{7x10 LED Display - Box test program, By Kane Partridge}
Program LED_DISPLAY_TEST;

Uses Dos,crt;

Var
   addr: word;
   Chr,Ch: Char;
   Done: Boolean;
   decimal,D0,D1,D2,D3,D4,D5,D6,D7: integer;
   stayon: longint;
Procedure BIN_TO_DEC;                           {Convert Binary to Decimal}
begin
     decimal:=0;
     if (D7=1) then decimal:=decimal+128;
     if (D6=1) then decimal:=decimal+64;
     if (D5=1) then decimal:=decimal+32;
     if (D4=1) then decimal:=decimal+16;
     if (D3=1) then decimal:=decimal+8;
     if (D2=1) then decimal:=decimal+4;
     if (D1=1) then decimal:=decimal+2;
     if (D0=1) then decimal:=decimal+1;
end;

Procedure CALIBRATE;
begin
     writeln('** Calibrate Display **');
     writeln('Press the right cursor key until the first column is lit');
     writeln('Then press enter to start test');
     D0:=1; D1:=1; D2:=1; D3:=1; D4:=1; D5:=1; D6:=1; D7:=0;
     BIN_TO_DEC; Port[addr]:=decimal;
     Done:=False;
     repeat                                     {Wait for user input}
           Chr:=ReadKey;
           case Chr of
                #0: begin                       {Function keys}
                    Chr:=ReadKey;
                    case Chr of
                         #77: begin             {Right Cursor}
                              Port[addr]:=0;
                              Port[addr]:=255;  {Move Column}
                    end;end;end;
           #13: Done:=True;                     {Enter}
     else
         Write(Ch);
     end;
     until Done;
end;

Begin {Main}
   clrscr;                                      {Clear Monitor}
   writeln('Enter parallel port address ($278, $378, $3BC)');
   readln(addr);                                {Address of parallel port}
   D7:=0; D6:=0; D5:=0; D4:=0; D3:=0; D2:=0; D1:=0; D0:=0;
   decimal:=0;                                  {Set all variables to zero}
   CALIBRATE;                                   {Run calibration}
   ch:=' ';
   writeln('** Running Display - Test Box **');
   writeln('The program will end within 4 to 6 seconds');
   Done:=False;
   stayon:=0;
   repeat                                           {Draw Box}
      stayon:=stayon+1;
      {COLUMN 1}
      D0:=0; D1:=0; D2:=0; D3:=0; D4:=0; D5:=0; D6:=0; D7:=1;
      BIN_TO_DEC; Port[addr]:=decimal; Port[addr]:=0;
      {COLUMN 2}
      D0:=0; D1:=0; D2:=0; D3:=0; D4:=0; D5:=0; D6:=0; D7:=1;
      BIN_TO_DEC; Port[addr]:=decimal; Port[addr]:=0;
      {COLUMN 3}
      D0:=0; D1:=1; D2:=1; D3:=1; D4:=1; D5:=1; D6:=0; D7:=1;
      BIN_TO_DEC; Port[addr]:=decimal; Port[addr]:=0;
      {COLUMN 4}
      D0:=0; D1:=1; D2:=0; D3:=0; D4:=0; D5:=1; D6:=0; D7:=1;
      BIN_TO_DEC; Port[addr]:=decimal; Port[addr]:=0;
      {COLUMN 5}
      D0:=0; D1:=1; D2:=0; D3:=0; D4:=0; D5:=1; D6:=0; D7:=1;
      BIN_TO_DEC; Port[addr]:=decimal; Port[addr]:=0;
      {COLUMN 6}
      D0:=0; D1:=1; D2:=0; D3:=0; D4:=0; D5:=1; D6:=0; D7:=1;
      BIN_TO_DEC; Port[addr]:=decimal; Port[addr]:=0;
      {COLUMN 7}
      D0:=0; D1:=1; D2:=0; D3:=0; D4:=0; D5:=1; D6:=0; D7:=1;
      BIN_TO_DEC; Port[addr]:=decimal; Port[addr]:=0;
      {COLUMN 8}
      D0:=0; D1:=1; D2:=1; D3:=1; D4:=1; D5:=1; D6:=0; D7:=1;
      BIN_TO_DEC; Port[addr]:=decimal; Port[addr]:=0;
      {COLUMN 9}
      D0:=0; D1:=0; D2:=0; D3:=0; D4:=0; D5:=0; D6:=0; D7:=1;
      BIN_TO_DEC; Port[addr]:=decimal; Port[addr]:=0;
      {COLUMN 10}
      D0:=0; D1:=0; D2:=0; D3:=0; D4:=0; D5:=0; D6:=0; D7:=1;
      BIN_TO_DEC; Port[addr]:=decimal; Port[addr]:=0;
      if stayon=100000 then begin Done:=True; end;
      until Done;
      writeln('This program was writen by Kane Partridge');
end.
