



	Title  "Calculated Auto Advance "
	;
	list p=16f84,c=140    ; processor type
	;
	;       10 05 96      Version 3.0      A. Nixon
	;
	;       2 STAGE ADVANCE CURVE
	;
	;       Modified for negative advance values.
	;
	; Ignition advance values are entered with a key board and
	; displayed. An advance map is calculated and major variables
	; are stored in eeprom to be used in the ignition routines.
	; A password is incorporated to gain entry into the system. This
	; comes from a two digit value entered by the user.
	; If no password is entered, then no password is needed and
	; the system automatically enters program mode on power up if
	; there is no valid system data. If there is data and no password
	; then the system powers up in the ignition mode.
	;
	;       *****************************************
	;       MODIFICATION LOG
	;
	;       24 07 96 - password '0' error fixed
	;       25 08 96 - small delay added to keyscan routine
	;       14 01 98 - modified for negative advance
	;       18 01 98 - now can't change levels with engine running
	;                  unless AA is present
	;	16 02 99 - PIC must be 16F84 now due to RAM usage
	;		 - data sets modified so that each can be set
	;		   pos or neg adv individually
	;
	;
	;       *****************************************
	;
	;       INTERNAL EEPROM DATA ADDRESSES
	;
	; following ignition data set is for level 0
	;
	;       values set      00h             AA = set
	;       mnrpmh          01h
	;       mnrpml          02h
	;       mdrpmh          03h
	;       mdrpml          04h
	;       advmin          05h
	;       revlimh         06h
	;       revliml         07h
	;       advmax          08h
	;       dwell           09h
	;       vacadv          0ah
	;
	;       loops ang @ rev limit   0bh
	;       loops ang @ user stg2   0ch
	;       loops ang @ user stg1   0dh
	;       loops at rev limit h    0eh
	;       loops at rev limit l    0fh
	;       loops at stg2rpm h      10h
	;       loops at stg2rpm l      11h
	;       loops at stg3rpm h      12h
	;       loops at stg3rpm l      13h
	;       loop count stg1         14h
	;       step count stg1         15h
	;       loop count stg2         16h
	;       step count stg2         17h
	;       loop count stg3         18h
	;       step count stg3         19h
	;       vac step value H        1ah
	;       vac step value L        1bh
	;       dwell step value H      1ch 
	;       dwell step value L      1dh
	;
	;
	; following ignition data set is for level 1
	;       
	;       values set      1eh             AA = set
	;       mnrpmh          1fh
	;       mnrpml          20h
	;       mdrpmh          21h
	;       mdrpml          22h
	;       advmin          23h
	;       revlimh         24h
	;       revliml         25h
	;       advmax          26h
	;       dwell           27h
	;       vacadv          28h
	;
	;       loops ang @ rev limit   29h
	;       loops ang @ user stg2   2ah
	;       loops ang @ user stg1   2bh
	;       loops at rev limit h    2ch
	;       loops at rev limit l    2dh
	;       loops at stg2rpm h      2eh
	;       loops at stg2rpm l      2fh
	;       loops at stg3rpm h      30h
	;       loops at stg3rpm l      31h
	;       loop count stg1         32h
	;       step count stg1         33h
	;       loop count stg2         34h
	;       step count stg2         35h
	;       loop count stg3         36h
	;       step count stg3         37h
	;       vac step value H        38h
	;       vac step value L        39h
	;       dwell step value H      3ah 
	;       dwell step value L      3bh
	;
	;
	;       cylinders               3ch     common to both sets
	;       pin                     3dh     common to both sets
	;       negative advance        3eh     common to both sets
	;	-  lo nib for level 1, hi nib for level 2  -
	;       level                   3fh     common to both sets
	;       
cyleep  equ 3ch
pinnum  equ 3dh
negadv  equ 3eh
eeplev  equ 3fh
	;
	;       ******************************************
	;
	;       ** CHIP INTERNAL EQUATES LIST **
	;
indirect equ 0h
rtcc equ 1h
pcl equ 2h
status equ 3h
fsr equ 4h
porta equ 5h
portb equ 6h
opton equ 81h
carry equ 0h
z equ 2h
rp0 equ 5h
eedata equ 8h
eeadr equ 9h
pclath equ 0ah
intcon equ 0bh
rtif equ 2h
eecon1 equ 88h
eecon2 equ 89h
	;
	;   ** I/O ASSIGNMENTS **
	;
so equ 0h       ; porta,0
clk equ 1h      ; porta,1
rotor equ 2h    ; porta,2      
coil equ 3h     ; porta,3
vacad equ 4h    ; porta,4      porta,4 tied low/high until used
;
col1 equ 0h     ; portb,0
col2 equ 1h     ; portb,1
col3 equ 2h     ; portb,2
row1 equ 3h     ; portb,3
row2 equ 4h     ; portb,4
row3 equ 5h     ; portb,5
row4 equ 6h     ; portb,6
led equ 7h      ; portb,7
	;
keysrv equ 0h   ; flag1
cctrl equ 1h    ; flag1
revl equ 2h     ; flag1
read equ 3h     ; flag1
write equ 4h    ; flag1
negset equ 5h   ; flag1
rotr equ 6h     ; flag1
run equ 7h      ; flag1
	;
Stg3 equ 0h     ; flag2
dwret equ 1h    ; flag2
count equ 2h    ; flag2
ramset equ 3h   ; flag2
Stg1 equ 3h     ; * flag 2
Stg4 equ 4h     ; flag2
nibl equ 5h     ; flag2
Stg2 equ 5h     ; * flag2
eepset equ 6h   ; flag2
pass  equ 7h    ; flag2
	; 
	;
	;       *******************************************
	;
	;       ** REGISTER LIST **
	;
mnrpmh equ 0ch  ; minimum entered rpm hi                (mnrpmh)
DcntH equ 0ch   ; * dwell count H
mnrpml equ 0dh  ; minimum entered rpm lo                (mnrpml)
DcntL equ 0dh   ; * dwell count L
rpmhi equ 0eh   ; distributor RPM counter register high  (mdrpmh)
mdrpmh equ 0eh  ; * mid rpm hi
rpmlo equ 0fh   ; distributer RPM counter register low   (mdrpml)
mdrpml equ 0fh  ; * mid rpm lo
advmin equ 10h  ; advance min                           (advmin)
VcntH equ 10h   ; * vac advance count H
mxrpmh equ 11h  ; maximum entered rpm hi  - at rev limit              (mxrpmh)
stpadH equ 11h  ; * stage (x) advance step value H      
mxrpml equ 12h  ; maximum entered rpm lo  - at rev limit (mxrpml)
fdwell equ 12h  ; * dwell countdown reg 
advmax equ 13h  ; advance max - at rev limit                           (advmax)
stepCH equ 13h  ; * retard loop value
dwllen equ 14h  ; dwell entered                          (dwell)
stgctL equ 14h  ; * stage (x) advance final value L
dwell equ 15h   ; dwell time counter                     (vacadv)

cyls equ 16h    ; number of cylinders entered    com     (cyls)
VcntL equ 16h   ; * vac advance count L
retval equ 17h  ; calculated ign retard value    com     (pin)
lvtimL equ 17h  ; * level key change timer L
lvtimH equ 18h  ; level key change timer H
dindex equ 19h  ; index to display data
rvlimH equ 19h  ; * rev limit H
flag2 equ 1ah   ; flag 2 register
row equ 1bh     ; keyboard row being scanned
s4stpH equ 1bh  ; * stage 4 step value H
VAstpH equ 1ch  ; vac adv step reg H
RDtimH equ 1dh  ; retard / dwell timer H
coila equ 1eh   ; time coil is left on byte 1
coilb equ 1fh   ; byte 2
bcdcnt equ 20h  ; bcd 2 byte calc reg
stpadL equ 20h  ; * stage (x) advance step value L
deboun equ 21h  ; points debounce period - (if points fitted)
numalo equ 22h  ; math reg a lo
rv300H equ 22h  ; * 300 RPM loop value H
numahi equ 23h  ; math reg a hi
stgctH equ 23h  ; * stage (x) advance final value H 
numblo equ 24h  ; math reg b lo
VAstpL equ 24h  ; * vac adv step counter L
numbhi equ 25h  ; math reg b hi
vloops equ 25h  ; * vac adv final loop value
rsltal equ 26h  ; math result reg a lo
dloops equ 26h  ; * final dwell loop count
rsltah equ 27h  ; math result reg a hi
DstpL equ 27h   ; * dwell step value L
rsltbl equ 28h  ; math result reg b lo
RDtimL equ 28h  ; * retard / dwell timer L
rsltbh equ 29h  ; math result reg b hi
stepCL equ 29h  ; * retard step value
temp equ 2ah    ; temporary work register
DstpH equ 2ah   ; * dwell step value H
flag1 equ 2bh   ; flag register 1
rvlimL equ 2ch  ; rev limit loop value
col equ 2dh     ; keyboard column being scanned
strtcnt equ 2dh ; allow this many counts before sparking
keyres equ 2eh  ; keyboard routine result register
rv300L equ 2eh  ; * 300 RPM loop value L
level equ 2fh   ; eeprom data level register

tempN equ 30h	; 16F84 data space
negdat equ 31h  ; negative adv flag data
	;
	;       *******************************************
	;
;                       flag 1 register
;
;       bit  #  7  6  5  4  3  2  1  0
;
;               x  x  x  x  x  x  x  0          ; key not serviced
;               x  x  x  x  x  x  x  1          ; key serviced
;               x  x  x  x  x  x  0  x          ; key not debounced
;               x  x  x  x  x  x  1  x          ; key debounced
;               x  x  x  x  x  0  x  x          ; no rev limiting
;               x  x  x  x  x  1  x  x          ; rev limiting
;               x  x  x  x  0  x  x  x          ; ram read flag
;               x  x  x  x  1  x  x  x          ; 
;               x  x  x  0  x  x  x  x          ; ram write flag
;               x  x  x  1  x  x  x  x          ; 
;               x  x  0  x  x  x  x  x          ; enter keys from pwr up
;               x  x  1  x  x  x  x  x          ; enter keys from ignition
;               x  0  x  x  x  x  x  x          ; rotor low
;               x  1  x  x  x  x  x  x          ; rotor high
;               0  x  x  x  x  x  x  x          ; motor idle
;               1  x  x  x  x  x  x  x          ; motor running
;
;***************************************************************
;
;                       flag 2 register
;
;       bit  #  7  6  5  4  3  2  1  0
;
;               x  x  x  x  x  x  x  0          ; 
;               x  x  x  x  x  x  x  1          ; clear coil counters
;               x  x  x  x  x  x  0  x          ; dwell timing
;               x  x  x  x  x  x  1  x          ; retard timing
;               x  x  x  x  x  0  x  x          ; 
;               x  x  x  x  x  1  x  x          ; do retard count
;               x  x  x  x  0  x  x  x          ; no ram data
;               x  x  x  x  1  x  x  x          ; ram data manually entered
;               x  x  x  0  x  x  x  x          ; 
;               x  x  x  1  x  x  x  x          ; do gnral timing
;               x  x  0  x  x  x  x  x          ; read high nibble ram
;               x  x  1  x  x  x  x  x          ; read low nibble ram
;               x  0  x  x  x  x  x  x          ; no eeprom aa
;               x  1  x  x  x  x  x  x          ; aa is in eeprom
;               0  x  x  x  x  x  x  x          ; 
;               1  x  x  x  x  x  x  x          ; password enabled
;
;***************************************************************
;
	org 0h  ; startup vector = 0000
	;
	;
	;
	;       100uS loop time
	;       8MHz clock = 2MHz instruction cycle
	;       cycle time = 1/2MHz  =  500nS
	;       100uS/500nS  =  200
	;       prescaler set to divide by 4
	;       preset rtcc = 206, when = 0  =  100uS
	;
;/        goto igntok
	movlw b'00010100'    
	bsf status,rp0  ; ram page 1
	movwf porta      ; 013 outputs 24 inputs
	movlw b'00000111'
	movwf portb      ; 012 inputs 34567 outputs
	bcf status,rp0  ; ram page 0
;/        goto igntok
	clrf porta
	clrf portb
	call clearR
	movlw .11
	call display    ; clear display
	call lpstup     ; setup keyboard routines loop timing
	;
	; ********************************
	;
	call getlev     ; get eeprom level from eeprom -> W
	btfsc status,z  ; level 0 is ok
	goto eeldun
	;
	xorlw 1eh       ; on initial use level could have any number in it
	btfsc status,z
	goto eeldun
	;
	clrf level       ; if not = 0 or 1e then = 0
	decf eeadr
	clrw
	call eeplwA     ; store new result
	;
eeldun  call chekAA      ; set eepset flag if aa present
	btfsc flag2,eepset
	goto aaset
	;
passin  bsf flag2,pass   ; no AA, so flag password enabled and goto
	goto disp        ; keyboard, because no valid data in eeprom yet
	;
aaset   movlw pinnum     ; if password = 0 then set password enabled
	call ereadA      ; and do ignition
	movwf retval
	btfss status,z
	goto keyloop     ; do password check 
	;
	;       **********************************
	;
igntok  
;        movlw 9h       ;/
;        movwf mnrpmh    ;/
;        clrf mnrpml
;        movlw 26h       ;/
;        movwf mdrpmh    ;/
;        clrf mdrpml
;        movlw 30h       ;/
;        movwf advmin    ;/
;        movlw 50h       ;/
;        movwf mxrpmh    ;/
;        clrf mxrpml
;        movlw 10h       ;/
;        movwf advmax    ;/
;        movlw 20h       ;/
;        movwf dwllen    ;/
;        movlw 00h       ;/
;        movwf dwell     ;/
;        movlw .6        ;/
;        movwf cyls      ;/
;        clrf level      ;/
;        clrf flag1      ;/
;        goto testrm     ;/
;        ;
	;       ****************************************
	; SET IGNITION VALUES FROM EEPROM
	;
testig  call levnum     ; set display for data level chosen
	call clearR     ; clear engine ram
	;
	; DIST LOOPS AT 300 RPM / CYLS = STAGE 4 START LOOPS
	;
	movlw cyleep
	call ereadA
	movwf cyls
	call DL300      ; -> numbhi/lo
	;
	movf numbhi,w
	movwf rv300H
	movf numblo,w
	movwf rv300L
	;
	movlw .4        ; 4 points openings before allowing spark
	movwf strtcnt
	bsf porta,coil  ; turn coil on
	;
	swapf cyls,w    ; calc stage 4 step value 1000h X cyls
	movwf s4stpH
	;
	movlw negadv	; get negadv flag data from eeprom
	call ereadA
	movwf negdat
	;
	movlw b'11000000'     ; set loop ignition timing
	call lpstupa
	bcf flag1,rotr  ; flag rotor is low
	btfsc porta,rotor  ; is rotor high or low
	bsf flag1,rotr  ; flag rotor is high
	bsf portb,5     ; enable keys 7,8,9
	goto newdat
	;
	; RE ENTRY FOR ALTERNATE LEVEL SELECT FROM ENGINE RUN
	;
stnwlv  clrw
	movf level      ; test other level for AA before swapping
	btfsc status,z
	movlw 1eh
	call ereadA
	xorlw 0xaa 
	btfss status,z
	goto stdebn     ; no AA
	call levalt     ; called to alternate data level - engine running
	;
newdat  movlw 1ah
	addwf level,w
	call ereadA
	movwf VAstpH    ; vacuum step value H
	call eread
	movwf VAstpL    ; vacuum step value L
	;
	call eread
	movwf DstpH     ; dwell step value  H
	call eread
	movwf DstpL     ; dwell step value  L
	goto stdebn
	;
	; alternate data level
	;
levalt  call getlev     ; get eeprom level from eeprom -> W
	btfss status,z  ; if eeprom level = 0 then = 1e
	goto st00
	;
	movlw 1eh       ; level was 0, make it 1eh
	goto ptine
	;
st00    clrw            ; level was 1eh, make it 0
ptine   decf eeadr
	call eeplwA     ; store new result
	call getlev     ; get eeprom level from eeprom -> W
	call levnum     ; update display
	call chekAA     ; set eepset flag if aa present
	return
	;
	; GET EEPROM DATA LEVEL -> W
	;
getlev  movlw eeplev    ; determine which eeprom data level to do
	call ereadA     ; from data in eeprom
	movwf level     ; update new level
	return
	;
	; AA CHECK
	; W holds current level
	;
chekAA  movf level,w
	bcf flag2,eepset  ; preclear
	call ereadA       ; check eeprom for presence of AAh
	xorlw 0xaa        ; according to selected level
	btfsc status,z
	bsf flag2,eepset  ; flag aa is in eeprom
	return          
	;
	;   ******************
	;
seg7cv  addwf pcl
	retlw b'00000011'       ; 0 for read routine '0' data
	retlw b'10011111'       ; 1
	retlw b'00100101'       ; 2
	retlw b'00001101'       ; 3
	retlw b'10011001'       ; 4
	retlw b'01001001'       ; 5
	retlw b'01000001'       ; 6
	retlw b'00011111'       ; 7
	retlw b'00000001'       ; 8
	retlw b'00001001'       ; 9
	retlw b'00110101'       ; ? Data error display
	retlw b'11111111'       ; clear display
	retlw b'11111101'       ; - display
	;
	;       *******************************************************
	;
rdrout  movf keyres,w
	xorlw .10
	btfsc status,z
	goto nxtdig     ; * pressed, display next data digit
	;
	movf keyres,w
	xorlw .12
	btfss status,z
	goto keyloop    ; other keys have no use
	;
	bcf flag1,read  ; # pressed, clear ram read flag
	goto disp       ; display '-'
	;
	;       ****************************************
	;
levnum  movlw .1        ; set display for data level chosen
	movf level      
	btfss status,z
	movlw .2
	call display
	return
	;
	;       ****************************************
	;
kyrout  decf keyres,w   ; key function routines
	addwf pcl
	goto keyloop    ; 1 no use - need bytes - clreep     ; 1 clear eeprom
	goto keyloop    ; 2 no use
	goto rdram      ; 3 read data from ram
	goto rdeep      ; 4 read data from eeprom
	goto wrtset     ; 5 write data to ram
	goto disp       ; 6 display '-'
	call levalt     ; 7 alternate level
	call levnum     ; 8 display level number
	goto keyloop    ; 9 no use  - but goes to keyloop after prev instr
	goto settab     ; * create eeprom variables
	goto keyloop    ; 0 no use
	btfss flag2,eepset  ; # if AA set, do ignition routines
	goto errset     ; error, eeprom not set
	goto keyrel     ; wait until key released
	;
	;       *******************************************
	;
nxtdig  btfsc flag2,nibl
	goto rdlwnb     ; read low nibble
	;
	btfss dindex,7  ; if = 1 then display '-'
	goto nibdis     ; instead of data from ram
	;
	bcf dindex,7
	goto disp
	;
nibdis  bsf flag2,nibl  ; set to read low nibble next
	swapf indirect,w ; fsr preset to 0ch on initial routine entry
	andlw b'00001111'
stdisp  call display    ; display data
	goto keyloop
	;
rdlwnb  bcf flag2,nibl  ; set to read high nibble next
	movf indirect,w
	andlw b'00001111'
	call display    ; display data
	incf fsr
	;
	movf fsr,w      ; if fsr points to low byte of mnrpm
	xorlw 0dh    
	btfsc status,z
	goto no7set
	;
	movf fsr,w      ; OR if fsr points to low byte of mdrpm
	xorlw 0fh    
	btfsc status,z
	goto no7set
	;
	movf fsr,w      ; OR if fsr points to low byte of mxrpm
	xorlw 12h       ; then dont set bit 7 of dindex
	btfss status,z
	bsf dindex,7    ; set to display '-' on next high nibble entry        
	;
no7set  movf fsr,w      ; if last data then wrap around to start
	xorlw 18h
	btfss status,z
	goto keyloop
	;
	movlw 0ch       ; ram start address
	movwf fsr
	bsf dindex,7
	goto keyloop
	;
	;       *******************************************************
	;
eephl   movf numbhi,w   ; store numbhi/lo to eeprom
	movwf eedata
	call eeprom
	;
eeplw   movf numblo,w   ; store numblo only to eeprom
eeplwA  movwf eedata
	call eeprom
	return
	;
	; CONVERT TO DIST LOOPS AND DIVIDE BY CYLS
	;
dstcyl  movwf fsr
	bcf status,carry
	rlf indirect,w
	movwf numblo
	decf fsr
	rlf indirect,w
	movwf numbhi
intlps  clrf numahi
	movf cyls,w
	call divizn
	btfss flag1,rotr ; if = 1 then no eeprom store
	call eephl      ; store to eeprom
	return
	;
	;       ****************************************
	;
bcdbin  movwf temp      ; convert bcd to binary
	swapf temp,w
	andlw 0fh       ; keep 10's value of bcd number
	movwf rsltbh
	bcf status,carry
	rlf rsltbh,w    ; X 2
	movwf rsltbl
	movwf rsltbh
	rlf rsltbh      ; X 4
	rlf rsltbh,w    ; X 8
	addwf rsltbl    ; X 10
delay   movf temp,w        
	andlw 0fh       ; mask 10's value of bcd number
	addwf rsltbl,w  ; add units to X 10 result
	return
	;
	;       *******************************************
	;
numkey  movf keyres,w   ; display key number
	call display
	;
	btfsc flag2,nibl
	goto lownib     ; data for lower nibble
	;
	bsf flag2,nibl  ; flag ready for low nibble
	swapf keyres,w  ; fsr set = 0ch on initial routine entry
	movwf indirect
	goto keyloop
	;
lownib  bcf flag2,nibl  ; flag ready for next high nibble
	movf keyres,w
	iorwf indirect
	incf fsr        ; set for next byte
	movf fsr,w      ; check for data finish
	xorlw 18h
	btfss status,z
	goto keyloop 
	;
	bsf flag2,ramset  ; set ram is entered
	bcf flag1,write   ; exit write routine
	goto disp
	;
	;       *****************************************
	;
msetup  movlw .16       ; math mult div setup
	movwf temp      ; 16 shifts
	movf numbhi,w   ; move b number to result high word
	movwf rsltbh
	movf numblo,w
	movwf rsltbl
	clrf numbhi
	clrf numblo
	return
	;
	;       *******************************************
	;
;       numb X numa -> numb,hi rslta,lo    16 X 16 -> 32 bits
multy   movwf numalo
	call msetup
	;
multlp  rrf rsltbh      ; rotate result right
	rrf rsltbl
	btfss status,carry
	goto noadd
	;
	movf numalo,w   ; addition (numb + numa -> numb)
	addwf numblo
	btfsc status,carry
	incf numbhi
	movf numahi,w
	addwf numbhi    ; add msb
	;
noadd   rrf numbhi
	rrf numblo
	rrf rsltah
	rrf rsltal
	decfsz temp
	goto multlp
	;
	return
	;
	;       *******************************************
	;
	;       numb / numa -> numb (16b), remainder in rslta
	;       numb must be > numa for routine to work
divizn  movwf numalo
diviznA call msetup
	;
	clrf rsltah
	clrf rsltal
	;
dvloop  bcf status,carry
	rlf rsltbl
	rlf rsltbh
	rlf rsltal
	rlf rsltah
	movf numahi,w
	subwf rsltah,w  ; check if numa > result a
	btfss status,z
	goto nochk
	;
	movf numalo,w
	subwf rsltal,w  ; if msb is = then check lsb
nochk   btfss status,carry      ; carry set if reslta > numa
	goto nogo
	;
	movf numalo,w   ; rslta - numa -> rslta
	subwf rsltal
	btfss status,carry
	decf rsltah
	movf numahi,w
	subwf rsltah
	bsf status,carry        ; shift 1 into result
nogo    rlf numblo
	rlf numbhi
	decfsz temp
	goto dvloop
	;
	return
	;
	;       ****************************************
	;
display call seg7cv
	movwf coilb
	movlw .8        ; output display data to ser/par chip
	movwf coila     ; 8 bits to send
	;
dploop  bcf porta,so    ; pre clear serial out bit
	rrf coilb
	btfsc status,carry
	bsf porta,so
	call delay
	bsf porta,clk
	call delay
	bcf porta,clk
	decfsz coila
	goto dploop
	;
	bcf porta,so
	return
	;
	;       *******************************************
	;
ereadA  movwf eeadr     ; in eeprom
eread   bsf status,rp0  ; ram page 1
	bsf 88h,0
	bcf status,rp0  ; ram page 0
	incf eeadr
	movf eedata,w   ; read eeprom value
	return
	;
	;       ****************************************
	;
eepram  movlw .1        ; put eeprom values into ram
	addwf level,w
	movwf eeadr     ; password is not included
	movlw 0ch
	movwf fsr
strdat  call eread
	;
	movwf indirect
	incf fsr
	movlw 16h
	xorwf fsr,w
	btfss status,z
	goto strdat
	;
	movlw cyleep    ; put cyls in ram
	call ereadA
	movwf cyls    
	;
	call eread     ; put password number in ram
	movwf retval    
	return
	;
	;       *******************************************************
	;
eeprom  bsf status,rp0  ; ram page 1
	bcf eecon1,4    ; clear write completion bit
	bsf eecon1,2    ; set WREN bit = 1
	movlw 55h       ; eeprom write
	movwf eecon2
	movlw 0xaa
	movwf eecon2
	bsf eecon1,1    ; set WR bit to initiate write
	;
wtloop  btfss eecon1,4  ; wait until write is finished (~10mS)
	goto wtloop
	;
	bcf eecon1,2    ; clear WREN bit
	bcf status,rp0  ; ram page 0
	incf eeadr      ; set for next eeprom address
	return
	;
	;       *******************************************************
	;
wrtset  bsf flag1,write ; set write flag      key #5
	bcf flag2,ramset
	movlw 0ch       ; point to 1st digit of mnrpm
	movwf fsr       ; ram start address
	bcf flag2,nibl  ; flag upper nibble to do
	clrw
	goto stdisp
	;
	;       *******************************************************
	;
rdram   btfss flag2,ramset  ; no read if no ram data entered  key #3
	goto errset
	;
inrdrm  clrf dindex     ; clear data index
	bsf flag1,read  ; set read flag
	movlw 0ch       ; point to 1st digit of mnrpm
	movwf fsr       ; ram start address
	bcf flag2,nibl  ; flag upper nibble to do
	goto nibdis     ; display 1st digit of mnrpm
	;
	; ***********************************
	; KEYBOARD LOOP TIMING SETUP
	;
lpstup  movlw b'11000111'
lpstupa bsf status,rp0  ; ram page 1
	movwf opton           ; prescaler assigned to RTCC, / 256
	bcf status,rp0  ;       Set 33mS loop time for keyscanning routines
	return
	;
	; KEYBOARD ROUTINES
	;
disp    movlw .12       ; display '-'
	call display
	;
keyloop movf rtcc,w
	btfss status,z
	goto keyloop
	;
; SCAN KEYBOARD
        ;
        movlw .1        ; initialise regs for keyscan
        movwf keyres    ; final keypress result
        movlw b'00001000'
        movwf row       ; bit corresponding to row being scanned
        ;
scnrow  movf row,w      ; activate keyboard row
        movwf portb
        call delay      ; delay for a few instructions
        movf portb,w    ; scan column
        andlw b'00000111'  ; mask off row data
        btfss status,z
        goto coldcy     ; column is active, decypher which
        ;
        bcf status,carry
        rlf row         ; set for next row
        movlw .3
        addwf keyres    ; add for next 3 buttons
        btfss row,7     ; test for last row to scan
        goto scnrow
        ;
        clrf portb
        bcf flag1,keysrv     ; clear key serviced flag
        goto keyloop
        ;
coldcy  movwf col       ; store column result
	bcf status,carry  ; decypher which row
        rrf col,w
	addwf keyres
        ;
debset  btfsc flag1,keysrv   ; has key been serviced already
        goto keyloop    ; yes
        ;
	; CHECK KEYPRESS FOR '0' KEY AND CONVERT VALUE TO 0
	;
	movf keyres,w
	xorlw .11
	btfsc status,z
	clrf keyres
	;
        ; **Flag1 used for password entry and cleared when finished**	
	;
	bsf flag1,keysrv     ; flag key serviced
	btfsc flag2,pass
	goto kyprck     ; password enabled, do normal keyboard routines
	;
	btfsc flag1,7   ; 1st number = 0
	goto numtwo
	;
	swapf retval,w  ; compare 1st number with password number
	call tstpin	; does not return if error
	goto keyloop
	;
numtwo  movf retval,w   ; test lower nibble against 2nd number
	call tstpin	; does not return if error
	;
	bsf flag2,pass  ; flag password enabled
	;
	; WAIT UNTIL KEY IS RELEASED
	;
keyrel  movf portb,w       
	andlw b'00000111'
	btfss status,z
	goto keyrel
	goto igntok     ; password accepted and AA set, do ignition
	;
	; TEST PIN NUMBER FOR ERROR
	;
tstpin  andlw b'00001111'
	xorwf keyres,w
	btfss status,z
passer	goto passer
	bsf flag1,7     ; flag 2nd number
	return
	;
	;       ******************************************
	;
kyprck  btfsc flag1,read
	goto rdrout     ; read flag set, do read routines
	;
	btfss flag1,write
	goto kyrout     ; determine which function to do and set thier flags
	;
	movf keyres,w   ; read data from keypad to ram
	xorlw .10
	btfsc status,z
	goto keyloop    ; * pressed, no use
	;
	movf keyres,w
	xorlw .12
	btfss status,z
	goto numkey     ; is a number
	;
	bcf flag1,write ; # pressed, exit write routine
	goto disp
	;
	;       ****************************************
	;
errset  movlw .10       ; display error  - no eeprom data
	goto stdisp
	;
	;       *******************************************************
	;
rdeep   btfss flag2,eepset   ; AA in eeprom if = 1   key #4
	goto errset
	;
eeset   call eepram     ; get data from eeprom
	bsf flag2,ramset
	goto inrdrm     ; display 1st data
	;
	;       *******************************************************
	;
settab  btfss flag2,ramset
	goto errset     ; no ram data entered
	;
testrm  movlw cyleep    ; cyls, pin -> eeprom
	movwf eeadr     
	movf cyls,w
	call eeplwA
	movf retval,w 
	call eeplwA
;
; negative advance uses upper nibble for level 2 and lower nibble for level 1
; for positive or negative advance flag storage for upper advance stage
;
	movlw negadv
	call ereadA
	movwf tempN

	movlw b'11110000'  ; pre set for level 1
	movf level
	btfss status,z
	movlw b'00001111'  ; set for level 2
	andwf tempN	; clear negative adv flags for current level
	;
	movlw 0bh       ; set ram data start address - 1
	movwf fsr
	movf level,w
	movwf eeadr
	movlw 0xaa      ; set values entered for correct level
	goto inentr
	;
eenter  movf indirect,w ; store entered variables into eeprom
inentr  call eeplwA
	incf fsr
	movlw 16h
	xorwf fsr,w
	btfss status,z
	goto eenter
	;
	; *************
	; ADVANCE CALCS
	; *************
	;
	; LOOPS RETARD AT REV LIMT AT MAX ENTERED ADVANCE
	;
seteep  movf advmax,w   ; subtract entered max angle from 45'
	call angle45    ; -> rvlimL
	;
	movlw mxrpmh    ; convert max rpm value to crank loops
	call angloop    ; then to loops at entered adv -> eeprom 0bh
	;
	; LOOPS RETARD AT MID RPM AT MID ENTERED ANGLE
	; 
	movf advmin,w   ; subtract entered mid angle from 45'
	call angle45    ; -> rvlimL
	;
	movlw mdrpmh    
	call angloop    ; convert mid rpm as above -> eeprom 0ch       
	;
	; LOOPS RETARD AT MIN RPM AT 45' ANGLE
	;
	movlw .45
	movwf rvlimL
	movlw mnrpmh
	call angloop    ; convert mid rpm as above -> eeprom 0dh
	;
	; LOOPS RETARD AT 300 RPM AT 45' ANGLE = 250 (fah) static
	;        
	; -------------------------------------------------
	;
	; DIST LOOPS AT MAXRPM / CYLS -> EEPROM  0eh  0fh
	;
	movlw mxrpml
	call dstcyl     ; -> eeprom
	;
	; DIST LOOPS AT MIDRPM / CYLS -> EEPROM  10h  11h
	;
	movlw mdrpml
	call dstcyl     ; -> eeprom 
	;
	; DIST LOOPS AT MINRPM / CYLS -> EEPROM  12h  13h
	;
	movlw mnrpml
	call dstcyl
	;
	; DIST LOOPS AT 300 RPM / CYLS (no store)
	;
	call DL300      ; -> numbhi/lo
	;
	movf numbhi,w   ; temp store value
	movwf coila
	movf numblo,w
	movwf coilb
	;
	; CALCULATE STAGE 1 STEP VALUES
	; maxrpm -> midrpm loop diff / angle diff
	;
	movlw 0bh       ; address for angle loops
	movwf temp
	movlw 14h       ; put step value to eeprom   14h  15h
	movwf mdrpmh
	movlw 0eh       ; address for dist loops
	call calstep
	;
	; CALCULATE STAGE 2 STEP VALUES
	; midrpm -> minrpm loop diff / angle diff
	;
	movlw 0ch       ; address for angle loops
	movwf temp
	movlw 16h       ; put step value to eeprom   16h  17h
	movwf mdrpmh
	movlw 10h       ; address for dist loops
	call calstep
	;
	; CALCULATE STAGE 3 STEP VALUES
	; minrpm -> 300 RPM loop diff / angle diff
	;
	movlw 12h       ; get mnrpm dist loops
	addwf level,w
	call ereadA     
	movwf mxrpmh    ; temp store
	call eread
	movwf mxrpml
	movlw 0dh       ; address for angle loops
	movwf temp
	movlw 18h       ; put step value to eeprom   18h  19h
	movwf mdrpmh
	movf coila,w    ; recall store 300RPM dist loops/cyls value
	movwf mnrpmh
	movf coilb,w
	call incal
	;
	; **************
	; VAC ADV CALCS
	; **************
	; vacadvXcyls / 720 = step value
	;
norvlm  movf dwell,w
	bsf flag1,run
	call tostep     ; convert to step value -> eeprom 1ah  1bh
	bcf flag1,run
	;
	; ***********
	; DWELL CALCS
	; ***********
	; dwellXcyls / 360 = step value
	;
	movf dwllen,w   ; already converted to binary
	call tostep     ; convert to step value -> eprom 1ch  1dh
	;
	movlw negadv
	movwf eeadr     
	movf tempN,w
	call eeplwA	; store negative adv result
	;
	; ************************
	; UPDATE KEY ROUTINE FLAGS
	; ************************
	;
	bsf flag2,eepset  ; flag eeprom data is valid
	call eepram       ; restore ram data from eeprom 
	goto disp
;        goto testig     ; test ignition            
	;
	; 300 DIST LOOPS / CYLS
	;
DL300   bsf flag1,rotr  ; if = 1 then no eeprom store
	movlw 0fh       ; fa0h dist loops at 300RPM
	movwf numbhi
	movlw 0xa0
	movwf numblo
	call intlps
	bcf flag1,rotr
	return
	;
	;       ******************
	; CONVERT DWELL/VACADV TO STEP VALUE
	;
tostep  call bcdbin     ; convert to binary
	movwf numblo
	clrf numbhi
	clrf numahi
	movf cyls,w
	call multy
	;
	movlw 0xff      ; if result > ff = ff
	movf rsltah
	btfsc status,z
	movf rsltal,w
	movwf numbhi    ; result into high byte for division
	clrf numblo
	;
	movlw .1        ; needs to be 2d0h for vac adv
	btfsc flag1,run ; needs to be 168h for dwell
	movlw .2
	movwf numahi
	movlw 68h
	btfsc flag1,run
	movlw 0xd0
	call divizn
	call eeplw      ; store step value H
	;
	; calculate remainder
	;
	movf rsltal,w
	movwf numblo
	movf rsltah,w
	movwf numbhi
	;
dodiv24 movlw numbhi    ; divide by 2 until numbhi = 0
	call tozero
	;
	movf numblo,w
	movwf numbhi
	clrf numblo
	call diviznA    ; divide and store remainder
	goto dobits
	;
	; CALCULATE STEP DATA
	; delta angle data / delta rpm loops data
	;
calstep addwf level,w   ; get rpm loops data
	call ereadA     
	movwf mxrpmh    ; temp store
	call eread
	movwf mxrpml
	call eread      
	movwf mnrpmh
	call eread
incal   movwf mnrpml
	;
	bcf flag1,run           ; clear negative flag
	comf mxrpml,w           ; negate then add
	movwf numalo
	comf mxrpmh,w
	movwf numahi
	incfsz numalo
	goto nocfin
	;
	incf numahi
nocfin  movf mnrpml,w
	addwf numalo
	btfsc status,carry
	incf numahi
	movf mnrpmh,w
	addwf numahi            ; loops data in numerator
	;
	movf temp,w
	xorlw 0dh               ; doing stg3 step calcs if = 0dh
	btfss status,z
	goto noddex
	;
	clrf numbhi             ; use fah - stg 1 angle loops
	movlw 0xfa
	movwf numblo
	movf temp,w
	addwf level,w
	call ereadA
	subwf numblo
	goto hlflop
	;
noddex  movf temp,w             ; get angle loops data
	addwf level,w           ; and subtract
	call ereadA
	movwf numbhi        
	call eread
	movwf numblo
	movf numbhi,w           ; mid to max adv is only negative answer
	subwf numblo            ; if result is negative - comf answer
	clrf numbhi             ; and flag negative
	;
	btfsc status,carry      
	goto hlflop
	;
	bsf flag1,run           ; flag negative - store flag in eeprom
	comf numblo             ; comf answer to calculate with pos number
	incf numblo             ; 
	;
	; NRATOR AND DENOM / 2 UNTIL = 1 BYTE ONLY
	;
hlflop  movlw numahi    ; divide by 2 until numahi = 0
	call tozero
	;
dn1byt  movf numblo,w
	movwf numbhi
	clrf numblo
	call diviznA
	movf numblo,w   ; temp save in case negative angle calc answer
	movwf row
	;
	; CALCULATE DIVISION REMAINDER
	;
	movf rsltal,w   ; remainderL into nratorH
	movwf numbhi
	clrf numblo
	call diviznA
	;
	; If adv result was negative, comf step value
	;
	btfss flag1,run
	goto setstep
	;
	movlw b'00001111'  ; level 1 is negative adv
	movf level
	btfss status,z
	movlw b'11110000'  ; level 2 is negative adv
	iorwf tempN	; flag level x adv is negative

	bcf flag1,run
	comf row        ; comf step value
	comf numblo
	incfsz numblo
	goto setstep
	incf row
	;
setstep movf mdrpmh,w   ; saved step H eeprom address
	addwf level,w
	movwf eeadr
	movf row,w
	call eeplwA     ; store step value H
	;
dobits  call eeplw      ; store step value L
	return
	;
	; SUBTRACT NUMBER FROM 45
	;
angle45 call bcdbin
	movwf temp
	movlw .45
	movwf rvlimL
	movf temp,w
	subwf rvlimL    ; subtract from 45 and temp store
	return
	;
	; CALC ANGLE LOOPS -> EEPROM
	;
angloop movwf fsr       ; first convert BCD RPM value to crank loops
	movf indirect,w
	call bcdbin     ; hi byte to binary
	movwf numblo
	clrf numbhi
	clrf numahi
	movlw 64h
	call multy      ; hi byte X 100
	;
	incf fsr
	movf indirect,w
	call bcdbin     ; high byte to binary
	addwf rsltal,w
	movwf numblo
	btfsc status,z
	incf rsltah     ; add to low byte
	movf rsltah,w
	movwf numbhi    ; convert to loops
	;
	clrf numahi
	movlw .10
	call divizn
	;
	movf numblo,w
	movwf numalo
	movf numbhi,w
	movwf numahi
	movlw 0xea
	movwf numbhi
	movlw 60h
	movwf numblo
	call diviznA
	movf numblo,w            ; for angle calcs
	movwf indirect
	decf fsr
	movf numbhi,w
	movwf indirect
	;
	bcf status,carry
	rrf indirect,w    ; / 2
	movwf numbhi
	incf fsr
	rrf indirect,w
	movwf numblo
	clrf numahi
	movf rvlimL,w
	call multy
	;
	movf rsltah,w   ; divide number by b4h
	movwf numbhi
	movf rsltal,w
	movwf numblo
	clrf numahi
	movlw 0xb4
	call divizn
	call eeplw      ; -> eeprom
	return
	;
	;       ******************************************************
	;
	;       IGNITION ROUTINES
	;
	;       ******************************************************
	;
init    btfsc intcon,rtif
	goto beginI
	;
	movf deboun
	btfss status,z
	goto init
	;
	btfss porta,rotor  ; is rotor high or low
	goto rotlow
	;
	btfsc flag1,rotr   ; test if rotor flagged high
	goto init          ; yes
	;
	bsf flag1,rotr  ; flag rotor is high
	bcf portb,led   ; set led off
stdebn  clrf coila      ; clear coil counters
	clrf coilb
	movlw .8
	movwf deboun
	goto init
	;
rotlow  btfss flag1,rotr   ; test if rotor flagged low
	goto init          ; yes
	;
	bcf flag1,rotr     ; flag low
	bsf flag1,run   ; flag running
	bsf portb,led   ; set led on
	;
	; START UP COUNTER TO ALLOW SPARK
	;
	movf strtcnt    ; dec startup count if <> 0
	btfsc status,z
	goto engdat
	;
	decf strtcnt
	goto clcnts     ; clear engine counters
	;
	; SET NEW RETARD, VAC ADV, DWELL
	;
engdat  movlw .10       ; if new dwell < 10 then = 10
	subwf dloops,w
	btfsc status,carry
	goto dwllok
	;
	movlw .10
	movwf dloops
	;
dwllok  movf dloops,w   ; store new dwell value until needed
	movwf dwell
	;
	; TEST REV LIMIT REACHED FLAG
	;
	btfsc flag2,Stg1    ; rev lim active if = 0
	goto nrvset
	;
	btfsc flag1,cctrl   ; if = 1 then no coil fire
	goto clcnts         ; no coil fire
	;
nrvset  btfsc porta,vacad   ; external vac adv switch set - active low
	goto rtdnew         ; no
	;
	movf vloops,w     ; yes, subtract vac adv from retard value
	subwf stgctL
	btfsc status,carry
	goto rtdnew
	;
	movlw .1        ; if < 0 = 0
	subwf stgctH    ; no retard to do
	btfss status,carry
	goto rdizro     
	;
	; SET FINAL ADVANCE VALUE
	;
rtdnew  movf stgctL,w
	movwf RDtimL
	incf stgctH,w   ; rdtimH + 1 for decrement routine
	movwf RDtimH
	;
	movlw .1
	xorwf RDtimH,w
	btfss status,z  ; test final retard value
	goto clcnts     ; if <> 0 then retard is active
	;
	movf RDtimL
	btfss status,z
	goto clcnts
	;
	clrf RDtimH
rdizro  bcf porta,coil  ; no retard, or vac adv, so turn off coil
	movf dwell,w    ; set dwell time
	movwf fdwell
	;
clcnts  call clear      ; clear dwell, retard, vacadv, and rpm etc
	;
	movlw b'11000110'
	andwf flag2        ; clear stage count flags
	movlw b'00000010'  ; alternate rev limit coil control bit
	xorwf flag1
	;
	; Set negative flag for stg1 adv if negative angle
	; Negadv flag data is stored in negdat
	;
	movlw b'00001111'  ; test neg adv for level 1
	movf level
	btfss status,z
	movlw b'11110000'  ; test neg adv for level 2
	andwf negdat,w
	btfss status,z
	bsf flag1,negset
	;
	; TEST FOR KEY 7
	;
	btfss lvtimH,2  ; wait for timer to count down before servicing
	goto stdebn     ; 4000h
	;
	clrf lvtimH
	btfsc portb,0   ; test if key 7 pressed
	goto stnwlv     ; alternate data level
	goto stdebn
	;
	; ROTOR HI/LO TEST - RESET LOOP TIMER
	;
beginI  movlw 0xa1      ; reset loop timer flag     
	movwf rtcc
	bcf intcon,rtif
	;
upcoil  incfsz coila    ; coil on counters + 1
	goto debchk     ; coil timers give 6.5 secs on time max
	;
	incfsz coilb
	goto debchk
	;
	bcf porta,coil  ; coil = off
	;
debchk  movf deboun,w   ; debounce - 1 if <> 0
	btfss status,z
	decf deboun     
	;
	; TIME DELAY BETWEEN LEVEL CHANGES
	;
	btfsc lvtimH,2
	goto tstrun     ; if > 3Fh then no increment
	;
	incfsz lvtimL   ; increment key level change delay count
	goto tstrun
	incf lvtimH
	;
tstrun  btfsc flag1,run ; test if running
	goto running    ; yes
	;
	btfss portb,2   ; if key 9 pressed, exit ignition
	goto init       ; no
	;
	bcf portb,led   ; turn led off if on
	bcf porta,coil  ; coil = off
	call clearR
	bsf flag2,eepset ; flag aa is in eeprom
	bsf flag1,keysrv     ; set key serviced flag
	call lpstup     ; setup keyboard loop timing
	goto passin     ; set pass word and goto keyboard
	;
	; UPDATE ENGINE TIMERS
	;
running movf RDtimL     ; dec retard count if <> 0
	btfss status,z
	goto dekRD
	;
	movf RDtimH
	btfsc status,z
	goto dwlchk
	;
dekRD   decf RDtimL
	movlw 0xff
	xorwf RDtimL,w
	btfss status,z
	goto dwlchk
	;
	decfsz RDtimH
	goto dwlchk
	;
	clrf RDtimL
	bcf porta,coil  ; retard timing finished, turn off coil
	movf dwell,w
	movwf fdwell
	goto moton
	;
dwlchk  movf fdwell     ; dec dwell count if <> 0
	btfsc status,z
	goto moton
	;
	decfsz fdwell
	goto moton
	;
	bsf porta,coil  ; dwell timing finished, turn coil on
	;
	;       Dwell, Vacadv and Retard counters work as follows:
	;       Each loop, 1 is added to a counter. When this counter
	;       = the dwell or retard reference value, then add 1 to the
	;       actual dwell or retard timer. This value will be used for
	;       the actual dwell and retard timing when needed
	;       Retard timing is started when then rpm is in the range
	;       specified when programmed by user.
	;
moton   incf rpmlo      ; new rpmhi/lo value
	btfsc status,z
	incf rpmhi
	;
	; UPDATE VAC ADVANCE COUNTER
	;
norlim  movf VAstpL,w
	addwf VcntL
	btfss status,carry
	goto lwadbe
	;
	incfsz VcntH
	goto lwadbe
	incfsz vloops
	goto lwadbe
	decf vloops     ; if > ff = ff
	;
lwadbe  movf VAstpH,w
	addwf VcntH
	btfss status,carry
	goto dlstep
	;
	incfsz vloops   ; vac advance value
	goto dlstep
	decf vloops     ; if > ff = ff
	;
	; UPDATE DWELL COUNTER
	;
dlstep  movf DstpL,w
	addwf DcntL
	btfss status,carry
	goto lwadbf
	;
	incfsz DcntH
	goto lwadbf
	incfsz dloops
	goto lwadbf
	decf dloops     ; if > ff = ff
	;
lwadbf  movf DstpH,w
	addwf DcntH
	btfss status,carry
	goto dlntsm
	;
	incfsz dloops             ; dwell advance value
	goto dlntsm
	decf dloops     ; if > ff = ff
	;
	; CHECK RPM VALUES FOR DIFFERENT STAGE COUNTS
	;
dlntsm  btfsc flag2,Stg4        ; 300 RPM -> 30 RPM
	goto dostg4     
	;
	btfsc flag2,Stg3        ; stg1 RPM -> 300 RPM
	goto dostg3     
	;
	btfsc flag2,Stg2        ; stg2 -> stg1 RPM
	goto dostg2
	;
	btfsc flag2,Stg1        ; rev limit -> stg2 RPM
	goto dostg1
	;
	movlw 0eh       ; test for stage 1 rpm reached
	call match      ; z clear if no match, z set if match
	btfss status,z
	goto init
	;
	bsf flag2,Stg1  ; flag stage 1 active
	movlw 14h
	call stpset     ; set step data for stage 1
	movlw 0bh
	goto inlpst     ; do stage loops
	;
	; STAGE 1 COUNT
	;
dostg1  call stpadd     ; increment stage 1 step counters
	movlw 10h       ; test for stage 2 rpm reached
	call match
	btfss status,z
	goto init
	;
	bsf flag2,Stg2  ; flag stage 2 active
	bcf flag1,negset  ; clear negative angle flag
	movlw 16h
	call stpset     ; set step data for stage 2
	movlw 0ch
	goto inlpst     ; do stage loops
	;
	; STAGE 2 COUNT
	;
dostg2  call stpadd     ; increment stage 2 step counters
	movlw 12h       ; test for stage 3 rpm reached
	call match
	btfss status,z
	goto init
	;
	bsf flag2,Stg3  ; flag stage 3 active
	movlw 18h
	call stpset     ; set step data for stage 3
	movlw 0dh
inlpst  call lpsset     ; set stage 1,2, or 3 initial advance loops 
	goto init
	;
	; STAGE 3 COUNT
	;
dostg3  call stpadd     ; increment stage 3 step counters
	;
	movf rpmhi,w    ; test for stage 4 start
	xorwf rv300H,w
	btfss status,z
	goto init
	movf rpmlo,w
	xorwf rv300L,w
	btfss status,z
	goto init
	;
	bsf flag2,Stg4  ; flag stage 4 active
	movf s4stpH,w
	movwf stepCH
	clrf stepCL 
	movlw 0xfa
	call lpsetA     ; set initial advance loops
	goto init
	;
	; STAGE 4 COUNT
	;
dostg4  call stpadd     ; increment stage 4 step counters
	goto init
	;
	; DETERMINE IF RPM LOOP DATA MATCHES START OF STAGE (x) COUNT
	; z clear if no match, z set if match
	;
match   addwf level,w
	call ereadA
	xorwf rpmhi,w
	btfss status,z
	return          ; z clear
	;
	call eread
	xorwf rpmlo,w
	return
	;
	; GET NEW STEP DATA
	;
stpset  addwf level,w
	call ereadA
	movwf stepCH    ; step count H stg (x)
	;
	call eread      
	movwf stepCL    ; step count L stg (x)
	return
	;
	; INCREMENT STAGE ADVANCE COUNTERS
	;
stpadd  movf stepCL,w
	addwf stpadL
	btfss status,carry
	goto lwadbr
	;
	incfsz stpadH
	goto lwadbr
	incfsz stgctL
	goto lwadbr
	incf stgctH
	;
lwadbr  movf stepCH,w
	addwf stpadH
	btfsc status,carry
	incfsz stgctL     ; stage advance value
	goto limitc
	incf stgctH
	;
limitc  btfss flag1,negset  ; do negative adv if set for stg1
	goto noigng
	;
	movlw 0xff          ; stgctL max value = fah
	addwf stgctL        ; stgctH not used until < 300RPM (= 0)
	;
noigng  movlw 0ah       ; max count = 0a
	xorwf stgctH,w  ; ~ 45' @ 30 RPM
	btfss status,z
	return
	;
	bcf flag1,run
	call clear
	movlw .2
	movwf strtcnt
	return
	;
	; SET STAGE INITIAL ADVANCE LOOPS
	;
lpsset  addwf level,w
	call ereadA
lpsetA  movwf stgctL
	clrf stpadH     ; clear stage step counters
	clrf stpadL
	return
	;
	; CLEAR REGS
	;
clear   clrf rpmhi
	clrf rpmlo
	clrf vloops
	clrf VcntH
	clrf VcntL
	clrf DcntH
	clrf DcntL
	clrf dloops
	clrf stgctL
	clrf stgctH
	return
	;
	; CLEAR WORKING RAM  - EXCEPT LEVEL
	;
clearR  movlw 0ch
	movwf fsr
clloop  clrf indirect
	incf fsr
	movlw 2fh
	xorwf fsr,w
	btfss status,z
	goto clloop
	return
	;
	; divide regs by 2 until indirect value = 0
	;
tozero  movwf fsr
inzero  movf indirect,w
	btfsc status,z
	return                  ; done
	;
	bcf status,carry
	rrf numbhi
	rrf numblo
	bcf status,carry
	rrf numahi
	rrf numalo
	goto inzero
	;
	;       **************************
	;
	end
