1 GOTO 10
5 REM IOIFM.BAS  #1 R.W. 30/08/99
6 SAVE "c:\bas\ioifm",A
7 SAVE "a:\bas\ioifm",A
10 REM Code for MODIFIED Input Output card. Silicon Chip July 1997, P23
11 'Each input controls the corresponding relay
12 'and toggles it each time the input is grounded
13 'line 1420 & subroutine 5000 allow you to store the relay
14 'settings so that you can quit the program & read the values
15 'as soon as you load the software without interrogating the card
16 CLS: LOCATE 10,1: PRINT "This program needs the MODIFIED input/output card"
17 PRINT "As well as GW Basic SCREEN9 (EGA/VGA)"
18 T = TIMER: WHILE TIMER < T + 4: WEND
20 ON ERROR GOTO 6000
30 GOSUB 1000 'Initialise
40 GOSUB 2000 'Write screen heading
50 GOSUB 4000 'Monitor the 8 opto-isolator input lines & switch the relays
900 GOSUB 5100 'Save current relay settings
999 CLS: SYSTEM
1000 '***********************
1010 'Initialisation routine.
1020 '***********************
1030 KEY OFF: CLS: DEFINT A-C,I,R: DEFSTR D,K,U
1050 KESC = CHR$(27): KENTER = CHR$(13): KSP = CHR$(32) 'Spacebar
1100 KHOME = CHR$(0) + CHR$(71): KEND = CHR$(0) + CHR$(79) 'Home & End
1110 DEF FNCENTRE$(M$) = SPACE$((79 - LEN(M$))/2) + M$ 'Centre text
1240 SCREEN 9: COLOR 14,11: CLS
1300 '*********************
1310 'Setup Card Addresses.
1320 '*********************
1330 ONE = 11 'PORTC address for output to card #1
1340 TWO = 9 'PORTC address for output to card #2
1350 THREE = 15 'PORTC address for output to card #3
1360 FOUR= 13 'PORTC address for output to card #4
1370 FIVE = 3 'PORTC address for output to card #5
1380 SIX = 1 'PORTC address for output to card #6
1390 SEVEN = 7 'PORTC address for output to card #7
1400 EIGHT = 5 'PORTC address for output to card #8
1410 STH = -1: STL = 0 'strobe high and low
1420 GOSUB 5000 'read stored values
1430 IF PORTA = 0 THEN PORTA = &H378 'LPT1. Change to &H278 for LPT2
1440 PORTB = PORTA + 1
1450 PORTC = PORTA + 2
1460 OUT PORTA,R(1) + R(2) + R(3) + R(4) + R(5) + R(6) + R(7) + R(8) 'sel Relays
1470 OUT PORTC,ONE + STH: OUT PORTC,ONE + STL 'latch them
1480 FALSE = 0: TRUE = NOT FALSE
1999 RETURN
2000 '****************
2010 'Write to screen.
2020 '****************
2030 COLOR 4,11: X = 100: Y = 25: PSET (X,Y) 'Write SC to screen
2040 DRAW "u12;h12;l48;g12;d24;f12;r32;d24;l24;u12;l24;d12;f12;r48"
2050 PSET (X,Y): DRAW "l24;u12;l24;d24;r32;f12;d24;g12"
2060 PAINT (X-20,Y-5) 'Draw & fill S
2070 PSET (X+90,Y)
2080 DRAW "u12;h12;l48;g12;d60;f12;r48;e12;u12;l24;d12;l24;u60;r24;d12;r24"
2090 PAINT (X+80,Y-5) 'Draw & fill C
2100 COLOR 14,11
2110 LOCATE 3,35: PRINT "Silicon Chip";
2120 LOCATE 5,35: PRINT "Input - Output Computer Interface";
2130 FOR A = 9 TO 23 STEP 2: LOCATE A,35
2140 PRINT "RELAY ";(A-7)/2;: NEXT
2150 LOCATE 25,1: PRINT FNCENTRE$("Press Esc or End key to end this program");
2160 R1 = R(1): R2 = R(2): R3 = R(3): R4 = R(4)
2170 R5 = R(5): R6 = R(6): R7 = R(7): R8 = R(8)
2180 FOR A = 9 TO 23 STEP 2: LOCATE A,45
2190   IF R((A-7)/2) = 0 THEN PRINT "De-energised"; ELSE PRINT "Energised   ";
2200 NEXT
2999 RETURN
3000 '******************************
3010 'Input Port Conversion Routine.
3020 '******************************
3030 B = INP(PORTB) 'Port B
3040 C = INP(PORTC) 'Port C
3100 '***************************
3110 'Convert input to TRUE HIGH.
3120 '***************************
3123 'To convert any data input to parallel ports B & C as all true HIGH
3126 'as PORT C bits 1, 2 & 4 and PORT B bit 8 are low TRUE
3140 IF (B AND 128) THEN BIN = B - 135 ELSE BIN = B + 121
3150 CIN = (C AND 14)
3160 IF (C AND 2) = 0 THEN CIN = CIN + 2 ELSE CIN = CIN - 2
3170 IF (C AND 8) = 0 THEN CIN = CIN + 8 ELSE CIN = CIN - 8
3180 CIN = INT(CIN / 2) 'get rid of bit 1
3190 TIN = BIN + CIN 'Total converted input
3199 RETURN
4000 '**************************
4010 'Monitor the 8 input lines.
4020 '**************************
4021 'Format is out port ,120: out portc,4
4022 'i.e. take all input lines high
4023 'After delay (line 4050) IC3 will be enabled and
4024 'any grounded inputs will pull output lines low
4030 WHILE K <> KESC AND K <> KEND: K = INKEY$
4040    OUT PORTB,120: OUT PORTC,4 'all lines high
4050    T = TIMER: WHILE TIMER < T + .01: WEND 'allow time for IC3 enable
4060    GOSUB 3000 'read input and convert to all positive true
4070    TIN = 255 - TIN 'get complement of TIN
4080    IF TIN = 0 THEN 4310
4085    FOR A = 0 TO 7: IF TIN/2^A = 1 THEN RLY = A + 1 ELSE NEXT A
4090    ON RLY GOTO 4100,4120,4140,4160,4180,4200,4220,4240
4100    S1 = NOT S1: IF S1 = TRUE THEN R1 = 1 ELSE R1 = 0 'toggle bit,set value
4110    R(1) = R1: GOTO 4260
4120    S2 = NOT S2: IF S2 = TRUE THEN R2 = 2 ELSE R2 = 0
4130    R(2) = R2: GOTO 4260
4140    S3 = NOT S3: IF S3 = TRUE THEN R3 = 4 ELSE R3 = 0
4150    R(3) = R3: GOTO 4260
4160    S4 = NOT S4: IF S4 = TRUE THEN R4 = 8 ELSE R4 = 0
4170    R(4) = R4: GOTO 4260
4180    S5 = NOT S5: IF S5 = TRUE THEN R5 = 16 ELSE R5 = 0
4190    R(5) = R5: GOTO 4260
4200    S6 = NOT S6: IF S6 = TRUE THEN R6 = 32 ELSE R6 = 0
4210    R(6) = R6: GOTO 4260
4220    S7 = NOT S7: IF S7 = TRUE THEN R7 = 64 ELSE R7 = 0
4230    R(7) = R7: GOTO 4260
4240    S8 = NOT S8: IF S8 = TRUE THEN R8 = 128 ELSE R8 = 0
4250    R(8) = R8
4260    RT = R1 + R2 + R3 + R4 + R5 + R6 + R7 + R8 'sum new value
4270     FOR A = 9 TO 23 STEP 2: LOCATE A,45
4280      IF R((A-7)/2) = 0 THEN PRINT "De-energised";ELSE PRINT "Energised   ";
4290     NEXT
4300    OUT PORTA,RT: OUT PORTC,ONE + STH: OUT PORTC,ONE + STL 'and output it
4310    T = TIMER: WHILE TIMER < T +.1: WEND 'delay to prevent relays chattering
4990 WEND
4999 RETURN
5000 '********************************
5010 'Read last stored output setting.
5020 '********************************
5030 'Read the previous saved values for this card
5040 OPEN "c:\bas\SCIO.DTA" FOR INPUT AS 1: GOTO 5050 'use C drive
5043 OPEN "a:SCIO.DTA" FOR INPUT AS 1: GOTO 5050 'or A drive if not on C
5050 INPUT #1, PORTA, R(1), R(2), R(3), R(4), R(5), R(6), R(7), R(8)
5060 CLOSE 1
5099 RETURN
5100 '**********************
5110 'Save current settings.
5120 '**********************
5130 OPEN "c:\bas\SCIO.DTA" FOR OUTPUT AS 1: GOTO 5140 'use C drive
5133 OPEN "a:SCIO.DTA" FOR OUTPUT AS 1: GOTO 5140 'or A drive if not on C
5140 WRITE# 1, PORTA, R1, R2, R3  R4, R5, R6, R7, R8
5150 CLOSE 1
5199 RETURN
6000 RESUME NEXT 'error handler
