0 GOTO 10
1 REM This modification & software make the I/O card compatible with the
2 ' one & two motor driver cards published in Silicon Chip
3 ' in August and September 1997 and July 1999.
4 ' You MUST move the 10k resistor on pin 4 of IC1 from ground to +5V.
5 ' You must also remove pin 4 of IC4's socket (or cut pin 4 off) & connect
6 ' pin 4 track to pin 5 track, which removes the strobe inverter
8 SAVE "a:ioifmagm",A
9 END
10 C1 = 11: C2 = 9: C3 = 15: C4 = 13 'define cards
20 C5 = 3: C6 = 1: C7 = 7: C8 = 5
30 STH = -1 :STL = 0 'strobe high & low
40 PORTA = &H378: REM &H378 is for LPT1 use &H278 for LPT2
50 PORTB = PORTA + 1: PORTC = PORTA + 2 'define port addresses
60 CLS: KEY OFF: OUT PORTC,C1 + STL 'inhibit IC3
70 OUT PORTA,0: OUT PORTC,C1+ STH: OUT PORTC,C1 + STL 'turn all relays off
80 FOR A = 0 TO 7 'relays are coded 1, 2, 4, 8, 16, 32, 64, 128
90     OUT PORTA,2^A 'select relay 1 TO 8 in turn
100    OUT PORTC,C1 + STH: OUT PORTC,C1 + STL 'release old, latch new
110    PRINT "Relay  ";A+1;" operating."
120    B$= RIGHT$(TIME$,2): WHILE RIGHT$(TIME$,2) = B$: WEND 'wait one second
130 NEXT A
140 OUT PORTA,0: OUT PORTC,C1 + STH: OUT PORTC,C1 + STL 'turn all relays off
200 'Code for reading CON3 inputs
210 OUT PORTB,120: OUT PORTC,4 'take input lines high
220 LOCATE 25,1: PRINT TAB(20);" Ground diode D1 - D8. Press any key to quit."
230 FOR A = 1 TO 200: NEXT 'delay for IC4c increase value if necessary
240 WHILE K$ = ""
250     K$ = INKEY$
260     LIN = 0: B = INP(PORTB): C = INP(PORTC) 'read port inputs
270     IF (B AND 128) THEN BIN = B - 135 ELSE BIN = B + 121 'complement bit 8
280     CIN = C AND 14 'mask high bits & C0
290     IF (C AND 2) = 0 THEN CIN = CIN + 2 ELSE CIN = CIN - 2 'complement 2 bit
300     IF (C AND 8) = 0 THEN CIN = CIN + 8 ELSE CIN = CIN - 8 'complement 8 bit
310     CIN = INT (CIN/2): TIN = 255 - (BIN + CIN)
320        FOR A = 0 TO 7
330          IF TIN/2^A = 1 THEN LIN = A + 1 'find low line
340        NEXT
350     LOCATE 24,20: PRINT "Line";LIN; 'print it
360 WEND 'loop
370 OUT PORTC,C1 + STL 'inhibit IC3
380 CLS: END 'change END to SYSTEM to exit GW-Basic
