1 GOTO 20
5 SAVE "c:\bas\pcbdrill",A
6 SAVE "a:\bas\pcbdrill",A
7 END
10 REM Driver software for drilling PC boards using a Protel file
11 'XY stepper motors use the 2 motor driver card featured in
12 'Silicon Chip Magazine September 1997 - Updated August 1999
13 'Z direction is controlled by the single stepper motor
14 'card featured in Silicon Chip Magazine August 1997 - Updated Augu t 1999
15 'X-Y is controlled by CARD1, Z controlled by CARD2
16 'DRLSETUP.BAS is the initialisation for all parameters
17 'Protel TRAXPLOT.EXE & drillfile must be in C:\PROTEL\TRAXPLOT directory
20 GOSUB 1030 'Initialise
30 GOSUB 5030 'Setup opening screen
40 GOSUB 2030 'Ask for filename and check PCB does not exceed XY limits
50 GOSUB 8030 'Main program
60 GOSUB 5630 'Drill fully up
70 GOSUB 6130 'Save X,Y position
80 CLS 'Done here to show OUT OF LIMITS message for line 2399
900 CHDIR "\bas"
999 SYSTEM 'Quit
1000 '***********************
1010 'Initialisation routine.
1020 '***********************
1030 KEY OFF: SCREEN 9: CLS : DEFINT A-Z: DEFSTR D-E, K: DEFSNG T
1031 'All integers except D,E,K,U which are strings & T single precision
1040 ESC = CHR$(27): ENTER = CHR$(13): KSP = CHR$(32) 'Spacebar
1050 KLA = CHR$(0) + CHR$(75): KRA = CHR$(0) + CHR$(77) 'Left & right arrows
1060 KUA = CHR$(0) + CHR$(72): KDA = CHR$(0) + CHR$(80) 'Up & down arrows
1070 KHOME = CHR$(0) + CHR$(71): KEND = CHR$(0) + CHR$(79) 'Home & end
1080 DEF FNCEOL$ = STRING$(79 - POS(Q)," ")
1090 DEF FNCENTRE$ (M$) = SPACE$((79 - LEN(M$)) / 2) + M$'Centre text
1100 DEF FNXLOC = INSTR(A$,"X"): DEF FNYLOC = INSTR(A$,"Y"): ZERO$ = "00000"
1110 DOB = CHR$(219): DP = CHR$(223) 'Define characters
1120 DOBB = CHR$(222): DOBE = CHR$(221)
1121 'Half width lines Beg & End of digits 2,5,6
1130 STH = -1: STL = 0 'Strobe high and low
1140 GOSUB 6030 'get saved values from file
1150 PORTA = PPORT: PORTC = PORTA + 2 'Select parallel port
1160 OUT PORTA,0 'set all data lines low
1170 OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL 'card1 - IC2 O/P's low
1180 FOR PAUSE = 1 TO MDELAY: NEXT
1190 OUT PORTC, CARD2 + STH: OUT PORTC, CARD2 + STL 'card2 - IC2 O/P's low
1200 FOR PAUSE = 1 TO MDELAY: NEXT
1210 OUT PORTC,7 + STH: OUT PORTC,7 + STL 'Clock IC1a
1220 FOR PAUSE = 1 TO MDELAY: NEXT
1230 OUT PORTC,5 + STH: OUT PORTC,5 + STL 'Clock IC1b, 12V to motors
1240 FOR PAUSE = 1 TO MDELAY: NEXT
1250 OUT PORTA, 153: OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL 'Home motor
1260 FOR PAUSE = 1 TO MDELAY: NEXT
1270 OUT PORTA, 105: OUT PORTC, CARD2 + STH: OUT PORTC, CARD2 + STL 'Home motor
1280 FOR PAUSE = 1 TO MDELAY: NEXT
1290 OUT PORTA, 0: OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL 'Motors off
1300 FOR PAUSE = 1 TO MDELAY: NEXT
1310 OUT PORTC, CARD2 + STH: OUT PORTC, CARD2 + STL 'Motor I off
1320 FOR PAUSE = 1 TO MDELAY: NEXT
1330 ISS = 30: IT = ISS + 8: IU = IT + 8: TH = IU + 9: TT = TH + 8: TU = TT + 8
1340 DATA 30,38,46,55,63,71
1341 'DATA is sequential sums of line 1190 as DATA statement wont accept ISS etc
1350 FS = 1 'Set feed step to 1 thou
1360 SPL(1) = 5: SPL(2) = 6: SPL(3) = 10: SPL(4) = 9 'Full plus step X-Y motors
1370 SMI(1) = 10: SMI(2) = 6: SMI(3) = 5: SMI(4) = 9 'Full minus step X-Y motors
1380 CW(1) = 153: CW(2) = 150: CW(3) = 102: CW(4) = 105 'Plus steps Z motor
1390 CCW(1) = 102: CCW(2) = 150: CCW(3) = 153: CCW(4) = 105 'Minus steps Z motor
1400 LX = 8: LY = 14 'Row or line for X & Y
1410 LXDP = LX + 3: LYDP = LY + 3: LPDP = IU + 7
1411 'X & Y positions for DP & line position for DP
1420 XNEW = XOLD: YNEW = YOLD 'Initialise X & Y positions
1430 ON ERROR GOTO 7030
1999 RETURN
2000 '*************
2010 'Parse string.
2020 '*************
2030 CHDIR "c:\protel\traxplot"
2040 INPUT;"What is the PCB filename to drill";FILENAME$
2050 IF FILENAME$ = "" OR FILENAME$ = ESC THEN 60
2060 A = INSTR(FILENAME$,"."): IF A THEN FILENAME$ = LEFT$(FILENAME$,A) + "TXT"
2070 IF A = 0 THEN FILENAME$ = FILENAME$ + ".TXT"
2080 OPEN FILENAME$ FOR INPUT AS 2
2090 XMIN = XMAX
2100    FOR A = 1 TO 6
2110            INPUT# 2,A$
2120    NEXT
2130 WHILE NOT EOF(2)
2140    INPUT# 2,A$
2150    IF FNXLOC > 0 AND FNYLOC > 0 THEN XINCH$ = MID$(A$,2,FNYLOC-2)                  ELSE IF FNXLOC > 0 AND FNYLOC = 0 THEN XINCH$ = MID$(A$,2,LEN(A$)-1)
2160    XNEW = VAL(LEFT$(XINCH$ + ZERO$,5+INSTR(XINCH$,"+")))
2170        IF FNYLOC THEN YINCH$ = MID$(A$,FNYLOC+1,LEN(A$)-FNYLOC+1)
2180    YNEW = VAL(LEFT$(YINCH$ + ZERO$,5+INSTR(YINCH$,"+")))
2190        IF XNEW > XMAX OR YNEW > YMAX THEN 2330 'Error - ABORT
2200        IF XNEW > XBIG THEN XBIG = XNEW 'find largest X value
2210 WEND
2220 CLOSE 2
2299 RETURN
2300 '********************
2310 'Out of range - exit.
2320 '********************
2330 CLOSE 2
2340 LOCATE 25,1: PRINT FNCEOL$;: LOCATE 25,1: BEEP: BEEP: BEEP
2350 PRINT FNCENTRE$("LOCATION OUTSIDE X-Y LIMITS. PROGRAM ABORTED");
2399 RETURN 900 'don't clear screen
3000 '********************
3010 'Motor step routines.
3020 '********************
3021 '4 steps = 0.001" on 1.8 degree motors
3022 'STX = LSN, STY = MSNibble of PORTA, STP is combined byte
3030 K = INKEY$
3040 IF XNEW <> XOLD THEN FSX = 1
3050 IF YNEW <> YOLD THEN FSY = 1
3060 IF XNEW <> XOLD THEN IF XNEW <= XOLD-10 OR XNEW => XOLD+10 THEN FSX = 10
3070 IF YNEW <> YOLD THEN IF YNEW <= YOLD-10 OR YNEW => YOLD+10 THEN FSY = 10
3080 IF XNEW <> XOLD THEN IF XNEW <= XOLD-100 OR XNEW => XOLD+100 THEN FSX = 100
3090 IF YNEW <> YOLD THEN IF YNEW <= YOLD-100 OR YNEW => YOLD+100 THEN FSY = 100
3100 IF XNEW > XOLD THEN FOR A = 1 TO 4: STX(A) = SPL(A): NEXT '+ step
3110 IF XNEW < XOLD THEN FOR A = 1 TO 4: STX(A) = SMI(A): NEXT '- step
3120 IF YNEW > YOLD THEN FOR A = 1 TO 4: STY(A) = SPL(A): NEXT '+ step
3130 IF YNEW < YOLD THEN FOR A = 1 TO 4: STY(A) = SMI(A): NEXT '- step
3133 IF XNEW = XOLD THEN FOR A = 1 TO 4: STX(A) = 0: NEXT: FSX = 100 'no step
3136 IF YNEW = YOLD THEN FOR A = 1 TO 4: STY(A) = 0: NEXT: FSY = 100 'no step
3140 FS = ABS((FSX > FSY) * FSY + (FSY > FSX) * FSX + (FSX = FSY) * FSY)
3150 FOR A = 1 TO 4: STP(A) = STX(A) * 16 + STY(A): NEXT 'combine X & Y
3160 FOR B = 1 TO FS: FOR A = 1 TO 4
3170	OUT PORTA, STP(A)
3180	    OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL'step
3190	FOR PAUSE = 1 TO MDELAY: NEXT 'allow stepping delay
3200 NEXT A: NEXT B
3210 IF XNEW = XOLD THEN 3310 'skip to Y move if no X movement
3220 IF XNEW>XOLD THEN XOLD = XOLD + FS ELSE IF XNEW<XOLD THEN XOLD = XOLD - FS
3230 LOCATE LX, ISS: FOR A = 1 TO 5: LOCATE CSRLIN, ISS: PRINT FNCEOL$: NEXT
3240 LOCATE LXDP, LPDP: PRINT DP're-write D.P.
3250 R = LX: XD$ = "000000": RSET XD$ = STR$(XOLD): XD$ = RIGHT$(XD$, 5)
3260 READ C: FOR A = 1 TO 5
3270 B = VAL(MID$(XD$, A, 1)): READ C 'get position & write large digit
3280 ON B + 1 GOSUB 4030, 4130, 4230, 4330, 4430, 4530, 4630, 4730, 4830, 4930
3290 NEXT A
3300 RESTORE 1340
3310 IF YNEW = YOLD THEN 3410 'skip to end if no Y movement
3320 IF YNEW>YOLD THEN YOLD = YOLD + FS ELSE IF YNEW<YOLD THEN YOLD = YOLD - FS
3330 LOCATE LY, ISS: FOR A = 1 TO 5: LOCATE CSRLIN, ISS: PRINT FNCEOL$: NEXT
3340 LOCATE LYDP, LPDP: PRINT DP're-write D.P.
3350 R = LY: YD$ = "000000": RSET YD$ = STR$(YOLD): YD$ = RIGHT$(YD$, 5)
3360 READ C: FOR A = 1 TO 5
3370 B = VAL(MID$(YD$, A, 1)): READ C
3380 ON B + 1 GOSUB 4030, 4130, 4230, 4330, 4430, 4530, 4630, 4730, 4830, 4930
3390 NEXT A
3400 RESTORE 1340
3410 OUT PORTA,0: OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL 'XY off
3420 FOR PAUSE = 1 TO MDELAY: NEXT
3430 IF K > "" THEN GOSUB 5630: XNEW = 0: YNEW = 0: WHILE XNEW <> XOLD                  OR YNEW <> YOLD: GOSUB 3030: WEND: RETURN 70 'any key ends
3499 RETURN
4000 '********************************************************************
4010 '4030 - 4920 draw large block digits from 0 to 9 at the location R,C.
4020 '********************************************************************
4030 'digit 0
4040 LOCATE R, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT
4050 FOR AA = 1 TO 3: LOCATE CSRLIN, C: PRINT DOB; : LOCATE CSRLIN, C + 4:           PRINT DOB: NEXT
4060 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT
4099 RETURN
4120 'digit 1
4130 LOCATE R, C + 1: PRINT DOB; DOB
4140 FOR AA = 1 TO 3: LOCATE CSRLIN, C + 1: PRINT DOB; DOB: NEXT
4150 LOCATE CSRLIN, C + 1: PRINT DOB; DOB;
4199 RETURN
4220 'digit 2
4230 LOCATE R, C: PRINT DOBB;:FOR AA = 1 TO 4: PRINT DOB; : NEXT: PRINT DOBE
4240 LOCATE CSRLIN, C + 3: PRINT DOBB;DOB;DOBE
4250 LOCATE CSRLIN, C: PRINT DOBB;:FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT DOBE
4260 LOCATE CSRLIN, C: PRINT DOBB;DOB
4270 LOCATE CSRLIN, C: PRINT DOBB;:FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT DOBE
4299 RETURN
4320 'digit 3
4330 LOCATE R, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT DOBE
4340 LOCATE CSRLIN, C + 4: PRINT DOB;DOBE
4350 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT DOBE
4360 LOCATE CSRLIN, C + 4: PRINT DOB;DOBE
4370 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT DOBE
4399 RETURN
4420 'digit 4
4430 LOCATE R, C: PRINT DOB; DOB: LOCATE CSRLIN, C: PRINT DOB; DOB
4440 LOCATE CSRLIN, C: PRINT DOB; DOB; SPC(2); DOB
4450 LOCATE CSRLIN, C: FOR AA = 1 TO 6: PRINT DOB; : NEXT: PRINT
4460 LOCATE CSRLIN, C + 4: PRINT DOB;
4499 RETURN
4520 'digit 5
4530 LOCATE R, C: PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB; : NEXT: PRINT DOBE
4540 LOCATE CSRLIN, C: PRINT DOBB;DOB
4550 LOCATE CSRLIN, C: PRINT DOBB;:FOR AA = 1 TO 4:PRINT DOB;: NEXT: PRINT DOBE
4560 LOCATE CSRLIN, C + 3: PRINT DOBB;DOB;DOBE
4570 LOCATE CSRLIN, C: PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB; : NEXT: PRINT DOBE
4599 RETURN
4620 'digit 6
4630 LOCATE R, C:PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT DOBE
4640 LOCATE CSRLIN, C: PRINT DOBB;DOB
4650 LOCATE CSRLIN, C: PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT DOBE
4660 LOCATE CSRLIN, C: PRINT DOBB;DOB; SPC(2); DOB;DOBE
4670 LOCATE CSRLIN, C: PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB; : NEXT: PRINT DOBE
4699 RETURN
4720 'digit 7
4730 LOCATE R, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT
4740 FOR AA = 1 TO 3: LOCATE CSRLIN, C + 3: PRINT DOB; DOB: NEXT
4780 LOCATE CSRLIN, C + 3: PRINT DOB; DOB;
4799 RETURN
4820 'digit 8
4830 LOCATE R, C: FOR AA = 1 TO 4: PRINT DOB; : NEXT
4840 FOR AA = 1 TO 2: LOCATE CSRLIN, C: PRINT DOB; : LOCATE CSRLIN, C + 4:           PRINT DOB: NEXT
4850 LOCATE CSRLIN, C: FOR AA = 1 TO 4: PRINT DOB; : NEXT
4860 FOR AA = 1 TO 2: LOCATE CSRLIN, C: PRINT DOB; : LOCATE CSRLIN, C + 4:           PRINT DOB: NEXT
4870 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT
4899 RETURN
4920 'digit 9
4930 LOCATE R, C: FOR AA = 1 TO 4: PRINT DOB; : NEXT
4940 FOR AA = 1 TO 2: LOCATE CSRLIN, C: PRINT DOB; : LOCATE CSRLIN, C + 4:           PRINT DOB: NEXT
4950 LOCATE CSRLIN, C: FOR AA = 1 TO 4: PRINT DOB; : NEXT
4960 FOR AA = 1 TO 2: LOCATE CSRLIN, C + 4: PRINT DOB: NEXT
4970 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT
4999 RETURN
5000 '****************
5010 'Write to screen.
5020 '****************
5030 COLOR 4, 11: X = 100: Y = 25: PSET (X, Y)'Write SC to screen
5040 DRAW "u12;h12;l48;g12;d24;f12;r32;d24;l24;u12;l24;d12;f12;r48"
5050 PSET (X, Y): DRAW "l24;u12;l24;d24;r32;f12;d24;g12"
5060 PAINT (X - 20, Y - 5)'draw & fill S
5070 PSET (X + 90, Y)
5080 DRAW "u12;h12;l48;g12;d60;f12;r48;e12;u12;l24;d12;l24;u60;r24;d12;r24"
5090 PAINT (X + 80, Y - 5)'draw & fill C
5100 COLOR 14, 11
5110 LOCATE 2, 35: PRINT "Silicon Chip";
5120 LOCATE 4, 35: PRINT "Drill a Protel PCB";
5130 LOCATE LX, 10: PRINT DOB; SPC(4); DOB 'print X
5140 LOCATE CSRLIN, 11: PRINT DOB; SPC(2); DOB; SPC(8); CHR$(220); CHR$(220)'& =
5150 LOCATE CSRLIN, 12: PRINT DOB; DOB; SPC(9); CHR$(220); CHR$(220)'& =
5160 LOCATE CSRLIN, 11: PRINT DOB; SPC(2); DOB
5170 LOCATE CSRLIN, 10: PRINT DOB; SPC(4); DOB
5180 LOCATE LY, 10: PRINT DOB; SPC(4); DOB 'print Y
5190 LOCATE CSRLIN, 10: PRINT DOB; SPC(4); DOB; SPC(7); CHR$(220); CHR$(220)'& =
5200 LOCATE CSRLIN, 10: FOR A = 1 TO 6: PRINT DOB; : NEXT
5210 PRINT SPC(7); CHR$(220); CHR$(220)'& =
5220 LOCATE CSRLIN, 15: PRINT DOB
5230 LOCATE CSRLIN, 10: FOR A = 1 TO 6: PRINT DOB; : NEXT
5240 XOLD = XOLD+1:YOLD = YOLD+1: GOSUB 3210
5250 XOLD = XOLD-1:YOLD = YOLD-1: GOSUB 3210
5260 LOCATE 25, 17
5299 RETURN
5300 '*******************
5310 'PCB drill fast down.
5320 '********************
5330 FOR A = 1 TO ZSF 'drive drill down ZSFast steps
5340    FOR B = 1 TO 4 
5350      OUT PORTA,CW(B)
5360      OUT PORTC,CARD2 + STH: OUT PORTC,CARD2 + STL
5370         FOR PAUSE = 1 TO MDELAY * 4: NEXT
5380    NEXT B
5390 NEXT A
5399 RETURN
5400 '********************
5410 'PCB drill slow down.
5420 '********************
5430 FOR A = 1 TO ZSS 
5440    FOR B = 1 TO 4 
5450      OUT PORTA,CW(B)
5460      OUT PORTC,CARD2 + STH: OUT PORTC,CARD2 + STL
5470         FOR PAUSE = 1 TO MDELAY * 4: NEXT 'slow stepping rate
5480    NEXT B
5490 NEXT A
5499 RETURN
5500 '******************
5510 'PCB drill slow up.
5520 '******************
5530 FOR A = 1 TO ZSS 
5540    FOR B = 1 TO 4  
5550      OUT PORTA,CCW(B)
5560      OUT PORTC,CARD2 + STH: OUT PORTC,CARD2 + STL
5570         FOR PAUSE = 1 TO MDELAY * 4: NEXT
5580    NEXT B
5590 NEXT A
5599 RETURN
5600 '******************
5610 'PCB drill fast up.
5620 '******************
5630 FOR A = 1 TO ZSF 'Take drill fully up
5640    FOR B = 1 TO 4 
5650      OUT PORTA,CCW(B)
5660      OUT PORTC,CARD2 + STH: OUT PORTC,CARD2 + STL
5670         FOR PAUSE = 1 TO MDELAY * 4: NEXT
5680    NEXT B
5690 NEXT A
5700 OUT PORTA,0: OUT PORTC,CARD2 + STH: OUT PORTC,CARD2 + STL 'motor off
5710 FOR PAUSE = 1 TO MDELAY: NEXT
5799 RETURN
6000 '****************************
6010 'Get save position from file.
6020 '****************************
6030 OPEN "r", 1, "\bas\drlsetup.fil", 48
6040 FIELD #1, 4 AS OLDX$, 4 AS OLDY$, 4 AS MAXX$, 4 AS MAXY$, 4 AS DELAY$
6050 FIELD #1,20 AS J$, 4 AS CARD1$, 4 AS CARD2$, 4 AS UNITS$, 4 AS ZFSTEP$
6055 FIELD #1, 36 AS JJ$, 4 AS ZSSTEP$, 4 AS PPORT$, 4 AS DRILL$
6060 GET 1,1: XOLD = CVI(OLDX$): YOLD = CVI(OLDY$): REDRILL = CVI(DRILL$)
6070 XMAX = CVI(MAXX$): YMAX = CVI(MAXY$): MDELAY = CVI(DELAY$)
6080 CARD1 = CVI(CARD1$): CARD2 = CVI(CARD2$): UNITS = CVI(UNITS$) '0=Imp 1=Met
6090 ZSF = CVI(ZFSTEP$): ZSS = CVI (ZSSTEP$): PPORT = CVI(PPORT$)
6099 RETURN
6100 '**********************
6110 'Save position to file.
6120 '**********************
6130 LSET OLDX$ = MKI$(XOLD): LSET OLDY$ = MKI$(YOLD)
6140 PUT 1,1
6150 CLOSE 1
6199 RETURN
7000 '**************
7010 'Error handler.
7020 '**************
7030 LOCATE 25,1: PRINT FNCEOL$;: LOCATE 25,14
7040 PRINT FILENAME$; " was not found. Press spacebar to re-enter.";
7050 PLAY "mb o2 p2  l8 ggg l2 e-"
7060 K = INPUT$(1)
7070 LOCATE 25,1: PRINT FNCEOL$;: LOCATE 25,17
7099 RESUME 2040
8000 '***********************************************
8010 'Reads FILE.TOL for drill sizes for X-Y-Z table.
8020 '***********************************************
8030 OPEN LEFT$(FILENAME$,LEN(FILENAME$)-3) + "TOL" FOR INPUT AS 2
8040 FOR A = 1 TO 7: INPUT# 2,A$: NEXT
8050 WHILE NOT EOF(2)
8060   INPUT#2,A$: DRILL(A) = (RIGHT$(A$,LEN(A$)-5)): A = A + 1
8070 WEND
8080 CLOSE 2
8090 B = A - 1 'B is number of drill sizes
8100 '*********************************
8110 'Read TXT file and compute points.
8120 '*********************************
8130 LOCATE 25,1:PRINT FNCENTRE$("Do you wish to flip the PC board. ENTER = Y");
8140 FLIP = 1: K = INPUT$(1): IF K = "N" OR K = "n" THEN FLIP = 0
8150 LOCATE 25,1: PRINT FNCEOL$;: LOCATE 6,35:                                          PRINT "Drilling ";LEFT$(FILENAME$,LEN(FILENAME$)-3) + "pcb";
8160 IF FLIP THEN PRINT " (Flipped)"
8170 GOSUB 5330 'drill fast down
8180 OPEN FILENAME$ FOR INPUT AS 2
8190 FILMAX = CINT(LOF(2)/128) + 1 'to be sure
8200    FOR A = 1 TO 6: INPUT# 2,A$: NEXT 'find XY start
8210 WHILE NOT EOF(2)
8220    INPUT#2,A$ 'calculate X and Y values for first pass
8230    GOSUB 8500 'move to hole & drill 
8240 WEND
8250 CLOSE 2
8260 IF REDRILL = 0 THEN 8450 'finished - exit
8270 XNEW = 500: YNEW = -1000 'set drill insert position
8280    WHILE XOLD <> XNEW OR YOLD <> YNEW: GOSUB 3030: WEND 'home drill
8290 OPEN FILENAME$ FOR INPUT AS 2: FILNOW = 0
8300    FOR A = 1 TO 7: INPUT# 2,A$: NEXT 'find XY start
8310       WHILE LEFT$(A$,2) < > "T0": INPUT# 2,A$: WEND 'find second T0
8320    LOCATE 25,1: PRINT FNCEOL$;: LOCATE 25,15
8330    PRINT "Insert a #";DRILL(VAL(RIGHT$(A$,1))+7);                                   " DRILL in the chuck & press Space-Bar";: SOUND 660,2: SOUND 440,6
8340    K = INPUT$(1): IF K < > KSP THEN BEEP: GOTO 8340
8350    LOCATE 25,1: PRINT FNCEOL$;
8360    INPUT# 2,A$: GOSUB 8530 'drill next pad
8370            WHILE LEFT$(A$,2) < > "T0" 'then all pads to next T0
8380                  INPUT# 2,A$: IF EOF(2) THEN 8450
8390                  GOSUB 8530 'drill pads
8400            WEND
8410    YNEW = -500 'set Y axis to drill insert position,
8420        WHILE XOLD <> XNEW OR YOLD <> YNEW: GOSUB 3030: WEND
8440    GOTO 8320
8450 CLOSE 2
8460 SOUND 660,2: SOUND 440,6
8470 LOCATE 6,35: PRINT "PCB completed, now homing table.";
8475 GOSUB 5610 'drill up
8480 XNEW = 0: YNEW = 0 'set home position,
8490    WHILE XOLD <> XNEW OR YOLD <> YNEW: GOSUB 3030: WEND
8499 RETURN
8500 '*************
8510 'Parse string.
8520 '*************
8530 IF FNXLOC > 0 AND FNYLOC > 0 THEN XINCH$ = MID$(A$,2,FNYLOC-2)                  ELSE IF FNXLOC > 0 AND FNYLOC = 0 THEN XINCH$ = MID$(A$,2,LEN(A$)-1)
8540 XNEW = VAL(LEFT$(XINCH$ + ZERO$,5+INSTR(XINCH$,"+")))
8550 IF FNYLOC THEN YINCH$ = MID$(A$,FNYLOC+1,LEN(A$)-FNYLOC+1)
8560 YNEW = VAL(LEFT$(YINCH$ + ZERO$,5+INSTR(YINCH$,"+")))
8570	WHILE XOLD <> XNEW OR YOLD <> YNEW: GOSUB 3030: WEND 'move XY
8580   GOSUB 5430: GOSUB 5530 'drill hole (drill down & up)
8590 IF LOC(2) > FILNOW THEN FOR BB = 1 TO (LOC(2)/FILMAX)*80:                        LOCATE 25,BB: PRINT CHR$(254);:NEXT: FILNOW = LOC(2)
8599 RETURN
