1 GOTO 10
5 SAVE "c:\bas\xytable",A
6 SAVE "a:\bas\xytable",A
7 END
10 REM Driver software for X-Y stepper motors using the 2 motor
11 'driver card featured in Silicon Chip Magazine September 1997
12 'XYSETUP.BAS is the initialisation for all parameters
13 'Stepping speed optimisation is done by pressing R in this program
20 GOSUB 1000 'Initialise
30 GOSUB 5000 'Setup opening screen
40 GOSUB 2000 'Main program
50 OUT PORTA,0: OUT PORTC,CARD1 + STH: OUT PORTC,CARD1 + STL 'Motors off
60 GOSUB 6130 'Save X,Y position
999 CLS: SYSTEM 'Quit
1000 '***********************
1010 'Initialisation routine.
1020 '***********************
1030 KEY OFF: SCREEN 9: CLS : DEFINT A-Z: DEFSTR D-E, K: DEFSNG T
1031 'All integers except D,E,K,U which are strings & T single precision
1040 ESC = CHR$(27): ENTER = CHR$(13): KSP = CHR$(32) 'Spacebar
1050 KLA = CHR$(0) + CHR$(75): KRA = CHR$(0) + CHR$(77) 'Left & right arrows
1060 KUA = CHR$(0) + CHR$(72): KDA = CHR$(0) + CHR$(80) 'Up & down arrows
1070 KHOME = CHR$(0) + CHR$(71): KEND = CHR$(0) + CHR$(79) 'Home & end
1080 DEF FNCEOL$ = STRING$(79 - POS(Q)," ")
1090 DEF FNCENTRE$ (M$) = SPACE$((79 - LEN(M$)) / 2) + M$'Centre text
1100 DOB = CHR$(219): DP = CHR$(223) 'Define characters
1110 DOBB = CHR$(222): DOBE = CHR$(221)
1111 'Half width lines Beg & End of digits 2,5,6
1120 STL = 0: STH = -1 'Strobe low & high
1130 GOSUB 6030 'get saved values from file
1140 PORTA = PPORT: PORTB = PORTA + 1: PORTC = PORTA + 2 'Select parallel port
1150 OUT PORTA, 0: OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL 'IC2 O/P's low
1155 OUT PORTC,7 + STH: OUT PORTC,7 + STL 'Clock IC1a
1160 OUT PORTC,5 + STH: OUT PORTC,5 + STL 'Clock IC1b - 12V switched to motors
1165 OUT PORTA, 136: OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL 'Home motor
1170 OUT PORTA, 0: OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL 'Motors off
1180 ISS = 30: IT = ISS + 8: IU = IT + 8: TH = IU + 9: TT = TH + 8: TU = TT + 8
1181 'X posit for tens ", unit ", hundred thou, ten thou, unit thou of an inch
1190 DATA 30,38,46,55,63,71
1191 'DATA is sequential sum of line 1180 as DATA statement won't accept ISS etc
1200 FS = 1 'Set feed step to 1 thou
1210 SPL(1) = 5: SPL(2) = 6: SPL(3) = 10: SPL(4) = 9 'Full plus step X&Y motors
1220 SMI(1) = 10: SMI(2) = 6: SMI(3) = 5: SMI(4) = 9 'Full minus step X&Y motors
1250 LX = 8: LY = 14 'Row or line for X & Y
1260 LXDP = LX + 3: LYDP = LY + 3: LPDP = IU + 7
1261 'X & Y positions for DP & line position for DP
1270 XNEW = XOLD: YNEW = YOLD 'initialise X & Y positions
1280 ON ERROR GOTO 7030
1999 RETURN
2000 '*************
2010 'Main program.
2020 '*************
2021 'Check keyboard for instruction
2030 K = INKEY$
2040 WHILE K = "": K = INKEY$: WEND
2050 IF K = KRA THEN IF XOLD < XMAX THEN XNEW = XOLD + FS: GOSUB 3030: GOTO 2030
2060 IF K = KLA THEN IF XOLD > 0 THEN XNEW = XOLD - FS: GOSUB 3030: GOTO 2030
2070 IF K = KUA THEN IF YOLD < YMAX THEN YNEW = YOLD + FS: GOSUB 3030: GOTO 2030
2080 IF K = KDA THEN IF YOLD > 0 THEN YNEW = YOLD - FS: GOSUB 3030: GOTO 2030
2090 IF K = "X" OR K = "x" THEN GOSUB 2330 'move in X direction
2100 IF K = "Y" OR K = "y" THEN GOSUB 2430 'move in Y direction
2110 IF K = "S" OR K = "s" THEN GOSUB 2530 'change stepping increment
2120 IF K = "I" OR K = "i" THEN GOSUB 2730 'set Imperial units
2130 IF K = "M" OR K = "m" THEN GOSUB 2830 'set Metric units
2140 IF K = "R" OR K = "r" THEN GOSUB 5330 'set stepping rate
2150 IF K = KHOME THEN XNEW = 0: YNEW = 0: ST = 0:                                      WHILE XOLD <> XNEW OR YOLD <> YNEW: GOSUB 3030: WEND: GOTO 2030
2160 IF K = KEND THEN XNEW = XMAX: YNEW = YMAX: ST = 0:                                 WHILE XOLD <> XNEW OR YOLD <> YNEW: GOSUB 3030: WEND: GOTO 2030
2170 IF K = ESC THEN 2199
2180 GOTO 2030
2199 RETURN
2300 '***************
2310 'Set X position.
2320 '***************
2330 LOCATE 23, 1: INPUT "What is the new X co-ordinate";XPOS$
2335 IF XPOS$ = "" THEN XNEW = XOLD: GOTO 2350
2340 IF VAL(XPOS$) > -1 THEN IF UNITS = 0 THEN XNEW = VAL(XPOS$) * 1000                  ELSE XNEW = VAL(XPOS$) * (1000/25.4)
2350 INPUT;"If you wish to alter the Y co-ordinate type value &/or press Enter";        YPOS$: IF YPOS$ = "" THEN YNEW = YOLD: GOTO 2365
2360 IF VAL(YPOS$) > -1 THEN IF UNITS = 0 THEN YNEW = VAL(YPOS$) * 1000                 ELSE YNEW = VAL(YPOS$) * (1000/25.4)
2365 LOCATE 23, 1: PRINT FNCEOL$; : LOCATE 24, 1: PRINT FNCEOL$;
2370 IF XNEW > XMAX THEN XNEW = XMAX
2380 IF YNEW > YMAX THEN YNEW = YMAX
2390 ST = 0 'set auto feed
2395 WHILE XOLD <> XNEW OR YOLD <> YNEW: GOSUB 3030: WEND
2399 RETURN 2030
2400 '***************
2410 'Set Y position.
2420 '***************
2430 LOCATE 23, 1: INPUT "What is the new Y co-ordinate";YPOS$
2435 IF YPOS$ = "" THEN YNEW = YOLD: GOTO 2450
2440 IF VAL(YPOS$) > -1 THEN IF UNITS = 0 THEN YNEW = VAL(YPOS$) * 1000                 ELSE YNEW = VAL(YPOS$) * (1000/25.4)
2450 INPUT;"If you wish to alter the X co-ordinate type value &/or press Enter";        XPOS$: IF XPOS$ = "" THEN XNEW = XOLD: GOTO 2465
2460 IF VAL(XPOS$) > -1 THEN IF UNITS = 0 THEN XNEW = VAL(XPOS$) * 1000                 ELSE XNEW = VAL(XPOS$) * (1000/25.4)
2465 LOCATE 23, 1: PRINT FNCEOL$; : LOCATE 24, 1: PRINT FNCEOL$;
2470 IF XNEW > XMAX THEN XNEW = XMAX
2480 IF YNEW > YMAX THEN YNEW = YMAX
2490 ST = 0 'set auto feed
2495 WHILE XOLD <> XNEW OR YOLD <> YNEW: GOSUB 3030: WEND
2499 RETURN 2030
2500 '************************
2510 'Set feed step increment.
2520 '************************
2530 LOCATE 24, 1
2540 PRINT "Auto or Manual stepping? Press A or M.";
2550 ST$ = INPUT$(1)
2560 IF ST$ = ESC THEN 2660
2570 IF ST$ = "a" OR ST$ = "A" THEN ST = 0: GOTO 2670
2580 IF ST$ = "m" OR ST$ = "M" THEN ST = 1: GOTO 2600
2590 BEEP: GOTO 2530
2600 LOCATE 24, 1: PRINT FNCEOL$; : LOCATE 24, 1
2610 PRINT "Feed step in Unit, Tens or Hundreds of thou. Press U, T or H.";
2620 FS$ = INPUT$(1)
2630 IF FS$ = "u" OR FS$ = "U" THEN FSX = 1: FSY = 1: GOTO 2670
2640 IF FS$ = "t" OR FS$ = "T" THEN FSX = 10: FSY = 10: GOTO 2670
2650 IF FS$ = "h" OR FS$ = "H" THEN FSX = 100: FSY = 100: GOTO 2670
2660 ST = 0 'escape or wrong key sets auto feed as default
2670 LOCATE 24, 1: PRINT FNCEOL$;
2699 RETURN 2030
2700 '**********************
2710 'Select Imperial Units.
2720 '**********************
2730 UNITS = 0 'Imperial units
2740 XOLD = XOLD + 1: YOLD = YOLD + 1: GOSUB 3200 'update display - move table
2750 XOLD = XOLD - 1: YOLD = YOLD - 1: GOSUB 3200 'then restore it
2799 RETURN
2800 '********************
2810 'Select Metric Units.
2820 '********************
2830 UNITS = 1 'Metric units
2840 XOLD = XOLD + 1: YOLD = YOLD + 1: GOSUB 3200 'update display - move table
2850 XOLD = XOLD - 1: YOLD = YOLD - 1: GOSUB 3200 'then restore it
2899 RETURN
3000 '********************
3010 'Motor step routines.
3020 '********************
3021 '4 steps = 0.001" on 1.8 degree motors
3022 'STX = LSN, STY = MSNibble of PORTA, STP is combined Byte
3030 K = INKEY$
3035 IF ST THEN 3100 'if manual stepping skip auto (3040-3090)
3040 IF XNEW <> XOLD THEN FSX = 1
3050 IF YNEW <> YOLD THEN FSY = 1
3060 IF XNEW <> XOLD THEN IF XNEW <= XOLD-10 OR XNEW => XOLD+10 THEN FSX = 10
3070 IF YNEW <> YOLD THEN IF YNEW <= YOLD-10 OR YNEW => YOLD+10 THEN FSY = 10
3080 IF XNEW <> XOLD THEN IF XNEW <= XOLD-100 OR XNEW => XOLD+100 THEN FSX = 100
3090 IF YNEW <> YOLD THEN IF YNEW <= YOLD-100 OR YNEW => YOLD+100 THEN FSY = 100
3100 IF XNEW > XOLD THEN FOR A = 1 TO 4: STX(A) = SPL(A): NEXT '+ step
3110 IF XNEW < XOLD THEN FOR A = 1 TO 4: STX(A) = SMI(A): NEXT '- step
3120 IF YNEW > YOLD THEN FOR A = 1 TO 4: STY(A) = SPL(A): NEXT '+ step
3130 IF YNEW < YOLD THEN FOR A = 1 TO 4: STY(A) = SMI(A): NEXT '- step
3133 IF XNEW = XOLD THEN FOR A = 1 TO 4: STX(A) = 0: NEXT: FSX = 100 'no step
3136 IF YNEW = YOLD THEN FOR A = 1 TO 4: STY(A) = 0: NEXT: FSY = 100 'no step
3137 FS = ABS((FSX > FSY) * FSY + (FSY > FSX) * FSX + (FSX = FSY) * FSY)
3140 FOR A = 1 TO 4: STP(A) = STX(A) + STY(A) * 16: NEXT 'combine X & Y
3150 FOR B = 1 TO FS: FOR A = 1 TO 4
3160 OUT PORTA, STP(A)
3170 OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL
3180 FOR PAUSE = 1 TO MDELAY: NEXT
3190 NEXT A: NEXT B
3200 IF UNITS THEN GOSUB 3530 'if Metric display use Metric driver
3210 IF XNEW = XOLD THEN 3310 'skip to Y move if no X movement
3220 IF XNEW>XOLD THEN XOLD = XOLD + FS ELSE IF XNEW<XOLD THEN XOLD = XOLD - FS
3230 LOCATE LX, ISS: FOR A = 1 TO 5: LOCATE CSRLIN, ISS: PRINT FNCEOL$: NEXT
3240 LOCATE LXDP, LPDP: PRINT DP're-write D.P.
3250 R = LX: XD$ = "000000": RSET XD$ = STR$(XOLD): XD$ = RIGHT$(XD$, 5)
3260 READ C: FOR A = 1 TO 5
3270 B = VAL(MID$(XD$, A, 1)): READ C 'get position & write large digit
3280 ON B + 1 GOSUB 4030, 4130, 4230, 4330, 4430, 4530, 4630, 4730, 4830, 4930
3290 NEXT A
3300 RESTORE 1190
3310 IF YNEW = YOLD THEN 3410 'skip to end if no Y movement
3320 IF YNEW>YOLD THEN YOLD = YOLD + FS ELSE IF YNEW<YOLD THEN YOLD = YOLD - FS
3330 LOCATE LY, ISS: FOR A = 1 TO 5: LOCATE CSRLIN, ISS: PRINT FNCEOL$: NEXT
3340 LOCATE LYDP, LPDP: PRINT DP're-write D.P.
3350 R = LY: YD$ = "000000": RSET YD$ = STR$(YOLD): YD$ = RIGHT$(YD$, 5)
3360 READ C: FOR A = 1 TO 5
3370 B = VAL(MID$(YD$, A, 1)): READ C
3380 ON B + 1 GOSUB 4030, 4130, 4230, 4330, 4430, 4530, 4630, 4730, 4830, 4930
3390 NEXT A
3400 RESTORE 1190
3410 IF K > "" THEN XNEW = XOLD: YNEW = YOLD 'any key stops stepping
3420 OUT PORTA,0: OUT PORTC,CARD1 + STH: OUT PORTC,CARD1 + STL 'motors off
3499 RETURN
3500 '***************************
3510 'Handler for Metric display.
3520 '***************************
3530 IF XNEW = XOLD THEN 3640
3540 IF XNEW > XOLD THEN XOLD = XOLD+FS ELSE IF XNEW < XOLD THEN XOLD = XOLD-FS
3550 LOCATE LX, ISS: FOR A = 1 TO 5: LOCATE CSRLIN, ISS: PRINT FNCEOL$: NEXT
3560 LOCATE LXDP, LPDP: PRINT DP 're-write D.P.
3570 R = LX: TX = INT(XOLD*25.4) 'T is single precision & temporary value for X
3580 XD$ = "0000000": RSET XD$ = STR$(TX): XD$ = RIGHT$(XD$, 6)
3590 FOR A = 1 TO 6 'display can be 6 digits
3600 B = VAL(MID$(XD$, A, 1)): READ C
3610 ON B + 1 GOSUB 4030, 4130, 4230, 4330, 4430, 4530, 4630, 4730, 4830, 4930
3620 NEXT A
3630 RESTORE 1190
3640 IF YNEW = YOLD THEN 3799
3650 IF YNEW > YOLD THEN YOLD = YOLD+FS ELSE IF YNEW < YOLD THEN YOLD = YOLD-FS
3660 LOCATE LY, ISS: FOR A = 1 TO 5: LOCATE CSRLIN, ISS: PRINT FNCEOL$: NEXT
3670 LOCATE LYDP, LPDP: PRINT DP're-write D.P.
3680 R = LY: TY = INT(YOLD*25.4) 'temporary Y value
3690 YD$ = "0000000": RSET YD$ = STR$(TY): YD$ = RIGHT$(YD$, 6)
3700 FOR A = 1 TO 6
3710 B = VAL(MID$(YD$, A, 1)): READ C
3720 ON B + 1 GOSUB 4030, 4130, 4230, 4330, 4430, 4530, 4630, 4730, 4830, 4930
3730 NEXT A
3740 RESTORE 1190
3799 RETURN 3410
4000 '********************************************************************
4010 '4030 - 4920 draw large block digits from 0 to 9 at the location R,C.
4020 '********************************************************************
4030 'digit 0
4040 LOCATE R, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT
4050 FOR AA = 1 TO 3: LOCATE CSRLIN, C: PRINT DOB; : LOCATE CSRLIN, C + 4:           PRINT DOB: NEXT
4060 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT
4099 RETURN
4120 'digit 1
4130 LOCATE R, C + 1: PRINT DOB; DOB
4140 FOR AA = 1 TO 3: LOCATE CSRLIN, C + 1: PRINT DOB; DOB: NEXT
4150 LOCATE CSRLIN, C + 1: PRINT DOB; DOB;
4199 RETURN
4220 'digit 2
4230 LOCATE R, C: PRINT DOBB;:FOR AA = 1 TO 4: PRINT DOB; : NEXT: PRINT DOBE
4240 LOCATE CSRLIN, C + 3: PRINT DOBB;DOB;DOBE
4250 LOCATE CSRLIN, C: PRINT DOBB;:FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT DOBE
4260 LOCATE CSRLIN, C: PRINT DOBB;DOB
4270 LOCATE CSRLIN, C: PRINT DOBB;:FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT DOBE
4299 RETURN
4320 'digit 3
4330 LOCATE R, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT DOBE
4340 LOCATE CSRLIN, C + 4: PRINT DOB;DOBE
4350 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT DOBE
4360 LOCATE CSRLIN, C + 4: PRINT DOB;DOBE
4370 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT DOBE
4399 RETURN
4420 'digit 4
4430 LOCATE R, C: PRINT DOB; DOB: LOCATE CSRLIN, C: PRINT DOB; DOB
4440 LOCATE CSRLIN, C: PRINT DOB; DOB; SPC(2); DOB
4450 LOCATE CSRLIN, C: FOR AA = 1 TO 6: PRINT DOB; : NEXT: PRINT
4460 LOCATE CSRLIN, C + 4: PRINT DOB;
4499 RETURN
4520 'digit 5
4530 LOCATE R, C: PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB; : NEXT: PRINT DOBE
4540 LOCATE CSRLIN, C: PRINT DOBB;DOB
4550 LOCATE CSRLIN, C: PRINT DOBB;:FOR AA = 1 TO 4:PRINT DOB;: NEXT: PRINT DOBE
4560 LOCATE CSRLIN, C + 3: PRINT DOBB;DOB;DOBE
4570 LOCATE CSRLIN, C: PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB; : NEXT: PRINT DOBE
4599 RETURN
4620 'digit 6
4630 LOCATE R, C:PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT DOBE
4640 LOCATE CSRLIN, C: PRINT DOBB;DOB
4650 LOCATE CSRLIN, C: PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT DOBE
4660 LOCATE CSRLIN, C: PRINT DOBB;DOB; SPC(2); DOB;DOBE
4670 LOCATE CSRLIN, C: PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB; : NEXT: PRINT DOBE
4699 RETURN
4720 'digit 7
4730 LOCATE R, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT
4740 FOR AA = 1 TO 3: LOCATE CSRLIN, C + 3: PRINT DOB; DOB: NEXT
4780 LOCATE CSRLIN, C + 3: PRINT DOB; DOB;
4799 RETURN
4820 'digit 8
4830 LOCATE R, C: FOR AA = 1 TO 4: PRINT DOB; : NEXT
4840 FOR AA = 1 TO 2: LOCATE CSRLIN, C: PRINT DOB; : LOCATE CSRLIN, C + 4:           PRINT DOB: NEXT
4850 LOCATE CSRLIN, C: FOR AA = 1 TO 4: PRINT DOB; : NEXT
4860 FOR AA = 1 TO 2: LOCATE CSRLIN, C: PRINT DOB; : LOCATE CSRLIN, C + 4:           PRINT DOB: NEXT
4870 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT
4899 RETURN
4920 'digit 9
4930 LOCATE R, C: FOR AA = 1 TO 4: PRINT DOB; : NEXT
4940 FOR AA = 1 TO 2: LOCATE CSRLIN, C: PRINT DOB; : LOCATE CSRLIN, C + 4:           PRINT DOB: NEXT
4950 LOCATE CSRLIN, C: FOR AA = 1 TO 4: PRINT DOB; : NEXT
4960 FOR AA = 1 TO 2: LOCATE CSRLIN, C + 4: PRINT DOB: NEXT
4970 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT
4999 RETURN
5000 '****************
5010 'Write to screen.
5020 '****************
5030 COLOR 4, 11: X = 100: Y = 25: PSET (X, Y)'Write SC to screen
5040 DRAW "u12;h12;l48;g12;d24;f12;r32;d24;l24;u12;l24;d12;f12;r48"
5050 PSET (X, Y): DRAW "l24;u12;l24;d24;r32;f12;d24;g12"
5060 PAINT (X - 20, Y - 5)'draw & fill S
5070 PSET (X + 90, Y)
5080 DRAW "u12;h12;l48;g12;d60;f12;r48;e12;u12;l24;d12;l24;u60;r24;d12;r24"
5090 PAINT (X + 80, Y - 5)'draw & fill C
5100 COLOR 14, 11
5110 LOCATE 3, 35: PRINT "Silicon Chip";
5120 LOCATE 5, 37: PRINT "X-Y Table";
5130 LOCATE LX, 10: PRINT DOB; SPC(4); DOB 'print X
5140 LOCATE CSRLIN, 11: PRINT DOB; SPC(2); DOB; SPC(8); CHR$(220); CHR$(220)'& =
5150 LOCATE CSRLIN, 12: PRINT DOB; DOB; SPC(9); CHR$(220); CHR$(220)'& =
5160 LOCATE CSRLIN, 11: PRINT DOB; SPC(2); DOB
5170 LOCATE CSRLIN, 10: PRINT DOB; SPC(4); DOB
5180 LOCATE LY, 10: PRINT DOB; SPC(4); DOB 'print Y
5190 LOCATE CSRLIN, 10: PRINT DOB; SPC(4); DOB; SPC(7); CHR$(220); CHR$(220)'& =
5200 LOCATE CSRLIN, 10: FOR A = 1 TO 6: PRINT DOB; : NEXT
5210 PRINT SPC(7); CHR$(220); CHR$(220)'& =
5220 LOCATE CSRLIN, 15: PRINT DOB
5230 LOCATE CSRLIN, 10: FOR A = 1 TO 6: PRINT DOB; : NEXT
5240 XOLD = XOLD + 1:YOLD = YOLD + 1: GOSUB 3200
5250 XOLD = XOLD + 1:YOLD = YOLD - 1: GOSUB 3200
5260 LOCATE 25, 1
5270 PRINT TAB(2); "Arrow keys X-Y direction. I or M - units.";
5280 PRINT " X-Y to set. S-Stepinc. ESC to end.";
5299 RETURN
5300 '*******************
5310 'Set stepping speed.
5320 '*******************
5330 LOCATE 22, 1: PRINT "Current stepping speed is";MDELAY;
5340 PRINT "A smaller value gives a faster step rate."
5350 INPUT; "What is the new stepping speed.";NDELAY
5360 LOCATE 22,1:PRINT FNCEOL$;: LOCATE 23,1: PRINT FNCEOL$;
5370 IF NDELAY > 0 THEN MDELAY = NDELAY
5399 RETURN
6000 '****************************
6010 'Get save position from file.
6020 '****************************
6030 OPEN "r", 1, "xyplot.fil", 44
6040 FIELD #1, 4 AS OLDX$, 4 AS OLDY$, 4 AS MAXX$, 4 AS MAXY$, 4 AS DELAY$
6050 FIELD #1,20 AS J$, 4 AS CARD1$, 4 AS CARD2$, 4 AS UNITS$, 4 AS ZFSTEP$
6055 FIELD #1, 36 AS JJ$, 4 AS ZSSTEP$, 4 AS PPORT$
6060 GET 1,1: XOLD = CVI(OLDX$): YOLD = CVI(OLDY$): PPORT = CVI(PPORT$)
6070 XMAX = CVI(MAXX$): YMAX = CVI(MAXY$): MDELAY = CVI(DELAY$)
6080 CARD1 = CVI(CARD1$): CARD2 = CVI(CARD2$): UNITS = CVI(UNITS$) '0=Imp 1=Met
6099 RETURN
6100 '**********************
6110 'Save position to file.
6120 '**********************
6130 LSET OLDX$ = MKI$(XOLD): LSET OLDY$ = MKI$(YOLD)
6140 LSET UNITS$ = MKI$(UNITS): LSET DELAY$ = MKI$(MDELAY)
6150 PUT 1,1
6160 CLOSE 1
6199 RETURN
7000 '**************
7010 'Error handler.
7020 '**************
7021 'If UNITS = 0 then Imperial selected, if UNITS = 1 then Metric
7030 IF UNITS = 0 THEN IF VAL(XPOS$) * 1000 > XMAX THEN XNEW = VAL(XPOS$):               IF XNEW > XMAX THEN XNEW = XMAX
7040 IF UNITS = 0 THEN IF VAL(YPOS$) * 1000 > YMAX THEN YNEW = VAL(YPOS$):               IF YNEW > YMAX THEN YNEW = YMAX
7050 IF UNITS THEN IF VAL(XPOS$) > XMAX THEN XNEW = VAL(XPOS$)/25.4:                  IF XNEW > XMAX THEN XNEW = XMAX
7060 IF UNITS THEN IF VAL(YPOS$) > YMAX THEN YNEW = VAL(YPOS$)/25.4:                  IF YNEW > YMAX THEN YNEW = YMAX
7099 RESUME NEXT
