1 GOTO 10
2 GOSUB 1920: LPRINT TAB(48);" Printed on ";TODAY$;" @ ";TIME$
3 LLIST: PRINT CHR$(12)
4 END
5 SAVE "c:\bas\pcbdraw",A
6 SAVE "a:\bas\pcbdraw",A
7 END
10 REM Decode & Draw Protel PBL file
20 GOSUB 1030 'Initialise
30 GOSUB 2030 'Setup opening screen
40 GOSUB 5130 'Open PBL file & check limits, re-write file
50 GOSUB 5530 'draw PCB
60 CLS
70 GOSUB 6830 'Save X & Y positions (should be 0,0)
80 GOSUB 7330 'lift pen fully
90 OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL
100     FOR PAUSE = 1 TO MDELAY: NEXT 'Turn XY motors off
110 CHDIR "\bas"
120 KILL "c:\bas\pcbdraw.tmp"
999 SYSTEM 'Quit
1000 '***********************
1010 'Initialisation routine.
1020 '***********************
1030 KEY OFF: SCREEN 9: CLS : DEFINT A-Z: DEFSTR D, E, K: DEFSNG T
1031 'All integers except D,E,K,U which are strings & T single precision
1040 ESC = CHR$(27): ENTER = CHR$(13): KSP = CHR$(32) 'Spacebar
1050 KLA = CHR$(0) + CHR$(75): KRA = CHR$(0) + CHR$(77) 'Left & right arrows
1060 KUA = CHR$(0) + CHR$(72): KDA = CHR$(0) + CHR$(80) 'Up & down arrows
1070 KHOME = CHR$(0) + CHR$(71): KEND = CHR$(0) + CHR$(79) 'Home & end
1080 DEF FNCEOL$ = STRING$(80 - POS(Q)," ")
1090 DEF FNCENTRE$ (M$) = SPACE$((79 - LEN(M$)) / 2) + M$ 'Centre text
1100 DEF FNXLOC = INSTR(A$,"X"): DEF FNYLOC = INSTR(A$,"Y"): ZERO$ = "00000"
1110 DEF FNX = ABS(XBIG-X1) + ((XSIZE/2+(PWC<XSIZE/2)*PWC) * COS(ARC * TC))
1120 DEF FNY = Y1 + ((YSIZE/2+(PCW<YSIZE/2)*PWC)*SIN(ARC * TC))
1130 PI! = 4 * ATN(1): TC = PI!/180 'Use double precision
1140 DOB = CHR$(219): DP = CHR$(223) 'Define block and decimal pt. characters
1150 DOBB = CHR$(222): DOBE = CHR$(221)
1151 'Half width lines for Beginning & End of digits 2,5,6
1160 STH = -1: STL = 0 'Strobe high and low
1170 GOSUB 6630 'Get saved values from file
1180 PORTA = PPORT: PORTB = PORTA + 1: PORTC = PORTA + 2 'Select parallel port
1190 OUT PORTA,0 'set all data lines low
1200 OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL 'card1 - IC2 O/P's low
1210 FOR PAUSE = 1 TO MDELAY: NEXT
1220 OUT PORTC, CARD2 + STH: OUT PORTC, CARD2 + STL 'card2 - IC2 O/P's low
1230 FOR PAUSE = 1 TO MDELAY: NEXT
1240 OUT PORTC,7 + STH: OUT PORTC,7 + STL 'Clock IC1a
1250 FOR PAUSE = 1 TO MDELAY: NEXT
1260 OUT PORTC,5 + STH: OUT PORTC,5 + STL 'Clock IC1b, 12V to motors
1270 FOR PAUSE = 1 TO MDELAY: NEXT
1280 OUT PORTA, 153: OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL 'Home motor
1290 FOR PAUSE = 1 TO MDELAY: NEXT
1300 OUT PORTA, 105: OUT PORTC, CARD2 + STH: OUT PORTC, CARD2 + STL 'Home motor
1310 FOR PAUSE = 1 TO MDELAY: NEXT
1320 OUT PORTA, 0: OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL 'Motors off
1330 FOR PAUSE = 1 TO MDELAY: NEXT
1340 OUT PORTC, CARD2 + STH: OUT PORTC, CARD2 + STL 'Motor off
1350 FOR PAUSE = 1 TO MDELAY: NEXT
1360 ISS = 30: IT = ISS + 8: IU = IT + 8: TH = IU + 9: TT = TH + 8: TU = TT + 8
1361 'X posit for tens ", unit ", hundred thou, ten thou, unit thou of an inch
1370 DATA 30,38,46,55,63,71
1371 'DATA is sequential sums of line 1190 as DATA statement wont accept ISS etc
1380 FS = 1 'Set feed step to 1 thou
1390 SPL(1) = 5: SPL(2) = 6: SPL(3) = 10: SPL(4) = 9 'Full plus step X-Y motors
1400 SMI(1) = 10: SMI(2) = 6: SMI(3) = 5: SMI(4) = 9 'Full minus step X-Y motors
1410 OUT PORTC,5 + STH: OUT PORTC,5 + STL 'Clock IC1b - 12V switched to motors
1420 CW(1) = 153: CW(2) = 150: CW(3) = 102: CW(4) = 105 'Plus steps Z motor
1430 CCW(1) = 102: CCW(2) = 150: CCW(3) = 153: CCW(4) = 105 'Minus steps Z motor
1440 LX = 8: LY = 14 'Row or line for X & Y large display
1450 LXDP = LX + 3: LYDP = LY + 3: LPDP = IU + 7
1451 'X & Y positions & line position for DP
1460 XNEW = XOLD: YNEW = YOLD: 'Initialise X & Y positions
1480 XSML = XMAX 'Set X minimum dimension at X limit
1490 ON ERROR GOTO 5030
1999 RETURN
2000 '****************
2010 'Write to screen.
2020 '****************
2030 COLOR 4, 11: X = 100: Y = 25: PSET (X, Y)'Write SC to screen
2040 DRAW "u12;h12;l48;g12;d24;f12;r32;d24;l24;u12;l24;d12;f12;r48"
2050 PSET (X, Y): DRAW "l24;u12;l24;d24;r32;f12;d24;g12"
2060 PAINT (X - 20, Y - 5)'draw & fill S
2070 PSET (X + 90, Y)
2080 DRAW "u12;h12;l48;g12;d60;f12;r48;e12;u12;l24;d12;l24;u60;r24;d12;r24"
2090 PAINT (X + 80, Y - 5)'draw & fill C
2100 COLOR 14, 11
2110 LOCATE 2, 35: PRINT "Silicon Chip";
2120 LOCATE 4, 35: PRINT "Draw a Protel PCB";
2130 LOCATE LX, 10: PRINT DOB; SPC(4); DOB 'print X
2140 LOCATE CSRLIN, 11: PRINT DOB; SPC(2); DOB; SPC(8); CHR$(220); CHR$(220)'& =
2150 LOCATE CSRLIN, 12: PRINT DOB; DOB; SPC(9); CHR$(220); CHR$(220)'& =
2160 LOCATE CSRLIN, 11: PRINT DOB; SPC(2); DOB
2170 LOCATE CSRLIN, 10: PRINT DOB; SPC(4); DOB
2180 LOCATE LY, 10: PRINT DOB; SPC(4); DOB 'print Y
2190 LOCATE CSRLIN, 10: PRINT DOB; SPC(4); DOB; SPC(7); CHR$(220); CHR$(220)'& =
2200 LOCATE CSRLIN, 10: FOR A = 1 TO 6: PRINT DOB; : NEXT
2210 PRINT SPC(7); CHR$(220); CHR$(220) '& =
2220 LOCATE CSRLIN, 15: PRINT DOB
2230 LOCATE CSRLIN, 10: FOR A = 1 TO 6: PRINT DOB; : NEXT
2240 XOLD = XOLD+1: YOLD = YOLD+1: GOSUB 3250 'display current X & Y value
2250 XOLD = XOLD-1: YOLD = YOLD-1: GOSUB 3250 'by changing X & Y positions
2260 LOCATE 25, 17
2299 RETURN
3000 '********************
3010 'Motor step routines.
3020 '********************
3021 '4 steps = 0.001" on 1.8 degree motors
3022 'STX = LSN, STY = MSNibble of PORTA, STP is combined byte
3030 K = INKEY$
3040 IF XNEW <> XOLD THEN FSX = 1 'determine step size
3050 IF YNEW <> YOLD THEN FSY = 1
3060 IF XNEW <> XOLD THEN IF XNEW <= XOLD-10 OR XNEW => XOLD+10 THEN FSX = 10
3070 IF YNEW <> YOLD THEN IF YNEW <= YOLD-10 OR YNEW => YOLD+10 THEN FSY = 10
3080 IF XNEW <> XOLD THEN IF XNEW <= XOLD-100 OR XNEW => XOLD+100 THEN FSX = 100
3090 IF YNEW <> YOLD THEN IF YNEW <= YOLD-100 OR YNEW => YOLD+100 THEN FSY = 100
3100 IF XNEW > XOLD THEN FOR A = 1 TO 4: STX(A) = SPL(A): NEXT '+ step
3110 IF XNEW < XOLD THEN FOR A = 1 TO 4: STX(A) = SMI(A): NEXT '- step
3120 IF YNEW > YOLD THEN FOR A = 1 TO 4: STY(A) = SPL(A): NEXT '+ step
3130 IF YNEW < YOLD THEN FOR A = 1 TO 4: STY(A) = SMI(A): NEXT '- step
3140 IF XNEW = XOLD THEN FOR A = 1 TO 4: STX(A) = 0: NEXT: FSX = 100 'no step
3150 IF YNEW = YOLD THEN FOR A = 1 TO 4: STY(A) = 0: NEXT: FSY = 100 'no step
3160 FS = ABS((FSX > FSY) * FSY + (FSY > FSX) * FSX + (FSX = FSY) * FSY)
3170    FOR A = 1 TO 4: STP(A) = STX(A) * 16 + STY(A): NEXT 'combine X & Y
3180 FOR B = 1 TO FS
3190    FOR A = 1 TO 4
3200      OUT PORTA, STP(A)
3210	  OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL'step
3220	     FOR PAUSE = 1 TO MDELAY: NEXT 'allow stepping delay
3230    NEXT A 
3240 NEXT B
3250 IF XNEW = XOLD THEN 3360 'skip to Y move if no X movement
3260 IF XNEW>XOLD THEN XOLD = XOLD + FS ELSE IF XNEW<XOLD THEN XOLD = XOLD - FS
3270 LOCATE LX,ISS: FOR A = 1 TO 5: LOCATE CSRLIN,ISS: PRINT FNCEOL$: NEXT
3280 LOCATE LXDP, LPDP: PRINT DP're-write D.P.
3290 R = LX: XD$ = "000000": RSET XD$ = STR$(XOLD): XD$ = RIGHT$(XD$, 5)
3300 READ C 
3310 FOR A = 1 TO 5
3320    B = VAL(MID$(XD$, A, 1)): READ C 'get position & write large digit
3330    ON B + 1 GOSUB 4030, 4130, 4230, 4330, 4430, 4530, 4630, 4730, 4830, 4930
3340 NEXT A
3350 RESTORE 1370
3360 IF YNEW = YOLD THEN 3470 'skip to end if no Y movement
3370 IF YNEW>YOLD THEN YOLD = YOLD + FS ELSE IF YNEW<YOLD THEN YOLD = YOLD - FS
3380 LOCATE LY, ISS: FOR A = 1 TO 5: LOCATE CSRLIN, ISS: PRINT FNCEOL$: NEXT
3390 LOCATE LYDP, LPDP: PRINT DP're-write D.P.
3400 R = LY: YD$ = "000000": RSET YD$ = STR$(YOLD): YD$ = RIGHT$(YD$, 5)
3410 READ C
3420 FOR A = 1 TO 5
3430   B = VAL(MID$(YD$, A, 1)): READ C
3440   ON B + 1 GOSUB 4030, 4130, 4230, 4330, 4430, 4530, 4630, 4730, 4830, 4930
3450 NEXT A
3460 RESTORE 1370
3470 IF K = "" THEN 3530 'continue if no keypress
3480 IF DPEN = "PD" THEN GOSUB 7230: DPEN = "PU" 'lift pen off paper
3490 CLS: LOCATE 25,1: PRINT FNCEOL$;: LOCATE 25,1: BEEP:                                 PRINT FNCENTRE$("PROGRAM ABORTED.")
3500 XNEW = 0: YNEW = 0
3510    WHILE XOLD <> XNEW OR YOLD <> YNEW: GOSUB 3030: WEND
3520 RETURN 70
3530 OUT PORTA,0: OUT PORTC, CARD1 + STH: OUT PORTC, CARD1 + STL
3540    FOR PAUSE = 1 TO MDELAY: NEXT
3599 RETURN
4000 '********************************************************************
4010 '4030 - 4920 draw large block digits from 0 to 9 at the location R,C.
4020 '********************************************************************
4030 '**digit 0**
4040 LOCATE R, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT
4050 FOR AA = 1 TO 3: LOCATE CSRLIN, C: PRINT DOB; : LOCATE CSRLIN, C + 4:           PRINT DOB: NEXT
4060 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT
4099 RETURN
4120 '**digit 1**
4130 LOCATE R, C + 1: PRINT DOB; DOB
4140 FOR AA = 1 TO 3: LOCATE CSRLIN, C + 1: PRINT DOB; DOB: NEXT
4150 LOCATE CSRLIN, C + 1: PRINT DOB; DOB;
4199 RETURN
4220 '**digit 2**
4230 LOCATE R, C: PRINT DOBB;:FOR AA = 1 TO 4: PRINT DOB; : NEXT: PRINT DOBE
4240 LOCATE CSRLIN, C + 3: PRINT DOBB;DOB;DOBE
4250 LOCATE CSRLIN, C: PRINT DOBB;:FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT DOBE
4260 LOCATE CSRLIN, C: PRINT DOBB;DOB
4270 LOCATE CSRLIN, C: PRINT DOBB;:FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT DOBE
4299 RETURN
4320 '**digit 3**
4330 LOCATE R, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT DOBE
4340 LOCATE CSRLIN, C + 4: PRINT DOB;DOBE
4350 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT DOBE
4360 LOCATE CSRLIN, C + 4: PRINT DOB;DOBE
4370 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT DOBE
4399 RETURN
4420 '**digit 4**
4430 LOCATE R, C: PRINT DOB; DOB: LOCATE CSRLIN, C: PRINT DOB; DOB
4440 LOCATE CSRLIN, C: PRINT DOB; DOB; SPC(2); DOB
4450 LOCATE CSRLIN, C: FOR AA = 1 TO 6: PRINT DOB; : NEXT: PRINT
4460 LOCATE CSRLIN, C + 4: PRINT DOB;
4499 RETURN
4520 '**digit 5**
4530 LOCATE R, C: PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB; : NEXT: PRINT DOBE
4540 LOCATE CSRLIN, C: PRINT DOBB;DOB
4550 LOCATE CSRLIN, C: PRINT DOBB;:FOR AA = 1 TO 4:PRINT DOB;: NEXT: PRINT DOBE
4560 LOCATE CSRLIN, C + 3: PRINT DOBB;DOB;DOBE
4570 LOCATE CSRLIN, C: PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB; : NEXT: PRINT DOBE
4599 RETURN
4620 '**digit 6**
4630 LOCATE R, C:PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT DOBE
4640 LOCATE CSRLIN, C: PRINT DOBB;DOB
4650 LOCATE CSRLIN, C: PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT DOBE
4660 LOCATE CSRLIN, C: PRINT DOBB;DOB; SPC(2); DOB;DOBE
4670 LOCATE CSRLIN, C: PRINT DOBB;: FOR AA = 1 TO 4: PRINT DOB; : NEXT: PRINT DOBE
4699 RETURN
4720 '**digit 7**
4730 LOCATE R, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT: PRINT
4740 FOR AA = 1 TO 3: LOCATE CSRLIN, C + 3: PRINT DOB; DOB: NEXT
4780 LOCATE CSRLIN, C + 3: PRINT DOB; DOB;
4799 RETURN
4820 '**digit 8**
4830 LOCATE R, C: FOR AA = 1 TO 4: PRINT DOB; : NEXT
4840 FOR AA = 1 TO 2: LOCATE CSRLIN, C: PRINT DOB; : LOCATE CSRLIN, C + 4:           PRINT DOB: NEXT
4850 LOCATE CSRLIN, C: FOR AA = 1 TO 4: PRINT DOB; : NEXT
4860 FOR AA = 1 TO 2: LOCATE CSRLIN, C: PRINT DOB; : LOCATE CSRLIN, C + 4:           PRINT DOB: NEXT
4870 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT
4899 RETURN
4920 '**digit 9**
4930 LOCATE R, C: FOR AA = 1 TO 4: PRINT DOB; : NEXT
4940 FOR AA = 1 TO 2: LOCATE CSRLIN, C: PRINT DOB; : LOCATE CSRLIN, C + 4:           PRINT DOB: NEXT
4950 LOCATE CSRLIN, C: FOR AA = 1 TO 4: PRINT DOB; : NEXT
4960 FOR AA = 1 TO 2: LOCATE CSRLIN, C + 4: PRINT DOB: NEXT
4970 LOCATE CSRLIN, C: FOR AA = 1 TO 5: PRINT DOB; : NEXT
4999 RETURN
5000 '**************
5010 'Error handler.
5020 '**************
5030 PLAY "mf o2 p2  l8 ggg l2 e-"
5040 LOCATE 25,1: PRINT FNCEOL$;: LOCATE 25,17
5050 PRINT FILENAME$; " was not found. Press spacebar to re-enter.";
5060 K = INPUT$(1)
5070 LOCATE 25,1: PRINT FNCEOL$;
5080 RESUME 5140
5099 RETURN 'not used
5100 '*********************************
5110 'Check Protel PBL file for limits.
5120 '*********************************
5130 CHDIR "c:\protel\traxplot"
5140 LOCATE 25,17: PRINT "What is PCB filename to draw";
5150 INPUT;"";FILENAME$: IF FILENAME$ = "" OR FILENAME$ = ESC THEN CHDIR "\bas":       GOTO 999
5160 IF INSTR(FILENAME$,".") = 0 THEN FILENAME$ = FILENAME$ + ".PBL"
5170 OPEN FILENAME$ FOR INPUT AS 2
5180 LOCATE 25,1: PRINT FNCEOL$;
5190 LOCATE 6,35: PRINT "Checking ";FILENAME$;
5195 OPEN "\bas\pcbdraw.tmp" FOR OUTPUT AS 1
5200 INPUT# 2,X$
5210    WHILE X$ <> "SP1;": INPUT #2,X$: WEND 'search for data start  
5220    INPUT# 2,X$: INPUT# 2,Y$ 'first entries
5230       IF LEFT$(X$,1) = "P" THEN  XTEMP$ = RIGHT$(X$,LEN(X$)-2)                           + LEFT$(X$,2) ELSE XTEMP$ = X$
5240       XNEW = VAL(XTEMP$): YNEW = VAL(Y$)
5245 PRINT# 1,XTEMP$;",";Y$
5250	XBIG = XNEW: YBIG = YNEW
5260 WHILE NOT EOF(2) 'read through all data to end
5270    INPUT# 2,X$: INPUT# 2,Y$
5275       IF X$ = "SP0;" THEN 5330
5280       IF LEFT$(X$,1) = "P"                                                              THEN XTEMP$ = RIGHT$(X$,LEN(X$)-2) + LEFT$(X$,2) ELSE XTEMP$ = X$
5290       XNEW = VAL(XTEMP$): YNEW = VAL(Y$)
5295         PRINT# 1,XTEMP$;",";Y$
5300            IF XNEW > XBIG THEN XBIG = XNEW
5310            IF YNEW > YBIG THEN YBIG = YNEW
5320 WEND
5330 CLOSE
5340 IF XBIG < = XMAX AND YBIG < = YMAX THEN 5399
5350 BEEP: BEEP: BEEP: CLS: LOCATE 25,1
5360 PRINT FNCENTRE$("LOCATION OUTSIDE X-Y LIMITS. PROGRAM ABORTED");
5370 RETURN 999
5399 RETURN
5500 '*********
5510 'Plot PCB.
5520 '*********
5530 LOCATE 6,35: PRINT "Drawing ";FILENAME$;"  ";
5540 GOSUB 7030 'pen partially down
5550 DPEN = "PU" 'set initial pen position, PEN is reserved word
5560 OPEN "c:\bas\pcbdraw.tmp" FOR INPUT AS 2
5570 WHILE NOT EOF(2)
5580    INPUT# 2,X$,Y$
5590    XNEW = VAL(X$): YNEW = VAL(Y$)
5600       IF RIGHT$(X$,1) < ":" THEN 5630 'not P (U or D)
5610       IF RIGHT$(X$,2) = "PU" THEN GOSUB 7230                                             ELSE IF RIGHT$(X$,2) = "PD" THEN GOSUB 7130
5620       DPEN = RIGHT$(X$,2) 'store new value
5630    WHILE XNEW <> XOLD OR YNEW <> YOLD: GOSUB 3030: WEND 'move to new X & Y
5640 WEND
5650 DPEN = "PU": GOSUB 7230 'lift pen off paper
5660 SOUND 660,5: SOUND 440,5
5670 LOCATE 6,35: PRINT "Drawing completed. Homing table.";
5680 XNEW = 0: YNEW = 0
5690    WHILE XNEW < > XOLD OR YNEW < > YOLD: GOSUB 3030: WEND
5699 RETURN
6600 '*****************************
6610 'Get saved position from file.
6620 '*****************************
6630 OPEN "r", 1, "\bas\drwsetup.fil", 48
6640 FIELD #1, 4 AS OLDX$, 4 AS OLDY$, 4 AS MAXX$, 4 AS MAXY$, 4 AS DELAY$
6650 FIELD #1,20 AS J$, 4 AS CARD1$, 4 AS CARD2$, 4 AS UNITS$, 4 AS ZFSTEP$
6660 FIELD #1, 36 AS JJ$, 4 AS ZSSTEP$, 4 AS PPORT$, 4 AS PW$
6670 GET 1,1
6680 XOLD = CVI(OLDX$): YOLD = CVI(OLDY$): PW = CVI(PW$): PWC = PW
6690 XMAX = CVI(MAXX$): YMAX = CVI(MAXY$): MDELAY = CVI(DELAY$)
6700 CARD1 = CVI(CARD1$): CARD2 = CVI(CARD2$): UNITS = CVI(UNITS$) '0=Imp 1=Met
6710 ZSF = CVI(ZFSTEP$): ZSS = CVI (ZSSTEP$): PPORT = CVI(PPORT$)
6720 CLOSE 1
6799 RETURN
6800 '**********************
6810 'Save position to file.
6820 '**********************
6830 OPEN "r", 1, "\bas\drwsetup.fil", 48
6840 FIELD #1, 4 AS OLDX$, 4 AS OLDY$, 4 AS MAXX$, 4 AS MAXY$, 4 AS DELAY$
6850 FIELD #1,20 AS J$, 4 AS CARD1$, 4 AS CARD2$, 4 AS UNITS$, 4 AS ZFSTEP$
6860 FIELD #1, 36 AS JJ$, 4 AS ZSSTEP$, 4 AS PPORT$
6870 GET 1,1: LSET OLDX$ = MKI$(XOLD): LSET OLDY$ = MKI$(YOLD)
6880 PUT 1,1
6890 CLOSE
6899 RETURN
7000 '*******************
7010 'Pen partially down.
7020 '*******************
7030 FOR A = 1 TO ZSF 'pen down ZSFast steps
7040    FOR B = 1 TO 4 '
7050      OUT PORTA,CW(B): OUT PORTC,CARD2 + STH: OUT PORTC,CARD2 + STL
7060         FOR PAUSE = 1 TO MDELAY * 4: NEXT
7070    NEXT B
7080 NEXT A
7099 RETURN
7100 '***************
7110 'Pen fully down.
7120 '***************
7130 FOR A = 1 TO ZSS 'pen down slow steps
7140    FOR B = 1 TO 4 '
7150      OUT PORTA,CW(B): OUT PORTC,CARD2 + STH: OUT PORTC,CARD2 + STL
7160         FOR PAUSE = 1 TO MDELAY * 4: NEXT
7170    NEXT B
7180 NEXT A
7199 RETURN
7200 '*****************
7210 'Pen partially up.
7220 '*****************
7230 FOR A = 1 TO ZSS 'pen up ZSSlow steps
7240    FOR B = 1 TO 4 '
7250      OUT PORTA,CCW(B): OUT PORTC,CARD2 + STH: OUT PORTC,CARD2 + STL
7260         FOR PAUSE = 1 TO MDELAY * 4: NEXT
7270    NEXT B
7280 NEXT A
7299 RETURN
7300 '*************
7310 'Pen fully up.
7320 '*************
7330 FOR A = 1 TO ZSF 'pen fully up ZSFast steps
7340    FOR B = 1 TO 4 '
7350      OUT PORTA,CCW(B): OUT PORTC,CARD2 + STH: OUT PORTC,CARD2 + STL
7360         FOR PAUSE = 1 TO MDELAY * 4: NEXT
7370    NEXT B
7380 NEXT A
7390 OUT PORTA,0: OUT PORTC,CARD2 + STH: OUT PORTC,CARD2 + STL 'motor off
7400    FOR PAUSE = 1 TO MDELAY * 2: NEXT
7499 RETURN
