#line 1 "D:/DESIGN/SPECTRUM_ANALYZER_V3/spectrum_analyzer.c"









sbit GLCD_D0 at RB4_bit;
sbit GLCD_D1 at RB5_bit;
sbit GLCD_D2 at RB6_bit;
sbit GLCD_D3 at RB7_bit;
sbit GLCD_D4 at RB8_bit;
sbit GLCD_D5 at RC13_bit;
sbit GLCD_D6 at RC14_bit;
sbit GLCD_D7 at RA11_bit;
sbit GLCD_D0_Direction at TRISB4_bit;
sbit GLCD_D1_Direction at TRISB5_bit;
sbit GLCD_D2_Direction at TRISB6_bit;
sbit GLCD_D3_Direction at TRISB7_bit;
sbit GLCD_D4_Direction at TRISB8_bit;
sbit GLCD_D5_Direction at TRISC13_bit;
sbit GLCD_D6_Direction at TRISC14_bit;
sbit GLCD_D7_Direction at TRISA11_bit;


sbit GLCD_CS2 at LATD9_bit;
sbit GLCD_CS1 at LATD3_bit;
sbit GLCD_RS at LATB1_bit;
sbit GLCD_RW at LATB2_bit;
sbit GLCD_EN at LATB3_bit;
sbit GLCD_RST at LATD2_bit;

sbit GLCD_CS2_Direction at TRISD9_bit;
sbit GLCD_CS1_Direction at TRISD3_bit;
sbit GLCD_RS_Direction at TRISB1_bit;
sbit GLCD_RW_Direction at TRISB2_bit;
sbit GLCD_EN_Direction at TRISB3_bit;
sbit GLCD_RST_Direction at TRISD2_bit;

void SampleInput(void);

char Dodraw=0;



 const unsigned long NUM_OF_SAMPLES = 256;
 const unsigned long SAMPLE_FREQ = 38400;




 ydata int Samples[512];

 unsigned int freq;
 char txt[7];
 unsigned int Written[256];
 int sample_counter=0;






void OscillatorFailTrap() org 0x06 {
 trisf = 0;
 asm{
 MOV [w15-34], w13
 LSR w13, #8, w13
 MOV w13, LATF
 ;LSR w15, #8, w13
 ;MOV w13, LATB

 }
 while(1);
}

void AddressTrap() org 0x08 {
 trisd = 0;
 asm{
 MOV [w15-34], w13
 ;LSR w13, #8, w13
 MOV w13, LATd
 }
 while(1);
}

void StackErrorTrap() org 0x0A {
trisf = 0;
 asm{
 MOV [w15-34], w13
 LSR w13, #8, w13
 MOV w13, LATF
 ;LSR w15, #8, w13
 ;MOV w13, LATB

 } while(1);
}

void MathErrorTrap() org 0x0C {
 trisf = 0;
 asm{
 MOV [w15-34], w13
 LSR w13, #8, w13
 MOV w13, LATF
 ;LSR w15, #8, w13
 ;MOV w13, LATB

 }
 while(1);
}

void InitTimer1(){
 T1CON = 0x8000;
 T1IE_bit = 1;
 T1IF_bit = 0;
 IPC0 = IPC0 | 0x1000;
 PR1 = 130;

}

void Timer1Interrupt() iv IVT_ADDR_T1INTERRUPT{
 T1IF_bit = 0;
 SampleInput();
}




void InitAdc() {

 ADPCFG = 0xFFFE;
 TRISB0_bit = 1;

 ADCHS = 0;
 ADCON2 = 0;
 ADCON1 = 0x83E0;
 ADCON2 = 0x0000;
 ADCON3 = 0x0113;
 ADCHS = 0x0000;
 ADCSSL = 0;




}




void InitGlcd() {



 Glcd_Init();

 Glcd_Fill(0xAA);

 Delay_ms(500);
 Glcd_Fill(0x00);
 Glcd_Rectangle(0, 0, 127, 63, 1);
}


void MainInit() {

 UART2_Init(9600);

 TRISF = 0;
 LATF = 0;

 InitAdc();
 InitGlcd();
 InitTimer1();


 Vector_Set(Written,255, 0xFFFF);
 Glcd_Write_Text(" Hz", 100, 1, 1);
}




float Fract2Float(int input) {

 return (input /4096.0);
}







void WriteData() {

 unsigned int Re, Im, tmpw,max;

 float Rer, Imr, tmpR;
 unsigned int k,l,j;

 j = 0;
 k = 0;
 max = 0;
 freq = 0;

 while (k <= 63) {
 Re = Samples[j++];

 Im = Samples[j++];

 Rer = Fract2Float(Re);
 Imr = Fract2Float(Im);

 tmpR = Rer * Rer;
 Rer = tmpR;
 tmpR = Imr * Imr;
 Imr = tmpR;
 tmpR = sqrt(Rer + Imr);
 Rer = tmpR * 256.0;


 Re = Rer;

 if (Re > 63)
 if(k != 0)

 Re = Written[k-1];
 else
 Re = 0;

 if (Re >max) {
 max = Re;
 freq = k;
 }

 tmpw = Written[k];
 if (tmpw != Re) {
 l =63 - tmpw;
 if(l==0) l=1;
 while (l <= 63) {
 Glcd_Dot(k+1, l, 0);
 l++;
 }

 l = 63 - Re;
 if(l==0) l=1;
 while (l <= 63) {
 Glcd_Dot(k+1,l,1);
 l++;
 }
 Written[k] = Re;
 }
 k++;
 }


 freq *= 300;
 WordToStr(freq, txt);
 Glcd_Write_Text(txt, 70, 1, 1);

}



unsigned ReadAdc() {
 LATF = ~ PORTF;
 ADCON1.F1 = 1;
 while (ADCON1.F0 == 0){
 asm nop;}
 return ADCBUF0;
}



void SampleInput() {



 Samples[sample_counter++] = (ReadAdc()-2048)*2;
 Samples[sample_counter++] = 0;
 if (sample_counter > 511)
 { sample_counter = 0;
 DoDraw = 1;
 T1IE_bit = 0;

 }

}



void main() {

 MainInit();
 while (1) {


 if(DoDraw)
 {


 FFT(8, TwiddleCoeff_256,Samples);



 BitReverseComplex(8, Samples);


 WriteData();
 DoDraw=0;
 T1IE_bit = 1;
 }
 }


}
