//#include "Glcd_Fonts.h"

// Audio Spectrum Analyzer
// Author: Noel A. Rios
//Processor: DSPIC30F4013
// Crystal: 10Mhz 8X PLL


// Glcd module connections                                                                                                           lp1
sbit GLCD_D0 at RB4_bit;          //sbit GLCD_D7 at RD3_bit
sbit GLCD_D1 at RB5_bit;
sbit GLCD_D2 at RB6_bit;
sbit GLCD_D3 at RB7_bit;
sbit GLCD_D4 at RB8_bit;
sbit GLCD_D5 at RC13_bit;
sbit GLCD_D6 at RC14_bit;
sbit GLCD_D7 at RA11_bit;
sbit GLCD_D0_Direction at TRISB4_bit;
sbit GLCD_D1_Direction at TRISB5_bit;
sbit GLCD_D2_Direction at TRISB6_bit;
sbit GLCD_D3_Direction at TRISB7_bit;
sbit GLCD_D4_Direction at TRISB8_bit;
sbit GLCD_D5_Direction at TRISC13_bit;
sbit GLCD_D6_Direction at TRISC14_bit;
sbit GLCD_D7_Direction at TRISA11_bit;


sbit GLCD_CS2 at LATD9_bit;
sbit GLCD_CS1   at LATD3_bit;
sbit GLCD_RS  at LATB1_bit;
sbit GLCD_RW  at LATB2_bit;
sbit GLCD_EN  at LATB3_bit;
sbit GLCD_RST at LATD2_bit;

sbit GLCD_CS2_Direction at TRISD9_bit;              //Switch according to GLCD
sbit GLCD_CS1_Direction at TRISD3_bit;
sbit GLCD_RS_Direction  at TRISB1_bit;
sbit GLCD_RW_Direction  at TRISB2_bit;
sbit GLCD_EN_Direction  at TRISB3_bit;
sbit GLCD_RST_Direction at TRISD2_bit;

void SampleInput(void);

char Dodraw=0;

// End Glcd module connections

  const unsigned long NUM_OF_SAMPLES = 256;// 256 pairs of [Re, Im] values
  const unsigned long SAMPLE_FREQ  = 38400;// kHz


  
  
  ydata int Samples[512]; //absolute 0x0C00;  // Y data space for P30F4013- required by FFT routine
                                           // See datasheet for your dsPIC to see Y data space limits.
  unsigned int freq;                           // Auxiliary variables
  char txt[7];
  unsigned int Written[256];
  int sample_counter=0;                                //64




// The following trap procedures are not really needed here, they
//   are used here just for the sake of demonstration.
void OscillatorFailTrap() org 0x06 { // if oscillator fails, the code jumps here
  trisf = 0;
    asm{
    MOV [w15-34], w13
    LSR  w13, #8, w13
    MOV w13, LATF
    ;LSR  w15, #8, w13
    ;MOV w13, LATB

  }
  while(1);
}

void AddressTrap() org 0x08 {  // if the addressing mode is wrong, the code jumps here
    trisd = 0;
    asm{
    MOV [w15-34], w13
    ;LSR  w13, #8, w13
    MOV w13, LATd
  }
  while(1);
}

void StackErrorTrap() org 0x0A { // stack overflow, underflow...
trisf = 0;
    asm{
    MOV [w15-34], w13
    LSR  w13, #8, w13
    MOV w13, LATF
    ;LSR  w15, #8, w13
    ;MOV w13, LATB

  }  while(1);
}

void MathErrorTrap() org 0x0C { // div by zero etc...
  trisf = 0;
    asm{
    MOV [w15-34], w13
    LSR  w13, #8, w13
    MOV w13, LATF
    ;LSR  w15, #8, w13
    ;MOV w13, LATB

  }
  while(1);
}

void InitTimer1(){
  T1CON         = 0x8000;
  T1IE_bit         = 1;
  T1IF_bit         = 0;
  IPC0                 = IPC0 | 0x1000;
  PR1                 = 130; //38400 //125;        //250 20Khz,  125 40Khz sampling rate

}

void Timer1Interrupt() iv IVT_ADDR_T1INTERRUPT{
  T1IF_bit         = 0;
  SampleInput();
}



//-------------- Initialization of AD converter
void InitAdc() {

  ADPCFG = 0xFFFE;//PORTB 0 as input pin
  TRISB0_bit = 1;    // RB0 as input pin

  ADCHS  = 0;      //  Connect RBxx/ANxx as CH0 input. RB0 is input pin
  ADCON2 = 0;      //
  ADCON1 = 0x83E0; // turn ADC ON, internal, counter ends conversion  current
  ADCON2  = 0x0000;
  ADCON3  = 0x0113;                     //0x0113
  ADCHS   = 0x0000;                      // Sample input on RB8
  ADCSSL  = 0;                           // No input scan




}//~



//-------------- Initialize GLCD for EASYdsPIC4 board
void InitGlcd() {

  
  
  Glcd_Init();
  //Glcd_Set_Font(FontSystem5x8, 5, 8, 32);
  Glcd_Fill(0xAA); // Show stripes on GLCD to signalize startup

  Delay_ms(500);   // Wait for a while
  Glcd_Fill(0x00); // Clear screen
  Glcd_Rectangle(0, 0, 127, 63, 1);
}//~

//-------------- Main Initialization
void MainInit() {

  UART2_Init(9600);
  
  TRISF = 0;
  LATF  = 0;

  InitAdc();
  InitGlcd();
  InitTimer1();
  
 //Twiddle_Factors_Init();
  Vector_Set(Written,255, 0xFFFF);  // Fill "Written" with $FFFF
  Glcd_Write_Text(" Hz", 100, 1, 1);
}//~


//-------------- Auxiliary function for converting 1.15 radix point to
//               IEEE floating point variable (needed for sqrt).
float Fract2Float(int input) {

   return (input /4096.0);
}//~


//-------------- Data output procedure. It draws FFT components on GLCD.
//               GLCD coordinate system starts at top left corner. Therefore,
//               line drawing had to be modified in order to achieve
//               a viewable spectrum on screen.
//               "Samples" at this moment contains DFT of the signal in the manner Re, Im, Re, Im...
void WriteData() {

  unsigned int Re, Im, tmpw,max;

  float    Rer, Imr, tmpR;
  unsigned int k,l,j;                  //short

  j      = 0; //0;                      // If you want to skip DC component then make j >= 1
  k      = 0;
  max    = 0;
  freq = 0;                        // Reset current max. frequency for new reading

  while (k <= 63) {                //63
      Re = Samples[j++];           // Real part of DFT sample

      Im = Samples[j++];           // Imaginary part of DFT sample

      Rer = Fract2Float(Re);       // conversion to IEEE floating point
      Imr = Fract2Float(Im);       // conversion to IEEE floating point

      tmpR = Rer * Rer;            // Re^2
      Rer  = tmpR;
      tmpR = Imr * Imr;            // Im^2
      Imr  = tmpR;
      tmpR = sqrt(Rer + Imr);      // Amplitude of current DFT sample
      Rer  = tmpR * 256.0;          // DFT is scaled down by 1/N, we need to
                                   //   take it back in order to have visible
                                   //   components on GLCD
      Re = Rer;

      if (Re > 63)               //63)
        if(k != 0)
          //--- NOTE: rejecting values for k=0 removes strong DC component
          Re = Written[k-1];       // k = 0? beware of the glitch
        else
          Re = 0;

      if (Re >max) {               //>=
          max = Re;
          freq = k;                // This should be the center frequency of the signal
      }

      tmpw = Written[k];
      if (tmpw != Re) {            // Draw only those components that changed
          l =63 - tmpw;                      //64 - tmpw;           // 64 lines on GLCD on Y axis
          if(l==0) l=1;
          while (l <= 63) {        // Clear line to the bottom of the screen
             Glcd_Dot(k+1, l, 0);
             l++;
          }

           l = 63 - Re;           // 64 Draw line to the bottom of the screen
           if(l==0) l=1;
           while (l <= 63) {
               Glcd_Dot(k+1,l,1);     //Glcd_Dot(k, l, 1)
               l++;
           }
           Written[k] = Re;       // Mark that the current sample has been drawn
      }
      k++;                      // Move current X coordinate
   }

   //--- Write the frequency of max. amplitude sample
   freq *= 300;            //38400/128
   WordToStr(freq, txt);
   Glcd_Write_Text(txt, 70, 1, 1);    //formerly 70

}//~


//-------------- Takes current sample
unsigned ReadAdc() {
  LATF = ~ PORTF;                   // Add Pin to monitor sampling Rate!!!
  ADCON1.F1 = 1;                    // Start AD conversion
  while (ADCON1.F0 == 0){            // Wait for ADC to finish
    asm nop;}
  return ADCBUF0;                   // Get ADC value
}//~


//-------------- Fills "Samples" with input samples in manner Re, Im, Re, Im... where Im = 0
void SampleInput() {



   Samples[sample_counter++] = (ReadAdc()-2048)*2;   // Re
   Samples[sample_counter++] = 0;            // Im
   if (sample_counter > 511)                 //511
     {   sample_counter = 0;
           DoDraw = 1;
           T1IE_bit         = 0;      //Disable interrupt

     }
  // "Samples" now contains 128 pairs of <Re, Im> samples
}//~


//-------------- Main program starts here
void main() {

  MainInit();                     // Initialize all
  while (1) {                     // Infinite loop
      //SampleInput();              // Sample input signal
                                  //Add Timer Interrupt to set sampling Frequency
       if(DoDraw)
       {
      // Perform FFT (DFT), 7 stages, 128 samples of complex pairs
      // Twiddle factors are taken from the <TwiddleFactors.dpas> unit
      FFT(8, TwiddleCoeff_256,Samples);

      // DFT butterfly algorythm bit-reverses output samples.
      // We have to restore them in natural order.
      BitReverseComplex(8, Samples);

      // Draw DFT samples on GLCD
      WriteData();
      DoDraw=0;
      T1IE_bit         = 1;             //enable interrupt for sampling
    }
    }
  
  
}//~!