
_OscillatorFailTrap:
	PUSH	52
	PUSH	RCOUNT
	PUSH	W0
	MOV	#2, W0
	REPEAT	#12
	PUSH	[W0++]

;spectrum_analyzer.c,66 :: 		void OscillatorFailTrap() org 0x06 { // if oscillator fails, the code jumps here
;spectrum_analyzer.c,67 :: 		trisf = 0;
	CLR	TRISF
;spectrum_analyzer.c,69 :: 		MOV [w15-34], w13
	MOV	[W15-34], W13
;spectrum_analyzer.c,70 :: 		LSR  w13, #8, w13
	LSR	W13, #8, W13
;spectrum_analyzer.c,71 :: 		MOV w13, LATF
	MOV	W13, LATF
;spectrum_analyzer.c,76 :: 		while(1);
L_OscillatorFailTrap0:
	GOTO	L_OscillatorFailTrap0
;spectrum_analyzer.c,77 :: 		}
L_end_OscillatorFailTrap:
	MOV	#26, W0
	REPEAT	#12
	POP	[W0--]
	POP	W0
	POP	RCOUNT
	POP	52
	RETFIE
; end of _OscillatorFailTrap

_AddressTrap:
	PUSH	52
	PUSH	RCOUNT
	PUSH	W0
	MOV	#2, W0
	REPEAT	#12
	PUSH	[W0++]

;spectrum_analyzer.c,79 :: 		void AddressTrap() org 0x08 {  // if the addressing mode is wrong, the code jumps here
;spectrum_analyzer.c,80 :: 		trisd = 0;
	CLR	TRISD
;spectrum_analyzer.c,82 :: 		MOV [w15-34], w13
	MOV	[W15-34], W13
;spectrum_analyzer.c,84 :: 		MOV w13, LATd
	MOV	W13, LATD
;spectrum_analyzer.c,86 :: 		while(1);
L_AddressTrap2:
	GOTO	L_AddressTrap2
;spectrum_analyzer.c,87 :: 		}
L_end_AddressTrap:
	MOV	#26, W0
	REPEAT	#12
	POP	[W0--]
	POP	W0
	POP	RCOUNT
	POP	52
	RETFIE
; end of _AddressTrap

_StackErrorTrap:
	PUSH	52
	PUSH	RCOUNT
	PUSH	W0
	MOV	#2, W0
	REPEAT	#12
	PUSH	[W0++]

;spectrum_analyzer.c,89 :: 		void StackErrorTrap() org 0x0A { // stack overflow, underflow...
;spectrum_analyzer.c,90 :: 		trisf = 0;
	CLR	TRISF
;spectrum_analyzer.c,92 :: 		MOV [w15-34], w13
	MOV	[W15-34], W13
;spectrum_analyzer.c,93 :: 		LSR  w13, #8, w13
	LSR	W13, #8, W13
;spectrum_analyzer.c,94 :: 		MOV w13, LATF
	MOV	W13, LATF
;spectrum_analyzer.c,98 :: 		}  while(1);
L_StackErrorTrap4:
	GOTO	L_StackErrorTrap4
;spectrum_analyzer.c,99 :: 		}
L_end_StackErrorTrap:
	MOV	#26, W0
	REPEAT	#12
	POP	[W0--]
	POP	W0
	POP	RCOUNT
	POP	52
	RETFIE
; end of _StackErrorTrap

_MathErrorTrap:
	PUSH	52
	PUSH	RCOUNT
	PUSH	W0
	MOV	#2, W0
	REPEAT	#12
	PUSH	[W0++]

;spectrum_analyzer.c,101 :: 		void MathErrorTrap() org 0x0C { // div by zero etc...
;spectrum_analyzer.c,102 :: 		trisf = 0;
	CLR	TRISF
;spectrum_analyzer.c,104 :: 		MOV [w15-34], w13
	MOV	[W15-34], W13
;spectrum_analyzer.c,105 :: 		LSR  w13, #8, w13
	LSR	W13, #8, W13
;spectrum_analyzer.c,106 :: 		MOV w13, LATF
	MOV	W13, LATF
;spectrum_analyzer.c,111 :: 		while(1);
L_MathErrorTrap6:
	GOTO	L_MathErrorTrap6
;spectrum_analyzer.c,112 :: 		}
L_end_MathErrorTrap:
	MOV	#26, W0
	REPEAT	#12
	POP	[W0--]
	POP	W0
	POP	RCOUNT
	POP	52
	RETFIE
; end of _MathErrorTrap

_InitTimer1:

;spectrum_analyzer.c,114 :: 		void InitTimer1(){
;spectrum_analyzer.c,115 :: 		T1CON         = 0x8000;
	MOV	#32768, W0
	MOV	WREG, T1CON
;spectrum_analyzer.c,116 :: 		T1IE_bit         = 1;
	BSET	T1IE_bit, BitPos(T1IE_bit+0)
;spectrum_analyzer.c,117 :: 		T1IF_bit         = 0;
	BCLR	T1IF_bit, BitPos(T1IF_bit+0)
;spectrum_analyzer.c,118 :: 		IPC0                 = IPC0 | 0x1000;
	MOV	#4096, W1
	MOV	#lo_addr(IPC0), W0
	IOR	W1, [W0], [W0]
;spectrum_analyzer.c,119 :: 		PR1                 = 130; //38400 //125;        //250 20Khz,  125 40Khz sampling rate
	MOV	#130, W0
	MOV	WREG, PR1
;spectrum_analyzer.c,121 :: 		}
L_end_InitTimer1:
	RETURN
; end of _InitTimer1

_Timer1Interrupt:
	PUSH	52
	PUSH	RCOUNT
	PUSH	W0
	MOV	#2, W0
	REPEAT	#12
	PUSH	[W0++]

;spectrum_analyzer.c,123 :: 		void Timer1Interrupt() iv IVT_ADDR_T1INTERRUPT{
;spectrum_analyzer.c,124 :: 		T1IF_bit         = 0;
	BCLR	T1IF_bit, BitPos(T1IF_bit+0)
;spectrum_analyzer.c,125 :: 		SampleInput();
	CALL	_SampleInput
;spectrum_analyzer.c,126 :: 		}
L_end_Timer1Interrupt:
	MOV	#26, W0
	REPEAT	#12
	POP	[W0--]
	POP	W0
	POP	RCOUNT
	POP	52
	RETFIE
; end of _Timer1Interrupt

_InitAdc:

;spectrum_analyzer.c,131 :: 		void InitAdc() {
;spectrum_analyzer.c,133 :: 		ADPCFG = 0xFFFE;//PORTB 0 as input pin
	MOV	#65534, W0
	MOV	WREG, ADPCFG
;spectrum_analyzer.c,134 :: 		TRISB0_bit = 1;    // RB0 as input pin
	BSET	TRISB0_bit, BitPos(TRISB0_bit+0)
;spectrum_analyzer.c,136 :: 		ADCHS  = 0;      //  Connect RBxx/ANxx as CH0 input. RB0 is input pin
	CLR	ADCHS
;spectrum_analyzer.c,137 :: 		ADCON2 = 0;      //
	CLR	ADCON2
;spectrum_analyzer.c,138 :: 		ADCON1 = 0x83E0; // turn ADC ON, internal, counter ends conversion  current
	MOV	#33760, W0
	MOV	WREG, ADCON1
;spectrum_analyzer.c,139 :: 		ADCON2  = 0x0000;
	CLR	ADCON2
;spectrum_analyzer.c,140 :: 		ADCON3  = 0x0113;                     //0x0113
	MOV	#275, W0
	MOV	WREG, ADCON3
;spectrum_analyzer.c,141 :: 		ADCHS   = 0x0000;                      // Sample input on RB8
	CLR	ADCHS
;spectrum_analyzer.c,142 :: 		ADCSSL  = 0;                           // No input scan
	CLR	ADCSSL
;spectrum_analyzer.c,147 :: 		}//~
L_end_InitAdc:
	RETURN
; end of _InitAdc

_InitGlcd:

;spectrum_analyzer.c,152 :: 		void InitGlcd() {
;spectrum_analyzer.c,156 :: 		Glcd_Init();
	PUSH	W10
	PUSH	W11
	PUSH	W12
	PUSH	W13
	CALL	_Glcd_Init
;spectrum_analyzer.c,158 :: 		Glcd_Fill(0xAA); // Show stripes on GLCD to signalize startup
	MOV.B	#170, W10
	CALL	_Glcd_Fill
;spectrum_analyzer.c,160 :: 		Delay_ms(500);   // Wait for a while
	MOV	#51, W8
	MOV	#56549, W7
L_InitGlcd8:
	DEC	W7
	BRA NZ	L_InitGlcd8
	DEC	W8
	BRA NZ	L_InitGlcd8
;spectrum_analyzer.c,161 :: 		Glcd_Fill(0x00); // Clear screen
	CLR	W10
	CALL	_Glcd_Fill
;spectrum_analyzer.c,162 :: 		Glcd_Rectangle(0, 0, 127, 63, 1);
	MOV.B	#63, W13
	MOV.B	#127, W12
	CLR	W11
	CLR	W10
	MOV	#1, W0
	PUSH	W0
	CALL	_Glcd_Rectangle
	SUB	#2, W15
;spectrum_analyzer.c,163 :: 		}//~
L_end_InitGlcd:
	POP	W13
	POP	W12
	POP	W11
	POP	W10
	RETURN
; end of _InitGlcd

_MainInit:

;spectrum_analyzer.c,166 :: 		void MainInit() {
;spectrum_analyzer.c,168 :: 		UART2_Init(9600);
	PUSH	W10
	PUSH	W11
	PUSH	W12
	PUSH	W13
	MOV	#9600, W10
	MOV	#0, W11
	CALL	_UART2_Init
;spectrum_analyzer.c,170 :: 		TRISF = 0;
	CLR	TRISF
;spectrum_analyzer.c,171 :: 		LATF  = 0;
	CLR	LATF
;spectrum_analyzer.c,173 :: 		InitAdc();
	CALL	_InitAdc
;spectrum_analyzer.c,174 :: 		InitGlcd();
	CALL	_InitGlcd
;spectrum_analyzer.c,175 :: 		InitTimer1();
	CALL	_InitTimer1
;spectrum_analyzer.c,178 :: 		Vector_Set(Written,255, 0xFFFF);  // Fill "Written" with $FFFF
	MOV	#65535, W0
	PUSH	W0
	MOV	#255, W0
	PUSH	W0
	MOV	#lo_addr(_Written), W0
	PUSH	W0
	CALL	_Vector_Set
	SUB	#6, W15
;spectrum_analyzer.c,179 :: 		Glcd_Write_Text(" Hz", 100, 1, 1);
	MOV.B	#1, W13
	MOV.B	#1, W12
	MOV.B	#100, W11
	MOV	#lo_addr(?lstr1_spectrum_analyzer), W10
	CALL	_Glcd_Write_Text
;spectrum_analyzer.c,180 :: 		}//~
L_end_MainInit:
	POP	W13
	POP	W12
	POP	W11
	POP	W10
	RETURN
; end of _MainInit

_Fract2Float:

;spectrum_analyzer.c,185 :: 		float Fract2Float(int input) {
;spectrum_analyzer.c,187 :: 		return (input /4096.0);
	MOV	W10, W0
	ASR	W0, #15, W1
	SETM	W2
	CALL	__Long2Float
	MOV	#0, W2
	MOV	#17792, W3
	CALL	__Div_FP
;spectrum_analyzer.c,188 :: 		}//~
L_end_Fract2Float:
	RETURN
; end of _Fract2Float

_WriteData:
	LNK	#14

;spectrum_analyzer.c,196 :: 		void WriteData() {
;spectrum_analyzer.c,203 :: 		j      = 0; //0;                      // If you want to skip DC component then make j >= 1
	PUSH	W10
	PUSH	W11
	PUSH	W12
	PUSH	W13
	CLR	W0
	MOV	W0, [W14+12]
;spectrum_analyzer.c,204 :: 		k      = 0;
	CLR	W0
	MOV	W0, [W14+8]
;spectrum_analyzer.c,205 :: 		max    = 0;
	CLR	W0
	MOV	W0, [W14+2]
;spectrum_analyzer.c,206 :: 		freq = 0;                        // Reset current max. frequency for new reading
	CLR	W0
	MOV	W0, _freq
;spectrum_analyzer.c,208 :: 		while (k <= 63) {                //63
L_WriteData10:
	MOV	#63, W1
	ADD	W14, #8, W0
	CP	W1, [W0]
	BRA GEU	L__WriteData41
	GOTO	L_WriteData11
L__WriteData41:
;spectrum_analyzer.c,209 :: 		Re = Samples[j++];           // Real part of DFT sample
	MOV	[W14+12], W0
	SL	W0, #1, W1
	MOV	#lo_addr(_Samples), W0
	ADD	W0, W1, W3
	MOV	[W14+12], W0
	ADD	W0, #1, W2
;spectrum_analyzer.c,211 :: 		Im = Samples[j++];           // Imaginary part of DFT sample
	SL	W2, #1, W1
	MOV	#lo_addr(_Samples), W0
	ADD	W0, W1, W0
	MOV	[W0], W0
	MOV	W0, [W14+0]
	ADD	W14, #12, W0
	ADD	W2, #1, [W0]
;spectrum_analyzer.c,213 :: 		Rer = Fract2Float(Re);       // conversion to IEEE floating point
	MOV	[W3], W10
	CALL	_Fract2Float
	MOV	W0, [W14+4]
	MOV	W1, [W14+6]
;spectrum_analyzer.c,214 :: 		Imr = Fract2Float(Im);       // conversion to IEEE floating point
	MOV	[W14+0], W10
	CALL	_Fract2Float
; Imr start address is: 4 (W2)
	MOV.D	W0, W2
;spectrum_analyzer.c,216 :: 		tmpR = Rer * Rer;            // Re^2
	PUSH.D	W2
	MOV	[W14+4], W0
	MOV	[W14+6], W1
	MOV	[W14+4], W2
	MOV	[W14+6], W3
	CALL	__Mul_FP
	POP.D	W2
;spectrum_analyzer.c,217 :: 		Rer  = tmpR;
	MOV	W0, [W14+4]
	MOV	W1, [W14+6]
;spectrum_analyzer.c,218 :: 		tmpR = Imr * Imr;            // Im^2
	MOV.D	W2, W0
	CALL	__Mul_FP
; Imr end address is: 4 (W2)
;spectrum_analyzer.c,220 :: 		tmpR = sqrt(Rer + Imr);      // Amplitude of current DFT sample
	MOV	[W14+4], W2
	MOV	[W14+6], W3
	CALL	__AddSub_FP
	MOV.D	W0, W10
	CALL	_sqrt
;spectrum_analyzer.c,221 :: 		Rer  = tmpR * 256.0;          // DFT is scaled down by 1/N, we need to
	MOV	#0, W2
	MOV	#17280, W3
	CALL	__Mul_FP
;spectrum_analyzer.c,224 :: 		Re = Rer;
	CALL	__Float2Longint
; Re start address is: 6 (W3)
	MOV	W0, W3
;spectrum_analyzer.c,226 :: 		if (Re > 63)               //63)
	MOV	#63, W1
	CP	W0, W1
	BRA GTU	L__WriteData42
	GOTO	L__WriteData29
L__WriteData42:
; Re end address is: 6 (W3)
;spectrum_analyzer.c,227 :: 		if(k != 0)
	MOV	[W14+8], W0
	CP	W0, #0
	BRA NZ	L__WriteData43
	GOTO	L_WriteData13
L__WriteData43:
;spectrum_analyzer.c,229 :: 		Re = Written[k-1];       // k = 0? beware of the glitch
	MOV	[W14+8], W0
	DEC	W0
	SL	W0, #1, W1
	MOV	#lo_addr(_Written), W0
	ADD	W0, W1, W0
; Re start address is: 6 (W3)
	MOV	[W0], W3
; Re end address is: 6 (W3)
	GOTO	L_WriteData14
L_WriteData13:
;spectrum_analyzer.c,231 :: 		Re = 0;
; Re start address is: 6 (W3)
	CLR	W3
; Re end address is: 6 (W3)
L_WriteData14:
; Re start address is: 6 (W3)
	MOV	W3, W5
; Re end address is: 6 (W3)
	GOTO	L_WriteData12
L__WriteData29:
;spectrum_analyzer.c,226 :: 		if (Re > 63)               //63)
	MOV	W3, W5
;spectrum_analyzer.c,231 :: 		Re = 0;
L_WriteData12:
;spectrum_analyzer.c,233 :: 		if (Re >max) {               //>=
; Re start address is: 10 (W5)
	ADD	W14, #2, W0
	CP	W5, [W0]
	BRA GTU	L__WriteData44
	GOTO	L_WriteData15
L__WriteData44:
;spectrum_analyzer.c,234 :: 		max = Re;
	MOV	W5, [W14+2]
;spectrum_analyzer.c,235 :: 		freq = k;                // This should be the center frequency of the signal
	MOV	[W14+8], W0
	MOV	W0, _freq
;spectrum_analyzer.c,236 :: 		}
L_WriteData15:
;spectrum_analyzer.c,238 :: 		tmpw = Written[k];
	MOV	[W14+8], W0
	SL	W0, #1, W1
	MOV	#lo_addr(_Written), W0
	ADD	W0, W1, W0
	MOV	[W0], W0
; tmpw start address is: 2 (W1)
	MOV	W0, W1
;spectrum_analyzer.c,239 :: 		if (tmpw != Re) {            // Draw only those components that changed
	CP	W0, W5
	BRA NZ	L__WriteData45
	GOTO	L_WriteData16
L__WriteData45:
;spectrum_analyzer.c,240 :: 		l =63 - tmpw;                      //64 - tmpw;           // 64 lines on GLCD on Y axis
	MOV	#63, W0
	SUB	W0, W1, W0
; tmpw end address is: 2 (W1)
	MOV	W0, [W14+10]
;spectrum_analyzer.c,241 :: 		if(l==0) l=1;
	CP	W0, #0
	BRA Z	L__WriteData46
	GOTO	L_WriteData17
L__WriteData46:
	MOV	#1, W0
	MOV	W0, [W14+10]
L_WriteData17:
;spectrum_analyzer.c,242 :: 		while (l <= 63) {        // Clear line to the bottom of the screen
L_WriteData18:
; Re end address is: 10 (W5)
; Re start address is: 10 (W5)
	MOV	#63, W1
	ADD	W14, #10, W0
	CP	W1, [W0]
	BRA GEU	L__WriteData47
	GOTO	L_WriteData19
L__WriteData47:
;spectrum_analyzer.c,243 :: 		Glcd_Dot(k+1, l, 0);
	MOV	[W14+8], W0
	INC	W0
	CLR	W12
	MOV.B	[W14+10], W11
	MOV.B	W0, W10
	CALL	_Glcd_Dot
;spectrum_analyzer.c,244 :: 		l++;
	MOV	#1, W1
	ADD	W14, #10, W0
	ADD	W1, [W0], [W0]
;spectrum_analyzer.c,245 :: 		}
	GOTO	L_WriteData18
L_WriteData19:
;spectrum_analyzer.c,247 :: 		l = 63 - Re;           // 64 Draw line to the bottom of the screen
	MOV	#63, W0
	SUB	W0, W5, W0
	MOV	W0, [W14+10]
;spectrum_analyzer.c,248 :: 		if(l==0) l=1;
	CP	W0, #0
	BRA Z	L__WriteData48
	GOTO	L_WriteData20
L__WriteData48:
	MOV	#1, W0
	MOV	W0, [W14+10]
L_WriteData20:
;spectrum_analyzer.c,249 :: 		while (l <= 63) {
L_WriteData21:
; Re end address is: 10 (W5)
; Re start address is: 10 (W5)
	MOV	#63, W1
	ADD	W14, #10, W0
	CP	W1, [W0]
	BRA GEU	L__WriteData49
	GOTO	L_WriteData22
L__WriteData49:
;spectrum_analyzer.c,250 :: 		Glcd_Dot(k+1,l,1);     //Glcd_Dot(k, l, 1)
	MOV	[W14+8], W0
	INC	W0
	MOV.B	#1, W12
	MOV.B	[W14+10], W11
	MOV.B	W0, W10
	CALL	_Glcd_Dot
;spectrum_analyzer.c,251 :: 		l++;
	MOV	#1, W1
	ADD	W14, #10, W0
	ADD	W1, [W0], [W0]
;spectrum_analyzer.c,252 :: 		}
	GOTO	L_WriteData21
L_WriteData22:
;spectrum_analyzer.c,253 :: 		Written[k] = Re;       // Mark that the current sample has been drawn
	MOV	[W14+8], W0
	SL	W0, #1, W1
	MOV	#lo_addr(_Written), W0
	ADD	W0, W1, W0
	MOV	W5, [W0]
; Re end address is: 10 (W5)
;spectrum_analyzer.c,254 :: 		}
L_WriteData16:
;spectrum_analyzer.c,255 :: 		k++;                      // Move current X coordinate
	MOV	[W14+8], W1
	ADD	W14, #8, W0
	ADD	W1, #1, [W0]
;spectrum_analyzer.c,256 :: 		}
	GOTO	L_WriteData10
L_WriteData11:
;spectrum_analyzer.c,259 :: 		freq *= 300;            //38400/128
	MOV	_freq, W1
	MOV	#300, W0
	MUL.UU	W1, W0, W0
	MOV	W0, _freq
;spectrum_analyzer.c,260 :: 		WordToStr(freq, txt);
	MOV	#lo_addr(_txt), W11
	MOV	W0, W10
	CALL	_WordToStr
;spectrum_analyzer.c,261 :: 		Glcd_Write_Text(txt, 70, 1, 1);    //formerly 70
	MOV.B	#1, W13
	MOV.B	#1, W12
	MOV.B	#70, W11
	MOV	#lo_addr(_txt), W10
	CALL	_Glcd_Write_Text
;spectrum_analyzer.c,263 :: 		}//~
L_end_WriteData:
	POP	W13
	POP	W12
	POP	W11
	POP	W10
	ULNK
	RETURN
; end of _WriteData

_ReadAdc:

;spectrum_analyzer.c,267 :: 		unsigned ReadAdc() {
;spectrum_analyzer.c,268 :: 		LATF = ~ PORTF;                   // Add Pin to monitor sampling Rate!!!
	MOV	#lo_addr(LATF), W1
	MOV	PORTF, WREG
	COM	W0, [W1]
;spectrum_analyzer.c,269 :: 		ADCON1.F1 = 1;                    // Start AD conversion
	BSET	ADCON1, #1
;spectrum_analyzer.c,270 :: 		while (ADCON1.F0 == 0){            // Wait for ADC to finish
L_ReadAdc23:
	BTSC	ADCON1, #0
	GOTO	L_ReadAdc24
;spectrum_analyzer.c,271 :: 		asm nop;}
	NOP
	GOTO	L_ReadAdc23
L_ReadAdc24:
;spectrum_analyzer.c,272 :: 		return ADCBUF0;                   // Get ADC value
	MOV	ADCBUF0, WREG
;spectrum_analyzer.c,273 :: 		}//~
L_end_ReadAdc:
	RETURN
; end of _ReadAdc

_SampleInput:
	LNK	#2

;spectrum_analyzer.c,277 :: 		void SampleInput() {
;spectrum_analyzer.c,281 :: 		Samples[sample_counter++] = (ReadAdc()-2048)*2;   // Re
	MOV	_sample_counter, W0
	SL	W0, #1, W1
	MOV	#lo_addr(_Samples), W0
	ADD	W0, W1, W0
	MOV	W0, [W14+0]
	CALL	_ReadAdc
	MOV	#2048, W1
	SUB	W0, W1, W0
	SL	W0, #1, W1
	MOV	[W14+0], W0
	MOV	W1, [W0]
	MOV	#1, W1
	MOV	#lo_addr(_sample_counter), W0
	ADD	W1, [W0], [W0]
;spectrum_analyzer.c,282 :: 		Samples[sample_counter++] = 0;            // Im
	MOV	_sample_counter, W0
	SL	W0, #1, W1
	MOV	#lo_addr(_Samples), W0
	ADD	W0, W1, W1
	CLR	W0
	MOV	W0, [W1]
	MOV	#1, W1
	MOV	#lo_addr(_sample_counter), W0
	ADD	W1, [W0], [W0]
;spectrum_analyzer.c,283 :: 		if (sample_counter > 511)                 //511
	MOV	_sample_counter, W1
	MOV	#511, W0
	CP	W1, W0
	BRA GT	L__SampleInput52
	GOTO	L_SampleInput25
L__SampleInput52:
;spectrum_analyzer.c,284 :: 		{   sample_counter = 0;
	CLR	W0
	MOV	W0, _sample_counter
;spectrum_analyzer.c,285 :: 		DoDraw = 1;
	MOV	#lo_addr(_Dodraw), W1
	MOV.B	#1, W0
	MOV.B	W0, [W1]
;spectrum_analyzer.c,286 :: 		T1IE_bit         = 0;      //Disable interrupt
	BCLR	T1IE_bit, BitPos(T1IE_bit+0)
;spectrum_analyzer.c,288 :: 		}
L_SampleInput25:
;spectrum_analyzer.c,290 :: 		}//~
L_end_SampleInput:
	ULNK
	RETURN
; end of _SampleInput

_main:
	MOV	#2048, W15
	MOV	#6142, W0
	MOV	WREG, 32
	MOV	#1, W0
	MOV	WREG, 52
	MOV	#4, W0
	IOR	68

;spectrum_analyzer.c,294 :: 		void main() {
;spectrum_analyzer.c,296 :: 		MainInit();                     // Initialize all
	CALL	_MainInit
;spectrum_analyzer.c,297 :: 		while (1) {                     // Infinite loop
L_main26:
;spectrum_analyzer.c,300 :: 		if(DoDraw)
	MOV	#lo_addr(_Dodraw), W0
	CP0.B	[W0]
	BRA NZ	L__main54
	GOTO	L_main28
L__main54:
;spectrum_analyzer.c,304 :: 		FFT(8, TwiddleCoeff_256,Samples);
	MOV	#lo_addr(_Samples), W0
	PUSH	W0
	MOV	#lo_addr(_TwiddleCoeff_256), W0
	PUSH	W0
	MOV	#8, W0
	PUSH	W0
	CALL	_Fft
	SUB	#6, W15
;spectrum_analyzer.c,308 :: 		BitReverseComplex(8, Samples);
	MOV	#lo_addr(_Samples), W0
	PUSH	W0
	MOV	#8, W0
	PUSH	W0
	CALL	_BitReverseComplex
	SUB	#4, W15
;spectrum_analyzer.c,311 :: 		WriteData();
	CALL	_WriteData
;spectrum_analyzer.c,312 :: 		DoDraw=0;
	MOV	#lo_addr(_Dodraw), W1
	CLR	W0
	MOV.B	W0, [W1]
;spectrum_analyzer.c,313 :: 		T1IE_bit         = 1;             //enable interrupt for sampling
	BSET	T1IE_bit, BitPos(T1IE_bit+0)
;spectrum_analyzer.c,314 :: 		}
L_main28:
;spectrum_analyzer.c,315 :: 		}
	GOTO	L_main26
;spectrum_analyzer.c,318 :: 		}//~!
L_end_main:
L__main_end_loop:
	BRA	L__main_end_loop
; end of _main
