'***********************************************************************
'*                   DSE K-2805 Parallel Port Interface                *
'*                         QBasic program examples                     *
'*                                                                     *
'*                       Setting the digital outputs                   *
'***********************************************************************
'
'Define printer port base addresses
'
BASE0 = &H378  'LPT1
BASE1 = &H278  'LPT2
'
'Switch power and outputs on
'
OUT BASE0, &H80
OUT BASE0+2, &HB
'
'Define all digital outputs as being off.
'
DOUT=0
'
START:
CLS
INPUT "Toggle which digital output (0-7)";N
DOUT = DOUT XOR 2^N
'
'Write 8 clock pulses and digital output data.
'
FOR BIT = 1 TO 8
B = 8 - BIT
BYTE = ((DOUT AND 2^B) / 2^B) OR &H80
OUT BASE0, BYTE
OUT BASE0, BYTE OR 2
OUT BASE0, BYTE
NEXT BIT
'
'Write another 16 clock pulses to shift all 8 bits into IC3.
'
FOR BIT = 9 TO 24
OUT BASE0, &H82
OUT BASE0, &H80
NEXT BIT
'
'Latch data on IC3 outputs
'
OUT BASE0, &H90
OUT BASE0, &H80
GOTO START
