'***********************************************************************
'*                   DSE K-2805 Parallel Port Interface                *
'*                         QBasic program examples                     *
'*                                                                     *
'*             Setting the D/A converter (DAC) output voltages         *
'***********************************************************************
'
'Define printer port base addresses
'
BASE0 = &H378  'LPT1
BASE1 = &H278  'LPT2
'
'Switch power on
'
OUT BASE0, &H80
'
CLS
START:
'
'Get the D/A converter channel number and output voltage
'
INPUT "Which analog output do you want to set (0 or 1) ";N
IF N < 0 OR N > 1 THEN GOTO START
INPUT "Enter the required output voltage (0 to 5V) ";V
IF V > 4.98 THEN V = 4.98
IF V < .02 THEN V = 0
DV = CINT(V * 51.2)
D0 = -DV * (N = 0)
D1= -DV * (N = 1)
'
'Now load the 24 bit shift register (IC1-3) with data.
'The very first bit we shift in will end up at IC3s Qh
'output after 24 clock pulses.
'
'Do the first 8 clock pulses with all data bits = 0. This
'will be used to zero all the digital outputs (IC3).
'
FOR BIT = 1 TO 8
OUT BASE0, &H82
OUT BASE0, &H80
NEXT BIT
'
'Do the next 8 clock pulses with DAC channel 1 data bits.
'
FOR BIT=9 TO 16
B = 16 - BIT
BYTE = ((D1 AND 2^B) / 2^B) OR &H80
OUT BASE0, BYTE
OUT BASE0, BYTE OR 2
OUT BASE0, BYTE
NEXT BIT
'
'Do final 8 clock pulses with DAC channel 0 data bits.
'
FOR BIT = 17 TO 24
B = 24 - BIT
BYTE = ((D0 AND 2^B) / 2^B) OR &H80
OUT BASE0, BYTE
OUT BASE0, BYTE OR 2
OUT BASE0, BYTE
NEXT BIT
'
'Load IC1 (DAC 0) or IC2 (DAC 1) output latch with the data.
'
IF N = 0 THEN OUT BASE0, &H84
IF N = 1 THEN OUT BASE0, &H88
OUT BASE0, &H80
'
'Now enable all latch outputs.
'
OUT BASE0 + 2, &HB
'
'Display actual values used by this program.
'
PRINT: PRINT "DAC channel"+STR$(N)+" output set to about"+STR$(DV*.0195)+" volts"
PRINT "Digital value written to IC"+STR$(N+1)+" = "+HEX$(DV)+"H"
PRINT: PRINT
GOTO START
