'***********************************************************************
'*                   DSE K-2805 Parallel Port Interface                *
'*                         QBasic program examples                     *
'*                                                                     *
'*              Reading the A/D converter (ADC) input voltages         *
'***********************************************************************
'
'Define printer port base addresses
'
BASE0 = &H378  'LPT1
BASE1 = &H278  'LPT2
'
DIM V(12)
'
'Switch power on & deselect IC4
'
OUT BASE0, &HA0
'
CLS
START:
'
'Get the A/D converter channel number to be read.
'
INPUT "Which analog input do you want to read (0 to 11) ";N
IF N < 0 OR N > 11 THEN GOTO START
V(N) = 0
CYCLE = 0
'
CYCLESTART:
'
'Send select signal to IC4 (CS pin low).
'
OUT BASE0, &H80
'
'Read data output (bit 7) from previous conversion.
'
V = V OR (INP(BASE0+1) AND &H10) * 8
'
'Send address of channel to sample (MSB first)
'& read data output bits 6-3.
'
FOR CLK = 1 TO 4
ADDRESS = &H80 + &H40 * (N AND 2^(4 - CLK)) / 2^(4 - CLK)
V = V OR (INP(BASE0 + 1) AND &H10) * (2^(8- CLK)) / &H10
OUT BASE0, ADDRESS
OUT BASE0, ADDRESS OR 2
OUT BASE0, ADDRESS AND &HFD
NEXT CLK
'
'Recover final 3 bits of previous conversion (bits 2-0).
'Include a fourth clock pulse to initiate the next conversion.
'
FOR CLK = 5 TO 8
ADDRESS = &H80 + &H40 * (N AND 2^(4 - CLK)) / 2^(4 - CLK)
V = V OR (INP(BASE0 + 1) AND &H10) * (2^(8 - CLK)) / &H10
OUT BASE0, &H82
OUT BASE0, &H80
NEXT CLK
'
' Deselect IC4 and wait for EOC to signal conversion complete.
'
OUT BASE0, &HA0
'
WAITEOC:
IF INP(BASE0 + 1) AND &H40 = 0 GOTO WAITEOC
'
'Loop to do one complete cycle
'
CYCLE = CYCLE + 1
IF CYCLE = 1 THEN V = 0: GOTO CYCLESTART
V(N) = V
'
' Now display the result
'
' Channel 10 is the switched DC voltage input (allowing for the R65/R66
' divider ratio of 4.1:1) and channel 11 is the internal reference (always
' 2.5 volts).
'
CLS
LOCATE 2,1
'PRINT "V(";N;") = "; CINT(V(N) * 100 / 51.2) / 100;"  "
IF N < 10 OR N = 11 THEN PRINT "V(";N;") = "; CINT(V(N) * 100 / 51.2) / 100;"  "
IF N = 10 THEN PRINT "V(";N;") = "; (CINT(V(N) * 100 / 51.2) / 100) * 5.1;"  "
GOTO START
END
