;*****************************************************************************
;
; RC_DEMO.ASM
;
; Lights LED's on Port B in sequence.
;
; This version for TestBed with RC oscillator connected.
;
;*****************************************************************************

        list	p=16f84
        #include <p16f84.inc>

; Config bits: RC oscillator, watchdog timer OFF,
;              power up timer ON, code protection off

	__CONFIG _RC_OSC & _WDT_OFF & _PWRTE_ON & _CP_OFF

; Declare variables

j       equ     h'1f'           ; j=address 1fh
k       equ     h'1e'           ; k=address 1eh

	ORG	0

; Set Port B as output and initialise it

chaser	bsf	STATUS,RP0	; select bank 1
        movlw   b'00000000'	; 0 = out, 1 = in
	movwf	TRISB		; set all bits as outputs
	bcf	STATUS,RP0	; select bank 0

; Write high bit to RB0

	movlw   b'00000001'
        movwf   PORTB		; write to Port B output latch

; Chaser loop

next_led
	bcf	STATUS,C	; clear carry flag
shift   rlf     PORTB,f		; rotate Port B bits left
	btfss	STATUS,C	; skip if bit dropped out
        goto    next_led	; loop back to do next led
	goto	shift		; do another shift (9-bit rotate)

        end
