Version 1.00
BEGIN Form SoftArbg
	AutoRedraw   = 0
	BackColor    = QBColor(7)
	BorderStyle  = 2
	Caption      = "Silicon Chip Software Driven Arb Generator"
	ControlBox   = -1
	Enabled      = -1
	ForeColor    = QBColor(0)
	Height       = Char(17)
	Left         = Char(15)
	MaxButton    = -1
	MinButton    = -1
	MousePointer = 0
	Tag          = ""
	Top          = Char(3)
	Visible      = -1
	Width        = Char(63)
	WindowState  = 0
	BEGIN CommandButton SelectWfm
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Select Waveform"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(8)
		MousePointer = 0
		TabIndex     = 0
		TabStop      = -1
		Tag          = ""
		Top          = Char(7)
		Visible      = -1
		Width        = Char(19)
	END
	BEGIN CommandButton SetFreq
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Set Frequency"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(32)
		MousePointer = 0
		TabIndex     = 1
		TabStop      = -1
		Tag          = ""
		Top          = Char(7)
		Visible      = -1
		Width        = Char(19)
	END
	BEGIN CommandButton RunStopGen
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Run/Stop Gen."
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(8)
		MousePointer = 0
		TabIndex     = 2
		TabStop      = -1
		Tag          = ""
		Top          = Char(11)
		Visible      = -1
		Width        = Char(19)
	END
	BEGIN CommandButton QuitProg
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Quit Program"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(32)
		MousePointer = 0
		TabIndex     = 3
		TabStop      = -1
		Tag          = ""
		Top          = Char(11)
		Visible      = -1
		Width        = Char(19)
	END
	BEGIN TextBox WaveDisplay
		BackColor    = QBColor(0)
		BorderStyle  = 1
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(14)
		Height       = Char(5)
		Left         = Char(8)
		MousePointer = 0
		MultiLine    = -1
		ScrollBars   = 0
		TabIndex     = 4
		TabStop      = -1
		Tag          = ""
		Text         = "    Sinewave"
		Top          = Char(1)
		Visible      = -1
		Width        = Char(19)
	END
	BEGIN TextBox FreqDisplay
		BackColor    = QBColor(0)
		BorderStyle  = 1
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(11)
		Height       = Char(5)
		Left         = Char(32)
		MousePointer = 0
		MultiLine    = -1
		ScrollBars   = 0
		TabIndex     = 5
		TabStop      = -1
		Tag          = ""
		Text         = "     1000 Hz"
		Top          = Char(1)
		Visible      = -1
		Width        = Char(19)
	END
END
'SOFTARBG.FRM -- Software Driven Arb Generator Run Program Main Module
'Written by David Sibley for Silicon Chip, November 2000
'
'$FORM SelWave

' $INCLUDE: 'CONSTANT.BI'    'For control panel def's

DECLARE SUB DelayTime ()
DECLARE SUB DisplayStatus ()
DECLARE SUB GetSize ()
DECLARE SUB GrowString ()
DECLARE SUB LoadConfig ()
DECLARE SUB MakeWave ()
DECLARE SUB OpenWfmFile ()
DECLARE SUB SendWave ()

COMMON SHARED BaseAddress%, Delay!
COMMON SHARED WaveCode%, WaveFile$

DIM SHARED RunFlag%         'Run status flag
DIM SHARED WaveSample$      'Waveform storage string
DIM SHARED Sample%          'Waveform sample for passing
DIM SHARED FileLen%         'Length of waveform string
DIM SHARED Frequency%       'Waveform frequency


SUB DelayTime ()
    SHARED BaseAddress%, Delay!
    DIM Counter AS SINGLE, X AS SINGLE
    Counter = INT(Delay!)
    FOR X = 1 TO Counter: NEXT X
END SUB

SUB DisplayStatus ()
    SHARED WaveCode%, WaveFile$, Frequency%
        SELECT CASE WaveCode%
            CASE 1
                WaveName$ = "    Sine Wave"
                WaveFile$ = STRING$(12, " ")
            CASE 2
                WaveName$ = "   Square Wave"
                WaveFile$ = STRING$(12, " ")
            CASE 3
                WaveName$ = "  Triangle Wave"
                WaveFile$ = STRING$(12, " ")
            CASE 4
                WaveName$ = "  Sawtooth Down"
                WaveFile$ = STRING$(12, " ")
            CASE 5
                WaveName$ = "   Sawtooth Up"
                WaveFile$ = STRING$(12, " ")
            CASE 6
                WaveName$ = "   Custom Wave:"
        END SELECT
        CrLf$ = CHR$(13) + CHR$(10)
        WaveDisplay.TEXT = WaveName$ + CrLf$ + CrLf$ + "   " + WaveFile$
        Freq$ = STR$(Frequency%)
        FreqDisplay.TEXT = CrLf$ + SPACE$(9 - LEN(Freq$)) + Freq$ + " Hz"
END SUB

SUB Form_Load ()
    SHARED BaseAddress%, Delay!, WaveCode%, Frequency%, RunFlag%
    SCREEN.ControlPanel(ACTIVE_BORDER_BACKCOLOR) = 7
    SCREEN.ControlPanel(ACTIVE_BORDER_FORECOLOR) = 0
    SCREEN.ControlPanel(TITLEBAR_BACKCOLOR) = 5
    SCREEN.ControlPanel(TITLEBAR_FORECOLOR) = 15
    WindowState = 2         'Maximise form...
    BaseAddress% = &H278    'Default values
    Delay! = 11
    WaveCode% = 1
    Frequency% = 400
    RunFlag% = 0            'Stopped on prog startup
    CALL LoadConfig
    CALL DisplayStatus

END SUB

SUB GetSize ()
    SHARED Frequency%, FileLen%
    FileLen% = 25000 / Frequency%
END SUB

SUB GrowString ()
    SHARED Sample%, WaveSample$
    Sample% = Sample% AND 255               'Mask off hi byte
    NewChar$ = CHR$(Sample%)                'Convert to char
    WaveSample$ = WaveSample$ + NewChar$    '& add to string
END SUB

SUB LoadConfig ()
    SHARED BaseAddress%, Delay!
    ON LOCAL ERROR GOTO ErrHandler
    ErrorFlag = 0
    IF LEN(COMMAND$) > 0 THEN
        CurrentConfig$ = COMMAND$
        Auto = 1
        ELSE CurrentConfig$ = "SOFTAGEN.CFG"
    END IF
    OPEN CurrentConfig$ FOR INPUT AS #2
    IF ErrorFlag = 0 THEN
        FOR X = 1 TO 3      'Ignore header
            LINE INPUT #2, A$
        NEXT X
        INPUT #2, A$: BaseAddress% = VAL("&H" + A$)
        INPUT #2, A$: Delay! = VAL(A$)
        CLOSE #2
    END IF
ErrHandler:
ErrorFlag = 1
RESUME NEXT

END SUB

SUB MakeWave ()
    SHARED WaveCode%, Frequency%, WaveFile$
    SHARED WaveSample$, Delay!, FileLen%, Sample%
    DIM X AS INTEGER

    WaveSample$ = ""                'Start again
    SELECT CASE WaveCode%
        CASE 1
            CALL GetSize
            FOR X = 1 TO FileLen%
            Sample% = INT(127 + 127 * SIN(X / FileLen% * 6.2831853#))
            CALL GrowString
            NEXT X
        CASE 2
            CALL GetSize
            MidWave% = FileLen% / 2
            FOR X = 1 TO MidWave%
                Sample% = 0
                CALL GrowString
            NEXT X
            FOR X = MidWave% + 1 TO FileLen%
                Sample% = 255
                CALL GrowString
            NEXT X
        CASE 3
            CALL GetSize
            MidWave% = FileLen% / 2
            FOR X = 1 TO MidWave%
                Sample% = INT(255 * (1 - (X / MidWave%)))
                CALL GrowString
            NEXT X
            FOR X = MidWave% + 1 TO FileLen%
                Sample% = INT((X - MidWave%) / (FileLen% - MidWave%) * 255)
                CALL GrowString
            NEXT X
        CASE 4
            CALL GetSize
            FOR X = 1 TO FileLen%
                Sample% = INT(255 - (X / FileLen%) * 255)
                CALL GrowString
            NEXT X
        CASE 5
            CALL GetSize
            FOR X = 1 TO FileLen%
                Sample% = INT((X / FileLen%) * 255)
                CALL GrowString
            NEXT X
        CASE 6
            CALL OpenWfmFile        'Fetch custom wfm
        END SELECT
END SUB

SUB OpenWfmFile ()
    SHARED WaveFile$
    SHARED WaveSample$
    SHARED Sample%
    SHARED FileLen%
    SHARED Frequency%

    OPEN WaveFile$ FOR BINARY AS #1
    GET #1, 1, FileLen%                 'Fetch wfm length
    IF FileLen% > 32700 THEN FileLen% = 32700
    WaveSample$ = ""                    'then wfm data
    FOR Count% = 1 TO FileLen%
        GET #1, (2 + (Count% * 2)), Sample%
        CALL GrowString
    NEXT Count%
    CLOSE #1
    Frequency% = 25000 / FileLen%       'now work out freq
    CALL DisplayStatus                  '& show it
END SUB

SUB QuitProg_Click ()
    CLS
    SYSTEM
    END
END SUB

SUB RunStopGen_Click ()
    SHARED RunFlag%

    IF RunFlag% = 0 THEN        'Was stopped, so go
        RunFlag% = 1
        CALL MakeWave
        CALL SendWave
    ELSE RunFlag% = 0           'Was going, so stop
    END IF
END SUB

SUB SelectWfm_Click ()
    SHARED WaveCode%, WaveFile$
        SelWave.SHOW 1      'Show dialog box & get info
        CALL DisplayStatus
END SUB

SUB SendWave ()
    SHARED BaseAddress%
    SHARED RunFlag%
    SHARED WaveSample$
    SHARED FileLen%
    DIM X AS INTEGER
    
    DO WHILE DOEVENTS()
        FOR X = 1 TO FileLen%
        Samp$ = MID$(WaveSample$, X, 1)   'get data byte
        ThisByte% = ASC(Samp$)
        OUT BaseAddress%, ThisByte%         '& send it
        OUT BaseAddress% + 2, 13            'with strobe pulse
        OUT BaseAddress% + 2, 0
        CALL DelayTime                      'then delay 20us
        NEXT X
        IF RunFlag% = 0 THEN EXIT DO        'stop if user wants it
    LOOP                                    'otherwise continue
END SUB

SUB SetFreq_Click ()
    SHARED Frequency%, WaveCode%

    IF WaveCode% = 6 THEN EXIT SUB      'Freq fixed, skip
    Prompt$ = "Give desired frequency in Hz:" + CHR$(13) + CHR$(10)
    Prompt$ = Prompt$ + "(Whole Number only)"
    DO
        WantedFreq$ = INPUTBOX$(Prompt$, "Frequency Input", "400")
        InFreq% = INT(VAL(WantedFreq$))
        IF InFreq% >= 1 AND InFreq% <= 5000 THEN EXIT DO
        MSGBOX "Sorry -- outside range (1Hz - 2500Hz)"
    LOOP
    Frequency% = InFreq%
    CALL DisplayStatus
END SUB

