'MAKEMAIN.BAS -- main module for Wave Maker
'                (for Software-Driven Arb Gen)
'  Written by David Sibley for Silicon Chip, November 2000

'$FORM MakeWave

' $INCLUDE: 'CONSTANT.BI'       'For control panel defns

DECLARE SUB DisplayStatus ()
DECLARE SUB WaveEdit ()
DECLARE SUB GrowString ()
DECLARE SUB MakeArray ()
DECLARE SUB GetFileName ()
DECLARE SUB Form_Load ()
DECLARE SUB ShowWfm ()
DECLARE SUB PlotColumn ()
DECLARE SUB ColStatus ()
DECLARE SUB EraseRow ()
DECLARE SUB BackToString ()

COMMON SHARED WaveFile$                     'Waveform storage filename
COMMON SHARED FileLen%                      'Length of waveform string
COMMON SHARED Frequency%                    'Frequency
COMMON SHARED Res%                          'pixels per screen column
COMMON SHARED Sample%                       'Waveform sample for passing
COMMON SHARED WaveSample$                   'Waveform storage string
DIM SHARED EditWave(1 TO 599) AS INTEGER    'Array for wfm editing
COMMON SHARED ArrayLen%                     'Actual length of array
COMMON SHARED Div%                          'Decimation factor
COMMON SHARED Cval%                         'Current scrn column value
COMMON SHARED Cnum%                         'Current scrn column number
COMMON SHARED LineGo%                       'Previous value to erase

SCREEN 0
SCREEN.ControlPanel(ACTIVE_BORDER_BACKCOLOR) = 7
SCREEN.ControlPanel(ACTIVE_BORDER_FORECOLOR) = 0
SCREEN.ControlPanel(TITLEBAR_BACKCOLOR) = 5
SCREEN.ControlPanel(TITLEBAR_FORECOLOR) = 15

MakeWave.SHOW
WHILE DOEVENTS(): WEND
END

SUB BackToString ()
    SHARED WaveSample$, FileLen%, Sample%
    SHARED EditWave() AS INTEGER
    SHARED ArrayLen%, Div%
    DIM X AS INTEGER, Y AS INTEGER

    WaveSample$ = ""                'initialise string
    FOR X = 1 TO ArrayLen%          'then rebuild it...
        FOR Y = 1 TO (Div%)
            Sample% = EditWave(X)
            CALL GrowString
        NEXT Y
    NEXT X
    FileLen% = LEN(WaveSample$)     'recalc just in case
END SUB

SUB ColStatus ()
    SHARED Cnum%, Cval%
    COLOR 11, 0
    LOCATE 20, 25: PRINT "    ";
    LOCATE 20, 25: PRINT Cval%;
    LOCATE 21, 25: PRINT "    ";
    LOCATE 21, 25: PRINT Cnum%;

END SUB

SUB DisplayStatus ()

SHARED WaveFile$, FileLen%
    SCREEN 9: WIDTH 80: WINDOW (0, 0)-(640, 349)
    COLOR 14, 0
    LOCATE 20, 1: PRINT "Current Sample Value  = ";
    LOCATE 21, 1: PRINT "Current Sample Column = ";
    LOCATE 22, 1: PRINT "Samples per Column    = ";
    LOCATE 23, 1: PRINT "Column Period         = ";
    LOCATE 24, 1: PRINT "Samples in Waveform   = ";
    LOCATE 25, 1: PRINT "Waveform File Name    = ";
    LKey$ = CHR$(91) + CHR$(27) + CHR$(93) + "   = "
    RKey$ = CHR$(91) + CHR$(26) + CHR$(93) + "   = "
    UKey$ = CHR$(91) + CHR$(24) + CHR$(93) + "   = "
    DKey$ = CHR$(91) + CHR$(25) + CHR$(93) + "   = "
    EKey$ = CHR$(91) + "End" + CHR$(93) + " = "
    LOCATE 20, 45: COLOR 12, 0: PRINT "KEYPAD LEGEND:"
    COLOR 14, 0
    LOCATE 21, 45: PRINT LKey$ + "Left one column";
    LOCATE 22, 45: PRINT RKey$ + "Right one column";
    LOCATE 23, 45: PRINT UKey$ + "Increase sample val";
    LOCATE 24, 45: PRINT DKey$ + "Decrease sample val";
    LOCATE 25, 45: PRINT EKey$ + "Return to Main Prog";
    COLOR 11, 0
    LOCATE 25, 26: PRINT (WaveFile$ + ".SWF");
    LOCATE 1, 77: PRINT "255";
    LOCATE 10, 77: PRINT "127";
    LOCATE 19, 77: PRINT "0";
    COLOR 15, 0
    LINE (0, 92)-(600, 349), , B     'Wfm box
    COLOR 12, 0
    LINE (1, 220)-(599, 220)         'red midline

END SUB

SUB EraseRow ()
    SHARED Cnum%, LineGo%, Res%
    DIM Scol AS INTEGER, Sval AS INTEGER
    COLOR 0, 0                      'erase to black
    Scol = ((Cnum% - 1) * Res%) + 1
    Sval = LineGo% + 93
    LINE (Scol, Sval)-((Scol + Res% - 1), Sval)

END SUB

SUB GetFileName ()
    SHARED WaveFile$
    CR$ = CHR$(13) + CHR$(10)
    Prompt$ = "Give Waveform File Name" + CR$
    Prompt$ = Prompt$ + "8 chars max, no extension"
    DO
        FileName$ = INPUTBOX$(Prompt$, "File Name Input", WaveFile$)
        IF LEN(FileName$) <= 8 THEN EXIT DO
    LOOP
    WaveFile$ = FileName$
END SUB

SUB GrowString ()
    SHARED Sample%
    SHARED WaveSample$

    Sample% = Sample% AND 255       'mask off hi byte
    NewChar$ = CHR$(Sample%)
    WaveSample$ = WaveSample$ + NewChar$    '& add to string
END SUB

SUB MakeArray ()
    SHARED FileLen%
    SHARED WaveSample$
    SHARED EditWave() AS INTEGER
    SHARED ArrayLen%
    SHARED Div%
    DIM X AS INTEGER, Y AS INTEGER

    Div% = 1                        'Initial val for decim factor
    DO
        ArrayLen% = INT(FileLen% / Div%)
        IF ArrayLen% <= 599 THEN EXIT DO
        Div% = Div% + 1             'Try adding 1 until found
    LOOP
    FOR X = 1 TO ArrayLen%
        Av% = 0
        FOR Y = X TO (Div% - 1 + X)
            Samp$ = MID$(WaveSample$, Y, 1)
            Samp% = ASC(Samp$)
            Av% = Av% + Samp%
        NEXT Y
        Av% = INT(Av% / Div%)       'Find average
        EditWave(X) = Av% AND 255   '& store in edit array
    NEXT X

END SUB

SUB PlotColumn ()
    SHARED Cval%, Cnum%, Res%
    DIM Scol AS INTEGER, Sval AS INTEGER
    Scol = ((Cnum% - 1) * Res%) + 1         'Start of column
    Sval = Cval% + 93
    LINE (Scol, Sval)-((Scol + Res% - 1), Sval)
    
END SUB

SUB ShowWfm ()
    SHARED FileLen%, Res%
    SHARED EditWave() AS INTEGER
    SHARED ArrayLen%, Div%, Cval%, Cnum%
    DIM X AS INTEGER

    Res% = 1                        'initial trial val
    DO
        GrafLen% = ArrayLen% * Res%
        IF GrafLen% >= 599 THEN EXIT DO
        Res% = Res% + 1
    LOOP
    IF Res% > 1 THEN Res% = Res% - 1   'Largest that fits
    COLOR 10, 0
    FOR X = 1 TO ArrayLen%
        Cval% = EditWave(X)
        Cnum% = X
        CALL PlotColumn
    NEXT X
    COLOR 11, 0
    LOCATE 22, 25: PRINT Div%;
    LOCATE 23, 25: PRINT (Div% * 40); "us";
    LOCATE 24, 25: PRINT FileLen%;

END SUB

SUB WaveEdit ()
    SHARED WaveSample$, FileLen%, Res%, LineGo%
    SHARED Cnum%, Cval%, EditWave() AS INTEGER

    MakeWave.HIDE               'Hide form, then
    CALL DisplayStatus          'show status panel
    CALL ShowWfm                'then waveform itself
    Cnum% = 1                   'reset column ptr
    Cval% = EditWave(1)
    CALL ColStatus              '% update status ind
ScanLoop:
    DO
        A$ = INKEY$             'check keys
    LOOP UNTIL A$ <> "" AND LEN(A$) = 2
    A$ = MID$(A$, 2, 1): A% = ASC(A$)
    SELECT CASE A%
        CASE 72                             'Up arrow
            Cval% = Cval% + 1               'so update array
            IF Cval% > 255 THEN Cval% = 255
            EditWave(Cnum%) = Cval%
            CALL ColStatus                  '& status indic
            COLOR 10, 0: CALL PlotColumn    '& graph too
            LineGo% = Cval% - 1
            CALL EraseRow
        CASE 80                             'Down arrow
            Cval% = Cval% - 1               'so update array
            IF Cval% < 0 THEN Cval% = 0
            EditWave(Cnum%) = Cval%
            CALL ColStatus                  '& status indic
            COLOR 10, 0: CALL PlotColumn    '& graph
            LineGo% = Cval% + 1
            CALL EraseRow
        CASE 77                             'Right arrow
            Cnum% = Cnum% + 1               'so jump right
            IF Cnum% > ArrayLen% THEN Cnum% = ArrayLen%
            Cval% = EditWave(Cnum%)
            COLOR 11, 0: CALL ColStatus
            COLOR 10, 0: CALL PlotColumn
        CASE 75                             'Left arrow
            Cnum% = Cnum% - 1               'so jump left
            IF Cnum% < 1 THEN Cnum% = 1
            Cval% = EditWave(Cnum%)
            COLOR 11, 0: CALL ColStatus
            COLOR 10, 0: CALL PlotColumn
        CASE 79                             'End key
            SCREEN 0                        'so restore form
            MakeWave.SHOW
            CALL BackToString               'resave array as string
            EXIT SUB                        '& leave...
    END SELECT
    GOTO ScanLoop       'keep checking
    
END SUB

