Version 1.00
BEGIN Form Softtest
	AutoRedraw   = 0
	BackColor    = QBColor(7)
	BorderStyle  = 2
	Caption      = "Silicon Chip Software Driven Arb Gen: Setup Program"
	ControlBox   = -1
	Enabled      = -1
	ForeColor    = QBColor(7)
	Height       = Char(17)
	Left         = Char(15)
	MaxButton    = -1
	MinButton    = -1
	MousePointer = 0
	Tag          = ""
	Top          = Char(3)
	Visible      = -1
	Width        = Char(63)
	WindowState  = 0
	BEGIN CommandButton SetPortAddress
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Set Port Address"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(8)
		MousePointer = 0
		TabIndex     = 0
		TabStop      = -1
		Tag          = ""
		Top          = Char(3)
		Visible      = -1
		Width        = Char(31)
	END
	BEGIN CommandButton FlashGenLED
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Flash Generator LED"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(8)
		MousePointer = 0
		TabIndex     = 1
		TabStop      = -1
		Tag          = ""
		Top          = Char(6)
		Visible      = -1
		Width        = Char(31)
	END
	BEGIN CommandButton AdjustDelay
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Adjust Delay Constant"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(8)
		MousePointer = 0
		TabIndex     = 2
		TabStop      = -1
		Tag          = ""
		Top          = Char(9)
		Visible      = -1
		Width        = Char(31)
	END
	BEGIN CommandButton SaveConfigFile
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Save Data in Config File"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(8)
		MousePointer = 0
		TabIndex     = 3
		TabStop      = -1
		Tag          = ""
		Top          = Char(12)
		Visible      = -1
		Width        = Char(31)
	END
	BEGIN CommandButton QuitProg
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Quit Program"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(43)
		MousePointer = 0
		TabIndex     = 4
		TabStop      = -1
		Tag          = ""
		Top          = Char(12)
		Visible      = -1
		Width        = Char(16)
	END
	BEGIN TextBox PortAddr
		BackColor    = QBColor(0)
		BorderStyle  = 1
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(14)
		Height       = Char(3)
		Left         = Char(46)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 5
		TabStop      = -1
		Tag          = ""
		Text         = " Port: 278"
		Top          = Char(3)
		Visible      = -1
		Width        = Char(13)
	END
END
'SOFTTEST.FRM -- Software Driven Arb Generator Test Program Main Module
'Written by David Sibley for Silicon Chip, November 2000
'
'$FORM SetIOPrt

' $INCLUDE: 'CONSTANT.BI'    'For control panel def's

DECLARE SUB DelayTime ()
COMMON SHARED BaseAddress%, Delay!

SUB AdjustDelay_Click ()
    SHARED BaseAddress%, Delay!
    DIM DelayInput AS SINGLE
    CrLf$ = CHR$(13) + CHR$(10)
    Prompt$ = "Adjust delay value until generator" + CrLf$
    Prompt$ = Prompt$ + "frequencies are as close as possible" + CrLf$
    Prompt$ = Prompt$ + "to those you key into SOFTARBG..." + CrLf$
    MSGBOX Prompt$, 0, "How to adjust delay value:"
    Prompt$ = "Give desired delay constant" + CHR$(13) + CHR$(10)
    Prompt$ = Prompt$ + "(Positive number < 32,000)"
    DO
        DelayInp$ = INPUTBOX$(Prompt$, "Delay Input", STR$(Delay!))
        DelayInput = VAL(DelayInp$)
        IF DelayInput > 0 AND DelayInput < 32000 THEN EXIT DO
    LOOP
    Delay! = DelayInput
END SUB

SUB DelayTime ()
    SHARED BaseAddress%, Delay!
    DIM Counter AS SINGLE, X AS SINGLE
    Counter = INT(Delay! * 25000)   'About 1 sec when
    FOR X = 1 TO Counter: NEXT X    'Delay! gives 40us...
END SUB

SUB FlashGenLED_Click ()
    SHARED BaseAddress%, Delay!
    DIM X AS INTEGER
    FOR X = 1 TO 5
        OUT BaseAddress% + 2, 13
        CALL DelayTime
        OUT BaseAddress% + 2, 0
        CALL DelayTime
    NEXT X
END SUB

SUB Form_Load ()
    SHARED BaseAddress%, Delay!
    SCREEN.ControlPanel(ACTIVE_BORDER_BACKCOLOR) = 7
    SCREEN.ControlPanel(ACTIVE_BORDER_FORECOLOR) = 0
    SCREEN.ControlPanel(TITLEBAR_BACKCOLOR) = 5
    SCREEN.ControlPanel(TITLEBAR_FORECOLOR) = 15
    WindowState = 0         'Modest size form...
    BaseAddress% = &H278    'Set defaults
    Delay! = 11
    PortAddr.TEXT = " Port: " + HEX$(BaseAddress%)
END SUB

SUB QuitProg_Click ()
    CLS
    SYSTEM
    END
END SUB

SUB SaveConfigFile_Click ()
    SHARED BaseAddress%, Delay!
    OPEN "SOFTAGEN.CFG" FOR OUTPUT AS #2
    PRINT #2, "Config file for SC Software-Driven Arb Generator"
    PRINT #2, "Numbers in brackets are default values."
    PRINT #2, "Next line is first one actually read in..."
    PRINT #2, HEX$(BaseAddress%); " Port address (278)"
    PRINT #2, Delay!; "Delay constant (11)"
    CLOSE #2
END SUB

SUB SetPortAddress_Click ()
    SHARED BaseAddress%
        SetIOPrt.SHOW 1     'Display dialog box
    PortAddr.TEXT = " Port: " + HEX$(BaseAddress%)
END SUB

