Version 1.00
BEGIN Form Form1
	AutoRedraw   = 0
	BackColor    = QBColor(7)
	BorderStyle  = 2
	Caption      = "DC Voltage Program for Software-Driven Arbgen"
	ControlBox   = -1
	Enabled      = -1
	ForeColor    = QBColor(7)
	Height       = Char(17)
	Left         = Char(15)
	MaxButton    = -1
	MinButton    = -1
	MousePointer = 0
	Tag          = ""
	Top          = Char(3)
	Visible      = -1
	Width        = Char(63)
	WindowState  = 0
	BEGIN TextBox VoltDisplay
		BackColor    = QBColor(0)
		BorderStyle  = 1
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(11)
		Height       = Char(4)
		Left         = Char(4)
		MousePointer = 0
		MultiLine    = -1
		ScrollBars   = 0
		TabIndex     = 0
		TabStop      = -1
		Tag          = ""
		Text         = " Vo = 10.00V"
		Top          = Char(2)
		Visible      = -1
		Width        = Char(16)
	END
	BEGIN TextBox PortDisplay
		BackColor    = QBColor(0)
		BorderStyle  = 1
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(14)
		Height       = Char(4)
		Left         = Char(41)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 1
		TabStop      = -1
		Tag          = ""
		Text         = "  Port: 378H"
		Top          = Char(2)
		Visible      = -1
		Width        = Char(16)
	END
	BEGIN CommandButton ChangeVolts
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Change Volts"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(4)
		MousePointer = 0
		TabIndex     = 2
		TabStop      = -1
		Tag          = ""
		Top          = Char(9)
		Visible      = -1
		Width        = Char(16)
	END
	BEGIN CommandButton QuitProg
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Quit Program"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(41)
		MousePointer = 0
		TabIndex     = 3
		TabStop      = -1
		Tag          = ""
		Top          = Char(9)
		Visible      = -1
		Width        = Char(16)
	END
	BEGIN TextBox MaxVDisplay
		BackColor    = QBColor(0)
		BorderStyle  = 1
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(12)
		Height       = Char(4)
		Left         = Char(22)
		MousePointer = 0
		MultiLine    = -1
		ScrollBars   = 0
		TabIndex     = 4
		TabStop      = -1
		Tag          = ""
		Text         = "  Max. Volts:"
		Top          = Char(2)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN CommandButton SetMaxVolts
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Set Max Volts"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(22)
		MousePointer = 0
		TabIndex     = 5
		TabStop      = -1
		Tag          = ""
		Top          = Char(9)
		Visible      = -1
		Width        = Char(17)
	END
END
'SOFTVOLT.FRM -- DC voltage program for Software-Driven Arb Gen
' Written by David Sibley for Silicon Chip, November 2000
'
' $INCLUDE: 'CONSTANT.BI'

COMMON SHARED BaseAddress%, Delay!, MaxVolts!

DECLARE SUB LoadConfig ()
DECLARE SUB ShowMaxV ()

SUB ChangeVolts_Click ()
    SHARED BaseAddress%, MaxVolts!
    DIM VoltInput AS SINGLE
    CrLf$ = CHR$(13) + CHR$(10)
    Prompt$ = "Give new voltage" + CrLf$
    Prompt$ = Prompt$ + "(0 - 10.00)"
    DO
        VoltInp$ = INPUTBOX$(Prompt$, "Voltage Input", "1.00")
        VoltInput = VAL(VoltInp$)
        IF VoltInput >= 0 AND VoltInput <= 10! THEN EXIT DO
    LOOP
    SendVal% = INT((VoltInput / MaxVolts!) * 255) AND 255
    SendChar$ = CHR$(SendVal%)
    SendByte% = ASC(SendChar$)
    OUT BaseAddress%, SendByte%
    OUT BaseAddress% + 2, 13
    OUT BaseAddress% + 2, 0
    TrueVolts! = ((SendVal% / 255) * MaxVolts!)
    TrueVolts$ = FORMAT$(TrueVolts!, "##.00")
    Display$ = " Vo = " + TrueVolts$ + "V" + CrLf$
    VoltDisplay.TEXT = Display$ + "  (" + HEX$(SendVal%) + " hex)"
    
END SUB

SUB Form_Load ()
    SHARED BaseAddress%, Delay!, MaxVolts!
    SCREEN.ControlPanel(ACTIVE_BORDER_BACKCOLOR) = 7
    SCREEN.ControlPanel(ACTIVE_BORDER_FORECOLOR) = 0
    SCREEN.ControlPanel(TITLEBAR_BACKCOLOR) = 5
    SCREEN.ControlPanel(TITLEBAR_FORECOLOR) = 15
    WindowState = 0             'Keep modest size
    BaseAddress% = &H278        'Set defaults
    Delay! = 11
    MaxVolts! = 10!
    CALL LoadConfig             'But also look for config file
    PortDisplay.TEXT = "  Port: " + HEX$(BaseAddress%)
    CALL ShowMaxV
END SUB

SUB LoadConfig ()
    SHARED BaseAddress%, Delay!
    ON LOCAL ERROR GOTO ErrHandler
    ErrorFlag = 0
    IF LEN(COMMAND$) > 0 THEN
        CurrentConfig$ = COMMAND$
        Auto = 1
        ELSE CurrentConfig$ = "SOFTAGEN.CFG"
    END IF
    OPEN CurrentConfig$ FOR INPUT AS #2
    IF ErrorFlag = 0 THEN
        FOR X = 1 TO 3      'Ignore header lines
            LINE INPUT #2, A$
        NEXT X
        INPUT #2, A$: BaseAddress% = VAL("&H" + A$)
        INPUT #2, A$: Delay! = VAL(A$)  'not used here tho
        CLOSE #2
    END IF
ErrHandler:
    ErrorFlag = 1
    RESUME NEXT

END SUB

SUB QuitProg_Click ()
    CLS
    SYSTEM
    END
END SUB

SUB SetMaxVolts_Click ()
    SHARED MaxVolts!
    CrLf$ = CHR$(13) + CHR$(10)
    Prompt$ = "Set full scale volts:" + CrLf$
    Prompt$ = Prompt$ + "(1.00 - 10.00)"
    DO
        VoltInp$ = INPUTBOX$(Prompt$, "Set FS volts", "10.00")
        VoltInput! = VAL(VoltInp$)
        IF VoltInput! >= 1! AND VoltInput! <= 10! THEN EXIT DO
    LOOP
    MaxVolts! = VoltInput!          'Have new value
    CALL ShowMaxV
END SUB

SUB ShowMaxV ()
    SHARED MaxVolts!
    CrLf$ = CHR$(13) + CHR$(10)
    MaxVolts$ = FORMAT$(MaxVolts!, "##.00")
    Display$ = "  Max. Volts" + CrLf$
    MaxVDisplay.TEXT = Display$ + "  = " + MaxVolts$ + "V"

END SUB

