Version 1.00
BEGIN Form Makewave
	AutoRedraw   = 0
	BackColor    = QBColor(7)
	BorderStyle  = 2
	Caption      = "MAKEWAVE: Make a new Arbitrary Waveform"
	ControlBox   = -1
	Enabled      = -1
	ForeColor    = QBColor(7)
	Height       = Char(17)
	Left         = Char(15)
	MaxButton    = -1
	MinButton    = -1
	MousePointer = 0
	Tag          = ""
	Top          = Char(3)
	Visible      = -1
	Width        = Char(63)
	WindowState  = 0
	BEGIN CommandButton SetPeriodFreq
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "New Wfm: Period/Freq"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(4)
		MousePointer = 0
		TabIndex     = 0
		TabStop      = -1
		Tag          = ""
		Top          = Char(2)
		Visible      = -1
		Width        = Char(25)
	END
	BEGIN CommandButton DrawWave
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "New Wfm: Draw Samples"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(4)
		MousePointer = 0
		TabIndex     = 1
		TabStop      = -1
		Tag          = ""
		Top          = Char(6)
		Visible      = -1
		Width        = Char(25)
	END
	BEGIN CommandButton SaveWfmFile
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Save Current Waveform"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(32)
		MousePointer = 0
		TabIndex     = 2
		TabStop      = -1
		Tag          = ""
		Top          = Char(6)
		Visible      = -1
		Width        = Char(25)
	END
	BEGIN CommandButton LoadEditWfm
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Load && Edit a Waveform"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(32)
		MousePointer = 0
		TabIndex     = 3
		TabStop      = -1
		Tag          = ""
		Top          = Char(2)
		Visible      = -1
		Width        = Char(25)
	END
	BEGIN CommandButton QuitProgram
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Quit Program"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(32)
		MousePointer = 0
		TabIndex     = 4
		TabStop      = -1
		Tag          = ""
		Top          = Char(10)
		Visible      = -1
		Width        = Char(25)
	END
END
'MAKEWAVE.FRM -- Wave Maker for Software-Driven Arb Generator
' Written by David Sibley for Silicon Chip, November 2000
'
'
DECLARE SUB SaveWfmFile_Click ()
DECLARE SUB GetFileName ()
DECLARE SUB GrowString ()
DECLARE SUB WaveEdit ()
DECLARE SUB DisplayStatus ()
DECLARE SUB MakeArray ()
DECLARE SUB ShowWfm ()

COMMON SHARED WaveFile$
COMMON SHARED FileLen%
COMMON SHARED Frequency%
COMMON SHARED Res%
COMMON SHARED Sample%
COMMON SHARED WaveSample$






SUB DrawWave_Click ()
    SHARED FileLen%, Sample%, WaveSample$
    DIM X AS INTEGER
    WaveSample$ = ""            'Null sample string to init
    Sample% = 127               'Initial midrange value
    FOR X = 1 TO FileLen%       'Create initial flat line
        CALL GrowString
    NEXT X
    CALL MakeArray              'create editing array
    CALL WaveEdit               'then go edit it

END SUB

SUB Form_Load ()
    SCREEN.ControlPanel(ACTIVE_BORDER_BACKCOLOR) = 7
    SCREEN.ControlPanel(ACTIVE_BORDER_FORECOLOR) = 0
    SCREEN.ControlPanel(TITLEBAR_BACKCOLOR) = 5
    SCREEN.ControlPanel(TITLEBAR_FORECOLOR) = 15
    WindowState = 2                 'Maximise form
    WaveFile$ = "TESTWAVE"          'Set defaults
    FileLen% = 25
    Div% = 1
    Frequency% = 1000
    
END SUB

SUB LoadEditWfm_Click ()
    SHARED WaveFile$
    SHARED FileLen%
    SHARED Sample%
    SHARED WaveSample$
    DIM X AS INTEGER

    DO
        CALL GetFileName                'Learn file to load
        Y$ = DIR$(WaveFile$ + ".SWF")
        IF Y$ <> "" THEN EXIT DO        'File exists...
        MSGBOX "Sorry, file not found"
    LOOP
    OPEN (WaveFile$ + ".SWF") FOR BINARY AS #2
    GET #2, 1, FileLen%                 'Fetch wfm length
    IF FileLen% > 32700 THEN FileLen% = 32700 'just playing safe
    WaveSample$ = ""                    'then wfm data
    FOR X = 1 TO FileLen%
        GET #2, (2 + (X * 2)), Sample%
        CALL GrowString
    NEXT X
    CLOSE #2
    Frequency% = 25000 / FileLen%       'work out freq
    CALL MakeArray                      'create edit array
    CALL WaveEdit                       'and go edit wfm

END SUB

SUB QuitProgram_Click ()
    Prompt$ = "Save Waveform before Exit?"
    SaveFirst% = MSGBOX(Prompt$, 4, "Make Sure Waveform is Saved")
    IF SaveFirst% = 7 THEN GOTO QuitNow     'Saving not wanted
    CALL SaveWfmFile_Click                  'Is wanted, so do it
QuitNow:
    CLS
    SYSTEM
    END
    
END SUB

SUB SaveWfmFile_Click ()
    SHARED WaveFile$
    SHARED FileLen%
    SHARED WaveSample$

    CALL GetFileName                            'Learn filename
    OPEN (WaveFile$ + ".SWF") FOR BINARY AS #2  'open to save
    PUT #2, 1, FileLen%                         'save wfm length
    FOR Count% = 1 TO FileLen%                  'then wfm data
        Sample% = ASC(MID$(WaveSample$, Count%, 1))
        PUT #2, (2 + (Count% * 2)), Sample%
    NEXT Count%
    CLOSE #2

END SUB

SUB SetPeriodFreq_Click ()
    SHARED Frequency%, FileLen%, Res%
    CrLf$ = CHR$(13) + CHR$(10)
    Prompt$ = "Set Frequency or Period?" + CrLf$
    Prompt$ = Prompt$ + "(Input 'F' or 'P')"
    DO
        M$ = INPUTBOX$(Prompt$, "Set Frequency or Period", "F")
        IF M$ = "F" OR M$ = "f" OR M$ = "P" OR M$ = "p" THEN EXIT DO
    LOOP
    SELECT CASE UCASE$(M$)
        CASE "F"
            Prompt$ = "Give Waveform Frequency in Hertz" + CrLf$
            Prompt$ = Prompt$ + "(Integer 1 - 1000)"
            DO
                InpFreq$ = INPUTBOX$(Prompt$, "Waveform Frequency", "100")
                InFreq% = INT(VAL(InpFreq$))
                IF InFreq% >= 1 AND InFreq% <= 1000 THEN EXIT DO
            LOOP
            Frequency% = InFreq%                'Found Frequency%
            FileLen% = 25000 / Frequency%       '& FileLen%
        CASE "P"
            Prompt$ = "Give Waveform Period in Milliseconds" + CrLf$
            Prompt$ = Prompt$ + "(Integer 1 - 1000)"
            DO
                InpPerd$ = INPUTBOX$(Prompt$, "Waveform Period", "10")
                InPerd% = INT(VAL(InpPerd$))
                IF InPerd% >= 1 AND InPerd% <= 1000 THEN EXIT DO
            LOOP
            FileLen% = InPerd% * 25             'Found FileLen%
            Frequency% = 25000 / FileLen%       '& FileLen%
        END SELECT

END SUB

