REM **************************************************************************
REM ****** UNIVERSAL JOYSTICK & GAMES PORT TESTER Release Version 2.0a *******
REM ************** Programming By: Trent Jackson. MARCH 2001 *****************
REM **************************************************************************
REM *********** FINAL RELEASE VERSION WITH AUTO SCALING PROCEDURE ************
REM **************************************************************************

start: CLEAR : CLS : DEFINT A-Z: SCREEN 9: KEY OFF    'standard common settings
DIM circ(1000), circx, circy, joyx, joyy AS INTEGER         'declare variables
DIM ydown, xdown, newsumjoy, oldsumjoy AS INTEGER           'declare variables
DIM joycenterx, joycentrey, calibratex AS INTEGER           'declare variables
DIM cyan, green, red, yellow, white, grey AS INTEGER        'declare variables
DIM xacross, ex, fire1, fire2, joychange AS INTEGER         'declare variables
DIM text1(200), text2(200), calibratey AS INTEGER           'declare variables
DIM text3(400), text4(400), title(2000) AS INTEGER          'declare variables
DIM joystickx, joysticky, button1, button2 AS INTEGER       'declare variables
DIM linecolorfire(2) AS INTEGER, xscale, yscale AS SINGLE   'declare variables
DIM maxjoyx, maxjoyy AS INTEGER '''''''''''''''''''''''''''''declare variables
REM **************************************************************************

REM **************************************************************************
f1$ = CHR$(0) + ";": f2$ = CHR$(0) + "<": f3$ = CHR$(0) + "="   'function keys
f4$ = CHR$(0) + ">": f5$ = CHR$(0) + "?": f6$ = CHR$(0) + "@"   'function keys
cyan = 3: green = 2: red = 4: yellow = 14: white = 15: grey = 8 'define colors
joychange = 1: button1 = 0: button2 = 4      'joystick 1 settings as a default
joycentrex = 170: joycentrey = 145        'defines the center position of grid
maxjoyx = (joycentrex * 2): maxjoyy = (joycentrey * 2)  'defines max grid size
joystickx = 0: joysticky = 1               'start with joystick 1 as a default
FOR i = 0 TO 1:                  'double red boarders for the next info box ok
LINE (98 - i * 4, 116 - i * 4)-(516 + i * 4, 176 + i * 4), red, B: NEXT
LOCATE 10, 15: PRINT "PLEASE ROTATE THE (X) & (Y) KNOBS FULLY CLOCKWISE"
LOCATE 12, 15: PRINT "PRESS ANY KEY TO CONTINUE ......................."
DO UNTIL INKEY$ > CHR$(0): LOOP             'wait for any key to be pressed ok
joyx = STICK(joystickx): joyy = STICK(joysticky)     'get joystick coordinates
IF joyx = 0 OR joyy = 0 THEN GOTO noport:
xscale! = (maxjoyx / joyx): yscale! = (maxjoyy / joyy)       'movement scaling
LINE (0, 0)-(600, 300), 0, BF: FOR i = 0 TO 1:   'double boarders for next box
LINE (114 - i * 4, 116 - i * 4)-(508 + i * 4, 232 + i * 4), red, B: NEXT
LOCATE 10, 17: PRINT "SYSTEM SCALING VARIABLES HAVE BEEN CALCULATED!"
LOCATE 12, 17: PRINT "    NOW PLEASE CENTRE THE (X) & (Y) KNOBS     "
LOCATE 14, 17: PRINT " NEXT YOU MAY NEED TO CALIBRATE THE SOFTWARE  "
LOCATE 16, 17: PRINT "PRESS ANY KEY TO CONTINUE ...................."
DO UNTIL INKEY$ > CHR$(0): LOOP: GOTO dostick: 'wait for any key to be pressed
noport: ''''''if there is no stick or port u are here baby...................
FOR i = 0 TO 2 STEP 2
LOCATE 10 + i, 15: PRINT "                                                 "
NEXT    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
LOCATE 10, 19: PRINT "SYSTEM ERROR UNABLE TO READ THE GAMES PORT"
LOCATE 12, 19: PRINT "PRESS ANY KEY TO CONTINUE ................"
DO UNTIL INKEY$ > CHR$(0): LOOP: xscale! = 2.85: yscale! = 2.35
dostick: joyx = STICK(joystickx): joyy = STICK(joysticky):
circx = (joyx * xscale!): circy = (joyy * yscale!) 'coordinates for the circle
LOCATE 1, 1: PRINT "FIRE 1": GET (0, 0)-(48, 12), text1:    'print text & save
LOCATE 1, 1: PRINT "FIRE 2": GET (0, 0)-(48, 12), text2:    'print text & save
LOCATE 1, 1: PRINT "JOYSTICK 1:": GET (0, 0)-(78, 12), text3'print text & save
LOCATE 1, 1: PRINT "JOYSTICK 2:": GET (0, 0)-(78, 12), text4'print text & save
LOCATE 1, 1: COLOR cyan              'prepare color for the next line, program title
PRINT "UNIVERSAL JOYSTICK & GAMES PORT TESTER. V2.0a"           'program title
GET (0, 0)-(400, 16), title: CLS        'get & save program title as a graphic
CIRCLE (40, 40), (20), green               'draw a circle with a green boarder
PAINT (40, 40), red, green           'paint the circle red until you see green
GET (20, 20)-(60, 60), circ: CLS      'get & save circle then clear the screen
REM **************************************************************************

REM **************************************************************************
REM ''''''''''''''draw a background grid to xor with the transparent circle ok
FOR linesacross = 1 TO 19          'draw 19 horizontal lines across the screen
LINE (10, 30 + ydown)-(370, 30 + ydown), green      'draw 1 of 19 lines across
ydown = ydown + 15: NEXT    'go back & execute again to complete half the grid
FOR linesdown = 1 TO 19                'draw 19 vertical lines down the screen
LINE (10 + xdown, 30)-(10 + xdown, 300), green        'draw 1 of 19 lines down
xdown = xdown + 20: NEXT    'go back & execute again to complete the full grid
LINE (170, 165)-(210, 165), white              'vertical line for centre cross
LINE (190, 150)-(190, 180), white            'horizontal line for center cross
REM now bound the circle to 19 * 19 grid ok
IF circx > 330 THEN circx = 330  'has the circle exceeded the maximum (X) axis
IF circy > 264 THEN circy = 264  'has the circle execeded the maximum (Y) axis
IF circx < 10 THEN circx = 10    'has the circle exceeded the minimum (X) axis
IF circy < 25 THEN circy = 25    'has the circle exceeded the minimum (Y) axis
PUT (circx, circy), circ                         'put new circle on the screen
REM **************************************************************************

REM **************************************************************************
REM draw the various boarders for the screen & the info box ok
LINE (0, 0)-(590, 330), yellow, B          'outside almost full screen boarder
LINE (2, 2)-(588, 328), yellow, B           'inside almost full screen boarder
LINE (416, 10)-(530, 154), yellow, B         'outside boarder for the info box
LINE (420, 155)-(542, 163), grey, BF       'apply a drop shadow for the bottom
LINE (531, 14)-(542, 158), grey, BF    'apply a drop shadow for the right side
LINE (531, 155)-(541, 163), yellow                          'corner angle line
LINE (418, 30)-(528, 127), yellow, B            '(X) & (Y) axis inside boarder
LINE (418, 93)-(472, 127), yellow, B       'fire button (1) status box boarder
LINE (473, 93)-(528, 127), yellow, B       'fire button (2) status box boarder
LINE (6, 331)-(594, 340), grey, BF:    'a drop shadow for bottom of the screen
LINE (591, 6)-(604, 340), grey, BF 'a drop shadow for right side of the screen
LINE (590, 330)-(604, 340), yellow      'corner angle line at bottom of screen
REM **************************************************************************

REM **************************************************************************
REM now print & put some lables and instructions to the screen ok
PUT (10, 10), title, PSET
PUT (422, 134), text1: PUT (478, 134), text2     'fire button (1) & (2) labels
LINE (418, 129)-(472, 152), yellow, B           'fire button (1) label boarder
LINE (473, 129)-(528, 152), yellow, B           'fire button (2) label boarder
COLOR cyan:                 'prepare color for the next five lines of print ok
LOCATE 14, 50: PRINT "PRESS (F1) TO CALIBRATE"  'user instructions keys to use
LOCATE 16, 50: PRINT "PRESS (F2) TO RESET ALL"  'user instructions keys to use
LOCATE 18, 50: PRINT "PRESS (F3)  TO   TOGGLE"  'user instructions keys to use
LOCATE 19, 50: PRINT "BETWEEN JOYSTICKS 1 & 2"  'user instructions keys to use
LOCATE 21, 50: PRINT "PRESS (F4) TO EXIT THIS"  'user instructions keys to use
REM **************************************************************************

REM **************************************************************************
readport:               'return values from games port & compare with old ones
a$ = INKEY$: IF a$ > CHR$(0) THEN GOSUB keyboard  'has the user pressed a key?
COLOR white                     'set the color for the next few lines of print
LOCATE 4, 54: PRINT "(X)Axis:"; joyx      'print (X) coordinates to the screen
LOCATE 6, 54: PRINT "(Y)Axis:"; joyy      'print (Y) coordinates to the screen
oldsumjoy = (joyx + joyy)                         'save old joyx & joyy values
joyx = STICK(joystickx): joyy = STICK(joysticky):    'get joystick coordinates
newsumjoy = (joyx + joyy)                 'save new values for comparing later
fire1 = STRIG(button1):      'return a true or false value for fire button (A)
fire2 = STRIG(button2):      'return a true or false value for fire button (B)
REM **************************************************************************

REM **************************************************************************
REM the next two lines will check if a fire button was pushed. (A) or (B)
IF fire1 = -1 THEN linecolorfire(1) = green ELSE linecolorfire(1) = red
IF fire2 = -1 THEN linecolorfire(2) = green ELSE linecolorfire(2) = red
REM **************************************************************************

REM **************************************************************************
REM update joystick label with current joystick is in use ok
IF joychange = 1 THEN PUT (434, 14), text3, PSET 'has the user selected JOY(1)
IF joychange = 2 THEN PUT (434, 14), text4, PSET 'has the user selected JOY(2)
REM **************************************************************************

REM **************************************************************************
REM now draw the fire button boxes, red for off & green for on ok
xacross = 0: ex = 0: FOR colorbar = 1 TO 2: 'execute the next four lines twice
REM color the box green if a button is pressed if not then color it red ok
LINE (420 + xacross, 95)-(470 + xacross + ex, 125), linecolorfire(colorbar), BF
xacross = 55: ex = 1: NEXT 'include xacross & ex for second box then loop back
REM **************************************************************************

REM **************************************************************************
REM '''''now check if the joystick has moved?. if it has then update screen ok
IF oldsumjoy = newsumjoy THEN GOTO readport           'has the joystick moved?
REM  goto movecircle only if joyx or joyy has changed else go back to readport
REM ''''''''''doing this will increase speed and it will reduce screen flicker
REM **************************************************************************

REM **************************************************************************
movecircle: ''''update screen with circle positions circle must be transparent
REM the next four lines will bound the circle to the 19 * 19 grid
PUT (circx, circy), circ                 'erase the old circle from the screen
circx = (joyx * xscale!) + calibratex'calculate new circle horizontal position
circy = (joyy * yscale!) + calibratey  'calculate new circle vertical position
LOCATE 4, 64: PRINT "   "   'blanking for large (X) axis numbers to small ones
LOCATE 6, 64: PRINT "   "   'blanking for large (Y) axis numbers to small ones
REM the next four lines will bound the circle to the 19 * 19 grid
IF circx > 330 THEN circx = 330  'has the circle exceeded the maximum (X) axis
IF circy > 264 THEN circy = 264  'has the circle execeded the maximum (Y) axis
IF circx < 10 THEN circx = 10    'has the circle exceeded the minimum (X) axis
IF circy < 25 THEN circy = 25    'has the circle exceeded the minimum (Y) axis
PUT (circx, circy), circ    'put the circle on the screen with new coordinates
GOTO readport:       'the new circle has been updated go back & get new values
REM **************************************************************************

REM **************************************************************************
keyboard: 'sortout the keyboard buttons that user has pressed ok
IF a$ = f1$ THEN GOSUB calibrate           'has the user pressed the (F1) key?
IF a$ = f2$ THEN GOTO start                'has the user pressed the (F2) key?
IF a$ = f3$ THEN GOSUB changejoystick      'has the user toggled the (F2) key?
IF a$ = f4$ THEN GOTO endit         'has the user decided to quit the program?
IF a$ < f1$ OR a$ > f4$ THEN BEEP         'has the user pressed a invalid key?
a$ = INKEY$: RETURN   'reset keyboard buffer and go back to main loop readport
REM **************************************************************************

REM **************************************************************************
calibrate:           'this sub will calibrate the joystick to the centre cross
LOCATE 23, 2: COLOR white     'the next few lines will print some instructions
PRINT "PLEASE SET THE (X) & (Y) KNOBS TO THE CENTRE POSITION THEN PRESS ANY KEY"
DO UNTIL INKEY$ > CHR$(0): LOOP'execute this line until a key has been pressed
LOCATE 23, 2 'a key has been pressed so erase the instructions text, next line
PRINT "                                                                        "
REM now calculate the required compensation needed to centre the circle ok
joyx = STICK(joystickx): joyy = STICK(joysticky):    'get joystick coordinates
PUT (circx, circy), circ                 'erase the old circle from the screen
circx = (joyx * xscale!): circy = (joyy * yscale!)   'calculate circle position
calibratex = (joycentrex - circx)       'calculate the horizontal offset value
calibratey = (joycentrey - circy)         'calculate the vertical offset value
circy = (circy + calibratey)                  'now calibrate the vertical axis
circx = (circx + calibratex)                'now calibrate the horizontal axis
circx = (joyx * xscale!) + calibratex'calculate new circle horizontal position
circy = (joyy * yscale!) + calibratey  'calculate new circle vertical position
PUT (circx, circy), circ                     'put the new circle on the screen
RETURN                                      'go back to the keyboard buffer ok
REM **************************************************************************

REM ***************************************************************************
changejoystick:      'this sub is used to toggle between joystick (1) & (2) ok
joychange = joychange MOD 2: joychange = (joychange + 1)  'increment joychange
IF joychange = 1 THEN button1 = 0: button2 = 4:  'define buttons for jostick 1
IF joychange = 1 THEN joystickx = 0: joysticky = 1   '(X) & (Y) for joystick 1
IF joychange = 2 THEN button1 = 2: button2 = 6:  'define buttons for jostick 2
IF joychange = 2 THEN joystickx = 2: joysticky = 3   '(X) & (Y) for joystick 2
RETURN                                      'go back to the keyboard buffer ok
REM **************************************************************************

REM **************************************************************************
endit: CLS
tex1$ = "THANK YOU FOR USING THIS JOYSTICK & GAMES PORT TESTER"      'message
Y = 10: X = 12: ps = 1: COLOR green   'define some variables & set print color
testtimer: cpuspeed! = 0: testtimesample1# = TIMER
synctimer: testtimesample2# = TIMER
IF testtimesample1# = testtimesample2# THEN GOTO synctimer
cpuclock: testtimesample1# = TIMER
countspeed: testtimesample2# = TIMER
cpuspeed! = cpuspeed! + 1  'general routine check the system clock speed
IF testtimesample1# = testtimesample2# THEN GOTO countspeed
resettimer: b! = TIMER: IF b! < .8 THEN GOTO testtimer
increasec:     'this is a timming sub as used for timming a .2 second loop ok
c! = TIMER: d! = .2: IF c! < .8 THEN GOTO testtimer
IF c! - b! < d! THEN GOTO increasec     'is c! too small
en = LEN(tex1$): IF ps = en + 1 THEN GOTO viewtime: 'is the whole string done
tex2$ = LEFT$(tex1$, ps): ps = ps + 1  'get a new characther & put into tex2$
LOCATE Y, X: PRINT tex2$        'print one characther at a time left to right
SOUND 3300, 1                                    'simple typing sound effects
GOTO resettimer:   'repeat the loop until the full string has been printed ok
REM *************************************************************************

REM *************************************************************************
viewtime: b! = TIMER  'a small time delay so the user can read the message ok
IF b! < .8 THEN GOTO viewtime                        'stop the midnight error
increased:      'this is a timming sub as used for timming a 4 second loop ok
d! = TIMER: c! = 4: IF d! < .8 THEN GOTO viewtime    'stop the midnight error
IF d! - b! < c! THEN GOTO increased:                         'is d! too small
CLS : SCREEN 13
FOR i = 1 TO 22: SOUND 220 * i, i / 10: NEXT: FOR i = 1 TO 255:
IF i < 8 THEN GOTO skipchr
COLOR i: PRINT " PRESENTED BY ALPHA PROJECTS 2001 " + CHR$(14) + CHR$(0) + CHR$(i)
skipchr: FOR delay! = 1 TO (cpuspeed! * 8): NEXT: NEXT
REM *************************************************************************
REM *************************************************************************





