
#define _SUPPRESS_PLIB_WARNING
#define _DISABLE_OPENADC10_CONFIGPORT_WARNING
#include "gpsserial.h"
#include "parsegps.h"
#include "uart.h"

char gpsbuf[256];
int gpsbuf_pos;
char gps_alt[16];
unsigned char gps_fix, gps_numsats, gps_detected, gps_fixgood, gps_datetimelatlongood;
unsigned long gps_time, gps_fractime, gps_date, gps_lat, gps_lon;

/*
int gps_detected, gps_fixgood, gps_datetimelatlongood, gps_fixgoodfor, gps_good_counter;
int tz_searching, timezone_found = -1, tz_override = -1;
unsigned long serial_rx_bytes_since_last_valid;

extern unsigned char time_set, date_set;

static unsigned char bcd_to_dec(unsigned char bcd) {
    return (bcd>>4)*10 + (bcd&0x0F);
}

void bcd_time_date_to_decimal(int* timehere, int* datehere, const rtccTime* bcdtime, const rtccDate* bcddate) {
    *datehere = (bcd_to_dec(bcddate->mday) * 100 + bcd_to_dec(bcddate->mon)) * 100 + bcd_to_dec(bcddate->year);
    *timehere = (bcd_to_dec(bcdtime->hour) * 100 + bcd_to_dec(bcdtime->min)) * 100 + bcd_to_dec(bcdtime->sec);
}

static inline unsigned char RtccTimeEqual(const rtccTime* a, const rtccTime* b) {
    return a->sec == b->sec && a->min == b->min && a->hour == b->hour;
}
static inline unsigned char RtccDateEqual(const rtccDate* a, const rtccDate* b) {
    return a->mday == b->mday && a->mon == b->mon && a->year == b->year;
}
*/
#if 0
static unsigned char dec_to_bcd(unsigned char dec) {
    return (unsigned char)((dec/10)<<4)|(dec%10);
}
#endif

static void extract_time_date(rtccTime* timehere, rtccDate* datehere, unsigned long dectime, unsigned long decdate) {
    unsigned char mday, mon, hour, min;//, year;

    mday = (unsigned char)(decdate/10000);
    decdate -= mday * 10000UL;
    mon = (unsigned char)(decdate/100);
    decdate -= mon * 100;

    hour = (unsigned char)(dectime / 10000);
    dectime -= hour * 10000UL;
    min = (unsigned char)(dectime / 100);
    dectime -= min * 100;

    datehere->year = (unsigned char)decdate;
    datehere->mon = (unsigned char)mon;
    datehere->mday = (unsigned char)mday;
    timehere->sec = (unsigned char)dectime;
    timehere->min = (unsigned char)min;
    timehere->hour = (unsigned char)hour;
}

//static unsigned char gps_skip_second_disable;
//static int gps_good_time, num_consecutive_off_by_one_sec;
unsigned char serial_read(unsigned char maxchars, rtccTime* pTime, rtccDate* pDate) {
    while( uartAvailable() && maxchars > 0 ) {
        --maxchars;
        if( gpsbuf_pos ) {
            if( gpsbuf_pos == sizeof(gpsbuf)-2 ) {
                gpsbuf_pos = 0;
            } else {
                gpsbuf[gpsbuf_pos] = uartReceive();
                if( gpsbuf[gpsbuf_pos] == '$' ) {
                    gpsbuf[0] = '$';
                    gpsbuf_pos = 0;
                }
                ++gpsbuf_pos;
                if( gpsbuf_pos > 3 && gpsbuf[gpsbuf_pos-2] == '\r' && gpsbuf[gpsbuf_pos-1] == '\n' ) {
                    gpsbuf[gpsbuf_pos] = '\0';
                    gpsbuf_pos = 0;
                    switch( ParseGPS(gpsbuf, &gps_fix, &gps_numsats, gps_alt, &gps_time, &gps_fractime, &gps_date, &gps_lat, &gps_lon) ) {
                        case GPS_MSG_FIXANDALT:
                            gps_detected = 255;
                            if( gps_fix > 0 ) {
                                gps_fixgood = 10;
                            }
                            break;
                        case GPS_MSG_TIMEDATELATLON:
                            gps_detected = 255;
                            gps_datetimelatlongood = 10;
                            extract_time_date(pTime, pDate, gps_time, gps_date);
                            return 1;
                        default:
                            break;
                    }
                    if( gps_detected < 64 && gpsbuf[0] == '$' && gpsbuf[1] == 'G' && gpsbuf[3] == 'G' && gpsbuf[4] == 'G' && gpsbuf[5] == 'A' && gpsbuf[6] == ',' )
                        gps_detected = 255;
                }
            }
        } else {
            if( uartReceive() == '$' ) {
                gpsbuf[0] = '$';
                gpsbuf_pos = 1;
            }
        }
    }
    return 0;
}
/*
void RtccFixupDOW(rtccDate* date) {
    date->wday = RtccWeekDay(2000 + bcd_to_dec(date->year), bcd_to_dec(date->mon), bcd_to_dec(date->mday));
}
*/