
; automatic car headlights / daytime running lights / headlight reminder
; JP1, JP2 nd JP3 set the OPTIONS (JP3 allows VR1,VR2 and VR3 to alter timeouts on options
; A high beam monitor switches off PWM with high beam

	ERRORLEVEL -302
	ERRORLEVEL -306
	list P=16F88
	#include P16F88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0  & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_OFF & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; non volatile storage
EEPROM1			equ	H'00'	; non-volatile storage for lights on after ignition off period
EEPROM2			equ	H'01'	; non-volatile storage for lights on with central locking period
EEPROM3			equ	H'02'	; non-volatile storage for lights on warning period

; Bank 0 RAM
AN0_L			equ H'20'	; 16-bit ADC accumulators for input channels 0-4
AN0_H			equ H'21'	; daytime lights brightness
AN1_L			equ H'22'	; Light sensitivity
AN1_H			equ H'23'	
AN2_L			equ H'24'	; Delay
AN2_H			equ H'25'
AN3_L			equ H'26'	; Lights on switched or PWM
AN3_H			equ H'27'
AN4_L			equ H'28'	; LDR in
AN4_H			equ H'29'
ADC_CUR_INPUT	equ	H'2A'	; ADC inputs are scanned sequentially, this tracks which one was last read
ADC_PASS		equ H'2B'	; ADC channels are sequentially scanned 256 times for averaging, incrementing this for each pass
DELAY			equ H'2C'	; general delay register used for wait loops
PWM_DUTY		equ	H'2D'	; current PWM duty cycle, 0-80
TEMP			equ H'2E'	; general temporary register
DAY_BRIGHTNESS	equ H'2F'	; value 0-255 to indicate how bright the daytime running lights should be (from trimpot)
THRESHOLD		equ H'30'	; value 0-255 to indicate brightness level which is considered threshold between day and night
LIGHT_DELAY		equ H'31'	; value 0-255 to indicate how long lightness is detected before headlights are switched to daytime mode (from trimpot)
LIGHT_DELAY2	equ H'32'	; similar to above but divided by 16
LIGHT_LEVEL		equ H'33'	; current light level from LDR, 0-191 where 0 indicates complete darkness
LIGHT_ACCUM_L	equ H'34'	; 16-bit counter which is increased/decreased depending on whether LDR detects light or darkness, giving a lights on/off delay when compared with LIGHT_DELAY
LIGHT_ACCUM_H	equ H'35'
DARK			equ	H'36'	; light/dark flag based on LDR and sensitivity control VR1. 
STORE1			equ	H'37'	; delay counter
STORE2			equ	H'38'	; delay counter
STORE3			equ	H'39'	; delay counter
IGN_LOCK		equ	H'3A'	; power up via ignition or central locking flag
VALUES			equ	H'3B'	; A/D values all tallied flag
TEMPX			equ	H'3C'	; temporary storage
TEMPY			equ	H'3D'	; temporary storage
LIGHTS_ON_I		equ	H'3E'	; lights on period for ignition off
LIGHTS_ON_C		equ	H'3F'	; lights on period with central locking
LIGHTS_ON_W		equ	H'40'	; lights left on warning period		
STORE_DUTY		equ	H'41'	; duty cycle store

  
; preset EEPROM values used for options periods
	ORG     2100
 
	DE	D'120'	; initially set at 30s (120 x 250ms) (lights on period after ignition off) JP1 option1
	DE	D'120'	; initially set at 30s (120 x 250ms) (lights on period with central locking)JP2 option2
	DE	D'40'	; initially set at 10s (40 x 250ms) (lights on warning period)OPTION_BUZZER

; reset vector
	org	0
	goto	SETUP
	org	4	; interrupt vector (not used)
	retfie

READADC					; subroutine to do basic job of reading value from current ADC channel
	movlw	D'40'		; delay for 320 clocks for ~20us acquisition time
	movwf	DELAY
ADCDELAY
	decfsz	DELAY,f
	goto	ADCDELAY
	bsf		ADCON0, 2	; start sampling
ADCWAIT
	btfsc	ADCON0, 2	; wait until ADCDONE bit is set
	goto	ADCWAIT
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL, 0	; read low part of result
	bcf		STATUS,RP0	; select memory bank 0
	return				; caller is responsible for reading ADRESH and optionally, ADRESL

INIT_ADC_AVGERAGING		; subroutine to set ADC averaging registers to zero
	movlw	0
	movwf	AN0_L
	movwf	AN0_H
	movwf	AN1_L
	movwf	AN1_H
	movwf	AN2_L
	movwf	AN2_H
	movwf	AN3_L
	movwf	AN3_H
	movwf	AN4_L
	movwf	AN4_H
	movwf	ADC_CUR_INPUT
	movwf	ADC_PASS
	return

DO_ADC_READING			; subroutine to do ADC conversion for current channel, sum into accumulator and check if all readings have been completed
	movlw	B'01000001'	; ADC clock = 16 Tosc, ADC on (bank 0)
	iorwf	ADC_CUR_INPUT, W	; select input which is constantly being cycled 0-4
	movwf	ADCON0		; (bank 0)
	call	READADC		; read the value
	movfw	ADC_CUR_INPUT	; now we need to figure out which channel we just read in order to sum the result into the correct averaging register
	sublw	B'00001000'
	btfsc	STATUS, Z
	goto	ADD_TO_AN1	; jump to code to sum into AN1 averaging register
	movfw	ADC_CUR_INPUT
	sublw	B'00010000'
	btfsc	STATUS, Z
	goto	ADD_TO_AN2	; jump to code to sum into AN2 averaging register
	movfw	ADC_CUR_INPUT
	sublw	B'00011000'
	btfsc	STATUS, Z
	goto	ADD_TO_AN3	; jump to code to sum into AN3 averaging register
	movfw	ADC_CUR_INPUT
	sublw	B'00100000'
	btfsc	STATUS, Z
	goto	ADD_TO_AN4	; jump to code to sum into AN4 averaging register
	movfw	ADRESH		; fall through; only AN0 remains so sum into its averaging register
	addwf	AN0_L, F	; (16-bit add)
	movfw	STATUS
	andlw	1
	addwf	AN0_H, F
FINISH_ADC
	movfw	ADC_CUR_INPUT	; now switch to the next ADC input
	addlw	B'00001000'
	movwf	ADC_CUR_INPUT	; after input AN4, cycle back to AN0
	sublw	B'00101000'
	btfss	STATUS, Z
	return					; if we just sampled AN0-3, our job is done so return
	movwf	ADC_CUR_INPUT	; when we go back to AN0, we increment the pass register
	incf	ADC_PASS, F
	btfss	STATUS, Z
	return	
	
	; pass 0-254, averaging not complete so return
	call	ADC_READ_COMPLETE	; OK, all readings complete so do whatever needs to be done with those values...
	call	INIT_ADC_AVGERAGING	; then zero out the registers to start again
	return
ADD_TO_AN1					; sum into AN1 averaging register
	movfw	ADRESH
	addwf	AN1_L, F
	movfw	STATUS
	andlw	1
	addwf	AN1_H, F
	goto	FINISH_ADC
ADD_TO_AN2					; sum into AN2 averaging register
	movfw	ADRESH
	addwf	AN2_L, F
	movfw	STATUS
	andlw	1
	addwf	AN2_H, F
	goto	FINISH_ADC
ADD_TO_AN3					; sum into AN3 averaging register
	movfw	ADRESH
	addwf	AN3_L, F
	movfw	STATUS
	andlw	1
	addwf	AN3_H, F
	goto	FINISH_ADC
ADD_TO_AN4					; sum into AN4 averaging register
	movfw	ADRESH
	addwf	AN4_L, F
	movfw	STATUS
	andlw	1
	addwf	AN4_H, F
	goto	FINISH_ADC

PWM_DUTY_FROM_8BIT			; subroutine to convert a PWM duty cycle of 0-255 to what's required for 25kHz PWM with an
; 8MHz clock, which is value 0-80
	; divide result by 8 to give a reading of 0-31
	bcf		STATUS,C	; clear carry bit
	rrf		PWM_DUTY, F
	bcf		STATUS,C	; clear carry bit
	rrf		PWM_DUTY, F
	bcf		STATUS,C	; clear carry bit
	rrf		PWM_DUTY, F
	; copy this and divide by 16
	movfw	PWM_DUTY
	movwf	TEMP
	bcf		STATUS,C	; clear carry bit
	rrf		TEMP, F
	bcf		STATUS,C	; clear carry bit
	rrf		TEMP, F
	bcf		STATUS,C	; clear carry bit
	rrf		TEMP, F
	bcf		STATUS,C	; clear carry bit
	rrf		TEMP, W
	addwf	PWM_DUTY, F	; add this back in to the original result which gives 0-32

	; copy this and multiply by four
	movfw	PWM_DUTY
	movwf	TEMP
	bcf		STATUS,C	; clear carry bit
	rlf		TEMP, F
	rlf		TEMP, W
	addwf	PWM_DUTY, F	; add to original value, effectively multiplying it by five
	; result is now 0-160, divide by 2 to get a value from 0-80
	bcf		STATUS,C	; clear carry bit
	rrf		PWM_DUTY, F
	return

ADC_READ_COMPLETE			; subroutine which is called when AN0-4 have all been read and averaged 256 times. Most of the actual work is done here.

; check startup
	btfsc	PORTA,7			; ignition input
	bsf		IGN_LOCK,0		; power up via ignition or central locking flag	(ign=1, lock=0)
	bsf		VALUES,0		; set values accessed flag

	movfw	AN0_H			; the value for AN0 is the daytime running lights duty cycle so store that
	movwf	DAY_BRIGHTNESS
	movfw	AN1_H			; the value for AN1 is the light/dark threshold value
	movwf	THRESHOLD
	movfw	AN2_H			; AN2 gives us the delay value which determine how quickly to switch the lights on/off with a change in brightness
	movwf	LIGHT_DELAY
	andwf	LIGHT_DELAY		; if it's zero, set it to one or else the lights will never come on
	btfsc	STATUS,Z
	incf	LIGHT_DELAY, F
	movfw	LIGHT_DELAY
	movwf	LIGHT_DELAY2	; this is the value above divided by 16, it's used by the delay logic
	bcf		STATUS,C	; clear carry bit
	rrf		LIGHT_DELAY2, F
	bcf		STATUS,C	; clear carry bit
	rrf		LIGHT_DELAY2, F
	bcf		STATUS,C	; clear carry bit
	rrf		LIGHT_DELAY2, F
	bcf		STATUS,C	; clear carry bit
	rrf		LIGHT_DELAY2, F
	andlw	0
	btfsc	STATUS,Z
	incf	LIGHT_DELAY2, F	; make sure LIGHT_DELAY2 is never zero even if LIGHT_DELAY is less than 16
	movfw	AN4_H			; AN4 gives the LDR reading but we compute 192-x for LIGHT_LEVEL since this is inverse. Readings above 192 give zero (uncommon).
	sublw	H'C0'
	btfss	STATUS, C
	movlw	H'00'
	movwf	LIGHT_LEVEL
;	movwf	TEMP
;	bcf		STATUS,C	; clear carry bit
;	rrf		TEMP, F
;	bcf		STATUS,C	; clear carry bit
;	rrf		TEMP, W
	incf	PWM_DUTY, W		; now we introduce some hystersis for light level detection. If PWM duty cycle is 100% (ie, headlights are on), reduce the value of LIGHT_LEVEL by up to 16, as if it's darker outside than it actually is.
	btfsc	STATUS, C
	goto	NO_HYSTERESIS
	movlw	16
	subwf	LIGHT_LEVEL, F
	btfss	STATUS, C
	clrf	LIGHT_LEVEL		; if LIGHT_LEVEL < 16 when hysteresis is active then just set it to zero
NO_HYSTERESIS

	movfw	LIGHT_LEVEL		; compare light level to threshold (hysteresis already applied)
	subwf	THRESHOLD, W
	btfss	STATUS, C
	goto	INCREASE_ACCUM	; if it's above, increase the value in LIGHT_ACCUM (16-bit) by 128
	movfw	LIGHT_DELAY2	; if it's below, subtract LIGHT_DELAY2 from LIGHT_ACCUM (16-bit) which gives a more or less constant time for it to reach zero, regardless of the LIGHT_DELAY setting
	subwf	LIGHT_ACCUM_H, F
	btfss	STATUS, C
	clrf	LIGHT_ACCUM_L
	btfss	STATUS, C
	clrf	LIGHT_ACCUM_H

	bsf		DARK,0	; set dark flag (set for Darkness)

	goto	DECREASE_ACCUM
INCREASE_ACCUM
	bcf		DARK,0	; clear dark flag (clear for in light)

	movlw	H'80';LIGHT_DELAY2
	addwf	LIGHT_ACCUM_L, F
	movfw	STATUS
	andlw	1
	addwf	LIGHT_ACCUM_H, F
	movlw	H'FF'
	btfsc	STATUS, C
	movwf	LIGHT_ACCUM_L
	btfsc	STATUS, C
	movwf	LIGHT_ACCUM_H
DECREASE_ACCUM

	movfw	LIGHT_DELAY		; now that that has been done, we compare the top 8 bits of the accumulator to the delay setting and this determines whether we should run the lights at 100% duty cycle or reduced (daytime running) level
	subwf	LIGHT_ACCUM_H, W
	movfw	DAY_BRIGHTNESS
	btfss	STATUS, C
	movlw	H'FF'			; 255 = maximum duty cycle when LIGHT_ACCUM_H > LIGHT_DELAY
	movwf	PWM_DUTY
	call	PWM_DUTY_FROM_8BIT	; convert the 8-bit value to 0-80 as required by the PWM hardware at 25kHz
	return

SETUP					; subroutine to initialise registers for program
	clrf	STATUS		; set LIGHT_ACCUM to 65535 initially (not sure if this is the best choice but it's OK for now)
	clrf	LIGHT_ACCUM_L
	decf	LIGHT_ACCUM_L, F
	clrf	LIGHT_ACCUM_H
	decf	LIGHT_ACCUM_H, F	
	clrf	IGN_LOCK	; power up via ignition or central locking flag	cleared initially 
	clrf	VALUES		; A/D values all tallied flag	

; set up inputs & outputs
	clrf	PORTA
	clrf	PORTB
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'10111111'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register (bank 1)
	movlw	B'00111010'	; outputs (0) and inputs (1)
	movwf	TRISB		; port B data direction register (bank 1)
	movlw	B'00000000'	; 
	movwf	OPTION_REG	; pullups enabled 

	; set up clock
	movlw	B'01110000'	; 8MHz INTOSC
	movwf	OSCCON		; change oscillator mode (bank 1)

	; set up PWM
	movlw	D'79'
	movwf	PR2			; set PWM period to 80, ie, 25kHz (8MHz / 4 / 80) (bank 1)
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00000100'	; timer 2 on with minimum prescaler ratio
	movwf	T2CON		; (bank 0)
	movlw	B'00001100'	; CCP1 unit in PWM mode
	movwf	CCP1CON		; (bank 0)
	movlw	D'0'
	movwf	CCPR1L		; set PWM duty cycle to 0% (bank 0)

	; set up ADC
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00011111'	; analog inputs
	movwf	ANSEL
	movlw	B'01000000' ; left justified, ADCS2 = 1 (bank 1)
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'01001001'	; ADC clock = 16 Tosc, channel = 1 (RA1), ADC on (bank 0)
	movwf	ADCON0

	call	INIT_ADC_AVGERAGING; clear values

	clrf	PORTA		; buzzer off
	clrf	PWM_DUTY	; PWM duty cycle = 0

; read EEPROM values & place in registers
	movlw	EEPROM1
	call	EEREAD
	movwf	LIGHTS_ON_I		; lights on period for ignition off
	movlw	EEPROM2
	call	EEREAD
	movwf	LIGHTS_ON_C		; lights on period with central locking
	movlw	EEPROM3
	call	EEREAD
	movwf	LIGHTS_ON_W		; lights left on warning period		

; ************************************************************************
OPTION2 ; set with JP2
; JP2 option allows lights on after doors opened with central locking with LDR light detection showing dark.
	btfsc	PORTB,5		; if low then JP2 option
	goto	WAIT_IGN	; not this option

	movlw	D'25'		; 25ms
	call	DELAYZ

	bsf		PORTB,2		; maintain supply to regulator
	
	movlw	D'25'		; 25ms
	call	DELAYZ
CONTINUE
	call	DO_ADC_READING; get values especially LDR
	btfss	VALUES,0	; wait for all A/D values first tallied
	goto	CONTINUE
	
	btfsc	PORTA,7		; if low then ignition power is off
	goto	OPTIONSX
	btfss	DARK,0		; LDR state dark or light (set = dark, clear = light)
	goto	SHUTDOWN2	; only switch on lights in darkness

; clear tail lights output at RB6, RB7
	movf	PORTB,w
	andlw	B'00000100'; keep RB2, clear RB6,RB7
	nop
	nop
	nop
	movwf	PORTB		; output drive for tail lights off

; set PWM at say 75%
	bsf		STATUS,RP0	; select memory bank 1
	movlw	D'79'
	movwf	PR2			; set PWM period to 80, ie, 25kHz (8MHz / 4 / 80) (bank 1)
	bcf		STATUS,RP0	; select memory bank 0
	movlw	D'60'
	movwf	CCPR1L		; set PWM duty cycle to 75% (bank 0)

; set delay period
; during delay, check RA7

	movf	LIGHTS_ON_C,w	; lights on period with central locking =value x 250ms
	movwf	STORE3
COUNTDOWN2
	movlw	D'250'		; 250ms
	call	DELAYZ
	
	btfsc	PORTA,7		; if low then ignition power is off
	goto	OPTIONSX

	decfsz	STORE3,f
	goto	COUNTDOWN2	; total decremented period
	goto	SHUTDOWN2

OPTIONSX
	bcf		PORTB,2		; cease supply to regulator
	goto	MAINLOOP

; shutdown, light off
SHUTDOWN2
	movlw	D'00'
	movwf	CCPR1L		; set PWM duty cycle to 0% (bank 0)
	bcf		PORTB,2		; shut down supply to regulator
	movlw	D'250'		; 250ms
	call	DELAYZ		; time to switch off

WAIT_IGN; wait till ignition is on (or overall power shutdown with RB2 low, closes down the PIC)

	movlw	D'250'		; 250ms
	call	DELAYZ
	btfss	PORTA,7		; ignition on or off
	goto	WAIT_IGN	; ignition is off
; ignition on so continue

; ***************************************************************************

MAINLOOP
	call	DO_ADC_READING	; this does an ADC reading for one channel and when it has enough for all channels to compute
	; average values, calls the ADC_READ_COMPLETE subroutine which does most of the actual work


; check RB1 input for high beam, stopping drive to low beam via PWM drive

	btfss	PORTB,1
	goto	OPTIONS			; when low, high beam is off
; high beam is set
	movf	CCPR1L,w		; keep PWM value
	movwf	STORE_DUTY		; duty cycle store
	clrf	CCPR1L			; PWM duty off
	
; wait for high beam to be off
HB	
	btfsc	PORTB,1			; when low, high beam is off
	goto	HB				; High beam on
	movlw	D'100'			; 100ms
	call 	DELAYZ			; delay to wait for HB level to drop on RB1 input
	btfsc	PORTB,1			; recheck level. When low, high beam is off
	goto	HB				; High beam on
	movf	STORE_DUTY,w	; return to original duty cycle from storage
	movwf	CCPR1L

; *********************************************************************
OPTIONS; (OPTION2 is at startup section above)

	btfss	VALUES,0	; wait for all A/D values first tallied
	goto	BYPASS		; bypass options

OPTION3 ; set with JP3
; JP3 allows setting the delay periods with VR1, VR2 and VR3 setting OPTION1 period, OPTION2 period and OPTION_BUZZER warning period

	btfsc	PORTB,3
	goto	OPTION1
	
	; 	get VR1, VR2, VR3 values (THRESHOLD, DAY_BRIGHTNESS & LIGHT_DELAY)
	;	and place into: 
	;					LIGHTS_ON_I		; lights on period for ignition off
	;					LIGHTS_ON_C		; lights on period with central locking
	;					LIGHTS_ON_W		; lights left on warning period	
; VR1
	movf	THRESHOLD,w	; VR1 value
	andlw	B'11111100'	; ms 6-bits only
	iorlw	B'00000011'	; minimum of 4
	movwf	LIGHTS_ON_I	; lights on period for ignition off

; VR2
	movf	DAY_BRIGHTNESS,w ; VR2 value		
	andlw	B'11111100'	; ms 6-bits only
	iorlw	B'00000011'	; minimum of 4
	movwf	LIGHTS_ON_C	; lights on period with central locking

; VR3
	movf	LIGHT_DELAY,w ; VR3 value
	andlw	B'11111100'	; ms 6-bits only
	iorlw	B'00000011'	; minimum of 4
	movwf	LIGHTS_ON_W	; lights left on warning period

; write to EEPROM 1,2,3 if required (ie if changed)
; EEPROM1
	movlw	EEPROM1
	call	EEREAD			; result in W (EEADR set for EEPROM1)
	xorwf	LIGHTS_ON_I,w	; compare with lights on period for ignition off
	btfsc	STATUS,Z		; check if equal
	goto	COMPARE2		; the same so bypass write and check next values
	movf	LIGHTS_ON_I,w	; lights on period for ignition off
	call	EEWRITE			; write to EEPROM
; EEPROM2
COMPARE2
	movlw	EEPROM2
	call	EEREAD			; result in W (EEADR set for EEPROM2)
	xorwf	LIGHTS_ON_C,w	; compare with lights on period for central locking
	btfsc	STATUS,Z		; check if equal
	goto	COMPARE3		; the same so bypass write and check next values
	movf	LIGHTS_ON_C,w	; lights on period central locking
	call	EEWRITE			; write to EEPROM
; EEPROM3
COMPARE3
	movlw	EEPROM3
	call	EEREAD			; result in W (EEADR set for EEPROM3)
	xorwf	LIGHTS_ON_W,w	; compare with lights left on warning period	
	btfsc	STATUS,Z		; check if equal
	goto	OPTION1			; the same so bypass write 
	movf	LIGHTS_ON_W,w	; lights left on warning period	
	call	EEWRITE			; write to EEPROM

OPTION1; set with JP1
; JP1 option allows lights on after ignition switchoff with LDR light detection showing dark.
	btfsc	PORTB,4		; if low then JP1 option
	goto	OPTION_BUZZER
	bsf		PORTB,2		; maintain supply to regulator

	btfsc	PORTA,7		; if low then power is off
	goto	OPTION_BUZZER

	call	LIGHTS_ON	; check if lights left on
	btfss	DARK,0		; LDR state dark or light (set = dark, clear = light)
	goto	SHUTDOWN1

; set PWM at say 75%

	bsf		STATUS,RP0	; select memory bank 1
	movlw	D'79'
	movwf	PR2			; set PWM period to 80, ie, 25kHz (8MHz / 4 / 80) (bank 1)
	bcf		STATUS,RP0	; select memory bank 0
	movlw	D'60'
	movwf	CCPR1L		; set PWM duty cycle to 75% (bank 0)

; clear tail lights output at RB6, RB7
	movf	PORTB,w
	andlw	B'00000100'; keep RB2, clear RB6,RB7
	nop
	nop
	nop
	movwf	PORTB		; output drive for tail lights off

; check if lights left on 

	call	LIGHTS_ON	; check if lights left on

; set delay 
; during delay, check RA7
	movf	LIGHTS_ON_I,w	; lights on period for ignition off, Value x 250ms
	movwf	STORE3
COUNTDOWN1
	movlw	D'250'		; 250ms
	call	DELAYZ
	
	btfsc	PORTA,7		; if low then power off
	goto	OPTION_BUZZER

	decfsz	STORE3,f
	goto	COUNTDOWN1	; total period continues
; shutdown
SHUTDOWN1
	bcf		PORTB,2		; shut down supply to regulator
	movlw	D'250'		; 250ms
	call	DELAYZ		; time to switch off

OPTION_BUZZER ; option works with buzzer installed
; check if lights left on 

	bsf		PORTB,2		; maintain supply to regulator
;	check for power off
	btfss	PORTA,7		; if low then power off
	call	LIGHTS_ON	; check if lights left on
	
BYPASS	; starts normal run mode

; now look at what PWM_DUTY has been set to and update the actual PWM output.
; the duty cycle shouldn't be set to 100% so we need to handle this differently - reduce the frequency and set the duty cycle to ~99.5% so that the boost capacitor occasionally recharges
	movlw	D'80'
	subwf	PWM_DUTY, W
	btfss	STATUS, Z
	goto	SETDUTY

	; set duty cycle to maximum
	bsf		STATUS,RP0	; select memory bank 1
	movlw	D'255'
	movwf	PR2			; set PWM period to 256, ie, 7.8125kHz (8MHz / 4 / 255) (bank 1)
	bcf		STATUS,RP0	; select memory bank 0
	movlw	D'255'
	movwf	CCPR1L		; set PWM duty cycle to 99.6% (255/256) (bank 0)

; set tail lights output (RB6,RB7)
	movf	PORTB,w
	andlw	B'00000100'	; keep RB2
	iorlw	B'11000000'	; set RB6,RB7
	nop
	nop
	nop
	movwf	PORTB		; output drive for tail lights on
	
	goto	MAINLOOP

SETDUTY
	; use this as the new PWM duty cycle
	bsf		STATUS,RP0	; select memory bank 1
	movlw	D'79'
	movwf	PR2			; set PWM period to 80, ie, 25kHz (8MHz / 4 / 80) (bank 1)
	bcf		STATUS,RP0	; select memory bank 0
	movfw	PWM_DUTY
	movwf	CCPR1L		; set PWM duty cycle (bank 0)

; clear tail lights output (RB6,RB7)
	movf	PORTB,w
	andlw	B'00000100'	; keep RB2, clear RB6,RB7
	nop
	nop
	nop
	movwf	PORTB		; output drive for tail lights off
		
	goto	MAINLOOP

; SUBROUTINES
; *************************************
; Check if lights left on subroutine
LIGHTS_ON
	bsf		PORTB,2		; maintain supply to regulator
; store CCPR1L
	movf	CCPR1L,w
	movwf	TEMPX
; set at 0
	clrf	CCPR1L
	movlw	D'10'		; PWM drive off for 10ms
	call	DELAYZ		
; check AN3 input for voltage	
	movf	ADCON0,w
	movwf	TEMPY		; store setting and channel
	movlw	B'01011001'	; ADC clock = 16 Tosc, channel = 3  ADC on (bank 0)
	movwf	ADCON0		; set channel 3
	call	READADC		; read channel 3
	movf	ADRESH,w
	sublw	D'50'		; Check value. check if below 50
	btfsc	STATUS,C
	goto	RESTORE		; lights are off; if lower than Check value, return 
; higher
; sound warning and check channel 3 for lights off
	movf	LIGHTS_ON_W,w	; lights left on warning period,	Value x 250ms	
	movwf	STORE3	
	bcf		STATUS,C
	rrf		STORE3,f		; divide by 2 (since ALARM below is 250ms on 250ms off) and LIGHTS_ON_W
; is set for a single 250ms repeat for 4-63s timeout alarm period.
; if high sound warning for 10s and return
ALARM
	bsf		PORTA,6		; buzzer on 

; Alarm period = (LIGHTS_ON_W divided by 2 x (250ms on time + 250ms for off time))
	
	movlw	D'250'		; 250ms		; warning! Changes will affect alarm timeout
	call	DELAYZ		; timer
	bcf		PORTA,6		; buzzer off
	movlw	D'250'		; 250ms		; warning! Changes will affect alarm timeout
	call	DELAYZ		; timer

; check lights again
	call	READADC		; read channel 3
	movf	ADRESH,w
	sublw	D'50'		; check if below 50
	btfsc	STATUS,C
	goto	RESTORE		; lights are off
 	decfsz	STORE3,f
	goto	ALARM

RESTORE
	bcf		PORTA,6		; buzzer off

	; restore PWM
	; restore analog channel
; restore CCPR1L
	movf	TEMPX,w
	movwf	CCPR1L
	
; restore analog channel	
	movf	TEMPY,w
	movwf	ADCON0		; restore setting and channel

; clear PORTB,2 if JP1 high
	btfsc	PORTB,4		; ie enable check of JP1 power off, lights on selection
	bcf		PORTB,2		; power off via Q1,Q2
	return


; **********************************		
; Time delay
DELAYZ
	movwf	STORE1		; delay value 1=1ms 
LOOPZ2
	movlw	D'255'
	movwf	STORE2
LOOPZ1
	nop
	nop
	nop
	nop
	nop
	decfsz	STORE2,f
	goto	LOOPZ1
	decfsz	STORE1,f
	goto	LOOPZ2
	return

; subroutine to read EEPROM memory 

EEREAD
	bsf 	STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM
EWRITE
EEWRITE	
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register

	bsf 	STATUS,RP0	; select memory bank 3
WR3	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE	; disable interrupts
	bcf		EECON1,EEPGD
	bsf		EECON1,WREN	; enable write
	movlw	H'55'		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit

WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 	STATUS,RP0	; select memory bank 0
	return				; value written 


	END
