;issues

;
;


	list	p=16f84
	__config 	0x3ff1	;cp=off, pwrt=on, wdt=off, osc=xt 

;       RAM Definition
	__MAXRAM 	H'CF'
	__BADRAM 	H'07', H'50'-H'7F', H'87'


w	equ	0x00
c	equ	0x00
f	equ	0x01
z	equ	0x02
t0if	equ	0x02
rp0	equ	0x05

indf	equ	0x00
tmr0	equ	0x01
pcl	equ	0x02
status	equ	0x03
fsr	equ	0x04
porta	equ	0x05
portb	equ	0x06
pclath	equ	0x0a
intcon	equ	0x0b

trisa	equ	0x85
trisb	equ	0x86
option_reg	equ	0x81
	
w_temp	equ	0x0c
status_temp	equ	0x0d
temp	equ	0x0e
modenumber	equ	0x0f
dcounter	equ	0x10
tconst0	equ	0x11
tcount0	equ	0x12
tconst1	equ	0x13
tcount1	equ	0x14
sec1	equ	0x15
sec10	equ	0x16
min1sec	equ	0x17
min10sec	equ	0x18
min1	equ	0x19
min10	equ	0x1a
hr1	equ	0x1b
hr10	equ	0x1c
pm	equ	0x1d
hr12	equ	0x1e
hr24	equ	0x1f
alarmmin1	equ	0x20
alarmmin10	equ	0x21
alarmhr1	equ	0x22
alarmhr10	equ	0x23
alarmpm	equ	0x24
alarmhr12	equ	0x25
alarmhr24	equ	0x26
soundalarm	equ	0x27
trisa0	equ	0x28
trisa1	equ	0x29
trisa2	equ	0x2a
trisa3	equ	0x2b
trisa4	equ	0x2c
andb0	equ	0x2d
andb1	equ	0x2e
andb2	equ	0x2f
andb3	equ	0x30
display	equ	0x31
melodynumber	equ	0x32
melodyh	equ	0x33
melodyl	equ	0x34
melodylength	equ	0x35
melodyrepeat	equ	0x36
notepointer	equ	0x37
note	equ	0x38
notenumber	equ	0x39
toggler	equ	0x3a
period	equ	0x3b
hdquvrconst	equ	0x3c
hdquvrcount	equ	0x3d
displayconst	equ	0x3e
displaycount	equ	0x3f
pauselength	equ	0x40
notelength	equ	0x41
tasks	equ	0x42
taskpointer	equ	0x43
jumps	equ	0x44
loops	equ	0x45
fraction	equ	0x46
modeptr	equ	0x47
last_min1	equ	0x48
trisa_temp	equ	0x49
dcounter_old	equ	0x4a
dcounter_flag	equ	0x4b
last_display	equ	0x4c
init	equ	0x4d
dimconst	equ	0x4e
	
			; 4.000 000 Mhz gives 500,000 tmr0 cycles per second
			; 500,000 decimal = 0x07a120 hex 
			; for my oscillator = 0x07a0e4 hex (499,940 Hz)
			; 
 			;
	movlw	0x07	; <= *** adjust here if needed for different frequency
	movwf	tconst1	;    default high byte of frequency, tconst1 = 0x07
	incf	tconst1,w	
	movwf	tconst1	; 
	movwf	tcount1	; 
	movlw	0xa0	; <= *** adjust here if needed for different frequency
	movwf	tconst0	;    default mid byte of frequency, tconst0  = 0xa1
	movwf	tcount0	; 
	movlw	0xee	; <= *** adjust here if needed for different frequency
	movwf	fraction	;    default low byte of frequency, fraction = 0x20 

	movlw	0x0D	;set initial time to thirteen hrs 23 mins
	movwf	hr24
	movlw	0x01	;ie 1:23:00pm
	movwf	hr12
	movwf	hr1
	movwf	pm
	movlw	0x0a
	movwf	hr10
	movwf	min10sec	;set min10 in seconds display to be blank
	movlw	0x02
	movwf	min10
	movlw	0x03
	movwf	min1
	movwf	last_min1
	clrf	sec10
	clrf	sec1
	movlw	0x07	;set alarm to seven am
	movwf	alarmhr24
	movwf	alarmhr12	;07:00:00am
	movwf	alarmhr1
	clrf	alarmpm
	movlw	0x0a
	movwf	alarmhr10
	clrf	alarmmin10
	clrf	alarmmin1
	
	movlw	0x03
	movwf	modenumber	;set display to hrmin
	movlw	0x0a	;
	movwf	tasks	;set 10 tasks
	incf	tasks,w
	movwf	taskpointer	;initialise taskpointer

	bsf	status,rp0	;select bank 1
	movlw	0x50	;set option_reg to TOCS=0 (internal),PSA=0 (tmr0),
	movwf	option_reg	;tmr0 prescaler = 1 in 2, port b pullups on
	clrf	trisb	;make port b all outputs

	bcf	status,rp0	;select bank 0
	movlw	B'11101110'	;bit 4 always an 0 for output (for the buzzer)
	movwf	trisa4	;
	movwf	trisa3	;0 makes a0 an output
	movlw	B'11101101'
	movwf	trisa2	;0 makes a1 an output
	movlw	B'11101011'	
	movwf	trisa1	;0 makes a2 an output
	movlw	B'11100111'	
	movwf	trisa0	;0 makes a3 an output

	movlw	0xff	;
	movwf	andb0	;and a blank to b0
	movlw	0x7f
	movwf	andb1	;and a dp to b1
	movwf	andb2	;and a dp to b2
	movwf	andb3	;and a dp to b3
	movlw	0xfd	;set up the init melodies (2,1 then 3)
	movwf	init

;	this program plays the default silent melody over and over.
;	silent melody is a pause (note 0x00) repeated (ie no sound)
;	Program checks which melody to play next while doing housekeeping playing a note.
;	Button beeps are programmed as different nonrepeating melodies.

;	The first byte returned is saved as melodylength. 
;	Melodylength is b7 to b1. The melodyrepeat flag is b0.
;	subsequent bytes are the notes.

;	b0 is the note pause bit, if b0 = 1, pause 1/32 sec until the next note	
;	b1:2 is the negative notelength in quavers (1/8 sec)
;		ie 11 = a quaver, 10 = a crotchet, 
;		   01 = dotted crotchet, 00 = a minim
;	b7:3 is the midi notenumber, with 0 as a pause.

silentmelody	clrf	melodynumber	;silence is melodynumber=0 
 
playmelody	movf	hr24,w	;- IS IT TIME TO DIM? - 
	sublw	0x06	; <= *** last hour to dim (in hexadecimal)***
	bcf	dcounter_flag,4
	btfsc	status,c	; c is set if 6 - hr24 >= 0 
	bsf	dcounter_flag,4; so before 7am the flag is set high

	movlw	0x14	; <= *** first hour to dim (in hexadecimal)***
	subwf	hr24,w	; 
	btfsc	status,c	; c is set if hr24 - 20 >= 0 
	bsf	dcounter_flag,4; so after 8pm the flag is set high

	bsf	porta,4
	btfss	init,7
	goto	not_init

	comf	init,w	;play initial melodies 2,1 then 3 at startup
	btfsc	status,z
	movlw	0x03
	movwf	melodynumber	
	incf	init,f
		
not_init	clrf	notepointer
	clrf	melodyrepeat
	call	getmelodyaddr
	movwf	melodyl
	call	getnotedata
	movwf	melodylength
	bcf	status,c	;clear carry bit
	rrf	melodylength,f	;roll off the repeat bit
	rlf	melodyrepeat,f	;roll on the repeat bit

nextnote	incf	notepointer,f
	call	initnote
	movf	notepointer,w
	btfsc	status,z	
	goto	playmelody	;If notepointer = 0, go back to playmelody
	xorwf	melodylength,w
	btfss	status,z
	goto	nextnote	;If melodylength <> notepointer loop to nextnote

			;If melodylength = notepointer then:
	btfsc	melodyrepeat,w	;
	goto	playmelody	;         If melodyrepeat=1 start the melody again
	goto	silentmelody	;         If melodyrepeat=0 go back to silentmelody

initnote	call	getnotedata
	movwf	note	
	movf	note,w	; - notenumber	-
	andlw	0xf8
	movwf	notenumber	
	bcf	status,c	;clear carry flag
	rrf	notenumber,f	;move b7:3 to b4:0
	rrf	notenumber,f
	rrf	notenumber,f	
	clrf	toggler	; - initoggler -
	movf	notenumber,f	;disable the toggler
	btfss	status,z	;test if note is a pause (notenumber=0)
	bsf	toggler,4	;if notenumber not zero, enable the toggler
	call	getperiod	; - period -	
	movwf	period
	call	gethdquvrconst	; - hdquvrcount -	
	movwf	hdquvrconst	; 8 quavers=1 sec, 32 hemidemiquavers=1 sec
	movwf	hdquvrcount	; hdquvrconst = number of cycles in 1/32 sec
	movwf	displayconst	
	bcf	status,c
	rrf	displayconst,f		
	bcf	status,c
	rrf	displayconst,f	
	bcf	status,c
	rrf	displayconst,f	; displayconst = number of cycles in 1/128 sec
	movf	displayconst,w	
	movwf	displaycount
	bcf	status,c
	rrf	displayconst,w
	movwf	dimconst
	bcf	status,c
	rrf	dimconst,w
	movwf	dimconst
	bcf	status,c
	rrf	dimconst,w
	movwf	dimconst
	bcf	status,c
	rrf	dimconst,w
	subwf	displayconst,w
	movwf	dimconst	; dimconst = no of cycles in 15/16 of dispconst

	movf	note,w	; - pauselength	
	andlw	0x01
	movwf	pauselength
	movf	note,w	; - notelength	
	andlw	0x06	; get bits 1 and 2 (negative quavers)
	sublw	0x08	; make them positive 
	movwf	notelength	; 
	bcf	status,c	; multiply quavers by four (to get no of hdqs)
	rlf	notelength,f	; ie move b2:1 to b3:2
	movf	pauselength,w	; and subtract an hdq pause if there is one
	subwf	notelength,f

playnote	movf	toggler,w	;toggle a4		12
	xorwf	porta,f	;		13
	;nop		;*** debug ***
	call 	waitperiod	;wait period uS	2
	movf	notepointer,w
	btfsc	status,z	;if notepointer reset 	4
	return		;return to nextnote (and then play new melody)

	decf	displaycount,w	;dec displaycount	6
	btfsc	status,z	;when displaycount=0
	bsf	dcounter_flag,0; set counter flag
	btfsc	status,z
	movf	displayconst,w	;and reset displaycount
	movwf	displaycount	;		11
	movf	toggler,w	;toggle a4 again	12		
	xorwf	porta,f	;		13	
	;nop		;*** debug ***
	call 	waitperiod	;wait period uS	2
	movf	notepointer,w
	btfsc	status,z	;if notepointer reset 	4
	return		;return to nextnote (and then play new melody)
	nop		
	nop		;nops to balance cycles
	movf	hdquvrconst,w	;		8
	decfsz	hdquvrcount,f	;when hdquvrcount>0,	 
	goto	playnote	;keep playing note	10
	movwf	hdquvrcount	;else reset it, and dec notelength
	decfsz	notelength,f	;if notelength>0, 	
	goto	playnote	; keep playing the note	
	btfss	pauselength,0	;else, if pauselength = 0 
	return		;return to nextnote
 	bsf	notelength,0	;else do a pause first, make notelength = 1
	clrf	pauselength	;clear the pause
	clrf	toggler	;disable the toggler
	goto	playnote	;then play a 1/32 sec pause

waitperiod	movlw	0x1f	;14
	movwf	jumps
	movlw	0x1e	;*** 31 or whatever the overhead is
	subwf	period,w	;	17
	movwf	loops
	andlw	0x1f	;jumps is 31-(b4:0) 	19
	subwf	jumps,f	;
	subwf	loops,f	;clear b4:0 in loops
	swapf	loops,f	;put b7:5 (loops) in 3:1
	bcf	status,c	;	23
	rrf	loops,f	;then roll down to b2:0
	incf	loops,f	;and add one	25
	movlw	0x00	
	movwf	pclath	;	27
	movf	jumps,w	;jump the requisite jumps
	addwf	pcl,f	;using computed goto	29

	nop		;0x1f
	nop
	nop
	nop

	nop		;0x1b
	nop
	nop
	nop

	nop		;0x17
	nop
	nop
	nop

	nop		;0x13
	nop
	nop
	nop

	nop		;0x0f		
	nop
	nop
	nop

	nop		;0x1b
	nop
	nop
	nop

	nop		;0x07
	nop
	nop
	nop

	nop		;0x03
	nop
	nop		;0x01

loop	decf	loops,f	;if loops = 1, return (0 loops was inc'ed to 1)
	btfsc	status,z
	return		;returns to playnote from waitperiod
	movlw	0x00	;set pclath to page0
	movwf	pclath
	movf	tasks,w	; the number of tasks ***
	decfsz	taskpointer,f	; last task is task8
	movf	taskpointer,w
	
	;nop		; for debugging: nops match
	;nop		; the number of rem'd tasks
	;nop		; below
	;nop		;
	;nop		;

	movwf	taskpointer	; then jump to the next housekeeping task
	addwf	pcl,f	; using computed goto
	nop		; (no task0)
	goto	task10
	goto	task9
	goto	task8
	goto	task7
	goto	task6
	goto	task5
	goto	task4
	goto	task3
	goto	task2
	goto	task1
			;each task is the same length 32 -11 = 21 cycles,
			;including 2 for ending of "goto loop"
 

;Calculate how many nops are needed, then select a 32 cycle subroutine 
;for the requisite number of cycles, the 32 cycle subroutine is selected 
;from a bank of housekeeping routines in turn, pointed to by taskpointer.

;viz-

task1	clrf	temp	; - INC DCOUNTER -
	btfsc	dcounter_flag,0
	incf	dcounter,f	; increment dcounter when flag has been set
	movlw	0x03		
	btfss	dcounter_flag,0

	movlw	0x23	; set do display bit (temp,5) if flag set
	bcf	dcounter_flag,0; clear counter flag
	movwf	temp	
	movf	melodynumber,w	; - CHECKBUTTONS SETUP -
	btfsc	status,z	; if melody=0 (silence) load melody9 (alarm)

	movlw	0x09
	addwf	dcounter,w
	addwf	temp,f	; 3+9+4 = 16, ie sets bit(4)
	btfsc	dcounter,2	; if dcounter is 4 reset to 0
	clrf	dcounter 	

	movf	min1,w	; - MINSEC SETUP - 
	movwf	min1sec	; get the minsec mode minute display sorted
	nop
	nop
	goto	loop

task2	nop		; - GET READY TO OUTPUT DISPLAY -
	nop
	movlw	0x02	;because the calls are in page 2
	movwf	pclath	;and contain calculated gotos
	movf	modenumber,w	; (each call takes 5 cycles)

	call	getmodeptr	;get the first digit location

	addwf	dcounter,w	;add the digit number offset
	movwf	fsr	;point to the current digit location
	movf	indf,w	;load the current digit

	call	ledcode	;look up its display code

	movwf	display	;store the display code
	goto	loop

task3	movlw	pm	; - PM DISPLAY SETUP -  
	btfss	modenumber,1	;use pm if mode 2 or 3 ie bit1 is set
	movlw	alarmpm	;else if mode1 use alarmpm 
	movwf	fsr
	bcf	andb3,7	;turn pm indicator on

	btfss	indf,0	;if pm bit set, leave it on
	bsf	andb3,7	;else clear the pm indicator
	movlw	andb0	;get the location of the dp mask for the mode
	addwf	dcounter,w
	movwf	fsr

	movf	indf,w	;load the andb mask
	andwf	display,f	;and dp (if any) or alarmled to display code
	movlw	trisa0	; - TRISA SETUP -
	addwf	dcounter,w	;point to the appropriate value for trisa
	movwf	fsr	;to display the current digit

	movf	indf,w	;load the appropriate trisa
	movwf	trisa_temp
	btfss	temp,4	;if checkbuttons bit not set
	decf	taskpointer,f	;skip the next task
	goto	loop

task4			; - CHECKBUTTONS - 
	bcf	porta,0	;make a0 (digit3) negative
	bsf	status,rp0	; select bank 1
	movlw	0xff	;make portb buttons all inputs
	movwf	trisb	; b6 (green), b5 (black), b3 (red), b0 (yellow)	
	bcf	status,rp0	;select bank 0	again
	
	btfss	portb,3	;check if red button is closed
	goto	togglalarm
	btfss	portb,0	;check if yellow button is closed
	goto	inchrs
	btfss	portb,6	;check if green button is closed

	goto	incmins
	btfss	portb,5	;check if black button is closed
	goto	changemode
	bsf	porta,0	; turn digit3 on
	bsf	status,rp0	; select bank 1

	movwf	last_display	; turn on display again
	movwf	trisb	; 
	bcf	status,rp0	; select bank 0 again
	movwf	portb
	goto	loop

task5	btfss	temp,5	; - OUTPUT DISPLAY -
	goto	marktime2	; (only if new digit now)
	movf	display,w	; save display
	movwf	last_display
	movlw	0xff	; turn off old display (if it's not off already)

	movwf	portb	; 
	movlw	0x10	; turn off porta b0-3
	andwf	porta,f
	bsf	status,rp0	; select bank 1
	movf	display,w	; select new display output pins 

	movwf	trisb	;
	movf	trisa_temp,w	; select the new digit to output
	movwf	trisa	;
	bcf	status,rp0	; select bank 0 again
	movf	display,w	; 

	movwf	portb	; turn on the new display
	comf	trisa_temp,w	; 
	andlw	0x0f	; turn on new digit
	iorwf	porta,f	; (leave bits 7-4 as is)
	goto	loop		

task6	btfss	intcon,t0if	; - CHECK IF SEC -
	goto	marktime2	;check if tmr0 interupt flag has been set
	bcf	intcon,t0if	;if set clear tmr0 interupt flag
	decfsz	tcount0,f	;decrement tcount0, if zero
	goto	marktime5

	decfsz	tcount1,f	; decrement tcount1,
	goto	marktime7	;
	movf	tconst0,w	; if zero reset tcount0
	movwf	tcount0	;
	movf	tconst1,w	; reset tcount1

	movwf	tcount1	;then add one to seconds	
	incf	sec1,f	; - ADJUSTMENT -
	movf	fraction,w	; 
	subwf	tmr0,f	; put tmr0 back a fraction of a cycle
	btfss	status,c	; if c is clear tmr0 < fraction

	incf	tcount0,f	; so add 1 to tcount0 to ensure delay
	nop
	goto	marktime18	;	

task7	movlw	0x0a	; -INC TIME -
	xorwf	sec1,w	;check if seconds are still < 10
	btfsc	status,z
	clrf	sec1	;if 10 set seconds to 0
	btfsc	status,z	

	incf	sec10,f	;then add one to tens of seconds
	movlw	0x06
	xorwf	sec10,w	;check if tens of seconds are still < 6
	btfsc	status,z	
	clrf	sec10	;if 6 set sec10 to 0

	btfsc	status,z
	incf	min1,f	;then add one to minutes
	nop
	movlw	0x0a
	xorwf	min1,w	;check if minutes are still < 10

	btfsc	status,z	
	clrf	min1	;if 10 set minutes to 0
	btfsc	status,z
	incf	min10,f	;then add one to tens of minutes
	goto	loop

task8	movlw	0x06	
	subwf	min10,w	;check if tens of minutes are still < 6	
	btfsc	status,z	
	clrf	min10	;if 6 set tens of minutes to 0
	btfsc	status,z

	incf	hr24,f	;add one to hours
	movlw	0x18	;check if 24 hours are still < 24
	subwf	hr24,w
	btfsc	status,z	
	clrf	hr24	;if 24 set 24 hours to 0
			; - 12 hours -
	bsf	pm,0	;set pm indicator
	movlw	0x0c	;subtract 12 from 24hrs
	subwf	hr24,w	
	btfss	status,c	;if result is negative (c is not set) 
	bcf	pm,0	;then clear pm indicator

	btfss	status,c	;if result is negative (c is not set) 
	movf	hr24,w	;then restore 24 hour time
	movwf	hr12	;else save result as 12 hour time
	nop
	goto	loop
	
task9	movlw	0x0c	;if hr12 is 0, make it 12
	movf	hr12,f
	btfsc	status,z
	movwf	hr12	
	movlw	0x0a	;set display for hr10 as blank

	movwf	hr10	;
	subwf	hr12,w	;subtract 10 from 12 hr time
	btfss	status,c	;if result is negative (c is not set)
	movf	hr12,w	;then restore 12 hour time
	movwf	hr1	;else save result as hr1

	movlw	0x01	;
	btfsc	status,c	;if result is positive or zero (c is set)
	movwf	hr10	;set hr10 as one
	btfsc	dcounter_flag,4	;if daytime don't dim
	btfss	dcounter_flag,5	;if disp>dim don't dim

	goto	marktime16
	movlw	0xff
	movwf	portb	; - DIM THE DISPLAY!
	bcf	dcounter_flag,5		
	goto	loop		

task10	movf	min1,w	; -ALARMCHECK-	
	xorwf	last_min1,f
	movwf	last_min1
	btfsc	status,z	;if the same marktime
	goto	marktime5

	movf	alarmmin1,w
	xorwf	min1,w
	btfss	status,z	;if different marktime	
	goto	marktime9
	movf	alarmmin10,w	

	xorwf	min10,w
	btfss	status,z	;if different marktime
	goto	marktime13
	movf	alarmhr24,w	
	xorwf	hr24,w

	btfss	status,z	;if different marktime
	goto	marktime17
	nop
	btfsc	andb0,7	; 0=on 
	goto	loop

	goto	alarminit

;			; - MARKTIME ARRAY -
marktime2	nop		;4
	nop		;5
			
marktime4	nop		;6
marktime5	nop		;7
	nop		;8
marktime7	nop		;9
	nop		;10
			; - TIME TO DIM?
marktime9	movf	dimconst,w	;;set flag high 
	subwf	displaycount,w	;if less than dimconst cycles left
	btfss	status,c	;(carry is 1 if disp >= dimconst)
	bsf	dcounter_flag,5	

marktime13	nop		;15

marktime14	nop		;16
	nop		;17
marktime16	nop		;18  
marktime17	nop		;19  
marktime18	goto	loop	;21

;These are NOT housekeeping tasks:

alarminit	clrf	notepointer
	movlw	0x09	;alarm is melody 9
	movwf	melodynumber
	nop
	return		;returns to playnote from waitperiod

changemode	movlw	0x09	;if alarm playing
	xorwf	melodynumber,w	;toggle alarm
	btfsc	status,z
	goto	togglalarm

	decf	modenumber,w
	btfsc	status,z
	movlw	0x03
	movwf	modenumber
	clrf	notepointer	;play the melody that signals the mode
	movf	modenumber,w
	movwf	melodynumber	;melody 3 is the hrmin melody
			;melody 2 is the minsec melody
			;melody 1 is the alarmset melody
	return		;returns to playnote from waitperiod

incmins	movlw	0x09	;if alarm playing
	xorwf	melodynumber,w	;toggle alarm
	btfsc	status,z
	goto	togglalarm

	movlw	0x02
	xorwf	modenumber,w
	btfsc	status,z
	goto	clrsecs	;clear secs if minsec mode 2
incminsec	clrf	notepointer
	movlw	0x05
	movwf	melodynumber	;play melody 5 the incmins melody
	movlw	0x01
	xorwf	modenumber,w
	btfsc	status,z
	goto	incalarmmin	;if alarm mode (1)
	incf	min1,1	;add one to minutes
	movlw	0x0a	;check if minutes are still < 10
	subwf	min1,0
	btfss	status,z	
	return		;returns to playnote from waitperiod 
			;to play melody now
	clrf	min1	;if 10, set minutes to 0
	incf	min10,1	;then add one to tens of minutes
	movlw	0x06	;check if tens of minutes are still < 6
	subwf	min10,0
	btfss	status,z	
	return		;returns to playnote from waitperiod 
			;to play melody now
	clrf	min10	;if 6 set tens of minutes to 0
	return		;returns to playnote from waitperiod 
			;to play melody now

clrsecs	clrf	sec1
	clrf	sec10
	clrf	notepointer
	movlw	0x04
	movwf	melodynumber	;play melody 4 the clrsecs melody
	return		;returns to playnote from waitperiod 
			;to play melody now

incalarmmin	incf	alarmmin1,f	;add one to alarm minutes
	movlw	0x0a	;check if alarm minutes are still < 10
	subwf	alarmmin1,w
	btfss	status,z	
	return		;returns to playnote from waitperiod 
			;to play melody now
	clrf	alarmmin1	;if 10, set alarm minutes to 0
	incf	alarmmin10,f	;then add one to tens of alarm minutes
	movlw	0x06	;check if tens of alarm minutes are still < 6
	subwf	alarmmin10,w
	btfss	status,z	
	return		;returns to playnote from waitperiod 
			;to play melody now
	clrf	alarmmin10	;if 6 set tens of alarm minutes to 0
	return		;returns to playnote from waitperiod 
			;to play melody now

inchrs	movlw	0x09	;if alarm playing
	xorwf	melodynumber,w	;toggle alarm
	btfsc	status,z
	goto	togglalarm

	movlw	0x02
	xorwf	modenumber,w
	btfsc	status,z
	goto	incminsec	;goto incminsec if minsec mode
	clrf	notepointer
	movlw	0x06
	movwf	melodynumber	;play melody 6 the inchrs melody
	movlw	0x01
	xorwf	modenumber,w	;goto incalarmhrs if alarmset mode
	btfsc	status,z
	goto	incalarmhrs

	incf	hr24,f	;add one to hours
	movlw	0x18	;check if 24 hours are still < 24
	subwf	hr24,w
	btfsc	status,z	
	clrf	hr24	;if 24 set 24 hours to 0

			; - 12 hours -
	bsf	pm,0	;set pm indicator
	movlw	0x0c	;subtract 12 from 24hrs
	subwf	hr24,w	
	btfss	status,c	;if result is negative (c is not set) 
	bcf	pm,0	;then clear pm indicator
	btfss	status,c	;if result is negative (c is not set) 
	movf	hr24,w	;then restore 24 hour time
	movwf	hr12	;else save result as 12 hour time

	movlw	0x0c	;if hr12 is 0, make it 12
	movf	hr12,f
	btfsc	status,z
	movwf	hr12	

	movlw	0x0a	;set display for hr10 as blank
	movwf	hr10	;
	subwf	hr12,w	;subtract 10 from 12 hr time
	btfss	status,c	;if result is negative (c is not set)
	movf	hr12,w	;then restore 12 hour time
	movwf	hr1	;else save result as hr1
	movlw	0x01	;
	btfsc	status,c	;if result is positive or zero (c is set)
	movwf	hr10	;set hr10 as one

	return		;returns to playnote from waitperiod 
			;to play melody now

incalarmhrs	incf	alarmhr24,f	;add one to alarmhours
	movlw	0x18	;check if 24 alarmhours are still < 24
	subwf	alarmhr24,w
	btfsc	status,z	
	clrf	alarmhr24	;if 24 set 24 hours to 0
			; - 12 hours -
	bsf	alarmpm,0	;set alarmpm indicator
	movlw	0x0c	;subtract 12 from alarm24hrs
	subwf	alarmhr24,w	
	btfss	status,c	;if result is negative (c is not set) 
	bcf	alarmpm,0	;then clear alarmpm indicator
	btfss	status,c	;if result is negative (c is not set) 
	movf	alarmhr24,w	;then restore 24 hour time
	movwf	alarmhr12	;else save result as 12 hour time

	movlw	0x0c	;if alarmhr12 is 0, make it 12
	movf	alarmhr12,f
	btfsc	status,z
	movwf	alarmhr12	

	movlw	0x0a	;set display for alarmhr10 as blank
	movwf	alarmhr10	;
	subwf	alarmhr12,w	;subtract 10 from 12 hr time
	btfss	status,c	;if result is negative (c is not set)
	movf	alarmhr12,w	;then restore 12 hour time
	movwf	alarmhr1	;else save result as alarmhr1
	movlw	0x01	;
	btfsc	status,c	;if result is positive or zero (c is set)
	movwf	alarmhr10	;set alarmhr10 as one
	return		;returns to playnote from waitperiod 
			;to play melody now

togglalarm	movlw	0x80
	xorwf	andb0,f	;bit 7=alarm indicator
	clrf	notepointer
	movlw	0x07	;play melody 7 the toggleon melody
	btfsc	andb0,7	;if bit 2 now = 0 ("0n")
	movlw	0x08
	movwf	melodynumber	;otherwise melody 8 the toggleoff melody
	return		;returns to playnote from waitperiod 
			;to play melody now
getmodeptr	addwf	pcl,f	
	retlw	0x00	;mode0 not used
	retlw	alarmmin1	;mode1
	retlw	sec1	;mode2
	retlw	min1	;mode3

ledcode	addwf	pcl,f
	retlw	0x88	;0x00
	retlw	0xED
	retlw	0x91
	retlw	0xC1
	retlw	0xE4
	retlw	0xC2
	retlw	0x82
	retlw	0xE9
	retlw	0x80
	retlw	0xC0	;0x09
	retlw	0xFF	;0x0a

gethdquvrconst	movlw	0x02	;set pclath at page2
	movwf	pclath
	movf	notenumber,w	;
	addwf	pcl,f	;computed goto
	retlw	0x3D
	retlw	0x3D
	retlw	0x3D
	retlw	0x3D
	retlw	0x3D
	retlw	0x41
	retlw	0x45
	retlw	0x49
	retlw	0x4D
	retlw	0x52
	retlw	0x57
	retlw	0x5C
	retlw	0x61
	retlw	0x67
	retlw	0x6E
	retlw	0x74
	retlw	0x7B
	retlw	0x82
	retlw	0x8A
	retlw	0x92
	retlw	0x9B
	retlw	0xA4
	retlw	0xAE
	retlw	0xB8
	retlw	0xC3
	retlw	0xCF
	retlw	0xDC
	retlw	0xE9
	retlw	0xF6

getperiod	movlw	0x02	;set pclath at page2
	movwf	pclath
	movf	notenumber,w	;
	addwf	pcl,f	;computed goto
	retlw	0xFD
	retlw	0xFD
	retlw	0xFD
	retlw	0xFD
	retlw	0xFD
	retlw	0xEF
	retlw	0xE1
	retlw	0xD5
	retlw	0xC9
	retlw	0xBD
	retlw	0xB3
	retlw	0xA9
	retlw	0x9F
	retlw	0x96
	retlw	0x8E
	retlw	0x86
	retlw	0x7E
	retlw	0x77
	retlw	0x70
	retlw	0x6A
	retlw	0x64
	retlw	0x5F
	retlw	0x59
	retlw	0x54
	retlw	0x4F
	retlw	0x4B
	retlw	0x47
	retlw	0x43
	retlw	0x3F

getmelodyaddr	movlw	0x02	;set pclath at page2
	movwf	pclath	
	movf	melodynumber,w	
	addwf	melodynumber,w	;double melodynumber
	addwf	melodynumber,w	;triple melodynumber
	addwf	pcl,1	
	movlw	0x02	;melody0
	movwf	melodyh	
	retlw	0xD7	
	movlw	0x02	;melody1
	movwf	melodyh	
	retlw	0xD9	
	movlw	0x02	;melody2
	movwf	melodyh	
	retlw	0xDD	
	movlw	0x02	;melody3
	movwf	melodyh	
	retlw	0xE0	
	movlw	0x02	;melody4
	movwf	melodyh	
	retlw	0xE3	
	movlw	0x02	;melody5
	movwf	melodyh	
	retlw	0xE9	
	movlw	0x02	;melody6
	movwf	melodyh	
	retlw	0xEC	
	movlw	0x02	;melody7
	movwf	melodyh	
	retlw	0xEF	
	movlw	0x02	;melody8
	movwf	melodyh	
	retlw	0xF3	
	movlw	0x02	;melody9
	movwf	melodyh	
	retlw	0xF7	
			
getnotedata	movf	melodyh,w	;set pclath at page 2 or 3
	movwf	pclath	; (start of melody's notedata)
	movf	melodyl,w	
	addwf	notepointer,w	
	btfsc	status,c	
	incf	pclath,f	;add one to pclath if carry
	movwf	pcl	
			
			;silent melody is one note long and repeats
			; first note:
			;b0 = 0 ie no 1/32 sec pause between notes
			;b1:2 = 0 ie a minim
			;b7:3 = 0 ie play a pause
;notedata			
	retlw	0x03	;melody0
	retlw	0x00	
	retlw	0x06	;melody1
	retlw	0x4D	
	retlw	0x65	
	retlw	0x64	
	retlw	0x04	;melody2
	retlw	0x89	
	retlw	0x00	
	retlw	0x04	;melody3
	retlw	0x29	
	retlw	0x00	
	retlw	0x0A	;melody4
	retlw	0xEE	
	retlw	0xC6	
	retlw	0xAE	
	retlw	0x8E	
	retlw	0x00	
	retlw	0x04	;melody5
	retlw	0x8F	
	retlw	0x06	
	retlw	0x04	;melody6
	retlw	0x2F	
	retlw	0x04	
	retlw	0x06	;melody7
	retlw	0x4D	
	retlw	0x65	
	retlw	0x01	
	retlw	0x06	;melody8
	retlw	0x65	
	retlw	0x4D	
	retlw	0x01	
	retlw	0x31	;melody9
	retlw	0x4D	
	retlw	0x65	
	retlw	0x61	
	retlw	0x4D	
	retlw	0x3D	
	retlw	0x29	
	retlw	0x3D	
	retlw	0x4D	
	retlw	0x65	
	retlw	0x4D	
	retlw	0x38	
	retlw	0x39	
	retlw	0x4D	
	retlw	0x65	
	retlw	0x61	
	retlw	0x4D	
	retlw	0x3D	
	retlw	0x29	
	retlw	0x3D	
	retlw	0x4D	
	retlw	0x3D	
	retlw	0x2D	
	retlw	0x28	
	retlw	0x29	

	end
