Attribute VB_Name = "WinAmpControl"
Option Explicit

'********************************************************************
'*
'* WinAmpControl.bas
'*
'* Modified and expanded from an example by Duane Odom.
'*
'********************************************************************

'********************************************************************
'*
'* Win32API Declarations
'*
'********************************************************************
Public Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long

Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function PostMessage Lib "user32" Alias "PostMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function CopyDataSendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByRef lParam As COPYDATASTRUCT) As Long
Private Declare Function lstrcpy Lib "kernel32" Alias "lstrcpyA" (ByVal lpString1 As String, ByVal lpString2 As String) As Long

Private Type COPYDATASTRUCT
    dwData As Long
    cbData As Long
    lpData As Long
End Type

'********************************************************************
'*
'* Global Variables
'*
'********************************************************************
Public hWndWinamp As Long                   'Winamp's handle

'********************************************************************
'*
'* Windows SendMessage Constants
'*
'********************************************************************
Public Const WM_COPYDATA = &H4A
Public Const WM_COMMAND = &H111
Public Const WM_USER = &H400

Public Const vbQuote As String = """"

'********************************************************************
'*
'* Winamp Command Message Constants
'*
'********************************************************************
Public Const WA_PREVTRACK = 40044
Public Const WA_NEXTTRACK = 40048
Public Const WA_PLAY = 40045
Public Const WA_PAUSE = 40046
Public Const WA_STOP = 40047
Public Const WA_FADEOUTSTOP = 40147
Public Const WA_STOPAFTERTRACK = 40157
Public Const WA_FASTFORWARD = 40148
Public Const WA_FASTREWIND = 40144
Public Const WA_PLAYLISTHOME = 40154
Public Const WA_PLAYLISTEND = 40158
Public Const WA_DIALOGOPENFILE = 40029
Public Const WA_DIALOGOPENURL = 40155
Public Const WA_DIALOGFILEINFO = 40188
Public Const WA_TIMEDISPLAYELAPSED = 40037
Public Const WA_TIMEDISPLAYREMAINING = 40038
Public Const WA_TOGGLEPREFERENCES = 40012
Public Const WA_DIALOGVISUALOPTIONS = 40190
Public Const WA_DIALOGVISUALPLUGINOPTIONS = 40191
Public Const WA_STARTVISUALPLUGIN = 40192
Public Const WA_TOGGLEABOUT = 40041
Public Const WA_TOGGLEAUTOSCROLL = 40189
Public Const WA_TOGGLEALWAYSONTOP = 40019
Public Const WA_TOGGLEWINDOWSHADE = 40064
Public Const WA_TOGGLEPLAYLISTWINDOWSHADE = 40266
Public Const WA_TOGGLEDOUBLESIZE = 40165
Public Const WA_TOGGLEEQ = 40036
Public Const WA_TOGGLEPLAYLIST = 40040
Public Const WA_TOGGLEMAINWINDOW = 40258
Public Const WA_TOGGLEMINIBROWSER = 40298
Public Const WA_TOGGLEEASYMOVE = 40186
Public Const WA_VOLUMEUP = 40058            'increase volume by 1%
Public Const WA_VOLUMEDOWN = 40059          'decrease volume by 1%
Public Const WA_TOGGLEREPEAT = 40022
Public Const WA_TOGGLESHUFFLE = 40023
Public Const WA_DIALOGJUMPTOTIME = 40193
Public Const WA_DIALOGJUMPTOFILE = 40194
Public Const WA_DIALOGSKINSELECTOR = 40219
Public Const WA_DIALOGCONFIGUREVISUALPLUGIN = 40221
Public Const WA_RELOADSKIN = 40291
Public Const WA_CLOSE = 40001
Public Const WA_BACKTENTRACKS = 40197
Public Const WA_SHOWEDITBOOKMARKS = 40320
Public Const WA_BOOKMARKTRACK = 40321
Public Const WA_PLAYAUDIOCD = 40323
Public Const WA_LOADEQPRESET = 40253
Public Const WA_SAVEEQPRESET = 40254
Public Const WA_DIALOGLOADPRESETS = 40172
Public Const WA_DIALOGAUTOLOADPRESETS = 40173
Public Const WA_LOADDEFAULTPRESET = 40174
Public Const WA_DIALOGSAVEPRESET = 40175
Public Const WA_DIALOGAUTOLOADSAVEPRESET = 40176
Public Const WA_DIALOGDELETEPRESET = 40178
Public Const WA_DIALOGDELETEAUTOLOADPRESET = 40180

'********************************************************************
'*
'* User Message Constants
'*
'********************************************************************
Private Const WA_GETVERSION = 0              'retrieves the version of Winamp running. Version will be 0x20yx for 2.yx
Private Const WA_STARTPLAYBACK = 100         'starts playback. Almost like hitting 'play' in Winamp.
Private Const WA_CLEARPLAYLIST = 101         'clears Winamp's internal playlist.
Private Const WA_PLAYSELECTED = 102          'begins play of selected track.
Private Const WA_CHANGEDIR = 103             'makes Winamp change to the directory C:\\download
Private Const WA_GETSTATUS = 104             'returns the status of playback (1=playing, 3=paused, all else stopped).
Private Const WA_GETTRACKPOSITION = 105      ' 0 = return position in millisecs,
                                             ' 1 = return track length in secs.
                                             ' returns -1 if not playing or error.
Private Const WA_SEEKTOPOSITION = 106        'offset in milliseconds.
Private Const WA_WRITEPLAYLIST = 120         'writes playlist to Winampdir\winamp.m3u & returns position in playlist.
Private Const WA_SETPLAYLISTPOSITION = 121   'sets the playlist position to the position specified in tracks.
Private Const WA_SETVOLUME = 122             'sets the volume: range between 0 (silent) and 255 (maximum).
Private Const WA_SETBALANCE = 123            'sets the panning: range between 0 (all left) and 255 (all right).
Private Const WA_GETPLAYLISTLENGTH = 124     'returns length of the current playlist, in tracks.
Private Const WA_GETPLAYLISTPOSITION = 125   'returns position in playlist, in tracks (requires Winamp 2.05+).
Private Const WA_GETTRACKINFO = 126          'retrieves info about the playing track:
                                             ' 0 = return sample rate (i.e. 44100),
                                             ' 1 = return bitrate,
                                             ' 2 = return number of channels (requires Winamp 2.05+)
Private Const WA_GETEQDATA = 127             'retrieves one element of equalizer data:
                                             ' 0-9 the 10 bands; will return 0-63 (+20db - -20db)
                                             ' 10  the preamp; will return 0-63 (+20db - -20db)
                                             ' 11  eq state; will return zero if disabled, nonzero if enabled.
                                             ' 12  autoload; will return zero if disabled, nonzero if enabled.
Private Const WA_SETEQDATA = 128             'sets one element of equalizer data.
                                             'query which item you wish to set using the message above (127),
                                             'then call this message with data.
Private Const WA_ADDBOOKMARK = 129           'adds the specified file to the Winamp bookmark list.
Private Const WA_RESTART = 135               'restarts Winamp
Private Const WA_UPDTITLE = 243              'forces track title update
Private Const WA_GETSHUFFLE = 250            'get shuffle state; 0=off, 1=on
Private Const WA_GETREPEAT = 251             'get repeat state; 0=off, 1=on
Private Const WA_SETSHUFFLE = 252            'enable/disable shuffle; 0=off, 1=on
Private Const WA_SETREPEAT = 253             'enable/disable repeat; 0=off, 1=on
'********************************************************************

'
Function WinAMP_AddFile(sFileName As String) As Long

'********************************************************************
'*
'* Add a file to Winamp's Playlist
'*
'********************************************************************
Dim iResult As Long
Dim cds As COPYDATASTRUCT

cds.dwData = WA_STARTPLAYBACK
cds.lpData = lstrcpy(sFileName, sFileName)  'returns the address of the pointer to the string
cds.cbData = Len(sFileName) + 1
  
iResult = CopyDataSendMessage(hWndWinamp, WM_COPYDATA, 0, cds)

WinAMP_AddFile = iResult

End Function

'
Function WinAMP_SetPlayListPosition(iPosition) As Long

'********************************************************************
'*
'* Set current position in playlist
'*
'********************************************************************

Dim iResult As Long

iResult = SendMessage(hWndWinamp, WM_USER, iPosition, WA_SETPLAYLISTPOSITION)

WinAMP_SetPlayListPosition = iResult

End Function

'
Function WinAMP_GetPlayListPosition() As Long

'********************************************************************
'*
'* Get current position in playlist
'*
'********************************************************************
Dim iPosition As Long

iPosition = SendMessage(hWndWinamp, WM_USER, 0, WA_GETPLAYLISTPOSITION)

WinAMP_GetPlayListPosition = iPosition

End Function

'
Function WinAMP_GetPlayListLength() As Long

'********************************************************************
'*
'* Get length of current playlist in tracks
'*
'********************************************************************
Dim iLength As Long

iLength = SendMessage(hWndWinamp, WM_USER, 0, WA_GETPLAYLISTLENGTH)

WinAMP_GetPlayListLength = iLength

End Function

'
Function WinAMP_GetSampleRate() As Long

'********************************************************************
'*
'* Get sample rate of playing track
'*
'********************************************************************
Dim iSampleRate As Long

iSampleRate = SendMessage(hWndWinamp, WM_USER, 0, WA_GETTRACKINFO)

WinAMP_GetSampleRate = iSampleRate

End Function

'
Function WinAMP_GetBitRate() As Long

'********************************************************************
'*
'* Get bit rate of playing track
'*
'********************************************************************

Dim iBitRate As Long

iBitRate = SendMessage(hWndWinamp, WM_USER, 1, WA_GETTRACKINFO)

WinAMP_GetBitRate = iBitRate

End Function

'
Sub WinAMP_SetEQValue(iEQ_Index As Long, iEQ_Value As Long)
  
'********************************************************************
'*
'* Sets the EQ slider value for the slider specified by EQ_Index
'*
'********************************************************************

' EQ values range from 0(top) to 63(bottom)

' Range check the EQ Index
    
If iEQ_Index < 0 Or iEQ_Index > 9 Then Exit Sub
  
' Range check the new EQ value
    
If iEQ_Value < 0 Or iEQ_Value > 63 Then Exit Sub
    
' Query the EQ line we want to change first
    
SendMessage hWndWinamp, WM_USER, iEQ_Index, WA_GETEQDATA
 
' Now send the new EQ value to the selected EQ line
    
PostMessage hWndWinamp, WM_USER, iEQ_Value, WA_SETEQDATA

End Sub

'
Sub WinAMP_SetAutoload(iAutoLoadState As Long)
  
'********************************************************************
'*
'* Enables/disabled Autoload
'*
'********************************************************************

' Query Autoload state first

SendMessage hWndWinamp, WM_USER, 12, WA_GETEQDATA
 
' Now send the enable/disable command
    
PostMessage hWndWinamp, WM_USER, iAutoLoadState, WA_SETEQDATA

End Sub

'
Sub WinAMP_SetEQState(iEQ_Flag As Long)
  
'********************************************************************
'*
'* Enables/disables the EQ
'*
'********************************************************************

' Query the EQ first
    
Call WinAMP_GetEQState
 
' iEQ_Flag = 0 to disable, 1 to enable
    
PostMessage hWndWinamp, WM_USER, iEQ_Flag, WA_SETEQDATA

End Sub

'
Function WinAMP_GetEQState() As Long
  
'********************************************************************
'*
'* Get the EQ status
'*
'********************************************************************

' Returns 0 if disabled, non-zero if enabled

WinAMP_GetEQState = SendMessage(hWndWinamp, WM_USER, 11, WA_GETEQDATA)

End Function

'
Sub WinAMP_SetPreAmpValue(iPreAmpValue As Long)

'********************************************************************
'*
'* Sets the Pre-amp value
'*
'********************************************************************

' Pre-amp values range from 0(top) to 63(bottom)

' Range check the new Pre-amp value
    
If iPreAmpValue < 0 Or iPreAmpValue > 63 Then Exit Sub

' We have to query the Pre-amp first
    
SendMessage hWndWinamp, WM_USER, 10, WA_GETEQDATA

' Send the new Pre-amp value
    
PostMessage hWndWinamp, WM_USER, iPreAmpValue, WA_SETEQDATA

End Sub

'
Sub WinAMP_ClearPlaylist()

'********************************************************************
'*
'* Clear Winamp's Playlist
'*
'********************************************************************

SendMessage hWndWinamp, WM_USER, 0, WA_CLEARPLAYLIST

End Sub

'
Function WinAMP_FindWindow() As Boolean

'********************************************************************
'*
'* Retrieve a handle to Winamp's window.
'*
'* Default name is "Winamp v1.x", but can be modified with
'* the /CLASS= switch, as follows:
'*
'* C:\path\to\winamp\winamp.exe /CLASS="myclassname"
'*
'********************************************************************

hWndWinamp = FindWindow("Winamp v1.x", vbNullString)
  
WinAMP_FindWindow = IIf(hWndWinamp <> 0, True, False)

End Function

'
Function WinAMP_GetStatus() As Integer

'********************************************************************
'*
'* Get WinAMP status
'*
'********************************************************************
Dim iStatus As Long

iStatus = SendMessage(hWndWinamp, WM_USER, 0, WA_GETSTATUS)

If iStatus = 0 Or iStatus > 3 Then iStatus = 2

WinAMP_GetStatus = CInt(iStatus)    '1=playing, 2=stopped, 3=paused

End Function

'
Function WinAMP_GetTrackPosition() As Long

'********************************************************************
'*
'* Retrieves the position of the current track in secs
'*
'********************************************************************
Dim iReturnPos As Long
    
' ReturnPos will contain the current track pos in milliseconds
' or -1 if no track is playing or an error occurs.
    
iReturnPos = SendMessage(hWndWinamp, WM_USER, 0, WA_GETTRACKPOSITION)

If iReturnPos <> -1 And iReturnPos > 999 Then
    WinAMP_GetTrackPosition = iReturnPos / 1000   'convert to secs
Else
    WinAMP_GetTrackPosition = -1
End If

End Function

'
Function WinAMP_Restart() As Long

'********************************************************************
'*
'* Restart Winamp (takes forever!)
'*
'********************************************************************

Dim iStatus As Long

iStatus = SendMessage(hWndWinamp, WM_USER, 0, WA_RESTART)

End Function

'
Function WinAMP_GetEQValue(iEQ_Index As Long) As Long

'********************************************************************
'*
'* Retrieve equalizer slider value (EQ_Index indicates slider number)
'*
'********************************************************************
Dim iResult As Long

' Range check the EQ Index (between 0 and 9, inclusive)
    
If iEQ_Index < 0 Or iEQ_Index > 9 Then
    WinAMP_GetEQValue = -1
    Exit Function
End If
    
' Return value will hold a value for the selected EQ slider
' values will range from 0(top) to 63(bottom)

iResult = SendMessage(hWndWinamp, WM_USER, iEQ_Index, WA_GETEQDATA)

WinAMP_GetEQValue = iResult

End Function

'
Function WinAMP_GetPreAmpValue() As Long
    
'********************************************************************
'*
'* Retrieve the Pre-amp slider value
'*
'********************************************************************
Dim iResult As Long
    
' Values will range from 0(top) to 63(bottom)
    
iResult = SendMessage(hWndWinamp, WM_USER, 10, WA_GETEQDATA)
WinAMP_GetPreAmpValue = iResult

End Function

'
Sub WinAMP_SeekToPosition(iPositionInSec As Long)

'********************************************************************
'*
'* Seek to the specified position (in secs) in the current track
'*
'********************************************************************

' Range check the new position
    
If iPositionInSec < 0 Or iPositionInSec > WinAMP_GetTrackLength Then
    Exit Sub
End If

PostMessage hWndWinamp, WM_USER, CLng(iPositionInSec * 1000), WA_SEEKTOPOSITION

End Sub

'
Sub WinAMP_SetVolume(iVolume As Long)

'********************************************************************
'*
'* Set the volume slider
'*
'********************************************************************

' Volume values will range from 0(bottom) to 255(top)

' Range check the new volume
   
If Not (iVolume < 0 Or iVolume > 255) Then
    PostMessage hWndWinamp, WM_USER, iVolume, WA_SETVOLUME
End If

End Sub

'
Sub WinAMP_SetRepeat(iRepeatState As Long)

'********************************************************************
'*
'* Enable/disable repeat
'*
'********************************************************************
    
PostMessage hWndWinamp, WM_USER, iRepeatState, WA_SETREPEAT

End Sub

'
Sub WinAMP_SetShuffle(iShuffleState As Long)

'********************************************************************
'*
'* Enable/disable shuffle
'*
'********************************************************************
    
PostMessage hWndWinamp, WM_USER, iShuffleState, WA_SETSHUFFLE

End Sub

'
Sub WinAMP_UpdateTitle()

'********************************************************************
'*
'* Force track title update
'*
'********************************************************************

PostMessage hWndWinamp, WM_USER, 0, WA_UPDTITLE

End Sub

'
Sub WinAMP_SetBalance(iBalance As Long)

'********************************************************************
'*
'* Set the Balance slider
'*
'********************************************************************

Dim iScaledBalance As Long

' We want the range of balance to be from -127 to 127, but the
' real range is as follows:

' |LEFT                       CENTER                       RIGHT|
' |128 ----------------------255(or 0)-----------------------127|
' |_____________________________________________________________|
    
' Range check the new balance
    
If iBalance < -127 Or iBalance > 127 Then
    Exit Sub
End If
    
' Here we do our shifting to correct the range of values
    
If iBalance < 0 Then
    iScaledBalance = 255 + iBalance
Else
    iScaledBalance = iBalance
End If

PostMessage hWndWinamp, WM_USER, iScaledBalance, WA_SETBALANCE

End Sub

'
Function WinAMP_GetTrackLength() As Long

'********************************************************************
'*
'* Retrieves the length of the current track in secs
'*
'********************************************************************
Dim iReturnLength As Long
  
' iReturnLength will contain the current track length in seconds
' or -1 if no track is playing or an error occurs.
    
iReturnLength = SendMessage(hWndWinamp, WM_USER, 1, WA_GETTRACKPOSITION)

WinAMP_GetTrackLength = IIf(iReturnLength <> -1, iReturnLength, -1)

End Function

'
Function WinAMP_GetVersion() As String

'********************************************************************
'*
'* Get WinAMP version
'*
'********************************************************************
Dim iVersionNum As Long
Dim sReturnVersion As String

iVersionNum = SendMessage(hWndWinamp, WM_USER, 0, WA_GETVERSION)
    
If Len(Hex(iVersionNum)) > 3 Then
    sReturnVersion = Left(Hex(iVersionNum), 1) & "."
    sReturnVersion = sReturnVersion & Mid(Hex(iVersionNum), 2, 1)
    sReturnVersion = sReturnVersion & Right$(Hex(iVersionNum), Len(Hex(iVersionNum)) - 3)
    WinAMP_GetVersion = sReturnVersion
Else
    WinAMP_GetVersion = ""
End If

End Function

'
Sub WinAMP_SendCommandMessage(iCommandMessage As Long)

'********************************************************************
'*
'* Send command message to Winamp
'*
'********************************************************************

SendMessage hWndWinamp, WM_COMMAND, iCommandMessage, 0

End Sub

'
Sub WinAMP_PostCommandMessage(iCommandMessage As Long)

'********************************************************************
'*
'* Post a command message to Winamp (no wait)
'*
'********************************************************************

PostMessage hWndWinamp, WM_COMMAND, iCommandMessage, 0

End Sub

'
Function WinAMP_Start(sWinAmpPath As String) As Boolean

'********************************************************************
'*
'* Runs an instance of Winamp if not already running
'*
'********************************************************************

Dim iResult As Double
    
iResult = Shell(sWinAmpPath, vbMinimizedNoFocus)
    
WinAMP_Start = IIf(iResult <> 0, True, False)

End Function

'
Function WinAMP_OpenFile(sWinAmpPath As String, sFileName As String) As Boolean

'********************************************************************
'*
'* Add a file to the WinAMP play list
'*
'********************************************************************
Dim iResult As Double
    
iResult = Shell(sWinAmpPath & " /ADD " & vbQuote & sFileName & vbQuote, vbMinimizedNoFocus)
    
WinAMP_OpenFile = IIf(iResult <> 0, True, False)

End Function
