VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Object = "{70406F28-2F49-11D5-8799-000000000000}#1.0#0"; "SysTray.ocx"
Begin VB.Form frmControl 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "IR Remote Startup"
   ClientHeight    =   2385
   ClientLeft      =   2760
   ClientTop       =   3750
   ClientWidth     =   4710
   ControlBox      =   0   'False
   Icon            =   "frmControl.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2385
   ScaleWidth      =   4710
   StartUpPosition =   2  'CenterScreen
   Visible         =   0   'False
   Begin VB.TextBox txtStatus 
      BackColor       =   &H80000004&
      CausesValidation=   0   'False
      Height          =   495
      Left            =   150
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   4
      TabStop         =   0   'False
      Top             =   1680
      Width           =   4440
   End
   Begin VB.PictureBox imgIRremote 
      Height          =   1350
      Left            =   150
      Picture         =   "frmControl.frx":0442
      ScaleHeight     =   1290
      ScaleWidth      =   2955
      TabIndex        =   3
      TabStop         =   0   'False
      ToolTipText     =   "Australia's Electronics Magazine"
      Top             =   105
      Width           =   3015
   End
   Begin VB.Timer tmrQueue 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   1800
      Top             =   240
   End
   Begin VB.Timer tmrOneShot 
      Enabled         =   0   'False
      Left            =   1320
      Top             =   240
   End
   Begin VB.Timer tmrLCD2 
      Enabled         =   0   'False
      Left            =   1320
      Top             =   720
   End
   Begin VB.Timer tmrLCD1 
      Enabled         =   0   'False
      Left            =   840
      Top             =   720
   End
   Begin VB.Timer tmrComm 
      Enabled         =   0   'False
      Left            =   840
      Top             =   240
   End
   Begin VB.Timer tmrKeyTimeout 
      Enabled         =   0   'False
      Left            =   1800
      Top             =   720
   End
   Begin VB.CommandButton cmdSetup 
      Caption         =   "&Setup"
      Enabled         =   0   'False
      Height          =   375
      Left            =   3360
      TabIndex        =   2
      Top             =   1080
      Width           =   1215
   End
   Begin SysTrayCtl.cSysTray cSysTray1 
      Left            =   2400
      Top             =   240
      _ExtentX        =   900
      _ExtentY        =   900
      InTray          =   0   'False
      TrayIcon        =   "frmControl.frx":4D5C
      TrayTip         =   "IR Remote"
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close"
      Default         =   -1  'True
      Enabled         =   0   'False
      Height          =   375
      Left            =   3360
      TabIndex        =   1
      Top             =   600
      Width           =   1215
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Enabled         =   0   'False
      Height          =   375
      Left            =   3360
      TabIndex        =   0
      Top             =   120
      Width           =   1215
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   240
      Top             =   240
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      CommPort        =   2
      DTREnable       =   0   'False
      Handshaking     =   2
      InBufferSize    =   128
      OutBufferSize   =   128
      ParityReplace   =   0
      RThreshold      =   1
      InputMode       =   1
   End
End
Attribute VB_Name = "frmControl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'********************************************************************
'********************************************************************
'*
'*
'*               IR Remote Control & LCD Display for Winamp
'*
'*                         Version 1.0  16/09/01
'*
'*                         Created by P.B.Smith
'*                 (C)2001 Silicon Chip Publications P/L
'*                         All Rights Reserved.
'*
'*                        www.siliconchip.com.au
'*
'*
'********************************************************************
'********************************************************************

' MSComm event codes

Private Const comEvSend = 1             '< SThreshold in the TX buffer
Private Const comEvReceive = 2          'RThreshold recv'd
Private Const comEvCTS = 3              'CTS state change
Private Const comEvDSR = 4              'DSR state change
Private Const comEvCD = 5               'CD state change
Private Const comEvRing = 6             'RI detected
Private Const comEvEOF = 7              'EOF (ASC 26) recv'd

Private Const comEventBreak = 1001      'break recv'd
Private Const comEventFrame = 1004      'framing error
Private Const comEventOverrun = 1006    'port overrun
Private Const comEventRxOver = 1008     'receive buffer overflow
Private Const comEventRxParity = 1009   'parity error
Private Const comEventTxFull = 1010     'transmit buffer full
Private Const comEventDCB = 1011        'unexpected error retrieving port DCB

' Other MSComm stuff...

Private Const comNone = 0               'no handshaking (default)
Private Const comXOnXOff = 1            'XON/XOFF handshaking
Private Const comRTS = 2                'RTS/CTS handshaking
Private Const comRTSXOnXOff = 3         'both RTS & XON/XOFF handshaking

Private Const comInputModeText = 0
Private Const comInputModeBinary = 1

' File access error codes

Private Const MnErrDeviceIO = 57
Private Const MnErrDiskFull = 61
Private Const MnErrDeviceUnavailable = 68
Private Const MnErrDiskNotReady = 71
Private Const ErrBadFileNameOrNumber = 52
Private Const ErrBadFileMode = 54
Private Const ErrFileAlreadyOpen = 55
Private Const ErrInputPastEndOfFile = 62
Private Const ErrBadFileName = 64
Private Const ErrFileAccess = 75
Private Const ErrPathDoesNotExit = 76

' Winamp status return codes

Private Const PLAYING As Integer = 1
Private Const STOPPED As Integer = 2    'used internally
Private Const PAUSED As Integer = 3

Private Const LISTRESET = True          'see GetRandomTrackNumber()
Private Const NOLISTRESET = False

' ID3v1 tag record fields

Private Type ID3v1Tag
    sTag As String * 3
    sTitle As String * 30
    sArtist As String * 30
    sAlbum As String * 30
    sYear As String * 4
    sComment As String * 30
    bGenre As Byte
End Type

Private MP3Tag As ID3v1Tag

Private INBuffer() As Byte              'serial input buffer (for MSComm)
Private RecordBuffer(4) As Byte         'serial input record buffer
Private KeyQueue(10) As Byte            'keys received queue
Private PlayedTracks(199) As Boolean    'played tracks flags
Private TrackShuffleList(199) As Integer 'list of tracks in played order
Private LineIndex(199) As Integer       'index of valid tracks in open playlist
Private MetaLineIndex(99) As Integer    'index of valid entries in open metalist
Private iPortNumber As Integer          'comm port in use
Private iRecIndex As Integer            'comm record index
Private iQCount As Integer              'count of queued keys
Private fTimerSecondEvent As Boolean    'comm timer second event flag

Private KeyCodeArray As Variant         'IR remote codes (from setup)
Private ShiftCodeArray As Variant       'IR remote shift codes (from setup)
Private EqSliderArray As Variant        'Equalizer slider values
Private sWinAmpPath As String           'path to the Winamp executable (from setup)
Private sWinAmpVersion As String        'Winamp version
Private sPlayListFile As String         'path to the open playlist
Private sMetaListFile As String         'path to the open metalist
Private sMetaListPath As String         'path (only) part
Private sBuildNumber As String          'incoming numeric key build
Private sTopLine As String              'top line of LCD
Private sTopLineSave As String          'ditto
Private hPlayListFile As Integer        'playlist file handle
Private hMetaListFile As Integer        'metalist handle
Private iMetaListIndex As Integer       'index into metalist
Private iPlayListCount As Integer       'number of entries in open metalist
Private iShuffleIndex As Integer        'index into TrackShuffleList
Private iTrackNumber As Integer         'current track
Private iTrackCount As Integer          'number of tracks in open playlist
Private iPlayedTrackCount As Integer    'tracks played count
Private iSystemAddress As Integer       'current IR system address
Private iKeyTimeout As Single           'key timeout (from setup)
Private iEqSlider As Long               'last selected equaliser slider number
Private iLastVolume As Long             'last selected volume
Private iLastPreamp As Long             'preamp value (retrieved from Winamp)
Private iLastEqState As Long            'equaliser state
Private fRepeatKey As Boolean           'true if last key repeated
Private fFirstKey As Boolean            'true if very first key
Private fShift As Boolean               'true when shift key received
Private fShuffleTracks As Boolean       'true when shuffle is on
Private fRepeatList As Boolean          'true when repeat is on
Private fEqControl As Boolean           'true when equaliser set selected
Private fScrollEnabled As Boolean       'true when scrolling top LCD line
Private fLCDEnabled As Boolean          'true to enable serial data out
Private fMetaListEnable As Boolean      'true when using metalist (from setup)
Private fPlayNext As Boolean            'true to enable auto play next track
Private fSecsToggle As Boolean          'toggles every second (see tmrLCD2)
Private fGotTrackLength As Boolean      'true when Winamp returns track length
Private fGotSampleRate As Boolean       'true when Winamp returns sample rate
Private fTrackSync As Boolean           'track advance sync flag (see tmrLCD2)
Private fClickedAbort As Boolean        'true if user clicked Abort during init
Private fSemLCD1 As Boolean             'flag to stop tmrLCD
Private fSemLCD2 As Boolean             'flag to stop tmrLCD2
Private fSemQueue As Boolean            'flag to stop tmrQueue
Private fSemComm As Boolean             'flag to stop tmrComm
Private fSemKeyTimeout As Boolean       'flag to stop tmrKeyTimeout
Private fProcessKey As Boolean          'true when key receive complete
Private fSoftKill As Boolean            'exit me when true
Private fHardKill As Boolean            'exit Windows when true
Private bToggleByte As Byte             'toggle (bit) of last key code

'
Function ConvertAscii(sInputString As String) As String

'********************************************************************
'*
'* Limit ASCII charcters in sInputString to < 128, and replace codes
'* less than 32 with 32(white space).
'*
'********************************************************************
Dim i As Integer, iChar As Integer
Dim sOutputString As String

If Len(sInputString) Then
    For i = 1 To Len(sInputString)
        iChar = Asc(Mid(sInputString, i, 1))
        iChar = iChar And &H7F
        If iChar < &H20 Then iChar = &H20
        sOutputString = sOutputString & Chr(iChar)
    Next
    ConvertAscii = sOutputString
Else
    ConvertAscii = ""
End If

End Function

'
Private Function InitLists() As Boolean

'********************************************************************
'*
'* Initialise the playlist and load the first track.
'*
'********************************************************************
Dim iTemp As Integer

' If using a 'meta' playlist, then open it.

If fMetaListEnable Then
    If Not OpenMetaList Then
        sTopLine = "INVALID METALIST!<><><>"  'show error on LCD
        fScrollEnabled = True
        InitLists = False
        Exit Function
    End If
Else
    iMetaListIndex = 1                          'not a metalist...
End If

' Attempt to open the last playlist in use. If that fails, and there is
' more than one entry in the metalist, then try loading the first playlist.

If Not OpenPlayList(iMetaListIndex) Then
    iTemp = iMetaListIndex
    If (iTemp = 1) Or ((iMetaListIndex > 1) And (Not OpenPlayList(1))) Then
        sTopLine = "CAN'T LOAD PLAYLIST!<><><>"  'show error on LCD
        fScrollEnabled = True
        InitLists = False
        Exit Function
    End If
End If
    
Call LoadTrack(1)
InitLists = True

End Function

'
Sub StatMsg(sMessage As String)

'********************************************************************
'*
'* Display status information.
'
'* Text is limited to max. 3k in length (typically around 50 lines).
'*
'********************************************************************
Dim iEndLine As Integer

Do While Len(txtStatus.Text) > 3071
    iEndLine = InStr(txtStatus.Text, vbLf)
    txtStatus.Text = Mid(txtStatus.Text, iEndLine + 1)
Loop

txtStatus.SelStart = Len(txtStatus.Text)
txtStatus.SelText = vbCrLf & sMessage

End Sub

'
Private Sub Form_Load()

'********************************************************************
'*
'* This is the main form (loads first).
'*
'********************************************************************
On Error GoTo 0

Move (Screen.Width - Width) / 2, (Screen.Height - Height) / 2
Me.Visible = True
DoEvents                                'paint me

' Prompt user to quit if an instance of IRRemote is already running.

cmdClose.Enabled = True
cmdClose.SetFocus

If FindWindow(vbNullString, "IR Remote") > 0 Or FindWindow(vbNullString, "IR Remote Setup") > 0 Then
    StatMsg "IR Remote is already running!"
    Exit Sub
End If

Me.Caption = "IR Remote"

' If the IR equipment address string isn't in registry, then assume this is
' the first run and prompt user to click the Setup button.

If GetSetting(App.Title, "System", "Version", "") = "" Then
    StatMsg "Click Setup!"
    cmdSetup.Enabled = True
    cmdSetup.SetFocus
    Exit Sub
End If

StatMsg "IR Remote " & CStr(App.Major) & "." & CStr(App.Minor)
StatMsg "Initialising..."

' Load settings, init comms, load the (meta)playlist and finally load the first
' track. After that, sit idle with the serial and timer events driving the
' whole show.

cmdClose.Caption = "Abort"
fClickedAbort = False
DoEvents

If InitSettings Then
    cmdClose.Caption = "Close"
    cmdClose.Enabled = False
    frmControl.MousePointer = 11            'hourglass
    DoEvents
    If InitComm Then
        If InitLists Then
            cSysTray1.InTray = True         'drop an icon in the system tray
            cmdOK.Enabled = True
            Me.WindowState = vbMinimized    'hide me
            Me.Visible = False
        End If
        tmrQueue.Enabled = True             'start the key dequeue timer
        fEnableCommInput = True             'enable incoming IR data
    End If
End If

frmControl.MousePointer = 0                 'default
cmdClose.Caption = "Close"
cmdClose.Enabled = True
cmdSetup.Enabled = True

End Sub

'
Private Sub cmdClose_Click()

' Don't close if it's an abort

If cmdClose.Caption = "Abort" Then
    fClickedAbort = True
    Exit Sub
End If

If Me.Caption <> "IR Remote Startup" Then   'see Form_Load
    Call CloseAll
End If

Unload Me
Set frmControl = Nothing

End Sub

'
Private Sub cmdOK_Click()

' Hide me again

Me.WindowState = vbMinimized
Me.Visible = False

End Sub

'
Private Sub cmdSetup_Click()

Call CloseAll
Unload Me
Set frmControl = Nothing
frmSetup.Show

End Sub

'
Private Sub cSysTray1_MouseDblClick(Button As Integer, Id As Long)

Me.Visible = True
Me.WindowState = vbNormal
Me.SetFocus

End Sub

'
Private Sub MSComm1_OnComm()

'********************************************************************
'*
'* Serial comms event handler.
'*
'* Receives a short (2-byte) data record from the IR receiver and
'* queues for later processing.
'*
'* Data is transmitted from the IR receiver using a simple binary
'* record, as follows:
'*
'* Byte 1 : Start record (FE)
'* Byte 2 : System byte
'* Byte 3 : Command Byte
'* Byte 4 : Checksum of bytes 2 & 3
'*
'********************************************************************
On Error GoTo CommError

Dim i As Integer, z As Integer, iChecksum As Integer

fSemComm = True                         'kill timeout timer

If Not fEnableCommInput Then            'input enabled?
    MSComm1.InBufferCount = 0           'if not, just flush & exit...
    Exit Sub
End If

Select Case MSComm1.CommEvent
Case comEvReceive                       'byte(s) received
    z = MSComm1.InBufferCount
    INBuffer = MSComm1.Input            'get entire input buffer

    Debug.Print "Got " & z & " IR bytes"
    
    If z = 0 Then Exit Sub
        
    For i = 1 To z
        If iRecIndex > 0 Or INBuffer(i - 1) = &HFE Then
            RecordBuffer(iRecIndex) = INBuffer(i - 1) 'move to our buffer
            iRecIndex = iRecIndex + 1
            If iRecIndex = 4 Then Exit For            'got complete record
        End If
    Next i
        
    If iRecIndex = 4 Then               'record received, do checksum
        iRecIndex = 0
        iChecksum = 0
        For i = 1 To 3
            iChecksum = (iChecksum + (RecordBuffer(i))) And 255
        Next i
           
' If checksum is OK and it's our address, then queue key for processing

       If iChecksum = 0 And RecordBuffer(1) = iSystemAddress Then
            If iQCount < 9 Then
                KeyQueue(iQCount) = RecordBuffer(2)
                iQCount = iQCount + 1
            End If
        End If
        
    ElseIf iRecIndex > 0 Then

'We've received part of the record, so set a 10ms timeout. Minimum timer
'resolution is actually 1/18 sec, and timer event has to be entered twice,
'so actual timeout will be between approx 55 and 110ms.

        fTimerSecondEvent = False
        tmrComm.Interval = 2500
        fSemComm = False
        tmrComm.Enabled = True
     End If
            
' Handle all other comm events

Case comEvDSR, comEvCTS
    If MSComm1.DSRHolding And MSComm1.CTSHolding Then 'assume device just connected...
        MSComm1.OutBufferCount = 0          'flush output buffer
        If fLCDEnabled Then
            tmrLCD1.Enabled = True          'this timer updates LCD top line
        End If
        tmrLCD2.Enabled = True              'this timer updates LCD bottom line
        StatMsg "Ready."
    Else
        StatMsg "Device not detected on Com " & CStr(iPortNumber) & " !"
    End If

Case comEventTxFull
    StatMsg "Transmit buffer overflow!"
    MSComm1.OutBufferCount = 0              'flush output buffer

Case comEventFrame, comEventOverrun, comEventRxParity
    StatMsg "Com async error!  (" & CStr(MSComm1.CommEvent) & ")"

Case comEventBreak                          'do nothing

Case Else
    StatMsg "Unexpected Com event!  (" & CStr(MSComm1.CommEvent) & ")"
End Select

Exit Sub

CommError:
    StatMsg "Unexpected Com error!"
    StatMsg "VBErr=" & CStr(Err) & ", Event=" & CStr(MSComm1.CommEvent)
    Resume Next
    
End Sub

'
Private Sub tmrComm_Timer()

'********************************************************************
'*
'* Serial port record receive timer (see the On_Comm event).
'*
'********************************************************************

If fSemComm Then
    tmrComm.Enabled = False
    Exit Sub
End If

' If second entry, timeout and flush the input buffer

If fTimerSecondEvent Then
    tmrComm.Enabled = False
    MSComm1.InBufferCount = 0       'flush input buffer
    iRecIndex = 0                   'reset receive count
Else
    fTimerSecondEvent = True        'next time, for sure!
End If

End Sub

'
Private Sub tmrKeyTimeout_Timer()

'********************************************************************
'*
'* IR key timeout timer.
'*
'* Using the timeout specified in setup, ProcessKeyCode starts this
'* timer and waits for the next key of a possible multi-key sequence.
'*
'* If it's a numeric sequence, and shift is active, then load the
'* selected playlist, else load and play the selected track number.
'*
'* If it's a shift only (no numerics), then reset 'cause we didn't
'* get the next key in time!
'*
'********************************************************************
Dim fResult As Boolean

tmrKeyTimeout.Enabled = False                   'one-shot

If fSemKeyTimeout Then
    Exit Sub
End If

Debug.Print "Key timeout"

If sBuildNumber <> "" Then                      'it's a numeric sequence...
    If fShift Then
        Call LoadPlayList(CInt(sBuildNumber))   'load requested playlist
    Else
        Call PlayTrack(CInt(sBuildNumber))      'else play the track!
    End If
    sBuildNumber = ""
End If

fShift = False

End Sub

'
Private Sub tmrLCD1_Timer()

'********************************************************************
'*
'* Scroll the song title and artist information across the top line
'* and update the equaliser display (if active).
'*
'********************************************************************
On Error GoTo 0

If fSemLCD1 Then
    tmrLCD1.Enabled = False
    Exit Sub
End If

If fLCDEnabled Then
    MSComm1.Output = Chr(1) & Left(sTopLine, 16)
    If fScrollEnabled Then
        sTopLine = Right(sTopLine, Len(sTopLine) - 1) & Left(sTopLine, 1)
    End If
    If fEqControl Then Call DisplayEq
End If

End Sub

'
Private Sub tmrLCD2_Timer()

'********************************************************************
'*
'* Display the LCD bottom line information.
'*
'********************************************************************
On Error GoTo 0

Dim iMins As Integer, iSecs As Integer, iStatus As Integer
Dim iTrackPosition As Long, iTrackLength As Long, iSampleRate As Long
Dim sTrackPosition As String, sTrackLength As String, sIndicator As String

If fSemLCD2 Then
    tmrLCD2.Enabled = False
    Exit Sub
End If

fSecsToggle = Not fSecsToggle
iStatus = WinAMP_GetStatus

' Get current track position, convert to min:sec format and display it.

If fLCDEnabled Then
    iTrackPosition = WinAMP_GetTrackPosition
    If iTrackPosition <> -1 And iTrackPosition < 6000 Then
        If iTrackPosition > 59 Then
            iMins = iTrackPosition \ 60
        Else
            iMins = 0
        End If
        iSecs = CInt(iTrackPosition Mod 60)
        sTrackPosition = Format(iMins, "00") & ":" & Format(iSecs, "00")
    Else
            sTrackPosition = "   " & Format(iMetaListIndex, "00")
    End If

    MSComm1.Output = Chr(16) & Chr(27 + 64) & sTrackPosition

' Get current track length, convert to min:sec format and display it.

    If Not fGotTrackLength Then
        iTrackLength = WinAMP_GetTrackLength
        If iTrackLength <> -1 And iTrackLength < 32768 Then
            fGotTrackLength = True
            If iTrackLength > 59 Then
                iMins = iTrackLength \ 60
            Else
                iMins = 0
            End If
            iSecs = CInt(iTrackLength Mod 60)
            sTrackLength = CStr(iMins) & ":" & Format(iSecs, "00")
            sTopLine = RTrim(sTopLineSave) & " (" & sTrackLength & ")   "
            If Not fScrollEnabled Then
                MSComm1.Output = Chr(1) & Left(sTopLine, 16)
            End If
        End If
    End If
    
' Get sample rate and display it.

    If Not fGotSampleRate Then
        iSampleRate = WinAMP_GetSampleRate
        If iSampleRate > 0 Then
            fGotSampleRate = True
            MSComm1.Output = Chr(16) & Chr(20 + 64) & CStr(iSampleRate) & "kHz"
        End If
    End If

' Select indicator for current mode (playing, paused or stopped).

    Select Case iStatus
        Case PLAYING
            sIndicator = Chr(128)               'custom LCD symbol
        Case PAUSED
            If Not fSecsToggle Then
                sIndicator = " "
            Else
                sIndicator = Chr(129)           'custom LCD symbol
            End If
        Case Else
            sIndicator = Chr(130)               'custom LCD symbol
    End Select

' Determine shuffle & repeat status, build appropriate indicator.

    If fRepeatList And fShuffleTracks Then
        sIndicator = Chr(134) & sIndicator      'custom LCD symbol
    ElseIf fRepeatList Then
        sIndicator = Chr(133) & sIndicator      'custom LCD symbol
    ElseIf fShuffleTracks Then
        sIndicator = Chr(132) & sIndicator      'custom LCD symbol
    Else
        sIndicator = " " & sIndicator
    End If

' Determine equaliser status and include indicator if enabled

    If iLastEqState <> 0 Then
        sIndicator = Chr(131) & sIndicator      'custom LCD symbol
    Else
        sIndicator = " " & sIndicator
    End If

' Now display the indicators on the bottom line.

    MSComm1.Output = Chr(16) & Chr(16 + 64) & sIndicator
End If

' If Winamp is stopped and fPlayAll is true, it means that we've
' just finished a track. If fTrackSync is false (we're not still trying
' to load a track from the last iteration!), then trigger tmrOneShot to
' load and play the next track in the list.

' If we can't find Winamp, then stop the auto play. WinAMP_GetStatus
' will return 0 (STOPPED). When the user hits any key on the remote, the
' status dialog will appear, displaying an appropriate distress message.

If fPlayNext And Not fTrackSync And iStatus = STOPPED Then
    If WinAMP_FindWindow Then
        fTrackSync = True                       'true until track is loaded
        tmrOneShot.Enabled = True               'fire in 100ms
    Else
        fPlayNext = False
    End If
End If

End Sub

'
Private Sub tmrOneShot_Timer()

'********************************************************************
'*
'* Handle close or shutdown request -OR-
'*
'* Load and play next Winamp track (see tmrLCD2)
'*
'********************************************************************
Dim iTemp As Integer

tmrOneShot.Enabled = False

' Handle close or shutdown request from ProcessKeyCode.
' Do it here because we can't have *anything* in the VB code queue!

If fSoftKill Then
    Call CloseAll
    Unload Me                           'bye bye
    Set frmControl = Nothing
    Exit Sub
End If

If fHardKill Then
    Call CloseAll
    Call Shutdown_Windows
    Unload Me                           'bye bye
    Set frmControl = Nothing
    Exit Sub
End If

' Load and play next Winamp track
    
Call NextTrack
fTrackSync = False                      'flag track load complete

End Sub


'
Private Sub tmrQueue_Timer()

'********************************************************************
'*
'* Dequeue and process the incoming IR keys.
'*
'********************************************************************
Dim i As Integer

tmrQueue.Enabled = False
If fSemQueue Then Exit Sub

If iQCount > 0 Then
    Call ProcessKeyCode(CStr(KeyQueue(iQCount - 1)))
    For i = 1 To 10
        KeyQueue(i - 1) = KeyQueue(i)
    Next
    iQCount = iQCount - 1
End If

tmrQueue.Enabled = True

End Sub

'
Private Sub KillTimers()

'********************************************************************
'*
'* Send a 'kill signal' to any running timers, then wait for them to
'* die. This ensures that we don't continue with timer code in the
'* VB queue.
'*
'********************************************************************
Dim iStartTime As Single

If tmrLCD1.Enabled Then fSemLCD1 = True
If tmrLCD2.Enabled Then fSemLCD2 = True
If tmrQueue.Enabled Then fSemQueue = True
If tmrKeyTimeout.Enabled Then fSemKeyTimeout = True
        
iStartTime = Timer                  'wait max. 10 secs...

Do While (Timer < iStartTime + 10) And (tmrLCD1.Enabled Or tmrLCD2.Enabled Or tmrQueue.Enabled Or tmrKeyTimeout.Enabled)
    DoEvents
Loop

fSemLCD1 = False
fSemLCD2 = False
fSemQueue = False
fSemKeyTimeout = False

End Sub

'
Private Function InitSettings() As Boolean

'********************************************************************
'*
'* Initialise everything, including Winamp.
'*
'********************************************************************
On Error Resume Next

Dim i As Long, iValue As Long
Dim iStartTime As Single
Dim sTemp As String, sResult As String

InitSettings = False             'for an early exit...

' Load settings from registry

StatMsg "Loading registry settings"

iSystemAddress = CInt(GetSetting(App.Title, "System", "Address", "0"))
iLastVolume = CLng(GetSetting(App.Title, "System", "Volume", "127"))
iLastPreamp = CLng(GetSetting(App.Title, "System", "Preamp", "31"))
iLastEqState = CLng(GetSetting(App.Title, "System", "Eq State", "0"))
iPortNumber = CInt(GetSetting(App.Title, "General", "Com Port", "2"))
iKeyTimeout = CSng(GetSetting(App.Title, "General", "Key Timeout", "1"))
fLCDEnabled = CBool(GetSetting(App.Title, "General", "Enable LCD", "1"))
fMetaListEnable = CBool(GetSetting(App.Title, "Playlist", "Metalist Enable", "0"))
iMetaListIndex = CInt(GetSetting(App.Title, "Playlist", "Metalist Index", "1"))
sPlayListFile = GetSetting(App.Title, "Playlist", "Path", "")
sWinAmpPath = GetSetting(App.Title, "Winamp", "Path", "")
KeyCodeArray = GetAllSettings(App.Title, "Key Codes")
ShiftCodeArray = GetAllSettings(App.Title, "Shift Codes")
EqSliderArray = GetAllSettings(App.Title, "Eq Sliders")

If sPlayListFile = "" Then
    StatMsg "Playlist not defined, run setup!"
    Exit Function
End If

If sWinAmpPath = "" Or Dir(sWinAmpPath) = "" Then
    StatMsg "Invalid Winamp path, run setup!"
    Exit Function
End If

If Err.Number <> 0 Then
    StatMsg "Error loading settings, run setup!  (" & CStr(Err) & ")"
    Exit Function
End If

If fMetaListEnable Then sMetaListFile = sPlayListFile

' Check that we can find the (meta) playlist. If not, keep trying
' for 60 seconds to allow for systems with the list on CD-ROM.

If Dir(sPlayListFile) = "" Or Err.Number <> 0 Then

    If fMetaListEnable Then
        sTemp = "meta"
    Else
        sTemp = "play"
    End If
    StatMsg "Can't find " & sTemp & "list, retrying for 60 seconds..."
    
    iStartTime = Timer
    Do While Not fClickedAbort And Timer < iStartTime + 60
        Err.Clear
        sResult = Dir(sPlayListFile)
        If sResult <> "" And Err.Number = 0 Then Exit Do
        DoEvents
    Loop
    
    If sResult = "" Or Err.Number <> 0 Then
            StatMsg (UCase(Left(sTemp, 1))) & Mid(sTemp, 2) & "list not found!"
        Exit Function
    End If
End If

' Init variables (...it makes me feel better :)

fSoftKill = False               'system shutdown flags
fHardKill = False
fPlayNext = False               'auto play next
fTrackSync = False              'wait for last track load
fShift = False                  'remote shift(ed)
fFirstKey = True                'very first remote code
sTopLine = ""                   'top LCD line string

tmrQueue.Interval = 100
tmrOneShot.Interval = 100
tmrLCD1.Interval = 200
tmrLCD2.Interval = 1000
tmrKeyTimeout.Interval = iKeyTimeout * 1000

' Attempt to start Winamp (if not already running).
' If we can't find it's window within 10 secs, then bomb!

If Not WinAMP_FindWindow Then
    If WinAMP_Start(sWinAmpPath) Then
        iStartTime = Timer
        Do While Not fClickedAbort And Timer < iStartTime + 10
            If WinAMP_FindWindow Then
                Exit Do
            End If
        DoEvents
        Loop
    End If
    
    If Not WinAMP_FindWindow Then
        StatMsg "Can't load or initialise Winamp!"
        Exit Function
    End If
    
    sWinAmpVersion = WinAMP_GetVersion
    StatMsg "Winamp " & sWinAmpVersion & " loaded"
Else
    StatMsg "Winamp already loaded"
End If

' Load any Winamp settings here...

StatMsg "Initialising Winamp settings"

WinAMP_SetVolume (iLastVolume)
WinAMP_SetPreAmpValue (iLastPreamp)
WinAMP_SetEQState (iLastEqState)
WinAMP_SetRepeat (0)            'turn off repeat
WinAMP_SetShuffle (0)           ' and shuffle

For i = 0 To 9
    iValue = CLng(EqSliderArray(i, 1))
    If Not (iValue < 0 Or iValue > 9) Then
        Call WinAMP_SetEQValue(i, iValue)
    End If
Next

InitSettings = True

End Function


'
Private Function InitComm() As Boolean

'********************************************************************
'*
'* Initialise the chosen serial port.
'*
'********************************************************************
On Error Resume Next

fEnableCommInput = False            'no input just yet
iRecIndex = 0                       'init receive count
iQCount = 0                         'and queued key count

If MSComm1.PortOpen = True Then
    MSComm1.PortOpen = False
End If

MSComm1.CommPort = iPortNumber
MSComm1.InputMode = comInputModeBinary
MSComm1.Settings = "9600,N,8,1"
MSComm1.Handshaking = comRTS
MSComm1.ParityReplace = " "
MSComm1.InBufferSize = 128
MSComm1.OutBufferSize = 128
MSComm1.InputLen = 0                'get entire input buffer on read
MSComm1.RThreshold = 1              'generate an event on each received char
MSComm1.SThreshold = 0              'never generate a tx buffer empty event

MSComm1.PortOpen = True             'attempt the open

If Err.Number <> 0 Then
    StatMsg "Can't open Com " & CStr(iPortNumber) & " !  (" & CStr(Err) & ")"
    InitComm = False
    Exit Function
End If

' If the hardware is plugged into the selected serial port, then asserting
' DTR should generate a comEvDSR, because DSR is looped back to DTR.

' If it does, the event handler will enable serial output. We check that
' the event has occured, and if not we do it anyway (MSComm is a basket case...)

' If the device is not connected, it's not treated as a serious error (the
' load process continues).

MSComm1.DTREnable = True
MSComm1.RTSEnable = True

If Not tmrLCD1.Enabled Then
    If MSComm1.DSRHolding And MSComm1.CTSHolding Then
        If fLCDEnabled Then
            MSComm1.Output = Chr(12)
            tmrLCD1.Enabled = True      'this timer updates LCD top line
        End If
        tmrLCD2.Enabled = True          'this timer updates LCD bottom line
    Else
        StatMsg "Device not detected on Com " & CStr(iPortNumber) & " !"
    End If
End If

sTopLine = "  MP3 JUKEBOX   "           'display something while lists load...

InitComm = True
   
End Function


'
Private Sub CloseAll()

'********************************************************************
'*
'* Close Winamp & clean up ready for exit.
'*
'********************************************************************
On Error GoTo 0

Dim i As Integer

StatMsg "Exiting..."

fEnableCommInput = False            'ignore any incoming
Call KillTimers                     'terminate all timers

If MSComm1.PortOpen And fLCDEnabled Then
    MSComm1.Output = Chr(12)        'clear screen
End If

' Close Winamp

If WinAMP_FindWindow Then
    iLastPreamp = WinAMP_GetPreAmpValue
    StatMsg "Closing Winamp"
    WinAMP_SendCommandMessage WA_STOP
    WinAMP_ClearPlaylist
    WinAMP_PostCommandMessage WA_CLOSE
End If

If MSComm1.PortOpen Then            'close the serial link
    MSComm1.PortOpen = False
End If

' Save any settings here...

If cmdOK.Enabled = True Then        'but only if init was successfull!
    StatMsg "Saving settings"
    SaveSetting App.Title, "System", "Volume", CStr(iLastVolume)
    SaveSetting App.Title, "System", "Preamp", CStr(iLastPreamp)
    SaveSetting App.Title, "System", "Eq State", CStr(iLastEqState)
    SaveSetting App.Title, "Playlist", "Metalist Index", CStr(iMetaListIndex)
    
    If Not IsEmpty(EqSliderArray) Then
        For i = 0 To 9
            SaveSetting App.Title, "Eq Sliders", CStr(i), EqSliderArray(i, 1)
        Next
    End If
End If

Close                               'close all files

If cSysTray1.InTray = True Then
    StatMsg "Removing from Systray"
    cSysTray1.InTray = False
End If

Me.WindowState = vbMinimized        'zzzzzz...

End Sub

'
Private Sub ProcessKeyCode(bKeyCode As Byte)

'********************************************************************
'*
'* Process received keycodes.
'*
'* tmr_Queue periodically (every 100mS) checks for keys in the input
'* queue and sends them here for processing.
'*
'********************************************************************
On Error GoTo KeyProcErr

Dim i As Integer
Dim sKeyCode As String

fSemKeyTimeout = True                       'kill timer action

' Determine if this key is a repeat of the last

If (bKeyCode And &H80) = bToggleByte And Not fFirstKey Then
    fRepeatKey = True
Else
    fRepeatKey = False
    fFirstKey = False
End If

bToggleByte = bKeyCode And &H80
sKeyCode = CStr(bKeyCode And &H7F)
            
' Make sure that Winamp is still running. If not, display an
' error message and exit.

If Not WinAMP_FindWindow Then
    StatMsg "Winamp failed to respond!"
    Me.Visible = True                       'unhide me
    Me.WindowState = vbNormal
    Me.SetFocus
    sBuildNumber = ""                       'ignore received key(s)
    Exit Sub
End If

' Check for numeric (0 - 9) keys

If Len(sKeyCode) = 1 And Not fRepeatKey Then    'numeric
    
    If fEqControl Then
        iEqSlider = CLng(sKeyCode)
        Exit Sub
    End If
    
    If Len(sBuildNumber) = 3 Then           'already got three numerals...
        sBuildNumber = ""
        Exit Sub                            'four are invalid, so quit
    End If
        
    sBuildNumber = sBuildNumber & sKeyCode
    
    If Len(sBuildNumber) = 2 And fShift Then
        Call LoadPlayList(CInt(sBuildNumber))
        sBuildNumber = ""
        Exit Sub
    ElseIf Len(sBuildNumber) = 3 And Not fShift Then
        Call PlayTrack(CInt(sBuildNumber))
        sBuildNumber = ""
        Exit Sub
    Else

' Start the key timout timer. If we get a timeout before the next
' keypress, then tmrKeyTimeout will play the track in (sBuildNumber).

        fSemKeyTimeout = False
        tmrKeyTimeout.Enabled = True
        Exit Sub
    End If
End If

' Not numeric ... scan for a match in our array of programmed codes.
' Non-shifted codes are checked first.

If Not fShift Then
    For i = LBound(KeyCodeArray, 1) To UBound(KeyCodeArray, 1)
        If sKeyCode = KeyCodeArray(i, 1) Then
            Select Case KeyCodeArray(i, 0)

' Shift starts the key timeout timer. If we get a timeout before
' the next keypress, then tmrKeyTimeout clears the shift flag.
        
            Case "Shift"
                fShift = True                   'flag next key "shifted"
                fSemKeyTimeout = False
                tmrKeyTimeout.Enabled = True
                Exit Sub

' If the previous one or two keys were numeric, pass the key(s) to
' PlayTrack to begin playing. Otherwise, just play the current track.

            Case "Play"
                If Not fRepeatKey Then          'ignore if repeated key
                    If sBuildNumber <> "" Then
                        Call PlayTrack(CInt(sBuildNumber))
                        sBuildNumber = ""
                    Else
                        Call PlayTrack(iTrackNumber)
                    End If
                End If
                Exit Sub
        
            Case "Pause"
                If Not fRepeatKey Then          'ignore if repeated key
                    Call PauseTrack
                End If
                Exit Sub
        
            Case "Stop"
                If Not fRepeatKey Then          'ignore if repeated key
                    Call StopTrack
                End If
                Exit Sub
        
            Case "Fade Out"
                If Not fRepeatKey Then          'ignore if repeated key
                    Call FadeOutTrack
                End If
                Exit Sub
        
            Case "Prev"
                If fEqControl Then
                    Call DecreaseEqSlider
                Else
                    Call PrevTrack
                End If
                Exit Sub
            
            Case "Next"
                If fEqControl Then
                    Call IncreaseEqSlider
                Else
                    Call NextTrack
                End If
                Exit Sub
                
            Case "Back 5 Secs"
                Call RewindTrack
                Exit Sub
        
            Case "Fwd 5 Secs"
                Call FastFwdTrack
                Exit Sub
        
            Case "Volume Up"
                Call VolumeUp
                Exit Sub
        
            Case "Volume Down"
                Call VolumeDown
                Exit Sub
        
            Case "Repeat"
                If Not fRepeatKey Then         'ignore if repeated key
                    Call ToggleRepeat
                End If
                Exit Sub
        
            Case "Shuffle"
                If Not fRepeatKey Then        'ignore if repeated key
                    Call ToggleShuffle
                End If
                Exit Sub
            End Select
        End If
    Next
StatMsg "Unknown IR code [" & sKeyCode & "]"
Else

' Scan "shifted" codes...
    
    If fRepeatKey Then Exit Sub                 'ignore all repeated shifts
    fShift = False
    
    For i = LBound(ShiftCodeArray, 1) To UBound(ShiftCodeArray, 1)
        If sKeyCode = ShiftCodeArray(i, 1) Then
            Select Case ShiftCodeArray(i, 0)

' If the previous one or two keys were numeric, pass the key(s) to
' LoadPlayList to load the selected list. Otherwise, reload the
' current list.
            
            Case "Load Playlist"
                If sBuildNumber <> "" Then
                    Call LoadPlayList(CInt(sBuildNumber))
                    sBuildNumber = ""
                Else
                    Call LoadPlayList(iMetaListIndex) 'reload current list
                End If
                Exit Sub
                
            Case "Reload Playlist"
                Call ReloadPlayList
                Exit Sub
                
            Case "Prev Playlist"
                Call PrevPlayList
                Exit Sub
        
            Case "Next Playlist"
                Call NextPlayList
                Exit Sub
        
            Case "Close Winamp"
                fSoftKill = True
                tmrOneShot.Enabled = True
                Exit Sub
        
            Case "Shut Down PC"
                fHardKill = True
                tmrOneShot.Enabled = True
                Exit Sub
        
            Case "Set Equaliser"
                Call ToggleEqControl
                Exit Sub
            
            Case "Toggle Equaliser"
                Call ToggleEqState

                Exit Sub
            
            End Select
        End If
    Next
StatMsg "Unknown IR code [" & sKeyCode & "]"
End If

Exit Sub

KeyProcErr:
StatMsg "Error processing command!  (" & CStr(Err) & ")"
Resume Next

End Sub

'
Private Sub FadeOutTrack()

'********************************************************************
'*
'* Fade out and stop currently-playing track.
'*
'********************************************************************
Dim iStatus As Integer

fPlayNext = False                   'stop auto play next track
iStatus = WinAMP_GetStatus

If iStatus = PLAYING Then
    WinAMP_SendCommandMessage WA_FADEOUTSTOP
ElseIf iStatus = PAUSED Then
    WinAMP_SendCommandMessage WA_STOP
End If

End Sub

'
Private Sub FastFwdTrack()

'********************************************************************
'*
'* Skip forward 5 seconds in current track.
'*
'********************************************************************

If WinAMP_GetStatus <> STOPPED Then
    WinAMP_PostCommandMessage WA_FASTFORWARD
End If

End Sub

'
Private Function LoadPlayList(iMetaListNumber As Integer) As Boolean

'********************************************************************
'*
'* Opens specified playlist from the 'meta' list. If not using
'* a 'meta' list, then just reloads the playlist.
'*
'* First track in the playlist is sent to Winamp. If Winamp was
'* playing or paused, then play begins immediately.
'*
'********************************************************************

Dim iStatus As Integer

iStatus = WinAMP_GetStatus

If OpenPlayList(iMetaListNumber) Then
    Call LoadTrack(iTrackNumber)
    If iStatus <> STOPPED Then
        Call PlayTrack(iTrackNumber)
    End If
    LoadPlayList = True
Else
    LoadPlayList = False
End If

End Function

Private Function ReloadPlayList() As Boolean

'********************************************************************
'*
'* Reloads the metalist & the current playlist.
'*
'* Useful for CD-based systems, allowing the disc to be swapped
'* without having to restart.
'*
'********************************************************************

Dim iStatus As Integer

StatMsg "Reloading lists..."
iStatus = WinAMP_GetStatus
Call StopTrack
sTopLine = "RELOADING LISTS<><><>"
fScrollEnabled = True

Close #hMetaListFile
If InitLists Then
    If iStatus <> STOPPED Then
        Call PlayTrack(iTrackNumber)
    End If
    ReloadPlayList = True
Else
    ReloadPlayList = False
End If

End Function

'
Private Function OpenPlayList(iMetaListNumber As Integer) As Boolean

'********************************************************************
'*
'* Open the playlist and count the entries.
'*
'* No (MP3) file integrity checking is performed.
'*
'********************************************************************
On Error Resume Next

Dim i As Integer
Dim sFileName As String, sLine As String, sMP3Path As String

' Check if we're using a 'meta' playlist.

If hMetaListFile > 0 Then
    sFileName = GetPlayList(iMetaListNumber)
    If sFileName = "" Then
        OpenPlayList = False
        Exit Function
    End If
    
' If the playlist file we retrieved doesn't have a path, then assume
' it's in the same directory as the meta list...

    If InStr(sFileName, "\") = 0 Then       'no path, huh?
        sFileName = sMetaListPath & sFileName
    End If
Else
    
' Not using 'meta' list, get playlist file from setup
    
    sFileName = sPlayListFile
End If

' Check that it actually exists before trying the open

If Dir(sFileName) = "" Or Err.Number <> 0 Then
    StatMsg "Can't find playlist " & iMetaListNumber & "  [" & sFileName & "]"
    OpenPlayList = False
    Exit Function
End If

' Now open the playlist file.

If hPlayListFile > 0 Then Close #hPlayListFile  'close previous first!
hPlayListFile = FreeFile

StatMsg "Opening playlist " & iMetaListNumber & "  [" & sFileName & "]"

Open sFileName For Input Lock Write As hPlayListFile

If Err.Number <> 0 Then
    OpenPlayList = False
    StatMsg "Can't open playlist!  (" & CStr(Err) & ")"
Else
    sPlayListFile = sFileName
    sMP3Path = Left(sPlayListFile, InStrRev(sPlayListFile, "\"))

' Count the number of entries in the playlist file, skipping blank
' lines and lines beginning with a hash.

    StatMsg "Scanning playlist..."

    iTrackCount = 0
    For i = 1 To 5000
        If EOF(hPlayListFile) Then Exit For
        Line Input #hPlayListFile, sLine
        If sLine <> "" And (Left(LTrim(sLine), 1) <> "#") Then
            If Dir(sMP3Path & sLine) <> "" And Err.Number = 0 Then
                LineIndex(iTrackCount) = i      'save this track's line number
                iTrackCount = iTrackCount + 1
                If iTrackCount = 199 Then Exit For
            Else
                StatMsg "Skipping invalid mp3 file: " & sLine
            End If
            Err.Clear
        End If
    Next
    
    If iTrackCount = 0 Then
        OpenPlayList = False
        StatMsg "No valid tracks in playlist!"
    Else
        StatMsg "Track count = " & iTrackCount
        Call GetRandomTrackNumber(LISTRESET)    'reset the shuffle variables
        iMetaListIndex = iMetaListNumber        'save index for prev/next functions
        OpenPlayList = True
    End If
End If

End Function

'
Private Function NextPlayList() As Boolean

'********************************************************************
'*
'* Load the next playlist file in the meta list.
'*
'********************************************************************
Dim iListNum As Integer

If iMetaListIndex < iPlayListCount Then
    iListNum = iMetaListIndex
    Do
        iListNum = iListNum + 1
        If LoadPlayList(iListNum) Then
            NextPlayList = True
            Exit Function
        End If
    Loop While iListNum < iPlayListCount
End If

' Couldn't load next, so reload original

LoadPlayList (iMetaListIndex)
NextPlayList = False

End Function

'
Private Function OpenMetaList() As Boolean

'********************************************************************
'*
'* Open the 'meta' playlist and count the entries.
'*
'********************************************************************
On Error Resume Next

Dim i As Integer
Dim sFileName As String

hMetaListFile = FreeFile

StatMsg "Opening metalist: " & sMetaListFile

Open sMetaListFile For Input Lock Write As hMetaListFile

If Err.Number <> 0 Then
    StatMsg "Can't open metalist!  (" & CStr(Err) & ")"
    iPlayListCount = 0
    OpenMetaList = False
    Exit Function
End If

sMetaListPath = Left(sPlayListFile, InStrRev(sPlayListFile, "\"))
StatMsg "Scanning metalist..."
    
iPlayListCount = 0
For i = 1 To 5000
    If EOF(hMetaListFile) Then Exit For
    Line Input #hMetaListFile, sFileName
    If sFileName <> "" And (Left(LTrim(sFileName), 1) <> "#") Then
        If InStr(sFileName, "\") = 0 Then                   'no path, huh?
            sFileName = sMetaListPath & sFileName
        End If
        If Dir(sFileName) <> "" And Err.Number = 0 Then
            MetaLineIndex(iPlayListCount) = i      'save this entries line #
            iPlayListCount = iPlayListCount + 1
            If iPlayListCount = 99 Then Exit For
        Else
            StatMsg "Skipping invalid playlist: " & sFileName
        End If
        Err.Clear
    End If
Next
    
If iPlayListCount = 0 Then
    StatMsg "No valid entries in metalist!"
    OpenMetaList = False
Else
    StatMsg "Playlist count = " & iPlayListCount
    OpenMetaList = True
End If

End Function

'
Private Function LoadTrack(iThisTrack As Integer) As Boolean

'********************************************************************
'*
'* Get the filename associated with the track index number from the
'* currently open playlist. If it's valid (i.e. it exists), then
'* send it to Winamp. Finally, retrieve the tag info and build the
'* LCD top line string.
'*
'********************************************************************
On Error Resume Next

Dim sFileName As String, sMP3File As String
Dim sTrackArtist As String, sTrackTitle As String
Dim iResult As Long, i As Integer

' Find track in currently open playlist by index number.

sFileName = GetTrack(iThisTrack)
If sFileName = "" Then              'end of list
    LoadTrack = False
    Exit Function
End If
    
 ' Prepend the full path to the (MP3) filename
 
sMP3File = Left(sPlayListFile, InStrRev(sPlayListFile, "\")) & sFileName

If Dir(sMP3File) = "" Or Err.Number <> 0 Then
    LoadTrack = False
    Exit Function
End If
    
' Stop if playing or paused

If WinAMP_GetStatus <> STOPPED Then
    WinAMP_SendCommandMessage WA_STOP
End If
    
' Clear playlist and add new track to WinAMP's playlist.

Call WinAMP_ClearPlaylist
iResult = WinAMP_AddFile(sMP3File)
Call GetID3v1Tag(iThisTrack, sMP3File)       'Update tag info

' Put together the string for the top LCD line. Underscore characters in the
' artist/title names are replaced with spaces, and ASCII codes are limited
' to <128 and >31.

' When either artist or title is missing, then "Unknown" is substituted.
' If no TAG info is found, or both artist and title are missing, then the
' filename (minus the extension) is used instead.

On Error GoTo 0

If UCase(MP3Tag.sTag) = "TAG" Then
    sTrackArtist = ConvertAscii(MP3Tag.sArtist)
    sTrackArtist = UCase(Trim(Replace(sTrackArtist, "_", " ")))
    sTrackTitle = ConvertAscii(MP3Tag.sTitle)
    sTrackTitle = UCase(Trim(Replace(sTrackTitle, "_", " ")))
    
    If sTrackArtist = "" And sTrackTitle = "" Then
        sTopLine = CStr(iThisTrack) & "." & UCase(Left(sFileName, InStrRev(sFileName, ".") - 1)) & "  "
    Else
        If sTrackArtist = "" Then
            sTrackArtist = "UNKNOWN ARTIST"
        ElseIf sTrackTitle = "" Then
            sTrackTitle = "UNKNOWN TITLE"
        End If
        sTopLine = CStr(iThisTrack) & "." & sTrackArtist & " - " & sTrackTitle & "  "
    End If
Else
    sTopLine = CStr(iThisTrack) & "." & UCase(Left(sFileName, InStrRev(sFileName, ".") - 1)) & "  "
End If

sTopLineSave = sTopLine
iTrackNumber = iThisTrack               'becomes current track in playlist

If Len(sTopLine) > 9 Then
    fScrollEnabled = True
Else
    fScrollEnabled = False
End If

If Len(sTopLine) < 16 Then
    sTopLine = sTopLine & String(16 - Len(sTopLine), " ")
End If

fGotTrackLength = False                 'track and sample rate to come
fGotSampleRate = False

StatMsg "Load track " & iTrackNumber & "  [" & sMP3File & "]"

LoadTrack = True

End Function

'
Function PrevPlayList() As Boolean

'********************************************************************
'*
'* Bump the 'meta' list index, load the playlist file, etc.
'*
'********************************************************************
Dim iListNum As Integer

iListNum = iMetaListIndex

Do While iListNum > 1
    iListNum = iListNum - 1
    If LoadPlayList(iListNum) Then
        PrevPlayList = True
        Exit Function
    End If
Loop

' Couldn't load previous, so reload original.

LoadPlayList (iMetaListIndex)
PrevPlayList = False

End Function

'
Private Sub NextTrack()

'********************************************************************
'*
'* Load the next track and play it if appropriate.
'*
'********************************************************************
On Error GoTo 0

Dim i As Integer, iStatus As Integer
Dim fResetStatus As Boolean

If Not PlayedTracks(iTrackNumber - 1) Then
    iPlayedTrackCount = iPlayedTrackCount + 1
    PlayedTracks(iTrackNumber - 1) = True             'flag played
End If

' Handle track shuffling (yuck)

If fShuffleTracks Then
    TrackShuffleList(iShuffleIndex) = iTrackNumber
    iShuffleIndex = iShuffleIndex + 1
    
' Check is we've backed up in the list (PrevTrack). If we have,
' get the next from the list, else get next random track.

    If TrackShuffleList(iShuffleIndex) > 0 Then
        iTrackNumber = TrackShuffleList(iShuffleIndex)
    Else
        fResetStatus = GetRandomTrackNumber(NOLISTRESET)
    End If
Else
    
' Shuffle off, just bump track number and reset if at end of list.

    If iTrackNumber = iTrackCount Then
        fResetStatus = True
        iTrackNumber = 1
    Else
        iTrackNumber = iTrackNumber + 1
    End If
End If

' Load the track and decide whether to play it or not

If LoadTrack(iTrackNumber) Then
    If (fPlayNext And Not fResetStatus) Or (fResetStatus And fPlayNext And fRepeatList) Then
        WinAMP_SendCommandMessage WA_PLAY
    Else
        fPlayNext = False
    End If
Else
    fPlayNext = False
End If

End Sub

'
Private Function GetID3v1Tag(iTrack As Integer, sFileName As String) As Boolean

'********************************************************************
'*
'* Gets the ID3v1 tag info from the specified file.
'*
'********************************************************************
On Error GoTo FileError

Dim hMP3File As Integer

MP3Tag.sTag = ""
hMP3File = FreeFile
Open sFileName For Binary Access Read As hMP3File
Seek #hMP3File, LOF(hMP3File) - 127
Get #hMP3File, , MP3Tag
Close #hMP3File

GetID3v1Tag = True
Exit Function

FileError:
StatMsg "Error reading ID3 tag from track " & iTrack & "  [" & sFileName & "]  (" & CStr(Err) & ")"
Close #hMP3File

GetID3v1Tag = False

End Function

'
Private Function GetRandomTrackNumber(fResetList As Boolean) As Boolean

'********************************************************************
'*
'* Get the next random track.
'*
'* Stores the new track in iTrackNumber. If fResetList is true,
'* then the list and the random number generator are reset.
'*
'********************************************************************
On Error GoTo 0

Dim i As Integer

If Not fResetList And iShuffleIndex < iTrackCount And iPlayedTrackCount < iTrackCount Then
    
' Select next track at random from list of unplayed tracks

    Do
        iTrackNumber = Int((iTrackCount * Rnd) + 1)
    Loop While PlayedTracks(iTrackNumber - 1)   'get unique number
    GetRandomTrackNumber = False                'list wasn't reset
Else

' Reset requested or all tracks played

    StatMsg "Reset shuffle list"
    iShuffleIndex = 0
    iPlayedTrackCount = 0
    For i = 0 To iTrackCount
        PlayedTracks(i) = False
        TrackShuffleList(i) = 0
    Next
    Randomize
    If fShuffleTracks Then
        iTrackNumber = Int((iTrackCount * Rnd) + 1)
    Else
        iTrackNumber = 1
    End If
    GetRandomTrackNumber = True                 'list was reset
End If

End Function

'
Private Function GetTrack(iNewTrack As Integer) As String

'********************************************************************
'*
'* Gets (iNewTrack) track from the open playlist.
'*
'********************************************************************
On Error GoTo FileError

Dim sLine As String
Dim i As Integer

GetTrack = ""

Seek #hPlayListFile, 1

For i = 1 To LineIndex(iNewTrack - 1)
    If EOF(hPlayListFile) Then Exit Function
    Line Input #hPlayListFile, sLine
Next

GetTrack = sLine
Exit Function

FileError:
StatMsg "Error reading playlist!  (" & CStr(Err) & ")"

End Function

'
Private Function GetPlayList(iLineIndex As Integer) As String

'********************************************************************
'*
'* Gets (iLineIndex) playlist path from the metalist.
'*
'********************************************************************
On Error GoTo FileError

Dim sLine As String
Dim i As Integer

GetPlayList = ""

Seek #hMetaListFile, 1

For i = 1 To MetaLineIndex(iLineIndex - 1)
    If EOF(hMetaListFile) Then Exit Function
    Line Input #hMetaListFile, sLine
Next

GetPlayList = sLine
Exit Function

FileError:
StatMsg "Error reading metalist!  (" & CStr(Err) & ")"

End Function

'
Private Sub PauseTrack()

Dim iStatus As Integer

iStatus = WinAMP_GetStatus

If iStatus = PLAYING Then
    WinAMP_SendCommandMessage WA_PAUSE
ElseIf iStatus = PAUSED Then
    WinAMP_SendCommandMessage WA_PLAY
End If

End Sub

'
Private Sub PrevTrack()

'********************************************************************
'*
'* Load previous track and play it if appropriate.
'*
'********************************************************************
On Error GoTo 0

Dim iStatus As Integer
   
If fShuffleTracks Then
    If iShuffleIndex > 0 Then
        iShuffleIndex = iShuffleIndex - 1
        iTrackNumber = TrackShuffleList(iShuffleIndex)
    End If
Else
    If iTrackNumber > 1 Then
    iTrackNumber = iTrackNumber - 1
    End If
End If

iStatus = WinAMP_GetStatus            'save status
If LoadTrack(iTrackNumber) Then
    If iStatus <> STOPPED Then
        WinAMP_SendCommandMessage WA_PLAY
    End If
End If

End Sub

'
Private Sub RewindTrack()

'********************************************************************
'*
'* Skip back 5 seconds in current track.
'*
'********************************************************************

If WinAMP_GetStatus <> STOPPED Then
    WinAMP_PostCommandMessage WA_FASTREWIND
End If

End Sub

'
Private Sub StopTrack()

fPlayNext = False

If WinAMP_GetStatus <> STOPPED Then
    WinAMP_SendCommandMessage WA_STOP
End If

End Sub

'
Private Sub PlayTrack(iThisTrack As Integer)

'********************************************************************
'*
'* Plays the specified track.
'*
'********************************************************************
On Error GoTo 0

If iThisTrack > 0 And iThisTrack < iTrackCount + 1 Then
    
    If Not PlayedTracks(iThisTrack - 1) Then
        iPlayedTrackCount = iPlayedTrackCount + 1
        PlayedTracks(iThisTrack - 1) = True         'flag played
    End If

    If iThisTrack <> iTrackNumber Then
        LoadTrack (iThisTrack)
        WinAMP_SendCommandMessage WA_PLAY
    Else
        If WinAMP_GetStatus = PLAYING Then          'if already playing...
            WinAMP_SendCommandMessage WA_STOP       'then stop and...
        End If
        WinAMP_SendCommandMessage WA_PLAY           'replay this track
    End If
    
    fPlayNext = True

End If

End Sub

'
Private Sub ToggleEqControl()

'********************************************************************
'*
'* Toggle equaliser control on/off.
'*
'********************************************************************
On Error GoTo 0

' Kill LCD line 2 timer

If tmrLCD2.Enabled Then fSemLCD2 = True
Do While tmrLCD2.Enabled
    DoEvents
Loop
fSemLCD2 = False

If fLCDEnabled Then
    MSComm1.Output = Chr(12)        'clear screen
End If

fEqControl = Not fEqControl
fGotSampleRate = False              'force redisplay of sample rate
If Not fEqControl Then
    tmrLCD2.Enabled = True
End If

End Sub

'
Private Sub ToggleRepeat()

fRepeatList = Not fRepeatList
If fRepeatList Then
    StatMsg "Repeat on"
Else
    StatMsg "Repeat off"
End If

End Sub

'
Private Sub ToggleShuffle()

'********************************************************************
'*
'* Toggle shuffle on/off.
'*
'********************************************************************
On Error GoTo 0

Dim i As Integer

If Not fShuffleTracks Then
    fShuffleTracks = True
    StatMsg "Shuffle on"

' Reset the sequence list (but not the tracks played!)

    iShuffleIndex = 0
    For i = 0 To iTrackCount
        TrackShuffleList(i) = 0
    Next
    
' If stopped, then load the first random track

    If WinAMP_GetStatus = STOPPED Then
        Call GetRandomTrackNumber(NOLISTRESET)
        Call LoadTrack(iTrackNumber)
    End If
Else
    fShuffleTracks = False
    StatMsg "Shuffle off"
End If

End Sub

'
Private Sub VolumeDown()

If iLastVolume > 9 Then
    iLastVolume = iLastVolume - 10
Else
    iLastVolume = 0
End If

WinAMP_SetVolume (iLastVolume)

End Sub

'
Private Sub VolumeUp()

If iLastVolume < 256 - 10 Then
    iLastVolume = iLastVolume + 10
Else
    iLastVolume = 255
End If

WinAMP_SetVolume (iLastVolume)

End Sub

'
Private Sub DecreaseEqSlider()

'********************************************************************
'*
'* Decrease the currently-displayed EQ slider by one point.
'*
'********************************************************************
Dim iValue As Long

iValue = WinAMP_GetEQValue(iEqSlider)
If iValue <> -1 And iValue < 63 Then
    iValue = iValue + 1
    EqSliderArray(iEqSlider, 1) = CStr(iValue)
    Call WinAMP_SetEQValue(iEqSlider, iValue)
End If

End Sub

'
Private Sub IncreaseEqSlider()

'********************************************************************
'*
'* Increase the currently-selected EQ slider by one point.
'*
'********************************************************************
Dim iValue As Long

iValue = WinAMP_GetEQValue(iEqSlider)
If iValue > 0 Then
    iValue = iValue - 1
    EqSliderArray(iEqSlider, 1) = CStr(iValue)
    Call WinAMP_SetEQValue(iEqSlider, iValue)
End If

End Sub

'
Private Sub DisplayEq()

'********************************************************************
'*
'* Display the equaliser slider (iEQSlider) value on the LCD bottom
'* line. The current value of the slider is retrieved from Winamp.
'*
'********************************************************************
Dim iValue As Long
Dim sEqLine As String

If WinAMP_FindWindow Then
    Select Case iEqSlider
        Case 0
            sEqLine = "60Hz "
        Case 1
            sEqLine = "170Hz"
        Case 2
            sEqLine = "310Hz"
        Case 3
            sEqLine = "600Hz"
        Case 4
            sEqLine = "1kHz "
        Case 5
            sEqLine = "3kHz "
        Case 6
            sEqLine = "6kHz "
        Case 7
            sEqLine = "12kHz"
        Case 8
            sEqLine = "14kHz"
        Case 9
            sEqLine = "16kHz"
    End Select

    sEqLine = Chr(16) & Chr(16 + 64) & "EQ " & sEqLine & " "

    iValue = WinAMP_GetEQValue(iEqSlider)
    If iValue <> -1 Then
        If iValue < 31 Then
            iValue = ((Not iValue) And 31)
            sEqLine = sEqLine & Chr(43) & CStr(iValue)
        ElseIf iValue = 31 Then
        sEqLine = sEqLine & " 0"
        Else
            sEqLine = sEqLine & Chr(45) & CStr(iValue - 31)
        End If
    Else
        sEqLine = sEqLine & " E"        'E is for Error
    End If
    MSComm1.Output = sEqLine & " "
End If

End Sub

'
Private Sub ToggleEqState()

Dim iNewState As Long

If WinAMP_GetEQState <> 0 Then
    iNewState = 0
    StatMsg "Equaliser off"
Else
    iNewState = 1
    StatMsg "Equaliser on"
End If

iLastEqState = iNewState
Call WinAMP_SetEQState(iNewState)

End Sub

