VERSION 5.00
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "TABCTL32.OCX"
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmSetup 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "IR Remote Setup"
   ClientHeight    =   6480
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7215
   ControlBox      =   0   'False
   Icon            =   "frmSetup.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6480
   ScaleWidth      =   7215
   StartUpPosition =   2  'CenterScreen
   Begin VB.Timer tmrComm 
      Enabled         =   0   'False
      Left            =   1560
      Top             =   6000
   End
   Begin VB.Frame frameSetup 
      Caption         =   "Basic Settings"
      Height          =   1335
      Left            =   120
      TabIndex        =   33
      Top             =   120
      Width           =   6975
      Begin VB.CheckBox chkEnableLCD 
         Alignment       =   1  'Right Justify
         Caption         =   "Enable LCD:"
         Height          =   360
         Left            =   375
         TabIndex        =   27
         Top             =   780
         Width           =   1230
      End
      Begin VB.ComboBox cboPort 
         Height          =   315
         Left            =   5400
         Style           =   2  'Dropdown List
         TabIndex        =   29
         Top             =   810
         Width           =   1095
      End
      Begin VB.ComboBox cboTimeOut 
         BeginProperty DataFormat 
            Type            =   0
            Format          =   "0.0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   3081
            SubFormatType   =   0
         EndProperty
         Height          =   315
         Left            =   5400
         Style           =   2  'Dropdown List
         TabIndex        =   28
         Top             =   315
         Width           =   1095
      End
      Begin VB.Label lblSysAddress 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "00"
         Height          =   255
         Left            =   1650
         TabIndex        =   46
         Top             =   375
         Width           =   315
      End
      Begin VB.Label lblAddressLabel 
         Caption         =   "System Address:"
         Height          =   255
         Left            =   390
         TabIndex        =   45
         Top             =   390
         Width           =   1215
      End
      Begin VB.Label lblPort 
         Alignment       =   1  'Right Justify
         Caption         =   "Com Port:"
         Height          =   255
         Left            =   4440
         TabIndex        =   37
         Top             =   855
         Width           =   855
      End
      Begin VB.Label lblTimeOut 
         Alignment       =   1  'Right Justify
         Caption         =   "Key Timeout (secs):"
         Height          =   255
         Left            =   3720
         TabIndex        =   38
         Top             =   375
         Width           =   1575
      End
   End
   Begin MSComDlg.CommonDialog dlgOpenFile 
      Left            =   120
      Top             =   6000
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton cmdApply 
      Caption         =   "Apply"
      Height          =   375
      Left            =   6000
      TabIndex        =   32
      TabStop         =   0   'False
      Top             =   6000
      Width           =   1095
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      CausesValidation=   0   'False
      Height          =   375
      Left            =   4680
      TabIndex        =   31
      Top             =   6000
      Width           =   1095
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   3360
      TabIndex        =   30
      Top             =   6000
      Width           =   1095
   End
   Begin TabDlg.SSTab ssTabSetup 
      Height          =   4215
      Left            =   120
      TabIndex        =   12
      TabStop         =   0   'False
      Top             =   1680
      Width           =   6975
      _ExtentX        =   12303
      _ExtentY        =   7435
      _Version        =   393216
      Style           =   1
      Tabs            =   5
      TabsPerRow      =   7
      TabHeight       =   520
      WordWrap        =   0   'False
      BackColor       =   -2147483644
      ForeColor       =   -2147483641
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      TabCaption(0)   =   "Main"
      TabPicture(0)   =   "frmSetup.frx":0442
      Tab(0).ControlEnabled=   -1  'True
      Tab(0).Control(0)=   "cmdShuffle"
      Tab(0).Control(0).Enabled=   0   'False
      Tab(0).Control(1)=   "cmdRepeat"
      Tab(0).Control(1).Enabled=   0   'False
      Tab(0).Control(2)=   "cmdFadeOut"
      Tab(0).Control(2).Enabled=   0   'False
      Tab(0).Control(3)=   "cmdVolDown"
      Tab(0).Control(3).Enabled=   0   'False
      Tab(0).Control(4)=   "cmdVolUp"
      Tab(0).Control(4).Enabled=   0   'False
      Tab(0).Control(5)=   "cmdBack5Secs"
      Tab(0).Control(5).Enabled=   0   'False
      Tab(0).Control(6)=   "cmdFwd5Secs"
      Tab(0).Control(6).Enabled=   0   'False
      Tab(0).Control(7)=   "cmdPrev"
      Tab(0).Control(7).Enabled=   0   'False
      Tab(0).Control(8)=   "cmdNext"
      Tab(0).Control(8).Enabled=   0   'False
      Tab(0).Control(9)=   "cmdStop"
      Tab(0).Control(9).Enabled=   0   'False
      Tab(0).Control(10)=   "cmdPause"
      Tab(0).Control(10).Enabled=   0   'False
      Tab(0).Control(11)=   "cmdPlay"
      Tab(0).Control(11).Enabled=   0   'False
      Tab(0).ControlCount=   12
      TabCaption(1)   =   "Playlist"
      TabPicture(1)   =   "frmSetup.frx":045E
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "cmdReloadPlayList"
      Tab(1).Control(1)=   "framePlayListFile"
      Tab(1).Control(2)=   "cmdNextPlaylist"
      Tab(1).Control(3)=   "cmdPrevPlaylist"
      Tab(1).Control(4)=   "cmdLoadPlaylist"
      Tab(1).Control(5)=   "cmdPlayListShift"
      Tab(1).ControlCount=   6
      TabCaption(2)   =   "Special"
      TabPicture(2)   =   "frmSetup.frx":047A
      Tab(2).ControlEnabled=   0   'False
      Tab(2).Control(0)=   "cmdSpecialShift"
      Tab(2).Control(1)=   "cmdCloseWinAmp"
      Tab(2).Control(2)=   "cmdSetEq"
      Tab(2).Control(3)=   "cmdShutDown"
      Tab(2).Control(4)=   "cmdToggleEq"
      Tab(2).ControlCount=   5
      TabCaption(3)   =   "Winamp"
      TabPicture(3)   =   "frmSetup.frx":0496
      Tab(3).ControlEnabled=   0   'False
      Tab(3).Control(0)=   "frameWinAmpPath"
      Tab(3).Control(1)=   "frameGetWinamp"
      Tab(3).ControlCount=   2
      TabCaption(4)   =   "About"
      TabPicture(4)   =   "frmSetup.frx":04B2
      Tab(4).ControlEnabled=   0   'False
      Tab(4).Control(0)=   "imgSCLogo"
      Tab(4).Control(1)=   "lblAboutCopyright"
      Tab(4).Control(2)=   "lblSiliconChipLink"
      Tab(4).Control(3)=   "lblVersion"
      Tab(4).Control(4)=   "shapeSCLogo"
      Tab(4).ControlCount=   5
      Begin VB.CommandButton cmdReloadPlayList 
         Caption         =   "&Reload Playlist"
         Height          =   495
         Left            =   -72240
         TabIndex        =   15
         Top             =   1440
         Width           =   1455
      End
      Begin VB.Frame frameGetWinamp 
         Caption         =   "Get Winamp!"
         Height          =   1215
         Left            =   -74760
         TabIndex        =   43
         Top             =   2640
         Width           =   6495
         Begin VB.Image imgWinAmpLogo 
            Height          =   465
            Left            =   2640
            MouseIcon       =   "frmSetup.frx":04CE
            MousePointer    =   99  'Custom
            Picture         =   "frmSetup.frx":07D8
            Top             =   420
            Width           =   1320
         End
         Begin VB.Label lblWinAmpLink 
            Alignment       =   2  'Center
            Caption         =   "www.winamp.com"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   -1  'True
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            ForeColor       =   &H00FF0000&
            Height          =   255
            Left            =   480
            MouseIcon       =   "frmSetup.frx":0E8B
            MousePointer    =   99  'Custom
            TabIndex        =   44
            ToolTipText     =   "Get WINAMP music player!"
            Top             =   540
            Width           =   1695
         End
      End
      Begin VB.CommandButton cmdToggleEq 
         Caption         =   "Toggle E&qualiser"
         Height          =   495
         Left            =   -72240
         TabIndex        =   25
         Top             =   2160
         Width           =   1455
      End
      Begin VB.Frame frameWinAmpPath 
         Caption         =   "Path to Winamp"
         Height          =   1695
         Left            =   -74760
         TabIndex        =   40
         Top             =   600
         Width           =   6495
         Begin VB.CommandButton cmdChangeWinAmpPath 
            Caption         =   "&Change"
            Height          =   495
            Left            =   4800
            TabIndex        =   26
            Top             =   360
            Width           =   1455
         End
         Begin VB.TextBox txtWinAmpPath 
            Height          =   285
            Left            =   240
            Locked          =   -1  'True
            TabIndex        =   41
            TabStop         =   0   'False
            Text            =   "txtWinAmpPath"
            Top             =   1080
            Width           =   6015
         End
      End
      Begin VB.CommandButton cmdShutDown 
         Caption         =   "Sh&ut Down PC"
         Height          =   495
         Left            =   -74520
         TabIndex        =   23
         Top             =   2160
         Width           =   1455
      End
      Begin VB.CommandButton cmdSetEq 
         Caption         =   "Set &Equaliser "
         Height          =   495
         Left            =   -72240
         TabIndex        =   24
         Top             =   1440
         Width           =   1455
      End
      Begin VB.CommandButton cmdCloseWinAmp 
         Caption         =   "Close &Winamp"
         Height          =   495
         Left            =   -74520
         TabIndex        =   22
         Top             =   1440
         Width           =   1455
      End
      Begin VB.CommandButton cmdSpecialShift 
         Caption         =   "&Shift"
         Height          =   495
         Left            =   -74520
         TabIndex        =   21
         Top             =   720
         Width           =   6015
      End
      Begin VB.Frame framePlayListFile 
         Caption         =   "Playlist/Metalist File"
         Height          =   1695
         Left            =   -74760
         TabIndex        =   39
         Top             =   2280
         Width           =   6495
         Begin VB.OptionButton optPlayList 
            Caption         =   "Playlist"
            Height          =   435
            Left            =   255
            TabIndex        =   18
            Top             =   405
            Width           =   870
         End
         Begin VB.OptionButton optMetaList 
            Caption         =   "Metalist"
            Height          =   495
            Left            =   1320
            TabIndex        =   19
            Top             =   375
            Width           =   945
         End
         Begin VB.TextBox txtPlayListFile 
            Height          =   285
            Left            =   240
            Locked          =   -1  'True
            TabIndex        =   34
            TabStop         =   0   'False
            Text            =   "txtPlayListFile"
            Top             =   1080
            Width           =   6015
         End
         Begin VB.CommandButton cmdChangePlayList 
            Caption         =   "&Change"
            Height          =   495
            Left            =   4800
            TabIndex        =   20
            Top             =   360
            Width           =   1455
         End
      End
      Begin VB.CommandButton cmdNextPlaylist 
         Caption         =   "&Next Playlist"
         Height          =   495
         Left            =   -69960
         TabIndex        =   16
         Top             =   720
         Width           =   1455
      End
      Begin VB.CommandButton cmdPrevPlaylist 
         Caption         =   "&Prev Playlist"
         Height          =   495
         Left            =   -69960
         TabIndex        =   17
         ToolTipText     =   "y"
         Top             =   1440
         Width           =   1455
      End
      Begin VB.CommandButton cmdLoadPlaylist 
         Caption         =   "&Load Playlist"
         Height          =   495
         Left            =   -74520
         TabIndex        =   14
         Top             =   1440
         Width           =   1455
      End
      Begin VB.CommandButton cmdPlayListShift 
         Caption         =   "&Shift"
         Height          =   495
         Left            =   -74520
         TabIndex        =   13
         Top             =   720
         Width           =   3735
      End
      Begin VB.CommandButton cmdPlay 
         Caption         =   "&Play"
         Height          =   495
         Left            =   480
         Style           =   1  'Graphical
         TabIndex        =   0
         Top             =   720
         Width           =   1455
      End
      Begin VB.CommandButton cmdPause 
         Caption         =   "P&ause"
         Height          =   495
         Left            =   480
         TabIndex        =   1
         Top             =   1440
         Width           =   1455
      End
      Begin VB.CommandButton cmdStop 
         Caption         =   "&Stop"
         Height          =   495
         Left            =   480
         TabIndex        =   2
         Top             =   2160
         Width           =   1455
      End
      Begin VB.CommandButton cmdNext 
         Caption         =   "&Next"
         Height          =   495
         Left            =   2760
         TabIndex        =   5
         Top             =   1440
         Width           =   1455
      End
      Begin VB.CommandButton cmdPrev 
         Caption         =   "P&rev"
         Height          =   495
         Left            =   2760
         TabIndex        =   4
         Top             =   720
         Width           =   1455
      End
      Begin VB.CommandButton cmdFwd5Secs 
         Caption         =   "&Fwd 5 Secs"
         Height          =   495
         Left            =   2760
         TabIndex        =   7
         Top             =   2880
         Width           =   1455
      End
      Begin VB.CommandButton cmdBack5Secs 
         Caption         =   "&Back 5 Secs"
         Height          =   495
         Left            =   2760
         TabIndex        =   6
         Top             =   2160
         Width           =   1455
      End
      Begin VB.CommandButton cmdVolUp 
         Caption         =   "Volume &Up"
         Height          =   495
         Left            =   5040
         TabIndex        =   8
         Top             =   720
         Width           =   1455
      End
      Begin VB.CommandButton cmdVolDown 
         Caption         =   "Volume &Down"
         Height          =   495
         Left            =   5040
         TabIndex        =   9
         Top             =   1440
         Width           =   1455
      End
      Begin VB.CommandButton cmdFadeOut 
         Caption         =   "Fade &Out"
         Height          =   495
         Left            =   480
         TabIndex        =   3
         Top             =   2880
         Width           =   1455
      End
      Begin VB.CommandButton cmdRepeat 
         Caption         =   "R&epeat"
         Height          =   495
         Left            =   5040
         TabIndex        =   10
         Top             =   2160
         Width           =   1455
      End
      Begin VB.CommandButton cmdShuffle 
         Caption         =   "S&huffle"
         Height          =   495
         Left            =   5040
         TabIndex        =   11
         Top             =   2880
         Width           =   1455
      End
      Begin VB.Shape shapeSCLogo 
         BorderColor     =   &H80000004&
         BorderWidth     =   10
         Height          =   2115
         Left            =   -73815
         Top             =   1065
         Width           =   4665
      End
      Begin VB.Label lblVersion 
         Alignment       =   2  'Center
         Caption         =   "Version  _._"
         Height          =   255
         Left            =   -72240
         TabIndex        =   42
         Top             =   720
         Width           =   1455
      End
      Begin VB.Label lblSiliconChipLink 
         Alignment       =   2  'Center
         Caption         =   "www.siliconchip.com.au"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   -1  'True
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00FF0000&
         Height          =   255
         Left            =   -72510
         MouseIcon       =   "frmSetup.frx":1195
         MousePointer    =   99  'Custom
         TabIndex        =   36
         ToolTipText     =   "Silicon Chip on the Web"
         Top             =   3600
         Width           =   1935
      End
      Begin VB.Label lblAboutCopyright 
         Alignment       =   2  'Center
         Caption         =   "Copyright  2001 Silicon Chip Publications P/L"
         Height          =   255
         Left            =   -73320
         TabIndex        =   35
         Top             =   3240
         Width           =   3615
      End
      Begin VB.Image imgSCLogo 
         Height          =   2040
         Left            =   -73800
         Picture         =   "frmSetup.frx":149F
         ToolTipText     =   "Australia's Electronics Magazine"
         Top             =   1080
         Width           =   4635
      End
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   720
      Top             =   5880
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      CommPort        =   2
      DTREnable       =   0   'False
      Handshaking     =   2
      InBufferSize    =   128
      OutBufferSize   =   128
      RThreshold      =   1
      InputMode       =   1
   End
End
Attribute VB_Name = "frmSetup"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Return codes for ShellExec (see HyperLinkTo)

Private Const SE_ERR_FNF = 2&               'file not found
Private Const SE_ERR_PNF = 3&               'path not found
Private Const SE_ERR_ACCESSDENIED = 5&      'access denied
Private Const SE_ERR_OOM = 8&               'out of memory
Private Const SE_ERR_DLLNOTFOUND = 32&      'DLL not found
Private Const SE_ERR_SHARE = 26&            'sharing violation
Private Const SE_ERR_ASSOCINCOMPLETE = 27&  'invalid file association
Private Const SE_ERR_DDETIMEOUT = 28&       'DDE timeout
Private Const SE_ERR_DDEFAIL = 29&          'DDE transaction failed
Private Const SE_ERR_DDEBUSY = 30&          'DDE busy
Private Const SE_ERR_NOASSOC = 31&          'no file association
Private Const ERROR_BAD_FORMAT = 11&        'bad EXE file

' MSComm event codes

Private Const comEvSend = 1             '< SThreshold in the TX buffer
Private Const comEvReceive = 2          'RThreshold recv'd
Private Const comEvCTS = 3              'CTS state change
Private Const comEvDSR = 4              'DSR state change
Private Const comEvCD = 5               'CD state change
Private Const comEvRing = 6             'RI detected
Private Const comEvEOF = 7              'EOF (ASC 26) recv'd

Private Const comEventBreak = 1001      'break recv'd
Private Const comEventFrame = 1004      'framing error
Private Const comEventOverrun = 1006    'port overrun
Private Const comEventRxOver = 1008     'receive buffer overflow
Private Const comEventRxParity = 1009   'parity error
Private Const comEventTxFull = 1010     'transmit buffer full
Private Const comEventDCB = 1011        'unexpected error retrieving port DCB

' Other MSComm stuff...

Private Const comNone = 0               'no handshaking (default)
Private Const comXOnXOff = 1            'XON/XOFF handshaking
Private Const comRTS = 2                'RTS/CTS handshaking
Private Const comRTSXOnXOff = 3         'both RTS & XON/XOFF handshaking

Private Const comInputModeText = 0
Private Const comInputModeBinary = 1

' Local stuff

Private INBuffer() As Byte              'serial input buffer for MSComm
Private RecordBuffer(4) As Byte         'serial input record buffer
Private iRecIndex As Integer            'record index
Private fTimerSecondEvent As Boolean    'comm timer second event flag
Private fFirstTime As Boolean           'true when first executed
Private iPortNumber As Integer          'active COM port


'
Private Function InitSetup() As Boolean

'********************************************************************
'*
'* Load all settings from the registry & initialise the form controls.
'*
'* All settings are stored in:
'* [HKEY_CURRENT_USER\Software\VB and VBA Program Settings\IRRemote]
'*
'********************************************************************
On Error GoTo RegError

Dim i As Integer, sTemp As String

Move (Screen.Width - Width) / 2, (Screen.Height - Height) / 2
lblVersion.Caption = "Version " & CStr(App.Major) & "." & CStr(App.Minor)

' If the version string hasn't been initialised, then assume
' this is the first run and initialise all registry entries.

If GetSetting(App.Title, "System", "Version", "") = "" Then
    SaveSetting App.Title, "System", "Version", CStr(App.Major) & "." & CStr(App.Minor)
    SaveSetting App.Title, "System", "Address", ""
    SaveSetting App.Title, "System", "Volume", "127"
    SaveSetting App.Title, "System", "Preamp", "31"
    SaveSetting App.Title, "System", "Eq State", "0"
    SaveSetting App.Title, "Eq Sliders", "0", "31"
    SaveSetting App.Title, "Eq Sliders", "1", "31"
    SaveSetting App.Title, "Eq Sliders", "2", "31"
    SaveSetting App.Title, "Eq Sliders", "3", "31"
    SaveSetting App.Title, "Eq Sliders", "4", "31"
    SaveSetting App.Title, "Eq Sliders", "5", "31"
    SaveSetting App.Title, "Eq Sliders", "6", "31"
    SaveSetting App.Title, "Eq Sliders", "7", "31"
    SaveSetting App.Title, "Eq Sliders", "8", "31"
    SaveSetting App.Title, "Eq Sliders", "9", "31"
    SaveSetting App.Title, "General", "Enable LCD", "1"
    SaveSetting App.Title, "General", "Com Port", "2"
    SaveSetting App.Title, "General", "Key Timeout", "1.5"
    SaveSetting App.Title, "Playlist", "Path", ""
    SaveSetting App.Title, "Playlist", "Metalist Enable", "0"
    SaveSetting App.Title, "Playlist", "Metalist Index", "1"
    SaveSetting App.Title, "Winamp", "Path", ""
    SaveSetting App.Title, "Key Codes", "Play", ""
    SaveSetting App.Title, "Key Codes", "Pause", ""
    SaveSetting App.Title, "Key Codes", "Stop", ""
    SaveSetting App.Title, "Key Codes", "Fade Out", ""
    SaveSetting App.Title, "Key Codes", "Prev", ""
    SaveSetting App.Title, "Key Codes", "Next", ""
    SaveSetting App.Title, "Key Codes", "Back 5 Secs", ""
    SaveSetting App.Title, "Key Codes", "Fwd 5 Secs", ""
    SaveSetting App.Title, "Key Codes", "Volume Up", ""
    SaveSetting App.Title, "Key Codes", "Volume Down", ""
    SaveSetting App.Title, "Key Codes", "Repeat", ""
    SaveSetting App.Title, "Key Codes", "Shuffle", ""
    SaveSetting App.Title, "Key Codes", "Shift", ""
    SaveSetting App.Title, "Shift Codes", "Load Playlist", ""
    SaveSetting App.Title, "Shift Codes", "Reload Playlist", ""
    SaveSetting App.Title, "Shift Codes", "Prev Playlist", ""
    SaveSetting App.Title, "Shift Codes", "Next Playlist", ""
    SaveSetting App.Title, "Shift Codes", "Close Winamp", ""
    SaveSetting App.Title, "Shift Codes", "Shut Down PC", ""
    SaveSetting App.Title, "Shift Codes", "Toggle Equaliser", ""
    SaveSetting App.Title, "Shift Codes", "Set Equaliser", ""
    fFirstTime = True
Else
    fFirstTime = False
End If

' Build the COM port drop-down list.

For i = 1 To 4
    cboPort.AddItem "COM" & Trim(CStr(i))
Next

iPortNumber = CInt(GetSetting(App.Title, "General", "Com Port", "2"))
cboPort.ListIndex = iPortNumber - 1

' Build the key timeout drop-down list

    cboTimeOut.AddItem "0.5"
    cboTimeOut.AddItem "1.0"
    cboTimeOut.AddItem "1.5"
    cboTimeOut.AddItem "2.0"
    cboTimeOut.AddItem "2.5"
    cboTimeOut.AddItem "3.0"
    cboTimeOut.AddItem "3.5"
    cboTimeOut.AddItem "4.0"
    cboTimeOut.AddItem "4.5"
    cboTimeOut.AddItem "5.0"

' Following bit allows loading non-included timeouts from the registry

sTemp = GetSetting(App.Title, "General", "Key Timeout", "")

If sTemp <> "" Then
    For i = 0 To cboTimeOut.ListCount - 1
        If sTemp = cboTimeOut.List(i) Then Exit For
    Next
End If

If sTemp <> cboTimeOut.List(i) Then
    cboTimeOut.AddItem sTemp
End If

cboTimeOut.ListIndex = i

' Restore the various form control values

lblSysAddress.Caption = GetSetting(App.Title, "System", "Address", "")
chkEnableLCD.Value = GetSetting(App.Title, "General", "Enable LCD", "0")
txtPlayListFile.Text = GetSetting(App.Title, "Playlist", "Path", "")
txtWinAmpPath.Text = GetSetting(App.Title, "Winamp", "Path", "")

' Set the playlist/metalist option buttons

If GetSetting(App.Title, "Playlist", "Metalist Enable", "") = "1" Then
    optMetaList.Value = True
Else
    optPlayList.Value = True
    If UCase(Mid(txtPlayListFile.Text, InStrRev(txtPlayListFile.Text, ".") + 1, 3)) = "M3U" Then
        optMetaList.Enabled = False
    End If
End If

cmdApply.Enabled = False
InitSetup = True

Exit Function

' An error occurred, most likely while accessing the registry.

RegError:
MsgBox "Error initialising settings  (" & CStr(Err) & ")", vbSystemModal + vbCritical + vbOKOnly
InitSetup = False

End Function

'
Private Function VerifySetup() As Boolean

' The following stuff *must* be initialised before we continue...
' (no file checks!)

VerifySetup = False

If txtWinAmpPath.Text = "" Then Exit Function
If txtPlayListFile.Text = "" Then Exit Function
If GetSetting(App.Title, "Key Codes", "Play", "") = "" Then Exit Function
If GetSetting(App.Title, "Key Codes", "Stop", "") = "" Then Exit Function

VerifySetup = True

End Function


'
Private Function InitComm() As Boolean

'********************************************************************
'*
'* Initialise the chosen serial port.
'*
'********************************************************************
On Error Resume Next

Dim iResult As Integer

fEnableCommInput = False
If MSComm1.PortOpen = True Then
    MSComm1.PortOpen = False
End If

MSComm1.CommPort = iPortNumber
MSComm1.InputMode = comInputModeBinary
MSComm1.Settings = "9600,N,8,1"
MSComm1.Handshaking = comRTS
MSComm1.InBufferSize = 128
MSComm1.OutBufferSize = 128
MSComm1.InputLen = 0            'get entire input buffer on read
MSComm1.RThreshold = 1          'generate an event on each received char
MSComm1.SThreshold = 0          'never generate a tx buffer empty event

MSComm1.PortOpen = True         'attempt the open

If Err.Number <> 0 And Not fFirstTime Then
    MsgBox "Couldn't open Com " & CStr(iPortNumber) & " !", vbCritical + vbOKOnly + vbSystemModal, "IR Remote Setup"
    InitComm = False
    Exit Function
End If

MSComm1.DTREnable = True
MSComm1.RTSEnable = True

' Check if we have a device connected (DSR line true).

Do While Not fFirstTime And (Not MSComm1.DSRHolding Or Not MSComm1.CTSHolding)
    iResult = MsgBox("Device not detected on Com " & CStr(iPortNumber) & " !", vbCritical + vbRetryCancel + vbSystemModal, "IR Remote Setup")
    If iResult = vbCancel Then Exit Do
Loop

MSComm1.InBufferCount = 0       'flush input buffer
iRecIndex = 0                   'init receive count

InitComm = True
   
End Function

'
Private Sub cboPort_Click()

On Error Resume Next

Dim iNewPort As Integer

iNewPort = cboPort.ListIndex + 1

If iNewPort <> iPortNumber Then
    
    If MSComm1.PortOpen = True Then
        MSComm1.PortOpen = False
    End If
    
    MSComm1.CommPort = iNewPort
    MSComm1.PortOpen = True
    
    If Err.Number = 0 Then
        iPortNumber = iNewPort
        cmdApply.Enabled = True
    Else
        MsgBox "Com " & CStr(iNewPort) & " unavailable.", vbSystemModal + vbCritical + vbOKOnly, "IR Remote Setup"
        cboPort.ListIndex = iPortNumber - 1
        MSComm1.CommPort = iPortNumber
    End If

End If

Call InitComm       'reinit port

End Sub

'
Private Sub cboTimeOut_Click()

cmdApply.Enabled = True

End Sub

'
Private Sub chkEnableLCD_Click()

cmdApply.Enabled = True

End Sub

'
Private Sub cmdApply_Click()
Dim sTemp As String
On Error GoTo RegError
    
SaveSetting App.Title, "General", "Enable LCD", chkEnableLCD.Value
SaveSetting App.Title, "General", "Com Port", cboPort.ListIndex + 1
SaveSetting App.Title, "General", "Key Timeout", cboTimeOut.Text
SaveSetting App.Title, "Playlist", "Path", txtPlayListFile.Text
If optMetaList.Value Then
    SaveSetting App.Title, "Playlist", "Metalist Enable", "1"
Else
    SaveSetting App.Title, "Playlist", "Metalist Enable", "0"
End If
SaveSetting App.Title, "Winamp", "Path", txtWinAmpPath.Text

cmdApply.Enabled = False

Exit Sub

RegError:
MsgBox "Error saving settings (" & CStr(Err) & ")", vbSystemModal + vbCritical + vbOKOnly
Resume Next

End Sub

'
Private Sub cmdBack5Secs_Click()

frmGetCode.lblFunction.Caption = "Back 5 Secs"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdCancel_Click()

' Change caption so that we're not detected when frm.Control loads...

Me.Caption = "IR Remote Setup Cancelled"

If MSComm1.PortOpen = True Then
    MSComm1.PortOpen = False
End If

Unload frmGetCode
Set frmGetCode = Nothing
Me.WindowState = vbMinimized
Me.Visible = False

' Load the main form if the (minimum) basic parameters have been entered,
' otherwise just terminate.

If VerifySetup Then frmControl.Show
Unload Me
Set frmSetup = Nothing

End Sub

'
Private Sub cmdChangePlaylist_Click()

On Error Resume Next

Dim sPath As String

dlgOpenFile.Flags = cdlOFNExplorer Or cdlOFNHideReadOnly Or cdlOFNFileMustExist
dlgOpenFile.CancelError = True


sPath = Left(txtPlayListFile.Text, InStrRev(txtPlayListFile.Text, "\"))
If Dir(sPath) <> "" And Err.Number = 0 Then
    dlgOpenFile.InitDir = sPath
Else
    dlgOpenFile.InitDir = "C:\"
End If
Err.Clear
dlgOpenFile.DialogTitle = "Open Playlist/MetaList File"

If optMetaList.Value = True Then
    dlgOpenFile.Filter = "Metalist Files (*.txt)|*.txt|Playlist Files (*.m3u)|*.m3u|All Files (*.*)|*.*"
Else
    dlgOpenFile.Filter = "Playlist Files (*.m3u)|*.m3u|Metalist Files (*.txt)|*.txt|All Files (*.*)|*.*"
End If

dlgOpenFile.FileName = ""
dlgOpenFile.ShowOpen
    
If Err.Number <> cdlCancel Then
    txtPlayListFile.Text = dlgOpenFile.FileName
    If UCase(Mid(txtPlayListFile.Text, InStrRev(txtPlayListFile.Text, ".") + 1, 3)) = "M3U" Then
        optPlayList.Value = True
        optMetaList.Enabled = False
    Else
        optMetaList.Enabled = True
        optMetaList.Value = True
    End If
    cmdApply.Enabled = True
End If

End Sub

'
Private Sub cmdChangeWinAmpPath_Click()

On Error Resume Next

dlgOpenFile.Flags = cdlOFNExplorer Or cdlOFNHideReadOnly Or cdlOFNFileMustExist
dlgOpenFile.CancelError = True

If txtWinAmpPath.Text <> "" Then
    dlgOpenFile.InitDir = Left(txtWinAmpPath.Text, InStrRev(txtWinAmpPath.Text, "\"))
Else
    dlgOpenFile.InitDir = "C:\Program Files\Winamp\"
End If

dlgOpenFile.DialogTitle = "Find Winamp Executable"
dlgOpenFile.Filter = "Application Files (*.exe)|*.exe"
dlgOpenFile.FileName = ""
dlgOpenFile.ShowOpen
    
If Err.Number = cdlCancel Then Exit Sub

txtWinAmpPath.Text = dlgOpenFile.FileName
cmdApply.Enabled = True

End Sub

'
Private Sub cmdCloseWinAmp_Click()

frmGetCode.lblFunction.Caption = "Close Winamp"
frmGetCode.lblCode.Tag = "2"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdFadeOut_Click()

frmGetCode.lblFunction.Caption = "Fade Out"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdFwd5Secs_Click()

frmGetCode.lblFunction.Caption = "Fwd 5 Secs"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdLoadPlaylist_Click()

frmGetCode.lblFunction.Caption = "Load Playlist"
frmGetCode.lblCode.Tag = "1"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdNext_Click()

frmGetCode.lblFunction.Caption = "Next"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdNextPlaylist_Click()

frmGetCode.lblFunction.Caption = "Next Playlist"
frmGetCode.lblCode.Tag = "1"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdOK_Click()

On Error GoTo 0

Dim sMsg As String

Call cmdApply_Click

If Not VerifySetup Then
    sMsg = "One or more of the following items "
    sMsg = sMsg & "have not been configured: " & vbCrLf & vbCrLf
    sMsg = sMsg & " - Playlist/Metalist path" & vbCrLf
    sMsg = sMsg & " - Winamp path" & vbCrLf
    sMsg = sMsg & " - Play & Stop keys"
    MsgBox sMsg, vbCritical + vbOKOnly, "Setup Incomplete"
Else

' Change caption so that we're not detected when frm.Control loads...

    Me.Caption = "IR Remote Setup Complete"

    If MSComm1.PortOpen = True Then
        MSComm1.PortOpen = False        'prevent MSComm overlap
    End If
    
    Unload frmGetCode
    Set frmGetCode = Nothing
    Me.WindowState = vbMinimized
    Me.Visible = False                  'hide me
    frmControl.Show
    Unload Me
End If

End Sub

'
Private Sub cmdPause_Click()

frmGetCode.lblFunction.Caption = "Pause"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdPlay_Click()

frmGetCode.lblFunction.Caption = "Play"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdPlayListShift_Click()

frmGetCode.lblFunction.Caption = "Shift"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdPrev_Click()

frmGetCode.lblFunction.Caption = "Prev"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdPrevPlaylist_Click()

frmGetCode.lblFunction.Caption = "Prev Playlist"
frmGetCode.lblCode.Tag = "1"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdReloadPlayList_Click()

frmGetCode.lblFunction.Caption = "Reload Playlist"
frmGetCode.lblCode.Tag = "1"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdRepeat_Click()

frmGetCode.lblFunction.Caption = "Repeat"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdSetEq_Click()

frmGetCode.lblFunction.Caption = "Set Equaliser"
frmGetCode.lblCode.Tag = "2"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdShuffle_Click()

frmGetCode.lblFunction.Caption = "Shuffle"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdShutDown_Click()

frmGetCode.lblFunction.Caption = "Shut Down PC"
frmGetCode.lblCode.Tag = "2"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdSpecialShift_Click()

frmGetCode.lblFunction.Caption = "Shift"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdStop_Click()

frmGetCode.lblFunction.Caption = "Stop"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdToggleEq_Click()

frmGetCode.lblFunction.Caption = "Toggle Equaliser"
frmGetCode.lblCode.Tag = "2"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdVolDown_Click()

frmGetCode.lblFunction.Caption = "Volume Down"
frmGetCode.Show vbModal

End Sub

'
Private Sub cmdVolUp_Click()

frmGetCode.lblFunction.Caption = "Volume Up"
frmGetCode.Show vbModal

End Sub

'
Private Sub Form_Load()

ssTabSetup.Tab = 0          'always display first tab

Call InitSetup              'init/load registry settings & form controls
Call InitComm               'init the COM port
fFirstTime = False          'allow COM port error messages now

End Sub

'
Private Sub imgWinAmpLogo_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)

Dim iResult As Long

If Button = vbLeftButton Then
    iResult = HyperLinkTo("http://www.winamp.com")
End If

End Sub

'
Private Sub lblSiliconChipLink_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)

Dim iResult As Long, sMsg As String

If Button = vbLeftButton Then
    iResult = HyperLinkTo("http://www.siliconchip.com.au")

' Here are all the possible returns, but we don't actually use them :)
'
'    If iResult <= 32 Then
'        Select Case iResult
'        Case SE_ERR_FNF
'            sMsg = "File not found"
'        Case SE_ERR_PNF
'            sMsg = "Path not found"
'        Case SE_ERR_ACCESSDENIED
'            sMsg = "Access denied"
'        Case SE_ERR_OOM
'            sMsg = "Out of memory"
'        Case SE_ERR_DLLNOTFOUND
'            sMsg = "DLL not found"
'        Case SE_ERR_SHARE
'            sMsg = "A sharing violation occurred"
'        Case SE_ERR_ASSOCINCOMPLETE
'            sMsg = "Incomplete or invalid file association"
'        Case SE_ERR_DDETIMEOUT
'            sMsg = "DDE Time out"
'        Case SE_ERR_DDEFAIL
'            sMsg = "DDE transaction failed"
'        Case SE_ERR_DDEBUSY
'            sMsg = "DDE busy"
'        Case SE_ERR_NOASSOC
'            sMsg = "No association for file extension"
'        Case ERROR_BAD_FORMAT
'            sMsg = "Invalid EXE file or error in EXE image"
'        Case Else
'            sMsg = "Unknown error"
'        End Select
'        MsgBox sMsg
'    End If

End If

End Sub

'
Private Sub lblWinAmpLink_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)

Dim iResult As Long

If Button = vbLeftButton Then
    iResult = HyperLinkTo("http://www.winamp.com")
End If

End Sub

'
Private Sub MSComm1_OnComm()

'********************************************************************
'*
'* Serial comms event handler.
'*
'* Receives a short (2-byte) data record from the IR receiver.
'*
'* Data is transmitted from the IR receiver using a simple binary
'* record, as follows:
'*
'* Byte 1 : Start record (FE)
'* Byte 2 : System byte
'* Byte 3 : Command Byte
'* Byte 4 : Checksum of bytes 2 & 3
'*
'********************************************************************
On Error GoTo MSCommError

Dim i As Integer, z As Integer, iChecksum As Integer
Dim sMsg As String

tmrComm.Enabled = False             'kill possible running timer

If fEnableCommInput Then
    Select Case MSComm1.CommEvent
    Case comEvReceive
        z = MSComm1.InBufferCount
        INBuffer = MSComm1.Input

        For i = 1 To z
            If iRecIndex > 0 Or INBuffer(i - 1) = &HFE Then
                RecordBuffer(iRecIndex) = INBuffer(i - 1)
                iRecIndex = iRecIndex + 1
            End If
        Next i
    
        If iRecIndex = 4 Then
            iRecIndex = 0
            iChecksum = 0
            
            For i = 1 To 3
                iChecksum = (iChecksum + (RecordBuffer(i))) And 255
            Next i
                
            If iChecksum = 0 Then
                frmGetCode.shapeRx.FillColor = QBColor(12)  'change indicator colour to red
                frmGetCode.tmrGetCode.Enabled = True        '...timer will change it back
                frmGetCode.lblAddress.Caption = CStr(RecordBuffer(1)) 'pass address
                frmGetCode.lblCode.Caption = CStr((RecordBuffer(2) And 127)) 'pass/display function code
                frmGetCode.cmdDisable.Enabled = True
            End If
            
        ElseIf iRecIndex > 0 Then

'Set a 10ms timeout. Minimum timer resolution is actually 1/18 sec,
'and timer event has to be entered twice, so actual timeout will
'be between approx 55 and 110ms.

            fTimerSecondEvent = False
            tmrComm.Interval = 2500
            tmrComm.Enabled = True
        End If
            
' All other comm event handling follows. For these simple receive
' routines, no action is taken on error.

    Case comEvCTS, comEvDSR
    Case comEventFrame, comEventOverrun, comEventRxParity
'        MsgBox ("Com async error! " & CStr(MSComm1.CommEvent))
    Case comEventBreak, comEventRxOver, comEventDCB
'        MsgBox ("Unexpected Com error! " & CStr(MSComm1.CommEvent))
    End Select
Else
    
' If idle mode, simply flush buffer & exit
    
    MSComm1.InBufferCount = 0
End If
Exit Sub

MSCommError:
sMsg = "Unexpected error in MSComm  (" & CStr(Err) & ")" & vbCrLf
sMsg = sMsg & "CommEvent = " & CStr(MSComm1.CommEvent) & vbCrLf
MsgBox sMsg, vbSystemModal + vbCritical + vbOKOnly
Resume Next

End Sub

'
Private Sub optMetaList_Click()

cmdApply.Enabled = True

End Sub

'
Private Sub optPlayList_Click()

cmdApply.Enabled = True

End Sub

'
Private Sub tmrComm_Timer()

'********************************************************************
'*
'* Serial port record receive timer (see the On_Comm event).
'*
'********************************************************************

If fTimerSecondEvent Then

' Flush the input buffer and reset the receive count.

    fTimerSecondEvent = False
    tmrComm.Enabled = False
    iRecIndex = 0
    MSComm1.InBufferCount = 0
Else
    fTimerSecondEvent = True    'next time, for sure!
End If

End Sub

