
; Lamp dimmer using phase control
; also includes remote control operation
; lamp dimmer uses touch control for various lamp brightness
; operation. On short touch will either turn on or turn off the lamp.
; prolonged touch will dim the lamp either up or down.
; When switching on, the lamp will return to last dimming broghtness.
; a quick touch of the plate within 2.5 seconds of switching on the lamp will 
; bring the light to full brightness. After the 2.5-seconds the normal on and 
; off operation will return.
; remote control uses the channel up and down and volume up and down controls plus mute.
; ch up is fast brightness up, ch down is fast dimming down. The volume up and down are slow brightness
; up and down. Mute is off.
; options are for four different remote control codes for TV1, VCR2 and Sat1 & Sat2.
; also option for touch plate dimming extension or a simple momentary switch extension.		  

; Philips RC5 code for infra red transmission (also used with Marantz, Grundig and Loewe)
; Comprises 2 start bits, 1 toggle bit (alternates high or low on successive same key press)
; 5-system address bits and 6 command bits. Data stream starts with the start bits. 
; biphase encoding with high to a low transition = a low and low to high = high
; each bit transmitted at 1.778ms rate. Whole code at 24.889ms and next code starts 113.778ms
; later. Can decode by detecting first start bit then waiting 1.778ms + 444.5us for next start
; bit. Successive bits are 1.778ms apart. Total of 14 bits. 

;Address
;0 TV1
;1 TV2
;2 Videotext
;3 Expansion for TV1 and TV2
;4 Laser vision player
;5 VCR1
;6 VCR2
;7 Reserved
;8 SAT1
;9 Expansion for VCR1 and VCR2
;10 SAT2
;11 Reserved
;12 CD Video
;13 Reserved
;14 CD Photo
;15 Reserved
;16 Audio preamplifier1
;17 Tuner
;18 Analogue cassetter recorder
;19 Audio Preamp2
;20 CD
;21 Audio rack
;22 Audio Satellite
;23 DCC Recorder
;24 Reserved
;25 Reserved
;26 Writable CD
;27-31 Reserved

;Keycode commands 
;0 0
;1 1
;2 2
;3 3
;4 4
;5 5
;6 6
;7 7
;8 8
;9 9
;16 Volume +
;17 Volume -
;18 Brightness +
;19 Brightness -
;20 Colour saturation +
;21 Colour Saturation -
;22 Bass +
;23 Bass -
;24 Treble +
;25 Treble -
;26 Balance right
;27 balance left
;63 System select
;71 Dim local display

; Special commands
;10 1/2/3 digits /10
;11 Freq/prog/ch11
;12 standby
;13 Mute
;14 Personal preference
;15 Display
;28 Contrast +
;29 Contrast -
;30 Search +
;31 Tint/hue
;32 CH/prog +
;33 CH/prog -
;34 Alternate CH

;37 stereo/mono
;39 Tint/hue +
;48 Pause
;50 rewind
;52 wind
;53 play
;54 stop
;55 record


; CPU configuration
; 	
	list P=16F84
	#include "p16f84.inc"
	__config _HS_OSC & _WDT_OFF & _PWRTE_ON

; Define variables at memory locations

; RAM

W_TMP		equ	H'0C'	; temporary store for w in interrupt
STATUS_TMP	equ	H'0D'	; temporary store of status in interrupt  
BRIGHT_C	equ	H'0E'	; current lamp brightness 
BRIGHT_S	equ	H'0F'	; brightness setting for lookup table 
BRIGHT_V	equ	H'10'	; stored brightness

POSITION	equ	H'13'	; position counter within half sine wave starting from zero crossing
RATE		equ	H'14'	; rate execution counter
FLAG		equ	H'15'	; bit 0, off flag, 1 on, 2 up, 3 down 
COUNTZ_Z	equ	H'16'	; counter from zero crossing to zero crossing
COUNTZ		equ	H'17'	; counter storage of z-z counter
TOUCH_C		equ	H'18'	; touch count
REMOTE_M	equ	H'19'	; remote control input ms byte
REMOTE_L	equ	H'1A'	; remote control input LS byte
REM_FLG		equ	H'1B'	; flag to indicate current remote control sequencing 
REM_CNT		equ	H'1C'	; interrupt count for polling remote control signal
REM_COD		equ	H'1D'	; remote control bit counter
FLAG_ON		equ	H'1E'	; 0, off flag. 1,on/off. 2,up/dn dimming mode.
				; 3, soft start. 4, stop dimming 
DIVIDE		equ	H'1F'	; divider of timer counter
TIMER		equ	H'20'	; temp timer value
FLAG_Z		equ	H'21'	; zero crossing flag
PULSE_V		equ	H'22'	; pulse value 
PULSE_O		equ	H'23'	; operational pulse value
DIVID_O		equ	H'24'	; operational divide value
ON_OFFT		equ	H'25'	; on/off timer
SOFT_ST		equ	H'26'	; soft start rate counter
TOGGLE		equ	H'27'	; remote control toggle flag
R_FLAG		equ	H'28'   ; remote control flag
R_TMR		equ	H'29'	; remote control timer
RD_RMT		equ	H'2A'   ; remote input store
GLITCH		equ	H'2B'	; flag that determines a glitch for start of remote code
DIMRTE		equ	H'2C'	; dimming rate
FLG_HL		equ	H'2D'	; high or low remote control sign

; define reset and interrupt vector start addresses

	org	0	  	; start at address 0000h
	goto	MAIN		; normal service routines from Reset vector
	org     4		; interrupt vector 0004h, start interrupt routine here
	goto	INTRUPT

; lookup table for lamp brightness versus phase

BRIGH_T addwf	PCL,f	; add value to program counter
	retlw	D'48'	; 0
	retlw	D'48'	; 1 
	retlw	D'48'	; 2 
	retlw	D'48'	; 3 
	retlw	D'48'	; 4 
	retlw	D'48'	; 5 
	retlw	D'48'	; 6 
	retlw	D'48'	; 7 
	retlw	D'48'	; 8  
	retlw	D'48'	; 9 
	retlw	D'48'	; 10 
 	retlw	D'48'	; 11 
	retlw	D'48'	; 12 
 	retlw	D'48'	; 13 
	retlw	D'48'	; 14 
 	retlw	D'48'	; 15 
	retlw	D'48'	; 16 
 	retlw	D'48'	; 17 
	retlw	D'48'	; 18 
 	retlw	D'48'	; 19 
	retlw	D'48'	; 20 
 	retlw	D'48'	; 21 
	retlw	D'48'	; 22 
 	retlw	D'48'	; 23 
	retlw	D'48'	; 24 
	retlw	D'48'	; 25 
	retlw	D'48'	; 26 
	retlw	D'48'	; 27 
	retlw	D'48'	; 28 
	retlw	D'48'	; 29 
	retlw	D'48'	; 30 
	retlw	D'48'	; 31 
	retlw	D'48'	; 32 
	retlw	D'48'	; 33
	retlw	D'48'	; 34 
	retlw	D'48'	; 35 
	retlw	D'48'	; 36 
	retlw	D'48'	; 37 
	retlw	D'48'	; 38 
	retlw	D'48'	; 39
	retlw	D'48'	; 40 
	retlw	D'48'	; 41 
	retlw	D'48'	; 42 
	retlw	D'48'	; 43 
	retlw	D'48'	; 44 
	retlw	D'48'	; 45 
	retlw	D'48'	; 46 
	retlw	D'48'	; 47 
	retlw	D'48'	; 48 
	retlw	D'52'	; 49 
	retlw	D'56'	; 50 
	retlw	D'60'	; 51 
	retlw	D'64'	; 52 
	retlw	D'68'	; 53 
	retlw	D'71'	; 54 
	retlw	D'74'	; 55 	
	retlw	D'77'	; 56 
	retlw	D'80'	; 57 
	retlw	D'83'	; 58 
	retlw	D'86'	; 59 
	retlw	D'89'	; 60 
	retlw	D'92'	; 61 
	retlw	D'95'	; 62
	retlw	D'98'	; 63 
	retlw	D'100'	; 64 
	retlw	D'102'	; 65 	
	retlw	D'104'	; 66 
	retlw	D'106'	; 67 
	retlw	D'108'	; 68 
	retlw	D'110'	; 69 
	retlw	D'112'	; 70
	retlw	D'114'	; 71 
	retlw	D'116'	; 72 
	retlw	D'118'	; 73 
	retlw	D'120'	; 74 
	retlw	D'122'	; 75 
	retlw	D'124'	; 76 
	retlw	D'126'	; 77 	
	retlw	D'128'	; 78 
	retlw	D'130'	; 79 
	retlw	D'132'	; 80 
	retlw	D'134'	; 81 
	retlw	D'136'	; 82 
	retlw	D'138'	; 83 
	retlw	D'140'	; 84 
	retlw	D'142'	; 85 
	retlw	D'144'	; 86 
	retlw	D'146'	; 87 
	retlw	D'148'	; 88 
	retlw	D'150'	; 89 	
	retlw	D'151'	; 90 
	retlw	D'152'	; 91 
	retlw	D'153'	; 92 
	retlw	D'154'	; 93 
	retlw	D'155'	; 94
	retlw	D'156'	; 95 
	retlw	D'157'	; 96 
	retlw	D'158'	; 97 
	retlw	D'159'	; 98 
	retlw	D'160'	; 99
	retlw	D'161'	; 100 
	retlw	D'162'	; 101 	
	retlw	D'163'	; 102 
	retlw	D'164'	; 103 
	retlw	D'165'	; 104 
	retlw	D'166'	; 105 
	retlw	D'167'	; 106
	retlw	D'168'	; 107 
	retlw	D'169'	; 108 
	retlw	D'170'	; 109 
	retlw	D'171'	; 110 
	retlw	D'172'	; 111 
	retlw	D'173'	; 112 
	retlw	D'174'	; 113 	
	retlw	D'175'	; 114 
	retlw	D'176'	; 115 
	retlw	D'177'	; 116 
	retlw	D'178'	; 117 
	retlw	D'179'	; 118
	retlw	D'180'	; 119 
	retlw	D'181'	; 120 
	retlw	D'182'	; 121 
	retlw	D'183'	; 122 
	retlw	D'184'	; 123 
	retlw	D'185'	; 124 
	retlw	D'186'	; 125 	
	retlw	D'187'	; 126 
	retlw	D'188'	; 127 
	retlw	D'189'	; 128 
	retlw	D'190'	; 129 
	retlw	D'191'	; 130
     	retlw	D'192'	; 131 
	retlw	D'193'	; 132 
	retlw	D'194'	; 133 	
	retlw	D'195'	; 134 
	retlw	D'196'	; 135 
	retlw	D'197'	; 136 
	retlw	D'198'	; 137 
	retlw	D'199'	; 138
	retlw	D'200'	; 139 
	retlw	D'201'	; 140 
	retlw	D'202'	; 141 
	retlw	D'203'	; 142 
	retlw	D'204'	; 143 
	retlw	D'205'	; 144 
	retlw	D'206'	; 145 	
	retlw	D'207'	; 146 
	retlw	D'208'	; 147 
	retlw	D'209'	; 148 
	retlw	D'210'	; 149 
	retlw	D'211'	; 150
	retlw	D'211'	; 151

; start interrupt by saving w and status registers before altered by interrupt routine

INTRUPT movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bcf	STATUS,RP0	; select memory bank 0

; check which interrupt	
	
	btfsc	INTCON,INTF	; INT interrupt flag set then goto zero
	goto	ZERO		; zero crossing signal update
	btfsc	INTCON,T0IF	; TMRO overflow interrupt flag then goto counter
	goto	COUNTER		; TMRO overflow so increase counter 
	goto	RECLAIM		; end of interrupt reclaim w and status

; POSITION counter timer 250 counts are 10ms (count 48 is 35 degrees for max brightness and count 
; 211 is 152 degrees or min brightness start point. 

COUNTER	incf	POSITION,f	; position in half wave starting from zero crossing point

; adjust interrupt rate with counter

	movf	DIVIDE,w	; divide value
	movwf	DIVID_O		; operating divide value
	movf	PULSE_O,f	; pulse value number of interrupt speedups
	btfsc	STATUS,z	; if zero leave
	goto	NO_CHNG
	incf	DIVID_O,f
	decf	PULSE_O,f	; freq is 10MHz/4/2/50. =25kHz or 40us period
NO_CHNG	movf	TMR0,w		; each change of DIVID_O speeds interrupt time to 39.2us	
	addwf	DIVID_O,w	; add to timer register and takes 2 cycles to start counting
	movwf	TMR0	
	bcf	INTCON,T0IF	; clear TMRO interrupt flag

; increase zero crossing counter
	
	incf	COUNTZ_Z,f	; increase the zero crossing to zero crossing counter
	btfsc	STATUS,z
	bsf	FLAG_Z,0	; if zero set flag
	btfsc	FLAG_Z,0	; is flag set
	goto	POSN		; second half of sine wave
	movf	COUNTZ_Z,w
	xorwf	COUNTZ,w	; check if same (countZ = 250)
	btfsc	STATUS,z	; if zero then half way through zero-zero crossing point
	goto	ZERO_H		; go to half way between zero crossings
	

; check if POSITION counter = BRIGHT_C counter then trigger @ 40us gate drive each
	
POSN	movf	PORTB,w		; looking at RB3 
	movwf	RD_RMT		; remote input store
	movf	POSITION,w	; look at position in mains waveform
	xorwf	BRIGHT_C,w	; current brightness. If zero then drive Triac gate
	btfsc	STATUS,z	; if zero bit high drive gate (is off, on at next timer interrupt)
	goto	FLG_TST
	incf	BRIGHT_C,w	; drive gate for second time so total of 80us
	xorwf	POSITION,w
	btfss	STATUS,z
	goto	REMOTE
FLG_TST	btfsc	FLAG,0		; is the off flag set
	goto	REMOTE		; do not drive gate if off
	movlw	B'00000110'	; gate drive low (on)
	goto	D_PORTB
	

; check if RB3 has gone low for start of remote control sequence

REMOTE	movlw	B'11110000'	; gate drive high (off)
	iorwf	PORTB,f
	goto	P_BSET
D_PORTB	andwf	PORTB,f		; gate drive 
P_BSET	bcf	PORTB,1		; tracer for remote decode

	btfsc	REM_FLG,0	; has remote control sequence started		
	goto	REM_SEQ
	btfss	RD_RMT,3	; was RB3 low
	goto	CK_TMR
	bcf	GLITCH,0	; clear glitch bit as high RB3 
	goto	RECLAIM
CK_TMR	movf	R_TMR,w		; remote control timer
	btfss	STATUS,z
	goto	RECLAIM		; wait till timer is 0

	btfsc	GLITCH,0	; if high then was high at last interrupt
	goto	NO_GLC
	bsf	GLITCH,0	; set if was clear
	goto	RECLAIM		; bypass as may be a glitch
NO_GLC	bcf	GLITCH,0	; clear as was set
	bsf	REM_FLG,0	; set beginning of remote control flag
	
	movlw	D'55'		; initial time period to wait till next start bit
	movwf	REM_CNT
	movlw	D'13'		; shift register counter
	movwf	REM_COD
	bsf	REMOTE_L,0	; set first bit in remote control sequence
	bsf	PORTB,2		; decode out
	bsf	PORTB,1		; tracer for decode (reads level at this point) 
	bsf	PORTA,2		; start/stop trace	
	clrf	FLG_HL		; * clear bit 1 in high low flag
	bsf	REM_FLG,7	; * start bit flag set
	goto 	RECLAIM

REM_SEQ	btfsc	REM_FLG,1	; has it finished
	goto	RECLAIM
	decfsz	REM_CNT,f	; decrease interrupt counter for timing
	goto	CKEDGE		; * check change in level
	bcf	REM_FLG,7	; * clear start bit flag
	movlw	D'45'		; 45 x 40us = 1.8ms or period between valid bits
	movwf	REM_CNT
	rlf	REMOTE_L,f	; least sig byte in remote control code sequence
	rlf	REMOTE_M,f	; most sig byte 
	movf	RD_RMT		; * check bit 3 portB via RD_RMT
	andlw	B'00001000'	; * mask out bits except bit 3
	movwf	FLG_HL		; * place in flag
	btfsc	RD_RMT,3	; check if high or low
	goto	HI		; high so clear
	bsf	REMOTE_L,0	; if low set this bit
	bsf	PORTB,2		; if high clear this bit
	goto	BY_HI		; bypass high
HI	bcf	REMOTE_L,0	; clear 0 bit
	bcf	PORTB,2 	; acknowledge
BY_HI	bsf	PORTB,1		; tracer  
	decfsz	REM_COD,f	; decrease shift register count
	goto	RECLAIM
	bsf	REM_FLG,1	; set end of remote control decoding flag
	movlw	D'09'		; timer (9 gives 90ms and plus first 24.889ms =114.88ms)
				; so await for next code which occurs every 113.778ms
	movwf	R_TMR		; remote control timer
	goto	RECLAIM

; align change in level (edge detect) with REM_CNT counter
 
CKEDGE	btfsc	REM_FLG,7	; start bit flag bypass edge detect as AGC level setting
	goto	RECLAIM
	movlw	B'00001000'	; select bit 3 for PORTB,3
	andwf	RD_RMT,w	; bit 3
	xorwf	FLG_HL,w	; compare PORTA,1 with FLAG (previous level)		
	btfsc	STATUS,z	; Z=1 if zero then no change
	goto	RECLAIM		; no change 
	movlw	B'00001000'	; select bit 3 for PORTB,3
	andwf	RD_RMT,w	; bit 3 select 
	movwf	FLG_HL		; reload new level
	movlw	D'6'		; count of 6 for REM_CNT
	subwf	REM_CNT,w	; is REM_CNT larger or equal to 6
	btfss	STATUS,c
	goto	RECLAIM		; smaller than 6 
	movf	REM_CNT,w
	sublw	D'16'		; check if 16 or less
	btfss	STATUS,c
	goto	RECLAIM		; larger than 16 
	movlw	D'11'
	movwf	REM_CNT		; set REM_CNT to 11 to align with change in level
	goto	RECLAIM

; zero crossing 

ZERO	movf	TMR0,w		; timer value
	movwf	TIMER		; temp storage for TMR0	

; reset timer counter
; freq is 10MHz/4/2/50. [50 =(256(-208-2)] =25kHz or 40us period 
	
	movlw	D'208'		; 
	movwf	TMR0		; set timer
	nop			; make sure timer reset before clearing flag 
	nop
	nop
	bcf	INTCON,INTF	; clear INT flag
	bcf	INTCON,T0IF	; clear TMRO interrupt flag

; check lock
	
	movf	COUNTZ_Z,w	; zero - zero crossing count of 500=244 as (256+244=500)
	sublw	D'150'		; overrange into next count
	btfsc	STATUS,c	
	goto	SLOWER
	movf	COUNTZ_Z,w
	sublw	D'243'
	btfss	STATUS,z	; if zero check timer status
	goto	FST_SLO

; check timer value to within acceptable range (ie. in middle of count between 205 and 255)

	movf	TIMER,w		; look at timer
	sublw	D'225'		; is it larger than 225
	btfsc	STATUS,c	; if c is 0 then >225 if 1 then <225 so speed up
	goto	FASTER
	movf	TIMER,w
	sublw	D'235'
	btfsc	STATUS,c	; if c is 1 then <= 235
	goto	RESET		; in lock so leave values as is
	goto	SLOWER
FST_SLO	btfss	STATUS,c	; if 0 then count is larger so slow down
	goto	SLOWER
FASTER	incf	PULSE_V,w
	sublw	D'250'
	btfsc	STATUS,c	; if c is 0 then do not increase
	goto	INC_PLS
	clrf	PULSE_V
	incf	DIVIDE,f	; increase divide as PULSE_V has exhausted its range
	goto	RESET		
INC_PLS	incf	PULSE_V,f
	goto 	RESET
SLOWER	movf	PULSE_V,w
	btfss	STATUS,z
	goto	DEC_PLS
	decf	DIVIDE,f	; zero PULSE_V so reduce Divide value 
	movlw	D'250'
	movwf	PULSE_V
	goto	RESET
DEC_PLS	decf	PULSE_V,f
	

; zero crossing reset counter (also compensates for shift due to input filtering)

RESET	bcf	FLAG_Z,0	; clear zero crossing sine flag (plus or minus half sine wave)
	clrf	COUNTZ_Z	; counter from zero crossing to zero crossing

ZERO_H	movf	PULSE_V,w
	movwf	PULSE_O		; transfer value to operating counter
	movlw	D'30'		; offset compensates for filter phase change 
	movwf	POSITION	; reset position counter any offset is to counteract shift in zero
 				; voltage crossing detector due to filtering
	movf	BRIGHT_S,w	; update brightness
	call	BRIGH_T		; lookup table	
	movwf	BRIGHT_C	; update every zero crossing only (10ms to prevent erratic 
; brightness during dimming up) 
	movf	R_TMR,w		; look at remote control timer
	btfss	STATUS,z	; if zero do not decrease
	decf	R_TMR,f
	goto	REMOTE


; end of interrupt reclaim w and status 

RECLAIM	swapf	STATUS_TMP,w	; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie			; return from interrupt

;********************************************************************************************** 
  
; RESET		
; Set ports A & B

MAIN	clrf	GLITCH		; glitch flag for start of remote
	clrf	R_FLAG		; remote control flags
	clrf	R_TMR		; remote timer
	clrf	ON_OFFT		; on/off timer
	clrf	PULSE_V		; pulse value
	clrf	PULSE_O		; operating pulse value
	clrf	REM_CNT		; remote control polling counter
	clrf	REM_FLG		; remote control flag status
	clrf	TOUCH_C		; touch counter
	clrf	DIMRTE		; dimming rate
	clrf	FLAG_ON		; on/off flag
	bsf	FLAG,0		; set off flag
	movlw	D'208'		; initial divider for timer counter
	movwf	DIVIDE		; freq is 10MHz/4/2/50. [50 =(256(-208-2)] =25kHz or 40us period 
	movlw	D'211'		; min brightness setting
	movwf	BRIGHT_C	; current brightness level
	movlw	D'49'		; max at start
	movwf	BRIGHT_V	; stored brightness
	movlw	D'150'		; min brightness
	movwf	BRIGHT_S	; brightness setting
	movlw	D'250'		; zero crossing
	movwf	COUNTZ		; counter for zero crossing - zero crossing length
	clrf	COUNTZ_Z	; clear countZ-Z zero crossing counter
	clrf	TOUCH_C		; touch time counter
	bsf	STATUS,RP0	; select memory bank 1
	movlw	B'00001001'	; (RB3,0 inputs, RB1,RB2, 4- RB7 outputs)
	movwf	TRISB		; port B data direction register
	movlw	B'10000000'	; 
	movwf	OPTION_REG	; TMRO prescaler is 2, PORTB pullups disabled
	movlw   B'00011011'	; w = 11011 binary (1's are inputs) RA2 is output 
	movwf   TRISA		; A port data direction register
	bcf	STATUS,RP0	; select memory bank 0
	movlw	B'11111111'	; 1 for RB4-RB7
	movwf	PORTB		; portB outputs high
	movlw	B'00000000'
	movwf	PORTA		; portA low
	
	
; interrupt enable 

	bsf	INTCON,T0IE	; set interrupt enable for TMR0 
	bsf	INTCON,INTE	; set interrupt enable for RB0
	bsf	INTCON,GIE	; set global interrupt enable for above


; check remote codes and switch flags

	
; check touch switch and extension input
; look at when COUNTZ_Z is at peak positive of sine wave
; count number of time is low for touch input and high for extn input
; if 3 counts (60ms) or less then nothing happens 
; if 3 counts or more check if less than 32 (640ms) counts then on/off
; if more then start dimming up/dn 	
	
SWITCH	btfsc	REM_FLG,0	; has remote code started
	goto	DEM_DEC		; remote control decoding (ignore touch inputs during remote control)
	movf	POSITION,w	; position counter
	xorlw	D'78'		; look at when around peak positive of sine wave (noting filter-
				; -- phase shift)
	btfss	STATUS,z
	goto	DEM_DEC		; remote control decoding
	movf	ON_OFFT,w	; on off timer
	btfsc	STATUS,z	; is it zero? do not decrement
	goto	ZRO_CNT 
	decf	ON_OFFT,f	; decrement
TST_FG3	btfsc	FLAG_ON,3	; is soft start set
	goto	ON_SET
	btfsc	FLAG_Z,0	; is flag bit set (positive half of sine wave) 
	goto	DEM_DEC		; remote control decoding
	btfss	PORTA,0		; touch input is it low	
	goto	TOUCHED
	btfsc	PORTA,1		; extension input is it high
	goto	TOUCHED
	goto	SW_NOT
ZRO_CNT	bcf	FLAG_ON,5	; clear on/on flag
	goto	TST_FG3

; switch not touched. If between 3 and 32 then on/off operation
	
SW_NOT	bcf	FLAG_ON,4	; stop dimming flag off
	btfsc	FLAG_ON,2	; check if up/dn dimming mode was set
	goto	TOGLE
	movf	TOUCH_C,w
	sublw	D'03'
	btfsc	STATUS,c
	goto	DM_DCCR		; clear TOUCH_C and remote control decode
	movf	TOUCH_C,w
	clrf	TOUCH_C
	sublw	D'32'
	btfss	STATUS,c
	goto	TOGLE
	btfsc	FLAG_ON,0	; is off flag on
	goto	OFF_SET
	bsf	FLAG_ON,3	; soft start dim up flag
	goto	ON_SET
TOGLE	bcf	FLAG_ON,2	; up/dn dimming mode clear
	goto	DM_DCCR

TOUCHED	incf	TOUCH_C,f	; increase touch counter
	incf	DIMRTE,f	; dimming rate
	movf	TOUCH_C,w
	sublw	D'32'		; is it less than 32 (on/off)
	btfsc	STATUS,c	; if c is 1 then less than 32
	goto	CHK_RTE 	; check dimming rate
	clrf	TOUCH_C		; touch counter
	bsf	FLAG_ON,2	; indicates up/dn mode
DIM_AGN	btfss	FLAG_ON,1
	goto	UP_SET
	goto	DN_SET		
CHK_RTE	btfsc	DIMRTE,0	; if bit 0 clear then dim
	goto	DEM_DEC
	btfss	DIMRTE,1	; if bit 1 set then dim (sets dimming rate)
	goto	DEM_DEC
	clrf	DIMRTE		; dimming rate
	btfsc	FLAG_ON,2	; is up/dn flag set (already touched)
	goto	DIM_AGN
	goto	DEM_DEC

; remote control decoding

DM_DCCR	clrf	TOUCH_C		; clear touch counter
	clrf	DIMRTE		; dimming rate
DEM_DEC	movf	R_TMR,w		; is timer at zero
	btfsc	STATUS,z	; if not zero check flags
	goto	CL_CKR		; if zero then clear flags and check remote
	movf	R_FLAG,w	; are any flags set
	btfsc	STATUS,z	; if flags set then check position
	goto	CL_CKR

	movf	POSITION,w
	xorlw	D'120'		; once per cycle
	btfss	STATUS,z	; if zero can update 
	goto	SWITCH
	
	btfsc	R_FLAG,0	; up flag
	goto	REM_UP
	btfsc	R_FLAG,1
	goto	REM_DN
		
CL_CKR	clrf	R_FLAG
	
	btfss	REM_FLG,1	; is remote control entered flag set
	goto	SWITCH
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	

; compare with address code out if invalid clear REM_FLG
; if valid check command bits and ls 2 address bits then clear REM_FLG
 
	btfsc	PORTA,3		; check porta
	goto	VCR_2		; VCR1 code also available instead (change VCR_2 to VCR_1)
				; see note on this code at VCR_2
	btfsc	PORTA,4
	goto	SAT_COD		; satellite codes

; code for television (TV1)

TV_1	xorlw	B'00110000'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,z	; if zero then matching
	goto	CLR_RMF		; clear remote flag
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'00100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_UP

	movf	REMOTE_L,w
	xorlw	B'00100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_DN 
	movf	REMOTE_L,w
	xorlw	B'00010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	UP_SET
	movf	REMOTE_L,w
	xorlw	B'00010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	DN_SET  
	movf	REMOTE_L,w
	xorlw	B'00001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	OFF_SET 
	goto	CLR_RMF

; VCR decoding VCR1. Note VCR1 code for Mute is the same as TV1 mute. 
	
VCR_1	xorlw	B'00110001'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,z	; if zero then matching
	goto	CLR_RMF		; clear remote flag
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'01100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_UP

	movf	REMOTE_L,w
	xorlw	B'01100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_DN 
	movf	REMOTE_L,w
	xorlw	B'01010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	UP_SET
	movf	REMOTE_L,w
	xorlw	B'01010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	DN_SET  
	movf	REMOTE_L,w
	xorlw	B'01001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	OFF_SET 
	goto	CLR_RMF

; VCR2 Mute transmission from 'Big Shot 3' preprogrammed remote unit has error in second start 
; bit. This is decoded assuming this error. 
; Decoding is included and can be used with this qualification. It also may 
; not operate on Mute with other remote transmitters set for VCR2. 

VCR_2	btfsc	PORTA,4
	goto	SAT2
	xorlw	B'00110001'	; compare with start bits and ms 3-bits of address
	btfsc	STATUS,z	; if zero then matching
	goto	VCR_L		; check low byte codes
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	xorlw	B'00100001'	; compare with start bits and ms 3-bits of address Note VCR2
				; has incorrect start bits on mute transmission
	btfss	STATUS,z	; if zero then matching
	goto	CLR_RMF		; clear remote flag
	goto	VCR_OFF	
VCR_L	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'10100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_UP

	movf	REMOTE_L,w
	xorlw	B'10100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_DN 
	movf	REMOTE_L,w
	xorlw	B'10010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	UP_SET
	movf	REMOTE_L,w
	xorlw	B'10010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	DN_SET
VCR_OFF	movf	REMOTE_L,w
	xorlw	B'10111111'	; bits 0-5 keycode (63), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	OFF_SET   
	goto	CLR_RMF

; satellite decoding SAT1 & SAT2
	
SAT_COD
SAT_1	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,z	; if zero then matching
	goto	CLR_RMF		; clear remote flag
	movf	REMOTE_L,w	;  least sig remote code
	xorlw	B'00100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_UP

	movf	REMOTE_L,w
	xorlw	B'00100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_DN 
	movf	REMOTE_L,w
	xorlw	B'00010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	UP_SET
	movf	REMOTE_L,w
	xorlw	B'00010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	DN_SET
	movf	REMOTE_L,w
	xorlw	B'00001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	OFF_SET   
	goto	CLR_RMF

SAT2	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,z	; if zero then matching
	goto	CLR_RMF		; clear remote flag
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'10100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_UP

	movf	REMOTE_L,w
	xorlw	B'10100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_DN 
	movf	REMOTE_L,w
	xorlw	B'10010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	UP_SET
	movf	REMOTE_L,w
	xorlw	B'10010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	DN_SET 
	movf	REMOTE_L,w
	xorlw	B'10001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	OFF_SET  


CLR_RMF	clrf	REM_FLG		; remote flag cleared
	
	bcf	PORTB,2		; decode out
	bcf	PORTB,1		; tracer out
	bcf	PORTA,2		; start stop for decoder	
	goto	SWITCH

; switch function
	
OFF_SET	clrf	R_FLAG		; remote control flags
	bcf	FLAG_ON,7
	btfss	FLAG_ON,5	; if flag set then on
	goto	OFF_C		; continue with off
	movf	ON_OFFT,w	; check if zero
	btfss	STATUS,z
	goto	ON_SET1
OFF_C	clrf	TOUCH_C
	bcf	FLAG_ON,0	; on flag off
	bcf	FLAG_ON,1	; dim down flag
	bsf	FLAG,0		; set off flag
	movlw	D'150'
	movwf	BRIGHT_S	
	goto	OUT_FLG

ON_SET1	bcf	FLAG_ON,1	; up dimming
	bsf	FLAG_ON,7
	movlw	D'49'		; max brightness
	movwf	BRIGHT_V	; set at max
	clrf	ON_OFFT
	goto	BY_TM
ON_SET	clrf	R_FLAG		; remote control flags
	bcf	FLAG_ON,1
	btfsc	FLAG_ON,5	; is on/on timer still running
	goto	BY_TM
	movlw	D'250'		; timer for on/on - off period (250 = 2.5s)
	movwf	ON_OFFT		; on off timer set
	bsf	FLAG_ON,5	
BY_TM	clrf	TOUCH_C
	bsf	FLAG_ON,0	; on flag set
	clrf	FLAG
	bsf	FLAG_ON,3	; soft start flag
	movlw	D'06'		; soft start rate (larger is faster)
	movwf	SOFT_ST
	decf	BRIGHT_S,w	; increase brightness setting 
SOFT_T	sublw	D'48'		; min value
	btfsc	STATUS,c	; if c is 1 then BRIGHT_S at min value
	goto	CLR_DEC		; 
	decf	BRIGHT_S,w	;
	subwf	BRIGHT_V,w
	btfsc	STATUS,c	; compare with brightness setting
	goto	CLR_THR
	decf	BRIGHT_S,f
	movf	BRIGHT_S,w
	decfsz	SOFT_ST,f	; decrease counter
	goto	SOFT_T		; continue dec bright_s till counter is zero
	incf	SOFT_ST,f
	goto	OUT_FLG
	
CLR_DEC	bcf	FLAG_ON,3
	bsf	FLAG_ON,7	; has run once flag
	bsf	FLAG_ON,1	; set down dimming
	bcf	FLAG_ON,5	; clear the on/on flag
	bcf	FLAG_ON,4	; clear the stop dimming flag
	movf	BRIGHT_S,w
	movwf	BRIGHT_V
	goto	OUT_FLG
CLR_THR	decf	BRIGHT_S,f
	movf	BRIGHT_S,w
	sublw	D'48'		; max brightness
	btfsc	STATUS,c
	goto	SET_1		; at max so set down dimming	
	movf	BRIGHT_S,w
	sublw	D'149'		; max value (min brightness)
	btfss	STATUS,c
	bcf	FLAG_ON,1	; up dimming
	goto	STET_1		; no change
SET_1	bsf	FLAG_ON,1	; down dimming
STET_1	bcf	FLAG_ON,3	; clear soft start flag
	decf	BRIGHT_S,f
	movf	BRIGHT_S,w
	sublw	D'48'
	btfss	STATUS,c
	goto	OUT_FLG
	bsf	FLAG_ON,1	; set down dimming
	incf	BRIGHT_S,f
	bsf	FLAG_ON,4	; set stop dimming flag
	bsf	FLAG_ON,7
	clrf	ON_OFFT
	movf	BRIGHT_S,w
	movwf	BRIGHT_V
	goto	OUT_FLG

	
UP_SET	clrf	R_FLAG		; remote control flags
	bcf	FLAG_ON,1	; up/dn dimming flag
	bcf	FLAG_ON,7
	btfsc	FLAG_ON,4	; is dimming stop flag set
	goto	OUT_FLG
	bsf	FLAG_ON,0	; on flag set
	clrf	FLAG
	bcf	FLAG_ON,5
	decf	BRIGHT_S,w	; increase brightness setting 
	sublw	D'48'		; min value
	btfsc	STATUS,c	; if c is 1 then BRIGHT_S at min value
	goto	TOGL_U		; toggle up flag
	decf	BRIGHT_S,f	;
	movf	BRIGHT_S,w
	movwf	BRIGHT_V	; stored brightness  
	goto	OUT_FLG
TOGL_U	bsf	FLAG_ON,1	; up/down dimming flag
	bsf	FLAG_ON,4	; stop dimming flag
	movf	BRIGHT_S,w
	movwf	BRIGHT_V
	goto	OUT_FLG

DN_SET	clrf	R_FLAG		; remote control flags
	bsf	FLAG_ON,1
	bcf	FLAG_ON,7
	btfsc	FLAG_ON,4	; is dimming stop flag set
	goto	OUT_FLG
	bsf	FLAG_ON,0	; on flag set
	clrf	FLAG
	bcf	FLAG_ON,5
	bcf	FLAG_ON,4
	movf	BRIGHT_S,w	; current brightness 
	sublw	D'149'		; min brightness  
	btfss	STATUS,c	; light is brighter than setting if c is 0
	goto	TOGL_D		; toggle down flag & do nothing to brightness
	incf	BRIGHT_S,f	; decrease brightness
	movf	BRIGHT_S,w
	movwf	BRIGHT_V	; stored brightness
	goto	OUT_FLG
TOGL_D	bcf	FLAG_ON,1	; up/dn dimming flag	
	bsf	FLAG_ON,4	; dimming stop flag
	goto	OUT_FLG

REM_UP	clrf	R_FLAG
	bsf	R_FLAG,0	; up flag
	bcf	FLAG_ON,1	; up/dn dimming flag
	bcf	FLAG_ON,7
	btfss	FLAG_ON,0	; was on flag clear ie after an off 
	bsf	FLAG_ON,6
	bsf	FLAG_ON,0	; on flag set
	clrf	FLAG
	bcf	FLAG_ON,5
	decf	BRIGHT_S,w	; increase brightness setting 
	sublw	D'48'		; min value
	btfsc	STATUS,c	; if c is 1 then BRIGHT_S at min value
	goto	MAX_B		; max brightness
	decf	BRIGHT_S,f	;
	movf	BRIGHT_S,w
	movwf	BRIGHT_V	; stored brightness
	goto	OUT_FLG

MAX_B	bsf	FLAG_ON,1	; up/down dimming flag
	movf	BRIGHT_S,w
	movwf	BRIGHT_V
	goto	OUT_FLG

REM_DN	clrf	R_FLAG		; remote control flags
	bsf	R_FLAG,1	; remote down flag
	bsf	FLAG_ON,1
	bcf	FLAG_ON,7
	btfsc	FLAG_ON,4	; is dimming stop flag set
	goto	OUT_FLG
	bsf	FLAG_ON,0	; on flag set
	clrf	FLAG
	bcf	FLAG_ON,5
	bcf	FLAG_ON,4
	movf	BRIGHT_S,w	; current brightness 
	sublw	D'149'		; min brightness  
	btfss	STATUS,c	; light is brighter than setting if c is 0
	goto	TOG_D		; toggle down flag & do nothing to brightness
	incf	BRIGHT_S,f	; decrease brightness
	movf	BRIGHT_S,w
	movwf	BRIGHT_V	; stored brightness
	goto	OUT_FLG
TOG_D	bcf	FLAG_ON,1	; up/dn dimming flag	
	bsf	FLAG_ON,4	; dimming stop flag
	goto	OUT_FLG

OUT_FLG	goto	CLR_RMF

	end		 	
