
; Remote volume control


; CPU configuration
; 	
	list P=16F84
	#include "p16f84.inc"
	__config _XT_OSC & _WDT_OFF & _PWRTE_ON

; Define variables at memory locations
; EEPROM DATA


EEPROM1		equ	H'00'	; non-volatile storage for volume level 
EEPROM2		equ	H'01'	; remote control code (selected with switches)


; RAM

W_TMP		equ	H'0C'	; temporary store for w in interrupt
STATUS_TMP	equ	H'0D'	; temporary store of status in interrupt  
VOL_LEV		equ	H'0E'	; volume level on display
REMOTE_M	equ	H'0F'	; remote control input ms byte
REMOTE_L	equ	H'10'	; remote control input LS byte
REM_FLG		equ	H'11'	; flag to indicate current remote control sequencing 
REM_CNT		equ	H'12'	; interrupt count for polling remote control signal
REM_COD		equ	H'13'	; remote control bit counter mode.
TOGGLE		equ	H'14'	; remote control toggle flag
	
SWITCH		equ	H'16'	; switch closure status (bits 5,6 & 7)
VOL_ATT		equ	H'17'	; attenuation level
FLAG_1		equ	H'18'	; repeat flag during EEPROM write
TEMP_2		equ	H'19'	; storage for EEPROM write
TEMP		equ	H'1A'	; temporary store
CODE_1		equ	H'1B'	; remote control code to be decoded (TV1, SAT1 or SAT2)
TEMP_1		equ	H'1C'	; temp location during data transfer to LM1973
TRANSF		equ	H'1D'	; counter during address and data transfer
VALUE_1		equ	H'1E'	; count value in delay routine
VALUE_2		equ	H'1F'	; count value in delay routine
MUTE_FG		equ	H'20'	; mute flag bit 1; high is mute
INT_CT1		equ	H'21'	; interrupt counter lsb
INT_CT2		equ	H'22'	; interrupt counter msb
TEMP_3		equ	H'23'	; storage of attenuation value during loading of LM1973
FLG_HL		equ	H'24'	; high or low remote control signal

; preprogram EEPROM DATA (00-3F from 2100-213F)
	
	ORG     2100		; start at 00
	
	DE	B'00100010'	; attenuation level -18dB
	DE	B'01111111'	; clear bit 7 (TV1 remote code)

; define reset and interrupt vector start addresses

	org	0	  	; start at address 0000h
	goto	MAIN		; normal service routines from Reset vector
	org     4		; interrupt vector 0004h, start interrupt routine here
	goto	INTRUPT

; conversion from VOL_ATT (attenuation level) to display value (VOL_LEV)

LEV_DSP	addwf	PCL,f	; add value to program counter
	retlw	D'38'	;  0.0dB. max volume
	retlw	D'38'	; -0.5dB. attenuation
	retlw	D'38'	; -1.0dB
	retlw	D'38'	; -1.5dB
	retlw	D'37'	; -2.0dB
	retlw	D'37'	; -2.5dB
	retlw	D'37'	; -3.0dB
	retlw	D'37'	; -3.5dB
	retlw	D'36'	; -4.0dB
	retlw	D'36'	; -4.5dB
	retlw	D'36'	; -5.0dB
	retlw	D'36'	; -5.5dB
	retlw	D'35'	; -6.0dB
	retlw	D'35'	; -6.5dB
	retlw	D'35'	; -7.0dB
	retlw	D'35'	; -7.5dB
	retlw	D'34'	; -8.0dB
	retlw	D'34'	; -8.5dB
	retlw	D'34'	; -9.0dB
	retlw	D'34'	; -9.5dB
	retlw	D'33'	; -10.0dB
	retlw	D'33'	; -10.5dB
	retlw	D'33'	; -11.0dB
	retlw	D'33'	; -11.5dB
	retlw	D'32'	; -12.0dB
	retlw	D'32'	; -12.5dB
	retlw	D'32'	; -13.0dB
	retlw	D'32'	; -13.5dB
	retlw	D'31'	; -14.0dB
	retlw	D'31'	; -14.5dB
	retlw	D'31'	; -15.0dB 
	retlw	D'31' 	; -15.5dB
	retlw	D'30'	; -16dB
	retlw	D'30'	; -17dB
	retlw	D'29'	; -18dB
	retlw	D'29'	; -19dB  	
	retlw	D'28'	; -20dB
	retlw	D'28'	; -21dB
	retlw	D'27'	; -22dB
	retlw	D'27'	; -23dB
	retlw	D'26'	; -24dB
	retlw	D'26'	; -25dB
	retlw	D'25'	; -26dB
	retlw	D'25'	; -27dB  	
	retlw	D'24'	; -28dB
	retlw	D'24'	; -29dB
	retlw	D'23'	; -30dB
	retlw	D'23'	; -31dB
	retlw	D'22'	; -32dB
	retlw	D'22'	; -33dB
	retlw	D'21'	; -34dB
	retlw	D'21'	; -35dB  	
	retlw	D'20'	; -36dB
	retlw	D'20'	; -37dB
	retlw	D'19'	; -38dB
	retlw	D'19'	; -39dB
	retlw	D'18'	; -40dB
	retlw	D'18'	; -41dB
	retlw	D'17'	; -42dB
	retlw	D'17'	; -43dB  	
	retlw	D'16'	; -44dB
	retlw	D'16'	; -45dB
	retlw	D'15'	; -46dB
	retlw	D'15'	; -47dB
	retlw	D'14'	; -48dB
	retlw	D'13'	; -50dB
	retlw	D'12'	; -52dB
	retlw	D'11'	; -54dB  	
	retlw	D'10'	; -56dB
	retlw	D'9'	; -58dB
	retlw	D'8'	; -60dB
	retlw	D'7'	; -62dB
	retlw	D'6'	; -64dB
	retlw	D'5'	; -66dB
	retlw	D'4'	; -68dB
	retlw	D'3'	; -70dB  	
	retlw	D'2'	; -72dB
	retlw	D'1'	; -74dB
	retlw	D'0'	; -76dB
	
; LED display values

DISP_V	addwf	PCL,f	; add value to program counter
	retlw	B'11101111'	; 0
	retlw	B'11101110'	; 1
	retlw	B'11111110'	; 2
	retlw	B'11111100'	; 3
	retlw	B'11111101'	; 4
	retlw	B'11111001'	; 5
	retlw	B'11111011'	; 6
	retlw	B'11110011'	; 7
	retlw	B'11110111'	; 8
	retlw	B'11110111'	; 9
	retlw	B'11110111'	; 10
	retlw	B'11110011'	; 11
	retlw	B'11111011'	; 12
	retlw	B'11111001'	; 13
	retlw	B'11111101'	; 14
	retlw	B'11111100'	; 15
	retlw	B'11111110'	; 16
	retlw	B'11101110'	; 17
	retlw	B'11101111'	; 18
	retlw	B'11101111'	; 19
	retlw	B'11101111'	; 20
	retlw	B'11101110'	; 21
	retlw	B'11111110'	; 22
	retlw	B'11111100'	; 23
	retlw	B'11111101'	; 24
	retlw	B'11111001'	; 25
	retlw	B'11111011'	; 26
	retlw	B'11110011'	; 27
	retlw	B'11110111'	; 28
	retlw	B'11110111'	; 29
	retlw	B'11110111'	; 30
	retlw	B'11110011'	; 31
	retlw	B'11111011'	; 32
	retlw	B'11111001'	; 33
	retlw	B'11111101'	; 34
	retlw	B'11111100'	; 35
	retlw	B'11111110'	; 36
	retlw	B'11101110'	; 37
	retlw	B'11101111'	; 38
	retlw	B'11101111'	; 39


; start interrupt by saving w and status registers before altered by interrupt routine

INTRUPT movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bcf	STATUS,RP0	; select memory bank 0

; check interrupt	
	
	
	btfsc	INTCON,T0IF	; TMRO overflow interrupt flag then goto counter
	goto	COUNTER		; TMRO overflow so increase counter 
	goto	RECLAIM		; end of interrupt reclaim w and status


COUNTER	movlw	D'207'		; freq is 4MHz/4/2/50. = 100us
	addwf	TMR0,f		; add to timer register and takes 2 cycles to start counting
	bcf	INTCON,T0IF	; clear TMRO interrupt flag
	incfsz	INT_CT1,f	; increase interrupt counter
	goto	MD 
	incf	INT_CT2,f	; INT_CT1 has reached zero so increase INT_CT2
 
; multiplex display

MD	movlw	B'00011111'	; B0-B4 take high
	iorwf	PORTB,f		; LEDs off
	btfss	PORTB,7		; is B7 low
	goto	SEVEN_L
	btfss	PORTB,6		; is B6 low
	goto	SIX_L
	btfss	PORTB,5		; is B5 low
	goto	FIVE_L
	
; B7, B6 & B5 high so set B7 low

	movlw	B'11111111'
	movwf	PORTB		; all bits high
	bcf	PORTB,7		; B7 low
	btfss	MUTE_FG,1	; mute flag is it set
	goto	ALL_H
	btfss	INT_CT2,4	; if interrupt counter bit clr bypass
	goto	REM_CTR		; remote control decode
ALL_H	movf	VOL_LEV,w
	sublw	D'09'		; check if vol_lev between 0 & 9
	btfss	STATUS,c	; if c=1 then <=9
	goto	REM_CTR		; remote control section	
	movf	VOL_LEV,w	; volume level
	call	DISP_V
	andwf	PORTB,f		; drive LEDs
	goto	REM_CTR

SEVEN_L	movlw	B'11111111'
	movwf	PORTB		; all bits high
	bcf	PORTB,6		; B6 low
	btfss	MUTE_FG,1	; mute flag is it set
	goto	SEV_H
	btfss	INT_CT2,4	; if interrupt counter bit clr bypass
	goto	REM_CTR		; remote control decode
SEV_H	movlw	D'09'		; min volume level value for B6
	subwf	VOL_LEV,w	; if larger than or = 9
	btfss	STATUS,c	; c = 1 if larger or = 9
	goto	REM_CTR
	movf	VOL_LEV,w	; volume level
	sublw	D'19'		; check if less than or = 19
	btfss	STATUS,c	; c is 1 if less than or = 19
	goto	REM_CTR
	movf	VOL_LEV,w
	call	DISP_V		; get LED code
	andwf	PORTB,f		; drive LEDs	
	goto	REM_CTR

SIX_L	movlw	B'11111111'
	movwf	PORTB		; all bits high
	bcf	PORTB,5		; B5 low
	btfss	MUTE_FG,1	; mute flag is it set
	goto	SIX_H
	btfss	INT_CT2,4	; if interrupt counter bit clr bypass
	goto	REM_CTR		; remote control decode
SIX_H	movlw	D'19'		; min volume level value for B5
	subwf	VOL_LEV,w	; if larger than or = 19
	btfss	STATUS,c	; c = 1 if larger or = 19
	goto	REM_CTR
	movf	VOL_LEV,w	; volume level
	sublw	D'29'		; check if less than or = 29
	btfss	STATUS,c	; c is 1 if less than or = 29
	goto	REM_CTR
	movf	VOL_LEV,w
	call	DISP_V		; get LED code
	andwf	PORTB,f		; drive LEDs	
	goto	REM_CTR

FIVE_L	movlw	B'11111111'
	movwf	PORTB		; all bits high
	btfss	MUTE_FG,1	; mute flag is it set
	goto	FIV_H
	btfss	INT_CT2,4	; if interrupt counter bit clear bypass
	goto	REM_CTR		; remote control decode
FIV_H	movlw	D'29'		; min volume level value for B7,6&5 high
	subwf	VOL_LEV,w	; if larger than or = 29
	btfss	STATUS,c	; c = 1 if larger or = 29
	goto	REM_CTR
	movf	VOL_LEV,w	; volume level
	sublw	D'38'		; check if less than or = 38
	btfss	STATUS,c	; c is 1 if less than or = 38
	goto	REM_CTR
	movf	VOL_LEV,w
	call	DISP_V		; get LED code
	andwf	PORTB,f		; drive LEDs	
	goto	REM_CTR

; check if RA1 has gone low for start of remote control sequence

REM_CTR	btfsc	PORTA,0		; if RA0 is low then a switch is pressed
	goto	RM_SQ
	movf	PORTB,w
	movwf	SWITCH		; bits 5,6 and 7 if low tests the closed switch
	
RM_SQ	btfsc	REM_FLG,0	; has remote control sequence started		
	goto	REM_SEQ
	btfsc	PORTA,1		; is RA1 low 
	goto	RECLAIM
	bsf	REM_FLG,0	; set beginning of remote control flag
	
	movlw	D'22'		; initial time period to wait till next start bit
	movwf	REM_CNT
	movlw	D'13'		; shift register counter
	movwf	REM_COD
	bsf	REMOTE_L,0	; set first bit in remote control sequence
		
	clrf	FLG_HL		; * clear bit 1 in high low flag
	bsf	REM_FLG,7	; * start bit flag set	
	goto	RECLAIM
	
REM_SEQ	btfsc	REM_FLG,1	; has it finished
	goto	RECLAIM
	decfsz	REM_CNT,f	; decrease interrupt counter for timing
	goto	CKEDGE		; * check if change in level
	bcf	REM_FLG,7	; * clear start bit flag
	movlw	D'18'		; 18 x 100us = 1.8ms or period between valid bits
	movwf	REM_CNT
	rlf	REMOTE_L,f	; least significant byte in remote control code sequence
	rlf	REMOTE_M,f	; most significant byte 
	movf	PORTA,w		; * check bit 1 portA
	andlw	B'00000010'	; * mask out bits except bit 1
	movwf	FLG_HL		; * place in flag
		
	btfsc	PORTA,1		; check if high or low
	goto	HI		; high so clear
	bsf	REMOTE_L,0	; if low set this bit
	goto	BY_HI		; bypass high
HI	bcf	REMOTE_L,0	; clear 0 bit

BY_HI	decfsz	REM_COD,f	; decrease shift register count
	goto	RECLAIM
	bsf	REM_FLG,1	; set end of remote control decoding flag
	goto	RECLAIM

; align change in level (edge detect) with REM_CNT counter
 
CKEDGE	btfsc	REM_FLG,7	; start bit flag bypass edge detect as AGC level setting
	goto	RECLAIM
	movlw	B'00000010'	; select bit 1 for PORTA,1
	andwf	PORTA,w		; bit 1
	xorwf	FLG_HL,w	; compare PORTA,1 with FLAG (previous level)		
	btfsc	STATUS,z	; Z=1 if zero then no change
	goto	RECLAIM		; no change 
	movlw	B'00000010'	; select bit 1 for PORTA,1
	andwf	PORTA,w		; bit 1 select 
	movwf	FLG_HL		; reload new level
	movlw	0x3		; count of 3 for REM_CNT
	subwf	REM_CNT,w	; is REM_CNT larger or equal to 3
	btfss	STATUS,c
	goto	RECLAIM		; smaller than 3 
	movf	REM_CNT,w
	sublw	0x6		; check if 6 or less
	btfss	STATUS,c
	goto	RECLAIM		; larger than 6 
	movlw	0x4
	movwf	REM_CNT		; set REM_CNT to 4 to align with change in level
	goto	RECLAIM


; end of interrupt reclaim w and status 

RECLAIM	swapf	STATUS_TMP,w	; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie			; return from interrupt

;********************************************************************************************** 
  
; RESET		
; Set ports A & B

MAIN	bsf	STATUS,RP0	; select memory bank 1
	movlw	B'00000000'	; (RB0 - RB7 outputs)
	movwf	TRISB		; port B data direction register
	movlw	B'10000000'	; 
	movwf	OPTION_REG	; TMRO prescaler is 2, PORTB pullups disabled
	movlw   B'00000011'	; 1's are inputs (RA0,1) RA2-RA4 outputs 
	movwf   TRISA		; A port data direction register
	bcf	STATUS,RP0	; select memory bank 0
	movlw	B'11111111'	; 1 for RB display off
	movwf	PORTB		; portB outputs high
	movlw	B'00011100'	; data, load outputs high and clock high
	movwf	PORTA		; portA values set
	
	clrf	MUTE_FG		; clear mute flag

; recall stored values

	movlw	EEPROM1		; volume level
	call 	EEREAD
	movwf	VOL_ATT		; attenuation level
	call	LEV_DSP		; convert to display value
	movwf	VOL_LEV		; volume display
	
	movlw	EEPROM2		; remote code
	call 	EEREAD
	movwf	CODE_1		; which remote code to decode

; read switches at power up
; store selection in EEPROM2 and CODE_1
; send current VOL_ATT to LM1973

	bcf	PORTB,5		; clear bit 5
	btfss	PORTA,0		; check if RA0 is low (Down switch closed)
 	goto	CODE_N		; code new
	bsf	PORTB,5		; bit 5 high again
	bcf	PORTB,6		; check Up switch
	btfss	PORTA,0
	goto	CODE_N
	bsf	PORTB,6		; bit 6 high again
	bcf	PORTB,7		; check Mute switch
	btfss	PORTA,0
	goto	CODE_N
	bsf	PORTB,7		; bit 7 high again
	goto	INT_E		; start interrupts and load volume levels

CODE_N	movlw	EEPROM2		; address for EEPROM2, remote control coding
	movwf	EEADR		; address for write
	movf	PORTB,w		; PORTB levels stored
	movwf	CODE_1		; place in memory
	call	EWRITE		; write to EEPROM 

; interrupt enable 

INT_E	bsf	INTCON,T0IE	; set interrupt enable for TMR0 
	bsf	INTCON,GIE	; set global interrupt enable for above

; send data to LM1973
	
	call 	DELY
	call	NEW_ATT		; subroutine for new attenuation load into LM1973	
	call	NEW_ATT		; a second time to ensure input 1 set correctly

; check operation switches first. Volume Up, Down, Mute
; switch function

SW_CK	btfss	SWITCH,7	; is Mute switch pressed
	goto	MUTE_ST		; mute set
	btfss	SWITCH,6	; is Up switch pressed
	goto	UP_SET		; Up set
	btfss	SWITCH,5	; is Dn switch pressed
	goto	DN_SET		; down set
	
; decode remote control signal

	btfss	REM_FLG,1	; is remote control entered flag set
	goto	SW_CK
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	

; compare with address code out if invalid clear REM_FLG
; if valid check command bits and ls 2 address bits then clear REM_FLG
 
	btfss	CODE_1,7		; set with Mute switch at power up
	goto	TV_1
	btfss	CODE_1,6		; set with Up switch
	goto	SAT_1
	btfss	CODE_1,5		; set with Dn switch
	goto	SAT_2
	goto	SW_CK

; code for television (TV1)

TV_1	xorlw	B'00110000'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,z	; if zero then matching
	goto	CLR_RMF		; clear remote flag
	
	movf	REMOTE_L,w
	xorlw	B'00010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	UP_SET
	movf	REMOTE_L,w
	xorlw	B'00010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	DN_SET  
	movf	REMOTE_L,w
	xorlw	B'00001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	MUTE_ST
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'00100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_UP
	movf	REMOTE_L,w
	xorlw	B'00100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_DN  
	goto	CLR_RMF


; satellite decoding SAT1 & SAT2
	
SAT_1	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,z	; if zero then matching
	goto	CLR_RMF		; clear remote flag
	movf	REMOTE_L,w	;  least sig remote code
	
	xorlw	B'00010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	UP_SET
	movf	REMOTE_L,w
	xorlw	B'00010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	DN_SET
	movf	REMOTE_L,w
	xorlw	B'00001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	MUTE_ST 
	movf	REMOTE_L,w	;  least sig remote code
	xorlw	B'00100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_UP
	movf	REMOTE_L,w
	xorlw	B'00100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_DN 
  	goto	CLR_RMF

SAT_2	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,z	; if zero then matching
	goto	CLR_RMF		; clear remote flag
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'10100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_UP
	movf	REMOTE_L,w
	xorlw	B'10100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	REM_DN 
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'10010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	UP_SET
	movf	REMOTE_L,w
	xorlw	B'10010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	DN_SET 
	movf	REMOTE_L,w
	xorlw	B'10001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,z
	goto	MUTE_ST  


CLR_RMF	clrf	REM_FLG		; remote flag cleared
	goto	SW_CK

; up volume. Increase to 0 (ie dec VOL_ATT value), drive LM1973, store new value in EEPROM

UP_SET	clrf	REM_FLG		; remote flag cleared
	bcf	MUTE_FG,1	; mute flag off
	movf	VOL_ATT,f
	btfsc	STATUS,z	; check if zero
	goto	PROCESS		; already zero so no change
	decf	VOL_ATT,f	; decrease value
	movf	VOL_ATT,w	; attenuation value
	sublw	B'0011111'	; 15.5dB attenuation value
	btfsc	STATUS,c	; if c is 1 then <= so decrease twice for 1dB steps
	goto	BY_PTFV		; bypass 0.5dB steps (PoinT FiVe)) 
PROCESS	movf	VOL_ATT,w	; attenuation level
	call	LEV_DSP		; convert to display value
	movwf	VOL_LEV		; volume display

	call	NEW_ATT		; drive LM1973

	movlw	EEPROM1		; address for EEPROM1, volume attenuation level
	movwf	EEADR		; address for write
	movf	VOL_ATT,w	; attenuation level
	call	EWRITE		; write to EEPROM
	call 	DELY		; delay between changes
	call	DELY
	call	DELY
	call	DELY 
	goto	SW_CK

BY_PTFV	movf	VOL_ATT,f
	btfsc	STATUS,z	; check if zero
	goto	PROCESS		; already zero so no change
	decf	VOL_ATT,f	; decrease value
	goto	PROCESS

DN_SET	clrf	REM_FLG		; remote flag cleared
	movf	VOL_ATT,w	; attenuation value
	sublw	B'0011110'	; 15.0dB attenuation value
	btfsc	STATUS,c	; if c is 1 then <= so increase twice for 1dB steps
	goto	BY_HALF		; bypass 0.5dB steps (half) 
	incf	VOL_ATT,w	; attenuation value
	sublw	D'78'		; max value
	btfss	STATUS,c	; if negative do not increase
	goto	IS_MUTE
	incf	VOL_ATT,f
	goto	IS_MUTE	
BY_HALF	incf	VOL_ATT,f
	incf	VOL_ATT,f
	
IS_MUTE	btfss	MUTE_FG,1	; if mute flag set do not load VOL_ATT
	goto	PROCESS		; not muted so load attenuation value
	movf	VOL_ATT,w	; muted so convert display. look at attenuation level
	call	LEV_DSP		; convert to display value
	movwf	VOL_LEV		; volume display
	call	DELY
	call	DELY
	call	DELY
	call	DELY
	goto	SW_CK
	
MUTE_ST	clrf	REM_FLG		; remote flag cleared
	btfss	MUTE_FG,1	; if set clear if clear set
	goto	ST_FG1
	bcf	MUTE_FG,1	; mute off
	
	call	NEW_ATT		; reload attenuation value
	call	DELY
	call	DELY
	call	DELY
	call	DELY
	call	DELY
	call	DELY
	call	DELY
	call	DELY

	goto	SW_CK

ST_FG1	bsf	MUTE_FG,1	; mute on
	clrf	INT_CT1		; interrupt counter (sets blink rate during Mute)
	clrf	INT_CT2		; ms byte interrupt counter
	movlw	0xFF		; mute value
	movwf	TEMP_3		; attenuation store
	call	ATT_M		; mute attenuation
	call	DELY
	call	DELY
	call	DELY
	call	DELY
	call	DELY
	call	DELY
	call	DELY
	call	DELY
	goto	SW_CK

; up volume. Increase to 0 (ie dec VOL_ATT value), drive LM1973, store new value in EEPROM

REM_UP	clrf	REM_FLG		; remote flag cleared
	bcf	MUTE_FG,1	; mute flag off
	movf	VOL_ATT,f
	btfsc	STATUS,z	; check if zero
	goto	PR0CESS		; already zero so no change
	decf	VOL_ATT,f	; decrease value
	movf	VOL_ATT,w	; attenuation value
	sublw	B'01000001'	; 50dB attenuation value
	btfsc	STATUS,c	; if c is 1 then <= so decrease twice for 2dB steps
	goto	BY_ONE		; bypass 1dB steps 
PR0CESS	movf	VOL_ATT,w	; attenuation level
	call	LEV_DSP		; convert to display value
	movwf	VOL_LEV		; volume display

	call	NEW_ATT		; drive LM1973

	movlw	EEPROM1		; address for EEPROM1, volume attenuation level
	movwf	EEADR		; address for write
	movf	VOL_ATT,w	; attenuation level
	call	EWRITE		; write to EEPROM

	goto	SW_CK

BY_ONE	movf	VOL_ATT,f
	btfsc	STATUS,z	; check if zero
	goto	PR0CESS		; already zero so no change
	decf	VOL_ATT,f	; decrease value
	movf	VOL_ATT,f
	btfsc	STATUS,z	; check if zero
	goto	PR0CESS		; already zero so no change
	decf	VOL_ATT,f	; decrease value
	movf	VOL_ATT,f
	btfsc	STATUS,z	; check if zero
	goto	PR0CESS		; already zero so no change
	decf	VOL_ATT,f	; decrease value
	goto	PR0CESS

REM_DN	clrf	REM_FLG		; remote flag cleared
	movf	VOL_ATT,w	; attenuation value
	sublw	B'01000000'	; 48.0dB attenuation value
	btfsc	STATUS,c	; if c is 1 then <= so increase 4x for 2dB steps
	goto	BY_STP		; bypass 1 dB steps (half) 
	incf	VOL_ATT,w	; attenuation value
	sublw	D'78'		; max value
	btfss	STATUS,c	; if negative do not increase
	goto	IS_MUTD
	incf	VOL_ATT,f
	goto	IS_MUTD	
BY_STP	incf	VOL_ATT,f
	incf	VOL_ATT,f
	incf	VOL_ATT,f
	incf	VOL_ATT,f	
IS_MUTD	btfss	MUTE_FG,1	; if mute flag set do not load VOL_ATT
	goto	PR0CESS		; not muted so load attenuation value
	movf	VOL_ATT,w	; muted so convert display. look at attenuation level
	call	LEV_DSP		; convert to display value
	movwf	VOL_LEV		; volume display
	
	goto	SW_CK
; ....................................................

; subroutines

NEW_ATT	movf	VOL_ATT,w
	movwf	TEMP_3		; storage of VOL_ATT
ATT_M	bcf	PORTA,3		; clock low
	bcf	PORTA,4		; load shift line low
	clrf	TEMP_1		; storage of address for channel 1 of LM1973
	call	PAR_SER		; parallel to serial conversion send out address 0
	movf	TEMP_3,w	; volume attenuation level
	movwf	TEMP_1
	call	PAR_SER		; send attenuation data
	bsf	PORTA,4		; set load shift line high
	
	movlw	0x01		; address for channel 2
	movwf	TEMP_1
	call	PAR_SER		; send address data
	movf	TEMP_3,w	; volume attenuation level
	movwf	TEMP_1
	call	PAR_SER		; send attenuation data
	bsf	PORTA,4		; load shift line high
	
	movlw	0x02		; address for channel 3
	movwf	TEMP_1
	call	PAR_SER		; send address data
	movf	TEMP_3,w	; volume attenuation level
	movwf	TEMP_1
	call	PAR_SER		; send attenuation data
	bsf	PORTA,4		; set load shift line high
	return			; end of parallel to serial conversion

PAR_SER	movlw	D'08'		; count of 8	
	movwf	TRANSF		; transfer counter
SERIAL	bcf	PORTA,3		; clock low
	nop
	nop
	bcf	PORTA,4		; load shift low
	rlf	TEMP_1,f	; move left (ms bits first) into carry bit	
	btfss	STATUS,c	; check carry bit
	goto	CLR_A		; clear address bit
	bsf	PORTA,2		; address/data line high
	goto	SET_A
CLR_A	bcf	PORTA,2		; address/data low
SET_A	nop
	bsf	PORTA,3		; clock high
	decfsz	TRANSF,f	; decrement transfer counter
	goto	SERIAL
	bcf	PORTA,3		; clock low
	return
				

; subroutine to read EEPROM memory

EEREAD	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 1
	bsf	EECON1,RD	; read EEPROM
RD_RD	nop
	btfsc	EECON1,RD	; skip if RD low (read complete)
	goto 	RD_RD		; wait for low RD (read RD)	
	bcf	STATUS,RP0	; select bank 0
	movf	EEDATA,w	; EEPROM value in w
	return

; subroutine to write to EEPROM

EWRITE	bcf	FLAG_1,6	; EEPROM write repeat flag
	movwf	TEMP_2		; store w in temporary storage
EWRIT	movf	TEMP_2,w	; place value in w (used for read data sequence) 
	movwf	EEDATA		; data register
	bcf	INTCON,GIE	; disable interrupts
	bsf	STATUS,RP0	; select bank 1
	bsf	EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf	EECON1,WR	; set WR bit and begin write sequence
	bsf	INTCON,GIE	; enable interrupts
	bcf	EECON1,WREN	; clear WREN bit
WRITE	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE		; not written yet
	bcf	EECON1,EEIF	; clear write interrupt flag 
	
; read EEPROM DATA and check if written correctly
	
	bsf 	STATUS,RP0	; select memory bank 1
	bsf	EECON1,RD	; read EEPROM
RD_AGN	nop
	btfsc	EECON1,RD	; skip if RD low (read complete)
	goto 	RD_AGN		; wait for low RD	
	bcf	STATUS,RP0	; select bank 0
	movf	EEDATA,w	; EEPROM value in w
	subwf	EEDATA,w	; compare read value with value stored
	btfsc	STATUS,z	; skip if not the same
	return			; value correctly written 
	btfsc	FLAG_1,6	; write repeat bit, skip if clear and rewrite
	return
	bsf	FLAG_1,6	; set repeat flag rewrite once only 
	goto 	EWRIT		; rewrite as not written correctly

DELY	movlw	D'25'		; set delay period 
	movwf	VALUE_1		; VALUE_1 = w
	movlw	D'255'		; set delay period value 2 
LP_X	movwf	VALUE_2		; VALUE_2 = w
LP_Y	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_Y
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_X	
	movlw	0xFF
	movwf	SWITCH		; switch closure status set off
	clrf	REM_FLG		; remote flag cleared
	return


	end		 	
