//Battery Checker: applied nominal current and tests sag

#include "config.h"
#include <xc.h>
#include "globalPins.h"
#include "portbits.h"
#include "io.h"
#include "oled.h"
#include "util.h"

//_XTAL_FREQ and pins set in globalPins.h

void main(void) {
    char b=0;   //for buttons
    ioInit();
    initADC();
    FVRCON=FVR_DAC4_ADC1;   //DAC at 4V, ADC at 1V
    DAC1CON=DAC_RA2_FVR;       
    DAC1DATL=0xFF;   //max is lowest current
    //check if running off external or internal battery
    getV();
    if(PRESSED(S_POWER)&&(vaux>vbat)){   //button pressed and internal battery present
        psu=BATTERY_AUX;
        latbits.POWERCON=1; //on
    }else{
        psu=BATTERY_EXT;
    }
    I2Cinit();
    OLEDinit();    
    OLEDclear(0);
    OLEDflip(OLED_CONNECTOR_AT_BOTTOM);
    OLEDbrightness(0xFF);  
    OLEDpage=0;                            
    OLEDcol=2;    
    //OLEDchararray("SPLASH",arial);
    OLEDchar(0,splash);
    while(PRESSED(S_POWER)){}    //wait for release, otherwise it will switch back off
    delay(1000);
    OLEDclear(0);
    t0init();
    tmOut=cur.cdTime;
    GIE=1;
    while(1){
        getV();
        checkForPowerOff();
        if(screen==SCREEN_TEST){    //test for S4 differently
            if(checkButtonLong(MODE_BUTTON)){
                screen=screen+1;
                OLEDclear(0);//refresh
                resetTimer();
            }
        }else{
            if(checkButton(MODE_BUTTON)){
                screen=screen+1;
                if(screen>=SCREEN_DUMMY){screen=0;}
                OLEDclear(0);//refresh
                resetTimer();
            }
        }
        //page title etc
        OLEDpage=0;                            
        OLEDcol=2;
        OLEDchararray(screenNames[screen],arial);
        OLEDpage=0;                            
        OLEDcol=96;
        if(psu==BATTERY_AUX){
            if((cur.autoPowerOff) && (tmOut==0)){turnAuxPowerOff();}    //if timeout enabled and triggered
            if((cur.autoPowerOff) && (tFree&2)){   //cycle every 2s
                OLEDscanshort(tmOut);
                OLEDlzb(8);
                OLEDchar(OLEDbuf[8],arial);
                OLEDchar(OLEDbuf[9],arial);
                OLEDchar('s',arial);                    
                OLEDchar('.',narrow);                    
            }else{
                OLEDscanshort(vaux);
                if(vaux<10000){
                    OLEDchar(OLEDbuf[6],arial);
                    OLEDchar('.',narrow);
                    OLEDchar(OLEDbuf[7],arial);
                    OLEDchar('V',arial);                    
                }else{
                    OLEDchar(OLEDbuf[5],arial);
                    OLEDchar(OLEDbuf[6],arial);
                    OLEDchar('.',narrow);
                    OLEDchar('V',arial);                                        
                }                    
            }        
        }else{
            OLEDchararray("EXT",arial);            
        }
        OLEDpage=2;                            
        OLEDcol=2;
        b=buttonPressAndHold();
        if(b){resetTimer();}
        if(screen!=SCREEN_TEST){resetTimer();}  //don't shut down during settings
        switch(screen){
            case SCREEN_TEST:
                if(b==DOWN_BUTTON){if(maxCurrent>TEST_CURRENT_MIN){maxCurrent=maxCurrent-1;}}
                if(b==UP_BUTTON){if(maxCurrent<TEST_CURRENT_MAX){maxCurrent=maxCurrent+1;}}
                if(b==ENTER_BUTTON){
                    while(anyButton()){}
                    runTestAndDisplay();
                    OLEDclear(0);//refresh                    
                }
                testScreen();
                break;            
            case SCREEN_AUTOCAL:    //set .iOffset
                if(b==DOWN_BUTTON){if(cur.iOffset>0){cur.iOffset=cur.iOffset-1;}}
                if(b==UP_BUTTON){if(cur.iOffset<255){cur.iOffset=cur.iOffset+1;}}
                if(b==ENTER_BUTTON){
                    unsigned char res;
                    OLEDclear(0);//refresh
                    OLEDpage=2;                            
                    OLEDcol=33;
                    OLEDchararray("Running",arial);                        
                    res=runShuntScan();
                    OLEDclear(0);//refresh
                    if(res==0xFF){//fail
                        OLEDpage=2;                            
                        OLEDcol=15;
                        OLEDchararray("Scan failed",arial);                        
                        OLEDpage=4;                            
                        OLEDcol=5;
                        OLEDchararray("Check Battery",arial);                        
                    }else{
                        OLEDpage=2;                            
                        OLEDcol=33;
                        OLEDchararray("Scan OK",arial);                        
                        cur.iOffset=res;
                    }
                    delay(1000);
                    OLEDclear(0);//refresh
                    OLEDpage=2;                            
                    OLEDcol=2;
                }
                OLEDchar(ICON_RIGHT,icons);
                OLEDchararray(" Run auto",arial);
                OLEDpage=4;                            
                OLEDcol=2;
                OLEDchararray("Set:",arial);
                OLEDscanshort(getVdac(cur.iOffset,dacref4)); //calculated voltage
                OLEDlzb(8);
                OLEDchararray(&OLEDbuf[6],arial);
                OLEDchararray("mV",arial);
                OLEDpage=6;                            
                OLEDcol=2;//OLEDchararray("DN  UP  GO  SE",arial);
                OLEDchararray(ICON_DOWN_ARRAY ICON_BLANK_ARRAY ICON_UP_ARRAY ICON_BLANK_ARRAY ICON_RIGHT_ARRAY ICON_BLANK_ARRAY ICON_MODE_ARRAY,icons);
                break;     
            case SCREEN_INTRES:    //set .intResistance
                if(intRes>INT_RES_MAX){intRes=INT_RES_MAX;}
                if(intRes<INT_RES_MIN){intRes=INT_RES_MIN;}
                if(b==DOWN_BUTTON){if(cur.intResistance>INT_RES_MIN){cur.intResistance=cur.intResistance-INT_RES_INC;}}
                if(b==UP_BUTTON){if(cur.intResistance<INT_RES_MAX){cur.intResistance=cur.intResistance+INT_RES_INC;}}
                if(b==ENTER_BUTTON){cur.intResistance=intRes;}
                OLEDchar(ICON_RIGHT,icons);
                OLEDchararray(" use:",arial);
                OLEDscanshort(intRes); //calculated voltage
                OLEDlzb(8);
                OLEDchararray(&OLEDbuf[6],arial);
                OLEDchararray("m" FONT_STRING_OMEGA,arial);
                OLEDpage=4;                            
                OLEDcol=2;
                OLEDchararray("Set:",arial);
                OLEDscanshort(cur.intResistance); //calculated voltage
                OLEDlzb(8);
                OLEDchararray(&OLEDbuf[6],arial);
                OLEDchararray("m" FONT_STRING_OMEGA,arial);
                OLEDpage=6;                            
                OLEDcol=2;//OLEDchararray("DN  UP  GO  SE",arial);
                OLEDchararray(ICON_DOWN_ARRAY ICON_BLANK_ARRAY ICON_UP_ARRAY ICON_BLANK_ARRAY ICON_RIGHT_ARRAY ICON_BLANK_ARRAY ICON_MODE_ARRAY,icons);
                break;     
            case SCREEN_TIMER:      //set .cdTime, toggle .autoPowerOff
                if(b==ENTER_BUTTON){
                    if(cur.autoPowerOff){
                        cur.autoPowerOff=0;
                    }else{
                        cur.autoPowerOff=1;
                    }                    
                }
                if(b==DOWN_BUTTON){if(cur.cdTime>0){cur.cdTime=cur.cdTime-5;}}
                if(b==UP_BUTTON){if(cur.cdTime<95){cur.cdTime=cur.cdTime+5;}}
                OLEDchar(ICON_RIGHT,icons);
                if(cur.autoPowerOff){
                    OLEDchararray(" Timer on ",arial);
                }else{
                    OLEDchararray(" Timer off",arial);
                }                
                OLEDpage=4;                            
                OLEDcol=2;
                OLEDchararray("Set:",arial);
                OLEDscanshort(cur.cdTime); //calculated voltage
                OLEDlzb(8);
                OLEDchararray(&OLEDbuf[6],arial);
                OLEDchararray("s",arial);
                OLEDpage=6;                            
                OLEDcol=2;//OLEDchararray("DN  UP  GO  SE",arial);
                OLEDchararray(ICON_DOWN_ARRAY ICON_BLANK_ARRAY ICON_UP_ARRAY ICON_BLANK_ARRAY ICON_RIGHT_ARRAY ICON_BLANK_ARRAY ICON_MODE_ARRAY,icons);
                break;     
            case SCREEN_PERCENT:    //set .pcDrop
                if(b==DOWN_BUTTON){if(cur.pcDrop>PC_DROP_LOWER){cur.pcDrop=cur.pcDrop-1;}}
                if(b==UP_BUTTON){if(cur.pcDrop<PC_DROP_UPPER){cur.pcDrop=cur.pcDrop+1;}}
                OLEDpage=4;                            
                OLEDcol=2;
                OLEDchararray("Set:",arial);
                OLEDscanshort(cur.pcDrop); //calculated voltage
                OLEDlzb(8);
                OLEDchararray(&OLEDbuf[6],arial);
                OLEDchararray("%",arial);
                OLEDpage=6;                            
                OLEDcol=2;//OLEDchararray("DN  UP      SE",arial);
                OLEDchararray(ICON_DOWN_ARRAY ICON_BLANK_ARRAY ICON_UP_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_MODE_ARRAY,icons);
                break;     
            case SCREEN_IMAX:       //set .iMax (current at DAC=0)
                if(b==DOWN_BUTTON){if(cur.iMax>I_CAL_MIN){cur.iMax=cur.iMax-I_CAL_INC;}}
                if(b==UP_BUTTON){if(cur.iMax<I_CAL_MAX){cur.iMax=cur.iMax+I_CAL_INC;}}
                OLEDpage=4;                            
                OLEDcol=2;
                OLEDchararray("Set:",arial);
                OLEDscanshort(cur.iMax); //calculated voltage
                OLEDlzb(5);
                OLEDchar(OLEDbuf[5],arial);
                OLEDchar(OLEDbuf[6],arial);
                OLEDchar('.',arial);
                OLEDchar(OLEDbuf[7],arial);
                OLEDchararray("A",arial);
                OLEDpage=6;                            
                OLEDcol=2;//OLEDchararray("DN  UP      SE",arial);
                OLEDchararray(ICON_DOWN_ARRAY ICON_BLANK_ARRAY ICON_UP_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_MODE_ARRAY,icons);
                break;     
            case SCREEN_ISCALE:     //set .iFullScale (ie shunt calibration)
                if(b==DOWN_BUTTON){if(cur.iFullScale>I_CAL_MIN){cur.iFullScale=cur.iFullScale-I_CAL_INC;}}
                if(b==UP_BUTTON){if(cur.iFullScale<I_CAL_MAX){cur.iFullScale=cur.iFullScale+I_CAL_INC;}}
                OLEDpage=4;                            
                OLEDcol=2;
                OLEDchararray("Set:",arial);
                OLEDscanshort(cur.iFullScale); //calculated voltage
                OLEDlzb(5);
                OLEDchar(OLEDbuf[5],arial);
                OLEDchar(OLEDbuf[6],arial);
                OLEDchar('.',arial);
                OLEDchar(OLEDbuf[7],arial);
                OLEDchararray("A",arial);
                OLEDpage=6;                            
                OLEDcol=2;//OLEDchararray("DN  UP      SE",arial);
                OLEDchararray(ICON_DOWN_ARRAY ICON_BLANK_ARRAY ICON_UP_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_MODE_ARRAY,icons);
                break;     
            case SCREEN_VBAT:        //set .vBatScale (ie divider calibration)
                if(b==DOWN_BUTTON){if(cur.vBatScale>VSCALE_MIN){cur.vBatScale=cur.vBatScale-VSCALE_INC;}}
                if(b==UP_BUTTON){if(cur.vBatScale<VSCALE_MAX){cur.vBatScale=cur.vBatScale+VSCALE_INC;}}
                OLEDchararray("Trim: ",arial);
                OLEDscanshort(vbat);//measured value
                OLEDlzb(5);
                OLEDchar(OLEDbuf[5],arial);
                OLEDchar(OLEDbuf[6],arial);
                OLEDchar('.',narrow);
                OLEDchar(OLEDbuf[7],arial);
                OLEDchar(OLEDbuf[8],arial);
                OLEDchar('V',arial);                                                        
                OLEDpage=4;                            
                OLEDcol=2;
                OLEDchararray("Set:",arial);
                OLEDscanshort(cur.vBatScale); //coefficient value
                OLEDlzb(8);
                OLEDchararray(&OLEDbuf[5],arial);
                OLEDpage=6;                            
                OLEDcol=2;//OLEDchararray("DN  UP      SE",arial);
                OLEDchararray(ICON_DOWN_ARRAY ICON_BLANK_ARRAY ICON_UP_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_MODE_ARRAY,icons);
                break;     
            case SCREEN_VAUX:       //set .vAuxScale (ie divider calibration)
                if(b==DOWN_BUTTON){if(cur.vAuxScale>VSCALE_MIN){cur.vAuxScale=cur.vAuxScale-VSCALE_INC;}}
                if(b==UP_BUTTON){if(cur.vAuxScale<VSCALE_MAX){cur.vAuxScale=cur.vAuxScale+VSCALE_INC;}}
                OLEDchararray("Trim: ",arial);
                OLEDscanshort(vaux);//measured value
                OLEDlzb(5);
                OLEDchar(OLEDbuf[5],arial);
                OLEDchar(OLEDbuf[6],arial);
                OLEDchar('.',narrow);
                OLEDchar(OLEDbuf[7],arial);
                OLEDchar(OLEDbuf[8],arial);
                OLEDchar('V',arial);                                                        
                OLEDpage=4;                            
                OLEDcol=2;
                OLEDchararray("Set:",arial);
                OLEDscanshort(cur.vAuxScale); //coefficient value
                OLEDlzb(8);
                OLEDchararray(&OLEDbuf[5],arial);
                OLEDpage=6;                            
                OLEDcol=2;//OLEDchararray("DN  UP      SE",arial);
                OLEDchararray(ICON_DOWN_ARRAY ICON_BLANK_ARRAY ICON_UP_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_MODE_ARRAY,icons);
                break;     
            case SCREEN_VAUX_MIN:   //set .minVaux (shutdown limit)
                if(b==DOWN_BUTTON){if(cur.minVaux>VAUXMIN_MIN){cur.minVaux=cur.minVaux-VAUXMIN_INC;}}
                if(b==UP_BUTTON){if(cur.minVaux<VAUXMIN_MAX){cur.minVaux=cur.minVaux+VAUXMIN_INC;}}
                OLEDpage=4;                            
                OLEDcol=2;
                OLEDchararray("Set: ",arial);
                OLEDscanshort(cur.minVaux);//measured value
                OLEDlzb(5);
                OLEDchar(OLEDbuf[5],arial);
                OLEDchar(OLEDbuf[6],arial);
                OLEDchar('.',narrow);
                OLEDchar(OLEDbuf[7],arial);
                OLEDchar('V',arial);                                                        
                OLEDpage=6;                            
                OLEDcol=2;//OLEDchararray("DN  UP      SE",arial);
                OLEDchararray(ICON_DOWN_ARRAY ICON_BLANK_ARRAY ICON_UP_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_MODE_ARRAY,icons);
                break;     
            case SCREEN_LOAD_DEFAULTS:      //load from flash
                if(buttonState(DOWN_BUTTON)&&buttonState(UP_BUTTON)){
                    OLEDclear(0);//refresh
                    OLEDpage=3;                            
                    OLEDcol=23;
                    OLEDchararray("Resetting",arial);                        
                    cur=backupSettings;
                    while(buttonState(DOWN_BUTTON)||buttonState(UP_BUTTON)){}
                    OLEDclear(0);//refresh
                    OLEDpage=3;                            
                    OLEDcol=46;
                    OLEDchararray("Done",arial);                        
                    delay(1000);
                    OLEDclear(0);//refresh
                    OLEDpage=2;                            
                    OLEDcol=2;                    
                }
                OLEDchar(ICON_DOWN,icons);
                OLEDchar('+',arial);
                OLEDchar(ICON_UP,icons);
                OLEDchararray(" = reset",arial);                
                OLEDpage=6;                            
                OLEDcol=2;//OLEDchararray("DN  UP  GO  SE",arial);
                OLEDchararray(ICON_DOWN_ARRAY ICON_BLANK_ARRAY ICON_UP_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_BLANK_ARRAY ICON_MODE_ARRAY,icons);
                break;     
            default:screen=SCREEN_TEST;break; //anything else is error, resume normal operation                     
        }
        waitForButtonOrT(200);
    }
}

void __interrupt() isr(){
    if(PIR0bits.TMR0IF && PIE0bits.TMR0IE){
        PIR0bits.TMR0IF=0;      
        if(tmOut){tmOut--;}
        if(cdTm){cdTm--;}        
        tFlag=1;
        tFree++;
    }
}

