#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"
#include "globalPins.h"
#include "oled.h"

#define FVRBUF1 0b111110 
#define FVR_1V (1)
#define FVR_2V (2)
#define FVR_4V (3)
#define ADREF_VDD (0)
#define ADREF_FVR (3)
#define ADC_OS (8)

#define PRESSED(x) (portbits.x==0)
//from DIA
extern unsigned int adcref1,dacref1;
extern unsigned int adcref2,dacref2;
extern unsigned int adcref4,dacref4;

//apply pullup to ensure not floating
#define UNUSED_A0 a0
#define UNUSED_A1 a1

//simple bitbanged UART
//this is S7 contacts
#define BB_UART_PIN c1
//PGD
//#define BB_UART_PIN a0
//PGC
//#define BB_UART_PIN a1
#define BB_BAUD 9600

//for FVRCON
#define FVR_OFF (0)
//both buffers set the same
#define FVR_4096 (128|12|3)
#define FVR_2048 (128|8|2)
#define FVR_1024 (128|4|1)
#define FVR_DAC4_ADC1 (128|12|1)

//for DAC1CON/DAC2CON
#define DAC_OFF (0)
#define DAC_RA2_FVR (128|32|8|0)

//buttonPressAndHold timings
#define PRESS_DELAY 300
#define HOLD_DELAY 150
#define DELAY_INCREMENT 10

void ioInit(void);
void sendBBstring(char* c);
void sendBBbyte(char d);
void t0init(void);
void initADC(void);
void deInitADC(void);
unsigned int getADC(char c);
unsigned int getVCC(void);  //in mV
unsigned int readNVM(unsigned int add);
unsigned int adjust(unsigned int v,unsigned int m);
char checkButtonLong(char n);
char checkButton(char n);
char buttonState(char n);
char anyButton(void);
char buttonPressAndHold(void);  //return repeats when held

#endif	/* IO_H */

