#include "io.h"

unsigned int adcref1,dacref1;
unsigned int adcref2,dacref2;
unsigned int adcref4,dacref4;

void ioInit(void){
    //unsigned char iflag;        //store INTCON
    ANSELA=0; //assume digital
    ANSELB=0;
    ANSELC=0;
    //switches
    trisbits.S1=1;
    trisbits.S2=1;
    trisbits.S3=1;
    trisbits.S4=1;
    trisbits.S_POWER=1;
    wpubits.S1=1;
    wpubits.S2=1;
    wpubits.S3=1;
    wpubits.S4=1;
    wpubits.S_POWER=1;
    //analog input pulled up, not floating
    wpubits.UNUSED_A0=1;
    wpubits.UNUSED_A1=1;    
    anselbits.UNUSED_A0=1;
    anselbits.UNUSED_A1=1;    
    //battery interface
    trisbits.POWERCON=0;    //output    
    latbits.POWERCON=0; //off
    trisbits.TESTCON=0; //output
    latbits.TESTCON=0;  //low
    //analog inputs/outputs
    anselbits.AUXSENSE=1;
    anselbits.BATSENSE=1;
    anselbits.CURCON=1;
    anselbits.VSHUNT=1;      
}

void sendBBstring(char* c){
    while(*c){
        sendBBbyte(*c++);
    }    
}

void sendBBbyte(char d){
    anselbits.BB_UART_PIN=0;
    latbits.BB_UART_PIN=1;  //idle hi
    trisbits.BB_UART_PIN=0; //output
    latbits.BB_UART_PIN=0;  //start
    __delay_us(1000000/BB_BAUD);
    if(d&1){latbits.BB_UART_PIN=1;}else{latbits.BB_UART_PIN=0;}
    __delay_us(1000000/BB_BAUD);
    if(d&2){latbits.BB_UART_PIN=1;}else{latbits.BB_UART_PIN=0;}
    __delay_us(1000000/BB_BAUD);
    if(d&4){latbits.BB_UART_PIN=1;}else{latbits.BB_UART_PIN=0;}
    __delay_us(1000000/BB_BAUD);
    if(d&8){latbits.BB_UART_PIN=1;}else{latbits.BB_UART_PIN=0;}
    __delay_us(1000000/BB_BAUD);
    if(d&16){latbits.BB_UART_PIN=1;}else{latbits.BB_UART_PIN=0;}
    __delay_us(1000000/BB_BAUD);
    if(d&32){latbits.BB_UART_PIN=1;}else{latbits.BB_UART_PIN=0;}
    __delay_us(1000000/BB_BAUD);
    if(d&64){latbits.BB_UART_PIN=1;}else{latbits.BB_UART_PIN=0;}
    __delay_us(1000000/BB_BAUD);
    if(d&128){latbits.BB_UART_PIN=1;}else{latbits.BB_UART_PIN=0;}
    __delay_us(1000000/BB_BAUD);
    latbits.BB_UART_PIN=1;  //stop
    __delay_us(1000000/BB_BAUD);
}

void t0init(void){
    //16bit
    T0CON0=0;               //reset, 8-bit, 1:1    
    T0CON0bits.MD16=1;      //16-bit, period is 65536
    T0CON1bits.CS=2;        //FOSC/4=8MHz
    T0CON1bits.ASYNC=1;     //ASYNC
    T0CON0bits.OUTPS=14;    //1:15   1:15*65536 => 8Hz
    T0CON1bits.T0CKPS=3;    //1:8 => 1Hz
    T0CON0bits.EN=1;        //on
    PIR0bits.TMR0IF=0;      //clear
    PIE0bits.TMR0IE=1;      //enable
/*
    //8bit
    T0CON0=0;               //reset, 8-bit, 1:1    
    T0CON1bits.CS=2;        //FOSC/4=8MHz
    T0CON1bits.ASYNC=1;     //ASYNC
    T0CON1bits.T0CKPS=7;    //1:128
    T0CON0bits.OUTPS=15;    //1:16
    TMR0H=255;              //full period
    T0CON0bits.EN=1;        //on
    PIR0bits.TMR0IF=0;      //clear
    PIE0bits.TMR0IE=1;      //enable
*/
}

void initADC(void){
    adcref1=readNVM(DIA_FVRA1X);
    dacref1=readNVM(DIA_FVRC1X);
    adcref2=readNVM(DIA_FVRA2X);
    dacref2=readNVM(DIA_FVRC2X);
    adcref4=readNVM(DIA_FVRA4X);
    dacref4=readNVM(DIA_FVRC4X);
    ADCON0=0;           //reset ADC, single ended
    ADCON1=0;
    ADCON2=0;           //legacy mode
    ADCON3=0;
    ADPRE=0;
    ADACQ=0;
    ADCAP=0;            //extra capacitance
    ADCON0bits.CS=1;    //ADCRC
    ADCON0bits.ADFM0=1; //right justify
    ADREF=ADREF_VDD;
    //ADREF=ADREF_FVR;        //switch reference
    ADCON0bits.ADON=1;  //turn on, ready
    //FVR set in main
}

void deInitADC(void){
    ADCON0=0;
    FVRCON=0;
}

unsigned int getADC(char c){
    ADPCH=c;
    ADCON0bits.GO=1;
    while(ADCON0bits.GO){}    
    return ADRES;
}

unsigned int getVCC(void){  //in mV
    unsigned long r;
    r=getADC(FVRBUF1);
    switch(FVRCONbits.ADFVR){
        case FVR_1V:
            if(r<(adcref4/8)){return 8192;}    //possible overflow/error
            return (unsigned int)(((unsigned long)adcref1)*(4096UL)/r);
            break;
        case FVR_2V:
            if(r<(adcref4/4)){return 8192;}    //possible overflow/error
            return (unsigned int)(((unsigned long)adcref2)*(4096UL)/r);
            break;            
        case FVR_4V:
            if(r<(adcref4/2)){return 8192;}    //possible overflow/error
            return (unsigned int)(((unsigned long)adcref4)*(4096UL)/r);
            break;
        default: break;   //won't work with other settings
    }
    return 0; 
}

unsigned int readNVM(unsigned int add){ //maps top bit to NVMREGS
    NVMREGS=0;
    if(add&0x8000){NVMREGS=1;}
    NVMADR=add;
    NVMCON1bits.RD=1;   //start read
    return NVMDAT;    
}

unsigned int adjust(unsigned int v,unsigned int m){
    unsigned long t;
    t=((unsigned long)v) * ((unsigned long)m);
    t=t/(4096UL);
    return (unsigned int)t;
}

char checkButtonLong(char n){   //check for press&hold ~1s
    unsigned char t=100;
    while(buttonState(n)&&t){        
        delay(10);
        t--;
    }
    if(t==0){
        OLEDclear(0);   //acknowledge long press
        while(buttonState(n)){} //wait for release
        delay(10);
        return 1;
    }
    return 0;        
}

char anyButton(void){
#ifdef S1
    if(PRESSED(S1)){return 1;}
#endif
#ifdef S2
    if(PRESSED(S2)){return 2;}
#endif
#ifdef S3
    if(PRESSED(S3)){return 3;}
#endif
#ifdef S4
    if(PRESSED(S4)){return 4;}
#endif
#ifdef S5
    if(PRESSED(S5)){return 5;}
#endif
#ifdef S6
    if(PRESSED(S6)){return 6;}
#endif
#ifdef S7
    if(PRESSED(S7)){return 7;}
#endif
#ifdef S8
    if(PRESSED(S8)){return 8;}
#endif
    return 0;    
}

char checkButton(char n){
    if(buttonState(n)){
        while(buttonState(n)){}
        delay(10); //debouncing
        return 1;
    }
    return 0;    
}

char buttonState(char n){
    switch(n){
#ifdef S1
        case 1: return PRESSED(S1); break;
#endif
#ifdef S2
        case 2: return PRESSED(S2); break;
#endif
#ifdef S3
        case 3: return PRESSED(S3); break;
#endif
#ifdef S4
        case 4: return PRESSED(S4); break;
#endif
#ifdef S5
        case 5: return PRESSED(S5); break;
#endif
#ifdef S6
        case 6: return PRESSED(S6); break;
#endif
#ifdef S7
        case 7: return PRESSED(S7); break;
#endif
#ifdef S8
        case 8: return PRESSED(S8); break;
#endif
    }
    return 0;
}

char buttonPressAndHold(void){  //return repeats when held
    char t;
    static char last=0;
    char now=anyButton();   //what is pressed?
    if(now==0){  //return immediately unless button pressed
        last=0;
        return 0;
    }else{
        if(last){
            t=HOLD_DELAY/DELAY_INCREMENT;
            while((t--)&&anyButton()){
                delay(DELAY_INCREMENT);
            }
            last=anyButton();
            if(last){
                return now;
            }else{
                return 0;   //stop double-skip on release after hold
            }            
        }else{
            t=PRESS_DELAY/DELAY_INCREMENT;
            while((t--)&&anyButton()){
                delay(DELAY_INCREMENT);
            }
            last=anyButton();
            return now;
        }        
    }    
}