//general utilities and settings framework

#ifndef UTIL_H
#define	UTIL_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "globalPins.h"
#include "portbits.h"
#include "io.h"
#include "oled.h"
#include "font.h"

#define REF_CHANGE_DELAY (100)
#define I_ADC_OS (8)
#define BATTERY_MIN (1000)
#define I_SHUNT_THRESH (250)
#define DAC_PROBE_MIN (190)
#define TEST_CURRENT_MAX (30)
#define TEST_CURRENT_MIN (1)
#define TEST_COUNT (10)
#define ERROR_R (65535)
#define PC_DROP_LOWER (1)
#define PC_DROP_UPPER (50)
#define VSCALE_MAX 50000
#define VSCALE_MIN 40000
#define VSCALE_INC 10
#define VAUXMIN_MIN 7000
#define VAUXMIN_MAX 14000
#define VAUXMIN_INC 100
#define I_CAL_MIN 20000
#define I_CAL_MAX 65500
#define I_CAL_INC 100
#define VBAT_MAX 30000
#define SOA_LIMIT 400
#define INT_RES_MIN 0
#define INT_RES_MAX 500
#define INT_RES_INC 1

//for settings
typedef struct {
    unsigned int iFullScale;    //mA at max, nominally 1.024V/shunt resistance
    unsigned int vBatScale;     //nominally 4096*divider ratio
    unsigned int vAuxScale;     //nominally 4096*divider ratio
    unsigned char iOffset;      //DAC output for 0 current setting (easiest found by trial)
    unsigned int iMax;          //mA at DAC=0 (estimate at 60000)
    unsigned char cdTime;       //in seconds
    unsigned char autoPowerOff; //based on timer
    unsigned char pcDrop;       //% drop in battery to detect
    unsigned int minVaux;       //autoshutoff if aux below this
    unsigned int intResistance; //intrinsic/internal resistance
} settings_t;

#define DEFAULT_SETTINGS .iFullScale=65500,.vBatScale=45060,.vAuxScale=45060,.iOffset=200,.iMax=45000,.cdTime=60,.autoPowerOff=0,.pcDrop=10,.minVaux=7000,.intResistance=0

typedef enum {
    BATTERY_OFF=0,
    BATTERY_AUX=1,
    BATTERY_EXT=2
} powerSource_t;

typedef enum {
    SCREEN_TEST=0,
    SCREEN_AUTOCAL, //iOffset
    SCREEN_INTRES, 
    SCREEN_TIMER,   //timer and auto off
    SCREEN_PERCENT,
    SCREEN_IMAX,
    SCREEN_ISCALE,
    SCREEN_VBAT,
    SCREEN_VAUX,
    SCREEN_VAUX_MIN,
    SCREEN_LOAD_DEFAULTS,
    SCREEN_DUMMY    //last, to loop around
} screenMode_t;

typedef enum {
    TEST_OK=0,
    TEST_VOLTAGE_LOW,
    TEST_CURRENT_HIGH,
    TEST_VAUXBAT_LOW,
    TEST_VOLTAGE_HIGH,
    TEST_VI_HIGH        //SOA exceeded
} scanResult_t;

extern unsigned int vcc,vbat,vaux;
extern unsigned int shuntI,v0,v1;
extern unsigned int intRes;  //calculcated .intResistance from most recent test
extern volatile unsigned char tmOut;
extern volatile unsigned char tFlag;
extern volatile unsigned char tFree;
extern volatile unsigned char cdTm;
extern __eeprom unsigned char maxCurrent;  //maximum test current
extern screenMode_t screen;
extern const char screenNames[][12];

extern const settings_t backupSettings;
//extern __eeprom settings_t savedSettings;
extern __eeprom settings_t cur;

extern powerSource_t psu;

unsigned int getShuntI(void);   //get shunt current
void getV(void);    //all the voltages, VCC, BATSENSE, AUXSENSE
scanResult_t runPulse(unsigned char dac);           //get current at dac
unsigned char runShuntScan(void);           //probe for threshold value
void resetTimer(void);
void testScreen(void);  //actions on TEST BATT screen
void waitForButtonOrT(unsigned int t);
void runTestAndDisplay(void);
void populateTestArray(unsigned char dac);  //fill tDac with suitable values
void showTestResult(unsigned char n,unsigned char i);
unsigned int getVdac(unsigned char dac, unsigned int ref);  //ie 8-bit=> 256<=>ref
unsigned char getPCdrop(unsigned int v0, unsigned int v1);  //calculate % drop from v0 to v1
unsigned int getResistance(unsigned int v0, unsigned int v1, unsigned int i); //expects mV/mA, gives mOhm
unsigned int adjustResistance(unsigned int r);  //remove offset
void checkForPowerOff(void);
void turnAuxPowerOff(void);
void waitForCooldown(void);

#endif	/* UTIL_H */

