; gear indicator

; CPU configuration
; 	
	list P=16F84
	#include "p16f84.inc"
	__config _XT_OSC & _WDT_OFF & _PWRTE_ON
; Gear ratio indicator

; Define variables at memory locations

; EEPROM DATA

; gear ratio (rpm/speed)

EEPROM1L	equ	H'0F'	; non-volatile storage for 1st gear LSB
EEPROM1		equ	H'10'	; non-volatile storage for 1st gear 
EEPROM2L	equ	H'11'	; non-volatile storage for 2nd gear LSB
EEPROM2		equ	H'12'	; non-volatile storage for 2nd gear 
EEPROM3L	equ	H'13'	; non-volatile storage for 3rd gear LSB
EEPROM3		equ	H'14'	; non-volatile storage for 3rd gear 
EEPROM4L	equ	H'15'	; non-volatile storage for 4th gear LSB
EEPROM4		equ	H'16'	; non-volatile storage for 4th gear  
EEPROM5L	equ	H'17'	; non-volatile storage for 5th gear LSB
EEPROM5		equ	H'18'	; non-volatile storage for 5th gear 
EEPROM6L	equ	H'19'	; non-volatile storage for 6th gear LSB
EEPROM6		equ	H'1A'	; non-volatile storage for 6th gear 
EEPROM7L	equ	H'1B'	; non-volatile storage for 7th gear LSB
EEPROM7		equ	H'1C'	; non-volatile storage for 7th gear  
EEPROM8L	equ	H'1D'	; non-volatile storage for 8th gear LSB
EEPROM8		equ	H'1E'	; non-volatile storage for 8th gear 
EEPROM9L	equ	H'1F'	; non-volatile storage for 9th gear LSB
EEPROM9		equ	H'20'	; non-volatile storage for 9th gear 

EEPROMS		equ	H'21'	; storage of number of speed pulses gating 
EEPROMH		equ	H'22'	; hysteresis of gear ratio 
EEPROMD		equ	H'23'	; delay before indicating next gear
EEPROMT		equ	H'24'	; timeout delay 
EEPROMR		equ	H'25'	; reverse polarity
EEPROMC		equ	H'26'	; clear eeprom

; RAM

DISP		equ	H'0C'	; working storage for Display value 
STATUS_TMP 	equ 	H'0D'	; temp storage for status during interrupt
W_TMP		equ	H'0E'	; temporary storage for w during interrupt
VALUE_1		equ 	H'0F'	; delay value storage			
VALUE_2		equ	H'10'	; delay value storage
FLAG_1		equ	H'12'	; bit0 program mode 
TEMP		equ	H'13'	; temporary storage 
TEMP_1		equ	H'14'	; temporary working storage
TEMP_2		equ	H'15'	; temp storage
PULSE_CNT	equ	H'16'   ; counter for tacho pulses 
PULSE_CT1	equ	H'17'	; counter for tacho pulses 
TACHO_0		equ	H'18'	; latched value for tachometer obtained from PULSE_CNT
TACHO_1		equ	H'19'	; latched value for tachometer obtained from pulse count
SPEED_CNT	equ	H'1A'	; speed pulses count 
B_INT		equ	H'1B'	; state of port B
B_INT1		equ	H'1C'	; new B values stored
INT_STO		equ	H'1D'	; temporary storage
B_STOR		equ     H'1E'	; temporary store 
SPEED		equ	H'1F'	; speed count gating value
GEAR		equ	H'20'	; gear number
GEAR_T		equ	H'21'	; gear tally number
GEAR_R		equ	H'22'	; gear run value	
DEL_GAP		equ	H'23'	; delay gap between gear display update 
HYSTER		equ	H'24'	; hysteresis value

START_FLG	equ	H'25'	; flag to start counting rpm pulses
TIME_CNT1	equ	H'26'	; time period counter
TIME_CNT2	equ	H'27'	; time period counter
TEMP_W		equ	H'28'	; store w in tacho comparison
TACHH_0		equ	H'29'	; tacho_0 value after hysteresis added
TACHH_1		equ	H'2A'	; tacho_1 value  
FLG_GR		equ	H'2B'	; gear flag
PARAM		equ	H'2C'	; parameter number
PRM_VAL		equ	H'2D'	; parameter value
GEAR_P		equ	H'2E'	; previous gear
DEL_CHG		equ	H'2F'	; delay between changes of gear indication
T_OUTD		equ	H'30'	; timeout delay
EXT_CNT		equ	H'31'	; extra counter to divide by 256
CNTR		equ	H'32'	; counter for clearing EEPROM

; math routines

AARGB2          equ     H'35'	; sum value
AARGB1          equ     H'36'	; sum value
AARGB0          equ     0x37
AARG            equ     0x37    ; most significant byte of argument A
BARGB1          equ     0x38
BARGB0          equ     0x39
BARG            equ     0x39    ; most significant byte of argument B
REMB1           equ     0x3A	; remainder	
REMB0           equ     0x3B    ; most significant byte of remainder
LOOPCOUNT       equ     0x3C    ; loop counter
STO1		equ	0x3D	; AARGB1 storage
STO2		equ	0x3E	; AARGB2 storage
TEMPD		equ	0x3F	; storage

; preprogram EEPROM DATA (00-3F from 2100-213F)
	
	ORG     210F			; start at 0F
	DE	H'FF', H'FF', H'FF'	; initial gear ratio value 
	DE	H'FF', H'FF', H'FF'	; from 1 to 9
	DE	H'FF', H'FF', H'FF'	; 
	DE	H'FF', H'FF', H'FF'
	DE	H'FF', H'FF', H'FF'	;  
	DE	H'FF', H'FF', H'FF'	; 
	
	DE	D'03'			; initial gating count (1-9) x 4
	DE	D'03'	  		; initial hysteresis (1-9)  2-20% 
	DE	D'02'			; delay between gear changes 1-9 delays (.1 to .9s)
	DE	D'05'			; timeout delay (1-9) x 8 = 0.5 to 4.5s
	DE	D'01'			; reverse indication high or low toggle
	DE	D'00'			; clear

; define reset and interrupt vector start addresses

	org	0	  	; start at address 0000h
	goto	MAIN		; normal service routines from Reset vector
	org     4		; interrupt vector 0004h, start interrupt routine here
	goto	INTRUPT		; go to start of interrupt routine, bypass subroutines

; subroutine to get seven segment display data.  
 
SVNSEG	andlw	0x0F		; remove most significant bits if present prevents value >16h
	addwf	PCL,f		; add value to program counter
	retlw 	B'00001000'	; 7-segment code 0 
	retlw 	B'10101110'	; 7-segment code 1
	retlw 	B'10000000'	; 7-segment code 2
	retlw 	B'10000100'	; 7-segment code 3
	retlw 	B'00100110'	; 7-segment code 4
	retlw 	B'00010100'	; 7-segment code 5
	retlw 	B'00010000'	; 7-segment code 6
	retlw 	B'10001110'	; 7-segment code 7
	retlw 	B'00000000'	; 7-segment code 8
	retlw 	B'00000100'	; 7-segment code 9
	retlw	B'10110110'	; code for a "-" Neutral
	retlw	B'00001010'	; code for "R" reverse

PAR_DSP	andlw	0x0F		; remove most significant bits if present prevents value >16h
	addwf	PCL,f		; add value to program counter
	retlw 	B'00010100'	; 7-segment code S 
	retlw 	B'01100010'	; 7-segment code H
	retlw 	B'11100000'	; 7-segment code d
	retlw 	B'10110110'	; 7-segment code -
	retlw 	B'00001010'	; 7-segment code R
	retlw	B'00011000'	; 7-segment code C for clear

PERCNT	addwf	PCL,f		; add to program counter
	retlw	D'50'		; get 2% or 1 in 50
	retlw	D'25'		; get 4% or 1 in 25
	retlw	D'16'		; 6% 
	retlw	D'12'		; 8%
	retlw	D'10'		; 10% 1 in 10
	retlw	D'8'		; 12% 
	retlw	D'7'		; 14%
	retlw	D'6'		; 17%
	retlw	D'5'		; 20% 1 in 5	

;******************************************************************************************* 

; INTERRUPT


; start interrupt by saving w and status registers before altered by interrupt routine

INTRUPT	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bcf	STATUS,RP0	; select bank 0

	btfss	INTCON,T0IF	; TMRO overflow interrupt flag 
	goto	PORT_CG

; timer

	bcf	INTCON,T0IF	; clear interrupt flag
				; timer every 4MHz/4/256/2 or 1953Hz (5125us)

	decfsz	EXT_CNT,f	; extra counter to divide interrupt timer by 256
	goto	PORT_CG
	movf	T_OUTD,w	; timeout value
	subwf	TIME_CNT1,w	; compare LS byte counter 
	btfss	STATUS,c	; skip if equal
	goto	INC_CT1		; increment time counters
	clrf	TIME_CNT1	; clear timer counter 
	clrf	SPEED_CNT	; clear speed count
	clrf	TACHO_0
	clrf	TACHO_1
	clrf	PULSE_CNT
	clrf	PULSE_CT1
	bcf	START_FLG,0	; start count flag cleared
	goto	PORT_CG		; goto port change?
INC_CT1 incf	TIME_CNT1,f	; increase counter 1 every 65.5ms 
		
; which change of level has occurred (RB6 or interrupt on RB0)
	
PORT_CG	btfss	INTCON,INTF
	goto	CK_6		; check portB,6
	bcf	INTCON,INTF	; clear flag

; increase pulse counters

	btfss	START_FLG,0	; begin on flag set ie on initial speed low pulse
	goto	CK_6
	incfsz	PULSE_CNT,f	; increase ls byte of rpm counter
	goto	CK_6		; check if bit 6 has changed
	incf	PULSE_CT1,f	; ms byte increased on overflow	
	
CK_6	btfss	PORTB,6		; level check
	bsf	START_FLG,0	; set start flag if low
	movf	B_INT,w		; previous port B levels
	movwf	B_INT1		; store
	movf	PORTB,w		; look at port B
	movwf	B_STOR		; store values
	movwf	B_INT		; new port B levels stored
	movf	B_INT1,w
	andlw	B'01000000'	; extract bit 6
	movwf	INT_STO
	movf	B_STOR,w
	andlw	B'01000000'	; extract bit 6
	xorwf	INT_STO,w	; check if same
	btfsc	STATUS,z
	goto	RECLAIM

; bit 6 changed so increase speed count. Reset if reached limit and store rpm count
	
	btfss	START_FLG,0	; if start flag set allow speed count
	goto	RECLAIM		; flag clear so bypass
	incf	SPEED_CNT,f	; increase speed count
	movf	SPEED_CNT,w
	subwf	SPEED,w 	; has it reached speed gating value yet
	btfsc	STATUS,c	; if c is zero then larger
	goto	RECLAIM		; not counted up to speed value yet
	clrf	SPEED_CNT	; clear speed count
	movf	PULSE_CNT,w	; rpm counter
	movwf	TACHO_0
	movf	PULSE_CT1,w	; rpm counter
	movwf	TACHO_1
	clrf	PULSE_CNT
	clrf	PULSE_CT1
	bcf	START_FLG,0	; start count flag cleared
	clrf	TIME_CNT1	; clear timer counter 
	
; end of interrupt reclaim w and status 

RECLAIM	swapf	STATUS_TMP,w	; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie			; return from interrupt

;********************************************************************************************** 
  
; RESET		
; Set ports A & B

MAIN	clrf	FLAG_1		; clear flags
	clrf	TIME_CNT1	; clear timer counter
	clrf	PULSE_CNT	; clear tacho pulse counter
	clrf	PULSE_CT1	; clear tacho pulse counter	
	clrf	TACHO_0		; tacho latched value
	clrf	TACHO_1		; tacho latched value
	clrf	SPEED_CNT	; speed pulses counter
	clrf	START_FLG	; flag to indicate to start counting rpm pulses	
	clrf	GEAR		; gear number
	clrf	GEAR_T		;
	incf	GEAR_T,f	; gear 1
	clrf	PARAM		; parameter
	bsf	STATUS,RP0	; select memory bank 1
	movlw	B'01000001'	; (RB1 - RB5,RB7 output, RB6,RB0 input)
	movwf	TRISB		; port B data direction register
	movlw	B'10000000'	; 
	movwf	OPTION_REG	; TMRO prescaler 2 division, PORTB pullups disabled
	movlw   B'00001101'	; (RA0, RA2, RA3 inputs, RA1 & RA4 output)
	movwf   TRISA		; A port data direction register
	bcf	STATUS,RP0	; select memory bank 0
	movlw	B'10111110'	; 
	movwf	PORTB		; portB outputs high
	movlw	B'00011111'
	movwf	PORTA		; portA outputs high
	movf	PORTB,w		; check portB inputs
	movwf	B_INT		; storage of levels

; check if parameters are to be changed

CK_P	btfsc	PORTA,2		; Check mode/parameter switch
	goto	FLG_P
	btfss	PORTA,3		; RA3 must be high if its the Mode switch
	goto	FLG_P
	btfsc	FLAG_1,0	; parameter mode 
	goto	N_PARAM		; next parameter
	bsf	FLAG_1,0
	bcf	PORTA,4		; decimal point on
	goto	D_PAR		; display parameter	
	
N_PARAM incf	PARAM,f
	movlw	0x06		; max 6 parameters
	subwf	PARAM,w		; 
	btfss	STATUS,c	; if c is 1 then clear
	goto	DISP_P		; display parameter
D_PAR	clrf	PARAM		; stop at 6
DISP_P	bsf	PORTA,1		; C segment off
	movlw	B'10111110'	; port B outputs high
	movwf	PORTB
	movf	PARAM,w		; parameter value
	call	PAR_DSP		; get seven segment display value
	movwf	PORTB		; drive segment
	movf	PARAM,w		; get param value
	sublw	0x02		; is it 3 or more
	btfsc	STATUS,c	; if zero then set RA1
	bcf	PORTA,1		; drive segment

	call	DELTME		; display parameter for short time
	call	DELTME
	call	DELTME
	call	DELTME		; display parameter for short time
	call	DELTME
	call	DELTME

; drive segment with parameter value
	
	movf	PARAM,w
	xorlw	0x05		; clear paramater value
	btfsc	STATUS,z	; stay with "C" displayed
	goto	CK_P
	bsf	PORTA,1		; C segment off
	movlw	B'10111110'	; port B outputs high
	movwf	PORTB
	movlw	EEPROMS		; address for number of speed pulses EEPROMS
	addwf	PARAM,w		; add to get parameter EEPROM address
	call	EEREAD
	movwf	PRM_VAL		; parameter value
	call	SVNSEG		; get seven segment display value
	movwf	PORTB		; drive segment
	movf	PRM_VAL,w	; get value
	xorlw	0x02		; is it 2
	btfss	STATUS,z	; if zero then set RA1
	bcf	PORTA,1		; drive segment 
	goto	CK_P
 
; check mode

FLG_P	btfss	FLAG_1,0	; if set then parameter mode
	goto 	NO_PRES		; switch not pressed so normal program run

; program mode

	btfsc	PORTA,3		; increase value switch
	goto	CK_P	   	; switch not pressed
	btfsc	PORTA,2		; if both RA inputs low then program
	goto	INC_PRM		; increase parameter value
	movf	PARAM,w
	xorlw	0x05		; clear paramater value
	btfsc	STATUS,z	; stay with "C" displayed
	goto	CLR_GR
	movlw	EEPROMS		; initial EEPROM address
	addwf	PARAM,w		; parameter EEPROM
	movwf	EEADR		; address to write to 
	
; write new option to EEPROM

	movf	PRM_VAL,w	; parameter value
	call	EWRITE		; write to EEPROM
	goto 	CK_P

; clear gear values by setting at FF

CLR_GR	movlw	D'18'		; 18 EEPROM locations
	movwf	CNTR
	movlw	EEPROM1L	; first gear EEPROM address
	movwf	EEADR
CLR_WR	movlw	0xFF		; max
	call	EWRITE		; clear EEPROM
	decfsz	CNTR,f
	goto	NXT_CLR		; next EEPROM to clear
	goto	CK_P
NXT_CLR	incf	EEADR,f
	goto	CLR_WR	
			
; Increase parameter value. 

INC_PRM	incf	PRM_VAL,f	; value increased
	movlw	D'10'		; check if over 9
	subwf	PRM_VAL,w	; if c is 0 then over
	btfss	STATUS,c
	goto	DISP_V
	clrf	PRM_VAL		; back to 1
	incf	PRM_VAL,f

; display parameter value
	
DISP_V	bsf	PORTA,1		; C segment off
	movlw	B'10111110'	; port B outputs high
	movwf	PORTB
	movf	PRM_VAL,w	; parameter value
	call	SVNSEG		; get seven segment display value
	movwf	PORTB		; drive segment
	movf	PRM_VAL,w	; get value
	xorlw	0x02		; is it 2
	btfss	STATUS,z	; if zero then set RA1
	bcf	PORTA,1		; drive segment
	call	DELTME
	call	DELTME
	call	DELTME
	call	DELTME		; display value for short time
	goto	CK_P
	
; get EEPROMS value (speed pulses gate value) and place in SPEED
	
NO_PRES	movlw	EEPROMS		; address for EEPROMS
	call	EEREAD		; read EEPROM storage
	movwf	SPEED		;
	rlf	SPEED,f		; x 2
	bcf	SPEED,0		; clear bit 0 from carry 	
	rlf	SPEED,f		; x 4
	bcf	SPEED,0		; clear bit 0 from carry 

; get hysteresis value

	movlw	EEPROMH		; address for hysteresis value in EEPROM 
	call	EEREAD		; read EEPROM storage
	call	PERCNT		; convert to percentage
	movwf	HYSTER		; hysteresis store
	
; get delay between gear change value
	
	movlw	EEPROMD		; delay between change value
	call 	EEREAD
	movwf	DEL_CHG		; stored

; get timeout delay value

	movlw	EEPROMT		; timeout value
	call	EEREAD
	movwf	T_OUTD
	rlf	T_OUTD,f	; x 2
	bcf	T_OUTD,0
	rlf	T_OUTD,f	; x 4
	bcf	T_OUTD,0

; allow interrupts

	bsf	INTCON,T0IE	; timer interrupt enabled
	bsf	INTCON,INTE	; RB0 interrupt enabled
	bsf	INTCON,GIE	; set global interrupt enable for above
	
; mode switch is it pressed. Toggle FLAG_1,0 if it is.

MODE	bcf	FLG_GR,0	; clear gear flag
	btfsc	PORTA,2		; Check mode switch
	goto	FLG_A
	btfss	PORTA,3		; RA3 must be high if its the Mode switch
	goto	FLG_A
	btfsc	FLAG_1,0	; program mode indication mode
	goto	CLEAR_0
	bsf	FLAG_1,0
	bcf	PORTA,4		; decimal point on
	clrf	GEAR		; back to gear 1
	clrf	GEAR_T		; 0
	incf	GEAR_T,f	; gear 1
	goto	DISP_GR	
	
CLEAR_0	bcf	FLAG_1,0
	bsf	PORTA,4		; decimal point off
	call	DELTME
	call	DELTME
	call	DELTME
	  
; check mode

FLG_A	btfss	FLAG_1,0	; if set then program mode
	goto 	RUN_MDE		; run mode showing gear selected

; program mode

	btfsc	PORTA,3		; gear switch
	goto	MODE	   	; switch not pressed
	btfsc	PORTA,2		; if both RA inputs low then program
	goto	INC_GR		; gear increase
	movlw	EEPROM1L	; initial EEPROM address
	addwf	GEAR,w		; gear value EEPROM
	movwf	EEADR		; address to write to 
	
; write new option to EEPROM

	movf	TACHO_0,w	; tacho value ls byte
	call	EWRITE		; write to EEPROM
	incf	EEADR,f
	movf	TACHO_1,w	; tacho value ms byte
	call 	EWRITE		; write to eprom
	call	DELTME
	call	DELTME
	call	DELTME
	goto 	MODE

; Increase gear value. GEAR increased by 2's so gear 1 is 0, gear 2 is 2, gear 3 is 4 etc.
; GEAR_T incresed by 1 from 1 so gear 1 is 1 gear 2 is 2 etc.

INC_GR	incf	GEAR,f		; value for memory address
	incf	GEAR,f		; gear value increased by 2
	incf	GEAR_T,f	; gear tally
	movlw	D'18'		; check if over 18
	subwf	GEAR,w		; if c is 0 then over
	btfss	STATUS,c
	goto	DISP_GR
	clrf	GEAR		; back to gear 1
	clrf	GEAR_T		; 0
	incf	GEAR_T,f	; back to gear 1

; display gear number
	
DISP_GR	bsf	PORTA,1		; C segment off
	movlw	B'10111110'	; port B outputs high
	movwf	PORTB
	movf	GEAR_T,w	; gear value
	call	SVNSEG		; get seven segment display value
	movwf	PORTB		; drive segment
	movf	GEAR_T,w	; get gear value
	xorlw	0x02		; is it 2
	btfss	STATUS,z	; if zero then set RA1
	bcf	PORTA,1		; drive segment
	call	DELTME
	call	DELTME
	call	DELTME
	goto	MODE
	
; check for reverse gear switch
	
RUN_MDE	movlw	EEPROMR		; reverse gear input polarity value
	call	EEREAD
	movwf	TEMP_2
	btfss	TEMP_2,0	; check if bit 0 high or low
	goto	EVEN		; even number
	btfss	PORTA,0		; odd polarity and check reverse input
	goto	TST_1
LOAD_R	bsf	PORTA,1		
	movlw	B'00001010'	; code for "R" reverse
	movwf	PORTB		; drive display
	goto	RUN_MDE		; cycle test of reverse till forward gear selected
EVEN	btfss	PORTA,0	
	goto	LOAD_R

TST_1	movlw	0x01
	movwf	GEAR_R		; gear value is 1	
	movlw	EEPROM1L	; initial ls byte address of rpm value in EEPROM
	call	EEREAD		; read value
	movwf	STO2		; ls gear (rpm) comparison value
	movlw	EEPROM1
	call	GR_CHNG		; find the correct gear

	btfsc	FLG_GR,0	; if gear flag set then bypass
	goto	MODE
	movlw	0x02
	movwf	GEAR_R		; gear value is 2	
	movlw	EEPROM2L	; initial ls byte address of rpm value in EEPROM
	call	EEREAD		; read value
	movwf	STO2		; ls gear (rpm) comparison value
	movlw	EEPROM2
	call	GR_CHNG		; find the correct gear

	btfsc	FLG_GR,0	; if gear flag set then bypass
	goto	MODE
	movlw	0x03
	movwf	GEAR_R		; gear value is 3	
	movlw	EEPROM3L	; initial ls byte address of rpm value in EEPROM
	call	EEREAD		; read value
	movwf	STO2		; ls gear (rpm) comparison value
	movlw	EEPROM3
	call	GR_CHNG		; find the correct gear

	btfsc	FLG_GR,0	; if gear flag set then bypass
	goto	MODE
	movlw	0x04
	movwf	GEAR_R		; gear value is 4	
	movlw	EEPROM4L	; initial ls byte address of rpm value in EEPROM
	call	EEREAD		; read value
	movwf	STO2		; ls gear (rpm) comparison value
	movlw	EEPROM4
	call	GR_CHNG		; find the correct gear

	btfsc	FLG_GR,0	; if gear flag set then bypass
	goto	MODE
	movlw	0x05
	movwf	GEAR_R		; gear value is 5	
	movlw	EEPROM5L	; initial ls byte address of rpm value in EEPROM
	call	EEREAD		; read value
	movwf	STO2		; ls gear (rpm) comparison value
	movlw	EEPROM5
	call	GR_CHNG		; find the correct gear

	btfsc	FLG_GR,0	; if gear flag set then bypass
	goto	MODE
	movlw	0x06
	movwf	GEAR_R		; gear value is 6	
	movlw	EEPROM6L	; initial ls byte address of rpm value in EEPROM
	call	EEREAD		; read value
	movwf	STO2		; ls gear (rpm) comparison value
	movlw	EEPROM6
	call	GR_CHNG		; find the correct gear

	btfsc	FLG_GR,0	; if gear flag set then bypass
	goto	MODE
	movlw	0x07
	movwf	GEAR_R		; gear value is 7	
	movlw	EEPROM7L	; initial ls byte address of rpm value in EEPROM
	call	EEREAD		; read value
	movwf	STO2		; ls gear (rpm) comparison value
	movlw	EEPROM7
	call	GR_CHNG		; find the correct gear

	btfsc	FLG_GR,0	; if gear flag set then bypass
	goto	MODE
	movlw	0x08
	movwf	GEAR_R		; gear value is 8	
	movlw	EEPROM8L	; initial ls byte address of rpm value in EEPROM
	call	EEREAD		; read value
	movwf	STO2		; ls gear (rpm) comparison value
	movlw	EEPROM8
	call	GR_CHNG		; find the correct gear

	btfsc	FLG_GR,0	; if gear flag set then bypass
	goto	MODE
	movlw	0x09
	movwf	GEAR_R		; gear value is 9	
	movlw	EEPROM9L	; initial ls byte address of rpm value in EEPROM
	call	EEREAD		; read value
	movwf	STO2		; ls gear (rpm) comparison value
	movlw	EEPROM9
	call	GR_CHNG		; find the correct gear
	goto	MODE

; add hysteresis value to TACHO
; check if tacho value is zero first

GR_CHNG	bcf	INTCON,GIE	; clear global interrupt enable
	movwf	TEMP_W		; store
	movf	TACHO_0,w	; check value
	movwf	TACHH_0		; store
	movf	TACHO_1,w
	movwf	TACHH_1
	bsf	INTCON,GIE	; set global interrupt enable
	btfss	STATUS,z	; if zero
	goto	CALL_RD
	movf	TACHH_0,w
	btfss	STATUS,z	
	goto	CALL_RD
DASH	movlw	B'10110110'	; both zero so dash in display
	movwf	PORTB
	bsf	PORTA,1		; RA1 high
	return

CALL_RD	movf	TACHH_1,w	; ms byte of tacho value
	movwf	AARGB1
	movf	TACHH_0,w	; ls byte of tacho value
	movwf	AARGB2
	clrf	AARGB0		; clear ms byte of numerator
	movf	HYSTER,w	; hysteresis value (percentage)
	movwf	BARGB1		; ls denominator
	clrf	BARGB0		; ms denominator
	call	DIVIDE		; get percentage of tacho value
	
; add percentage to TACHH

	movf	AARGB2,w	; add tacho ls byte to percentage
	addwf	TACHH_0,f 	; add lsb
	btfsc	STATUS,c	; add carry
	incf	TACHH_1,f 	; tacho ms byte increase
	movf	AARGB1,w 	; 
	addwf	TACHH_1,f 

	movf	TEMP_W,w	; retrieve w
	call	EEREAD
	movwf	STO1		; ms gear (rpm) comparison value
	
; check if tacho value larger than gear tacho value

	movf	STO1,w		; ms byte of result
	subwf	TACHH_1,w	; tacho value
	btfss	STATUS,c	; if c is 1 then tacho_1 is equal or larger
	return			; not this gear so check next gear
	btfss	STATUS,z	; if z is 0 then larger so it is this gear
	goto	THIS_GR		; this is the gear
	movf	STO2,w		; ls byte of result
	subwf	TACHH_0,w
	btfss	STATUS,c	; if c is 1 then tacho_0 is equal or larger
	return

; check if the same as last time if different wait till next time

THIS_GR	movf	GEAR_R,w
	xorwf	GEAR_P,w
	btfss	STATUS,z	; if same continue
	goto	DIF_GR		; new gear
	
	bsf	PORTA,1		; C segment off
	movlw	B'10111110'	; port B outputs high
	movwf	PORTB
	movf	GEAR_R,w	; gear value
	call	SVNSEG		; get seven segment display value
	movwf	PORTB		; drive segment
	movf	GEAR_R,w	; get gear value
	xorlw	0x02		; is it 2
	btfss	STATUS,z	; if zero (z=1) then set RA1
	bcf	PORTA,1		; drive segment
	bsf	FLG_GR,0	; set gear flag
	return

; add programmable delay for between gear changes 

DIF_GR	movf	DEL_CHG,w	; delay between gear changes value
	movwf	TEMP_1		; temporary storage
DEL_TM	movlw	D'125'
	call	DELTM1		; delay 100ms
	decfsz	TEMP_1,f	; decrease
	goto	DEL_TM	
	movf	GEAR_R,w	; current gear
	movwf	GEAR_P		; previous gear
	bsf	FLG_GR,0	; set gear flag
	return

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

; SUBROUTINES

; delay time for switch debounce period (200ms)

DELTME	movlw	D'250'		; set delay period 
DELTM1	movwf	VALUE_1		; VALUE_1 = w
	movlw	D'255'		; set delay period value 2 
LP_1	movwf	VALUE_2		; VALUE_2 = w
LP_2	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_2
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_1	
	return	

; subroutine to read EEPROM memory

EEREAD	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 1
	bsf	EECON1,RD	; read EEPROM
RD_RD	nop
	btfsc	EECON1,RD	; skip if RD low (read complete)
	goto 	RD_RD		; wait for low RD (read RD)	
	bcf	STATUS,RP0	; select bank 0
	movf	EEDATA,w	; EEPROM value in w
	return

; subroutine to write to EEPROM

EWRITE	movwf	EEDATA		; data register
	bcf	INTCON,GIE	; disable interrupts
	bsf	STATUS,RP0	; select bank 1
	bsf	EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf	EECON1,WR	; set WR bit and begin write sequence
	bcf	EECON1,WREN	; clear WREN bit
WRITE	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE		; not written yet
	bcf	EECON1,EEIF	; clear write interrupt flag 
	bcf	STATUS,RP0	; select bank 0
	bsf	INTCON,GIE	; enable interrupts
	return


; 24/16 Bit Unsigned Fixed Point Divide 

;       Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point divisor in BARGB0, BARGB1

;       Use:    CALL    FXD2416U

;       Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point remainder in REMB0, REMB1

;       Result: AARG, REM  <--  AARG / BARG

DIVIDE
FXD2416U        CLRF            REMB0
                CLRF            REMB1
                CLRF            TEMPD
                RLF             AARGB0,W
                RLF             REMB1, F
                MOVF            BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                RLF             AARGB0, F
                MOVLW           7
                MOVWF           LOOPCOUNT
LOOPU2416A      RLF             AARGB0,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46LA
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46LA
UADD46LA        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46LA 	RLF             AARGB0, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416A
                RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46L8
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46L8
UADD46L8        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46L8         RLF             AARGB1, F
                MOVLW           7
                MOVWF           LOOPCOUNT
LOOPU2416B      RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46LB
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46LB
UADD46LB        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46LB         RLF             AARGB1, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416B
                RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46L16
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46L16
UADD46L16       ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46L16        RLF             AARGB2, F
                MOVLW           7
                MOVWF           LOOPCOUNT
LOOPU2416C      RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB2,0
                GOTO            UADD46LC
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46LC
UADD46LC        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46LC 	RLF             AARGB2, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416C
                BTFSC           AARGB2,0
                GOTO            UOK46L
                MOVF            BARGB1,W
	        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,c
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
UOK46L		RETURN

; subroutine subtract (D_RSUB) AARGB1 AARGB2 - BARGB0 BARGB1 = AARGB
; or add (D_ADD)	

D_RSUB	call	NEG_A		; complement of A

D_ADD	movf	BARGB1,w 
	addwf	AARGB2,f 	; add lsb
	btfsc	STATUS,c	; add carry
	incf	AARGB1,f 
	movf	BARGB0,w 
	addwf	AARGB1,f 
	return

NEG_A	comf	BARGB1,f 
	incf	BARGB1,f 
	btfsc	STATUS,z
	decf	BARGB0,f 
	comf	BARGB0,f 
	return	


	end
