/* Generated by Edge Impulse
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
// Generated on: 21.02.2023 09:20:53

#include <stdio.h>
#include <stdlib.h>
#include "edge-impulse-sdk/tensorflow/lite/c/builtin_op_data.h"
#include "edge-impulse-sdk/tensorflow/lite/c/common.h"
#include "edge-impulse-sdk/tensorflow/lite/micro/micro_mutable_op_resolver.h"
#include "edge-impulse-sdk/porting/ei_classifier_porting.h"

#if EI_CLASSIFIER_PRINT_STATE
#if defined(__cplusplus) && EI_C_LINKAGE == 1
extern "C" {
    extern void ei_printf(const char *format, ...);
}
#else
extern void ei_printf(const char *format, ...);
#endif
#endif

#if defined __GNUC__
#define ALIGN(X) __attribute__((aligned(X)))
#elif defined _MSC_VER
#define ALIGN(X) __declspec(align(X))
#elif defined __TASKING__
#define ALIGN(X) __align(X)
#endif

#ifndef EI_MAX_SCRATCH_BUFFER_COUNT
#define EI_MAX_SCRATCH_BUFFER_COUNT 14
#endif // EI_MAX_SCRATCH_BUFFER_COUNT

#ifndef EI_MAX_OVERFLOW_BUFFER_COUNT
#define EI_MAX_OVERFLOW_BUFFER_COUNT 10
#endif // EI_MAX_OVERFLOW_BUFFER_COUNT

using namespace tflite;
using namespace tflite::ops;
using namespace tflite::ops::micro;

namespace {

constexpr int kTensorArenaSize = 637712;

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX)
#pragma Bss(".tensor_arena")
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#pragma Bss()
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16) __attribute__((section(".tensor_arena")));
#else
#define EI_CLASSIFIER_ALLOCATION_HEAP 1
uint8_t* tensor_arena = NULL;
#endif

static uint8_t* tensor_boundary;
static uint8_t* current_location;

template <int SZ, class T> struct TfArray {
  int sz; T elem[SZ];
};
enum used_operators_e {
  OP_CONV_2D, OP_DEPTHWISE_CONV_2D, OP_PAD, OP_ADD, OP_SOFTMAX,  OP_LAST
};
struct TensorInfo_t { // subset of TfLiteTensor used for initialization from constant memory
  TfLiteAllocationType allocation_type;
  TfLiteType type;
  void* data;
  TfLiteIntArray* dims;
  size_t bytes;
  TfLiteQuantization quantization;
};
struct NodeInfo_t { // subset of TfLiteNode used for initialization from constant memory
  struct TfLiteIntArray* inputs;
  struct TfLiteIntArray* outputs;
  void* builtin_data;
  used_operators_e used_op_index;
};

TfLiteContext ctx{};
TfLiteTensor tflTensors[71];
TfLiteEvalTensor tflEvalTensors[71];
TfLiteRegistration registrations[OP_LAST];
TfLiteNode tflNodes[27];

const TfArray<4, int> tensor_dimension0 = { 4, { 1,160,160,3 } };
const TfArray<1, float> quant0_scale = { 1, { 0.0039215688593685627, } };
const TfArray<1, int> quant0_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant0 = { (TfLiteFloatArray*)&quant0_scale, (TfLiteIntArray*)&quant0_zero, 0 };
const ALIGN(16) int32_t tensor_data1[4*2] = { 
  0, 0, 
  0, 1, 
  0, 1, 
  0, 0, 
};
const TfArray<2, int> tensor_dimension1 = { 2, { 4,2 } };
const ALIGN(16) int8_t tensor_data2[16*3*3*3] = { 
  /* [0][0][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [0][1][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [0][2][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [1][0][][] */ 46,-3,28, -5,-21,14, -127,-115,-68, 
  /* [1][1][][] */ 2,-5,-3, -22,2,-7, -5,-34,-1, 
  /* [1][2][][] */ -4,15,-4, -7,4,-6, 31,-26,4, 
  /* [2][0][][] */ 33,0,0, 76,115,6, 37,-39,7, 
  /* [2][1][][] */ 14,18,4, 68,127,-21, 18,-4,-5, 
  /* [2][2][][] */ 52,-59,24, 75,-37,-14, 31,-51,16, 
  /* [3][0][][] */ 7,34,5, 32,93,21, 1,6,-4, 
  /* [3][1][][] */ 21,37,7, 67,127,27, -12,-17,5, 
  /* [3][2][][] */ 6,3,4, 26,27,8, 0,-2,4, 
  /* [4][0][][] */ 33,63,-12, 5,69,-18, -16,9,-2, 
  /* [4][1][][] */ 42,80,46, 26,109,27, 33,54,-11, 
  /* [4][2][][] */ 63,84,47, 59,127,25, -12,33,30, 
  /* [5][0][][] */ 8,2,-121, 3,9,-95, -6,27,-28, 
  /* [5][1][][] */ 5,-40,-127, 4,-37,-108, -3,11,-25, 
  /* [5][2][][] */ -3,7,-21, 3,0,-12, -3,9,-15, 
  /* [6][0][][] */ 24,-63,34, 46,-88,38, 11,-18,11, 
  /* [6][1][][] */ 36,-95,61, 63,-127,70, 9,-26,19, 
  /* [6][2][][] */ 22,-33,14, 15,-43,26, -9,11,2, 
  /* [7][0][][] */ -29,20,7, -107,-37,3, -23,25,3, 
  /* [7][1][][] */ -12,-5,4, -127,-90,-4, -5,-3,7, 
  /* [7][2][][] */ -22,33,-5, -15,12,2, -20,27,0, 
  /* [8][0][][] */ 115,110,95, 90,82,63, 78,70,54, 
  /* [8][1][][] */ 119,114,100, 95,86,70, 82,74,57, 
  /* [8][2][][] */ 127,123,108, 99,87,67, 79,67,49, 
  /* [9][0][][] */ -21,-3,9, -11,-3,2, 6,6,-7, 
  /* [9][1][][] */ 97,116,-9, 73,127,13, -6,20,27, 
  /* [9][2][][] */ -28,-26,13, -1,-35,-4, 8,1,-22, 
  /* [10][0][][] */ -25,-84,-19, 33,94,20, -9,-13,-3, 
  /* [10][1][][] */ -60,-104,-14, 79,127,14, -17,-27,-1, 
  /* [10][2][][] */ -32,-20,2, 36,23,-11, -9,-1,7, 
  /* [11][0][][] */ -11,-23,2, 11,-40,7, 11,-97,-50, 
  /* [11][1][][] */ -41,-38,-15, -31,-59,-33, -11,-55,-50, 
  /* [11][2][][] */ -5,-36,-74, 118,127,65, -35,16,-43, 
  /* [12][0][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [12][1][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [12][2][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [13][0][][] */ -51,-97,-18, -61,-111,-25, -9,-18,-6, 
  /* [13][1][][] */ 62,114,15, 58,127,24, 7,15,11, 
  /* [13][2][][] */ -8,-19,3, 1,-19,-2, 0,4,-4, 
  /* [14][0][][] */ 45,-6,-37, 79,-26,-50, 33,-8,-19, 
  /* [14][1][][] */ 88,-17,-73, 127,-40,-88, 59,-18,-37, 
  /* [14][2][][] */ 55,-9,-45, 74,-22,-52, 25,-7,-18, 
  /* [15][0][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [15][1][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [15][2][][] */ 0,0,0, 0,0,0, 0,0,0, 
};
const TfArray<4, int> tensor_dimension2 = { 4, { 16,3,3,3 } };
const TfArray<16, float> quant2_scale = { 16, { 3.3410194077987398e-07, 0.048435144126415253, 0.056330882012844086, 0.012827393598854542, 0.0035849388223141432, 0.069948695600032806, 0.042901866137981415, 0.099083453416824341, 0.001486079185269773, 0.015727953985333443, 0.030703894793987274, 0.0033501433208584785, 2.9411381774480105e-07, 0.041542362421751022, 0.026841411367058754, 3.1706054670621597e-08, } };
const TfArray<16, int> quant2_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant2 = { (TfLiteFloatArray*)&quant2_scale, (TfLiteIntArray*)&quant2_zero, 0 };
const ALIGN(16) int32_t tensor_data3[16] = { -1073741824, 41552, -124481, -27908, 150280, 59183, 18278, 38853, -317714, -1098, 26936, 472652, -1073741824, 24172, 15708, -1073741824, };
const TfArray<1, int> tensor_dimension3 = { 1, { 16 } };
const TfArray<16, float> quant3_scale = { 16, { 1.3102037232926023e-09, 0.00018994175479747355, 0.00022090543643571436, 5.0303508032811806e-05, 1.4058584383747075e-05, 0.00027430863701738417, 0.00016824262274894863, 0.00038856259197928011, 5.8277619245927781e-06, 6.167825631564483e-05, 0.00012040743604302406, 1.3137817404640373e-05, 1.1533876076441629e-09, 0.00016291123756673187, 0.00010526044206926599, 1.243374708748135e-10, } };
const TfArray<16, int> quant3_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant3 = { (TfLiteFloatArray*)&quant3_scale, (TfLiteIntArray*)&quant3_zero, 0 };
const ALIGN(16) int8_t tensor_data4[1*3*3*16] = { 
  /* [0][0][][] */ -108,19,-82,-126,39,-67,80,-76,-90,-3,-8,29,-127,5,54,-73, 51,25,-127,127,127,-127,127,-127,-85,127,-127,51,-105,5,127,-25, 24,-24,91,-2,-72,66,-95,78,-95,-27,4,-16,61,1,-102,-29, 
  /* [0][1][][] */ -127,127,-22,13,-43,15,-29,14,-28,1,3,-109,-49,8,-30,-14, -78,-41,-58,-14,-7,-26,8,-27,-108,-89,21,-12,-104,-127,1,23, 14,1,65,2,3,33,-26,33,-127,6,-2,1,-21,12,-4,43, 
  /* [0][2][][] */ -115,-72,69,2,-6,38,-39,52,-76,0,0,4,40,2,-27,23, 23,-4,31,-2,-27,39,-34,21,-125,-13,0,84,-58,0,-29,-111, 21,-7,19,0,4,13,9,22,-115,4,-1,-127,107,3,17,-127, 
};
const TfArray<4, int> tensor_dimension4 = { 4, { 1,3,3,16 } };
const TfArray<16, float> quant4_scale = { 16, { 0.079427838325500488, 0.0043657748028635979, 0.032404471188783646, 0.013885990716516972, 0.0080463914200663567, 0.0015243503730744123, 0.018739739432930946, 0.0015584791544824839, 0.0011468271259218454, 0.01648026704788208, 0.010056743398308754, 0.038473464548587799, 0.030907778069376945, 0.010836591944098473, 0.0082519110292196274, 0.16606816649436951, } };
const TfArray<16, int> quant4_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant4 = { (TfLiteFloatArray*)&quant4_scale, (TfLiteIntArray*)&quant4_zero, 3 };
const ALIGN(16) int32_t tensor_data5[16] = { -161, 25403, 5272, 10737, 8697, 92516, 11755, 106123, -3431, 4392, 27239, 15874, -445, 25884, 10813, -107, };
const TfArray<1, int> tensor_dimension5 = { 1, { 16 } };
const TfArray<16, float> quant5_scale = { 16, { 0.0018688903655856848, 0.00010272411600453779, 0.00076245813397690654, 0.00032672920497134328, 0.00018932686361949891, 3.5867069527739659e-05, 0.00044093505130149424, 3.6670098779723048e-05, 2.6984167561749928e-05, 0.00038777099689468741, 0.00023662926105316728, 0.0009052579989656806, 0.00072724185883998871, 0.00025497862952761352, 0.0001941626105690375, 0.003907486330717802, } };
const TfArray<16, int> quant5_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant5 = { (TfLiteFloatArray*)&quant5_scale, (TfLiteIntArray*)&quant5_zero, 0 };
const ALIGN(16) int8_t tensor_data6[8*1*1*16] = { 
  /* [0][0][][] */ 0,-23,-1,2,120,-1,-1,0,-2,-127,-88,-4,0,115,-2,0, 
  /* [1][0][][] */ 0,-29,-3,84,70,11,24,4,-1,-9,127,-44,0,26,-11,0, 
  /* [2][0][][] */ 0,-1,-2,-12,-55,8,9,5,0,6,-17,4,0,127,-10,0, 
  /* [3][0][][] */ 0,-8,-22,-127,79,18,73,10,0,56,-1,44,0,-6,22,0, 
  /* [4][0][][] */ 0,48,-25,34,-53,34,127,12,1,-54,17,-13,0,-1,13,0, 
  /* [5][0][][] */ 0,-14,-11,0,-22,-23,-13,17,1,11,-4,-41,0,-4,127,0, 
  /* [6][0][][] */ 0,21,-6,5,49,-24,-24,-9,1,-110,112,62,0,127,58,0, 
  /* [7][0][][] */ 0,16,-15,127,4,-7,18,5,0,64,-54,78,0,-11,47,0, 
};
const TfArray<4, int> tensor_dimension6 = { 4, { 8,1,1,16 } };
const TfArray<8, float> quant6_scale = { 8, { 0.10226311534643173, 0.08815021812915802, 0.10616712272167206, 0.052545133978128433, 0.049191948026418686, 0.094418585300445557, 0.077697783708572388, 0.04805532842874527, } };
const TfArray<8, int> quant6_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant6 = { (TfLiteFloatArray*)&quant6_scale, (TfLiteIntArray*)&quant6_zero, 0 };
const ALIGN(16) int32_t tensor_data7[8] = { 255, -40812, -8897, -10428, -33425, -2886, -23662, -24899, };
const TfArray<1, int> tensor_dimension7 = { 1, { 8 } };
const TfArray<8, float> quant7_scale = { 8, { 0.0024061910808086395, 0.0020741228945553303, 0.0024980499874800444, 0.001236356096342206, 0.001157457591034472, 0.0022216138895601034, 0.0018281831871718168, 0.0011307136155664921, } };
const TfArray<8, int> quant7_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant7 = { (TfLiteFloatArray*)&quant7_scale, (TfLiteIntArray*)&quant7_zero, 0 };
const ALIGN(16) int8_t tensor_data8[48*1*1*8] = { 
  /* [0][0][][] */ 17,-127,49,-40,24,-20,-48,21, 
  /* [1][0][][] */ 69,67,-21,-98,17,-19,-83,127, 
  /* [2][0][][] */ 24,4,-45,121,58,127,49,95, 
  /* [3][0][][] */ 75,71,-88,127,-85,-4,-4,11, 
  /* [4][0][][] */ -37,-99,68,10,5,36,-38,-127, 
  /* [5][0][][] */ 19,2,-37,48,0,-32,38,127, 
  /* [6][0][][] */ 63,-13,-127,-95,120,23,46,-44, 
  /* [7][0][][] */ 127,24,21,-23,35,-6,84,-59, 
  /* [8][0][][] */ 16,-91,10,101,3,16,-6,-127, 
  /* [9][0][][] */ 110,-127,8,4,-18,10,-113,92, 
  /* [10][0][][] */ -127,-47,-122,21,-12,-2,-113,59, 
  /* [11][0][][] */ -21,-47,-9,-108,-127,-34,46,-16, 
  /* [12][0][][] */ 14,-1,-45,62,-74,-19,60,127, 
  /* [13][0][][] */ 0,0,0,0,0,0,0,0, 
  /* [14][0][][] */ -4,-34,-7,10,43,127,45,43, 
  /* [15][0][][] */ 35,4,17,-127,65,41,-54,64, 
  /* [16][0][][] */ 0,0,0,0,0,0,0,0, 
  /* [17][0][][] */ 14,20,127,24,-25,-6,28,23, 
  /* [18][0][][] */ 90,-127,25,36,-3,15,-118,2, 
  /* [19][0][][] */ -127,-1,32,71,-68,-57,-100,67, 
  /* [20][0][][] */ 35,26,-42,101,-16,-127,-5,57, 
  /* [21][0][][] */ 56,19,127,11,-15,-8,68,11, 
  /* [22][0][][] */ -77,-16,-127,4,5,13,-100,4, 
  /* [23][0][][] */ -94,127,-17,-16,11,-11,127,-72, 
  /* [24][0][][] */ 8,-55,-57,86,-2,-63,102,127, 
  /* [25][0][][] */ 17,42,46,39,123,127,-83,-53, 
  /* [26][0][][] */ -85,-33,-127,1,9,17,-93,-1, 
  /* [27][0][][] */ 0,-23,-29,3,-39,127,74,53, 
  /* [28][0][][] */ 3,-20,-17,45,22,127,52,60, 
  /* [29][0][][] */ 94,28,127,8,-26,-22,94,-8, 
  /* [30][0][][] */ -77,127,-28,-28,8,-4,100,-45, 
  /* [31][0][][] */ -40,-103,-13,5,25,-81,127,119, 
  /* [32][0][][] */ -1,4,-52,124,-14,109,91,127, 
  /* [33][0][][] */ 1,68,-9,-115,13,-17,-10,127, 
  /* [34][0][][] */ -24,90,-12,-94,32,-15,19,127, 
  /* [35][0][][] */ 127,14,-20,-45,31,31,103,-42, 
  /* [36][0][][] */ -127,-1,18,66,-40,12,-107,79, 
  /* [37][0][][] */ -4,-21,-7,30,28,127,56,57, 
  /* [38][0][][] */ 11,19,4,78,127,-10,-20,31, 
  /* [39][0][][] */ -1,26,38,-127,22,-2,-36,113, 
  /* [40][0][][] */ 101,31,127,5,-13,-14,92,-3, 
  /* [41][0][][] */ -1,-30,-31,81,56,127,71,104, 
  /* [42][0][][] */ -75,-4,127,22,-31,9,-30,59, 
  /* [43][0][][] */ -11,-54,7,98,-16,3,13,-127, 
  /* [44][0][][] */ 33,4,-60,-127,60,-39,-14,-103, 
  /* [45][0][][] */ -86,127,0,-46,16,-2,76,-58, 
  /* [46][0][][] */ -127,-20,42,28,-26,39,-86,43, 
  /* [47][0][][] */ 102,25,121,-3,29,-21,127,-18, 
};
const TfArray<4, int> tensor_dimension8 = { 4, { 48,1,1,8 } };
const TfArray<48, float> quant8_scale = { 48, { 0.00089792959624901414, 0.00084226310718804598, 0.00061904650647193193, 0.00056507292902097106, 0.00058715126942843199, 0.00061195885064080358, 0.00082082889275625348, 0.0027373135089874268, 0.00085561821470037103, 0.004358082078397274, 0.0011763300281018019, 0.0036928765475749969, 0.00036479945993050933, 3.937008052901092e-09, 0.0016738754929974675, 0.00035091032623313367, 3.937008052901092e-09, 0.013471862301230431, 0.00080766191240400076, 0.00073913374217227101, 0.00059115508338436484, 0.0090936291962862015, 0.00064848910551518202, 0.0029660232830792665, 0.0020976467058062553, 0.0012037546839565039, 0.0043603708036243916, 0.0037383739836513996, 0.00048979267012327909, 0.0031972147990018129, 0.0023871418088674545, 0.00032983647543005645, 0.00038598637911491096, 0.018770433962345123, 0.00097712338902056217, 0.0012166530359536409, 0.008715248666703701, 0.00063598994165658951, 0.0053821760229766369, 0.00055278040235862136, 0.0024305165279656649, 0.00034958191099576652, 0.0010443596402183175, 0.018097750842571259, 0.00079436978558078408, 0.0010172625770792365, 0.00057795830070972443, 0.00039558738353662193, } };
const TfArray<48, int> quant8_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant8 = { (TfLiteFloatArray*)&quant8_scale, (TfLiteIntArray*)&quant8_zero, 0 };
const ALIGN(16) int32_t tensor_data9[48] = { 3718, 87, 8161, 5374, 5390, 5462, 7426, -25, 13, -289, 1993, 378, 9668, -65945768, 2523, 14928, -53234848, -85, -467, 8353, 2926, -14, 14, 351, 2885, -732, 52, 533, 3754, 1462, 1979, 11367, 3138, 278, 223, -1557, 275, 3217, -110, 10111, 1866, 10151, -241, -70, 10105, 159, 7737, 3485, };
const TfArray<1, int> tensor_dimension9 = { 1, { 48 } };
const TfArray<48, float> quant9_scale = { 48, { 0.00056091381702572107, 0.0005261403857730329, 0.00038670265348628163, 0.00035298670991323888, 0.00036677849129773676, 0.00038227517507039011, 0.00051275099394842982, 0.0017099302494898438, 0.00053448299877345562, 0.0027223832439631224, 0.00073482352308928967, 0.0023068462032824755, 0.00022788096976000816, 2.4593489467150675e-09, 0.0010456275194883347, 0.00021920476865489036, 2.4593489467150675e-09, 0.0084155304357409477, 0.0005045259022153914, 0.00046171809663064778, 0.00036927958717569709, 0.0056805592030286789, 0.00040509467362426221, 0.0018527994398027658, 0.0013103466480970383, 0.00075195496901869774, 0.0027238130569458008, 0.002335267374292016, 0.00030596106080338359, 0.0019972189329564571, 0.0014911869075149298, 0.00020604048040695488, 0.00024111589300446212, 0.011725413613021374, 0.00061038415879011154, 0.00076001224806532264, 0.0054441946558654308, 0.00039728678530082107, 0.0033621087204664946, 0.00034530789707787335, 0.0015182819915935397, 0.00021837494568899274, 0.00065238494426012039, 0.011305205523967743, 0.00049622263759374619, 0.00063545809825882316, 0.00036103586899116635, 0.00024711340665817261, } };
const TfArray<48, int> quant9_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant9 = { (TfLiteFloatArray*)&quant9_scale, (TfLiteIntArray*)&quant9_zero, 0 };
const ALIGN(16) int8_t tensor_data10[1*3*3*48] = { 
  /* [0][0][][] */ -43,-23,-7,-16,7,-39,-79,-69,-27,-50,9,64,34,-71,114,-42,-113,-85,37,-6,0,-74,-111,-80,-34,-126,-64,-21,70,15,95,26,-127,-88,-7,54,18,48,-127,79,-76,-14,106,-108,-3,-35,-87,107, 75,11,-28,-28,58,-127,-127,-82,61,-76,-115,109,37,-82,-1,62,-52,-112,59,7,9,-111,-127,-71,-5,-127,-121,-40,-55,21,-57,54,27,-127,65,83,13,73,-91,127,-127,6,125,-127,2,-22,-127,95, -32,42,7,-5,-64,-109,-58,-18,87,-7,-127,38,8,-71,-101,-10,-127,-24,27,12,-15,-75,-36,-24,-11,-28,-58,-12,-11,17,-24,9,105,-87,70,32,14,37,-5,16,-78,3,7,-78,-17,6,-55,15, 
  /* [0][1][][] */ -86,-127,-44,-44,-9,54,99,-105,-26,-108,-20,111,90,-64,27,-96,-121,-93,90,-76,42,-90,-102,-127,42,-120,-78,-39,127,-60,127,84,-44,-84,-14,85,-35,-77,-107,90,42,59,104,-107,-91,-117,82,120, 127,-83,-127,-127,127,41,94,-127,101,-127,-111,127,127,-14,-6,127,-60,-127,127,-127,127,-127,-119,-120,127,-98,-127,-127,-120,-127,-71,127,27,-111,127,127,-68,-127,-96,90,60,127,127,-116,-112,-127,125,127, -53,30,-61,-85,-118,-23,31,-37,127,-20,-76,34,56,-70,-26,-42,-37,-29,54,-71,58,-80,-38,-24,48,-4,-46,-60,14,-89,-36,20,29,-98,117,23,-36,-61,1,-14,37,53,10,-74,-57,-37,66,37, 
  /* [0][2][][] */ -61,-107,-34,-35,1,35,-4,-35,-39,-58,-17,59,76,-127,-127,-63,-43,-19,64,74,53,-32,-13,-60,32,-55,-11,-59,75,29,78,63,107,-26,-38,-9,-96,35,-18,31,9,37,15,-54,96,-78,4,32, 87,-74,-88,-86,81,19,7,-47,48,-70,-31,56,82,-26,16,93,-24,-31,77,116,81,-53,-18,-58,93,-68,-19,-99,-51,39,-45,111,-19,-47,66,6,-127,51,-14,-1,10,32,15,-66,127,-100,-12,40, -29,29,-41,-37,-78,-19,23,-12,59,-5,-12,31,31,-43,110,-28,-93,-5,30,59,75,-30,-1,-3,43,2,-5,-63,-15,29,-20,39,-89,-43,65,3,-20,22,27,-38,7,35,-6,-14,63,-35,-4,18, 
};
const TfArray<4, int> tensor_dimension10 = { 4, { 1,3,3,48 } };
const TfArray<48, float> quant10_scale = { 48, { 0.0033430384937673807, 0.0028111496940255165, 0.0052756047807633877, 0.0045878742821514606, 0.0055262297391891479, 0.008141213096678257, 0.0069476496428251266, 0.0028352998197078705, 0.0029654593672603369, 0.0013153983745723963, 0.0037740098778158426, 0.0010932935401797295, 0.0078002610243856907, 0.23551659286022186, 0.0029354363214224577, 0.0077900425530970097, 0.1168077290058136, 0.00094077776884660125, 0.0028880462050437927, 0.0089719109237194061, 0.0046514696441590786, 0.0067943157628178596, 0.0055485609918832779, 0.0016577255446463823, 0.0041921348311007023, 0.0028146607801318169, 0.0014882410177960992, 0.0021443676669150591, 0.01428376417607069, 0.0023138930555433035, 0.0021300979424268007, 0.009280678816139698, 0.0077214236371219158, 0.00038864742964506149, 0.0032890881411731243, 0.0080416491255164146, 0.00071820238372310996, 0.018473166972398758, 0.0012900967849418521, 0.0034413798712193966, 0.0028953352011740208, 0.007280224934220314, 0.0049625528044998646, 0.00040601685759611428, 0.0093819275498390198, 0.0032266830094158649, 0.0099449651315808296, 0.0057104215957224369, } };
const TfArray<48, int> quant10_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant10 = { (TfLiteFloatArray*)&quant10_scale, (TfLiteIntArray*)&quant10_zero, 3 };
const ALIGN(16) int32_t tensor_data11[48] = { 76594, 59378, 63013, 43588, -234, 14271, 2010, 26016, 34037, 21724, 29470, 8501, -46763, -127, 36854, 28, -204, 37127, 4697, 1861, -15524, 11890, 45300, 38197, -23365, 40029, 40909, 19243, -2475, 14661, -7066, -51332, 13907, 118397, 31704, 1544, 55807, -732, 149214, -22954, 15461, -26704, 2305, 92800, -2168, 78723, 792, -22413, };
const TfArray<1, int> tensor_dimension11 = { 1, { 48 } };
const TfArray<48, float> quant11_scale = { 48, { 7.8659730206709355e-05, 6.6144697484560311e-05, 0.00012413188233040273, 0.00010794998524943367, 0.0001300289441132918, 0.00019155796326231211, 0.0001634741056477651, 6.6712935222312808e-05, 6.9775516749359667e-05, 3.095055217272602e-05, 8.8800232333596796e-05, 2.5724553779582493e-05, 0.00018353555060457438, 0.005541567225009203, 6.9069094024598598e-05, 0.00018329512386117131, 0.0027484172023832798, 2.2135947801871225e-05, 6.7954031692352146e-05, 0.00021110379020683467, 0.0001094463441404514, 0.00015986624930519611, 0.00013055438466835767, 3.9005306462058797e-05, 9.8638469353318214e-05, 6.6227315983269364e-05, 3.5017437767237425e-05, 5.0455710152164102e-05, 0.00033608858939260244, 5.4444542911369354e-05, 5.0119953812099993e-05, 0.00021836892119608819, 0.00018168055976275355, 9.1446454462129623e-06, 7.7390308433678001e-05, 0.00018921527953352779, 1.6898879039217718e-05, 0.00043466276838444173, 3.0355218768818304e-05, 8.0973644799087197e-05, 6.8125533289276063e-05, 0.0001712994126137346, 0.00011676595022436231, 9.5533378043910488e-06, 0.00022075124434195459, 7.5921954703517258e-05, 0.00023399917699862272, 0.00013436286826618016, } };
const TfArray<48, int> quant11_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant11 = { (TfLiteFloatArray*)&quant11_scale, (TfLiteIntArray*)&quant11_zero, 0 };
const ALIGN(16) int8_t tensor_data12[8*1*1*48] = { 
  /* [0][0][][] */ -10,1,10,-96,11,26,6,4,1,5,1,-4,101,0,2,4,0,-9,-8,3,81,-8,-3,7,29,41,14,11,5,4,4,-127,9,2,-1,5,-26,2,-16,34,11,-27,-11,6,4,0,5,1, 
  /* [1][0][][] */ -36,-6,-1,-4,41,24,-31,77,18,8,-30,-20,16,0,20,35,0,40,19,-49,3,20,127,19,-27,-2,54,3,21,-4,17,-6,12,-7,-9,-18,5,-49,10,4,-9,-7,-76,-5,-30,4,-47,-92, 
  /* [2][0][][] */ -58,15,2,14,41,-12,28,26,-9,55,7,-3,0,0,6,53,0,13,-127,27,-4,15,8,-13,-34,-1,38,8,9,28,23,3,5,-11,-12,-11,8,8,6,5,37,-9,-30,5,26,-57,25,18, 
  /* [3][0][][] */ 0,0,-3,7,-5,26,-2,-1,67,20,-5,-3,28,0,-27,-6,0,3,-9,-1,-3,4,4,-19,-14,-5,-13,-6,-8,-3,-3,-9,-53,47,-51,-3,8,0,2,-127,0,5,-2,-53,-3,-3,-4,3, 
  /* [4][0][][] */ 4,-3,80,30,4,-20,-2,-7,3,-2,-1,-7,-79,0,-13,3,0,9,4,2,65,2,2,-3,-17,32,-4,47,-9,-4,2,93,5,2,-2,-3,14,-10,-8,-18,-1,-127,3,5,1,-3,0,1, 
  /* [5][0][][] */ -7,43,5,-6,2,47,23,14,-21,28,6,55,23,0,-127,-1,0,14,-37,20,-13,11,-13,44,-23,-2,26,-3,-14,23,22,-18,50,27,-39,-3,2,21,-43,17,25,-14,-10,28,23,58,24,23, 
  /* [6][0][][] */ -23,-56,4,8,40,-48,-21,7,27,-24,-10,87,-8,0,-127,39,0,-10,47,-19,-7,2,26,-34,30,0,-4,-13,48,-13,-14,-7,91,-31,29,-4,0,-13,-71,-22,-11,-18,-4,-27,-22,-81,-22,-27, 
  /* [7][0][][] */ -113,-23,-12,11,127,18,65,30,13,6,24,-32,-32,0,90,104,0,16,-1,63,-18,2,-29,49,14,4,46,8,47,62,55,-9,-13,-16,-21,-26,7,26,29,34,77,2,-28,-10,61,6,65,79, 
};
const TfArray<4, int> tensor_dimension12 = { 4, { 8,1,1,48 } };
const TfArray<8, float> quant12_scale = { 8, { 0.056395754218101501, 0.027555055916309357, 0.060133509337902069, 0.05080687627196312, 0.045848578214645386, 0.049806684255599976, 0.033197920769453049, 0.029742073267698288, } };
const TfArray<8, int> quant12_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant12 = { (TfLiteFloatArray*)&quant12_scale, (TfLiteIntArray*)&quant12_zero, 0 };
const ALIGN(16) int32_t tensor_data13[8] = { -5726, -25671, 23894, 23436, 2423, 604, 38091, 9408, };
const TfArray<1, int> tensor_dimension13 = { 1, { 8 } };
const TfArray<8, float> quant13_scale = { 8, { 0.00132695899810642, 0.00064835429657250643, 0.0014149061171337962, 0.001195455901324749, 0.0010787900537252426, 0.001171921961940825, 0.00078112754272297025, 0.00069981347769498825, } };
const TfArray<8, int> quant13_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant13 = { (TfLiteFloatArray*)&quant13_scale, (TfLiteIntArray*)&quant13_zero, 0 };
const ALIGN(16) int8_t tensor_data14[48*1*1*8] = { 
  /* [0][0][][] */ 78,36,-9,-5,127,27,-55,-35, 
  /* [1][0][][] */ -5,-4,2,127,7,-15,-2,18, 
  /* [2][0][][] */ 20,-127,-19,46,-5,-69,78,11, 
  /* [3][0][][] */ 127,-31,-7,15,-9,-39,28,10, 
  /* [4][0][][] */ 7,-55,127,-17,-12,-50,13,-93, 
  /* [5][0][][] */ 77,-2,10,1,127,25,-23,-3, 
  /* [6][0][][] */ -22,94,-5,127,33,58,-75,-57, 
  /* [7][0][][] */ -5,127,-6,1,2,-14,14,-5, 
  /* [8][0][][] */ 127,46,-1,5,-43,-22,-3,-34, 
  /* [9][0][][] */ -127,26,0,13,44,9,-10,-6, 
  /* [10][0][][] */ -76,-5,15,127,40,29,-18,-1, 
  /* [11][0][][] */ -127,17,4,-69,44,3,-15,-48, 
  /* [12][0][][] */ 127,25,0,10,-42,-8,2,-43, 
  /* [13][0][][] */ -6,80,-127,-5,7,95,-75,72, 
  /* [14][0][][] */ -46,-14,-9,127,23,3,2,-29, 
  /* [15][0][][] */ -1,127,3,-3,2,-19,14,-49, 
  /* [16][0][][] */ -16,-127,-19,13,-13,-126,117,-29, 
  /* [17][0][][] */ 18,127,0,-10,10,81,-92,-18, 
  /* [18][0][][] */ -2,45,-127,-6,10,44,-26,61, 
  /* [19][0][][] */ -78,15,6,2,-127,13,11,26, 
  /* [20][0][][] */ -127,-11,-4,-1,76,-28,49,-14, 
  /* [21][0][][] */ -61,-7,-8,1,-127,-10,23,13, 
  /* [22][0][][] */ -127,-28,0,4,103,-8,47,52, 
  /* [23][0][][] */ -19,-27,-11,-5,-5,85,-127,-90, 
  /* [24][0][][] */ -10,42,-127,3,10,45,-19,75, 
  /* [25][0][][] */ 101,-36,3,127,-69,-5,-2,-55, 
  /* [26][0][][] */ 0,-23,-5,-1,-8,123,127,-27, 
  /* [27][0][][] */ 80,-6,-6,14,127,31,40,-22, 
  /* [28][0][][] */ -6,127,-66,8,3,78,-31,122, 
  /* [29][0][][] */ -8,16,-4,-11,-5,86,-127,-90, 
  /* [30][0][][] */ 0,-2,0,-127,-4,-3,0,-11, 
  /* [31][0][][] */ -70,10,7,1,-127,6,14,-1, 
  /* [32][0][][] */ -13,40,16,-127,1,42,-94,-115, 
  /* [33][0][][] */ -66,-3,-6,-3,-127,36,45,4, 
  /* [34][0][][] */ -127,85,5,23,44,-26,13,2, 
  /* [35][0][][] */ -11,127,-19,-1,-2,-89,66,-38, 
  /* [36][0][][] */ -4,41,9,-32,-1,109,-127,-22, 
  /* [37][0][][] */ 30,-59,-5,18,24,-127,107,-14, 
  /* [38][0][][] */ 21,-127,12,-1,14,59,-61,62, 
  /* [39][0][][] */ 10,-127,-14,-5,-7,-13,-50,-96, 
  /* [40][0][][] */ 98,38,15,-15,-28,65,-127,-80, 
  /* [41][0][][] */ 16,-120,24,-1,-3,94,-70,127, 
  /* [42][0][][] */ 47,-7,2,-127,-58,1,3,-30, 
  /* [43][0][][] */ -91,-25,7,-127,59,12,-19,-12, 
  /* [44][0][][] */ 1,-27,-5,15,-24,90,127,-11, 
  /* [45][0][][] */ -127,-49,0,5,16,18,22,-17, 
  /* [46][0][][] */ 10,95,127,-3,-3,5,16,25, 
  /* [47][0][][] */ -5,6,10,127,15,4,6,-7, 
};
const TfArray<4, int> tensor_dimension14 = { 4, { 48,1,1,8 } };
const TfArray<48, float> quant14_scale = { 48, { 0.00016383612819481641, 0.00074411288369446993, 0.0006567105301655829, 0.0011077005183324218, 0.0034556975588202477, 0.0013237085659056902, 0.0025281284470111132, 0.0026439533103257418, 0.00146841024979949, 0.0014727885136380792, 0.0018198451725766063, 0.0011568731861189008, 0.0012306277640163898, 0.0013748343335464597, 0.0015416373498737812, 0.004304954782128334, 0.00085534161189571023, 0.00097147707128897309, 0.0047350861132144928, 0.00026860451907850802, 0.00062831473769620061, 0.00096279784338548779, 0.00095461198361590505, 0.0023300836328417063, 0.00082281534560024738, 0.00048691706615500152, 0.00035902898525819182, 0.00095173483714461327, 0.0021794512867927551, 0.0024382846895605326, 0.0013392475666478276, 0.0010656825033947825, 0.002242265036329627, 0.00064672436565160751, 0.00077261513797566295, 0.00058845715830102563, 0.0012632819125428796, 0.0008543469593860209, 0.00023751780099701136, 0.0051227714866399765, 0.001646229880861938, 0.0023145040031522512, 0.0010974368778988719, 0.00093179487157613039, 0.00069954950595274568, 0.0011497825616970658, 0.0018777565564960241, 0.0024877323303371668, } };
const TfArray<48, int> quant14_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant14 = { (TfLiteFloatArray*)&quant14_scale, (TfLiteIntArray*)&quant14_zero, 0 };
const ALIGN(16) int32_t tensor_data15[48] = { 64079, 7414, 5796, 7035, 1580, 9186, -1838, -266, 936, 2205, 2952, 302, 1919, -825, 657, -2034, 4592, 10530, -273, 24432, 4648, 2511, 10143, -557, 3579, 5836, 27444, 9226, -65, -2593, 89, 1868, -2148, 8184, 3237, 7732, 7067, 3729, 23965, 2134, -822, 2919, 1037, 3858, 4056, 2253, -1470, 2587, };
const TfArray<1, int> tensor_dimension15 = { 1, { 48 } };
const TfArray<48, float> quant15_scale = { 48, { 6.7847999162040651e-05, 0.00030815284117124975, 0.00027195768780075014, 0.00045872214832343161, 0.0014310772530734539, 0.00054817565251141787, 0.0010469512781128287, 0.0010949168354272842, 0.00060809968272224069, 0.00060991279315203428, 0.00075363629730418324, 0.00047908557462505996, 0.00050962890964001417, 0.00056934787426143885, 0.0006384245352819562, 0.0017827725969254971, 0.00035421500797383487, 0.00040230914601124823, 0.0019608989823609591, 0.00011123479634989053, 0.00026019837241619825, 0.00039871488115750253, 0.00039532495429739356, 0.00096493680030107498, 0.00034074520226567984, 0.00020164262969046831, 0.0001486814726376906, 0.00039413347258232534, 0.00090255675604566932, 0.001009745174087584, 0.00055461068404838443, 0.00044132160837762058, 0.00092856923583894968, 0.00026782220811583102, 0.00031995621975511312, 0.0002436925278743729, 0.00052315171342343092, 0.00035380310146138072, 9.8361131676938385e-05, 0.0021214478183537722, 0.00068173854378983378, 0.00095848494675010443, 0.00045447176671586931, 0.0003858759009744972, 0.00028969821869395673, 0.00047614920185878873, 0.00077761861030012369, 0.0010302223963662982, } };
const TfArray<48, int> quant15_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant15 = { (TfLiteFloatArray*)&quant15_scale, (TfLiteIntArray*)&quant15_zero, 0 };
const ALIGN(16) int8_t tensor_data16[1*3*3*48] = { 
  /* [0][0][][] */ 5,-4,20,109,4,81,-1,28,16,8,10,8,-8,-9,-45,9,-2,8,-23,-114,-7,-22,127,-10,-2,7,-5,9,-5,5,15,99,20,29,39,-28,1,35,-2,1,18,-68,-8,-8,17,2,-7,-10, 127,10,14,-127,28,86,10,10,124,127,8,44,-50,-24,5,8,127,-56,-60,-57,-101,25,-110,15,17,72,-31,-84,23,21,10,-123,5,-60,127,10,-40,-47,-6,115,-79,-99,-29,3,-34,-8,-127,23, -32,-3,7,14,-1,64,4,17,27,8,-13,31,-14,-3,15,4,-103,29,-3,78,-31,-11,-18,-6,-4,-60,-3,29,-17,5,4,-21,8,-24,16,-19,0,47,41,-13,50,39,-15,12,-43,3,-2,-6, 
  /* [0][1][][] */ 125,6,1,-98,14,-26,34,-16,10,9,-12,54,-6,-1,18,-33,0,-50,-60,-86,10,-73,-125,-18,5,100,-15,-127,-9,33,12,-107,17,-53,-2,127,-3,59,-41,41,-62,-127,39,-88,-44,-14,-12,-5, 26,-127,-127,114,-127,-127,-127,-127,-127,-96,127,-127,127,127,34,-127,-82,127,127,-107,127,127,112,127,127,-127,-127,29,-127,-127,94,127,-127,127,-29,-42,127,-127,127,127,127,-79,127,127,127,-122,102,107, 53,5,49,-13,5,-61,44,18,-24,14,-104,-8,1,-40,127,4,63,-66,-71,86,14,-46,11,-33,1,6,-38,68,20,40,1,3,33,-44,9,67,-5,64,68,-10,-82,9,-84,-31,27,-16,-11,5, 
  /* [0][2][][] */ -53,-7,25,-17,7,35,-37,22,9,-24,12,32,6,-6,-39,18,4,22,-14,106,5,-32,-16,-13,-3,23,0,50,-10,3,47,-31,-18,-44,-32,-40,-1,31,9,-23,10,-5,42,-37,-36,18,-10,18, 68,125,75,21,17,-20,123,35,18,-4,44,26,-5,-1,-91,24,-58,-56,-36,123,-37,49,11,19,32,-63,-40,29,76,1,127,22,85,-26,7,-36,-25,-17,-12,118,-27,-13,-40,45,21,-32,8,-127, -42,-4,7,-3,5,-6,-61,8,-19,-11,-39,-40,20,-9,-9,11,33,24,-8,-127,24,-11,4,-9,-6,9,-11,-55,-15,8,6,9,-20,87,-37,-23,-4,36,25,-61,4,8,-37,7,-43,127,-5,-4, 
};
const TfArray<4, int> tensor_dimension16 = { 4, { 1,3,3,48 } };
const TfArray<48, float> quant16_scale = { 48, { 0.016350474208593369, 0.014979308471083641, 0.0080206030979752541, 0.014094649814069271, 0.0072446456179022789, 0.0048825787380337715, 0.033578082919120789, 0.0065876287408173084, 0.0072502642869949341, 0.010232096537947655, 0.0037228695582598448, 0.0075046340934932232, 0.013346324674785137, 0.0069565447047352791, 0.0037535401061177254, 0.009347137063741684, 0.0099512478336691856, 0.010960828512907028, 0.0032634076196700335, 0.0081964666023850441, 0.015007927082479, 0.0076501811854541302, 0.011217221617698669, 0.0079175056889653206, 0.0065605873242020607, 0.0069002667441964149, 0.026916222646832466, 0.0044867927208542824, 0.0085062934085726738, 0.061209734529256821, 0.0038869509007781744, 0.0077545675449073315, 0.056569993495941162, 0.0068981111980974674, 0.0093399463221430779, 0.0087938131764531136, 0.017486006021499634, 0.005953631829470396, 0.012389098294079304, 0.00090808933600783348, 0.010797768831253052, 0.0024320529773831367, 0.0062071341089904308, 0.0064841471612453461, 0.0072344578802585602, 0.0049921674653887749, 0.012054095976054668, 0.0057043940760195255, } };
const TfArray<48, int> quant16_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant16 = { (TfLiteFloatArray*)&quant16_scale, (TfLiteIntArray*)&quant16_zero, 3 };
const ALIGN(16) int32_t tensor_data17[48] = { -52532, -128, 8095, -97, 5577, -5728, 1528, 22499, 1253, 19539, -2499, 24438, -6352, -1207, 28619, 7150, 531, 15985, 30273, 11558, 74, -198, 686, 11705, -8065, 22613, 46806, 32661, 3442, 550, -828, 1073, 644, 17825, -6616, 11747, -10773, 17752, -22693, 116923, 12857, 23422, 11129, -1468, 14188, 3195, 1058, 49, };
const TfArray<1, int> tensor_dimension17 = { 1, { 48 } };
const TfArray<48, float> quant17_scale = { 48, { 0.00038471704465337098, 0.00035245431354269385, 0.00018872007785830647, 0.00033163881744258106, 0.00017046225548256189, 0.00011488420568639413, 0.00079007254680618644, 0.00015500302833970636, 0.0001705944596324116, 0.00024075522378552705, 8.7596934463363141e-05, 0.00017657963326200843, 0.00031403117463923991, 0.0001636834058444947, 8.831859304336831e-05, 0.00021993264090269804, 0.00023414700990542769, 0.00025790184736251831, 7.678606198169291e-05, 0.00019285804592072964, 0.0003531276888679713, 0.00018000426643993706, 0.00026393463485874236, 0.00018629425903782248, 0.00015436676039826125, 0.000162359225214459, 0.00063332292484119534, 0.00010557159839663655, 0.00020014808978885412, 0.0014402291271835566, 9.1457666712813079e-05, 0.00018246041145175695, 0.0013310586800798774, 0.00016230849723797292, 0.00021976344578433782, 0.00020691326062660664, 0.00041143543785437942, 0.00014008545258548111, 0.00029150821501389146, 2.1366808141465299e-05, 0.00025406514760106802, 5.7224777265219018e-05, 0.00014605022442992777, 0.00015256817277986556, 0.000170222541783005, 0.00011746276868507266, 0.00028362579178065062, 0.00013422104530036449, } };
const TfArray<48, int> quant17_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant17 = { (TfLiteFloatArray*)&quant17_scale, (TfLiteIntArray*)&quant17_zero, 0 };
const ALIGN(16) int8_t tensor_data18[8*1*1*48] = { 
  /* [0][0][][] */ -42,-7,-34,12,4,-23,1,11,-108,127,-36,106,106,5,64,-17,-7,-35,0,6,-8,-6,-19,-33,20,-90,13,61,-14,23,17,-39,3,-75,108,29,-1,-4,-7,-17,107,-7,39,-21,-28,14,-24,-22, 
  /* [1][0][][] */ -3,34,127,2,-9,-19,2,-84,34,2,19,8,-25,9,-1,-126,9,-66,10,2,-26,36,23,-41,-19,-11,20,3,17,2,12,2,-6,12,22,16,-19,-38,70,-58,10,50,-8,25,-17,11,22,-4, 
  /* [2][0][][] */ 4,-52,18,-41,35,26,-6,-30,7,-1,-2,15,-13,60,6,-3,-42,127,-26,-33,-14,24,-40,-9,124,2,0,-8,-29,-13,2,-43,-9,-14,1,10,-11,0,-15,7,12,-22,-21,0,-1,28,-27,-41, 
  /* [3][0][][] */ -7,-81,-1,7,7,-2,-8,-1,-5,-8,19,19,12,-8,47,1,-9,-24,1,21,-6,23,-21,-2,9,50,-4,6,-9,3,127,1,14,6,0,-2,-24,-15,-12,7,-6,9,-10,30,-7,5,0,30, 
  /* [4][0][][] */ -97,12,6,6,-2,-38,-3,12,39,-40,21,-19,-34,0,-16,-5,5,11,7,30,7,-34,14,6,-10,45,4,114,3,2,-10,-29,-2,-127,-32,11,6,-5,3,0,-54,-14,-16,17,-56,-1,6,4, 
  /* [5][0][][] */ -27,25,15,1,-45,20,-3,44,25,6,8,10,-13,-43,7,34,-5,-86,18,7,45,-41,6,36,9,3,-75,-41,-35,-29,20,4,-1,-61,3,-55,58,9,-37,14,29,-40,3,3,127,-11,-41,-10, 
  /* [6][0][][] */ -30,-21,-8,-4,37,-31,-2,-26,-13,-7,37,-21,-8,38,-6,-56,1,9,0,-26,-41,49,-7,-72,1,-6,-60,-67,23,43,-17,4,6,-63,-18,65,-66,-48,5,-59,-8,4,10,44,127,-34,42,16, 
  /* [7][0][][] */ 8,33,-72,29,-21,16,8,54,-10,-4,65,-35,5,-34,-13,-4,-17,-127,38,-40,61,38,17,-55,18,-17,16,5,-18,31,-13,8,-1,36,-8,-27,-11,-55,-38,-66,-9,-31,36,66,-33,-21,0,-1, 
};
const TfArray<4, int> tensor_dimension18 = { 4, { 8,1,1,48 } };
const TfArray<8, float> quant18_scale = { 8, { 0.024000043049454689, 0.02798881009221077, 0.058564756065607071, 0.069915726780891418, 0.033947166055440903, 0.026695879176259041, 0.030696872621774673, 0.047600872814655304, } };
const TfArray<8, int> quant18_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant18 = { (TfLiteFloatArray*)&quant18_scale, (TfLiteIntArray*)&quant18_zero, 0 };
const ALIGN(16) int32_t tensor_data19[8] = { -40575, 27111, -11704, -11294, 18180, -5227, 31425, 44526, };
const TfArray<1, int> tensor_dimension19 = { 1, { 8 } };
const TfArray<8, float> quant19_scale = { 8, { 0.00056470691924914718, 0.00065856025321409106, 0.00137799431104213, 0.0016450759721919894, 0.00079875683877617121, 0.0006281383684836328, 0.00072227936470881104, 0.0011200205190107226, } };
const TfArray<8, int> quant19_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant19 = { (TfLiteFloatArray*)&quant19_scale, (TfLiteIntArray*)&quant19_zero, 0 };
const ALIGN(16) int8_t tensor_data20[48*1*1*8] = { 
  /* [0][0][][] */ -127,3,-2,79,-41,45,26,-31, 
  /* [1][0][][] */ 33,79,58,26,16,-46,117,127, 
  /* [2][0][][] */ -43,-6,-9,-2,-127,-10,9,7, 
  /* [3][0][][] */ 87,-10,-14,-112,-127,26,26,-27, 
  /* [4][0][][] */ -127,36,-17,-14,73,-4,33,11, 
  /* [5][0][][] */ -112,-30,19,-6,-127,9,7,82, 
  /* [6][0][][] */ -22,-127,33,-19,20,0,1,30, 
  /* [7][0][][] */ -70,-8,4,104,127,-33,-33,11, 
  /* [8][0][][] */ 72,-5,4,-127,1,-18,-52,-41, 
  /* [9][0][][] */ -8,-127,-11,-11,-3,96,-59,75, 
  /* [10][0][][] */ -99,-7,1,24,-127,73,67,-15, 
  /* [11][0][][] */ 117,14,44,12,-56,-49,-30,-127, 
  /* [12][0][][] */ -4,11,38,-4,14,-78,127,62, 
  /* [13][0][][] */ 60,-23,-6,-25,116,127,107,-43, 
  /* [14][0][][] */ 127,37,-22,21,-89,-18,-26,-6, 
  /* [15][0][][] */ -17,-127,24,-15,6,4,1,29, 
  /* [16][0][][] */ -45,-14,3,-5,-127,0,8,0, 
  /* [17][0][][] */ -30,107,-119,-6,16,-127,105,-94, 
  /* [18][0][][] */ 127,-30,-41,12,-58,29,11,104, 
  /* [19][0][][] */ 127,-35,-19,-5,32,0,23,-1, 
  /* [20][0][][] */ 117,32,-10,127,-5,33,7,-51, 
  /* [21][0][][] */ 2,32,-54,6,-11,102,-127,-88, 
  /* [22][0][][] */ -127,29,32,2,-40,-7,-55,-22, 
  /* [23][0][][] */ -42,-53,3,24,-127,63,79,-13, 
  /* [24][0][][] */ 127,-11,-9,-6,-98,-3,-4,2, 
  /* [25][0][][] */ 29,-14,-1,-30,127,58,52,-34, 
  /* [26][0][][] */ 4,-93,9,-35,5,-127,77,-50, 
  /* [27][0][][] */ -17,-127,26,-13,-3,-54,32,-6, 
  /* [28][0][][] */ -93,26,-24,16,-10,-34,127,97, 
  /* [29][0][][] */ -10,37,13,6,-4,41,-110,-127, 
  /* [30][0][][] */ 127,-32,-17,-2,-78,14,-51,-26, 
  /* [31][0][][] */ -11,-22,74,-18,20,-121,127,61, 
  /* [32][0][][] */ -78,30,9,16,-127,-106,-97,56, 
  /* [33][0][][] */ -25,15,0,26,-127,-61,-45,21, 
  /* [34][0][][] */ 5,-127,52,-5,-3,83,-71,65, 
  /* [35][0][][] */ -21,-51,-127,-9,-3,-69,45,-53, 
  /* [36][0][][] */ 7,127,59,7,-9,10,-23,-41, 
  /* [37][0][][] */ -127,30,34,-13,61,-34,-7,-103, 
  /* [38][0][][] */ -127,-18,-50,-9,37,24,31,105, 
  /* [39][0][][] */ 6,-27,73,-6,14,-85,127,88, 
  /* [40][0][][] */ -30,-20,-15,-40,-127,117,119,-31, 
  /* [41][0][][] */ -127,53,7,-76,-107,-98,-106,50, 
  /* [42][0][][] */ -37,-123,-110,1,-18,68,-127,-83, 
  /* [43][0][][] */ -76,5,-12,-127,106,63,68,-1, 
  /* [44][0][][] */ 127,-13,14,-92,29,-26,-15,38, 
  /* [45][0][][] */ -21,-127,-7,-9,-13,-69,73,8, 
  /* [46][0][][] */ 108,-4,-8,-25,127,-30,-31,7, 
  /* [47][0][][] */ 127,5,5,116,-8,22,20,-40, 
};
const TfArray<4, int> tensor_dimension20 = { 4, { 48,1,1,8 } };
const TfArray<48, float> quant20_scale = { 48, { 0.00072691857349127531, 0.0013232959900051355, 0.00049911520909518003, 0.00057631381787359715, 0.00043038319563493133, 0.00044759802403859794, 0.00094584946054965258, 0.00044906049151904881, 0.00068306631874293089, 0.0012994121061637998, 0.0016937172040343285, 0.0005308566614985466, 0.0007062393706291914, 0.0013237346429377794, 0.00025914711295627058, 0.00087225431343540549, 0.00049561960622668266, 0.00063628127099946141, 0.00045349352876655757, 0.00059046095702797174, 0.00073874840745702386, 0.00043053505942225456, 0.00081439514178782701, 0.00028433318948373199, 0.00050323858158662915, 0.00048951496137306094, 0.0036481439601629972, 0.0009282901301048696, 0.00036007596645504236, 0.00088562490418553352, 0.00048141906154341996, 0.00036306175752542913, 0.0012830337509512901, 0.00045180125744082034, 0.001390863792039454, 0.0011776884784922004, 0.0015203261282294989, 0.00066873087780550122, 0.00045269218389876187, 0.0006622165092267096, 0.00031427314388565719, 0.00048413954209536314, 0.00052764418069273233, 0.00046915700659155846, 0.0038739379961043596, 0.00089695851784199476, 0.00060868158470839262, 0.0023539792746305466, } };
const TfArray<48, int> quant20_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant20 = { (TfLiteFloatArray*)&quant20_scale, (TfLiteIntArray*)&quant20_zero, 0 };
const ALIGN(16) int32_t tensor_data21[48] = { 517, 762, 1653, 400, 7376, 13173, 1683, -71, -571, -483, 859, 870, 2595, 839, 20413, 2095, 1502, -913, -231, 2277, -1118, 8625, 6646, 8154, 4681, 317, 2768, 2936, 7122, -343, 7788, 4815, 436, -136, 3906, 2230, -1316, 162, -553, 4073, 800, -460, -807, 58, 730, 2202, 561, 724, };
const TfArray<1, int> tensor_dimension21 = { 1, { 48 } };
const TfArray<48, float> quant21_scale = { 48, { 0.00049986090743914247, 0.00090995599748566747, 0.00034321338171139359, 0.00039629850653000176, 0.00029595024534501135, 0.00030778790824115276, 0.00065040733898058534, 0.00030879356199875474, 0.00046970616676844656, 0.00089353241492062807, 0.0011646738275885582, 0.00036504017771221697, 0.00048564097960479558, 0.00091025762958452106, 0.00017820084758568555, 0.00059980008518323302, 0.00034080963814631104, 0.00043753473437391222, 0.00031184192630462348, 0.00040602669469080865, 0.00050799560267478228, 0.00029605466988869011, 0.00056001357734203339, 0.00019551989680621773, 0.00034604879328981042, 0.0003366118180565536, 0.0025086228270083666, 0.00063833274180069566, 0.0002476039226166904, 0.00060899427626281977, 0.00033104472095146775, 0.00024965708144009113, 0.00088226993102580309, 0.00031067823874764144, 0.00095641857478767633, 0.00080982991494238377, 0.0010454425355419517, 0.00045984849566593766, 0.00031129087437875569, 0.00045536895049735904, 0.0002161079173674807, 0.00033291545696556568, 0.00036283113877288997, 0.00032261281739920378, 0.0026638887356966734, 0.00061678775819018483, 0.00041855598101392388, 0.0016186987049877644, } };
const TfArray<48, int> quant21_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant21 = { (TfLiteFloatArray*)&quant21_scale, (TfLiteIntArray*)&quant21_zero, 0 };
const ALIGN(16) int8_t tensor_data22[1*3*3*48] = { 
  /* [0][0][][] */ 70,-92,97,72,54,-34,107,-65,59,-88,-79,47,51,-43,-70,-89,102,79,48,78,67,-74,-82,51,-32,-41,-63,-64,-67,61,-63,-114,-14,42,69,64,-64,52,-50,-23,49,-73,59,61,-92,11,75,-33, 81,-97,127,87,-77,-68,-56,-85,96,-101,-63,74,79,-110,-94,92,-37,96,82,127,85,-115,51,71,-51,-78,-69,-80,57,79,-31,-127,-86,78,81,84,-81,81,-82,-16,76,-93,83,88,-72,-127,92,-102, 35,-47,70,37,18,-41,-46,-40,42,-31,5,33,29,-80,-55,0,-52,38,34,69,32,-54,31,26,-28,-45,-44,-23,32,32,88,-90,-85,44,35,34,-29,40,-38,-11,41,-39,34,42,-6,-8,37,-72, 
  /* [0][1][][] */ 94,-111,-42,93,56,-82,127,-90,86,-111,-71,81,83,-111,-13,-127,127,108,74,-38,83,108,-127,73,73,-76,-92,-99,-127,86,-70,-9,-88,71,106,96,-85,79,-81,89,84,-100,87,90,-85,107,93,-91, 127,-127,-66,127,-127,-127,-90,-127,127,-127,-127,127,127,-127,-22,97,-65,127,127,-51,127,127,68,127,127,-127,-127,-127,54,127,-29,15,-127,127,127,127,-127,127,-127,127,127,-127,127,127,-127,-11,127,-127, 64,-78,-32,64,37,-63,-48,-63,55,-42,-61,57,48,-55,-17,11,-62,52,58,-31,56,64,50,64,65,-64,-61,-45,37,55,127,14,-61,68,49,49,-49,61,-60,55,61,-57,53,62,-62,-67,59,-56, 
  /* [0][2][][] */ 45,-49,-46,50,27,-53,63,-42,41,-71,-4,39,55,-74,83,-79,73,50,34,-31,26,-10,-77,30,-24,-43,-46,-49,-74,32,-42,89,-74,36,49,42,-26,38,-43,-87,47,-49,40,44,-22,16,40,-74, 72,-74,-49,80,-56,-64,-71,-67,51,-76,-66,60,74,-48,127,33,-46,59,61,-44,55,-18,41,67,-49,-66,-76,-61,33,61,-24,116,-55,65,58,57,-49,62,-66,-105,68,-66,60,63,-86,50,63,-53, 42,-40,-26,45,28,-20,-16,-34,14,-25,-52,28,31,4,67,24,-34,22,28,-33,27,0,39,42,-25,-29,-47,-24,34,34,61,66,0,33,16,22,-22,31,-30,-56,28,-32,25,29,-62,9,31,-3, 
};
const TfArray<4, int> tensor_dimension22 = { 4, { 1,3,3,48 } };
const TfArray<48, float> quant22_scale = { 48, { 0.0023235855624079704, 0.0014875058550387621, 0.0078671770170331001, 0.0019914752338081598, 0.0063073891215026379, 0.002704554470255971, 0.0056523345410823822, 0.0037027988582849503, 0.0032048199791461229, 0.0015960484743118286, 0.001932395389303565, 0.0035805488005280495, 0.0017140160780400038, 0.0016535568283870816, 0.0076309801079332829, 0.0072304061613976955, 0.0071584000252187252, 0.0028660967946052551, 0.004523854237049818, 0.009450545534491539, 0.0029302851762622595, 0.0077949822880327702, 0.0045075388625264168, 0.0056568006984889507, 0.0035369398538023233, 0.0038905472029000521, 0.0011746257077902555, 0.0027471974026411772, 0.0050043188966810703, 0.0061700604856014252, 0.004858821164816618, 0.0079621691256761551, 0.002236958360299468, 0.0051768412813544273, 0.0011821583611890674, 0.0022497414611279964, 0.0051964321173727512, 0.0039030236657708883, 0.0037039816379547119, 0.0073446733877062798, 0.0037787002511322498, 0.0038073102477937937, 0.0029282758478075266, 0.0032645780593156815, 0.0012937471037730575, 0.0069159697741270065, 0.004931984469294548, 0.0012695126933977008, } };
const TfArray<48, int> quant22_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant22 = { (TfLiteFloatArray*)&quant22_scale, (TfLiteIntArray*)&quant22_zero, 3 };
const ALIGN(16) int32_t tensor_data23[48] = { 9599, 32801, -1049, 51466, 3905, 129739, -3291, 63578, 4297, 31084, 19783, 4474, 2194, 27460, -2209, -2171, -735, 1307, 3350, -1580, 1283, -2902, -138, -21774, -5597, 46629, 129223, 106124, 2582, 1631, -2451, 463, 19592, 1936, 39009, 1746, 46975, 2604, 63800, 2676, 3569, 63658, 2724, 5364, 52656, -602, 816, 46468, };
const TfArray<1, int> tensor_dimension23 = { 1, { 48 } };
const TfArray<48, float> quant23_scale = { 48, { 5.4672604164807126e-05, 3.5000139178009704e-05, 0.00018511005328036845, 4.6858240239089355e-05, 0.00014840916264802217, 6.36365803075023e-05, 0.00013299610873218626, 8.7124681158456951e-05, 7.5407529948279262e-05, 3.7554083974100649e-05, 4.5468128519132733e-05, 8.424821135122329e-05, 4.0329789044335485e-05, 3.8907219277461991e-05, 0.00017955247312784195, 0.00017012721218634397, 0.00016843294724822044, 6.7437569668982178e-05, 0.00010644362919265404, 0.00022236577933654189, 6.8947891122661531e-05, 0.00018341135000810027, 0.00010605974239297211, 0.00013310120266396552, 8.3222119428683072e-05, 9.1542286099866033e-05, 2.7638252504402772e-05, 6.4639942138455808e-05, 0.00011774868471547961, 0.00014517789531964809, 0.00011432520841481164, 0.00018734515469986945, 5.2634313760790974e-05, 0.00012180803605588153, 2.7815491193905473e-05, 5.2935094572603703e-05, 0.00012226898979861289, 9.1835849161725491e-05, 8.7152511696331203e-05, 0.00017281585314776748, 8.891059405868873e-05, 8.9583772933110595e-05, 6.8900611950084567e-05, 7.6813601481262594e-05, 3.0441109629464336e-05, 0.00016272869834210724, 0.00011604669271036983, 2.987088737427257e-05, } };
const TfArray<48, int> quant23_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant23 = { (TfLiteFloatArray*)&quant23_scale, (TfLiteIntArray*)&quant23_zero, 0 };
const ALIGN(16) int8_t tensor_data24[16*1*1*48] = { 
  /* [0][0][][] */ -12,-7,-24,7,25,-3,2,99,-52,19,36,-6,20,-17,-18,15,17,-7,-8,-1,67,-10,22,119,-20,81,-5,-14,31,-16,25,-21,-21,55,14,-47,11,51,16,-20,-108,-27,16,44,38,28,-127,-52, 
  /* [1][0][][] */ -40,-17,20,14,-40,11,3,58,-61,-34,8,-54,-23,-19,2,-4,-24,121,-14,15,4,5,-26,-18,24,-45,22,27,-27,-92,-39,20,-21,-5,33,-3,-3,-46,3,20,-18,-34,127,11,12,0,25,-9, 
  /* [2][0][][] */ -19,-10,-13,-37,-2,-65,8,-22,0,12,15,28,16,15,-11,10,-3,-21,-24,-11,-3,3,-3,-127,-13,73,-14,1,3,-17,-4,-7,-6,53,11,0,22,12,25,-1,-43,8,-19,-6,-2,-8,14,6, 
  /* [3][0][][] */ -9,28,0,-33,-1,1,3,-2,-20,-1,0,36,-127,6,-5,0,2,4,-20,-2,-32,6,7,14,-8,-10,6,25,-8,16,4,17,3,0,17,17,-11,24,42,7,8,6,23,-30,8,-4,6,18, 
  /* [4][0][][] */ 41,-36,13,12,24,25,25,-27,-31,2,-16,-21,2,9,3,19,25,-7,-81,5,-5,8,14,77,-5,-29,7,48,12,-78,22,11,14,-36,33,-127,14,40,-4,14,-16,15,7,-22,-10,-19,11,6, 
  /* [5][0][][] */ 28,2,-20,56,0,-6,6,26,2,-1,38,11,1,52,-1,1,-21,19,25,4,8,1,0,-24,0,-47,1,-20,-3,-6,3,8,62,-127,4,29,-12,-12,16,4,-91,55,23,-5,-5,0,-100,-7, 
  /* [6][0][][] */ 23,-3,8,3,-13,-4,2,-12,-8,6,-3,2,-17,8,1,5,0,-12,127,6,5,8,17,-31,4,3,25,-12,-13,-5,-3,7,-2,-11,31,-39,2,-45,72,18,2,-9,-6,7,-7,1,6,-10, 
  /* [7][0][][] */ -44,-15,-12,36,-11,84,-3,42,3,26,-3,127,78,-7,-1,-3,-4,-23,-3,-15,-26,0,-16,60,5,-42,-53,-32,-14,-17,-9,-17,5,-2,-25,3,7,-57,92,1,22,27,-63,-54,13,-9,11,3, 
  /* [8][0][][] */ -51,-49,5,6,-6,6,-3,34,-3,-67,7,45,51,8,1,5,-15,65,-36,4,-55,19,-11,-15,2,2,7,47,-5,125,-9,29,-4,6,-20,-127,-115,74,36,32,21,-7,117,-24,11,31,20,36, 
  /* [9][0][][] */ -31,1,2,30,16,-26,-6,3,55,-37,8,56,-58,8,7,2,-7,15,-40,-23,44,2,-13,-16,-2,11,47,-24,10,13,8,1,-3,15,78,-98,-7,-127,-86,13,-28,26,51,5,4,9,-16,-40, 
  /* [10][0][][] */ -23,-7,-35,-127,41,84,14,-9,-2,29,23,3,51,-51,-25,21,36,-47,59,-38,26,-21,41,56,-47,-107,11,-33,45,29,46,-51,-32,-81,26,-12,14,-49,8,-32,-32,-65,-15,6,11,17,18,-34, 
  /* [11][0][][] */ -4,48,-6,60,34,-67,-89,-16,-5,75,-20,-8,-8,56,-13,-83,25,49,6,-11,-58,-110,13,-3,18,-40,25,-11,57,-44,25,-78,44,-13,-46,-95,90,21,11,-127,-4,61,99,-77,-6,-51,34,33, 
  /* [12][0][][] */ 123,-2,-15,17,7,19,4,102,19,-12,-60,-20,-2,12,-11,-2,-9,5,-1,-6,9,1,-2,23,0,18,-3,9,1,17,-4,2,4,-60,-9,7,-20,-20,-27,4,-10,-76,7,-127,-49,-9,77,-7, 
  /* [13][0][][] */ 10,0,2,6,7,-10,0,1,-1,8,3,21,-4,4,2,1,8,3,10,4,13,-15,9,-2,1,0,17,127,12,-4,6,-1,3,2,-39,22,9,-5,6,-14,-12,-5,0,6,0,-2,-8,-11, 
  /* [14][0][][] */ 60,-27,46,-68,50,25,35,-93,-52,-49,-8,115,-63,-5,60,11,54,28,-48,63,17,15,77,-18,21,56,-37,-105,24,-39,60,40,-6,69,-127,-51,-47,38,85,3,-36,10,48,-3,-5,3,18,-32, 
  /* [15][0][][] */ -2,-45,-68,-35,54,22,78,-54,-5,19,-21,-37,87,18,-91,63,60,56,81,-80,-99,-19,60,-15,-92,40,21,54,51,42,53,-49,19,63,91,127,-16,-107,-12,-39,93,56,113,-49,-6,-34,-12,62, 
};
const TfArray<4, int> tensor_dimension24 = { 4, { 16,1,1,48 } };
const TfArray<16, float> quant24_scale = { 16, { 0.032000470906496048, 0.036723613739013672, 0.042349442839622498, 0.048103898763656616, 0.02663687989115715, 0.041652396321296692, 0.041799258440732956, 0.026712074875831604, 0.029168030247092247, 0.030634976923465729, 0.042268745601177216, 0.025110827758908272, 0.048478648066520691, 0.054057735949754715, 0.018452232703566551, 0.027991281822323799, } };
const TfArray<16, int> quant24_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant24 = { (TfLiteFloatArray*)&quant24_scale, (TfLiteIntArray*)&quant24_zero, 0 };
const ALIGN(16) int32_t tensor_data25[16] = { -32384, 5177, 2132, -7524, 2130, -7539, -10979, -40273, 1410, 19898, 33959, -7313, -5054, -21689, 41351, -41876, };
const TfArray<1, int> tensor_dimension25 = { 1, { 16 } };
const TfArray<16, float> quant25_scale = { 16, { 0.00075295229908078909, 0.00086408504284918308, 0.00099645752925425768, 0.0011318564647808671, 0.00062675011577084661, 0.00098005635663866997, 0.0009835120290517807, 0.00062851939583197236, 0.00068630662281066179, 0.00072082300903275609, 0.00099455879535526037, 0.00059084303211420774, 0.0011406741105020046, 0.0012719467049464583, 0.00043417018605396152, 0.00065861840266734362, } };
const TfArray<16, int> quant25_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant25 = { (TfLiteFloatArray*)&quant25_scale, (TfLiteIntArray*)&quant25_zero, 0 };
const ALIGN(16) int8_t tensor_data26[96*1*1*16] = { 
  /* [0][0][][] */ 32,-17,127,107,73,-29,21,-37,110,-31,-52,-80,24,81,-50,-90, 
  /* [1][0][][] */ 37,74,-11,-12,92,-9,8,22,60,75,-30,127,-3,-28,107,-85, 
  /* [2][0][][] */ 10,-42,-3,-6,-49,45,-39,76,-75,-86,10,63,-12,-127,64,-103, 
  /* [3][0][][] */ 127,121,12,35,-113,-14,-55,-17,15,6,99,-66,-51,114,-49,-39, 
  /* [4][0][][] */ 3,-5,19,17,-20,35,-20,38,-54,-35,-2,-8,-11,-127,28,-5, 
  /* [5][0][][] */ 127,-59,-18,-7,-7,-122,-39,3,-19,5,-120,-12,12,-3,-2,33, 
  /* [6][0][][] */ -126,-69,-7,126,-71,-2,-34,50,-127,-67,-92,-32,46,77,-23,98, 
  /* [7][0][][] */ -26,19,-68,51,37,-127,-13,54,8,-18,24,-15,8,12,-49,19, 
  /* [8][0][][] */ 37,-47,1,-8,11,41,-75,-62,-2,6,-76,20,-127,3,4,17, 
  /* [9][0][][] */ 30,-46,62,127,-1,14,-11,-63,107,-88,-7,-10,0,49,-61,28, 
  /* [10][0][][] */ -105,-81,6,-34,121,42,12,61,127,-95,-96,52,84,-84,-94,46, 
  /* [11][0][][] */ 37,-12,-127,8,53,16,-27,30,-19,-38,-12,-5,-1,17,-36,11, 
  /* [12][0][][] */ 105,-54,8,3,-6,-68,-57,-36,33,5,-127,-28,-54,-28,2,55, 
  /* [13][0][][] */ 69,-83,2,-55,82,17,-72,-127,48,-44,-7,26,3,-13,32,-4, 
  /* [14][0][][] */ -49,26,-83,-35,71,-127,49,-56,48,42,-5,-91,19,97,-14,27, 
  /* [15][0][][] */ 15,-11,66,30,47,-35,-49,-14,14,-66,-60,-3,-127,-53,-4,52, 
  /* [16][0][][] */ -127,69,17,10,-3,85,41,69,-8,21,123,16,9,18,1,-52, 
  /* [17][0][][] */ -7,-6,-47,-31,-35,9,41,82,-16,127,-20,6,-11,76,64,-2, 
  /* [18][0][][] */ 0,127,-38,-2,15,9,55,-64,31,101,-47,104,8,-31,28,-84, 
  /* [19][0][][] */ 1,-14,42,25,7,50,-5,20,19,8,-43,-6,-127,2,-12,19, 
  /* [20][0][][] */ 85,-64,-2,-83,-28,31,16,-87,-49,16,-127,-35,22,8,60,-4, 
  /* [21][0][][] */ 42,-11,127,46,-22,50,31,6,-6,35,-14,-14,-8,67,-2,-7, 
  /* [22][0][][] */ 35,9,20,2,-8,1,37,127,0,6,-1,27,4,23,2,22, 
  /* [23][0][][] */ -24,17,-82,15,16,-127,12,35,-1,-22,-16,6,-64,7,-2,36, 
  /* [24][0][][] */ 42,-53,14,-79,63,-4,-31,-3,34,29,83,115,-46,107,127,59, 
  /* [25][0][][] */ -127,-90,-59,12,3,3,29,-28,-83,8,-80,5,33,36,16,69, 
  /* [26][0][][] */ 10,0,47,-1,-9,5,-33,55,-86,-51,-9,4,10,-127,31,-17, 
  /* [27][0][][] */ -102,35,-56,34,36,-16,3,25,35,-32,127,22,-30,-12,-4,-34, 
  /* [28][0][][] */ -16,-9,24,32,1,2,8,80,24,11,-21,-2,-127,-12,-5,35, 
  /* [29][0][][] */ -14,55,35,-42,34,-19,17,-27,-127,27,-20,3,-5,25,-75,17, 
  /* [30][0][][] */ -13,-1,-127,-41,34,-67,-3,10,-21,-18,-8,-18,-42,-31,4,4, 
  /* [31][0][][] */ 127,-41,-121,9,43,-8,-42,52,-28,-8,-67,-49,10,-30,-80,34, 
  /* [32][0][][] */ -121,57,21,38,14,76,32,41,9,8,127,-6,-18,14,-22,-17, 
  /* [33][0][][] */ 2,-19,127,-29,-71,20,8,-45,-8,11,-7,11,-11,15,48,18, 
  /* [34][0][][] */ -17,-28,-57,-124,19,19,-5,-24,-36,-60,-39,-127,-5,0,59,21, 
  /* [35][0][][] */ 5,-28,45,52,54,-20,19,-12,-110,38,-7,27,-10,127,-43,-39, 
  /* [36][0][][] */ -127,54,-32,18,-14,46,48,92,-4,29,125,-9,-2,18,4,-39, 
  /* [37][0][][] */ -35,9,127,-37,-71,-64,41,-20,3,28,8,7,-1,-79,48,14, 
  /* [38][0][][] */ 6,-21,-20,23,30,-59,-57,6,-16,-8,76,-18,127,22,-10,16, 
  /* [39][0][][] */ -17,-24,15,-72,-23,-112,55,127,-42,-20,20,-30,3,41,73,67, 
  /* [40][0][][] */ 65,-5,-21,-11,-6,84,-15,12,23,-1,20,-4,127,26,-26,-17, 
  /* [41][0][][] */ -2,-6,-46,-127,26,-12,-25,-73,-27,-47,15,-50,-2,-29,-20,39, 
  /* [42][0][][] */ 32,59,24,108,-115,-8,-103,3,-70,-62,87,-86,-45,127,-43,7, 
  /* [43][0][][] */ 20,105,-38,127,14,18,49,-67,-36,77,9,21,3,-43,46,38, 
  /* [44][0][][] */ 1,-25,-127,28,42,74,-34,61,-2,-12,31,-20,13,-22,-53,2, 
  /* [45][0][][] */ 8,15,-10,-127,-22,-7,46,-9,-14,21,-23,7,3,-95,38,-30, 
  /* [46][0][][] */ 3,24,46,-17,0,6,-48,57,17,-51,-21,8,3,127,60,-4, 
  /* [47][0][][] */ 15,-25,17,-33,-31,21,-60,49,-8,-31,14,31,7,-127,44,2, 
  /* [48][0][][] */ 14,-17,8,-127,-8,-24,-8,8,17,-29,14,-15,8,53,-6,61, 
  /* [49][0][][] */ 35,-42,-14,110,95,1,-2,41,-47,20,49,38,-15,31,127,-3, 
  /* [50][0][][] */ -28,-14,84,-10,-7,127,-26,-55,42,-23,114,26,96,-7,-16,-73, 
  /* [51][0][][] */ 31,50,16,16,15,3,-54,15,49,1,-7,127,11,32,29,-61, 
  /* [52][0][][] */ -18,57,127,2,22,-34,6,-55,-25,9,18,25,-3,92,-110,-3, 
  /* [53][0][][] */ 2,-18,-52,-127,-47,6,14,-27,-13,33,10,11,28,-13,55,24, 
  /* [54][0][][] */ 3,23,-40,-69,16,12,-5,14,58,-30,8,-21,-11,127,16,39, 
  /* [55][0][][] */ 2,-23,-38,-22,20,-46,-10,-127,-12,-82,-11,-5,-29,-83,-41,-22, 
  /* [56][0][][] */ 42,48,30,56,4,-22,22,127,24,-19,0,-41,80,-9,-48,37, 
  /* [57][0][][] */ 79,-21,127,-27,-70,-47,-5,-35,17,0,-104,38,61,-44,63,28, 
  /* [58][0][][] */ 115,82,10,127,-119,-4,-13,32,-25,0,98,-55,-109,-45,-22,-108, 
  /* [59][0][][] */ 127,-42,-4,0,-23,-17,-11,15,-20,21,-108,-6,18,0,7,27, 
  /* [60][0][][] */ -127,40,-1,8,10,24,17,28,23,1,81,6,-41,10,20,-22, 
  /* [61][0][][] */ -101,63,16,2,39,-21,-86,-94,127,-112,116,-18,63,-73,-91,-60, 
  /* [62][0][][] */ -33,-25,-108,59,62,127,-12,112,17,-52,39,3,-61,-4,-107,-9, 
  /* [63][0][][] */ -40,-2,127,-50,-59,-61,37,-34,-3,21,14,11,-11,-63,89,32, 
  /* [64][0][][] */ 14,71,-17,23,61,17,87,-127,-20,97,7,-21,-22,-124,-7,31, 
  /* [65][0][][] */ 7,15,20,-23,66,3,-8,-127,-23,-42,-31,-47,-12,-43,35,16, 
  /* [66][0][][] */ -127,7,-15,2,-38,12,5,-38,-75,-49,-83,65,62,31,55,90, 
  /* [67][0][][] */ -9,-35,1,127,2,1,-20,32,62,27,-7,-17,-1,-28,-85,-15, 
  /* [68][0][][] */ 21,-3,-3,127,-45,-22,-8,-28,-46,34,14,-21,-25,-61,-27,-47, 
  /* [69][0][][] */ 86,107,32,127,58,-22,70,-121,17,103,9,71,27,-25,27,-5, 
  /* [70][0][][] */ 33,-54,-4,-98,127,-48,34,15,103,-45,51,-63,-5,115,85,113, 
  /* [71][0][][] */ 10,50,8,69,44,-127,-50,74,29,-97,14,15,13,-57,-51,37, 
  /* [72][0][][] */ -127,-64,2,37,22,37,-31,14,-48,-38,-74,36,49,23,8,90, 
  /* [73][0][][] */ -6,-17,11,70,23,-15,-3,-8,64,15,3,28,29,127,-62,-45, 
  /* [74][0][][] */ 71,-33,22,-18,-32,-8,35,-19,-39,-16,-123,29,-127,-1,27,42, 
  /* [75][0][][] */ -12,-16,-25,127,-34,12,-3,-24,-85,20,-12,-30,-2,-58,-24,-29, 
  /* [76][0][][] */ 4,-17,-13,43,42,9,-26,-126,11,-127,12,29,-29,-24,36,-39, 
  /* [77][0][][] */ 127,-28,52,58,-32,1,-51,-4,52,-20,-58,76,47,36,-61,31, 
  /* [78][0][][] */ -10,-11,44,8,5,-13,-62,35,44,-21,-47,-36,21,127,30,-24, 
  /* [79][0][][] */ -5,11,54,19,46,64,-51,-51,18,-41,75,-14,127,-19,-29,-40, 
  /* [80][0][][] */ -120,-113,-64,127,6,40,34,-8,-96,19,-121,22,68,-64,-25,60, 
  /* [81][0][][] */ 47,-4,-93,35,127,95,-50,-59,-21,-107,-18,-97,-37,-29,-103,27, 
  /* [82][0][][] */ 118,127,8,38,-112,-11,-77,-13,-60,-21,104,-36,-49,102,2,-36, 
  /* [83][0][][] */ 127,49,21,-24,9,-20,-11,33,37,12,86,-24,-51,-24,-31,-78, 
  /* [84][0][][] */ 8,-50,-53,-31,37,22,-6,-127,-31,-51,32,12,-15,-11,5,-6, 
  /* [85][0][][] */ -27,-2,-62,-69,-5,-22,96,101,-22,127,1,-51,29,63,80,-24, 
  /* [86][0][][] */ 102,-24,20,3,5,-21,-10,-17,1,-5,-127,16,5,27,-6,7, 
  /* [87][0][][] */ -19,36,24,-41,-5,69,-41,40,-14,-43,29,14,0,-127,18,3, 
  /* [88][0][][] */ -15,-25,-70,-34,64,10,-47,-127,5,-32,-6,-29,-53,0,32,-30, 
  /* [89][0][][] */ 24,-23,26,-127,26,10,-55,94,59,-65,38,9,-16,24,34,45, 
  /* [90][0][][] */ -13,21,-43,62,73,-5,109,-82,61,127,-43,32,27,12,-9,-31, 
  /* [91][0][][] */ 36,-10,-41,-14,-11,-127,-7,-3,-12,-5,-38,-14,25,-19,6,34, 
  /* [92][0][][] */ 4,4,127,53,36,12,7,38,-51,23,-63,39,31,96,-13,0, 
  /* [93][0][][] */ 127,-49,-42,-10,-42,-60,22,48,-25,58,-117,-17,-1,23,-3,55, 
  /* [94][0][][] */ 11,-14,41,74,111,-26,-7,52,15,-12,4,53,-8,127,-24,-72, 
  /* [95][0][][] */ -119,48,44,51,20,51,20,8,19,4,127,0,-27,39,-11,-37, 
};
const TfArray<4, int> tensor_dimension26 = { 4, { 96,1,1,16 } };
const TfArray<96, float> quant26_scale = { 96, { 0.00058103405172005296, 0.00099909631535410881, 0.00061784120043739676, 0.0030191142577677965, 0.0011366838589310646, 0.00061887485207989812, 0.00051250186515972018, 0.001792195369489491, 0.00094839837402105331, 0.00044410245027393103, 0.00079761806409806013, 0.0016947488766163588, 0.0013702500145882368, 0.0003538401797413826, 0.00071291811764240265, 0.0010284238960593939, 0.00074095738818868995, 0.00060561887221410871, 0.00091739918570965528, 0.0022177067585289478, 0.0013702764408662915, 0.00054748106049373746, 0.0011216378770768642, 0.00066874170443043113, 0.00041044916724786162, 0.0012897321721538901, 0.0010475555900484324, 0.0007174448692239821, 0.0026306209620088339, 0.0011757576139643788, 0.00060537515673786402, 0.00066628976492211223, 0.00044586043804883957, 0.0019871543627232313, 0.00067691865842789412, 0.0014388086274266243, 0.00037491472903639078, 0.0012563714990392327, 0.0022351653315126896, 0.00067049439530819654, 0.0019337058765813708, 0.0003901165327988565, 0.00060192024102434516, 0.00055519654415547848, 0.0015060524456202984, 0.001095372368581593, 0.00058728241128847003, 0.00084401859203353524, 0.00097511039348319173, 0.0012179795885458589, 0.0013741833390668035, 0.0025868499651551247, 0.00050321652088314295, 0.00084871228318661451, 0.00088324130047112703, 0.00032578193349763751, 0.00113702192902565, 0.00090830674162134528, 0.00080597802298143506, 0.0015897696139290929, 0.00046292057959362864, 0.00059992697788402438, 0.0013690561754629016, 0.0012756857322528958, 0.00055224751122295856, 0.00078639650018885732, 0.0010682858992367983, 0.0013037207536399364, 0.00046764712897129357, 0.00050997722428292036, 0.00049122411292046309, 0.0015184133080765605, 0.00093902461230754852, 0.0013304929016157985, 0.00091876077931374311, 0.001018456881865859, 0.00029293389525264502, 0.00094805337721481919, 0.00040733363130129874, 0.0016640650574117899, 0.00048761317157186568, 0.001036287285387516, 0.0007194806239567697, 0.0014314943691715598, 0.00061104976339265704, 0.00080623076064512134, 0.00084837613394483924, 0.00096962653333321214, 0.00041936183697544038, 0.001145250047557056, 0.00054929190082475543, 0.0014060968533158302, 0.00043538943282328546, 0.00046574787120334804, 0.001080587855540216, 0.00074644538108259439, } };
const TfArray<96, int> quant26_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant26 = { (TfLiteFloatArray*)&quant26_scale, (TfLiteIntArray*)&quant26_zero, 0 };
const ALIGN(16) int32_t tensor_data27[96] = { 13612, 1095, 6663, -572, 4341, 4538, 18681, 5989, -1545, 12435, 5525, 1472, 6149, 41882, -652, -2115, 9112, 11727, 1471, -167, -590, 13809, 4126, 3543, 13196, 4930, 4165, 3914, 48, -91, 7228, 8721, 13586, 1685, 7627, -592, 18380, 6393, 619, 4429, 773, 15078, 10840, 4156, 2306, 9095, 14852, 5313, 4940, 2151, 281, -799, 16299, 5689, 8003, 17373, -292, 5895, 3113, 3131, 11346, 7052, 2375, 6640, 5677, 4237, 5607, -758, 17559, 7036, 12537, -981, -1260, 3117, 1397, 3895, 24894, 14501, 12481, -2258, 6988, -6152, -1580, 553, 7926, 5979, 5938, 4442, 12140, 4295, 7878, 3707, 14840, 18026, -8264, 13542, };
const TfArray<1, int> tensor_dimension27 = { 1, { 96 } };
const TfArray<96, float> quant27_scale = { 96, { 0.00018973172700498253, 0.00032624640152789652, 0.00020175077952444553, 0.00098586606327444315, 0.00037117442116141319, 0.0002020883111981675, 0.00016735312237869948, 0.00058522610925137997, 0.00030969141516834497, 0.00014501786790788174, 0.00026045538834296167, 0.00055340578546747565, 0.00044744348269887269, 0.00011554349475773051, 0.0002327973343199119, 0.00033582307514734566, 0.00024195332662202418, 0.00019775968394242227, 0.0002995688992086798, 0.00072417326737195253, 0.00044745209743268788, 0.00017877528443932533, 0.00036626128712669015, 0.00021837190433871001, 0.00013402868353296071, 0.000421151053160429, 0.00034207035787403584, 0.0002342755178688094, 0.00085900689009577036, 0.00038393362774513662, 0.00019768009951803833, 0.00021757124341093004, 0.00014559192641172558, 0.00064888835186138749, 0.00022104202071204782, 0.00046983070205897093, 0.00012242520460858941, 0.00041025740210898221, 0.00072987418388947845, 0.00021894423116464168, 0.00063143519219011068, 0.00012738922669086605, 0.00019655193318612874, 0.00018129470117855817, 0.00049178861081600189, 0.00035768450470641255, 0.00019177206559106708, 0.00027560707530938089, 0.00031841400777921081, 0.00039772086893208325, 0.0004487278638407588, 0.0008447138243354857, 0.00016432107076980174, 0.00027713977033272386, 0.00028841491439379752, 0.00010638131789164618, 0.00037128484109416604, 0.00029659984284080565, 0.00026318526943214238, 0.00051912572234869003, 0.00015116277791094035, 0.00019590104056987911, 0.00044705363688990474, 0.00041656431858427823, 0.00018033172818832099, 0.00025679107056930661, 0.00034883967600762844, 0.00042571889935061336, 0.00015270618314389139, 0.00016652871272526681, 0.00016040504851844162, 0.00049582496285438538, 0.00030663047800771892, 0.00043446113704703748, 0.00030001351842656732, 0.00033256842289119959, 9.5655072072986513e-05, 0.00030957875424064696, 0.00013301133003551513, 0.00054338626796379685, 0.00015922592137940228, 0.00033839078969322145, 0.00023494026390835643, 0.00046744229621253908, 0.00019953309674747288, 0.00026326777879148722, 0.00027702999068424106, 0.00031662327819503844, 0.00013693903747480363, 0.00037397164851427078, 0.00017936658696271479, 0.00045914895599707961, 0.00014217270654626191, 0.00015208599506877363, 0.00035285676131024957, 0.00024374538043048233, } };
const TfArray<96, int> quant27_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant27 = { (TfLiteFloatArray*)&quant27_scale, (TfLiteIntArray*)&quant27_zero, 0 };
const ALIGN(16) int8_t tensor_data28[1*3*3*96] = { 
  /* [0][0][][] */ -18,6,-20,104,-17,23,-62,-55,19,-5,98,-9,4,-7,-5,54,6,16,-35,4,75,3,33,-34,2,18,45,49,21,12,24,48,-9,27,10,-15,6,48,-61,-25,21,8,28,18,-84,-55,26,-5,-11,-21,-8,-7,49,5,-8,2,-4,-36,27,-30,27,-3,127,27,-12,-11,10,-51,67,36,1,-7,78,-34,70,4,16,-127,29,68,0,14,127,-14,38,28,-29,-20,36,-5,-14,80,1,20,-2,11, -49,13,-8,11,53,-9,-9,-127,37,14,-127,-5,-16,-13,4,90,18,-29,-13,-15,74,-97,127,26,-61,-31,-104,-17,27,35,-49,18,119,11,-13,-1,-23,127,-65,-127,9,-19,-28,13,48,-127,127,-44,-76,51,49,7,39,-64,32,56,36,41,-103,84,127,34,4,-20,44,-38,-96,-1,37,-31,-20,47,-48,-48,107,-5,-30,-60,-34,65,-67,59,-14,10,-11,47,56,-42,-26,54,-14,71,-127,-31,24,-127, 0,-3,-23,-74,8,19,38,21,-3,-1,5,62,0,-13,-11,7,-12,17,-19,16,7,25,22,-32,1,-31,10,11,-6,5,46,-79,41,16,9,-23,13,4,-30,-21,7,2,-15,7,23,-30,22,1,6,-9,5,-5,4,5,-5,8,-8,43,4,-2,12,-18,2,-17,-25,-18,30,-49,-109,-7,39,-19,-127,-23,-11,16,9,-11,5,11,-13,25,-37,-3,-41,21,25,37,-23,-16,25,-11,21,7,-1,-47, 
  /* [0][1][][] */ -42,59,-17,37,-85,-15,-11,-45,28,96,-45,-22,-31,-24,-7,64,127,-24,-89,-13,60,-127,-27,16,-35,-47,-127,-6,37,37,-50,28,-127,-75,-57,3,66,-4,-49,47,-19,85,2,-3,35,-51,-12,-32,127,41,-3,21,45,9,-35,-16,31,9,-127,127,-37,-89,22,127,-58,-36,-86,125,-38,127,-19,53,-35,-56,37,8,-36,-70,127,49,127,36,6,-1,127,28,-98,47,-38,-34,-102,39,98,102,29,-61, 127,127,127,127,-46,-127,127,23,127,-127,17,-127,-107,127,127,127,-16,-127,-62,-127,127,23,-66,127,127,127,-55,-127,127,127,-127,127,-9,-127,-125,127,-127,-46,98,108,-127,-127,127,127,127,-118,-106,127,-13,127,-127,-127,-127,127,127,-127,127,-127,-45,40,-107,-27,-70,-68,127,127,-73,127,127,-107,-127,127,-42,127,-127,-127,-127,123,-75,127,-44,127,79,127,-38,-127,-25,-109,-127,-125,-23,-127,-21,-127,-127,118, -25,66,-37,2,127,72,-21,48,5,24,-13,-5,-27,-31,-14,-8,-103,-22,-127,38,34,79,-13,-115,-34,-40,126,72,10,34,74,9,122,-48,127,-4,56,5,-93,13,36,22,-22,0,-24,-51,-12,-43,81,13,-11,40,-6,-4,-74,-14,24,20,125,-90,3,127,-1,-37,-109,-28,-75,99,14,-17,109,24,-18,-56,12,45,-29,-7,-43,-3,-47,9,45,24,-90,35,127,-47,35,-22,127,-10,-110,35,34,18, 
  /* [0][2][][] */ -5,-40,-21,-60,-5,14,40,31,0,10,-20,52,24,-35,-7,7,40,3,15,22,-10,31,-16,-26,2,-24,10,3,-9,-8,50,-76,-39,66,-28,-26,30,-36,-64,18,9,8,-33,21,12,-77,-11,-1,-10,4,17,-7,7,2,-21,6,-2,43,-52,34,-6,-12,5,16,-6,-10,23,-53,-57,11,-22,-11,-116,-33,0,17,14,-12,57,17,22,21,-38,17,11,25,-20,9,4,25,22,-6,21,40,-6,-30, -28,-11,-27,23,-45,74,-24,66,5,-6,54,-12,127,-8,-18,-16,-1,-39,-55,23,-23,80,-44,-111,-47,-47,101,70,14,45,55,-3,-122,62,-15,-24,-28,-28,-127,-3,45,-14,-14,39,-27,-44,-17,-48,-61,28,68,25,-11,-80,31,52,16,26,73,-54,20,-57,-8,0,19,-26,-127,-54,-11,-27,-64,22,35,-46,-29,-9,-45,22,-55,2,48,38,20,11,5,63,-93,127,18,127,-31,-19,115,-21,46,83, -10,-34,-25,28,11,64,-43,12,4,-5,-1,14,11,-52,-10,-12,-44,-6,19,19,-24,6,-21,4,-4,21,-1,50,-2,-7,35,29,17,41,19,-24,-6,-27,-30,8,11,-12,22,10,-74,-31,-12,4,-2,-17,-1,-5,-9,9,-16,-5,-2,-50,11,-29,-21,50,8,-29,-9,-2,36,-54,46,7,51,-21,29,-55,-19,21,11,11,-4,21,-31,32,87,-14,-17,54,39,-9,113,12,1,-19,12,-22,-6,-51, 
};
const TfArray<4, int> tensor_dimension28 = { 4, { 1,3,3,96 } };
const TfArray<96, float> quant28_scale = { 96, { 0.0081252893432974815, 0.0061704046092927456, 0.012103396467864513, 0.0018426117021590471, 0.0073797521181404591, 0.006693301722407341, 0.014447745867073536, 0.0045168837532401085, 0.0046316171064972878, 0.016648661345243454, 0.0076903160661458969, 0.013947643339633942, 0.0054712314158678055, 0.021931564435362816, 0.0074403081089258194, 0.0040332023054361343, 0.0040694340132176876, 0.013193114660680294, 0.0027782921679317951, 0.010235565714538097, 0.0017740083858370781, 0.0088545018807053566, 0.0090884417295455933, 0.016274066641926765, 0.013613346964120865, 0.011642847210168839, 0.0062252646312117577, 0.0076273391023278236, 0.0052556362934410572, 0.0045420266687870026, 0.0064169592224061489, 0.0076609854586422443, 0.0060444613918662071, 0.0064668804407119751, 0.0077100531198084354, 0.0097470348700881004, 0.016511019319295883, 0.0061619998887181282, 0.0019117771880701184, 0.0080826431512832642, 0.011330116540193558, 0.013988866470754147, 0.01620200090110302, 0.0064196782186627388, 0.0082322396337985992, 0.0023768413811922073, 0.012018700130283833, 0.011866144835948944, 0.0047736521810293198, 0.0079907728359103203, 0.013451926410198212, 0.007950357161462307, 0.010750586166977882, 0.013861626386642456, 0.011052715592086315, 0.026980439200997353, 0.015549531206488609, 0.010833839885890484, 0.0054362001828849316, 0.0033499260898679495, 0.014932162128388882, 0.0060933381319046021, 0.013206577859818935, 0.0054589938372373581, 0.008405366912484169, 0.0084050195291638374, 0.0035889933351427317, 0.0037877962458878756, 0.015897670760750771, 0.010489162057638168, 0.0089677255600690842, 0.0036729651037603617, 0.0054408442229032516, 0.0063825389370322227, 0.0066038100048899651, 0.012774319387972355, 0.020933499559760094, 0.0025147912092506886, 0.012721581384539604, 0.020338121801614761, 0.0075872782617807388, 0.0084624812006950378, 0.0050244233570992947, 0.0058996188454329967, 0.0048994757235050201, 0.0041386517696082592, 0.0056763994507491589, 0.0093420036137104034, 0.0098279286175966263, 0.0069287992082536221, 0.0089190136641263962, 0.0056142900139093399, 0.0073751802556216717, 0.017982609570026398, 0.49584293365478516, 0.0035663789603859186, } };
const TfArray<96, int> quant28_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant28 = { (TfLiteFloatArray*)&quant28_scale, (TfLiteIntArray*)&quant28_zero, 3 };
const ALIGN(16) int32_t tensor_data29[96] = { 10942, -8555, 3470, 48634, -1433, -4832, -10438, 3423, -2233, 518, 2845, -2080, 1594, -1089, 5901, -6933, -1626, 16885, 24507, 2246, 3513, -3296, 833, 352, 12420, -282, -1418, -3892, -5573, -7153, 4437, -8900, 737, -881, -1148, 10375, 613, -3218, 19638, -275, -335, 2019, -9902, -8104, -6751, 68289, -681, 13071, 22557, -12137, -50, 6944, 6065, -264, -5897, 2249, -10315, 2086, 3303, -6324, -1602, -952, -12995, -699, 1347, 15136, 29805, 19660, -11297, 275, -8102, 75, 45314, 11898, -100, 1187, 19111, 34476, -516, -3571, -1342, -10442, 665, -3162, 555, 412, 1112, -427, 814, -2835, 117, -171, -909, -979, 106, 48413, };
const TfArray<1, int> tensor_dimension29 = { 1, { 96 } };
const TfArray<96, float> quant29_scale = { 96, { 0.00019118328054901212, 0.00014518600073643029, 0.00028478581225499511, 4.3355568777769804e-05, 0.00017364122322760522, 0.00015748945588711649, 0.000339946971507743, 0.00010627962183207273, 0.00010897922766162083, 0.0003917332214768976, 0.00018094861297868192, 0.00032817985629662871, 0.00012873485684394836, 0.00051603681640699506, 0.00017506607400719076, 9.489888179814443e-05, 9.5751391199883074e-05, 0.00031042622867971659, 6.5371583332307637e-05, 0.00024083684547804296, 4.1741375753190368e-05, 0.00020834122551605105, 0.00021384569117799401, 0.00038291921373456717, 0.00032031405135057867, 0.00027394935023039579, 0.00014647681382484734, 0.00017946680600289255, 0.00012366203009150922, 0.00010687121539376676, 0.00015098728181328624, 0.00018025848839897662, 0.0001422226196154952, 0.00015216189785860479, 0.00018141302280128002, 0.00022934199660085142, 0.00038849457632750273, 0.00014498824020847678, 4.4982993131270632e-05, 0.00019017983868252486, 0.0002665909705683589, 0.00032914979965426028, 0.00038122356636449695, 0.00015105125203263015, 0.00019369975780136883, 5.5925680499058217e-05, 0.00028279295656830072, 0.00027920340653508902, 0.00011232122778892517, 0.00018801818077918142, 0.00031651591416448355, 0.00018706722767092288, 0.00025295498198829591, 0.00032615591771900654, 0.00026006391271948814, 0.00063483387930318713, 0.00036587132490240037, 0.00025491387350484729, 0.00012791059270966798, 7.8821794886607677e-05, 0.00035134499194100499, 0.00014337265747599304, 0.00031074302387423813, 0.00012844691809732467, 0.00019777334819082171, 0.00019776517001446337, 8.4446903201751411e-05, 8.9124616351909935e-05, 0.00037406285991892219, 0.00024680382921360433, 0.00021100531739648432, 8.6422711319755763e-05, 0.00012801986304111779, 0.00015017739497125149, 0.00015538376464974135, 0.00030057222465984523, 0.00049255293561145663, 5.9171557950321585e-05, 0.00029933132464066148, 0.00047854403965175152, 0.00017852419114205986, 0.00019911720301024616, 0.00011822173109976575, 0.00013881456106901169, 0.00011528178583830595, 9.7380041552241892e-05, 0.00013356233830563724, 0.0002198118600063026, 0.0002312453871127218, 0.00016303057782351971, 0.00020985915034543723, 0.00013210094766691327, 0.00017353365547023714, 0.00042312024743296206, 0.011666893027722836, 8.3914797869510949e-05, } };
const TfArray<96, int> quant29_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant29 = { (TfLiteFloatArray*)&quant29_scale, (TfLiteIntArray*)&quant29_zero, 0 };
const ALIGN(16) int8_t tensor_data30[16*1*1*96] = { 
  /* [0][0][][] */ 0,30,-9,23,41,77,-38,-30,50,7,6,13,-8,15,24,72,3,-5,-5,-9,102,-59,25,-9,-28,-39,-44,-101,-8,-18,49,50,127,-3,9,-6,7,-15,-23,-4,-30,14,28,-35,5,-32,-17,26,-11,20,4,-13,-31,-8,4,-8,39,25,-21,-31,-55,35,-8,-10,12,11,60,8,5,11,2,-24,-73,-8,-11,3,-5,-89,7,-23,54,-17,-55,-45,33,-18,7,23,-5,12,23,-32,32,27,-14,125, 
  /* [1][0][][] */ 72,-100,47,76,-17,-62,-12,-48,-31,-93,4,22,12,-53,-30,-51,-76,2,28,20,-42,-101,-42,24,127,-59,-76,19,-23,102,-25,50,4,5,-51,24,-20,-17,46,-19,5,-76,63,-32,-53,11,60,3,33,23,-11,-68,49,-77,39,-27,13,30,-15,-98,29,-63,19,-42,10,-66,29,25,46,43,-38,8,-92,38,-9,66,24,85,12,-18,39,-2,-74,31,-84,70,4,64,-58,0,19,13,4,-42,36,8, 
  /* [2][0][][] */ 28,14,16,-26,12,-4,0,35,65,-14,9,64,5,8,43,7,-5,-12,17,0,-11,-61,9,-58,-9,-16,-21,26,-1,13,124,-51,25,-63,-14,55,15,127,-43,-26,-3,-14,-2,35,-41,-52,-59,17,28,29,-28,-29,33,0,-2,-30,-18,-1,-5,35,6,9,70,86,9,-80,22,-63,-8,-14,-5,-2,-24,10,-20,12,20,51,8,13,20,90,29,-9,-2,5,10,11,34,12,-9,-43,-37,4,-14,59, 
  /* [3][0][][] */ -14,-20,-41,28,22,-23,-9,-26,-22,16,9,11,2,-12,48,-11,40,-45,15,13,-31,-9,-12,7,-18,11,9,-4,18,-51,60,-21,11,-19,-17,46,-8,-16,-14,8,16,-59,16,-29,-8,-2,7,6,-127,51,-16,25,-116,-52,-24,-44,19,11,-9,48,-8,25,17,20,-12,-89,-32,21,54,14,-7,39,-26,11,-6,-41,-51,-51,29,-33,24,-23,9,68,35,52,31,8,39,-13,-10,2,-29,0,-19,-24, 
  /* [4][0][][] */ -8,-30,17,-70,3,-11,-40,12,-20,-44,-29,-11,5,62,4,3,53,-10,3,8,0,28,45,-7,-6,-3,21,12,3,-2,-5,-9,-38,9,9,16,35,-18,5,-8,14,3,-95,-27,35,-10,-20,-22,2,73,-13,-11,-18,-17,6,-6,-6,-31,25,38,12,7,1,-9,34,-115,12,-24,-44,12,-15,-2,-25,20,-16,34,-21,63,57,6,10,3,127,-42,42,-17,-12,0,70,14,1,19,-37,25,-7,-42, 
  /* [5][0][][] */ -16,-7,-3,-5,-6,-8,-6,110,58,-16,-1,-30,-14,31,38,37,-8,-9,1,-32,-46,-16,-9,-43,14,17,25,76,70,5,67,53,-57,11,3,-4,-52,-61,-34,-9,-32,-11,-11,-3,63,3,13,19,14,17,-20,19,-27,-8,5,-6,-21,-17,-4,35,-59,23,-22,-42,15,11,-25,-10,-1,14,0,11,49,17,17,1,-6,23,16,126,2,-46,22,34,11,-1,18,-32,10,-27,17,-127,-34,-23,-13,-112, 
  /* [6][0][][] */ -27,-4,-15,-58,-9,-23,-21,11,-5,21,-8,-3,35,-63,11,-9,-7,-70,29,8,-1,4,-22,34,87,-11,-3,4,21,-7,13,-8,-30,-6,-33,2,26,-2,16,44,-2,-31,-58,-19,-5,-24,36,-127,25,46,17,12,9,5,-7,-54,40,-8,-4,1,17,18,6,12,43,73,34,-28,-21,-14,11,-14,30,10,49,-6,-33,36,5,7,-13,-6,51,-30,-6,45,22,-21,19,-1,-41,-11,-26,9,-9,18, 
  /* [7][0][][] */ 14,6,35,-21,-6,5,-1,-34,-3,-8,-11,-9,-7,-89,35,7,-9,-29,-13,-15,9,-11,-32,-3,-21,-8,2,-12,7,15,-1,-8,-12,7,-10,-26,5,-8,-33,25,13,-19,-20,27,-6,10,-8,74,-6,19,-10,-18,-24,12,-2,-54,36,8,4,-3,1,4,-8,-5,-16,48,15,-30,-12,-4,10,36,-11,-4,-16,8,48,6,1,-11,1,-32,39,3,-38,127,2,3,-37,-19,-1,22,-19,4,-3,2, 
  /* [8][0][][] */ -75,43,-55,2,27,-9,-17,28,16,73,-43,14,1,40,74,-10,-1,37,-77,27,19,26,-26,13,-38,-18,21,17,51,-93,2,-3,17,4,13,-1,-16,15,-44,46,16,15,9,-127,-41,-9,49,-9,-39,31,6,73,-107,92,13,-14,5,-24,-20,-30,-11,-39,4,18,-30,46,27,-27,-8,-2,18,89,-26,28,40,35,-3,-85,-6,-39,-12,-10,27,0,-58,6,17,-38,4,43,-22,1,23,-16,-24,-8, 
  /* [9][0][][] */ 35,-59,-30,-43,20,25,-25,22,23,-25,3,15,-47,-15,-3,13,4,-1,35,-19,-25,17,-34,-39,40,12,16,-22,-29,-35,-19,5,-17,20,18,42,1,50,-39,10,4,20,-24,-89,16,-7,21,-127,-27,8,4,20,-26,11,-22,7,-36,21,-12,11,8,10,12,38,29,108,34,49,9,-15,8,-20,-9,-4,-30,6,68,3,10,3,0,0,3,-51,6,29,-3,-11,-44,35,-29,9,11,5,3,-9, 
  /* [10][0][][] */ 21,41,-24,29,70,-117,-12,-40,-6,55,40,-2,-18,13,21,-92,12,34,-26,38,-89,-13,-18,-42,-67,-32,-58,57,12,23,-6,32,-17,-14,28,-18,84,-16,-14,2,-12,56,43,-28,-60,-16,-35,6,-30,-32,-43,7,-13,-27,8,-14,7,34,-24,-14,-2,2,-15,23,16,51,50,18,28,1,30,47,-49,-23,-58,-8,-2,22,-13,20,15,-13,-68,-29,51,-41,102,-4,-28,11,22,-15,78,39,-10,-127, 
  /* [11][0][][] */ 34,37,-34,23,-15,11,51,-3,-7,-12,-27,-8,-6,2,41,2,-9,-9,-94,-9,-8,11,11,-4,-49,-21,-6,10,0,17,3,-8,-10,1,4,18,9,4,-9,18,11,28,58,-93,22,-39,9,0,-127,15,11,-47,22,18,-11,6,-21,-16,8,-1,11,-12,-3,8,-55,56,-19,4,16,2,23,17,-49,-35,8,26,-10,-40,-53,4,8,-4,88,45,3,-14,-19,-2,-2,22,-20,-6,-10,7,-19,9, 
  /* [12][0][][] */ -35,-4,-2,2,-32,36,14,3,127,10,-18,3,-2,10,-35,-35,25,24,14,77,49,29,-3,-19,0,9,23,-27,-108,1,37,-39,7,-12,-4,-24,18,-11,38,-4,-44,-9,-8,16,2,26,21,2,28,15,-43,9,9,9,11,-11,74,-22,14,10,15,-7,20,-10,-11,25,-35,2,2,6,-23,-30,20,12,-68,5,32,-5,9,-64,-11,12,40,43,-16,-21,-31,-23,15,10,-5,42,-21,-25,15,6, 
  /* [13][0][][] */ 33,-15,-23,29,30,-1,9,2,-4,1,12,-2,13,-10,11,-7,19,-66,-31,17,-7,-21,8,8,6,15,-1,-3,-14,-36,-4,21,2,5,10,48,17,-6,3,22,2,14,22,35,22,10,-17,-127,24,4,5,11,-15,0,20,4,-19,19,28,14,6,25,-3,5,-11,-21,-12,-61,7,15,-6,-25,-11,47,-6,21,-30,2,16,-2,33,-8,-14,20,14,28,11,18,3,2,22,-3,2,18,-12,-6, 
  /* [14][0][][] */ -121,-50,20,51,30,-34,-30,3,-27,16,-12,15,60,-1,-126,-12,72,-23,-15,21,-23,1,42,12,-120,-2,32,-5,-48,-77,-39,-7,-8,13,24,-77,35,45,-4,14,22,35,-4,-42,14,127,65,55,-126,43,10,33,-58,-11,34,-3,8,6,64,60,40,47,9,53,-9,-16,-49,52,2,82,-52,-90,-91,-9,-9,46,-11,41,87,5,47,14,33,24,37,12,47,33,21,50,68,0,6,28,29,-32, 
  /* [15][0][][] */ 89,-23,38,11,1,78,45,-30,-18,65,5,6,-94,-18,-7,30,-2,45,52,-34,11,22,-82,76,12,8,51,8,20,51,-72,-87,21,-38,47,-4,43,-23,-68,-119,2,27,9,44,-10,51,-23,-43,96,-55,-49,29,45,-127,61,-120,-1,-64,20,30,-117,-5,21,15,84,-13,-61,47,-34,90,-18,27,30,17,12,2,25,-63,74,-19,-22,-3,47,89,-26,3,-5,-52,-14,7,74,5,-62,71,31,-19, 
};
const TfArray<4, int> tensor_dimension30 = { 4, { 16,1,1,96 } };
const TfArray<16, float> quant30_scale = { 16, { 0.015152690000832081, 0.011157605797052383, 0.010425656102597713, 0.0093330349773168564, 0.013096440583467484, 0.014585273340344429, 0.012273138388991356, 0.015567348338663578, 0.0086875660344958305, 0.010843319818377495, 0.014463200233876705, 0.029227182269096375, 0.018623040989041328, 0.017265209928154945, 0.019294852390885353, 0.011282136663794518, } };
const TfArray<16, int> quant30_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant30 = { (TfLiteFloatArray*)&quant30_scale, (TfLiteIntArray*)&quant30_zero, 0 };
const ALIGN(16) int32_t tensor_data31[16] = { -2442, -6038, -9825, 29132, 30403, -2201, -11111, -4767, 19875, 794, 31404, 25837, -12200, 9733, 46416, -22783, };
const TfArray<1, int> tensor_dimension31 = { 1, { 16 } };
const TfArray<16, float> quant31_scale = { 16, { 0.00035653388476930559, 0.00026253191754221916, 0.00024530955124646425, 0.00021960082813166082, 0.00030815156060270965, 0.00034318291000090539, 0.00028877973090857267, 0.00036629056558012962, 0.00020441332890186459, 0.00025513695436529815, 0.00034031059476546943, 0.00068769842619076371, 0.00043818922131322324, 0.00040624022949486971, 0.0004539965302683413, 0.0002654620329849422, } };
const TfArray<16, int> quant31_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant31 = { (TfLiteFloatArray*)&quant31_scale, (TfLiteIntArray*)&quant31_zero, 0 };
const ALIGN(16) int8_t tensor_data32[96*1*1*16] = { 
  /* [0][0][][] */ 15,64,-23,78,49,24,3,-18,32,30,-53,111,7,-120,61,-127, 
  /* [1][0][][] */ 30,55,-10,-23,29,-29,127,-122,3,88,-21,-24,-2,-50,31,10, 
  /* [2][0][][] */ -127,44,-31,-23,-7,-16,48,97,-35,50,105,-22,-70,25,18,-58, 
  /* [3][0][][] */ -113,67,51,29,-79,58,99,127,-20,69,-113,10,55,-103,-68,-59, 
  /* [4][0][][] */ 3,3,33,65,-23,64,0,45,10,-23,8,-10,17,-7,-127,-24, 
  /* [5][0][][] */ -4,-27,60,-15,6,-27,-1,28,-58,109,-27,-127,-9,24,-62,-25, 
  /* [6][0][][] */ 15,5,40,-1,37,67,-53,-58,1,-10,39,-11,127,-12,-23,-43, 
  /* [7][0][][] */ 17,8,127,-11,-15,-47,7,-7,-88,31,-68,-51,-1,-23,31,-10, 
  /* [8][0][][] */ 4,32,70,45,-54,67,31,41,32,3,18,-73,-23,-1,-127,-63, 
  /* [9][0][][] */ 28,-127,67,63,-1,-24,17,42,121,29,73,-1,-22,-2,-121,-34, 
  /* [10][0][][] */ -32,-123,-9,-40,-119,-6,-20,53,86,127,61,-49,-36,52,118,19, 
  /* [11][0][][] */ 40,-23,17,-115,27,-39,-124,-127,-80,58,-1,-46,34,-36,45,-66, 
  /* [12][0][][] */ -7,11,12,-29,-36,-24,-85,7,-51,-74,-12,30,42,127,106,47, 
  /* [13][0][][] */ -55,-100,-67,47,7,-77,14,-12,69,17,-28,-8,42,49,127,13, 
  /* [14][0][][] */ -8,-52,53,13,36,21,16,127,24,46,26,-21,6,34,-47,125, 
  /* [15][0][][] */ 28,-40,-1,57,21,0,94,-9,8,-127,19,-49,-3,-33,-2,-26, 
  /* [16][0][][] */ 54,-90,-33,42,25,14,35,-67,127,72,93,-2,13,101,59,110, 
  /* [17][0][][] */ -65,-86,60,124,127,52,-3,-36,121,-50,0,-41,11,35,-104,29, 
  /* [18][0][][] */ -18,10,4,12,-89,-19,-10,31,-70,-14,-4,-60,-15,-127,60,-2, 
  /* [19][0][][] */ 74,-67,71,-61,112,45,-107,107,127,-67,76,54,-9,93,32,121, 
  /* [20][0][][] */ 36,-12,58,-65,-15,5,-18,57,-8,-43,100,-1,24,12,-31,127, 
  /* [21][0][][] */ -63,-19,-6,-34,10,14,-82,-44,-14,64,-10,11,-127,-10,31,-2, 
  /* [22][0][][] */ 21,-31,25,-11,14,-69,16,-8,-127,43,-5,-55,-21,-21,77,-19, 
  /* [23][0][][] */ 24,3,16,-7,7,14,-10,0,-4,0,41,-20,127,-7,2,-37, 
  /* [24][0][][] */ -15,11,-7,-64,-30,-15,53,11,-47,-3,-11,-127,8,-91,43,11, 
  /* [25][0][][] */ -97,-4,-37,-22,85,-16,-75,-127,-75,55,-34,-47,-67,-90,22,-54, 
  /* [26][0][][] */ 25,3,55,-101,127,-23,-8,10,112,-56,18,-28,-14,93,-4,67, 
  /* [27][0][][] */ 91,-20,23,-25,-31,-46,-7,-21,-19,14,-127,19,14,-11,0,31, 
  /* [28][0][][] */ -106,-30,-127,-81,68,-12,68,-59,-12,51,-67,5,42,-14,-42,47, 
  /* [29][0][][] */ -52,-27,5,127,-15,27,16,-30,-2,6,-77,35,32,-56,15,-40, 
  /* [30][0][][] */ 68,-2,127,-6,51,54,-27,78,-22,-62,44,-44,-7,35,-90,62, 
  /* [31][0][][] */ 16,-89,0,-51,-4,-64,20,-32,-7,45,100,21,-17,101,75,127, 
  /* [32][0][][] */ -17,78,-36,38,-127,21,-70,-34,-52,-40,2,56,14,55,35,62, 
  /* [33][0][][] */ 29,0,26,127,22,4,27,-43,-93,47,52,-11,5,-3,-3,85, 
  /* [34][0][][] */ 36,0,14,-15,79,-47,-127,-17,-52,106,-35,-7,-28,2,-8,16, 
  /* [35][0][][] */ 74,8,-26,-3,23,-127,-27,-11,-17,3,-74,1,67,27,2,21, 
  /* [36][0][][] */ 21,-7,-127,-1,52,5,-37,21,-37,-23,9,-20,-5,13,-19,13, 
  /* [37][0][][] */ 8,-2,127,4,-38,25,24,-44,-8,29,-43,15,21,-1,8,-15, 
  /* [38][0][][] */ -127,30,-14,29,25,72,24,-26,-1,-6,103,-37,-23,9,-8,-22, 
  /* [39][0][][] */ -21,-9,9,32,28,-17,-127,33,9,30,-1,-36,-1,-24,2,-2, 
  /* [40][0][][] */ -16,81,-31,127,8,26,62,47,-47,-25,-38,60,28,54,-82,-27, 
  /* [41][0][][] */ 14,21,-50,-12,-65,5,127,102,-44,100,-36,0,-4,82,39,-18, 
  /* [42][0][][] */ 24,-55,-34,-45,14,-10,-69,35,46,-109,127,27,-22,0,-34,54, 
  /* [43][0][][] */ -64,-18,56,-57,53,23,-82,-107,-47,53,0,-40,-127,-23,35,-16, 
  /* [44][0][][] */ -1,6,-18,-6,0,-27,-5,-48,127,-2,19,53,26,86,3,41, 
  /* [45][0][][] */ -65,-76,-4,-105,41,-27,3,46,-3,-67,2,-25,27,76,-21,127, 
  /* [46][0][][] */ -38,30,-33,110,-76,-19,19,-71,-127,68,-55,-25,-3,32,-4,-56, 
  /* [47][0][][] */ -19,-13,-77,127,14,37,-4,-20,16,53,48,48,-21,-7,18,-15, 
  /* [48][0][][] */ -8,24,31,-111,31,-26,-5,0,-29,32,12,-6,-4,90,127,42, 
  /* [49][0][][] */ -2,26,50,105,10,39,-27,2,35,-36,-57,-26,-20,-17,-58,-127, 
  /* [50][0][][] */ 7,65,31,-118,68,17,-40,62,127,-32,-39,6,5,-34,14,-25, 
  /* [51][0][][] */ 25,-38,34,-6,54,2,-66,-127,17,-109,-11,17,2,-6,-7,2, 
  /* [52][0][][] */ 12,24,-19,39,37,-23,-74,127,-79,126,-34,-20,95,104,19,-38, 
  /* [53][0][][] */ -23,115,14,-89,-22,4,41,-24,-55,-49,-58,61,21,-127,-108,-26, 
  /* [54][0][][] */ -1,12,24,32,49,-29,9,-34,-12,32,-4,-20,-8,127,-43,-15, 
  /* [55][0][][] */ -107,111,85,-34,54,-12,-23,-6,-63,40,124,-36,-16,-45,127,5, 
  /* [56][0][][] */ 46,14,6,-94,76,-11,5,27,57,-49,47,127,-25,28,82,43, 
  /* [57][0][][] */ -30,4,23,90,-25,13,45,127,0,21,0,-36,2,55,-13,10, 
  /* [58][0][][] */ 12,124,9,-127,17,35,-17,18,105,-10,-5,79,1,-86,41,66, 
  /* [59][0][][] */ 39,61,56,-119,-32,-16,17,-17,25,28,40,-63,-20,-127,-73,16, 
  /* [60][0][][] */ 52,-14,117,-41,-38,127,23,-28,-19,22,-55,-22,31,11,22,-8, 
  /* [61][0][][] */ -30,28,-49,-39,-55,16,127,126,-27,95,-25,1,-1,93,8,-48, 
  /* [62][0][][] */ -15,-14,-1,0,-72,34,-72,10,-33,-28,16,-61,-3,-127,106,6, 
  /* [63][0][][] */ 21,-40,16,-100,61,0,-127,-125,-81,114,-6,5,63,-7,33,-53, 
  /* [64][0][][] */ -16,0,35,37,63,2,-32,-127,15,-118,-10,-30,-17,-15,-7,16, 
  /* [65][0][][] */ -127,11,32,-87,22,86,60,-60,-101,34,60,-17,-4,14,-21,-24, 
  /* [66][0][][] */ 56,9,81,6,-47,2,-37,26,-46,-18,66,-91,-42,36,-127,-22, 
  /* [67][0][][] */ 38,-20,-44,61,51,-68,-72,-96,26,-127,-60,-15,-88,7,-75,22, 
  /* [68][0][][] */ -3,-12,-79,79,-49,-112,14,-43,-32,-5,42,-59,-27,84,127,-48, 
  /* [69][0][][] */ -18,24,-84,66,-2,-127,41,102,40,13,62,-33,115,40,-28,6, 
  /* [70][0][][] */ 14,12,-41,-40,-54,3,127,109,-36,46,-26,8,21,48,18,-5, 
  /* [71][0][][] */ -9,2,-38,-45,2,-8,7,61,-24,-41,6,3,12,-127,85,18, 
  /* [72][0][][] */ 30,21,-14,55,10,-46,-31,-127,11,66,-54,10,40,62,52,38, 
  /* [73][0][][] */ -41,-127,-31,-69,-83,-10,29,-43,-16,2,-43,-35,19,-36,57,-12, 
  /* [74][0][][] */ -27,25,63,105,-9,7,-127,96,21,-28,-40,-45,-4,-11,-16,3, 
  /* [75][0][][] */ -60,29,-38,10,-22,83,88,127,-9,55,4,-39,-118,73,14,26, 
  /* [76][0][][] */ 9,-23,-24,-16,46,-68,-127,-102,-8,-18,-11,-12,44,0,49,-38, 
  /* [77][0][][] */ -33,3,-39,-29,-45,-6,-16,-47,127,0,-61,13,-11,44,30,-75, 
  /* [78][0][][] */ -87,-127,-7,78,50,55,-40,18,-2,-62,-95,85,50,-18,97,70, 
  /* [79][0][][] */ 41,-17,30,-48,127,8,44,14,78,23,1,24,-8,-24,14,-26, 
  /* [80][0][][] */ -9,-30,68,-103,-14,-48,1,19,-75,-45,-8,-49,2,127,-31,11, 
  /* [81][0][][] */ 20,-12,48,22,11,39,-33,-30,3,-23,8,-47,-20,27,-127,26, 
  /* [82][0][][] */ -69,-20,27,-111,2,-40,14,-30,-55,-5,-23,-127,-24,-110,-86,13, 
  /* [83][0][][] */ 1,4,-20,-60,-47,7,-9,34,-80,-1,15,-70,22,-127,6,31, 
  /* [84][0][][] */ 127,42,31,38,-50,10,-74,13,2,-30,118,21,-93,20,94,-87, 
  /* [85][0][][] */ 6,-30,16,-41,44,-3,-56,97,-72,-127,-61,-24,-33,67,85,-111, 
  /* [86][0][][] */ 34,-7,14,-3,-39,57,-40,40,-67,-33,30,-39,-26,-127,-18,34, 
  /* [87][0][][] */ 127,-42,24,6,-36,-20,5,5,2,16,-108,21,45,6,-5,36, 
  /* [88][0][][] */ 33,67,-22,-14,-8,-26,-2,3,88,40,42,27,-13,-47,127,-100, 
  /* [89][0][][] */ 50,61,-73,-24,-23,-15,19,-65,41,48,25,-38,-43,-8,-20,-127, 
  /* [90][0][][] */ -7,-16,-8,-81,-70,16,127,-51,92,-72,24,-63,51,-17,-20,-2, 
  /* [91][0][][] */ 3,13,-30,-82,-37,-6,35,-35,-59,25,71,46,15,-23,30,127, 
  /* [92][0][][] */ 21,7,11,16,46,-14,-79,-127,52,-58,5,-19,-16,-4,5,-29, 
  /* [93][0][][] */ 62,-3,22,-127,-41,-15,-15,49,32,-60,86,-27,-33,93,-15,34, 
  /* [94][0][][] */ -122,71,-102,31,64,-127,1,14,-4,-52,87,-12,14,2,-45,-29, 
  /* [95][0][][] */ -17,43,27,-127,-5,8,-18,3,5,-39,-72,-84,-3,43,-70,-16, 
};
const TfArray<4, int> tensor_dimension32 = { 4, { 96,1,1,16 } };
const TfArray<96, float> quant32_scale = { 96, { 0.00079746532719582319, 0.00062138261273503304, 0.00043709226883947849, 0.00015314023767132312, 0.00049411901272833347, 0.00082674471195787191, 0.0016306866891682148, 0.0011203759349882603, 0.00020913407206535339, 0.0010902109788730741, 0.00066691741812974215, 0.00052745651919394732, 0.00040833459934219718, 0.00058748316951096058, 0.00033713984885253012, 0.001457936828956008, 0.00056184164714068174, 0.00053596746874973178, 0.00053368310909718275, 0.0004355013370513916, 0.0010067468974739313, 0.001963677816092968, 0.00055923656327649951, 0.0020290950778871775, 0.0019186052959412336, 0.00076777930371463299, 0.00046243137330748141, 0.0007689407211728394, 0.000862772052641958, 0.00025399669539183378, 0.00020797754405066371, 0.00032448265119455755, 0.00077108055120334029, 0.0010099734645336866, 0.00061263889074325562, 0.00083205039845779538, 0.0010037405882030725, 0.001262611011043191, 0.00052116077858954668, 0.0027192789129912853, 0.00032150387414731085, 0.00046024870243854821, 0.00016978741041384637, 0.00076989654917269945, 0.00037307199090719223, 0.00059404881903901696, 0.00060231483075767756, 0.00078969000605866313, 0.00016680746921338141, 0.00060858775395900011, 0.00061673979507759213, 0.00049703859258443117, 0.00078195478999987245, 0.00074044236680492759, 0.0013660492841154337, 0.0004895160673186183, 0.0004240857670083642, 0.00028886093059554696, 0.00099318171851336956, 0.00056024797959253192, 0.00079390837345272303, 0.00022971675207372755, 0.00061614508740603924, 0.00049191102152690291, 0.00068196706706658006, 0.00072612467920407653, 0.00086880673188716173, 0.00069647294003516436, 0.00082130770897492766, 0.00065391469979658723, 0.00062649237224832177, 0.00049524992937222123, 0.00039820908568799496, 0.00057669723173603415, 0.0010587669676169753, 0.00086801254656165838, 0.00076453463407233357, 0.0010177198564633727, 0.0010523959062993526, 0.0010089414427056909, 0.00042272720020264387, 0.00045849845628254116, 0.00057326321257278323, 0.00044472358422353864, 0.00095463439356535673, 0.00073875149246305227, 0.00080929556861519814, 0.00018380045366939157, 0.00047995673958212137, 0.00071764434687793255, 0.00076517910929396749, 0.001091054524295032, 0.00068198441294953227, 0.00056296546244993806, 0.00058325985446572304, 0.00052864733152091503, } };
const TfArray<96, int> quant32_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant32 = { (TfLiteFloatArray*)&quant32_scale, (TfLiteIntArray*)&quant32_zero, 0 };
const ALIGN(16) int32_t tensor_data33[96] = { 1362, 6358, 11675, 40289, 16136, -3311, -1320, 3908, 30136, -3366, 10770, 4409, 8177, 10533, 18806, 1002, 2055, 6183, 11067, 7159, -210, 277, 9430, -821, 3620, 1, 12769, 4999, 4986, 37086, 36242, 20254, 5739, -617, 8738, 1941, 1407, 3129, 13672, -545, 15605, 9034, 42500, -3701, 23339, 6920, 7769, 8892, 66308, 9311, -527, 8974, -3611, -197, -1966, 5909, -869, 17226, 5478, 7010, 5407, 15961, 6464, 5254, 9623, 7015, 3949, -4983, 5499, -2920, 4723, 8418, 13993, 4855, -3857, -4147, 5811, 266, 1963, -1001, 12979, 9676, 3987, 11734, 3267, 160, 7656, 56154, 8059, 8321, 4358, -109, 5687, 7657, 5066, 8651, };
const TfArray<1, int> tensor_dimension33 = { 1, { 96 } };
const TfArray<96, float> quant33_scale = { 96, { 0.00029912445461377501, 0.00023307689116336405, 0.00016395068087149411, 5.7441982789896429e-05, 0.000185341079486534, 0.00031010698876343668, 0.00061166076920926571, 0.00042024627327919006, 7.8444936661981046e-05, 0.00040893160621635616, 0.00025015670689754188, 0.00019784577307291329, 0.00015316385542973876, 0.00022036141308490187, 0.00012645912647712976, 0.00054686336079612374, 0.0002107434265781194, 0.00020103818678762764, 0.00020018132636323571, 0.00016335393593180925, 0.00037762470310553908, 0.0007365637575276196, 0.00020976628002244979, 0.00076110137160867453, 0.00071965734241530299, 0.00028798941639252007, 0.00017345523519907147, 0.00028842504252679646, 0.00032362062484025955, 9.5272633188869804e-05, 7.8011129517108202e-05, 0.00012171149137429893, 0.00028922769706696272, 0.00037883498589508235, 0.0002297971659572795, 0.00031209710869006813, 0.00037649707519449294, 0.00047359781456179917, 0.00019548427371773869, 0.001019985182210803, 0.00012059417349519208, 0.00017263652989640832, 6.3686238718219101e-05, 0.00028878357261419296, 0.00013993706670589745, 0.00022282415011432022, 0.00022592468303628266, 0.00029620798886753619, 6.2568477005697787e-05, 0.00022827761131338775, 0.00023133539070840925, 0.00018643619841895998, 0.00029330654069781303, 0.00027773549663834274, 0.00051239685853943229, 0.00018361453840043396, 0.00015907202032394707, 0.00010835000284714624, 0.00037253650953061879, 0.00021014564845245332, 0.00029779027681797743, 8.6165375250857323e-05, 0.00023111232439987361, 0.00018451287178322673, 0.00025580174406059086, 0.00027236499590799212, 0.00032588417525403202, 0.00026124282157979906, 0.00030806759605184197, 0.00024527948698960245, 0.00023499352391809225, 0.00018576528236735612, 0.00014936583465896547, 0.00021631567506119609, 0.00039713713340461254, 0.00032558629754930735, 0.00028677235241048038, 0.00038174059591256082, 0.00039474738878197968, 0.00037844787584617734, 0.00015856244135648012, 0.00017198002024088055, 0.00021502758318092674, 0.00016681314446032047, 0.00035807763924822211, 0.00027710123686119914, 0.0003035619156435132, 6.8942448706366122e-05, 0.00018002888828050345, 0.00026918409275822341, 0.00028701408882625401, 0.00040924799395725131, 0.00025580826331861317, 0.00021116496645845473, 0.00021877727704122663, 0.00019829244411084801, } };
const TfArray<96, int> quant33_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant33 = { (TfLiteFloatArray*)&quant33_scale, (TfLiteIntArray*)&quant33_zero, 0 };
const ALIGN(16) int8_t tensor_data34[1*3*3*96] = { 
  /* [0][0][][] */ -46,-71,-10,127,22,73,78,-59,-14,-18,-15,-4,-28,0,36,1,-10,-43,26,22,18,-127,127,6,-83,9,50,-28,-125,-127,39,24,12,23,60,-19,-30,-11,29,-7,-12,27,-108,71,25,-69,36,45,-18,52,-24,21,3,-7,14,48,-89,-49,-62,-19,-11,1,10,38,69,-24,76,15,-8,17,19,127,23,22,26,0,-11,19,127,-6,-15,14,-26,21,127,23,-76,-15,-3,-32,-15,-41,1,-26,-15,25, 127,-127,74,106,-43,127,42,-119,71,4,-17,127,127,-98,-13,16,10,127,127,-112,127,-72,82,69,-127,-112,-65,-33,-54,45,-59,-20,-89,50,-127,-87,-43,-15,-53,60,0,127,127,84,-50,-115,-114,-51,-15,-127,42,86,67,-31,45,84,-48,42,-81,-114,-45,-42,-61,66,73,-61,27,32,-81,33,-18,91,117,127,13,21,2,59,-33,55,64,127,127,-23,-7,78,-109,127,-124,-100,4,-127,-90,-127,-37,105, -73,-12,28,-82,14,-27,65,-8,81,-35,-27,19,-17,-5,-10,-12,-10,-15,7,-4,-23,-108,30,-1,-120,99,8,-54,118,48,-14,10,3,13,13,-31,-9,33,19,14,25,12,-118,66,17,-20,35,14,-15,11,-17,5,-10,1,-2,21,-65,6,-35,54,2,41,33,-1,-7,-38,-30,25,10,3,-3,36,10,-27,-6,4,-11,-6,-85,2,-22,-24,-18,2,-111,9,-33,-21,-53,23,-25,-29,29,-27,-14,1, 
  /* [0][1][][] */ -63,-74,73,-35,-48,95,19,127,-52,-22,-1,-117,26,-115,79,29,-3,-59,-17,89,51,-71,47,48,-95,-9,127,-22,-26,63,121,-103,-127,87,-86,-58,-36,32,-30,95,-48,-27,-5,47,-48,127,-24,65,16,95,20,-1,12,-55,26,31,127,122,-72,-86,127,-32,-36,127,72,-36,-14,0,127,41,127,98,-41,102,-6,11,14,13,-32,9,-44,122,-77,110,1,33,-54,30,78,-127,-32,-10,127,-69,-23,0, 67,126,55,-113,127,82,88,37,-127,127,127,-38,-63,-127,-127,127,127,-62,-125,-50,101,103,-122,127,-105,-87,-43,127,-127,109,-127,-127,-87,127,107,127,127,-127,-106,127,-64,-97,110,-127,-127,-36,-127,-127,127,-112,85,44,127,127,127,-127,100,-127,-127,127,19,-80,-127,-100,-127,127,-127,127,-126,-127,-108,-82,-127,-80,127,127,-127,127,-77,127,127,30,-40,-127,60,127,94,45,127,11,127,-3,-67,33,127,-127, -52,-13,-51,38,-57,-100,35,-28,19,-34,-29,94,3,93,13,11,-5,65,-7,127,0,-90,-41,6,-70,105,-70,-19,-68,-17,17,-61,-69,38,5,-19,-29,44,-68,41,127,-5,-38,32,-40,-60,16,45,8,117,-11,7,-38,-73,4,19,95,2,1,24,-36,127,92,-52,-44,13,39,-9,-76,122,-18,-86,-1,-55,-17,-21,27,15,77,-37,-72,-42,55,14,-48,-19,73,23,14,60,-43,23,-43,94,-26,-6, 
  /* [0][2][][] */ -65,1,-4,-20,13,-47,63,25,54,-29,-36,-1,19,18,-26,0,-8,65,6,1,-54,-86,1,-10,-27,-50,34,-68,88,38,26,25,15,-9,-11,-48,-7,35,-3,1,-14,-7,-68,106,3,30,10,35,-16,-32,10,-19,21,-1,8,13,-69,24,-15,14,16,0,-22,-5,-1,-45,-46,16,-32,16,25,29,13,-20,26,4,17,4,-78,-13,-9,-9,18,13,-127,4,13,-42,-61,-51,-27,-52,10,55,-18,-9, 121,34,-127,-34,-72,-28,35,30,-64,-30,-19,-107,-74,112,-14,37,2,-50,-10,-125,94,-48,-39,1,-108,127,-51,21,-36,-21,-8,-4,-62,17,27,4,-23,-29,127,54,11,-14,68,-33,-39,75,-70,-45,-33,-7,-127,-127,-49,-26,3,39,-64,-7,11,38,-8,-18,9,-47,-54,34,66,-22,115,109,-25,-68,11,-59,2,4,100,3,52,21,11,-97,-49,3,2,7,127,40,-63,38,-18,-110,42,76,-9,25, -52,13,-20,26,16,-70,-127,1,-12,-8,-16,6,16,-26,18,-2,-9,-16,4,17,-49,-74,14,-1,16,-92,21,4,-47,-39,-6,17,44,-18,-7,-26,-35,3,42,-41,23,-3,-48,-31,2,63,22,16,-9,-4,9,-9,19,5,-3,-6,-60,-13,3,-36,-12,10,83,-11,34,-1,-1,29,2,6,-4,19,-19,15,-1,14,36,0,75,-13,2,-10,-9,-19,75,-2,44,-38,58,37,-17,-52,-8,1,-14,-16, 
};
const TfArray<4, int> tensor_dimension34 = { 4, { 1,3,3,96 } };
const TfArray<96, float> quant34_scale = { 96, { 0.0047714323736727238, 0.0040840646252036095, 0.0050519201904535294, 0.012116926722228527, 0.013493308797478676, 0.0088956020772457123, 0.0030639388132840395, 0.0044553331099450588, 0.012265651486814022, 0.0070961993187665939, 0.010057980194687843, 0.0049619101919233799, 0.014862191863358021, 0.0091050853952765465, 0.019026901572942734, 0.0065806363709270954, 0.0081172389909625053, 0.0079526631161570549, 0.0093817878514528275, 0.0036390321329236031, 0.0022594511974602938, 0.0020174863748252392, 0.0070351492613554001, 0.0041695097461342812, 0.0034767023753374815, 0.0042288322001695633, 0.0081954142078757286, 0.0077703730203211308, 0.003125394694507122, 0.022734722122550011, 0.019644828513264656, 0.010040551424026489, 0.0053270314820110798, 0.0067643634974956512, 0.013239437714219093, 0.018105687573552132, 0.018721804022789001, 0.0099927885457873344, 0.013683157041668892, 0.0040392228402197361, 0.0095273461192846298, 0.012713768519461155, 0.017353549599647522, 0.0029405122622847557, 0.016214791685342789, 0.0052990908734500408, 0.0054776486940681934, 0.012252555228769779, 0.035149559378623962, 0.0054382826201617718, 0.022786732763051987, 0.0102840606123209, 0.010730160400271416, 0.0071497424505650997, 0.0099710533395409584, 0.0057939975522458553, 0.0093069598078727722, 0.019447609782218933, 0.0022155113983899355, 0.00724445516243577, 0.016637776046991348, 0.015593504533171654, 0.0043492550030350685, 0.0067695649340748787, 0.0070459707640111446, 0.0066176792606711388, 0.013100235722959042, 0.0092950239777565002, 0.0085785510018467903, 0.005522165447473526, 0.010972841642796993, 0.0044496180489659309, 0.011972703039646149, 0.006801975890994072, 0.01559002511203289, 0.013912699185311794, 0.0083219446241855621, 0.0034962627105414867, 0.0027317490894347429, 0.0061321426182985306, 0.011336782947182655, 0.011860470287501812, 0.0082838227972388268, 0.011346491053700447, 0.0029276562854647636, 0.004960332065820694, 0.0037179398350417614, 0.024673540145158768, 0.010927539318799973, 0.0056322435848414898, 0.015775423496961594, 0.0010801417520269752, 0.0072840661741793156, 0.0060472898185253143, 0.017947720363736153, 0.012901898473501205, } };
const TfArray<96, int> quant34_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant34 = { (TfLiteFloatArray*)&quant34_scale, (TfLiteIntArray*)&quant34_zero, 3 };
const ALIGN(16) int32_t tensor_data35[96] = { 20192, 60190, -661, -748, 12049, -3623, 401, 100, 4987, 14601, -4557, -607, 58, 5134, 5027, -8968, -3710, -999, -47, 12839, -11867, 12659, -3877, 7874, 21851, -405, -5656, 16706, 13445, -18399, 958, 21821, 23714, -9933, 2320, 483, 285, 11, 4434, -7661, -6186, 33, -4617, 414, 31043, -1172, 14685, -1461, -13037, 2157, 46, -502, -1908, 16680, -3628, 12088, 12878, -159, 35168, -102, -7727, -800, 918, -286, -2441, 12133, -1785, -9707, -3303, 3261, 53, -4993, 1080, 440, -1840, -5558, -1120, -1379, 39814, -8366, -4988, -11079, 28, -191, 51845, -12930, -10296, -27615, -6116, 10448, -2083, 38301, 190, -1517, -2096, 922, };
const TfArray<1, int> tensor_dimension35 = { 1, { 96 } };
const TfArray<96, float> quant35_scale = { 96, { 0.00011226900096517056, 9.6095638582482934e-05, 0.00011886870925081894, 0.00028510414995253086, 0.00031748961191624403, 0.0002093082875944674, 7.2092676418833435e-05, 0.00010483137157279998, 0.00028860356542281806, 0.00016696940292604268, 0.00023665836488362402, 0.00011675083078444004, 0.00034969864645972848, 0.00021423731232061982, 0.00044769179658032954, 0.00015483850438613445, 0.00019099385826848447, 0.00018712149176280946, 0.00022074795560911298, 8.5624284110963345e-05, 5.3163559641689062e-05, 4.7470268327742815e-05, 0.00016553292516618967, 9.810611663851887e-05, 8.1804762885440141e-05, 9.9501936347223818e-05, 0.00019283327856101096, 0.00018283231474924833, 7.3538700235076249e-05, 0.00053493463201448321, 0.00046223125536926091, 0.00023624827736057341, 0.00012534191773738712, 0.0001591615000506863, 0.00031151619623415172, 0.00042601619497872889, 0.0004405130457598716, 0.00023512444749940187, 0.00032195664243772626, 9.5040537416934967e-05, 0.00022417285072151572, 0.00029914750484749675, 0.00040831882506608963, 6.9188521592877805e-05, 0.00038152452907525003, 0.00012468449131119996, 0.0001288858475163579, 0.00028829541406594217, 0.0008270484977401793, 0.00012795958900824189, 0.00053615844808518887, 0.00024197790480684489, 0.00025247436133213341, 0.00016822923498693854, 0.00023461302043870091, 0.00013632935588248074, 0.00021898729028180242, 0.00045759082422591746, 5.2129682444501668e-05, 0.00017045777349267155, 0.00039147707866504788, 0.00036690599517896771, 0.00010233541252091527, 0.00015928388165775687, 0.00016578755457885563, 0.00015571010590065271, 0.00030824085115455091, 0.00021870645286981016, 0.00020184826280456036, 0.00012993330892641097, 0.00025818450376391411, 0.00010469689732417464, 0.00028171067242510617, 0.00016004648932721466, 0.00036682412610389292, 0.00032735764398239553, 0.00019581046944949776, 8.2265003584325314e-05, 6.4276449847966433e-05, 0.00014428571739699692, 0.00026674784021452069, 0.00027906990726478398, 0.000194913474842906, 0.0002669762761797756, 6.8886030931025743e-05, 0.00011671370157273486, 8.7480941147077829e-05, 0.00058055389672517776, 0.00025711857597343624, 0.00013252337521407753, 0.00037118644104339182, 2.5415100026293658e-05, 0.00017138979455921799, 0.00014228918007574975, 0.00042229931568726897, 0.00030357408104464412, } };
const TfArray<96, int> quant35_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant35 = { (TfLiteFloatArray*)&quant35_scale, (TfLiteIntArray*)&quant35_zero, 0 };
const ALIGN(16) int8_t tensor_data36[16*1*1*96] = { 
  /* [0][0][][] */ -12,-20,9,-33,27,-11,-40,-9,18,-2,-8,11,-16,-13,-24,0,1,-2,4,-7,14,-36,13,6,0,16,6,127,31,-37,43,-13,1,0,6,-3,-12,17,-50,-2,-11,7,-2,41,3,6,18,11,23,4,-13,2,16,-17,-15,88,1,10,-33,-39,-6,27,-4,-22,-42,-65,-19,40,1,8,21,-12,-12,-30,-9,-17,-20,16,-1,10,-8,-28,36,19,2,-17,-13,-92,7,-18,10,-7,52,-32,-34,-12, 
  /* [1][0][][] */ 36,-59,-90,-60,127,-10,66,67,-20,-82,-67,-28,21,-4,-71,48,-82,13,35,48,20,40,-35,-63,13,-20,-17,-71,39,-22,-63,34,-30,35,5,4,14,-5,23,21,-28,36,-39,-24,-48,107,12,1,28,-72,25,-30,-25,46,55,10,-57,-28,-37,-27,35,-16,1,-48,-90,118,-31,-22,4,-24,-21,18,77,-116,-40,-4,17,-58,53,1,16,-31,8,6,-67,51,-5,28,22,-28,-8,10,18,5,35,101, 
  /* [2][0][][] */ 0,45,-79,-8,88,79,33,57,-6,-118,8,3,-16,-8,34,20,20,-16,-38,65,22,-5,95,21,50,49,7,-50,38,-5,49,-62,36,35,-25,27,-127,-87,15,43,1,-36,21,-5,16,-39,2,76,-33,23,-38,-23,88,-14,-13,59,30,15,27,2,10,27,31,-13,13,-14,-26,6,-63,4,-12,-32,-57,-74,11,66,86,58,17,-9,23,-36,23,-14,-19,17,7,52,-13,23,13,-28,21,-34,-70,7, 
  /* [3][0][][] */ 63,29,85,-8,40,-29,20,7,-13,-53,15,-54,7,35,25,110,31,-8,21,-1,127,-18,29,25,45,-33,-20,22,23,39,0,75,-94,31,26,-1,-22,-14,-3,25,-72,-44,71,17,18,44,-43,-103,-62,-20,-43,52,-7,-126,-5,25,-114,71,55,41,22,90,-16,-54,45,70,-8,-56,27,-30,-4,-74,53,-43,46,-22,4,-13,60,49,-40,-83,5,-12,-48,8,30,36,15,21,24,32,28,99,43,-45, 
  /* [4][0][][] */ 25,-15,25,-8,127,30,-6,-24,-34,-50,-43,-21,-58,19,-4,40,26,-79,-26,75,-13,0,35,-15,-3,0,12,-38,3,-12,51,-35,75,4,-22,8,36,15,-3,2,-24,-3,-33,-20,-12,-50,-11,13,26,11,-25,-3,-10,-34,7,-16,22,-12,-33,18,-3,51,53,27,32,39,-20,-9,-46,-1,41,61,8,-58,-41,-26,37,28,69,-37,-6,-34,10,-6,-57,-3,31,37,-44,26,6,-43,13,17,23,-23, 
  /* [5][0][][] */ 2,-11,-27,17,12,-10,45,-23,-21,-38,-16,14,6,23,-5,25,-3,0,7,-5,27,12,-49,70,8,-11,17,-104,2,19,16,25,-2,15,11,-53,40,28,11,10,-8,-5,27,-14,3,11,6,-29,-16,-15,10,-1,-7,-29,-13,-59,8,19,-22,26,74,14,2,42,-2,47,6,74,9,98,14,25,18,7,-12,67,-34,-20,23,5,-11,-20,-9,19,-18,25,-5,127,-9,29,-5,-11,11,27,-53,27, 
  /* [6][0][][] */ 22,-70,11,-35,-41,17,37,36,6,6,-15,-78,-19,-2,-32,40,14,-4,-9,-7,-43,36,3,6,-24,-13,-19,-11,-13,9,44,-8,64,21,62,2,-3,-4,29,-90,-20,84,6,-35,22,-14,-18,14,-7,37,-17,81,-23,-60,-12,-14,8,-61,-8,12,-4,58,40,-84,35,-26,10,-20,4,4,127,-2,-24,4,-33,21,-94,-18,24,10,30,36,12,-2,-35,8,48,25,2,20,45,-35,-24,-7,-30,-16, 
  /* [7][0][][] */ 4,127,52,13,119,52,49,-17,-22,-27,36,-28,-18,23,25,26,9,-47,9,23,41,-39,32,15,-10,-2,12,21,9,-17,19,14,51,-10,-39,4,11,15,-19,85,-45,22,12,20,-19,-22,33,-18,-34,-23,40,1,18,-35,-39,59,37,6,-24,6,-3,-41,-16,-10,-54,85,-33,-81,-8,-48,-2,69,-4,-24,10,10,52,61,46,-5,-43,-43,-9,-20,-28,51,-4,-9,-36,26,-29,-42,-62,-12,24,-17, 
  /* [8][0][][] */ -3,10,44,17,-127,-26,47,-10,26,88,66,8,4,19,22,16,-48,19,-2,5,-42,-2,-118,67,19,-45,58,-14,12,10,-4,50,71,-9,1,-3,-15,-18,29,37,14,-32,47,9,-32,6,43,-2,-96,12,30,40,-49,-38,-31,35,23,-51,-81,-9,19,-29,-22,-6,8,76,-3,-52,26,-4,-42,-25,44,44,54,-11,-27,-45,-12,21,-75,6,-28,-2,14,28,65,47,24,-26,41,50,6,-2,44,20, 
  /* [9][0][][] */ 7,-99,-24,14,59,67,-33,-26,19,-30,84,104,-14,18,79,-78,14,-19,1,22,-59,-38,39,-15,-21,-1,3,23,-11,4,1,-6,20,25,-100,31,12,10,2,50,23,-64,-3,69,14,-9,-73,-34,24,19,-19,-60,52,26,-20,-56,13,79,-11,4,11,-55,-25,127,-76,-25,13,-23,0,45,-51,-76,40,-4,13,20,41,-68,16,0,-8,-33,12,21,11,-63,17,-4,5,-22,-54,38,-41,-7,2,-32, 
  /* [10][0][][] */ -45,-13,-32,-48,-13,-6,64,-14,39,18,24,19,21,-18,-6,-11,-10,13,-34,-28,2,28,6,23,-12,-22,4,-127,19,-46,62,-40,-4,10,-12,-19,-13,35,-11,-15,12,-43,20,-63,-6,-12,34,18,-12,46,-23,-30,-38,-21,-6,-52,8,12,-9,-42,32,8,-8,-2,-37,104,-25,-38,15,-44,-3,-19,-22,-9,18,58,-2,46,-19,22,-25,1,-1,22,3,-23,-4,117,-6,-10,19,9,8,-49,41,-45, 
  /* [11][0][][] */ -92,36,-10,-5,19,-68,-20,9,-50,-4,-15,4,42,28,-33,-6,47,1,-79,-61,26,-12,-22,-3,70,-5,59,4,-20,29,-43,18,-14,23,-13,-10,-12,4,32,10,-17,-17,-1,-4,77,5,85,16,43,54,7,40,5,-62,35,-8,-81,-22,-35,-41,3,-13,0,11,0,-15,26,0,27,1,-9,27,-16,5,17,-2,-19,84,-127,72,-38,-5,-87,-69,121,31,49,-21,4,51,-37,-63,-40,35,-29,-2, 
  /* [12][0][][] */ -11,5,-43,2,62,28,0,-2,-14,28,33,-10,19,-16,28,-3,-29,-8,0,-13,-10,-19,-46,47,-24,38,-27,97,-13,36,-33,2,-14,34,7,36,-14,-13,29,12,-4,-21,-2,10,-12,-2,19,17,4,-3,10,-19,-1,9,-11,-17,-7,-11,17,27,-12,-23,6,44,46,-77,21,52,-24,-127,-9,48,7,3,14,84,3,-8,-1,2,-4,23,-53,11,7,-7,6,-42,-9,16,4,1,-43,27,-10,30, 
  /* [13][0][][] */ -74,62,-14,1,-77,10,-6,17,-39,-25,38,32,92,12,-17,17,-16,31,-44,-4,14,-18,51,-55,57,33,8,-4,19,-45,-28,-104,-81,-24,9,14,4,25,63,-10,-35,81,12,17,56,21,-11,12,64,-12,42,93,60,-58,74,-26,-14,59,41,21,12,41,-10,21,3,-22,5,14,19,21,28,-127,10,-25,-77,-4,39,31,-42,-49,88,-35,-3,-27,22,-18,89,-2,-39,5,-13,23,44,-30,-12,5, 
  /* [14][0][][] */ -32,20,-15,-56,45,-6,-17,38,-86,1,11,1,-33,-69,-78,-39,-85,-23,82,1,39,-10,19,-102,-44,13,-62,-20,3,-19,-5,-35,-71,-42,17,6,-28,2,-9,-4,10,85,-84,-20,-69,7,15,18,127,-21,31,-29,24,58,-105,35,-37,25,-112,7,13,25,34,24,-5,39,-6,1,-54,14,55,41,37,-3,-26,17,61,-66,-32,-95,11,-31,17,42,37,-86,-52,0,-39,16,36,45,1,20,20,-27, 
  /* [15][0][][] */ -30,-80,-2,-34,19,3,-7,-62,-19,13,-7,-28,29,-12,51,-24,-92,-7,-7,9,-6,-5,-55,-43,-14,8,-7,21,-22,-14,66,-87,-8,23,19,1,-4,22,-93,7,29,-61,-5,17,-28,-49,55,40,47,22,-9,-127,-4,45,-4,49,20,-6,-20,40,12,3,38,-7,-1,-1,-12,-6,-23,24,10,40,-36,12,1,-31,-23,-3,4,12,-1,45,1,63,-8,-44,-28,-30,-40,50,34,69,-39,-4,-4,-15, 
};
const TfArray<4, int> tensor_dimension36 = { 4, { 16,1,1,96 } };
const TfArray<16, float> quant36_scale = { 16, { 0.031868685036897659, 0.016240891069173813, 0.0097537403926253319, 0.010171671397984028, 0.019322061911225319, 0.01546061597764492, 0.015593782067298889, 0.012121391482651234, 0.013044294901192188, 0.012323449365794659, 0.027650386095046997, 0.022110380232334137, 0.016138326376676559, 0.0091276997700333595, 0.021282082423567772, 0.023113500326871872, } };
const TfArray<16, int> quant36_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant36 = { (TfLiteFloatArray*)&quant36_scale, (TfLiteIntArray*)&quant36_zero, 0 };
const ALIGN(16) int32_t tensor_data37[16] = { -9336, 12709, -16832, -777, -7393, 11085, 26941, -55093, -5022, 15310, 24586, 15237, -14128, 12790, -6102, 8043, };
const TfArray<1, int> tensor_dimension37 = { 1, { 16 } };
const TfArray<16, float> quant37_scale = { 16, { 0.00074985140236094594, 0.00038213861989788711, 0.0002294997830176726, 0.0002393334434600547, 0.00045463675633072853, 0.00036377919605001807, 0.00036691251443699002, 0.00028520921478047967, 0.00030692460131831467, 0.00028996352921240032, 0.00065059732878580689, 0.00052024424076080322, 0.00037972533027641475, 0.00021476941765286028, 0.00050075491890311241, 0.00054384709801524878, } };
const TfArray<16, int> quant37_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant37 = { (TfLiteFloatArray*)&quant37_scale, (TfLiteIntArray*)&quant37_zero, 0 };
const ALIGN(16) int8_t tensor_data38[96*1*1*16] = { 
  /* [0][0][][] */ -37,100,-4,-127,-48,-32,-31,-62,-12,11,2,85,20,-56,-12,53, 
  /* [1][0][][] */ -44,23,-73,-8,-35,-38,23,-95,65,51,-61,29,4,0,46,-127, 
  /* [2][0][][] */ -9,17,-51,24,31,8,-45,-53,127,-47,3,25,-15,89,-63,39, 
  /* [3][0][][] */ 41,-50,7,-105,5,-41,-15,-4,94,-10,68,39,-4,38,30,127, 
  /* [4][0][][] */ -98,65,23,51,2,-19,2,52,11,15,19,-23,-127,-15,-22,25, 
  /* [5][0][][] */ 5,89,127,4,12,90,-100,94,-83,90,-20,-62,60,-82,-125,58, 
  /* [6][0][][] */ 20,-48,107,-127,25,-7,-41,90,-69,-97,55,-25,-2,80,-13,88, 
  /* [7][0][][] */ 38,127,-33,-67,94,6,6,-49,127,94,-28,40,36,-27,74,56, 
  /* [8][0][][] */ 11,-83,7,-94,21,-52,21,-72,20,49,78,-2,24,127,88,66, 
  /* [9][0][][] */ 16,-32,0,127,41,-3,42,-58,-62,113,30,-16,-4,-60,-8,-8, 
  /* [10][0][][] */ -1,14,-40,-127,4,-5,-14,28,19,-22,11,-28,-11,-44,8,27, 
  /* [11][0][][] */ 7,10,15,-18,74,-33,83,-53,-82,38,-1,31,-5,127,-61,-30, 
  /* [12][0][][] */ 41,-3,-127,-16,24,-95,28,5,-4,40,-57,-44,-25,73,-8,36, 
  /* [13][0][][] */ -16,8,-24,9,4,-127,-2,18,7,-13,7,3,12,-11,11,14, 
  /* [14][0][][] */ 31,-15,88,-26,61,7,-127,-73,-15,-57,19,34,11,-47,-21,-27, 
  /* [15][0][][] */ -72,22,-4,-47,5,7,127,58,-23,39,74,-22,13,76,50,0, 
  /* [16][0][][] */ 30,37,127,119,2,40,97,62,-85,35,-85,-20,18,13,-1,-112, 
  /* [17][0][][] */ -40,-106,-14,28,-71,-25,-57,12,-127,-28,15,-45,-1,37,61,-36, 
  /* [18][0][][] */ 5,42,1,51,39,-1,25,12,71,42,-12,-18,8,127,61,21, 
  /* [19][0][][] */ 9,-7,32,22,89,17,-80,-49,-103,-70,-41,-127,-30,-33,-9,-33, 
  /* [20][0][][] */ 103,-53,-58,-33,22,-127,-6,12,-65,47,-117,-31,16,-2,32,-11, 
  /* [21][0][][] */ 68,-30,89,-24,-17,-8,-12,103,-17,-111,81,41,2,127,60,96, 
  /* [22][0][][] */ -42,51,-39,127,-45,-1,95,71,6,37,-1,33,-10,10,16,-2, 
  /* [23][0][][] */ 50,15,88,-72,39,-3,13,64,23,-3,6,-5,23,0,-127,28, 
  /* [24][0][][] */ -127,42,13,-19,2,101,28,-19,-5,7,99,-4,-67,16,57,-22, 
  /* [25][0][][] */ 24,26,10,22,11,11,65,-45,-1,-127,-12,-14,-9,-23,9,22, 
  /* [26][0][][] */ -37,-2,1,8,-47,-8,-38,-32,-104,-38,3,-32,8,127,-38,51, 
  /* [27][0][][] */ -5,29,11,62,34,-30,-19,-29,57,7,-24,2,8,127,-7,16, 
  /* [28][0][][] */ 8,79,47,69,127,-12,36,40,-93,-25,-47,-42,21,83,37,-32, 
  /* [29][0][][] */ 10,-5,11,13,32,5,9,34,-18,-20,-22,-127,2,-13,-19,5, 
  /* [30][0][][] */ -19,88,-47,72,-43,-23,46,-127,-44,50,-15,4,63,41,84,94, 
  /* [31][0][][] */ -48,-27,-14,-73,-8,-8,-50,-104,13,89,-12,-127,-31,-48,8,26, 
  /* [32][0][][] */ -127,-76,-4,67,56,42,-10,11,1,-42,-114,40,79,6,57,65, 
  /* [33][0][][] */ -17,-33,-42,-7,-95,-10,-72,12,68,24,16,-42,40,-111,127,33, 
  /* [34][0][][] */ 49,-10,59,20,40,12,-45,76,-85,-42,65,23,14,-9,-11,127, 
  /* [35][0][][] */ -37,56,-70,21,-13,-17,32,-114,87,95,-87,3,7,-2,75,-127, 
  /* [36][0][][] */ -37,21,-9,127,10,29,127,44,16,32,-10,11,-5,31,-54,-32, 
  /* [37][0][][] */ -7,4,16,-76,-7,-12,-33,-38,-82,-18,5,4,14,-127,74,-27, 
  /* [38][0][][] */ 39,81,-8,-45,127,1,24,-45,103,72,-15,-12,-1,-28,43,14, 
  /* [39][0][][] */ -19,51,-3,-127,-13,13,-54,25,40,-70,-29,-24,9,69,50,27, 
  /* [40][0][][] */ -7,-29,25,-101,-7,-28,-9,-23,-127,-2,-8,-11,2,-110,107,-57, 
  /* [41][0][][] */ -7,-11,-52,-18,-2,-34,28,-2,-35,8,-48,-2,-127,17,28,38, 
  /* [42][0][][] */ 127,88,-12,-25,-70,-51,-18,-41,5,9,84,-38,-48,48,104,-104, 
  /* [43][0][][] */ 3,104,-78,3,51,-3,127,-20,53,80,-44,-4,34,-107,-79,-50, 
  /* [44][0][][] */ -19,-20,0,-25,45,12,-79,-127,-15,11,2,0,-4,-18,56,-71, 
  /* [45][0][][] */ -26,40,-127,-45,24,-82,22,-76,-2,38,5,-82,29,-28,61,-15, 
  /* [46][0][][] */ 12,-1,-22,-83,-12,15,22,-36,-114,-20,7,9,-10,-127,61,-35, 
  /* [47][0][][] */ 17,52,22,-23,127,-18,-30,16,-53,31,5,27,2,-3,121,-20, 
  /* [48][0][][] */ -127,-65,-8,36,70,16,11,-11,5,-20,-103,45,61,17,70,53, 
  /* [49][0][][] */ 13,12,100,81,127,4,50,33,-123,-53,-47,-83,19,125,17,-69, 
  /* [50][0][][] */ 42,-35,-83,-25,26,-127,-56,-16,-33,-16,5,-41,30,-16,2,20, 
  /* [51][0][][] */ 0,31,39,9,23,3,-4,16,-127,63,7,-111,7,-115,-22,90, 
  /* [52][0][][] */ -1,45,-7,51,45,-7,23,41,72,90,-20,-54,34,127,69,24, 
  /* [53][0][][] */ 0,-54,-23,-10,-90,-4,-74,-6,54,32,8,-69,33,-127,110,7, 
  /* [54][0][][] */ 57,-13,-53,7,127,74,-118,-48,-101,-2,-34,-84,5,-47,-12,-38, 
  /* [55][0][][] */ 53,-15,5,7,35,-32,-69,-127,-34,-56,-62,2,-7,-28,20,-12, 
  /* [56][0][][] */ -24,18,22,-20,-10,-26,-89,66,-10,127,-3,-15,29,4,-5,6, 
  /* [57][0][][] */ -16,28,-57,-16,-58,-50,127,92,-23,36,-17,-10,29,26,114,-17, 
  /* [58][0][][] */ 51,15,-127,29,75,99,-35,39,-104,-25,-3,12,-38,30,1,-19, 
  /* [59][0][][] */ -112,67,114,17,-77,-74,123,127,21,4,38,-10,10,6,80,8, 
  /* [60][0][][] */ 12,-15,-53,0,21,-127,-31,-7,-14,-16,-6,-27,27,-16,6,9, 
  /* [61][0][][] */ 36,-21,26,127,84,23,18,-2,-103,1,20,51,-21,23,44,-49, 
  /* [62][0][][] */ -53,127,13,-48,-29,-10,-69,52,-24,-56,-88,-59,-8,-101,-59,-42, 
  /* [63][0][][] */ -37,16,-26,127,-76,24,-65,-35,-57,-18,-27,-41,27,68,38,35, 
  /* [64][0][][] */ 2,10,-2,47,1,9,-9,71,35,6,-18,-40,-8,-127,47,-7, 
  /* [65][0][][] */ -8,-45,7,-127,32,-25,59,-37,-21,53,0,-109,-8,0,27,-46, 
  /* [66][0][][] */ 25,-28,73,-30,1,-5,-14,106,-2,-74,47,44,1,127,27,84, 
  /* [67][0][][] */ 0,48,-16,-127,-13,2,-66,33,80,-107,-30,-14,24,84,73,34, 
  /* [68][0][][] */ -32,35,127,11,12,3,-3,3,-41,-20,-16,-28,19,-17,85,-31, 
  /* [69][0][][] */ 127,97,-20,-2,-100,-39,-30,-44,7,25,111,-76,-91,72,77,-118, 
  /* [70][0][][] */ 39,8,-54,-10,-26,27,56,127,-35,92,-42,6,17,63,-33,20, 
  /* [71][0][][] */ 9,-8,-4,8,3,-79,-1,18,-41,22,-82,4,-127,-5,48,48, 
  /* [72][0][][] */ 10,25,-127,4,18,3,21,90,-41,-39,16,6,14,13,6,14, 
  /* [73][0][][] */ -62,33,44,2,44,-45,-75,-127,23,-92,45,-9,29,-45,48,-11, 
  /* [74][0][][] */ -4,31,34,127,14,1,-81,84,-66,20,-50,50,24,-122,39,-100, 
  /* [75][0][][] */ -6,24,-67,20,18,-2,23,-20,126,36,-17,-17,13,127,-49,-9, 
  /* [76][0][][] */ 5,-24,-4,9,6,-19,-15,50,10,-30,-8,-127,-11,-13,17,19, 
  /* [77][0][][] */ -25,43,-11,125,-50,19,83,127,24,32,13,59,-18,-19,-17,1, 
  /* [78][0][][] */ 14,-7,34,-109,52,-23,-44,32,16,-40,-1,-47,20,127,16,33, 
  /* [79][0][][] */ -20,-84,-74,-52,-80,-6,23,-71,127,12,31,59,15,41,37,-47, 
  /* [80][0][][] */ -30,8,104,-81,16,-28,36,-80,-42,53,-34,-127,22,99,63,-55, 
  /* [81][0][][] */ -51,42,-126,23,65,-127,-16,52,-13,-52,66,6,31,-1,16,1, 
  /* [82][0][][] */ 127,-13,-7,10,11,-111,-21,15,-21,-10,-91,-3,93,3,1,28, 
  /* [83][0][][] */ -32,79,-115,-78,-30,-13,43,-122,63,51,-44,-127,10,48,45,94, 
  /* [84][0][][] */ -32,27,61,-35,0,-20,61,-127,-47,58,-19,-66,33,49,67,-6, 
  /* [85][0][][] */ -80,127,19,-117,-77,-26,-26,-3,-56,0,-71,17,-1,-7,-97,-31, 
  /* [86][0][][] */ -14,13,-30,-1,-20,-37,127,28,4,-34,5,14,8,27,79,-15, 
  /* [87][0][][] */ -21,-40,5,-116,12,-28,49,-22,-6,17,-10,-127,-23,4,7,-43, 
  /* [88][0][][] */ 101,-33,57,-17,22,-127,8,31,-58,45,-122,-50,49,29,84,4, 
  /* [89][0][][] */ 25,-23,-49,-43,25,-10,-16,2,-43,18,28,-61,127,4,24,-48, 
  /* [90][0][][] */ -14,-41,31,-64,68,-5,-61,96,67,-99,-35,-23,0,123,20,-127, 
  /* [91][0][][] */ -38,0,-25,-33,15,-6,-17,-74,15,63,-14,-127,-28,-7,-4,5, 
  /* [92][0][][] */ -19,15,38,15,-1,-127,6,-3,-2,-15,-2,-17,-1,-26,22,3, 
  /* [93][0][][] */ 52,-30,127,-21,-48,46,20,-35,-27,22,-60,-14,-32,-5,44,14, 
  /* [94][0][][] */ 33,3,-4,-22,27,-4,-13,0,-30,-19,14,-45,127,-8,27,-31, 
  /* [95][0][][] */ 127,87,-3,32,-91,-20,-60,-2,-30,-13,87,-38,-38,27,81,-70, 
};
const TfArray<4, int> tensor_dimension38 = { 4, { 96,1,1,16 } };
const TfArray<96, float> quant38_scale = { 96, { 0.00080913439160212874, 0.0011218353174626827, 0.00084629544289782643, 0.00072428077692165971, 0.00069648236967623234, 0.00086293468484655023, 0.00041592342313379049, 0.00085226475493982434, 0.00044524576514959335, 0.00098003598395735025, 0.00055017787963151932, 0.0006794133223593235, 0.00088062102440744638, 0.0035744416527450085, 0.00045766116818413138, 0.00051404221449047327, 0.00026101252296939492, 0.00075626373291015625, 0.001443863264285028, 0.00078644382301717997, 0.00038014070014469326, 0.00017152824148070067, 0.00030672416323795915, 0.00038522909744642675, 0.00052179052727296948, 0.0013883627252653241, 0.001960244495421648, 0.0010607094736769795, 0.00061048608040437102, 0.0010998072102665901, 0.00056484545348212123, 0.00078205979662016034, 0.00057213497348129749, 0.00061152788111940026, 0.00080279546091333032, 0.00064287986606359482, 0.00043297346564941108, 0.00064631848363205791, 0.00096487224800512195, 0.00091718824114650488, 0.00044837564928457141, 0.0012226797407492995, 0.00097636162536218762, 0.00044235531822778285, 0.001419239561073482, 0.00057941640261560678, 0.00084163894644007087, 0.00058102537877857685, 0.00088364793919026852, 0.00057552126236259937, 0.00058976875152438879, 0.00047991087194532156, 0.0014768756227567792, 0.00059265893651172519, 0.0008475569193251431, 0.00090445094974711537, 0.0012039578286930919, 0.00066710379905998707, 0.0011387529084458947, 0.00037023489130660892, 0.0021905370522290468, 0.0013166385469958186, 0.00051104743033647537, 0.0011186489136889577, 0.0013152592582628131, 0.00080392399104312062, 0.00020703280461020768, 0.0004763792094308883, 0.0012772632762789726, 0.001127379247918725, 0.00060437718639150262, 0.00068680621916428208, 0.0024790905881673098, 0.00080913607962429523, 0.0007706176838837564, 0.0005097963148728013, 0.0009112540865316987, 0.00022030246327631176, 0.00026994876679964364, 0.00059374456759542227, 0.00053361215395852923, 0.00041437306208536029, 0.00058066874044016004, 0.00049593253061175346, 0.00043129516416229308, 0.00067066121846437454, 0.0015390298794955015, 0.00064669287530705333, 0.0003285361744929105, 0.0016342606395483017, 0.0005621383897960186, 0.00072690215893089771, 0.00096645747544243932, 0.0013405970530584455, 0.0011773168807849288, 0.00063912192126736045, } };
const TfArray<96, int> quant38_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant38 = { (TfLiteFloatArray*)&quant38_scale, (TfLiteIntArray*)&quant38_zero, 0 };
const ALIGN(16) int32_t tensor_data39[96] = { -1853, 3309, 6692, 2872, -3630, -4045, 18999, 1987, 3275, -1546, 8593, -205, -6832, 1879, 15872, 5385, 17069, 4550, -3165, -5194, 3834, 37400, 23837, 10272, 908, 822, 3607, 2384, 2077, -4239, 6211, -2295, -280, 4452, 53, 900, 10298, 3958, -1528, 4616, 6801, 5013, 3658, 12482, 3125, 4136, 1401, 8971, 3557, -5405, -6275, 556, -182, -1305, 2167, -44, 185, -1003, -3208, 11917, -805, 1200, -1262, -1655, -3400, 5665, 24910, 1958, -2158, 671, 1650, 1797, 1326, -1214, 507, 10099, -215, 20414, 15827, -777, 6565, 1917, -294, 1158, 10005, 8438, 3644, 1085, 5146, 2923, -390, -6509, 528, -1776, -1285, -1486, };
const TfArray<1, int> tensor_dimension39 = { 1, { 96 } };
const TfArray<96, float> quant39_scale = { 96, { 0.00034104398218914866, 0.00047284501488320529, 0.00035670708166435361, 0.00030527880880981684, 0.00029356201412156224, 0.00036372037720866501, 0.00017530855257064104, 0.00035922307870350778, 0.00018766769790090621, 0.00041307767969556153, 0.00023189577041193843, 0.00028636751812882721, 0.00037117503234185278, 0.0015065998304635286, 0.00019290068303234875, 0.00021666487737093121, 0.0001100147856050171, 0.00031875938293524086, 0.0006085773347876966, 0.00033148005604743958, 0.00016022640920709819, 7.2297843871638179e-05, 0.00012928189244121313, 0.00016237112868111581, 0.0002199307200498879, 0.0005851843161508441, 0.00082622811896726489, 0.00044708093628287315, 0.00025731523055583239, 0.00046356033999472857, 0.00023807804973330349, 0.0003296322247479111, 0.00024115052656270564, 0.00025775434914976358, 0.00033837216324172914, 0.00027096894336864352, 0.00018249501590617001, 0.00027241831412538886, 0.00040668627480044961, 0.00038658783887512982, 0.00018898691632784903, 0.0005153501988388598, 0.00041152897756546736, 0.0001864493970060721, 0.00059819861780852079, 0.00024421958369202912, 0.00035474440664984286, 0.00024489776114933193, 0.00037245085695758462, 0.00024257782206404954, 0.00024858303368091583, 0.00020227876666467637, 0.00062249181792140007, 0.00024980123271234334, 0.00035723877954296768, 0.00038121917168609798, 0.00050745904445648193, 0.00028117914916947484, 0.00047997565707191825, 0.0001560511882416904, 0.000923294632229954, 0.00055495311971753836, 0.00021540258603636175, 0.00047150198952294886, 0.00055437174160033464, 0.000338847836246714, 8.7262749730143696e-05, 0.00020079020760022104, 0.00053835671860724688, 0.00047518176143057644, 0.0002547403855714947, 0.00028948357794433832, 0.0010449177352711558, 0.00034104468068107963, 0.00032480945810675621, 0.0002148752537323162, 0.00038408665568567812, 9.2855807451996952e-05, 0.00011378134513506666, 0.0002502588031347841, 0.00022491345589514822, 0.000174655084265396, 0.0002447474398650229, 0.00020903177210129797, 0.00018178761820308864, 0.00028267857851460576, 0.00064868933986872435, 0.00027257611509412527, 0.00013847548689227551, 0.00068882841151207685, 0.00023693703406024724, 0.00030638370662927628, 0.0004073544405400753, 0.00056505145039409399, 0.00049623008817434311, 0.0002693850256036967, } };
const TfArray<96, int> quant39_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant39 = { (TfLiteFloatArray*)&quant39_scale, (TfLiteIntArray*)&quant39_zero, 0 };
const ALIGN(16) int8_t tensor_data40[32*1*1*96] = { 
  /* [0][0][][] */ 19,69,26,-91,-81,2,-10,67,-23,-35,-127,-109,-125,117,-62,66,31,95,6,7,-42,-112,-46,20,102,-107,-3,99,47,-96,75,4,-86,93,17,-61,-45,12,-103,-28,-107,-50,111,-75,69,-18,-86,105,-110,88,-93,24,-42,88,4,59,-88,-94,-13,31,-19,85,25,-124,71,-123,-116,45,53,-90,-25,117,-70,37,-54,106,-65,-68,-40,-14,-117,48,68,35,-49,-74,-59,-52,24,42,20,67,-104,-100,-49,51, 
  /* [1][0][][] */ 70,1,75,38,27,-46,-4,116,27,97,-86,64,-77,-117,22,-88,-64,-32,33,-18,96,85,-97,-83,41,0,-34,-73,101,102,-29,-70,-101,-95,-98,-75,61,-72,-60,11,2,114,-14,26,36,-2,-44,35,17,-110,19,-46,-5,-121,-44,-104,38,37,119,4,66,-75,-44,-39,118,-21,-7,92,68,90,53,127,-1,36,53,29,93,-82,122,-23,-92,113,-88,84,27,16,-123,30,-68,-78,65,-19,-42,11,31,15, 
  /* [2][0][][] */ 17,-76,-85,-107,-35,19,85,11,36,-58,-54,-55,38,91,-63,-103,-103,38,-64,24,-102,-41,40,35,-71,83,-35,-62,-22,-29,-77,14,68,-60,67,-1,-97,28,-77,85,64,-30,119,71,-54,-15,63,38,-3,-48,-28,74,-111,-79,-12,-90,-43,38,74,127,107,78,-63,105,102,95,-63,-64,2,22,55,-21,49,17,-20,-70,78,127,-92,-69,-89,127,69,29,-68,46,59,14,67,85,78,106,-43,-47,75,85, 
  /* [3][0][][] */ -65,87,59,-74,98,85,81,77,106,14,46,-66,88,51,108,117,-124,73,-66,93,-68,80,-71,8,109,84,-94,10,49,26,-36,100,-90,33,34,-100,-104,-33,-73,-45,-81,-37,-57,24,-67,-95,-19,-26,-49,87,-41,-99,-3,50,90,-69,-85,-87,53,-82,-75,21,-84,-32,11,90,-47,-25,-31,-38,77,6,96,88,-60,-71,-127,-47,85,-53,58,109,-81,-85,77,-104,106,-87,-32,-100,86,86,-78,-60,36,-36, 
  /* [4][0][][] */ -94,31,85,-10,54,8,-28,-46,21,72,-106,-73,-54,102,28,-98,85,45,-45,-79,-96,79,-110,-32,-28,-121,95,37,2,-120,127,34,-100,50,-64,-49,98,-19,-121,-103,109,98,-102,-99,-18,96,-41,-43,125,-47,118,116,96,-114,-6,38,-112,-10,95,-51,88,-47,-18,96,-49,31,-118,-83,25,99,55,-12,-49,-6,26,-69,-29,94,-41,48,32,-106,46,11,54,123,22,-66,-35,-9,88,64,101,-25,-107,-115, 
  /* [5][0][][] */ -86,99,-53,-49,22,-55,-44,58,-15,-96,53,22,-106,34,101,102,-127,114,74,-10,104,7,-53,99,-108,46,-35,-75,-41,14,63,-2,-55,67,66,50,73,-55,-59,-36,76,-4,-14,-64,99,110,11,-8,27,77,87,45,-104,-39,38,-37,97,-37,-80,68,58,46,-16,66,67,-55,43,52,94,-61,14,7,-98,83,4,-94,-66,53,30,0,72,107,-92,-43,46,-31,-84,-14,76,102,-45,107,-15,96,1,101, 
  /* [6][0][][] */ 76,8,14,-85,-78,6,44,-83,13,95,23,127,58,-61,-10,93,-23,88,59,102,-79,90,84,34,-43,29,-71,-59,-4,-36,12,81,-76,13,45,84,-57,-40,6,39,-68,37,59,26,-77,71,-82,-22,54,117,18,14,-38,-79,-7,-51,-37,-14,8,73,39,-7,96,24,110,78,-16,28,5,-69,-24,-15,49,-39,96,99,0,55,-38,-71,39,-21,-22,-65,74,15,-12,111,-1,-68,-61,13,-65,48,98,-74, 
  /* [7][0][][] */ 69,37,-51,-111,103,-4,-33,-60,20,-77,-15,-4,-34,99,88,56,76,-6,-41,47,67,-93,-13,-57,95,-69,49,108,-63,-28,-17,6,-112,-45,59,-34,112,-9,-3,-94,-105,29,-60,71,6,-63,-89,-57,54,-21,-35,91,-47,31,52,26,56,-103,2,-101,14,-46,-47,-46,-10,-58,-104,-92,38,-104,-112,5,-104,60,-35,67,-69,-44,-73,-7,-103,36,6,59,-63,-77,-19,-80,43,102,127,-84,26,-80,79,-102, 
  /* [8][0][][] */ -47,-20,-64,-5,60,52,-11,-73,73,-55,106,-58,0,-74,-85,15,57,64,88,-47,80,59,100,-24,-42,-59,19,-61,-35,-29,-75,3,-48,-3,-79,111,-49,-78,-20,-56,-12,21,41,29,-5,-34,-17,80,53,99,-12,-3,109,11,-4,-80,3,9,-5,42,-76,8,-49,74,-1,-20,16,-58,-51,33,-55,36,58,74,127,102,95,23,-2,-8,41,101,-3,62,71,-5,-4,75,48,58,-39,86,-72,84,105,-47, 
  /* [9][0][][] */ -27,-33,13,76,23,35,83,35,18,44,68,45,76,58,-28,-21,-25,-54,-79,-72,-80,80,17,-24,-76,-61,-43,35,50,-127,-25,56,-74,-58,109,-25,-56,2,-64,-60,107,91,4,2,42,60,33,-17,-19,-64,-90,-56,-115,35,26,77,-6,-63,-2,5,6,-78,24,84,-116,79,69,66,102,-61,-127,21,42,25,55,-116,100,-75,14,-41,-105,-40,87,-73,60,-70,-81,24,-63,93,25,17,-76,32,35,58, 
  /* [10][0][][] */ -103,56,-80,-101,-50,67,-124,-104,78,-91,77,65,0,23,74,-12,113,26,-54,49,12,-66,-48,76,29,100,-34,-20,-109,-83,-13,-89,63,39,96,-103,127,-73,46,103,92,34,34,62,-13,34,2,-6,-79,90,122,126,124,-82,110,71,19,-18,89,-20,68,73,95,57,-28,116,-7,45,12,-10,87,34,-105,-103,33,55,89,88,72,5,13,26,30,37,20,66,-91,46,7,47,-47,99,40,93,36,-16, 
  /* [11][0][][] */ 88,61,-75,-80,89,-36,-43,-91,-86,34,41,-15,10,-69,50,-77,-124,72,-36,-58,-46,-41,63,-82,-93,88,69,68,-7,27,2,38,60,81,-112,-69,-7,116,-66,-68,50,-105,103,-113,84,26,-97,-21,51,68,-65,82,40,-73,-51,-92,-16,78,-114,73,-31,-8,110,-50,47,-32,89,2,86,96,-65,27,-89,-37,14,-105,-28,69,-75,-9,-92,-14,-127,95,0,-70,-45,-32,-84,41,-44,-57,86,13,106,17, 
  /* [12][0][][] */ -76,-50,-88,108,-4,-55,-64,-82,-28,3,-54,26,-81,-105,-55,53,22,-55,21,110,-105,-42,49,42,-16,84,-98,-14,88,-101,66,72,19,-38,-13,-88,-9,-93,70,57,79,82,39,-82,24,-16,-68,78,-93,88,-63,54,-70,-109,82,39,-12,-87,-100,-112,42,-44,101,-25,-76,-10,-7,-72,-125,-118,27,-31,-122,-73,-28,-34,-127,-35,75,-69,17,66,85,-13,59,-70,-32,-74,-87,-92,-12,4,-117,-100,-123,74, 
  /* [13][0][][] */ 60,52,80,-67,97,4,36,-58,26,-109,39,21,-23,88,42,70,77,60,10,91,125,-17,-15,-78,89,-80,0,-75,21,-117,-47,-4,-13,-100,19,-2,64,-102,82,38,-9,-62,78,93,58,-4,73,72,-88,58,-31,9,-18,-89,6,100,27,-54,77,-75,-94,-12,75,-58,-88,43,-42,-115,-92,-60,-85,100,-40,-15,106,-31,-30,85,-14,-50,85,37,3,124,105,-46,-111,85,-44,-50,33,-30,67,127,-22,-80, 
  /* [14][0][][] */ -41,-79,85,65,50,-119,20,-13,-4,53,-32,-83,-25,121,-30,44,-111,-31,-42,-115,-11,42,-53,-42,-43,-20,73,9,69,-101,82,-56,-32,101,127,14,3,78,-95,-91,111,122,121,14,83,-76,-1,-49,-108,-10,-50,-78,-39,-122,78,-120,25,-84,-58,-98,-95,-120,9,11,-17,63,9,-6,-111,-10,22,-66,-103,-76,36,-20,-113,-15,74,9,124,-29,109,37,-81,-65,-58,74,53,-10,-84,-47,-16,-121,-80,-57, 
  /* [15][0][][] */ 18,44,-10,-74,-101,98,4,52,-123,-50,99,-45,-25,-62,-53,-45,-43,86,-112,12,-33,-96,-67,-34,-10,-15,94,105,-24,-72,-127,19,52,97,-49,-32,-40,98,-38,-101,-70,111,102,-68,77,48,-87,-101,22,-31,-40,-100,-84,-13,27,7,58,-23,88,-59,-118,-108,-104,-63,-51,24,-25,-87,-25,-84,-90,7,58,42,-5,78,-36,92,-113,-34,-32,-72,-51,-62,-58,-47,96,-44,56,-109,-90,95,-11,-53,109,-86, 
  /* [16][0][][] */ 1,28,-106,127,87,-89,109,115,-34,38,92,-67,-83,97,-117,-24,32,90,-76,-25,-111,-17,-101,18,113,-63,-73,21,-51,86,123,40,-63,-41,24,14,-34,101,-113,73,55,39,86,-57,-93,-8,-95,-55,-15,33,99,75,-54,-114,59,12,44,107,-55,-58,49,-31,-5,77,-10,38,77,-39,7,-54,63,25,83,1,41,-84,77,-53,-93,-46,-23,32,-3,-102,102,-60,10,-110,120,-92,93,-105,55,37,83,-92, 
  /* [17][0][][] */ -31,94,-123,-45,-41,45,-55,107,24,-33,102,-22,-28,103,31,-80,29,81,-11,90,19,-23,-73,-22,-127,5,-48,-90,-44,47,61,-112,55,-51,-38,42,53,-65,-32,38,-50,119,-31,-95,112,17,-95,-108,25,-110,-1,-125,-64,6,64,37,-79,76,-46,-82,104,125,81,80,-57,32,-109,70,-81,-75,12,-31,-43,-43,-10,45,-118,-72,114,-118,-72,-13,112,-64,77,31,-61,104,15,127,-27,77,-116,-54,84,-34, 
  /* [18][0][][] */ 71,-120,-124,-24,56,44,-126,-107,-65,43,-94,-79,0,93,17,31,27,86,-74,-48,-94,46,20,33,18,-28,32,-108,-15,-127,27,-125,-39,81,107,-66,48,-48,-66,-92,-113,20,114,-66,-32,37,93,-68,84,24,-57,-101,-38,-7,-42,27,71,21,-120,59,-110,-20,68,107,-15,19,-107,-120,99,-43,-67,85,-108,108,1,118,27,90,-19,-31,-69,-56,-109,95,1,-73,96,10,68,22,-47,116,-106,-13,-4,-123, 
  /* [19][0][][] */ 77,50,-96,87,109,96,-52,10,91,-47,12,-39,60,86,108,-37,33,-104,-55,98,-106,-71,36,124,70,-3,35,-33,83,42,108,-127,67,-29,-75,74,-112,-29,-73,29,57,33,45,41,-39,38,-108,99,114,55,52,-42,40,-94,66,90,57,18,-100,-35,-36,53,108,-41,84,-21,-64,97,102,-11,-105,0,28,78,11,95,-11,93,-72,114,-116,-40,83,-106,34,22,93,-95,-92,-19,-24,1,-16,-66,68,-104, 
  /* [20][0][][] */ -3,-90,-32,65,88,5,83,50,-50,-71,21,-11,-43,-81,1,-94,-33,-50,95,46,68,-115,89,-27,-106,107,-82,2,-6,-88,-42,15,58,106,82,-60,78,22,-101,23,104,-107,-85,-30,49,23,-36,-42,87,-31,127,-72,-5,100,30,-83,-57,-107,63,10,-25,79,62,82,38,104,30,-76,39,84,-90,31,-106,-92,-50,100,-9,-104,42,-69,20,98,95,-44,58,12,-70,-106,122,19,-120,-75,68,-49,35,73, 
  /* [21][0][][] */ 91,92,99,-59,-23,-74,-67,-31,-11,79,36,-100,-78,-56,-79,-83,-46,-10,-91,-112,-32,63,105,-46,102,46,80,-29,-69,-118,103,5,-71,41,115,93,-127,-58,-99,39,20,57,-30,-2,-56,97,-94,80,74,-127,-18,-67,38,-29,-124,-44,-28,-52,70,92,26,-51,-9,65,-50,50,-54,16,13,-44,-30,20,-26,-71,-63,-2,-101,100,116,94,-37,111,-6,-14,-107,-60,31,27,-38,49,-66,74,-18,-73,101,-14, 
  /* [22][0][][] */ -30,-62,55,-39,-87,-117,91,54,38,-28,-34,12,-67,30,-38,-102,-105,-18,-97,60,34,101,-20,71,-98,29,-79,45,-50,-94,-69,-89,-92,103,22,39,8,-106,-73,-73,-35,-17,-85,-3,53,-49,102,-82,-82,-37,-108,65,-96,100,-30,32,99,102,-127,89,-71,-41,-19,13,77,-111,-98,-32,60,87,-94,-52,4,78,-89,-27,-120,-97,47,-41,90,-78,-109,-54,37,79,-30,99,17,87,92,11,-104,69,87,66, 
  /* [23][0][][] */ -30,-2,1,-30,-87,-15,56,12,20,-97,53,-104,-127,81,60,-40,14,40,26,23,49,90,53,-6,46,-46,-63,-73,-99,63,-2,105,87,-55,97,-21,-29,102,70,-69,108,41,90,-96,-87,0,-82,96,29,66,-43,-13,-97,105,60,11,29,5,34,-20,-39,36,66,-100,94,-87,10,-8,86,98,-88,102,91,39,9,-49,-109,12,-85,-11,-97,14,-84,-72,-47,-106,109,-104,-32,-67,-41,-67,10,-42,-63,109, 
  /* [24][0][][] */ -11,74,101,87,61,12,-94,91,-8,-83,-74,96,50,-1,-10,-57,-3,29,-40,71,105,-21,-18,33,-30,60,-60,-42,95,127,84,-29,90,-46,-8,-24,35,-43,-74,-82,0,93,-70,44,-45,63,40,-61,-88,-31,32,-18,-53,62,99,-41,48,-42,6,-26,93,64,54,-25,-104,-9,-56,94,55,-71,5,25,13,-97,-17,-20,37,-42,-27,57,55,-36,61,-44,-73,-60,-13,-57,-72,68,-48,-26,-62,-62,65,97, 
  /* [25][0][][] */ -33,2,-21,63,-6,12,-105,35,-32,74,50,43,-97,66,76,-107,-59,-27,-65,11,63,92,-42,83,32,-92,-76,-59,60,72,-106,70,-99,-83,78,123,-115,46,-110,104,-112,98,57,-4,-19,-97,-120,-127,-56,13,-94,-51,-9,-17,-117,-99,30,-42,92,10,-85,106,-104,27,-85,-100,-107,81,14,-4,23,53,-8,58,-22,-12,20,-21,19,-106,-94,-17,-71,37,81,1,-39,42,-109,92,-70,-7,-28,83,102,49, 
  /* [26][0][][] */ 63,-73,6,-12,82,-63,91,-40,37,-25,-86,19,-9,-68,31,-22,122,3,-46,-77,33,-50,70,85,-6,-33,41,64,42,11,-50,-44,-37,39,34,106,37,79,-114,93,82,2,-32,-84,-11,44,100,6,13,77,67,-25,114,84,54,22,84,-2,-49,-13,5,127,-69,-110,46,-31,-101,-35,-4,-53,64,28,-103,-66,-62,-55,-15,33,-23,52,95,11,-57,-24,-14,-37,-14,-87,15,11,92,96,-51,33,38,-48, 
  /* [27][0][][] */ 47,42,-99,102,-31,-3,0,-7,-92,90,-33,-1,-92,63,72,-51,57,-113,9,-104,-26,48,79,-85,-112,64,-42,62,100,-47,55,-113,91,-87,25,100,127,48,-74,-47,26,46,-29,63,58,-90,92,-71,-24,-36,59,84,121,48,-108,-87,86,-39,-14,6,27,-59,-97,-90,24,100,20,-99,31,-13,47,-106,17,-77,13,-71,-79,0,63,13,-61,-82,85,-1,-104,-87,46,-35,100,14,52,98,78,27,57,-105, 
  /* [28][0][][] */ -118,121,-62,83,4,72,-114,-8,59,-75,-106,69,41,-77,21,-108,-93,81,19,99,107,76,4,-95,71,-74,79,102,-72,2,-21,44,-12,20,-41,-60,10,106,-40,124,-97,-29,-7,60,113,115,-14,4,123,-23,-117,7,48,-41,23,68,97,52,30,85,50,-47,-8,-118,-81,-6,90,-49,-89,63,50,119,-127,59,111,18,55,-56,-14,84,-73,65,64,-25,57,11,-78,-65,-98,20,76,-88,53,65,-12,112, 
  /* [29][0][][] */ 16,-24,37,16,-33,5,17,-119,-64,-37,-58,-87,69,-26,-88,-27,91,89,-72,95,24,-74,-89,-97,85,-69,-104,-49,-48,84,-67,21,-105,113,105,-4,-28,-102,21,-36,107,-59,-25,32,-90,56,-123,-2,-39,70,18,40,-83,-20,82,87,38,-20,-67,7,113,103,-79,40,73,-92,-123,34,66,-15,-35,-56,-28,-127,-29,-97,-66,33,-4,63,-11,-47,26,-34,19,-122,-71,84,-20,29,-73,-65,-110,-15,-73,-70, 
  /* [30][0][][] */ -79,-65,-63,-58,66,116,51,1,-78,51,30,76,109,52,-96,-97,110,108,95,15,-13,-70,127,-63,29,59,-16,32,89,-17,14,53,0,-30,16,45,-48,-34,72,-26,-10,-87,-67,-58,76,119,-39,-33,-58,125,-82,-30,-89,-21,94,-100,101,49,12,7,-51,-89,68,81,111,97,28,52,85,77,124,-81,38,-106,-63,48,70,-8,-4,-34,52,54,91,50,83,-37,61,47,98,40,59,-92,12,65,-67,-69, 
  /* [31][0][][] */ 50,110,76,-31,-59,32,104,-73,-73,-54,67,-55,-71,-72,94,32,-3,41,-39,16,-34,-32,104,14,71,95,-31,-59,-10,89,64,48,80,36,63,97,43,103,-11,-69,-9,100,-88,43,30,102,46,-2,-103,10,-80,44,12,-96,-30,-21,12,46,19,124,3,-127,116,-96,15,-90,84,-53,-110,32,104,-35,87,-72,-36,64,-19,92,62,-73,-10,-3,-121,-79,-26,88,127,-118,-78,84,33,-32,-40,-62,-116,66, 
};
const TfArray<4, int> tensor_dimension40 = { 4, { 32,1,1,96 } };
const TfArray<32, float> quant40_scale = { 32, { 0.001728746690787375, 0.0017387598054483533, 0.0017727033700793982, 0.0018909383798018098, 0.0017518990207463503, 0.0019466184312477708, 0.0022922568023204803, 0.0019336130935698748, 0.0022448597010225058, 0.001826921827159822, 0.0018160693580284715, 0.0018416400998830795, 0.0018819482065737247, 0.0018481840379536152, 0.0017173517262563109, 0.0018215205054730177, 0.0017576859099790454, 0.0016561707016080618, 0.0017383713275194168, 0.0017977332463487983, 0.0018269136780872941, 0.0019286754541099072, 0.0019999525975435972, 0.0020053938496857882, 0.0020900091622024775, 0.0018012877553701401, 0.0019687593448907137, 0.0019426523940637708, 0.0017420117510482669, 0.0017841786611825228, 0.0019163708202540874, 0.0018174136057496071, } };
const TfArray<32, int> quant40_zero = { 32, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant40 = { (TfLiteFloatArray*)&quant40_scale, (TfLiteIntArray*)&quant40_zero, 0 };
const ALIGN(16) int32_t tensor_data41[32] = { -228, -93, 306, 37, 193, -13, 623, -319, 635, -66, -185, -62, -237, 159, 52, -325, 109, -102, -281, 220, -100, 55, -129, 40, -74, -537, -117, -93, -98, -213, 413, 155, };
const TfArray<1, int> tensor_dimension41 = { 1, { 32 } };
const TfArray<32, float> quant41_scale = { 32, { 4.067639383720234e-05, 4.0911996620707214e-05, 4.1710667574079707e-05, 4.4492669985629618e-05, 4.1221155697712675e-05, 4.58027861895971e-05, 5.393545507104136e-05, 4.5496781240217388e-05, 5.2820229029748589e-05, 4.2986397602362558e-05, 4.2731044231913984e-05, 4.333270771894604e-05, 4.4281136069912463e-05, 4.3486685171956196e-05, 4.0408278437098488e-05, 4.2859308450715616e-05, 4.1357317968504503e-05, 3.8968722947174683e-05, 4.0902854379964992e-05, 4.2299605411244556e-05, 4.2986204789485782e-05, 4.5380598749034107e-05, 4.7057710617082193e-05, 4.7185738367261365e-05, 4.9176687753060833e-05, 4.2383242544019595e-05, 4.632374839275144e-05, 4.570946839521639e-05, 4.0988514228956774e-05, 4.1980674723163247e-05, 4.5091077481629327e-05, 4.2762672819662839e-05, } };
const TfArray<32, int> quant41_zero = { 32, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant41 = { (TfLiteFloatArray*)&quant41_scale, (TfLiteIntArray*)&quant41_zero, 0 };
const ALIGN(16) int8_t tensor_data42[3*1*1*32] = { 
  /* [0][0][][] */ -59,121,-78,-3,127,-78,-60,-92,113,-21,-40,-96,94,47,-61,-21,-70,-26,-116,59,11,-101,86,-88,17,42,68,-17,14,75,-20,127, 
  /* [1][0][][] */ 83,-56,-70,1,16,42,-127,-52,-59,109,77,14,89,74,-3,-51,93,10,-81,-82,103,-8,8,43,-70,61,-17,-26,64,7,-67,-33, 
  /* [2][0][][] */ -16,-97,120,108,1,77,-127,61,-58,35,-115,102,8,-84,106,53,98,-88,-83,99,11,30,21,58,-127,-52,-8,-15,22,90,-70,59, 
};
const TfArray<4, int> tensor_dimension42 = { 4, { 3,1,1,32 } };
const TfArray<3, float> quant42_scale = { 3, { 0.0031763641163706779, 0.0036673964932560921, 0.0030909625347703695, } };
const TfArray<3, int> quant42_zero = { 3, { 0,0,0 } };
const TfLiteAffineQuantization quant42 = { (TfLiteFloatArray*)&quant42_scale, (TfLiteIntArray*)&quant42_zero, 0 };
const ALIGN(8) int32_t tensor_data43[3] = { 41419, -40320, -47796, };
const TfArray<1, int> tensor_dimension43 = { 1, { 3 } };
const TfArray<3, float> quant43_scale = { 3, { 0.00014149308844935149, 0.00016336642147507519, 0.00013768882490694523, } };
const TfArray<3, int> quant43_zero = { 3, { 0,0,0 } };
const TfLiteAffineQuantization quant43 = { (TfLiteFloatArray*)&quant43_scale, (TfLiteIntArray*)&quant43_zero, 0 };
const TfArray<4, int> tensor_dimension44 = { 4, { 1,80,80,16 } };
const TfArray<1, float> quant44_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant44_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant44 = { (TfLiteFloatArray*)&quant44_scale, (TfLiteIntArray*)&quant44_zero, 0 };
const TfArray<4, int> tensor_dimension45 = { 4, { 1,80,80,16 } };
const TfArray<1, float> quant45_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant45_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant45 = { (TfLiteFloatArray*)&quant45_scale, (TfLiteIntArray*)&quant45_zero, 0 };
const TfArray<4, int> tensor_dimension46 = { 4, { 1,80,80,8 } };
const TfArray<1, float> quant46_scale = { 1, { 0.62467461824417114, } };
const TfArray<1, int> quant46_zero = { 1, { -3 } };
const TfLiteAffineQuantization quant46 = { (TfLiteFloatArray*)&quant46_scale, (TfLiteIntArray*)&quant46_zero, 0 };
const TfArray<4, int> tensor_dimension47 = { 4, { 1,80,80,48 } };
const TfArray<1, float> quant47_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant47_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant47 = { (TfLiteFloatArray*)&quant47_scale, (TfLiteIntArray*)&quant47_zero, 0 };
const TfArray<4, int> tensor_dimension48 = { 4, { 1,81,81,48 } };
const TfArray<1, float> quant48_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant48_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant48 = { (TfLiteFloatArray*)&quant48_scale, (TfLiteIntArray*)&quant48_zero, 0 };
const TfArray<4, int> tensor_dimension49 = { 4, { 1,40,40,48 } };
const TfArray<1, float> quant49_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant49_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant49 = { (TfLiteFloatArray*)&quant49_scale, (TfLiteIntArray*)&quant49_zero, 0 };
const TfArray<4, int> tensor_dimension50 = { 4, { 1,40,40,8 } };
const TfArray<1, float> quant50_scale = { 1, { 0.41412109136581421, } };
const TfArray<1, int> quant50_zero = { 1, { 6 } };
const TfLiteAffineQuantization quant50 = { (TfLiteFloatArray*)&quant50_scale, (TfLiteIntArray*)&quant50_zero, 0 };
const TfArray<4, int> tensor_dimension51 = { 4, { 1,40,40,48 } };
const TfArray<1, float> quant51_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant51_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant51 = { (TfLiteFloatArray*)&quant51_scale, (TfLiteIntArray*)&quant51_zero, 0 };
const TfArray<4, int> tensor_dimension52 = { 4, { 1,40,40,48 } };
const TfArray<1, float> quant52_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant52_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant52 = { (TfLiteFloatArray*)&quant52_scale, (TfLiteIntArray*)&quant52_zero, 0 };
const TfArray<4, int> tensor_dimension53 = { 4, { 1,40,40,8 } };
const TfArray<1, float> quant53_scale = { 1, { 0.48270288109779358, } };
const TfArray<1, int> quant53_zero = { 1, { -14 } };
const TfLiteAffineQuantization quant53 = { (TfLiteFloatArray*)&quant53_scale, (TfLiteIntArray*)&quant53_zero, 0 };
const TfArray<4, int> tensor_dimension54 = { 4, { 1,40,40,8 } };
const TfArray<1, float> quant54_scale = { 1, { 0.68764358758926392, } };
const TfArray<1, int> quant54_zero = { 1, { 1 } };
const TfLiteAffineQuantization quant54 = { (TfLiteFloatArray*)&quant54_scale, (TfLiteIntArray*)&quant54_zero, 0 };
const TfArray<4, int> tensor_dimension55 = { 4, { 1,40,40,48 } };
const TfArray<1, float> quant55_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant55_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant55 = { (TfLiteFloatArray*)&quant55_scale, (TfLiteIntArray*)&quant55_zero, 0 };
const TfArray<4, int> tensor_dimension56 = { 4, { 1,41,41,48 } };
const TfArray<1, float> quant56_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant56_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant56 = { (TfLiteFloatArray*)&quant56_scale, (TfLiteIntArray*)&quant56_zero, 0 };
const TfArray<4, int> tensor_dimension57 = { 4, { 1,20,20,48 } };
const TfArray<1, float> quant57_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant57_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant57 = { (TfLiteFloatArray*)&quant57_scale, (TfLiteIntArray*)&quant57_zero, 0 };
const TfArray<4, int> tensor_dimension58 = { 4, { 1,20,20,16 } };
const TfArray<1, float> quant58_scale = { 1, { 0.3265414834022522, } };
const TfArray<1, int> quant58_zero = { 1, { 0 } };
const TfLiteAffineQuantization quant58 = { (TfLiteFloatArray*)&quant58_scale, (TfLiteIntArray*)&quant58_zero, 0 };
const TfArray<4, int> tensor_dimension59 = { 4, { 1,20,20,96 } };
const TfArray<1, float> quant59_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant59_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant59 = { (TfLiteFloatArray*)&quant59_scale, (TfLiteIntArray*)&quant59_zero, 0 };
const TfArray<4, int> tensor_dimension60 = { 4, { 1,20,20,96 } };
const TfArray<1, float> quant60_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant60_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant60 = { (TfLiteFloatArray*)&quant60_scale, (TfLiteIntArray*)&quant60_zero, 0 };
const TfArray<4, int> tensor_dimension61 = { 4, { 1,20,20,16 } };
const TfArray<1, float> quant61_scale = { 1, { 0.24378979206085205, } };
const TfArray<1, int> quant61_zero = { 1, { -11 } };
const TfLiteAffineQuantization quant61 = { (TfLiteFloatArray*)&quant61_scale, (TfLiteIntArray*)&quant61_zero, 0 };
const TfArray<4, int> tensor_dimension62 = { 4, { 1,20,20,16 } };
const TfArray<1, float> quant62_scale = { 1, { 0.37509399652481079, } };
const TfArray<1, int> quant62_zero = { 1, { -6 } };
const TfLiteAffineQuantization quant62 = { (TfLiteFloatArray*)&quant62_scale, (TfLiteIntArray*)&quant62_zero, 0 };
const TfArray<4, int> tensor_dimension63 = { 4, { 1,20,20,96 } };
const TfArray<1, float> quant63_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant63_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant63 = { (TfLiteFloatArray*)&quant63_scale, (TfLiteIntArray*)&quant63_zero, 0 };
const TfArray<4, int> tensor_dimension64 = { 4, { 1,20,20,96 } };
const TfArray<1, float> quant64_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant64_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant64 = { (TfLiteFloatArray*)&quant64_scale, (TfLiteIntArray*)&quant64_zero, 0 };
const TfArray<4, int> tensor_dimension65 = { 4, { 1,20,20,16 } };
const TfArray<1, float> quant65_scale = { 1, { 0.23844107985496521, } };
const TfArray<1, int> quant65_zero = { 1, { -7 } };
const TfLiteAffineQuantization quant65 = { (TfLiteFloatArray*)&quant65_scale, (TfLiteIntArray*)&quant65_zero, 0 };
const TfArray<4, int> tensor_dimension66 = { 4, { 1,20,20,16 } };
const TfArray<1, float> quant66_scale = { 1, { 0.42149236798286438, } };
const TfArray<1, int> quant66_zero = { 1, { -3 } };
const TfLiteAffineQuantization quant66 = { (TfLiteFloatArray*)&quant66_scale, (TfLiteIntArray*)&quant66_zero, 0 };
const TfArray<4, int> tensor_dimension67 = { 4, { 1,20,20,96 } };
const TfArray<1, float> quant67_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant67_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant67 = { (TfLiteFloatArray*)&quant67_scale, (TfLiteIntArray*)&quant67_zero, 0 };
const TfArray<4, int> tensor_dimension68 = { 4, { 1,20,20,32 } };
const TfArray<1, float> quant68_scale = { 1, { 0.04454561322927475, } };
const TfArray<1, int> quant68_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant68 = { (TfLiteFloatArray*)&quant68_scale, (TfLiteIntArray*)&quant68_zero, 0 };
const TfArray<4, int> tensor_dimension69 = { 4, { 1,20,20,3 } };
const TfArray<1, float> quant69_scale = { 1, { 0.098921932280063629, } };
const TfArray<1, int> quant69_zero = { 1, { 9 } };
const TfLiteAffineQuantization quant69 = { (TfLiteFloatArray*)&quant69_scale, (TfLiteIntArray*)&quant69_zero, 0 };
const TfArray<4, int> tensor_dimension70 = { 4, { 1,20,20,3 } };
const TfArray<1, float> quant70_scale = { 1, { 0.00390625, } };
const TfArray<1, int> quant70_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant70 = { (TfLiteFloatArray*)&quant70_scale, (TfLiteIntArray*)&quant70_zero, 0 };
const TfLiteConvParams opdata0 = { kTfLitePaddingSame, 2,2, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs0 = { 3, { 0,2,3 } };
const TfArray<1, int> outputs0 = { 1, { 44 } };
const TfLiteDepthwiseConvParams opdata1 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs1 = { 3, { 44,4,5 } };
const TfArray<1, int> outputs1 = { 1, { 45 } };
const TfLiteConvParams opdata2 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs2 = { 3, { 45,6,7 } };
const TfArray<1, int> outputs2 = { 1, { 46 } };
const TfLiteConvParams opdata3 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs3 = { 3, { 46,8,9 } };
const TfArray<1, int> outputs3 = { 1, { 47 } };
const TfArray<2, int> inputs4 = { 2, { 47,1 } };
const TfArray<1, int> outputs4 = { 1, { 48 } };
const TfLiteDepthwiseConvParams opdata5 = { kTfLitePaddingValid, 2,2, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs5 = { 3, { 48,10,11 } };
const TfArray<1, int> outputs5 = { 1, { 49 } };
const TfLiteConvParams opdata6 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs6 = { 3, { 49,12,13 } };
const TfArray<1, int> outputs6 = { 1, { 50 } };
const TfLiteConvParams opdata7 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs7 = { 3, { 50,14,15 } };
const TfArray<1, int> outputs7 = { 1, { 51 } };
const TfLiteDepthwiseConvParams opdata8 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs8 = { 3, { 51,16,17 } };
const TfArray<1, int> outputs8 = { 1, { 52 } };
const TfLiteConvParams opdata9 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs9 = { 3, { 52,18,19 } };
const TfArray<1, int> outputs9 = { 1, { 53 } };
const TfLiteAddParams opdata10 = { kTfLiteActNone };
const TfArray<2, int> inputs10 = { 2, { 50,53 } };
const TfArray<1, int> outputs10 = { 1, { 54 } };
const TfLiteConvParams opdata11 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs11 = { 3, { 54,20,21 } };
const TfArray<1, int> outputs11 = { 1, { 55 } };
const TfArray<2, int> inputs12 = { 2, { 55,1 } };
const TfArray<1, int> outputs12 = { 1, { 56 } };
const TfLiteDepthwiseConvParams opdata13 = { kTfLitePaddingValid, 2,2, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs13 = { 3, { 56,22,23 } };
const TfArray<1, int> outputs13 = { 1, { 57 } };
const TfLiteConvParams opdata14 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs14 = { 3, { 57,24,25 } };
const TfArray<1, int> outputs14 = { 1, { 58 } };
const TfLiteConvParams opdata15 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs15 = { 3, { 58,26,27 } };
const TfArray<1, int> outputs15 = { 1, { 59 } };
const TfLiteDepthwiseConvParams opdata16 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs16 = { 3, { 59,28,29 } };
const TfArray<1, int> outputs16 = { 1, { 60 } };
const TfLiteConvParams opdata17 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs17 = { 3, { 60,30,31 } };
const TfArray<1, int> outputs17 = { 1, { 61 } };
const TfLiteAddParams opdata18 = { kTfLiteActNone };
const TfArray<2, int> inputs18 = { 2, { 58,61 } };
const TfArray<1, int> outputs18 = { 1, { 62 } };
const TfLiteConvParams opdata19 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs19 = { 3, { 62,32,33 } };
const TfArray<1, int> outputs19 = { 1, { 63 } };
const TfLiteDepthwiseConvParams opdata20 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs20 = { 3, { 63,34,35 } };
const TfArray<1, int> outputs20 = { 1, { 64 } };
const TfLiteConvParams opdata21 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs21 = { 3, { 64,36,37 } };
const TfArray<1, int> outputs21 = { 1, { 65 } };
const TfLiteAddParams opdata22 = { kTfLiteActNone };
const TfArray<2, int> inputs22 = { 2, { 62,65 } };
const TfArray<1, int> outputs22 = { 1, { 66 } };
const TfLiteConvParams opdata23 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs23 = { 3, { 66,38,39 } };
const TfArray<1, int> outputs23 = { 1, { 67 } };
const TfLiteConvParams opdata24 = { kTfLitePaddingValid, 1,1, kTfLiteActRelu, 1,1 };
const TfArray<3, int> inputs24 = { 3, { 67,40,41 } };
const TfArray<1, int> outputs24 = { 1, { 68 } };
const TfLiteConvParams opdata25 = { kTfLitePaddingValid, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs25 = { 3, { 68,42,43 } };
const TfArray<1, int> outputs25 = { 1, { 69 } };
const TfLiteSoftmaxParams opdata26 = { 1 };
const TfArray<1, int> inputs26 = { 1, { 69 } };
const TfArray<1, int> outputs26 = { 1, { 70 } };
const TensorInfo_t tensorData[] = {
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension0, 76800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant0))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data1, (TfLiteIntArray*)&tensor_dimension1, 32, {kTfLiteNoQuantization, nullptr}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data2, (TfLiteIntArray*)&tensor_dimension2, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant2))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data3, (TfLiteIntArray*)&tensor_dimension3, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant3))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data4, (TfLiteIntArray*)&tensor_dimension4, 144, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant4))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data5, (TfLiteIntArray*)&tensor_dimension5, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant5))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data6, (TfLiteIntArray*)&tensor_dimension6, 128, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant6))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data7, (TfLiteIntArray*)&tensor_dimension7, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant7))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data8, (TfLiteIntArray*)&tensor_dimension8, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant8))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data9, (TfLiteIntArray*)&tensor_dimension9, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant9))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data10, (TfLiteIntArray*)&tensor_dimension10, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant10))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data11, (TfLiteIntArray*)&tensor_dimension11, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant11))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data12, (TfLiteIntArray*)&tensor_dimension12, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant12))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data13, (TfLiteIntArray*)&tensor_dimension13, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant13))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data14, (TfLiteIntArray*)&tensor_dimension14, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant14))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data15, (TfLiteIntArray*)&tensor_dimension15, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant15))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data16, (TfLiteIntArray*)&tensor_dimension16, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant16))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data17, (TfLiteIntArray*)&tensor_dimension17, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant17))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data18, (TfLiteIntArray*)&tensor_dimension18, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant18))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data19, (TfLiteIntArray*)&tensor_dimension19, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant19))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data20, (TfLiteIntArray*)&tensor_dimension20, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant20))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data21, (TfLiteIntArray*)&tensor_dimension21, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant21))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data22, (TfLiteIntArray*)&tensor_dimension22, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant22))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data23, (TfLiteIntArray*)&tensor_dimension23, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant23))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data24, (TfLiteIntArray*)&tensor_dimension24, 768, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant24))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data25, (TfLiteIntArray*)&tensor_dimension25, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant25))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data26, (TfLiteIntArray*)&tensor_dimension26, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant26))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data27, (TfLiteIntArray*)&tensor_dimension27, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant27))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data28, (TfLiteIntArray*)&tensor_dimension28, 864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant28))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data29, (TfLiteIntArray*)&tensor_dimension29, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant29))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data30, (TfLiteIntArray*)&tensor_dimension30, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant30))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data31, (TfLiteIntArray*)&tensor_dimension31, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant31))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data32, (TfLiteIntArray*)&tensor_dimension32, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant32))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data33, (TfLiteIntArray*)&tensor_dimension33, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant33))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data34, (TfLiteIntArray*)&tensor_dimension34, 864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant34))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data35, (TfLiteIntArray*)&tensor_dimension35, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant35))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data36, (TfLiteIntArray*)&tensor_dimension36, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant36))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data37, (TfLiteIntArray*)&tensor_dimension37, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant37))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data38, (TfLiteIntArray*)&tensor_dimension38, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant38))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data39, (TfLiteIntArray*)&tensor_dimension39, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant39))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data40, (TfLiteIntArray*)&tensor_dimension40, 3072, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant40))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data41, (TfLiteIntArray*)&tensor_dimension41, 128, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant41))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data42, (TfLiteIntArray*)&tensor_dimension42, 96, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant42))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data43, (TfLiteIntArray*)&tensor_dimension43, 12, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant43))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 102400, (TfLiteIntArray*)&tensor_dimension44, 102400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant44))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension45, 102400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant45))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 102400, (TfLiteIntArray*)&tensor_dimension46, 51200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant46))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 314928, (TfLiteIntArray*)&tensor_dimension47, 307200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant47))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension48, 314928, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant48))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 314928, (TfLiteIntArray*)&tensor_dimension49, 76800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant49))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 153600, (TfLiteIntArray*)&tensor_dimension50, 12800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant50))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 76800, (TfLiteIntArray*)&tensor_dimension51, 76800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant51))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension52, 76800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant52))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 76800, (TfLiteIntArray*)&tensor_dimension53, 12800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant53))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension54, 12800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant54))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 80688, (TfLiteIntArray*)&tensor_dimension55, 76800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant55))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension56, 80688, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant56))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 80688, (TfLiteIntArray*)&tensor_dimension57, 19200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant57))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 99888, (TfLiteIntArray*)&tensor_dimension58, 6400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant58))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 38400, (TfLiteIntArray*)&tensor_dimension59, 38400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant59))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension60, 38400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant60))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 38400, (TfLiteIntArray*)&tensor_dimension61, 6400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant61))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 76800, (TfLiteIntArray*)&tensor_dimension62, 6400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant62))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 38400, (TfLiteIntArray*)&tensor_dimension63, 38400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant63))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension64, 38400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant64))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 44800, (TfLiteIntArray*)&tensor_dimension65, 6400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant65))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 38400, (TfLiteIntArray*)&tensor_dimension66, 6400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant66))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension67, 38400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant67))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 38400, (TfLiteIntArray*)&tensor_dimension68, 12800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant68))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 1200, (TfLiteIntArray*)&tensor_dimension69, 1200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant69))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension70, 1200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant70))}, },
};const NodeInfo_t nodeData[] = {
  { (TfLiteIntArray*)&inputs0, (TfLiteIntArray*)&outputs0, const_cast<void*>(static_cast<const void*>(&opdata0)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs1, (TfLiteIntArray*)&outputs1, const_cast<void*>(static_cast<const void*>(&opdata1)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs2, (TfLiteIntArray*)&outputs2, const_cast<void*>(static_cast<const void*>(&opdata2)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs3, (TfLiteIntArray*)&outputs3, const_cast<void*>(static_cast<const void*>(&opdata3)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs4, (TfLiteIntArray*)&outputs4, nullptr, OP_PAD, },
  { (TfLiteIntArray*)&inputs5, (TfLiteIntArray*)&outputs5, const_cast<void*>(static_cast<const void*>(&opdata5)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs6, (TfLiteIntArray*)&outputs6, const_cast<void*>(static_cast<const void*>(&opdata6)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs7, (TfLiteIntArray*)&outputs7, const_cast<void*>(static_cast<const void*>(&opdata7)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs8, (TfLiteIntArray*)&outputs8, const_cast<void*>(static_cast<const void*>(&opdata8)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs9, (TfLiteIntArray*)&outputs9, const_cast<void*>(static_cast<const void*>(&opdata9)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs10, (TfLiteIntArray*)&outputs10, const_cast<void*>(static_cast<const void*>(&opdata10)), OP_ADD, },
  { (TfLiteIntArray*)&inputs11, (TfLiteIntArray*)&outputs11, const_cast<void*>(static_cast<const void*>(&opdata11)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs12, (TfLiteIntArray*)&outputs12, nullptr, OP_PAD, },
  { (TfLiteIntArray*)&inputs13, (TfLiteIntArray*)&outputs13, const_cast<void*>(static_cast<const void*>(&opdata13)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs14, (TfLiteIntArray*)&outputs14, const_cast<void*>(static_cast<const void*>(&opdata14)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs15, (TfLiteIntArray*)&outputs15, const_cast<void*>(static_cast<const void*>(&opdata15)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs16, (TfLiteIntArray*)&outputs16, const_cast<void*>(static_cast<const void*>(&opdata16)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs17, (TfLiteIntArray*)&outputs17, const_cast<void*>(static_cast<const void*>(&opdata17)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs18, (TfLiteIntArray*)&outputs18, const_cast<void*>(static_cast<const void*>(&opdata18)), OP_ADD, },
  { (TfLiteIntArray*)&inputs19, (TfLiteIntArray*)&outputs19, const_cast<void*>(static_cast<const void*>(&opdata19)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs20, (TfLiteIntArray*)&outputs20, const_cast<void*>(static_cast<const void*>(&opdata20)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs21, (TfLiteIntArray*)&outputs21, const_cast<void*>(static_cast<const void*>(&opdata21)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs22, (TfLiteIntArray*)&outputs22, const_cast<void*>(static_cast<const void*>(&opdata22)), OP_ADD, },
  { (TfLiteIntArray*)&inputs23, (TfLiteIntArray*)&outputs23, const_cast<void*>(static_cast<const void*>(&opdata23)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs24, (TfLiteIntArray*)&outputs24, const_cast<void*>(static_cast<const void*>(&opdata24)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs25, (TfLiteIntArray*)&outputs25, const_cast<void*>(static_cast<const void*>(&opdata25)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs26, (TfLiteIntArray*)&outputs26, const_cast<void*>(static_cast<const void*>(&opdata26)), OP_SOFTMAX, },
};
static void* overflow_buffers[EI_MAX_OVERFLOW_BUFFER_COUNT];
static size_t overflow_buffers_ix = 0;
static void * AllocatePersistentBuffer(struct TfLiteContext* ctx,
                                       size_t bytes) {
  void *ptr;
  if (current_location - bytes < tensor_boundary) {
    if (overflow_buffers_ix > EI_MAX_OVERFLOW_BUFFER_COUNT - 1) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d, does not fit in tensor arena and reached EI_MAX_OVERFLOW_BUFFER_COUNT\n",
        (int)bytes);
      return NULL;
    }

    // OK, this will look super weird, but.... we have CMSIS-NN buffers which
    // we cannot calculate beforehand easily.
    ptr = ei_calloc(bytes, 1);
    if (ptr == NULL) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d\n", (int)bytes);
      return NULL;
    }
    overflow_buffers[overflow_buffers_ix++] = ptr;
    return ptr;
  }

  current_location -= bytes;

  ptr = current_location;
  memset(ptr, 0, bytes);

  return ptr;
}
typedef struct {
  size_t bytes;
  void *ptr;
} scratch_buffer_t;
static scratch_buffer_t scratch_buffers[EI_MAX_SCRATCH_BUFFER_COUNT];
static size_t scratch_buffers_ix = 0;

static TfLiteStatus RequestScratchBufferInArena(struct TfLiteContext* ctx, size_t bytes,
                                                int* buffer_idx) {
  if (scratch_buffers_ix > EI_MAX_SCRATCH_BUFFER_COUNT - 1) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d, reached EI_MAX_SCRATCH_BUFFER_COUNT\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffer_t b;
  b.bytes = bytes;

  b.ptr = AllocatePersistentBuffer(ctx, b.bytes);
  if (!b.ptr) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffers[scratch_buffers_ix] = b;
  *buffer_idx = scratch_buffers_ix;

  scratch_buffers_ix++;

  return kTfLiteOk;
}

static void* GetScratchBuffer(struct TfLiteContext* ctx, int buffer_idx) {
  if (buffer_idx > (int)scratch_buffers_ix) {
    return NULL;
  }
  return scratch_buffers[buffer_idx].ptr;
}

static TfLiteTensor* GetTensor(const struct TfLiteContext* context,
                               int tensor_idx) {
  return &tflTensors[tensor_idx];
}

static TfLiteEvalTensor* GetEvalTensor(const struct TfLiteContext* context,
                                       int tensor_idx) {
  return &tflEvalTensors[tensor_idx];
}

} // namespace

TfLiteStatus trained_model_init( void*(*alloc_fnc)(size_t,size_t) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  tensor_arena = (uint8_t*) alloc_fnc(16, kTensorArenaSize);
  if (!tensor_arena) {
    ei_printf("ERR: failed to allocate tensor arena\n");
    return kTfLiteError;
  }
#else
  memset(tensor_arena, 0, kTensorArenaSize);
#endif
  tensor_boundary = tensor_arena;
  current_location = tensor_arena + kTensorArenaSize;
  ctx.AllocatePersistentBuffer = &AllocatePersistentBuffer;
  ctx.RequestScratchBufferInArena = &RequestScratchBufferInArena;
  ctx.GetScratchBuffer = &GetScratchBuffer;
  ctx.GetTensor = &GetTensor;
  ctx.GetEvalTensor = &GetEvalTensor;
  ctx.tensors = tflTensors;
  ctx.tensors_size = 71;
  for (size_t i = 0; i < 71; ++i) {
    tflTensors[i].type = tensorData[i].type;
    tflEvalTensors[i].type = tensorData[i].type;
    tflTensors[i].is_variable = 0;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
    tflTensors[i].allocation_type = tensorData[i].allocation_type;
#else
    tflTensors[i].allocation_type = (tensor_arena <= tensorData[i].data && tensorData[i].data < tensor_arena + kTensorArenaSize) ? kTfLiteArenaRw : kTfLiteMmapRo;
#endif
    tflTensors[i].bytes = tensorData[i].bytes;
    tflTensors[i].dims = tensorData[i].dims;
    tflEvalTensors[i].dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
    if(tflTensors[i].allocation_type == kTfLiteArenaRw){
      uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

     tflTensors[i].data.data =  start;
     tflEvalTensors[i].data.data =  start;
    }
    else {
       tflTensors[i].data.data = tensorData[i].data;
       tflEvalTensors[i].data.data = tensorData[i].data;
    }
#else
    tflTensors[i].data.data = tensorData[i].data;
    tflEvalTensors[i].data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
    tflTensors[i].quantization = tensorData[i].quantization;
    if (tflTensors[i].quantization.type == kTfLiteAffineQuantization) {
      TfLiteAffineQuantization const* quant = ((TfLiteAffineQuantization const*)(tensorData[i].quantization.params));
      tflTensors[i].params.scale = quant->scale->data[0];
      tflTensors[i].params.zero_point = quant->zero_point->data[0];
    }
    if (tflTensors[i].allocation_type == kTfLiteArenaRw) {
      auto data_end_ptr = (uint8_t*)tflTensors[i].data.data + tensorData[i].bytes;
      if (data_end_ptr > tensor_boundary) {
        tensor_boundary = data_end_ptr;
      }
    }
  }
  if (tensor_boundary > current_location /* end of arena size */) {
    ei_printf("ERR: tensor arena is too small, does not fit model - even without scratch buffers\n");
    return kTfLiteError;
  }
  registrations[OP_CONV_2D] = Register_CONV_2D();
  registrations[OP_DEPTHWISE_CONV_2D] = Register_DEPTHWISE_CONV_2D();
  registrations[OP_PAD] = Register_PAD();
  registrations[OP_ADD] = Register_ADD();
  registrations[OP_SOFTMAX] = Register_SOFTMAX();

  for (size_t i = 0; i < 27; ++i) {
    tflNodes[i].inputs = nodeData[i].inputs;
    tflNodes[i].outputs = nodeData[i].outputs;
    tflNodes[i].builtin_data = nodeData[i].builtin_data;
tflNodes[i].custom_initial_data = nullptr;
      tflNodes[i].custom_initial_data_size = 0;
if (registrations[nodeData[i].used_op_index].init) {
      tflNodes[i].user_data = registrations[nodeData[i].used_op_index].init(&ctx, (const char*)tflNodes[i].builtin_data, 0);
    }
  }
  for (size_t i = 0; i < 27; ++i) {
    if (registrations[nodeData[i].used_op_index].prepare) {
      TfLiteStatus status = registrations[nodeData[i].used_op_index].prepare(&ctx, &tflNodes[i]);
      if (status != kTfLiteOk) {
        return status;
      }
    }
  }
  return kTfLiteOk;
}

static const int inTensorIndices[] = {
  0, 
};
TfLiteTensor* trained_model_input(int index) {
  return &ctx.tensors[inTensorIndices[index]];
}

static const int outTensorIndices[] = {
  70, 
};
TfLiteTensor* trained_model_output(int index) {
  return &ctx.tensors[outTensorIndices[index]];
}

TfLiteStatus trained_model_invoke() {
  for (size_t i = 0; i < 27; ++i) {
    TfLiteStatus status = registrations[nodeData[i].used_op_index].invoke(&ctx, &tflNodes[i]);

#if EI_CLASSIFIER_PRINT_STATE
    ei_printf("layer %lu\n", i);
    ei_printf("    inputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].inputs->size; ix++) {
      auto d = tensorData[tflNodes[i].inputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");

    ei_printf("    outputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].outputs->size; ix++) {
      auto d = tensorData[tflNodes[i].outputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");
#endif // EI_CLASSIFIER_PRINT_STATE

    if (status != kTfLiteOk) {
      return status;
    }
  }
  return kTfLiteOk;
}

TfLiteStatus trained_model_reset( void (*free_fnc)(void* ptr) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  free_fnc(tensor_arena);
#endif

  // scratch buffers are allocated within the arena, so just reset the counter so memory can be reused
  scratch_buffers_ix = 0;

  // overflow buffers are on the heap, so free them first
  for (size_t ix = 0; ix < overflow_buffers_ix; ix++) {
    ei_free(overflow_buffers[ix]);
  }
  overflow_buffers_ix = 0;
  return kTfLiteOk;
}
