#include "edge-impulse-sdk/dsp/config.hpp"
#if EIDSP_LOAD_CMSIS_DSP_SOURCES
/* ----------------------------------------------------------------------
 * Project:      CMSIS DSP Library
 * Title:        arm_common_tables_f16.c
 * Description:  common tables like fft twiddle factors, Bitreverse, reciprocal etc
 *
 * $Date:        18. March 2019
 * $Revision:    V1.6.0
 *
 * Target Processor: Cortex-M cores
 * -------------------------------------------------------------------- */
/*
 * Copyright (C) 2010-2019 ARM Limited or its affiliates. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "edge-impulse-sdk/CMSIS/DSP/Include/arm_math_types_f16.h"
/**
  @ingroup ComplexFFT
 */

/**
  @addtogroup CFFT_CIFFT Complex FFT Tables
  @{
 */


/**
  @brief  Floating-point Twiddle factors Table Generation
*/

/* F16 */
#if !defined(__CC_ARM)

#if defined(ARM_FLOAT16_SUPPORTED)

#include "edge-impulse-sdk/CMSIS/DSP/Include/arm_common_tables_f16.h"


#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_16)

/**
* \par
* Example code for Floating-point Twiddle factors Generation:
* \par
* <pre>for(i = 0; i< N/; i++)
* {
* twiddleCoef[2*i]= cos(i * 2*PI/(float)N);
* twiddleCoef[2*i+1]= sin(i * 2*PI/(float)N);
* } </pre>
* \par
* where N = 16  and PI = 3.14159265358979
* \par
* Cos and Sin values are in interleaved fashion
*
*/
const float16_t twiddleCoefF16_16[32] = {
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
   (float16_t)-0.382683432f,  (float16_t)0.923879533f,
   (float16_t)-0.707106781f,  (float16_t)0.707106781f,
   (float16_t)-0.923879533f,  (float16_t)0.382683432f,
   (float16_t)-1.000000000f,  (float16_t)0.000000000f,
   (float16_t)-0.923879533f, (float16_t)-0.382683432f,
   (float16_t)-0.707106781f, (float16_t)-0.707106781f,
   (float16_t)-0.382683432f, (float16_t)-0.923879533f,
   (float16_t)-0.000000000f, (float16_t)-1.000000000f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f
};
#endif 

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_32)

/**
* \par
* Example code for Floating-point Twiddle factors Generation:
* \par
* <pre>for(i = 0; i< N/; i++)
* {
* twiddleCoef[2*i]= cos(i * 2*PI/(float)N);
* twiddleCoef[2*i+1]= sin(i * 2*PI/(float)N);
* } </pre>
* \par
* where N = 32  and PI = 3.14159265358979
* \par
* Cos and Sin values are in interleaved fashion
*
*/
const float16_t twiddleCoefF16_32[64] = {
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
   (float16_t)-0.195090322f,  (float16_t)0.980785280f,
   (float16_t)-0.382683432f,  (float16_t)0.923879533f,
   (float16_t)-0.555570233f,  (float16_t)0.831469612f,
   (float16_t)-0.707106781f,  (float16_t)0.707106781f,
   (float16_t)-0.831469612f,  (float16_t)0.555570233f,
   (float16_t)-0.923879533f,  (float16_t)0.382683432f,
   (float16_t)-0.980785280f,  (float16_t)0.195090322f,
   (float16_t)-1.000000000f,  (float16_t)0.000000000f,
   (float16_t)-0.980785280f, (float16_t)-0.195090322f,
   (float16_t)-0.923879533f, (float16_t)-0.382683432f,
   (float16_t)-0.831469612f, (float16_t)-0.555570233f,
   (float16_t)-0.707106781f, (float16_t)-0.707106781f,
   (float16_t)-0.555570233f, (float16_t)-0.831469612f,
   (float16_t)-0.382683432f, (float16_t)-0.923879533f,
   (float16_t)-0.195090322f, (float16_t)-0.980785280f,
   (float16_t)-0.000000000f, (float16_t)-1.000000000f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f
};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_64)

/**
* \par
* Example code for Floating-point Twiddle factors Generation:
* \par
* <pre>for(i = 0; i< N/; i++)
* {
* twiddleCoef[2*i]= cos(i * 2*PI/(float)N);
* twiddleCoef[2*i+1]= sin(i * 2*PI/(float)N);
* } </pre>
* \par
* where N = 64  and PI = 3.14159265358979
* \par
* Cos and Sin values are in interleaved fashion
*
*/
const float16_t twiddleCoefF16_64[128] = {
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.995184727f,  (float16_t)0.098017140f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.956940336f,  (float16_t)0.290284677f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.881921264f,  (float16_t)0.471396737f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.773010453f,  (float16_t)0.634393284f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.634393284f,  (float16_t)0.773010453f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.471396737f,  (float16_t)0.881921264f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.290284677f,  (float16_t)0.956940336f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.098017140f,  (float16_t)0.995184727f,
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
   (float16_t)-0.098017140f,  (float16_t)0.995184727f,
   (float16_t)-0.195090322f,  (float16_t)0.980785280f,
   (float16_t)-0.290284677f,  (float16_t)0.956940336f,
   (float16_t)-0.382683432f,  (float16_t)0.923879533f,
   (float16_t)-0.471396737f,  (float16_t)0.881921264f,
   (float16_t)-0.555570233f,  (float16_t)0.831469612f,
   (float16_t)-0.634393284f,  (float16_t)0.773010453f,
   (float16_t)-0.707106781f,  (float16_t)0.707106781f,
   (float16_t)-0.773010453f,  (float16_t)0.634393284f,
   (float16_t)-0.831469612f,  (float16_t)0.555570233f,
   (float16_t)-0.881921264f,  (float16_t)0.471396737f,
   (float16_t)-0.923879533f,  (float16_t)0.382683432f,
   (float16_t)-0.956940336f,  (float16_t)0.290284677f,
   (float16_t)-0.980785280f,  (float16_t)0.195090322f,
   (float16_t)-0.995184727f,  (float16_t)0.098017140f,
   (float16_t)-1.000000000f,  (float16_t)0.000000000f,
   (float16_t)-0.995184727f, (float16_t)-0.098017140f,
   (float16_t)-0.980785280f, (float16_t)-0.195090322f,
   (float16_t)-0.956940336f, (float16_t)-0.290284677f,
   (float16_t)-0.923879533f, (float16_t)-0.382683432f,
   (float16_t)-0.881921264f, (float16_t)-0.471396737f,
   (float16_t)-0.831469612f, (float16_t)-0.555570233f,
   (float16_t)-0.773010453f, (float16_t)-0.634393284f,
   (float16_t)-0.707106781f, (float16_t)-0.707106781f,
   (float16_t)-0.634393284f, (float16_t)-0.773010453f,
   (float16_t)-0.555570233f, (float16_t)-0.831469612f,
   (float16_t)-0.471396737f, (float16_t)-0.881921264f,
   (float16_t)-0.382683432f, (float16_t)-0.923879533f,
   (float16_t)-0.290284677f, (float16_t)-0.956940336f,
   (float16_t)-0.195090322f, (float16_t)-0.980785280f,
   (float16_t)-0.098017140f, (float16_t)-0.995184727f,
   (float16_t)-0.000000000f, (float16_t)-1.000000000f,
    (float16_t)0.098017140f, (float16_t)-0.995184727f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.290284677f, (float16_t)-0.956940336f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.471396737f, (float16_t)-0.881921264f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.634393284f, (float16_t)-0.773010453f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.773010453f, (float16_t)-0.634393284f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.881921264f, (float16_t)-0.471396737f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.956940336f, (float16_t)-0.290284677f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.995184727f, (float16_t)-0.098017140f
};
#endif 

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_128)

/**
* \par
* Example code for Floating-point Twiddle factors Generation:
* \par
* <pre>for(i = 0; i< N/; i++)
* {
* twiddleCoef[2*i]= cos(i * 2*PI/(float)N);
* twiddleCoef[2*i+1]= sin(i * 2*PI/(float)N);
* } </pre>
* \par
* where N = 128 and PI = 3.14159265358979
* \par
* Cos and Sin values are in interleaved fashion
*
*/

const float16_t twiddleCoefF16_128[256] = {
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.998795456f,  (float16_t)0.049067674f,
    (float16_t)0.995184727f,  (float16_t)0.098017140f,
    (float16_t)0.989176510f,  (float16_t)0.146730474f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.970031253f,  (float16_t)0.242980180f,
    (float16_t)0.956940336f,  (float16_t)0.290284677f,
    (float16_t)0.941544065f,  (float16_t)0.336889853f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.903989293f,  (float16_t)0.427555093f,
    (float16_t)0.881921264f,  (float16_t)0.471396737f,
    (float16_t)0.857728610f,  (float16_t)0.514102744f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.803207531f,  (float16_t)0.595699304f,
    (float16_t)0.773010453f,  (float16_t)0.634393284f,
    (float16_t)0.740951125f,  (float16_t)0.671558955f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.671558955f,  (float16_t)0.740951125f,
    (float16_t)0.634393284f,  (float16_t)0.773010453f,
    (float16_t)0.595699304f,  (float16_t)0.803207531f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.514102744f,  (float16_t)0.857728610f,
    (float16_t)0.471396737f,  (float16_t)0.881921264f,
    (float16_t)0.427555093f,  (float16_t)0.903989293f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.336889853f,  (float16_t)0.941544065f,
    (float16_t)0.290284677f,  (float16_t)0.956940336f,
    (float16_t)0.242980180f,  (float16_t)0.970031253f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.146730474f,  (float16_t)0.989176510f,
    (float16_t)0.098017140f,  (float16_t)0.995184727f,
    (float16_t)0.049067674f,  (float16_t)0.998795456f,
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
   (float16_t)-0.049067674f,  (float16_t)0.998795456f,
   (float16_t)-0.098017140f,  (float16_t)0.995184727f,
   (float16_t)-0.146730474f,  (float16_t)0.989176510f,
   (float16_t)-0.195090322f,  (float16_t)0.980785280f,
   (float16_t)-0.242980180f,  (float16_t)0.970031253f,
   (float16_t)-0.290284677f,  (float16_t)0.956940336f,
   (float16_t)-0.336889853f,  (float16_t)0.941544065f,
   (float16_t)-0.382683432f,  (float16_t)0.923879533f,
   (float16_t)-0.427555093f,  (float16_t)0.903989293f,
   (float16_t)-0.471396737f,  (float16_t)0.881921264f,
   (float16_t)-0.514102744f,  (float16_t)0.857728610f,
   (float16_t)-0.555570233f,  (float16_t)0.831469612f,
   (float16_t)-0.595699304f,  (float16_t)0.803207531f,
   (float16_t)-0.634393284f,  (float16_t)0.773010453f,
   (float16_t)-0.671558955f,  (float16_t)0.740951125f,
   (float16_t)-0.707106781f,  (float16_t)0.707106781f,
   (float16_t)-0.740951125f,  (float16_t)0.671558955f,
   (float16_t)-0.773010453f,  (float16_t)0.634393284f,
   (float16_t)-0.803207531f,  (float16_t)0.595699304f,
   (float16_t)-0.831469612f,  (float16_t)0.555570233f,
   (float16_t)-0.857728610f,  (float16_t)0.514102744f,
   (float16_t)-0.881921264f,  (float16_t)0.471396737f,
   (float16_t)-0.903989293f,  (float16_t)0.427555093f,
   (float16_t)-0.923879533f,  (float16_t)0.382683432f,
   (float16_t)-0.941544065f,  (float16_t)0.336889853f,
   (float16_t)-0.956940336f,  (float16_t)0.290284677f,
   (float16_t)-0.970031253f,  (float16_t)0.242980180f,
   (float16_t)-0.980785280f,  (float16_t)0.195090322f,
   (float16_t)-0.989176510f,  (float16_t)0.146730474f,
   (float16_t)-0.995184727f,  (float16_t)0.098017140f,
   (float16_t)-0.998795456f,  (float16_t)0.049067674f,
   (float16_t)-1.000000000f,  (float16_t)0.000000000f,
   (float16_t)-0.998795456f, (float16_t)-0.049067674f,
   (float16_t)-0.995184727f, (float16_t)-0.098017140f,
   (float16_t)-0.989176510f, (float16_t)-0.146730474f,
   (float16_t)-0.980785280f, (float16_t)-0.195090322f,
   (float16_t)-0.970031253f, (float16_t)-0.242980180f,
   (float16_t)-0.956940336f, (float16_t)-0.290284677f,
   (float16_t)-0.941544065f, (float16_t)-0.336889853f,
   (float16_t)-0.923879533f, (float16_t)-0.382683432f,
   (float16_t)-0.903989293f, (float16_t)-0.427555093f,
   (float16_t)-0.881921264f, (float16_t)-0.471396737f,
   (float16_t)-0.857728610f, (float16_t)-0.514102744f,
   (float16_t)-0.831469612f, (float16_t)-0.555570233f,
   (float16_t)-0.803207531f, (float16_t)-0.595699304f,
   (float16_t)-0.773010453f, (float16_t)-0.634393284f,
   (float16_t)-0.740951125f, (float16_t)-0.671558955f,
   (float16_t)-0.707106781f, (float16_t)-0.707106781f,
   (float16_t)-0.671558955f, (float16_t)-0.740951125f,
   (float16_t)-0.634393284f, (float16_t)-0.773010453f,
   (float16_t)-0.595699304f, (float16_t)-0.803207531f,
   (float16_t)-0.555570233f, (float16_t)-0.831469612f,
   (float16_t)-0.514102744f, (float16_t)-0.857728610f,
   (float16_t)-0.471396737f, (float16_t)-0.881921264f,
   (float16_t)-0.427555093f, (float16_t)-0.903989293f,
   (float16_t)-0.382683432f, (float16_t)-0.923879533f,
   (float16_t)-0.336889853f, (float16_t)-0.941544065f,
   (float16_t)-0.290284677f, (float16_t)-0.956940336f,
   (float16_t)-0.242980180f, (float16_t)-0.970031253f,
   (float16_t)-0.195090322f, (float16_t)-0.980785280f,
   (float16_t)-0.146730474f, (float16_t)-0.989176510f,
   (float16_t)-0.098017140f, (float16_t)-0.995184727f,
   (float16_t)-0.049067674f, (float16_t)-0.998795456f,
   (float16_t)-0.000000000f, (float16_t)-1.000000000f,
    (float16_t)0.049067674f, (float16_t)-0.998795456f,
    (float16_t)0.098017140f, (float16_t)-0.995184727f,
    (float16_t)0.146730474f, (float16_t)-0.989176510f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.242980180f, (float16_t)-0.970031253f,
    (float16_t)0.290284677f, (float16_t)-0.956940336f,
    (float16_t)0.336889853f, (float16_t)-0.941544065f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.427555093f, (float16_t)-0.903989293f,
    (float16_t)0.471396737f, (float16_t)-0.881921264f,
    (float16_t)0.514102744f, (float16_t)-0.857728610f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.595699304f, (float16_t)-0.803207531f,
    (float16_t)0.634393284f, (float16_t)-0.773010453f,
    (float16_t)0.671558955f, (float16_t)-0.740951125f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.740951125f, (float16_t)-0.671558955f,
    (float16_t)0.773010453f, (float16_t)-0.634393284f,
    (float16_t)0.803207531f, (float16_t)-0.595699304f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.857728610f, (float16_t)-0.514102744f,
    (float16_t)0.881921264f, (float16_t)-0.471396737f,
    (float16_t)0.903989293f, (float16_t)-0.427555093f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.941544065f, (float16_t)-0.336889853f,
    (float16_t)0.956940336f, (float16_t)-0.290284677f,
    (float16_t)0.970031253f, (float16_t)-0.242980180f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.989176510f, (float16_t)-0.146730474f,
    (float16_t)0.995184727f, (float16_t)-0.098017140f,
    (float16_t)0.998795456f, (float16_t)-0.049067674f
};
#endif 

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_256)

/**
* \par
* Example code for Floating-point Twiddle factors Generation:
* \par
* <pre>for(i = 0; i< N/; i++)
* {
* twiddleCoef[2*i]= cos(i * 2*PI/(float)N);
* twiddleCoef[2*i+1]= sin(i * 2*PI/(float)N);
* } </pre>
* \par
* where N = 256 and PI = 3.14159265358979
* \par
* Cos and Sin values are in interleaved fashion
*
*/
const float16_t twiddleCoefF16_256[512] = {
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.999698819f,  (float16_t)0.024541229f,
    (float16_t)0.998795456f,  (float16_t)0.049067674f,
    (float16_t)0.997290457f,  (float16_t)0.073564564f,
    (float16_t)0.995184727f,  (float16_t)0.098017140f,
    (float16_t)0.992479535f,  (float16_t)0.122410675f,
    (float16_t)0.989176510f,  (float16_t)0.146730474f,
    (float16_t)0.985277642f,  (float16_t)0.170961889f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.975702130f,  (float16_t)0.219101240f,
    (float16_t)0.970031253f,  (float16_t)0.242980180f,
    (float16_t)0.963776066f,  (float16_t)0.266712757f,
    (float16_t)0.956940336f,  (float16_t)0.290284677f,
    (float16_t)0.949528181f,  (float16_t)0.313681740f,
    (float16_t)0.941544065f,  (float16_t)0.336889853f,
    (float16_t)0.932992799f,  (float16_t)0.359895037f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.914209756f,  (float16_t)0.405241314f,
    (float16_t)0.903989293f,  (float16_t)0.427555093f,
    (float16_t)0.893224301f,  (float16_t)0.449611330f,
    (float16_t)0.881921264f,  (float16_t)0.471396737f,
    (float16_t)0.870086991f,  (float16_t)0.492898192f,
    (float16_t)0.857728610f,  (float16_t)0.514102744f,
    (float16_t)0.844853565f,  (float16_t)0.534997620f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.817584813f,  (float16_t)0.575808191f,
    (float16_t)0.803207531f,  (float16_t)0.595699304f,
    (float16_t)0.788346428f,  (float16_t)0.615231591f,
    (float16_t)0.773010453f,  (float16_t)0.634393284f,
    (float16_t)0.757208847f,  (float16_t)0.653172843f,
    (float16_t)0.740951125f,  (float16_t)0.671558955f,
    (float16_t)0.724247083f,  (float16_t)0.689540545f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.689540545f,  (float16_t)0.724247083f,
    (float16_t)0.671558955f,  (float16_t)0.740951125f,
    (float16_t)0.653172843f,  (float16_t)0.757208847f,
    (float16_t)0.634393284f,  (float16_t)0.773010453f,
    (float16_t)0.615231591f,  (float16_t)0.788346428f,
    (float16_t)0.595699304f,  (float16_t)0.803207531f,
    (float16_t)0.575808191f,  (float16_t)0.817584813f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.534997620f,  (float16_t)0.844853565f,
    (float16_t)0.514102744f,  (float16_t)0.857728610f,
    (float16_t)0.492898192f,  (float16_t)0.870086991f,
    (float16_t)0.471396737f,  (float16_t)0.881921264f,
    (float16_t)0.449611330f,  (float16_t)0.893224301f,
    (float16_t)0.427555093f,  (float16_t)0.903989293f,
    (float16_t)0.405241314f,  (float16_t)0.914209756f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.359895037f,  (float16_t)0.932992799f,
    (float16_t)0.336889853f,  (float16_t)0.941544065f,
    (float16_t)0.313681740f,  (float16_t)0.949528181f,
    (float16_t)0.290284677f,  (float16_t)0.956940336f,
    (float16_t)0.266712757f,  (float16_t)0.963776066f,
    (float16_t)0.242980180f,  (float16_t)0.970031253f,
    (float16_t)0.219101240f,  (float16_t)0.975702130f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.170961889f,  (float16_t)0.985277642f,
    (float16_t)0.146730474f,  (float16_t)0.989176510f,
    (float16_t)0.122410675f,  (float16_t)0.992479535f,
    (float16_t)0.098017140f,  (float16_t)0.995184727f,
    (float16_t)0.073564564f,  (float16_t)0.997290457f,
    (float16_t)0.049067674f,  (float16_t)0.998795456f,
    (float16_t)0.024541229f,  (float16_t)0.999698819f,
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
   (float16_t)-0.024541229f,  (float16_t)0.999698819f,
   (float16_t)-0.049067674f,  (float16_t)0.998795456f,
   (float16_t)-0.073564564f,  (float16_t)0.997290457f,
   (float16_t)-0.098017140f,  (float16_t)0.995184727f,
   (float16_t)-0.122410675f,  (float16_t)0.992479535f,
   (float16_t)-0.146730474f,  (float16_t)0.989176510f,
   (float16_t)-0.170961889f,  (float16_t)0.985277642f,
   (float16_t)-0.195090322f,  (float16_t)0.980785280f,
   (float16_t)-0.219101240f,  (float16_t)0.975702130f,
   (float16_t)-0.242980180f,  (float16_t)0.970031253f,
   (float16_t)-0.266712757f,  (float16_t)0.963776066f,
   (float16_t)-0.290284677f,  (float16_t)0.956940336f,
   (float16_t)-0.313681740f,  (float16_t)0.949528181f,
   (float16_t)-0.336889853f,  (float16_t)0.941544065f,
   (float16_t)-0.359895037f,  (float16_t)0.932992799f,
   (float16_t)-0.382683432f,  (float16_t)0.923879533f,
   (float16_t)-0.405241314f,  (float16_t)0.914209756f,
   (float16_t)-0.427555093f,  (float16_t)0.903989293f,
   (float16_t)-0.449611330f,  (float16_t)0.893224301f,
   (float16_t)-0.471396737f,  (float16_t)0.881921264f,
   (float16_t)-0.492898192f,  (float16_t)0.870086991f,
   (float16_t)-0.514102744f,  (float16_t)0.857728610f,
   (float16_t)-0.534997620f,  (float16_t)0.844853565f,
   (float16_t)-0.555570233f,  (float16_t)0.831469612f,
   (float16_t)-0.575808191f,  (float16_t)0.817584813f,
   (float16_t)-0.595699304f,  (float16_t)0.803207531f,
   (float16_t)-0.615231591f,  (float16_t)0.788346428f,
   (float16_t)-0.634393284f,  (float16_t)0.773010453f,
   (float16_t)-0.653172843f,  (float16_t)0.757208847f,
   (float16_t)-0.671558955f,  (float16_t)0.740951125f,
   (float16_t)-0.689540545f,  (float16_t)0.724247083f,
   (float16_t)-0.707106781f,  (float16_t)0.707106781f,
   (float16_t)-0.724247083f,  (float16_t)0.689540545f,
   (float16_t)-0.740951125f,  (float16_t)0.671558955f,
   (float16_t)-0.757208847f,  (float16_t)0.653172843f,
   (float16_t)-0.773010453f,  (float16_t)0.634393284f,
   (float16_t)-0.788346428f,  (float16_t)0.615231591f,
   (float16_t)-0.803207531f,  (float16_t)0.595699304f,
   (float16_t)-0.817584813f,  (float16_t)0.575808191f,
   (float16_t)-0.831469612f,  (float16_t)0.555570233f,
   (float16_t)-0.844853565f,  (float16_t)0.534997620f,
   (float16_t)-0.857728610f,  (float16_t)0.514102744f,
   (float16_t)-0.870086991f,  (float16_t)0.492898192f,
   (float16_t)-0.881921264f,  (float16_t)0.471396737f,
   (float16_t)-0.893224301f,  (float16_t)0.449611330f,
   (float16_t)-0.903989293f,  (float16_t)0.427555093f,
   (float16_t)-0.914209756f,  (float16_t)0.405241314f,
   (float16_t)-0.923879533f,  (float16_t)0.382683432f,
   (float16_t)-0.932992799f,  (float16_t)0.359895037f,
   (float16_t)-0.941544065f,  (float16_t)0.336889853f,
   (float16_t)-0.949528181f,  (float16_t)0.313681740f,
   (float16_t)-0.956940336f,  (float16_t)0.290284677f,
   (float16_t)-0.963776066f,  (float16_t)0.266712757f,
   (float16_t)-0.970031253f,  (float16_t)0.242980180f,
   (float16_t)-0.975702130f,  (float16_t)0.219101240f,
   (float16_t)-0.980785280f,  (float16_t)0.195090322f,
   (float16_t)-0.985277642f,  (float16_t)0.170961889f,
   (float16_t)-0.989176510f,  (float16_t)0.146730474f,
   (float16_t)-0.992479535f,  (float16_t)0.122410675f,
   (float16_t)-0.995184727f,  (float16_t)0.098017140f,
   (float16_t)-0.997290457f,  (float16_t)0.073564564f,
   (float16_t)-0.998795456f,  (float16_t)0.049067674f,
   (float16_t)-0.999698819f,  (float16_t)0.024541229f,
   (float16_t)-1.000000000f,  (float16_t)0.000000000f,
   (float16_t)-0.999698819f, (float16_t)-0.024541229f,
   (float16_t)-0.998795456f, (float16_t)-0.049067674f,
   (float16_t)-0.997290457f, (float16_t)-0.073564564f,
   (float16_t)-0.995184727f, (float16_t)-0.098017140f,
   (float16_t)-0.992479535f, (float16_t)-0.122410675f,
   (float16_t)-0.989176510f, (float16_t)-0.146730474f,
   (float16_t)-0.985277642f, (float16_t)-0.170961889f,
   (float16_t)-0.980785280f, (float16_t)-0.195090322f,
   (float16_t)-0.975702130f, (float16_t)-0.219101240f,
   (float16_t)-0.970031253f, (float16_t)-0.242980180f,
   (float16_t)-0.963776066f, (float16_t)-0.266712757f,
   (float16_t)-0.956940336f, (float16_t)-0.290284677f,
   (float16_t)-0.949528181f, (float16_t)-0.313681740f,
   (float16_t)-0.941544065f, (float16_t)-0.336889853f,
   (float16_t)-0.932992799f, (float16_t)-0.359895037f,
   (float16_t)-0.923879533f, (float16_t)-0.382683432f,
   (float16_t)-0.914209756f, (float16_t)-0.405241314f,
   (float16_t)-0.903989293f, (float16_t)-0.427555093f,
   (float16_t)-0.893224301f, (float16_t)-0.449611330f,
   (float16_t)-0.881921264f, (float16_t)-0.471396737f,
   (float16_t)-0.870086991f, (float16_t)-0.492898192f,
   (float16_t)-0.857728610f, (float16_t)-0.514102744f,
   (float16_t)-0.844853565f, (float16_t)-0.534997620f,
   (float16_t)-0.831469612f, (float16_t)-0.555570233f,
   (float16_t)-0.817584813f, (float16_t)-0.575808191f,
   (float16_t)-0.803207531f, (float16_t)-0.595699304f,
   (float16_t)-0.788346428f, (float16_t)-0.615231591f,
   (float16_t)-0.773010453f, (float16_t)-0.634393284f,
   (float16_t)-0.757208847f, (float16_t)-0.653172843f,
   (float16_t)-0.740951125f, (float16_t)-0.671558955f,
   (float16_t)-0.724247083f, (float16_t)-0.689540545f,
   (float16_t)-0.707106781f, (float16_t)-0.707106781f,
   (float16_t)-0.689540545f, (float16_t)-0.724247083f,
   (float16_t)-0.671558955f, (float16_t)-0.740951125f,
   (float16_t)-0.653172843f, (float16_t)-0.757208847f,
   (float16_t)-0.634393284f, (float16_t)-0.773010453f,
   (float16_t)-0.615231591f, (float16_t)-0.788346428f,
   (float16_t)-0.595699304f, (float16_t)-0.803207531f,
   (float16_t)-0.575808191f, (float16_t)-0.817584813f,
   (float16_t)-0.555570233f, (float16_t)-0.831469612f,
   (float16_t)-0.534997620f, (float16_t)-0.844853565f,
   (float16_t)-0.514102744f, (float16_t)-0.857728610f,
   (float16_t)-0.492898192f, (float16_t)-0.870086991f,
   (float16_t)-0.471396737f, (float16_t)-0.881921264f,
   (float16_t)-0.449611330f, (float16_t)-0.893224301f,
   (float16_t)-0.427555093f, (float16_t)-0.903989293f,
   (float16_t)-0.405241314f, (float16_t)-0.914209756f,
   (float16_t)-0.382683432f, (float16_t)-0.923879533f,
   (float16_t)-0.359895037f, (float16_t)-0.932992799f,
   (float16_t)-0.336889853f, (float16_t)-0.941544065f,
   (float16_t)-0.313681740f, (float16_t)-0.949528181f,
   (float16_t)-0.290284677f, (float16_t)-0.956940336f,
   (float16_t)-0.266712757f, (float16_t)-0.963776066f,
   (float16_t)-0.242980180f, (float16_t)-0.970031253f,
   (float16_t)-0.219101240f, (float16_t)-0.975702130f,
   (float16_t)-0.195090322f, (float16_t)-0.980785280f,
   (float16_t)-0.170961889f, (float16_t)-0.985277642f,
   (float16_t)-0.146730474f, (float16_t)-0.989176510f,
   (float16_t)-0.122410675f, (float16_t)-0.992479535f,
   (float16_t)-0.098017140f, (float16_t)-0.995184727f,
   (float16_t)-0.073564564f, (float16_t)-0.997290457f,
   (float16_t)-0.049067674f, (float16_t)-0.998795456f,
   (float16_t)-0.024541229f, (float16_t)-0.999698819f,
   (float16_t)-0.000000000f, (float16_t)-1.000000000f,
    (float16_t)0.024541229f, (float16_t)-0.999698819f,
    (float16_t)0.049067674f, (float16_t)-0.998795456f,
    (float16_t)0.073564564f, (float16_t)-0.997290457f,
    (float16_t)0.098017140f, (float16_t)-0.995184727f,
    (float16_t)0.122410675f, (float16_t)-0.992479535f,
    (float16_t)0.146730474f, (float16_t)-0.989176510f,
    (float16_t)0.170961889f, (float16_t)-0.985277642f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.219101240f, (float16_t)-0.975702130f,
    (float16_t)0.242980180f, (float16_t)-0.970031253f,
    (float16_t)0.266712757f, (float16_t)-0.963776066f,
    (float16_t)0.290284677f, (float16_t)-0.956940336f,
    (float16_t)0.313681740f, (float16_t)-0.949528181f,
    (float16_t)0.336889853f, (float16_t)-0.941544065f,
    (float16_t)0.359895037f, (float16_t)-0.932992799f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.405241314f, (float16_t)-0.914209756f,
    (float16_t)0.427555093f, (float16_t)-0.903989293f,
    (float16_t)0.449611330f, (float16_t)-0.893224301f,
    (float16_t)0.471396737f, (float16_t)-0.881921264f,
    (float16_t)0.492898192f, (float16_t)-0.870086991f,
    (float16_t)0.514102744f, (float16_t)-0.857728610f,
    (float16_t)0.534997620f, (float16_t)-0.844853565f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.575808191f, (float16_t)-0.817584813f,
    (float16_t)0.595699304f, (float16_t)-0.803207531f,
    (float16_t)0.615231591f, (float16_t)-0.788346428f,
    (float16_t)0.634393284f, (float16_t)-0.773010453f,
    (float16_t)0.653172843f, (float16_t)-0.757208847f,
    (float16_t)0.671558955f, (float16_t)-0.740951125f,
    (float16_t)0.689540545f, (float16_t)-0.724247083f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.724247083f, (float16_t)-0.689540545f,
    (float16_t)0.740951125f, (float16_t)-0.671558955f,
    (float16_t)0.757208847f, (float16_t)-0.653172843f,
    (float16_t)0.773010453f, (float16_t)-0.634393284f,
    (float16_t)0.788346428f, (float16_t)-0.615231591f,
    (float16_t)0.803207531f, (float16_t)-0.595699304f,
    (float16_t)0.817584813f, (float16_t)-0.575808191f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.844853565f, (float16_t)-0.534997620f,
    (float16_t)0.857728610f, (float16_t)-0.514102744f,
    (float16_t)0.870086991f, (float16_t)-0.492898192f,
    (float16_t)0.881921264f, (float16_t)-0.471396737f,
    (float16_t)0.893224301f, (float16_t)-0.449611330f,
    (float16_t)0.903989293f, (float16_t)-0.427555093f,
    (float16_t)0.914209756f, (float16_t)-0.405241314f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.932992799f, (float16_t)-0.359895037f,
    (float16_t)0.941544065f, (float16_t)-0.336889853f,
    (float16_t)0.949528181f, (float16_t)-0.313681740f,
    (float16_t)0.956940336f, (float16_t)-0.290284677f,
    (float16_t)0.963776066f, (float16_t)-0.266712757f,
    (float16_t)0.970031253f, (float16_t)-0.242980180f,
    (float16_t)0.975702130f, (float16_t)-0.219101240f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.985277642f, (float16_t)-0.170961889f,
    (float16_t)0.989176510f, (float16_t)-0.146730474f,
    (float16_t)0.992479535f, (float16_t)-0.122410675f,
    (float16_t)0.995184727f, (float16_t)-0.098017140f,
    (float16_t)0.997290457f, (float16_t)-0.073564564f,
    (float16_t)0.998795456f, (float16_t)-0.049067674f,
    (float16_t)0.999698819f, (float16_t)-0.024541229f
};
#endif 

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_512)

/**
* \par
* Example code for Floating-point Twiddle factors Generation:
* \par
* <pre>for(i = 0; i< N/; i++)
* {
* twiddleCoef[2*i]= cos(i * 2*PI/(float)N);
* twiddleCoef[2*i+1]= sin(i * 2*PI/(float)N);
* } </pre>
* \par
* where N = 512 and PI = 3.14159265358979
* \par
* Cos and Sin values are in interleaved fashion
*
*/
const float16_t twiddleCoefF16_512[1024] = {
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.999924702f,  (float16_t)0.012271538f,
    (float16_t)0.999698819f,  (float16_t)0.024541229f,
    (float16_t)0.999322385f,  (float16_t)0.036807223f,
    (float16_t)0.998795456f,  (float16_t)0.049067674f,
    (float16_t)0.998118113f,  (float16_t)0.061320736f,
    (float16_t)0.997290457f,  (float16_t)0.073564564f,
    (float16_t)0.996312612f,  (float16_t)0.085797312f,
    (float16_t)0.995184727f,  (float16_t)0.098017140f,
    (float16_t)0.993906970f,  (float16_t)0.110222207f,
    (float16_t)0.992479535f,  (float16_t)0.122410675f,
    (float16_t)0.990902635f,  (float16_t)0.134580709f,
    (float16_t)0.989176510f,  (float16_t)0.146730474f,
    (float16_t)0.987301418f,  (float16_t)0.158858143f,
    (float16_t)0.985277642f,  (float16_t)0.170961889f,
    (float16_t)0.983105487f,  (float16_t)0.183039888f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.978317371f,  (float16_t)0.207111376f,
    (float16_t)0.975702130f,  (float16_t)0.219101240f,
    (float16_t)0.972939952f,  (float16_t)0.231058108f,
    (float16_t)0.970031253f,  (float16_t)0.242980180f,
    (float16_t)0.966976471f,  (float16_t)0.254865660f,
    (float16_t)0.963776066f,  (float16_t)0.266712757f,
    (float16_t)0.960430519f,  (float16_t)0.278519689f,
    (float16_t)0.956940336f,  (float16_t)0.290284677f,
    (float16_t)0.953306040f,  (float16_t)0.302005949f,
    (float16_t)0.949528181f,  (float16_t)0.313681740f,
    (float16_t)0.945607325f,  (float16_t)0.325310292f,
    (float16_t)0.941544065f,  (float16_t)0.336889853f,
    (float16_t)0.937339012f,  (float16_t)0.348418680f,
    (float16_t)0.932992799f,  (float16_t)0.359895037f,
    (float16_t)0.928506080f,  (float16_t)0.371317194f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.919113852f,  (float16_t)0.393992040f,
    (float16_t)0.914209756f,  (float16_t)0.405241314f,
    (float16_t)0.909167983f,  (float16_t)0.416429560f,
    (float16_t)0.903989293f,  (float16_t)0.427555093f,
    (float16_t)0.898674466f,  (float16_t)0.438616239f,
    (float16_t)0.893224301f,  (float16_t)0.449611330f,
    (float16_t)0.887639620f,  (float16_t)0.460538711f,
    (float16_t)0.881921264f,  (float16_t)0.471396737f,
    (float16_t)0.876070094f,  (float16_t)0.482183772f,
    (float16_t)0.870086991f,  (float16_t)0.492898192f,
    (float16_t)0.863972856f,  (float16_t)0.503538384f,
    (float16_t)0.857728610f,  (float16_t)0.514102744f,
    (float16_t)0.851355193f,  (float16_t)0.524589683f,
    (float16_t)0.844853565f,  (float16_t)0.534997620f,
    (float16_t)0.838224706f,  (float16_t)0.545324988f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.824589303f,  (float16_t)0.565731811f,
    (float16_t)0.817584813f,  (float16_t)0.575808191f,
    (float16_t)0.810457198f,  (float16_t)0.585797857f,
    (float16_t)0.803207531f,  (float16_t)0.595699304f,
    (float16_t)0.795836905f,  (float16_t)0.605511041f,
    (float16_t)0.788346428f,  (float16_t)0.615231591f,
    (float16_t)0.780737229f,  (float16_t)0.624859488f,
    (float16_t)0.773010453f,  (float16_t)0.634393284f,
    (float16_t)0.765167266f,  (float16_t)0.643831543f,
    (float16_t)0.757208847f,  (float16_t)0.653172843f,
    (float16_t)0.749136395f,  (float16_t)0.662415778f,
    (float16_t)0.740951125f,  (float16_t)0.671558955f,
    (float16_t)0.732654272f,  (float16_t)0.680600998f,
    (float16_t)0.724247083f,  (float16_t)0.689540545f,
    (float16_t)0.715730825f,  (float16_t)0.698376249f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.698376249f,  (float16_t)0.715730825f,
    (float16_t)0.689540545f,  (float16_t)0.724247083f,
    (float16_t)0.680600998f,  (float16_t)0.732654272f,
    (float16_t)0.671558955f,  (float16_t)0.740951125f,
    (float16_t)0.662415778f,  (float16_t)0.749136395f,
    (float16_t)0.653172843f,  (float16_t)0.757208847f,
    (float16_t)0.643831543f,  (float16_t)0.765167266f,
    (float16_t)0.634393284f,  (float16_t)0.773010453f,
    (float16_t)0.624859488f,  (float16_t)0.780737229f,
    (float16_t)0.615231591f,  (float16_t)0.788346428f,
    (float16_t)0.605511041f,  (float16_t)0.795836905f,
    (float16_t)0.595699304f,  (float16_t)0.803207531f,
    (float16_t)0.585797857f,  (float16_t)0.810457198f,
    (float16_t)0.575808191f,  (float16_t)0.817584813f,
    (float16_t)0.565731811f,  (float16_t)0.824589303f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.545324988f,  (float16_t)0.838224706f,
    (float16_t)0.534997620f,  (float16_t)0.844853565f,
    (float16_t)0.524589683f,  (float16_t)0.851355193f,
    (float16_t)0.514102744f,  (float16_t)0.857728610f,
    (float16_t)0.503538384f,  (float16_t)0.863972856f,
    (float16_t)0.492898192f,  (float16_t)0.870086991f,
    (float16_t)0.482183772f,  (float16_t)0.876070094f,
    (float16_t)0.471396737f,  (float16_t)0.881921264f,
    (float16_t)0.460538711f,  (float16_t)0.887639620f,
    (float16_t)0.449611330f,  (float16_t)0.893224301f,
    (float16_t)0.438616239f,  (float16_t)0.898674466f,
    (float16_t)0.427555093f,  (float16_t)0.903989293f,
    (float16_t)0.416429560f,  (float16_t)0.909167983f,
    (float16_t)0.405241314f,  (float16_t)0.914209756f,
    (float16_t)0.393992040f,  (float16_t)0.919113852f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.371317194f,  (float16_t)0.928506080f,
    (float16_t)0.359895037f,  (float16_t)0.932992799f,
    (float16_t)0.348418680f,  (float16_t)0.937339012f,
    (float16_t)0.336889853f,  (float16_t)0.941544065f,
    (float16_t)0.325310292f,  (float16_t)0.945607325f,
    (float16_t)0.313681740f,  (float16_t)0.949528181f,
    (float16_t)0.302005949f,  (float16_t)0.953306040f,
    (float16_t)0.290284677f,  (float16_t)0.956940336f,
    (float16_t)0.278519689f,  (float16_t)0.960430519f,
    (float16_t)0.266712757f,  (float16_t)0.963776066f,
    (float16_t)0.254865660f,  (float16_t)0.966976471f,
    (float16_t)0.242980180f,  (float16_t)0.970031253f,
    (float16_t)0.231058108f,  (float16_t)0.972939952f,
    (float16_t)0.219101240f,  (float16_t)0.975702130f,
    (float16_t)0.207111376f,  (float16_t)0.978317371f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.183039888f,  (float16_t)0.983105487f,
    (float16_t)0.170961889f,  (float16_t)0.985277642f,
    (float16_t)0.158858143f,  (float16_t)0.987301418f,
    (float16_t)0.146730474f,  (float16_t)0.989176510f,
    (float16_t)0.134580709f,  (float16_t)0.990902635f,
    (float16_t)0.122410675f,  (float16_t)0.992479535f,
    (float16_t)0.110222207f,  (float16_t)0.993906970f,
    (float16_t)0.098017140f,  (float16_t)0.995184727f,
    (float16_t)0.085797312f,  (float16_t)0.996312612f,
    (float16_t)0.073564564f,  (float16_t)0.997290457f,
    (float16_t)0.061320736f,  (float16_t)0.998118113f,
    (float16_t)0.049067674f,  (float16_t)0.998795456f,
    (float16_t)0.036807223f,  (float16_t)0.999322385f,
    (float16_t)0.024541229f,  (float16_t)0.999698819f,
    (float16_t)0.012271538f,  (float16_t)0.999924702f,
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
   (float16_t)-0.012271538f,  (float16_t)0.999924702f,
   (float16_t)-0.024541229f,  (float16_t)0.999698819f,
   (float16_t)-0.036807223f,  (float16_t)0.999322385f,
   (float16_t)-0.049067674f,  (float16_t)0.998795456f,
   (float16_t)-0.061320736f,  (float16_t)0.998118113f,
   (float16_t)-0.073564564f,  (float16_t)0.997290457f,
   (float16_t)-0.085797312f,  (float16_t)0.996312612f,
   (float16_t)-0.098017140f,  (float16_t)0.995184727f,
   (float16_t)-0.110222207f,  (float16_t)0.993906970f,
   (float16_t)-0.122410675f,  (float16_t)0.992479535f,
   (float16_t)-0.134580709f,  (float16_t)0.990902635f,
   (float16_t)-0.146730474f,  (float16_t)0.989176510f,
   (float16_t)-0.158858143f,  (float16_t)0.987301418f,
   (float16_t)-0.170961889f,  (float16_t)0.985277642f,
   (float16_t)-0.183039888f,  (float16_t)0.983105487f,
   (float16_t)-0.195090322f,  (float16_t)0.980785280f,
   (float16_t)-0.207111376f,  (float16_t)0.978317371f,
   (float16_t)-0.219101240f,  (float16_t)0.975702130f,
   (float16_t)-0.231058108f,  (float16_t)0.972939952f,
   (float16_t)-0.242980180f,  (float16_t)0.970031253f,
   (float16_t)-0.254865660f,  (float16_t)0.966976471f,
   (float16_t)-0.266712757f,  (float16_t)0.963776066f,
   (float16_t)-0.278519689f,  (float16_t)0.960430519f,
   (float16_t)-0.290284677f,  (float16_t)0.956940336f,
   (float16_t)-0.302005949f,  (float16_t)0.953306040f,
   (float16_t)-0.313681740f,  (float16_t)0.949528181f,
   (float16_t)-0.325310292f,  (float16_t)0.945607325f,
   (float16_t)-0.336889853f,  (float16_t)0.941544065f,
   (float16_t)-0.348418680f,  (float16_t)0.937339012f,
   (float16_t)-0.359895037f,  (float16_t)0.932992799f,
   (float16_t)-0.371317194f,  (float16_t)0.928506080f,
   (float16_t)-0.382683432f,  (float16_t)0.923879533f,
   (float16_t)-0.393992040f,  (float16_t)0.919113852f,
   (float16_t)-0.405241314f,  (float16_t)0.914209756f,
   (float16_t)-0.416429560f,  (float16_t)0.909167983f,
   (float16_t)-0.427555093f,  (float16_t)0.903989293f,
   (float16_t)-0.438616239f,  (float16_t)0.898674466f,
   (float16_t)-0.449611330f,  (float16_t)0.893224301f,
   (float16_t)-0.460538711f,  (float16_t)0.887639620f,
   (float16_t)-0.471396737f,  (float16_t)0.881921264f,
   (float16_t)-0.482183772f,  (float16_t)0.876070094f,
   (float16_t)-0.492898192f,  (float16_t)0.870086991f,
   (float16_t)-0.503538384f,  (float16_t)0.863972856f,
   (float16_t)-0.514102744f,  (float16_t)0.857728610f,
   (float16_t)-0.524589683f,  (float16_t)0.851355193f,
   (float16_t)-0.534997620f,  (float16_t)0.844853565f,
   (float16_t)-0.545324988f,  (float16_t)0.838224706f,
   (float16_t)-0.555570233f,  (float16_t)0.831469612f,
   (float16_t)-0.565731811f,  (float16_t)0.824589303f,
   (float16_t)-0.575808191f,  (float16_t)0.817584813f,
   (float16_t)-0.585797857f,  (float16_t)0.810457198f,
   (float16_t)-0.595699304f,  (float16_t)0.803207531f,
   (float16_t)-0.605511041f,  (float16_t)0.795836905f,
   (float16_t)-0.615231591f,  (float16_t)0.788346428f,
   (float16_t)-0.624859488f,  (float16_t)0.780737229f,
   (float16_t)-0.634393284f,  (float16_t)0.773010453f,
   (float16_t)-0.643831543f,  (float16_t)0.765167266f,
   (float16_t)-0.653172843f,  (float16_t)0.757208847f,
   (float16_t)-0.662415778f,  (float16_t)0.749136395f,
   (float16_t)-0.671558955f,  (float16_t)0.740951125f,
   (float16_t)-0.680600998f,  (float16_t)0.732654272f,
   (float16_t)-0.689540545f,  (float16_t)0.724247083f,
   (float16_t)-0.698376249f,  (float16_t)0.715730825f,
   (float16_t)-0.707106781f,  (float16_t)0.707106781f,
   (float16_t)-0.715730825f,  (float16_t)0.698376249f,
   (float16_t)-0.724247083f,  (float16_t)0.689540545f,
   (float16_t)-0.732654272f,  (float16_t)0.680600998f,
   (float16_t)-0.740951125f,  (float16_t)0.671558955f,
   (float16_t)-0.749136395f,  (float16_t)0.662415778f,
   (float16_t)-0.757208847f,  (float16_t)0.653172843f,
   (float16_t)-0.765167266f,  (float16_t)0.643831543f,
   (float16_t)-0.773010453f,  (float16_t)0.634393284f,
   (float16_t)-0.780737229f,  (float16_t)0.624859488f,
   (float16_t)-0.788346428f,  (float16_t)0.615231591f,
   (float16_t)-0.795836905f,  (float16_t)0.605511041f,
   (float16_t)-0.803207531f,  (float16_t)0.595699304f,
   (float16_t)-0.810457198f,  (float16_t)0.585797857f,
   (float16_t)-0.817584813f,  (float16_t)0.575808191f,
   (float16_t)-0.824589303f,  (float16_t)0.565731811f,
   (float16_t)-0.831469612f,  (float16_t)0.555570233f,
   (float16_t)-0.838224706f,  (float16_t)0.545324988f,
   (float16_t)-0.844853565f,  (float16_t)0.534997620f,
   (float16_t)-0.851355193f,  (float16_t)0.524589683f,
   (float16_t)-0.857728610f,  (float16_t)0.514102744f,
   (float16_t)-0.863972856f,  (float16_t)0.503538384f,
   (float16_t)-0.870086991f,  (float16_t)0.492898192f,
   (float16_t)-0.876070094f,  (float16_t)0.482183772f,
   (float16_t)-0.881921264f,  (float16_t)0.471396737f,
   (float16_t)-0.887639620f,  (float16_t)0.460538711f,
   (float16_t)-0.893224301f,  (float16_t)0.449611330f,
   (float16_t)-0.898674466f,  (float16_t)0.438616239f,
   (float16_t)-0.903989293f,  (float16_t)0.427555093f,
   (float16_t)-0.909167983f,  (float16_t)0.416429560f,
   (float16_t)-0.914209756f,  (float16_t)0.405241314f,
   (float16_t)-0.919113852f,  (float16_t)0.393992040f,
   (float16_t)-0.923879533f,  (float16_t)0.382683432f,
   (float16_t)-0.928506080f,  (float16_t)0.371317194f,
   (float16_t)-0.932992799f,  (float16_t)0.359895037f,
   (float16_t)-0.937339012f,  (float16_t)0.348418680f,
   (float16_t)-0.941544065f,  (float16_t)0.336889853f,
   (float16_t)-0.945607325f,  (float16_t)0.325310292f,
   (float16_t)-0.949528181f,  (float16_t)0.313681740f,
   (float16_t)-0.953306040f,  (float16_t)0.302005949f,
   (float16_t)-0.956940336f,  (float16_t)0.290284677f,
   (float16_t)-0.960430519f,  (float16_t)0.278519689f,
   (float16_t)-0.963776066f,  (float16_t)0.266712757f,
   (float16_t)-0.966976471f,  (float16_t)0.254865660f,
   (float16_t)-0.970031253f,  (float16_t)0.242980180f,
   (float16_t)-0.972939952f,  (float16_t)0.231058108f,
   (float16_t)-0.975702130f,  (float16_t)0.219101240f,
   (float16_t)-0.978317371f,  (float16_t)0.207111376f,
   (float16_t)-0.980785280f,  (float16_t)0.195090322f,
   (float16_t)-0.983105487f,  (float16_t)0.183039888f,
   (float16_t)-0.985277642f,  (float16_t)0.170961889f,
   (float16_t)-0.987301418f,  (float16_t)0.158858143f,
   (float16_t)-0.989176510f,  (float16_t)0.146730474f,
   (float16_t)-0.990902635f,  (float16_t)0.134580709f,
   (float16_t)-0.992479535f,  (float16_t)0.122410675f,
   (float16_t)-0.993906970f,  (float16_t)0.110222207f,
   (float16_t)-0.995184727f,  (float16_t)0.098017140f,
   (float16_t)-0.996312612f,  (float16_t)0.085797312f,
   (float16_t)-0.997290457f,  (float16_t)0.073564564f,
   (float16_t)-0.998118113f,  (float16_t)0.061320736f,
   (float16_t)-0.998795456f,  (float16_t)0.049067674f,
   (float16_t)-0.999322385f,  (float16_t)0.036807223f,
   (float16_t)-0.999698819f,  (float16_t)0.024541229f,
   (float16_t)-0.999924702f,  (float16_t)0.012271538f,
   (float16_t)-1.000000000f,  (float16_t)0.000000000f,
   (float16_t)-0.999924702f, (float16_t)-0.012271538f,
   (float16_t)-0.999698819f, (float16_t)-0.024541229f,
   (float16_t)-0.999322385f, (float16_t)-0.036807223f,
   (float16_t)-0.998795456f, (float16_t)-0.049067674f,
   (float16_t)-0.998118113f, (float16_t)-0.061320736f,
   (float16_t)-0.997290457f, (float16_t)-0.073564564f,
   (float16_t)-0.996312612f, (float16_t)-0.085797312f,
   (float16_t)-0.995184727f, (float16_t)-0.098017140f,
   (float16_t)-0.993906970f, (float16_t)-0.110222207f,
   (float16_t)-0.992479535f, (float16_t)-0.122410675f,
   (float16_t)-0.990902635f, (float16_t)-0.134580709f,
   (float16_t)-0.989176510f, (float16_t)-0.146730474f,
   (float16_t)-0.987301418f, (float16_t)-0.158858143f,
   (float16_t)-0.985277642f, (float16_t)-0.170961889f,
   (float16_t)-0.983105487f, (float16_t)-0.183039888f,
   (float16_t)-0.980785280f, (float16_t)-0.195090322f,
   (float16_t)-0.978317371f, (float16_t)-0.207111376f,
   (float16_t)-0.975702130f, (float16_t)-0.219101240f,
   (float16_t)-0.972939952f, (float16_t)-0.231058108f,
   (float16_t)-0.970031253f, (float16_t)-0.242980180f,
   (float16_t)-0.966976471f, (float16_t)-0.254865660f,
   (float16_t)-0.963776066f, (float16_t)-0.266712757f,
   (float16_t)-0.960430519f, (float16_t)-0.278519689f,
   (float16_t)-0.956940336f, (float16_t)-0.290284677f,
   (float16_t)-0.953306040f, (float16_t)-0.302005949f,
   (float16_t)-0.949528181f, (float16_t)-0.313681740f,
   (float16_t)-0.945607325f, (float16_t)-0.325310292f,
   (float16_t)-0.941544065f, (float16_t)-0.336889853f,
   (float16_t)-0.937339012f, (float16_t)-0.348418680f,
   (float16_t)-0.932992799f, (float16_t)-0.359895037f,
   (float16_t)-0.928506080f, (float16_t)-0.371317194f,
   (float16_t)-0.923879533f, (float16_t)-0.382683432f,
   (float16_t)-0.919113852f, (float16_t)-0.393992040f,
   (float16_t)-0.914209756f, (float16_t)-0.405241314f,
   (float16_t)-0.909167983f, (float16_t)-0.416429560f,
   (float16_t)-0.903989293f, (float16_t)-0.427555093f,
   (float16_t)-0.898674466f, (float16_t)-0.438616239f,
   (float16_t)-0.893224301f, (float16_t)-0.449611330f,
   (float16_t)-0.887639620f, (float16_t)-0.460538711f,
   (float16_t)-0.881921264f, (float16_t)-0.471396737f,
   (float16_t)-0.876070094f, (float16_t)-0.482183772f,
   (float16_t)-0.870086991f, (float16_t)-0.492898192f,
   (float16_t)-0.863972856f, (float16_t)-0.503538384f,
   (float16_t)-0.857728610f, (float16_t)-0.514102744f,
   (float16_t)-0.851355193f, (float16_t)-0.524589683f,
   (float16_t)-0.844853565f, (float16_t)-0.534997620f,
   (float16_t)-0.838224706f, (float16_t)-0.545324988f,
   (float16_t)-0.831469612f, (float16_t)-0.555570233f,
   (float16_t)-0.824589303f, (float16_t)-0.565731811f,
   (float16_t)-0.817584813f, (float16_t)-0.575808191f,
   (float16_t)-0.810457198f, (float16_t)-0.585797857f,
   (float16_t)-0.803207531f, (float16_t)-0.595699304f,
   (float16_t)-0.795836905f, (float16_t)-0.605511041f,
   (float16_t)-0.788346428f, (float16_t)-0.615231591f,
   (float16_t)-0.780737229f, (float16_t)-0.624859488f,
   (float16_t)-0.773010453f, (float16_t)-0.634393284f,
   (float16_t)-0.765167266f, (float16_t)-0.643831543f,
   (float16_t)-0.757208847f, (float16_t)-0.653172843f,
   (float16_t)-0.749136395f, (float16_t)-0.662415778f,
   (float16_t)-0.740951125f, (float16_t)-0.671558955f,
   (float16_t)-0.732654272f, (float16_t)-0.680600998f,
   (float16_t)-0.724247083f, (float16_t)-0.689540545f,
   (float16_t)-0.715730825f, (float16_t)-0.698376249f,
   (float16_t)-0.707106781f, (float16_t)-0.707106781f,
   (float16_t)-0.698376249f, (float16_t)-0.715730825f,
   (float16_t)-0.689540545f, (float16_t)-0.724247083f,
   (float16_t)-0.680600998f, (float16_t)-0.732654272f,
   (float16_t)-0.671558955f, (float16_t)-0.740951125f,
   (float16_t)-0.662415778f, (float16_t)-0.749136395f,
   (float16_t)-0.653172843f, (float16_t)-0.757208847f,
   (float16_t)-0.643831543f, (float16_t)-0.765167266f,
   (float16_t)-0.634393284f, (float16_t)-0.773010453f,
   (float16_t)-0.624859488f, (float16_t)-0.780737229f,
   (float16_t)-0.615231591f, (float16_t)-0.788346428f,
   (float16_t)-0.605511041f, (float16_t)-0.795836905f,
   (float16_t)-0.595699304f, (float16_t)-0.803207531f,
   (float16_t)-0.585797857f, (float16_t)-0.810457198f,
   (float16_t)-0.575808191f, (float16_t)-0.817584813f,
   (float16_t)-0.565731811f, (float16_t)-0.824589303f,
   (float16_t)-0.555570233f, (float16_t)-0.831469612f,
   (float16_t)-0.545324988f, (float16_t)-0.838224706f,
   (float16_t)-0.534997620f, (float16_t)-0.844853565f,
   (float16_t)-0.524589683f, (float16_t)-0.851355193f,
   (float16_t)-0.514102744f, (float16_t)-0.857728610f,
   (float16_t)-0.503538384f, (float16_t)-0.863972856f,
   (float16_t)-0.492898192f, (float16_t)-0.870086991f,
   (float16_t)-0.482183772f, (float16_t)-0.876070094f,
   (float16_t)-0.471396737f, (float16_t)-0.881921264f,
   (float16_t)-0.460538711f, (float16_t)-0.887639620f,
   (float16_t)-0.449611330f, (float16_t)-0.893224301f,
   (float16_t)-0.438616239f, (float16_t)-0.898674466f,
   (float16_t)-0.427555093f, (float16_t)-0.903989293f,
   (float16_t)-0.416429560f, (float16_t)-0.909167983f,
   (float16_t)-0.405241314f, (float16_t)-0.914209756f,
   (float16_t)-0.393992040f, (float16_t)-0.919113852f,
   (float16_t)-0.382683432f, (float16_t)-0.923879533f,
   (float16_t)-0.371317194f, (float16_t)-0.928506080f,
   (float16_t)-0.359895037f, (float16_t)-0.932992799f,
   (float16_t)-0.348418680f, (float16_t)-0.937339012f,
   (float16_t)-0.336889853f, (float16_t)-0.941544065f,
   (float16_t)-0.325310292f, (float16_t)-0.945607325f,
   (float16_t)-0.313681740f, (float16_t)-0.949528181f,
   (float16_t)-0.302005949f, (float16_t)-0.953306040f,
   (float16_t)-0.290284677f, (float16_t)-0.956940336f,
   (float16_t)-0.278519689f, (float16_t)-0.960430519f,
   (float16_t)-0.266712757f, (float16_t)-0.963776066f,
   (float16_t)-0.254865660f, (float16_t)-0.966976471f,
   (float16_t)-0.242980180f, (float16_t)-0.970031253f,
   (float16_t)-0.231058108f, (float16_t)-0.972939952f,
   (float16_t)-0.219101240f, (float16_t)-0.975702130f,
   (float16_t)-0.207111376f, (float16_t)-0.978317371f,
   (float16_t)-0.195090322f, (float16_t)-0.980785280f,
   (float16_t)-0.183039888f, (float16_t)-0.983105487f,
   (float16_t)-0.170961889f, (float16_t)-0.985277642f,
   (float16_t)-0.158858143f, (float16_t)-0.987301418f,
   (float16_t)-0.146730474f, (float16_t)-0.989176510f,
   (float16_t)-0.134580709f, (float16_t)-0.990902635f,
   (float16_t)-0.122410675f, (float16_t)-0.992479535f,
   (float16_t)-0.110222207f, (float16_t)-0.993906970f,
   (float16_t)-0.098017140f, (float16_t)-0.995184727f,
   (float16_t)-0.085797312f, (float16_t)-0.996312612f,
   (float16_t)-0.073564564f, (float16_t)-0.997290457f,
   (float16_t)-0.061320736f, (float16_t)-0.998118113f,
   (float16_t)-0.049067674f, (float16_t)-0.998795456f,
   (float16_t)-0.036807223f, (float16_t)-0.999322385f,
   (float16_t)-0.024541229f, (float16_t)-0.999698819f,
   (float16_t)-0.012271538f, (float16_t)-0.999924702f,
   (float16_t)-0.000000000f, (float16_t)-1.000000000f,
    (float16_t)0.012271538f, (float16_t)-0.999924702f,
    (float16_t)0.024541229f, (float16_t)-0.999698819f,
    (float16_t)0.036807223f, (float16_t)-0.999322385f,
    (float16_t)0.049067674f, (float16_t)-0.998795456f,
    (float16_t)0.061320736f, (float16_t)-0.998118113f,
    (float16_t)0.073564564f, (float16_t)-0.997290457f,
    (float16_t)0.085797312f, (float16_t)-0.996312612f,
    (float16_t)0.098017140f, (float16_t)-0.995184727f,
    (float16_t)0.110222207f, (float16_t)-0.993906970f,
    (float16_t)0.122410675f, (float16_t)-0.992479535f,
    (float16_t)0.134580709f, (float16_t)-0.990902635f,
    (float16_t)0.146730474f, (float16_t)-0.989176510f,
    (float16_t)0.158858143f, (float16_t)-0.987301418f,
    (float16_t)0.170961889f, (float16_t)-0.985277642f,
    (float16_t)0.183039888f, (float16_t)-0.983105487f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.207111376f, (float16_t)-0.978317371f,
    (float16_t)0.219101240f, (float16_t)-0.975702130f,
    (float16_t)0.231058108f, (float16_t)-0.972939952f,
    (float16_t)0.242980180f, (float16_t)-0.970031253f,
    (float16_t)0.254865660f, (float16_t)-0.966976471f,
    (float16_t)0.266712757f, (float16_t)-0.963776066f,
    (float16_t)0.278519689f, (float16_t)-0.960430519f,
    (float16_t)0.290284677f, (float16_t)-0.956940336f,
    (float16_t)0.302005949f, (float16_t)-0.953306040f,
    (float16_t)0.313681740f, (float16_t)-0.949528181f,
    (float16_t)0.325310292f, (float16_t)-0.945607325f,
    (float16_t)0.336889853f, (float16_t)-0.941544065f,
    (float16_t)0.348418680f, (float16_t)-0.937339012f,
    (float16_t)0.359895037f, (float16_t)-0.932992799f,
    (float16_t)0.371317194f, (float16_t)-0.928506080f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.393992040f, (float16_t)-0.919113852f,
    (float16_t)0.405241314f, (float16_t)-0.914209756f,
    (float16_t)0.416429560f, (float16_t)-0.909167983f,
    (float16_t)0.427555093f, (float16_t)-0.903989293f,
    (float16_t)0.438616239f, (float16_t)-0.898674466f,
    (float16_t)0.449611330f, (float16_t)-0.893224301f,
    (float16_t)0.460538711f, (float16_t)-0.887639620f,
    (float16_t)0.471396737f, (float16_t)-0.881921264f,
    (float16_t)0.482183772f, (float16_t)-0.876070094f,
    (float16_t)0.492898192f, (float16_t)-0.870086991f,
    (float16_t)0.503538384f, (float16_t)-0.863972856f,
    (float16_t)0.514102744f, (float16_t)-0.857728610f,
    (float16_t)0.524589683f, (float16_t)-0.851355193f,
    (float16_t)0.534997620f, (float16_t)-0.844853565f,
    (float16_t)0.545324988f, (float16_t)-0.838224706f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.565731811f, (float16_t)-0.824589303f,
    (float16_t)0.575808191f, (float16_t)-0.817584813f,
    (float16_t)0.585797857f, (float16_t)-0.810457198f,
    (float16_t)0.595699304f, (float16_t)-0.803207531f,
    (float16_t)0.605511041f, (float16_t)-0.795836905f,
    (float16_t)0.615231591f, (float16_t)-0.788346428f,
    (float16_t)0.624859488f, (float16_t)-0.780737229f,
    (float16_t)0.634393284f, (float16_t)-0.773010453f,
    (float16_t)0.643831543f, (float16_t)-0.765167266f,
    (float16_t)0.653172843f, (float16_t)-0.757208847f,
    (float16_t)0.662415778f, (float16_t)-0.749136395f,
    (float16_t)0.671558955f, (float16_t)-0.740951125f,
    (float16_t)0.680600998f, (float16_t)-0.732654272f,
    (float16_t)0.689540545f, (float16_t)-0.724247083f,
    (float16_t)0.698376249f, (float16_t)-0.715730825f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.715730825f, (float16_t)-0.698376249f,
    (float16_t)0.724247083f, (float16_t)-0.689540545f,
    (float16_t)0.732654272f, (float16_t)-0.680600998f,
    (float16_t)0.740951125f, (float16_t)-0.671558955f,
    (float16_t)0.749136395f, (float16_t)-0.662415778f,
    (float16_t)0.757208847f, (float16_t)-0.653172843f,
    (float16_t)0.765167266f, (float16_t)-0.643831543f,
    (float16_t)0.773010453f, (float16_t)-0.634393284f,
    (float16_t)0.780737229f, (float16_t)-0.624859488f,
    (float16_t)0.788346428f, (float16_t)-0.615231591f,
    (float16_t)0.795836905f, (float16_t)-0.605511041f,
    (float16_t)0.803207531f, (float16_t)-0.595699304f,
    (float16_t)0.810457198f, (float16_t)-0.585797857f,
    (float16_t)0.817584813f, (float16_t)-0.575808191f,
    (float16_t)0.824589303f, (float16_t)-0.565731811f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.838224706f, (float16_t)-0.545324988f,
    (float16_t)0.844853565f, (float16_t)-0.534997620f,
    (float16_t)0.851355193f, (float16_t)-0.524589683f,
    (float16_t)0.857728610f, (float16_t)-0.514102744f,
    (float16_t)0.863972856f, (float16_t)-0.503538384f,
    (float16_t)0.870086991f, (float16_t)-0.492898192f,
    (float16_t)0.876070094f, (float16_t)-0.482183772f,
    (float16_t)0.881921264f, (float16_t)-0.471396737f,
    (float16_t)0.887639620f, (float16_t)-0.460538711f,
    (float16_t)0.893224301f, (float16_t)-0.449611330f,
    (float16_t)0.898674466f, (float16_t)-0.438616239f,
    (float16_t)0.903989293f, (float16_t)-0.427555093f,
    (float16_t)0.909167983f, (float16_t)-0.416429560f,
    (float16_t)0.914209756f, (float16_t)-0.405241314f,
    (float16_t)0.919113852f, (float16_t)-0.393992040f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.928506080f, (float16_t)-0.371317194f,
    (float16_t)0.932992799f, (float16_t)-0.359895037f,
    (float16_t)0.937339012f, (float16_t)-0.348418680f,
    (float16_t)0.941544065f, (float16_t)-0.336889853f,
    (float16_t)0.945607325f, (float16_t)-0.325310292f,
    (float16_t)0.949528181f, (float16_t)-0.313681740f,
    (float16_t)0.953306040f, (float16_t)-0.302005949f,
    (float16_t)0.956940336f, (float16_t)-0.290284677f,
    (float16_t)0.960430519f, (float16_t)-0.278519689f,
    (float16_t)0.963776066f, (float16_t)-0.266712757f,
    (float16_t)0.966976471f, (float16_t)-0.254865660f,
    (float16_t)0.970031253f, (float16_t)-0.242980180f,
    (float16_t)0.972939952f, (float16_t)-0.231058108f,
    (float16_t)0.975702130f, (float16_t)-0.219101240f,
    (float16_t)0.978317371f, (float16_t)-0.207111376f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.983105487f, (float16_t)-0.183039888f,
    (float16_t)0.985277642f, (float16_t)-0.170961889f,
    (float16_t)0.987301418f, (float16_t)-0.158858143f,
    (float16_t)0.989176510f, (float16_t)-0.146730474f,
    (float16_t)0.990902635f, (float16_t)-0.134580709f,
    (float16_t)0.992479535f, (float16_t)-0.122410675f,
    (float16_t)0.993906970f, (float16_t)-0.110222207f,
    (float16_t)0.995184727f, (float16_t)-0.098017140f,
    (float16_t)0.996312612f, (float16_t)-0.085797312f,
    (float16_t)0.997290457f, (float16_t)-0.073564564f,
    (float16_t)0.998118113f, (float16_t)-0.061320736f,
    (float16_t)0.998795456f, (float16_t)-0.049067674f,
    (float16_t)0.999322385f, (float16_t)-0.036807223f,
    (float16_t)0.999698819f, (float16_t)-0.024541229f,
    (float16_t)0.999924702f, (float16_t)-0.012271538f
};

#endif 

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_1024)

/**
* \par
* Example code for Floating-point Twiddle factors Generation:
* \par
* <pre>for(i = 0; i< N/; i++)
* {
* twiddleCoef[2*i]= cos(i * 2*PI/(float)N);
* twiddleCoef[2*i+1]= sin(i * 2*PI/(float)N);
* } </pre>
* \par
* where N = 1024  and PI = 3.14159265358979
* \par
* Cos and Sin values are in interleaved fashion
*
*/
const float16_t twiddleCoefF16_1024[2048] = {
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.999981175f,  (float16_t)0.006135885f,
    (float16_t)0.999924702f,  (float16_t)0.012271538f,
    (float16_t)0.999830582f,  (float16_t)0.018406730f,
    (float16_t)0.999698819f,  (float16_t)0.024541229f,
    (float16_t)0.999529418f,  (float16_t)0.030674803f,
    (float16_t)0.999322385f,  (float16_t)0.036807223f,
    (float16_t)0.999077728f,  (float16_t)0.042938257f,
    (float16_t)0.998795456f,  (float16_t)0.049067674f,
    (float16_t)0.998475581f,  (float16_t)0.055195244f,
    (float16_t)0.998118113f,  (float16_t)0.061320736f,
    (float16_t)0.997723067f,  (float16_t)0.067443920f,
    (float16_t)0.997290457f,  (float16_t)0.073564564f,
    (float16_t)0.996820299f,  (float16_t)0.079682438f,
    (float16_t)0.996312612f,  (float16_t)0.085797312f,
    (float16_t)0.995767414f,  (float16_t)0.091908956f,
    (float16_t)0.995184727f,  (float16_t)0.098017140f,
    (float16_t)0.994564571f,  (float16_t)0.104121634f,
    (float16_t)0.993906970f,  (float16_t)0.110222207f,
    (float16_t)0.993211949f,  (float16_t)0.116318631f,
    (float16_t)0.992479535f,  (float16_t)0.122410675f,
    (float16_t)0.991709754f,  (float16_t)0.128498111f,
    (float16_t)0.990902635f,  (float16_t)0.134580709f,
    (float16_t)0.990058210f,  (float16_t)0.140658239f,
    (float16_t)0.989176510f,  (float16_t)0.146730474f,
    (float16_t)0.988257568f,  (float16_t)0.152797185f,
    (float16_t)0.987301418f,  (float16_t)0.158858143f,
    (float16_t)0.986308097f,  (float16_t)0.164913120f,
    (float16_t)0.985277642f,  (float16_t)0.170961889f,
    (float16_t)0.984210092f,  (float16_t)0.177004220f,
    (float16_t)0.983105487f,  (float16_t)0.183039888f,
    (float16_t)0.981963869f,  (float16_t)0.189068664f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.979569766f,  (float16_t)0.201104635f,
    (float16_t)0.978317371f,  (float16_t)0.207111376f,
    (float16_t)0.977028143f,  (float16_t)0.213110320f,
    (float16_t)0.975702130f,  (float16_t)0.219101240f,
    (float16_t)0.974339383f,  (float16_t)0.225083911f,
    (float16_t)0.972939952f,  (float16_t)0.231058108f,
    (float16_t)0.971503891f,  (float16_t)0.237023606f,
    (float16_t)0.970031253f,  (float16_t)0.242980180f,
    (float16_t)0.968522094f,  (float16_t)0.248927606f,
    (float16_t)0.966976471f,  (float16_t)0.254865660f,
    (float16_t)0.965394442f,  (float16_t)0.260794118f,
    (float16_t)0.963776066f,  (float16_t)0.266712757f,
    (float16_t)0.962121404f,  (float16_t)0.272621355f,
    (float16_t)0.960430519f,  (float16_t)0.278519689f,
    (float16_t)0.958703475f,  (float16_t)0.284407537f,
    (float16_t)0.956940336f,  (float16_t)0.290284677f,
    (float16_t)0.955141168f,  (float16_t)0.296150888f,
    (float16_t)0.953306040f,  (float16_t)0.302005949f,
    (float16_t)0.951435021f,  (float16_t)0.307849640f,
    (float16_t)0.949528181f,  (float16_t)0.313681740f,
    (float16_t)0.947585591f,  (float16_t)0.319502031f,
    (float16_t)0.945607325f,  (float16_t)0.325310292f,
    (float16_t)0.943593458f,  (float16_t)0.331106306f,
    (float16_t)0.941544065f,  (float16_t)0.336889853f,
    (float16_t)0.939459224f,  (float16_t)0.342660717f,
    (float16_t)0.937339012f,  (float16_t)0.348418680f,
    (float16_t)0.935183510f,  (float16_t)0.354163525f,
    (float16_t)0.932992799f,  (float16_t)0.359895037f,
    (float16_t)0.930766961f,  (float16_t)0.365612998f,
    (float16_t)0.928506080f,  (float16_t)0.371317194f,
    (float16_t)0.926210242f,  (float16_t)0.377007410f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.921514039f,  (float16_t)0.388345047f,
    (float16_t)0.919113852f,  (float16_t)0.393992040f,
    (float16_t)0.916679060f,  (float16_t)0.399624200f,
    (float16_t)0.914209756f,  (float16_t)0.405241314f,
    (float16_t)0.911706032f,  (float16_t)0.410843171f,
    (float16_t)0.909167983f,  (float16_t)0.416429560f,
    (float16_t)0.906595705f,  (float16_t)0.422000271f,
    (float16_t)0.903989293f,  (float16_t)0.427555093f,
    (float16_t)0.901348847f,  (float16_t)0.433093819f,
    (float16_t)0.898674466f,  (float16_t)0.438616239f,
    (float16_t)0.895966250f,  (float16_t)0.444122145f,
    (float16_t)0.893224301f,  (float16_t)0.449611330f,
    (float16_t)0.890448723f,  (float16_t)0.455083587f,
    (float16_t)0.887639620f,  (float16_t)0.460538711f,
    (float16_t)0.884797098f,  (float16_t)0.465976496f,
    (float16_t)0.881921264f,  (float16_t)0.471396737f,
    (float16_t)0.879012226f,  (float16_t)0.476799230f,
    (float16_t)0.876070094f,  (float16_t)0.482183772f,
    (float16_t)0.873094978f,  (float16_t)0.487550160f,
    (float16_t)0.870086991f,  (float16_t)0.492898192f,
    (float16_t)0.867046246f,  (float16_t)0.498227667f,
    (float16_t)0.863972856f,  (float16_t)0.503538384f,
    (float16_t)0.860866939f,  (float16_t)0.508830143f,
    (float16_t)0.857728610f,  (float16_t)0.514102744f,
    (float16_t)0.854557988f,  (float16_t)0.519355990f,
    (float16_t)0.851355193f,  (float16_t)0.524589683f,
    (float16_t)0.848120345f,  (float16_t)0.529803625f,
    (float16_t)0.844853565f,  (float16_t)0.534997620f,
    (float16_t)0.841554977f,  (float16_t)0.540171473f,
    (float16_t)0.838224706f,  (float16_t)0.545324988f,
    (float16_t)0.834862875f,  (float16_t)0.550457973f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.828045045f,  (float16_t)0.560661576f,
    (float16_t)0.824589303f,  (float16_t)0.565731811f,
    (float16_t)0.821102515f,  (float16_t)0.570780746f,
    (float16_t)0.817584813f,  (float16_t)0.575808191f,
    (float16_t)0.814036330f,  (float16_t)0.580813958f,
    (float16_t)0.810457198f,  (float16_t)0.585797857f,
    (float16_t)0.806847554f,  (float16_t)0.590759702f,
    (float16_t)0.803207531f,  (float16_t)0.595699304f,
    (float16_t)0.799537269f,  (float16_t)0.600616479f,
    (float16_t)0.795836905f,  (float16_t)0.605511041f,
    (float16_t)0.792106577f,  (float16_t)0.610382806f,
    (float16_t)0.788346428f,  (float16_t)0.615231591f,
    (float16_t)0.784556597f,  (float16_t)0.620057212f,
    (float16_t)0.780737229f,  (float16_t)0.624859488f,
    (float16_t)0.776888466f,  (float16_t)0.629638239f,
    (float16_t)0.773010453f,  (float16_t)0.634393284f,
    (float16_t)0.769103338f,  (float16_t)0.639124445f,
    (float16_t)0.765167266f,  (float16_t)0.643831543f,
    (float16_t)0.761202385f,  (float16_t)0.648514401f,
    (float16_t)0.757208847f,  (float16_t)0.653172843f,
    (float16_t)0.753186799f,  (float16_t)0.657806693f,
    (float16_t)0.749136395f,  (float16_t)0.662415778f,
    (float16_t)0.745057785f,  (float16_t)0.666999922f,
    (float16_t)0.740951125f,  (float16_t)0.671558955f,
    (float16_t)0.736816569f,  (float16_t)0.676092704f,
    (float16_t)0.732654272f,  (float16_t)0.680600998f,
    (float16_t)0.728464390f,  (float16_t)0.685083668f,
    (float16_t)0.724247083f,  (float16_t)0.689540545f,
    (float16_t)0.720002508f,  (float16_t)0.693971461f,
    (float16_t)0.715730825f,  (float16_t)0.698376249f,
    (float16_t)0.711432196f,  (float16_t)0.702754744f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.702754744f,  (float16_t)0.711432196f,
    (float16_t)0.698376249f,  (float16_t)0.715730825f,
    (float16_t)0.693971461f,  (float16_t)0.720002508f,
    (float16_t)0.689540545f,  (float16_t)0.724247083f,
    (float16_t)0.685083668f,  (float16_t)0.728464390f,
    (float16_t)0.680600998f,  (float16_t)0.732654272f,
    (float16_t)0.676092704f,  (float16_t)0.736816569f,
    (float16_t)0.671558955f,  (float16_t)0.740951125f,
    (float16_t)0.666999922f,  (float16_t)0.745057785f,
    (float16_t)0.662415778f,  (float16_t)0.749136395f,
    (float16_t)0.657806693f,  (float16_t)0.753186799f,
    (float16_t)0.653172843f,  (float16_t)0.757208847f,
    (float16_t)0.648514401f,  (float16_t)0.761202385f,
    (float16_t)0.643831543f,  (float16_t)0.765167266f,
    (float16_t)0.639124445f,  (float16_t)0.769103338f,
    (float16_t)0.634393284f,  (float16_t)0.773010453f,
    (float16_t)0.629638239f,  (float16_t)0.776888466f,
    (float16_t)0.624859488f,  (float16_t)0.780737229f,
    (float16_t)0.620057212f,  (float16_t)0.784556597f,
    (float16_t)0.615231591f,  (float16_t)0.788346428f,
    (float16_t)0.610382806f,  (float16_t)0.792106577f,
    (float16_t)0.605511041f,  (float16_t)0.795836905f,
    (float16_t)0.600616479f,  (float16_t)0.799537269f,
    (float16_t)0.595699304f,  (float16_t)0.803207531f,
    (float16_t)0.590759702f,  (float16_t)0.806847554f,
    (float16_t)0.585797857f,  (float16_t)0.810457198f,
    (float16_t)0.580813958f,  (float16_t)0.814036330f,
    (float16_t)0.575808191f,  (float16_t)0.817584813f,
    (float16_t)0.570780746f,  (float16_t)0.821102515f,
    (float16_t)0.565731811f,  (float16_t)0.824589303f,
    (float16_t)0.560661576f,  (float16_t)0.828045045f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.550457973f,  (float16_t)0.834862875f,
    (float16_t)0.545324988f,  (float16_t)0.838224706f,
    (float16_t)0.540171473f,  (float16_t)0.841554977f,
    (float16_t)0.534997620f,  (float16_t)0.844853565f,
    (float16_t)0.529803625f,  (float16_t)0.848120345f,
    (float16_t)0.524589683f,  (float16_t)0.851355193f,
    (float16_t)0.519355990f,  (float16_t)0.854557988f,
    (float16_t)0.514102744f,  (float16_t)0.857728610f,
    (float16_t)0.508830143f,  (float16_t)0.860866939f,
    (float16_t)0.503538384f,  (float16_t)0.863972856f,
    (float16_t)0.498227667f,  (float16_t)0.867046246f,
    (float16_t)0.492898192f,  (float16_t)0.870086991f,
    (float16_t)0.487550160f,  (float16_t)0.873094978f,
    (float16_t)0.482183772f,  (float16_t)0.876070094f,
    (float16_t)0.476799230f,  (float16_t)0.879012226f,
    (float16_t)0.471396737f,  (float16_t)0.881921264f,
    (float16_t)0.465976496f,  (float16_t)0.884797098f,
    (float16_t)0.460538711f,  (float16_t)0.887639620f,
    (float16_t)0.455083587f,  (float16_t)0.890448723f,
    (float16_t)0.449611330f,  (float16_t)0.893224301f,
    (float16_t)0.444122145f,  (float16_t)0.895966250f,
    (float16_t)0.438616239f,  (float16_t)0.898674466f,
    (float16_t)0.433093819f,  (float16_t)0.901348847f,
    (float16_t)0.427555093f,  (float16_t)0.903989293f,
    (float16_t)0.422000271f,  (float16_t)0.906595705f,
    (float16_t)0.416429560f,  (float16_t)0.909167983f,
    (float16_t)0.410843171f,  (float16_t)0.911706032f,
    (float16_t)0.405241314f,  (float16_t)0.914209756f,
    (float16_t)0.399624200f,  (float16_t)0.916679060f,
    (float16_t)0.393992040f,  (float16_t)0.919113852f,
    (float16_t)0.388345047f,  (float16_t)0.921514039f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.377007410f,  (float16_t)0.926210242f,
    (float16_t)0.371317194f,  (float16_t)0.928506080f,
    (float16_t)0.365612998f,  (float16_t)0.930766961f,
    (float16_t)0.359895037f,  (float16_t)0.932992799f,
    (float16_t)0.354163525f,  (float16_t)0.935183510f,
    (float16_t)0.348418680f,  (float16_t)0.937339012f,
    (float16_t)0.342660717f,  (float16_t)0.939459224f,
    (float16_t)0.336889853f,  (float16_t)0.941544065f,
    (float16_t)0.331106306f,  (float16_t)0.943593458f,
    (float16_t)0.325310292f,  (float16_t)0.945607325f,
    (float16_t)0.319502031f,  (float16_t)0.947585591f,
    (float16_t)0.313681740f,  (float16_t)0.949528181f,
    (float16_t)0.307849640f,  (float16_t)0.951435021f,
    (float16_t)0.302005949f,  (float16_t)0.953306040f,
    (float16_t)0.296150888f,  (float16_t)0.955141168f,
    (float16_t)0.290284677f,  (float16_t)0.956940336f,
    (float16_t)0.284407537f,  (float16_t)0.958703475f,
    (float16_t)0.278519689f,  (float16_t)0.960430519f,
    (float16_t)0.272621355f,  (float16_t)0.962121404f,
    (float16_t)0.266712757f,  (float16_t)0.963776066f,
    (float16_t)0.260794118f,  (float16_t)0.965394442f,
    (float16_t)0.254865660f,  (float16_t)0.966976471f,
    (float16_t)0.248927606f,  (float16_t)0.968522094f,
    (float16_t)0.242980180f,  (float16_t)0.970031253f,
    (float16_t)0.237023606f,  (float16_t)0.971503891f,
    (float16_t)0.231058108f,  (float16_t)0.972939952f,
    (float16_t)0.225083911f,  (float16_t)0.974339383f,
    (float16_t)0.219101240f,  (float16_t)0.975702130f,
    (float16_t)0.213110320f,  (float16_t)0.977028143f,
    (float16_t)0.207111376f,  (float16_t)0.978317371f,
    (float16_t)0.201104635f,  (float16_t)0.979569766f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.189068664f,  (float16_t)0.981963869f,
    (float16_t)0.183039888f,  (float16_t)0.983105487f,
    (float16_t)0.177004220f,  (float16_t)0.984210092f,
    (float16_t)0.170961889f,  (float16_t)0.985277642f,
    (float16_t)0.164913120f,  (float16_t)0.986308097f,
    (float16_t)0.158858143f,  (float16_t)0.987301418f,
    (float16_t)0.152797185f,  (float16_t)0.988257568f,
    (float16_t)0.146730474f,  (float16_t)0.989176510f,
    (float16_t)0.140658239f,  (float16_t)0.990058210f,
    (float16_t)0.134580709f,  (float16_t)0.990902635f,
    (float16_t)0.128498111f,  (float16_t)0.991709754f,
    (float16_t)0.122410675f,  (float16_t)0.992479535f,
    (float16_t)0.116318631f,  (float16_t)0.993211949f,
    (float16_t)0.110222207f,  (float16_t)0.993906970f,
    (float16_t)0.104121634f,  (float16_t)0.994564571f,
    (float16_t)0.098017140f,  (float16_t)0.995184727f,
    (float16_t)0.091908956f,  (float16_t)0.995767414f,
    (float16_t)0.085797312f,  (float16_t)0.996312612f,
    (float16_t)0.079682438f,  (float16_t)0.996820299f,
    (float16_t)0.073564564f,  (float16_t)0.997290457f,
    (float16_t)0.067443920f,  (float16_t)0.997723067f,
    (float16_t)0.061320736f,  (float16_t)0.998118113f,
    (float16_t)0.055195244f,  (float16_t)0.998475581f,
    (float16_t)0.049067674f,  (float16_t)0.998795456f,
    (float16_t)0.042938257f,  (float16_t)0.999077728f,
    (float16_t)0.036807223f,  (float16_t)0.999322385f,
    (float16_t)0.030674803f,  (float16_t)0.999529418f,
    (float16_t)0.024541229f,  (float16_t)0.999698819f,
    (float16_t)0.018406730f,  (float16_t)0.999830582f,
    (float16_t)0.012271538f,  (float16_t)0.999924702f,
    (float16_t)0.006135885f,  (float16_t)0.999981175f,
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
   (float16_t)-0.006135885f,  (float16_t)0.999981175f,
   (float16_t)-0.012271538f,  (float16_t)0.999924702f,
   (float16_t)-0.018406730f,  (float16_t)0.999830582f,
   (float16_t)-0.024541229f,  (float16_t)0.999698819f,
   (float16_t)-0.030674803f,  (float16_t)0.999529418f,
   (float16_t)-0.036807223f,  (float16_t)0.999322385f,
   (float16_t)-0.042938257f,  (float16_t)0.999077728f,
   (float16_t)-0.049067674f,  (float16_t)0.998795456f,
   (float16_t)-0.055195244f,  (float16_t)0.998475581f,
   (float16_t)-0.061320736f,  (float16_t)0.998118113f,
   (float16_t)-0.067443920f,  (float16_t)0.997723067f,
   (float16_t)-0.073564564f,  (float16_t)0.997290457f,
   (float16_t)-0.079682438f,  (float16_t)0.996820299f,
   (float16_t)-0.085797312f,  (float16_t)0.996312612f,
   (float16_t)-0.091908956f,  (float16_t)0.995767414f,
   (float16_t)-0.098017140f,  (float16_t)0.995184727f,
   (float16_t)-0.104121634f,  (float16_t)0.994564571f,
   (float16_t)-0.110222207f,  (float16_t)0.993906970f,
   (float16_t)-0.116318631f,  (float16_t)0.993211949f,
   (float16_t)-0.122410675f,  (float16_t)0.992479535f,
   (float16_t)-0.128498111f,  (float16_t)0.991709754f,
   (float16_t)-0.134580709f,  (float16_t)0.990902635f,
   (float16_t)-0.140658239f,  (float16_t)0.990058210f,
   (float16_t)-0.146730474f,  (float16_t)0.989176510f,
   (float16_t)-0.152797185f,  (float16_t)0.988257568f,
   (float16_t)-0.158858143f,  (float16_t)0.987301418f,
   (float16_t)-0.164913120f,  (float16_t)0.986308097f,
   (float16_t)-0.170961889f,  (float16_t)0.985277642f,
   (float16_t)-0.177004220f,  (float16_t)0.984210092f,
   (float16_t)-0.183039888f,  (float16_t)0.983105487f,
   (float16_t)-0.189068664f,  (float16_t)0.981963869f,
   (float16_t)-0.195090322f,  (float16_t)0.980785280f,
   (float16_t)-0.201104635f,  (float16_t)0.979569766f,
   (float16_t)-0.207111376f,  (float16_t)0.978317371f,
   (float16_t)-0.213110320f,  (float16_t)0.977028143f,
   (float16_t)-0.219101240f,  (float16_t)0.975702130f,
   (float16_t)-0.225083911f,  (float16_t)0.974339383f,
   (float16_t)-0.231058108f,  (float16_t)0.972939952f,
   (float16_t)-0.237023606f,  (float16_t)0.971503891f,
   (float16_t)-0.242980180f,  (float16_t)0.970031253f,
   (float16_t)-0.248927606f,  (float16_t)0.968522094f,
   (float16_t)-0.254865660f,  (float16_t)0.966976471f,
   (float16_t)-0.260794118f,  (float16_t)0.965394442f,
   (float16_t)-0.266712757f,  (float16_t)0.963776066f,
   (float16_t)-0.272621355f,  (float16_t)0.962121404f,
   (float16_t)-0.278519689f,  (float16_t)0.960430519f,
   (float16_t)-0.284407537f,  (float16_t)0.958703475f,
   (float16_t)-0.290284677f,  (float16_t)0.956940336f,
   (float16_t)-0.296150888f,  (float16_t)0.955141168f,
   (float16_t)-0.302005949f,  (float16_t)0.953306040f,
   (float16_t)-0.307849640f,  (float16_t)0.951435021f,
   (float16_t)-0.313681740f,  (float16_t)0.949528181f,
   (float16_t)-0.319502031f,  (float16_t)0.947585591f,
   (float16_t)-0.325310292f,  (float16_t)0.945607325f,
   (float16_t)-0.331106306f,  (float16_t)0.943593458f,
   (float16_t)-0.336889853f,  (float16_t)0.941544065f,
   (float16_t)-0.342660717f,  (float16_t)0.939459224f,
   (float16_t)-0.348418680f,  (float16_t)0.937339012f,
   (float16_t)-0.354163525f,  (float16_t)0.935183510f,
   (float16_t)-0.359895037f,  (float16_t)0.932992799f,
   (float16_t)-0.365612998f,  (float16_t)0.930766961f,
   (float16_t)-0.371317194f,  (float16_t)0.928506080f,
   (float16_t)-0.377007410f,  (float16_t)0.926210242f,
   (float16_t)-0.382683432f,  (float16_t)0.923879533f,
   (float16_t)-0.388345047f,  (float16_t)0.921514039f,
   (float16_t)-0.393992040f,  (float16_t)0.919113852f,
   (float16_t)-0.399624200f,  (float16_t)0.916679060f,
   (float16_t)-0.405241314f,  (float16_t)0.914209756f,
   (float16_t)-0.410843171f,  (float16_t)0.911706032f,
   (float16_t)-0.416429560f,  (float16_t)0.909167983f,
   (float16_t)-0.422000271f,  (float16_t)0.906595705f,
   (float16_t)-0.427555093f,  (float16_t)0.903989293f,
   (float16_t)-0.433093819f,  (float16_t)0.901348847f,
   (float16_t)-0.438616239f,  (float16_t)0.898674466f,
   (float16_t)-0.444122145f,  (float16_t)0.895966250f,
   (float16_t)-0.449611330f,  (float16_t)0.893224301f,
   (float16_t)-0.455083587f,  (float16_t)0.890448723f,
   (float16_t)-0.460538711f,  (float16_t)0.887639620f,
   (float16_t)-0.465976496f,  (float16_t)0.884797098f,
   (float16_t)-0.471396737f,  (float16_t)0.881921264f,
   (float16_t)-0.476799230f,  (float16_t)0.879012226f,
   (float16_t)-0.482183772f,  (float16_t)0.876070094f,
   (float16_t)-0.487550160f,  (float16_t)0.873094978f,
   (float16_t)-0.492898192f,  (float16_t)0.870086991f,
   (float16_t)-0.498227667f,  (float16_t)0.867046246f,
   (float16_t)-0.503538384f,  (float16_t)0.863972856f,
   (float16_t)-0.508830143f,  (float16_t)0.860866939f,
   (float16_t)-0.514102744f,  (float16_t)0.857728610f,
   (float16_t)-0.519355990f,  (float16_t)0.854557988f,
   (float16_t)-0.524589683f,  (float16_t)0.851355193f,
   (float16_t)-0.529803625f,  (float16_t)0.848120345f,
   (float16_t)-0.534997620f,  (float16_t)0.844853565f,
   (float16_t)-0.540171473f,  (float16_t)0.841554977f,
   (float16_t)-0.545324988f,  (float16_t)0.838224706f,
   (float16_t)-0.550457973f,  (float16_t)0.834862875f,
   (float16_t)-0.555570233f,  (float16_t)0.831469612f,
   (float16_t)-0.560661576f,  (float16_t)0.828045045f,
   (float16_t)-0.565731811f,  (float16_t)0.824589303f,
   (float16_t)-0.570780746f,  (float16_t)0.821102515f,
   (float16_t)-0.575808191f,  (float16_t)0.817584813f,
   (float16_t)-0.580813958f,  (float16_t)0.814036330f,
   (float16_t)-0.585797857f,  (float16_t)0.810457198f,
   (float16_t)-0.590759702f,  (float16_t)0.806847554f,
   (float16_t)-0.595699304f,  (float16_t)0.803207531f,
   (float16_t)-0.600616479f,  (float16_t)0.799537269f,
   (float16_t)-0.605511041f,  (float16_t)0.795836905f,
   (float16_t)-0.610382806f,  (float16_t)0.792106577f,
   (float16_t)-0.615231591f,  (float16_t)0.788346428f,
   (float16_t)-0.620057212f,  (float16_t)0.784556597f,
   (float16_t)-0.624859488f,  (float16_t)0.780737229f,
   (float16_t)-0.629638239f,  (float16_t)0.776888466f,
   (float16_t)-0.634393284f,  (float16_t)0.773010453f,
   (float16_t)-0.639124445f,  (float16_t)0.769103338f,
   (float16_t)-0.643831543f,  (float16_t)0.765167266f,
   (float16_t)-0.648514401f,  (float16_t)0.761202385f,
   (float16_t)-0.653172843f,  (float16_t)0.757208847f,
   (float16_t)-0.657806693f,  (float16_t)0.753186799f,
   (float16_t)-0.662415778f,  (float16_t)0.749136395f,
   (float16_t)-0.666999922f,  (float16_t)0.745057785f,
   (float16_t)-0.671558955f,  (float16_t)0.740951125f,
   (float16_t)-0.676092704f,  (float16_t)0.736816569f,
   (float16_t)-0.680600998f,  (float16_t)0.732654272f,
   (float16_t)-0.685083668f,  (float16_t)0.728464390f,
   (float16_t)-0.689540545f,  (float16_t)0.724247083f,
   (float16_t)-0.693971461f,  (float16_t)0.720002508f,
   (float16_t)-0.698376249f,  (float16_t)0.715730825f,
   (float16_t)-0.702754744f,  (float16_t)0.711432196f,
   (float16_t)-0.707106781f,  (float16_t)0.707106781f,
   (float16_t)-0.711432196f,  (float16_t)0.702754744f,
   (float16_t)-0.715730825f,  (float16_t)0.698376249f,
   (float16_t)-0.720002508f,  (float16_t)0.693971461f,
   (float16_t)-0.724247083f,  (float16_t)0.689540545f,
   (float16_t)-0.728464390f,  (float16_t)0.685083668f,
   (float16_t)-0.732654272f,  (float16_t)0.680600998f,
   (float16_t)-0.736816569f,  (float16_t)0.676092704f,
   (float16_t)-0.740951125f,  (float16_t)0.671558955f,
   (float16_t)-0.745057785f,  (float16_t)0.666999922f,
   (float16_t)-0.749136395f,  (float16_t)0.662415778f,
   (float16_t)-0.753186799f,  (float16_t)0.657806693f,
   (float16_t)-0.757208847f,  (float16_t)0.653172843f,
   (float16_t)-0.761202385f,  (float16_t)0.648514401f,
   (float16_t)-0.765167266f,  (float16_t)0.643831543f,
   (float16_t)-0.769103338f,  (float16_t)0.639124445f,
   (float16_t)-0.773010453f,  (float16_t)0.634393284f,
   (float16_t)-0.776888466f,  (float16_t)0.629638239f,
   (float16_t)-0.780737229f,  (float16_t)0.624859488f,
   (float16_t)-0.784556597f,  (float16_t)0.620057212f,
   (float16_t)-0.788346428f,  (float16_t)0.615231591f,
   (float16_t)-0.792106577f,  (float16_t)0.610382806f,
   (float16_t)-0.795836905f,  (float16_t)0.605511041f,
   (float16_t)-0.799537269f,  (float16_t)0.600616479f,
   (float16_t)-0.803207531f,  (float16_t)0.595699304f,
   (float16_t)-0.806847554f,  (float16_t)0.590759702f,
   (float16_t)-0.810457198f,  (float16_t)0.585797857f,
   (float16_t)-0.814036330f,  (float16_t)0.580813958f,
   (float16_t)-0.817584813f,  (float16_t)0.575808191f,
   (float16_t)-0.821102515f,  (float16_t)0.570780746f,
   (float16_t)-0.824589303f,  (float16_t)0.565731811f,
   (float16_t)-0.828045045f,  (float16_t)0.560661576f,
   (float16_t)-0.831469612f,  (float16_t)0.555570233f,
   (float16_t)-0.834862875f,  (float16_t)0.550457973f,
   (float16_t)-0.838224706f,  (float16_t)0.545324988f,
   (float16_t)-0.841554977f,  (float16_t)0.540171473f,
   (float16_t)-0.844853565f,  (float16_t)0.534997620f,
   (float16_t)-0.848120345f,  (float16_t)0.529803625f,
   (float16_t)-0.851355193f,  (float16_t)0.524589683f,
   (float16_t)-0.854557988f,  (float16_t)0.519355990f,
   (float16_t)-0.857728610f,  (float16_t)0.514102744f,
   (float16_t)-0.860866939f,  (float16_t)0.508830143f,
   (float16_t)-0.863972856f,  (float16_t)0.503538384f,
   (float16_t)-0.867046246f,  (float16_t)0.498227667f,
   (float16_t)-0.870086991f,  (float16_t)0.492898192f,
   (float16_t)-0.873094978f,  (float16_t)0.487550160f,
   (float16_t)-0.876070094f,  (float16_t)0.482183772f,
   (float16_t)-0.879012226f,  (float16_t)0.476799230f,
   (float16_t)-0.881921264f,  (float16_t)0.471396737f,
   (float16_t)-0.884797098f,  (float16_t)0.465976496f,
   (float16_t)-0.887639620f,  (float16_t)0.460538711f,
   (float16_t)-0.890448723f,  (float16_t)0.455083587f,
   (float16_t)-0.893224301f,  (float16_t)0.449611330f,
   (float16_t)-0.895966250f,  (float16_t)0.444122145f,
   (float16_t)-0.898674466f,  (float16_t)0.438616239f,
   (float16_t)-0.901348847f,  (float16_t)0.433093819f,
   (float16_t)-0.903989293f,  (float16_t)0.427555093f,
   (float16_t)-0.906595705f,  (float16_t)0.422000271f,
   (float16_t)-0.909167983f,  (float16_t)0.416429560f,
   (float16_t)-0.911706032f,  (float16_t)0.410843171f,
   (float16_t)-0.914209756f,  (float16_t)0.405241314f,
   (float16_t)-0.916679060f,  (float16_t)0.399624200f,
   (float16_t)-0.919113852f,  (float16_t)0.393992040f,
   (float16_t)-0.921514039f,  (float16_t)0.388345047f,
   (float16_t)-0.923879533f,  (float16_t)0.382683432f,
   (float16_t)-0.926210242f,  (float16_t)0.377007410f,
   (float16_t)-0.928506080f,  (float16_t)0.371317194f,
   (float16_t)-0.930766961f,  (float16_t)0.365612998f,
   (float16_t)-0.932992799f,  (float16_t)0.359895037f,
   (float16_t)-0.935183510f,  (float16_t)0.354163525f,
   (float16_t)-0.937339012f,  (float16_t)0.348418680f,
   (float16_t)-0.939459224f,  (float16_t)0.342660717f,
   (float16_t)-0.941544065f,  (float16_t)0.336889853f,
   (float16_t)-0.943593458f,  (float16_t)0.331106306f,
   (float16_t)-0.945607325f,  (float16_t)0.325310292f,
   (float16_t)-0.947585591f,  (float16_t)0.319502031f,
   (float16_t)-0.949528181f,  (float16_t)0.313681740f,
   (float16_t)-0.951435021f,  (float16_t)0.307849640f,
   (float16_t)-0.953306040f,  (float16_t)0.302005949f,
   (float16_t)-0.955141168f,  (float16_t)0.296150888f,
   (float16_t)-0.956940336f,  (float16_t)0.290284677f,
   (float16_t)-0.958703475f,  (float16_t)0.284407537f,
   (float16_t)-0.960430519f,  (float16_t)0.278519689f,
   (float16_t)-0.962121404f,  (float16_t)0.272621355f,
   (float16_t)-0.963776066f,  (float16_t)0.266712757f,
   (float16_t)-0.965394442f,  (float16_t)0.260794118f,
   (float16_t)-0.966976471f,  (float16_t)0.254865660f,
   (float16_t)-0.968522094f,  (float16_t)0.248927606f,
   (float16_t)-0.970031253f,  (float16_t)0.242980180f,
   (float16_t)-0.971503891f,  (float16_t)0.237023606f,
   (float16_t)-0.972939952f,  (float16_t)0.231058108f,
   (float16_t)-0.974339383f,  (float16_t)0.225083911f,
   (float16_t)-0.975702130f,  (float16_t)0.219101240f,
   (float16_t)-0.977028143f,  (float16_t)0.213110320f,
   (float16_t)-0.978317371f,  (float16_t)0.207111376f,
   (float16_t)-0.979569766f,  (float16_t)0.201104635f,
   (float16_t)-0.980785280f,  (float16_t)0.195090322f,
   (float16_t)-0.981963869f,  (float16_t)0.189068664f,
   (float16_t)-0.983105487f,  (float16_t)0.183039888f,
   (float16_t)-0.984210092f,  (float16_t)0.177004220f,
   (float16_t)-0.985277642f,  (float16_t)0.170961889f,
   (float16_t)-0.986308097f,  (float16_t)0.164913120f,
   (float16_t)-0.987301418f,  (float16_t)0.158858143f,
   (float16_t)-0.988257568f,  (float16_t)0.152797185f,
   (float16_t)-0.989176510f,  (float16_t)0.146730474f,
   (float16_t)-0.990058210f,  (float16_t)0.140658239f,
   (float16_t)-0.990902635f,  (float16_t)0.134580709f,
   (float16_t)-0.991709754f,  (float16_t)0.128498111f,
   (float16_t)-0.992479535f,  (float16_t)0.122410675f,
   (float16_t)-0.993211949f,  (float16_t)0.116318631f,
   (float16_t)-0.993906970f,  (float16_t)0.110222207f,
   (float16_t)-0.994564571f,  (float16_t)0.104121634f,
   (float16_t)-0.995184727f,  (float16_t)0.098017140f,
   (float16_t)-0.995767414f,  (float16_t)0.091908956f,
   (float16_t)-0.996312612f,  (float16_t)0.085797312f,
   (float16_t)-0.996820299f,  (float16_t)0.079682438f,
   (float16_t)-0.997290457f,  (float16_t)0.073564564f,
   (float16_t)-0.997723067f,  (float16_t)0.067443920f,
   (float16_t)-0.998118113f,  (float16_t)0.061320736f,
   (float16_t)-0.998475581f,  (float16_t)0.055195244f,
   (float16_t)-0.998795456f,  (float16_t)0.049067674f,
   (float16_t)-0.999077728f,  (float16_t)0.042938257f,
   (float16_t)-0.999322385f,  (float16_t)0.036807223f,
   (float16_t)-0.999529418f,  (float16_t)0.030674803f,
   (float16_t)-0.999698819f,  (float16_t)0.024541229f,
   (float16_t)-0.999830582f,  (float16_t)0.018406730f,
   (float16_t)-0.999924702f,  (float16_t)0.012271538f,
   (float16_t)-0.999981175f,  (float16_t)0.006135885f,
   (float16_t)-1.000000000f,  (float16_t)0.000000000f,
   (float16_t)-0.999981175f, (float16_t)-0.006135885f,
   (float16_t)-0.999924702f, (float16_t)-0.012271538f,
   (float16_t)-0.999830582f, (float16_t)-0.018406730f,
   (float16_t)-0.999698819f, (float16_t)-0.024541229f,
   (float16_t)-0.999529418f, (float16_t)-0.030674803f,
   (float16_t)-0.999322385f, (float16_t)-0.036807223f,
   (float16_t)-0.999077728f, (float16_t)-0.042938257f,
   (float16_t)-0.998795456f, (float16_t)-0.049067674f,
   (float16_t)-0.998475581f, (float16_t)-0.055195244f,
   (float16_t)-0.998118113f, (float16_t)-0.061320736f,
   (float16_t)-0.997723067f, (float16_t)-0.067443920f,
   (float16_t)-0.997290457f, (float16_t)-0.073564564f,
   (float16_t)-0.996820299f, (float16_t)-0.079682438f,
   (float16_t)-0.996312612f, (float16_t)-0.085797312f,
   (float16_t)-0.995767414f, (float16_t)-0.091908956f,
   (float16_t)-0.995184727f, (float16_t)-0.098017140f,
   (float16_t)-0.994564571f, (float16_t)-0.104121634f,
   (float16_t)-0.993906970f, (float16_t)-0.110222207f,
   (float16_t)-0.993211949f, (float16_t)-0.116318631f,
   (float16_t)-0.992479535f, (float16_t)-0.122410675f,
   (float16_t)-0.991709754f, (float16_t)-0.128498111f,
   (float16_t)-0.990902635f, (float16_t)-0.134580709f,
   (float16_t)-0.990058210f, (float16_t)-0.140658239f,
   (float16_t)-0.989176510f, (float16_t)-0.146730474f,
   (float16_t)-0.988257568f, (float16_t)-0.152797185f,
   (float16_t)-0.987301418f, (float16_t)-0.158858143f,
   (float16_t)-0.986308097f, (float16_t)-0.164913120f,
   (float16_t)-0.985277642f, (float16_t)-0.170961889f,
   (float16_t)-0.984210092f, (float16_t)-0.177004220f,
   (float16_t)-0.983105487f, (float16_t)-0.183039888f,
   (float16_t)-0.981963869f, (float16_t)-0.189068664f,
   (float16_t)-0.980785280f, (float16_t)-0.195090322f,
   (float16_t)-0.979569766f, (float16_t)-0.201104635f,
   (float16_t)-0.978317371f, (float16_t)-0.207111376f,
   (float16_t)-0.977028143f, (float16_t)-0.213110320f,
   (float16_t)-0.975702130f, (float16_t)-0.219101240f,
   (float16_t)-0.974339383f, (float16_t)-0.225083911f,
   (float16_t)-0.972939952f, (float16_t)-0.231058108f,
   (float16_t)-0.971503891f, (float16_t)-0.237023606f,
   (float16_t)-0.970031253f, (float16_t)-0.242980180f,
   (float16_t)-0.968522094f, (float16_t)-0.248927606f,
   (float16_t)-0.966976471f, (float16_t)-0.254865660f,
   (float16_t)-0.965394442f, (float16_t)-0.260794118f,
   (float16_t)-0.963776066f, (float16_t)-0.266712757f,
   (float16_t)-0.962121404f, (float16_t)-0.272621355f,
   (float16_t)-0.960430519f, (float16_t)-0.278519689f,
   (float16_t)-0.958703475f, (float16_t)-0.284407537f,
   (float16_t)-0.956940336f, (float16_t)-0.290284677f,
   (float16_t)-0.955141168f, (float16_t)-0.296150888f,
   (float16_t)-0.953306040f, (float16_t)-0.302005949f,
   (float16_t)-0.951435021f, (float16_t)-0.307849640f,
   (float16_t)-0.949528181f, (float16_t)-0.313681740f,
   (float16_t)-0.947585591f, (float16_t)-0.319502031f,
   (float16_t)-0.945607325f, (float16_t)-0.325310292f,
   (float16_t)-0.943593458f, (float16_t)-0.331106306f,
   (float16_t)-0.941544065f, (float16_t)-0.336889853f,
   (float16_t)-0.939459224f, (float16_t)-0.342660717f,
   (float16_t)-0.937339012f, (float16_t)-0.348418680f,
   (float16_t)-0.935183510f, (float16_t)-0.354163525f,
   (float16_t)-0.932992799f, (float16_t)-0.359895037f,
   (float16_t)-0.930766961f, (float16_t)-0.365612998f,
   (float16_t)-0.928506080f, (float16_t)-0.371317194f,
   (float16_t)-0.926210242f, (float16_t)-0.377007410f,
   (float16_t)-0.923879533f, (float16_t)-0.382683432f,
   (float16_t)-0.921514039f, (float16_t)-0.388345047f,
   (float16_t)-0.919113852f, (float16_t)-0.393992040f,
   (float16_t)-0.916679060f, (float16_t)-0.399624200f,
   (float16_t)-0.914209756f, (float16_t)-0.405241314f,
   (float16_t)-0.911706032f, (float16_t)-0.410843171f,
   (float16_t)-0.909167983f, (float16_t)-0.416429560f,
   (float16_t)-0.906595705f, (float16_t)-0.422000271f,
   (float16_t)-0.903989293f, (float16_t)-0.427555093f,
   (float16_t)-0.901348847f, (float16_t)-0.433093819f,
   (float16_t)-0.898674466f, (float16_t)-0.438616239f,
   (float16_t)-0.895966250f, (float16_t)-0.444122145f,
   (float16_t)-0.893224301f, (float16_t)-0.449611330f,
   (float16_t)-0.890448723f, (float16_t)-0.455083587f,
   (float16_t)-0.887639620f, (float16_t)-0.460538711f,
   (float16_t)-0.884797098f, (float16_t)-0.465976496f,
   (float16_t)-0.881921264f, (float16_t)-0.471396737f,
   (float16_t)-0.879012226f, (float16_t)-0.476799230f,
   (float16_t)-0.876070094f, (float16_t)-0.482183772f,
   (float16_t)-0.873094978f, (float16_t)-0.487550160f,
   (float16_t)-0.870086991f, (float16_t)-0.492898192f,
   (float16_t)-0.867046246f, (float16_t)-0.498227667f,
   (float16_t)-0.863972856f, (float16_t)-0.503538384f,
   (float16_t)-0.860866939f, (float16_t)-0.508830143f,
   (float16_t)-0.857728610f, (float16_t)-0.514102744f,
   (float16_t)-0.854557988f, (float16_t)-0.519355990f,
   (float16_t)-0.851355193f, (float16_t)-0.524589683f,
   (float16_t)-0.848120345f, (float16_t)-0.529803625f,
   (float16_t)-0.844853565f, (float16_t)-0.534997620f,
   (float16_t)-0.841554977f, (float16_t)-0.540171473f,
   (float16_t)-0.838224706f, (float16_t)-0.545324988f,
   (float16_t)-0.834862875f, (float16_t)-0.550457973f,
   (float16_t)-0.831469612f, (float16_t)-0.555570233f,
   (float16_t)-0.828045045f, (float16_t)-0.560661576f,
   (float16_t)-0.824589303f, (float16_t)-0.565731811f,
   (float16_t)-0.821102515f, (float16_t)-0.570780746f,
   (float16_t)-0.817584813f, (float16_t)-0.575808191f,
   (float16_t)-0.814036330f, (float16_t)-0.580813958f,
   (float16_t)-0.810457198f, (float16_t)-0.585797857f,
   (float16_t)-0.806847554f, (float16_t)-0.590759702f,
   (float16_t)-0.803207531f, (float16_t)-0.595699304f,
   (float16_t)-0.799537269f, (float16_t)-0.600616479f,
   (float16_t)-0.795836905f, (float16_t)-0.605511041f,
   (float16_t)-0.792106577f, (float16_t)-0.610382806f,
   (float16_t)-0.788346428f, (float16_t)-0.615231591f,
   (float16_t)-0.784556597f, (float16_t)-0.620057212f,
   (float16_t)-0.780737229f, (float16_t)-0.624859488f,
   (float16_t)-0.776888466f, (float16_t)-0.629638239f,
   (float16_t)-0.773010453f, (float16_t)-0.634393284f,
   (float16_t)-0.769103338f, (float16_t)-0.639124445f,
   (float16_t)-0.765167266f, (float16_t)-0.643831543f,
   (float16_t)-0.761202385f, (float16_t)-0.648514401f,
   (float16_t)-0.757208847f, (float16_t)-0.653172843f,
   (float16_t)-0.753186799f, (float16_t)-0.657806693f,
   (float16_t)-0.749136395f, (float16_t)-0.662415778f,
   (float16_t)-0.745057785f, (float16_t)-0.666999922f,
   (float16_t)-0.740951125f, (float16_t)-0.671558955f,
   (float16_t)-0.736816569f, (float16_t)-0.676092704f,
   (float16_t)-0.732654272f, (float16_t)-0.680600998f,
   (float16_t)-0.728464390f, (float16_t)-0.685083668f,
   (float16_t)-0.724247083f, (float16_t)-0.689540545f,
   (float16_t)-0.720002508f, (float16_t)-0.693971461f,
   (float16_t)-0.715730825f, (float16_t)-0.698376249f,
   (float16_t)-0.711432196f, (float16_t)-0.702754744f,
   (float16_t)-0.707106781f, (float16_t)-0.707106781f,
   (float16_t)-0.702754744f, (float16_t)-0.711432196f,
   (float16_t)-0.698376249f, (float16_t)-0.715730825f,
   (float16_t)-0.693971461f, (float16_t)-0.720002508f,
   (float16_t)-0.689540545f, (float16_t)-0.724247083f,
   (float16_t)-0.685083668f, (float16_t)-0.728464390f,
   (float16_t)-0.680600998f, (float16_t)-0.732654272f,
   (float16_t)-0.676092704f, (float16_t)-0.736816569f,
   (float16_t)-0.671558955f, (float16_t)-0.740951125f,
   (float16_t)-0.666999922f, (float16_t)-0.745057785f,
   (float16_t)-0.662415778f, (float16_t)-0.749136395f,
   (float16_t)-0.657806693f, (float16_t)-0.753186799f,
   (float16_t)-0.653172843f, (float16_t)-0.757208847f,
   (float16_t)-0.648514401f, (float16_t)-0.761202385f,
   (float16_t)-0.643831543f, (float16_t)-0.765167266f,
   (float16_t)-0.639124445f, (float16_t)-0.769103338f,
   (float16_t)-0.634393284f, (float16_t)-0.773010453f,
   (float16_t)-0.629638239f, (float16_t)-0.776888466f,
   (float16_t)-0.624859488f, (float16_t)-0.780737229f,
   (float16_t)-0.620057212f, (float16_t)-0.784556597f,
   (float16_t)-0.615231591f, (float16_t)-0.788346428f,
   (float16_t)-0.610382806f, (float16_t)-0.792106577f,
   (float16_t)-0.605511041f, (float16_t)-0.795836905f,
   (float16_t)-0.600616479f, (float16_t)-0.799537269f,
   (float16_t)-0.595699304f, (float16_t)-0.803207531f,
   (float16_t)-0.590759702f, (float16_t)-0.806847554f,
   (float16_t)-0.585797857f, (float16_t)-0.810457198f,
   (float16_t)-0.580813958f, (float16_t)-0.814036330f,
   (float16_t)-0.575808191f, (float16_t)-0.817584813f,
   (float16_t)-0.570780746f, (float16_t)-0.821102515f,
   (float16_t)-0.565731811f, (float16_t)-0.824589303f,
   (float16_t)-0.560661576f, (float16_t)-0.828045045f,
   (float16_t)-0.555570233f, (float16_t)-0.831469612f,
   (float16_t)-0.550457973f, (float16_t)-0.834862875f,
   (float16_t)-0.545324988f, (float16_t)-0.838224706f,
   (float16_t)-0.540171473f, (float16_t)-0.841554977f,
   (float16_t)-0.534997620f, (float16_t)-0.844853565f,
   (float16_t)-0.529803625f, (float16_t)-0.848120345f,
   (float16_t)-0.524589683f, (float16_t)-0.851355193f,
   (float16_t)-0.519355990f, (float16_t)-0.854557988f,
   (float16_t)-0.514102744f, (float16_t)-0.857728610f,
   (float16_t)-0.508830143f, (float16_t)-0.860866939f,
   (float16_t)-0.503538384f, (float16_t)-0.863972856f,
   (float16_t)-0.498227667f, (float16_t)-0.867046246f,
   (float16_t)-0.492898192f, (float16_t)-0.870086991f,
   (float16_t)-0.487550160f, (float16_t)-0.873094978f,
   (float16_t)-0.482183772f, (float16_t)-0.876070094f,
   (float16_t)-0.476799230f, (float16_t)-0.879012226f,
   (float16_t)-0.471396737f, (float16_t)-0.881921264f,
   (float16_t)-0.465976496f, (float16_t)-0.884797098f,
   (float16_t)-0.460538711f, (float16_t)-0.887639620f,
   (float16_t)-0.455083587f, (float16_t)-0.890448723f,
   (float16_t)-0.449611330f, (float16_t)-0.893224301f,
   (float16_t)-0.444122145f, (float16_t)-0.895966250f,
   (float16_t)-0.438616239f, (float16_t)-0.898674466f,
   (float16_t)-0.433093819f, (float16_t)-0.901348847f,
   (float16_t)-0.427555093f, (float16_t)-0.903989293f,
   (float16_t)-0.422000271f, (float16_t)-0.906595705f,
   (float16_t)-0.416429560f, (float16_t)-0.909167983f,
   (float16_t)-0.410843171f, (float16_t)-0.911706032f,
   (float16_t)-0.405241314f, (float16_t)-0.914209756f,
   (float16_t)-0.399624200f, (float16_t)-0.916679060f,
   (float16_t)-0.393992040f, (float16_t)-0.919113852f,
   (float16_t)-0.388345047f, (float16_t)-0.921514039f,
   (float16_t)-0.382683432f, (float16_t)-0.923879533f,
   (float16_t)-0.377007410f, (float16_t)-0.926210242f,
   (float16_t)-0.371317194f, (float16_t)-0.928506080f,
   (float16_t)-0.365612998f, (float16_t)-0.930766961f,
   (float16_t)-0.359895037f, (float16_t)-0.932992799f,
   (float16_t)-0.354163525f, (float16_t)-0.935183510f,
   (float16_t)-0.348418680f, (float16_t)-0.937339012f,
   (float16_t)-0.342660717f, (float16_t)-0.939459224f,
   (float16_t)-0.336889853f, (float16_t)-0.941544065f,
   (float16_t)-0.331106306f, (float16_t)-0.943593458f,
   (float16_t)-0.325310292f, (float16_t)-0.945607325f,
   (float16_t)-0.319502031f, (float16_t)-0.947585591f,
   (float16_t)-0.313681740f, (float16_t)-0.949528181f,
   (float16_t)-0.307849640f, (float16_t)-0.951435021f,
   (float16_t)-0.302005949f, (float16_t)-0.953306040f,
   (float16_t)-0.296150888f, (float16_t)-0.955141168f,
   (float16_t)-0.290284677f, (float16_t)-0.956940336f,
   (float16_t)-0.284407537f, (float16_t)-0.958703475f,
   (float16_t)-0.278519689f, (float16_t)-0.960430519f,
   (float16_t)-0.272621355f, (float16_t)-0.962121404f,
   (float16_t)-0.266712757f, (float16_t)-0.963776066f,
   (float16_t)-0.260794118f, (float16_t)-0.965394442f,
   (float16_t)-0.254865660f, (float16_t)-0.966976471f,
   (float16_t)-0.248927606f, (float16_t)-0.968522094f,
   (float16_t)-0.242980180f, (float16_t)-0.970031253f,
   (float16_t)-0.237023606f, (float16_t)-0.971503891f,
   (float16_t)-0.231058108f, (float16_t)-0.972939952f,
   (float16_t)-0.225083911f, (float16_t)-0.974339383f,
   (float16_t)-0.219101240f, (float16_t)-0.975702130f,
   (float16_t)-0.213110320f, (float16_t)-0.977028143f,
   (float16_t)-0.207111376f, (float16_t)-0.978317371f,
   (float16_t)-0.201104635f, (float16_t)-0.979569766f,
   (float16_t)-0.195090322f, (float16_t)-0.980785280f,
   (float16_t)-0.189068664f, (float16_t)-0.981963869f,
   (float16_t)-0.183039888f, (float16_t)-0.983105487f,
   (float16_t)-0.177004220f, (float16_t)-0.984210092f,
   (float16_t)-0.170961889f, (float16_t)-0.985277642f,
   (float16_t)-0.164913120f, (float16_t)-0.986308097f,
   (float16_t)-0.158858143f, (float16_t)-0.987301418f,
   (float16_t)-0.152797185f, (float16_t)-0.988257568f,
   (float16_t)-0.146730474f, (float16_t)-0.989176510f,
   (float16_t)-0.140658239f, (float16_t)-0.990058210f,
   (float16_t)-0.134580709f, (float16_t)-0.990902635f,
   (float16_t)-0.128498111f, (float16_t)-0.991709754f,
   (float16_t)-0.122410675f, (float16_t)-0.992479535f,
   (float16_t)-0.116318631f, (float16_t)-0.993211949f,
   (float16_t)-0.110222207f, (float16_t)-0.993906970f,
   (float16_t)-0.104121634f, (float16_t)-0.994564571f,
   (float16_t)-0.098017140f, (float16_t)-0.995184727f,
   (float16_t)-0.091908956f, (float16_t)-0.995767414f,
   (float16_t)-0.085797312f, (float16_t)-0.996312612f,
   (float16_t)-0.079682438f, (float16_t)-0.996820299f,
   (float16_t)-0.073564564f, (float16_t)-0.997290457f,
   (float16_t)-0.067443920f, (float16_t)-0.997723067f,
   (float16_t)-0.061320736f, (float16_t)-0.998118113f,
   (float16_t)-0.055195244f, (float16_t)-0.998475581f,
   (float16_t)-0.049067674f, (float16_t)-0.998795456f,
   (float16_t)-0.042938257f, (float16_t)-0.999077728f,
   (float16_t)-0.036807223f, (float16_t)-0.999322385f,
   (float16_t)-0.030674803f, (float16_t)-0.999529418f,
   (float16_t)-0.024541229f, (float16_t)-0.999698819f,
   (float16_t)-0.018406730f, (float16_t)-0.999830582f,
   (float16_t)-0.012271538f, (float16_t)-0.999924702f,
   (float16_t)-0.006135885f, (float16_t)-0.999981175f,
   (float16_t)-0.000000000f, (float16_t)-1.000000000f,
    (float16_t)0.006135885f, (float16_t)-0.999981175f,
    (float16_t)0.012271538f, (float16_t)-0.999924702f,
    (float16_t)0.018406730f, (float16_t)-0.999830582f,
    (float16_t)0.024541229f, (float16_t)-0.999698819f,
    (float16_t)0.030674803f, (float16_t)-0.999529418f,
    (float16_t)0.036807223f, (float16_t)-0.999322385f,
    (float16_t)0.042938257f, (float16_t)-0.999077728f,
    (float16_t)0.049067674f, (float16_t)-0.998795456f,
    (float16_t)0.055195244f, (float16_t)-0.998475581f,
    (float16_t)0.061320736f, (float16_t)-0.998118113f,
    (float16_t)0.067443920f, (float16_t)-0.997723067f,
    (float16_t)0.073564564f, (float16_t)-0.997290457f,
    (float16_t)0.079682438f, (float16_t)-0.996820299f,
    (float16_t)0.085797312f, (float16_t)-0.996312612f,
    (float16_t)0.091908956f, (float16_t)-0.995767414f,
    (float16_t)0.098017140f, (float16_t)-0.995184727f,
    (float16_t)0.104121634f, (float16_t)-0.994564571f,
    (float16_t)0.110222207f, (float16_t)-0.993906970f,
    (float16_t)0.116318631f, (float16_t)-0.993211949f,
    (float16_t)0.122410675f, (float16_t)-0.992479535f,
    (float16_t)0.128498111f, (float16_t)-0.991709754f,
    (float16_t)0.134580709f, (float16_t)-0.990902635f,
    (float16_t)0.140658239f, (float16_t)-0.990058210f,
    (float16_t)0.146730474f, (float16_t)-0.989176510f,
    (float16_t)0.152797185f, (float16_t)-0.988257568f,
    (float16_t)0.158858143f, (float16_t)-0.987301418f,
    (float16_t)0.164913120f, (float16_t)-0.986308097f,
    (float16_t)0.170961889f, (float16_t)-0.985277642f,
    (float16_t)0.177004220f, (float16_t)-0.984210092f,
    (float16_t)0.183039888f, (float16_t)-0.983105487f,
    (float16_t)0.189068664f, (float16_t)-0.981963869f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.201104635f, (float16_t)-0.979569766f,
    (float16_t)0.207111376f, (float16_t)-0.978317371f,
    (float16_t)0.213110320f, (float16_t)-0.977028143f,
    (float16_t)0.219101240f, (float16_t)-0.975702130f,
    (float16_t)0.225083911f, (float16_t)-0.974339383f,
    (float16_t)0.231058108f, (float16_t)-0.972939952f,
    (float16_t)0.237023606f, (float16_t)-0.971503891f,
    (float16_t)0.242980180f, (float16_t)-0.970031253f,
    (float16_t)0.248927606f, (float16_t)-0.968522094f,
    (float16_t)0.254865660f, (float16_t)-0.966976471f,
    (float16_t)0.260794118f, (float16_t)-0.965394442f,
    (float16_t)0.266712757f, (float16_t)-0.963776066f,
    (float16_t)0.272621355f, (float16_t)-0.962121404f,
    (float16_t)0.278519689f, (float16_t)-0.960430519f,
    (float16_t)0.284407537f, (float16_t)-0.958703475f,
    (float16_t)0.290284677f, (float16_t)-0.956940336f,
    (float16_t)0.296150888f, (float16_t)-0.955141168f,
    (float16_t)0.302005949f, (float16_t)-0.953306040f,
    (float16_t)0.307849640f, (float16_t)-0.951435021f,
    (float16_t)0.313681740f, (float16_t)-0.949528181f,
    (float16_t)0.319502031f, (float16_t)-0.947585591f,
    (float16_t)0.325310292f, (float16_t)-0.945607325f,
    (float16_t)0.331106306f, (float16_t)-0.943593458f,
    (float16_t)0.336889853f, (float16_t)-0.941544065f,
    (float16_t)0.342660717f, (float16_t)-0.939459224f,
    (float16_t)0.348418680f, (float16_t)-0.937339012f,
    (float16_t)0.354163525f, (float16_t)-0.935183510f,
    (float16_t)0.359895037f, (float16_t)-0.932992799f,
    (float16_t)0.365612998f, (float16_t)-0.930766961f,
    (float16_t)0.371317194f, (float16_t)-0.928506080f,
    (float16_t)0.377007410f, (float16_t)-0.926210242f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.388345047f, (float16_t)-0.921514039f,
    (float16_t)0.393992040f, (float16_t)-0.919113852f,
    (float16_t)0.399624200f, (float16_t)-0.916679060f,
    (float16_t)0.405241314f, (float16_t)-0.914209756f,
    (float16_t)0.410843171f, (float16_t)-0.911706032f,
    (float16_t)0.416429560f, (float16_t)-0.909167983f,
    (float16_t)0.422000271f, (float16_t)-0.906595705f,
    (float16_t)0.427555093f, (float16_t)-0.903989293f,
    (float16_t)0.433093819f, (float16_t)-0.901348847f,
    (float16_t)0.438616239f, (float16_t)-0.898674466f,
    (float16_t)0.444122145f, (float16_t)-0.895966250f,
    (float16_t)0.449611330f, (float16_t)-0.893224301f,
    (float16_t)0.455083587f, (float16_t)-0.890448723f,
    (float16_t)0.460538711f, (float16_t)-0.887639620f,
    (float16_t)0.465976496f, (float16_t)-0.884797098f,
    (float16_t)0.471396737f, (float16_t)-0.881921264f,
    (float16_t)0.476799230f, (float16_t)-0.879012226f,
    (float16_t)0.482183772f, (float16_t)-0.876070094f,
    (float16_t)0.487550160f, (float16_t)-0.873094978f,
    (float16_t)0.492898192f, (float16_t)-0.870086991f,
    (float16_t)0.498227667f, (float16_t)-0.867046246f,
    (float16_t)0.503538384f, (float16_t)-0.863972856f,
    (float16_t)0.508830143f, (float16_t)-0.860866939f,
    (float16_t)0.514102744f, (float16_t)-0.857728610f,
    (float16_t)0.519355990f, (float16_t)-0.854557988f,
    (float16_t)0.524589683f, (float16_t)-0.851355193f,
    (float16_t)0.529803625f, (float16_t)-0.848120345f,
    (float16_t)0.534997620f, (float16_t)-0.844853565f,
    (float16_t)0.540171473f, (float16_t)-0.841554977f,
    (float16_t)0.545324988f, (float16_t)-0.838224706f,
    (float16_t)0.550457973f, (float16_t)-0.834862875f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.560661576f, (float16_t)-0.828045045f,
    (float16_t)0.565731811f, (float16_t)-0.824589303f,
    (float16_t)0.570780746f, (float16_t)-0.821102515f,
    (float16_t)0.575808191f, (float16_t)-0.817584813f,
    (float16_t)0.580813958f, (float16_t)-0.814036330f,
    (float16_t)0.585797857f, (float16_t)-0.810457198f,
    (float16_t)0.590759702f, (float16_t)-0.806847554f,
    (float16_t)0.595699304f, (float16_t)-0.803207531f,
    (float16_t)0.600616479f, (float16_t)-0.799537269f,
    (float16_t)0.605511041f, (float16_t)-0.795836905f,
    (float16_t)0.610382806f, (float16_t)-0.792106577f,
    (float16_t)0.615231591f, (float16_t)-0.788346428f,
    (float16_t)0.620057212f, (float16_t)-0.784556597f,
    (float16_t)0.624859488f, (float16_t)-0.780737229f,
    (float16_t)0.629638239f, (float16_t)-0.776888466f,
    (float16_t)0.634393284f, (float16_t)-0.773010453f,
    (float16_t)0.639124445f, (float16_t)-0.769103338f,
    (float16_t)0.643831543f, (float16_t)-0.765167266f,
    (float16_t)0.648514401f, (float16_t)-0.761202385f,
    (float16_t)0.653172843f, (float16_t)-0.757208847f,
    (float16_t)0.657806693f, (float16_t)-0.753186799f,
    (float16_t)0.662415778f, (float16_t)-0.749136395f,
    (float16_t)0.666999922f, (float16_t)-0.745057785f,
    (float16_t)0.671558955f, (float16_t)-0.740951125f,
    (float16_t)0.676092704f, (float16_t)-0.736816569f,
    (float16_t)0.680600998f, (float16_t)-0.732654272f,
    (float16_t)0.685083668f, (float16_t)-0.728464390f,
    (float16_t)0.689540545f, (float16_t)-0.724247083f,
    (float16_t)0.693971461f, (float16_t)-0.720002508f,
    (float16_t)0.698376249f, (float16_t)-0.715730825f,
    (float16_t)0.702754744f, (float16_t)-0.711432196f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.711432196f, (float16_t)-0.702754744f,
    (float16_t)0.715730825f, (float16_t)-0.698376249f,
    (float16_t)0.720002508f, (float16_t)-0.693971461f,
    (float16_t)0.724247083f, (float16_t)-0.689540545f,
    (float16_t)0.728464390f, (float16_t)-0.685083668f,
    (float16_t)0.732654272f, (float16_t)-0.680600998f,
    (float16_t)0.736816569f, (float16_t)-0.676092704f,
    (float16_t)0.740951125f, (float16_t)-0.671558955f,
    (float16_t)0.745057785f, (float16_t)-0.666999922f,
    (float16_t)0.749136395f, (float16_t)-0.662415778f,
    (float16_t)0.753186799f, (float16_t)-0.657806693f,
    (float16_t)0.757208847f, (float16_t)-0.653172843f,
    (float16_t)0.761202385f, (float16_t)-0.648514401f,
    (float16_t)0.765167266f, (float16_t)-0.643831543f,
    (float16_t)0.769103338f, (float16_t)-0.639124445f,
    (float16_t)0.773010453f, (float16_t)-0.634393284f,
    (float16_t)0.776888466f, (float16_t)-0.629638239f,
    (float16_t)0.780737229f, (float16_t)-0.624859488f,
    (float16_t)0.784556597f, (float16_t)-0.620057212f,
    (float16_t)0.788346428f, (float16_t)-0.615231591f,
    (float16_t)0.792106577f, (float16_t)-0.610382806f,
    (float16_t)0.795836905f, (float16_t)-0.605511041f,
    (float16_t)0.799537269f, (float16_t)-0.600616479f,
    (float16_t)0.803207531f, (float16_t)-0.595699304f,
    (float16_t)0.806847554f, (float16_t)-0.590759702f,
    (float16_t)0.810457198f, (float16_t)-0.585797857f,
    (float16_t)0.814036330f, (float16_t)-0.580813958f,
    (float16_t)0.817584813f, (float16_t)-0.575808191f,
    (float16_t)0.821102515f, (float16_t)-0.570780746f,
    (float16_t)0.824589303f, (float16_t)-0.565731811f,
    (float16_t)0.828045045f, (float16_t)-0.560661576f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.834862875f, (float16_t)-0.550457973f,
    (float16_t)0.838224706f, (float16_t)-0.545324988f,
    (float16_t)0.841554977f, (float16_t)-0.540171473f,
    (float16_t)0.844853565f, (float16_t)-0.534997620f,
    (float16_t)0.848120345f, (float16_t)-0.529803625f,
    (float16_t)0.851355193f, (float16_t)-0.524589683f,
    (float16_t)0.854557988f, (float16_t)-0.519355990f,
    (float16_t)0.857728610f, (float16_t)-0.514102744f,
    (float16_t)0.860866939f, (float16_t)-0.508830143f,
    (float16_t)0.863972856f, (float16_t)-0.503538384f,
    (float16_t)0.867046246f, (float16_t)-0.498227667f,
    (float16_t)0.870086991f, (float16_t)-0.492898192f,
    (float16_t)0.873094978f, (float16_t)-0.487550160f,
    (float16_t)0.876070094f, (float16_t)-0.482183772f,
    (float16_t)0.879012226f, (float16_t)-0.476799230f,
    (float16_t)0.881921264f, (float16_t)-0.471396737f,
    (float16_t)0.884797098f, (float16_t)-0.465976496f,
    (float16_t)0.887639620f, (float16_t)-0.460538711f,
    (float16_t)0.890448723f, (float16_t)-0.455083587f,
    (float16_t)0.893224301f, (float16_t)-0.449611330f,
    (float16_t)0.895966250f, (float16_t)-0.444122145f,
    (float16_t)0.898674466f, (float16_t)-0.438616239f,
    (float16_t)0.901348847f, (float16_t)-0.433093819f,
    (float16_t)0.903989293f, (float16_t)-0.427555093f,
    (float16_t)0.906595705f, (float16_t)-0.422000271f,
    (float16_t)0.909167983f, (float16_t)-0.416429560f,
    (float16_t)0.911706032f, (float16_t)-0.410843171f,
    (float16_t)0.914209756f, (float16_t)-0.405241314f,
    (float16_t)0.916679060f, (float16_t)-0.399624200f,
    (float16_t)0.919113852f, (float16_t)-0.393992040f,
    (float16_t)0.921514039f, (float16_t)-0.388345047f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.926210242f, (float16_t)-0.377007410f,
    (float16_t)0.928506080f, (float16_t)-0.371317194f,
    (float16_t)0.930766961f, (float16_t)-0.365612998f,
    (float16_t)0.932992799f, (float16_t)-0.359895037f,
    (float16_t)0.935183510f, (float16_t)-0.354163525f,
    (float16_t)0.937339012f, (float16_t)-0.348418680f,
    (float16_t)0.939459224f, (float16_t)-0.342660717f,
    (float16_t)0.941544065f, (float16_t)-0.336889853f,
    (float16_t)0.943593458f, (float16_t)-0.331106306f,
    (float16_t)0.945607325f, (float16_t)-0.325310292f,
    (float16_t)0.947585591f, (float16_t)-0.319502031f,
    (float16_t)0.949528181f, (float16_t)-0.313681740f,
    (float16_t)0.951435021f, (float16_t)-0.307849640f,
    (float16_t)0.953306040f, (float16_t)-0.302005949f,
    (float16_t)0.955141168f, (float16_t)-0.296150888f,
    (float16_t)0.956940336f, (float16_t)-0.290284677f,
    (float16_t)0.958703475f, (float16_t)-0.284407537f,
    (float16_t)0.960430519f, (float16_t)-0.278519689f,
    (float16_t)0.962121404f, (float16_t)-0.272621355f,
    (float16_t)0.963776066f, (float16_t)-0.266712757f,
    (float16_t)0.965394442f, (float16_t)-0.260794118f,
    (float16_t)0.966976471f, (float16_t)-0.254865660f,
    (float16_t)0.968522094f, (float16_t)-0.248927606f,
    (float16_t)0.970031253f, (float16_t)-0.242980180f,
    (float16_t)0.971503891f, (float16_t)-0.237023606f,
    (float16_t)0.972939952f, (float16_t)-0.231058108f,
    (float16_t)0.974339383f, (float16_t)-0.225083911f,
    (float16_t)0.975702130f, (float16_t)-0.219101240f,
    (float16_t)0.977028143f, (float16_t)-0.213110320f,
    (float16_t)0.978317371f, (float16_t)-0.207111376f,
    (float16_t)0.979569766f, (float16_t)-0.201104635f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.981963869f, (float16_t)-0.189068664f,
    (float16_t)0.983105487f, (float16_t)-0.183039888f,
    (float16_t)0.984210092f, (float16_t)-0.177004220f,
    (float16_t)0.985277642f, (float16_t)-0.170961889f,
    (float16_t)0.986308097f, (float16_t)-0.164913120f,
    (float16_t)0.987301418f, (float16_t)-0.158858143f,
    (float16_t)0.988257568f, (float16_t)-0.152797185f,
    (float16_t)0.989176510f, (float16_t)-0.146730474f,
    (float16_t)0.990058210f, (float16_t)-0.140658239f,
    (float16_t)0.990902635f, (float16_t)-0.134580709f,
    (float16_t)0.991709754f, (float16_t)-0.128498111f,
    (float16_t)0.992479535f, (float16_t)-0.122410675f,
    (float16_t)0.993211949f, (float16_t)-0.116318631f,
    (float16_t)0.993906970f, (float16_t)-0.110222207f,
    (float16_t)0.994564571f, (float16_t)-0.104121634f,
    (float16_t)0.995184727f, (float16_t)-0.098017140f,
    (float16_t)0.995767414f, (float16_t)-0.091908956f,
    (float16_t)0.996312612f, (float16_t)-0.085797312f,
    (float16_t)0.996820299f, (float16_t)-0.079682438f,
    (float16_t)0.997290457f, (float16_t)-0.073564564f,
    (float16_t)0.997723067f, (float16_t)-0.067443920f,
    (float16_t)0.998118113f, (float16_t)-0.061320736f,
    (float16_t)0.998475581f, (float16_t)-0.055195244f,
    (float16_t)0.998795456f, (float16_t)-0.049067674f,
    (float16_t)0.999077728f, (float16_t)-0.042938257f,
    (float16_t)0.999322385f, (float16_t)-0.036807223f,
    (float16_t)0.999529418f, (float16_t)-0.030674803f,
    (float16_t)0.999698819f, (float16_t)-0.024541229f,
    (float16_t)0.999830582f, (float16_t)-0.018406730f,
    (float16_t)0.999924702f, (float16_t)-0.012271538f,
    (float16_t)0.999981175f, (float16_t)-0.006135885f
};
#endif 

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_2048)

/**
* \par
* Example code for Floating-point Twiddle factors Generation:
* \par
* <pre>for(i = 0; i< N/; i++)
* {
* twiddleCoef[2*i]= cos(i * 2*PI/(float)N);
* twiddleCoef[2*i+1]= sin(i * 2*PI/(float)N);
* } </pre>
* \par
* where N = 2048  and PI = 3.14159265358979
* \par
* Cos and Sin values are in interleaved fashion
*
*/
const float16_t twiddleCoefF16_2048[4096] = {
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.999995294f,  (float16_t)0.003067957f,
    (float16_t)0.999981175f,  (float16_t)0.006135885f,
    (float16_t)0.999957645f,  (float16_t)0.009203755f,
    (float16_t)0.999924702f,  (float16_t)0.012271538f,
    (float16_t)0.999882347f,  (float16_t)0.015339206f,
    (float16_t)0.999830582f,  (float16_t)0.018406730f,
    (float16_t)0.999769405f,  (float16_t)0.021474080f,
    (float16_t)0.999698819f,  (float16_t)0.024541229f,
    (float16_t)0.999618822f,  (float16_t)0.027608146f,
    (float16_t)0.999529418f,  (float16_t)0.030674803f,
    (float16_t)0.999430605f,  (float16_t)0.033741172f,
    (float16_t)0.999322385f,  (float16_t)0.036807223f,
    (float16_t)0.999204759f,  (float16_t)0.039872928f,
    (float16_t)0.999077728f,  (float16_t)0.042938257f,
    (float16_t)0.998941293f,  (float16_t)0.046003182f,
    (float16_t)0.998795456f,  (float16_t)0.049067674f,
    (float16_t)0.998640218f,  (float16_t)0.052131705f,
    (float16_t)0.998475581f,  (float16_t)0.055195244f,
    (float16_t)0.998301545f,  (float16_t)0.058258265f,
    (float16_t)0.998118113f,  (float16_t)0.061320736f,
    (float16_t)0.997925286f,  (float16_t)0.064382631f,
    (float16_t)0.997723067f,  (float16_t)0.067443920f,
    (float16_t)0.997511456f,  (float16_t)0.070504573f,
    (float16_t)0.997290457f,  (float16_t)0.073564564f,
    (float16_t)0.997060070f,  (float16_t)0.076623861f,
    (float16_t)0.996820299f,  (float16_t)0.079682438f,
    (float16_t)0.996571146f,  (float16_t)0.082740265f,
    (float16_t)0.996312612f,  (float16_t)0.085797312f,
    (float16_t)0.996044701f,  (float16_t)0.088853553f,
    (float16_t)0.995767414f,  (float16_t)0.091908956f,
    (float16_t)0.995480755f,  (float16_t)0.094963495f,
    (float16_t)0.995184727f,  (float16_t)0.098017140f,
    (float16_t)0.994879331f,  (float16_t)0.101069863f,
    (float16_t)0.994564571f,  (float16_t)0.104121634f,
    (float16_t)0.994240449f,  (float16_t)0.107172425f,
    (float16_t)0.993906970f,  (float16_t)0.110222207f,
    (float16_t)0.993564136f,  (float16_t)0.113270952f,
    (float16_t)0.993211949f,  (float16_t)0.116318631f,
    (float16_t)0.992850414f,  (float16_t)0.119365215f,
    (float16_t)0.992479535f,  (float16_t)0.122410675f,
    (float16_t)0.992099313f,  (float16_t)0.125454983f,
    (float16_t)0.991709754f,  (float16_t)0.128498111f,
    (float16_t)0.991310860f,  (float16_t)0.131540029f,
    (float16_t)0.990902635f,  (float16_t)0.134580709f,
    (float16_t)0.990485084f,  (float16_t)0.137620122f,
    (float16_t)0.990058210f,  (float16_t)0.140658239f,
    (float16_t)0.989622017f,  (float16_t)0.143695033f,
    (float16_t)0.989176510f,  (float16_t)0.146730474f,
    (float16_t)0.988721692f,  (float16_t)0.149764535f,
    (float16_t)0.988257568f,  (float16_t)0.152797185f,
    (float16_t)0.987784142f,  (float16_t)0.155828398f,
    (float16_t)0.987301418f,  (float16_t)0.158858143f,
    (float16_t)0.986809402f,  (float16_t)0.161886394f,
    (float16_t)0.986308097f,  (float16_t)0.164913120f,
    (float16_t)0.985797509f,  (float16_t)0.167938295f,
    (float16_t)0.985277642f,  (float16_t)0.170961889f,
    (float16_t)0.984748502f,  (float16_t)0.173983873f,
    (float16_t)0.984210092f,  (float16_t)0.177004220f,
    (float16_t)0.983662419f,  (float16_t)0.180022901f,
    (float16_t)0.983105487f,  (float16_t)0.183039888f,
    (float16_t)0.982539302f,  (float16_t)0.186055152f,
    (float16_t)0.981963869f,  (float16_t)0.189068664f,
    (float16_t)0.981379193f,  (float16_t)0.192080397f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.980182136f,  (float16_t)0.198098411f,
    (float16_t)0.979569766f,  (float16_t)0.201104635f,
    (float16_t)0.978948175f,  (float16_t)0.204108966f,
    (float16_t)0.978317371f,  (float16_t)0.207111376f,
    (float16_t)0.977677358f,  (float16_t)0.210111837f,
    (float16_t)0.977028143f,  (float16_t)0.213110320f,
    (float16_t)0.976369731f,  (float16_t)0.216106797f,
    (float16_t)0.975702130f,  (float16_t)0.219101240f,
    (float16_t)0.975025345f,  (float16_t)0.222093621f,
    (float16_t)0.974339383f,  (float16_t)0.225083911f,
    (float16_t)0.973644250f,  (float16_t)0.228072083f,
    (float16_t)0.972939952f,  (float16_t)0.231058108f,
    (float16_t)0.972226497f,  (float16_t)0.234041959f,
    (float16_t)0.971503891f,  (float16_t)0.237023606f,
    (float16_t)0.970772141f,  (float16_t)0.240003022f,
    (float16_t)0.970031253f,  (float16_t)0.242980180f,
    (float16_t)0.969281235f,  (float16_t)0.245955050f,
    (float16_t)0.968522094f,  (float16_t)0.248927606f,
    (float16_t)0.967753837f,  (float16_t)0.251897818f,
    (float16_t)0.966976471f,  (float16_t)0.254865660f,
    (float16_t)0.966190003f,  (float16_t)0.257831102f,
    (float16_t)0.965394442f,  (float16_t)0.260794118f,
    (float16_t)0.964589793f,  (float16_t)0.263754679f,
    (float16_t)0.963776066f,  (float16_t)0.266712757f,
    (float16_t)0.962953267f,  (float16_t)0.269668326f,
    (float16_t)0.962121404f,  (float16_t)0.272621355f,
    (float16_t)0.961280486f,  (float16_t)0.275571819f,
    (float16_t)0.960430519f,  (float16_t)0.278519689f,
    (float16_t)0.959571513f,  (float16_t)0.281464938f,
    (float16_t)0.958703475f,  (float16_t)0.284407537f,
    (float16_t)0.957826413f,  (float16_t)0.287347460f,
    (float16_t)0.956940336f,  (float16_t)0.290284677f,
    (float16_t)0.956045251f,  (float16_t)0.293219163f,
    (float16_t)0.955141168f,  (float16_t)0.296150888f,
    (float16_t)0.954228095f,  (float16_t)0.299079826f,
    (float16_t)0.953306040f,  (float16_t)0.302005949f,
    (float16_t)0.952375013f,  (float16_t)0.304929230f,
    (float16_t)0.951435021f,  (float16_t)0.307849640f,
    (float16_t)0.950486074f,  (float16_t)0.310767153f,
    (float16_t)0.949528181f,  (float16_t)0.313681740f,
    (float16_t)0.948561350f,  (float16_t)0.316593376f,
    (float16_t)0.947585591f,  (float16_t)0.319502031f,
    (float16_t)0.946600913f,  (float16_t)0.322407679f,
    (float16_t)0.945607325f,  (float16_t)0.325310292f,
    (float16_t)0.944604837f,  (float16_t)0.328209844f,
    (float16_t)0.943593458f,  (float16_t)0.331106306f,
    (float16_t)0.942573198f,  (float16_t)0.333999651f,
    (float16_t)0.941544065f,  (float16_t)0.336889853f,
    (float16_t)0.940506071f,  (float16_t)0.339776884f,
    (float16_t)0.939459224f,  (float16_t)0.342660717f,
    (float16_t)0.938403534f,  (float16_t)0.345541325f,
    (float16_t)0.937339012f,  (float16_t)0.348418680f,
    (float16_t)0.936265667f,  (float16_t)0.351292756f,
    (float16_t)0.935183510f,  (float16_t)0.354163525f,
    (float16_t)0.934092550f,  (float16_t)0.357030961f,
    (float16_t)0.932992799f,  (float16_t)0.359895037f,
    (float16_t)0.931884266f,  (float16_t)0.362755724f,
    (float16_t)0.930766961f,  (float16_t)0.365612998f,
    (float16_t)0.929640896f,  (float16_t)0.368466830f,
    (float16_t)0.928506080f,  (float16_t)0.371317194f,
    (float16_t)0.927362526f,  (float16_t)0.374164063f,
    (float16_t)0.926210242f,  (float16_t)0.377007410f,
    (float16_t)0.925049241f,  (float16_t)0.379847209f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.922701128f,  (float16_t)0.385516054f,
    (float16_t)0.921514039f,  (float16_t)0.388345047f,
    (float16_t)0.920318277f,  (float16_t)0.391170384f,
    (float16_t)0.919113852f,  (float16_t)0.393992040f,
    (float16_t)0.917900776f,  (float16_t)0.396809987f,
    (float16_t)0.916679060f,  (float16_t)0.399624200f,
    (float16_t)0.915448716f,  (float16_t)0.402434651f,
    (float16_t)0.914209756f,  (float16_t)0.405241314f,
    (float16_t)0.912962190f,  (float16_t)0.408044163f,
    (float16_t)0.911706032f,  (float16_t)0.410843171f,
    (float16_t)0.910441292f,  (float16_t)0.413638312f,
    (float16_t)0.909167983f,  (float16_t)0.416429560f,
    (float16_t)0.907886116f,  (float16_t)0.419216888f,
    (float16_t)0.906595705f,  (float16_t)0.422000271f,
    (float16_t)0.905296759f,  (float16_t)0.424779681f,
    (float16_t)0.903989293f,  (float16_t)0.427555093f,
    (float16_t)0.902673318f,  (float16_t)0.430326481f,
    (float16_t)0.901348847f,  (float16_t)0.433093819f,
    (float16_t)0.900015892f,  (float16_t)0.435857080f,
    (float16_t)0.898674466f,  (float16_t)0.438616239f,
    (float16_t)0.897324581f,  (float16_t)0.441371269f,
    (float16_t)0.895966250f,  (float16_t)0.444122145f,
    (float16_t)0.894599486f,  (float16_t)0.446868840f,
    (float16_t)0.893224301f,  (float16_t)0.449611330f,
    (float16_t)0.891840709f,  (float16_t)0.452349587f,
    (float16_t)0.890448723f,  (float16_t)0.455083587f,
    (float16_t)0.889048356f,  (float16_t)0.457813304f,
    (float16_t)0.887639620f,  (float16_t)0.460538711f,
    (float16_t)0.886222530f,  (float16_t)0.463259784f,
    (float16_t)0.884797098f,  (float16_t)0.465976496f,
    (float16_t)0.883363339f,  (float16_t)0.468688822f,
    (float16_t)0.881921264f,  (float16_t)0.471396737f,
    (float16_t)0.880470889f,  (float16_t)0.474100215f,
    (float16_t)0.879012226f,  (float16_t)0.476799230f,
    (float16_t)0.877545290f,  (float16_t)0.479493758f,
    (float16_t)0.876070094f,  (float16_t)0.482183772f,
    (float16_t)0.874586652f,  (float16_t)0.484869248f,
    (float16_t)0.873094978f,  (float16_t)0.487550160f,
    (float16_t)0.871595087f,  (float16_t)0.490226483f,
    (float16_t)0.870086991f,  (float16_t)0.492898192f,
    (float16_t)0.868570706f,  (float16_t)0.495565262f,
    (float16_t)0.867046246f,  (float16_t)0.498227667f,
    (float16_t)0.865513624f,  (float16_t)0.500885383f,
    (float16_t)0.863972856f,  (float16_t)0.503538384f,
    (float16_t)0.862423956f,  (float16_t)0.506186645f,
    (float16_t)0.860866939f,  (float16_t)0.508830143f,
    (float16_t)0.859301818f,  (float16_t)0.511468850f,
    (float16_t)0.857728610f,  (float16_t)0.514102744f,
    (float16_t)0.856147328f,  (float16_t)0.516731799f,
    (float16_t)0.854557988f,  (float16_t)0.519355990f,
    (float16_t)0.852960605f,  (float16_t)0.521975293f,
    (float16_t)0.851355193f,  (float16_t)0.524589683f,
    (float16_t)0.849741768f,  (float16_t)0.527199135f,
    (float16_t)0.848120345f,  (float16_t)0.529803625f,
    (float16_t)0.846490939f,  (float16_t)0.532403128f,
    (float16_t)0.844853565f,  (float16_t)0.534997620f,
    (float16_t)0.843208240f,  (float16_t)0.537587076f,
    (float16_t)0.841554977f,  (float16_t)0.540171473f,
    (float16_t)0.839893794f,  (float16_t)0.542750785f,
    (float16_t)0.838224706f,  (float16_t)0.545324988f,
    (float16_t)0.836547727f,  (float16_t)0.547894059f,
    (float16_t)0.834862875f,  (float16_t)0.550457973f,
    (float16_t)0.833170165f,  (float16_t)0.553016706f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.829761234f,  (float16_t)0.558118531f,
    (float16_t)0.828045045f,  (float16_t)0.560661576f,
    (float16_t)0.826321063f,  (float16_t)0.563199344f,
    (float16_t)0.824589303f,  (float16_t)0.565731811f,
    (float16_t)0.822849781f,  (float16_t)0.568258953f,
    (float16_t)0.821102515f,  (float16_t)0.570780746f,
    (float16_t)0.819347520f,  (float16_t)0.573297167f,
    (float16_t)0.817584813f,  (float16_t)0.575808191f,
    (float16_t)0.815814411f,  (float16_t)0.578313796f,
    (float16_t)0.814036330f,  (float16_t)0.580813958f,
    (float16_t)0.812250587f,  (float16_t)0.583308653f,
    (float16_t)0.810457198f,  (float16_t)0.585797857f,
    (float16_t)0.808656182f,  (float16_t)0.588281548f,
    (float16_t)0.806847554f,  (float16_t)0.590759702f,
    (float16_t)0.805031331f,  (float16_t)0.593232295f,
    (float16_t)0.803207531f,  (float16_t)0.595699304f,
    (float16_t)0.801376172f,  (float16_t)0.598160707f,
    (float16_t)0.799537269f,  (float16_t)0.600616479f,
    (float16_t)0.797690841f,  (float16_t)0.603066599f,
    (float16_t)0.795836905f,  (float16_t)0.605511041f,
    (float16_t)0.793975478f,  (float16_t)0.607949785f,
    (float16_t)0.792106577f,  (float16_t)0.610382806f,
    (float16_t)0.790230221f,  (float16_t)0.612810082f,
    (float16_t)0.788346428f,  (float16_t)0.615231591f,
    (float16_t)0.786455214f,  (float16_t)0.617647308f,
    (float16_t)0.784556597f,  (float16_t)0.620057212f,
    (float16_t)0.782650596f,  (float16_t)0.622461279f,
    (float16_t)0.780737229f,  (float16_t)0.624859488f,
    (float16_t)0.778816512f,  (float16_t)0.627251815f,
    (float16_t)0.776888466f,  (float16_t)0.629638239f,
    (float16_t)0.774953107f,  (float16_t)0.632018736f,
    (float16_t)0.773010453f,  (float16_t)0.634393284f,
    (float16_t)0.771060524f,  (float16_t)0.636761861f,
    (float16_t)0.769103338f,  (float16_t)0.639124445f,
    (float16_t)0.767138912f,  (float16_t)0.641481013f,
    (float16_t)0.765167266f,  (float16_t)0.643831543f,
    (float16_t)0.763188417f,  (float16_t)0.646176013f,
    (float16_t)0.761202385f,  (float16_t)0.648514401f,
    (float16_t)0.759209189f,  (float16_t)0.650846685f,
    (float16_t)0.757208847f,  (float16_t)0.653172843f,
    (float16_t)0.755201377f,  (float16_t)0.655492853f,
    (float16_t)0.753186799f,  (float16_t)0.657806693f,
    (float16_t)0.751165132f,  (float16_t)0.660114342f,
    (float16_t)0.749136395f,  (float16_t)0.662415778f,
    (float16_t)0.747100606f,  (float16_t)0.664710978f,
    (float16_t)0.745057785f,  (float16_t)0.666999922f,
    (float16_t)0.743007952f,  (float16_t)0.669282588f,
    (float16_t)0.740951125f,  (float16_t)0.671558955f,
    (float16_t)0.738887324f,  (float16_t)0.673829000f,
    (float16_t)0.736816569f,  (float16_t)0.676092704f,
    (float16_t)0.734738878f,  (float16_t)0.678350043f,
    (float16_t)0.732654272f,  (float16_t)0.680600998f,
    (float16_t)0.730562769f,  (float16_t)0.682845546f,
    (float16_t)0.728464390f,  (float16_t)0.685083668f,
    (float16_t)0.726359155f,  (float16_t)0.687315341f,
    (float16_t)0.724247083f,  (float16_t)0.689540545f,
    (float16_t)0.722128194f,  (float16_t)0.691759258f,
    (float16_t)0.720002508f,  (float16_t)0.693971461f,
    (float16_t)0.717870045f,  (float16_t)0.696177131f,
    (float16_t)0.715730825f,  (float16_t)0.698376249f,
    (float16_t)0.713584869f,  (float16_t)0.700568794f,
    (float16_t)0.711432196f,  (float16_t)0.702754744f,
    (float16_t)0.709272826f,  (float16_t)0.704934080f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.704934080f,  (float16_t)0.709272826f,
    (float16_t)0.702754744f,  (float16_t)0.711432196f,
    (float16_t)0.700568794f,  (float16_t)0.713584869f,
    (float16_t)0.698376249f,  (float16_t)0.715730825f,
    (float16_t)0.696177131f,  (float16_t)0.717870045f,
    (float16_t)0.693971461f,  (float16_t)0.720002508f,
    (float16_t)0.691759258f,  (float16_t)0.722128194f,
    (float16_t)0.689540545f,  (float16_t)0.724247083f,
    (float16_t)0.687315341f,  (float16_t)0.726359155f,
    (float16_t)0.685083668f,  (float16_t)0.728464390f,
    (float16_t)0.682845546f,  (float16_t)0.730562769f,
    (float16_t)0.680600998f,  (float16_t)0.732654272f,
    (float16_t)0.678350043f,  (float16_t)0.734738878f,
    (float16_t)0.676092704f,  (float16_t)0.736816569f,
    (float16_t)0.673829000f,  (float16_t)0.738887324f,
    (float16_t)0.671558955f,  (float16_t)0.740951125f,
    (float16_t)0.669282588f,  (float16_t)0.743007952f,
    (float16_t)0.666999922f,  (float16_t)0.745057785f,
    (float16_t)0.664710978f,  (float16_t)0.747100606f,
    (float16_t)0.662415778f,  (float16_t)0.749136395f,
    (float16_t)0.660114342f,  (float16_t)0.751165132f,
    (float16_t)0.657806693f,  (float16_t)0.753186799f,
    (float16_t)0.655492853f,  (float16_t)0.755201377f,
    (float16_t)0.653172843f,  (float16_t)0.757208847f,
    (float16_t)0.650846685f,  (float16_t)0.759209189f,
    (float16_t)0.648514401f,  (float16_t)0.761202385f,
    (float16_t)0.646176013f,  (float16_t)0.763188417f,
    (float16_t)0.643831543f,  (float16_t)0.765167266f,
    (float16_t)0.641481013f,  (float16_t)0.767138912f,
    (float16_t)0.639124445f,  (float16_t)0.769103338f,
    (float16_t)0.636761861f,  (float16_t)0.771060524f,
    (float16_t)0.634393284f,  (float16_t)0.773010453f,
    (float16_t)0.632018736f,  (float16_t)0.774953107f,
    (float16_t)0.629638239f,  (float16_t)0.776888466f,
    (float16_t)0.627251815f,  (float16_t)0.778816512f,
    (float16_t)0.624859488f,  (float16_t)0.780737229f,
    (float16_t)0.622461279f,  (float16_t)0.782650596f,
    (float16_t)0.620057212f,  (float16_t)0.784556597f,
    (float16_t)0.617647308f,  (float16_t)0.786455214f,
    (float16_t)0.615231591f,  (float16_t)0.788346428f,
    (float16_t)0.612810082f,  (float16_t)0.790230221f,
    (float16_t)0.610382806f,  (float16_t)0.792106577f,
    (float16_t)0.607949785f,  (float16_t)0.793975478f,
    (float16_t)0.605511041f,  (float16_t)0.795836905f,
    (float16_t)0.603066599f,  (float16_t)0.797690841f,
    (float16_t)0.600616479f,  (float16_t)0.799537269f,
    (float16_t)0.598160707f,  (float16_t)0.801376172f,
    (float16_t)0.595699304f,  (float16_t)0.803207531f,
    (float16_t)0.593232295f,  (float16_t)0.805031331f,
    (float16_t)0.590759702f,  (float16_t)0.806847554f,
    (float16_t)0.588281548f,  (float16_t)0.808656182f,
    (float16_t)0.585797857f,  (float16_t)0.810457198f,
    (float16_t)0.583308653f,  (float16_t)0.812250587f,
    (float16_t)0.580813958f,  (float16_t)0.814036330f,
    (float16_t)0.578313796f,  (float16_t)0.815814411f,
    (float16_t)0.575808191f,  (float16_t)0.817584813f,
    (float16_t)0.573297167f,  (float16_t)0.819347520f,
    (float16_t)0.570780746f,  (float16_t)0.821102515f,
    (float16_t)0.568258953f,  (float16_t)0.822849781f,
    (float16_t)0.565731811f,  (float16_t)0.824589303f,
    (float16_t)0.563199344f,  (float16_t)0.826321063f,
    (float16_t)0.560661576f,  (float16_t)0.828045045f,
    (float16_t)0.558118531f,  (float16_t)0.829761234f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.553016706f,  (float16_t)0.833170165f,
    (float16_t)0.550457973f,  (float16_t)0.834862875f,
    (float16_t)0.547894059f,  (float16_t)0.836547727f,
    (float16_t)0.545324988f,  (float16_t)0.838224706f,
    (float16_t)0.542750785f,  (float16_t)0.839893794f,
    (float16_t)0.540171473f,  (float16_t)0.841554977f,
    (float16_t)0.537587076f,  (float16_t)0.843208240f,
    (float16_t)0.534997620f,  (float16_t)0.844853565f,
    (float16_t)0.532403128f,  (float16_t)0.846490939f,
    (float16_t)0.529803625f,  (float16_t)0.848120345f,
    (float16_t)0.527199135f,  (float16_t)0.849741768f,
    (float16_t)0.524589683f,  (float16_t)0.851355193f,
    (float16_t)0.521975293f,  (float16_t)0.852960605f,
    (float16_t)0.519355990f,  (float16_t)0.854557988f,
    (float16_t)0.516731799f,  (float16_t)0.856147328f,
    (float16_t)0.514102744f,  (float16_t)0.857728610f,
    (float16_t)0.511468850f,  (float16_t)0.859301818f,
    (float16_t)0.508830143f,  (float16_t)0.860866939f,
    (float16_t)0.506186645f,  (float16_t)0.862423956f,
    (float16_t)0.503538384f,  (float16_t)0.863972856f,
    (float16_t)0.500885383f,  (float16_t)0.865513624f,
    (float16_t)0.498227667f,  (float16_t)0.867046246f,
    (float16_t)0.495565262f,  (float16_t)0.868570706f,
    (float16_t)0.492898192f,  (float16_t)0.870086991f,
    (float16_t)0.490226483f,  (float16_t)0.871595087f,
    (float16_t)0.487550160f,  (float16_t)0.873094978f,
    (float16_t)0.484869248f,  (float16_t)0.874586652f,
    (float16_t)0.482183772f,  (float16_t)0.876070094f,
    (float16_t)0.479493758f,  (float16_t)0.877545290f,
    (float16_t)0.476799230f,  (float16_t)0.879012226f,
    (float16_t)0.474100215f,  (float16_t)0.880470889f,
    (float16_t)0.471396737f,  (float16_t)0.881921264f,
    (float16_t)0.468688822f,  (float16_t)0.883363339f,
    (float16_t)0.465976496f,  (float16_t)0.884797098f,
    (float16_t)0.463259784f,  (float16_t)0.886222530f,
    (float16_t)0.460538711f,  (float16_t)0.887639620f,
    (float16_t)0.457813304f,  (float16_t)0.889048356f,
    (float16_t)0.455083587f,  (float16_t)0.890448723f,
    (float16_t)0.452349587f,  (float16_t)0.891840709f,
    (float16_t)0.449611330f,  (float16_t)0.893224301f,
    (float16_t)0.446868840f,  (float16_t)0.894599486f,
    (float16_t)0.444122145f,  (float16_t)0.895966250f,
    (float16_t)0.441371269f,  (float16_t)0.897324581f,
    (float16_t)0.438616239f,  (float16_t)0.898674466f,
    (float16_t)0.435857080f,  (float16_t)0.900015892f,
    (float16_t)0.433093819f,  (float16_t)0.901348847f,
    (float16_t)0.430326481f,  (float16_t)0.902673318f,
    (float16_t)0.427555093f,  (float16_t)0.903989293f,
    (float16_t)0.424779681f,  (float16_t)0.905296759f,
    (float16_t)0.422000271f,  (float16_t)0.906595705f,
    (float16_t)0.419216888f,  (float16_t)0.907886116f,
    (float16_t)0.416429560f,  (float16_t)0.909167983f,
    (float16_t)0.413638312f,  (float16_t)0.910441292f,
    (float16_t)0.410843171f,  (float16_t)0.911706032f,
    (float16_t)0.408044163f,  (float16_t)0.912962190f,
    (float16_t)0.405241314f,  (float16_t)0.914209756f,
    (float16_t)0.402434651f,  (float16_t)0.915448716f,
    (float16_t)0.399624200f,  (float16_t)0.916679060f,
    (float16_t)0.396809987f,  (float16_t)0.917900776f,
    (float16_t)0.393992040f,  (float16_t)0.919113852f,
    (float16_t)0.391170384f,  (float16_t)0.920318277f,
    (float16_t)0.388345047f,  (float16_t)0.921514039f,
    (float16_t)0.385516054f,  (float16_t)0.922701128f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.379847209f,  (float16_t)0.925049241f,
    (float16_t)0.377007410f,  (float16_t)0.926210242f,
    (float16_t)0.374164063f,  (float16_t)0.927362526f,
    (float16_t)0.371317194f,  (float16_t)0.928506080f,
    (float16_t)0.368466830f,  (float16_t)0.929640896f,
    (float16_t)0.365612998f,  (float16_t)0.930766961f,
    (float16_t)0.362755724f,  (float16_t)0.931884266f,
    (float16_t)0.359895037f,  (float16_t)0.932992799f,
    (float16_t)0.357030961f,  (float16_t)0.934092550f,
    (float16_t)0.354163525f,  (float16_t)0.935183510f,
    (float16_t)0.351292756f,  (float16_t)0.936265667f,
    (float16_t)0.348418680f,  (float16_t)0.937339012f,
    (float16_t)0.345541325f,  (float16_t)0.938403534f,
    (float16_t)0.342660717f,  (float16_t)0.939459224f,
    (float16_t)0.339776884f,  (float16_t)0.940506071f,
    (float16_t)0.336889853f,  (float16_t)0.941544065f,
    (float16_t)0.333999651f,  (float16_t)0.942573198f,
    (float16_t)0.331106306f,  (float16_t)0.943593458f,
    (float16_t)0.328209844f,  (float16_t)0.944604837f,
    (float16_t)0.325310292f,  (float16_t)0.945607325f,
    (float16_t)0.322407679f,  (float16_t)0.946600913f,
    (float16_t)0.319502031f,  (float16_t)0.947585591f,
    (float16_t)0.316593376f,  (float16_t)0.948561350f,
    (float16_t)0.313681740f,  (float16_t)0.949528181f,
    (float16_t)0.310767153f,  (float16_t)0.950486074f,
    (float16_t)0.307849640f,  (float16_t)0.951435021f,
    (float16_t)0.304929230f,  (float16_t)0.952375013f,
    (float16_t)0.302005949f,  (float16_t)0.953306040f,
    (float16_t)0.299079826f,  (float16_t)0.954228095f,
    (float16_t)0.296150888f,  (float16_t)0.955141168f,
    (float16_t)0.293219163f,  (float16_t)0.956045251f,
    (float16_t)0.290284677f,  (float16_t)0.956940336f,
    (float16_t)0.287347460f,  (float16_t)0.957826413f,
    (float16_t)0.284407537f,  (float16_t)0.958703475f,
    (float16_t)0.281464938f,  (float16_t)0.959571513f,
    (float16_t)0.278519689f,  (float16_t)0.960430519f,
    (float16_t)0.275571819f,  (float16_t)0.961280486f,
    (float16_t)0.272621355f,  (float16_t)0.962121404f,
    (float16_t)0.269668326f,  (float16_t)0.962953267f,
    (float16_t)0.266712757f,  (float16_t)0.963776066f,
    (float16_t)0.263754679f,  (float16_t)0.964589793f,
    (float16_t)0.260794118f,  (float16_t)0.965394442f,
    (float16_t)0.257831102f,  (float16_t)0.966190003f,
    (float16_t)0.254865660f,  (float16_t)0.966976471f,
    (float16_t)0.251897818f,  (float16_t)0.967753837f,
    (float16_t)0.248927606f,  (float16_t)0.968522094f,
    (float16_t)0.245955050f,  (float16_t)0.969281235f,
    (float16_t)0.242980180f,  (float16_t)0.970031253f,
    (float16_t)0.240003022f,  (float16_t)0.970772141f,
    (float16_t)0.237023606f,  (float16_t)0.971503891f,
    (float16_t)0.234041959f,  (float16_t)0.972226497f,
    (float16_t)0.231058108f,  (float16_t)0.972939952f,
    (float16_t)0.228072083f,  (float16_t)0.973644250f,
    (float16_t)0.225083911f,  (float16_t)0.974339383f,
    (float16_t)0.222093621f,  (float16_t)0.975025345f,
    (float16_t)0.219101240f,  (float16_t)0.975702130f,
    (float16_t)0.216106797f,  (float16_t)0.976369731f,
    (float16_t)0.213110320f,  (float16_t)0.977028143f,
    (float16_t)0.210111837f,  (float16_t)0.977677358f,
    (float16_t)0.207111376f,  (float16_t)0.978317371f,
    (float16_t)0.204108966f,  (float16_t)0.978948175f,
    (float16_t)0.201104635f,  (float16_t)0.979569766f,
    (float16_t)0.198098411f,  (float16_t)0.980182136f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.192080397f,  (float16_t)0.981379193f,
    (float16_t)0.189068664f,  (float16_t)0.981963869f,
    (float16_t)0.186055152f,  (float16_t)0.982539302f,
    (float16_t)0.183039888f,  (float16_t)0.983105487f,
    (float16_t)0.180022901f,  (float16_t)0.983662419f,
    (float16_t)0.177004220f,  (float16_t)0.984210092f,
    (float16_t)0.173983873f,  (float16_t)0.984748502f,
    (float16_t)0.170961889f,  (float16_t)0.985277642f,
    (float16_t)0.167938295f,  (float16_t)0.985797509f,
    (float16_t)0.164913120f,  (float16_t)0.986308097f,
    (float16_t)0.161886394f,  (float16_t)0.986809402f,
    (float16_t)0.158858143f,  (float16_t)0.987301418f,
    (float16_t)0.155828398f,  (float16_t)0.987784142f,
    (float16_t)0.152797185f,  (float16_t)0.988257568f,
    (float16_t)0.149764535f,  (float16_t)0.988721692f,
    (float16_t)0.146730474f,  (float16_t)0.989176510f,
    (float16_t)0.143695033f,  (float16_t)0.989622017f,
    (float16_t)0.140658239f,  (float16_t)0.990058210f,
    (float16_t)0.137620122f,  (float16_t)0.990485084f,
    (float16_t)0.134580709f,  (float16_t)0.990902635f,
    (float16_t)0.131540029f,  (float16_t)0.991310860f,
    (float16_t)0.128498111f,  (float16_t)0.991709754f,
    (float16_t)0.125454983f,  (float16_t)0.992099313f,
    (float16_t)0.122410675f,  (float16_t)0.992479535f,
    (float16_t)0.119365215f,  (float16_t)0.992850414f,
    (float16_t)0.116318631f,  (float16_t)0.993211949f,
    (float16_t)0.113270952f,  (float16_t)0.993564136f,
    (float16_t)0.110222207f,  (float16_t)0.993906970f,
    (float16_t)0.107172425f,  (float16_t)0.994240449f,
    (float16_t)0.104121634f,  (float16_t)0.994564571f,
    (float16_t)0.101069863f,  (float16_t)0.994879331f,
    (float16_t)0.098017140f,  (float16_t)0.995184727f,
    (float16_t)0.094963495f,  (float16_t)0.995480755f,
    (float16_t)0.091908956f,  (float16_t)0.995767414f,
    (float16_t)0.088853553f,  (float16_t)0.996044701f,
    (float16_t)0.085797312f,  (float16_t)0.996312612f,
    (float16_t)0.082740265f,  (float16_t)0.996571146f,
    (float16_t)0.079682438f,  (float16_t)0.996820299f,
    (float16_t)0.076623861f,  (float16_t)0.997060070f,
    (float16_t)0.073564564f,  (float16_t)0.997290457f,
    (float16_t)0.070504573f,  (float16_t)0.997511456f,
    (float16_t)0.067443920f,  (float16_t)0.997723067f,
    (float16_t)0.064382631f,  (float16_t)0.997925286f,
    (float16_t)0.061320736f,  (float16_t)0.998118113f,
    (float16_t)0.058258265f,  (float16_t)0.998301545f,
    (float16_t)0.055195244f,  (float16_t)0.998475581f,
    (float16_t)0.052131705f,  (float16_t)0.998640218f,
    (float16_t)0.049067674f,  (float16_t)0.998795456f,
    (float16_t)0.046003182f,  (float16_t)0.998941293f,
    (float16_t)0.042938257f,  (float16_t)0.999077728f,
    (float16_t)0.039872928f,  (float16_t)0.999204759f,
    (float16_t)0.036807223f,  (float16_t)0.999322385f,
    (float16_t)0.033741172f,  (float16_t)0.999430605f,
    (float16_t)0.030674803f,  (float16_t)0.999529418f,
    (float16_t)0.027608146f,  (float16_t)0.999618822f,
    (float16_t)0.024541229f,  (float16_t)0.999698819f,
    (float16_t)0.021474080f,  (float16_t)0.999769405f,
    (float16_t)0.018406730f,  (float16_t)0.999830582f,
    (float16_t)0.015339206f,  (float16_t)0.999882347f,
    (float16_t)0.012271538f,  (float16_t)0.999924702f,
    (float16_t)0.009203755f,  (float16_t)0.999957645f,
    (float16_t)0.006135885f,  (float16_t)0.999981175f,
    (float16_t)0.003067957f,  (float16_t)0.999995294f,
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
   (float16_t)-0.003067957f,  (float16_t)0.999995294f,
   (float16_t)-0.006135885f,  (float16_t)0.999981175f,
   (float16_t)-0.009203755f,  (float16_t)0.999957645f,
   (float16_t)-0.012271538f,  (float16_t)0.999924702f,
   (float16_t)-0.015339206f,  (float16_t)0.999882347f,
   (float16_t)-0.018406730f,  (float16_t)0.999830582f,
   (float16_t)-0.021474080f,  (float16_t)0.999769405f,
   (float16_t)-0.024541229f,  (float16_t)0.999698819f,
   (float16_t)-0.027608146f,  (float16_t)0.999618822f,
   (float16_t)-0.030674803f,  (float16_t)0.999529418f,
   (float16_t)-0.033741172f,  (float16_t)0.999430605f,
   (float16_t)-0.036807223f,  (float16_t)0.999322385f,
   (float16_t)-0.039872928f,  (float16_t)0.999204759f,
   (float16_t)-0.042938257f,  (float16_t)0.999077728f,
   (float16_t)-0.046003182f,  (float16_t)0.998941293f,
   (float16_t)-0.049067674f,  (float16_t)0.998795456f,
   (float16_t)-0.052131705f,  (float16_t)0.998640218f,
   (float16_t)-0.055195244f,  (float16_t)0.998475581f,
   (float16_t)-0.058258265f,  (float16_t)0.998301545f,
   (float16_t)-0.061320736f,  (float16_t)0.998118113f,
   (float16_t)-0.064382631f,  (float16_t)0.997925286f,
   (float16_t)-0.067443920f,  (float16_t)0.997723067f,
   (float16_t)-0.070504573f,  (float16_t)0.997511456f,
   (float16_t)-0.073564564f,  (float16_t)0.997290457f,
   (float16_t)-0.076623861f,  (float16_t)0.997060070f,
   (float16_t)-0.079682438f,  (float16_t)0.996820299f,
   (float16_t)-0.082740265f,  (float16_t)0.996571146f,
   (float16_t)-0.085797312f,  (float16_t)0.996312612f,
   (float16_t)-0.088853553f,  (float16_t)0.996044701f,
   (float16_t)-0.091908956f,  (float16_t)0.995767414f,
   (float16_t)-0.094963495f,  (float16_t)0.995480755f,
   (float16_t)-0.098017140f,  (float16_t)0.995184727f,
   (float16_t)-0.101069863f,  (float16_t)0.994879331f,
   (float16_t)-0.104121634f,  (float16_t)0.994564571f,
   (float16_t)-0.107172425f,  (float16_t)0.994240449f,
   (float16_t)-0.110222207f,  (float16_t)0.993906970f,
   (float16_t)-0.113270952f,  (float16_t)0.993564136f,
   (float16_t)-0.116318631f,  (float16_t)0.993211949f,
   (float16_t)-0.119365215f,  (float16_t)0.992850414f,
   (float16_t)-0.122410675f,  (float16_t)0.992479535f,
   (float16_t)-0.125454983f,  (float16_t)0.992099313f,
   (float16_t)-0.128498111f,  (float16_t)0.991709754f,
   (float16_t)-0.131540029f,  (float16_t)0.991310860f,
   (float16_t)-0.134580709f,  (float16_t)0.990902635f,
   (float16_t)-0.137620122f,  (float16_t)0.990485084f,
   (float16_t)-0.140658239f,  (float16_t)0.990058210f,
   (float16_t)-0.143695033f,  (float16_t)0.989622017f,
   (float16_t)-0.146730474f,  (float16_t)0.989176510f,
   (float16_t)-0.149764535f,  (float16_t)0.988721692f,
   (float16_t)-0.152797185f,  (float16_t)0.988257568f,
   (float16_t)-0.155828398f,  (float16_t)0.987784142f,
   (float16_t)-0.158858143f,  (float16_t)0.987301418f,
   (float16_t)-0.161886394f,  (float16_t)0.986809402f,
   (float16_t)-0.164913120f,  (float16_t)0.986308097f,
   (float16_t)-0.167938295f,  (float16_t)0.985797509f,
   (float16_t)-0.170961889f,  (float16_t)0.985277642f,
   (float16_t)-0.173983873f,  (float16_t)0.984748502f,
   (float16_t)-0.177004220f,  (float16_t)0.984210092f,
   (float16_t)-0.180022901f,  (float16_t)0.983662419f,
   (float16_t)-0.183039888f,  (float16_t)0.983105487f,
   (float16_t)-0.186055152f,  (float16_t)0.982539302f,
   (float16_t)-0.189068664f,  (float16_t)0.981963869f,
   (float16_t)-0.192080397f,  (float16_t)0.981379193f,
   (float16_t)-0.195090322f,  (float16_t)0.980785280f,
   (float16_t)-0.198098411f,  (float16_t)0.980182136f,
   (float16_t)-0.201104635f,  (float16_t)0.979569766f,
   (float16_t)-0.204108966f,  (float16_t)0.978948175f,
   (float16_t)-0.207111376f,  (float16_t)0.978317371f,
   (float16_t)-0.210111837f,  (float16_t)0.977677358f,
   (float16_t)-0.213110320f,  (float16_t)0.977028143f,
   (float16_t)-0.216106797f,  (float16_t)0.976369731f,
   (float16_t)-0.219101240f,  (float16_t)0.975702130f,
   (float16_t)-0.222093621f,  (float16_t)0.975025345f,
   (float16_t)-0.225083911f,  (float16_t)0.974339383f,
   (float16_t)-0.228072083f,  (float16_t)0.973644250f,
   (float16_t)-0.231058108f,  (float16_t)0.972939952f,
   (float16_t)-0.234041959f,  (float16_t)0.972226497f,
   (float16_t)-0.237023606f,  (float16_t)0.971503891f,
   (float16_t)-0.240003022f,  (float16_t)0.970772141f,
   (float16_t)-0.242980180f,  (float16_t)0.970031253f,
   (float16_t)-0.245955050f,  (float16_t)0.969281235f,
   (float16_t)-0.248927606f,  (float16_t)0.968522094f,
   (float16_t)-0.251897818f,  (float16_t)0.967753837f,
   (float16_t)-0.254865660f,  (float16_t)0.966976471f,
   (float16_t)-0.257831102f,  (float16_t)0.966190003f,
   (float16_t)-0.260794118f,  (float16_t)0.965394442f,
   (float16_t)-0.263754679f,  (float16_t)0.964589793f,
   (float16_t)-0.266712757f,  (float16_t)0.963776066f,
   (float16_t)-0.269668326f,  (float16_t)0.962953267f,
   (float16_t)-0.272621355f,  (float16_t)0.962121404f,
   (float16_t)-0.275571819f,  (float16_t)0.961280486f,
   (float16_t)-0.278519689f,  (float16_t)0.960430519f,
   (float16_t)-0.281464938f,  (float16_t)0.959571513f,
   (float16_t)-0.284407537f,  (float16_t)0.958703475f,
   (float16_t)-0.287347460f,  (float16_t)0.957826413f,
   (float16_t)-0.290284677f,  (float16_t)0.956940336f,
   (float16_t)-0.293219163f,  (float16_t)0.956045251f,
   (float16_t)-0.296150888f,  (float16_t)0.955141168f,
   (float16_t)-0.299079826f,  (float16_t)0.954228095f,
   (float16_t)-0.302005949f,  (float16_t)0.953306040f,
   (float16_t)-0.304929230f,  (float16_t)0.952375013f,
   (float16_t)-0.307849640f,  (float16_t)0.951435021f,
   (float16_t)-0.310767153f,  (float16_t)0.950486074f,
   (float16_t)-0.313681740f,  (float16_t)0.949528181f,
   (float16_t)-0.316593376f,  (float16_t)0.948561350f,
   (float16_t)-0.319502031f,  (float16_t)0.947585591f,
   (float16_t)-0.322407679f,  (float16_t)0.946600913f,
   (float16_t)-0.325310292f,  (float16_t)0.945607325f,
   (float16_t)-0.328209844f,  (float16_t)0.944604837f,
   (float16_t)-0.331106306f,  (float16_t)0.943593458f,
   (float16_t)-0.333999651f,  (float16_t)0.942573198f,
   (float16_t)-0.336889853f,  (float16_t)0.941544065f,
   (float16_t)-0.339776884f,  (float16_t)0.940506071f,
   (float16_t)-0.342660717f,  (float16_t)0.939459224f,
   (float16_t)-0.345541325f,  (float16_t)0.938403534f,
   (float16_t)-0.348418680f,  (float16_t)0.937339012f,
   (float16_t)-0.351292756f,  (float16_t)0.936265667f,
   (float16_t)-0.354163525f,  (float16_t)0.935183510f,
   (float16_t)-0.357030961f,  (float16_t)0.934092550f,
   (float16_t)-0.359895037f,  (float16_t)0.932992799f,
   (float16_t)-0.362755724f,  (float16_t)0.931884266f,
   (float16_t)-0.365612998f,  (float16_t)0.930766961f,
   (float16_t)-0.368466830f,  (float16_t)0.929640896f,
   (float16_t)-0.371317194f,  (float16_t)0.928506080f,
   (float16_t)-0.374164063f,  (float16_t)0.927362526f,
   (float16_t)-0.377007410f,  (float16_t)0.926210242f,
   (float16_t)-0.379847209f,  (float16_t)0.925049241f,
   (float16_t)-0.382683432f,  (float16_t)0.923879533f,
   (float16_t)-0.385516054f,  (float16_t)0.922701128f,
   (float16_t)-0.388345047f,  (float16_t)0.921514039f,
   (float16_t)-0.391170384f,  (float16_t)0.920318277f,
   (float16_t)-0.393992040f,  (float16_t)0.919113852f,
   (float16_t)-0.396809987f,  (float16_t)0.917900776f,
   (float16_t)-0.399624200f,  (float16_t)0.916679060f,
   (float16_t)-0.402434651f,  (float16_t)0.915448716f,
   (float16_t)-0.405241314f,  (float16_t)0.914209756f,
   (float16_t)-0.408044163f,  (float16_t)0.912962190f,
   (float16_t)-0.410843171f,  (float16_t)0.911706032f,
   (float16_t)-0.413638312f,  (float16_t)0.910441292f,
   (float16_t)-0.416429560f,  (float16_t)0.909167983f,
   (float16_t)-0.419216888f,  (float16_t)0.907886116f,
   (float16_t)-0.422000271f,  (float16_t)0.906595705f,
   (float16_t)-0.424779681f,  (float16_t)0.905296759f,
   (float16_t)-0.427555093f,  (float16_t)0.903989293f,
   (float16_t)-0.430326481f,  (float16_t)0.902673318f,
   (float16_t)-0.433093819f,  (float16_t)0.901348847f,
   (float16_t)-0.435857080f,  (float16_t)0.900015892f,
   (float16_t)-0.438616239f,  (float16_t)0.898674466f,
   (float16_t)-0.441371269f,  (float16_t)0.897324581f,
   (float16_t)-0.444122145f,  (float16_t)0.895966250f,
   (float16_t)-0.446868840f,  (float16_t)0.894599486f,
   (float16_t)-0.449611330f,  (float16_t)0.893224301f,
   (float16_t)-0.452349587f,  (float16_t)0.891840709f,
   (float16_t)-0.455083587f,  (float16_t)0.890448723f,
   (float16_t)-0.457813304f,  (float16_t)0.889048356f,
   (float16_t)-0.460538711f,  (float16_t)0.887639620f,
   (float16_t)-0.463259784f,  (float16_t)0.886222530f,
   (float16_t)-0.465976496f,  (float16_t)0.884797098f,
   (float16_t)-0.468688822f,  (float16_t)0.883363339f,
   (float16_t)-0.471396737f,  (float16_t)0.881921264f,
   (float16_t)-0.474100215f,  (float16_t)0.880470889f,
   (float16_t)-0.476799230f,  (float16_t)0.879012226f,
   (float16_t)-0.479493758f,  (float16_t)0.877545290f,
   (float16_t)-0.482183772f,  (float16_t)0.876070094f,
   (float16_t)-0.484869248f,  (float16_t)0.874586652f,
   (float16_t)-0.487550160f,  (float16_t)0.873094978f,
   (float16_t)-0.490226483f,  (float16_t)0.871595087f,
   (float16_t)-0.492898192f,  (float16_t)0.870086991f,
   (float16_t)-0.495565262f,  (float16_t)0.868570706f,
   (float16_t)-0.498227667f,  (float16_t)0.867046246f,
   (float16_t)-0.500885383f,  (float16_t)0.865513624f,
   (float16_t)-0.503538384f,  (float16_t)0.863972856f,
   (float16_t)-0.506186645f,  (float16_t)0.862423956f,
   (float16_t)-0.508830143f,  (float16_t)0.860866939f,
   (float16_t)-0.511468850f,  (float16_t)0.859301818f,
   (float16_t)-0.514102744f,  (float16_t)0.857728610f,
   (float16_t)-0.516731799f,  (float16_t)0.856147328f,
   (float16_t)-0.519355990f,  (float16_t)0.854557988f,
   (float16_t)-0.521975293f,  (float16_t)0.852960605f,
   (float16_t)-0.524589683f,  (float16_t)0.851355193f,
   (float16_t)-0.527199135f,  (float16_t)0.849741768f,
   (float16_t)-0.529803625f,  (float16_t)0.848120345f,
   (float16_t)-0.532403128f,  (float16_t)0.846490939f,
   (float16_t)-0.534997620f,  (float16_t)0.844853565f,
   (float16_t)-0.537587076f,  (float16_t)0.843208240f,
   (float16_t)-0.540171473f,  (float16_t)0.841554977f,
   (float16_t)-0.542750785f,  (float16_t)0.839893794f,
   (float16_t)-0.545324988f,  (float16_t)0.838224706f,
   (float16_t)-0.547894059f,  (float16_t)0.836547727f,
   (float16_t)-0.550457973f,  (float16_t)0.834862875f,
   (float16_t)-0.553016706f,  (float16_t)0.833170165f,
   (float16_t)-0.555570233f,  (float16_t)0.831469612f,
   (float16_t)-0.558118531f,  (float16_t)0.829761234f,
   (float16_t)-0.560661576f,  (float16_t)0.828045045f,
   (float16_t)-0.563199344f,  (float16_t)0.826321063f,
   (float16_t)-0.565731811f,  (float16_t)0.824589303f,
   (float16_t)-0.568258953f,  (float16_t)0.822849781f,
   (float16_t)-0.570780746f,  (float16_t)0.821102515f,
   (float16_t)-0.573297167f,  (float16_t)0.819347520f,
   (float16_t)-0.575808191f,  (float16_t)0.817584813f,
   (float16_t)-0.578313796f,  (float16_t)0.815814411f,
   (float16_t)-0.580813958f,  (float16_t)0.814036330f,
   (float16_t)-0.583308653f,  (float16_t)0.812250587f,
   (float16_t)-0.585797857f,  (float16_t)0.810457198f,
   (float16_t)-0.588281548f,  (float16_t)0.808656182f,
   (float16_t)-0.590759702f,  (float16_t)0.806847554f,
   (float16_t)-0.593232295f,  (float16_t)0.805031331f,
   (float16_t)-0.595699304f,  (float16_t)0.803207531f,
   (float16_t)-0.598160707f,  (float16_t)0.801376172f,
   (float16_t)-0.600616479f,  (float16_t)0.799537269f,
   (float16_t)-0.603066599f,  (float16_t)0.797690841f,
   (float16_t)-0.605511041f,  (float16_t)0.795836905f,
   (float16_t)-0.607949785f,  (float16_t)0.793975478f,
   (float16_t)-0.610382806f,  (float16_t)0.792106577f,
   (float16_t)-0.612810082f,  (float16_t)0.790230221f,
   (float16_t)-0.615231591f,  (float16_t)0.788346428f,
   (float16_t)-0.617647308f,  (float16_t)0.786455214f,
   (float16_t)-0.620057212f,  (float16_t)0.784556597f,
   (float16_t)-0.622461279f,  (float16_t)0.782650596f,
   (float16_t)-0.624859488f,  (float16_t)0.780737229f,
   (float16_t)-0.627251815f,  (float16_t)0.778816512f,
   (float16_t)-0.629638239f,  (float16_t)0.776888466f,
   (float16_t)-0.632018736f,  (float16_t)0.774953107f,
   (float16_t)-0.634393284f,  (float16_t)0.773010453f,
   (float16_t)-0.636761861f,  (float16_t)0.771060524f,
   (float16_t)-0.639124445f,  (float16_t)0.769103338f,
   (float16_t)-0.641481013f,  (float16_t)0.767138912f,
   (float16_t)-0.643831543f,  (float16_t)0.765167266f,
   (float16_t)-0.646176013f,  (float16_t)0.763188417f,
   (float16_t)-0.648514401f,  (float16_t)0.761202385f,
   (float16_t)-0.650846685f,  (float16_t)0.759209189f,
   (float16_t)-0.653172843f,  (float16_t)0.757208847f,
   (float16_t)-0.655492853f,  (float16_t)0.755201377f,
   (float16_t)-0.657806693f,  (float16_t)0.753186799f,
   (float16_t)-0.660114342f,  (float16_t)0.751165132f,
   (float16_t)-0.662415778f,  (float16_t)0.749136395f,
   (float16_t)-0.664710978f,  (float16_t)0.747100606f,
   (float16_t)-0.666999922f,  (float16_t)0.745057785f,
   (float16_t)-0.669282588f,  (float16_t)0.743007952f,
   (float16_t)-0.671558955f,  (float16_t)0.740951125f,
   (float16_t)-0.673829000f,  (float16_t)0.738887324f,
   (float16_t)-0.676092704f,  (float16_t)0.736816569f,
   (float16_t)-0.678350043f,  (float16_t)0.734738878f,
   (float16_t)-0.680600998f,  (float16_t)0.732654272f,
   (float16_t)-0.682845546f,  (float16_t)0.730562769f,
   (float16_t)-0.685083668f,  (float16_t)0.728464390f,
   (float16_t)-0.687315341f,  (float16_t)0.726359155f,
   (float16_t)-0.689540545f,  (float16_t)0.724247083f,
   (float16_t)-0.691759258f,  (float16_t)0.722128194f,
   (float16_t)-0.693971461f,  (float16_t)0.720002508f,
   (float16_t)-0.696177131f,  (float16_t)0.717870045f,
   (float16_t)-0.698376249f,  (float16_t)0.715730825f,
   (float16_t)-0.700568794f,  (float16_t)0.713584869f,
   (float16_t)-0.702754744f,  (float16_t)0.711432196f,
   (float16_t)-0.704934080f,  (float16_t)0.709272826f,
   (float16_t)-0.707106781f,  (float16_t)0.707106781f,
   (float16_t)-0.709272826f,  (float16_t)0.704934080f,
   (float16_t)-0.711432196f,  (float16_t)0.702754744f,
   (float16_t)-0.713584869f,  (float16_t)0.700568794f,
   (float16_t)-0.715730825f,  (float16_t)0.698376249f,
   (float16_t)-0.717870045f,  (float16_t)0.696177131f,
   (float16_t)-0.720002508f,  (float16_t)0.693971461f,
   (float16_t)-0.722128194f,  (float16_t)0.691759258f,
   (float16_t)-0.724247083f,  (float16_t)0.689540545f,
   (float16_t)-0.726359155f,  (float16_t)0.687315341f,
   (float16_t)-0.728464390f,  (float16_t)0.685083668f,
   (float16_t)-0.730562769f,  (float16_t)0.682845546f,
   (float16_t)-0.732654272f,  (float16_t)0.680600998f,
   (float16_t)-0.734738878f,  (float16_t)0.678350043f,
   (float16_t)-0.736816569f,  (float16_t)0.676092704f,
   (float16_t)-0.738887324f,  (float16_t)0.673829000f,
   (float16_t)-0.740951125f,  (float16_t)0.671558955f,
   (float16_t)-0.743007952f,  (float16_t)0.669282588f,
   (float16_t)-0.745057785f,  (float16_t)0.666999922f,
   (float16_t)-0.747100606f,  (float16_t)0.664710978f,
   (float16_t)-0.749136395f,  (float16_t)0.662415778f,
   (float16_t)-0.751165132f,  (float16_t)0.660114342f,
   (float16_t)-0.753186799f,  (float16_t)0.657806693f,
   (float16_t)-0.755201377f,  (float16_t)0.655492853f,
   (float16_t)-0.757208847f,  (float16_t)0.653172843f,
   (float16_t)-0.759209189f,  (float16_t)0.650846685f,
   (float16_t)-0.761202385f,  (float16_t)0.648514401f,
   (float16_t)-0.763188417f,  (float16_t)0.646176013f,
   (float16_t)-0.765167266f,  (float16_t)0.643831543f,
   (float16_t)-0.767138912f,  (float16_t)0.641481013f,
   (float16_t)-0.769103338f,  (float16_t)0.639124445f,
   (float16_t)-0.771060524f,  (float16_t)0.636761861f,
   (float16_t)-0.773010453f,  (float16_t)0.634393284f,
   (float16_t)-0.774953107f,  (float16_t)0.632018736f,
   (float16_t)-0.776888466f,  (float16_t)0.629638239f,
   (float16_t)-0.778816512f,  (float16_t)0.627251815f,
   (float16_t)-0.780737229f,  (float16_t)0.624859488f,
   (float16_t)-0.782650596f,  (float16_t)0.622461279f,
   (float16_t)-0.784556597f,  (float16_t)0.620057212f,
   (float16_t)-0.786455214f,  (float16_t)0.617647308f,
   (float16_t)-0.788346428f,  (float16_t)0.615231591f,
   (float16_t)-0.790230221f,  (float16_t)0.612810082f,
   (float16_t)-0.792106577f,  (float16_t)0.610382806f,
   (float16_t)-0.793975478f,  (float16_t)0.607949785f,
   (float16_t)-0.795836905f,  (float16_t)0.605511041f,
   (float16_t)-0.797690841f,  (float16_t)0.603066599f,
   (float16_t)-0.799537269f,  (float16_t)0.600616479f,
   (float16_t)-0.801376172f,  (float16_t)0.598160707f,
   (float16_t)-0.803207531f,  (float16_t)0.595699304f,
   (float16_t)-0.805031331f,  (float16_t)0.593232295f,
   (float16_t)-0.806847554f,  (float16_t)0.590759702f,
   (float16_t)-0.808656182f,  (float16_t)0.588281548f,
   (float16_t)-0.810457198f,  (float16_t)0.585797857f,
   (float16_t)-0.812250587f,  (float16_t)0.583308653f,
   (float16_t)-0.814036330f,  (float16_t)0.580813958f,
   (float16_t)-0.815814411f,  (float16_t)0.578313796f,
   (float16_t)-0.817584813f,  (float16_t)0.575808191f,
   (float16_t)-0.819347520f,  (float16_t)0.573297167f,
   (float16_t)-0.821102515f,  (float16_t)0.570780746f,
   (float16_t)-0.822849781f,  (float16_t)0.568258953f,
   (float16_t)-0.824589303f,  (float16_t)0.565731811f,
   (float16_t)-0.826321063f,  (float16_t)0.563199344f,
   (float16_t)-0.828045045f,  (float16_t)0.560661576f,
   (float16_t)-0.829761234f,  (float16_t)0.558118531f,
   (float16_t)-0.831469612f,  (float16_t)0.555570233f,
   (float16_t)-0.833170165f,  (float16_t)0.553016706f,
   (float16_t)-0.834862875f,  (float16_t)0.550457973f,
   (float16_t)-0.836547727f,  (float16_t)0.547894059f,
   (float16_t)-0.838224706f,  (float16_t)0.545324988f,
   (float16_t)-0.839893794f,  (float16_t)0.542750785f,
   (float16_t)-0.841554977f,  (float16_t)0.540171473f,
   (float16_t)-0.843208240f,  (float16_t)0.537587076f,
   (float16_t)-0.844853565f,  (float16_t)0.534997620f,
   (float16_t)-0.846490939f,  (float16_t)0.532403128f,
   (float16_t)-0.848120345f,  (float16_t)0.529803625f,
   (float16_t)-0.849741768f,  (float16_t)0.527199135f,
   (float16_t)-0.851355193f,  (float16_t)0.524589683f,
   (float16_t)-0.852960605f,  (float16_t)0.521975293f,
   (float16_t)-0.854557988f,  (float16_t)0.519355990f,
   (float16_t)-0.856147328f,  (float16_t)0.516731799f,
   (float16_t)-0.857728610f,  (float16_t)0.514102744f,
   (float16_t)-0.859301818f,  (float16_t)0.511468850f,
   (float16_t)-0.860866939f,  (float16_t)0.508830143f,
   (float16_t)-0.862423956f,  (float16_t)0.506186645f,
   (float16_t)-0.863972856f,  (float16_t)0.503538384f,
   (float16_t)-0.865513624f,  (float16_t)0.500885383f,
   (float16_t)-0.867046246f,  (float16_t)0.498227667f,
   (float16_t)-0.868570706f,  (float16_t)0.495565262f,
   (float16_t)-0.870086991f,  (float16_t)0.492898192f,
   (float16_t)-0.871595087f,  (float16_t)0.490226483f,
   (float16_t)-0.873094978f,  (float16_t)0.487550160f,
   (float16_t)-0.874586652f,  (float16_t)0.484869248f,
   (float16_t)-0.876070094f,  (float16_t)0.482183772f,
   (float16_t)-0.877545290f,  (float16_t)0.479493758f,
   (float16_t)-0.879012226f,  (float16_t)0.476799230f,
   (float16_t)-0.880470889f,  (float16_t)0.474100215f,
   (float16_t)-0.881921264f,  (float16_t)0.471396737f,
   (float16_t)-0.883363339f,  (float16_t)0.468688822f,
   (float16_t)-0.884797098f,  (float16_t)0.465976496f,
   (float16_t)-0.886222530f,  (float16_t)0.463259784f,
   (float16_t)-0.887639620f,  (float16_t)0.460538711f,
   (float16_t)-0.889048356f,  (float16_t)0.457813304f,
   (float16_t)-0.890448723f,  (float16_t)0.455083587f,
   (float16_t)-0.891840709f,  (float16_t)0.452349587f,
   (float16_t)-0.893224301f,  (float16_t)0.449611330f,
   (float16_t)-0.894599486f,  (float16_t)0.446868840f,
   (float16_t)-0.895966250f,  (float16_t)0.444122145f,
   (float16_t)-0.897324581f,  (float16_t)0.441371269f,
   (float16_t)-0.898674466f,  (float16_t)0.438616239f,
   (float16_t)-0.900015892f,  (float16_t)0.435857080f,
   (float16_t)-0.901348847f,  (float16_t)0.433093819f,
   (float16_t)-0.902673318f,  (float16_t)0.430326481f,
   (float16_t)-0.903989293f,  (float16_t)0.427555093f,
   (float16_t)-0.905296759f,  (float16_t)0.424779681f,
   (float16_t)-0.906595705f,  (float16_t)0.422000271f,
   (float16_t)-0.907886116f,  (float16_t)0.419216888f,
   (float16_t)-0.909167983f,  (float16_t)0.416429560f,
   (float16_t)-0.910441292f,  (float16_t)0.413638312f,
   (float16_t)-0.911706032f,  (float16_t)0.410843171f,
   (float16_t)-0.912962190f,  (float16_t)0.408044163f,
   (float16_t)-0.914209756f,  (float16_t)0.405241314f,
   (float16_t)-0.915448716f,  (float16_t)0.402434651f,
   (float16_t)-0.916679060f,  (float16_t)0.399624200f,
   (float16_t)-0.917900776f,  (float16_t)0.396809987f,
   (float16_t)-0.919113852f,  (float16_t)0.393992040f,
   (float16_t)-0.920318277f,  (float16_t)0.391170384f,
   (float16_t)-0.921514039f,  (float16_t)0.388345047f,
   (float16_t)-0.922701128f,  (float16_t)0.385516054f,
   (float16_t)-0.923879533f,  (float16_t)0.382683432f,
   (float16_t)-0.925049241f,  (float16_t)0.379847209f,
   (float16_t)-0.926210242f,  (float16_t)0.377007410f,
   (float16_t)-0.927362526f,  (float16_t)0.374164063f,
   (float16_t)-0.928506080f,  (float16_t)0.371317194f,
   (float16_t)-0.929640896f,  (float16_t)0.368466830f,
   (float16_t)-0.930766961f,  (float16_t)0.365612998f,
   (float16_t)-0.931884266f,  (float16_t)0.362755724f,
   (float16_t)-0.932992799f,  (float16_t)0.359895037f,
   (float16_t)-0.934092550f,  (float16_t)0.357030961f,
   (float16_t)-0.935183510f,  (float16_t)0.354163525f,
   (float16_t)-0.936265667f,  (float16_t)0.351292756f,
   (float16_t)-0.937339012f,  (float16_t)0.348418680f,
   (float16_t)-0.938403534f,  (float16_t)0.345541325f,
   (float16_t)-0.939459224f,  (float16_t)0.342660717f,
   (float16_t)-0.940506071f,  (float16_t)0.339776884f,
   (float16_t)-0.941544065f,  (float16_t)0.336889853f,
   (float16_t)-0.942573198f,  (float16_t)0.333999651f,
   (float16_t)-0.943593458f,  (float16_t)0.331106306f,
   (float16_t)-0.944604837f,  (float16_t)0.328209844f,
   (float16_t)-0.945607325f,  (float16_t)0.325310292f,
   (float16_t)-0.946600913f,  (float16_t)0.322407679f,
   (float16_t)-0.947585591f,  (float16_t)0.319502031f,
   (float16_t)-0.948561350f,  (float16_t)0.316593376f,
   (float16_t)-0.949528181f,  (float16_t)0.313681740f,
   (float16_t)-0.950486074f,  (float16_t)0.310767153f,
   (float16_t)-0.951435021f,  (float16_t)0.307849640f,
   (float16_t)-0.952375013f,  (float16_t)0.304929230f,
   (float16_t)-0.953306040f,  (float16_t)0.302005949f,
   (float16_t)-0.954228095f,  (float16_t)0.299079826f,
   (float16_t)-0.955141168f,  (float16_t)0.296150888f,
   (float16_t)-0.956045251f,  (float16_t)0.293219163f,
   (float16_t)-0.956940336f,  (float16_t)0.290284677f,
   (float16_t)-0.957826413f,  (float16_t)0.287347460f,
   (float16_t)-0.958703475f,  (float16_t)0.284407537f,
   (float16_t)-0.959571513f,  (float16_t)0.281464938f,
   (float16_t)-0.960430519f,  (float16_t)0.278519689f,
   (float16_t)-0.961280486f,  (float16_t)0.275571819f,
   (float16_t)-0.962121404f,  (float16_t)0.272621355f,
   (float16_t)-0.962953267f,  (float16_t)0.269668326f,
   (float16_t)-0.963776066f,  (float16_t)0.266712757f,
   (float16_t)-0.964589793f,  (float16_t)0.263754679f,
   (float16_t)-0.965394442f,  (float16_t)0.260794118f,
   (float16_t)-0.966190003f,  (float16_t)0.257831102f,
   (float16_t)-0.966976471f,  (float16_t)0.254865660f,
   (float16_t)-0.967753837f,  (float16_t)0.251897818f,
   (float16_t)-0.968522094f,  (float16_t)0.248927606f,
   (float16_t)-0.969281235f,  (float16_t)0.245955050f,
   (float16_t)-0.970031253f,  (float16_t)0.242980180f,
   (float16_t)-0.970772141f,  (float16_t)0.240003022f,
   (float16_t)-0.971503891f,  (float16_t)0.237023606f,
   (float16_t)-0.972226497f,  (float16_t)0.234041959f,
   (float16_t)-0.972939952f,  (float16_t)0.231058108f,
   (float16_t)-0.973644250f,  (float16_t)0.228072083f,
   (float16_t)-0.974339383f,  (float16_t)0.225083911f,
   (float16_t)-0.975025345f,  (float16_t)0.222093621f,
   (float16_t)-0.975702130f,  (float16_t)0.219101240f,
   (float16_t)-0.976369731f,  (float16_t)0.216106797f,
   (float16_t)-0.977028143f,  (float16_t)0.213110320f,
   (float16_t)-0.977677358f,  (float16_t)0.210111837f,
   (float16_t)-0.978317371f,  (float16_t)0.207111376f,
   (float16_t)-0.978948175f,  (float16_t)0.204108966f,
   (float16_t)-0.979569766f,  (float16_t)0.201104635f,
   (float16_t)-0.980182136f,  (float16_t)0.198098411f,
   (float16_t)-0.980785280f,  (float16_t)0.195090322f,
   (float16_t)-0.981379193f,  (float16_t)0.192080397f,
   (float16_t)-0.981963869f,  (float16_t)0.189068664f,
   (float16_t)-0.982539302f,  (float16_t)0.186055152f,
   (float16_t)-0.983105487f,  (float16_t)0.183039888f,
   (float16_t)-0.983662419f,  (float16_t)0.180022901f,
   (float16_t)-0.984210092f,  (float16_t)0.177004220f,
   (float16_t)-0.984748502f,  (float16_t)0.173983873f,
   (float16_t)-0.985277642f,  (float16_t)0.170961889f,
   (float16_t)-0.985797509f,  (float16_t)0.167938295f,
   (float16_t)-0.986308097f,  (float16_t)0.164913120f,
   (float16_t)-0.986809402f,  (float16_t)0.161886394f,
   (float16_t)-0.987301418f,  (float16_t)0.158858143f,
   (float16_t)-0.987784142f,  (float16_t)0.155828398f,
   (float16_t)-0.988257568f,  (float16_t)0.152797185f,
   (float16_t)-0.988721692f,  (float16_t)0.149764535f,
   (float16_t)-0.989176510f,  (float16_t)0.146730474f,
   (float16_t)-0.989622017f,  (float16_t)0.143695033f,
   (float16_t)-0.990058210f,  (float16_t)0.140658239f,
   (float16_t)-0.990485084f,  (float16_t)0.137620122f,
   (float16_t)-0.990902635f,  (float16_t)0.134580709f,
   (float16_t)-0.991310860f,  (float16_t)0.131540029f,
   (float16_t)-0.991709754f,  (float16_t)0.128498111f,
   (float16_t)-0.992099313f,  (float16_t)0.125454983f,
   (float16_t)-0.992479535f,  (float16_t)0.122410675f,
   (float16_t)-0.992850414f,  (float16_t)0.119365215f,
   (float16_t)-0.993211949f,  (float16_t)0.116318631f,
   (float16_t)-0.993564136f,  (float16_t)0.113270952f,
   (float16_t)-0.993906970f,  (float16_t)0.110222207f,
   (float16_t)-0.994240449f,  (float16_t)0.107172425f,
   (float16_t)-0.994564571f,  (float16_t)0.104121634f,
   (float16_t)-0.994879331f,  (float16_t)0.101069863f,
   (float16_t)-0.995184727f,  (float16_t)0.098017140f,
   (float16_t)-0.995480755f,  (float16_t)0.094963495f,
   (float16_t)-0.995767414f,  (float16_t)0.091908956f,
   (float16_t)-0.996044701f,  (float16_t)0.088853553f,
   (float16_t)-0.996312612f,  (float16_t)0.085797312f,
   (float16_t)-0.996571146f,  (float16_t)0.082740265f,
   (float16_t)-0.996820299f,  (float16_t)0.079682438f,
   (float16_t)-0.997060070f,  (float16_t)0.076623861f,
   (float16_t)-0.997290457f,  (float16_t)0.073564564f,
   (float16_t)-0.997511456f,  (float16_t)0.070504573f,
   (float16_t)-0.997723067f,  (float16_t)0.067443920f,
   (float16_t)-0.997925286f,  (float16_t)0.064382631f,
   (float16_t)-0.998118113f,  (float16_t)0.061320736f,
   (float16_t)-0.998301545f,  (float16_t)0.058258265f,
   (float16_t)-0.998475581f,  (float16_t)0.055195244f,
   (float16_t)-0.998640218f,  (float16_t)0.052131705f,
   (float16_t)-0.998795456f,  (float16_t)0.049067674f,
   (float16_t)-0.998941293f,  (float16_t)0.046003182f,
   (float16_t)-0.999077728f,  (float16_t)0.042938257f,
   (float16_t)-0.999204759f,  (float16_t)0.039872928f,
   (float16_t)-0.999322385f,  (float16_t)0.036807223f,
   (float16_t)-0.999430605f,  (float16_t)0.033741172f,
   (float16_t)-0.999529418f,  (float16_t)0.030674803f,
   (float16_t)-0.999618822f,  (float16_t)0.027608146f,
   (float16_t)-0.999698819f,  (float16_t)0.024541229f,
   (float16_t)-0.999769405f,  (float16_t)0.021474080f,
   (float16_t)-0.999830582f,  (float16_t)0.018406730f,
   (float16_t)-0.999882347f,  (float16_t)0.015339206f,
   (float16_t)-0.999924702f,  (float16_t)0.012271538f,
   (float16_t)-0.999957645f,  (float16_t)0.009203755f,
   (float16_t)-0.999981175f,  (float16_t)0.006135885f,
   (float16_t)-0.999995294f,  (float16_t)0.003067957f,
   (float16_t)-1.000000000f,  (float16_t)0.000000000f,
   (float16_t)-0.999995294f, (float16_t)-0.003067957f,
   (float16_t)-0.999981175f, (float16_t)-0.006135885f,
   (float16_t)-0.999957645f, (float16_t)-0.009203755f,
   (float16_t)-0.999924702f, (float16_t)-0.012271538f,
   (float16_t)-0.999882347f, (float16_t)-0.015339206f,
   (float16_t)-0.999830582f, (float16_t)-0.018406730f,
   (float16_t)-0.999769405f, (float16_t)-0.021474080f,
   (float16_t)-0.999698819f, (float16_t)-0.024541229f,
   (float16_t)-0.999618822f, (float16_t)-0.027608146f,
   (float16_t)-0.999529418f, (float16_t)-0.030674803f,
   (float16_t)-0.999430605f, (float16_t)-0.033741172f,
   (float16_t)-0.999322385f, (float16_t)-0.036807223f,
   (float16_t)-0.999204759f, (float16_t)-0.039872928f,
   (float16_t)-0.999077728f, (float16_t)-0.042938257f,
   (float16_t)-0.998941293f, (float16_t)-0.046003182f,
   (float16_t)-0.998795456f, (float16_t)-0.049067674f,
   (float16_t)-0.998640218f, (float16_t)-0.052131705f,
   (float16_t)-0.998475581f, (float16_t)-0.055195244f,
   (float16_t)-0.998301545f, (float16_t)-0.058258265f,
   (float16_t)-0.998118113f, (float16_t)-0.061320736f,
   (float16_t)-0.997925286f, (float16_t)-0.064382631f,
   (float16_t)-0.997723067f, (float16_t)-0.067443920f,
   (float16_t)-0.997511456f, (float16_t)-0.070504573f,
   (float16_t)-0.997290457f, (float16_t)-0.073564564f,
   (float16_t)-0.997060070f, (float16_t)-0.076623861f,
   (float16_t)-0.996820299f, (float16_t)-0.079682438f,
   (float16_t)-0.996571146f, (float16_t)-0.082740265f,
   (float16_t)-0.996312612f, (float16_t)-0.085797312f,
   (float16_t)-0.996044701f, (float16_t)-0.088853553f,
   (float16_t)-0.995767414f, (float16_t)-0.091908956f,
   (float16_t)-0.995480755f, (float16_t)-0.094963495f,
   (float16_t)-0.995184727f, (float16_t)-0.098017140f,
   (float16_t)-0.994879331f, (float16_t)-0.101069863f,
   (float16_t)-0.994564571f, (float16_t)-0.104121634f,
   (float16_t)-0.994240449f, (float16_t)-0.107172425f,
   (float16_t)-0.993906970f, (float16_t)-0.110222207f,
   (float16_t)-0.993564136f, (float16_t)-0.113270952f,
   (float16_t)-0.993211949f, (float16_t)-0.116318631f,
   (float16_t)-0.992850414f, (float16_t)-0.119365215f,
   (float16_t)-0.992479535f, (float16_t)-0.122410675f,
   (float16_t)-0.992099313f, (float16_t)-0.125454983f,
   (float16_t)-0.991709754f, (float16_t)-0.128498111f,
   (float16_t)-0.991310860f, (float16_t)-0.131540029f,
   (float16_t)-0.990902635f, (float16_t)-0.134580709f,
   (float16_t)-0.990485084f, (float16_t)-0.137620122f,
   (float16_t)-0.990058210f, (float16_t)-0.140658239f,
   (float16_t)-0.989622017f, (float16_t)-0.143695033f,
   (float16_t)-0.989176510f, (float16_t)-0.146730474f,
   (float16_t)-0.988721692f, (float16_t)-0.149764535f,
   (float16_t)-0.988257568f, (float16_t)-0.152797185f,
   (float16_t)-0.987784142f, (float16_t)-0.155828398f,
   (float16_t)-0.987301418f, (float16_t)-0.158858143f,
   (float16_t)-0.986809402f, (float16_t)-0.161886394f,
   (float16_t)-0.986308097f, (float16_t)-0.164913120f,
   (float16_t)-0.985797509f, (float16_t)-0.167938295f,
   (float16_t)-0.985277642f, (float16_t)-0.170961889f,
   (float16_t)-0.984748502f, (float16_t)-0.173983873f,
   (float16_t)-0.984210092f, (float16_t)-0.177004220f,
   (float16_t)-0.983662419f, (float16_t)-0.180022901f,
   (float16_t)-0.983105487f, (float16_t)-0.183039888f,
   (float16_t)-0.982539302f, (float16_t)-0.186055152f,
   (float16_t)-0.981963869f, (float16_t)-0.189068664f,
   (float16_t)-0.981379193f, (float16_t)-0.192080397f,
   (float16_t)-0.980785280f, (float16_t)-0.195090322f,
   (float16_t)-0.980182136f, (float16_t)-0.198098411f,
   (float16_t)-0.979569766f, (float16_t)-0.201104635f,
   (float16_t)-0.978948175f, (float16_t)-0.204108966f,
   (float16_t)-0.978317371f, (float16_t)-0.207111376f,
   (float16_t)-0.977677358f, (float16_t)-0.210111837f,
   (float16_t)-0.977028143f, (float16_t)-0.213110320f,
   (float16_t)-0.976369731f, (float16_t)-0.216106797f,
   (float16_t)-0.975702130f, (float16_t)-0.219101240f,
   (float16_t)-0.975025345f, (float16_t)-0.222093621f,
   (float16_t)-0.974339383f, (float16_t)-0.225083911f,
   (float16_t)-0.973644250f, (float16_t)-0.228072083f,
   (float16_t)-0.972939952f, (float16_t)-0.231058108f,
   (float16_t)-0.972226497f, (float16_t)-0.234041959f,
   (float16_t)-0.971503891f, (float16_t)-0.237023606f,
   (float16_t)-0.970772141f, (float16_t)-0.240003022f,
   (float16_t)-0.970031253f, (float16_t)-0.242980180f,
   (float16_t)-0.969281235f, (float16_t)-0.245955050f,
   (float16_t)-0.968522094f, (float16_t)-0.248927606f,
   (float16_t)-0.967753837f, (float16_t)-0.251897818f,
   (float16_t)-0.966976471f, (float16_t)-0.254865660f,
   (float16_t)-0.966190003f, (float16_t)-0.257831102f,
   (float16_t)-0.965394442f, (float16_t)-0.260794118f,
   (float16_t)-0.964589793f, (float16_t)-0.263754679f,
   (float16_t)-0.963776066f, (float16_t)-0.266712757f,
   (float16_t)-0.962953267f, (float16_t)-0.269668326f,
   (float16_t)-0.962121404f, (float16_t)-0.272621355f,
   (float16_t)-0.961280486f, (float16_t)-0.275571819f,
   (float16_t)-0.960430519f, (float16_t)-0.278519689f,
   (float16_t)-0.959571513f, (float16_t)-0.281464938f,
   (float16_t)-0.958703475f, (float16_t)-0.284407537f,
   (float16_t)-0.957826413f, (float16_t)-0.287347460f,
   (float16_t)-0.956940336f, (float16_t)-0.290284677f,
   (float16_t)-0.956045251f, (float16_t)-0.293219163f,
   (float16_t)-0.955141168f, (float16_t)-0.296150888f,
   (float16_t)-0.954228095f, (float16_t)-0.299079826f,
   (float16_t)-0.953306040f, (float16_t)-0.302005949f,
   (float16_t)-0.952375013f, (float16_t)-0.304929230f,
   (float16_t)-0.951435021f, (float16_t)-0.307849640f,
   (float16_t)-0.950486074f, (float16_t)-0.310767153f,
   (float16_t)-0.949528181f, (float16_t)-0.313681740f,
   (float16_t)-0.948561350f, (float16_t)-0.316593376f,
   (float16_t)-0.947585591f, (float16_t)-0.319502031f,
   (float16_t)-0.946600913f, (float16_t)-0.322407679f,
   (float16_t)-0.945607325f, (float16_t)-0.325310292f,
   (float16_t)-0.944604837f, (float16_t)-0.328209844f,
   (float16_t)-0.943593458f, (float16_t)-0.331106306f,
   (float16_t)-0.942573198f, (float16_t)-0.333999651f,
   (float16_t)-0.941544065f, (float16_t)-0.336889853f,
   (float16_t)-0.940506071f, (float16_t)-0.339776884f,
   (float16_t)-0.939459224f, (float16_t)-0.342660717f,
   (float16_t)-0.938403534f, (float16_t)-0.345541325f,
   (float16_t)-0.937339012f, (float16_t)-0.348418680f,
   (float16_t)-0.936265667f, (float16_t)-0.351292756f,
   (float16_t)-0.935183510f, (float16_t)-0.354163525f,
   (float16_t)-0.934092550f, (float16_t)-0.357030961f,
   (float16_t)-0.932992799f, (float16_t)-0.359895037f,
   (float16_t)-0.931884266f, (float16_t)-0.362755724f,
   (float16_t)-0.930766961f, (float16_t)-0.365612998f,
   (float16_t)-0.929640896f, (float16_t)-0.368466830f,
   (float16_t)-0.928506080f, (float16_t)-0.371317194f,
   (float16_t)-0.927362526f, (float16_t)-0.374164063f,
   (float16_t)-0.926210242f, (float16_t)-0.377007410f,
   (float16_t)-0.925049241f, (float16_t)-0.379847209f,
   (float16_t)-0.923879533f, (float16_t)-0.382683432f,
   (float16_t)-0.922701128f, (float16_t)-0.385516054f,
   (float16_t)-0.921514039f, (float16_t)-0.388345047f,
   (float16_t)-0.920318277f, (float16_t)-0.391170384f,
   (float16_t)-0.919113852f, (float16_t)-0.393992040f,
   (float16_t)-0.917900776f, (float16_t)-0.396809987f,
   (float16_t)-0.916679060f, (float16_t)-0.399624200f,
   (float16_t)-0.915448716f, (float16_t)-0.402434651f,
   (float16_t)-0.914209756f, (float16_t)-0.405241314f,
   (float16_t)-0.912962190f, (float16_t)-0.408044163f,
   (float16_t)-0.911706032f, (float16_t)-0.410843171f,
   (float16_t)-0.910441292f, (float16_t)-0.413638312f,
   (float16_t)-0.909167983f, (float16_t)-0.416429560f,
   (float16_t)-0.907886116f, (float16_t)-0.419216888f,
   (float16_t)-0.906595705f, (float16_t)-0.422000271f,
   (float16_t)-0.905296759f, (float16_t)-0.424779681f,
   (float16_t)-0.903989293f, (float16_t)-0.427555093f,
   (float16_t)-0.902673318f, (float16_t)-0.430326481f,
   (float16_t)-0.901348847f, (float16_t)-0.433093819f,
   (float16_t)-0.900015892f, (float16_t)-0.435857080f,
   (float16_t)-0.898674466f, (float16_t)-0.438616239f,
   (float16_t)-0.897324581f, (float16_t)-0.441371269f,
   (float16_t)-0.895966250f, (float16_t)-0.444122145f,
   (float16_t)-0.894599486f, (float16_t)-0.446868840f,
   (float16_t)-0.893224301f, (float16_t)-0.449611330f,
   (float16_t)-0.891840709f, (float16_t)-0.452349587f,
   (float16_t)-0.890448723f, (float16_t)-0.455083587f,
   (float16_t)-0.889048356f, (float16_t)-0.457813304f,
   (float16_t)-0.887639620f, (float16_t)-0.460538711f,
   (float16_t)-0.886222530f, (float16_t)-0.463259784f,
   (float16_t)-0.884797098f, (float16_t)-0.465976496f,
   (float16_t)-0.883363339f, (float16_t)-0.468688822f,
   (float16_t)-0.881921264f, (float16_t)-0.471396737f,
   (float16_t)-0.880470889f, (float16_t)-0.474100215f,
   (float16_t)-0.879012226f, (float16_t)-0.476799230f,
   (float16_t)-0.877545290f, (float16_t)-0.479493758f,
   (float16_t)-0.876070094f, (float16_t)-0.482183772f,
   (float16_t)-0.874586652f, (float16_t)-0.484869248f,
   (float16_t)-0.873094978f, (float16_t)-0.487550160f,
   (float16_t)-0.871595087f, (float16_t)-0.490226483f,
   (float16_t)-0.870086991f, (float16_t)-0.492898192f,
   (float16_t)-0.868570706f, (float16_t)-0.495565262f,
   (float16_t)-0.867046246f, (float16_t)-0.498227667f,
   (float16_t)-0.865513624f, (float16_t)-0.500885383f,
   (float16_t)-0.863972856f, (float16_t)-0.503538384f,
   (float16_t)-0.862423956f, (float16_t)-0.506186645f,
   (float16_t)-0.860866939f, (float16_t)-0.508830143f,
   (float16_t)-0.859301818f, (float16_t)-0.511468850f,
   (float16_t)-0.857728610f, (float16_t)-0.514102744f,
   (float16_t)-0.856147328f, (float16_t)-0.516731799f,
   (float16_t)-0.854557988f, (float16_t)-0.519355990f,
   (float16_t)-0.852960605f, (float16_t)-0.521975293f,
   (float16_t)-0.851355193f, (float16_t)-0.524589683f,
   (float16_t)-0.849741768f, (float16_t)-0.527199135f,
   (float16_t)-0.848120345f, (float16_t)-0.529803625f,
   (float16_t)-0.846490939f, (float16_t)-0.532403128f,
   (float16_t)-0.844853565f, (float16_t)-0.534997620f,
   (float16_t)-0.843208240f, (float16_t)-0.537587076f,
   (float16_t)-0.841554977f, (float16_t)-0.540171473f,
   (float16_t)-0.839893794f, (float16_t)-0.542750785f,
   (float16_t)-0.838224706f, (float16_t)-0.545324988f,
   (float16_t)-0.836547727f, (float16_t)-0.547894059f,
   (float16_t)-0.834862875f, (float16_t)-0.550457973f,
   (float16_t)-0.833170165f, (float16_t)-0.553016706f,
   (float16_t)-0.831469612f, (float16_t)-0.555570233f,
   (float16_t)-0.829761234f, (float16_t)-0.558118531f,
   (float16_t)-0.828045045f, (float16_t)-0.560661576f,
   (float16_t)-0.826321063f, (float16_t)-0.563199344f,
   (float16_t)-0.824589303f, (float16_t)-0.565731811f,
   (float16_t)-0.822849781f, (float16_t)-0.568258953f,
   (float16_t)-0.821102515f, (float16_t)-0.570780746f,
   (float16_t)-0.819347520f, (float16_t)-0.573297167f,
   (float16_t)-0.817584813f, (float16_t)-0.575808191f,
   (float16_t)-0.815814411f, (float16_t)-0.578313796f,
   (float16_t)-0.814036330f, (float16_t)-0.580813958f,
   (float16_t)-0.812250587f, (float16_t)-0.583308653f,
   (float16_t)-0.810457198f, (float16_t)-0.585797857f,
   (float16_t)-0.808656182f, (float16_t)-0.588281548f,
   (float16_t)-0.806847554f, (float16_t)-0.590759702f,
   (float16_t)-0.805031331f, (float16_t)-0.593232295f,
   (float16_t)-0.803207531f, (float16_t)-0.595699304f,
   (float16_t)-0.801376172f, (float16_t)-0.598160707f,
   (float16_t)-0.799537269f, (float16_t)-0.600616479f,
   (float16_t)-0.797690841f, (float16_t)-0.603066599f,
   (float16_t)-0.795836905f, (float16_t)-0.605511041f,
   (float16_t)-0.793975478f, (float16_t)-0.607949785f,
   (float16_t)-0.792106577f, (float16_t)-0.610382806f,
   (float16_t)-0.790230221f, (float16_t)-0.612810082f,
   (float16_t)-0.788346428f, (float16_t)-0.615231591f,
   (float16_t)-0.786455214f, (float16_t)-0.617647308f,
   (float16_t)-0.784556597f, (float16_t)-0.620057212f,
   (float16_t)-0.782650596f, (float16_t)-0.622461279f,
   (float16_t)-0.780737229f, (float16_t)-0.624859488f,
   (float16_t)-0.778816512f, (float16_t)-0.627251815f,
   (float16_t)-0.776888466f, (float16_t)-0.629638239f,
   (float16_t)-0.774953107f, (float16_t)-0.632018736f,
   (float16_t)-0.773010453f, (float16_t)-0.634393284f,
   (float16_t)-0.771060524f, (float16_t)-0.636761861f,
   (float16_t)-0.769103338f, (float16_t)-0.639124445f,
   (float16_t)-0.767138912f, (float16_t)-0.641481013f,
   (float16_t)-0.765167266f, (float16_t)-0.643831543f,
   (float16_t)-0.763188417f, (float16_t)-0.646176013f,
   (float16_t)-0.761202385f, (float16_t)-0.648514401f,
   (float16_t)-0.759209189f, (float16_t)-0.650846685f,
   (float16_t)-0.757208847f, (float16_t)-0.653172843f,
   (float16_t)-0.755201377f, (float16_t)-0.655492853f,
   (float16_t)-0.753186799f, (float16_t)-0.657806693f,
   (float16_t)-0.751165132f, (float16_t)-0.660114342f,
   (float16_t)-0.749136395f, (float16_t)-0.662415778f,
   (float16_t)-0.747100606f, (float16_t)-0.664710978f,
   (float16_t)-0.745057785f, (float16_t)-0.666999922f,
   (float16_t)-0.743007952f, (float16_t)-0.669282588f,
   (float16_t)-0.740951125f, (float16_t)-0.671558955f,
   (float16_t)-0.738887324f, (float16_t)-0.673829000f,
   (float16_t)-0.736816569f, (float16_t)-0.676092704f,
   (float16_t)-0.734738878f, (float16_t)-0.678350043f,
   (float16_t)-0.732654272f, (float16_t)-0.680600998f,
   (float16_t)-0.730562769f, (float16_t)-0.682845546f,
   (float16_t)-0.728464390f, (float16_t)-0.685083668f,
   (float16_t)-0.726359155f, (float16_t)-0.687315341f,
   (float16_t)-0.724247083f, (float16_t)-0.689540545f,
   (float16_t)-0.722128194f, (float16_t)-0.691759258f,
   (float16_t)-0.720002508f, (float16_t)-0.693971461f,
   (float16_t)-0.717870045f, (float16_t)-0.696177131f,
   (float16_t)-0.715730825f, (float16_t)-0.698376249f,
   (float16_t)-0.713584869f, (float16_t)-0.700568794f,
   (float16_t)-0.711432196f, (float16_t)-0.702754744f,
   (float16_t)-0.709272826f, (float16_t)-0.704934080f,
   (float16_t)-0.707106781f, (float16_t)-0.707106781f,
   (float16_t)-0.704934080f, (float16_t)-0.709272826f,
   (float16_t)-0.702754744f, (float16_t)-0.711432196f,
   (float16_t)-0.700568794f, (float16_t)-0.713584869f,
   (float16_t)-0.698376249f, (float16_t)-0.715730825f,
   (float16_t)-0.696177131f, (float16_t)-0.717870045f,
   (float16_t)-0.693971461f, (float16_t)-0.720002508f,
   (float16_t)-0.691759258f, (float16_t)-0.722128194f,
   (float16_t)-0.689540545f, (float16_t)-0.724247083f,
   (float16_t)-0.687315341f, (float16_t)-0.726359155f,
   (float16_t)-0.685083668f, (float16_t)-0.728464390f,
   (float16_t)-0.682845546f, (float16_t)-0.730562769f,
   (float16_t)-0.680600998f, (float16_t)-0.732654272f,
   (float16_t)-0.678350043f, (float16_t)-0.734738878f,
   (float16_t)-0.676092704f, (float16_t)-0.736816569f,
   (float16_t)-0.673829000f, (float16_t)-0.738887324f,
   (float16_t)-0.671558955f, (float16_t)-0.740951125f,
   (float16_t)-0.669282588f, (float16_t)-0.743007952f,
   (float16_t)-0.666999922f, (float16_t)-0.745057785f,
   (float16_t)-0.664710978f, (float16_t)-0.747100606f,
   (float16_t)-0.662415778f, (float16_t)-0.749136395f,
   (float16_t)-0.660114342f, (float16_t)-0.751165132f,
   (float16_t)-0.657806693f, (float16_t)-0.753186799f,
   (float16_t)-0.655492853f, (float16_t)-0.755201377f,
   (float16_t)-0.653172843f, (float16_t)-0.757208847f,
   (float16_t)-0.650846685f, (float16_t)-0.759209189f,
   (float16_t)-0.648514401f, (float16_t)-0.761202385f,
   (float16_t)-0.646176013f, (float16_t)-0.763188417f,
   (float16_t)-0.643831543f, (float16_t)-0.765167266f,
   (float16_t)-0.641481013f, (float16_t)-0.767138912f,
   (float16_t)-0.639124445f, (float16_t)-0.769103338f,
   (float16_t)-0.636761861f, (float16_t)-0.771060524f,
   (float16_t)-0.634393284f, (float16_t)-0.773010453f,
   (float16_t)-0.632018736f, (float16_t)-0.774953107f,
   (float16_t)-0.629638239f, (float16_t)-0.776888466f,
   (float16_t)-0.627251815f, (float16_t)-0.778816512f,
   (float16_t)-0.624859488f, (float16_t)-0.780737229f,
   (float16_t)-0.622461279f, (float16_t)-0.782650596f,
   (float16_t)-0.620057212f, (float16_t)-0.784556597f,
   (float16_t)-0.617647308f, (float16_t)-0.786455214f,
   (float16_t)-0.615231591f, (float16_t)-0.788346428f,
   (float16_t)-0.612810082f, (float16_t)-0.790230221f,
   (float16_t)-0.610382806f, (float16_t)-0.792106577f,
   (float16_t)-0.607949785f, (float16_t)-0.793975478f,
   (float16_t)-0.605511041f, (float16_t)-0.795836905f,
   (float16_t)-0.603066599f, (float16_t)-0.797690841f,
   (float16_t)-0.600616479f, (float16_t)-0.799537269f,
   (float16_t)-0.598160707f, (float16_t)-0.801376172f,
   (float16_t)-0.595699304f, (float16_t)-0.803207531f,
   (float16_t)-0.593232295f, (float16_t)-0.805031331f,
   (float16_t)-0.590759702f, (float16_t)-0.806847554f,
   (float16_t)-0.588281548f, (float16_t)-0.808656182f,
   (float16_t)-0.585797857f, (float16_t)-0.810457198f,
   (float16_t)-0.583308653f, (float16_t)-0.812250587f,
   (float16_t)-0.580813958f, (float16_t)-0.814036330f,
   (float16_t)-0.578313796f, (float16_t)-0.815814411f,
   (float16_t)-0.575808191f, (float16_t)-0.817584813f,
   (float16_t)-0.573297167f, (float16_t)-0.819347520f,
   (float16_t)-0.570780746f, (float16_t)-0.821102515f,
   (float16_t)-0.568258953f, (float16_t)-0.822849781f,
   (float16_t)-0.565731811f, (float16_t)-0.824589303f,
   (float16_t)-0.563199344f, (float16_t)-0.826321063f,
   (float16_t)-0.560661576f, (float16_t)-0.828045045f,
   (float16_t)-0.558118531f, (float16_t)-0.829761234f,
   (float16_t)-0.555570233f, (float16_t)-0.831469612f,
   (float16_t)-0.553016706f, (float16_t)-0.833170165f,
   (float16_t)-0.550457973f, (float16_t)-0.834862875f,
   (float16_t)-0.547894059f, (float16_t)-0.836547727f,
   (float16_t)-0.545324988f, (float16_t)-0.838224706f,
   (float16_t)-0.542750785f, (float16_t)-0.839893794f,
   (float16_t)-0.540171473f, (float16_t)-0.841554977f,
   (float16_t)-0.537587076f, (float16_t)-0.843208240f,
   (float16_t)-0.534997620f, (float16_t)-0.844853565f,
   (float16_t)-0.532403128f, (float16_t)-0.846490939f,
   (float16_t)-0.529803625f, (float16_t)-0.848120345f,
   (float16_t)-0.527199135f, (float16_t)-0.849741768f,
   (float16_t)-0.524589683f, (float16_t)-0.851355193f,
   (float16_t)-0.521975293f, (float16_t)-0.852960605f,
   (float16_t)-0.519355990f, (float16_t)-0.854557988f,
   (float16_t)-0.516731799f, (float16_t)-0.856147328f,
   (float16_t)-0.514102744f, (float16_t)-0.857728610f,
   (float16_t)-0.511468850f, (float16_t)-0.859301818f,
   (float16_t)-0.508830143f, (float16_t)-0.860866939f,
   (float16_t)-0.506186645f, (float16_t)-0.862423956f,
   (float16_t)-0.503538384f, (float16_t)-0.863972856f,
   (float16_t)-0.500885383f, (float16_t)-0.865513624f,
   (float16_t)-0.498227667f, (float16_t)-0.867046246f,
   (float16_t)-0.495565262f, (float16_t)-0.868570706f,
   (float16_t)-0.492898192f, (float16_t)-0.870086991f,
   (float16_t)-0.490226483f, (float16_t)-0.871595087f,
   (float16_t)-0.487550160f, (float16_t)-0.873094978f,
   (float16_t)-0.484869248f, (float16_t)-0.874586652f,
   (float16_t)-0.482183772f, (float16_t)-0.876070094f,
   (float16_t)-0.479493758f, (float16_t)-0.877545290f,
   (float16_t)-0.476799230f, (float16_t)-0.879012226f,
   (float16_t)-0.474100215f, (float16_t)-0.880470889f,
   (float16_t)-0.471396737f, (float16_t)-0.881921264f,
   (float16_t)-0.468688822f, (float16_t)-0.883363339f,
   (float16_t)-0.465976496f, (float16_t)-0.884797098f,
   (float16_t)-0.463259784f, (float16_t)-0.886222530f,
   (float16_t)-0.460538711f, (float16_t)-0.887639620f,
   (float16_t)-0.457813304f, (float16_t)-0.889048356f,
   (float16_t)-0.455083587f, (float16_t)-0.890448723f,
   (float16_t)-0.452349587f, (float16_t)-0.891840709f,
   (float16_t)-0.449611330f, (float16_t)-0.893224301f,
   (float16_t)-0.446868840f, (float16_t)-0.894599486f,
   (float16_t)-0.444122145f, (float16_t)-0.895966250f,
   (float16_t)-0.441371269f, (float16_t)-0.897324581f,
   (float16_t)-0.438616239f, (float16_t)-0.898674466f,
   (float16_t)-0.435857080f, (float16_t)-0.900015892f,
   (float16_t)-0.433093819f, (float16_t)-0.901348847f,
   (float16_t)-0.430326481f, (float16_t)-0.902673318f,
   (float16_t)-0.427555093f, (float16_t)-0.903989293f,
   (float16_t)-0.424779681f, (float16_t)-0.905296759f,
   (float16_t)-0.422000271f, (float16_t)-0.906595705f,
   (float16_t)-0.419216888f, (float16_t)-0.907886116f,
   (float16_t)-0.416429560f, (float16_t)-0.909167983f,
   (float16_t)-0.413638312f, (float16_t)-0.910441292f,
   (float16_t)-0.410843171f, (float16_t)-0.911706032f,
   (float16_t)-0.408044163f, (float16_t)-0.912962190f,
   (float16_t)-0.405241314f, (float16_t)-0.914209756f,
   (float16_t)-0.402434651f, (float16_t)-0.915448716f,
   (float16_t)-0.399624200f, (float16_t)-0.916679060f,
   (float16_t)-0.396809987f, (float16_t)-0.917900776f,
   (float16_t)-0.393992040f, (float16_t)-0.919113852f,
   (float16_t)-0.391170384f, (float16_t)-0.920318277f,
   (float16_t)-0.388345047f, (float16_t)-0.921514039f,
   (float16_t)-0.385516054f, (float16_t)-0.922701128f,
   (float16_t)-0.382683432f, (float16_t)-0.923879533f,
   (float16_t)-0.379847209f, (float16_t)-0.925049241f,
   (float16_t)-0.377007410f, (float16_t)-0.926210242f,
   (float16_t)-0.374164063f, (float16_t)-0.927362526f,
   (float16_t)-0.371317194f, (float16_t)-0.928506080f,
   (float16_t)-0.368466830f, (float16_t)-0.929640896f,
   (float16_t)-0.365612998f, (float16_t)-0.930766961f,
   (float16_t)-0.362755724f, (float16_t)-0.931884266f,
   (float16_t)-0.359895037f, (float16_t)-0.932992799f,
   (float16_t)-0.357030961f, (float16_t)-0.934092550f,
   (float16_t)-0.354163525f, (float16_t)-0.935183510f,
   (float16_t)-0.351292756f, (float16_t)-0.936265667f,
   (float16_t)-0.348418680f, (float16_t)-0.937339012f,
   (float16_t)-0.345541325f, (float16_t)-0.938403534f,
   (float16_t)-0.342660717f, (float16_t)-0.939459224f,
   (float16_t)-0.339776884f, (float16_t)-0.940506071f,
   (float16_t)-0.336889853f, (float16_t)-0.941544065f,
   (float16_t)-0.333999651f, (float16_t)-0.942573198f,
   (float16_t)-0.331106306f, (float16_t)-0.943593458f,
   (float16_t)-0.328209844f, (float16_t)-0.944604837f,
   (float16_t)-0.325310292f, (float16_t)-0.945607325f,
   (float16_t)-0.322407679f, (float16_t)-0.946600913f,
   (float16_t)-0.319502031f, (float16_t)-0.947585591f,
   (float16_t)-0.316593376f, (float16_t)-0.948561350f,
   (float16_t)-0.313681740f, (float16_t)-0.949528181f,
   (float16_t)-0.310767153f, (float16_t)-0.950486074f,
   (float16_t)-0.307849640f, (float16_t)-0.951435021f,
   (float16_t)-0.304929230f, (float16_t)-0.952375013f,
   (float16_t)-0.302005949f, (float16_t)-0.953306040f,
   (float16_t)-0.299079826f, (float16_t)-0.954228095f,
   (float16_t)-0.296150888f, (float16_t)-0.955141168f,
   (float16_t)-0.293219163f, (float16_t)-0.956045251f,
   (float16_t)-0.290284677f, (float16_t)-0.956940336f,
   (float16_t)-0.287347460f, (float16_t)-0.957826413f,
   (float16_t)-0.284407537f, (float16_t)-0.958703475f,
   (float16_t)-0.281464938f, (float16_t)-0.959571513f,
   (float16_t)-0.278519689f, (float16_t)-0.960430519f,
   (float16_t)-0.275571819f, (float16_t)-0.961280486f,
   (float16_t)-0.272621355f, (float16_t)-0.962121404f,
   (float16_t)-0.269668326f, (float16_t)-0.962953267f,
   (float16_t)-0.266712757f, (float16_t)-0.963776066f,
   (float16_t)-0.263754679f, (float16_t)-0.964589793f,
   (float16_t)-0.260794118f, (float16_t)-0.965394442f,
   (float16_t)-0.257831102f, (float16_t)-0.966190003f,
   (float16_t)-0.254865660f, (float16_t)-0.966976471f,
   (float16_t)-0.251897818f, (float16_t)-0.967753837f,
   (float16_t)-0.248927606f, (float16_t)-0.968522094f,
   (float16_t)-0.245955050f, (float16_t)-0.969281235f,
   (float16_t)-0.242980180f, (float16_t)-0.970031253f,
   (float16_t)-0.240003022f, (float16_t)-0.970772141f,
   (float16_t)-0.237023606f, (float16_t)-0.971503891f,
   (float16_t)-0.234041959f, (float16_t)-0.972226497f,
   (float16_t)-0.231058108f, (float16_t)-0.972939952f,
   (float16_t)-0.228072083f, (float16_t)-0.973644250f,
   (float16_t)-0.225083911f, (float16_t)-0.974339383f,
   (float16_t)-0.222093621f, (float16_t)-0.975025345f,
   (float16_t)-0.219101240f, (float16_t)-0.975702130f,
   (float16_t)-0.216106797f, (float16_t)-0.976369731f,
   (float16_t)-0.213110320f, (float16_t)-0.977028143f,
   (float16_t)-0.210111837f, (float16_t)-0.977677358f,
   (float16_t)-0.207111376f, (float16_t)-0.978317371f,
   (float16_t)-0.204108966f, (float16_t)-0.978948175f,
   (float16_t)-0.201104635f, (float16_t)-0.979569766f,
   (float16_t)-0.198098411f, (float16_t)-0.980182136f,
   (float16_t)-0.195090322f, (float16_t)-0.980785280f,
   (float16_t)-0.192080397f, (float16_t)-0.981379193f,
   (float16_t)-0.189068664f, (float16_t)-0.981963869f,
   (float16_t)-0.186055152f, (float16_t)-0.982539302f,
   (float16_t)-0.183039888f, (float16_t)-0.983105487f,
   (float16_t)-0.180022901f, (float16_t)-0.983662419f,
   (float16_t)-0.177004220f, (float16_t)-0.984210092f,
   (float16_t)-0.173983873f, (float16_t)-0.984748502f,
   (float16_t)-0.170961889f, (float16_t)-0.985277642f,
   (float16_t)-0.167938295f, (float16_t)-0.985797509f,
   (float16_t)-0.164913120f, (float16_t)-0.986308097f,
   (float16_t)-0.161886394f, (float16_t)-0.986809402f,
   (float16_t)-0.158858143f, (float16_t)-0.987301418f,
   (float16_t)-0.155828398f, (float16_t)-0.987784142f,
   (float16_t)-0.152797185f, (float16_t)-0.988257568f,
   (float16_t)-0.149764535f, (float16_t)-0.988721692f,
   (float16_t)-0.146730474f, (float16_t)-0.989176510f,
   (float16_t)-0.143695033f, (float16_t)-0.989622017f,
   (float16_t)-0.140658239f, (float16_t)-0.990058210f,
   (float16_t)-0.137620122f, (float16_t)-0.990485084f,
   (float16_t)-0.134580709f, (float16_t)-0.990902635f,
   (float16_t)-0.131540029f, (float16_t)-0.991310860f,
   (float16_t)-0.128498111f, (float16_t)-0.991709754f,
   (float16_t)-0.125454983f, (float16_t)-0.992099313f,
   (float16_t)-0.122410675f, (float16_t)-0.992479535f,
   (float16_t)-0.119365215f, (float16_t)-0.992850414f,
   (float16_t)-0.116318631f, (float16_t)-0.993211949f,
   (float16_t)-0.113270952f, (float16_t)-0.993564136f,
   (float16_t)-0.110222207f, (float16_t)-0.993906970f,
   (float16_t)-0.107172425f, (float16_t)-0.994240449f,
   (float16_t)-0.104121634f, (float16_t)-0.994564571f,
   (float16_t)-0.101069863f, (float16_t)-0.994879331f,
   (float16_t)-0.098017140f, (float16_t)-0.995184727f,
   (float16_t)-0.094963495f, (float16_t)-0.995480755f,
   (float16_t)-0.091908956f, (float16_t)-0.995767414f,
   (float16_t)-0.088853553f, (float16_t)-0.996044701f,
   (float16_t)-0.085797312f, (float16_t)-0.996312612f,
   (float16_t)-0.082740265f, (float16_t)-0.996571146f,
   (float16_t)-0.079682438f, (float16_t)-0.996820299f,
   (float16_t)-0.076623861f, (float16_t)-0.997060070f,
   (float16_t)-0.073564564f, (float16_t)-0.997290457f,
   (float16_t)-0.070504573f, (float16_t)-0.997511456f,
   (float16_t)-0.067443920f, (float16_t)-0.997723067f,
   (float16_t)-0.064382631f, (float16_t)-0.997925286f,
   (float16_t)-0.061320736f, (float16_t)-0.998118113f,
   (float16_t)-0.058258265f, (float16_t)-0.998301545f,
   (float16_t)-0.055195244f, (float16_t)-0.998475581f,
   (float16_t)-0.052131705f, (float16_t)-0.998640218f,
   (float16_t)-0.049067674f, (float16_t)-0.998795456f,
   (float16_t)-0.046003182f, (float16_t)-0.998941293f,
   (float16_t)-0.042938257f, (float16_t)-0.999077728f,
   (float16_t)-0.039872928f, (float16_t)-0.999204759f,
   (float16_t)-0.036807223f, (float16_t)-0.999322385f,
   (float16_t)-0.033741172f, (float16_t)-0.999430605f,
   (float16_t)-0.030674803f, (float16_t)-0.999529418f,
   (float16_t)-0.027608146f, (float16_t)-0.999618822f,
   (float16_t)-0.024541229f, (float16_t)-0.999698819f,
   (float16_t)-0.021474080f, (float16_t)-0.999769405f,
   (float16_t)-0.018406730f, (float16_t)-0.999830582f,
   (float16_t)-0.015339206f, (float16_t)-0.999882347f,
   (float16_t)-0.012271538f, (float16_t)-0.999924702f,
   (float16_t)-0.009203755f, (float16_t)-0.999957645f,
   (float16_t)-0.006135885f, (float16_t)-0.999981175f,
   (float16_t)-0.003067957f, (float16_t)-0.999995294f,
   (float16_t)-0.000000000f, (float16_t)-1.000000000f,
    (float16_t)0.003067957f, (float16_t)-0.999995294f,
    (float16_t)0.006135885f, (float16_t)-0.999981175f,
    (float16_t)0.009203755f, (float16_t)-0.999957645f,
    (float16_t)0.012271538f, (float16_t)-0.999924702f,
    (float16_t)0.015339206f, (float16_t)-0.999882347f,
    (float16_t)0.018406730f, (float16_t)-0.999830582f,
    (float16_t)0.021474080f, (float16_t)-0.999769405f,
    (float16_t)0.024541229f, (float16_t)-0.999698819f,
    (float16_t)0.027608146f, (float16_t)-0.999618822f,
    (float16_t)0.030674803f, (float16_t)-0.999529418f,
    (float16_t)0.033741172f, (float16_t)-0.999430605f,
    (float16_t)0.036807223f, (float16_t)-0.999322385f,
    (float16_t)0.039872928f, (float16_t)-0.999204759f,
    (float16_t)0.042938257f, (float16_t)-0.999077728f,
    (float16_t)0.046003182f, (float16_t)-0.998941293f,
    (float16_t)0.049067674f, (float16_t)-0.998795456f,
    (float16_t)0.052131705f, (float16_t)-0.998640218f,
    (float16_t)0.055195244f, (float16_t)-0.998475581f,
    (float16_t)0.058258265f, (float16_t)-0.998301545f,
    (float16_t)0.061320736f, (float16_t)-0.998118113f,
    (float16_t)0.064382631f, (float16_t)-0.997925286f,
    (float16_t)0.067443920f, (float16_t)-0.997723067f,
    (float16_t)0.070504573f, (float16_t)-0.997511456f,
    (float16_t)0.073564564f, (float16_t)-0.997290457f,
    (float16_t)0.076623861f, (float16_t)-0.997060070f,
    (float16_t)0.079682438f, (float16_t)-0.996820299f,
    (float16_t)0.082740265f, (float16_t)-0.996571146f,
    (float16_t)0.085797312f, (float16_t)-0.996312612f,
    (float16_t)0.088853553f, (float16_t)-0.996044701f,
    (float16_t)0.091908956f, (float16_t)-0.995767414f,
    (float16_t)0.094963495f, (float16_t)-0.995480755f,
    (float16_t)0.098017140f, (float16_t)-0.995184727f,
    (float16_t)0.101069863f, (float16_t)-0.994879331f,
    (float16_t)0.104121634f, (float16_t)-0.994564571f,
    (float16_t)0.107172425f, (float16_t)-0.994240449f,
    (float16_t)0.110222207f, (float16_t)-0.993906970f,
    (float16_t)0.113270952f, (float16_t)-0.993564136f,
    (float16_t)0.116318631f, (float16_t)-0.993211949f,
    (float16_t)0.119365215f, (float16_t)-0.992850414f,
    (float16_t)0.122410675f, (float16_t)-0.992479535f,
    (float16_t)0.125454983f, (float16_t)-0.992099313f,
    (float16_t)0.128498111f, (float16_t)-0.991709754f,
    (float16_t)0.131540029f, (float16_t)-0.991310860f,
    (float16_t)0.134580709f, (float16_t)-0.990902635f,
    (float16_t)0.137620122f, (float16_t)-0.990485084f,
    (float16_t)0.140658239f, (float16_t)-0.990058210f,
    (float16_t)0.143695033f, (float16_t)-0.989622017f,
    (float16_t)0.146730474f, (float16_t)-0.989176510f,
    (float16_t)0.149764535f, (float16_t)-0.988721692f,
    (float16_t)0.152797185f, (float16_t)-0.988257568f,
    (float16_t)0.155828398f, (float16_t)-0.987784142f,
    (float16_t)0.158858143f, (float16_t)-0.987301418f,
    (float16_t)0.161886394f, (float16_t)-0.986809402f,
    (float16_t)0.164913120f, (float16_t)-0.986308097f,
    (float16_t)0.167938295f, (float16_t)-0.985797509f,
    (float16_t)0.170961889f, (float16_t)-0.985277642f,
    (float16_t)0.173983873f, (float16_t)-0.984748502f,
    (float16_t)0.177004220f, (float16_t)-0.984210092f,
    (float16_t)0.180022901f, (float16_t)-0.983662419f,
    (float16_t)0.183039888f, (float16_t)-0.983105487f,
    (float16_t)0.186055152f, (float16_t)-0.982539302f,
    (float16_t)0.189068664f, (float16_t)-0.981963869f,
    (float16_t)0.192080397f, (float16_t)-0.981379193f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.198098411f, (float16_t)-0.980182136f,
    (float16_t)0.201104635f, (float16_t)-0.979569766f,
    (float16_t)0.204108966f, (float16_t)-0.978948175f,
    (float16_t)0.207111376f, (float16_t)-0.978317371f,
    (float16_t)0.210111837f, (float16_t)-0.977677358f,
    (float16_t)0.213110320f, (float16_t)-0.977028143f,
    (float16_t)0.216106797f, (float16_t)-0.976369731f,
    (float16_t)0.219101240f, (float16_t)-0.975702130f,
    (float16_t)0.222093621f, (float16_t)-0.975025345f,
    (float16_t)0.225083911f, (float16_t)-0.974339383f,
    (float16_t)0.228072083f, (float16_t)-0.973644250f,
    (float16_t)0.231058108f, (float16_t)-0.972939952f,
    (float16_t)0.234041959f, (float16_t)-0.972226497f,
    (float16_t)0.237023606f, (float16_t)-0.971503891f,
    (float16_t)0.240003022f, (float16_t)-0.970772141f,
    (float16_t)0.242980180f, (float16_t)-0.970031253f,
    (float16_t)0.245955050f, (float16_t)-0.969281235f,
    (float16_t)0.248927606f, (float16_t)-0.968522094f,
    (float16_t)0.251897818f, (float16_t)-0.967753837f,
    (float16_t)0.254865660f, (float16_t)-0.966976471f,
    (float16_t)0.257831102f, (float16_t)-0.966190003f,
    (float16_t)0.260794118f, (float16_t)-0.965394442f,
    (float16_t)0.263754679f, (float16_t)-0.964589793f,
    (float16_t)0.266712757f, (float16_t)-0.963776066f,
    (float16_t)0.269668326f, (float16_t)-0.962953267f,
    (float16_t)0.272621355f, (float16_t)-0.962121404f,
    (float16_t)0.275571819f, (float16_t)-0.961280486f,
    (float16_t)0.278519689f, (float16_t)-0.960430519f,
    (float16_t)0.281464938f, (float16_t)-0.959571513f,
    (float16_t)0.284407537f, (float16_t)-0.958703475f,
    (float16_t)0.287347460f, (float16_t)-0.957826413f,
    (float16_t)0.290284677f, (float16_t)-0.956940336f,
    (float16_t)0.293219163f, (float16_t)-0.956045251f,
    (float16_t)0.296150888f, (float16_t)-0.955141168f,
    (float16_t)0.299079826f, (float16_t)-0.954228095f,
    (float16_t)0.302005949f, (float16_t)-0.953306040f,
    (float16_t)0.304929230f, (float16_t)-0.952375013f,
    (float16_t)0.307849640f, (float16_t)-0.951435021f,
    (float16_t)0.310767153f, (float16_t)-0.950486074f,
    (float16_t)0.313681740f, (float16_t)-0.949528181f,
    (float16_t)0.316593376f, (float16_t)-0.948561350f,
    (float16_t)0.319502031f, (float16_t)-0.947585591f,
    (float16_t)0.322407679f, (float16_t)-0.946600913f,
    (float16_t)0.325310292f, (float16_t)-0.945607325f,
    (float16_t)0.328209844f, (float16_t)-0.944604837f,
    (float16_t)0.331106306f, (float16_t)-0.943593458f,
    (float16_t)0.333999651f, (float16_t)-0.942573198f,
    (float16_t)0.336889853f, (float16_t)-0.941544065f,
    (float16_t)0.339776884f, (float16_t)-0.940506071f,
    (float16_t)0.342660717f, (float16_t)-0.939459224f,
    (float16_t)0.345541325f, (float16_t)-0.938403534f,
    (float16_t)0.348418680f, (float16_t)-0.937339012f,
    (float16_t)0.351292756f, (float16_t)-0.936265667f,
    (float16_t)0.354163525f, (float16_t)-0.935183510f,
    (float16_t)0.357030961f, (float16_t)-0.934092550f,
    (float16_t)0.359895037f, (float16_t)-0.932992799f,
    (float16_t)0.362755724f, (float16_t)-0.931884266f,
    (float16_t)0.365612998f, (float16_t)-0.930766961f,
    (float16_t)0.368466830f, (float16_t)-0.929640896f,
    (float16_t)0.371317194f, (float16_t)-0.928506080f,
    (float16_t)0.374164063f, (float16_t)-0.927362526f,
    (float16_t)0.377007410f, (float16_t)-0.926210242f,
    (float16_t)0.379847209f, (float16_t)-0.925049241f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.385516054f, (float16_t)-0.922701128f,
    (float16_t)0.388345047f, (float16_t)-0.921514039f,
    (float16_t)0.391170384f, (float16_t)-0.920318277f,
    (float16_t)0.393992040f, (float16_t)-0.919113852f,
    (float16_t)0.396809987f, (float16_t)-0.917900776f,
    (float16_t)0.399624200f, (float16_t)-0.916679060f,
    (float16_t)0.402434651f, (float16_t)-0.915448716f,
    (float16_t)0.405241314f, (float16_t)-0.914209756f,
    (float16_t)0.408044163f, (float16_t)-0.912962190f,
    (float16_t)0.410843171f, (float16_t)-0.911706032f,
    (float16_t)0.413638312f, (float16_t)-0.910441292f,
    (float16_t)0.416429560f, (float16_t)-0.909167983f,
    (float16_t)0.419216888f, (float16_t)-0.907886116f,
    (float16_t)0.422000271f, (float16_t)-0.906595705f,
    (float16_t)0.424779681f, (float16_t)-0.905296759f,
    (float16_t)0.427555093f, (float16_t)-0.903989293f,
    (float16_t)0.430326481f, (float16_t)-0.902673318f,
    (float16_t)0.433093819f, (float16_t)-0.901348847f,
    (float16_t)0.435857080f, (float16_t)-0.900015892f,
    (float16_t)0.438616239f, (float16_t)-0.898674466f,
    (float16_t)0.441371269f, (float16_t)-0.897324581f,
    (float16_t)0.444122145f, (float16_t)-0.895966250f,
    (float16_t)0.446868840f, (float16_t)-0.894599486f,
    (float16_t)0.449611330f, (float16_t)-0.893224301f,
    (float16_t)0.452349587f, (float16_t)-0.891840709f,
    (float16_t)0.455083587f, (float16_t)-0.890448723f,
    (float16_t)0.457813304f, (float16_t)-0.889048356f,
    (float16_t)0.460538711f, (float16_t)-0.887639620f,
    (float16_t)0.463259784f, (float16_t)-0.886222530f,
    (float16_t)0.465976496f, (float16_t)-0.884797098f,
    (float16_t)0.468688822f, (float16_t)-0.883363339f,
    (float16_t)0.471396737f, (float16_t)-0.881921264f,
    (float16_t)0.474100215f, (float16_t)-0.880470889f,
    (float16_t)0.476799230f, (float16_t)-0.879012226f,
    (float16_t)0.479493758f, (float16_t)-0.877545290f,
    (float16_t)0.482183772f, (float16_t)-0.876070094f,
    (float16_t)0.484869248f, (float16_t)-0.874586652f,
    (float16_t)0.487550160f, (float16_t)-0.873094978f,
    (float16_t)0.490226483f, (float16_t)-0.871595087f,
    (float16_t)0.492898192f, (float16_t)-0.870086991f,
    (float16_t)0.495565262f, (float16_t)-0.868570706f,
    (float16_t)0.498227667f, (float16_t)-0.867046246f,
    (float16_t)0.500885383f, (float16_t)-0.865513624f,
    (float16_t)0.503538384f, (float16_t)-0.863972856f,
    (float16_t)0.506186645f, (float16_t)-0.862423956f,
    (float16_t)0.508830143f, (float16_t)-0.860866939f,
    (float16_t)0.511468850f, (float16_t)-0.859301818f,
    (float16_t)0.514102744f, (float16_t)-0.857728610f,
    (float16_t)0.516731799f, (float16_t)-0.856147328f,
    (float16_t)0.519355990f, (float16_t)-0.854557988f,
    (float16_t)0.521975293f, (float16_t)-0.852960605f,
    (float16_t)0.524589683f, (float16_t)-0.851355193f,
    (float16_t)0.527199135f, (float16_t)-0.849741768f,
    (float16_t)0.529803625f, (float16_t)-0.848120345f,
    (float16_t)0.532403128f, (float16_t)-0.846490939f,
    (float16_t)0.534997620f, (float16_t)-0.844853565f,
    (float16_t)0.537587076f, (float16_t)-0.843208240f,
    (float16_t)0.540171473f, (float16_t)-0.841554977f,
    (float16_t)0.542750785f, (float16_t)-0.839893794f,
    (float16_t)0.545324988f, (float16_t)-0.838224706f,
    (float16_t)0.547894059f, (float16_t)-0.836547727f,
    (float16_t)0.550457973f, (float16_t)-0.834862875f,
    (float16_t)0.553016706f, (float16_t)-0.833170165f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.558118531f, (float16_t)-0.829761234f,
    (float16_t)0.560661576f, (float16_t)-0.828045045f,
    (float16_t)0.563199344f, (float16_t)-0.826321063f,
    (float16_t)0.565731811f, (float16_t)-0.824589303f,
    (float16_t)0.568258953f, (float16_t)-0.822849781f,
    (float16_t)0.570780746f, (float16_t)-0.821102515f,
    (float16_t)0.573297167f, (float16_t)-0.819347520f,
    (float16_t)0.575808191f, (float16_t)-0.817584813f,
    (float16_t)0.578313796f, (float16_t)-0.815814411f,
    (float16_t)0.580813958f, (float16_t)-0.814036330f,
    (float16_t)0.583308653f, (float16_t)-0.812250587f,
    (float16_t)0.585797857f, (float16_t)-0.810457198f,
    (float16_t)0.588281548f, (float16_t)-0.808656182f,
    (float16_t)0.590759702f, (float16_t)-0.806847554f,
    (float16_t)0.593232295f, (float16_t)-0.805031331f,
    (float16_t)0.595699304f, (float16_t)-0.803207531f,
    (float16_t)0.598160707f, (float16_t)-0.801376172f,
    (float16_t)0.600616479f, (float16_t)-0.799537269f,
    (float16_t)0.603066599f, (float16_t)-0.797690841f,
    (float16_t)0.605511041f, (float16_t)-0.795836905f,
    (float16_t)0.607949785f, (float16_t)-0.793975478f,
    (float16_t)0.610382806f, (float16_t)-0.792106577f,
    (float16_t)0.612810082f, (float16_t)-0.790230221f,
    (float16_t)0.615231591f, (float16_t)-0.788346428f,
    (float16_t)0.617647308f, (float16_t)-0.786455214f,
    (float16_t)0.620057212f, (float16_t)-0.784556597f,
    (float16_t)0.622461279f, (float16_t)-0.782650596f,
    (float16_t)0.624859488f, (float16_t)-0.780737229f,
    (float16_t)0.627251815f, (float16_t)-0.778816512f,
    (float16_t)0.629638239f, (float16_t)-0.776888466f,
    (float16_t)0.632018736f, (float16_t)-0.774953107f,
    (float16_t)0.634393284f, (float16_t)-0.773010453f,
    (float16_t)0.636761861f, (float16_t)-0.771060524f,
    (float16_t)0.639124445f, (float16_t)-0.769103338f,
    (float16_t)0.641481013f, (float16_t)-0.767138912f,
    (float16_t)0.643831543f, (float16_t)-0.765167266f,
    (float16_t)0.646176013f, (float16_t)-0.763188417f,
    (float16_t)0.648514401f, (float16_t)-0.761202385f,
    (float16_t)0.650846685f, (float16_t)-0.759209189f,
    (float16_t)0.653172843f, (float16_t)-0.757208847f,
    (float16_t)0.655492853f, (float16_t)-0.755201377f,
    (float16_t)0.657806693f, (float16_t)-0.753186799f,
    (float16_t)0.660114342f, (float16_t)-0.751165132f,
    (float16_t)0.662415778f, (float16_t)-0.749136395f,
    (float16_t)0.664710978f, (float16_t)-0.747100606f,
    (float16_t)0.666999922f, (float16_t)-0.745057785f,
    (float16_t)0.669282588f, (float16_t)-0.743007952f,
    (float16_t)0.671558955f, (float16_t)-0.740951125f,
    (float16_t)0.673829000f, (float16_t)-0.738887324f,
    (float16_t)0.676092704f, (float16_t)-0.736816569f,
    (float16_t)0.678350043f, (float16_t)-0.734738878f,
    (float16_t)0.680600998f, (float16_t)-0.732654272f,
    (float16_t)0.682845546f, (float16_t)-0.730562769f,
    (float16_t)0.685083668f, (float16_t)-0.728464390f,
    (float16_t)0.687315341f, (float16_t)-0.726359155f,
    (float16_t)0.689540545f, (float16_t)-0.724247083f,
    (float16_t)0.691759258f, (float16_t)-0.722128194f,
    (float16_t)0.693971461f, (float16_t)-0.720002508f,
    (float16_t)0.696177131f, (float16_t)-0.717870045f,
    (float16_t)0.698376249f, (float16_t)-0.715730825f,
    (float16_t)0.700568794f, (float16_t)-0.713584869f,
    (float16_t)0.702754744f, (float16_t)-0.711432196f,
    (float16_t)0.704934080f, (float16_t)-0.709272826f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.709272826f, (float16_t)-0.704934080f,
    (float16_t)0.711432196f, (float16_t)-0.702754744f,
    (float16_t)0.713584869f, (float16_t)-0.700568794f,
    (float16_t)0.715730825f, (float16_t)-0.698376249f,
    (float16_t)0.717870045f, (float16_t)-0.696177131f,
    (float16_t)0.720002508f, (float16_t)-0.693971461f,
    (float16_t)0.722128194f, (float16_t)-0.691759258f,
    (float16_t)0.724247083f, (float16_t)-0.689540545f,
    (float16_t)0.726359155f, (float16_t)-0.687315341f,
    (float16_t)0.728464390f, (float16_t)-0.685083668f,
    (float16_t)0.730562769f, (float16_t)-0.682845546f,
    (float16_t)0.732654272f, (float16_t)-0.680600998f,
    (float16_t)0.734738878f, (float16_t)-0.678350043f,
    (float16_t)0.736816569f, (float16_t)-0.676092704f,
    (float16_t)0.738887324f, (float16_t)-0.673829000f,
    (float16_t)0.740951125f, (float16_t)-0.671558955f,
    (float16_t)0.743007952f, (float16_t)-0.669282588f,
    (float16_t)0.745057785f, (float16_t)-0.666999922f,
    (float16_t)0.747100606f, (float16_t)-0.664710978f,
    (float16_t)0.749136395f, (float16_t)-0.662415778f,
    (float16_t)0.751165132f, (float16_t)-0.660114342f,
    (float16_t)0.753186799f, (float16_t)-0.657806693f,
    (float16_t)0.755201377f, (float16_t)-0.655492853f,
    (float16_t)0.757208847f, (float16_t)-0.653172843f,
    (float16_t)0.759209189f, (float16_t)-0.650846685f,
    (float16_t)0.761202385f, (float16_t)-0.648514401f,
    (float16_t)0.763188417f, (float16_t)-0.646176013f,
    (float16_t)0.765167266f, (float16_t)-0.643831543f,
    (float16_t)0.767138912f, (float16_t)-0.641481013f,
    (float16_t)0.769103338f, (float16_t)-0.639124445f,
    (float16_t)0.771060524f, (float16_t)-0.636761861f,
    (float16_t)0.773010453f, (float16_t)-0.634393284f,
    (float16_t)0.774953107f, (float16_t)-0.632018736f,
    (float16_t)0.776888466f, (float16_t)-0.629638239f,
    (float16_t)0.778816512f, (float16_t)-0.627251815f,
    (float16_t)0.780737229f, (float16_t)-0.624859488f,
    (float16_t)0.782650596f, (float16_t)-0.622461279f,
    (float16_t)0.784556597f, (float16_t)-0.620057212f,
    (float16_t)0.786455214f, (float16_t)-0.617647308f,
    (float16_t)0.788346428f, (float16_t)-0.615231591f,
    (float16_t)0.790230221f, (float16_t)-0.612810082f,
    (float16_t)0.792106577f, (float16_t)-0.610382806f,
    (float16_t)0.793975478f, (float16_t)-0.607949785f,
    (float16_t)0.795836905f, (float16_t)-0.605511041f,
    (float16_t)0.797690841f, (float16_t)-0.603066599f,
    (float16_t)0.799537269f, (float16_t)-0.600616479f,
    (float16_t)0.801376172f, (float16_t)-0.598160707f,
    (float16_t)0.803207531f, (float16_t)-0.595699304f,
    (float16_t)0.805031331f, (float16_t)-0.593232295f,
    (float16_t)0.806847554f, (float16_t)-0.590759702f,
    (float16_t)0.808656182f, (float16_t)-0.588281548f,
    (float16_t)0.810457198f, (float16_t)-0.585797857f,
    (float16_t)0.812250587f, (float16_t)-0.583308653f,
    (float16_t)0.814036330f, (float16_t)-0.580813958f,
    (float16_t)0.815814411f, (float16_t)-0.578313796f,
    (float16_t)0.817584813f, (float16_t)-0.575808191f,
    (float16_t)0.819347520f, (float16_t)-0.573297167f,
    (float16_t)0.821102515f, (float16_t)-0.570780746f,
    (float16_t)0.822849781f, (float16_t)-0.568258953f,
    (float16_t)0.824589303f, (float16_t)-0.565731811f,
    (float16_t)0.826321063f, (float16_t)-0.563199344f,
    (float16_t)0.828045045f, (float16_t)-0.560661576f,
    (float16_t)0.829761234f, (float16_t)-0.558118531f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.833170165f, (float16_t)-0.553016706f,
    (float16_t)0.834862875f, (float16_t)-0.550457973f,
    (float16_t)0.836547727f, (float16_t)-0.547894059f,
    (float16_t)0.838224706f, (float16_t)-0.545324988f,
    (float16_t)0.839893794f, (float16_t)-0.542750785f,
    (float16_t)0.841554977f, (float16_t)-0.540171473f,
    (float16_t)0.843208240f, (float16_t)-0.537587076f,
    (float16_t)0.844853565f, (float16_t)-0.534997620f,
    (float16_t)0.846490939f, (float16_t)-0.532403128f,
    (float16_t)0.848120345f, (float16_t)-0.529803625f,
    (float16_t)0.849741768f, (float16_t)-0.527199135f,
    (float16_t)0.851355193f, (float16_t)-0.524589683f,
    (float16_t)0.852960605f, (float16_t)-0.521975293f,
    (float16_t)0.854557988f, (float16_t)-0.519355990f,
    (float16_t)0.856147328f, (float16_t)-0.516731799f,
    (float16_t)0.857728610f, (float16_t)-0.514102744f,
    (float16_t)0.859301818f, (float16_t)-0.511468850f,
    (float16_t)0.860866939f, (float16_t)-0.508830143f,
    (float16_t)0.862423956f, (float16_t)-0.506186645f,
    (float16_t)0.863972856f, (float16_t)-0.503538384f,
    (float16_t)0.865513624f, (float16_t)-0.500885383f,
    (float16_t)0.867046246f, (float16_t)-0.498227667f,
    (float16_t)0.868570706f, (float16_t)-0.495565262f,
    (float16_t)0.870086991f, (float16_t)-0.492898192f,
    (float16_t)0.871595087f, (float16_t)-0.490226483f,
    (float16_t)0.873094978f, (float16_t)-0.487550160f,
    (float16_t)0.874586652f, (float16_t)-0.484869248f,
    (float16_t)0.876070094f, (float16_t)-0.482183772f,
    (float16_t)0.877545290f, (float16_t)-0.479493758f,
    (float16_t)0.879012226f, (float16_t)-0.476799230f,
    (float16_t)0.880470889f, (float16_t)-0.474100215f,
    (float16_t)0.881921264f, (float16_t)-0.471396737f,
    (float16_t)0.883363339f, (float16_t)-0.468688822f,
    (float16_t)0.884797098f, (float16_t)-0.465976496f,
    (float16_t)0.886222530f, (float16_t)-0.463259784f,
    (float16_t)0.887639620f, (float16_t)-0.460538711f,
    (float16_t)0.889048356f, (float16_t)-0.457813304f,
    (float16_t)0.890448723f, (float16_t)-0.455083587f,
    (float16_t)0.891840709f, (float16_t)-0.452349587f,
    (float16_t)0.893224301f, (float16_t)-0.449611330f,
    (float16_t)0.894599486f, (float16_t)-0.446868840f,
    (float16_t)0.895966250f, (float16_t)-0.444122145f,
    (float16_t)0.897324581f, (float16_t)-0.441371269f,
    (float16_t)0.898674466f, (float16_t)-0.438616239f,
    (float16_t)0.900015892f, (float16_t)-0.435857080f,
    (float16_t)0.901348847f, (float16_t)-0.433093819f,
    (float16_t)0.902673318f, (float16_t)-0.430326481f,
    (float16_t)0.903989293f, (float16_t)-0.427555093f,
    (float16_t)0.905296759f, (float16_t)-0.424779681f,
    (float16_t)0.906595705f, (float16_t)-0.422000271f,
    (float16_t)0.907886116f, (float16_t)-0.419216888f,
    (float16_t)0.909167983f, (float16_t)-0.416429560f,
    (float16_t)0.910441292f, (float16_t)-0.413638312f,
    (float16_t)0.911706032f, (float16_t)-0.410843171f,
    (float16_t)0.912962190f, (float16_t)-0.408044163f,
    (float16_t)0.914209756f, (float16_t)-0.405241314f,
    (float16_t)0.915448716f, (float16_t)-0.402434651f,
    (float16_t)0.916679060f, (float16_t)-0.399624200f,
    (float16_t)0.917900776f, (float16_t)-0.396809987f,
    (float16_t)0.919113852f, (float16_t)-0.393992040f,
    (float16_t)0.920318277f, (float16_t)-0.391170384f,
    (float16_t)0.921514039f, (float16_t)-0.388345047f,
    (float16_t)0.922701128f, (float16_t)-0.385516054f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.925049241f, (float16_t)-0.379847209f,
    (float16_t)0.926210242f, (float16_t)-0.377007410f,
    (float16_t)0.927362526f, (float16_t)-0.374164063f,
    (float16_t)0.928506080f, (float16_t)-0.371317194f,
    (float16_t)0.929640896f, (float16_t)-0.368466830f,
    (float16_t)0.930766961f, (float16_t)-0.365612998f,
    (float16_t)0.931884266f, (float16_t)-0.362755724f,
    (float16_t)0.932992799f, (float16_t)-0.359895037f,
    (float16_t)0.934092550f, (float16_t)-0.357030961f,
    (float16_t)0.935183510f, (float16_t)-0.354163525f,
    (float16_t)0.936265667f, (float16_t)-0.351292756f,
    (float16_t)0.937339012f, (float16_t)-0.348418680f,
    (float16_t)0.938403534f, (float16_t)-0.345541325f,
    (float16_t)0.939459224f, (float16_t)-0.342660717f,
    (float16_t)0.940506071f, (float16_t)-0.339776884f,
    (float16_t)0.941544065f, (float16_t)-0.336889853f,
    (float16_t)0.942573198f, (float16_t)-0.333999651f,
    (float16_t)0.943593458f, (float16_t)-0.331106306f,
    (float16_t)0.944604837f, (float16_t)-0.328209844f,
    (float16_t)0.945607325f, (float16_t)-0.325310292f,
    (float16_t)0.946600913f, (float16_t)-0.322407679f,
    (float16_t)0.947585591f, (float16_t)-0.319502031f,
    (float16_t)0.948561350f, (float16_t)-0.316593376f,
    (float16_t)0.949528181f, (float16_t)-0.313681740f,
    (float16_t)0.950486074f, (float16_t)-0.310767153f,
    (float16_t)0.951435021f, (float16_t)-0.307849640f,
    (float16_t)0.952375013f, (float16_t)-0.304929230f,
    (float16_t)0.953306040f, (float16_t)-0.302005949f,
    (float16_t)0.954228095f, (float16_t)-0.299079826f,
    (float16_t)0.955141168f, (float16_t)-0.296150888f,
    (float16_t)0.956045251f, (float16_t)-0.293219163f,
    (float16_t)0.956940336f, (float16_t)-0.290284677f,
    (float16_t)0.957826413f, (float16_t)-0.287347460f,
    (float16_t)0.958703475f, (float16_t)-0.284407537f,
    (float16_t)0.959571513f, (float16_t)-0.281464938f,
    (float16_t)0.960430519f, (float16_t)-0.278519689f,
    (float16_t)0.961280486f, (float16_t)-0.275571819f,
    (float16_t)0.962121404f, (float16_t)-0.272621355f,
    (float16_t)0.962953267f, (float16_t)-0.269668326f,
    (float16_t)0.963776066f, (float16_t)-0.266712757f,
    (float16_t)0.964589793f, (float16_t)-0.263754679f,
    (float16_t)0.965394442f, (float16_t)-0.260794118f,
    (float16_t)0.966190003f, (float16_t)-0.257831102f,
    (float16_t)0.966976471f, (float16_t)-0.254865660f,
    (float16_t)0.967753837f, (float16_t)-0.251897818f,
    (float16_t)0.968522094f, (float16_t)-0.248927606f,
    (float16_t)0.969281235f, (float16_t)-0.245955050f,
    (float16_t)0.970031253f, (float16_t)-0.242980180f,
    (float16_t)0.970772141f, (float16_t)-0.240003022f,
    (float16_t)0.971503891f, (float16_t)-0.237023606f,
    (float16_t)0.972226497f, (float16_t)-0.234041959f,
    (float16_t)0.972939952f, (float16_t)-0.231058108f,
    (float16_t)0.973644250f, (float16_t)-0.228072083f,
    (float16_t)0.974339383f, (float16_t)-0.225083911f,
    (float16_t)0.975025345f, (float16_t)-0.222093621f,
    (float16_t)0.975702130f, (float16_t)-0.219101240f,
    (float16_t)0.976369731f, (float16_t)-0.216106797f,
    (float16_t)0.977028143f, (float16_t)-0.213110320f,
    (float16_t)0.977677358f, (float16_t)-0.210111837f,
    (float16_t)0.978317371f, (float16_t)-0.207111376f,
    (float16_t)0.978948175f, (float16_t)-0.204108966f,
    (float16_t)0.979569766f, (float16_t)-0.201104635f,
    (float16_t)0.980182136f, (float16_t)-0.198098411f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.981379193f, (float16_t)-0.192080397f,
    (float16_t)0.981963869f, (float16_t)-0.189068664f,
    (float16_t)0.982539302f, (float16_t)-0.186055152f,
    (float16_t)0.983105487f, (float16_t)-0.183039888f,
    (float16_t)0.983662419f, (float16_t)-0.180022901f,
    (float16_t)0.984210092f, (float16_t)-0.177004220f,
    (float16_t)0.984748502f, (float16_t)-0.173983873f,
    (float16_t)0.985277642f, (float16_t)-0.170961889f,
    (float16_t)0.985797509f, (float16_t)-0.167938295f,
    (float16_t)0.986308097f, (float16_t)-0.164913120f,
    (float16_t)0.986809402f, (float16_t)-0.161886394f,
    (float16_t)0.987301418f, (float16_t)-0.158858143f,
    (float16_t)0.987784142f, (float16_t)-0.155828398f,
    (float16_t)0.988257568f, (float16_t)-0.152797185f,
    (float16_t)0.988721692f, (float16_t)-0.149764535f,
    (float16_t)0.989176510f, (float16_t)-0.146730474f,
    (float16_t)0.989622017f, (float16_t)-0.143695033f,
    (float16_t)0.990058210f, (float16_t)-0.140658239f,
    (float16_t)0.990485084f, (float16_t)-0.137620122f,
    (float16_t)0.990902635f, (float16_t)-0.134580709f,
    (float16_t)0.991310860f, (float16_t)-0.131540029f,
    (float16_t)0.991709754f, (float16_t)-0.128498111f,
    (float16_t)0.992099313f, (float16_t)-0.125454983f,
    (float16_t)0.992479535f, (float16_t)-0.122410675f,
    (float16_t)0.992850414f, (float16_t)-0.119365215f,
    (float16_t)0.993211949f, (float16_t)-0.116318631f,
    (float16_t)0.993564136f, (float16_t)-0.113270952f,
    (float16_t)0.993906970f, (float16_t)-0.110222207f,
    (float16_t)0.994240449f, (float16_t)-0.107172425f,
    (float16_t)0.994564571f, (float16_t)-0.104121634f,
    (float16_t)0.994879331f, (float16_t)-0.101069863f,
    (float16_t)0.995184727f, (float16_t)-0.098017140f,
    (float16_t)0.995480755f, (float16_t)-0.094963495f,
    (float16_t)0.995767414f, (float16_t)-0.091908956f,
    (float16_t)0.996044701f, (float16_t)-0.088853553f,
    (float16_t)0.996312612f, (float16_t)-0.085797312f,
    (float16_t)0.996571146f, (float16_t)-0.082740265f,
    (float16_t)0.996820299f, (float16_t)-0.079682438f,
    (float16_t)0.997060070f, (float16_t)-0.076623861f,
    (float16_t)0.997290457f, (float16_t)-0.073564564f,
    (float16_t)0.997511456f, (float16_t)-0.070504573f,
    (float16_t)0.997723067f, (float16_t)-0.067443920f,
    (float16_t)0.997925286f, (float16_t)-0.064382631f,
    (float16_t)0.998118113f, (float16_t)-0.061320736f,
    (float16_t)0.998301545f, (float16_t)-0.058258265f,
    (float16_t)0.998475581f, (float16_t)-0.055195244f,
    (float16_t)0.998640218f, (float16_t)-0.052131705f,
    (float16_t)0.998795456f, (float16_t)-0.049067674f,
    (float16_t)0.998941293f, (float16_t)-0.046003182f,
    (float16_t)0.999077728f, (float16_t)-0.042938257f,
    (float16_t)0.999204759f, (float16_t)-0.039872928f,
    (float16_t)0.999322385f, (float16_t)-0.036807223f,
    (float16_t)0.999430605f, (float16_t)-0.033741172f,
    (float16_t)0.999529418f, (float16_t)-0.030674803f,
    (float16_t)0.999618822f, (float16_t)-0.027608146f,
    (float16_t)0.999698819f, (float16_t)-0.024541229f,
    (float16_t)0.999769405f, (float16_t)-0.021474080f,
    (float16_t)0.999830582f, (float16_t)-0.018406730f,
    (float16_t)0.999882347f, (float16_t)-0.015339206f,
    (float16_t)0.999924702f, (float16_t)-0.012271538f,
    (float16_t)0.999957645f, (float16_t)-0.009203755f,
    (float16_t)0.999981175f, (float16_t)-0.006135885f,
    (float16_t)0.999995294f, (float16_t)-0.003067957f
};
#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_4096)

/**
* \par
* Example code for Floating-point Twiddle factors Generation:
* \par
* <pre>for(i = 0; i< N/; i++)
* {
* twiddleCoef[2*i]= cos(i * 2*PI/(float)N);
* twiddleCoef[2*i+1]= sin(i * 2*PI/(float)N);
* } </pre>
* \par
* where N = 4096  and PI = 3.14159265358979
* \par
* Cos and Sin values are in interleaved fashion
*
*/
const float16_t twiddleCoefF16_4096[8192] = {
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.999998823f,  (float16_t)0.001533980f,
    (float16_t)0.999995294f,  (float16_t)0.003067957f,
    (float16_t)0.999989411f,  (float16_t)0.004601926f,
    (float16_t)0.999981175f,  (float16_t)0.006135885f,
    (float16_t)0.999970586f,  (float16_t)0.007669829f,
    (float16_t)0.999957645f,  (float16_t)0.009203755f,
    (float16_t)0.999942350f,  (float16_t)0.010737659f,
    (float16_t)0.999924702f,  (float16_t)0.012271538f,
    (float16_t)0.999904701f,  (float16_t)0.013805389f,
    (float16_t)0.999882347f,  (float16_t)0.015339206f,
    (float16_t)0.999857641f,  (float16_t)0.016872988f,
    (float16_t)0.999830582f,  (float16_t)0.018406730f,
    (float16_t)0.999801170f,  (float16_t)0.019940429f,
    (float16_t)0.999769405f,  (float16_t)0.021474080f,
    (float16_t)0.999735288f,  (float16_t)0.023007681f,
    (float16_t)0.999698819f,  (float16_t)0.024541229f,
    (float16_t)0.999659997f,  (float16_t)0.026074718f,
    (float16_t)0.999618822f,  (float16_t)0.027608146f,
    (float16_t)0.999575296f,  (float16_t)0.029141509f,
    (float16_t)0.999529418f,  (float16_t)0.030674803f,
    (float16_t)0.999481187f,  (float16_t)0.032208025f,
    (float16_t)0.999430605f,  (float16_t)0.033741172f,
    (float16_t)0.999377670f,  (float16_t)0.035274239f,
    (float16_t)0.999322385f,  (float16_t)0.036807223f,
    (float16_t)0.999264747f,  (float16_t)0.038340120f,
    (float16_t)0.999204759f,  (float16_t)0.039872928f,
    (float16_t)0.999142419f,  (float16_t)0.041405641f,
    (float16_t)0.999077728f,  (float16_t)0.042938257f,
    (float16_t)0.999010686f,  (float16_t)0.044470772f,
    (float16_t)0.998941293f,  (float16_t)0.046003182f,
    (float16_t)0.998869550f,  (float16_t)0.047535484f,
    (float16_t)0.998795456f,  (float16_t)0.049067674f,
    (float16_t)0.998719012f,  (float16_t)0.050599749f,
    (float16_t)0.998640218f,  (float16_t)0.052131705f,
    (float16_t)0.998559074f,  (float16_t)0.053663538f,
    (float16_t)0.998475581f,  (float16_t)0.055195244f,
    (float16_t)0.998389737f,  (float16_t)0.056726821f,
    (float16_t)0.998301545f,  (float16_t)0.058258265f,
    (float16_t)0.998211003f,  (float16_t)0.059789571f,
    (float16_t)0.998118113f,  (float16_t)0.061320736f,
    (float16_t)0.998022874f,  (float16_t)0.062851758f,
    (float16_t)0.997925286f,  (float16_t)0.064382631f,
    (float16_t)0.997825350f,  (float16_t)0.065913353f,
    (float16_t)0.997723067f,  (float16_t)0.067443920f,
    (float16_t)0.997618435f,  (float16_t)0.068974328f,
    (float16_t)0.997511456f,  (float16_t)0.070504573f,
    (float16_t)0.997402130f,  (float16_t)0.072034653f,
    (float16_t)0.997290457f,  (float16_t)0.073564564f,
    (float16_t)0.997176437f,  (float16_t)0.075094301f,
    (float16_t)0.997060070f,  (float16_t)0.076623861f,
    (float16_t)0.996941358f,  (float16_t)0.078153242f,
    (float16_t)0.996820299f,  (float16_t)0.079682438f,
    (float16_t)0.996696895f,  (float16_t)0.081211447f,
    (float16_t)0.996571146f,  (float16_t)0.082740265f,
    (float16_t)0.996443051f,  (float16_t)0.084268888f,
    (float16_t)0.996312612f,  (float16_t)0.085797312f,
    (float16_t)0.996179829f,  (float16_t)0.087325535f,
    (float16_t)0.996044701f,  (float16_t)0.088853553f,
    (float16_t)0.995907229f,  (float16_t)0.090381361f,
    (float16_t)0.995767414f,  (float16_t)0.091908956f,
    (float16_t)0.995625256f,  (float16_t)0.093436336f,
    (float16_t)0.995480755f,  (float16_t)0.094963495f,
    (float16_t)0.995333912f,  (float16_t)0.096490431f,
    (float16_t)0.995184727f,  (float16_t)0.098017140f,
    (float16_t)0.995033199f,  (float16_t)0.099543619f,
    (float16_t)0.994879331f,  (float16_t)0.101069863f,
    (float16_t)0.994723121f,  (float16_t)0.102595869f,
    (float16_t)0.994564571f,  (float16_t)0.104121634f,
    (float16_t)0.994403680f,  (float16_t)0.105647154f,
    (float16_t)0.994240449f,  (float16_t)0.107172425f,
    (float16_t)0.994074879f,  (float16_t)0.108697444f,
    (float16_t)0.993906970f,  (float16_t)0.110222207f,
    (float16_t)0.993736722f,  (float16_t)0.111746711f,
    (float16_t)0.993564136f,  (float16_t)0.113270952f,
    (float16_t)0.993389211f,  (float16_t)0.114794927f,
    (float16_t)0.993211949f,  (float16_t)0.116318631f,
    (float16_t)0.993032350f,  (float16_t)0.117842062f,
    (float16_t)0.992850414f,  (float16_t)0.119365215f,
    (float16_t)0.992666142f,  (float16_t)0.120888087f,
    (float16_t)0.992479535f,  (float16_t)0.122410675f,
    (float16_t)0.992290591f,  (float16_t)0.123932975f,
    (float16_t)0.992099313f,  (float16_t)0.125454983f,
    (float16_t)0.991905700f,  (float16_t)0.126976696f,
    (float16_t)0.991709754f,  (float16_t)0.128498111f,
    (float16_t)0.991511473f,  (float16_t)0.130019223f,
    (float16_t)0.991310860f,  (float16_t)0.131540029f,
    (float16_t)0.991107914f,  (float16_t)0.133060525f,
    (float16_t)0.990902635f,  (float16_t)0.134580709f,
    (float16_t)0.990695025f,  (float16_t)0.136100575f,
    (float16_t)0.990485084f,  (float16_t)0.137620122f,
    (float16_t)0.990272812f,  (float16_t)0.139139344f,
    (float16_t)0.990058210f,  (float16_t)0.140658239f,
    (float16_t)0.989841278f,  (float16_t)0.142176804f,
    (float16_t)0.989622017f,  (float16_t)0.143695033f,
    (float16_t)0.989400428f,  (float16_t)0.145212925f,
    (float16_t)0.989176510f,  (float16_t)0.146730474f,
    (float16_t)0.988950265f,  (float16_t)0.148247679f,
    (float16_t)0.988721692f,  (float16_t)0.149764535f,
    (float16_t)0.988490793f,  (float16_t)0.151281038f,
    (float16_t)0.988257568f,  (float16_t)0.152797185f,
    (float16_t)0.988022017f,  (float16_t)0.154312973f,
    (float16_t)0.987784142f,  (float16_t)0.155828398f,
    (float16_t)0.987543942f,  (float16_t)0.157343456f,
    (float16_t)0.987301418f,  (float16_t)0.158858143f,
    (float16_t)0.987056571f,  (float16_t)0.160372457f,
    (float16_t)0.986809402f,  (float16_t)0.161886394f,
    (float16_t)0.986559910f,  (float16_t)0.163399949f,
    (float16_t)0.986308097f,  (float16_t)0.164913120f,
    (float16_t)0.986053963f,  (float16_t)0.166425904f,
    (float16_t)0.985797509f,  (float16_t)0.167938295f,
    (float16_t)0.985538735f,  (float16_t)0.169450291f,
    (float16_t)0.985277642f,  (float16_t)0.170961889f,
    (float16_t)0.985014231f,  (float16_t)0.172473084f,
    (float16_t)0.984748502f,  (float16_t)0.173983873f,
    (float16_t)0.984480455f,  (float16_t)0.175494253f,
    (float16_t)0.984210092f,  (float16_t)0.177004220f,
    (float16_t)0.983937413f,  (float16_t)0.178513771f,
    (float16_t)0.983662419f,  (float16_t)0.180022901f,
    (float16_t)0.983385110f,  (float16_t)0.181531608f,
    (float16_t)0.983105487f,  (float16_t)0.183039888f,
    (float16_t)0.982823551f,  (float16_t)0.184547737f,
    (float16_t)0.982539302f,  (float16_t)0.186055152f,
    (float16_t)0.982252741f,  (float16_t)0.187562129f,
    (float16_t)0.981963869f,  (float16_t)0.189068664f,
    (float16_t)0.981672686f,  (float16_t)0.190574755f,
    (float16_t)0.981379193f,  (float16_t)0.192080397f,
    (float16_t)0.981083391f,  (float16_t)0.193585587f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.980484862f,  (float16_t)0.196594598f,
    (float16_t)0.980182136f,  (float16_t)0.198098411f,
    (float16_t)0.979877104f,  (float16_t)0.199601758f,
    (float16_t)0.979569766f,  (float16_t)0.201104635f,
    (float16_t)0.979260123f,  (float16_t)0.202607039f,
    (float16_t)0.978948175f,  (float16_t)0.204108966f,
    (float16_t)0.978633924f,  (float16_t)0.205610413f,
    (float16_t)0.978317371f,  (float16_t)0.207111376f,
    (float16_t)0.977998515f,  (float16_t)0.208611852f,
    (float16_t)0.977677358f,  (float16_t)0.210111837f,
    (float16_t)0.977353900f,  (float16_t)0.211611327f,
    (float16_t)0.977028143f,  (float16_t)0.213110320f,
    (float16_t)0.976700086f,  (float16_t)0.214608811f,
    (float16_t)0.976369731f,  (float16_t)0.216106797f,
    (float16_t)0.976037079f,  (float16_t)0.217604275f,
    (float16_t)0.975702130f,  (float16_t)0.219101240f,
    (float16_t)0.975364885f,  (float16_t)0.220597690f,
    (float16_t)0.975025345f,  (float16_t)0.222093621f,
    (float16_t)0.974683511f,  (float16_t)0.223589029f,
    (float16_t)0.974339383f,  (float16_t)0.225083911f,
    (float16_t)0.973992962f,  (float16_t)0.226578264f,
    (float16_t)0.973644250f,  (float16_t)0.228072083f,
    (float16_t)0.973293246f,  (float16_t)0.229565366f,
    (float16_t)0.972939952f,  (float16_t)0.231058108f,
    (float16_t)0.972584369f,  (float16_t)0.232550307f,
    (float16_t)0.972226497f,  (float16_t)0.234041959f,
    (float16_t)0.971866337f,  (float16_t)0.235533059f,
    (float16_t)0.971503891f,  (float16_t)0.237023606f,
    (float16_t)0.971139158f,  (float16_t)0.238513595f,
    (float16_t)0.970772141f,  (float16_t)0.240003022f,
    (float16_t)0.970402839f,  (float16_t)0.241491885f,
    (float16_t)0.970031253f,  (float16_t)0.242980180f,
    (float16_t)0.969657385f,  (float16_t)0.244467903f,
    (float16_t)0.969281235f,  (float16_t)0.245955050f,
    (float16_t)0.968902805f,  (float16_t)0.247441619f,
    (float16_t)0.968522094f,  (float16_t)0.248927606f,
    (float16_t)0.968139105f,  (float16_t)0.250413007f,
    (float16_t)0.967753837f,  (float16_t)0.251897818f,
    (float16_t)0.967366292f,  (float16_t)0.253382037f,
    (float16_t)0.966976471f,  (float16_t)0.254865660f,
    (float16_t)0.966584374f,  (float16_t)0.256348682f,
    (float16_t)0.966190003f,  (float16_t)0.257831102f,
    (float16_t)0.965793359f,  (float16_t)0.259312915f,
    (float16_t)0.965394442f,  (float16_t)0.260794118f,
    (float16_t)0.964993253f,  (float16_t)0.262274707f,
    (float16_t)0.964589793f,  (float16_t)0.263754679f,
    (float16_t)0.964184064f,  (float16_t)0.265234030f,
    (float16_t)0.963776066f,  (float16_t)0.266712757f,
    (float16_t)0.963365800f,  (float16_t)0.268190857f,
    (float16_t)0.962953267f,  (float16_t)0.269668326f,
    (float16_t)0.962538468f,  (float16_t)0.271145160f,
    (float16_t)0.962121404f,  (float16_t)0.272621355f,
    (float16_t)0.961702077f,  (float16_t)0.274096910f,
    (float16_t)0.961280486f,  (float16_t)0.275571819f,
    (float16_t)0.960856633f,  (float16_t)0.277046080f,
    (float16_t)0.960430519f,  (float16_t)0.278519689f,
    (float16_t)0.960002146f,  (float16_t)0.279992643f,
    (float16_t)0.959571513f,  (float16_t)0.281464938f,
    (float16_t)0.959138622f,  (float16_t)0.282936570f,
    (float16_t)0.958703475f,  (float16_t)0.284407537f,
    (float16_t)0.958266071f,  (float16_t)0.285877835f,
    (float16_t)0.957826413f,  (float16_t)0.287347460f,
    (float16_t)0.957384501f,  (float16_t)0.288816408f,
    (float16_t)0.956940336f,  (float16_t)0.290284677f,
    (float16_t)0.956493919f,  (float16_t)0.291752263f,
    (float16_t)0.956045251f,  (float16_t)0.293219163f,
    (float16_t)0.955594334f,  (float16_t)0.294685372f,
    (float16_t)0.955141168f,  (float16_t)0.296150888f,
    (float16_t)0.954685755f,  (float16_t)0.297615707f,
    (float16_t)0.954228095f,  (float16_t)0.299079826f,
    (float16_t)0.953768190f,  (float16_t)0.300543241f,
    (float16_t)0.953306040f,  (float16_t)0.302005949f,
    (float16_t)0.952841648f,  (float16_t)0.303467947f,
    (float16_t)0.952375013f,  (float16_t)0.304929230f,
    (float16_t)0.951906137f,  (float16_t)0.306389795f,
    (float16_t)0.951435021f,  (float16_t)0.307849640f,
    (float16_t)0.950961666f,  (float16_t)0.309308760f,
    (float16_t)0.950486074f,  (float16_t)0.310767153f,
    (float16_t)0.950008245f,  (float16_t)0.312224814f,
    (float16_t)0.949528181f,  (float16_t)0.313681740f,
    (float16_t)0.949045882f,  (float16_t)0.315137929f,
    (float16_t)0.948561350f,  (float16_t)0.316593376f,
    (float16_t)0.948074586f,  (float16_t)0.318048077f,
    (float16_t)0.947585591f,  (float16_t)0.319502031f,
    (float16_t)0.947094366f,  (float16_t)0.320955232f,
    (float16_t)0.946600913f,  (float16_t)0.322407679f,
    (float16_t)0.946105232f,  (float16_t)0.323859367f,
    (float16_t)0.945607325f,  (float16_t)0.325310292f,
    (float16_t)0.945107193f,  (float16_t)0.326760452f,
    (float16_t)0.944604837f,  (float16_t)0.328209844f,
    (float16_t)0.944100258f,  (float16_t)0.329658463f,
    (float16_t)0.943593458f,  (float16_t)0.331106306f,
    (float16_t)0.943084437f,  (float16_t)0.332553370f,
    (float16_t)0.942573198f,  (float16_t)0.333999651f,
    (float16_t)0.942059740f,  (float16_t)0.335445147f,
    (float16_t)0.941544065f,  (float16_t)0.336889853f,
    (float16_t)0.941026175f,  (float16_t)0.338333767f,
    (float16_t)0.940506071f,  (float16_t)0.339776884f,
    (float16_t)0.939983753f,  (float16_t)0.341219202f,
    (float16_t)0.939459224f,  (float16_t)0.342660717f,
    (float16_t)0.938932484f,  (float16_t)0.344101426f,
    (float16_t)0.938403534f,  (float16_t)0.345541325f,
    (float16_t)0.937872376f,  (float16_t)0.346980411f,
    (float16_t)0.937339012f,  (float16_t)0.348418680f,
    (float16_t)0.936803442f,  (float16_t)0.349856130f,
    (float16_t)0.936265667f,  (float16_t)0.351292756f,
    (float16_t)0.935725689f,  (float16_t)0.352728556f,
    (float16_t)0.935183510f,  (float16_t)0.354163525f,
    (float16_t)0.934639130f,  (float16_t)0.355597662f,
    (float16_t)0.934092550f,  (float16_t)0.357030961f,
    (float16_t)0.933543773f,  (float16_t)0.358463421f,
    (float16_t)0.932992799f,  (float16_t)0.359895037f,
    (float16_t)0.932439629f,  (float16_t)0.361325806f,
    (float16_t)0.931884266f,  (float16_t)0.362755724f,
    (float16_t)0.931326709f,  (float16_t)0.364184790f,
    (float16_t)0.930766961f,  (float16_t)0.365612998f,
    (float16_t)0.930205023f,  (float16_t)0.367040346f,
    (float16_t)0.929640896f,  (float16_t)0.368466830f,
    (float16_t)0.929074581f,  (float16_t)0.369892447f,
    (float16_t)0.928506080f,  (float16_t)0.371317194f,
    (float16_t)0.927935395f,  (float16_t)0.372741067f,
    (float16_t)0.927362526f,  (float16_t)0.374164063f,
    (float16_t)0.926787474f,  (float16_t)0.375586178f,
    (float16_t)0.926210242f,  (float16_t)0.377007410f,
    (float16_t)0.925630831f,  (float16_t)0.378427755f,
    (float16_t)0.925049241f,  (float16_t)0.379847209f,
    (float16_t)0.924465474f,  (float16_t)0.381265769f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.923291417f,  (float16_t)0.384100195f,
    (float16_t)0.922701128f,  (float16_t)0.385516054f,
    (float16_t)0.922108669f,  (float16_t)0.386931006f,
    (float16_t)0.921514039f,  (float16_t)0.388345047f,
    (float16_t)0.920917242f,  (float16_t)0.389758174f,
    (float16_t)0.920318277f,  (float16_t)0.391170384f,
    (float16_t)0.919717146f,  (float16_t)0.392581674f,
    (float16_t)0.919113852f,  (float16_t)0.393992040f,
    (float16_t)0.918508394f,  (float16_t)0.395401479f,
    (float16_t)0.917900776f,  (float16_t)0.396809987f,
    (float16_t)0.917290997f,  (float16_t)0.398217562f,
    (float16_t)0.916679060f,  (float16_t)0.399624200f,
    (float16_t)0.916064966f,  (float16_t)0.401029897f,
    (float16_t)0.915448716f,  (float16_t)0.402434651f,
    (float16_t)0.914830312f,  (float16_t)0.403838458f,
    (float16_t)0.914209756f,  (float16_t)0.405241314f,
    (float16_t)0.913587048f,  (float16_t)0.406643217f,
    (float16_t)0.912962190f,  (float16_t)0.408044163f,
    (float16_t)0.912335185f,  (float16_t)0.409444149f,
    (float16_t)0.911706032f,  (float16_t)0.410843171f,
    (float16_t)0.911074734f,  (float16_t)0.412241227f,
    (float16_t)0.910441292f,  (float16_t)0.413638312f,
    (float16_t)0.909805708f,  (float16_t)0.415034424f,
    (float16_t)0.909167983f,  (float16_t)0.416429560f,
    (float16_t)0.908528119f,  (float16_t)0.417823716f,
    (float16_t)0.907886116f,  (float16_t)0.419216888f,
    (float16_t)0.907241978f,  (float16_t)0.420609074f,
    (float16_t)0.906595705f,  (float16_t)0.422000271f,
    (float16_t)0.905947298f,  (float16_t)0.423390474f,
    (float16_t)0.905296759f,  (float16_t)0.424779681f,
    (float16_t)0.904644091f,  (float16_t)0.426167889f,
    (float16_t)0.903989293f,  (float16_t)0.427555093f,
    (float16_t)0.903332368f,  (float16_t)0.428941292f,
    (float16_t)0.902673318f,  (float16_t)0.430326481f,
    (float16_t)0.902012144f,  (float16_t)0.431710658f,
    (float16_t)0.901348847f,  (float16_t)0.433093819f,
    (float16_t)0.900683429f,  (float16_t)0.434475961f,
    (float16_t)0.900015892f,  (float16_t)0.435857080f,
    (float16_t)0.899346237f,  (float16_t)0.437237174f,
    (float16_t)0.898674466f,  (float16_t)0.438616239f,
    (float16_t)0.898000580f,  (float16_t)0.439994271f,
    (float16_t)0.897324581f,  (float16_t)0.441371269f,
    (float16_t)0.896646470f,  (float16_t)0.442747228f,
    (float16_t)0.895966250f,  (float16_t)0.444122145f,
    (float16_t)0.895283921f,  (float16_t)0.445496017f,
    (float16_t)0.894599486f,  (float16_t)0.446868840f,
    (float16_t)0.893912945f,  (float16_t)0.448240612f,
    (float16_t)0.893224301f,  (float16_t)0.449611330f,
    (float16_t)0.892533555f,  (float16_t)0.450980989f,
    (float16_t)0.891840709f,  (float16_t)0.452349587f,
    (float16_t)0.891145765f,  (float16_t)0.453717121f,
    (float16_t)0.890448723f,  (float16_t)0.455083587f,
    (float16_t)0.889749586f,  (float16_t)0.456448982f,
    (float16_t)0.889048356f,  (float16_t)0.457813304f,
    (float16_t)0.888345033f,  (float16_t)0.459176548f,
    (float16_t)0.887639620f,  (float16_t)0.460538711f,
    (float16_t)0.886932119f,  (float16_t)0.461899791f,
    (float16_t)0.886222530f,  (float16_t)0.463259784f,
    (float16_t)0.885510856f,  (float16_t)0.464618686f,
    (float16_t)0.884797098f,  (float16_t)0.465976496f,
    (float16_t)0.884081259f,  (float16_t)0.467333209f,
    (float16_t)0.883363339f,  (float16_t)0.468688822f,
    (float16_t)0.882643340f,  (float16_t)0.470043332f,
    (float16_t)0.881921264f,  (float16_t)0.471396737f,
    (float16_t)0.881197113f,  (float16_t)0.472749032f,
    (float16_t)0.880470889f,  (float16_t)0.474100215f,
    (float16_t)0.879742593f,  (float16_t)0.475450282f,
    (float16_t)0.879012226f,  (float16_t)0.476799230f,
    (float16_t)0.878279792f,  (float16_t)0.478147056f,
    (float16_t)0.877545290f,  (float16_t)0.479493758f,
    (float16_t)0.876808724f,  (float16_t)0.480839331f,
    (float16_t)0.876070094f,  (float16_t)0.482183772f,
    (float16_t)0.875329403f,  (float16_t)0.483527079f,
    (float16_t)0.874586652f,  (float16_t)0.484869248f,
    (float16_t)0.873841843f,  (float16_t)0.486210276f,
    (float16_t)0.873094978f,  (float16_t)0.487550160f,
    (float16_t)0.872346059f,  (float16_t)0.488888897f,
    (float16_t)0.871595087f,  (float16_t)0.490226483f,
    (float16_t)0.870842063f,  (float16_t)0.491562916f,
    (float16_t)0.870086991f,  (float16_t)0.492898192f,
    (float16_t)0.869329871f,  (float16_t)0.494232309f,
    (float16_t)0.868570706f,  (float16_t)0.495565262f,
    (float16_t)0.867809497f,  (float16_t)0.496897049f,
    (float16_t)0.867046246f,  (float16_t)0.498227667f,
    (float16_t)0.866280954f,  (float16_t)0.499557113f,
    (float16_t)0.865513624f,  (float16_t)0.500885383f,
    (float16_t)0.864744258f,  (float16_t)0.502212474f,
    (float16_t)0.863972856f,  (float16_t)0.503538384f,
    (float16_t)0.863199422f,  (float16_t)0.504863109f,
    (float16_t)0.862423956f,  (float16_t)0.506186645f,
    (float16_t)0.861646461f,  (float16_t)0.507508991f,
    (float16_t)0.860866939f,  (float16_t)0.508830143f,
    (float16_t)0.860085390f,  (float16_t)0.510150097f,
    (float16_t)0.859301818f,  (float16_t)0.511468850f,
    (float16_t)0.858516224f,  (float16_t)0.512786401f,
    (float16_t)0.857728610f,  (float16_t)0.514102744f,
    (float16_t)0.856938977f,  (float16_t)0.515417878f,
    (float16_t)0.856147328f,  (float16_t)0.516731799f,
    (float16_t)0.855353665f,  (float16_t)0.518044504f,
    (float16_t)0.854557988f,  (float16_t)0.519355990f,
    (float16_t)0.853760301f,  (float16_t)0.520666254f,
    (float16_t)0.852960605f,  (float16_t)0.521975293f,
    (float16_t)0.852158902f,  (float16_t)0.523283103f,
    (float16_t)0.851355193f,  (float16_t)0.524589683f,
    (float16_t)0.850549481f,  (float16_t)0.525895027f,
    (float16_t)0.849741768f,  (float16_t)0.527199135f,
    (float16_t)0.848932055f,  (float16_t)0.528502002f,
    (float16_t)0.848120345f,  (float16_t)0.529803625f,
    (float16_t)0.847306639f,  (float16_t)0.531104001f,
    (float16_t)0.846490939f,  (float16_t)0.532403128f,
    (float16_t)0.845673247f,  (float16_t)0.533701002f,
    (float16_t)0.844853565f,  (float16_t)0.534997620f,
    (float16_t)0.844031895f,  (float16_t)0.536292979f,
    (float16_t)0.843208240f,  (float16_t)0.537587076f,
    (float16_t)0.842382600f,  (float16_t)0.538879909f,
    (float16_t)0.841554977f,  (float16_t)0.540171473f,
    (float16_t)0.840725375f,  (float16_t)0.541461766f,
    (float16_t)0.839893794f,  (float16_t)0.542750785f,
    (float16_t)0.839060237f,  (float16_t)0.544038527f,
    (float16_t)0.838224706f,  (float16_t)0.545324988f,
    (float16_t)0.837387202f,  (float16_t)0.546610167f,
    (float16_t)0.836547727f,  (float16_t)0.547894059f,
    (float16_t)0.835706284f,  (float16_t)0.549176662f,
    (float16_t)0.834862875f,  (float16_t)0.550457973f,
    (float16_t)0.834017501f,  (float16_t)0.551737988f,
    (float16_t)0.833170165f,  (float16_t)0.553016706f,
    (float16_t)0.832320868f,  (float16_t)0.554294121f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.830616400f,  (float16_t)0.556845037f,
    (float16_t)0.829761234f,  (float16_t)0.558118531f,
    (float16_t)0.828904115f,  (float16_t)0.559390712f,
    (float16_t)0.828045045f,  (float16_t)0.560661576f,
    (float16_t)0.827184027f,  (float16_t)0.561931121f,
    (float16_t)0.826321063f,  (float16_t)0.563199344f,
    (float16_t)0.825456154f,  (float16_t)0.564466242f,
    (float16_t)0.824589303f,  (float16_t)0.565731811f,
    (float16_t)0.823720511f,  (float16_t)0.566996049f,
    (float16_t)0.822849781f,  (float16_t)0.568258953f,
    (float16_t)0.821977115f,  (float16_t)0.569520519f,
    (float16_t)0.821102515f,  (float16_t)0.570780746f,
    (float16_t)0.820225983f,  (float16_t)0.572039629f,
    (float16_t)0.819347520f,  (float16_t)0.573297167f,
    (float16_t)0.818467130f,  (float16_t)0.574553355f,
    (float16_t)0.817584813f,  (float16_t)0.575808191f,
    (float16_t)0.816700573f,  (float16_t)0.577061673f,
    (float16_t)0.815814411f,  (float16_t)0.578313796f,
    (float16_t)0.814926329f,  (float16_t)0.579564559f,
    (float16_t)0.814036330f,  (float16_t)0.580813958f,
    (float16_t)0.813144415f,  (float16_t)0.582061990f,
    (float16_t)0.812250587f,  (float16_t)0.583308653f,
    (float16_t)0.811354847f,  (float16_t)0.584553943f,
    (float16_t)0.810457198f,  (float16_t)0.585797857f,
    (float16_t)0.809557642f,  (float16_t)0.587040394f,
    (float16_t)0.808656182f,  (float16_t)0.588281548f,
    (float16_t)0.807752818f,  (float16_t)0.589521319f,
    (float16_t)0.806847554f,  (float16_t)0.590759702f,
    (float16_t)0.805940391f,  (float16_t)0.591996695f,
    (float16_t)0.805031331f,  (float16_t)0.593232295f,
    (float16_t)0.804120377f,  (float16_t)0.594466499f,
    (float16_t)0.803207531f,  (float16_t)0.595699304f,
    (float16_t)0.802292796f,  (float16_t)0.596930708f,
    (float16_t)0.801376172f,  (float16_t)0.598160707f,
    (float16_t)0.800457662f,  (float16_t)0.599389298f,
    (float16_t)0.799537269f,  (float16_t)0.600616479f,
    (float16_t)0.798614995f,  (float16_t)0.601842247f,
    (float16_t)0.797690841f,  (float16_t)0.603066599f,
    (float16_t)0.796764810f,  (float16_t)0.604289531f,
    (float16_t)0.795836905f,  (float16_t)0.605511041f,
    (float16_t)0.794907126f,  (float16_t)0.606731127f,
    (float16_t)0.793975478f,  (float16_t)0.607949785f,
    (float16_t)0.793041960f,  (float16_t)0.609167012f,
    (float16_t)0.792106577f,  (float16_t)0.610382806f,
    (float16_t)0.791169330f,  (float16_t)0.611597164f,
    (float16_t)0.790230221f,  (float16_t)0.612810082f,
    (float16_t)0.789289253f,  (float16_t)0.614021559f,
    (float16_t)0.788346428f,  (float16_t)0.615231591f,
    (float16_t)0.787401747f,  (float16_t)0.616440175f,
    (float16_t)0.786455214f,  (float16_t)0.617647308f,
    (float16_t)0.785506830f,  (float16_t)0.618852988f,
    (float16_t)0.784556597f,  (float16_t)0.620057212f,
    (float16_t)0.783604519f,  (float16_t)0.621259977f,
    (float16_t)0.782650596f,  (float16_t)0.622461279f,
    (float16_t)0.781694832f,  (float16_t)0.623661118f,
    (float16_t)0.780737229f,  (float16_t)0.624859488f,
    (float16_t)0.779777788f,  (float16_t)0.626056388f,
    (float16_t)0.778816512f,  (float16_t)0.627251815f,
    (float16_t)0.777853404f,  (float16_t)0.628445767f,
    (float16_t)0.776888466f,  (float16_t)0.629638239f,
    (float16_t)0.775921699f,  (float16_t)0.630829230f,
    (float16_t)0.774953107f,  (float16_t)0.632018736f,
    (float16_t)0.773982691f,  (float16_t)0.633206755f,
    (float16_t)0.773010453f,  (float16_t)0.634393284f,
    (float16_t)0.772036397f,  (float16_t)0.635578320f,
    (float16_t)0.771060524f,  (float16_t)0.636761861f,
    (float16_t)0.770082837f,  (float16_t)0.637943904f,
    (float16_t)0.769103338f,  (float16_t)0.639124445f,
    (float16_t)0.768122029f,  (float16_t)0.640303482f,
    (float16_t)0.767138912f,  (float16_t)0.641481013f,
    (float16_t)0.766153990f,  (float16_t)0.642657034f,
    (float16_t)0.765167266f,  (float16_t)0.643831543f,
    (float16_t)0.764178741f,  (float16_t)0.645004537f,
    (float16_t)0.763188417f,  (float16_t)0.646176013f,
    (float16_t)0.762196298f,  (float16_t)0.647345969f,
    (float16_t)0.761202385f,  (float16_t)0.648514401f,
    (float16_t)0.760206682f,  (float16_t)0.649681307f,
    (float16_t)0.759209189f,  (float16_t)0.650846685f,
    (float16_t)0.758209910f,  (float16_t)0.652010531f,
    (float16_t)0.757208847f,  (float16_t)0.653172843f,
    (float16_t)0.756206001f,  (float16_t)0.654333618f,
    (float16_t)0.755201377f,  (float16_t)0.655492853f,
    (float16_t)0.754194975f,  (float16_t)0.656650546f,
    (float16_t)0.753186799f,  (float16_t)0.657806693f,
    (float16_t)0.752176850f,  (float16_t)0.658961293f,
    (float16_t)0.751165132f,  (float16_t)0.660114342f,
    (float16_t)0.750151646f,  (float16_t)0.661265838f,
    (float16_t)0.749136395f,  (float16_t)0.662415778f,
    (float16_t)0.748119380f,  (float16_t)0.663564159f,
    (float16_t)0.747100606f,  (float16_t)0.664710978f,
    (float16_t)0.746080074f,  (float16_t)0.665856234f,
    (float16_t)0.745057785f,  (float16_t)0.666999922f,
    (float16_t)0.744033744f,  (float16_t)0.668142041f,
    (float16_t)0.743007952f,  (float16_t)0.669282588f,
    (float16_t)0.741980412f,  (float16_t)0.670421560f,
    (float16_t)0.740951125f,  (float16_t)0.671558955f,
    (float16_t)0.739920095f,  (float16_t)0.672694769f,
    (float16_t)0.738887324f,  (float16_t)0.673829000f,
    (float16_t)0.737852815f,  (float16_t)0.674961646f,
    (float16_t)0.736816569f,  (float16_t)0.676092704f,
    (float16_t)0.735778589f,  (float16_t)0.677222170f,
    (float16_t)0.734738878f,  (float16_t)0.678350043f,
    (float16_t)0.733697438f,  (float16_t)0.679476320f,
    (float16_t)0.732654272f,  (float16_t)0.680600998f,
    (float16_t)0.731609381f,  (float16_t)0.681724074f,
    (float16_t)0.730562769f,  (float16_t)0.682845546f,
    (float16_t)0.729514438f,  (float16_t)0.683965412f,
    (float16_t)0.728464390f,  (float16_t)0.685083668f,
    (float16_t)0.727412629f,  (float16_t)0.686200312f,
    (float16_t)0.726359155f,  (float16_t)0.687315341f,
    (float16_t)0.725303972f,  (float16_t)0.688428753f,
    (float16_t)0.724247083f,  (float16_t)0.689540545f,
    (float16_t)0.723188489f,  (float16_t)0.690650714f,
    (float16_t)0.722128194f,  (float16_t)0.691759258f,
    (float16_t)0.721066199f,  (float16_t)0.692866175f,
    (float16_t)0.720002508f,  (float16_t)0.693971461f,
    (float16_t)0.718937122f,  (float16_t)0.695075114f,
    (float16_t)0.717870045f,  (float16_t)0.696177131f,
    (float16_t)0.716801279f,  (float16_t)0.697277511f,
    (float16_t)0.715730825f,  (float16_t)0.698376249f,
    (float16_t)0.714658688f,  (float16_t)0.699473345f,
    (float16_t)0.713584869f,  (float16_t)0.700568794f,
    (float16_t)0.712509371f,  (float16_t)0.701662595f,
    (float16_t)0.711432196f,  (float16_t)0.702754744f,
    (float16_t)0.710353347f,  (float16_t)0.703845241f,
    (float16_t)0.709272826f,  (float16_t)0.704934080f,
    (float16_t)0.708190637f,  (float16_t)0.706021261f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.706021261f,  (float16_t)0.708190637f,
    (float16_t)0.704934080f,  (float16_t)0.709272826f,
    (float16_t)0.703845241f,  (float16_t)0.710353347f,
    (float16_t)0.702754744f,  (float16_t)0.711432196f,
    (float16_t)0.701662595f,  (float16_t)0.712509371f,
    (float16_t)0.700568794f,  (float16_t)0.713584869f,
    (float16_t)0.699473345f,  (float16_t)0.714658688f,
    (float16_t)0.698376249f,  (float16_t)0.715730825f,
    (float16_t)0.697277511f,  (float16_t)0.716801279f,
    (float16_t)0.696177131f,  (float16_t)0.717870045f,
    (float16_t)0.695075114f,  (float16_t)0.718937122f,
    (float16_t)0.693971461f,  (float16_t)0.720002508f,
    (float16_t)0.692866175f,  (float16_t)0.721066199f,
    (float16_t)0.691759258f,  (float16_t)0.722128194f,
    (float16_t)0.690650714f,  (float16_t)0.723188489f,
    (float16_t)0.689540545f,  (float16_t)0.724247083f,
    (float16_t)0.688428753f,  (float16_t)0.725303972f,
    (float16_t)0.687315341f,  (float16_t)0.726359155f,
    (float16_t)0.686200312f,  (float16_t)0.727412629f,
    (float16_t)0.685083668f,  (float16_t)0.728464390f,
    (float16_t)0.683965412f,  (float16_t)0.729514438f,
    (float16_t)0.682845546f,  (float16_t)0.730562769f,
    (float16_t)0.681724074f,  (float16_t)0.731609381f,
    (float16_t)0.680600998f,  (float16_t)0.732654272f,
    (float16_t)0.679476320f,  (float16_t)0.733697438f,
    (float16_t)0.678350043f,  (float16_t)0.734738878f,
    (float16_t)0.677222170f,  (float16_t)0.735778589f,
    (float16_t)0.676092704f,  (float16_t)0.736816569f,
    (float16_t)0.674961646f,  (float16_t)0.737852815f,
    (float16_t)0.673829000f,  (float16_t)0.738887324f,
    (float16_t)0.672694769f,  (float16_t)0.739920095f,
    (float16_t)0.671558955f,  (float16_t)0.740951125f,
    (float16_t)0.670421560f,  (float16_t)0.741980412f,
    (float16_t)0.669282588f,  (float16_t)0.743007952f,
    (float16_t)0.668142041f,  (float16_t)0.744033744f,
    (float16_t)0.666999922f,  (float16_t)0.745057785f,
    (float16_t)0.665856234f,  (float16_t)0.746080074f,
    (float16_t)0.664710978f,  (float16_t)0.747100606f,
    (float16_t)0.663564159f,  (float16_t)0.748119380f,
    (float16_t)0.662415778f,  (float16_t)0.749136395f,
    (float16_t)0.661265838f,  (float16_t)0.750151646f,
    (float16_t)0.660114342f,  (float16_t)0.751165132f,
    (float16_t)0.658961293f,  (float16_t)0.752176850f,
    (float16_t)0.657806693f,  (float16_t)0.753186799f,
    (float16_t)0.656650546f,  (float16_t)0.754194975f,
    (float16_t)0.655492853f,  (float16_t)0.755201377f,
    (float16_t)0.654333618f,  (float16_t)0.756206001f,
    (float16_t)0.653172843f,  (float16_t)0.757208847f,
    (float16_t)0.652010531f,  (float16_t)0.758209910f,
    (float16_t)0.650846685f,  (float16_t)0.759209189f,
    (float16_t)0.649681307f,  (float16_t)0.760206682f,
    (float16_t)0.648514401f,  (float16_t)0.761202385f,
    (float16_t)0.647345969f,  (float16_t)0.762196298f,
    (float16_t)0.646176013f,  (float16_t)0.763188417f,
    (float16_t)0.645004537f,  (float16_t)0.764178741f,
    (float16_t)0.643831543f,  (float16_t)0.765167266f,
    (float16_t)0.642657034f,  (float16_t)0.766153990f,
    (float16_t)0.641481013f,  (float16_t)0.767138912f,
    (float16_t)0.640303482f,  (float16_t)0.768122029f,
    (float16_t)0.639124445f,  (float16_t)0.769103338f,
    (float16_t)0.637943904f,  (float16_t)0.770082837f,
    (float16_t)0.636761861f,  (float16_t)0.771060524f,
    (float16_t)0.635578320f,  (float16_t)0.772036397f,
    (float16_t)0.634393284f,  (float16_t)0.773010453f,
    (float16_t)0.633206755f,  (float16_t)0.773982691f,
    (float16_t)0.632018736f,  (float16_t)0.774953107f,
    (float16_t)0.630829230f,  (float16_t)0.775921699f,
    (float16_t)0.629638239f,  (float16_t)0.776888466f,
    (float16_t)0.628445767f,  (float16_t)0.777853404f,
    (float16_t)0.627251815f,  (float16_t)0.778816512f,
    (float16_t)0.626056388f,  (float16_t)0.779777788f,
    (float16_t)0.624859488f,  (float16_t)0.780737229f,
    (float16_t)0.623661118f,  (float16_t)0.781694832f,
    (float16_t)0.622461279f,  (float16_t)0.782650596f,
    (float16_t)0.621259977f,  (float16_t)0.783604519f,
    (float16_t)0.620057212f,  (float16_t)0.784556597f,
    (float16_t)0.618852988f,  (float16_t)0.785506830f,
    (float16_t)0.617647308f,  (float16_t)0.786455214f,
    (float16_t)0.616440175f,  (float16_t)0.787401747f,
    (float16_t)0.615231591f,  (float16_t)0.788346428f,
    (float16_t)0.614021559f,  (float16_t)0.789289253f,
    (float16_t)0.612810082f,  (float16_t)0.790230221f,
    (float16_t)0.611597164f,  (float16_t)0.791169330f,
    (float16_t)0.610382806f,  (float16_t)0.792106577f,
    (float16_t)0.609167012f,  (float16_t)0.793041960f,
    (float16_t)0.607949785f,  (float16_t)0.793975478f,
    (float16_t)0.606731127f,  (float16_t)0.794907126f,
    (float16_t)0.605511041f,  (float16_t)0.795836905f,
    (float16_t)0.604289531f,  (float16_t)0.796764810f,
    (float16_t)0.603066599f,  (float16_t)0.797690841f,
    (float16_t)0.601842247f,  (float16_t)0.798614995f,
    (float16_t)0.600616479f,  (float16_t)0.799537269f,
    (float16_t)0.599389298f,  (float16_t)0.800457662f,
    (float16_t)0.598160707f,  (float16_t)0.801376172f,
    (float16_t)0.596930708f,  (float16_t)0.802292796f,
    (float16_t)0.595699304f,  (float16_t)0.803207531f,
    (float16_t)0.594466499f,  (float16_t)0.804120377f,
    (float16_t)0.593232295f,  (float16_t)0.805031331f,
    (float16_t)0.591996695f,  (float16_t)0.805940391f,
    (float16_t)0.590759702f,  (float16_t)0.806847554f,
    (float16_t)0.589521319f,  (float16_t)0.807752818f,
    (float16_t)0.588281548f,  (float16_t)0.808656182f,
    (float16_t)0.587040394f,  (float16_t)0.809557642f,
    (float16_t)0.585797857f,  (float16_t)0.810457198f,
    (float16_t)0.584553943f,  (float16_t)0.811354847f,
    (float16_t)0.583308653f,  (float16_t)0.812250587f,
    (float16_t)0.582061990f,  (float16_t)0.813144415f,
    (float16_t)0.580813958f,  (float16_t)0.814036330f,
    (float16_t)0.579564559f,  (float16_t)0.814926329f,
    (float16_t)0.578313796f,  (float16_t)0.815814411f,
    (float16_t)0.577061673f,  (float16_t)0.816700573f,
    (float16_t)0.575808191f,  (float16_t)0.817584813f,
    (float16_t)0.574553355f,  (float16_t)0.818467130f,
    (float16_t)0.573297167f,  (float16_t)0.819347520f,
    (float16_t)0.572039629f,  (float16_t)0.820225983f,
    (float16_t)0.570780746f,  (float16_t)0.821102515f,
    (float16_t)0.569520519f,  (float16_t)0.821977115f,
    (float16_t)0.568258953f,  (float16_t)0.822849781f,
    (float16_t)0.566996049f,  (float16_t)0.823720511f,
    (float16_t)0.565731811f,  (float16_t)0.824589303f,
    (float16_t)0.564466242f,  (float16_t)0.825456154f,
    (float16_t)0.563199344f,  (float16_t)0.826321063f,
    (float16_t)0.561931121f,  (float16_t)0.827184027f,
    (float16_t)0.560661576f,  (float16_t)0.828045045f,
    (float16_t)0.559390712f,  (float16_t)0.828904115f,
    (float16_t)0.558118531f,  (float16_t)0.829761234f,
    (float16_t)0.556845037f,  (float16_t)0.830616400f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.554294121f,  (float16_t)0.832320868f,
    (float16_t)0.553016706f,  (float16_t)0.833170165f,
    (float16_t)0.551737988f,  (float16_t)0.834017501f,
    (float16_t)0.550457973f,  (float16_t)0.834862875f,
    (float16_t)0.549176662f,  (float16_t)0.835706284f,
    (float16_t)0.547894059f,  (float16_t)0.836547727f,
    (float16_t)0.546610167f,  (float16_t)0.837387202f,
    (float16_t)0.545324988f,  (float16_t)0.838224706f,
    (float16_t)0.544038527f,  (float16_t)0.839060237f,
    (float16_t)0.542750785f,  (float16_t)0.839893794f,
    (float16_t)0.541461766f,  (float16_t)0.840725375f,
    (float16_t)0.540171473f,  (float16_t)0.841554977f,
    (float16_t)0.538879909f,  (float16_t)0.842382600f,
    (float16_t)0.537587076f,  (float16_t)0.843208240f,
    (float16_t)0.536292979f,  (float16_t)0.844031895f,
    (float16_t)0.534997620f,  (float16_t)0.844853565f,
    (float16_t)0.533701002f,  (float16_t)0.845673247f,
    (float16_t)0.532403128f,  (float16_t)0.846490939f,
    (float16_t)0.531104001f,  (float16_t)0.847306639f,
    (float16_t)0.529803625f,  (float16_t)0.848120345f,
    (float16_t)0.528502002f,  (float16_t)0.848932055f,
    (float16_t)0.527199135f,  (float16_t)0.849741768f,
    (float16_t)0.525895027f,  (float16_t)0.850549481f,
    (float16_t)0.524589683f,  (float16_t)0.851355193f,
    (float16_t)0.523283103f,  (float16_t)0.852158902f,
    (float16_t)0.521975293f,  (float16_t)0.852960605f,
    (float16_t)0.520666254f,  (float16_t)0.853760301f,
    (float16_t)0.519355990f,  (float16_t)0.854557988f,
    (float16_t)0.518044504f,  (float16_t)0.855353665f,
    (float16_t)0.516731799f,  (float16_t)0.856147328f,
    (float16_t)0.515417878f,  (float16_t)0.856938977f,
    (float16_t)0.514102744f,  (float16_t)0.857728610f,
    (float16_t)0.512786401f,  (float16_t)0.858516224f,
    (float16_t)0.511468850f,  (float16_t)0.859301818f,
    (float16_t)0.510150097f,  (float16_t)0.860085390f,
    (float16_t)0.508830143f,  (float16_t)0.860866939f,
    (float16_t)0.507508991f,  (float16_t)0.861646461f,
    (float16_t)0.506186645f,  (float16_t)0.862423956f,
    (float16_t)0.504863109f,  (float16_t)0.863199422f,
    (float16_t)0.503538384f,  (float16_t)0.863972856f,
    (float16_t)0.502212474f,  (float16_t)0.864744258f,
    (float16_t)0.500885383f,  (float16_t)0.865513624f,
    (float16_t)0.499557113f,  (float16_t)0.866280954f,
    (float16_t)0.498227667f,  (float16_t)0.867046246f,
    (float16_t)0.496897049f,  (float16_t)0.867809497f,
    (float16_t)0.495565262f,  (float16_t)0.868570706f,
    (float16_t)0.494232309f,  (float16_t)0.869329871f,
    (float16_t)0.492898192f,  (float16_t)0.870086991f,
    (float16_t)0.491562916f,  (float16_t)0.870842063f,
    (float16_t)0.490226483f,  (float16_t)0.871595087f,
    (float16_t)0.488888897f,  (float16_t)0.872346059f,
    (float16_t)0.487550160f,  (float16_t)0.873094978f,
    (float16_t)0.486210276f,  (float16_t)0.873841843f,
    (float16_t)0.484869248f,  (float16_t)0.874586652f,
    (float16_t)0.483527079f,  (float16_t)0.875329403f,
    (float16_t)0.482183772f,  (float16_t)0.876070094f,
    (float16_t)0.480839331f,  (float16_t)0.876808724f,
    (float16_t)0.479493758f,  (float16_t)0.877545290f,
    (float16_t)0.478147056f,  (float16_t)0.878279792f,
    (float16_t)0.476799230f,  (float16_t)0.879012226f,
    (float16_t)0.475450282f,  (float16_t)0.879742593f,
    (float16_t)0.474100215f,  (float16_t)0.880470889f,
    (float16_t)0.472749032f,  (float16_t)0.881197113f,
    (float16_t)0.471396737f,  (float16_t)0.881921264f,
    (float16_t)0.470043332f,  (float16_t)0.882643340f,
    (float16_t)0.468688822f,  (float16_t)0.883363339f,
    (float16_t)0.467333209f,  (float16_t)0.884081259f,
    (float16_t)0.465976496f,  (float16_t)0.884797098f,
    (float16_t)0.464618686f,  (float16_t)0.885510856f,
    (float16_t)0.463259784f,  (float16_t)0.886222530f,
    (float16_t)0.461899791f,  (float16_t)0.886932119f,
    (float16_t)0.460538711f,  (float16_t)0.887639620f,
    (float16_t)0.459176548f,  (float16_t)0.888345033f,
    (float16_t)0.457813304f,  (float16_t)0.889048356f,
    (float16_t)0.456448982f,  (float16_t)0.889749586f,
    (float16_t)0.455083587f,  (float16_t)0.890448723f,
    (float16_t)0.453717121f,  (float16_t)0.891145765f,
    (float16_t)0.452349587f,  (float16_t)0.891840709f,
    (float16_t)0.450980989f,  (float16_t)0.892533555f,
    (float16_t)0.449611330f,  (float16_t)0.893224301f,
    (float16_t)0.448240612f,  (float16_t)0.893912945f,
    (float16_t)0.446868840f,  (float16_t)0.894599486f,
    (float16_t)0.445496017f,  (float16_t)0.895283921f,
    (float16_t)0.444122145f,  (float16_t)0.895966250f,
    (float16_t)0.442747228f,  (float16_t)0.896646470f,
    (float16_t)0.441371269f,  (float16_t)0.897324581f,
    (float16_t)0.439994271f,  (float16_t)0.898000580f,
    (float16_t)0.438616239f,  (float16_t)0.898674466f,
    (float16_t)0.437237174f,  (float16_t)0.899346237f,
    (float16_t)0.435857080f,  (float16_t)0.900015892f,
    (float16_t)0.434475961f,  (float16_t)0.900683429f,
    (float16_t)0.433093819f,  (float16_t)0.901348847f,
    (float16_t)0.431710658f,  (float16_t)0.902012144f,
    (float16_t)0.430326481f,  (float16_t)0.902673318f,
    (float16_t)0.428941292f,  (float16_t)0.903332368f,
    (float16_t)0.427555093f,  (float16_t)0.903989293f,
    (float16_t)0.426167889f,  (float16_t)0.904644091f,
    (float16_t)0.424779681f,  (float16_t)0.905296759f,
    (float16_t)0.423390474f,  (float16_t)0.905947298f,
    (float16_t)0.422000271f,  (float16_t)0.906595705f,
    (float16_t)0.420609074f,  (float16_t)0.907241978f,
    (float16_t)0.419216888f,  (float16_t)0.907886116f,
    (float16_t)0.417823716f,  (float16_t)0.908528119f,
    (float16_t)0.416429560f,  (float16_t)0.909167983f,
    (float16_t)0.415034424f,  (float16_t)0.909805708f,
    (float16_t)0.413638312f,  (float16_t)0.910441292f,
    (float16_t)0.412241227f,  (float16_t)0.911074734f,
    (float16_t)0.410843171f,  (float16_t)0.911706032f,
    (float16_t)0.409444149f,  (float16_t)0.912335185f,
    (float16_t)0.408044163f,  (float16_t)0.912962190f,
    (float16_t)0.406643217f,  (float16_t)0.913587048f,
    (float16_t)0.405241314f,  (float16_t)0.914209756f,
    (float16_t)0.403838458f,  (float16_t)0.914830312f,
    (float16_t)0.402434651f,  (float16_t)0.915448716f,
    (float16_t)0.401029897f,  (float16_t)0.916064966f,
    (float16_t)0.399624200f,  (float16_t)0.916679060f,
    (float16_t)0.398217562f,  (float16_t)0.917290997f,
    (float16_t)0.396809987f,  (float16_t)0.917900776f,
    (float16_t)0.395401479f,  (float16_t)0.918508394f,
    (float16_t)0.393992040f,  (float16_t)0.919113852f,
    (float16_t)0.392581674f,  (float16_t)0.919717146f,
    (float16_t)0.391170384f,  (float16_t)0.920318277f,
    (float16_t)0.389758174f,  (float16_t)0.920917242f,
    (float16_t)0.388345047f,  (float16_t)0.921514039f,
    (float16_t)0.386931006f,  (float16_t)0.922108669f,
    (float16_t)0.385516054f,  (float16_t)0.922701128f,
    (float16_t)0.384100195f,  (float16_t)0.923291417f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.381265769f,  (float16_t)0.924465474f,
    (float16_t)0.379847209f,  (float16_t)0.925049241f,
    (float16_t)0.378427755f,  (float16_t)0.925630831f,
    (float16_t)0.377007410f,  (float16_t)0.926210242f,
    (float16_t)0.375586178f,  (float16_t)0.926787474f,
    (float16_t)0.374164063f,  (float16_t)0.927362526f,
    (float16_t)0.372741067f,  (float16_t)0.927935395f,
    (float16_t)0.371317194f,  (float16_t)0.928506080f,
    (float16_t)0.369892447f,  (float16_t)0.929074581f,
    (float16_t)0.368466830f,  (float16_t)0.929640896f,
    (float16_t)0.367040346f,  (float16_t)0.930205023f,
    (float16_t)0.365612998f,  (float16_t)0.930766961f,
    (float16_t)0.364184790f,  (float16_t)0.931326709f,
    (float16_t)0.362755724f,  (float16_t)0.931884266f,
    (float16_t)0.361325806f,  (float16_t)0.932439629f,
    (float16_t)0.359895037f,  (float16_t)0.932992799f,
    (float16_t)0.358463421f,  (float16_t)0.933543773f,
    (float16_t)0.357030961f,  (float16_t)0.934092550f,
    (float16_t)0.355597662f,  (float16_t)0.934639130f,
    (float16_t)0.354163525f,  (float16_t)0.935183510f,
    (float16_t)0.352728556f,  (float16_t)0.935725689f,
    (float16_t)0.351292756f,  (float16_t)0.936265667f,
    (float16_t)0.349856130f,  (float16_t)0.936803442f,
    (float16_t)0.348418680f,  (float16_t)0.937339012f,
    (float16_t)0.346980411f,  (float16_t)0.937872376f,
    (float16_t)0.345541325f,  (float16_t)0.938403534f,
    (float16_t)0.344101426f,  (float16_t)0.938932484f,
    (float16_t)0.342660717f,  (float16_t)0.939459224f,
    (float16_t)0.341219202f,  (float16_t)0.939983753f,
    (float16_t)0.339776884f,  (float16_t)0.940506071f,
    (float16_t)0.338333767f,  (float16_t)0.941026175f,
    (float16_t)0.336889853f,  (float16_t)0.941544065f,
    (float16_t)0.335445147f,  (float16_t)0.942059740f,
    (float16_t)0.333999651f,  (float16_t)0.942573198f,
    (float16_t)0.332553370f,  (float16_t)0.943084437f,
    (float16_t)0.331106306f,  (float16_t)0.943593458f,
    (float16_t)0.329658463f,  (float16_t)0.944100258f,
    (float16_t)0.328209844f,  (float16_t)0.944604837f,
    (float16_t)0.326760452f,  (float16_t)0.945107193f,
    (float16_t)0.325310292f,  (float16_t)0.945607325f,
    (float16_t)0.323859367f,  (float16_t)0.946105232f,
    (float16_t)0.322407679f,  (float16_t)0.946600913f,
    (float16_t)0.320955232f,  (float16_t)0.947094366f,
    (float16_t)0.319502031f,  (float16_t)0.947585591f,
    (float16_t)0.318048077f,  (float16_t)0.948074586f,
    (float16_t)0.316593376f,  (float16_t)0.948561350f,
    (float16_t)0.315137929f,  (float16_t)0.949045882f,
    (float16_t)0.313681740f,  (float16_t)0.949528181f,
    (float16_t)0.312224814f,  (float16_t)0.950008245f,
    (float16_t)0.310767153f,  (float16_t)0.950486074f,
    (float16_t)0.309308760f,  (float16_t)0.950961666f,
    (float16_t)0.307849640f,  (float16_t)0.951435021f,
    (float16_t)0.306389795f,  (float16_t)0.951906137f,
    (float16_t)0.304929230f,  (float16_t)0.952375013f,
    (float16_t)0.303467947f,  (float16_t)0.952841648f,
    (float16_t)0.302005949f,  (float16_t)0.953306040f,
    (float16_t)0.300543241f,  (float16_t)0.953768190f,
    (float16_t)0.299079826f,  (float16_t)0.954228095f,
    (float16_t)0.297615707f,  (float16_t)0.954685755f,
    (float16_t)0.296150888f,  (float16_t)0.955141168f,
    (float16_t)0.294685372f,  (float16_t)0.955594334f,
    (float16_t)0.293219163f,  (float16_t)0.956045251f,
    (float16_t)0.291752263f,  (float16_t)0.956493919f,
    (float16_t)0.290284677f,  (float16_t)0.956940336f,
    (float16_t)0.288816408f,  (float16_t)0.957384501f,
    (float16_t)0.287347460f,  (float16_t)0.957826413f,
    (float16_t)0.285877835f,  (float16_t)0.958266071f,
    (float16_t)0.284407537f,  (float16_t)0.958703475f,
    (float16_t)0.282936570f,  (float16_t)0.959138622f,
    (float16_t)0.281464938f,  (float16_t)0.959571513f,
    (float16_t)0.279992643f,  (float16_t)0.960002146f,
    (float16_t)0.278519689f,  (float16_t)0.960430519f,
    (float16_t)0.277046080f,  (float16_t)0.960856633f,
    (float16_t)0.275571819f,  (float16_t)0.961280486f,
    (float16_t)0.274096910f,  (float16_t)0.961702077f,
    (float16_t)0.272621355f,  (float16_t)0.962121404f,
    (float16_t)0.271145160f,  (float16_t)0.962538468f,
    (float16_t)0.269668326f,  (float16_t)0.962953267f,
    (float16_t)0.268190857f,  (float16_t)0.963365800f,
    (float16_t)0.266712757f,  (float16_t)0.963776066f,
    (float16_t)0.265234030f,  (float16_t)0.964184064f,
    (float16_t)0.263754679f,  (float16_t)0.964589793f,
    (float16_t)0.262274707f,  (float16_t)0.964993253f,
    (float16_t)0.260794118f,  (float16_t)0.965394442f,
    (float16_t)0.259312915f,  (float16_t)0.965793359f,
    (float16_t)0.257831102f,  (float16_t)0.966190003f,
    (float16_t)0.256348682f,  (float16_t)0.966584374f,
    (float16_t)0.254865660f,  (float16_t)0.966976471f,
    (float16_t)0.253382037f,  (float16_t)0.967366292f,
    (float16_t)0.251897818f,  (float16_t)0.967753837f,
    (float16_t)0.250413007f,  (float16_t)0.968139105f,
    (float16_t)0.248927606f,  (float16_t)0.968522094f,
    (float16_t)0.247441619f,  (float16_t)0.968902805f,
    (float16_t)0.245955050f,  (float16_t)0.969281235f,
    (float16_t)0.244467903f,  (float16_t)0.969657385f,
    (float16_t)0.242980180f,  (float16_t)0.970031253f,
    (float16_t)0.241491885f,  (float16_t)0.970402839f,
    (float16_t)0.240003022f,  (float16_t)0.970772141f,
    (float16_t)0.238513595f,  (float16_t)0.971139158f,
    (float16_t)0.237023606f,  (float16_t)0.971503891f,
    (float16_t)0.235533059f,  (float16_t)0.971866337f,
    (float16_t)0.234041959f,  (float16_t)0.972226497f,
    (float16_t)0.232550307f,  (float16_t)0.972584369f,
    (float16_t)0.231058108f,  (float16_t)0.972939952f,
    (float16_t)0.229565366f,  (float16_t)0.973293246f,
    (float16_t)0.228072083f,  (float16_t)0.973644250f,
    (float16_t)0.226578264f,  (float16_t)0.973992962f,
    (float16_t)0.225083911f,  (float16_t)0.974339383f,
    (float16_t)0.223589029f,  (float16_t)0.974683511f,
    (float16_t)0.222093621f,  (float16_t)0.975025345f,
    (float16_t)0.220597690f,  (float16_t)0.975364885f,
    (float16_t)0.219101240f,  (float16_t)0.975702130f,
    (float16_t)0.217604275f,  (float16_t)0.976037079f,
    (float16_t)0.216106797f,  (float16_t)0.976369731f,
    (float16_t)0.214608811f,  (float16_t)0.976700086f,
    (float16_t)0.213110320f,  (float16_t)0.977028143f,
    (float16_t)0.211611327f,  (float16_t)0.977353900f,
    (float16_t)0.210111837f,  (float16_t)0.977677358f,
    (float16_t)0.208611852f,  (float16_t)0.977998515f,
    (float16_t)0.207111376f,  (float16_t)0.978317371f,
    (float16_t)0.205610413f,  (float16_t)0.978633924f,
    (float16_t)0.204108966f,  (float16_t)0.978948175f,
    (float16_t)0.202607039f,  (float16_t)0.979260123f,
    (float16_t)0.201104635f,  (float16_t)0.979569766f,
    (float16_t)0.199601758f,  (float16_t)0.979877104f,
    (float16_t)0.198098411f,  (float16_t)0.980182136f,
    (float16_t)0.196594598f,  (float16_t)0.980484862f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.193585587f,  (float16_t)0.981083391f,
    (float16_t)0.192080397f,  (float16_t)0.981379193f,
    (float16_t)0.190574755f,  (float16_t)0.981672686f,
    (float16_t)0.189068664f,  (float16_t)0.981963869f,
    (float16_t)0.187562129f,  (float16_t)0.982252741f,
    (float16_t)0.186055152f,  (float16_t)0.982539302f,
    (float16_t)0.184547737f,  (float16_t)0.982823551f,
    (float16_t)0.183039888f,  (float16_t)0.983105487f,
    (float16_t)0.181531608f,  (float16_t)0.983385110f,
    (float16_t)0.180022901f,  (float16_t)0.983662419f,
    (float16_t)0.178513771f,  (float16_t)0.983937413f,
    (float16_t)0.177004220f,  (float16_t)0.984210092f,
    (float16_t)0.175494253f,  (float16_t)0.984480455f,
    (float16_t)0.173983873f,  (float16_t)0.984748502f,
    (float16_t)0.172473084f,  (float16_t)0.985014231f,
    (float16_t)0.170961889f,  (float16_t)0.985277642f,
    (float16_t)0.169450291f,  (float16_t)0.985538735f,
    (float16_t)0.167938295f,  (float16_t)0.985797509f,
    (float16_t)0.166425904f,  (float16_t)0.986053963f,
    (float16_t)0.164913120f,  (float16_t)0.986308097f,
    (float16_t)0.163399949f,  (float16_t)0.986559910f,
    (float16_t)0.161886394f,  (float16_t)0.986809402f,
    (float16_t)0.160372457f,  (float16_t)0.987056571f,
    (float16_t)0.158858143f,  (float16_t)0.987301418f,
    (float16_t)0.157343456f,  (float16_t)0.987543942f,
    (float16_t)0.155828398f,  (float16_t)0.987784142f,
    (float16_t)0.154312973f,  (float16_t)0.988022017f,
    (float16_t)0.152797185f,  (float16_t)0.988257568f,
    (float16_t)0.151281038f,  (float16_t)0.988490793f,
    (float16_t)0.149764535f,  (float16_t)0.988721692f,
    (float16_t)0.148247679f,  (float16_t)0.988950265f,
    (float16_t)0.146730474f,  (float16_t)0.989176510f,
    (float16_t)0.145212925f,  (float16_t)0.989400428f,
    (float16_t)0.143695033f,  (float16_t)0.989622017f,
    (float16_t)0.142176804f,  (float16_t)0.989841278f,
    (float16_t)0.140658239f,  (float16_t)0.990058210f,
    (float16_t)0.139139344f,  (float16_t)0.990272812f,
    (float16_t)0.137620122f,  (float16_t)0.990485084f,
    (float16_t)0.136100575f,  (float16_t)0.990695025f,
    (float16_t)0.134580709f,  (float16_t)0.990902635f,
    (float16_t)0.133060525f,  (float16_t)0.991107914f,
    (float16_t)0.131540029f,  (float16_t)0.991310860f,
    (float16_t)0.130019223f,  (float16_t)0.991511473f,
    (float16_t)0.128498111f,  (float16_t)0.991709754f,
    (float16_t)0.126976696f,  (float16_t)0.991905700f,
    (float16_t)0.125454983f,  (float16_t)0.992099313f,
    (float16_t)0.123932975f,  (float16_t)0.992290591f,
    (float16_t)0.122410675f,  (float16_t)0.992479535f,
    (float16_t)0.120888087f,  (float16_t)0.992666142f,
    (float16_t)0.119365215f,  (float16_t)0.992850414f,
    (float16_t)0.117842062f,  (float16_t)0.993032350f,
    (float16_t)0.116318631f,  (float16_t)0.993211949f,
    (float16_t)0.114794927f,  (float16_t)0.993389211f,
    (float16_t)0.113270952f,  (float16_t)0.993564136f,
    (float16_t)0.111746711f,  (float16_t)0.993736722f,
    (float16_t)0.110222207f,  (float16_t)0.993906970f,
    (float16_t)0.108697444f,  (float16_t)0.994074879f,
    (float16_t)0.107172425f,  (float16_t)0.994240449f,
    (float16_t)0.105647154f,  (float16_t)0.994403680f,
    (float16_t)0.104121634f,  (float16_t)0.994564571f,
    (float16_t)0.102595869f,  (float16_t)0.994723121f,
    (float16_t)0.101069863f,  (float16_t)0.994879331f,
    (float16_t)0.099543619f,  (float16_t)0.995033199f,
    (float16_t)0.098017140f,  (float16_t)0.995184727f,
    (float16_t)0.096490431f,  (float16_t)0.995333912f,
    (float16_t)0.094963495f,  (float16_t)0.995480755f,
    (float16_t)0.093436336f,  (float16_t)0.995625256f,
    (float16_t)0.091908956f,  (float16_t)0.995767414f,
    (float16_t)0.090381361f,  (float16_t)0.995907229f,
    (float16_t)0.088853553f,  (float16_t)0.996044701f,
    (float16_t)0.087325535f,  (float16_t)0.996179829f,
    (float16_t)0.085797312f,  (float16_t)0.996312612f,
    (float16_t)0.084268888f,  (float16_t)0.996443051f,
    (float16_t)0.082740265f,  (float16_t)0.996571146f,
    (float16_t)0.081211447f,  (float16_t)0.996696895f,
    (float16_t)0.079682438f,  (float16_t)0.996820299f,
    (float16_t)0.078153242f,  (float16_t)0.996941358f,
    (float16_t)0.076623861f,  (float16_t)0.997060070f,
    (float16_t)0.075094301f,  (float16_t)0.997176437f,
    (float16_t)0.073564564f,  (float16_t)0.997290457f,
    (float16_t)0.072034653f,  (float16_t)0.997402130f,
    (float16_t)0.070504573f,  (float16_t)0.997511456f,
    (float16_t)0.068974328f,  (float16_t)0.997618435f,
    (float16_t)0.067443920f,  (float16_t)0.997723067f,
    (float16_t)0.065913353f,  (float16_t)0.997825350f,
    (float16_t)0.064382631f,  (float16_t)0.997925286f,
    (float16_t)0.062851758f,  (float16_t)0.998022874f,
    (float16_t)0.061320736f,  (float16_t)0.998118113f,
    (float16_t)0.059789571f,  (float16_t)0.998211003f,
    (float16_t)0.058258265f,  (float16_t)0.998301545f,
    (float16_t)0.056726821f,  (float16_t)0.998389737f,
    (float16_t)0.055195244f,  (float16_t)0.998475581f,
    (float16_t)0.053663538f,  (float16_t)0.998559074f,
    (float16_t)0.052131705f,  (float16_t)0.998640218f,
    (float16_t)0.050599749f,  (float16_t)0.998719012f,
    (float16_t)0.049067674f,  (float16_t)0.998795456f,
    (float16_t)0.047535484f,  (float16_t)0.998869550f,
    (float16_t)0.046003182f,  (float16_t)0.998941293f,
    (float16_t)0.044470772f,  (float16_t)0.999010686f,
    (float16_t)0.042938257f,  (float16_t)0.999077728f,
    (float16_t)0.041405641f,  (float16_t)0.999142419f,
    (float16_t)0.039872928f,  (float16_t)0.999204759f,
    (float16_t)0.038340120f,  (float16_t)0.999264747f,
    (float16_t)0.036807223f,  (float16_t)0.999322385f,
    (float16_t)0.035274239f,  (float16_t)0.999377670f,
    (float16_t)0.033741172f,  (float16_t)0.999430605f,
    (float16_t)0.032208025f,  (float16_t)0.999481187f,
    (float16_t)0.030674803f,  (float16_t)0.999529418f,
    (float16_t)0.029141509f,  (float16_t)0.999575296f,
    (float16_t)0.027608146f,  (float16_t)0.999618822f,
    (float16_t)0.026074718f,  (float16_t)0.999659997f,
    (float16_t)0.024541229f,  (float16_t)0.999698819f,
    (float16_t)0.023007681f,  (float16_t)0.999735288f,
    (float16_t)0.021474080f,  (float16_t)0.999769405f,
    (float16_t)0.019940429f,  (float16_t)0.999801170f,
    (float16_t)0.018406730f,  (float16_t)0.999830582f,
    (float16_t)0.016872988f,  (float16_t)0.999857641f,
    (float16_t)0.015339206f,  (float16_t)0.999882347f,
    (float16_t)0.013805389f,  (float16_t)0.999904701f,
    (float16_t)0.012271538f,  (float16_t)0.999924702f,
    (float16_t)0.010737659f,  (float16_t)0.999942350f,
    (float16_t)0.009203755f,  (float16_t)0.999957645f,
    (float16_t)0.007669829f,  (float16_t)0.999970586f,
    (float16_t)0.006135885f,  (float16_t)0.999981175f,
    (float16_t)0.004601926f,  (float16_t)0.999989411f,
    (float16_t)0.003067957f,  (float16_t)0.999995294f,
    (float16_t)0.001533980f,  (float16_t)0.999998823f,
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
   (float16_t)-0.001533980f,  (float16_t)0.999998823f,
   (float16_t)-0.003067957f,  (float16_t)0.999995294f,
   (float16_t)-0.004601926f,  (float16_t)0.999989411f,
   (float16_t)-0.006135885f,  (float16_t)0.999981175f,
   (float16_t)-0.007669829f,  (float16_t)0.999970586f,
   (float16_t)-0.009203755f,  (float16_t)0.999957645f,
   (float16_t)-0.010737659f,  (float16_t)0.999942350f,
   (float16_t)-0.012271538f,  (float16_t)0.999924702f,
   (float16_t)-0.013805389f,  (float16_t)0.999904701f,
   (float16_t)-0.015339206f,  (float16_t)0.999882347f,
   (float16_t)-0.016872988f,  (float16_t)0.999857641f,
   (float16_t)-0.018406730f,  (float16_t)0.999830582f,
   (float16_t)-0.019940429f,  (float16_t)0.999801170f,
   (float16_t)-0.021474080f,  (float16_t)0.999769405f,
   (float16_t)-0.023007681f,  (float16_t)0.999735288f,
   (float16_t)-0.024541229f,  (float16_t)0.999698819f,
   (float16_t)-0.026074718f,  (float16_t)0.999659997f,
   (float16_t)-0.027608146f,  (float16_t)0.999618822f,
   (float16_t)-0.029141509f,  (float16_t)0.999575296f,
   (float16_t)-0.030674803f,  (float16_t)0.999529418f,
   (float16_t)-0.032208025f,  (float16_t)0.999481187f,
   (float16_t)-0.033741172f,  (float16_t)0.999430605f,
   (float16_t)-0.035274239f,  (float16_t)0.999377670f,
   (float16_t)-0.036807223f,  (float16_t)0.999322385f,
   (float16_t)-0.038340120f,  (float16_t)0.999264747f,
   (float16_t)-0.039872928f,  (float16_t)0.999204759f,
   (float16_t)-0.041405641f,  (float16_t)0.999142419f,
   (float16_t)-0.042938257f,  (float16_t)0.999077728f,
   (float16_t)-0.044470772f,  (float16_t)0.999010686f,
   (float16_t)-0.046003182f,  (float16_t)0.998941293f,
   (float16_t)-0.047535484f,  (float16_t)0.998869550f,
   (float16_t)-0.049067674f,  (float16_t)0.998795456f,
   (float16_t)-0.050599749f,  (float16_t)0.998719012f,
   (float16_t)-0.052131705f,  (float16_t)0.998640218f,
   (float16_t)-0.053663538f,  (float16_t)0.998559074f,
   (float16_t)-0.055195244f,  (float16_t)0.998475581f,
   (float16_t)-0.056726821f,  (float16_t)0.998389737f,
   (float16_t)-0.058258265f,  (float16_t)0.998301545f,
   (float16_t)-0.059789571f,  (float16_t)0.998211003f,
   (float16_t)-0.061320736f,  (float16_t)0.998118113f,
   (float16_t)-0.062851758f,  (float16_t)0.998022874f,
   (float16_t)-0.064382631f,  (float16_t)0.997925286f,
   (float16_t)-0.065913353f,  (float16_t)0.997825350f,
   (float16_t)-0.067443920f,  (float16_t)0.997723067f,
   (float16_t)-0.068974328f,  (float16_t)0.997618435f,
   (float16_t)-0.070504573f,  (float16_t)0.997511456f,
   (float16_t)-0.072034653f,  (float16_t)0.997402130f,
   (float16_t)-0.073564564f,  (float16_t)0.997290457f,
   (float16_t)-0.075094301f,  (float16_t)0.997176437f,
   (float16_t)-0.076623861f,  (float16_t)0.997060070f,
   (float16_t)-0.078153242f,  (float16_t)0.996941358f,
   (float16_t)-0.079682438f,  (float16_t)0.996820299f,
   (float16_t)-0.081211447f,  (float16_t)0.996696895f,
   (float16_t)-0.082740265f,  (float16_t)0.996571146f,
   (float16_t)-0.084268888f,  (float16_t)0.996443051f,
   (float16_t)-0.085797312f,  (float16_t)0.996312612f,
   (float16_t)-0.087325535f,  (float16_t)0.996179829f,
   (float16_t)-0.088853553f,  (float16_t)0.996044701f,
   (float16_t)-0.090381361f,  (float16_t)0.995907229f,
   (float16_t)-0.091908956f,  (float16_t)0.995767414f,
   (float16_t)-0.093436336f,  (float16_t)0.995625256f,
   (float16_t)-0.094963495f,  (float16_t)0.995480755f,
   (float16_t)-0.096490431f,  (float16_t)0.995333912f,
   (float16_t)-0.098017140f,  (float16_t)0.995184727f,
   (float16_t)-0.099543619f,  (float16_t)0.995033199f,
   (float16_t)-0.101069863f,  (float16_t)0.994879331f,
   (float16_t)-0.102595869f,  (float16_t)0.994723121f,
   (float16_t)-0.104121634f,  (float16_t)0.994564571f,
   (float16_t)-0.105647154f,  (float16_t)0.994403680f,
   (float16_t)-0.107172425f,  (float16_t)0.994240449f,
   (float16_t)-0.108697444f,  (float16_t)0.994074879f,
   (float16_t)-0.110222207f,  (float16_t)0.993906970f,
   (float16_t)-0.111746711f,  (float16_t)0.993736722f,
   (float16_t)-0.113270952f,  (float16_t)0.993564136f,
   (float16_t)-0.114794927f,  (float16_t)0.993389211f,
   (float16_t)-0.116318631f,  (float16_t)0.993211949f,
   (float16_t)-0.117842062f,  (float16_t)0.993032350f,
   (float16_t)-0.119365215f,  (float16_t)0.992850414f,
   (float16_t)-0.120888087f,  (float16_t)0.992666142f,
   (float16_t)-0.122410675f,  (float16_t)0.992479535f,
   (float16_t)-0.123932975f,  (float16_t)0.992290591f,
   (float16_t)-0.125454983f,  (float16_t)0.992099313f,
   (float16_t)-0.126976696f,  (float16_t)0.991905700f,
   (float16_t)-0.128498111f,  (float16_t)0.991709754f,
   (float16_t)-0.130019223f,  (float16_t)0.991511473f,
   (float16_t)-0.131540029f,  (float16_t)0.991310860f,
   (float16_t)-0.133060525f,  (float16_t)0.991107914f,
   (float16_t)-0.134580709f,  (float16_t)0.990902635f,
   (float16_t)-0.136100575f,  (float16_t)0.990695025f,
   (float16_t)-0.137620122f,  (float16_t)0.990485084f,
   (float16_t)-0.139139344f,  (float16_t)0.990272812f,
   (float16_t)-0.140658239f,  (float16_t)0.990058210f,
   (float16_t)-0.142176804f,  (float16_t)0.989841278f,
   (float16_t)-0.143695033f,  (float16_t)0.989622017f,
   (float16_t)-0.145212925f,  (float16_t)0.989400428f,
   (float16_t)-0.146730474f,  (float16_t)0.989176510f,
   (float16_t)-0.148247679f,  (float16_t)0.988950265f,
   (float16_t)-0.149764535f,  (float16_t)0.988721692f,
   (float16_t)-0.151281038f,  (float16_t)0.988490793f,
   (float16_t)-0.152797185f,  (float16_t)0.988257568f,
   (float16_t)-0.154312973f,  (float16_t)0.988022017f,
   (float16_t)-0.155828398f,  (float16_t)0.987784142f,
   (float16_t)-0.157343456f,  (float16_t)0.987543942f,
   (float16_t)-0.158858143f,  (float16_t)0.987301418f,
   (float16_t)-0.160372457f,  (float16_t)0.987056571f,
   (float16_t)-0.161886394f,  (float16_t)0.986809402f,
   (float16_t)-0.163399949f,  (float16_t)0.986559910f,
   (float16_t)-0.164913120f,  (float16_t)0.986308097f,
   (float16_t)-0.166425904f,  (float16_t)0.986053963f,
   (float16_t)-0.167938295f,  (float16_t)0.985797509f,
   (float16_t)-0.169450291f,  (float16_t)0.985538735f,
   (float16_t)-0.170961889f,  (float16_t)0.985277642f,
   (float16_t)-0.172473084f,  (float16_t)0.985014231f,
   (float16_t)-0.173983873f,  (float16_t)0.984748502f,
   (float16_t)-0.175494253f,  (float16_t)0.984480455f,
   (float16_t)-0.177004220f,  (float16_t)0.984210092f,
   (float16_t)-0.178513771f,  (float16_t)0.983937413f,
   (float16_t)-0.180022901f,  (float16_t)0.983662419f,
   (float16_t)-0.181531608f,  (float16_t)0.983385110f,
   (float16_t)-0.183039888f,  (float16_t)0.983105487f,
   (float16_t)-0.184547737f,  (float16_t)0.982823551f,
   (float16_t)-0.186055152f,  (float16_t)0.982539302f,
   (float16_t)-0.187562129f,  (float16_t)0.982252741f,
   (float16_t)-0.189068664f,  (float16_t)0.981963869f,
   (float16_t)-0.190574755f,  (float16_t)0.981672686f,
   (float16_t)-0.192080397f,  (float16_t)0.981379193f,
   (float16_t)-0.193585587f,  (float16_t)0.981083391f,
   (float16_t)-0.195090322f,  (float16_t)0.980785280f,
   (float16_t)-0.196594598f,  (float16_t)0.980484862f,
   (float16_t)-0.198098411f,  (float16_t)0.980182136f,
   (float16_t)-0.199601758f,  (float16_t)0.979877104f,
   (float16_t)-0.201104635f,  (float16_t)0.979569766f,
   (float16_t)-0.202607039f,  (float16_t)0.979260123f,
   (float16_t)-0.204108966f,  (float16_t)0.978948175f,
   (float16_t)-0.205610413f,  (float16_t)0.978633924f,
   (float16_t)-0.207111376f,  (float16_t)0.978317371f,
   (float16_t)-0.208611852f,  (float16_t)0.977998515f,
   (float16_t)-0.210111837f,  (float16_t)0.977677358f,
   (float16_t)-0.211611327f,  (float16_t)0.977353900f,
   (float16_t)-0.213110320f,  (float16_t)0.977028143f,
   (float16_t)-0.214608811f,  (float16_t)0.976700086f,
   (float16_t)-0.216106797f,  (float16_t)0.976369731f,
   (float16_t)-0.217604275f,  (float16_t)0.976037079f,
   (float16_t)-0.219101240f,  (float16_t)0.975702130f,
   (float16_t)-0.220597690f,  (float16_t)0.975364885f,
   (float16_t)-0.222093621f,  (float16_t)0.975025345f,
   (float16_t)-0.223589029f,  (float16_t)0.974683511f,
   (float16_t)-0.225083911f,  (float16_t)0.974339383f,
   (float16_t)-0.226578264f,  (float16_t)0.973992962f,
   (float16_t)-0.228072083f,  (float16_t)0.973644250f,
   (float16_t)-0.229565366f,  (float16_t)0.973293246f,
   (float16_t)-0.231058108f,  (float16_t)0.972939952f,
   (float16_t)-0.232550307f,  (float16_t)0.972584369f,
   (float16_t)-0.234041959f,  (float16_t)0.972226497f,
   (float16_t)-0.235533059f,  (float16_t)0.971866337f,
   (float16_t)-0.237023606f,  (float16_t)0.971503891f,
   (float16_t)-0.238513595f,  (float16_t)0.971139158f,
   (float16_t)-0.240003022f,  (float16_t)0.970772141f,
   (float16_t)-0.241491885f,  (float16_t)0.970402839f,
   (float16_t)-0.242980180f,  (float16_t)0.970031253f,
   (float16_t)-0.244467903f,  (float16_t)0.969657385f,
   (float16_t)-0.245955050f,  (float16_t)0.969281235f,
   (float16_t)-0.247441619f,  (float16_t)0.968902805f,
   (float16_t)-0.248927606f,  (float16_t)0.968522094f,
   (float16_t)-0.250413007f,  (float16_t)0.968139105f,
   (float16_t)-0.251897818f,  (float16_t)0.967753837f,
   (float16_t)-0.253382037f,  (float16_t)0.967366292f,
   (float16_t)-0.254865660f,  (float16_t)0.966976471f,
   (float16_t)-0.256348682f,  (float16_t)0.966584374f,
   (float16_t)-0.257831102f,  (float16_t)0.966190003f,
   (float16_t)-0.259312915f,  (float16_t)0.965793359f,
   (float16_t)-0.260794118f,  (float16_t)0.965394442f,
   (float16_t)-0.262274707f,  (float16_t)0.964993253f,
   (float16_t)-0.263754679f,  (float16_t)0.964589793f,
   (float16_t)-0.265234030f,  (float16_t)0.964184064f,
   (float16_t)-0.266712757f,  (float16_t)0.963776066f,
   (float16_t)-0.268190857f,  (float16_t)0.963365800f,
   (float16_t)-0.269668326f,  (float16_t)0.962953267f,
   (float16_t)-0.271145160f,  (float16_t)0.962538468f,
   (float16_t)-0.272621355f,  (float16_t)0.962121404f,
   (float16_t)-0.274096910f,  (float16_t)0.961702077f,
   (float16_t)-0.275571819f,  (float16_t)0.961280486f,
   (float16_t)-0.277046080f,  (float16_t)0.960856633f,
   (float16_t)-0.278519689f,  (float16_t)0.960430519f,
   (float16_t)-0.279992643f,  (float16_t)0.960002146f,
   (float16_t)-0.281464938f,  (float16_t)0.959571513f,
   (float16_t)-0.282936570f,  (float16_t)0.959138622f,
   (float16_t)-0.284407537f,  (float16_t)0.958703475f,
   (float16_t)-0.285877835f,  (float16_t)0.958266071f,
   (float16_t)-0.287347460f,  (float16_t)0.957826413f,
   (float16_t)-0.288816408f,  (float16_t)0.957384501f,
   (float16_t)-0.290284677f,  (float16_t)0.956940336f,
   (float16_t)-0.291752263f,  (float16_t)0.956493919f,
   (float16_t)-0.293219163f,  (float16_t)0.956045251f,
   (float16_t)-0.294685372f,  (float16_t)0.955594334f,
   (float16_t)-0.296150888f,  (float16_t)0.955141168f,
   (float16_t)-0.297615707f,  (float16_t)0.954685755f,
   (float16_t)-0.299079826f,  (float16_t)0.954228095f,
   (float16_t)-0.300543241f,  (float16_t)0.953768190f,
   (float16_t)-0.302005949f,  (float16_t)0.953306040f,
   (float16_t)-0.303467947f,  (float16_t)0.952841648f,
   (float16_t)-0.304929230f,  (float16_t)0.952375013f,
   (float16_t)-0.306389795f,  (float16_t)0.951906137f,
   (float16_t)-0.307849640f,  (float16_t)0.951435021f,
   (float16_t)-0.309308760f,  (float16_t)0.950961666f,
   (float16_t)-0.310767153f,  (float16_t)0.950486074f,
   (float16_t)-0.312224814f,  (float16_t)0.950008245f,
   (float16_t)-0.313681740f,  (float16_t)0.949528181f,
   (float16_t)-0.315137929f,  (float16_t)0.949045882f,
   (float16_t)-0.316593376f,  (float16_t)0.948561350f,
   (float16_t)-0.318048077f,  (float16_t)0.948074586f,
   (float16_t)-0.319502031f,  (float16_t)0.947585591f,
   (float16_t)-0.320955232f,  (float16_t)0.947094366f,
   (float16_t)-0.322407679f,  (float16_t)0.946600913f,
   (float16_t)-0.323859367f,  (float16_t)0.946105232f,
   (float16_t)-0.325310292f,  (float16_t)0.945607325f,
   (float16_t)-0.326760452f,  (float16_t)0.945107193f,
   (float16_t)-0.328209844f,  (float16_t)0.944604837f,
   (float16_t)-0.329658463f,  (float16_t)0.944100258f,
   (float16_t)-0.331106306f,  (float16_t)0.943593458f,
   (float16_t)-0.332553370f,  (float16_t)0.943084437f,
   (float16_t)-0.333999651f,  (float16_t)0.942573198f,
   (float16_t)-0.335445147f,  (float16_t)0.942059740f,
   (float16_t)-0.336889853f,  (float16_t)0.941544065f,
   (float16_t)-0.338333767f,  (float16_t)0.941026175f,
   (float16_t)-0.339776884f,  (float16_t)0.940506071f,
   (float16_t)-0.341219202f,  (float16_t)0.939983753f,
   (float16_t)-0.342660717f,  (float16_t)0.939459224f,
   (float16_t)-0.344101426f,  (float16_t)0.938932484f,
   (float16_t)-0.345541325f,  (float16_t)0.938403534f,
   (float16_t)-0.346980411f,  (float16_t)0.937872376f,
   (float16_t)-0.348418680f,  (float16_t)0.937339012f,
   (float16_t)-0.349856130f,  (float16_t)0.936803442f,
   (float16_t)-0.351292756f,  (float16_t)0.936265667f,
   (float16_t)-0.352728556f,  (float16_t)0.935725689f,
   (float16_t)-0.354163525f,  (float16_t)0.935183510f,
   (float16_t)-0.355597662f,  (float16_t)0.934639130f,
   (float16_t)-0.357030961f,  (float16_t)0.934092550f,
   (float16_t)-0.358463421f,  (float16_t)0.933543773f,
   (float16_t)-0.359895037f,  (float16_t)0.932992799f,
   (float16_t)-0.361325806f,  (float16_t)0.932439629f,
   (float16_t)-0.362755724f,  (float16_t)0.931884266f,
   (float16_t)-0.364184790f,  (float16_t)0.931326709f,
   (float16_t)-0.365612998f,  (float16_t)0.930766961f,
   (float16_t)-0.367040346f,  (float16_t)0.930205023f,
   (float16_t)-0.368466830f,  (float16_t)0.929640896f,
   (float16_t)-0.369892447f,  (float16_t)0.929074581f,
   (float16_t)-0.371317194f,  (float16_t)0.928506080f,
   (float16_t)-0.372741067f,  (float16_t)0.927935395f,
   (float16_t)-0.374164063f,  (float16_t)0.927362526f,
   (float16_t)-0.375586178f,  (float16_t)0.926787474f,
   (float16_t)-0.377007410f,  (float16_t)0.926210242f,
   (float16_t)-0.378427755f,  (float16_t)0.925630831f,
   (float16_t)-0.379847209f,  (float16_t)0.925049241f,
   (float16_t)-0.381265769f,  (float16_t)0.924465474f,
   (float16_t)-0.382683432f,  (float16_t)0.923879533f,
   (float16_t)-0.384100195f,  (float16_t)0.923291417f,
   (float16_t)-0.385516054f,  (float16_t)0.922701128f,
   (float16_t)-0.386931006f,  (float16_t)0.922108669f,
   (float16_t)-0.388345047f,  (float16_t)0.921514039f,
   (float16_t)-0.389758174f,  (float16_t)0.920917242f,
   (float16_t)-0.391170384f,  (float16_t)0.920318277f,
   (float16_t)-0.392581674f,  (float16_t)0.919717146f,
   (float16_t)-0.393992040f,  (float16_t)0.919113852f,
   (float16_t)-0.395401479f,  (float16_t)0.918508394f,
   (float16_t)-0.396809987f,  (float16_t)0.917900776f,
   (float16_t)-0.398217562f,  (float16_t)0.917290997f,
   (float16_t)-0.399624200f,  (float16_t)0.916679060f,
   (float16_t)-0.401029897f,  (float16_t)0.916064966f,
   (float16_t)-0.402434651f,  (float16_t)0.915448716f,
   (float16_t)-0.403838458f,  (float16_t)0.914830312f,
   (float16_t)-0.405241314f,  (float16_t)0.914209756f,
   (float16_t)-0.406643217f,  (float16_t)0.913587048f,
   (float16_t)-0.408044163f,  (float16_t)0.912962190f,
   (float16_t)-0.409444149f,  (float16_t)0.912335185f,
   (float16_t)-0.410843171f,  (float16_t)0.911706032f,
   (float16_t)-0.412241227f,  (float16_t)0.911074734f,
   (float16_t)-0.413638312f,  (float16_t)0.910441292f,
   (float16_t)-0.415034424f,  (float16_t)0.909805708f,
   (float16_t)-0.416429560f,  (float16_t)0.909167983f,
   (float16_t)-0.417823716f,  (float16_t)0.908528119f,
   (float16_t)-0.419216888f,  (float16_t)0.907886116f,
   (float16_t)-0.420609074f,  (float16_t)0.907241978f,
   (float16_t)-0.422000271f,  (float16_t)0.906595705f,
   (float16_t)-0.423390474f,  (float16_t)0.905947298f,
   (float16_t)-0.424779681f,  (float16_t)0.905296759f,
   (float16_t)-0.426167889f,  (float16_t)0.904644091f,
   (float16_t)-0.427555093f,  (float16_t)0.903989293f,
   (float16_t)-0.428941292f,  (float16_t)0.903332368f,
   (float16_t)-0.430326481f,  (float16_t)0.902673318f,
   (float16_t)-0.431710658f,  (float16_t)0.902012144f,
   (float16_t)-0.433093819f,  (float16_t)0.901348847f,
   (float16_t)-0.434475961f,  (float16_t)0.900683429f,
   (float16_t)-0.435857080f,  (float16_t)0.900015892f,
   (float16_t)-0.437237174f,  (float16_t)0.899346237f,
   (float16_t)-0.438616239f,  (float16_t)0.898674466f,
   (float16_t)-0.439994271f,  (float16_t)0.898000580f,
   (float16_t)-0.441371269f,  (float16_t)0.897324581f,
   (float16_t)-0.442747228f,  (float16_t)0.896646470f,
   (float16_t)-0.444122145f,  (float16_t)0.895966250f,
   (float16_t)-0.445496017f,  (float16_t)0.895283921f,
   (float16_t)-0.446868840f,  (float16_t)0.894599486f,
   (float16_t)-0.448240612f,  (float16_t)0.893912945f,
   (float16_t)-0.449611330f,  (float16_t)0.893224301f,
   (float16_t)-0.450980989f,  (float16_t)0.892533555f,
   (float16_t)-0.452349587f,  (float16_t)0.891840709f,
   (float16_t)-0.453717121f,  (float16_t)0.891145765f,
   (float16_t)-0.455083587f,  (float16_t)0.890448723f,
   (float16_t)-0.456448982f,  (float16_t)0.889749586f,
   (float16_t)-0.457813304f,  (float16_t)0.889048356f,
   (float16_t)-0.459176548f,  (float16_t)0.888345033f,
   (float16_t)-0.460538711f,  (float16_t)0.887639620f,
   (float16_t)-0.461899791f,  (float16_t)0.886932119f,
   (float16_t)-0.463259784f,  (float16_t)0.886222530f,
   (float16_t)-0.464618686f,  (float16_t)0.885510856f,
   (float16_t)-0.465976496f,  (float16_t)0.884797098f,
   (float16_t)-0.467333209f,  (float16_t)0.884081259f,
   (float16_t)-0.468688822f,  (float16_t)0.883363339f,
   (float16_t)-0.470043332f,  (float16_t)0.882643340f,
   (float16_t)-0.471396737f,  (float16_t)0.881921264f,
   (float16_t)-0.472749032f,  (float16_t)0.881197113f,
   (float16_t)-0.474100215f,  (float16_t)0.880470889f,
   (float16_t)-0.475450282f,  (float16_t)0.879742593f,
   (float16_t)-0.476799230f,  (float16_t)0.879012226f,
   (float16_t)-0.478147056f,  (float16_t)0.878279792f,
   (float16_t)-0.479493758f,  (float16_t)0.877545290f,
   (float16_t)-0.480839331f,  (float16_t)0.876808724f,
   (float16_t)-0.482183772f,  (float16_t)0.876070094f,
   (float16_t)-0.483527079f,  (float16_t)0.875329403f,
   (float16_t)-0.484869248f,  (float16_t)0.874586652f,
   (float16_t)-0.486210276f,  (float16_t)0.873841843f,
   (float16_t)-0.487550160f,  (float16_t)0.873094978f,
   (float16_t)-0.488888897f,  (float16_t)0.872346059f,
   (float16_t)-0.490226483f,  (float16_t)0.871595087f,
   (float16_t)-0.491562916f,  (float16_t)0.870842063f,
   (float16_t)-0.492898192f,  (float16_t)0.870086991f,
   (float16_t)-0.494232309f,  (float16_t)0.869329871f,
   (float16_t)-0.495565262f,  (float16_t)0.868570706f,
   (float16_t)-0.496897049f,  (float16_t)0.867809497f,
   (float16_t)-0.498227667f,  (float16_t)0.867046246f,
   (float16_t)-0.499557113f,  (float16_t)0.866280954f,
   (float16_t)-0.500885383f,  (float16_t)0.865513624f,
   (float16_t)-0.502212474f,  (float16_t)0.864744258f,
   (float16_t)-0.503538384f,  (float16_t)0.863972856f,
   (float16_t)-0.504863109f,  (float16_t)0.863199422f,
   (float16_t)-0.506186645f,  (float16_t)0.862423956f,
   (float16_t)-0.507508991f,  (float16_t)0.861646461f,
   (float16_t)-0.508830143f,  (float16_t)0.860866939f,
   (float16_t)-0.510150097f,  (float16_t)0.860085390f,
   (float16_t)-0.511468850f,  (float16_t)0.859301818f,
   (float16_t)-0.512786401f,  (float16_t)0.858516224f,
   (float16_t)-0.514102744f,  (float16_t)0.857728610f,
   (float16_t)-0.515417878f,  (float16_t)0.856938977f,
   (float16_t)-0.516731799f,  (float16_t)0.856147328f,
   (float16_t)-0.518044504f,  (float16_t)0.855353665f,
   (float16_t)-0.519355990f,  (float16_t)0.854557988f,
   (float16_t)-0.520666254f,  (float16_t)0.853760301f,
   (float16_t)-0.521975293f,  (float16_t)0.852960605f,
   (float16_t)-0.523283103f,  (float16_t)0.852158902f,
   (float16_t)-0.524589683f,  (float16_t)0.851355193f,
   (float16_t)-0.525895027f,  (float16_t)0.850549481f,
   (float16_t)-0.527199135f,  (float16_t)0.849741768f,
   (float16_t)-0.528502002f,  (float16_t)0.848932055f,
   (float16_t)-0.529803625f,  (float16_t)0.848120345f,
   (float16_t)-0.531104001f,  (float16_t)0.847306639f,
   (float16_t)-0.532403128f,  (float16_t)0.846490939f,
   (float16_t)-0.533701002f,  (float16_t)0.845673247f,
   (float16_t)-0.534997620f,  (float16_t)0.844853565f,
   (float16_t)-0.536292979f,  (float16_t)0.844031895f,
   (float16_t)-0.537587076f,  (float16_t)0.843208240f,
   (float16_t)-0.538879909f,  (float16_t)0.842382600f,
   (float16_t)-0.540171473f,  (float16_t)0.841554977f,
   (float16_t)-0.541461766f,  (float16_t)0.840725375f,
   (float16_t)-0.542750785f,  (float16_t)0.839893794f,
   (float16_t)-0.544038527f,  (float16_t)0.839060237f,
   (float16_t)-0.545324988f,  (float16_t)0.838224706f,
   (float16_t)-0.546610167f,  (float16_t)0.837387202f,
   (float16_t)-0.547894059f,  (float16_t)0.836547727f,
   (float16_t)-0.549176662f,  (float16_t)0.835706284f,
   (float16_t)-0.550457973f,  (float16_t)0.834862875f,
   (float16_t)-0.551737988f,  (float16_t)0.834017501f,
   (float16_t)-0.553016706f,  (float16_t)0.833170165f,
   (float16_t)-0.554294121f,  (float16_t)0.832320868f,
   (float16_t)-0.555570233f,  (float16_t)0.831469612f,
   (float16_t)-0.556845037f,  (float16_t)0.830616400f,
   (float16_t)-0.558118531f,  (float16_t)0.829761234f,
   (float16_t)-0.559390712f,  (float16_t)0.828904115f,
   (float16_t)-0.560661576f,  (float16_t)0.828045045f,
   (float16_t)-0.561931121f,  (float16_t)0.827184027f,
   (float16_t)-0.563199344f,  (float16_t)0.826321063f,
   (float16_t)-0.564466242f,  (float16_t)0.825456154f,
   (float16_t)-0.565731811f,  (float16_t)0.824589303f,
   (float16_t)-0.566996049f,  (float16_t)0.823720511f,
   (float16_t)-0.568258953f,  (float16_t)0.822849781f,
   (float16_t)-0.569520519f,  (float16_t)0.821977115f,
   (float16_t)-0.570780746f,  (float16_t)0.821102515f,
   (float16_t)-0.572039629f,  (float16_t)0.820225983f,
   (float16_t)-0.573297167f,  (float16_t)0.819347520f,
   (float16_t)-0.574553355f,  (float16_t)0.818467130f,
   (float16_t)-0.575808191f,  (float16_t)0.817584813f,
   (float16_t)-0.577061673f,  (float16_t)0.816700573f,
   (float16_t)-0.578313796f,  (float16_t)0.815814411f,
   (float16_t)-0.579564559f,  (float16_t)0.814926329f,
   (float16_t)-0.580813958f,  (float16_t)0.814036330f,
   (float16_t)-0.582061990f,  (float16_t)0.813144415f,
   (float16_t)-0.583308653f,  (float16_t)0.812250587f,
   (float16_t)-0.584553943f,  (float16_t)0.811354847f,
   (float16_t)-0.585797857f,  (float16_t)0.810457198f,
   (float16_t)-0.587040394f,  (float16_t)0.809557642f,
   (float16_t)-0.588281548f,  (float16_t)0.808656182f,
   (float16_t)-0.589521319f,  (float16_t)0.807752818f,
   (float16_t)-0.590759702f,  (float16_t)0.806847554f,
   (float16_t)-0.591996695f,  (float16_t)0.805940391f,
   (float16_t)-0.593232295f,  (float16_t)0.805031331f,
   (float16_t)-0.594466499f,  (float16_t)0.804120377f,
   (float16_t)-0.595699304f,  (float16_t)0.803207531f,
   (float16_t)-0.596930708f,  (float16_t)0.802292796f,
   (float16_t)-0.598160707f,  (float16_t)0.801376172f,
   (float16_t)-0.599389298f,  (float16_t)0.800457662f,
   (float16_t)-0.600616479f,  (float16_t)0.799537269f,
   (float16_t)-0.601842247f,  (float16_t)0.798614995f,
   (float16_t)-0.603066599f,  (float16_t)0.797690841f,
   (float16_t)-0.604289531f,  (float16_t)0.796764810f,
   (float16_t)-0.605511041f,  (float16_t)0.795836905f,
   (float16_t)-0.606731127f,  (float16_t)0.794907126f,
   (float16_t)-0.607949785f,  (float16_t)0.793975478f,
   (float16_t)-0.609167012f,  (float16_t)0.793041960f,
   (float16_t)-0.610382806f,  (float16_t)0.792106577f,
   (float16_t)-0.611597164f,  (float16_t)0.791169330f,
   (float16_t)-0.612810082f,  (float16_t)0.790230221f,
   (float16_t)-0.614021559f,  (float16_t)0.789289253f,
   (float16_t)-0.615231591f,  (float16_t)0.788346428f,
   (float16_t)-0.616440175f,  (float16_t)0.787401747f,
   (float16_t)-0.617647308f,  (float16_t)0.786455214f,
   (float16_t)-0.618852988f,  (float16_t)0.785506830f,
   (float16_t)-0.620057212f,  (float16_t)0.784556597f,
   (float16_t)-0.621259977f,  (float16_t)0.783604519f,
   (float16_t)-0.622461279f,  (float16_t)0.782650596f,
   (float16_t)-0.623661118f,  (float16_t)0.781694832f,
   (float16_t)-0.624859488f,  (float16_t)0.780737229f,
   (float16_t)-0.626056388f,  (float16_t)0.779777788f,
   (float16_t)-0.627251815f,  (float16_t)0.778816512f,
   (float16_t)-0.628445767f,  (float16_t)0.777853404f,
   (float16_t)-0.629638239f,  (float16_t)0.776888466f,
   (float16_t)-0.630829230f,  (float16_t)0.775921699f,
   (float16_t)-0.632018736f,  (float16_t)0.774953107f,
   (float16_t)-0.633206755f,  (float16_t)0.773982691f,
   (float16_t)-0.634393284f,  (float16_t)0.773010453f,
   (float16_t)-0.635578320f,  (float16_t)0.772036397f,
   (float16_t)-0.636761861f,  (float16_t)0.771060524f,
   (float16_t)-0.637943904f,  (float16_t)0.770082837f,
   (float16_t)-0.639124445f,  (float16_t)0.769103338f,
   (float16_t)-0.640303482f,  (float16_t)0.768122029f,
   (float16_t)-0.641481013f,  (float16_t)0.767138912f,
   (float16_t)-0.642657034f,  (float16_t)0.766153990f,
   (float16_t)-0.643831543f,  (float16_t)0.765167266f,
   (float16_t)-0.645004537f,  (float16_t)0.764178741f,
   (float16_t)-0.646176013f,  (float16_t)0.763188417f,
   (float16_t)-0.647345969f,  (float16_t)0.762196298f,
   (float16_t)-0.648514401f,  (float16_t)0.761202385f,
   (float16_t)-0.649681307f,  (float16_t)0.760206682f,
   (float16_t)-0.650846685f,  (float16_t)0.759209189f,
   (float16_t)-0.652010531f,  (float16_t)0.758209910f,
   (float16_t)-0.653172843f,  (float16_t)0.757208847f,
   (float16_t)-0.654333618f,  (float16_t)0.756206001f,
   (float16_t)-0.655492853f,  (float16_t)0.755201377f,
   (float16_t)-0.656650546f,  (float16_t)0.754194975f,
   (float16_t)-0.657806693f,  (float16_t)0.753186799f,
   (float16_t)-0.658961293f,  (float16_t)0.752176850f,
   (float16_t)-0.660114342f,  (float16_t)0.751165132f,
   (float16_t)-0.661265838f,  (float16_t)0.750151646f,
   (float16_t)-0.662415778f,  (float16_t)0.749136395f,
   (float16_t)-0.663564159f,  (float16_t)0.748119380f,
   (float16_t)-0.664710978f,  (float16_t)0.747100606f,
   (float16_t)-0.665856234f,  (float16_t)0.746080074f,
   (float16_t)-0.666999922f,  (float16_t)0.745057785f,
   (float16_t)-0.668142041f,  (float16_t)0.744033744f,
   (float16_t)-0.669282588f,  (float16_t)0.743007952f,
   (float16_t)-0.670421560f,  (float16_t)0.741980412f,
   (float16_t)-0.671558955f,  (float16_t)0.740951125f,
   (float16_t)-0.672694769f,  (float16_t)0.739920095f,
   (float16_t)-0.673829000f,  (float16_t)0.738887324f,
   (float16_t)-0.674961646f,  (float16_t)0.737852815f,
   (float16_t)-0.676092704f,  (float16_t)0.736816569f,
   (float16_t)-0.677222170f,  (float16_t)0.735778589f,
   (float16_t)-0.678350043f,  (float16_t)0.734738878f,
   (float16_t)-0.679476320f,  (float16_t)0.733697438f,
   (float16_t)-0.680600998f,  (float16_t)0.732654272f,
   (float16_t)-0.681724074f,  (float16_t)0.731609381f,
   (float16_t)-0.682845546f,  (float16_t)0.730562769f,
   (float16_t)-0.683965412f,  (float16_t)0.729514438f,
   (float16_t)-0.685083668f,  (float16_t)0.728464390f,
   (float16_t)-0.686200312f,  (float16_t)0.727412629f,
   (float16_t)-0.687315341f,  (float16_t)0.726359155f,
   (float16_t)-0.688428753f,  (float16_t)0.725303972f,
   (float16_t)-0.689540545f,  (float16_t)0.724247083f,
   (float16_t)-0.690650714f,  (float16_t)0.723188489f,
   (float16_t)-0.691759258f,  (float16_t)0.722128194f,
   (float16_t)-0.692866175f,  (float16_t)0.721066199f,
   (float16_t)-0.693971461f,  (float16_t)0.720002508f,
   (float16_t)-0.695075114f,  (float16_t)0.718937122f,
   (float16_t)-0.696177131f,  (float16_t)0.717870045f,
   (float16_t)-0.697277511f,  (float16_t)0.716801279f,
   (float16_t)-0.698376249f,  (float16_t)0.715730825f,
   (float16_t)-0.699473345f,  (float16_t)0.714658688f,
   (float16_t)-0.700568794f,  (float16_t)0.713584869f,
   (float16_t)-0.701662595f,  (float16_t)0.712509371f,
   (float16_t)-0.702754744f,  (float16_t)0.711432196f,
   (float16_t)-0.703845241f,  (float16_t)0.710353347f,
   (float16_t)-0.704934080f,  (float16_t)0.709272826f,
   (float16_t)-0.706021261f,  (float16_t)0.708190637f,
   (float16_t)-0.707106781f,  (float16_t)0.707106781f,
   (float16_t)-0.708190637f,  (float16_t)0.706021261f,
   (float16_t)-0.709272826f,  (float16_t)0.704934080f,
   (float16_t)-0.710353347f,  (float16_t)0.703845241f,
   (float16_t)-0.711432196f,  (float16_t)0.702754744f,
   (float16_t)-0.712509371f,  (float16_t)0.701662595f,
   (float16_t)-0.713584869f,  (float16_t)0.700568794f,
   (float16_t)-0.714658688f,  (float16_t)0.699473345f,
   (float16_t)-0.715730825f,  (float16_t)0.698376249f,
   (float16_t)-0.716801279f,  (float16_t)0.697277511f,
   (float16_t)-0.717870045f,  (float16_t)0.696177131f,
   (float16_t)-0.718937122f,  (float16_t)0.695075114f,
   (float16_t)-0.720002508f,  (float16_t)0.693971461f,
   (float16_t)-0.721066199f,  (float16_t)0.692866175f,
   (float16_t)-0.722128194f,  (float16_t)0.691759258f,
   (float16_t)-0.723188489f,  (float16_t)0.690650714f,
   (float16_t)-0.724247083f,  (float16_t)0.689540545f,
   (float16_t)-0.725303972f,  (float16_t)0.688428753f,
   (float16_t)-0.726359155f,  (float16_t)0.687315341f,
   (float16_t)-0.727412629f,  (float16_t)0.686200312f,
   (float16_t)-0.728464390f,  (float16_t)0.685083668f,
   (float16_t)-0.729514438f,  (float16_t)0.683965412f,
   (float16_t)-0.730562769f,  (float16_t)0.682845546f,
   (float16_t)-0.731609381f,  (float16_t)0.681724074f,
   (float16_t)-0.732654272f,  (float16_t)0.680600998f,
   (float16_t)-0.733697438f,  (float16_t)0.679476320f,
   (float16_t)-0.734738878f,  (float16_t)0.678350043f,
   (float16_t)-0.735778589f,  (float16_t)0.677222170f,
   (float16_t)-0.736816569f,  (float16_t)0.676092704f,
   (float16_t)-0.737852815f,  (float16_t)0.674961646f,
   (float16_t)-0.738887324f,  (float16_t)0.673829000f,
   (float16_t)-0.739920095f,  (float16_t)0.672694769f,
   (float16_t)-0.740951125f,  (float16_t)0.671558955f,
   (float16_t)-0.741980412f,  (float16_t)0.670421560f,
   (float16_t)-0.743007952f,  (float16_t)0.669282588f,
   (float16_t)-0.744033744f,  (float16_t)0.668142041f,
   (float16_t)-0.745057785f,  (float16_t)0.666999922f,
   (float16_t)-0.746080074f,  (float16_t)0.665856234f,
   (float16_t)-0.747100606f,  (float16_t)0.664710978f,
   (float16_t)-0.748119380f,  (float16_t)0.663564159f,
   (float16_t)-0.749136395f,  (float16_t)0.662415778f,
   (float16_t)-0.750151646f,  (float16_t)0.661265838f,
   (float16_t)-0.751165132f,  (float16_t)0.660114342f,
   (float16_t)-0.752176850f,  (float16_t)0.658961293f,
   (float16_t)-0.753186799f,  (float16_t)0.657806693f,
   (float16_t)-0.754194975f,  (float16_t)0.656650546f,
   (float16_t)-0.755201377f,  (float16_t)0.655492853f,
   (float16_t)-0.756206001f,  (float16_t)0.654333618f,
   (float16_t)-0.757208847f,  (float16_t)0.653172843f,
   (float16_t)-0.758209910f,  (float16_t)0.652010531f,
   (float16_t)-0.759209189f,  (float16_t)0.650846685f,
   (float16_t)-0.760206682f,  (float16_t)0.649681307f,
   (float16_t)-0.761202385f,  (float16_t)0.648514401f,
   (float16_t)-0.762196298f,  (float16_t)0.647345969f,
   (float16_t)-0.763188417f,  (float16_t)0.646176013f,
   (float16_t)-0.764178741f,  (float16_t)0.645004537f,
   (float16_t)-0.765167266f,  (float16_t)0.643831543f,
   (float16_t)-0.766153990f,  (float16_t)0.642657034f,
   (float16_t)-0.767138912f,  (float16_t)0.641481013f,
   (float16_t)-0.768122029f,  (float16_t)0.640303482f,
   (float16_t)-0.769103338f,  (float16_t)0.639124445f,
   (float16_t)-0.770082837f,  (float16_t)0.637943904f,
   (float16_t)-0.771060524f,  (float16_t)0.636761861f,
   (float16_t)-0.772036397f,  (float16_t)0.635578320f,
   (float16_t)-0.773010453f,  (float16_t)0.634393284f,
   (float16_t)-0.773982691f,  (float16_t)0.633206755f,
   (float16_t)-0.774953107f,  (float16_t)0.632018736f,
   (float16_t)-0.775921699f,  (float16_t)0.630829230f,
   (float16_t)-0.776888466f,  (float16_t)0.629638239f,
   (float16_t)-0.777853404f,  (float16_t)0.628445767f,
   (float16_t)-0.778816512f,  (float16_t)0.627251815f,
   (float16_t)-0.779777788f,  (float16_t)0.626056388f,
   (float16_t)-0.780737229f,  (float16_t)0.624859488f,
   (float16_t)-0.781694832f,  (float16_t)0.623661118f,
   (float16_t)-0.782650596f,  (float16_t)0.622461279f,
   (float16_t)-0.783604519f,  (float16_t)0.621259977f,
   (float16_t)-0.784556597f,  (float16_t)0.620057212f,
   (float16_t)-0.785506830f,  (float16_t)0.618852988f,
   (float16_t)-0.786455214f,  (float16_t)0.617647308f,
   (float16_t)-0.787401747f,  (float16_t)0.616440175f,
   (float16_t)-0.788346428f,  (float16_t)0.615231591f,
   (float16_t)-0.789289253f,  (float16_t)0.614021559f,
   (float16_t)-0.790230221f,  (float16_t)0.612810082f,
   (float16_t)-0.791169330f,  (float16_t)0.611597164f,
   (float16_t)-0.792106577f,  (float16_t)0.610382806f,
   (float16_t)-0.793041960f,  (float16_t)0.609167012f,
   (float16_t)-0.793975478f,  (float16_t)0.607949785f,
   (float16_t)-0.794907126f,  (float16_t)0.606731127f,
   (float16_t)-0.795836905f,  (float16_t)0.605511041f,
   (float16_t)-0.796764810f,  (float16_t)0.604289531f,
   (float16_t)-0.797690841f,  (float16_t)0.603066599f,
   (float16_t)-0.798614995f,  (float16_t)0.601842247f,
   (float16_t)-0.799537269f,  (float16_t)0.600616479f,
   (float16_t)-0.800457662f,  (float16_t)0.599389298f,
   (float16_t)-0.801376172f,  (float16_t)0.598160707f,
   (float16_t)-0.802292796f,  (float16_t)0.596930708f,
   (float16_t)-0.803207531f,  (float16_t)0.595699304f,
   (float16_t)-0.804120377f,  (float16_t)0.594466499f,
   (float16_t)-0.805031331f,  (float16_t)0.593232295f,
   (float16_t)-0.805940391f,  (float16_t)0.591996695f,
   (float16_t)-0.806847554f,  (float16_t)0.590759702f,
   (float16_t)-0.807752818f,  (float16_t)0.589521319f,
   (float16_t)-0.808656182f,  (float16_t)0.588281548f,
   (float16_t)-0.809557642f,  (float16_t)0.587040394f,
   (float16_t)-0.810457198f,  (float16_t)0.585797857f,
   (float16_t)-0.811354847f,  (float16_t)0.584553943f,
   (float16_t)-0.812250587f,  (float16_t)0.583308653f,
   (float16_t)-0.813144415f,  (float16_t)0.582061990f,
   (float16_t)-0.814036330f,  (float16_t)0.580813958f,
   (float16_t)-0.814926329f,  (float16_t)0.579564559f,
   (float16_t)-0.815814411f,  (float16_t)0.578313796f,
   (float16_t)-0.816700573f,  (float16_t)0.577061673f,
   (float16_t)-0.817584813f,  (float16_t)0.575808191f,
   (float16_t)-0.818467130f,  (float16_t)0.574553355f,
   (float16_t)-0.819347520f,  (float16_t)0.573297167f,
   (float16_t)-0.820225983f,  (float16_t)0.572039629f,
   (float16_t)-0.821102515f,  (float16_t)0.570780746f,
   (float16_t)-0.821977115f,  (float16_t)0.569520519f,
   (float16_t)-0.822849781f,  (float16_t)0.568258953f,
   (float16_t)-0.823720511f,  (float16_t)0.566996049f,
   (float16_t)-0.824589303f,  (float16_t)0.565731811f,
   (float16_t)-0.825456154f,  (float16_t)0.564466242f,
   (float16_t)-0.826321063f,  (float16_t)0.563199344f,
   (float16_t)-0.827184027f,  (float16_t)0.561931121f,
   (float16_t)-0.828045045f,  (float16_t)0.560661576f,
   (float16_t)-0.828904115f,  (float16_t)0.559390712f,
   (float16_t)-0.829761234f,  (float16_t)0.558118531f,
   (float16_t)-0.830616400f,  (float16_t)0.556845037f,
   (float16_t)-0.831469612f,  (float16_t)0.555570233f,
   (float16_t)-0.832320868f,  (float16_t)0.554294121f,
   (float16_t)-0.833170165f,  (float16_t)0.553016706f,
   (float16_t)-0.834017501f,  (float16_t)0.551737988f,
   (float16_t)-0.834862875f,  (float16_t)0.550457973f,
   (float16_t)-0.835706284f,  (float16_t)0.549176662f,
   (float16_t)-0.836547727f,  (float16_t)0.547894059f,
   (float16_t)-0.837387202f,  (float16_t)0.546610167f,
   (float16_t)-0.838224706f,  (float16_t)0.545324988f,
   (float16_t)-0.839060237f,  (float16_t)0.544038527f,
   (float16_t)-0.839893794f,  (float16_t)0.542750785f,
   (float16_t)-0.840725375f,  (float16_t)0.541461766f,
   (float16_t)-0.841554977f,  (float16_t)0.540171473f,
   (float16_t)-0.842382600f,  (float16_t)0.538879909f,
   (float16_t)-0.843208240f,  (float16_t)0.537587076f,
   (float16_t)-0.844031895f,  (float16_t)0.536292979f,
   (float16_t)-0.844853565f,  (float16_t)0.534997620f,
   (float16_t)-0.845673247f,  (float16_t)0.533701002f,
   (float16_t)-0.846490939f,  (float16_t)0.532403128f,
   (float16_t)-0.847306639f,  (float16_t)0.531104001f,
   (float16_t)-0.848120345f,  (float16_t)0.529803625f,
   (float16_t)-0.848932055f,  (float16_t)0.528502002f,
   (float16_t)-0.849741768f,  (float16_t)0.527199135f,
   (float16_t)-0.850549481f,  (float16_t)0.525895027f,
   (float16_t)-0.851355193f,  (float16_t)0.524589683f,
   (float16_t)-0.852158902f,  (float16_t)0.523283103f,
   (float16_t)-0.852960605f,  (float16_t)0.521975293f,
   (float16_t)-0.853760301f,  (float16_t)0.520666254f,
   (float16_t)-0.854557988f,  (float16_t)0.519355990f,
   (float16_t)-0.855353665f,  (float16_t)0.518044504f,
   (float16_t)-0.856147328f,  (float16_t)0.516731799f,
   (float16_t)-0.856938977f,  (float16_t)0.515417878f,
   (float16_t)-0.857728610f,  (float16_t)0.514102744f,
   (float16_t)-0.858516224f,  (float16_t)0.512786401f,
   (float16_t)-0.859301818f,  (float16_t)0.511468850f,
   (float16_t)-0.860085390f,  (float16_t)0.510150097f,
   (float16_t)-0.860866939f,  (float16_t)0.508830143f,
   (float16_t)-0.861646461f,  (float16_t)0.507508991f,
   (float16_t)-0.862423956f,  (float16_t)0.506186645f,
   (float16_t)-0.863199422f,  (float16_t)0.504863109f,
   (float16_t)-0.863972856f,  (float16_t)0.503538384f,
   (float16_t)-0.864744258f,  (float16_t)0.502212474f,
   (float16_t)-0.865513624f,  (float16_t)0.500885383f,
   (float16_t)-0.866280954f,  (float16_t)0.499557113f,
   (float16_t)-0.867046246f,  (float16_t)0.498227667f,
   (float16_t)-0.867809497f,  (float16_t)0.496897049f,
   (float16_t)-0.868570706f,  (float16_t)0.495565262f,
   (float16_t)-0.869329871f,  (float16_t)0.494232309f,
   (float16_t)-0.870086991f,  (float16_t)0.492898192f,
   (float16_t)-0.870842063f,  (float16_t)0.491562916f,
   (float16_t)-0.871595087f,  (float16_t)0.490226483f,
   (float16_t)-0.872346059f,  (float16_t)0.488888897f,
   (float16_t)-0.873094978f,  (float16_t)0.487550160f,
   (float16_t)-0.873841843f,  (float16_t)0.486210276f,
   (float16_t)-0.874586652f,  (float16_t)0.484869248f,
   (float16_t)-0.875329403f,  (float16_t)0.483527079f,
   (float16_t)-0.876070094f,  (float16_t)0.482183772f,
   (float16_t)-0.876808724f,  (float16_t)0.480839331f,
   (float16_t)-0.877545290f,  (float16_t)0.479493758f,
   (float16_t)-0.878279792f,  (float16_t)0.478147056f,
   (float16_t)-0.879012226f,  (float16_t)0.476799230f,
   (float16_t)-0.879742593f,  (float16_t)0.475450282f,
   (float16_t)-0.880470889f,  (float16_t)0.474100215f,
   (float16_t)-0.881197113f,  (float16_t)0.472749032f,
   (float16_t)-0.881921264f,  (float16_t)0.471396737f,
   (float16_t)-0.882643340f,  (float16_t)0.470043332f,
   (float16_t)-0.883363339f,  (float16_t)0.468688822f,
   (float16_t)-0.884081259f,  (float16_t)0.467333209f,
   (float16_t)-0.884797098f,  (float16_t)0.465976496f,
   (float16_t)-0.885510856f,  (float16_t)0.464618686f,
   (float16_t)-0.886222530f,  (float16_t)0.463259784f,
   (float16_t)-0.886932119f,  (float16_t)0.461899791f,
   (float16_t)-0.887639620f,  (float16_t)0.460538711f,
   (float16_t)-0.888345033f,  (float16_t)0.459176548f,
   (float16_t)-0.889048356f,  (float16_t)0.457813304f,
   (float16_t)-0.889749586f,  (float16_t)0.456448982f,
   (float16_t)-0.890448723f,  (float16_t)0.455083587f,
   (float16_t)-0.891145765f,  (float16_t)0.453717121f,
   (float16_t)-0.891840709f,  (float16_t)0.452349587f,
   (float16_t)-0.892533555f,  (float16_t)0.450980989f,
   (float16_t)-0.893224301f,  (float16_t)0.449611330f,
   (float16_t)-0.893912945f,  (float16_t)0.448240612f,
   (float16_t)-0.894599486f,  (float16_t)0.446868840f,
   (float16_t)-0.895283921f,  (float16_t)0.445496017f,
   (float16_t)-0.895966250f,  (float16_t)0.444122145f,
   (float16_t)-0.896646470f,  (float16_t)0.442747228f,
   (float16_t)-0.897324581f,  (float16_t)0.441371269f,
   (float16_t)-0.898000580f,  (float16_t)0.439994271f,
   (float16_t)-0.898674466f,  (float16_t)0.438616239f,
   (float16_t)-0.899346237f,  (float16_t)0.437237174f,
   (float16_t)-0.900015892f,  (float16_t)0.435857080f,
   (float16_t)-0.900683429f,  (float16_t)0.434475961f,
   (float16_t)-0.901348847f,  (float16_t)0.433093819f,
   (float16_t)-0.902012144f,  (float16_t)0.431710658f,
   (float16_t)-0.902673318f,  (float16_t)0.430326481f,
   (float16_t)-0.903332368f,  (float16_t)0.428941292f,
   (float16_t)-0.903989293f,  (float16_t)0.427555093f,
   (float16_t)-0.904644091f,  (float16_t)0.426167889f,
   (float16_t)-0.905296759f,  (float16_t)0.424779681f,
   (float16_t)-0.905947298f,  (float16_t)0.423390474f,
   (float16_t)-0.906595705f,  (float16_t)0.422000271f,
   (float16_t)-0.907241978f,  (float16_t)0.420609074f,
   (float16_t)-0.907886116f,  (float16_t)0.419216888f,
   (float16_t)-0.908528119f,  (float16_t)0.417823716f,
   (float16_t)-0.909167983f,  (float16_t)0.416429560f,
   (float16_t)-0.909805708f,  (float16_t)0.415034424f,
   (float16_t)-0.910441292f,  (float16_t)0.413638312f,
   (float16_t)-0.911074734f,  (float16_t)0.412241227f,
   (float16_t)-0.911706032f,  (float16_t)0.410843171f,
   (float16_t)-0.912335185f,  (float16_t)0.409444149f,
   (float16_t)-0.912962190f,  (float16_t)0.408044163f,
   (float16_t)-0.913587048f,  (float16_t)0.406643217f,
   (float16_t)-0.914209756f,  (float16_t)0.405241314f,
   (float16_t)-0.914830312f,  (float16_t)0.403838458f,
   (float16_t)-0.915448716f,  (float16_t)0.402434651f,
   (float16_t)-0.916064966f,  (float16_t)0.401029897f,
   (float16_t)-0.916679060f,  (float16_t)0.399624200f,
   (float16_t)-0.917290997f,  (float16_t)0.398217562f,
   (float16_t)-0.917900776f,  (float16_t)0.396809987f,
   (float16_t)-0.918508394f,  (float16_t)0.395401479f,
   (float16_t)-0.919113852f,  (float16_t)0.393992040f,
   (float16_t)-0.919717146f,  (float16_t)0.392581674f,
   (float16_t)-0.920318277f,  (float16_t)0.391170384f,
   (float16_t)-0.920917242f,  (float16_t)0.389758174f,
   (float16_t)-0.921514039f,  (float16_t)0.388345047f,
   (float16_t)-0.922108669f,  (float16_t)0.386931006f,
   (float16_t)-0.922701128f,  (float16_t)0.385516054f,
   (float16_t)-0.923291417f,  (float16_t)0.384100195f,
   (float16_t)-0.923879533f,  (float16_t)0.382683432f,
   (float16_t)-0.924465474f,  (float16_t)0.381265769f,
   (float16_t)-0.925049241f,  (float16_t)0.379847209f,
   (float16_t)-0.925630831f,  (float16_t)0.378427755f,
   (float16_t)-0.926210242f,  (float16_t)0.377007410f,
   (float16_t)-0.926787474f,  (float16_t)0.375586178f,
   (float16_t)-0.927362526f,  (float16_t)0.374164063f,
   (float16_t)-0.927935395f,  (float16_t)0.372741067f,
   (float16_t)-0.928506080f,  (float16_t)0.371317194f,
   (float16_t)-0.929074581f,  (float16_t)0.369892447f,
   (float16_t)-0.929640896f,  (float16_t)0.368466830f,
   (float16_t)-0.930205023f,  (float16_t)0.367040346f,
   (float16_t)-0.930766961f,  (float16_t)0.365612998f,
   (float16_t)-0.931326709f,  (float16_t)0.364184790f,
   (float16_t)-0.931884266f,  (float16_t)0.362755724f,
   (float16_t)-0.932439629f,  (float16_t)0.361325806f,
   (float16_t)-0.932992799f,  (float16_t)0.359895037f,
   (float16_t)-0.933543773f,  (float16_t)0.358463421f,
   (float16_t)-0.934092550f,  (float16_t)0.357030961f,
   (float16_t)-0.934639130f,  (float16_t)0.355597662f,
   (float16_t)-0.935183510f,  (float16_t)0.354163525f,
   (float16_t)-0.935725689f,  (float16_t)0.352728556f,
   (float16_t)-0.936265667f,  (float16_t)0.351292756f,
   (float16_t)-0.936803442f,  (float16_t)0.349856130f,
   (float16_t)-0.937339012f,  (float16_t)0.348418680f,
   (float16_t)-0.937872376f,  (float16_t)0.346980411f,
   (float16_t)-0.938403534f,  (float16_t)0.345541325f,
   (float16_t)-0.938932484f,  (float16_t)0.344101426f,
   (float16_t)-0.939459224f,  (float16_t)0.342660717f,
   (float16_t)-0.939983753f,  (float16_t)0.341219202f,
   (float16_t)-0.940506071f,  (float16_t)0.339776884f,
   (float16_t)-0.941026175f,  (float16_t)0.338333767f,
   (float16_t)-0.941544065f,  (float16_t)0.336889853f,
   (float16_t)-0.942059740f,  (float16_t)0.335445147f,
   (float16_t)-0.942573198f,  (float16_t)0.333999651f,
   (float16_t)-0.943084437f,  (float16_t)0.332553370f,
   (float16_t)-0.943593458f,  (float16_t)0.331106306f,
   (float16_t)-0.944100258f,  (float16_t)0.329658463f,
   (float16_t)-0.944604837f,  (float16_t)0.328209844f,
   (float16_t)-0.945107193f,  (float16_t)0.326760452f,
   (float16_t)-0.945607325f,  (float16_t)0.325310292f,
   (float16_t)-0.946105232f,  (float16_t)0.323859367f,
   (float16_t)-0.946600913f,  (float16_t)0.322407679f,
   (float16_t)-0.947094366f,  (float16_t)0.320955232f,
   (float16_t)-0.947585591f,  (float16_t)0.319502031f,
   (float16_t)-0.948074586f,  (float16_t)0.318048077f,
   (float16_t)-0.948561350f,  (float16_t)0.316593376f,
   (float16_t)-0.949045882f,  (float16_t)0.315137929f,
   (float16_t)-0.949528181f,  (float16_t)0.313681740f,
   (float16_t)-0.950008245f,  (float16_t)0.312224814f,
   (float16_t)-0.950486074f,  (float16_t)0.310767153f,
   (float16_t)-0.950961666f,  (float16_t)0.309308760f,
   (float16_t)-0.951435021f,  (float16_t)0.307849640f,
   (float16_t)-0.951906137f,  (float16_t)0.306389795f,
   (float16_t)-0.952375013f,  (float16_t)0.304929230f,
   (float16_t)-0.952841648f,  (float16_t)0.303467947f,
   (float16_t)-0.953306040f,  (float16_t)0.302005949f,
   (float16_t)-0.953768190f,  (float16_t)0.300543241f,
   (float16_t)-0.954228095f,  (float16_t)0.299079826f,
   (float16_t)-0.954685755f,  (float16_t)0.297615707f,
   (float16_t)-0.955141168f,  (float16_t)0.296150888f,
   (float16_t)-0.955594334f,  (float16_t)0.294685372f,
   (float16_t)-0.956045251f,  (float16_t)0.293219163f,
   (float16_t)-0.956493919f,  (float16_t)0.291752263f,
   (float16_t)-0.956940336f,  (float16_t)0.290284677f,
   (float16_t)-0.957384501f,  (float16_t)0.288816408f,
   (float16_t)-0.957826413f,  (float16_t)0.287347460f,
   (float16_t)-0.958266071f,  (float16_t)0.285877835f,
   (float16_t)-0.958703475f,  (float16_t)0.284407537f,
   (float16_t)-0.959138622f,  (float16_t)0.282936570f,
   (float16_t)-0.959571513f,  (float16_t)0.281464938f,
   (float16_t)-0.960002146f,  (float16_t)0.279992643f,
   (float16_t)-0.960430519f,  (float16_t)0.278519689f,
   (float16_t)-0.960856633f,  (float16_t)0.277046080f,
   (float16_t)-0.961280486f,  (float16_t)0.275571819f,
   (float16_t)-0.961702077f,  (float16_t)0.274096910f,
   (float16_t)-0.962121404f,  (float16_t)0.272621355f,
   (float16_t)-0.962538468f,  (float16_t)0.271145160f,
   (float16_t)-0.962953267f,  (float16_t)0.269668326f,
   (float16_t)-0.963365800f,  (float16_t)0.268190857f,
   (float16_t)-0.963776066f,  (float16_t)0.266712757f,
   (float16_t)-0.964184064f,  (float16_t)0.265234030f,
   (float16_t)-0.964589793f,  (float16_t)0.263754679f,
   (float16_t)-0.964993253f,  (float16_t)0.262274707f,
   (float16_t)-0.965394442f,  (float16_t)0.260794118f,
   (float16_t)-0.965793359f,  (float16_t)0.259312915f,
   (float16_t)-0.966190003f,  (float16_t)0.257831102f,
   (float16_t)-0.966584374f,  (float16_t)0.256348682f,
   (float16_t)-0.966976471f,  (float16_t)0.254865660f,
   (float16_t)-0.967366292f,  (float16_t)0.253382037f,
   (float16_t)-0.967753837f,  (float16_t)0.251897818f,
   (float16_t)-0.968139105f,  (float16_t)0.250413007f,
   (float16_t)-0.968522094f,  (float16_t)0.248927606f,
   (float16_t)-0.968902805f,  (float16_t)0.247441619f,
   (float16_t)-0.969281235f,  (float16_t)0.245955050f,
   (float16_t)-0.969657385f,  (float16_t)0.244467903f,
   (float16_t)-0.970031253f,  (float16_t)0.242980180f,
   (float16_t)-0.970402839f,  (float16_t)0.241491885f,
   (float16_t)-0.970772141f,  (float16_t)0.240003022f,
   (float16_t)-0.971139158f,  (float16_t)0.238513595f,
   (float16_t)-0.971503891f,  (float16_t)0.237023606f,
   (float16_t)-0.971866337f,  (float16_t)0.235533059f,
   (float16_t)-0.972226497f,  (float16_t)0.234041959f,
   (float16_t)-0.972584369f,  (float16_t)0.232550307f,
   (float16_t)-0.972939952f,  (float16_t)0.231058108f,
   (float16_t)-0.973293246f,  (float16_t)0.229565366f,
   (float16_t)-0.973644250f,  (float16_t)0.228072083f,
   (float16_t)-0.973992962f,  (float16_t)0.226578264f,
   (float16_t)-0.974339383f,  (float16_t)0.225083911f,
   (float16_t)-0.974683511f,  (float16_t)0.223589029f,
   (float16_t)-0.975025345f,  (float16_t)0.222093621f,
   (float16_t)-0.975364885f,  (float16_t)0.220597690f,
   (float16_t)-0.975702130f,  (float16_t)0.219101240f,
   (float16_t)-0.976037079f,  (float16_t)0.217604275f,
   (float16_t)-0.976369731f,  (float16_t)0.216106797f,
   (float16_t)-0.976700086f,  (float16_t)0.214608811f,
   (float16_t)-0.977028143f,  (float16_t)0.213110320f,
   (float16_t)-0.977353900f,  (float16_t)0.211611327f,
   (float16_t)-0.977677358f,  (float16_t)0.210111837f,
   (float16_t)-0.977998515f,  (float16_t)0.208611852f,
   (float16_t)-0.978317371f,  (float16_t)0.207111376f,
   (float16_t)-0.978633924f,  (float16_t)0.205610413f,
   (float16_t)-0.978948175f,  (float16_t)0.204108966f,
   (float16_t)-0.979260123f,  (float16_t)0.202607039f,
   (float16_t)-0.979569766f,  (float16_t)0.201104635f,
   (float16_t)-0.979877104f,  (float16_t)0.199601758f,
   (float16_t)-0.980182136f,  (float16_t)0.198098411f,
   (float16_t)-0.980484862f,  (float16_t)0.196594598f,
   (float16_t)-0.980785280f,  (float16_t)0.195090322f,
   (float16_t)-0.981083391f,  (float16_t)0.193585587f,
   (float16_t)-0.981379193f,  (float16_t)0.192080397f,
   (float16_t)-0.981672686f,  (float16_t)0.190574755f,
   (float16_t)-0.981963869f,  (float16_t)0.189068664f,
   (float16_t)-0.982252741f,  (float16_t)0.187562129f,
   (float16_t)-0.982539302f,  (float16_t)0.186055152f,
   (float16_t)-0.982823551f,  (float16_t)0.184547737f,
   (float16_t)-0.983105487f,  (float16_t)0.183039888f,
   (float16_t)-0.983385110f,  (float16_t)0.181531608f,
   (float16_t)-0.983662419f,  (float16_t)0.180022901f,
   (float16_t)-0.983937413f,  (float16_t)0.178513771f,
   (float16_t)-0.984210092f,  (float16_t)0.177004220f,
   (float16_t)-0.984480455f,  (float16_t)0.175494253f,
   (float16_t)-0.984748502f,  (float16_t)0.173983873f,
   (float16_t)-0.985014231f,  (float16_t)0.172473084f,
   (float16_t)-0.985277642f,  (float16_t)0.170961889f,
   (float16_t)-0.985538735f,  (float16_t)0.169450291f,
   (float16_t)-0.985797509f,  (float16_t)0.167938295f,
   (float16_t)-0.986053963f,  (float16_t)0.166425904f,
   (float16_t)-0.986308097f,  (float16_t)0.164913120f,
   (float16_t)-0.986559910f,  (float16_t)0.163399949f,
   (float16_t)-0.986809402f,  (float16_t)0.161886394f,
   (float16_t)-0.987056571f,  (float16_t)0.160372457f,
   (float16_t)-0.987301418f,  (float16_t)0.158858143f,
   (float16_t)-0.987543942f,  (float16_t)0.157343456f,
   (float16_t)-0.987784142f,  (float16_t)0.155828398f,
   (float16_t)-0.988022017f,  (float16_t)0.154312973f,
   (float16_t)-0.988257568f,  (float16_t)0.152797185f,
   (float16_t)-0.988490793f,  (float16_t)0.151281038f,
   (float16_t)-0.988721692f,  (float16_t)0.149764535f,
   (float16_t)-0.988950265f,  (float16_t)0.148247679f,
   (float16_t)-0.989176510f,  (float16_t)0.146730474f,
   (float16_t)-0.989400428f,  (float16_t)0.145212925f,
   (float16_t)-0.989622017f,  (float16_t)0.143695033f,
   (float16_t)-0.989841278f,  (float16_t)0.142176804f,
   (float16_t)-0.990058210f,  (float16_t)0.140658239f,
   (float16_t)-0.990272812f,  (float16_t)0.139139344f,
   (float16_t)-0.990485084f,  (float16_t)0.137620122f,
   (float16_t)-0.990695025f,  (float16_t)0.136100575f,
   (float16_t)-0.990902635f,  (float16_t)0.134580709f,
   (float16_t)-0.991107914f,  (float16_t)0.133060525f,
   (float16_t)-0.991310860f,  (float16_t)0.131540029f,
   (float16_t)-0.991511473f,  (float16_t)0.130019223f,
   (float16_t)-0.991709754f,  (float16_t)0.128498111f,
   (float16_t)-0.991905700f,  (float16_t)0.126976696f,
   (float16_t)-0.992099313f,  (float16_t)0.125454983f,
   (float16_t)-0.992290591f,  (float16_t)0.123932975f,
   (float16_t)-0.992479535f,  (float16_t)0.122410675f,
   (float16_t)-0.992666142f,  (float16_t)0.120888087f,
   (float16_t)-0.992850414f,  (float16_t)0.119365215f,
   (float16_t)-0.993032350f,  (float16_t)0.117842062f,
   (float16_t)-0.993211949f,  (float16_t)0.116318631f,
   (float16_t)-0.993389211f,  (float16_t)0.114794927f,
   (float16_t)-0.993564136f,  (float16_t)0.113270952f,
   (float16_t)-0.993736722f,  (float16_t)0.111746711f,
   (float16_t)-0.993906970f,  (float16_t)0.110222207f,
   (float16_t)-0.994074879f,  (float16_t)0.108697444f,
   (float16_t)-0.994240449f,  (float16_t)0.107172425f,
   (float16_t)-0.994403680f,  (float16_t)0.105647154f,
   (float16_t)-0.994564571f,  (float16_t)0.104121634f,
   (float16_t)-0.994723121f,  (float16_t)0.102595869f,
   (float16_t)-0.994879331f,  (float16_t)0.101069863f,
   (float16_t)-0.995033199f,  (float16_t)0.099543619f,
   (float16_t)-0.995184727f,  (float16_t)0.098017140f,
   (float16_t)-0.995333912f,  (float16_t)0.096490431f,
   (float16_t)-0.995480755f,  (float16_t)0.094963495f,
   (float16_t)-0.995625256f,  (float16_t)0.093436336f,
   (float16_t)-0.995767414f,  (float16_t)0.091908956f,
   (float16_t)-0.995907229f,  (float16_t)0.090381361f,
   (float16_t)-0.996044701f,  (float16_t)0.088853553f,
   (float16_t)-0.996179829f,  (float16_t)0.087325535f,
   (float16_t)-0.996312612f,  (float16_t)0.085797312f,
   (float16_t)-0.996443051f,  (float16_t)0.084268888f,
   (float16_t)-0.996571146f,  (float16_t)0.082740265f,
   (float16_t)-0.996696895f,  (float16_t)0.081211447f,
   (float16_t)-0.996820299f,  (float16_t)0.079682438f,
   (float16_t)-0.996941358f,  (float16_t)0.078153242f,
   (float16_t)-0.997060070f,  (float16_t)0.076623861f,
   (float16_t)-0.997176437f,  (float16_t)0.075094301f,
   (float16_t)-0.997290457f,  (float16_t)0.073564564f,
   (float16_t)-0.997402130f,  (float16_t)0.072034653f,
   (float16_t)-0.997511456f,  (float16_t)0.070504573f,
   (float16_t)-0.997618435f,  (float16_t)0.068974328f,
   (float16_t)-0.997723067f,  (float16_t)0.067443920f,
   (float16_t)-0.997825350f,  (float16_t)0.065913353f,
   (float16_t)-0.997925286f,  (float16_t)0.064382631f,
   (float16_t)-0.998022874f,  (float16_t)0.062851758f,
   (float16_t)-0.998118113f,  (float16_t)0.061320736f,
   (float16_t)-0.998211003f,  (float16_t)0.059789571f,
   (float16_t)-0.998301545f,  (float16_t)0.058258265f,
   (float16_t)-0.998389737f,  (float16_t)0.056726821f,
   (float16_t)-0.998475581f,  (float16_t)0.055195244f,
   (float16_t)-0.998559074f,  (float16_t)0.053663538f,
   (float16_t)-0.998640218f,  (float16_t)0.052131705f,
   (float16_t)-0.998719012f,  (float16_t)0.050599749f,
   (float16_t)-0.998795456f,  (float16_t)0.049067674f,
   (float16_t)-0.998869550f,  (float16_t)0.047535484f,
   (float16_t)-0.998941293f,  (float16_t)0.046003182f,
   (float16_t)-0.999010686f,  (float16_t)0.044470772f,
   (float16_t)-0.999077728f,  (float16_t)0.042938257f,
   (float16_t)-0.999142419f,  (float16_t)0.041405641f,
   (float16_t)-0.999204759f,  (float16_t)0.039872928f,
   (float16_t)-0.999264747f,  (float16_t)0.038340120f,
   (float16_t)-0.999322385f,  (float16_t)0.036807223f,
   (float16_t)-0.999377670f,  (float16_t)0.035274239f,
   (float16_t)-0.999430605f,  (float16_t)0.033741172f,
   (float16_t)-0.999481187f,  (float16_t)0.032208025f,
   (float16_t)-0.999529418f,  (float16_t)0.030674803f,
   (float16_t)-0.999575296f,  (float16_t)0.029141509f,
   (float16_t)-0.999618822f,  (float16_t)0.027608146f,
   (float16_t)-0.999659997f,  (float16_t)0.026074718f,
   (float16_t)-0.999698819f,  (float16_t)0.024541229f,
   (float16_t)-0.999735288f,  (float16_t)0.023007681f,
   (float16_t)-0.999769405f,  (float16_t)0.021474080f,
   (float16_t)-0.999801170f,  (float16_t)0.019940429f,
   (float16_t)-0.999830582f,  (float16_t)0.018406730f,
   (float16_t)-0.999857641f,  (float16_t)0.016872988f,
   (float16_t)-0.999882347f,  (float16_t)0.015339206f,
   (float16_t)-0.999904701f,  (float16_t)0.013805389f,
   (float16_t)-0.999924702f,  (float16_t)0.012271538f,
   (float16_t)-0.999942350f,  (float16_t)0.010737659f,
   (float16_t)-0.999957645f,  (float16_t)0.009203755f,
   (float16_t)-0.999970586f,  (float16_t)0.007669829f,
   (float16_t)-0.999981175f,  (float16_t)0.006135885f,
   (float16_t)-0.999989411f,  (float16_t)0.004601926f,
   (float16_t)-0.999995294f,  (float16_t)0.003067957f,
   (float16_t)-0.999998823f,  (float16_t)0.001533980f,
   (float16_t)-1.000000000f,  (float16_t)0.000000000f,
   (float16_t)-0.999998823f, (float16_t)-0.001533980f,
   (float16_t)-0.999995294f, (float16_t)-0.003067957f,
   (float16_t)-0.999989411f, (float16_t)-0.004601926f,
   (float16_t)-0.999981175f, (float16_t)-0.006135885f,
   (float16_t)-0.999970586f, (float16_t)-0.007669829f,
   (float16_t)-0.999957645f, (float16_t)-0.009203755f,
   (float16_t)-0.999942350f, (float16_t)-0.010737659f,
   (float16_t)-0.999924702f, (float16_t)-0.012271538f,
   (float16_t)-0.999904701f, (float16_t)-0.013805389f,
   (float16_t)-0.999882347f, (float16_t)-0.015339206f,
   (float16_t)-0.999857641f, (float16_t)-0.016872988f,
   (float16_t)-0.999830582f, (float16_t)-0.018406730f,
   (float16_t)-0.999801170f, (float16_t)-0.019940429f,
   (float16_t)-0.999769405f, (float16_t)-0.021474080f,
   (float16_t)-0.999735288f, (float16_t)-0.023007681f,
   (float16_t)-0.999698819f, (float16_t)-0.024541229f,
   (float16_t)-0.999659997f, (float16_t)-0.026074718f,
   (float16_t)-0.999618822f, (float16_t)-0.027608146f,
   (float16_t)-0.999575296f, (float16_t)-0.029141509f,
   (float16_t)-0.999529418f, (float16_t)-0.030674803f,
   (float16_t)-0.999481187f, (float16_t)-0.032208025f,
   (float16_t)-0.999430605f, (float16_t)-0.033741172f,
   (float16_t)-0.999377670f, (float16_t)-0.035274239f,
   (float16_t)-0.999322385f, (float16_t)-0.036807223f,
   (float16_t)-0.999264747f, (float16_t)-0.038340120f,
   (float16_t)-0.999204759f, (float16_t)-0.039872928f,
   (float16_t)-0.999142419f, (float16_t)-0.041405641f,
   (float16_t)-0.999077728f, (float16_t)-0.042938257f,
   (float16_t)-0.999010686f, (float16_t)-0.044470772f,
   (float16_t)-0.998941293f, (float16_t)-0.046003182f,
   (float16_t)-0.998869550f, (float16_t)-0.047535484f,
   (float16_t)-0.998795456f, (float16_t)-0.049067674f,
   (float16_t)-0.998719012f, (float16_t)-0.050599749f,
   (float16_t)-0.998640218f, (float16_t)-0.052131705f,
   (float16_t)-0.998559074f, (float16_t)-0.053663538f,
   (float16_t)-0.998475581f, (float16_t)-0.055195244f,
   (float16_t)-0.998389737f, (float16_t)-0.056726821f,
   (float16_t)-0.998301545f, (float16_t)-0.058258265f,
   (float16_t)-0.998211003f, (float16_t)-0.059789571f,
   (float16_t)-0.998118113f, (float16_t)-0.061320736f,
   (float16_t)-0.998022874f, (float16_t)-0.062851758f,
   (float16_t)-0.997925286f, (float16_t)-0.064382631f,
   (float16_t)-0.997825350f, (float16_t)-0.065913353f,
   (float16_t)-0.997723067f, (float16_t)-0.067443920f,
   (float16_t)-0.997618435f, (float16_t)-0.068974328f,
   (float16_t)-0.997511456f, (float16_t)-0.070504573f,
   (float16_t)-0.997402130f, (float16_t)-0.072034653f,
   (float16_t)-0.997290457f, (float16_t)-0.073564564f,
   (float16_t)-0.997176437f, (float16_t)-0.075094301f,
   (float16_t)-0.997060070f, (float16_t)-0.076623861f,
   (float16_t)-0.996941358f, (float16_t)-0.078153242f,
   (float16_t)-0.996820299f, (float16_t)-0.079682438f,
   (float16_t)-0.996696895f, (float16_t)-0.081211447f,
   (float16_t)-0.996571146f, (float16_t)-0.082740265f,
   (float16_t)-0.996443051f, (float16_t)-0.084268888f,
   (float16_t)-0.996312612f, (float16_t)-0.085797312f,
   (float16_t)-0.996179829f, (float16_t)-0.087325535f,
   (float16_t)-0.996044701f, (float16_t)-0.088853553f,
   (float16_t)-0.995907229f, (float16_t)-0.090381361f,
   (float16_t)-0.995767414f, (float16_t)-0.091908956f,
   (float16_t)-0.995625256f, (float16_t)-0.093436336f,
   (float16_t)-0.995480755f, (float16_t)-0.094963495f,
   (float16_t)-0.995333912f, (float16_t)-0.096490431f,
   (float16_t)-0.995184727f, (float16_t)-0.098017140f,
   (float16_t)-0.995033199f, (float16_t)-0.099543619f,
   (float16_t)-0.994879331f, (float16_t)-0.101069863f,
   (float16_t)-0.994723121f, (float16_t)-0.102595869f,
   (float16_t)-0.994564571f, (float16_t)-0.104121634f,
   (float16_t)-0.994403680f, (float16_t)-0.105647154f,
   (float16_t)-0.994240449f, (float16_t)-0.107172425f,
   (float16_t)-0.994074879f, (float16_t)-0.108697444f,
   (float16_t)-0.993906970f, (float16_t)-0.110222207f,
   (float16_t)-0.993736722f, (float16_t)-0.111746711f,
   (float16_t)-0.993564136f, (float16_t)-0.113270952f,
   (float16_t)-0.993389211f, (float16_t)-0.114794927f,
   (float16_t)-0.993211949f, (float16_t)-0.116318631f,
   (float16_t)-0.993032350f, (float16_t)-0.117842062f,
   (float16_t)-0.992850414f, (float16_t)-0.119365215f,
   (float16_t)-0.992666142f, (float16_t)-0.120888087f,
   (float16_t)-0.992479535f, (float16_t)-0.122410675f,
   (float16_t)-0.992290591f, (float16_t)-0.123932975f,
   (float16_t)-0.992099313f, (float16_t)-0.125454983f,
   (float16_t)-0.991905700f, (float16_t)-0.126976696f,
   (float16_t)-0.991709754f, (float16_t)-0.128498111f,
   (float16_t)-0.991511473f, (float16_t)-0.130019223f,
   (float16_t)-0.991310860f, (float16_t)-0.131540029f,
   (float16_t)-0.991107914f, (float16_t)-0.133060525f,
   (float16_t)-0.990902635f, (float16_t)-0.134580709f,
   (float16_t)-0.990695025f, (float16_t)-0.136100575f,
   (float16_t)-0.990485084f, (float16_t)-0.137620122f,
   (float16_t)-0.990272812f, (float16_t)-0.139139344f,
   (float16_t)-0.990058210f, (float16_t)-0.140658239f,
   (float16_t)-0.989841278f, (float16_t)-0.142176804f,
   (float16_t)-0.989622017f, (float16_t)-0.143695033f,
   (float16_t)-0.989400428f, (float16_t)-0.145212925f,
   (float16_t)-0.989176510f, (float16_t)-0.146730474f,
   (float16_t)-0.988950265f, (float16_t)-0.148247679f,
   (float16_t)-0.988721692f, (float16_t)-0.149764535f,
   (float16_t)-0.988490793f, (float16_t)-0.151281038f,
   (float16_t)-0.988257568f, (float16_t)-0.152797185f,
   (float16_t)-0.988022017f, (float16_t)-0.154312973f,
   (float16_t)-0.987784142f, (float16_t)-0.155828398f,
   (float16_t)-0.987543942f, (float16_t)-0.157343456f,
   (float16_t)-0.987301418f, (float16_t)-0.158858143f,
   (float16_t)-0.987056571f, (float16_t)-0.160372457f,
   (float16_t)-0.986809402f, (float16_t)-0.161886394f,
   (float16_t)-0.986559910f, (float16_t)-0.163399949f,
   (float16_t)-0.986308097f, (float16_t)-0.164913120f,
   (float16_t)-0.986053963f, (float16_t)-0.166425904f,
   (float16_t)-0.985797509f, (float16_t)-0.167938295f,
   (float16_t)-0.985538735f, (float16_t)-0.169450291f,
   (float16_t)-0.985277642f, (float16_t)-0.170961889f,
   (float16_t)-0.985014231f, (float16_t)-0.172473084f,
   (float16_t)-0.984748502f, (float16_t)-0.173983873f,
   (float16_t)-0.984480455f, (float16_t)-0.175494253f,
   (float16_t)-0.984210092f, (float16_t)-0.177004220f,
   (float16_t)-0.983937413f, (float16_t)-0.178513771f,
   (float16_t)-0.983662419f, (float16_t)-0.180022901f,
   (float16_t)-0.983385110f, (float16_t)-0.181531608f,
   (float16_t)-0.983105487f, (float16_t)-0.183039888f,
   (float16_t)-0.982823551f, (float16_t)-0.184547737f,
   (float16_t)-0.982539302f, (float16_t)-0.186055152f,
   (float16_t)-0.982252741f, (float16_t)-0.187562129f,
   (float16_t)-0.981963869f, (float16_t)-0.189068664f,
   (float16_t)-0.981672686f, (float16_t)-0.190574755f,
   (float16_t)-0.981379193f, (float16_t)-0.192080397f,
   (float16_t)-0.981083391f, (float16_t)-0.193585587f,
   (float16_t)-0.980785280f, (float16_t)-0.195090322f,
   (float16_t)-0.980484862f, (float16_t)-0.196594598f,
   (float16_t)-0.980182136f, (float16_t)-0.198098411f,
   (float16_t)-0.979877104f, (float16_t)-0.199601758f,
   (float16_t)-0.979569766f, (float16_t)-0.201104635f,
   (float16_t)-0.979260123f, (float16_t)-0.202607039f,
   (float16_t)-0.978948175f, (float16_t)-0.204108966f,
   (float16_t)-0.978633924f, (float16_t)-0.205610413f,
   (float16_t)-0.978317371f, (float16_t)-0.207111376f,
   (float16_t)-0.977998515f, (float16_t)-0.208611852f,
   (float16_t)-0.977677358f, (float16_t)-0.210111837f,
   (float16_t)-0.977353900f, (float16_t)-0.211611327f,
   (float16_t)-0.977028143f, (float16_t)-0.213110320f,
   (float16_t)-0.976700086f, (float16_t)-0.214608811f,
   (float16_t)-0.976369731f, (float16_t)-0.216106797f,
   (float16_t)-0.976037079f, (float16_t)-0.217604275f,
   (float16_t)-0.975702130f, (float16_t)-0.219101240f,
   (float16_t)-0.975364885f, (float16_t)-0.220597690f,
   (float16_t)-0.975025345f, (float16_t)-0.222093621f,
   (float16_t)-0.974683511f, (float16_t)-0.223589029f,
   (float16_t)-0.974339383f, (float16_t)-0.225083911f,
   (float16_t)-0.973992962f, (float16_t)-0.226578264f,
   (float16_t)-0.973644250f, (float16_t)-0.228072083f,
   (float16_t)-0.973293246f, (float16_t)-0.229565366f,
   (float16_t)-0.972939952f, (float16_t)-0.231058108f,
   (float16_t)-0.972584369f, (float16_t)-0.232550307f,
   (float16_t)-0.972226497f, (float16_t)-0.234041959f,
   (float16_t)-0.971866337f, (float16_t)-0.235533059f,
   (float16_t)-0.971503891f, (float16_t)-0.237023606f,
   (float16_t)-0.971139158f, (float16_t)-0.238513595f,
   (float16_t)-0.970772141f, (float16_t)-0.240003022f,
   (float16_t)-0.970402839f, (float16_t)-0.241491885f,
   (float16_t)-0.970031253f, (float16_t)-0.242980180f,
   (float16_t)-0.969657385f, (float16_t)-0.244467903f,
   (float16_t)-0.969281235f, (float16_t)-0.245955050f,
   (float16_t)-0.968902805f, (float16_t)-0.247441619f,
   (float16_t)-0.968522094f, (float16_t)-0.248927606f,
   (float16_t)-0.968139105f, (float16_t)-0.250413007f,
   (float16_t)-0.967753837f, (float16_t)-0.251897818f,
   (float16_t)-0.967366292f, (float16_t)-0.253382037f,
   (float16_t)-0.966976471f, (float16_t)-0.254865660f,
   (float16_t)-0.966584374f, (float16_t)-0.256348682f,
   (float16_t)-0.966190003f, (float16_t)-0.257831102f,
   (float16_t)-0.965793359f, (float16_t)-0.259312915f,
   (float16_t)-0.965394442f, (float16_t)-0.260794118f,
   (float16_t)-0.964993253f, (float16_t)-0.262274707f,
   (float16_t)-0.964589793f, (float16_t)-0.263754679f,
   (float16_t)-0.964184064f, (float16_t)-0.265234030f,
   (float16_t)-0.963776066f, (float16_t)-0.266712757f,
   (float16_t)-0.963365800f, (float16_t)-0.268190857f,
   (float16_t)-0.962953267f, (float16_t)-0.269668326f,
   (float16_t)-0.962538468f, (float16_t)-0.271145160f,
   (float16_t)-0.962121404f, (float16_t)-0.272621355f,
   (float16_t)-0.961702077f, (float16_t)-0.274096910f,
   (float16_t)-0.961280486f, (float16_t)-0.275571819f,
   (float16_t)-0.960856633f, (float16_t)-0.277046080f,
   (float16_t)-0.960430519f, (float16_t)-0.278519689f,
   (float16_t)-0.960002146f, (float16_t)-0.279992643f,
   (float16_t)-0.959571513f, (float16_t)-0.281464938f,
   (float16_t)-0.959138622f, (float16_t)-0.282936570f,
   (float16_t)-0.958703475f, (float16_t)-0.284407537f,
   (float16_t)-0.958266071f, (float16_t)-0.285877835f,
   (float16_t)-0.957826413f, (float16_t)-0.287347460f,
   (float16_t)-0.957384501f, (float16_t)-0.288816408f,
   (float16_t)-0.956940336f, (float16_t)-0.290284677f,
   (float16_t)-0.956493919f, (float16_t)-0.291752263f,
   (float16_t)-0.956045251f, (float16_t)-0.293219163f,
   (float16_t)-0.955594334f, (float16_t)-0.294685372f,
   (float16_t)-0.955141168f, (float16_t)-0.296150888f,
   (float16_t)-0.954685755f, (float16_t)-0.297615707f,
   (float16_t)-0.954228095f, (float16_t)-0.299079826f,
   (float16_t)-0.953768190f, (float16_t)-0.300543241f,
   (float16_t)-0.953306040f, (float16_t)-0.302005949f,
   (float16_t)-0.952841648f, (float16_t)-0.303467947f,
   (float16_t)-0.952375013f, (float16_t)-0.304929230f,
   (float16_t)-0.951906137f, (float16_t)-0.306389795f,
   (float16_t)-0.951435021f, (float16_t)-0.307849640f,
   (float16_t)-0.950961666f, (float16_t)-0.309308760f,
   (float16_t)-0.950486074f, (float16_t)-0.310767153f,
   (float16_t)-0.950008245f, (float16_t)-0.312224814f,
   (float16_t)-0.949528181f, (float16_t)-0.313681740f,
   (float16_t)-0.949045882f, (float16_t)-0.315137929f,
   (float16_t)-0.948561350f, (float16_t)-0.316593376f,
   (float16_t)-0.948074586f, (float16_t)-0.318048077f,
   (float16_t)-0.947585591f, (float16_t)-0.319502031f,
   (float16_t)-0.947094366f, (float16_t)-0.320955232f,
   (float16_t)-0.946600913f, (float16_t)-0.322407679f,
   (float16_t)-0.946105232f, (float16_t)-0.323859367f,
   (float16_t)-0.945607325f, (float16_t)-0.325310292f,
   (float16_t)-0.945107193f, (float16_t)-0.326760452f,
   (float16_t)-0.944604837f, (float16_t)-0.328209844f,
   (float16_t)-0.944100258f, (float16_t)-0.329658463f,
   (float16_t)-0.943593458f, (float16_t)-0.331106306f,
   (float16_t)-0.943084437f, (float16_t)-0.332553370f,
   (float16_t)-0.942573198f, (float16_t)-0.333999651f,
   (float16_t)-0.942059740f, (float16_t)-0.335445147f,
   (float16_t)-0.941544065f, (float16_t)-0.336889853f,
   (float16_t)-0.941026175f, (float16_t)-0.338333767f,
   (float16_t)-0.940506071f, (float16_t)-0.339776884f,
   (float16_t)-0.939983753f, (float16_t)-0.341219202f,
   (float16_t)-0.939459224f, (float16_t)-0.342660717f,
   (float16_t)-0.938932484f, (float16_t)-0.344101426f,
   (float16_t)-0.938403534f, (float16_t)-0.345541325f,
   (float16_t)-0.937872376f, (float16_t)-0.346980411f,
   (float16_t)-0.937339012f, (float16_t)-0.348418680f,
   (float16_t)-0.936803442f, (float16_t)-0.349856130f,
   (float16_t)-0.936265667f, (float16_t)-0.351292756f,
   (float16_t)-0.935725689f, (float16_t)-0.352728556f,
   (float16_t)-0.935183510f, (float16_t)-0.354163525f,
   (float16_t)-0.934639130f, (float16_t)-0.355597662f,
   (float16_t)-0.934092550f, (float16_t)-0.357030961f,
   (float16_t)-0.933543773f, (float16_t)-0.358463421f,
   (float16_t)-0.932992799f, (float16_t)-0.359895037f,
   (float16_t)-0.932439629f, (float16_t)-0.361325806f,
   (float16_t)-0.931884266f, (float16_t)-0.362755724f,
   (float16_t)-0.931326709f, (float16_t)-0.364184790f,
   (float16_t)-0.930766961f, (float16_t)-0.365612998f,
   (float16_t)-0.930205023f, (float16_t)-0.367040346f,
   (float16_t)-0.929640896f, (float16_t)-0.368466830f,
   (float16_t)-0.929074581f, (float16_t)-0.369892447f,
   (float16_t)-0.928506080f, (float16_t)-0.371317194f,
   (float16_t)-0.927935395f, (float16_t)-0.372741067f,
   (float16_t)-0.927362526f, (float16_t)-0.374164063f,
   (float16_t)-0.926787474f, (float16_t)-0.375586178f,
   (float16_t)-0.926210242f, (float16_t)-0.377007410f,
   (float16_t)-0.925630831f, (float16_t)-0.378427755f,
   (float16_t)-0.925049241f, (float16_t)-0.379847209f,
   (float16_t)-0.924465474f, (float16_t)-0.381265769f,
   (float16_t)-0.923879533f, (float16_t)-0.382683432f,
   (float16_t)-0.923291417f, (float16_t)-0.384100195f,
   (float16_t)-0.922701128f, (float16_t)-0.385516054f,
   (float16_t)-0.922108669f, (float16_t)-0.386931006f,
   (float16_t)-0.921514039f, (float16_t)-0.388345047f,
   (float16_t)-0.920917242f, (float16_t)-0.389758174f,
   (float16_t)-0.920318277f, (float16_t)-0.391170384f,
   (float16_t)-0.919717146f, (float16_t)-0.392581674f,
   (float16_t)-0.919113852f, (float16_t)-0.393992040f,
   (float16_t)-0.918508394f, (float16_t)-0.395401479f,
   (float16_t)-0.917900776f, (float16_t)-0.396809987f,
   (float16_t)-0.917290997f, (float16_t)-0.398217562f,
   (float16_t)-0.916679060f, (float16_t)-0.399624200f,
   (float16_t)-0.916064966f, (float16_t)-0.401029897f,
   (float16_t)-0.915448716f, (float16_t)-0.402434651f,
   (float16_t)-0.914830312f, (float16_t)-0.403838458f,
   (float16_t)-0.914209756f, (float16_t)-0.405241314f,
   (float16_t)-0.913587048f, (float16_t)-0.406643217f,
   (float16_t)-0.912962190f, (float16_t)-0.408044163f,
   (float16_t)-0.912335185f, (float16_t)-0.409444149f,
   (float16_t)-0.911706032f, (float16_t)-0.410843171f,
   (float16_t)-0.911074734f, (float16_t)-0.412241227f,
   (float16_t)-0.910441292f, (float16_t)-0.413638312f,
   (float16_t)-0.909805708f, (float16_t)-0.415034424f,
   (float16_t)-0.909167983f, (float16_t)-0.416429560f,
   (float16_t)-0.908528119f, (float16_t)-0.417823716f,
   (float16_t)-0.907886116f, (float16_t)-0.419216888f,
   (float16_t)-0.907241978f, (float16_t)-0.420609074f,
   (float16_t)-0.906595705f, (float16_t)-0.422000271f,
   (float16_t)-0.905947298f, (float16_t)-0.423390474f,
   (float16_t)-0.905296759f, (float16_t)-0.424779681f,
   (float16_t)-0.904644091f, (float16_t)-0.426167889f,
   (float16_t)-0.903989293f, (float16_t)-0.427555093f,
   (float16_t)-0.903332368f, (float16_t)-0.428941292f,
   (float16_t)-0.902673318f, (float16_t)-0.430326481f,
   (float16_t)-0.902012144f, (float16_t)-0.431710658f,
   (float16_t)-0.901348847f, (float16_t)-0.433093819f,
   (float16_t)-0.900683429f, (float16_t)-0.434475961f,
   (float16_t)-0.900015892f, (float16_t)-0.435857080f,
   (float16_t)-0.899346237f, (float16_t)-0.437237174f,
   (float16_t)-0.898674466f, (float16_t)-0.438616239f,
   (float16_t)-0.898000580f, (float16_t)-0.439994271f,
   (float16_t)-0.897324581f, (float16_t)-0.441371269f,
   (float16_t)-0.896646470f, (float16_t)-0.442747228f,
   (float16_t)-0.895966250f, (float16_t)-0.444122145f,
   (float16_t)-0.895283921f, (float16_t)-0.445496017f,
   (float16_t)-0.894599486f, (float16_t)-0.446868840f,
   (float16_t)-0.893912945f, (float16_t)-0.448240612f,
   (float16_t)-0.893224301f, (float16_t)-0.449611330f,
   (float16_t)-0.892533555f, (float16_t)-0.450980989f,
   (float16_t)-0.891840709f, (float16_t)-0.452349587f,
   (float16_t)-0.891145765f, (float16_t)-0.453717121f,
   (float16_t)-0.890448723f, (float16_t)-0.455083587f,
   (float16_t)-0.889749586f, (float16_t)-0.456448982f,
   (float16_t)-0.889048356f, (float16_t)-0.457813304f,
   (float16_t)-0.888345033f, (float16_t)-0.459176548f,
   (float16_t)-0.887639620f, (float16_t)-0.460538711f,
   (float16_t)-0.886932119f, (float16_t)-0.461899791f,
   (float16_t)-0.886222530f, (float16_t)-0.463259784f,
   (float16_t)-0.885510856f, (float16_t)-0.464618686f,
   (float16_t)-0.884797098f, (float16_t)-0.465976496f,
   (float16_t)-0.884081259f, (float16_t)-0.467333209f,
   (float16_t)-0.883363339f, (float16_t)-0.468688822f,
   (float16_t)-0.882643340f, (float16_t)-0.470043332f,
   (float16_t)-0.881921264f, (float16_t)-0.471396737f,
   (float16_t)-0.881197113f, (float16_t)-0.472749032f,
   (float16_t)-0.880470889f, (float16_t)-0.474100215f,
   (float16_t)-0.879742593f, (float16_t)-0.475450282f,
   (float16_t)-0.879012226f, (float16_t)-0.476799230f,
   (float16_t)-0.878279792f, (float16_t)-0.478147056f,
   (float16_t)-0.877545290f, (float16_t)-0.479493758f,
   (float16_t)-0.876808724f, (float16_t)-0.480839331f,
   (float16_t)-0.876070094f, (float16_t)-0.482183772f,
   (float16_t)-0.875329403f, (float16_t)-0.483527079f,
   (float16_t)-0.874586652f, (float16_t)-0.484869248f,
   (float16_t)-0.873841843f, (float16_t)-0.486210276f,
   (float16_t)-0.873094978f, (float16_t)-0.487550160f,
   (float16_t)-0.872346059f, (float16_t)-0.488888897f,
   (float16_t)-0.871595087f, (float16_t)-0.490226483f,
   (float16_t)-0.870842063f, (float16_t)-0.491562916f,
   (float16_t)-0.870086991f, (float16_t)-0.492898192f,
   (float16_t)-0.869329871f, (float16_t)-0.494232309f,
   (float16_t)-0.868570706f, (float16_t)-0.495565262f,
   (float16_t)-0.867809497f, (float16_t)-0.496897049f,
   (float16_t)-0.867046246f, (float16_t)-0.498227667f,
   (float16_t)-0.866280954f, (float16_t)-0.499557113f,
   (float16_t)-0.865513624f, (float16_t)-0.500885383f,
   (float16_t)-0.864744258f, (float16_t)-0.502212474f,
   (float16_t)-0.863972856f, (float16_t)-0.503538384f,
   (float16_t)-0.863199422f, (float16_t)-0.504863109f,
   (float16_t)-0.862423956f, (float16_t)-0.506186645f,
   (float16_t)-0.861646461f, (float16_t)-0.507508991f,
   (float16_t)-0.860866939f, (float16_t)-0.508830143f,
   (float16_t)-0.860085390f, (float16_t)-0.510150097f,
   (float16_t)-0.859301818f, (float16_t)-0.511468850f,
   (float16_t)-0.858516224f, (float16_t)-0.512786401f,
   (float16_t)-0.857728610f, (float16_t)-0.514102744f,
   (float16_t)-0.856938977f, (float16_t)-0.515417878f,
   (float16_t)-0.856147328f, (float16_t)-0.516731799f,
   (float16_t)-0.855353665f, (float16_t)-0.518044504f,
   (float16_t)-0.854557988f, (float16_t)-0.519355990f,
   (float16_t)-0.853760301f, (float16_t)-0.520666254f,
   (float16_t)-0.852960605f, (float16_t)-0.521975293f,
   (float16_t)-0.852158902f, (float16_t)-0.523283103f,
   (float16_t)-0.851355193f, (float16_t)-0.524589683f,
   (float16_t)-0.850549481f, (float16_t)-0.525895027f,
   (float16_t)-0.849741768f, (float16_t)-0.527199135f,
   (float16_t)-0.848932055f, (float16_t)-0.528502002f,
   (float16_t)-0.848120345f, (float16_t)-0.529803625f,
   (float16_t)-0.847306639f, (float16_t)-0.531104001f,
   (float16_t)-0.846490939f, (float16_t)-0.532403128f,
   (float16_t)-0.845673247f, (float16_t)-0.533701002f,
   (float16_t)-0.844853565f, (float16_t)-0.534997620f,
   (float16_t)-0.844031895f, (float16_t)-0.536292979f,
   (float16_t)-0.843208240f, (float16_t)-0.537587076f,
   (float16_t)-0.842382600f, (float16_t)-0.538879909f,
   (float16_t)-0.841554977f, (float16_t)-0.540171473f,
   (float16_t)-0.840725375f, (float16_t)-0.541461766f,
   (float16_t)-0.839893794f, (float16_t)-0.542750785f,
   (float16_t)-0.839060237f, (float16_t)-0.544038527f,
   (float16_t)-0.838224706f, (float16_t)-0.545324988f,
   (float16_t)-0.837387202f, (float16_t)-0.546610167f,
   (float16_t)-0.836547727f, (float16_t)-0.547894059f,
   (float16_t)-0.835706284f, (float16_t)-0.549176662f,
   (float16_t)-0.834862875f, (float16_t)-0.550457973f,
   (float16_t)-0.834017501f, (float16_t)-0.551737988f,
   (float16_t)-0.833170165f, (float16_t)-0.553016706f,
   (float16_t)-0.832320868f, (float16_t)-0.554294121f,
   (float16_t)-0.831469612f, (float16_t)-0.555570233f,
   (float16_t)-0.830616400f, (float16_t)-0.556845037f,
   (float16_t)-0.829761234f, (float16_t)-0.558118531f,
   (float16_t)-0.828904115f, (float16_t)-0.559390712f,
   (float16_t)-0.828045045f, (float16_t)-0.560661576f,
   (float16_t)-0.827184027f, (float16_t)-0.561931121f,
   (float16_t)-0.826321063f, (float16_t)-0.563199344f,
   (float16_t)-0.825456154f, (float16_t)-0.564466242f,
   (float16_t)-0.824589303f, (float16_t)-0.565731811f,
   (float16_t)-0.823720511f, (float16_t)-0.566996049f,
   (float16_t)-0.822849781f, (float16_t)-0.568258953f,
   (float16_t)-0.821977115f, (float16_t)-0.569520519f,
   (float16_t)-0.821102515f, (float16_t)-0.570780746f,
   (float16_t)-0.820225983f, (float16_t)-0.572039629f,
   (float16_t)-0.819347520f, (float16_t)-0.573297167f,
   (float16_t)-0.818467130f, (float16_t)-0.574553355f,
   (float16_t)-0.817584813f, (float16_t)-0.575808191f,
   (float16_t)-0.816700573f, (float16_t)-0.577061673f,
   (float16_t)-0.815814411f, (float16_t)-0.578313796f,
   (float16_t)-0.814926329f, (float16_t)-0.579564559f,
   (float16_t)-0.814036330f, (float16_t)-0.580813958f,
   (float16_t)-0.813144415f, (float16_t)-0.582061990f,
   (float16_t)-0.812250587f, (float16_t)-0.583308653f,
   (float16_t)-0.811354847f, (float16_t)-0.584553943f,
   (float16_t)-0.810457198f, (float16_t)-0.585797857f,
   (float16_t)-0.809557642f, (float16_t)-0.587040394f,
   (float16_t)-0.808656182f, (float16_t)-0.588281548f,
   (float16_t)-0.807752818f, (float16_t)-0.589521319f,
   (float16_t)-0.806847554f, (float16_t)-0.590759702f,
   (float16_t)-0.805940391f, (float16_t)-0.591996695f,
   (float16_t)-0.805031331f, (float16_t)-0.593232295f,
   (float16_t)-0.804120377f, (float16_t)-0.594466499f,
   (float16_t)-0.803207531f, (float16_t)-0.595699304f,
   (float16_t)-0.802292796f, (float16_t)-0.596930708f,
   (float16_t)-0.801376172f, (float16_t)-0.598160707f,
   (float16_t)-0.800457662f, (float16_t)-0.599389298f,
   (float16_t)-0.799537269f, (float16_t)-0.600616479f,
   (float16_t)-0.798614995f, (float16_t)-0.601842247f,
   (float16_t)-0.797690841f, (float16_t)-0.603066599f,
   (float16_t)-0.796764810f, (float16_t)-0.604289531f,
   (float16_t)-0.795836905f, (float16_t)-0.605511041f,
   (float16_t)-0.794907126f, (float16_t)-0.606731127f,
   (float16_t)-0.793975478f, (float16_t)-0.607949785f,
   (float16_t)-0.793041960f, (float16_t)-0.609167012f,
   (float16_t)-0.792106577f, (float16_t)-0.610382806f,
   (float16_t)-0.791169330f, (float16_t)-0.611597164f,
   (float16_t)-0.790230221f, (float16_t)-0.612810082f,
   (float16_t)-0.789289253f, (float16_t)-0.614021559f,
   (float16_t)-0.788346428f, (float16_t)-0.615231591f,
   (float16_t)-0.787401747f, (float16_t)-0.616440175f,
   (float16_t)-0.786455214f, (float16_t)-0.617647308f,
   (float16_t)-0.785506830f, (float16_t)-0.618852988f,
   (float16_t)-0.784556597f, (float16_t)-0.620057212f,
   (float16_t)-0.783604519f, (float16_t)-0.621259977f,
   (float16_t)-0.782650596f, (float16_t)-0.622461279f,
   (float16_t)-0.781694832f, (float16_t)-0.623661118f,
   (float16_t)-0.780737229f, (float16_t)-0.624859488f,
   (float16_t)-0.779777788f, (float16_t)-0.626056388f,
   (float16_t)-0.778816512f, (float16_t)-0.627251815f,
   (float16_t)-0.777853404f, (float16_t)-0.628445767f,
   (float16_t)-0.776888466f, (float16_t)-0.629638239f,
   (float16_t)-0.775921699f, (float16_t)-0.630829230f,
   (float16_t)-0.774953107f, (float16_t)-0.632018736f,
   (float16_t)-0.773982691f, (float16_t)-0.633206755f,
   (float16_t)-0.773010453f, (float16_t)-0.634393284f,
   (float16_t)-0.772036397f, (float16_t)-0.635578320f,
   (float16_t)-0.771060524f, (float16_t)-0.636761861f,
   (float16_t)-0.770082837f, (float16_t)-0.637943904f,
   (float16_t)-0.769103338f, (float16_t)-0.639124445f,
   (float16_t)-0.768122029f, (float16_t)-0.640303482f,
   (float16_t)-0.767138912f, (float16_t)-0.641481013f,
   (float16_t)-0.766153990f, (float16_t)-0.642657034f,
   (float16_t)-0.765167266f, (float16_t)-0.643831543f,
   (float16_t)-0.764178741f, (float16_t)-0.645004537f,
   (float16_t)-0.763188417f, (float16_t)-0.646176013f,
   (float16_t)-0.762196298f, (float16_t)-0.647345969f,
   (float16_t)-0.761202385f, (float16_t)-0.648514401f,
   (float16_t)-0.760206682f, (float16_t)-0.649681307f,
   (float16_t)-0.759209189f, (float16_t)-0.650846685f,
   (float16_t)-0.758209910f, (float16_t)-0.652010531f,
   (float16_t)-0.757208847f, (float16_t)-0.653172843f,
   (float16_t)-0.756206001f, (float16_t)-0.654333618f,
   (float16_t)-0.755201377f, (float16_t)-0.655492853f,
   (float16_t)-0.754194975f, (float16_t)-0.656650546f,
   (float16_t)-0.753186799f, (float16_t)-0.657806693f,
   (float16_t)-0.752176850f, (float16_t)-0.658961293f,
   (float16_t)-0.751165132f, (float16_t)-0.660114342f,
   (float16_t)-0.750151646f, (float16_t)-0.661265838f,
   (float16_t)-0.749136395f, (float16_t)-0.662415778f,
   (float16_t)-0.748119380f, (float16_t)-0.663564159f,
   (float16_t)-0.747100606f, (float16_t)-0.664710978f,
   (float16_t)-0.746080074f, (float16_t)-0.665856234f,
   (float16_t)-0.745057785f, (float16_t)-0.666999922f,
   (float16_t)-0.744033744f, (float16_t)-0.668142041f,
   (float16_t)-0.743007952f, (float16_t)-0.669282588f,
   (float16_t)-0.741980412f, (float16_t)-0.670421560f,
   (float16_t)-0.740951125f, (float16_t)-0.671558955f,
   (float16_t)-0.739920095f, (float16_t)-0.672694769f,
   (float16_t)-0.738887324f, (float16_t)-0.673829000f,
   (float16_t)-0.737852815f, (float16_t)-0.674961646f,
   (float16_t)-0.736816569f, (float16_t)-0.676092704f,
   (float16_t)-0.735778589f, (float16_t)-0.677222170f,
   (float16_t)-0.734738878f, (float16_t)-0.678350043f,
   (float16_t)-0.733697438f, (float16_t)-0.679476320f,
   (float16_t)-0.732654272f, (float16_t)-0.680600998f,
   (float16_t)-0.731609381f, (float16_t)-0.681724074f,
   (float16_t)-0.730562769f, (float16_t)-0.682845546f,
   (float16_t)-0.729514438f, (float16_t)-0.683965412f,
   (float16_t)-0.728464390f, (float16_t)-0.685083668f,
   (float16_t)-0.727412629f, (float16_t)-0.686200312f,
   (float16_t)-0.726359155f, (float16_t)-0.687315341f,
   (float16_t)-0.725303972f, (float16_t)-0.688428753f,
   (float16_t)-0.724247083f, (float16_t)-0.689540545f,
   (float16_t)-0.723188489f, (float16_t)-0.690650714f,
   (float16_t)-0.722128194f, (float16_t)-0.691759258f,
   (float16_t)-0.721066199f, (float16_t)-0.692866175f,
   (float16_t)-0.720002508f, (float16_t)-0.693971461f,
   (float16_t)-0.718937122f, (float16_t)-0.695075114f,
   (float16_t)-0.717870045f, (float16_t)-0.696177131f,
   (float16_t)-0.716801279f, (float16_t)-0.697277511f,
   (float16_t)-0.715730825f, (float16_t)-0.698376249f,
   (float16_t)-0.714658688f, (float16_t)-0.699473345f,
   (float16_t)-0.713584869f, (float16_t)-0.700568794f,
   (float16_t)-0.712509371f, (float16_t)-0.701662595f,
   (float16_t)-0.711432196f, (float16_t)-0.702754744f,
   (float16_t)-0.710353347f, (float16_t)-0.703845241f,
   (float16_t)-0.709272826f, (float16_t)-0.704934080f,
   (float16_t)-0.708190637f, (float16_t)-0.706021261f,
   (float16_t)-0.707106781f, (float16_t)-0.707106781f,
   (float16_t)-0.706021261f, (float16_t)-0.708190637f,
   (float16_t)-0.704934080f, (float16_t)-0.709272826f,
   (float16_t)-0.703845241f, (float16_t)-0.710353347f,
   (float16_t)-0.702754744f, (float16_t)-0.711432196f,
   (float16_t)-0.701662595f, (float16_t)-0.712509371f,
   (float16_t)-0.700568794f, (float16_t)-0.713584869f,
   (float16_t)-0.699473345f, (float16_t)-0.714658688f,
   (float16_t)-0.698376249f, (float16_t)-0.715730825f,
   (float16_t)-0.697277511f, (float16_t)-0.716801279f,
   (float16_t)-0.696177131f, (float16_t)-0.717870045f,
   (float16_t)-0.695075114f, (float16_t)-0.718937122f,
   (float16_t)-0.693971461f, (float16_t)-0.720002508f,
   (float16_t)-0.692866175f, (float16_t)-0.721066199f,
   (float16_t)-0.691759258f, (float16_t)-0.722128194f,
   (float16_t)-0.690650714f, (float16_t)-0.723188489f,
   (float16_t)-0.689540545f, (float16_t)-0.724247083f,
   (float16_t)-0.688428753f, (float16_t)-0.725303972f,
   (float16_t)-0.687315341f, (float16_t)-0.726359155f,
   (float16_t)-0.686200312f, (float16_t)-0.727412629f,
   (float16_t)-0.685083668f, (float16_t)-0.728464390f,
   (float16_t)-0.683965412f, (float16_t)-0.729514438f,
   (float16_t)-0.682845546f, (float16_t)-0.730562769f,
   (float16_t)-0.681724074f, (float16_t)-0.731609381f,
   (float16_t)-0.680600998f, (float16_t)-0.732654272f,
   (float16_t)-0.679476320f, (float16_t)-0.733697438f,
   (float16_t)-0.678350043f, (float16_t)-0.734738878f,
   (float16_t)-0.677222170f, (float16_t)-0.735778589f,
   (float16_t)-0.676092704f, (float16_t)-0.736816569f,
   (float16_t)-0.674961646f, (float16_t)-0.737852815f,
   (float16_t)-0.673829000f, (float16_t)-0.738887324f,
   (float16_t)-0.672694769f, (float16_t)-0.739920095f,
   (float16_t)-0.671558955f, (float16_t)-0.740951125f,
   (float16_t)-0.670421560f, (float16_t)-0.741980412f,
   (float16_t)-0.669282588f, (float16_t)-0.743007952f,
   (float16_t)-0.668142041f, (float16_t)-0.744033744f,
   (float16_t)-0.666999922f, (float16_t)-0.745057785f,
   (float16_t)-0.665856234f, (float16_t)-0.746080074f,
   (float16_t)-0.664710978f, (float16_t)-0.747100606f,
   (float16_t)-0.663564159f, (float16_t)-0.748119380f,
   (float16_t)-0.662415778f, (float16_t)-0.749136395f,
   (float16_t)-0.661265838f, (float16_t)-0.750151646f,
   (float16_t)-0.660114342f, (float16_t)-0.751165132f,
   (float16_t)-0.658961293f, (float16_t)-0.752176850f,
   (float16_t)-0.657806693f, (float16_t)-0.753186799f,
   (float16_t)-0.656650546f, (float16_t)-0.754194975f,
   (float16_t)-0.655492853f, (float16_t)-0.755201377f,
   (float16_t)-0.654333618f, (float16_t)-0.756206001f,
   (float16_t)-0.653172843f, (float16_t)-0.757208847f,
   (float16_t)-0.652010531f, (float16_t)-0.758209910f,
   (float16_t)-0.650846685f, (float16_t)-0.759209189f,
   (float16_t)-0.649681307f, (float16_t)-0.760206682f,
   (float16_t)-0.648514401f, (float16_t)-0.761202385f,
   (float16_t)-0.647345969f, (float16_t)-0.762196298f,
   (float16_t)-0.646176013f, (float16_t)-0.763188417f,
   (float16_t)-0.645004537f, (float16_t)-0.764178741f,
   (float16_t)-0.643831543f, (float16_t)-0.765167266f,
   (float16_t)-0.642657034f, (float16_t)-0.766153990f,
   (float16_t)-0.641481013f, (float16_t)-0.767138912f,
   (float16_t)-0.640303482f, (float16_t)-0.768122029f,
   (float16_t)-0.639124445f, (float16_t)-0.769103338f,
   (float16_t)-0.637943904f, (float16_t)-0.770082837f,
   (float16_t)-0.636761861f, (float16_t)-0.771060524f,
   (float16_t)-0.635578320f, (float16_t)-0.772036397f,
   (float16_t)-0.634393284f, (float16_t)-0.773010453f,
   (float16_t)-0.633206755f, (float16_t)-0.773982691f,
   (float16_t)-0.632018736f, (float16_t)-0.774953107f,
   (float16_t)-0.630829230f, (float16_t)-0.775921699f,
   (float16_t)-0.629638239f, (float16_t)-0.776888466f,
   (float16_t)-0.628445767f, (float16_t)-0.777853404f,
   (float16_t)-0.627251815f, (float16_t)-0.778816512f,
   (float16_t)-0.626056388f, (float16_t)-0.779777788f,
   (float16_t)-0.624859488f, (float16_t)-0.780737229f,
   (float16_t)-0.623661118f, (float16_t)-0.781694832f,
   (float16_t)-0.622461279f, (float16_t)-0.782650596f,
   (float16_t)-0.621259977f, (float16_t)-0.783604519f,
   (float16_t)-0.620057212f, (float16_t)-0.784556597f,
   (float16_t)-0.618852988f, (float16_t)-0.785506830f,
   (float16_t)-0.617647308f, (float16_t)-0.786455214f,
   (float16_t)-0.616440175f, (float16_t)-0.787401747f,
   (float16_t)-0.615231591f, (float16_t)-0.788346428f,
   (float16_t)-0.614021559f, (float16_t)-0.789289253f,
   (float16_t)-0.612810082f, (float16_t)-0.790230221f,
   (float16_t)-0.611597164f, (float16_t)-0.791169330f,
   (float16_t)-0.610382806f, (float16_t)-0.792106577f,
   (float16_t)-0.609167012f, (float16_t)-0.793041960f,
   (float16_t)-0.607949785f, (float16_t)-0.793975478f,
   (float16_t)-0.606731127f, (float16_t)-0.794907126f,
   (float16_t)-0.605511041f, (float16_t)-0.795836905f,
   (float16_t)-0.604289531f, (float16_t)-0.796764810f,
   (float16_t)-0.603066599f, (float16_t)-0.797690841f,
   (float16_t)-0.601842247f, (float16_t)-0.798614995f,
   (float16_t)-0.600616479f, (float16_t)-0.799537269f,
   (float16_t)-0.599389298f, (float16_t)-0.800457662f,
   (float16_t)-0.598160707f, (float16_t)-0.801376172f,
   (float16_t)-0.596930708f, (float16_t)-0.802292796f,
   (float16_t)-0.595699304f, (float16_t)-0.803207531f,
   (float16_t)-0.594466499f, (float16_t)-0.804120377f,
   (float16_t)-0.593232295f, (float16_t)-0.805031331f,
   (float16_t)-0.591996695f, (float16_t)-0.805940391f,
   (float16_t)-0.590759702f, (float16_t)-0.806847554f,
   (float16_t)-0.589521319f, (float16_t)-0.807752818f,
   (float16_t)-0.588281548f, (float16_t)-0.808656182f,
   (float16_t)-0.587040394f, (float16_t)-0.809557642f,
   (float16_t)-0.585797857f, (float16_t)-0.810457198f,
   (float16_t)-0.584553943f, (float16_t)-0.811354847f,
   (float16_t)-0.583308653f, (float16_t)-0.812250587f,
   (float16_t)-0.582061990f, (float16_t)-0.813144415f,
   (float16_t)-0.580813958f, (float16_t)-0.814036330f,
   (float16_t)-0.579564559f, (float16_t)-0.814926329f,
   (float16_t)-0.578313796f, (float16_t)-0.815814411f,
   (float16_t)-0.577061673f, (float16_t)-0.816700573f,
   (float16_t)-0.575808191f, (float16_t)-0.817584813f,
   (float16_t)-0.574553355f, (float16_t)-0.818467130f,
   (float16_t)-0.573297167f, (float16_t)-0.819347520f,
   (float16_t)-0.572039629f, (float16_t)-0.820225983f,
   (float16_t)-0.570780746f, (float16_t)-0.821102515f,
   (float16_t)-0.569520519f, (float16_t)-0.821977115f,
   (float16_t)-0.568258953f, (float16_t)-0.822849781f,
   (float16_t)-0.566996049f, (float16_t)-0.823720511f,
   (float16_t)-0.565731811f, (float16_t)-0.824589303f,
   (float16_t)-0.564466242f, (float16_t)-0.825456154f,
   (float16_t)-0.563199344f, (float16_t)-0.826321063f,
   (float16_t)-0.561931121f, (float16_t)-0.827184027f,
   (float16_t)-0.560661576f, (float16_t)-0.828045045f,
   (float16_t)-0.559390712f, (float16_t)-0.828904115f,
   (float16_t)-0.558118531f, (float16_t)-0.829761234f,
   (float16_t)-0.556845037f, (float16_t)-0.830616400f,
   (float16_t)-0.555570233f, (float16_t)-0.831469612f,
   (float16_t)-0.554294121f, (float16_t)-0.832320868f,
   (float16_t)-0.553016706f, (float16_t)-0.833170165f,
   (float16_t)-0.551737988f, (float16_t)-0.834017501f,
   (float16_t)-0.550457973f, (float16_t)-0.834862875f,
   (float16_t)-0.549176662f, (float16_t)-0.835706284f,
   (float16_t)-0.547894059f, (float16_t)-0.836547727f,
   (float16_t)-0.546610167f, (float16_t)-0.837387202f,
   (float16_t)-0.545324988f, (float16_t)-0.838224706f,
   (float16_t)-0.544038527f, (float16_t)-0.839060237f,
   (float16_t)-0.542750785f, (float16_t)-0.839893794f,
   (float16_t)-0.541461766f, (float16_t)-0.840725375f,
   (float16_t)-0.540171473f, (float16_t)-0.841554977f,
   (float16_t)-0.538879909f, (float16_t)-0.842382600f,
   (float16_t)-0.537587076f, (float16_t)-0.843208240f,
   (float16_t)-0.536292979f, (float16_t)-0.844031895f,
   (float16_t)-0.534997620f, (float16_t)-0.844853565f,
   (float16_t)-0.533701002f, (float16_t)-0.845673247f,
   (float16_t)-0.532403128f, (float16_t)-0.846490939f,
   (float16_t)-0.531104001f, (float16_t)-0.847306639f,
   (float16_t)-0.529803625f, (float16_t)-0.848120345f,
   (float16_t)-0.528502002f, (float16_t)-0.848932055f,
   (float16_t)-0.527199135f, (float16_t)-0.849741768f,
   (float16_t)-0.525895027f, (float16_t)-0.850549481f,
   (float16_t)-0.524589683f, (float16_t)-0.851355193f,
   (float16_t)-0.523283103f, (float16_t)-0.852158902f,
   (float16_t)-0.521975293f, (float16_t)-0.852960605f,
   (float16_t)-0.520666254f, (float16_t)-0.853760301f,
   (float16_t)-0.519355990f, (float16_t)-0.854557988f,
   (float16_t)-0.518044504f, (float16_t)-0.855353665f,
   (float16_t)-0.516731799f, (float16_t)-0.856147328f,
   (float16_t)-0.515417878f, (float16_t)-0.856938977f,
   (float16_t)-0.514102744f, (float16_t)-0.857728610f,
   (float16_t)-0.512786401f, (float16_t)-0.858516224f,
   (float16_t)-0.511468850f, (float16_t)-0.859301818f,
   (float16_t)-0.510150097f, (float16_t)-0.860085390f,
   (float16_t)-0.508830143f, (float16_t)-0.860866939f,
   (float16_t)-0.507508991f, (float16_t)-0.861646461f,
   (float16_t)-0.506186645f, (float16_t)-0.862423956f,
   (float16_t)-0.504863109f, (float16_t)-0.863199422f,
   (float16_t)-0.503538384f, (float16_t)-0.863972856f,
   (float16_t)-0.502212474f, (float16_t)-0.864744258f,
   (float16_t)-0.500885383f, (float16_t)-0.865513624f,
   (float16_t)-0.499557113f, (float16_t)-0.866280954f,
   (float16_t)-0.498227667f, (float16_t)-0.867046246f,
   (float16_t)-0.496897049f, (float16_t)-0.867809497f,
   (float16_t)-0.495565262f, (float16_t)-0.868570706f,
   (float16_t)-0.494232309f, (float16_t)-0.869329871f,
   (float16_t)-0.492898192f, (float16_t)-0.870086991f,
   (float16_t)-0.491562916f, (float16_t)-0.870842063f,
   (float16_t)-0.490226483f, (float16_t)-0.871595087f,
   (float16_t)-0.488888897f, (float16_t)-0.872346059f,
   (float16_t)-0.487550160f, (float16_t)-0.873094978f,
   (float16_t)-0.486210276f, (float16_t)-0.873841843f,
   (float16_t)-0.484869248f, (float16_t)-0.874586652f,
   (float16_t)-0.483527079f, (float16_t)-0.875329403f,
   (float16_t)-0.482183772f, (float16_t)-0.876070094f,
   (float16_t)-0.480839331f, (float16_t)-0.876808724f,
   (float16_t)-0.479493758f, (float16_t)-0.877545290f,
   (float16_t)-0.478147056f, (float16_t)-0.878279792f,
   (float16_t)-0.476799230f, (float16_t)-0.879012226f,
   (float16_t)-0.475450282f, (float16_t)-0.879742593f,
   (float16_t)-0.474100215f, (float16_t)-0.880470889f,
   (float16_t)-0.472749032f, (float16_t)-0.881197113f,
   (float16_t)-0.471396737f, (float16_t)-0.881921264f,
   (float16_t)-0.470043332f, (float16_t)-0.882643340f,
   (float16_t)-0.468688822f, (float16_t)-0.883363339f,
   (float16_t)-0.467333209f, (float16_t)-0.884081259f,
   (float16_t)-0.465976496f, (float16_t)-0.884797098f,
   (float16_t)-0.464618686f, (float16_t)-0.885510856f,
   (float16_t)-0.463259784f, (float16_t)-0.886222530f,
   (float16_t)-0.461899791f, (float16_t)-0.886932119f,
   (float16_t)-0.460538711f, (float16_t)-0.887639620f,
   (float16_t)-0.459176548f, (float16_t)-0.888345033f,
   (float16_t)-0.457813304f, (float16_t)-0.889048356f,
   (float16_t)-0.456448982f, (float16_t)-0.889749586f,
   (float16_t)-0.455083587f, (float16_t)-0.890448723f,
   (float16_t)-0.453717121f, (float16_t)-0.891145765f,
   (float16_t)-0.452349587f, (float16_t)-0.891840709f,
   (float16_t)-0.450980989f, (float16_t)-0.892533555f,
   (float16_t)-0.449611330f, (float16_t)-0.893224301f,
   (float16_t)-0.448240612f, (float16_t)-0.893912945f,
   (float16_t)-0.446868840f, (float16_t)-0.894599486f,
   (float16_t)-0.445496017f, (float16_t)-0.895283921f,
   (float16_t)-0.444122145f, (float16_t)-0.895966250f,
   (float16_t)-0.442747228f, (float16_t)-0.896646470f,
   (float16_t)-0.441371269f, (float16_t)-0.897324581f,
   (float16_t)-0.439994271f, (float16_t)-0.898000580f,
   (float16_t)-0.438616239f, (float16_t)-0.898674466f,
   (float16_t)-0.437237174f, (float16_t)-0.899346237f,
   (float16_t)-0.435857080f, (float16_t)-0.900015892f,
   (float16_t)-0.434475961f, (float16_t)-0.900683429f,
   (float16_t)-0.433093819f, (float16_t)-0.901348847f,
   (float16_t)-0.431710658f, (float16_t)-0.902012144f,
   (float16_t)-0.430326481f, (float16_t)-0.902673318f,
   (float16_t)-0.428941292f, (float16_t)-0.903332368f,
   (float16_t)-0.427555093f, (float16_t)-0.903989293f,
   (float16_t)-0.426167889f, (float16_t)-0.904644091f,
   (float16_t)-0.424779681f, (float16_t)-0.905296759f,
   (float16_t)-0.423390474f, (float16_t)-0.905947298f,
   (float16_t)-0.422000271f, (float16_t)-0.906595705f,
   (float16_t)-0.420609074f, (float16_t)-0.907241978f,
   (float16_t)-0.419216888f, (float16_t)-0.907886116f,
   (float16_t)-0.417823716f, (float16_t)-0.908528119f,
   (float16_t)-0.416429560f, (float16_t)-0.909167983f,
   (float16_t)-0.415034424f, (float16_t)-0.909805708f,
   (float16_t)-0.413638312f, (float16_t)-0.910441292f,
   (float16_t)-0.412241227f, (float16_t)-0.911074734f,
   (float16_t)-0.410843171f, (float16_t)-0.911706032f,
   (float16_t)-0.409444149f, (float16_t)-0.912335185f,
   (float16_t)-0.408044163f, (float16_t)-0.912962190f,
   (float16_t)-0.406643217f, (float16_t)-0.913587048f,
   (float16_t)-0.405241314f, (float16_t)-0.914209756f,
   (float16_t)-0.403838458f, (float16_t)-0.914830312f,
   (float16_t)-0.402434651f, (float16_t)-0.915448716f,
   (float16_t)-0.401029897f, (float16_t)-0.916064966f,
   (float16_t)-0.399624200f, (float16_t)-0.916679060f,
   (float16_t)-0.398217562f, (float16_t)-0.917290997f,
   (float16_t)-0.396809987f, (float16_t)-0.917900776f,
   (float16_t)-0.395401479f, (float16_t)-0.918508394f,
   (float16_t)-0.393992040f, (float16_t)-0.919113852f,
   (float16_t)-0.392581674f, (float16_t)-0.919717146f,
   (float16_t)-0.391170384f, (float16_t)-0.920318277f,
   (float16_t)-0.389758174f, (float16_t)-0.920917242f,
   (float16_t)-0.388345047f, (float16_t)-0.921514039f,
   (float16_t)-0.386931006f, (float16_t)-0.922108669f,
   (float16_t)-0.385516054f, (float16_t)-0.922701128f,
   (float16_t)-0.384100195f, (float16_t)-0.923291417f,
   (float16_t)-0.382683432f, (float16_t)-0.923879533f,
   (float16_t)-0.381265769f, (float16_t)-0.924465474f,
   (float16_t)-0.379847209f, (float16_t)-0.925049241f,
   (float16_t)-0.378427755f, (float16_t)-0.925630831f,
   (float16_t)-0.377007410f, (float16_t)-0.926210242f,
   (float16_t)-0.375586178f, (float16_t)-0.926787474f,
   (float16_t)-0.374164063f, (float16_t)-0.927362526f,
   (float16_t)-0.372741067f, (float16_t)-0.927935395f,
   (float16_t)-0.371317194f, (float16_t)-0.928506080f,
   (float16_t)-0.369892447f, (float16_t)-0.929074581f,
   (float16_t)-0.368466830f, (float16_t)-0.929640896f,
   (float16_t)-0.367040346f, (float16_t)-0.930205023f,
   (float16_t)-0.365612998f, (float16_t)-0.930766961f,
   (float16_t)-0.364184790f, (float16_t)-0.931326709f,
   (float16_t)-0.362755724f, (float16_t)-0.931884266f,
   (float16_t)-0.361325806f, (float16_t)-0.932439629f,
   (float16_t)-0.359895037f, (float16_t)-0.932992799f,
   (float16_t)-0.358463421f, (float16_t)-0.933543773f,
   (float16_t)-0.357030961f, (float16_t)-0.934092550f,
   (float16_t)-0.355597662f, (float16_t)-0.934639130f,
   (float16_t)-0.354163525f, (float16_t)-0.935183510f,
   (float16_t)-0.352728556f, (float16_t)-0.935725689f,
   (float16_t)-0.351292756f, (float16_t)-0.936265667f,
   (float16_t)-0.349856130f, (float16_t)-0.936803442f,
   (float16_t)-0.348418680f, (float16_t)-0.937339012f,
   (float16_t)-0.346980411f, (float16_t)-0.937872376f,
   (float16_t)-0.345541325f, (float16_t)-0.938403534f,
   (float16_t)-0.344101426f, (float16_t)-0.938932484f,
   (float16_t)-0.342660717f, (float16_t)-0.939459224f,
   (float16_t)-0.341219202f, (float16_t)-0.939983753f,
   (float16_t)-0.339776884f, (float16_t)-0.940506071f,
   (float16_t)-0.338333767f, (float16_t)-0.941026175f,
   (float16_t)-0.336889853f, (float16_t)-0.941544065f,
   (float16_t)-0.335445147f, (float16_t)-0.942059740f,
   (float16_t)-0.333999651f, (float16_t)-0.942573198f,
   (float16_t)-0.332553370f, (float16_t)-0.943084437f,
   (float16_t)-0.331106306f, (float16_t)-0.943593458f,
   (float16_t)-0.329658463f, (float16_t)-0.944100258f,
   (float16_t)-0.328209844f, (float16_t)-0.944604837f,
   (float16_t)-0.326760452f, (float16_t)-0.945107193f,
   (float16_t)-0.325310292f, (float16_t)-0.945607325f,
   (float16_t)-0.323859367f, (float16_t)-0.946105232f,
   (float16_t)-0.322407679f, (float16_t)-0.946600913f,
   (float16_t)-0.320955232f, (float16_t)-0.947094366f,
   (float16_t)-0.319502031f, (float16_t)-0.947585591f,
   (float16_t)-0.318048077f, (float16_t)-0.948074586f,
   (float16_t)-0.316593376f, (float16_t)-0.948561350f,
   (float16_t)-0.315137929f, (float16_t)-0.949045882f,
   (float16_t)-0.313681740f, (float16_t)-0.949528181f,
   (float16_t)-0.312224814f, (float16_t)-0.950008245f,
   (float16_t)-0.310767153f, (float16_t)-0.950486074f,
   (float16_t)-0.309308760f, (float16_t)-0.950961666f,
   (float16_t)-0.307849640f, (float16_t)-0.951435021f,
   (float16_t)-0.306389795f, (float16_t)-0.951906137f,
   (float16_t)-0.304929230f, (float16_t)-0.952375013f,
   (float16_t)-0.303467947f, (float16_t)-0.952841648f,
   (float16_t)-0.302005949f, (float16_t)-0.953306040f,
   (float16_t)-0.300543241f, (float16_t)-0.953768190f,
   (float16_t)-0.299079826f, (float16_t)-0.954228095f,
   (float16_t)-0.297615707f, (float16_t)-0.954685755f,
   (float16_t)-0.296150888f, (float16_t)-0.955141168f,
   (float16_t)-0.294685372f, (float16_t)-0.955594334f,
   (float16_t)-0.293219163f, (float16_t)-0.956045251f,
   (float16_t)-0.291752263f, (float16_t)-0.956493919f,
   (float16_t)-0.290284677f, (float16_t)-0.956940336f,
   (float16_t)-0.288816408f, (float16_t)-0.957384501f,
   (float16_t)-0.287347460f, (float16_t)-0.957826413f,
   (float16_t)-0.285877835f, (float16_t)-0.958266071f,
   (float16_t)-0.284407537f, (float16_t)-0.958703475f,
   (float16_t)-0.282936570f, (float16_t)-0.959138622f,
   (float16_t)-0.281464938f, (float16_t)-0.959571513f,
   (float16_t)-0.279992643f, (float16_t)-0.960002146f,
   (float16_t)-0.278519689f, (float16_t)-0.960430519f,
   (float16_t)-0.277046080f, (float16_t)-0.960856633f,
   (float16_t)-0.275571819f, (float16_t)-0.961280486f,
   (float16_t)-0.274096910f, (float16_t)-0.961702077f,
   (float16_t)-0.272621355f, (float16_t)-0.962121404f,
   (float16_t)-0.271145160f, (float16_t)-0.962538468f,
   (float16_t)-0.269668326f, (float16_t)-0.962953267f,
   (float16_t)-0.268190857f, (float16_t)-0.963365800f,
   (float16_t)-0.266712757f, (float16_t)-0.963776066f,
   (float16_t)-0.265234030f, (float16_t)-0.964184064f,
   (float16_t)-0.263754679f, (float16_t)-0.964589793f,
   (float16_t)-0.262274707f, (float16_t)-0.964993253f,
   (float16_t)-0.260794118f, (float16_t)-0.965394442f,
   (float16_t)-0.259312915f, (float16_t)-0.965793359f,
   (float16_t)-0.257831102f, (float16_t)-0.966190003f,
   (float16_t)-0.256348682f, (float16_t)-0.966584374f,
   (float16_t)-0.254865660f, (float16_t)-0.966976471f,
   (float16_t)-0.253382037f, (float16_t)-0.967366292f,
   (float16_t)-0.251897818f, (float16_t)-0.967753837f,
   (float16_t)-0.250413007f, (float16_t)-0.968139105f,
   (float16_t)-0.248927606f, (float16_t)-0.968522094f,
   (float16_t)-0.247441619f, (float16_t)-0.968902805f,
   (float16_t)-0.245955050f, (float16_t)-0.969281235f,
   (float16_t)-0.244467903f, (float16_t)-0.969657385f,
   (float16_t)-0.242980180f, (float16_t)-0.970031253f,
   (float16_t)-0.241491885f, (float16_t)-0.970402839f,
   (float16_t)-0.240003022f, (float16_t)-0.970772141f,
   (float16_t)-0.238513595f, (float16_t)-0.971139158f,
   (float16_t)-0.237023606f, (float16_t)-0.971503891f,
   (float16_t)-0.235533059f, (float16_t)-0.971866337f,
   (float16_t)-0.234041959f, (float16_t)-0.972226497f,
   (float16_t)-0.232550307f, (float16_t)-0.972584369f,
   (float16_t)-0.231058108f, (float16_t)-0.972939952f,
   (float16_t)-0.229565366f, (float16_t)-0.973293246f,
   (float16_t)-0.228072083f, (float16_t)-0.973644250f,
   (float16_t)-0.226578264f, (float16_t)-0.973992962f,
   (float16_t)-0.225083911f, (float16_t)-0.974339383f,
   (float16_t)-0.223589029f, (float16_t)-0.974683511f,
   (float16_t)-0.222093621f, (float16_t)-0.975025345f,
   (float16_t)-0.220597690f, (float16_t)-0.975364885f,
   (float16_t)-0.219101240f, (float16_t)-0.975702130f,
   (float16_t)-0.217604275f, (float16_t)-0.976037079f,
   (float16_t)-0.216106797f, (float16_t)-0.976369731f,
   (float16_t)-0.214608811f, (float16_t)-0.976700086f,
   (float16_t)-0.213110320f, (float16_t)-0.977028143f,
   (float16_t)-0.211611327f, (float16_t)-0.977353900f,
   (float16_t)-0.210111837f, (float16_t)-0.977677358f,
   (float16_t)-0.208611852f, (float16_t)-0.977998515f,
   (float16_t)-0.207111376f, (float16_t)-0.978317371f,
   (float16_t)-0.205610413f, (float16_t)-0.978633924f,
   (float16_t)-0.204108966f, (float16_t)-0.978948175f,
   (float16_t)-0.202607039f, (float16_t)-0.979260123f,
   (float16_t)-0.201104635f, (float16_t)-0.979569766f,
   (float16_t)-0.199601758f, (float16_t)-0.979877104f,
   (float16_t)-0.198098411f, (float16_t)-0.980182136f,
   (float16_t)-0.196594598f, (float16_t)-0.980484862f,
   (float16_t)-0.195090322f, (float16_t)-0.980785280f,
   (float16_t)-0.193585587f, (float16_t)-0.981083391f,
   (float16_t)-0.192080397f, (float16_t)-0.981379193f,
   (float16_t)-0.190574755f, (float16_t)-0.981672686f,
   (float16_t)-0.189068664f, (float16_t)-0.981963869f,
   (float16_t)-0.187562129f, (float16_t)-0.982252741f,
   (float16_t)-0.186055152f, (float16_t)-0.982539302f,
   (float16_t)-0.184547737f, (float16_t)-0.982823551f,
   (float16_t)-0.183039888f, (float16_t)-0.983105487f,
   (float16_t)-0.181531608f, (float16_t)-0.983385110f,
   (float16_t)-0.180022901f, (float16_t)-0.983662419f,
   (float16_t)-0.178513771f, (float16_t)-0.983937413f,
   (float16_t)-0.177004220f, (float16_t)-0.984210092f,
   (float16_t)-0.175494253f, (float16_t)-0.984480455f,
   (float16_t)-0.173983873f, (float16_t)-0.984748502f,
   (float16_t)-0.172473084f, (float16_t)-0.985014231f,
   (float16_t)-0.170961889f, (float16_t)-0.985277642f,
   (float16_t)-0.169450291f, (float16_t)-0.985538735f,
   (float16_t)-0.167938295f, (float16_t)-0.985797509f,
   (float16_t)-0.166425904f, (float16_t)-0.986053963f,
   (float16_t)-0.164913120f, (float16_t)-0.986308097f,
   (float16_t)-0.163399949f, (float16_t)-0.986559910f,
   (float16_t)-0.161886394f, (float16_t)-0.986809402f,
   (float16_t)-0.160372457f, (float16_t)-0.987056571f,
   (float16_t)-0.158858143f, (float16_t)-0.987301418f,
   (float16_t)-0.157343456f, (float16_t)-0.987543942f,
   (float16_t)-0.155828398f, (float16_t)-0.987784142f,
   (float16_t)-0.154312973f, (float16_t)-0.988022017f,
   (float16_t)-0.152797185f, (float16_t)-0.988257568f,
   (float16_t)-0.151281038f, (float16_t)-0.988490793f,
   (float16_t)-0.149764535f, (float16_t)-0.988721692f,
   (float16_t)-0.148247679f, (float16_t)-0.988950265f,
   (float16_t)-0.146730474f, (float16_t)-0.989176510f,
   (float16_t)-0.145212925f, (float16_t)-0.989400428f,
   (float16_t)-0.143695033f, (float16_t)-0.989622017f,
   (float16_t)-0.142176804f, (float16_t)-0.989841278f,
   (float16_t)-0.140658239f, (float16_t)-0.990058210f,
   (float16_t)-0.139139344f, (float16_t)-0.990272812f,
   (float16_t)-0.137620122f, (float16_t)-0.990485084f,
   (float16_t)-0.136100575f, (float16_t)-0.990695025f,
   (float16_t)-0.134580709f, (float16_t)-0.990902635f,
   (float16_t)-0.133060525f, (float16_t)-0.991107914f,
   (float16_t)-0.131540029f, (float16_t)-0.991310860f,
   (float16_t)-0.130019223f, (float16_t)-0.991511473f,
   (float16_t)-0.128498111f, (float16_t)-0.991709754f,
   (float16_t)-0.126976696f, (float16_t)-0.991905700f,
   (float16_t)-0.125454983f, (float16_t)-0.992099313f,
   (float16_t)-0.123932975f, (float16_t)-0.992290591f,
   (float16_t)-0.122410675f, (float16_t)-0.992479535f,
   (float16_t)-0.120888087f, (float16_t)-0.992666142f,
   (float16_t)-0.119365215f, (float16_t)-0.992850414f,
   (float16_t)-0.117842062f, (float16_t)-0.993032350f,
   (float16_t)-0.116318631f, (float16_t)-0.993211949f,
   (float16_t)-0.114794927f, (float16_t)-0.993389211f,
   (float16_t)-0.113270952f, (float16_t)-0.993564136f,
   (float16_t)-0.111746711f, (float16_t)-0.993736722f,
   (float16_t)-0.110222207f, (float16_t)-0.993906970f,
   (float16_t)-0.108697444f, (float16_t)-0.994074879f,
   (float16_t)-0.107172425f, (float16_t)-0.994240449f,
   (float16_t)-0.105647154f, (float16_t)-0.994403680f,
   (float16_t)-0.104121634f, (float16_t)-0.994564571f,
   (float16_t)-0.102595869f, (float16_t)-0.994723121f,
   (float16_t)-0.101069863f, (float16_t)-0.994879331f,
   (float16_t)-0.099543619f, (float16_t)-0.995033199f,
   (float16_t)-0.098017140f, (float16_t)-0.995184727f,
   (float16_t)-0.096490431f, (float16_t)-0.995333912f,
   (float16_t)-0.094963495f, (float16_t)-0.995480755f,
   (float16_t)-0.093436336f, (float16_t)-0.995625256f,
   (float16_t)-0.091908956f, (float16_t)-0.995767414f,
   (float16_t)-0.090381361f, (float16_t)-0.995907229f,
   (float16_t)-0.088853553f, (float16_t)-0.996044701f,
   (float16_t)-0.087325535f, (float16_t)-0.996179829f,
   (float16_t)-0.085797312f, (float16_t)-0.996312612f,
   (float16_t)-0.084268888f, (float16_t)-0.996443051f,
   (float16_t)-0.082740265f, (float16_t)-0.996571146f,
   (float16_t)-0.081211447f, (float16_t)-0.996696895f,
   (float16_t)-0.079682438f, (float16_t)-0.996820299f,
   (float16_t)-0.078153242f, (float16_t)-0.996941358f,
   (float16_t)-0.076623861f, (float16_t)-0.997060070f,
   (float16_t)-0.075094301f, (float16_t)-0.997176437f,
   (float16_t)-0.073564564f, (float16_t)-0.997290457f,
   (float16_t)-0.072034653f, (float16_t)-0.997402130f,
   (float16_t)-0.070504573f, (float16_t)-0.997511456f,
   (float16_t)-0.068974328f, (float16_t)-0.997618435f,
   (float16_t)-0.067443920f, (float16_t)-0.997723067f,
   (float16_t)-0.065913353f, (float16_t)-0.997825350f,
   (float16_t)-0.064382631f, (float16_t)-0.997925286f,
   (float16_t)-0.062851758f, (float16_t)-0.998022874f,
   (float16_t)-0.061320736f, (float16_t)-0.998118113f,
   (float16_t)-0.059789571f, (float16_t)-0.998211003f,
   (float16_t)-0.058258265f, (float16_t)-0.998301545f,
   (float16_t)-0.056726821f, (float16_t)-0.998389737f,
   (float16_t)-0.055195244f, (float16_t)-0.998475581f,
   (float16_t)-0.053663538f, (float16_t)-0.998559074f,
   (float16_t)-0.052131705f, (float16_t)-0.998640218f,
   (float16_t)-0.050599749f, (float16_t)-0.998719012f,
   (float16_t)-0.049067674f, (float16_t)-0.998795456f,
   (float16_t)-0.047535484f, (float16_t)-0.998869550f,
   (float16_t)-0.046003182f, (float16_t)-0.998941293f,
   (float16_t)-0.044470772f, (float16_t)-0.999010686f,
   (float16_t)-0.042938257f, (float16_t)-0.999077728f,
   (float16_t)-0.041405641f, (float16_t)-0.999142419f,
   (float16_t)-0.039872928f, (float16_t)-0.999204759f,
   (float16_t)-0.038340120f, (float16_t)-0.999264747f,
   (float16_t)-0.036807223f, (float16_t)-0.999322385f,
   (float16_t)-0.035274239f, (float16_t)-0.999377670f,
   (float16_t)-0.033741172f, (float16_t)-0.999430605f,
   (float16_t)-0.032208025f, (float16_t)-0.999481187f,
   (float16_t)-0.030674803f, (float16_t)-0.999529418f,
   (float16_t)-0.029141509f, (float16_t)-0.999575296f,
   (float16_t)-0.027608146f, (float16_t)-0.999618822f,
   (float16_t)-0.026074718f, (float16_t)-0.999659997f,
   (float16_t)-0.024541229f, (float16_t)-0.999698819f,
   (float16_t)-0.023007681f, (float16_t)-0.999735288f,
   (float16_t)-0.021474080f, (float16_t)-0.999769405f,
   (float16_t)-0.019940429f, (float16_t)-0.999801170f,
   (float16_t)-0.018406730f, (float16_t)-0.999830582f,
   (float16_t)-0.016872988f, (float16_t)-0.999857641f,
   (float16_t)-0.015339206f, (float16_t)-0.999882347f,
   (float16_t)-0.013805389f, (float16_t)-0.999904701f,
   (float16_t)-0.012271538f, (float16_t)-0.999924702f,
   (float16_t)-0.010737659f, (float16_t)-0.999942350f,
   (float16_t)-0.009203755f, (float16_t)-0.999957645f,
   (float16_t)-0.007669829f, (float16_t)-0.999970586f,
   (float16_t)-0.006135885f, (float16_t)-0.999981175f,
   (float16_t)-0.004601926f, (float16_t)-0.999989411f,
   (float16_t)-0.003067957f, (float16_t)-0.999995294f,
   (float16_t)-0.001533980f, (float16_t)-0.999998823f,
   (float16_t)-0.000000000f, (float16_t)-1.000000000f,
    (float16_t)0.001533980f, (float16_t)-0.999998823f,
    (float16_t)0.003067957f, (float16_t)-0.999995294f,
    (float16_t)0.004601926f, (float16_t)-0.999989411f,
    (float16_t)0.006135885f, (float16_t)-0.999981175f,
    (float16_t)0.007669829f, (float16_t)-0.999970586f,
    (float16_t)0.009203755f, (float16_t)-0.999957645f,
    (float16_t)0.010737659f, (float16_t)-0.999942350f,
    (float16_t)0.012271538f, (float16_t)-0.999924702f,
    (float16_t)0.013805389f, (float16_t)-0.999904701f,
    (float16_t)0.015339206f, (float16_t)-0.999882347f,
    (float16_t)0.016872988f, (float16_t)-0.999857641f,
    (float16_t)0.018406730f, (float16_t)-0.999830582f,
    (float16_t)0.019940429f, (float16_t)-0.999801170f,
    (float16_t)0.021474080f, (float16_t)-0.999769405f,
    (float16_t)0.023007681f, (float16_t)-0.999735288f,
    (float16_t)0.024541229f, (float16_t)-0.999698819f,
    (float16_t)0.026074718f, (float16_t)-0.999659997f,
    (float16_t)0.027608146f, (float16_t)-0.999618822f,
    (float16_t)0.029141509f, (float16_t)-0.999575296f,
    (float16_t)0.030674803f, (float16_t)-0.999529418f,
    (float16_t)0.032208025f, (float16_t)-0.999481187f,
    (float16_t)0.033741172f, (float16_t)-0.999430605f,
    (float16_t)0.035274239f, (float16_t)-0.999377670f,
    (float16_t)0.036807223f, (float16_t)-0.999322385f,
    (float16_t)0.038340120f, (float16_t)-0.999264747f,
    (float16_t)0.039872928f, (float16_t)-0.999204759f,
    (float16_t)0.041405641f, (float16_t)-0.999142419f,
    (float16_t)0.042938257f, (float16_t)-0.999077728f,
    (float16_t)0.044470772f, (float16_t)-0.999010686f,
    (float16_t)0.046003182f, (float16_t)-0.998941293f,
    (float16_t)0.047535484f, (float16_t)-0.998869550f,
    (float16_t)0.049067674f, (float16_t)-0.998795456f,
    (float16_t)0.050599749f, (float16_t)-0.998719012f,
    (float16_t)0.052131705f, (float16_t)-0.998640218f,
    (float16_t)0.053663538f, (float16_t)-0.998559074f,
    (float16_t)0.055195244f, (float16_t)-0.998475581f,
    (float16_t)0.056726821f, (float16_t)-0.998389737f,
    (float16_t)0.058258265f, (float16_t)-0.998301545f,
    (float16_t)0.059789571f, (float16_t)-0.998211003f,
    (float16_t)0.061320736f, (float16_t)-0.998118113f,
    (float16_t)0.062851758f, (float16_t)-0.998022874f,
    (float16_t)0.064382631f, (float16_t)-0.997925286f,
    (float16_t)0.065913353f, (float16_t)-0.997825350f,
    (float16_t)0.067443920f, (float16_t)-0.997723067f,
    (float16_t)0.068974328f, (float16_t)-0.997618435f,
    (float16_t)0.070504573f, (float16_t)-0.997511456f,
    (float16_t)0.072034653f, (float16_t)-0.997402130f,
    (float16_t)0.073564564f, (float16_t)-0.997290457f,
    (float16_t)0.075094301f, (float16_t)-0.997176437f,
    (float16_t)0.076623861f, (float16_t)-0.997060070f,
    (float16_t)0.078153242f, (float16_t)-0.996941358f,
    (float16_t)0.079682438f, (float16_t)-0.996820299f,
    (float16_t)0.081211447f, (float16_t)-0.996696895f,
    (float16_t)0.082740265f, (float16_t)-0.996571146f,
    (float16_t)0.084268888f, (float16_t)-0.996443051f,
    (float16_t)0.085797312f, (float16_t)-0.996312612f,
    (float16_t)0.087325535f, (float16_t)-0.996179829f,
    (float16_t)0.088853553f, (float16_t)-0.996044701f,
    (float16_t)0.090381361f, (float16_t)-0.995907229f,
    (float16_t)0.091908956f, (float16_t)-0.995767414f,
    (float16_t)0.093436336f, (float16_t)-0.995625256f,
    (float16_t)0.094963495f, (float16_t)-0.995480755f,
    (float16_t)0.096490431f, (float16_t)-0.995333912f,
    (float16_t)0.098017140f, (float16_t)-0.995184727f,
    (float16_t)0.099543619f, (float16_t)-0.995033199f,
    (float16_t)0.101069863f, (float16_t)-0.994879331f,
    (float16_t)0.102595869f, (float16_t)-0.994723121f,
    (float16_t)0.104121634f, (float16_t)-0.994564571f,
    (float16_t)0.105647154f, (float16_t)-0.994403680f,
    (float16_t)0.107172425f, (float16_t)-0.994240449f,
    (float16_t)0.108697444f, (float16_t)-0.994074879f,
    (float16_t)0.110222207f, (float16_t)-0.993906970f,
    (float16_t)0.111746711f, (float16_t)-0.993736722f,
    (float16_t)0.113270952f, (float16_t)-0.993564136f,
    (float16_t)0.114794927f, (float16_t)-0.993389211f,
    (float16_t)0.116318631f, (float16_t)-0.993211949f,
    (float16_t)0.117842062f, (float16_t)-0.993032350f,
    (float16_t)0.119365215f, (float16_t)-0.992850414f,
    (float16_t)0.120888087f, (float16_t)-0.992666142f,
    (float16_t)0.122410675f, (float16_t)-0.992479535f,
    (float16_t)0.123932975f, (float16_t)-0.992290591f,
    (float16_t)0.125454983f, (float16_t)-0.992099313f,
    (float16_t)0.126976696f, (float16_t)-0.991905700f,
    (float16_t)0.128498111f, (float16_t)-0.991709754f,
    (float16_t)0.130019223f, (float16_t)-0.991511473f,
    (float16_t)0.131540029f, (float16_t)-0.991310860f,
    (float16_t)0.133060525f, (float16_t)-0.991107914f,
    (float16_t)0.134580709f, (float16_t)-0.990902635f,
    (float16_t)0.136100575f, (float16_t)-0.990695025f,
    (float16_t)0.137620122f, (float16_t)-0.990485084f,
    (float16_t)0.139139344f, (float16_t)-0.990272812f,
    (float16_t)0.140658239f, (float16_t)-0.990058210f,
    (float16_t)0.142176804f, (float16_t)-0.989841278f,
    (float16_t)0.143695033f, (float16_t)-0.989622017f,
    (float16_t)0.145212925f, (float16_t)-0.989400428f,
    (float16_t)0.146730474f, (float16_t)-0.989176510f,
    (float16_t)0.148247679f, (float16_t)-0.988950265f,
    (float16_t)0.149764535f, (float16_t)-0.988721692f,
    (float16_t)0.151281038f, (float16_t)-0.988490793f,
    (float16_t)0.152797185f, (float16_t)-0.988257568f,
    (float16_t)0.154312973f, (float16_t)-0.988022017f,
    (float16_t)0.155828398f, (float16_t)-0.987784142f,
    (float16_t)0.157343456f, (float16_t)-0.987543942f,
    (float16_t)0.158858143f, (float16_t)-0.987301418f,
    (float16_t)0.160372457f, (float16_t)-0.987056571f,
    (float16_t)0.161886394f, (float16_t)-0.986809402f,
    (float16_t)0.163399949f, (float16_t)-0.986559910f,
    (float16_t)0.164913120f, (float16_t)-0.986308097f,
    (float16_t)0.166425904f, (float16_t)-0.986053963f,
    (float16_t)0.167938295f, (float16_t)-0.985797509f,
    (float16_t)0.169450291f, (float16_t)-0.985538735f,
    (float16_t)0.170961889f, (float16_t)-0.985277642f,
    (float16_t)0.172473084f, (float16_t)-0.985014231f,
    (float16_t)0.173983873f, (float16_t)-0.984748502f,
    (float16_t)0.175494253f, (float16_t)-0.984480455f,
    (float16_t)0.177004220f, (float16_t)-0.984210092f,
    (float16_t)0.178513771f, (float16_t)-0.983937413f,
    (float16_t)0.180022901f, (float16_t)-0.983662419f,
    (float16_t)0.181531608f, (float16_t)-0.983385110f,
    (float16_t)0.183039888f, (float16_t)-0.983105487f,
    (float16_t)0.184547737f, (float16_t)-0.982823551f,
    (float16_t)0.186055152f, (float16_t)-0.982539302f,
    (float16_t)0.187562129f, (float16_t)-0.982252741f,
    (float16_t)0.189068664f, (float16_t)-0.981963869f,
    (float16_t)0.190574755f, (float16_t)-0.981672686f,
    (float16_t)0.192080397f, (float16_t)-0.981379193f,
    (float16_t)0.193585587f, (float16_t)-0.981083391f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.196594598f, (float16_t)-0.980484862f,
    (float16_t)0.198098411f, (float16_t)-0.980182136f,
    (float16_t)0.199601758f, (float16_t)-0.979877104f,
    (float16_t)0.201104635f, (float16_t)-0.979569766f,
    (float16_t)0.202607039f, (float16_t)-0.979260123f,
    (float16_t)0.204108966f, (float16_t)-0.978948175f,
    (float16_t)0.205610413f, (float16_t)-0.978633924f,
    (float16_t)0.207111376f, (float16_t)-0.978317371f,
    (float16_t)0.208611852f, (float16_t)-0.977998515f,
    (float16_t)0.210111837f, (float16_t)-0.977677358f,
    (float16_t)0.211611327f, (float16_t)-0.977353900f,
    (float16_t)0.213110320f, (float16_t)-0.977028143f,
    (float16_t)0.214608811f, (float16_t)-0.976700086f,
    (float16_t)0.216106797f, (float16_t)-0.976369731f,
    (float16_t)0.217604275f, (float16_t)-0.976037079f,
    (float16_t)0.219101240f, (float16_t)-0.975702130f,
    (float16_t)0.220597690f, (float16_t)-0.975364885f,
    (float16_t)0.222093621f, (float16_t)-0.975025345f,
    (float16_t)0.223589029f, (float16_t)-0.974683511f,
    (float16_t)0.225083911f, (float16_t)-0.974339383f,
    (float16_t)0.226578264f, (float16_t)-0.973992962f,
    (float16_t)0.228072083f, (float16_t)-0.973644250f,
    (float16_t)0.229565366f, (float16_t)-0.973293246f,
    (float16_t)0.231058108f, (float16_t)-0.972939952f,
    (float16_t)0.232550307f, (float16_t)-0.972584369f,
    (float16_t)0.234041959f, (float16_t)-0.972226497f,
    (float16_t)0.235533059f, (float16_t)-0.971866337f,
    (float16_t)0.237023606f, (float16_t)-0.971503891f,
    (float16_t)0.238513595f, (float16_t)-0.971139158f,
    (float16_t)0.240003022f, (float16_t)-0.970772141f,
    (float16_t)0.241491885f, (float16_t)-0.970402839f,
    (float16_t)0.242980180f, (float16_t)-0.970031253f,
    (float16_t)0.244467903f, (float16_t)-0.969657385f,
    (float16_t)0.245955050f, (float16_t)-0.969281235f,
    (float16_t)0.247441619f, (float16_t)-0.968902805f,
    (float16_t)0.248927606f, (float16_t)-0.968522094f,
    (float16_t)0.250413007f, (float16_t)-0.968139105f,
    (float16_t)0.251897818f, (float16_t)-0.967753837f,
    (float16_t)0.253382037f, (float16_t)-0.967366292f,
    (float16_t)0.254865660f, (float16_t)-0.966976471f,
    (float16_t)0.256348682f, (float16_t)-0.966584374f,
    (float16_t)0.257831102f, (float16_t)-0.966190003f,
    (float16_t)0.259312915f, (float16_t)-0.965793359f,
    (float16_t)0.260794118f, (float16_t)-0.965394442f,
    (float16_t)0.262274707f, (float16_t)-0.964993253f,
    (float16_t)0.263754679f, (float16_t)-0.964589793f,
    (float16_t)0.265234030f, (float16_t)-0.964184064f,
    (float16_t)0.266712757f, (float16_t)-0.963776066f,
    (float16_t)0.268190857f, (float16_t)-0.963365800f,
    (float16_t)0.269668326f, (float16_t)-0.962953267f,
    (float16_t)0.271145160f, (float16_t)-0.962538468f,
    (float16_t)0.272621355f, (float16_t)-0.962121404f,
    (float16_t)0.274096910f, (float16_t)-0.961702077f,
    (float16_t)0.275571819f, (float16_t)-0.961280486f,
    (float16_t)0.277046080f, (float16_t)-0.960856633f,
    (float16_t)0.278519689f, (float16_t)-0.960430519f,
    (float16_t)0.279992643f, (float16_t)-0.960002146f,
    (float16_t)0.281464938f, (float16_t)-0.959571513f,
    (float16_t)0.282936570f, (float16_t)-0.959138622f,
    (float16_t)0.284407537f, (float16_t)-0.958703475f,
    (float16_t)0.285877835f, (float16_t)-0.958266071f,
    (float16_t)0.287347460f, (float16_t)-0.957826413f,
    (float16_t)0.288816408f, (float16_t)-0.957384501f,
    (float16_t)0.290284677f, (float16_t)-0.956940336f,
    (float16_t)0.291752263f, (float16_t)-0.956493919f,
    (float16_t)0.293219163f, (float16_t)-0.956045251f,
    (float16_t)0.294685372f, (float16_t)-0.955594334f,
    (float16_t)0.296150888f, (float16_t)-0.955141168f,
    (float16_t)0.297615707f, (float16_t)-0.954685755f,
    (float16_t)0.299079826f, (float16_t)-0.954228095f,
    (float16_t)0.300543241f, (float16_t)-0.953768190f,
    (float16_t)0.302005949f, (float16_t)-0.953306040f,
    (float16_t)0.303467947f, (float16_t)-0.952841648f,
    (float16_t)0.304929230f, (float16_t)-0.952375013f,
    (float16_t)0.306389795f, (float16_t)-0.951906137f,
    (float16_t)0.307849640f, (float16_t)-0.951435021f,
    (float16_t)0.309308760f, (float16_t)-0.950961666f,
    (float16_t)0.310767153f, (float16_t)-0.950486074f,
    (float16_t)0.312224814f, (float16_t)-0.950008245f,
    (float16_t)0.313681740f, (float16_t)-0.949528181f,
    (float16_t)0.315137929f, (float16_t)-0.949045882f,
    (float16_t)0.316593376f, (float16_t)-0.948561350f,
    (float16_t)0.318048077f, (float16_t)-0.948074586f,
    (float16_t)0.319502031f, (float16_t)-0.947585591f,
    (float16_t)0.320955232f, (float16_t)-0.947094366f,
    (float16_t)0.322407679f, (float16_t)-0.946600913f,
    (float16_t)0.323859367f, (float16_t)-0.946105232f,
    (float16_t)0.325310292f, (float16_t)-0.945607325f,
    (float16_t)0.326760452f, (float16_t)-0.945107193f,
    (float16_t)0.328209844f, (float16_t)-0.944604837f,
    (float16_t)0.329658463f, (float16_t)-0.944100258f,
    (float16_t)0.331106306f, (float16_t)-0.943593458f,
    (float16_t)0.332553370f, (float16_t)-0.943084437f,
    (float16_t)0.333999651f, (float16_t)-0.942573198f,
    (float16_t)0.335445147f, (float16_t)-0.942059740f,
    (float16_t)0.336889853f, (float16_t)-0.941544065f,
    (float16_t)0.338333767f, (float16_t)-0.941026175f,
    (float16_t)0.339776884f, (float16_t)-0.940506071f,
    (float16_t)0.341219202f, (float16_t)-0.939983753f,
    (float16_t)0.342660717f, (float16_t)-0.939459224f,
    (float16_t)0.344101426f, (float16_t)-0.938932484f,
    (float16_t)0.345541325f, (float16_t)-0.938403534f,
    (float16_t)0.346980411f, (float16_t)-0.937872376f,
    (float16_t)0.348418680f, (float16_t)-0.937339012f,
    (float16_t)0.349856130f, (float16_t)-0.936803442f,
    (float16_t)0.351292756f, (float16_t)-0.936265667f,
    (float16_t)0.352728556f, (float16_t)-0.935725689f,
    (float16_t)0.354163525f, (float16_t)-0.935183510f,
    (float16_t)0.355597662f, (float16_t)-0.934639130f,
    (float16_t)0.357030961f, (float16_t)-0.934092550f,
    (float16_t)0.358463421f, (float16_t)-0.933543773f,
    (float16_t)0.359895037f, (float16_t)-0.932992799f,
    (float16_t)0.361325806f, (float16_t)-0.932439629f,
    (float16_t)0.362755724f, (float16_t)-0.931884266f,
    (float16_t)0.364184790f, (float16_t)-0.931326709f,
    (float16_t)0.365612998f, (float16_t)-0.930766961f,
    (float16_t)0.367040346f, (float16_t)-0.930205023f,
    (float16_t)0.368466830f, (float16_t)-0.929640896f,
    (float16_t)0.369892447f, (float16_t)-0.929074581f,
    (float16_t)0.371317194f, (float16_t)-0.928506080f,
    (float16_t)0.372741067f, (float16_t)-0.927935395f,
    (float16_t)0.374164063f, (float16_t)-0.927362526f,
    (float16_t)0.375586178f, (float16_t)-0.926787474f,
    (float16_t)0.377007410f, (float16_t)-0.926210242f,
    (float16_t)0.378427755f, (float16_t)-0.925630831f,
    (float16_t)0.379847209f, (float16_t)-0.925049241f,
    (float16_t)0.381265769f, (float16_t)-0.924465474f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.384100195f, (float16_t)-0.923291417f,
    (float16_t)0.385516054f, (float16_t)-0.922701128f,
    (float16_t)0.386931006f, (float16_t)-0.922108669f,
    (float16_t)0.388345047f, (float16_t)-0.921514039f,
    (float16_t)0.389758174f, (float16_t)-0.920917242f,
    (float16_t)0.391170384f, (float16_t)-0.920318277f,
    (float16_t)0.392581674f, (float16_t)-0.919717146f,
    (float16_t)0.393992040f, (float16_t)-0.919113852f,
    (float16_t)0.395401479f, (float16_t)-0.918508394f,
    (float16_t)0.396809987f, (float16_t)-0.917900776f,
    (float16_t)0.398217562f, (float16_t)-0.917290997f,
    (float16_t)0.399624200f, (float16_t)-0.916679060f,
    (float16_t)0.401029897f, (float16_t)-0.916064966f,
    (float16_t)0.402434651f, (float16_t)-0.915448716f,
    (float16_t)0.403838458f, (float16_t)-0.914830312f,
    (float16_t)0.405241314f, (float16_t)-0.914209756f,
    (float16_t)0.406643217f, (float16_t)-0.913587048f,
    (float16_t)0.408044163f, (float16_t)-0.912962190f,
    (float16_t)0.409444149f, (float16_t)-0.912335185f,
    (float16_t)0.410843171f, (float16_t)-0.911706032f,
    (float16_t)0.412241227f, (float16_t)-0.911074734f,
    (float16_t)0.413638312f, (float16_t)-0.910441292f,
    (float16_t)0.415034424f, (float16_t)-0.909805708f,
    (float16_t)0.416429560f, (float16_t)-0.909167983f,
    (float16_t)0.417823716f, (float16_t)-0.908528119f,
    (float16_t)0.419216888f, (float16_t)-0.907886116f,
    (float16_t)0.420609074f, (float16_t)-0.907241978f,
    (float16_t)0.422000271f, (float16_t)-0.906595705f,
    (float16_t)0.423390474f, (float16_t)-0.905947298f,
    (float16_t)0.424779681f, (float16_t)-0.905296759f,
    (float16_t)0.426167889f, (float16_t)-0.904644091f,
    (float16_t)0.427555093f, (float16_t)-0.903989293f,
    (float16_t)0.428941292f, (float16_t)-0.903332368f,
    (float16_t)0.430326481f, (float16_t)-0.902673318f,
    (float16_t)0.431710658f, (float16_t)-0.902012144f,
    (float16_t)0.433093819f, (float16_t)-0.901348847f,
    (float16_t)0.434475961f, (float16_t)-0.900683429f,
    (float16_t)0.435857080f, (float16_t)-0.900015892f,
    (float16_t)0.437237174f, (float16_t)-0.899346237f,
    (float16_t)0.438616239f, (float16_t)-0.898674466f,
    (float16_t)0.439994271f, (float16_t)-0.898000580f,
    (float16_t)0.441371269f, (float16_t)-0.897324581f,
    (float16_t)0.442747228f, (float16_t)-0.896646470f,
    (float16_t)0.444122145f, (float16_t)-0.895966250f,
    (float16_t)0.445496017f, (float16_t)-0.895283921f,
    (float16_t)0.446868840f, (float16_t)-0.894599486f,
    (float16_t)0.448240612f, (float16_t)-0.893912945f,
    (float16_t)0.449611330f, (float16_t)-0.893224301f,
    (float16_t)0.450980989f, (float16_t)-0.892533555f,
    (float16_t)0.452349587f, (float16_t)-0.891840709f,
    (float16_t)0.453717121f, (float16_t)-0.891145765f,
    (float16_t)0.455083587f, (float16_t)-0.890448723f,
    (float16_t)0.456448982f, (float16_t)-0.889749586f,
    (float16_t)0.457813304f, (float16_t)-0.889048356f,
    (float16_t)0.459176548f, (float16_t)-0.888345033f,
    (float16_t)0.460538711f, (float16_t)-0.887639620f,
    (float16_t)0.461899791f, (float16_t)-0.886932119f,
    (float16_t)0.463259784f, (float16_t)-0.886222530f,
    (float16_t)0.464618686f, (float16_t)-0.885510856f,
    (float16_t)0.465976496f, (float16_t)-0.884797098f,
    (float16_t)0.467333209f, (float16_t)-0.884081259f,
    (float16_t)0.468688822f, (float16_t)-0.883363339f,
    (float16_t)0.470043332f, (float16_t)-0.882643340f,
    (float16_t)0.471396737f, (float16_t)-0.881921264f,
    (float16_t)0.472749032f, (float16_t)-0.881197113f,
    (float16_t)0.474100215f, (float16_t)-0.880470889f,
    (float16_t)0.475450282f, (float16_t)-0.879742593f,
    (float16_t)0.476799230f, (float16_t)-0.879012226f,
    (float16_t)0.478147056f, (float16_t)-0.878279792f,
    (float16_t)0.479493758f, (float16_t)-0.877545290f,
    (float16_t)0.480839331f, (float16_t)-0.876808724f,
    (float16_t)0.482183772f, (float16_t)-0.876070094f,
    (float16_t)0.483527079f, (float16_t)-0.875329403f,
    (float16_t)0.484869248f, (float16_t)-0.874586652f,
    (float16_t)0.486210276f, (float16_t)-0.873841843f,
    (float16_t)0.487550160f, (float16_t)-0.873094978f,
    (float16_t)0.488888897f, (float16_t)-0.872346059f,
    (float16_t)0.490226483f, (float16_t)-0.871595087f,
    (float16_t)0.491562916f, (float16_t)-0.870842063f,
    (float16_t)0.492898192f, (float16_t)-0.870086991f,
    (float16_t)0.494232309f, (float16_t)-0.869329871f,
    (float16_t)0.495565262f, (float16_t)-0.868570706f,
    (float16_t)0.496897049f, (float16_t)-0.867809497f,
    (float16_t)0.498227667f, (float16_t)-0.867046246f,
    (float16_t)0.499557113f, (float16_t)-0.866280954f,
    (float16_t)0.500885383f, (float16_t)-0.865513624f,
    (float16_t)0.502212474f, (float16_t)-0.864744258f,
    (float16_t)0.503538384f, (float16_t)-0.863972856f,
    (float16_t)0.504863109f, (float16_t)-0.863199422f,
    (float16_t)0.506186645f, (float16_t)-0.862423956f,
    (float16_t)0.507508991f, (float16_t)-0.861646461f,
    (float16_t)0.508830143f, (float16_t)-0.860866939f,
    (float16_t)0.510150097f, (float16_t)-0.860085390f,
    (float16_t)0.511468850f, (float16_t)-0.859301818f,
    (float16_t)0.512786401f, (float16_t)-0.858516224f,
    (float16_t)0.514102744f, (float16_t)-0.857728610f,
    (float16_t)0.515417878f, (float16_t)-0.856938977f,
    (float16_t)0.516731799f, (float16_t)-0.856147328f,
    (float16_t)0.518044504f, (float16_t)-0.855353665f,
    (float16_t)0.519355990f, (float16_t)-0.854557988f,
    (float16_t)0.520666254f, (float16_t)-0.853760301f,
    (float16_t)0.521975293f, (float16_t)-0.852960605f,
    (float16_t)0.523283103f, (float16_t)-0.852158902f,
    (float16_t)0.524589683f, (float16_t)-0.851355193f,
    (float16_t)0.525895027f, (float16_t)-0.850549481f,
    (float16_t)0.527199135f, (float16_t)-0.849741768f,
    (float16_t)0.528502002f, (float16_t)-0.848932055f,
    (float16_t)0.529803625f, (float16_t)-0.848120345f,
    (float16_t)0.531104001f, (float16_t)-0.847306639f,
    (float16_t)0.532403128f, (float16_t)-0.846490939f,
    (float16_t)0.533701002f, (float16_t)-0.845673247f,
    (float16_t)0.534997620f, (float16_t)-0.844853565f,
    (float16_t)0.536292979f, (float16_t)-0.844031895f,
    (float16_t)0.537587076f, (float16_t)-0.843208240f,
    (float16_t)0.538879909f, (float16_t)-0.842382600f,
    (float16_t)0.540171473f, (float16_t)-0.841554977f,
    (float16_t)0.541461766f, (float16_t)-0.840725375f,
    (float16_t)0.542750785f, (float16_t)-0.839893794f,
    (float16_t)0.544038527f, (float16_t)-0.839060237f,
    (float16_t)0.545324988f, (float16_t)-0.838224706f,
    (float16_t)0.546610167f, (float16_t)-0.837387202f,
    (float16_t)0.547894059f, (float16_t)-0.836547727f,
    (float16_t)0.549176662f, (float16_t)-0.835706284f,
    (float16_t)0.550457973f, (float16_t)-0.834862875f,
    (float16_t)0.551737988f, (float16_t)-0.834017501f,
    (float16_t)0.553016706f, (float16_t)-0.833170165f,
    (float16_t)0.554294121f, (float16_t)-0.832320868f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.556845037f, (float16_t)-0.830616400f,
    (float16_t)0.558118531f, (float16_t)-0.829761234f,
    (float16_t)0.559390712f, (float16_t)-0.828904115f,
    (float16_t)0.560661576f, (float16_t)-0.828045045f,
    (float16_t)0.561931121f, (float16_t)-0.827184027f,
    (float16_t)0.563199344f, (float16_t)-0.826321063f,
    (float16_t)0.564466242f, (float16_t)-0.825456154f,
    (float16_t)0.565731811f, (float16_t)-0.824589303f,
    (float16_t)0.566996049f, (float16_t)-0.823720511f,
    (float16_t)0.568258953f, (float16_t)-0.822849781f,
    (float16_t)0.569520519f, (float16_t)-0.821977115f,
    (float16_t)0.570780746f, (float16_t)-0.821102515f,
    (float16_t)0.572039629f, (float16_t)-0.820225983f,
    (float16_t)0.573297167f, (float16_t)-0.819347520f,
    (float16_t)0.574553355f, (float16_t)-0.818467130f,
    (float16_t)0.575808191f, (float16_t)-0.817584813f,
    (float16_t)0.577061673f, (float16_t)-0.816700573f,
    (float16_t)0.578313796f, (float16_t)-0.815814411f,
    (float16_t)0.579564559f, (float16_t)-0.814926329f,
    (float16_t)0.580813958f, (float16_t)-0.814036330f,
    (float16_t)0.582061990f, (float16_t)-0.813144415f,
    (float16_t)0.583308653f, (float16_t)-0.812250587f,
    (float16_t)0.584553943f, (float16_t)-0.811354847f,
    (float16_t)0.585797857f, (float16_t)-0.810457198f,
    (float16_t)0.587040394f, (float16_t)-0.809557642f,
    (float16_t)0.588281548f, (float16_t)-0.808656182f,
    (float16_t)0.589521319f, (float16_t)-0.807752818f,
    (float16_t)0.590759702f, (float16_t)-0.806847554f,
    (float16_t)0.591996695f, (float16_t)-0.805940391f,
    (float16_t)0.593232295f, (float16_t)-0.805031331f,
    (float16_t)0.594466499f, (float16_t)-0.804120377f,
    (float16_t)0.595699304f, (float16_t)-0.803207531f,
    (float16_t)0.596930708f, (float16_t)-0.802292796f,
    (float16_t)0.598160707f, (float16_t)-0.801376172f,
    (float16_t)0.599389298f, (float16_t)-0.800457662f,
    (float16_t)0.600616479f, (float16_t)-0.799537269f,
    (float16_t)0.601842247f, (float16_t)-0.798614995f,
    (float16_t)0.603066599f, (float16_t)-0.797690841f,
    (float16_t)0.604289531f, (float16_t)-0.796764810f,
    (float16_t)0.605511041f, (float16_t)-0.795836905f,
    (float16_t)0.606731127f, (float16_t)-0.794907126f,
    (float16_t)0.607949785f, (float16_t)-0.793975478f,
    (float16_t)0.609167012f, (float16_t)-0.793041960f,
    (float16_t)0.610382806f, (float16_t)-0.792106577f,
    (float16_t)0.611597164f, (float16_t)-0.791169330f,
    (float16_t)0.612810082f, (float16_t)-0.790230221f,
    (float16_t)0.614021559f, (float16_t)-0.789289253f,
    (float16_t)0.615231591f, (float16_t)-0.788346428f,
    (float16_t)0.616440175f, (float16_t)-0.787401747f,
    (float16_t)0.617647308f, (float16_t)-0.786455214f,
    (float16_t)0.618852988f, (float16_t)-0.785506830f,
    (float16_t)0.620057212f, (float16_t)-0.784556597f,
    (float16_t)0.621259977f, (float16_t)-0.783604519f,
    (float16_t)0.622461279f, (float16_t)-0.782650596f,
    (float16_t)0.623661118f, (float16_t)-0.781694832f,
    (float16_t)0.624859488f, (float16_t)-0.780737229f,
    (float16_t)0.626056388f, (float16_t)-0.779777788f,
    (float16_t)0.627251815f, (float16_t)-0.778816512f,
    (float16_t)0.628445767f, (float16_t)-0.777853404f,
    (float16_t)0.629638239f, (float16_t)-0.776888466f,
    (float16_t)0.630829230f, (float16_t)-0.775921699f,
    (float16_t)0.632018736f, (float16_t)-0.774953107f,
    (float16_t)0.633206755f, (float16_t)-0.773982691f,
    (float16_t)0.634393284f, (float16_t)-0.773010453f,
    (float16_t)0.635578320f, (float16_t)-0.772036397f,
    (float16_t)0.636761861f, (float16_t)-0.771060524f,
    (float16_t)0.637943904f, (float16_t)-0.770082837f,
    (float16_t)0.639124445f, (float16_t)-0.769103338f,
    (float16_t)0.640303482f, (float16_t)-0.768122029f,
    (float16_t)0.641481013f, (float16_t)-0.767138912f,
    (float16_t)0.642657034f, (float16_t)-0.766153990f,
    (float16_t)0.643831543f, (float16_t)-0.765167266f,
    (float16_t)0.645004537f, (float16_t)-0.764178741f,
    (float16_t)0.646176013f, (float16_t)-0.763188417f,
    (float16_t)0.647345969f, (float16_t)-0.762196298f,
    (float16_t)0.648514401f, (float16_t)-0.761202385f,
    (float16_t)0.649681307f, (float16_t)-0.760206682f,
    (float16_t)0.650846685f, (float16_t)-0.759209189f,
    (float16_t)0.652010531f, (float16_t)-0.758209910f,
    (float16_t)0.653172843f, (float16_t)-0.757208847f,
    (float16_t)0.654333618f, (float16_t)-0.756206001f,
    (float16_t)0.655492853f, (float16_t)-0.755201377f,
    (float16_t)0.656650546f, (float16_t)-0.754194975f,
    (float16_t)0.657806693f, (float16_t)-0.753186799f,
    (float16_t)0.658961293f, (float16_t)-0.752176850f,
    (float16_t)0.660114342f, (float16_t)-0.751165132f,
    (float16_t)0.661265838f, (float16_t)-0.750151646f,
    (float16_t)0.662415778f, (float16_t)-0.749136395f,
    (float16_t)0.663564159f, (float16_t)-0.748119380f,
    (float16_t)0.664710978f, (float16_t)-0.747100606f,
    (float16_t)0.665856234f, (float16_t)-0.746080074f,
    (float16_t)0.666999922f, (float16_t)-0.745057785f,
    (float16_t)0.668142041f, (float16_t)-0.744033744f,
    (float16_t)0.669282588f, (float16_t)-0.743007952f,
    (float16_t)0.670421560f, (float16_t)-0.741980412f,
    (float16_t)0.671558955f, (float16_t)-0.740951125f,
    (float16_t)0.672694769f, (float16_t)-0.739920095f,
    (float16_t)0.673829000f, (float16_t)-0.738887324f,
    (float16_t)0.674961646f, (float16_t)-0.737852815f,
    (float16_t)0.676092704f, (float16_t)-0.736816569f,
    (float16_t)0.677222170f, (float16_t)-0.735778589f,
    (float16_t)0.678350043f, (float16_t)-0.734738878f,
    (float16_t)0.679476320f, (float16_t)-0.733697438f,
    (float16_t)0.680600998f, (float16_t)-0.732654272f,
    (float16_t)0.681724074f, (float16_t)-0.731609381f,
    (float16_t)0.682845546f, (float16_t)-0.730562769f,
    (float16_t)0.683965412f, (float16_t)-0.729514438f,
    (float16_t)0.685083668f, (float16_t)-0.728464390f,
    (float16_t)0.686200312f, (float16_t)-0.727412629f,
    (float16_t)0.687315341f, (float16_t)-0.726359155f,
    (float16_t)0.688428753f, (float16_t)-0.725303972f,
    (float16_t)0.689540545f, (float16_t)-0.724247083f,
    (float16_t)0.690650714f, (float16_t)-0.723188489f,
    (float16_t)0.691759258f, (float16_t)-0.722128194f,
    (float16_t)0.692866175f, (float16_t)-0.721066199f,
    (float16_t)0.693971461f, (float16_t)-0.720002508f,
    (float16_t)0.695075114f, (float16_t)-0.718937122f,
    (float16_t)0.696177131f, (float16_t)-0.717870045f,
    (float16_t)0.697277511f, (float16_t)-0.716801279f,
    (float16_t)0.698376249f, (float16_t)-0.715730825f,
    (float16_t)0.699473345f, (float16_t)-0.714658688f,
    (float16_t)0.700568794f, (float16_t)-0.713584869f,
    (float16_t)0.701662595f, (float16_t)-0.712509371f,
    (float16_t)0.702754744f, (float16_t)-0.711432196f,
    (float16_t)0.703845241f, (float16_t)-0.710353347f,
    (float16_t)0.704934080f, (float16_t)-0.709272826f,
    (float16_t)0.706021261f, (float16_t)-0.708190637f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.708190637f, (float16_t)-0.706021261f,
    (float16_t)0.709272826f, (float16_t)-0.704934080f,
    (float16_t)0.710353347f, (float16_t)-0.703845241f,
    (float16_t)0.711432196f, (float16_t)-0.702754744f,
    (float16_t)0.712509371f, (float16_t)-0.701662595f,
    (float16_t)0.713584869f, (float16_t)-0.700568794f,
    (float16_t)0.714658688f, (float16_t)-0.699473345f,
    (float16_t)0.715730825f, (float16_t)-0.698376249f,
    (float16_t)0.716801279f, (float16_t)-0.697277511f,
    (float16_t)0.717870045f, (float16_t)-0.696177131f,
    (float16_t)0.718937122f, (float16_t)-0.695075114f,
    (float16_t)0.720002508f, (float16_t)-0.693971461f,
    (float16_t)0.721066199f, (float16_t)-0.692866175f,
    (float16_t)0.722128194f, (float16_t)-0.691759258f,
    (float16_t)0.723188489f, (float16_t)-0.690650714f,
    (float16_t)0.724247083f, (float16_t)-0.689540545f,
    (float16_t)0.725303972f, (float16_t)-0.688428753f,
    (float16_t)0.726359155f, (float16_t)-0.687315341f,
    (float16_t)0.727412629f, (float16_t)-0.686200312f,
    (float16_t)0.728464390f, (float16_t)-0.685083668f,
    (float16_t)0.729514438f, (float16_t)-0.683965412f,
    (float16_t)0.730562769f, (float16_t)-0.682845546f,
    (float16_t)0.731609381f, (float16_t)-0.681724074f,
    (float16_t)0.732654272f, (float16_t)-0.680600998f,
    (float16_t)0.733697438f, (float16_t)-0.679476320f,
    (float16_t)0.734738878f, (float16_t)-0.678350043f,
    (float16_t)0.735778589f, (float16_t)-0.677222170f,
    (float16_t)0.736816569f, (float16_t)-0.676092704f,
    (float16_t)0.737852815f, (float16_t)-0.674961646f,
    (float16_t)0.738887324f, (float16_t)-0.673829000f,
    (float16_t)0.739920095f, (float16_t)-0.672694769f,
    (float16_t)0.740951125f, (float16_t)-0.671558955f,
    (float16_t)0.741980412f, (float16_t)-0.670421560f,
    (float16_t)0.743007952f, (float16_t)-0.669282588f,
    (float16_t)0.744033744f, (float16_t)-0.668142041f,
    (float16_t)0.745057785f, (float16_t)-0.666999922f,
    (float16_t)0.746080074f, (float16_t)-0.665856234f,
    (float16_t)0.747100606f, (float16_t)-0.664710978f,
    (float16_t)0.748119380f, (float16_t)-0.663564159f,
    (float16_t)0.749136395f, (float16_t)-0.662415778f,
    (float16_t)0.750151646f, (float16_t)-0.661265838f,
    (float16_t)0.751165132f, (float16_t)-0.660114342f,
    (float16_t)0.752176850f, (float16_t)-0.658961293f,
    (float16_t)0.753186799f, (float16_t)-0.657806693f,
    (float16_t)0.754194975f, (float16_t)-0.656650546f,
    (float16_t)0.755201377f, (float16_t)-0.655492853f,
    (float16_t)0.756206001f, (float16_t)-0.654333618f,
    (float16_t)0.757208847f, (float16_t)-0.653172843f,
    (float16_t)0.758209910f, (float16_t)-0.652010531f,
    (float16_t)0.759209189f, (float16_t)-0.650846685f,
    (float16_t)0.760206682f, (float16_t)-0.649681307f,
    (float16_t)0.761202385f, (float16_t)-0.648514401f,
    (float16_t)0.762196298f, (float16_t)-0.647345969f,
    (float16_t)0.763188417f, (float16_t)-0.646176013f,
    (float16_t)0.764178741f, (float16_t)-0.645004537f,
    (float16_t)0.765167266f, (float16_t)-0.643831543f,
    (float16_t)0.766153990f, (float16_t)-0.642657034f,
    (float16_t)0.767138912f, (float16_t)-0.641481013f,
    (float16_t)0.768122029f, (float16_t)-0.640303482f,
    (float16_t)0.769103338f, (float16_t)-0.639124445f,
    (float16_t)0.770082837f, (float16_t)-0.637943904f,
    (float16_t)0.771060524f, (float16_t)-0.636761861f,
    (float16_t)0.772036397f, (float16_t)-0.635578320f,
    (float16_t)0.773010453f, (float16_t)-0.634393284f,
    (float16_t)0.773982691f, (float16_t)-0.633206755f,
    (float16_t)0.774953107f, (float16_t)-0.632018736f,
    (float16_t)0.775921699f, (float16_t)-0.630829230f,
    (float16_t)0.776888466f, (float16_t)-0.629638239f,
    (float16_t)0.777853404f, (float16_t)-0.628445767f,
    (float16_t)0.778816512f, (float16_t)-0.627251815f,
    (float16_t)0.779777788f, (float16_t)-0.626056388f,
    (float16_t)0.780737229f, (float16_t)-0.624859488f,
    (float16_t)0.781694832f, (float16_t)-0.623661118f,
    (float16_t)0.782650596f, (float16_t)-0.622461279f,
    (float16_t)0.783604519f, (float16_t)-0.621259977f,
    (float16_t)0.784556597f, (float16_t)-0.620057212f,
    (float16_t)0.785506830f, (float16_t)-0.618852988f,
    (float16_t)0.786455214f, (float16_t)-0.617647308f,
    (float16_t)0.787401747f, (float16_t)-0.616440175f,
    (float16_t)0.788346428f, (float16_t)-0.615231591f,
    (float16_t)0.789289253f, (float16_t)-0.614021559f,
    (float16_t)0.790230221f, (float16_t)-0.612810082f,
    (float16_t)0.791169330f, (float16_t)-0.611597164f,
    (float16_t)0.792106577f, (float16_t)-0.610382806f,
    (float16_t)0.793041960f, (float16_t)-0.609167012f,
    (float16_t)0.793975478f, (float16_t)-0.607949785f,
    (float16_t)0.794907126f, (float16_t)-0.606731127f,
    (float16_t)0.795836905f, (float16_t)-0.605511041f,
    (float16_t)0.796764810f, (float16_t)-0.604289531f,
    (float16_t)0.797690841f, (float16_t)-0.603066599f,
    (float16_t)0.798614995f, (float16_t)-0.601842247f,
    (float16_t)0.799537269f, (float16_t)-0.600616479f,
    (float16_t)0.800457662f, (float16_t)-0.599389298f,
    (float16_t)0.801376172f, (float16_t)-0.598160707f,
    (float16_t)0.802292796f, (float16_t)-0.596930708f,
    (float16_t)0.803207531f, (float16_t)-0.595699304f,
    (float16_t)0.804120377f, (float16_t)-0.594466499f,
    (float16_t)0.805031331f, (float16_t)-0.593232295f,
    (float16_t)0.805940391f, (float16_t)-0.591996695f,
    (float16_t)0.806847554f, (float16_t)-0.590759702f,
    (float16_t)0.807752818f, (float16_t)-0.589521319f,
    (float16_t)0.808656182f, (float16_t)-0.588281548f,
    (float16_t)0.809557642f, (float16_t)-0.587040394f,
    (float16_t)0.810457198f, (float16_t)-0.585797857f,
    (float16_t)0.811354847f, (float16_t)-0.584553943f,
    (float16_t)0.812250587f, (float16_t)-0.583308653f,
    (float16_t)0.813144415f, (float16_t)-0.582061990f,
    (float16_t)0.814036330f, (float16_t)-0.580813958f,
    (float16_t)0.814926329f, (float16_t)-0.579564559f,
    (float16_t)0.815814411f, (float16_t)-0.578313796f,
    (float16_t)0.816700573f, (float16_t)-0.577061673f,
    (float16_t)0.817584813f, (float16_t)-0.575808191f,
    (float16_t)0.818467130f, (float16_t)-0.574553355f,
    (float16_t)0.819347520f, (float16_t)-0.573297167f,
    (float16_t)0.820225983f, (float16_t)-0.572039629f,
    (float16_t)0.821102515f, (float16_t)-0.570780746f,
    (float16_t)0.821977115f, (float16_t)-0.569520519f,
    (float16_t)0.822849781f, (float16_t)-0.568258953f,
    (float16_t)0.823720511f, (float16_t)-0.566996049f,
    (float16_t)0.824589303f, (float16_t)-0.565731811f,
    (float16_t)0.825456154f, (float16_t)-0.564466242f,
    (float16_t)0.826321063f, (float16_t)-0.563199344f,
    (float16_t)0.827184027f, (float16_t)-0.561931121f,
    (float16_t)0.828045045f, (float16_t)-0.560661576f,
    (float16_t)0.828904115f, (float16_t)-0.559390712f,
    (float16_t)0.829761234f, (float16_t)-0.558118531f,
    (float16_t)0.830616400f, (float16_t)-0.556845037f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.832320868f, (float16_t)-0.554294121f,
    (float16_t)0.833170165f, (float16_t)-0.553016706f,
    (float16_t)0.834017501f, (float16_t)-0.551737988f,
    (float16_t)0.834862875f, (float16_t)-0.550457973f,
    (float16_t)0.835706284f, (float16_t)-0.549176662f,
    (float16_t)0.836547727f, (float16_t)-0.547894059f,
    (float16_t)0.837387202f, (float16_t)-0.546610167f,
    (float16_t)0.838224706f, (float16_t)-0.545324988f,
    (float16_t)0.839060237f, (float16_t)-0.544038527f,
    (float16_t)0.839893794f, (float16_t)-0.542750785f,
    (float16_t)0.840725375f, (float16_t)-0.541461766f,
    (float16_t)0.841554977f, (float16_t)-0.540171473f,
    (float16_t)0.842382600f, (float16_t)-0.538879909f,
    (float16_t)0.843208240f, (float16_t)-0.537587076f,
    (float16_t)0.844031895f, (float16_t)-0.536292979f,
    (float16_t)0.844853565f, (float16_t)-0.534997620f,
    (float16_t)0.845673247f, (float16_t)-0.533701002f,
    (float16_t)0.846490939f, (float16_t)-0.532403128f,
    (float16_t)0.847306639f, (float16_t)-0.531104001f,
    (float16_t)0.848120345f, (float16_t)-0.529803625f,
    (float16_t)0.848932055f, (float16_t)-0.528502002f,
    (float16_t)0.849741768f, (float16_t)-0.527199135f,
    (float16_t)0.850549481f, (float16_t)-0.525895027f,
    (float16_t)0.851355193f, (float16_t)-0.524589683f,
    (float16_t)0.852158902f, (float16_t)-0.523283103f,
    (float16_t)0.852960605f, (float16_t)-0.521975293f,
    (float16_t)0.853760301f, (float16_t)-0.520666254f,
    (float16_t)0.854557988f, (float16_t)-0.519355990f,
    (float16_t)0.855353665f, (float16_t)-0.518044504f,
    (float16_t)0.856147328f, (float16_t)-0.516731799f,
    (float16_t)0.856938977f, (float16_t)-0.515417878f,
    (float16_t)0.857728610f, (float16_t)-0.514102744f,
    (float16_t)0.858516224f, (float16_t)-0.512786401f,
    (float16_t)0.859301818f, (float16_t)-0.511468850f,
    (float16_t)0.860085390f, (float16_t)-0.510150097f,
    (float16_t)0.860866939f, (float16_t)-0.508830143f,
    (float16_t)0.861646461f, (float16_t)-0.507508991f,
    (float16_t)0.862423956f, (float16_t)-0.506186645f,
    (float16_t)0.863199422f, (float16_t)-0.504863109f,
    (float16_t)0.863972856f, (float16_t)-0.503538384f,
    (float16_t)0.864744258f, (float16_t)-0.502212474f,
    (float16_t)0.865513624f, (float16_t)-0.500885383f,
    (float16_t)0.866280954f, (float16_t)-0.499557113f,
    (float16_t)0.867046246f, (float16_t)-0.498227667f,
    (float16_t)0.867809497f, (float16_t)-0.496897049f,
    (float16_t)0.868570706f, (float16_t)-0.495565262f,
    (float16_t)0.869329871f, (float16_t)-0.494232309f,
    (float16_t)0.870086991f, (float16_t)-0.492898192f,
    (float16_t)0.870842063f, (float16_t)-0.491562916f,
    (float16_t)0.871595087f, (float16_t)-0.490226483f,
    (float16_t)0.872346059f, (float16_t)-0.488888897f,
    (float16_t)0.873094978f, (float16_t)-0.487550160f,
    (float16_t)0.873841843f, (float16_t)-0.486210276f,
    (float16_t)0.874586652f, (float16_t)-0.484869248f,
    (float16_t)0.875329403f, (float16_t)-0.483527079f,
    (float16_t)0.876070094f, (float16_t)-0.482183772f,
    (float16_t)0.876808724f, (float16_t)-0.480839331f,
    (float16_t)0.877545290f, (float16_t)-0.479493758f,
    (float16_t)0.878279792f, (float16_t)-0.478147056f,
    (float16_t)0.879012226f, (float16_t)-0.476799230f,
    (float16_t)0.879742593f, (float16_t)-0.475450282f,
    (float16_t)0.880470889f, (float16_t)-0.474100215f,
    (float16_t)0.881197113f, (float16_t)-0.472749032f,
    (float16_t)0.881921264f, (float16_t)-0.471396737f,
    (float16_t)0.882643340f, (float16_t)-0.470043332f,
    (float16_t)0.883363339f, (float16_t)-0.468688822f,
    (float16_t)0.884081259f, (float16_t)-0.467333209f,
    (float16_t)0.884797098f, (float16_t)-0.465976496f,
    (float16_t)0.885510856f, (float16_t)-0.464618686f,
    (float16_t)0.886222530f, (float16_t)-0.463259784f,
    (float16_t)0.886932119f, (float16_t)-0.461899791f,
    (float16_t)0.887639620f, (float16_t)-0.460538711f,
    (float16_t)0.888345033f, (float16_t)-0.459176548f,
    (float16_t)0.889048356f, (float16_t)-0.457813304f,
    (float16_t)0.889749586f, (float16_t)-0.456448982f,
    (float16_t)0.890448723f, (float16_t)-0.455083587f,
    (float16_t)0.891145765f, (float16_t)-0.453717121f,
    (float16_t)0.891840709f, (float16_t)-0.452349587f,
    (float16_t)0.892533555f, (float16_t)-0.450980989f,
    (float16_t)0.893224301f, (float16_t)-0.449611330f,
    (float16_t)0.893912945f, (float16_t)-0.448240612f,
    (float16_t)0.894599486f, (float16_t)-0.446868840f,
    (float16_t)0.895283921f, (float16_t)-0.445496017f,
    (float16_t)0.895966250f, (float16_t)-0.444122145f,
    (float16_t)0.896646470f, (float16_t)-0.442747228f,
    (float16_t)0.897324581f, (float16_t)-0.441371269f,
    (float16_t)0.898000580f, (float16_t)-0.439994271f,
    (float16_t)0.898674466f, (float16_t)-0.438616239f,
    (float16_t)0.899346237f, (float16_t)-0.437237174f,
    (float16_t)0.900015892f, (float16_t)-0.435857080f,
    (float16_t)0.900683429f, (float16_t)-0.434475961f,
    (float16_t)0.901348847f, (float16_t)-0.433093819f,
    (float16_t)0.902012144f, (float16_t)-0.431710658f,
    (float16_t)0.902673318f, (float16_t)-0.430326481f,
    (float16_t)0.903332368f, (float16_t)-0.428941292f,
    (float16_t)0.903989293f, (float16_t)-0.427555093f,
    (float16_t)0.904644091f, (float16_t)-0.426167889f,
    (float16_t)0.905296759f, (float16_t)-0.424779681f,
    (float16_t)0.905947298f, (float16_t)-0.423390474f,
    (float16_t)0.906595705f, (float16_t)-0.422000271f,
    (float16_t)0.907241978f, (float16_t)-0.420609074f,
    (float16_t)0.907886116f, (float16_t)-0.419216888f,
    (float16_t)0.908528119f, (float16_t)-0.417823716f,
    (float16_t)0.909167983f, (float16_t)-0.416429560f,
    (float16_t)0.909805708f, (float16_t)-0.415034424f,
    (float16_t)0.910441292f, (float16_t)-0.413638312f,
    (float16_t)0.911074734f, (float16_t)-0.412241227f,
    (float16_t)0.911706032f, (float16_t)-0.410843171f,
    (float16_t)0.912335185f, (float16_t)-0.409444149f,
    (float16_t)0.912962190f, (float16_t)-0.408044163f,
    (float16_t)0.913587048f, (float16_t)-0.406643217f,
    (float16_t)0.914209756f, (float16_t)-0.405241314f,
    (float16_t)0.914830312f, (float16_t)-0.403838458f,
    (float16_t)0.915448716f, (float16_t)-0.402434651f,
    (float16_t)0.916064966f, (float16_t)-0.401029897f,
    (float16_t)0.916679060f, (float16_t)-0.399624200f,
    (float16_t)0.917290997f, (float16_t)-0.398217562f,
    (float16_t)0.917900776f, (float16_t)-0.396809987f,
    (float16_t)0.918508394f, (float16_t)-0.395401479f,
    (float16_t)0.919113852f, (float16_t)-0.393992040f,
    (float16_t)0.919717146f, (float16_t)-0.392581674f,
    (float16_t)0.920318277f, (float16_t)-0.391170384f,
    (float16_t)0.920917242f, (float16_t)-0.389758174f,
    (float16_t)0.921514039f, (float16_t)-0.388345047f,
    (float16_t)0.922108669f, (float16_t)-0.386931006f,
    (float16_t)0.922701128f, (float16_t)-0.385516054f,
    (float16_t)0.923291417f, (float16_t)-0.384100195f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.924465474f, (float16_t)-0.381265769f,
    (float16_t)0.925049241f, (float16_t)-0.379847209f,
    (float16_t)0.925630831f, (float16_t)-0.378427755f,
    (float16_t)0.926210242f, (float16_t)-0.377007410f,
    (float16_t)0.926787474f, (float16_t)-0.375586178f,
    (float16_t)0.927362526f, (float16_t)-0.374164063f,
    (float16_t)0.927935395f, (float16_t)-0.372741067f,
    (float16_t)0.928506080f, (float16_t)-0.371317194f,
    (float16_t)0.929074581f, (float16_t)-0.369892447f,
    (float16_t)0.929640896f, (float16_t)-0.368466830f,
    (float16_t)0.930205023f, (float16_t)-0.367040346f,
    (float16_t)0.930766961f, (float16_t)-0.365612998f,
    (float16_t)0.931326709f, (float16_t)-0.364184790f,
    (float16_t)0.931884266f, (float16_t)-0.362755724f,
    (float16_t)0.932439629f, (float16_t)-0.361325806f,
    (float16_t)0.932992799f, (float16_t)-0.359895037f,
    (float16_t)0.933543773f, (float16_t)-0.358463421f,
    (float16_t)0.934092550f, (float16_t)-0.357030961f,
    (float16_t)0.934639130f, (float16_t)-0.355597662f,
    (float16_t)0.935183510f, (float16_t)-0.354163525f,
    (float16_t)0.935725689f, (float16_t)-0.352728556f,
    (float16_t)0.936265667f, (float16_t)-0.351292756f,
    (float16_t)0.936803442f, (float16_t)-0.349856130f,
    (float16_t)0.937339012f, (float16_t)-0.348418680f,
    (float16_t)0.937872376f, (float16_t)-0.346980411f,
    (float16_t)0.938403534f, (float16_t)-0.345541325f,
    (float16_t)0.938932484f, (float16_t)-0.344101426f,
    (float16_t)0.939459224f, (float16_t)-0.342660717f,
    (float16_t)0.939983753f, (float16_t)-0.341219202f,
    (float16_t)0.940506071f, (float16_t)-0.339776884f,
    (float16_t)0.941026175f, (float16_t)-0.338333767f,
    (float16_t)0.941544065f, (float16_t)-0.336889853f,
    (float16_t)0.942059740f, (float16_t)-0.335445147f,
    (float16_t)0.942573198f, (float16_t)-0.333999651f,
    (float16_t)0.943084437f, (float16_t)-0.332553370f,
    (float16_t)0.943593458f, (float16_t)-0.331106306f,
    (float16_t)0.944100258f, (float16_t)-0.329658463f,
    (float16_t)0.944604837f, (float16_t)-0.328209844f,
    (float16_t)0.945107193f, (float16_t)-0.326760452f,
    (float16_t)0.945607325f, (float16_t)-0.325310292f,
    (float16_t)0.946105232f, (float16_t)-0.323859367f,
    (float16_t)0.946600913f, (float16_t)-0.322407679f,
    (float16_t)0.947094366f, (float16_t)-0.320955232f,
    (float16_t)0.947585591f, (float16_t)-0.319502031f,
    (float16_t)0.948074586f, (float16_t)-0.318048077f,
    (float16_t)0.948561350f, (float16_t)-0.316593376f,
    (float16_t)0.949045882f, (float16_t)-0.315137929f,
    (float16_t)0.949528181f, (float16_t)-0.313681740f,
    (float16_t)0.950008245f, (float16_t)-0.312224814f,
    (float16_t)0.950486074f, (float16_t)-0.310767153f,
    (float16_t)0.950961666f, (float16_t)-0.309308760f,
    (float16_t)0.951435021f, (float16_t)-0.307849640f,
    (float16_t)0.951906137f, (float16_t)-0.306389795f,
    (float16_t)0.952375013f, (float16_t)-0.304929230f,
    (float16_t)0.952841648f, (float16_t)-0.303467947f,
    (float16_t)0.953306040f, (float16_t)-0.302005949f,
    (float16_t)0.953768190f, (float16_t)-0.300543241f,
    (float16_t)0.954228095f, (float16_t)-0.299079826f,
    (float16_t)0.954685755f, (float16_t)-0.297615707f,
    (float16_t)0.955141168f, (float16_t)-0.296150888f,
    (float16_t)0.955594334f, (float16_t)-0.294685372f,
    (float16_t)0.956045251f, (float16_t)-0.293219163f,
    (float16_t)0.956493919f, (float16_t)-0.291752263f,
    (float16_t)0.956940336f, (float16_t)-0.290284677f,
    (float16_t)0.957384501f, (float16_t)-0.288816408f,
    (float16_t)0.957826413f, (float16_t)-0.287347460f,
    (float16_t)0.958266071f, (float16_t)-0.285877835f,
    (float16_t)0.958703475f, (float16_t)-0.284407537f,
    (float16_t)0.959138622f, (float16_t)-0.282936570f,
    (float16_t)0.959571513f, (float16_t)-0.281464938f,
    (float16_t)0.960002146f, (float16_t)-0.279992643f,
    (float16_t)0.960430519f, (float16_t)-0.278519689f,
    (float16_t)0.960856633f, (float16_t)-0.277046080f,
    (float16_t)0.961280486f, (float16_t)-0.275571819f,
    (float16_t)0.961702077f, (float16_t)-0.274096910f,
    (float16_t)0.962121404f, (float16_t)-0.272621355f,
    (float16_t)0.962538468f, (float16_t)-0.271145160f,
    (float16_t)0.962953267f, (float16_t)-0.269668326f,
    (float16_t)0.963365800f, (float16_t)-0.268190857f,
    (float16_t)0.963776066f, (float16_t)-0.266712757f,
    (float16_t)0.964184064f, (float16_t)-0.265234030f,
    (float16_t)0.964589793f, (float16_t)-0.263754679f,
    (float16_t)0.964993253f, (float16_t)-0.262274707f,
    (float16_t)0.965394442f, (float16_t)-0.260794118f,
    (float16_t)0.965793359f, (float16_t)-0.259312915f,
    (float16_t)0.966190003f, (float16_t)-0.257831102f,
    (float16_t)0.966584374f, (float16_t)-0.256348682f,
    (float16_t)0.966976471f, (float16_t)-0.254865660f,
    (float16_t)0.967366292f, (float16_t)-0.253382037f,
    (float16_t)0.967753837f, (float16_t)-0.251897818f,
    (float16_t)0.968139105f, (float16_t)-0.250413007f,
    (float16_t)0.968522094f, (float16_t)-0.248927606f,
    (float16_t)0.968902805f, (float16_t)-0.247441619f,
    (float16_t)0.969281235f, (float16_t)-0.245955050f,
    (float16_t)0.969657385f, (float16_t)-0.244467903f,
    (float16_t)0.970031253f, (float16_t)-0.242980180f,
    (float16_t)0.970402839f, (float16_t)-0.241491885f,
    (float16_t)0.970772141f, (float16_t)-0.240003022f,
    (float16_t)0.971139158f, (float16_t)-0.238513595f,
    (float16_t)0.971503891f, (float16_t)-0.237023606f,
    (float16_t)0.971866337f, (float16_t)-0.235533059f,
    (float16_t)0.972226497f, (float16_t)-0.234041959f,
    (float16_t)0.972584369f, (float16_t)-0.232550307f,
    (float16_t)0.972939952f, (float16_t)-0.231058108f,
    (float16_t)0.973293246f, (float16_t)-0.229565366f,
    (float16_t)0.973644250f, (float16_t)-0.228072083f,
    (float16_t)0.973992962f, (float16_t)-0.226578264f,
    (float16_t)0.974339383f, (float16_t)-0.225083911f,
    (float16_t)0.974683511f, (float16_t)-0.223589029f,
    (float16_t)0.975025345f, (float16_t)-0.222093621f,
    (float16_t)0.975364885f, (float16_t)-0.220597690f,
    (float16_t)0.975702130f, (float16_t)-0.219101240f,
    (float16_t)0.976037079f, (float16_t)-0.217604275f,
    (float16_t)0.976369731f, (float16_t)-0.216106797f,
    (float16_t)0.976700086f, (float16_t)-0.214608811f,
    (float16_t)0.977028143f, (float16_t)-0.213110320f,
    (float16_t)0.977353900f, (float16_t)-0.211611327f,
    (float16_t)0.977677358f, (float16_t)-0.210111837f,
    (float16_t)0.977998515f, (float16_t)-0.208611852f,
    (float16_t)0.978317371f, (float16_t)-0.207111376f,
    (float16_t)0.978633924f, (float16_t)-0.205610413f,
    (float16_t)0.978948175f, (float16_t)-0.204108966f,
    (float16_t)0.979260123f, (float16_t)-0.202607039f,
    (float16_t)0.979569766f, (float16_t)-0.201104635f,
    (float16_t)0.979877104f, (float16_t)-0.199601758f,
    (float16_t)0.980182136f, (float16_t)-0.198098411f,
    (float16_t)0.980484862f, (float16_t)-0.196594598f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.981083391f, (float16_t)-0.193585587f,
    (float16_t)0.981379193f, (float16_t)-0.192080397f,
    (float16_t)0.981672686f, (float16_t)-0.190574755f,
    (float16_t)0.981963869f, (float16_t)-0.189068664f,
    (float16_t)0.982252741f, (float16_t)-0.187562129f,
    (float16_t)0.982539302f, (float16_t)-0.186055152f,
    (float16_t)0.982823551f, (float16_t)-0.184547737f,
    (float16_t)0.983105487f, (float16_t)-0.183039888f,
    (float16_t)0.983385110f, (float16_t)-0.181531608f,
    (float16_t)0.983662419f, (float16_t)-0.180022901f,
    (float16_t)0.983937413f, (float16_t)-0.178513771f,
    (float16_t)0.984210092f, (float16_t)-0.177004220f,
    (float16_t)0.984480455f, (float16_t)-0.175494253f,
    (float16_t)0.984748502f, (float16_t)-0.173983873f,
    (float16_t)0.985014231f, (float16_t)-0.172473084f,
    (float16_t)0.985277642f, (float16_t)-0.170961889f,
    (float16_t)0.985538735f, (float16_t)-0.169450291f,
    (float16_t)0.985797509f, (float16_t)-0.167938295f,
    (float16_t)0.986053963f, (float16_t)-0.166425904f,
    (float16_t)0.986308097f, (float16_t)-0.164913120f,
    (float16_t)0.986559910f, (float16_t)-0.163399949f,
    (float16_t)0.986809402f, (float16_t)-0.161886394f,
    (float16_t)0.987056571f, (float16_t)-0.160372457f,
    (float16_t)0.987301418f, (float16_t)-0.158858143f,
    (float16_t)0.987543942f, (float16_t)-0.157343456f,
    (float16_t)0.987784142f, (float16_t)-0.155828398f,
    (float16_t)0.988022017f, (float16_t)-0.154312973f,
    (float16_t)0.988257568f, (float16_t)-0.152797185f,
    (float16_t)0.988490793f, (float16_t)-0.151281038f,
    (float16_t)0.988721692f, (float16_t)-0.149764535f,
    (float16_t)0.988950265f, (float16_t)-0.148247679f,
    (float16_t)0.989176510f, (float16_t)-0.146730474f,
    (float16_t)0.989400428f, (float16_t)-0.145212925f,
    (float16_t)0.989622017f, (float16_t)-0.143695033f,
    (float16_t)0.989841278f, (float16_t)-0.142176804f,
    (float16_t)0.990058210f, (float16_t)-0.140658239f,
    (float16_t)0.990272812f, (float16_t)-0.139139344f,
    (float16_t)0.990485084f, (float16_t)-0.137620122f,
    (float16_t)0.990695025f, (float16_t)-0.136100575f,
    (float16_t)0.990902635f, (float16_t)-0.134580709f,
    (float16_t)0.991107914f, (float16_t)-0.133060525f,
    (float16_t)0.991310860f, (float16_t)-0.131540029f,
    (float16_t)0.991511473f, (float16_t)-0.130019223f,
    (float16_t)0.991709754f, (float16_t)-0.128498111f,
    (float16_t)0.991905700f, (float16_t)-0.126976696f,
    (float16_t)0.992099313f, (float16_t)-0.125454983f,
    (float16_t)0.992290591f, (float16_t)-0.123932975f,
    (float16_t)0.992479535f, (float16_t)-0.122410675f,
    (float16_t)0.992666142f, (float16_t)-0.120888087f,
    (float16_t)0.992850414f, (float16_t)-0.119365215f,
    (float16_t)0.993032350f, (float16_t)-0.117842062f,
    (float16_t)0.993211949f, (float16_t)-0.116318631f,
    (float16_t)0.993389211f, (float16_t)-0.114794927f,
    (float16_t)0.993564136f, (float16_t)-0.113270952f,
    (float16_t)0.993736722f, (float16_t)-0.111746711f,
    (float16_t)0.993906970f, (float16_t)-0.110222207f,
    (float16_t)0.994074879f, (float16_t)-0.108697444f,
    (float16_t)0.994240449f, (float16_t)-0.107172425f,
    (float16_t)0.994403680f, (float16_t)-0.105647154f,
    (float16_t)0.994564571f, (float16_t)-0.104121634f,
    (float16_t)0.994723121f, (float16_t)-0.102595869f,
    (float16_t)0.994879331f, (float16_t)-0.101069863f,
    (float16_t)0.995033199f, (float16_t)-0.099543619f,
    (float16_t)0.995184727f, (float16_t)-0.098017140f,
    (float16_t)0.995333912f, (float16_t)-0.096490431f,
    (float16_t)0.995480755f, (float16_t)-0.094963495f,
    (float16_t)0.995625256f, (float16_t)-0.093436336f,
    (float16_t)0.995767414f, (float16_t)-0.091908956f,
    (float16_t)0.995907229f, (float16_t)-0.090381361f,
    (float16_t)0.996044701f, (float16_t)-0.088853553f,
    (float16_t)0.996179829f, (float16_t)-0.087325535f,
    (float16_t)0.996312612f, (float16_t)-0.085797312f,
    (float16_t)0.996443051f, (float16_t)-0.084268888f,
    (float16_t)0.996571146f, (float16_t)-0.082740265f,
    (float16_t)0.996696895f, (float16_t)-0.081211447f,
    (float16_t)0.996820299f, (float16_t)-0.079682438f,
    (float16_t)0.996941358f, (float16_t)-0.078153242f,
    (float16_t)0.997060070f, (float16_t)-0.076623861f,
    (float16_t)0.997176437f, (float16_t)-0.075094301f,
    (float16_t)0.997290457f, (float16_t)-0.073564564f,
    (float16_t)0.997402130f, (float16_t)-0.072034653f,
    (float16_t)0.997511456f, (float16_t)-0.070504573f,
    (float16_t)0.997618435f, (float16_t)-0.068974328f,
    (float16_t)0.997723067f, (float16_t)-0.067443920f,
    (float16_t)0.997825350f, (float16_t)-0.065913353f,
    (float16_t)0.997925286f, (float16_t)-0.064382631f,
    (float16_t)0.998022874f, (float16_t)-0.062851758f,
    (float16_t)0.998118113f, (float16_t)-0.061320736f,
    (float16_t)0.998211003f, (float16_t)-0.059789571f,
    (float16_t)0.998301545f, (float16_t)-0.058258265f,
    (float16_t)0.998389737f, (float16_t)-0.056726821f,
    (float16_t)0.998475581f, (float16_t)-0.055195244f,
    (float16_t)0.998559074f, (float16_t)-0.053663538f,
    (float16_t)0.998640218f, (float16_t)-0.052131705f,
    (float16_t)0.998719012f, (float16_t)-0.050599749f,
    (float16_t)0.998795456f, (float16_t)-0.049067674f,
    (float16_t)0.998869550f, (float16_t)-0.047535484f,
    (float16_t)0.998941293f, (float16_t)-0.046003182f,
    (float16_t)0.999010686f, (float16_t)-0.044470772f,
    (float16_t)0.999077728f, (float16_t)-0.042938257f,
    (float16_t)0.999142419f, (float16_t)-0.041405641f,
    (float16_t)0.999204759f, (float16_t)-0.039872928f,
    (float16_t)0.999264747f, (float16_t)-0.038340120f,
    (float16_t)0.999322385f, (float16_t)-0.036807223f,
    (float16_t)0.999377670f, (float16_t)-0.035274239f,
    (float16_t)0.999430605f, (float16_t)-0.033741172f,
    (float16_t)0.999481187f, (float16_t)-0.032208025f,
    (float16_t)0.999529418f, (float16_t)-0.030674803f,
    (float16_t)0.999575296f, (float16_t)-0.029141509f,
    (float16_t)0.999618822f, (float16_t)-0.027608146f,
    (float16_t)0.999659997f, (float16_t)-0.026074718f,
    (float16_t)0.999698819f, (float16_t)-0.024541229f,
    (float16_t)0.999735288f, (float16_t)-0.023007681f,
    (float16_t)0.999769405f, (float16_t)-0.021474080f,
    (float16_t)0.999801170f, (float16_t)-0.019940429f,
    (float16_t)0.999830582f, (float16_t)-0.018406730f,
    (float16_t)0.999857641f, (float16_t)-0.016872988f,
    (float16_t)0.999882347f, (float16_t)-0.015339206f,
    (float16_t)0.999904701f, (float16_t)-0.013805389f,
    (float16_t)0.999924702f, (float16_t)-0.012271538f,
    (float16_t)0.999942350f, (float16_t)-0.010737659f,
    (float16_t)0.999957645f, (float16_t)-0.009203755f,
    (float16_t)0.999970586f, (float16_t)-0.007669829f,
    (float16_t)0.999981175f, (float16_t)-0.006135885f,
    (float16_t)0.999989411f, (float16_t)-0.004601926f,
    (float16_t)0.999995294f, (float16_t)-0.003067957f,
    (float16_t)0.999998823f, (float16_t)-0.001533980f
};
#endif 

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_RFFT_F16_32)
/**
  @par
  Example code for Floating-point RFFT Twiddle factors Generation:
  @par
  <pre>TW = exp(pi/2*i-2*pi*i*[0:L/2-1]/L).' </pre>
  @par
  Real and Imag values are in interleaved fashion
*/
const float16_t twiddleCoefF16_rfft_32[32] = {
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f
};
#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) */

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_RFFT_F16_64)
const float16_t twiddleCoefF16_rfft_64[64] = {
    (float16_t)0.000000000000000f,  (float16_t)1.000000000000000f,
    (float16_t)0.098017140329561f,  (float16_t)0.995184726672197f,
    (float16_t)0.195090322016128f,  (float16_t)0.980785280403230f,
    (float16_t)0.290284677254462f,  (float16_t)0.956940335732209f,
    (float16_t)0.382683432365090f,  (float16_t)0.923879532511287f,
    (float16_t)0.471396736825998f,  (float16_t)0.881921264348355f,
    (float16_t)0.555570233019602f,  (float16_t)0.831469612302545f,
    (float16_t)0.634393284163645f,  (float16_t)0.773010453362737f,
    (float16_t)0.707106781186547f,  (float16_t)0.707106781186548f,
    (float16_t)0.773010453362737f,  (float16_t)0.634393284163645f,
    (float16_t)0.831469612302545f,  (float16_t)0.555570233019602f,
    (float16_t)0.881921264348355f,  (float16_t)0.471396736825998f,
    (float16_t)0.923879532511287f,  (float16_t)0.382683432365090f,
    (float16_t)0.956940335732209f,  (float16_t)0.290284677254462f,
    (float16_t)0.980785280403230f,  (float16_t)0.195090322016128f,
    (float16_t)0.995184726672197f,  (float16_t)0.098017140329561f,
    (float16_t)1.000000000000000f,  (float16_t)0.000000000000000f,
    (float16_t)0.995184726672197f, (float16_t)-0.098017140329561f,
    (float16_t)0.980785280403230f, (float16_t)-0.195090322016128f,
    (float16_t)0.956940335732209f, (float16_t)-0.290284677254462f,
    (float16_t)0.923879532511287f, (float16_t)-0.382683432365090f,
    (float16_t)0.881921264348355f, (float16_t)-0.471396736825998f,
    (float16_t)0.831469612302545f, (float16_t)-0.555570233019602f,
    (float16_t)0.773010453362737f, (float16_t)-0.634393284163645f,
    (float16_t)0.707106781186548f, (float16_t)-0.707106781186547f,
    (float16_t)0.634393284163645f, (float16_t)-0.773010453362737f,
    (float16_t)0.555570233019602f, (float16_t)-0.831469612302545f,
    (float16_t)0.471396736825998f, (float16_t)-0.881921264348355f,
    (float16_t)0.382683432365090f, (float16_t)-0.923879532511287f,
    (float16_t)0.290284677254462f, (float16_t)-0.956940335732209f,
    (float16_t)0.195090322016129f, (float16_t)-0.980785280403230f,
    (float16_t)0.098017140329561f, (float16_t)-0.995184726672197f
};
#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) */

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_RFFT_F16_128)
const float16_t twiddleCoefF16_rfft_128[128] = {
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
    (float16_t)0.049067674f,  (float16_t)0.998795456f,
    (float16_t)0.098017140f,  (float16_t)0.995184727f,
    (float16_t)0.146730474f,  (float16_t)0.989176510f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.242980180f,  (float16_t)0.970031253f,
    (float16_t)0.290284677f,  (float16_t)0.956940336f,
    (float16_t)0.336889853f,  (float16_t)0.941544065f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.427555093f,  (float16_t)0.903989293f,
    (float16_t)0.471396737f,  (float16_t)0.881921264f,
    (float16_t)0.514102744f,  (float16_t)0.857728610f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.595699304f,  (float16_t)0.803207531f,
    (float16_t)0.634393284f,  (float16_t)0.773010453f,
    (float16_t)0.671558955f,  (float16_t)0.740951125f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.740951125f,  (float16_t)0.671558955f,
    (float16_t)0.773010453f,  (float16_t)0.634393284f,
    (float16_t)0.803207531f,  (float16_t)0.595699304f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.857728610f,  (float16_t)0.514102744f,
    (float16_t)0.881921264f,  (float16_t)0.471396737f,
    (float16_t)0.903989293f,  (float16_t)0.427555093f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.941544065f,  (float16_t)0.336889853f,
    (float16_t)0.956940336f,  (float16_t)0.290284677f,
    (float16_t)0.970031253f,  (float16_t)0.242980180f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.989176510f,  (float16_t)0.146730474f,
    (float16_t)0.995184727f,  (float16_t)0.098017140f,
    (float16_t)0.998795456f,  (float16_t)0.049067674f,
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.998795456f, (float16_t)-0.049067674f,
    (float16_t)0.995184727f, (float16_t)-0.098017140f,
    (float16_t)0.989176510f, (float16_t)-0.146730474f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.970031253f, (float16_t)-0.242980180f,
    (float16_t)0.956940336f, (float16_t)-0.290284677f,
    (float16_t)0.941544065f, (float16_t)-0.336889853f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.903989293f, (float16_t)-0.427555093f,
    (float16_t)0.881921264f, (float16_t)-0.471396737f,
    (float16_t)0.857728610f, (float16_t)-0.514102744f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.803207531f, (float16_t)-0.595699304f,
    (float16_t)0.773010453f, (float16_t)-0.634393284f,
    (float16_t)0.740951125f, (float16_t)-0.671558955f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.671558955f, (float16_t)-0.740951125f,
    (float16_t)0.634393284f, (float16_t)-0.773010453f,
    (float16_t)0.595699304f, (float16_t)-0.803207531f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.514102744f, (float16_t)-0.857728610f,
    (float16_t)0.471396737f, (float16_t)-0.881921264f,
    (float16_t)0.427555093f, (float16_t)-0.903989293f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.336889853f, (float16_t)-0.941544065f,
    (float16_t)0.290284677f, (float16_t)-0.956940336f,
    (float16_t)0.242980180f, (float16_t)-0.970031253f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.146730474f, (float16_t)-0.989176510f,
    (float16_t)0.098017140f, (float16_t)-0.995184727f,
    (float16_t)0.049067674f, (float16_t)-0.998795456f
};
#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) */

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_RFFT_F16_256)
const float16_t twiddleCoefF16_rfft_256[256] = {
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
    (float16_t)0.024541229f,  (float16_t)0.999698819f,
    (float16_t)0.049067674f,  (float16_t)0.998795456f,
    (float16_t)0.073564564f,  (float16_t)0.997290457f,
    (float16_t)0.098017140f,  (float16_t)0.995184727f,
    (float16_t)0.122410675f,  (float16_t)0.992479535f,
    (float16_t)0.146730474f,  (float16_t)0.989176510f,
    (float16_t)0.170961889f,  (float16_t)0.985277642f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.219101240f,  (float16_t)0.975702130f,
    (float16_t)0.242980180f,  (float16_t)0.970031253f,
    (float16_t)0.266712757f,  (float16_t)0.963776066f,
    (float16_t)0.290284677f,  (float16_t)0.956940336f,
    (float16_t)0.313681740f,  (float16_t)0.949528181f,
    (float16_t)0.336889853f,  (float16_t)0.941544065f,
    (float16_t)0.359895037f,  (float16_t)0.932992799f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.405241314f,  (float16_t)0.914209756f,
    (float16_t)0.427555093f,  (float16_t)0.903989293f,
    (float16_t)0.449611330f,  (float16_t)0.893224301f,
    (float16_t)0.471396737f,  (float16_t)0.881921264f,
    (float16_t)0.492898192f,  (float16_t)0.870086991f,
    (float16_t)0.514102744f,  (float16_t)0.857728610f,
    (float16_t)0.534997620f,  (float16_t)0.844853565f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.575808191f,  (float16_t)0.817584813f,
    (float16_t)0.595699304f,  (float16_t)0.803207531f,
    (float16_t)0.615231591f,  (float16_t)0.788346428f,
    (float16_t)0.634393284f,  (float16_t)0.773010453f,
    (float16_t)0.653172843f,  (float16_t)0.757208847f,
    (float16_t)0.671558955f,  (float16_t)0.740951125f,
    (float16_t)0.689540545f,  (float16_t)0.724247083f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.724247083f,  (float16_t)0.689540545f,
    (float16_t)0.740951125f,  (float16_t)0.671558955f,
    (float16_t)0.757208847f,  (float16_t)0.653172843f,
    (float16_t)0.773010453f,  (float16_t)0.634393284f,
    (float16_t)0.788346428f,  (float16_t)0.615231591f,
    (float16_t)0.803207531f,  (float16_t)0.595699304f,
    (float16_t)0.817584813f,  (float16_t)0.575808191f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.844853565f,  (float16_t)0.534997620f,
    (float16_t)0.857728610f,  (float16_t)0.514102744f,
    (float16_t)0.870086991f,  (float16_t)0.492898192f,
    (float16_t)0.881921264f,  (float16_t)0.471396737f,
    (float16_t)0.893224301f,  (float16_t)0.449611330f,
    (float16_t)0.903989293f,  (float16_t)0.427555093f,
    (float16_t)0.914209756f,  (float16_t)0.405241314f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.932992799f,  (float16_t)0.359895037f,
    (float16_t)0.941544065f,  (float16_t)0.336889853f,
    (float16_t)0.949528181f,  (float16_t)0.313681740f,
    (float16_t)0.956940336f,  (float16_t)0.290284677f,
    (float16_t)0.963776066f,  (float16_t)0.266712757f,
    (float16_t)0.970031253f,  (float16_t)0.242980180f,
    (float16_t)0.975702130f,  (float16_t)0.219101240f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.985277642f,  (float16_t)0.170961889f,
    (float16_t)0.989176510f,  (float16_t)0.146730474f,
    (float16_t)0.992479535f,  (float16_t)0.122410675f,
    (float16_t)0.995184727f,  (float16_t)0.098017140f,
    (float16_t)0.997290457f,  (float16_t)0.073564564f,
    (float16_t)0.998795456f,  (float16_t)0.049067674f,
    (float16_t)0.999698819f,  (float16_t)0.024541229f,
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.999698819f, (float16_t)-0.024541229f,
    (float16_t)0.998795456f, (float16_t)-0.049067674f,
    (float16_t)0.997290457f, (float16_t)-0.073564564f,
    (float16_t)0.995184727f, (float16_t)-0.098017140f,
    (float16_t)0.992479535f, (float16_t)-0.122410675f,
    (float16_t)0.989176510f, (float16_t)-0.146730474f,
    (float16_t)0.985277642f, (float16_t)-0.170961889f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.975702130f, (float16_t)-0.219101240f,
    (float16_t)0.970031253f, (float16_t)-0.242980180f,
    (float16_t)0.963776066f, (float16_t)-0.266712757f,
    (float16_t)0.956940336f, (float16_t)-0.290284677f,
    (float16_t)0.949528181f, (float16_t)-0.313681740f,
    (float16_t)0.941544065f, (float16_t)-0.336889853f,
    (float16_t)0.932992799f, (float16_t)-0.359895037f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.914209756f, (float16_t)-0.405241314f,
    (float16_t)0.903989293f, (float16_t)-0.427555093f,
    (float16_t)0.893224301f, (float16_t)-0.449611330f,
    (float16_t)0.881921264f, (float16_t)-0.471396737f,
    (float16_t)0.870086991f, (float16_t)-0.492898192f,
    (float16_t)0.857728610f, (float16_t)-0.514102744f,
    (float16_t)0.844853565f, (float16_t)-0.534997620f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.817584813f, (float16_t)-0.575808191f,
    (float16_t)0.803207531f, (float16_t)-0.595699304f,
    (float16_t)0.788346428f, (float16_t)-0.615231591f,
    (float16_t)0.773010453f, (float16_t)-0.634393284f,
    (float16_t)0.757208847f, (float16_t)-0.653172843f,
    (float16_t)0.740951125f, (float16_t)-0.671558955f,
    (float16_t)0.724247083f, (float16_t)-0.689540545f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.689540545f, (float16_t)-0.724247083f,
    (float16_t)0.671558955f, (float16_t)-0.740951125f,
    (float16_t)0.653172843f, (float16_t)-0.757208847f,
    (float16_t)0.634393284f, (float16_t)-0.773010453f,
    (float16_t)0.615231591f, (float16_t)-0.788346428f,
    (float16_t)0.595699304f, (float16_t)-0.803207531f,
    (float16_t)0.575808191f, (float16_t)-0.817584813f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.534997620f, (float16_t)-0.844853565f,
    (float16_t)0.514102744f, (float16_t)-0.857728610f,
    (float16_t)0.492898192f, (float16_t)-0.870086991f,
    (float16_t)0.471396737f, (float16_t)-0.881921264f,
    (float16_t)0.449611330f, (float16_t)-0.893224301f,
    (float16_t)0.427555093f, (float16_t)-0.903989293f,
    (float16_t)0.405241314f, (float16_t)-0.914209756f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.359895037f, (float16_t)-0.932992799f,
    (float16_t)0.336889853f, (float16_t)-0.941544065f,
    (float16_t)0.313681740f, (float16_t)-0.949528181f,
    (float16_t)0.290284677f, (float16_t)-0.956940336f,
    (float16_t)0.266712757f, (float16_t)-0.963776066f,
    (float16_t)0.242980180f, (float16_t)-0.970031253f,
    (float16_t)0.219101240f, (float16_t)-0.975702130f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.170961889f, (float16_t)-0.985277642f,
    (float16_t)0.146730474f, (float16_t)-0.989176510f,
    (float16_t)0.122410675f, (float16_t)-0.992479535f,
    (float16_t)0.098017140f, (float16_t)-0.995184727f,
    (float16_t)0.073564564f, (float16_t)-0.997290457f,
    (float16_t)0.049067674f, (float16_t)-0.998795456f,
    (float16_t)0.024541229f, (float16_t)-0.999698819f
};
#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) */

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_RFFT_F16_512)
const float16_t twiddleCoefF16_rfft_512[512] = {
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
    (float16_t)0.012271538f,  (float16_t)0.999924702f,
    (float16_t)0.024541229f,  (float16_t)0.999698819f,
    (float16_t)0.036807223f,  (float16_t)0.999322385f,
    (float16_t)0.049067674f,  (float16_t)0.998795456f,
    (float16_t)0.061320736f,  (float16_t)0.998118113f,
    (float16_t)0.073564564f,  (float16_t)0.997290457f,
    (float16_t)0.085797312f,  (float16_t)0.996312612f,
    (float16_t)0.098017140f,  (float16_t)0.995184727f,
    (float16_t)0.110222207f,  (float16_t)0.993906970f,
    (float16_t)0.122410675f,  (float16_t)0.992479535f,
    (float16_t)0.134580709f,  (float16_t)0.990902635f,
    (float16_t)0.146730474f,  (float16_t)0.989176510f,
    (float16_t)0.158858143f,  (float16_t)0.987301418f,
    (float16_t)0.170961889f,  (float16_t)0.985277642f,
    (float16_t)0.183039888f,  (float16_t)0.983105487f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.207111376f,  (float16_t)0.978317371f,
    (float16_t)0.219101240f,  (float16_t)0.975702130f,
    (float16_t)0.231058108f,  (float16_t)0.972939952f,
    (float16_t)0.242980180f,  (float16_t)0.970031253f,
    (float16_t)0.254865660f,  (float16_t)0.966976471f,
    (float16_t)0.266712757f,  (float16_t)0.963776066f,
    (float16_t)0.278519689f,  (float16_t)0.960430519f,
    (float16_t)0.290284677f,  (float16_t)0.956940336f,
    (float16_t)0.302005949f,  (float16_t)0.953306040f,
    (float16_t)0.313681740f,  (float16_t)0.949528181f,
    (float16_t)0.325310292f,  (float16_t)0.945607325f,
    (float16_t)0.336889853f,  (float16_t)0.941544065f,
    (float16_t)0.348418680f,  (float16_t)0.937339012f,
    (float16_t)0.359895037f,  (float16_t)0.932992799f,
    (float16_t)0.371317194f,  (float16_t)0.928506080f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.393992040f,  (float16_t)0.919113852f,
    (float16_t)0.405241314f,  (float16_t)0.914209756f,
    (float16_t)0.416429560f,  (float16_t)0.909167983f,
    (float16_t)0.427555093f,  (float16_t)0.903989293f,
    (float16_t)0.438616239f,  (float16_t)0.898674466f,
    (float16_t)0.449611330f,  (float16_t)0.893224301f,
    (float16_t)0.460538711f,  (float16_t)0.887639620f,
    (float16_t)0.471396737f,  (float16_t)0.881921264f,
    (float16_t)0.482183772f,  (float16_t)0.876070094f,
    (float16_t)0.492898192f,  (float16_t)0.870086991f,
    (float16_t)0.503538384f,  (float16_t)0.863972856f,
    (float16_t)0.514102744f,  (float16_t)0.857728610f,
    (float16_t)0.524589683f,  (float16_t)0.851355193f,
    (float16_t)0.534997620f,  (float16_t)0.844853565f,
    (float16_t)0.545324988f,  (float16_t)0.838224706f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.565731811f,  (float16_t)0.824589303f,
    (float16_t)0.575808191f,  (float16_t)0.817584813f,
    (float16_t)0.585797857f,  (float16_t)0.810457198f,
    (float16_t)0.595699304f,  (float16_t)0.803207531f,
    (float16_t)0.605511041f,  (float16_t)0.795836905f,
    (float16_t)0.615231591f,  (float16_t)0.788346428f,
    (float16_t)0.624859488f,  (float16_t)0.780737229f,
    (float16_t)0.634393284f,  (float16_t)0.773010453f,
    (float16_t)0.643831543f,  (float16_t)0.765167266f,
    (float16_t)0.653172843f,  (float16_t)0.757208847f,
    (float16_t)0.662415778f,  (float16_t)0.749136395f,
    (float16_t)0.671558955f,  (float16_t)0.740951125f,
    (float16_t)0.680600998f,  (float16_t)0.732654272f,
    (float16_t)0.689540545f,  (float16_t)0.724247083f,
    (float16_t)0.698376249f,  (float16_t)0.715730825f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.715730825f,  (float16_t)0.698376249f,
    (float16_t)0.724247083f,  (float16_t)0.689540545f,
    (float16_t)0.732654272f,  (float16_t)0.680600998f,
    (float16_t)0.740951125f,  (float16_t)0.671558955f,
    (float16_t)0.749136395f,  (float16_t)0.662415778f,
    (float16_t)0.757208847f,  (float16_t)0.653172843f,
    (float16_t)0.765167266f,  (float16_t)0.643831543f,
    (float16_t)0.773010453f,  (float16_t)0.634393284f,
    (float16_t)0.780737229f,  (float16_t)0.624859488f,
    (float16_t)0.788346428f,  (float16_t)0.615231591f,
    (float16_t)0.795836905f,  (float16_t)0.605511041f,
    (float16_t)0.803207531f,  (float16_t)0.595699304f,
    (float16_t)0.810457198f,  (float16_t)0.585797857f,
    (float16_t)0.817584813f,  (float16_t)0.575808191f,
    (float16_t)0.824589303f,  (float16_t)0.565731811f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.838224706f,  (float16_t)0.545324988f,
    (float16_t)0.844853565f,  (float16_t)0.534997620f,
    (float16_t)0.851355193f,  (float16_t)0.524589683f,
    (float16_t)0.857728610f,  (float16_t)0.514102744f,
    (float16_t)0.863972856f,  (float16_t)0.503538384f,
    (float16_t)0.870086991f,  (float16_t)0.492898192f,
    (float16_t)0.876070094f,  (float16_t)0.482183772f,
    (float16_t)0.881921264f,  (float16_t)0.471396737f,
    (float16_t)0.887639620f,  (float16_t)0.460538711f,
    (float16_t)0.893224301f,  (float16_t)0.449611330f,
    (float16_t)0.898674466f,  (float16_t)0.438616239f,
    (float16_t)0.903989293f,  (float16_t)0.427555093f,
    (float16_t)0.909167983f,  (float16_t)0.416429560f,
    (float16_t)0.914209756f,  (float16_t)0.405241314f,
    (float16_t)0.919113852f,  (float16_t)0.393992040f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.928506080f,  (float16_t)0.371317194f,
    (float16_t)0.932992799f,  (float16_t)0.359895037f,
    (float16_t)0.937339012f,  (float16_t)0.348418680f,
    (float16_t)0.941544065f,  (float16_t)0.336889853f,
    (float16_t)0.945607325f,  (float16_t)0.325310292f,
    (float16_t)0.949528181f,  (float16_t)0.313681740f,
    (float16_t)0.953306040f,  (float16_t)0.302005949f,
    (float16_t)0.956940336f,  (float16_t)0.290284677f,
    (float16_t)0.960430519f,  (float16_t)0.278519689f,
    (float16_t)0.963776066f,  (float16_t)0.266712757f,
    (float16_t)0.966976471f,  (float16_t)0.254865660f,
    (float16_t)0.970031253f,  (float16_t)0.242980180f,
    (float16_t)0.972939952f,  (float16_t)0.231058108f,
    (float16_t)0.975702130f,  (float16_t)0.219101240f,
    (float16_t)0.978317371f,  (float16_t)0.207111376f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.983105487f,  (float16_t)0.183039888f,
    (float16_t)0.985277642f,  (float16_t)0.170961889f,
    (float16_t)0.987301418f,  (float16_t)0.158858143f,
    (float16_t)0.989176510f,  (float16_t)0.146730474f,
    (float16_t)0.990902635f,  (float16_t)0.134580709f,
    (float16_t)0.992479535f,  (float16_t)0.122410675f,
    (float16_t)0.993906970f,  (float16_t)0.110222207f,
    (float16_t)0.995184727f,  (float16_t)0.098017140f,
    (float16_t)0.996312612f,  (float16_t)0.085797312f,
    (float16_t)0.997290457f,  (float16_t)0.073564564f,
    (float16_t)0.998118113f,  (float16_t)0.061320736f,
    (float16_t)0.998795456f,  (float16_t)0.049067674f,
    (float16_t)0.999322385f,  (float16_t)0.036807223f,
    (float16_t)0.999698819f,  (float16_t)0.024541229f,
    (float16_t)0.999924702f,  (float16_t)0.012271538f,
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.999924702f, (float16_t)-0.012271538f,
    (float16_t)0.999698819f, (float16_t)-0.024541229f,
    (float16_t)0.999322385f, (float16_t)-0.036807223f,
    (float16_t)0.998795456f, (float16_t)-0.049067674f,
    (float16_t)0.998118113f, (float16_t)-0.061320736f,
    (float16_t)0.997290457f, (float16_t)-0.073564564f,
    (float16_t)0.996312612f, (float16_t)-0.085797312f,
    (float16_t)0.995184727f, (float16_t)-0.098017140f,
    (float16_t)0.993906970f, (float16_t)-0.110222207f,
    (float16_t)0.992479535f, (float16_t)-0.122410675f,
    (float16_t)0.990902635f, (float16_t)-0.134580709f,
    (float16_t)0.989176510f, (float16_t)-0.146730474f,
    (float16_t)0.987301418f, (float16_t)-0.158858143f,
    (float16_t)0.985277642f, (float16_t)-0.170961889f,
    (float16_t)0.983105487f, (float16_t)-0.183039888f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.978317371f, (float16_t)-0.207111376f,
    (float16_t)0.975702130f, (float16_t)-0.219101240f,
    (float16_t)0.972939952f, (float16_t)-0.231058108f,
    (float16_t)0.970031253f, (float16_t)-0.242980180f,
    (float16_t)0.966976471f, (float16_t)-0.254865660f,
    (float16_t)0.963776066f, (float16_t)-0.266712757f,
    (float16_t)0.960430519f, (float16_t)-0.278519689f,
    (float16_t)0.956940336f, (float16_t)-0.290284677f,
    (float16_t)0.953306040f, (float16_t)-0.302005949f,
    (float16_t)0.949528181f, (float16_t)-0.313681740f,
    (float16_t)0.945607325f, (float16_t)-0.325310292f,
    (float16_t)0.941544065f, (float16_t)-0.336889853f,
    (float16_t)0.937339012f, (float16_t)-0.348418680f,
    (float16_t)0.932992799f, (float16_t)-0.359895037f,
    (float16_t)0.928506080f, (float16_t)-0.371317194f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.919113852f, (float16_t)-0.393992040f,
    (float16_t)0.914209756f, (float16_t)-0.405241314f,
    (float16_t)0.909167983f, (float16_t)-0.416429560f,
    (float16_t)0.903989293f, (float16_t)-0.427555093f,
    (float16_t)0.898674466f, (float16_t)-0.438616239f,
    (float16_t)0.893224301f, (float16_t)-0.449611330f,
    (float16_t)0.887639620f, (float16_t)-0.460538711f,
    (float16_t)0.881921264f, (float16_t)-0.471396737f,
    (float16_t)0.876070094f, (float16_t)-0.482183772f,
    (float16_t)0.870086991f, (float16_t)-0.492898192f,
    (float16_t)0.863972856f, (float16_t)-0.503538384f,
    (float16_t)0.857728610f, (float16_t)-0.514102744f,
    (float16_t)0.851355193f, (float16_t)-0.524589683f,
    (float16_t)0.844853565f, (float16_t)-0.534997620f,
    (float16_t)0.838224706f, (float16_t)-0.545324988f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.824589303f, (float16_t)-0.565731811f,
    (float16_t)0.817584813f, (float16_t)-0.575808191f,
    (float16_t)0.810457198f, (float16_t)-0.585797857f,
    (float16_t)0.803207531f, (float16_t)-0.595699304f,
    (float16_t)0.795836905f, (float16_t)-0.605511041f,
    (float16_t)0.788346428f, (float16_t)-0.615231591f,
    (float16_t)0.780737229f, (float16_t)-0.624859488f,
    (float16_t)0.773010453f, (float16_t)-0.634393284f,
    (float16_t)0.765167266f, (float16_t)-0.643831543f,
    (float16_t)0.757208847f, (float16_t)-0.653172843f,
    (float16_t)0.749136395f, (float16_t)-0.662415778f,
    (float16_t)0.740951125f, (float16_t)-0.671558955f,
    (float16_t)0.732654272f, (float16_t)-0.680600998f,
    (float16_t)0.724247083f, (float16_t)-0.689540545f,
    (float16_t)0.715730825f, (float16_t)-0.698376249f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.698376249f, (float16_t)-0.715730825f,
    (float16_t)0.689540545f, (float16_t)-0.724247083f,
    (float16_t)0.680600998f, (float16_t)-0.732654272f,
    (float16_t)0.671558955f, (float16_t)-0.740951125f,
    (float16_t)0.662415778f, (float16_t)-0.749136395f,
    (float16_t)0.653172843f, (float16_t)-0.757208847f,
    (float16_t)0.643831543f, (float16_t)-0.765167266f,
    (float16_t)0.634393284f, (float16_t)-0.773010453f,
    (float16_t)0.624859488f, (float16_t)-0.780737229f,
    (float16_t)0.615231591f, (float16_t)-0.788346428f,
    (float16_t)0.605511041f, (float16_t)-0.795836905f,
    (float16_t)0.595699304f, (float16_t)-0.803207531f,
    (float16_t)0.585797857f, (float16_t)-0.810457198f,
    (float16_t)0.575808191f, (float16_t)-0.817584813f,
    (float16_t)0.565731811f, (float16_t)-0.824589303f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.545324988f, (float16_t)-0.838224706f,
    (float16_t)0.534997620f, (float16_t)-0.844853565f,
    (float16_t)0.524589683f, (float16_t)-0.851355193f,
    (float16_t)0.514102744f, (float16_t)-0.857728610f,
    (float16_t)0.503538384f, (float16_t)-0.863972856f,
    (float16_t)0.492898192f, (float16_t)-0.870086991f,
    (float16_t)0.482183772f, (float16_t)-0.876070094f,
    (float16_t)0.471396737f, (float16_t)-0.881921264f,
    (float16_t)0.460538711f, (float16_t)-0.887639620f,
    (float16_t)0.449611330f, (float16_t)-0.893224301f,
    (float16_t)0.438616239f, (float16_t)-0.898674466f,
    (float16_t)0.427555093f, (float16_t)-0.903989293f,
    (float16_t)0.416429560f, (float16_t)-0.909167983f,
    (float16_t)0.405241314f, (float16_t)-0.914209756f,
    (float16_t)0.393992040f, (float16_t)-0.919113852f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.371317194f, (float16_t)-0.928506080f,
    (float16_t)0.359895037f, (float16_t)-0.932992799f,
    (float16_t)0.348418680f, (float16_t)-0.937339012f,
    (float16_t)0.336889853f, (float16_t)-0.941544065f,
    (float16_t)0.325310292f, (float16_t)-0.945607325f,
    (float16_t)0.313681740f, (float16_t)-0.949528181f,
    (float16_t)0.302005949f, (float16_t)-0.953306040f,
    (float16_t)0.290284677f, (float16_t)-0.956940336f,
    (float16_t)0.278519689f, (float16_t)-0.960430519f,
    (float16_t)0.266712757f, (float16_t)-0.963776066f,
    (float16_t)0.254865660f, (float16_t)-0.966976471f,
    (float16_t)0.242980180f, (float16_t)-0.970031253f,
    (float16_t)0.231058108f, (float16_t)-0.972939952f,
    (float16_t)0.219101240f, (float16_t)-0.975702130f,
    (float16_t)0.207111376f, (float16_t)-0.978317371f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.183039888f, (float16_t)-0.983105487f,
    (float16_t)0.170961889f, (float16_t)-0.985277642f,
    (float16_t)0.158858143f, (float16_t)-0.987301418f,
    (float16_t)0.146730474f, (float16_t)-0.989176510f,
    (float16_t)0.134580709f, (float16_t)-0.990902635f,
    (float16_t)0.122410675f, (float16_t)-0.992479535f,
    (float16_t)0.110222207f, (float16_t)-0.993906970f,
    (float16_t)0.098017140f, (float16_t)-0.995184727f,
    (float16_t)0.085797312f, (float16_t)-0.996312612f,
    (float16_t)0.073564564f, (float16_t)-0.997290457f,
    (float16_t)0.061320736f, (float16_t)-0.998118113f,
    (float16_t)0.049067674f, (float16_t)-0.998795456f,
    (float16_t)0.036807223f, (float16_t)-0.999322385f,
    (float16_t)0.024541229f, (float16_t)-0.999698819f,
    (float16_t)0.012271538f, (float16_t)-0.999924702f
};
#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) */

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_RFFT_F16_1024)
const float16_t twiddleCoefF16_rfft_1024[1024] = {
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
    (float16_t)0.006135885f,  (float16_t)0.999981175f,
    (float16_t)0.012271538f,  (float16_t)0.999924702f,
    (float16_t)0.018406730f,  (float16_t)0.999830582f,
    (float16_t)0.024541229f,  (float16_t)0.999698819f,
    (float16_t)0.030674803f,  (float16_t)0.999529418f,
    (float16_t)0.036807223f,  (float16_t)0.999322385f,
    (float16_t)0.042938257f,  (float16_t)0.999077728f,
    (float16_t)0.049067674f,  (float16_t)0.998795456f,
    (float16_t)0.055195244f,  (float16_t)0.998475581f,
    (float16_t)0.061320736f,  (float16_t)0.998118113f,
    (float16_t)0.067443920f,  (float16_t)0.997723067f,
    (float16_t)0.073564564f,  (float16_t)0.997290457f,
    (float16_t)0.079682438f,  (float16_t)0.996820299f,
    (float16_t)0.085797312f,  (float16_t)0.996312612f,
    (float16_t)0.091908956f,  (float16_t)0.995767414f,
    (float16_t)0.098017140f,  (float16_t)0.995184727f,
    (float16_t)0.104121634f,  (float16_t)0.994564571f,
    (float16_t)0.110222207f,  (float16_t)0.993906970f,
    (float16_t)0.116318631f,  (float16_t)0.993211949f,
    (float16_t)0.122410675f,  (float16_t)0.992479535f,
    (float16_t)0.128498111f,  (float16_t)0.991709754f,
    (float16_t)0.134580709f,  (float16_t)0.990902635f,
    (float16_t)0.140658239f,  (float16_t)0.990058210f,
    (float16_t)0.146730474f,  (float16_t)0.989176510f,
    (float16_t)0.152797185f,  (float16_t)0.988257568f,
    (float16_t)0.158858143f,  (float16_t)0.987301418f,
    (float16_t)0.164913120f,  (float16_t)0.986308097f,
    (float16_t)0.170961889f,  (float16_t)0.985277642f,
    (float16_t)0.177004220f,  (float16_t)0.984210092f,
    (float16_t)0.183039888f,  (float16_t)0.983105487f,
    (float16_t)0.189068664f,  (float16_t)0.981963869f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.201104635f,  (float16_t)0.979569766f,
    (float16_t)0.207111376f,  (float16_t)0.978317371f,
    (float16_t)0.213110320f,  (float16_t)0.977028143f,
    (float16_t)0.219101240f,  (float16_t)0.975702130f,
    (float16_t)0.225083911f,  (float16_t)0.974339383f,
    (float16_t)0.231058108f,  (float16_t)0.972939952f,
    (float16_t)0.237023606f,  (float16_t)0.971503891f,
    (float16_t)0.242980180f,  (float16_t)0.970031253f,
    (float16_t)0.248927606f,  (float16_t)0.968522094f,
    (float16_t)0.254865660f,  (float16_t)0.966976471f,
    (float16_t)0.260794118f,  (float16_t)0.965394442f,
    (float16_t)0.266712757f,  (float16_t)0.963776066f,
    (float16_t)0.272621355f,  (float16_t)0.962121404f,
    (float16_t)0.278519689f,  (float16_t)0.960430519f,
    (float16_t)0.284407537f,  (float16_t)0.958703475f,
    (float16_t)0.290284677f,  (float16_t)0.956940336f,
    (float16_t)0.296150888f,  (float16_t)0.955141168f,
    (float16_t)0.302005949f,  (float16_t)0.953306040f,
    (float16_t)0.307849640f,  (float16_t)0.951435021f,
    (float16_t)0.313681740f,  (float16_t)0.949528181f,
    (float16_t)0.319502031f,  (float16_t)0.947585591f,
    (float16_t)0.325310292f,  (float16_t)0.945607325f,
    (float16_t)0.331106306f,  (float16_t)0.943593458f,
    (float16_t)0.336889853f,  (float16_t)0.941544065f,
    (float16_t)0.342660717f,  (float16_t)0.939459224f,
    (float16_t)0.348418680f,  (float16_t)0.937339012f,
    (float16_t)0.354163525f,  (float16_t)0.935183510f,
    (float16_t)0.359895037f,  (float16_t)0.932992799f,
    (float16_t)0.365612998f,  (float16_t)0.930766961f,
    (float16_t)0.371317194f,  (float16_t)0.928506080f,
    (float16_t)0.377007410f,  (float16_t)0.926210242f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.388345047f,  (float16_t)0.921514039f,
    (float16_t)0.393992040f,  (float16_t)0.919113852f,
    (float16_t)0.399624200f,  (float16_t)0.916679060f,
    (float16_t)0.405241314f,  (float16_t)0.914209756f,
    (float16_t)0.410843171f,  (float16_t)0.911706032f,
    (float16_t)0.416429560f,  (float16_t)0.909167983f,
    (float16_t)0.422000271f,  (float16_t)0.906595705f,
    (float16_t)0.427555093f,  (float16_t)0.903989293f,
    (float16_t)0.433093819f,  (float16_t)0.901348847f,
    (float16_t)0.438616239f,  (float16_t)0.898674466f,
    (float16_t)0.444122145f,  (float16_t)0.895966250f,
    (float16_t)0.449611330f,  (float16_t)0.893224301f,
    (float16_t)0.455083587f,  (float16_t)0.890448723f,
    (float16_t)0.460538711f,  (float16_t)0.887639620f,
    (float16_t)0.465976496f,  (float16_t)0.884797098f,
    (float16_t)0.471396737f,  (float16_t)0.881921264f,
    (float16_t)0.476799230f,  (float16_t)0.879012226f,
    (float16_t)0.482183772f,  (float16_t)0.876070094f,
    (float16_t)0.487550160f,  (float16_t)0.873094978f,
    (float16_t)0.492898192f,  (float16_t)0.870086991f,
    (float16_t)0.498227667f,  (float16_t)0.867046246f,
    (float16_t)0.503538384f,  (float16_t)0.863972856f,
    (float16_t)0.508830143f,  (float16_t)0.860866939f,
    (float16_t)0.514102744f,  (float16_t)0.857728610f,
    (float16_t)0.519355990f,  (float16_t)0.854557988f,
    (float16_t)0.524589683f,  (float16_t)0.851355193f,
    (float16_t)0.529803625f,  (float16_t)0.848120345f,
    (float16_t)0.534997620f,  (float16_t)0.844853565f,
    (float16_t)0.540171473f,  (float16_t)0.841554977f,
    (float16_t)0.545324988f,  (float16_t)0.838224706f,
    (float16_t)0.550457973f,  (float16_t)0.834862875f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.560661576f,  (float16_t)0.828045045f,
    (float16_t)0.565731811f,  (float16_t)0.824589303f,
    (float16_t)0.570780746f,  (float16_t)0.821102515f,
    (float16_t)0.575808191f,  (float16_t)0.817584813f,
    (float16_t)0.580813958f,  (float16_t)0.814036330f,
    (float16_t)0.585797857f,  (float16_t)0.810457198f,
    (float16_t)0.590759702f,  (float16_t)0.806847554f,
    (float16_t)0.595699304f,  (float16_t)0.803207531f,
    (float16_t)0.600616479f,  (float16_t)0.799537269f,
    (float16_t)0.605511041f,  (float16_t)0.795836905f,
    (float16_t)0.610382806f,  (float16_t)0.792106577f,
    (float16_t)0.615231591f,  (float16_t)0.788346428f,
    (float16_t)0.620057212f,  (float16_t)0.784556597f,
    (float16_t)0.624859488f,  (float16_t)0.780737229f,
    (float16_t)0.629638239f,  (float16_t)0.776888466f,
    (float16_t)0.634393284f,  (float16_t)0.773010453f,
    (float16_t)0.639124445f,  (float16_t)0.769103338f,
    (float16_t)0.643831543f,  (float16_t)0.765167266f,
    (float16_t)0.648514401f,  (float16_t)0.761202385f,
    (float16_t)0.653172843f,  (float16_t)0.757208847f,
    (float16_t)0.657806693f,  (float16_t)0.753186799f,
    (float16_t)0.662415778f,  (float16_t)0.749136395f,
    (float16_t)0.666999922f,  (float16_t)0.745057785f,
    (float16_t)0.671558955f,  (float16_t)0.740951125f,
    (float16_t)0.676092704f,  (float16_t)0.736816569f,
    (float16_t)0.680600998f,  (float16_t)0.732654272f,
    (float16_t)0.685083668f,  (float16_t)0.728464390f,
    (float16_t)0.689540545f,  (float16_t)0.724247083f,
    (float16_t)0.693971461f,  (float16_t)0.720002508f,
    (float16_t)0.698376249f,  (float16_t)0.715730825f,
    (float16_t)0.702754744f,  (float16_t)0.711432196f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.711432196f,  (float16_t)0.702754744f,
    (float16_t)0.715730825f,  (float16_t)0.698376249f,
    (float16_t)0.720002508f,  (float16_t)0.693971461f,
    (float16_t)0.724247083f,  (float16_t)0.689540545f,
    (float16_t)0.728464390f,  (float16_t)0.685083668f,
    (float16_t)0.732654272f,  (float16_t)0.680600998f,
    (float16_t)0.736816569f,  (float16_t)0.676092704f,
    (float16_t)0.740951125f,  (float16_t)0.671558955f,
    (float16_t)0.745057785f,  (float16_t)0.666999922f,
    (float16_t)0.749136395f,  (float16_t)0.662415778f,
    (float16_t)0.753186799f,  (float16_t)0.657806693f,
    (float16_t)0.757208847f,  (float16_t)0.653172843f,
    (float16_t)0.761202385f,  (float16_t)0.648514401f,
    (float16_t)0.765167266f,  (float16_t)0.643831543f,
    (float16_t)0.769103338f,  (float16_t)0.639124445f,
    (float16_t)0.773010453f,  (float16_t)0.634393284f,
    (float16_t)0.776888466f,  (float16_t)0.629638239f,
    (float16_t)0.780737229f,  (float16_t)0.624859488f,
    (float16_t)0.784556597f,  (float16_t)0.620057212f,
    (float16_t)0.788346428f,  (float16_t)0.615231591f,
    (float16_t)0.792106577f,  (float16_t)0.610382806f,
    (float16_t)0.795836905f,  (float16_t)0.605511041f,
    (float16_t)0.799537269f,  (float16_t)0.600616479f,
    (float16_t)0.803207531f,  (float16_t)0.595699304f,
    (float16_t)0.806847554f,  (float16_t)0.590759702f,
    (float16_t)0.810457198f,  (float16_t)0.585797857f,
    (float16_t)0.814036330f,  (float16_t)0.580813958f,
    (float16_t)0.817584813f,  (float16_t)0.575808191f,
    (float16_t)0.821102515f,  (float16_t)0.570780746f,
    (float16_t)0.824589303f,  (float16_t)0.565731811f,
    (float16_t)0.828045045f,  (float16_t)0.560661576f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.834862875f,  (float16_t)0.550457973f,
    (float16_t)0.838224706f,  (float16_t)0.545324988f,
    (float16_t)0.841554977f,  (float16_t)0.540171473f,
    (float16_t)0.844853565f,  (float16_t)0.534997620f,
    (float16_t)0.848120345f,  (float16_t)0.529803625f,
    (float16_t)0.851355193f,  (float16_t)0.524589683f,
    (float16_t)0.854557988f,  (float16_t)0.519355990f,
    (float16_t)0.857728610f,  (float16_t)0.514102744f,
    (float16_t)0.860866939f,  (float16_t)0.508830143f,
    (float16_t)0.863972856f,  (float16_t)0.503538384f,
    (float16_t)0.867046246f,  (float16_t)0.498227667f,
    (float16_t)0.870086991f,  (float16_t)0.492898192f,
    (float16_t)0.873094978f,  (float16_t)0.487550160f,
    (float16_t)0.876070094f,  (float16_t)0.482183772f,
    (float16_t)0.879012226f,  (float16_t)0.476799230f,
    (float16_t)0.881921264f,  (float16_t)0.471396737f,
    (float16_t)0.884797098f,  (float16_t)0.465976496f,
    (float16_t)0.887639620f,  (float16_t)0.460538711f,
    (float16_t)0.890448723f,  (float16_t)0.455083587f,
    (float16_t)0.893224301f,  (float16_t)0.449611330f,
    (float16_t)0.895966250f,  (float16_t)0.444122145f,
    (float16_t)0.898674466f,  (float16_t)0.438616239f,
    (float16_t)0.901348847f,  (float16_t)0.433093819f,
    (float16_t)0.903989293f,  (float16_t)0.427555093f,
    (float16_t)0.906595705f,  (float16_t)0.422000271f,
    (float16_t)0.909167983f,  (float16_t)0.416429560f,
    (float16_t)0.911706032f,  (float16_t)0.410843171f,
    (float16_t)0.914209756f,  (float16_t)0.405241314f,
    (float16_t)0.916679060f,  (float16_t)0.399624200f,
    (float16_t)0.919113852f,  (float16_t)0.393992040f,
    (float16_t)0.921514039f,  (float16_t)0.388345047f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.926210242f,  (float16_t)0.377007410f,
    (float16_t)0.928506080f,  (float16_t)0.371317194f,
    (float16_t)0.930766961f,  (float16_t)0.365612998f,
    (float16_t)0.932992799f,  (float16_t)0.359895037f,
    (float16_t)0.935183510f,  (float16_t)0.354163525f,
    (float16_t)0.937339012f,  (float16_t)0.348418680f,
    (float16_t)0.939459224f,  (float16_t)0.342660717f,
    (float16_t)0.941544065f,  (float16_t)0.336889853f,
    (float16_t)0.943593458f,  (float16_t)0.331106306f,
    (float16_t)0.945607325f,  (float16_t)0.325310292f,
    (float16_t)0.947585591f,  (float16_t)0.319502031f,
    (float16_t)0.949528181f,  (float16_t)0.313681740f,
    (float16_t)0.951435021f,  (float16_t)0.307849640f,
    (float16_t)0.953306040f,  (float16_t)0.302005949f,
    (float16_t)0.955141168f,  (float16_t)0.296150888f,
    (float16_t)0.956940336f,  (float16_t)0.290284677f,
    (float16_t)0.958703475f,  (float16_t)0.284407537f,
    (float16_t)0.960430519f,  (float16_t)0.278519689f,
    (float16_t)0.962121404f,  (float16_t)0.272621355f,
    (float16_t)0.963776066f,  (float16_t)0.266712757f,
    (float16_t)0.965394442f,  (float16_t)0.260794118f,
    (float16_t)0.966976471f,  (float16_t)0.254865660f,
    (float16_t)0.968522094f,  (float16_t)0.248927606f,
    (float16_t)0.970031253f,  (float16_t)0.242980180f,
    (float16_t)0.971503891f,  (float16_t)0.237023606f,
    (float16_t)0.972939952f,  (float16_t)0.231058108f,
    (float16_t)0.974339383f,  (float16_t)0.225083911f,
    (float16_t)0.975702130f,  (float16_t)0.219101240f,
    (float16_t)0.977028143f,  (float16_t)0.213110320f,
    (float16_t)0.978317371f,  (float16_t)0.207111376f,
    (float16_t)0.979569766f,  (float16_t)0.201104635f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.981963869f,  (float16_t)0.189068664f,
    (float16_t)0.983105487f,  (float16_t)0.183039888f,
    (float16_t)0.984210092f,  (float16_t)0.177004220f,
    (float16_t)0.985277642f,  (float16_t)0.170961889f,
    (float16_t)0.986308097f,  (float16_t)0.164913120f,
    (float16_t)0.987301418f,  (float16_t)0.158858143f,
    (float16_t)0.988257568f,  (float16_t)0.152797185f,
    (float16_t)0.989176510f,  (float16_t)0.146730474f,
    (float16_t)0.990058210f,  (float16_t)0.140658239f,
    (float16_t)0.990902635f,  (float16_t)0.134580709f,
    (float16_t)0.991709754f,  (float16_t)0.128498111f,
    (float16_t)0.992479535f,  (float16_t)0.122410675f,
    (float16_t)0.993211949f,  (float16_t)0.116318631f,
    (float16_t)0.993906970f,  (float16_t)0.110222207f,
    (float16_t)0.994564571f,  (float16_t)0.104121634f,
    (float16_t)0.995184727f,  (float16_t)0.098017140f,
    (float16_t)0.995767414f,  (float16_t)0.091908956f,
    (float16_t)0.996312612f,  (float16_t)0.085797312f,
    (float16_t)0.996820299f,  (float16_t)0.079682438f,
    (float16_t)0.997290457f,  (float16_t)0.073564564f,
    (float16_t)0.997723067f,  (float16_t)0.067443920f,
    (float16_t)0.998118113f,  (float16_t)0.061320736f,
    (float16_t)0.998475581f,  (float16_t)0.055195244f,
    (float16_t)0.998795456f,  (float16_t)0.049067674f,
    (float16_t)0.999077728f,  (float16_t)0.042938257f,
    (float16_t)0.999322385f,  (float16_t)0.036807223f,
    (float16_t)0.999529418f,  (float16_t)0.030674803f,
    (float16_t)0.999698819f,  (float16_t)0.024541229f,
    (float16_t)0.999830582f,  (float16_t)0.018406730f,
    (float16_t)0.999924702f,  (float16_t)0.012271538f,
    (float16_t)0.999981175f,  (float16_t)0.006135885f,
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.999981175f, (float16_t)-0.006135885f,
    (float16_t)0.999924702f, (float16_t)-0.012271538f,
    (float16_t)0.999830582f, (float16_t)-0.018406730f,
    (float16_t)0.999698819f, (float16_t)-0.024541229f,
    (float16_t)0.999529418f, (float16_t)-0.030674803f,
    (float16_t)0.999322385f, (float16_t)-0.036807223f,
    (float16_t)0.999077728f, (float16_t)-0.042938257f,
    (float16_t)0.998795456f, (float16_t)-0.049067674f,
    (float16_t)0.998475581f, (float16_t)-0.055195244f,
    (float16_t)0.998118113f, (float16_t)-0.061320736f,
    (float16_t)0.997723067f, (float16_t)-0.067443920f,
    (float16_t)0.997290457f, (float16_t)-0.073564564f,
    (float16_t)0.996820299f, (float16_t)-0.079682438f,
    (float16_t)0.996312612f, (float16_t)-0.085797312f,
    (float16_t)0.995767414f, (float16_t)-0.091908956f,
    (float16_t)0.995184727f, (float16_t)-0.098017140f,
    (float16_t)0.994564571f, (float16_t)-0.104121634f,
    (float16_t)0.993906970f, (float16_t)-0.110222207f,
    (float16_t)0.993211949f, (float16_t)-0.116318631f,
    (float16_t)0.992479535f, (float16_t)-0.122410675f,
    (float16_t)0.991709754f, (float16_t)-0.128498111f,
    (float16_t)0.990902635f, (float16_t)-0.134580709f,
    (float16_t)0.990058210f, (float16_t)-0.140658239f,
    (float16_t)0.989176510f, (float16_t)-0.146730474f,
    (float16_t)0.988257568f, (float16_t)-0.152797185f,
    (float16_t)0.987301418f, (float16_t)-0.158858143f,
    (float16_t)0.986308097f, (float16_t)-0.164913120f,
    (float16_t)0.985277642f, (float16_t)-0.170961889f,
    (float16_t)0.984210092f, (float16_t)-0.177004220f,
    (float16_t)0.983105487f, (float16_t)-0.183039888f,
    (float16_t)0.981963869f, (float16_t)-0.189068664f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.979569766f, (float16_t)-0.201104635f,
    (float16_t)0.978317371f, (float16_t)-0.207111376f,
    (float16_t)0.977028143f, (float16_t)-0.213110320f,
    (float16_t)0.975702130f, (float16_t)-0.219101240f,
    (float16_t)0.974339383f, (float16_t)-0.225083911f,
    (float16_t)0.972939952f, (float16_t)-0.231058108f,
    (float16_t)0.971503891f, (float16_t)-0.237023606f,
    (float16_t)0.970031253f, (float16_t)-0.242980180f,
    (float16_t)0.968522094f, (float16_t)-0.248927606f,
    (float16_t)0.966976471f, (float16_t)-0.254865660f,
    (float16_t)0.965394442f, (float16_t)-0.260794118f,
    (float16_t)0.963776066f, (float16_t)-0.266712757f,
    (float16_t)0.962121404f, (float16_t)-0.272621355f,
    (float16_t)0.960430519f, (float16_t)-0.278519689f,
    (float16_t)0.958703475f, (float16_t)-0.284407537f,
    (float16_t)0.956940336f, (float16_t)-0.290284677f,
    (float16_t)0.955141168f, (float16_t)-0.296150888f,
    (float16_t)0.953306040f, (float16_t)-0.302005949f,
    (float16_t)0.951435021f, (float16_t)-0.307849640f,
    (float16_t)0.949528181f, (float16_t)-0.313681740f,
    (float16_t)0.947585591f, (float16_t)-0.319502031f,
    (float16_t)0.945607325f, (float16_t)-0.325310292f,
    (float16_t)0.943593458f, (float16_t)-0.331106306f,
    (float16_t)0.941544065f, (float16_t)-0.336889853f,
    (float16_t)0.939459224f, (float16_t)-0.342660717f,
    (float16_t)0.937339012f, (float16_t)-0.348418680f,
    (float16_t)0.935183510f, (float16_t)-0.354163525f,
    (float16_t)0.932992799f, (float16_t)-0.359895037f,
    (float16_t)0.930766961f, (float16_t)-0.365612998f,
    (float16_t)0.928506080f, (float16_t)-0.371317194f,
    (float16_t)0.926210242f, (float16_t)-0.377007410f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.921514039f, (float16_t)-0.388345047f,
    (float16_t)0.919113852f, (float16_t)-0.393992040f,
    (float16_t)0.916679060f, (float16_t)-0.399624200f,
    (float16_t)0.914209756f, (float16_t)-0.405241314f,
    (float16_t)0.911706032f, (float16_t)-0.410843171f,
    (float16_t)0.909167983f, (float16_t)-0.416429560f,
    (float16_t)0.906595705f, (float16_t)-0.422000271f,
    (float16_t)0.903989293f, (float16_t)-0.427555093f,
    (float16_t)0.901348847f, (float16_t)-0.433093819f,
    (float16_t)0.898674466f, (float16_t)-0.438616239f,
    (float16_t)0.895966250f, (float16_t)-0.444122145f,
    (float16_t)0.893224301f, (float16_t)-0.449611330f,
    (float16_t)0.890448723f, (float16_t)-0.455083587f,
    (float16_t)0.887639620f, (float16_t)-0.460538711f,
    (float16_t)0.884797098f, (float16_t)-0.465976496f,
    (float16_t)0.881921264f, (float16_t)-0.471396737f,
    (float16_t)0.879012226f, (float16_t)-0.476799230f,
    (float16_t)0.876070094f, (float16_t)-0.482183772f,
    (float16_t)0.873094978f, (float16_t)-0.487550160f,
    (float16_t)0.870086991f, (float16_t)-0.492898192f,
    (float16_t)0.867046246f, (float16_t)-0.498227667f,
    (float16_t)0.863972856f, (float16_t)-0.503538384f,
    (float16_t)0.860866939f, (float16_t)-0.508830143f,
    (float16_t)0.857728610f, (float16_t)-0.514102744f,
    (float16_t)0.854557988f, (float16_t)-0.519355990f,
    (float16_t)0.851355193f, (float16_t)-0.524589683f,
    (float16_t)0.848120345f, (float16_t)-0.529803625f,
    (float16_t)0.844853565f, (float16_t)-0.534997620f,
    (float16_t)0.841554977f, (float16_t)-0.540171473f,
    (float16_t)0.838224706f, (float16_t)-0.545324988f,
    (float16_t)0.834862875f, (float16_t)-0.550457973f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.828045045f, (float16_t)-0.560661576f,
    (float16_t)0.824589303f, (float16_t)-0.565731811f,
    (float16_t)0.821102515f, (float16_t)-0.570780746f,
    (float16_t)0.817584813f, (float16_t)-0.575808191f,
    (float16_t)0.814036330f, (float16_t)-0.580813958f,
    (float16_t)0.810457198f, (float16_t)-0.585797857f,
    (float16_t)0.806847554f, (float16_t)-0.590759702f,
    (float16_t)0.803207531f, (float16_t)-0.595699304f,
    (float16_t)0.799537269f, (float16_t)-0.600616479f,
    (float16_t)0.795836905f, (float16_t)-0.605511041f,
    (float16_t)0.792106577f, (float16_t)-0.610382806f,
    (float16_t)0.788346428f, (float16_t)-0.615231591f,
    (float16_t)0.784556597f, (float16_t)-0.620057212f,
    (float16_t)0.780737229f, (float16_t)-0.624859488f,
    (float16_t)0.776888466f, (float16_t)-0.629638239f,
    (float16_t)0.773010453f, (float16_t)-0.634393284f,
    (float16_t)0.769103338f, (float16_t)-0.639124445f,
    (float16_t)0.765167266f, (float16_t)-0.643831543f,
    (float16_t)0.761202385f, (float16_t)-0.648514401f,
    (float16_t)0.757208847f, (float16_t)-0.653172843f,
    (float16_t)0.753186799f, (float16_t)-0.657806693f,
    (float16_t)0.749136395f, (float16_t)-0.662415778f,
    (float16_t)0.745057785f, (float16_t)-0.666999922f,
    (float16_t)0.740951125f, (float16_t)-0.671558955f,
    (float16_t)0.736816569f, (float16_t)-0.676092704f,
    (float16_t)0.732654272f, (float16_t)-0.680600998f,
    (float16_t)0.728464390f, (float16_t)-0.685083668f,
    (float16_t)0.724247083f, (float16_t)-0.689540545f,
    (float16_t)0.720002508f, (float16_t)-0.693971461f,
    (float16_t)0.715730825f, (float16_t)-0.698376249f,
    (float16_t)0.711432196f, (float16_t)-0.702754744f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.702754744f, (float16_t)-0.711432196f,
    (float16_t)0.698376249f, (float16_t)-0.715730825f,
    (float16_t)0.693971461f, (float16_t)-0.720002508f,
    (float16_t)0.689540545f, (float16_t)-0.724247083f,
    (float16_t)0.685083668f, (float16_t)-0.728464390f,
    (float16_t)0.680600998f, (float16_t)-0.732654272f,
    (float16_t)0.676092704f, (float16_t)-0.736816569f,
    (float16_t)0.671558955f, (float16_t)-0.740951125f,
    (float16_t)0.666999922f, (float16_t)-0.745057785f,
    (float16_t)0.662415778f, (float16_t)-0.749136395f,
    (float16_t)0.657806693f, (float16_t)-0.753186799f,
    (float16_t)0.653172843f, (float16_t)-0.757208847f,
    (float16_t)0.648514401f, (float16_t)-0.761202385f,
    (float16_t)0.643831543f, (float16_t)-0.765167266f,
    (float16_t)0.639124445f, (float16_t)-0.769103338f,
    (float16_t)0.634393284f, (float16_t)-0.773010453f,
    (float16_t)0.629638239f, (float16_t)-0.776888466f,
    (float16_t)0.624859488f, (float16_t)-0.780737229f,
    (float16_t)0.620057212f, (float16_t)-0.784556597f,
    (float16_t)0.615231591f, (float16_t)-0.788346428f,
    (float16_t)0.610382806f, (float16_t)-0.792106577f,
    (float16_t)0.605511041f, (float16_t)-0.795836905f,
    (float16_t)0.600616479f, (float16_t)-0.799537269f,
    (float16_t)0.595699304f, (float16_t)-0.803207531f,
    (float16_t)0.590759702f, (float16_t)-0.806847554f,
    (float16_t)0.585797857f, (float16_t)-0.810457198f,
    (float16_t)0.580813958f, (float16_t)-0.814036330f,
    (float16_t)0.575808191f, (float16_t)-0.817584813f,
    (float16_t)0.570780746f, (float16_t)-0.821102515f,
    (float16_t)0.565731811f, (float16_t)-0.824589303f,
    (float16_t)0.560661576f, (float16_t)-0.828045045f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.550457973f, (float16_t)-0.834862875f,
    (float16_t)0.545324988f, (float16_t)-0.838224706f,
    (float16_t)0.540171473f, (float16_t)-0.841554977f,
    (float16_t)0.534997620f, (float16_t)-0.844853565f,
    (float16_t)0.529803625f, (float16_t)-0.848120345f,
    (float16_t)0.524589683f, (float16_t)-0.851355193f,
    (float16_t)0.519355990f, (float16_t)-0.854557988f,
    (float16_t)0.514102744f, (float16_t)-0.857728610f,
    (float16_t)0.508830143f, (float16_t)-0.860866939f,
    (float16_t)0.503538384f, (float16_t)-0.863972856f,
    (float16_t)0.498227667f, (float16_t)-0.867046246f,
    (float16_t)0.492898192f, (float16_t)-0.870086991f,
    (float16_t)0.487550160f, (float16_t)-0.873094978f,
    (float16_t)0.482183772f, (float16_t)-0.876070094f,
    (float16_t)0.476799230f, (float16_t)-0.879012226f,
    (float16_t)0.471396737f, (float16_t)-0.881921264f,
    (float16_t)0.465976496f, (float16_t)-0.884797098f,
    (float16_t)0.460538711f, (float16_t)-0.887639620f,
    (float16_t)0.455083587f, (float16_t)-0.890448723f,
    (float16_t)0.449611330f, (float16_t)-0.893224301f,
    (float16_t)0.444122145f, (float16_t)-0.895966250f,
    (float16_t)0.438616239f, (float16_t)-0.898674466f,
    (float16_t)0.433093819f, (float16_t)-0.901348847f,
    (float16_t)0.427555093f, (float16_t)-0.903989293f,
    (float16_t)0.422000271f, (float16_t)-0.906595705f,
    (float16_t)0.416429560f, (float16_t)-0.909167983f,
    (float16_t)0.410843171f, (float16_t)-0.911706032f,
    (float16_t)0.405241314f, (float16_t)-0.914209756f,
    (float16_t)0.399624200f, (float16_t)-0.916679060f,
    (float16_t)0.393992040f, (float16_t)-0.919113852f,
    (float16_t)0.388345047f, (float16_t)-0.921514039f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.377007410f, (float16_t)-0.926210242f,
    (float16_t)0.371317194f, (float16_t)-0.928506080f,
    (float16_t)0.365612998f, (float16_t)-0.930766961f,
    (float16_t)0.359895037f, (float16_t)-0.932992799f,
    (float16_t)0.354163525f, (float16_t)-0.935183510f,
    (float16_t)0.348418680f, (float16_t)-0.937339012f,
    (float16_t)0.342660717f, (float16_t)-0.939459224f,
    (float16_t)0.336889853f, (float16_t)-0.941544065f,
    (float16_t)0.331106306f, (float16_t)-0.943593458f,
    (float16_t)0.325310292f, (float16_t)-0.945607325f,
    (float16_t)0.319502031f, (float16_t)-0.947585591f,
    (float16_t)0.313681740f, (float16_t)-0.949528181f,
    (float16_t)0.307849640f, (float16_t)-0.951435021f,
    (float16_t)0.302005949f, (float16_t)-0.953306040f,
    (float16_t)0.296150888f, (float16_t)-0.955141168f,
    (float16_t)0.290284677f, (float16_t)-0.956940336f,
    (float16_t)0.284407537f, (float16_t)-0.958703475f,
    (float16_t)0.278519689f, (float16_t)-0.960430519f,
    (float16_t)0.272621355f, (float16_t)-0.962121404f,
    (float16_t)0.266712757f, (float16_t)-0.963776066f,
    (float16_t)0.260794118f, (float16_t)-0.965394442f,
    (float16_t)0.254865660f, (float16_t)-0.966976471f,
    (float16_t)0.248927606f, (float16_t)-0.968522094f,
    (float16_t)0.242980180f, (float16_t)-0.970031253f,
    (float16_t)0.237023606f, (float16_t)-0.971503891f,
    (float16_t)0.231058108f, (float16_t)-0.972939952f,
    (float16_t)0.225083911f, (float16_t)-0.974339383f,
    (float16_t)0.219101240f, (float16_t)-0.975702130f,
    (float16_t)0.213110320f, (float16_t)-0.977028143f,
    (float16_t)0.207111376f, (float16_t)-0.978317371f,
    (float16_t)0.201104635f, (float16_t)-0.979569766f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.189068664f, (float16_t)-0.981963869f,
    (float16_t)0.183039888f, (float16_t)-0.983105487f,
    (float16_t)0.177004220f, (float16_t)-0.984210092f,
    (float16_t)0.170961889f, (float16_t)-0.985277642f,
    (float16_t)0.164913120f, (float16_t)-0.986308097f,
    (float16_t)0.158858143f, (float16_t)-0.987301418f,
    (float16_t)0.152797185f, (float16_t)-0.988257568f,
    (float16_t)0.146730474f, (float16_t)-0.989176510f,
    (float16_t)0.140658239f, (float16_t)-0.990058210f,
    (float16_t)0.134580709f, (float16_t)-0.990902635f,
    (float16_t)0.128498111f, (float16_t)-0.991709754f,
    (float16_t)0.122410675f, (float16_t)-0.992479535f,
    (float16_t)0.116318631f, (float16_t)-0.993211949f,
    (float16_t)0.110222207f, (float16_t)-0.993906970f,
    (float16_t)0.104121634f, (float16_t)-0.994564571f,
    (float16_t)0.098017140f, (float16_t)-0.995184727f,
    (float16_t)0.091908956f, (float16_t)-0.995767414f,
    (float16_t)0.085797312f, (float16_t)-0.996312612f,
    (float16_t)0.079682438f, (float16_t)-0.996820299f,
    (float16_t)0.073564564f, (float16_t)-0.997290457f,
    (float16_t)0.067443920f, (float16_t)-0.997723067f,
    (float16_t)0.061320736f, (float16_t)-0.998118113f,
    (float16_t)0.055195244f, (float16_t)-0.998475581f,
    (float16_t)0.049067674f, (float16_t)-0.998795456f,
    (float16_t)0.042938257f, (float16_t)-0.999077728f,
    (float16_t)0.036807223f, (float16_t)-0.999322385f,
    (float16_t)0.030674803f, (float16_t)-0.999529418f,
    (float16_t)0.024541229f, (float16_t)-0.999698819f,
    (float16_t)0.018406730f, (float16_t)-0.999830582f,
    (float16_t)0.012271538f, (float16_t)-0.999924702f,
    (float16_t)0.006135885f, (float16_t)-0.999981175f
};
#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) */

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_RFFT_F16_2048)
const float16_t twiddleCoefF16_rfft_2048[2048] = {
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
    (float16_t)0.003067957f,  (float16_t)0.999995294f,
    (float16_t)0.006135885f,  (float16_t)0.999981175f,
    (float16_t)0.009203755f,  (float16_t)0.999957645f,
    (float16_t)0.012271538f,  (float16_t)0.999924702f,
    (float16_t)0.015339206f,  (float16_t)0.999882347f,
    (float16_t)0.018406730f,  (float16_t)0.999830582f,
    (float16_t)0.021474080f,  (float16_t)0.999769405f,
    (float16_t)0.024541229f,  (float16_t)0.999698819f,
    (float16_t)0.027608146f,  (float16_t)0.999618822f,
    (float16_t)0.030674803f,  (float16_t)0.999529418f,
    (float16_t)0.033741172f,  (float16_t)0.999430605f,
    (float16_t)0.036807223f,  (float16_t)0.999322385f,
    (float16_t)0.039872928f,  (float16_t)0.999204759f,
    (float16_t)0.042938257f,  (float16_t)0.999077728f,
    (float16_t)0.046003182f,  (float16_t)0.998941293f,
    (float16_t)0.049067674f,  (float16_t)0.998795456f,
    (float16_t)0.052131705f,  (float16_t)0.998640218f,
    (float16_t)0.055195244f,  (float16_t)0.998475581f,
    (float16_t)0.058258265f,  (float16_t)0.998301545f,
    (float16_t)0.061320736f,  (float16_t)0.998118113f,
    (float16_t)0.064382631f,  (float16_t)0.997925286f,
    (float16_t)0.067443920f,  (float16_t)0.997723067f,
    (float16_t)0.070504573f,  (float16_t)0.997511456f,
    (float16_t)0.073564564f,  (float16_t)0.997290457f,
    (float16_t)0.076623861f,  (float16_t)0.997060070f,
    (float16_t)0.079682438f,  (float16_t)0.996820299f,
    (float16_t)0.082740265f,  (float16_t)0.996571146f,
    (float16_t)0.085797312f,  (float16_t)0.996312612f,
    (float16_t)0.088853553f,  (float16_t)0.996044701f,
    (float16_t)0.091908956f,  (float16_t)0.995767414f,
    (float16_t)0.094963495f,  (float16_t)0.995480755f,
    (float16_t)0.098017140f,  (float16_t)0.995184727f,
    (float16_t)0.101069863f,  (float16_t)0.994879331f,
    (float16_t)0.104121634f,  (float16_t)0.994564571f,
    (float16_t)0.107172425f,  (float16_t)0.994240449f,
    (float16_t)0.110222207f,  (float16_t)0.993906970f,
    (float16_t)0.113270952f,  (float16_t)0.993564136f,
    (float16_t)0.116318631f,  (float16_t)0.993211949f,
    (float16_t)0.119365215f,  (float16_t)0.992850414f,
    (float16_t)0.122410675f,  (float16_t)0.992479535f,
    (float16_t)0.125454983f,  (float16_t)0.992099313f,
    (float16_t)0.128498111f,  (float16_t)0.991709754f,
    (float16_t)0.131540029f,  (float16_t)0.991310860f,
    (float16_t)0.134580709f,  (float16_t)0.990902635f,
    (float16_t)0.137620122f,  (float16_t)0.990485084f,
    (float16_t)0.140658239f,  (float16_t)0.990058210f,
    (float16_t)0.143695033f,  (float16_t)0.989622017f,
    (float16_t)0.146730474f,  (float16_t)0.989176510f,
    (float16_t)0.149764535f,  (float16_t)0.988721692f,
    (float16_t)0.152797185f,  (float16_t)0.988257568f,
    (float16_t)0.155828398f,  (float16_t)0.987784142f,
    (float16_t)0.158858143f,  (float16_t)0.987301418f,
    (float16_t)0.161886394f,  (float16_t)0.986809402f,
    (float16_t)0.164913120f,  (float16_t)0.986308097f,
    (float16_t)0.167938295f,  (float16_t)0.985797509f,
    (float16_t)0.170961889f,  (float16_t)0.985277642f,
    (float16_t)0.173983873f,  (float16_t)0.984748502f,
    (float16_t)0.177004220f,  (float16_t)0.984210092f,
    (float16_t)0.180022901f,  (float16_t)0.983662419f,
    (float16_t)0.183039888f,  (float16_t)0.983105487f,
    (float16_t)0.186055152f,  (float16_t)0.982539302f,
    (float16_t)0.189068664f,  (float16_t)0.981963869f,
    (float16_t)0.192080397f,  (float16_t)0.981379193f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.198098411f,  (float16_t)0.980182136f,
    (float16_t)0.201104635f,  (float16_t)0.979569766f,
    (float16_t)0.204108966f,  (float16_t)0.978948175f,
    (float16_t)0.207111376f,  (float16_t)0.978317371f,
    (float16_t)0.210111837f,  (float16_t)0.977677358f,
    (float16_t)0.213110320f,  (float16_t)0.977028143f,
    (float16_t)0.216106797f,  (float16_t)0.976369731f,
    (float16_t)0.219101240f,  (float16_t)0.975702130f,
    (float16_t)0.222093621f,  (float16_t)0.975025345f,
    (float16_t)0.225083911f,  (float16_t)0.974339383f,
    (float16_t)0.228072083f,  (float16_t)0.973644250f,
    (float16_t)0.231058108f,  (float16_t)0.972939952f,
    (float16_t)0.234041959f,  (float16_t)0.972226497f,
    (float16_t)0.237023606f,  (float16_t)0.971503891f,
    (float16_t)0.240003022f,  (float16_t)0.970772141f,
    (float16_t)0.242980180f,  (float16_t)0.970031253f,
    (float16_t)0.245955050f,  (float16_t)0.969281235f,
    (float16_t)0.248927606f,  (float16_t)0.968522094f,
    (float16_t)0.251897818f,  (float16_t)0.967753837f,
    (float16_t)0.254865660f,  (float16_t)0.966976471f,
    (float16_t)0.257831102f,  (float16_t)0.966190003f,
    (float16_t)0.260794118f,  (float16_t)0.965394442f,
    (float16_t)0.263754679f,  (float16_t)0.964589793f,
    (float16_t)0.266712757f,  (float16_t)0.963776066f,
    (float16_t)0.269668326f,  (float16_t)0.962953267f,
    (float16_t)0.272621355f,  (float16_t)0.962121404f,
    (float16_t)0.275571819f,  (float16_t)0.961280486f,
    (float16_t)0.278519689f,  (float16_t)0.960430519f,
    (float16_t)0.281464938f,  (float16_t)0.959571513f,
    (float16_t)0.284407537f,  (float16_t)0.958703475f,
    (float16_t)0.287347460f,  (float16_t)0.957826413f,
    (float16_t)0.290284677f,  (float16_t)0.956940336f,
    (float16_t)0.293219163f,  (float16_t)0.956045251f,
    (float16_t)0.296150888f,  (float16_t)0.955141168f,
    (float16_t)0.299079826f,  (float16_t)0.954228095f,
    (float16_t)0.302005949f,  (float16_t)0.953306040f,
    (float16_t)0.304929230f,  (float16_t)0.952375013f,
    (float16_t)0.307849640f,  (float16_t)0.951435021f,
    (float16_t)0.310767153f,  (float16_t)0.950486074f,
    (float16_t)0.313681740f,  (float16_t)0.949528181f,
    (float16_t)0.316593376f,  (float16_t)0.948561350f,
    (float16_t)0.319502031f,  (float16_t)0.947585591f,
    (float16_t)0.322407679f,  (float16_t)0.946600913f,
    (float16_t)0.325310292f,  (float16_t)0.945607325f,
    (float16_t)0.328209844f,  (float16_t)0.944604837f,
    (float16_t)0.331106306f,  (float16_t)0.943593458f,
    (float16_t)0.333999651f,  (float16_t)0.942573198f,
    (float16_t)0.336889853f,  (float16_t)0.941544065f,
    (float16_t)0.339776884f,  (float16_t)0.940506071f,
    (float16_t)0.342660717f,  (float16_t)0.939459224f,
    (float16_t)0.345541325f,  (float16_t)0.938403534f,
    (float16_t)0.348418680f,  (float16_t)0.937339012f,
    (float16_t)0.351292756f,  (float16_t)0.936265667f,
    (float16_t)0.354163525f,  (float16_t)0.935183510f,
    (float16_t)0.357030961f,  (float16_t)0.934092550f,
    (float16_t)0.359895037f,  (float16_t)0.932992799f,
    (float16_t)0.362755724f,  (float16_t)0.931884266f,
    (float16_t)0.365612998f,  (float16_t)0.930766961f,
    (float16_t)0.368466830f,  (float16_t)0.929640896f,
    (float16_t)0.371317194f,  (float16_t)0.928506080f,
    (float16_t)0.374164063f,  (float16_t)0.927362526f,
    (float16_t)0.377007410f,  (float16_t)0.926210242f,
    (float16_t)0.379847209f,  (float16_t)0.925049241f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.385516054f,  (float16_t)0.922701128f,
    (float16_t)0.388345047f,  (float16_t)0.921514039f,
    (float16_t)0.391170384f,  (float16_t)0.920318277f,
    (float16_t)0.393992040f,  (float16_t)0.919113852f,
    (float16_t)0.396809987f,  (float16_t)0.917900776f,
    (float16_t)0.399624200f,  (float16_t)0.916679060f,
    (float16_t)0.402434651f,  (float16_t)0.915448716f,
    (float16_t)0.405241314f,  (float16_t)0.914209756f,
    (float16_t)0.408044163f,  (float16_t)0.912962190f,
    (float16_t)0.410843171f,  (float16_t)0.911706032f,
    (float16_t)0.413638312f,  (float16_t)0.910441292f,
    (float16_t)0.416429560f,  (float16_t)0.909167983f,
    (float16_t)0.419216888f,  (float16_t)0.907886116f,
    (float16_t)0.422000271f,  (float16_t)0.906595705f,
    (float16_t)0.424779681f,  (float16_t)0.905296759f,
    (float16_t)0.427555093f,  (float16_t)0.903989293f,
    (float16_t)0.430326481f,  (float16_t)0.902673318f,
    (float16_t)0.433093819f,  (float16_t)0.901348847f,
    (float16_t)0.435857080f,  (float16_t)0.900015892f,
    (float16_t)0.438616239f,  (float16_t)0.898674466f,
    (float16_t)0.441371269f,  (float16_t)0.897324581f,
    (float16_t)0.444122145f,  (float16_t)0.895966250f,
    (float16_t)0.446868840f,  (float16_t)0.894599486f,
    (float16_t)0.449611330f,  (float16_t)0.893224301f,
    (float16_t)0.452349587f,  (float16_t)0.891840709f,
    (float16_t)0.455083587f,  (float16_t)0.890448723f,
    (float16_t)0.457813304f,  (float16_t)0.889048356f,
    (float16_t)0.460538711f,  (float16_t)0.887639620f,
    (float16_t)0.463259784f,  (float16_t)0.886222530f,
    (float16_t)0.465976496f,  (float16_t)0.884797098f,
    (float16_t)0.468688822f,  (float16_t)0.883363339f,
    (float16_t)0.471396737f,  (float16_t)0.881921264f,
    (float16_t)0.474100215f,  (float16_t)0.880470889f,
    (float16_t)0.476799230f,  (float16_t)0.879012226f,
    (float16_t)0.479493758f,  (float16_t)0.877545290f,
    (float16_t)0.482183772f,  (float16_t)0.876070094f,
    (float16_t)0.484869248f,  (float16_t)0.874586652f,
    (float16_t)0.487550160f,  (float16_t)0.873094978f,
    (float16_t)0.490226483f,  (float16_t)0.871595087f,
    (float16_t)0.492898192f,  (float16_t)0.870086991f,
    (float16_t)0.495565262f,  (float16_t)0.868570706f,
    (float16_t)0.498227667f,  (float16_t)0.867046246f,
    (float16_t)0.500885383f,  (float16_t)0.865513624f,
    (float16_t)0.503538384f,  (float16_t)0.863972856f,
    (float16_t)0.506186645f,  (float16_t)0.862423956f,
    (float16_t)0.508830143f,  (float16_t)0.860866939f,
    (float16_t)0.511468850f,  (float16_t)0.859301818f,
    (float16_t)0.514102744f,  (float16_t)0.857728610f,
    (float16_t)0.516731799f,  (float16_t)0.856147328f,
    (float16_t)0.519355990f,  (float16_t)0.854557988f,
    (float16_t)0.521975293f,  (float16_t)0.852960605f,
    (float16_t)0.524589683f,  (float16_t)0.851355193f,
    (float16_t)0.527199135f,  (float16_t)0.849741768f,
    (float16_t)0.529803625f,  (float16_t)0.848120345f,
    (float16_t)0.532403128f,  (float16_t)0.846490939f,
    (float16_t)0.534997620f,  (float16_t)0.844853565f,
    (float16_t)0.537587076f,  (float16_t)0.843208240f,
    (float16_t)0.540171473f,  (float16_t)0.841554977f,
    (float16_t)0.542750785f,  (float16_t)0.839893794f,
    (float16_t)0.545324988f,  (float16_t)0.838224706f,
    (float16_t)0.547894059f,  (float16_t)0.836547727f,
    (float16_t)0.550457973f,  (float16_t)0.834862875f,
    (float16_t)0.553016706f,  (float16_t)0.833170165f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.558118531f,  (float16_t)0.829761234f,
    (float16_t)0.560661576f,  (float16_t)0.828045045f,
    (float16_t)0.563199344f,  (float16_t)0.826321063f,
    (float16_t)0.565731811f,  (float16_t)0.824589303f,
    (float16_t)0.568258953f,  (float16_t)0.822849781f,
    (float16_t)0.570780746f,  (float16_t)0.821102515f,
    (float16_t)0.573297167f,  (float16_t)0.819347520f,
    (float16_t)0.575808191f,  (float16_t)0.817584813f,
    (float16_t)0.578313796f,  (float16_t)0.815814411f,
    (float16_t)0.580813958f,  (float16_t)0.814036330f,
    (float16_t)0.583308653f,  (float16_t)0.812250587f,
    (float16_t)0.585797857f,  (float16_t)0.810457198f,
    (float16_t)0.588281548f,  (float16_t)0.808656182f,
    (float16_t)0.590759702f,  (float16_t)0.806847554f,
    (float16_t)0.593232295f,  (float16_t)0.805031331f,
    (float16_t)0.595699304f,  (float16_t)0.803207531f,
    (float16_t)0.598160707f,  (float16_t)0.801376172f,
    (float16_t)0.600616479f,  (float16_t)0.799537269f,
    (float16_t)0.603066599f,  (float16_t)0.797690841f,
    (float16_t)0.605511041f,  (float16_t)0.795836905f,
    (float16_t)0.607949785f,  (float16_t)0.793975478f,
    (float16_t)0.610382806f,  (float16_t)0.792106577f,
    (float16_t)0.612810082f,  (float16_t)0.790230221f,
    (float16_t)0.615231591f,  (float16_t)0.788346428f,
    (float16_t)0.617647308f,  (float16_t)0.786455214f,
    (float16_t)0.620057212f,  (float16_t)0.784556597f,
    (float16_t)0.622461279f,  (float16_t)0.782650596f,
    (float16_t)0.624859488f,  (float16_t)0.780737229f,
    (float16_t)0.627251815f,  (float16_t)0.778816512f,
    (float16_t)0.629638239f,  (float16_t)0.776888466f,
    (float16_t)0.632018736f,  (float16_t)0.774953107f,
    (float16_t)0.634393284f,  (float16_t)0.773010453f,
    (float16_t)0.636761861f,  (float16_t)0.771060524f,
    (float16_t)0.639124445f,  (float16_t)0.769103338f,
    (float16_t)0.641481013f,  (float16_t)0.767138912f,
    (float16_t)0.643831543f,  (float16_t)0.765167266f,
    (float16_t)0.646176013f,  (float16_t)0.763188417f,
    (float16_t)0.648514401f,  (float16_t)0.761202385f,
    (float16_t)0.650846685f,  (float16_t)0.759209189f,
    (float16_t)0.653172843f,  (float16_t)0.757208847f,
    (float16_t)0.655492853f,  (float16_t)0.755201377f,
    (float16_t)0.657806693f,  (float16_t)0.753186799f,
    (float16_t)0.660114342f,  (float16_t)0.751165132f,
    (float16_t)0.662415778f,  (float16_t)0.749136395f,
    (float16_t)0.664710978f,  (float16_t)0.747100606f,
    (float16_t)0.666999922f,  (float16_t)0.745057785f,
    (float16_t)0.669282588f,  (float16_t)0.743007952f,
    (float16_t)0.671558955f,  (float16_t)0.740951125f,
    (float16_t)0.673829000f,  (float16_t)0.738887324f,
    (float16_t)0.676092704f,  (float16_t)0.736816569f,
    (float16_t)0.678350043f,  (float16_t)0.734738878f,
    (float16_t)0.680600998f,  (float16_t)0.732654272f,
    (float16_t)0.682845546f,  (float16_t)0.730562769f,
    (float16_t)0.685083668f,  (float16_t)0.728464390f,
    (float16_t)0.687315341f,  (float16_t)0.726359155f,
    (float16_t)0.689540545f,  (float16_t)0.724247083f,
    (float16_t)0.691759258f,  (float16_t)0.722128194f,
    (float16_t)0.693971461f,  (float16_t)0.720002508f,
    (float16_t)0.696177131f,  (float16_t)0.717870045f,
    (float16_t)0.698376249f,  (float16_t)0.715730825f,
    (float16_t)0.700568794f,  (float16_t)0.713584869f,
    (float16_t)0.702754744f,  (float16_t)0.711432196f,
    (float16_t)0.704934080f,  (float16_t)0.709272826f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.709272826f,  (float16_t)0.704934080f,
    (float16_t)0.711432196f,  (float16_t)0.702754744f,
    (float16_t)0.713584869f,  (float16_t)0.700568794f,
    (float16_t)0.715730825f,  (float16_t)0.698376249f,
    (float16_t)0.717870045f,  (float16_t)0.696177131f,
    (float16_t)0.720002508f,  (float16_t)0.693971461f,
    (float16_t)0.722128194f,  (float16_t)0.691759258f,
    (float16_t)0.724247083f,  (float16_t)0.689540545f,
    (float16_t)0.726359155f,  (float16_t)0.687315341f,
    (float16_t)0.728464390f,  (float16_t)0.685083668f,
    (float16_t)0.730562769f,  (float16_t)0.682845546f,
    (float16_t)0.732654272f,  (float16_t)0.680600998f,
    (float16_t)0.734738878f,  (float16_t)0.678350043f,
    (float16_t)0.736816569f,  (float16_t)0.676092704f,
    (float16_t)0.738887324f,  (float16_t)0.673829000f,
    (float16_t)0.740951125f,  (float16_t)0.671558955f,
    (float16_t)0.743007952f,  (float16_t)0.669282588f,
    (float16_t)0.745057785f,  (float16_t)0.666999922f,
    (float16_t)0.747100606f,  (float16_t)0.664710978f,
    (float16_t)0.749136395f,  (float16_t)0.662415778f,
    (float16_t)0.751165132f,  (float16_t)0.660114342f,
    (float16_t)0.753186799f,  (float16_t)0.657806693f,
    (float16_t)0.755201377f,  (float16_t)0.655492853f,
    (float16_t)0.757208847f,  (float16_t)0.653172843f,
    (float16_t)0.759209189f,  (float16_t)0.650846685f,
    (float16_t)0.761202385f,  (float16_t)0.648514401f,
    (float16_t)0.763188417f,  (float16_t)0.646176013f,
    (float16_t)0.765167266f,  (float16_t)0.643831543f,
    (float16_t)0.767138912f,  (float16_t)0.641481013f,
    (float16_t)0.769103338f,  (float16_t)0.639124445f,
    (float16_t)0.771060524f,  (float16_t)0.636761861f,
    (float16_t)0.773010453f,  (float16_t)0.634393284f,
    (float16_t)0.774953107f,  (float16_t)0.632018736f,
    (float16_t)0.776888466f,  (float16_t)0.629638239f,
    (float16_t)0.778816512f,  (float16_t)0.627251815f,
    (float16_t)0.780737229f,  (float16_t)0.624859488f,
    (float16_t)0.782650596f,  (float16_t)0.622461279f,
    (float16_t)0.784556597f,  (float16_t)0.620057212f,
    (float16_t)0.786455214f,  (float16_t)0.617647308f,
    (float16_t)0.788346428f,  (float16_t)0.615231591f,
    (float16_t)0.790230221f,  (float16_t)0.612810082f,
    (float16_t)0.792106577f,  (float16_t)0.610382806f,
    (float16_t)0.793975478f,  (float16_t)0.607949785f,
    (float16_t)0.795836905f,  (float16_t)0.605511041f,
    (float16_t)0.797690841f,  (float16_t)0.603066599f,
    (float16_t)0.799537269f,  (float16_t)0.600616479f,
    (float16_t)0.801376172f,  (float16_t)0.598160707f,
    (float16_t)0.803207531f,  (float16_t)0.595699304f,
    (float16_t)0.805031331f,  (float16_t)0.593232295f,
    (float16_t)0.806847554f,  (float16_t)0.590759702f,
    (float16_t)0.808656182f,  (float16_t)0.588281548f,
    (float16_t)0.810457198f,  (float16_t)0.585797857f,
    (float16_t)0.812250587f,  (float16_t)0.583308653f,
    (float16_t)0.814036330f,  (float16_t)0.580813958f,
    (float16_t)0.815814411f,  (float16_t)0.578313796f,
    (float16_t)0.817584813f,  (float16_t)0.575808191f,
    (float16_t)0.819347520f,  (float16_t)0.573297167f,
    (float16_t)0.821102515f,  (float16_t)0.570780746f,
    (float16_t)0.822849781f,  (float16_t)0.568258953f,
    (float16_t)0.824589303f,  (float16_t)0.565731811f,
    (float16_t)0.826321063f,  (float16_t)0.563199344f,
    (float16_t)0.828045045f,  (float16_t)0.560661576f,
    (float16_t)0.829761234f,  (float16_t)0.558118531f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.833170165f,  (float16_t)0.553016706f,
    (float16_t)0.834862875f,  (float16_t)0.550457973f,
    (float16_t)0.836547727f,  (float16_t)0.547894059f,
    (float16_t)0.838224706f,  (float16_t)0.545324988f,
    (float16_t)0.839893794f,  (float16_t)0.542750785f,
    (float16_t)0.841554977f,  (float16_t)0.540171473f,
    (float16_t)0.843208240f,  (float16_t)0.537587076f,
    (float16_t)0.844853565f,  (float16_t)0.534997620f,
    (float16_t)0.846490939f,  (float16_t)0.532403128f,
    (float16_t)0.848120345f,  (float16_t)0.529803625f,
    (float16_t)0.849741768f,  (float16_t)0.527199135f,
    (float16_t)0.851355193f,  (float16_t)0.524589683f,
    (float16_t)0.852960605f,  (float16_t)0.521975293f,
    (float16_t)0.854557988f,  (float16_t)0.519355990f,
    (float16_t)0.856147328f,  (float16_t)0.516731799f,
    (float16_t)0.857728610f,  (float16_t)0.514102744f,
    (float16_t)0.859301818f,  (float16_t)0.511468850f,
    (float16_t)0.860866939f,  (float16_t)0.508830143f,
    (float16_t)0.862423956f,  (float16_t)0.506186645f,
    (float16_t)0.863972856f,  (float16_t)0.503538384f,
    (float16_t)0.865513624f,  (float16_t)0.500885383f,
    (float16_t)0.867046246f,  (float16_t)0.498227667f,
    (float16_t)0.868570706f,  (float16_t)0.495565262f,
    (float16_t)0.870086991f,  (float16_t)0.492898192f,
    (float16_t)0.871595087f,  (float16_t)0.490226483f,
    (float16_t)0.873094978f,  (float16_t)0.487550160f,
    (float16_t)0.874586652f,  (float16_t)0.484869248f,
    (float16_t)0.876070094f,  (float16_t)0.482183772f,
    (float16_t)0.877545290f,  (float16_t)0.479493758f,
    (float16_t)0.879012226f,  (float16_t)0.476799230f,
    (float16_t)0.880470889f,  (float16_t)0.474100215f,
    (float16_t)0.881921264f,  (float16_t)0.471396737f,
    (float16_t)0.883363339f,  (float16_t)0.468688822f,
    (float16_t)0.884797098f,  (float16_t)0.465976496f,
    (float16_t)0.886222530f,  (float16_t)0.463259784f,
    (float16_t)0.887639620f,  (float16_t)0.460538711f,
    (float16_t)0.889048356f,  (float16_t)0.457813304f,
    (float16_t)0.890448723f,  (float16_t)0.455083587f,
    (float16_t)0.891840709f,  (float16_t)0.452349587f,
    (float16_t)0.893224301f,  (float16_t)0.449611330f,
    (float16_t)0.894599486f,  (float16_t)0.446868840f,
    (float16_t)0.895966250f,  (float16_t)0.444122145f,
    (float16_t)0.897324581f,  (float16_t)0.441371269f,
    (float16_t)0.898674466f,  (float16_t)0.438616239f,
    (float16_t)0.900015892f,  (float16_t)0.435857080f,
    (float16_t)0.901348847f,  (float16_t)0.433093819f,
    (float16_t)0.902673318f,  (float16_t)0.430326481f,
    (float16_t)0.903989293f,  (float16_t)0.427555093f,
    (float16_t)0.905296759f,  (float16_t)0.424779681f,
    (float16_t)0.906595705f,  (float16_t)0.422000271f,
    (float16_t)0.907886116f,  (float16_t)0.419216888f,
    (float16_t)0.909167983f,  (float16_t)0.416429560f,
    (float16_t)0.910441292f,  (float16_t)0.413638312f,
    (float16_t)0.911706032f,  (float16_t)0.410843171f,
    (float16_t)0.912962190f,  (float16_t)0.408044163f,
    (float16_t)0.914209756f,  (float16_t)0.405241314f,
    (float16_t)0.915448716f,  (float16_t)0.402434651f,
    (float16_t)0.916679060f,  (float16_t)0.399624200f,
    (float16_t)0.917900776f,  (float16_t)0.396809987f,
    (float16_t)0.919113852f,  (float16_t)0.393992040f,
    (float16_t)0.920318277f,  (float16_t)0.391170384f,
    (float16_t)0.921514039f,  (float16_t)0.388345047f,
    (float16_t)0.922701128f,  (float16_t)0.385516054f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.925049241f,  (float16_t)0.379847209f,
    (float16_t)0.926210242f,  (float16_t)0.377007410f,
    (float16_t)0.927362526f,  (float16_t)0.374164063f,
    (float16_t)0.928506080f,  (float16_t)0.371317194f,
    (float16_t)0.929640896f,  (float16_t)0.368466830f,
    (float16_t)0.930766961f,  (float16_t)0.365612998f,
    (float16_t)0.931884266f,  (float16_t)0.362755724f,
    (float16_t)0.932992799f,  (float16_t)0.359895037f,
    (float16_t)0.934092550f,  (float16_t)0.357030961f,
    (float16_t)0.935183510f,  (float16_t)0.354163525f,
    (float16_t)0.936265667f,  (float16_t)0.351292756f,
    (float16_t)0.937339012f,  (float16_t)0.348418680f,
    (float16_t)0.938403534f,  (float16_t)0.345541325f,
    (float16_t)0.939459224f,  (float16_t)0.342660717f,
    (float16_t)0.940506071f,  (float16_t)0.339776884f,
    (float16_t)0.941544065f,  (float16_t)0.336889853f,
    (float16_t)0.942573198f,  (float16_t)0.333999651f,
    (float16_t)0.943593458f,  (float16_t)0.331106306f,
    (float16_t)0.944604837f,  (float16_t)0.328209844f,
    (float16_t)0.945607325f,  (float16_t)0.325310292f,
    (float16_t)0.946600913f,  (float16_t)0.322407679f,
    (float16_t)0.947585591f,  (float16_t)0.319502031f,
    (float16_t)0.948561350f,  (float16_t)0.316593376f,
    (float16_t)0.949528181f,  (float16_t)0.313681740f,
    (float16_t)0.950486074f,  (float16_t)0.310767153f,
    (float16_t)0.951435021f,  (float16_t)0.307849640f,
    (float16_t)0.952375013f,  (float16_t)0.304929230f,
    (float16_t)0.953306040f,  (float16_t)0.302005949f,
    (float16_t)0.954228095f,  (float16_t)0.299079826f,
    (float16_t)0.955141168f,  (float16_t)0.296150888f,
    (float16_t)0.956045251f,  (float16_t)0.293219163f,
    (float16_t)0.956940336f,  (float16_t)0.290284677f,
    (float16_t)0.957826413f,  (float16_t)0.287347460f,
    (float16_t)0.958703475f,  (float16_t)0.284407537f,
    (float16_t)0.959571513f,  (float16_t)0.281464938f,
    (float16_t)0.960430519f,  (float16_t)0.278519689f,
    (float16_t)0.961280486f,  (float16_t)0.275571819f,
    (float16_t)0.962121404f,  (float16_t)0.272621355f,
    (float16_t)0.962953267f,  (float16_t)0.269668326f,
    (float16_t)0.963776066f,  (float16_t)0.266712757f,
    (float16_t)0.964589793f,  (float16_t)0.263754679f,
    (float16_t)0.965394442f,  (float16_t)0.260794118f,
    (float16_t)0.966190003f,  (float16_t)0.257831102f,
    (float16_t)0.966976471f,  (float16_t)0.254865660f,
    (float16_t)0.967753837f,  (float16_t)0.251897818f,
    (float16_t)0.968522094f,  (float16_t)0.248927606f,
    (float16_t)0.969281235f,  (float16_t)0.245955050f,
    (float16_t)0.970031253f,  (float16_t)0.242980180f,
    (float16_t)0.970772141f,  (float16_t)0.240003022f,
    (float16_t)0.971503891f,  (float16_t)0.237023606f,
    (float16_t)0.972226497f,  (float16_t)0.234041959f,
    (float16_t)0.972939952f,  (float16_t)0.231058108f,
    (float16_t)0.973644250f,  (float16_t)0.228072083f,
    (float16_t)0.974339383f,  (float16_t)0.225083911f,
    (float16_t)0.975025345f,  (float16_t)0.222093621f,
    (float16_t)0.975702130f,  (float16_t)0.219101240f,
    (float16_t)0.976369731f,  (float16_t)0.216106797f,
    (float16_t)0.977028143f,  (float16_t)0.213110320f,
    (float16_t)0.977677358f,  (float16_t)0.210111837f,
    (float16_t)0.978317371f,  (float16_t)0.207111376f,
    (float16_t)0.978948175f,  (float16_t)0.204108966f,
    (float16_t)0.979569766f,  (float16_t)0.201104635f,
    (float16_t)0.980182136f,  (float16_t)0.198098411f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.981379193f,  (float16_t)0.192080397f,
    (float16_t)0.981963869f,  (float16_t)0.189068664f,
    (float16_t)0.982539302f,  (float16_t)0.186055152f,
    (float16_t)0.983105487f,  (float16_t)0.183039888f,
    (float16_t)0.983662419f,  (float16_t)0.180022901f,
    (float16_t)0.984210092f,  (float16_t)0.177004220f,
    (float16_t)0.984748502f,  (float16_t)0.173983873f,
    (float16_t)0.985277642f,  (float16_t)0.170961889f,
    (float16_t)0.985797509f,  (float16_t)0.167938295f,
    (float16_t)0.986308097f,  (float16_t)0.164913120f,
    (float16_t)0.986809402f,  (float16_t)0.161886394f,
    (float16_t)0.987301418f,  (float16_t)0.158858143f,
    (float16_t)0.987784142f,  (float16_t)0.155828398f,
    (float16_t)0.988257568f,  (float16_t)0.152797185f,
    (float16_t)0.988721692f,  (float16_t)0.149764535f,
    (float16_t)0.989176510f,  (float16_t)0.146730474f,
    (float16_t)0.989622017f,  (float16_t)0.143695033f,
    (float16_t)0.990058210f,  (float16_t)0.140658239f,
    (float16_t)0.990485084f,  (float16_t)0.137620122f,
    (float16_t)0.990902635f,  (float16_t)0.134580709f,
    (float16_t)0.991310860f,  (float16_t)0.131540029f,
    (float16_t)0.991709754f,  (float16_t)0.128498111f,
    (float16_t)0.992099313f,  (float16_t)0.125454983f,
    (float16_t)0.992479535f,  (float16_t)0.122410675f,
    (float16_t)0.992850414f,  (float16_t)0.119365215f,
    (float16_t)0.993211949f,  (float16_t)0.116318631f,
    (float16_t)0.993564136f,  (float16_t)0.113270952f,
    (float16_t)0.993906970f,  (float16_t)0.110222207f,
    (float16_t)0.994240449f,  (float16_t)0.107172425f,
    (float16_t)0.994564571f,  (float16_t)0.104121634f,
    (float16_t)0.994879331f,  (float16_t)0.101069863f,
    (float16_t)0.995184727f,  (float16_t)0.098017140f,
    (float16_t)0.995480755f,  (float16_t)0.094963495f,
    (float16_t)0.995767414f,  (float16_t)0.091908956f,
    (float16_t)0.996044701f,  (float16_t)0.088853553f,
    (float16_t)0.996312612f,  (float16_t)0.085797312f,
    (float16_t)0.996571146f,  (float16_t)0.082740265f,
    (float16_t)0.996820299f,  (float16_t)0.079682438f,
    (float16_t)0.997060070f,  (float16_t)0.076623861f,
    (float16_t)0.997290457f,  (float16_t)0.073564564f,
    (float16_t)0.997511456f,  (float16_t)0.070504573f,
    (float16_t)0.997723067f,  (float16_t)0.067443920f,
    (float16_t)0.997925286f,  (float16_t)0.064382631f,
    (float16_t)0.998118113f,  (float16_t)0.061320736f,
    (float16_t)0.998301545f,  (float16_t)0.058258265f,
    (float16_t)0.998475581f,  (float16_t)0.055195244f,
    (float16_t)0.998640218f,  (float16_t)0.052131705f,
    (float16_t)0.998795456f,  (float16_t)0.049067674f,
    (float16_t)0.998941293f,  (float16_t)0.046003182f,
    (float16_t)0.999077728f,  (float16_t)0.042938257f,
    (float16_t)0.999204759f,  (float16_t)0.039872928f,
    (float16_t)0.999322385f,  (float16_t)0.036807223f,
    (float16_t)0.999430605f,  (float16_t)0.033741172f,
    (float16_t)0.999529418f,  (float16_t)0.030674803f,
    (float16_t)0.999618822f,  (float16_t)0.027608146f,
    (float16_t)0.999698819f,  (float16_t)0.024541229f,
    (float16_t)0.999769405f,  (float16_t)0.021474080f,
    (float16_t)0.999830582f,  (float16_t)0.018406730f,
    (float16_t)0.999882347f,  (float16_t)0.015339206f,
    (float16_t)0.999924702f,  (float16_t)0.012271538f,
    (float16_t)0.999957645f,  (float16_t)0.009203755f,
    (float16_t)0.999981175f,  (float16_t)0.006135885f,
    (float16_t)0.999995294f,  (float16_t)0.003067957f,
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.999995294f, (float16_t)-0.003067957f,
    (float16_t)0.999981175f, (float16_t)-0.006135885f,
    (float16_t)0.999957645f, (float16_t)-0.009203755f,
    (float16_t)0.999924702f, (float16_t)-0.012271538f,
    (float16_t)0.999882347f, (float16_t)-0.015339206f,
    (float16_t)0.999830582f, (float16_t)-0.018406730f,
    (float16_t)0.999769405f, (float16_t)-0.021474080f,
    (float16_t)0.999698819f, (float16_t)-0.024541229f,
    (float16_t)0.999618822f, (float16_t)-0.027608146f,
    (float16_t)0.999529418f, (float16_t)-0.030674803f,
    (float16_t)0.999430605f, (float16_t)-0.033741172f,
    (float16_t)0.999322385f, (float16_t)-0.036807223f,
    (float16_t)0.999204759f, (float16_t)-0.039872928f,
    (float16_t)0.999077728f, (float16_t)-0.042938257f,
    (float16_t)0.998941293f, (float16_t)-0.046003182f,
    (float16_t)0.998795456f, (float16_t)-0.049067674f,
    (float16_t)0.998640218f, (float16_t)-0.052131705f,
    (float16_t)0.998475581f, (float16_t)-0.055195244f,
    (float16_t)0.998301545f, (float16_t)-0.058258265f,
    (float16_t)0.998118113f, (float16_t)-0.061320736f,
    (float16_t)0.997925286f, (float16_t)-0.064382631f,
    (float16_t)0.997723067f, (float16_t)-0.067443920f,
    (float16_t)0.997511456f, (float16_t)-0.070504573f,
    (float16_t)0.997290457f, (float16_t)-0.073564564f,
    (float16_t)0.997060070f, (float16_t)-0.076623861f,
    (float16_t)0.996820299f, (float16_t)-0.079682438f,
    (float16_t)0.996571146f, (float16_t)-0.082740265f,
    (float16_t)0.996312612f, (float16_t)-0.085797312f,
    (float16_t)0.996044701f, (float16_t)-0.088853553f,
    (float16_t)0.995767414f, (float16_t)-0.091908956f,
    (float16_t)0.995480755f, (float16_t)-0.094963495f,
    (float16_t)0.995184727f, (float16_t)-0.098017140f,
    (float16_t)0.994879331f, (float16_t)-0.101069863f,
    (float16_t)0.994564571f, (float16_t)-0.104121634f,
    (float16_t)0.994240449f, (float16_t)-0.107172425f,
    (float16_t)0.993906970f, (float16_t)-0.110222207f,
    (float16_t)0.993564136f, (float16_t)-0.113270952f,
    (float16_t)0.993211949f, (float16_t)-0.116318631f,
    (float16_t)0.992850414f, (float16_t)-0.119365215f,
    (float16_t)0.992479535f, (float16_t)-0.122410675f,
    (float16_t)0.992099313f, (float16_t)-0.125454983f,
    (float16_t)0.991709754f, (float16_t)-0.128498111f,
    (float16_t)0.991310860f, (float16_t)-0.131540029f,
    (float16_t)0.990902635f, (float16_t)-0.134580709f,
    (float16_t)0.990485084f, (float16_t)-0.137620122f,
    (float16_t)0.990058210f, (float16_t)-0.140658239f,
    (float16_t)0.989622017f, (float16_t)-0.143695033f,
    (float16_t)0.989176510f, (float16_t)-0.146730474f,
    (float16_t)0.988721692f, (float16_t)-0.149764535f,
    (float16_t)0.988257568f, (float16_t)-0.152797185f,
    (float16_t)0.987784142f, (float16_t)-0.155828398f,
    (float16_t)0.987301418f, (float16_t)-0.158858143f,
    (float16_t)0.986809402f, (float16_t)-0.161886394f,
    (float16_t)0.986308097f, (float16_t)-0.164913120f,
    (float16_t)0.985797509f, (float16_t)-0.167938295f,
    (float16_t)0.985277642f, (float16_t)-0.170961889f,
    (float16_t)0.984748502f, (float16_t)-0.173983873f,
    (float16_t)0.984210092f, (float16_t)-0.177004220f,
    (float16_t)0.983662419f, (float16_t)-0.180022901f,
    (float16_t)0.983105487f, (float16_t)-0.183039888f,
    (float16_t)0.982539302f, (float16_t)-0.186055152f,
    (float16_t)0.981963869f, (float16_t)-0.189068664f,
    (float16_t)0.981379193f, (float16_t)-0.192080397f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.980182136f, (float16_t)-0.198098411f,
    (float16_t)0.979569766f, (float16_t)-0.201104635f,
    (float16_t)0.978948175f, (float16_t)-0.204108966f,
    (float16_t)0.978317371f, (float16_t)-0.207111376f,
    (float16_t)0.977677358f, (float16_t)-0.210111837f,
    (float16_t)0.977028143f, (float16_t)-0.213110320f,
    (float16_t)0.976369731f, (float16_t)-0.216106797f,
    (float16_t)0.975702130f, (float16_t)-0.219101240f,
    (float16_t)0.975025345f, (float16_t)-0.222093621f,
    (float16_t)0.974339383f, (float16_t)-0.225083911f,
    (float16_t)0.973644250f, (float16_t)-0.228072083f,
    (float16_t)0.972939952f, (float16_t)-0.231058108f,
    (float16_t)0.972226497f, (float16_t)-0.234041959f,
    (float16_t)0.971503891f, (float16_t)-0.237023606f,
    (float16_t)0.970772141f, (float16_t)-0.240003022f,
    (float16_t)0.970031253f, (float16_t)-0.242980180f,
    (float16_t)0.969281235f, (float16_t)-0.245955050f,
    (float16_t)0.968522094f, (float16_t)-0.248927606f,
    (float16_t)0.967753837f, (float16_t)-0.251897818f,
    (float16_t)0.966976471f, (float16_t)-0.254865660f,
    (float16_t)0.966190003f, (float16_t)-0.257831102f,
    (float16_t)0.965394442f, (float16_t)-0.260794118f,
    (float16_t)0.964589793f, (float16_t)-0.263754679f,
    (float16_t)0.963776066f, (float16_t)-0.266712757f,
    (float16_t)0.962953267f, (float16_t)-0.269668326f,
    (float16_t)0.962121404f, (float16_t)-0.272621355f,
    (float16_t)0.961280486f, (float16_t)-0.275571819f,
    (float16_t)0.960430519f, (float16_t)-0.278519689f,
    (float16_t)0.959571513f, (float16_t)-0.281464938f,
    (float16_t)0.958703475f, (float16_t)-0.284407537f,
    (float16_t)0.957826413f, (float16_t)-0.287347460f,
    (float16_t)0.956940336f, (float16_t)-0.290284677f,
    (float16_t)0.956045251f, (float16_t)-0.293219163f,
    (float16_t)0.955141168f, (float16_t)-0.296150888f,
    (float16_t)0.954228095f, (float16_t)-0.299079826f,
    (float16_t)0.953306040f, (float16_t)-0.302005949f,
    (float16_t)0.952375013f, (float16_t)-0.304929230f,
    (float16_t)0.951435021f, (float16_t)-0.307849640f,
    (float16_t)0.950486074f, (float16_t)-0.310767153f,
    (float16_t)0.949528181f, (float16_t)-0.313681740f,
    (float16_t)0.948561350f, (float16_t)-0.316593376f,
    (float16_t)0.947585591f, (float16_t)-0.319502031f,
    (float16_t)0.946600913f, (float16_t)-0.322407679f,
    (float16_t)0.945607325f, (float16_t)-0.325310292f,
    (float16_t)0.944604837f, (float16_t)-0.328209844f,
    (float16_t)0.943593458f, (float16_t)-0.331106306f,
    (float16_t)0.942573198f, (float16_t)-0.333999651f,
    (float16_t)0.941544065f, (float16_t)-0.336889853f,
    (float16_t)0.940506071f, (float16_t)-0.339776884f,
    (float16_t)0.939459224f, (float16_t)-0.342660717f,
    (float16_t)0.938403534f, (float16_t)-0.345541325f,
    (float16_t)0.937339012f, (float16_t)-0.348418680f,
    (float16_t)0.936265667f, (float16_t)-0.351292756f,
    (float16_t)0.935183510f, (float16_t)-0.354163525f,
    (float16_t)0.934092550f, (float16_t)-0.357030961f,
    (float16_t)0.932992799f, (float16_t)-0.359895037f,
    (float16_t)0.931884266f, (float16_t)-0.362755724f,
    (float16_t)0.930766961f, (float16_t)-0.365612998f,
    (float16_t)0.929640896f, (float16_t)-0.368466830f,
    (float16_t)0.928506080f, (float16_t)-0.371317194f,
    (float16_t)0.927362526f, (float16_t)-0.374164063f,
    (float16_t)0.926210242f, (float16_t)-0.377007410f,
    (float16_t)0.925049241f, (float16_t)-0.379847209f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.922701128f, (float16_t)-0.385516054f,
    (float16_t)0.921514039f, (float16_t)-0.388345047f,
    (float16_t)0.920318277f, (float16_t)-0.391170384f,
    (float16_t)0.919113852f, (float16_t)-0.393992040f,
    (float16_t)0.917900776f, (float16_t)-0.396809987f,
    (float16_t)0.916679060f, (float16_t)-0.399624200f,
    (float16_t)0.915448716f, (float16_t)-0.402434651f,
    (float16_t)0.914209756f, (float16_t)-0.405241314f,
    (float16_t)0.912962190f, (float16_t)-0.408044163f,
    (float16_t)0.911706032f, (float16_t)-0.410843171f,
    (float16_t)0.910441292f, (float16_t)-0.413638312f,
    (float16_t)0.909167983f, (float16_t)-0.416429560f,
    (float16_t)0.907886116f, (float16_t)-0.419216888f,
    (float16_t)0.906595705f, (float16_t)-0.422000271f,
    (float16_t)0.905296759f, (float16_t)-0.424779681f,
    (float16_t)0.903989293f, (float16_t)-0.427555093f,
    (float16_t)0.902673318f, (float16_t)-0.430326481f,
    (float16_t)0.901348847f, (float16_t)-0.433093819f,
    (float16_t)0.900015892f, (float16_t)-0.435857080f,
    (float16_t)0.898674466f, (float16_t)-0.438616239f,
    (float16_t)0.897324581f, (float16_t)-0.441371269f,
    (float16_t)0.895966250f, (float16_t)-0.444122145f,
    (float16_t)0.894599486f, (float16_t)-0.446868840f,
    (float16_t)0.893224301f, (float16_t)-0.449611330f,
    (float16_t)0.891840709f, (float16_t)-0.452349587f,
    (float16_t)0.890448723f, (float16_t)-0.455083587f,
    (float16_t)0.889048356f, (float16_t)-0.457813304f,
    (float16_t)0.887639620f, (float16_t)-0.460538711f,
    (float16_t)0.886222530f, (float16_t)-0.463259784f,
    (float16_t)0.884797098f, (float16_t)-0.465976496f,
    (float16_t)0.883363339f, (float16_t)-0.468688822f,
    (float16_t)0.881921264f, (float16_t)-0.471396737f,
    (float16_t)0.880470889f, (float16_t)-0.474100215f,
    (float16_t)0.879012226f, (float16_t)-0.476799230f,
    (float16_t)0.877545290f, (float16_t)-0.479493758f,
    (float16_t)0.876070094f, (float16_t)-0.482183772f,
    (float16_t)0.874586652f, (float16_t)-0.484869248f,
    (float16_t)0.873094978f, (float16_t)-0.487550160f,
    (float16_t)0.871595087f, (float16_t)-0.490226483f,
    (float16_t)0.870086991f, (float16_t)-0.492898192f,
    (float16_t)0.868570706f, (float16_t)-0.495565262f,
    (float16_t)0.867046246f, (float16_t)-0.498227667f,
    (float16_t)0.865513624f, (float16_t)-0.500885383f,
    (float16_t)0.863972856f, (float16_t)-0.503538384f,
    (float16_t)0.862423956f, (float16_t)-0.506186645f,
    (float16_t)0.860866939f, (float16_t)-0.508830143f,
    (float16_t)0.859301818f, (float16_t)-0.511468850f,
    (float16_t)0.857728610f, (float16_t)-0.514102744f,
    (float16_t)0.856147328f, (float16_t)-0.516731799f,
    (float16_t)0.854557988f, (float16_t)-0.519355990f,
    (float16_t)0.852960605f, (float16_t)-0.521975293f,
    (float16_t)0.851355193f, (float16_t)-0.524589683f,
    (float16_t)0.849741768f, (float16_t)-0.527199135f,
    (float16_t)0.848120345f, (float16_t)-0.529803625f,
    (float16_t)0.846490939f, (float16_t)-0.532403128f,
    (float16_t)0.844853565f, (float16_t)-0.534997620f,
    (float16_t)0.843208240f, (float16_t)-0.537587076f,
    (float16_t)0.841554977f, (float16_t)-0.540171473f,
    (float16_t)0.839893794f, (float16_t)-0.542750785f,
    (float16_t)0.838224706f, (float16_t)-0.545324988f,
    (float16_t)0.836547727f, (float16_t)-0.547894059f,
    (float16_t)0.834862875f, (float16_t)-0.550457973f,
    (float16_t)0.833170165f, (float16_t)-0.553016706f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.829761234f, (float16_t)-0.558118531f,
    (float16_t)0.828045045f, (float16_t)-0.560661576f,
    (float16_t)0.826321063f, (float16_t)-0.563199344f,
    (float16_t)0.824589303f, (float16_t)-0.565731811f,
    (float16_t)0.822849781f, (float16_t)-0.568258953f,
    (float16_t)0.821102515f, (float16_t)-0.570780746f,
    (float16_t)0.819347520f, (float16_t)-0.573297167f,
    (float16_t)0.817584813f, (float16_t)-0.575808191f,
    (float16_t)0.815814411f, (float16_t)-0.578313796f,
    (float16_t)0.814036330f, (float16_t)-0.580813958f,
    (float16_t)0.812250587f, (float16_t)-0.583308653f,
    (float16_t)0.810457198f, (float16_t)-0.585797857f,
    (float16_t)0.808656182f, (float16_t)-0.588281548f,
    (float16_t)0.806847554f, (float16_t)-0.590759702f,
    (float16_t)0.805031331f, (float16_t)-0.593232295f,
    (float16_t)0.803207531f, (float16_t)-0.595699304f,
    (float16_t)0.801376172f, (float16_t)-0.598160707f,
    (float16_t)0.799537269f, (float16_t)-0.600616479f,
    (float16_t)0.797690841f, (float16_t)-0.603066599f,
    (float16_t)0.795836905f, (float16_t)-0.605511041f,
    (float16_t)0.793975478f, (float16_t)-0.607949785f,
    (float16_t)0.792106577f, (float16_t)-0.610382806f,
    (float16_t)0.790230221f, (float16_t)-0.612810082f,
    (float16_t)0.788346428f, (float16_t)-0.615231591f,
    (float16_t)0.786455214f, (float16_t)-0.617647308f,
    (float16_t)0.784556597f, (float16_t)-0.620057212f,
    (float16_t)0.782650596f, (float16_t)-0.622461279f,
    (float16_t)0.780737229f, (float16_t)-0.624859488f,
    (float16_t)0.778816512f, (float16_t)-0.627251815f,
    (float16_t)0.776888466f, (float16_t)-0.629638239f,
    (float16_t)0.774953107f, (float16_t)-0.632018736f,
    (float16_t)0.773010453f, (float16_t)-0.634393284f,
    (float16_t)0.771060524f, (float16_t)-0.636761861f,
    (float16_t)0.769103338f, (float16_t)-0.639124445f,
    (float16_t)0.767138912f, (float16_t)-0.641481013f,
    (float16_t)0.765167266f, (float16_t)-0.643831543f,
    (float16_t)0.763188417f, (float16_t)-0.646176013f,
    (float16_t)0.761202385f, (float16_t)-0.648514401f,
    (float16_t)0.759209189f, (float16_t)-0.650846685f,
    (float16_t)0.757208847f, (float16_t)-0.653172843f,
    (float16_t)0.755201377f, (float16_t)-0.655492853f,
    (float16_t)0.753186799f, (float16_t)-0.657806693f,
    (float16_t)0.751165132f, (float16_t)-0.660114342f,
    (float16_t)0.749136395f, (float16_t)-0.662415778f,
    (float16_t)0.747100606f, (float16_t)-0.664710978f,
    (float16_t)0.745057785f, (float16_t)-0.666999922f,
    (float16_t)0.743007952f, (float16_t)-0.669282588f,
    (float16_t)0.740951125f, (float16_t)-0.671558955f,
    (float16_t)0.738887324f, (float16_t)-0.673829000f,
    (float16_t)0.736816569f, (float16_t)-0.676092704f,
    (float16_t)0.734738878f, (float16_t)-0.678350043f,
    (float16_t)0.732654272f, (float16_t)-0.680600998f,
    (float16_t)0.730562769f, (float16_t)-0.682845546f,
    (float16_t)0.728464390f, (float16_t)-0.685083668f,
    (float16_t)0.726359155f, (float16_t)-0.687315341f,
    (float16_t)0.724247083f, (float16_t)-0.689540545f,
    (float16_t)0.722128194f, (float16_t)-0.691759258f,
    (float16_t)0.720002508f, (float16_t)-0.693971461f,
    (float16_t)0.717870045f, (float16_t)-0.696177131f,
    (float16_t)0.715730825f, (float16_t)-0.698376249f,
    (float16_t)0.713584869f, (float16_t)-0.700568794f,
    (float16_t)0.711432196f, (float16_t)-0.702754744f,
    (float16_t)0.709272826f, (float16_t)-0.704934080f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.704934080f, (float16_t)-0.709272826f,
    (float16_t)0.702754744f, (float16_t)-0.711432196f,
    (float16_t)0.700568794f, (float16_t)-0.713584869f,
    (float16_t)0.698376249f, (float16_t)-0.715730825f,
    (float16_t)0.696177131f, (float16_t)-0.717870045f,
    (float16_t)0.693971461f, (float16_t)-0.720002508f,
    (float16_t)0.691759258f, (float16_t)-0.722128194f,
    (float16_t)0.689540545f, (float16_t)-0.724247083f,
    (float16_t)0.687315341f, (float16_t)-0.726359155f,
    (float16_t)0.685083668f, (float16_t)-0.728464390f,
    (float16_t)0.682845546f, (float16_t)-0.730562769f,
    (float16_t)0.680600998f, (float16_t)-0.732654272f,
    (float16_t)0.678350043f, (float16_t)-0.734738878f,
    (float16_t)0.676092704f, (float16_t)-0.736816569f,
    (float16_t)0.673829000f, (float16_t)-0.738887324f,
    (float16_t)0.671558955f, (float16_t)-0.740951125f,
    (float16_t)0.669282588f, (float16_t)-0.743007952f,
    (float16_t)0.666999922f, (float16_t)-0.745057785f,
    (float16_t)0.664710978f, (float16_t)-0.747100606f,
    (float16_t)0.662415778f, (float16_t)-0.749136395f,
    (float16_t)0.660114342f, (float16_t)-0.751165132f,
    (float16_t)0.657806693f, (float16_t)-0.753186799f,
    (float16_t)0.655492853f, (float16_t)-0.755201377f,
    (float16_t)0.653172843f, (float16_t)-0.757208847f,
    (float16_t)0.650846685f, (float16_t)-0.759209189f,
    (float16_t)0.648514401f, (float16_t)-0.761202385f,
    (float16_t)0.646176013f, (float16_t)-0.763188417f,
    (float16_t)0.643831543f, (float16_t)-0.765167266f,
    (float16_t)0.641481013f, (float16_t)-0.767138912f,
    (float16_t)0.639124445f, (float16_t)-0.769103338f,
    (float16_t)0.636761861f, (float16_t)-0.771060524f,
    (float16_t)0.634393284f, (float16_t)-0.773010453f,
    (float16_t)0.632018736f, (float16_t)-0.774953107f,
    (float16_t)0.629638239f, (float16_t)-0.776888466f,
    (float16_t)0.627251815f, (float16_t)-0.778816512f,
    (float16_t)0.624859488f, (float16_t)-0.780737229f,
    (float16_t)0.622461279f, (float16_t)-0.782650596f,
    (float16_t)0.620057212f, (float16_t)-0.784556597f,
    (float16_t)0.617647308f, (float16_t)-0.786455214f,
    (float16_t)0.615231591f, (float16_t)-0.788346428f,
    (float16_t)0.612810082f, (float16_t)-0.790230221f,
    (float16_t)0.610382806f, (float16_t)-0.792106577f,
    (float16_t)0.607949785f, (float16_t)-0.793975478f,
    (float16_t)0.605511041f, (float16_t)-0.795836905f,
    (float16_t)0.603066599f, (float16_t)-0.797690841f,
    (float16_t)0.600616479f, (float16_t)-0.799537269f,
    (float16_t)0.598160707f, (float16_t)-0.801376172f,
    (float16_t)0.595699304f, (float16_t)-0.803207531f,
    (float16_t)0.593232295f, (float16_t)-0.805031331f,
    (float16_t)0.590759702f, (float16_t)-0.806847554f,
    (float16_t)0.588281548f, (float16_t)-0.808656182f,
    (float16_t)0.585797857f, (float16_t)-0.810457198f,
    (float16_t)0.583308653f, (float16_t)-0.812250587f,
    (float16_t)0.580813958f, (float16_t)-0.814036330f,
    (float16_t)0.578313796f, (float16_t)-0.815814411f,
    (float16_t)0.575808191f, (float16_t)-0.817584813f,
    (float16_t)0.573297167f, (float16_t)-0.819347520f,
    (float16_t)0.570780746f, (float16_t)-0.821102515f,
    (float16_t)0.568258953f, (float16_t)-0.822849781f,
    (float16_t)0.565731811f, (float16_t)-0.824589303f,
    (float16_t)0.563199344f, (float16_t)-0.826321063f,
    (float16_t)0.560661576f, (float16_t)-0.828045045f,
    (float16_t)0.558118531f, (float16_t)-0.829761234f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.553016706f, (float16_t)-0.833170165f,
    (float16_t)0.550457973f, (float16_t)-0.834862875f,
    (float16_t)0.547894059f, (float16_t)-0.836547727f,
    (float16_t)0.545324988f, (float16_t)-0.838224706f,
    (float16_t)0.542750785f, (float16_t)-0.839893794f,
    (float16_t)0.540171473f, (float16_t)-0.841554977f,
    (float16_t)0.537587076f, (float16_t)-0.843208240f,
    (float16_t)0.534997620f, (float16_t)-0.844853565f,
    (float16_t)0.532403128f, (float16_t)-0.846490939f,
    (float16_t)0.529803625f, (float16_t)-0.848120345f,
    (float16_t)0.527199135f, (float16_t)-0.849741768f,
    (float16_t)0.524589683f, (float16_t)-0.851355193f,
    (float16_t)0.521975293f, (float16_t)-0.852960605f,
    (float16_t)0.519355990f, (float16_t)-0.854557988f,
    (float16_t)0.516731799f, (float16_t)-0.856147328f,
    (float16_t)0.514102744f, (float16_t)-0.857728610f,
    (float16_t)0.511468850f, (float16_t)-0.859301818f,
    (float16_t)0.508830143f, (float16_t)-0.860866939f,
    (float16_t)0.506186645f, (float16_t)-0.862423956f,
    (float16_t)0.503538384f, (float16_t)-0.863972856f,
    (float16_t)0.500885383f, (float16_t)-0.865513624f,
    (float16_t)0.498227667f, (float16_t)-0.867046246f,
    (float16_t)0.495565262f, (float16_t)-0.868570706f,
    (float16_t)0.492898192f, (float16_t)-0.870086991f,
    (float16_t)0.490226483f, (float16_t)-0.871595087f,
    (float16_t)0.487550160f, (float16_t)-0.873094978f,
    (float16_t)0.484869248f, (float16_t)-0.874586652f,
    (float16_t)0.482183772f, (float16_t)-0.876070094f,
    (float16_t)0.479493758f, (float16_t)-0.877545290f,
    (float16_t)0.476799230f, (float16_t)-0.879012226f,
    (float16_t)0.474100215f, (float16_t)-0.880470889f,
    (float16_t)0.471396737f, (float16_t)-0.881921264f,
    (float16_t)0.468688822f, (float16_t)-0.883363339f,
    (float16_t)0.465976496f, (float16_t)-0.884797098f,
    (float16_t)0.463259784f, (float16_t)-0.886222530f,
    (float16_t)0.460538711f, (float16_t)-0.887639620f,
    (float16_t)0.457813304f, (float16_t)-0.889048356f,
    (float16_t)0.455083587f, (float16_t)-0.890448723f,
    (float16_t)0.452349587f, (float16_t)-0.891840709f,
    (float16_t)0.449611330f, (float16_t)-0.893224301f,
    (float16_t)0.446868840f, (float16_t)-0.894599486f,
    (float16_t)0.444122145f, (float16_t)-0.895966250f,
    (float16_t)0.441371269f, (float16_t)-0.897324581f,
    (float16_t)0.438616239f, (float16_t)-0.898674466f,
    (float16_t)0.435857080f, (float16_t)-0.900015892f,
    (float16_t)0.433093819f, (float16_t)-0.901348847f,
    (float16_t)0.430326481f, (float16_t)-0.902673318f,
    (float16_t)0.427555093f, (float16_t)-0.903989293f,
    (float16_t)0.424779681f, (float16_t)-0.905296759f,
    (float16_t)0.422000271f, (float16_t)-0.906595705f,
    (float16_t)0.419216888f, (float16_t)-0.907886116f,
    (float16_t)0.416429560f, (float16_t)-0.909167983f,
    (float16_t)0.413638312f, (float16_t)-0.910441292f,
    (float16_t)0.410843171f, (float16_t)-0.911706032f,
    (float16_t)0.408044163f, (float16_t)-0.912962190f,
    (float16_t)0.405241314f, (float16_t)-0.914209756f,
    (float16_t)0.402434651f, (float16_t)-0.915448716f,
    (float16_t)0.399624200f, (float16_t)-0.916679060f,
    (float16_t)0.396809987f, (float16_t)-0.917900776f,
    (float16_t)0.393992040f, (float16_t)-0.919113852f,
    (float16_t)0.391170384f, (float16_t)-0.920318277f,
    (float16_t)0.388345047f, (float16_t)-0.921514039f,
    (float16_t)0.385516054f, (float16_t)-0.922701128f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.379847209f, (float16_t)-0.925049241f,
    (float16_t)0.377007410f, (float16_t)-0.926210242f,
    (float16_t)0.374164063f, (float16_t)-0.927362526f,
    (float16_t)0.371317194f, (float16_t)-0.928506080f,
    (float16_t)0.368466830f, (float16_t)-0.929640896f,
    (float16_t)0.365612998f, (float16_t)-0.930766961f,
    (float16_t)0.362755724f, (float16_t)-0.931884266f,
    (float16_t)0.359895037f, (float16_t)-0.932992799f,
    (float16_t)0.357030961f, (float16_t)-0.934092550f,
    (float16_t)0.354163525f, (float16_t)-0.935183510f,
    (float16_t)0.351292756f, (float16_t)-0.936265667f,
    (float16_t)0.348418680f, (float16_t)-0.937339012f,
    (float16_t)0.345541325f, (float16_t)-0.938403534f,
    (float16_t)0.342660717f, (float16_t)-0.939459224f,
    (float16_t)0.339776884f, (float16_t)-0.940506071f,
    (float16_t)0.336889853f, (float16_t)-0.941544065f,
    (float16_t)0.333999651f, (float16_t)-0.942573198f,
    (float16_t)0.331106306f, (float16_t)-0.943593458f,
    (float16_t)0.328209844f, (float16_t)-0.944604837f,
    (float16_t)0.325310292f, (float16_t)-0.945607325f,
    (float16_t)0.322407679f, (float16_t)-0.946600913f,
    (float16_t)0.319502031f, (float16_t)-0.947585591f,
    (float16_t)0.316593376f, (float16_t)-0.948561350f,
    (float16_t)0.313681740f, (float16_t)-0.949528181f,
    (float16_t)0.310767153f, (float16_t)-0.950486074f,
    (float16_t)0.307849640f, (float16_t)-0.951435021f,
    (float16_t)0.304929230f, (float16_t)-0.952375013f,
    (float16_t)0.302005949f, (float16_t)-0.953306040f,
    (float16_t)0.299079826f, (float16_t)-0.954228095f,
    (float16_t)0.296150888f, (float16_t)-0.955141168f,
    (float16_t)0.293219163f, (float16_t)-0.956045251f,
    (float16_t)0.290284677f, (float16_t)-0.956940336f,
    (float16_t)0.287347460f, (float16_t)-0.957826413f,
    (float16_t)0.284407537f, (float16_t)-0.958703475f,
    (float16_t)0.281464938f, (float16_t)-0.959571513f,
    (float16_t)0.278519689f, (float16_t)-0.960430519f,
    (float16_t)0.275571819f, (float16_t)-0.961280486f,
    (float16_t)0.272621355f, (float16_t)-0.962121404f,
    (float16_t)0.269668326f, (float16_t)-0.962953267f,
    (float16_t)0.266712757f, (float16_t)-0.963776066f,
    (float16_t)0.263754679f, (float16_t)-0.964589793f,
    (float16_t)0.260794118f, (float16_t)-0.965394442f,
    (float16_t)0.257831102f, (float16_t)-0.966190003f,
    (float16_t)0.254865660f, (float16_t)-0.966976471f,
    (float16_t)0.251897818f, (float16_t)-0.967753837f,
    (float16_t)0.248927606f, (float16_t)-0.968522094f,
    (float16_t)0.245955050f, (float16_t)-0.969281235f,
    (float16_t)0.242980180f, (float16_t)-0.970031253f,
    (float16_t)0.240003022f, (float16_t)-0.970772141f,
    (float16_t)0.237023606f, (float16_t)-0.971503891f,
    (float16_t)0.234041959f, (float16_t)-0.972226497f,
    (float16_t)0.231058108f, (float16_t)-0.972939952f,
    (float16_t)0.228072083f, (float16_t)-0.973644250f,
    (float16_t)0.225083911f, (float16_t)-0.974339383f,
    (float16_t)0.222093621f, (float16_t)-0.975025345f,
    (float16_t)0.219101240f, (float16_t)-0.975702130f,
    (float16_t)0.216106797f, (float16_t)-0.976369731f,
    (float16_t)0.213110320f, (float16_t)-0.977028143f,
    (float16_t)0.210111837f, (float16_t)-0.977677358f,
    (float16_t)0.207111376f, (float16_t)-0.978317371f,
    (float16_t)0.204108966f, (float16_t)-0.978948175f,
    (float16_t)0.201104635f, (float16_t)-0.979569766f,
    (float16_t)0.198098411f, (float16_t)-0.980182136f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.192080397f, (float16_t)-0.981379193f,
    (float16_t)0.189068664f, (float16_t)-0.981963869f,
    (float16_t)0.186055152f, (float16_t)-0.982539302f,
    (float16_t)0.183039888f, (float16_t)-0.983105487f,
    (float16_t)0.180022901f, (float16_t)-0.983662419f,
    (float16_t)0.177004220f, (float16_t)-0.984210092f,
    (float16_t)0.173983873f, (float16_t)-0.984748502f,
    (float16_t)0.170961889f, (float16_t)-0.985277642f,
    (float16_t)0.167938295f, (float16_t)-0.985797509f,
    (float16_t)0.164913120f, (float16_t)-0.986308097f,
    (float16_t)0.161886394f, (float16_t)-0.986809402f,
    (float16_t)0.158858143f, (float16_t)-0.987301418f,
    (float16_t)0.155828398f, (float16_t)-0.987784142f,
    (float16_t)0.152797185f, (float16_t)-0.988257568f,
    (float16_t)0.149764535f, (float16_t)-0.988721692f,
    (float16_t)0.146730474f, (float16_t)-0.989176510f,
    (float16_t)0.143695033f, (float16_t)-0.989622017f,
    (float16_t)0.140658239f, (float16_t)-0.990058210f,
    (float16_t)0.137620122f, (float16_t)-0.990485084f,
    (float16_t)0.134580709f, (float16_t)-0.990902635f,
    (float16_t)0.131540029f, (float16_t)-0.991310860f,
    (float16_t)0.128498111f, (float16_t)-0.991709754f,
    (float16_t)0.125454983f, (float16_t)-0.992099313f,
    (float16_t)0.122410675f, (float16_t)-0.992479535f,
    (float16_t)0.119365215f, (float16_t)-0.992850414f,
    (float16_t)0.116318631f, (float16_t)-0.993211949f,
    (float16_t)0.113270952f, (float16_t)-0.993564136f,
    (float16_t)0.110222207f, (float16_t)-0.993906970f,
    (float16_t)0.107172425f, (float16_t)-0.994240449f,
    (float16_t)0.104121634f, (float16_t)-0.994564571f,
    (float16_t)0.101069863f, (float16_t)-0.994879331f,
    (float16_t)0.098017140f, (float16_t)-0.995184727f,
    (float16_t)0.094963495f, (float16_t)-0.995480755f,
    (float16_t)0.091908956f, (float16_t)-0.995767414f,
    (float16_t)0.088853553f, (float16_t)-0.996044701f,
    (float16_t)0.085797312f, (float16_t)-0.996312612f,
    (float16_t)0.082740265f, (float16_t)-0.996571146f,
    (float16_t)0.079682438f, (float16_t)-0.996820299f,
    (float16_t)0.076623861f, (float16_t)-0.997060070f,
    (float16_t)0.073564564f, (float16_t)-0.997290457f,
    (float16_t)0.070504573f, (float16_t)-0.997511456f,
    (float16_t)0.067443920f, (float16_t)-0.997723067f,
    (float16_t)0.064382631f, (float16_t)-0.997925286f,
    (float16_t)0.061320736f, (float16_t)-0.998118113f,
    (float16_t)0.058258265f, (float16_t)-0.998301545f,
    (float16_t)0.055195244f, (float16_t)-0.998475581f,
    (float16_t)0.052131705f, (float16_t)-0.998640218f,
    (float16_t)0.049067674f, (float16_t)-0.998795456f,
    (float16_t)0.046003182f, (float16_t)-0.998941293f,
    (float16_t)0.042938257f, (float16_t)-0.999077728f,
    (float16_t)0.039872928f, (float16_t)-0.999204759f,
    (float16_t)0.036807223f, (float16_t)-0.999322385f,
    (float16_t)0.033741172f, (float16_t)-0.999430605f,
    (float16_t)0.030674803f, (float16_t)-0.999529418f,
    (float16_t)0.027608146f, (float16_t)-0.999618822f,
    (float16_t)0.024541229f, (float16_t)-0.999698819f,
    (float16_t)0.021474080f, (float16_t)-0.999769405f,
    (float16_t)0.018406730f, (float16_t)-0.999830582f,
    (float16_t)0.015339206f, (float16_t)-0.999882347f,
    (float16_t)0.012271538f, (float16_t)-0.999924702f,
    (float16_t)0.009203755f, (float16_t)-0.999957645f,
    (float16_t)0.006135885f, (float16_t)-0.999981175f,
    (float16_t)0.003067957f, (float16_t)-0.999995294f
};
#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) */

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_RFFT_F16_4096)
const float16_t twiddleCoefF16_rfft_4096[4096] = {
    (float16_t)0.000000000f,  (float16_t)1.000000000f,
    (float16_t)0.001533980f,  (float16_t)0.999998823f,
    (float16_t)0.003067957f,  (float16_t)0.999995294f,
    (float16_t)0.004601926f,  (float16_t)0.999989411f,
    (float16_t)0.006135885f,  (float16_t)0.999981175f,
    (float16_t)0.007669829f,  (float16_t)0.999970586f,
    (float16_t)0.009203755f,  (float16_t)0.999957645f,
    (float16_t)0.010737659f,  (float16_t)0.999942350f,
    (float16_t)0.012271538f,  (float16_t)0.999924702f,
    (float16_t)0.013805389f,  (float16_t)0.999904701f,
    (float16_t)0.015339206f,  (float16_t)0.999882347f,
    (float16_t)0.016872988f,  (float16_t)0.999857641f,
    (float16_t)0.018406730f,  (float16_t)0.999830582f,
    (float16_t)0.019940429f,  (float16_t)0.999801170f,
    (float16_t)0.021474080f,  (float16_t)0.999769405f,
    (float16_t)0.023007681f,  (float16_t)0.999735288f,
    (float16_t)0.024541229f,  (float16_t)0.999698819f,
    (float16_t)0.026074718f,  (float16_t)0.999659997f,
    (float16_t)0.027608146f,  (float16_t)0.999618822f,
    (float16_t)0.029141509f,  (float16_t)0.999575296f,
    (float16_t)0.030674803f,  (float16_t)0.999529418f,
    (float16_t)0.032208025f,  (float16_t)0.999481187f,
    (float16_t)0.033741172f,  (float16_t)0.999430605f,
    (float16_t)0.035274239f,  (float16_t)0.999377670f,
    (float16_t)0.036807223f,  (float16_t)0.999322385f,
    (float16_t)0.038340120f,  (float16_t)0.999264747f,
    (float16_t)0.039872928f,  (float16_t)0.999204759f,
    (float16_t)0.041405641f,  (float16_t)0.999142419f,
    (float16_t)0.042938257f,  (float16_t)0.999077728f,
    (float16_t)0.044470772f,  (float16_t)0.999010686f,
    (float16_t)0.046003182f,  (float16_t)0.998941293f,
    (float16_t)0.047535484f,  (float16_t)0.998869550f,
    (float16_t)0.049067674f,  (float16_t)0.998795456f,
    (float16_t)0.050599749f,  (float16_t)0.998719012f,
    (float16_t)0.052131705f,  (float16_t)0.998640218f,
    (float16_t)0.053663538f,  (float16_t)0.998559074f,
    (float16_t)0.055195244f,  (float16_t)0.998475581f,
    (float16_t)0.056726821f,  (float16_t)0.998389737f,
    (float16_t)0.058258265f,  (float16_t)0.998301545f,
    (float16_t)0.059789571f,  (float16_t)0.998211003f,
    (float16_t)0.061320736f,  (float16_t)0.998118113f,
    (float16_t)0.062851758f,  (float16_t)0.998022874f,
    (float16_t)0.064382631f,  (float16_t)0.997925286f,
    (float16_t)0.065913353f,  (float16_t)0.997825350f,
    (float16_t)0.067443920f,  (float16_t)0.997723067f,
    (float16_t)0.068974328f,  (float16_t)0.997618435f,
    (float16_t)0.070504573f,  (float16_t)0.997511456f,
    (float16_t)0.072034653f,  (float16_t)0.997402130f,
    (float16_t)0.073564564f,  (float16_t)0.997290457f,
    (float16_t)0.075094301f,  (float16_t)0.997176437f,
    (float16_t)0.076623861f,  (float16_t)0.997060070f,
    (float16_t)0.078153242f,  (float16_t)0.996941358f,
    (float16_t)0.079682438f,  (float16_t)0.996820299f,
    (float16_t)0.081211447f,  (float16_t)0.996696895f,
    (float16_t)0.082740265f,  (float16_t)0.996571146f,
    (float16_t)0.084268888f,  (float16_t)0.996443051f,
    (float16_t)0.085797312f,  (float16_t)0.996312612f,
    (float16_t)0.087325535f,  (float16_t)0.996179829f,
    (float16_t)0.088853553f,  (float16_t)0.996044701f,
    (float16_t)0.090381361f,  (float16_t)0.995907229f,
    (float16_t)0.091908956f,  (float16_t)0.995767414f,
    (float16_t)0.093436336f,  (float16_t)0.995625256f,
    (float16_t)0.094963495f,  (float16_t)0.995480755f,
    (float16_t)0.096490431f,  (float16_t)0.995333912f,
    (float16_t)0.098017140f,  (float16_t)0.995184727f,
    (float16_t)0.099543619f,  (float16_t)0.995033199f,
    (float16_t)0.101069863f,  (float16_t)0.994879331f,
    (float16_t)0.102595869f,  (float16_t)0.994723121f,
    (float16_t)0.104121634f,  (float16_t)0.994564571f,
    (float16_t)0.105647154f,  (float16_t)0.994403680f,
    (float16_t)0.107172425f,  (float16_t)0.994240449f,
    (float16_t)0.108697444f,  (float16_t)0.994074879f,
    (float16_t)0.110222207f,  (float16_t)0.993906970f,
    (float16_t)0.111746711f,  (float16_t)0.993736722f,
    (float16_t)0.113270952f,  (float16_t)0.993564136f,
    (float16_t)0.114794927f,  (float16_t)0.993389211f,
    (float16_t)0.116318631f,  (float16_t)0.993211949f,
    (float16_t)0.117842062f,  (float16_t)0.993032350f,
    (float16_t)0.119365215f,  (float16_t)0.992850414f,
    (float16_t)0.120888087f,  (float16_t)0.992666142f,
    (float16_t)0.122410675f,  (float16_t)0.992479535f,
    (float16_t)0.123932975f,  (float16_t)0.992290591f,
    (float16_t)0.125454983f,  (float16_t)0.992099313f,
    (float16_t)0.126976696f,  (float16_t)0.991905700f,
    (float16_t)0.128498111f,  (float16_t)0.991709754f,
    (float16_t)0.130019223f,  (float16_t)0.991511473f,
    (float16_t)0.131540029f,  (float16_t)0.991310860f,
    (float16_t)0.133060525f,  (float16_t)0.991107914f,
    (float16_t)0.134580709f,  (float16_t)0.990902635f,
    (float16_t)0.136100575f,  (float16_t)0.990695025f,
    (float16_t)0.137620122f,  (float16_t)0.990485084f,
    (float16_t)0.139139344f,  (float16_t)0.990272812f,
    (float16_t)0.140658239f,  (float16_t)0.990058210f,
    (float16_t)0.142176804f,  (float16_t)0.989841278f,
    (float16_t)0.143695033f,  (float16_t)0.989622017f,
    (float16_t)0.145212925f,  (float16_t)0.989400428f,
    (float16_t)0.146730474f,  (float16_t)0.989176510f,
    (float16_t)0.148247679f,  (float16_t)0.988950265f,
    (float16_t)0.149764535f,  (float16_t)0.988721692f,
    (float16_t)0.151281038f,  (float16_t)0.988490793f,
    (float16_t)0.152797185f,  (float16_t)0.988257568f,
    (float16_t)0.154312973f,  (float16_t)0.988022017f,
    (float16_t)0.155828398f,  (float16_t)0.987784142f,
    (float16_t)0.157343456f,  (float16_t)0.987543942f,
    (float16_t)0.158858143f,  (float16_t)0.987301418f,
    (float16_t)0.160372457f,  (float16_t)0.987056571f,
    (float16_t)0.161886394f,  (float16_t)0.986809402f,
    (float16_t)0.163399949f,  (float16_t)0.986559910f,
    (float16_t)0.164913120f,  (float16_t)0.986308097f,
    (float16_t)0.166425904f,  (float16_t)0.986053963f,
    (float16_t)0.167938295f,  (float16_t)0.985797509f,
    (float16_t)0.169450291f,  (float16_t)0.985538735f,
    (float16_t)0.170961889f,  (float16_t)0.985277642f,
    (float16_t)0.172473084f,  (float16_t)0.985014231f,
    (float16_t)0.173983873f,  (float16_t)0.984748502f,
    (float16_t)0.175494253f,  (float16_t)0.984480455f,
    (float16_t)0.177004220f,  (float16_t)0.984210092f,
    (float16_t)0.178513771f,  (float16_t)0.983937413f,
    (float16_t)0.180022901f,  (float16_t)0.983662419f,
    (float16_t)0.181531608f,  (float16_t)0.983385110f,
    (float16_t)0.183039888f,  (float16_t)0.983105487f,
    (float16_t)0.184547737f,  (float16_t)0.982823551f,
    (float16_t)0.186055152f,  (float16_t)0.982539302f,
    (float16_t)0.187562129f,  (float16_t)0.982252741f,
    (float16_t)0.189068664f,  (float16_t)0.981963869f,
    (float16_t)0.190574755f,  (float16_t)0.981672686f,
    (float16_t)0.192080397f,  (float16_t)0.981379193f,
    (float16_t)0.193585587f,  (float16_t)0.981083391f,
    (float16_t)0.195090322f,  (float16_t)0.980785280f,
    (float16_t)0.196594598f,  (float16_t)0.980484862f,
    (float16_t)0.198098411f,  (float16_t)0.980182136f,
    (float16_t)0.199601758f,  (float16_t)0.979877104f,
    (float16_t)0.201104635f,  (float16_t)0.979569766f,
    (float16_t)0.202607039f,  (float16_t)0.979260123f,
    (float16_t)0.204108966f,  (float16_t)0.978948175f,
    (float16_t)0.205610413f,  (float16_t)0.978633924f,
    (float16_t)0.207111376f,  (float16_t)0.978317371f,
    (float16_t)0.208611852f,  (float16_t)0.977998515f,
    (float16_t)0.210111837f,  (float16_t)0.977677358f,
    (float16_t)0.211611327f,  (float16_t)0.977353900f,
    (float16_t)0.213110320f,  (float16_t)0.977028143f,
    (float16_t)0.214608811f,  (float16_t)0.976700086f,
    (float16_t)0.216106797f,  (float16_t)0.976369731f,
    (float16_t)0.217604275f,  (float16_t)0.976037079f,
    (float16_t)0.219101240f,  (float16_t)0.975702130f,
    (float16_t)0.220597690f,  (float16_t)0.975364885f,
    (float16_t)0.222093621f,  (float16_t)0.975025345f,
    (float16_t)0.223589029f,  (float16_t)0.974683511f,
    (float16_t)0.225083911f,  (float16_t)0.974339383f,
    (float16_t)0.226578264f,  (float16_t)0.973992962f,
    (float16_t)0.228072083f,  (float16_t)0.973644250f,
    (float16_t)0.229565366f,  (float16_t)0.973293246f,
    (float16_t)0.231058108f,  (float16_t)0.972939952f,
    (float16_t)0.232550307f,  (float16_t)0.972584369f,
    (float16_t)0.234041959f,  (float16_t)0.972226497f,
    (float16_t)0.235533059f,  (float16_t)0.971866337f,
    (float16_t)0.237023606f,  (float16_t)0.971503891f,
    (float16_t)0.238513595f,  (float16_t)0.971139158f,
    (float16_t)0.240003022f,  (float16_t)0.970772141f,
    (float16_t)0.241491885f,  (float16_t)0.970402839f,
    (float16_t)0.242980180f,  (float16_t)0.970031253f,
    (float16_t)0.244467903f,  (float16_t)0.969657385f,
    (float16_t)0.245955050f,  (float16_t)0.969281235f,
    (float16_t)0.247441619f,  (float16_t)0.968902805f,
    (float16_t)0.248927606f,  (float16_t)0.968522094f,
    (float16_t)0.250413007f,  (float16_t)0.968139105f,
    (float16_t)0.251897818f,  (float16_t)0.967753837f,
    (float16_t)0.253382037f,  (float16_t)0.967366292f,
    (float16_t)0.254865660f,  (float16_t)0.966976471f,
    (float16_t)0.256348682f,  (float16_t)0.966584374f,
    (float16_t)0.257831102f,  (float16_t)0.966190003f,
    (float16_t)0.259312915f,  (float16_t)0.965793359f,
    (float16_t)0.260794118f,  (float16_t)0.965394442f,
    (float16_t)0.262274707f,  (float16_t)0.964993253f,
    (float16_t)0.263754679f,  (float16_t)0.964589793f,
    (float16_t)0.265234030f,  (float16_t)0.964184064f,
    (float16_t)0.266712757f,  (float16_t)0.963776066f,
    (float16_t)0.268190857f,  (float16_t)0.963365800f,
    (float16_t)0.269668326f,  (float16_t)0.962953267f,
    (float16_t)0.271145160f,  (float16_t)0.962538468f,
    (float16_t)0.272621355f,  (float16_t)0.962121404f,
    (float16_t)0.274096910f,  (float16_t)0.961702077f,
    (float16_t)0.275571819f,  (float16_t)0.961280486f,
    (float16_t)0.277046080f,  (float16_t)0.960856633f,
    (float16_t)0.278519689f,  (float16_t)0.960430519f,
    (float16_t)0.279992643f,  (float16_t)0.960002146f,
    (float16_t)0.281464938f,  (float16_t)0.959571513f,
    (float16_t)0.282936570f,  (float16_t)0.959138622f,
    (float16_t)0.284407537f,  (float16_t)0.958703475f,
    (float16_t)0.285877835f,  (float16_t)0.958266071f,
    (float16_t)0.287347460f,  (float16_t)0.957826413f,
    (float16_t)0.288816408f,  (float16_t)0.957384501f,
    (float16_t)0.290284677f,  (float16_t)0.956940336f,
    (float16_t)0.291752263f,  (float16_t)0.956493919f,
    (float16_t)0.293219163f,  (float16_t)0.956045251f,
    (float16_t)0.294685372f,  (float16_t)0.955594334f,
    (float16_t)0.296150888f,  (float16_t)0.955141168f,
    (float16_t)0.297615707f,  (float16_t)0.954685755f,
    (float16_t)0.299079826f,  (float16_t)0.954228095f,
    (float16_t)0.300543241f,  (float16_t)0.953768190f,
    (float16_t)0.302005949f,  (float16_t)0.953306040f,
    (float16_t)0.303467947f,  (float16_t)0.952841648f,
    (float16_t)0.304929230f,  (float16_t)0.952375013f,
    (float16_t)0.306389795f,  (float16_t)0.951906137f,
    (float16_t)0.307849640f,  (float16_t)0.951435021f,
    (float16_t)0.309308760f,  (float16_t)0.950961666f,
    (float16_t)0.310767153f,  (float16_t)0.950486074f,
    (float16_t)0.312224814f,  (float16_t)0.950008245f,
    (float16_t)0.313681740f,  (float16_t)0.949528181f,
    (float16_t)0.315137929f,  (float16_t)0.949045882f,
    (float16_t)0.316593376f,  (float16_t)0.948561350f,
    (float16_t)0.318048077f,  (float16_t)0.948074586f,
    (float16_t)0.319502031f,  (float16_t)0.947585591f,
    (float16_t)0.320955232f,  (float16_t)0.947094366f,
    (float16_t)0.322407679f,  (float16_t)0.946600913f,
    (float16_t)0.323859367f,  (float16_t)0.946105232f,
    (float16_t)0.325310292f,  (float16_t)0.945607325f,
    (float16_t)0.326760452f,  (float16_t)0.945107193f,
    (float16_t)0.328209844f,  (float16_t)0.944604837f,
    (float16_t)0.329658463f,  (float16_t)0.944100258f,
    (float16_t)0.331106306f,  (float16_t)0.943593458f,
    (float16_t)0.332553370f,  (float16_t)0.943084437f,
    (float16_t)0.333999651f,  (float16_t)0.942573198f,
    (float16_t)0.335445147f,  (float16_t)0.942059740f,
    (float16_t)0.336889853f,  (float16_t)0.941544065f,
    (float16_t)0.338333767f,  (float16_t)0.941026175f,
    (float16_t)0.339776884f,  (float16_t)0.940506071f,
    (float16_t)0.341219202f,  (float16_t)0.939983753f,
    (float16_t)0.342660717f,  (float16_t)0.939459224f,
    (float16_t)0.344101426f,  (float16_t)0.938932484f,
    (float16_t)0.345541325f,  (float16_t)0.938403534f,
    (float16_t)0.346980411f,  (float16_t)0.937872376f,
    (float16_t)0.348418680f,  (float16_t)0.937339012f,
    (float16_t)0.349856130f,  (float16_t)0.936803442f,
    (float16_t)0.351292756f,  (float16_t)0.936265667f,
    (float16_t)0.352728556f,  (float16_t)0.935725689f,
    (float16_t)0.354163525f,  (float16_t)0.935183510f,
    (float16_t)0.355597662f,  (float16_t)0.934639130f,
    (float16_t)0.357030961f,  (float16_t)0.934092550f,
    (float16_t)0.358463421f,  (float16_t)0.933543773f,
    (float16_t)0.359895037f,  (float16_t)0.932992799f,
    (float16_t)0.361325806f,  (float16_t)0.932439629f,
    (float16_t)0.362755724f,  (float16_t)0.931884266f,
    (float16_t)0.364184790f,  (float16_t)0.931326709f,
    (float16_t)0.365612998f,  (float16_t)0.930766961f,
    (float16_t)0.367040346f,  (float16_t)0.930205023f,
    (float16_t)0.368466830f,  (float16_t)0.929640896f,
    (float16_t)0.369892447f,  (float16_t)0.929074581f,
    (float16_t)0.371317194f,  (float16_t)0.928506080f,
    (float16_t)0.372741067f,  (float16_t)0.927935395f,
    (float16_t)0.374164063f,  (float16_t)0.927362526f,
    (float16_t)0.375586178f,  (float16_t)0.926787474f,
    (float16_t)0.377007410f,  (float16_t)0.926210242f,
    (float16_t)0.378427755f,  (float16_t)0.925630831f,
    (float16_t)0.379847209f,  (float16_t)0.925049241f,
    (float16_t)0.381265769f,  (float16_t)0.924465474f,
    (float16_t)0.382683432f,  (float16_t)0.923879533f,
    (float16_t)0.384100195f,  (float16_t)0.923291417f,
    (float16_t)0.385516054f,  (float16_t)0.922701128f,
    (float16_t)0.386931006f,  (float16_t)0.922108669f,
    (float16_t)0.388345047f,  (float16_t)0.921514039f,
    (float16_t)0.389758174f,  (float16_t)0.920917242f,
    (float16_t)0.391170384f,  (float16_t)0.920318277f,
    (float16_t)0.392581674f,  (float16_t)0.919717146f,
    (float16_t)0.393992040f,  (float16_t)0.919113852f,
    (float16_t)0.395401479f,  (float16_t)0.918508394f,
    (float16_t)0.396809987f,  (float16_t)0.917900776f,
    (float16_t)0.398217562f,  (float16_t)0.917290997f,
    (float16_t)0.399624200f,  (float16_t)0.916679060f,
    (float16_t)0.401029897f,  (float16_t)0.916064966f,
    (float16_t)0.402434651f,  (float16_t)0.915448716f,
    (float16_t)0.403838458f,  (float16_t)0.914830312f,
    (float16_t)0.405241314f,  (float16_t)0.914209756f,
    (float16_t)0.406643217f,  (float16_t)0.913587048f,
    (float16_t)0.408044163f,  (float16_t)0.912962190f,
    (float16_t)0.409444149f,  (float16_t)0.912335185f,
    (float16_t)0.410843171f,  (float16_t)0.911706032f,
    (float16_t)0.412241227f,  (float16_t)0.911074734f,
    (float16_t)0.413638312f,  (float16_t)0.910441292f,
    (float16_t)0.415034424f,  (float16_t)0.909805708f,
    (float16_t)0.416429560f,  (float16_t)0.909167983f,
    (float16_t)0.417823716f,  (float16_t)0.908528119f,
    (float16_t)0.419216888f,  (float16_t)0.907886116f,
    (float16_t)0.420609074f,  (float16_t)0.907241978f,
    (float16_t)0.422000271f,  (float16_t)0.906595705f,
    (float16_t)0.423390474f,  (float16_t)0.905947298f,
    (float16_t)0.424779681f,  (float16_t)0.905296759f,
    (float16_t)0.426167889f,  (float16_t)0.904644091f,
    (float16_t)0.427555093f,  (float16_t)0.903989293f,
    (float16_t)0.428941292f,  (float16_t)0.903332368f,
    (float16_t)0.430326481f,  (float16_t)0.902673318f,
    (float16_t)0.431710658f,  (float16_t)0.902012144f,
    (float16_t)0.433093819f,  (float16_t)0.901348847f,
    (float16_t)0.434475961f,  (float16_t)0.900683429f,
    (float16_t)0.435857080f,  (float16_t)0.900015892f,
    (float16_t)0.437237174f,  (float16_t)0.899346237f,
    (float16_t)0.438616239f,  (float16_t)0.898674466f,
    (float16_t)0.439994271f,  (float16_t)0.898000580f,
    (float16_t)0.441371269f,  (float16_t)0.897324581f,
    (float16_t)0.442747228f,  (float16_t)0.896646470f,
    (float16_t)0.444122145f,  (float16_t)0.895966250f,
    (float16_t)0.445496017f,  (float16_t)0.895283921f,
    (float16_t)0.446868840f,  (float16_t)0.894599486f,
    (float16_t)0.448240612f,  (float16_t)0.893912945f,
    (float16_t)0.449611330f,  (float16_t)0.893224301f,
    (float16_t)0.450980989f,  (float16_t)0.892533555f,
    (float16_t)0.452349587f,  (float16_t)0.891840709f,
    (float16_t)0.453717121f,  (float16_t)0.891145765f,
    (float16_t)0.455083587f,  (float16_t)0.890448723f,
    (float16_t)0.456448982f,  (float16_t)0.889749586f,
    (float16_t)0.457813304f,  (float16_t)0.889048356f,
    (float16_t)0.459176548f,  (float16_t)0.888345033f,
    (float16_t)0.460538711f,  (float16_t)0.887639620f,
    (float16_t)0.461899791f,  (float16_t)0.886932119f,
    (float16_t)0.463259784f,  (float16_t)0.886222530f,
    (float16_t)0.464618686f,  (float16_t)0.885510856f,
    (float16_t)0.465976496f,  (float16_t)0.884797098f,
    (float16_t)0.467333209f,  (float16_t)0.884081259f,
    (float16_t)0.468688822f,  (float16_t)0.883363339f,
    (float16_t)0.470043332f,  (float16_t)0.882643340f,
    (float16_t)0.471396737f,  (float16_t)0.881921264f,
    (float16_t)0.472749032f,  (float16_t)0.881197113f,
    (float16_t)0.474100215f,  (float16_t)0.880470889f,
    (float16_t)0.475450282f,  (float16_t)0.879742593f,
    (float16_t)0.476799230f,  (float16_t)0.879012226f,
    (float16_t)0.478147056f,  (float16_t)0.878279792f,
    (float16_t)0.479493758f,  (float16_t)0.877545290f,
    (float16_t)0.480839331f,  (float16_t)0.876808724f,
    (float16_t)0.482183772f,  (float16_t)0.876070094f,
    (float16_t)0.483527079f,  (float16_t)0.875329403f,
    (float16_t)0.484869248f,  (float16_t)0.874586652f,
    (float16_t)0.486210276f,  (float16_t)0.873841843f,
    (float16_t)0.487550160f,  (float16_t)0.873094978f,
    (float16_t)0.488888897f,  (float16_t)0.872346059f,
    (float16_t)0.490226483f,  (float16_t)0.871595087f,
    (float16_t)0.491562916f,  (float16_t)0.870842063f,
    (float16_t)0.492898192f,  (float16_t)0.870086991f,
    (float16_t)0.494232309f,  (float16_t)0.869329871f,
    (float16_t)0.495565262f,  (float16_t)0.868570706f,
    (float16_t)0.496897049f,  (float16_t)0.867809497f,
    (float16_t)0.498227667f,  (float16_t)0.867046246f,
    (float16_t)0.499557113f,  (float16_t)0.866280954f,
    (float16_t)0.500885383f,  (float16_t)0.865513624f,
    (float16_t)0.502212474f,  (float16_t)0.864744258f,
    (float16_t)0.503538384f,  (float16_t)0.863972856f,
    (float16_t)0.504863109f,  (float16_t)0.863199422f,
    (float16_t)0.506186645f,  (float16_t)0.862423956f,
    (float16_t)0.507508991f,  (float16_t)0.861646461f,
    (float16_t)0.508830143f,  (float16_t)0.860866939f,
    (float16_t)0.510150097f,  (float16_t)0.860085390f,
    (float16_t)0.511468850f,  (float16_t)0.859301818f,
    (float16_t)0.512786401f,  (float16_t)0.858516224f,
    (float16_t)0.514102744f,  (float16_t)0.857728610f,
    (float16_t)0.515417878f,  (float16_t)0.856938977f,
    (float16_t)0.516731799f,  (float16_t)0.856147328f,
    (float16_t)0.518044504f,  (float16_t)0.855353665f,
    (float16_t)0.519355990f,  (float16_t)0.854557988f,
    (float16_t)0.520666254f,  (float16_t)0.853760301f,
    (float16_t)0.521975293f,  (float16_t)0.852960605f,
    (float16_t)0.523283103f,  (float16_t)0.852158902f,
    (float16_t)0.524589683f,  (float16_t)0.851355193f,
    (float16_t)0.525895027f,  (float16_t)0.850549481f,
    (float16_t)0.527199135f,  (float16_t)0.849741768f,
    (float16_t)0.528502002f,  (float16_t)0.848932055f,
    (float16_t)0.529803625f,  (float16_t)0.848120345f,
    (float16_t)0.531104001f,  (float16_t)0.847306639f,
    (float16_t)0.532403128f,  (float16_t)0.846490939f,
    (float16_t)0.533701002f,  (float16_t)0.845673247f,
    (float16_t)0.534997620f,  (float16_t)0.844853565f,
    (float16_t)0.536292979f,  (float16_t)0.844031895f,
    (float16_t)0.537587076f,  (float16_t)0.843208240f,
    (float16_t)0.538879909f,  (float16_t)0.842382600f,
    (float16_t)0.540171473f,  (float16_t)0.841554977f,
    (float16_t)0.541461766f,  (float16_t)0.840725375f,
    (float16_t)0.542750785f,  (float16_t)0.839893794f,
    (float16_t)0.544038527f,  (float16_t)0.839060237f,
    (float16_t)0.545324988f,  (float16_t)0.838224706f,
    (float16_t)0.546610167f,  (float16_t)0.837387202f,
    (float16_t)0.547894059f,  (float16_t)0.836547727f,
    (float16_t)0.549176662f,  (float16_t)0.835706284f,
    (float16_t)0.550457973f,  (float16_t)0.834862875f,
    (float16_t)0.551737988f,  (float16_t)0.834017501f,
    (float16_t)0.553016706f,  (float16_t)0.833170165f,
    (float16_t)0.554294121f,  (float16_t)0.832320868f,
    (float16_t)0.555570233f,  (float16_t)0.831469612f,
    (float16_t)0.556845037f,  (float16_t)0.830616400f,
    (float16_t)0.558118531f,  (float16_t)0.829761234f,
    (float16_t)0.559390712f,  (float16_t)0.828904115f,
    (float16_t)0.560661576f,  (float16_t)0.828045045f,
    (float16_t)0.561931121f,  (float16_t)0.827184027f,
    (float16_t)0.563199344f,  (float16_t)0.826321063f,
    (float16_t)0.564466242f,  (float16_t)0.825456154f,
    (float16_t)0.565731811f,  (float16_t)0.824589303f,
    (float16_t)0.566996049f,  (float16_t)0.823720511f,
    (float16_t)0.568258953f,  (float16_t)0.822849781f,
    (float16_t)0.569520519f,  (float16_t)0.821977115f,
    (float16_t)0.570780746f,  (float16_t)0.821102515f,
    (float16_t)0.572039629f,  (float16_t)0.820225983f,
    (float16_t)0.573297167f,  (float16_t)0.819347520f,
    (float16_t)0.574553355f,  (float16_t)0.818467130f,
    (float16_t)0.575808191f,  (float16_t)0.817584813f,
    (float16_t)0.577061673f,  (float16_t)0.816700573f,
    (float16_t)0.578313796f,  (float16_t)0.815814411f,
    (float16_t)0.579564559f,  (float16_t)0.814926329f,
    (float16_t)0.580813958f,  (float16_t)0.814036330f,
    (float16_t)0.582061990f,  (float16_t)0.813144415f,
    (float16_t)0.583308653f,  (float16_t)0.812250587f,
    (float16_t)0.584553943f,  (float16_t)0.811354847f,
    (float16_t)0.585797857f,  (float16_t)0.810457198f,
    (float16_t)0.587040394f,  (float16_t)0.809557642f,
    (float16_t)0.588281548f,  (float16_t)0.808656182f,
    (float16_t)0.589521319f,  (float16_t)0.807752818f,
    (float16_t)0.590759702f,  (float16_t)0.806847554f,
    (float16_t)0.591996695f,  (float16_t)0.805940391f,
    (float16_t)0.593232295f,  (float16_t)0.805031331f,
    (float16_t)0.594466499f,  (float16_t)0.804120377f,
    (float16_t)0.595699304f,  (float16_t)0.803207531f,
    (float16_t)0.596930708f,  (float16_t)0.802292796f,
    (float16_t)0.598160707f,  (float16_t)0.801376172f,
    (float16_t)0.599389298f,  (float16_t)0.800457662f,
    (float16_t)0.600616479f,  (float16_t)0.799537269f,
    (float16_t)0.601842247f,  (float16_t)0.798614995f,
    (float16_t)0.603066599f,  (float16_t)0.797690841f,
    (float16_t)0.604289531f,  (float16_t)0.796764810f,
    (float16_t)0.605511041f,  (float16_t)0.795836905f,
    (float16_t)0.606731127f,  (float16_t)0.794907126f,
    (float16_t)0.607949785f,  (float16_t)0.793975478f,
    (float16_t)0.609167012f,  (float16_t)0.793041960f,
    (float16_t)0.610382806f,  (float16_t)0.792106577f,
    (float16_t)0.611597164f,  (float16_t)0.791169330f,
    (float16_t)0.612810082f,  (float16_t)0.790230221f,
    (float16_t)0.614021559f,  (float16_t)0.789289253f,
    (float16_t)0.615231591f,  (float16_t)0.788346428f,
    (float16_t)0.616440175f,  (float16_t)0.787401747f,
    (float16_t)0.617647308f,  (float16_t)0.786455214f,
    (float16_t)0.618852988f,  (float16_t)0.785506830f,
    (float16_t)0.620057212f,  (float16_t)0.784556597f,
    (float16_t)0.621259977f,  (float16_t)0.783604519f,
    (float16_t)0.622461279f,  (float16_t)0.782650596f,
    (float16_t)0.623661118f,  (float16_t)0.781694832f,
    (float16_t)0.624859488f,  (float16_t)0.780737229f,
    (float16_t)0.626056388f,  (float16_t)0.779777788f,
    (float16_t)0.627251815f,  (float16_t)0.778816512f,
    (float16_t)0.628445767f,  (float16_t)0.777853404f,
    (float16_t)0.629638239f,  (float16_t)0.776888466f,
    (float16_t)0.630829230f,  (float16_t)0.775921699f,
    (float16_t)0.632018736f,  (float16_t)0.774953107f,
    (float16_t)0.633206755f,  (float16_t)0.773982691f,
    (float16_t)0.634393284f,  (float16_t)0.773010453f,
    (float16_t)0.635578320f,  (float16_t)0.772036397f,
    (float16_t)0.636761861f,  (float16_t)0.771060524f,
    (float16_t)0.637943904f,  (float16_t)0.770082837f,
    (float16_t)0.639124445f,  (float16_t)0.769103338f,
    (float16_t)0.640303482f,  (float16_t)0.768122029f,
    (float16_t)0.641481013f,  (float16_t)0.767138912f,
    (float16_t)0.642657034f,  (float16_t)0.766153990f,
    (float16_t)0.643831543f,  (float16_t)0.765167266f,
    (float16_t)0.645004537f,  (float16_t)0.764178741f,
    (float16_t)0.646176013f,  (float16_t)0.763188417f,
    (float16_t)0.647345969f,  (float16_t)0.762196298f,
    (float16_t)0.648514401f,  (float16_t)0.761202385f,
    (float16_t)0.649681307f,  (float16_t)0.760206682f,
    (float16_t)0.650846685f,  (float16_t)0.759209189f,
    (float16_t)0.652010531f,  (float16_t)0.758209910f,
    (float16_t)0.653172843f,  (float16_t)0.757208847f,
    (float16_t)0.654333618f,  (float16_t)0.756206001f,
    (float16_t)0.655492853f,  (float16_t)0.755201377f,
    (float16_t)0.656650546f,  (float16_t)0.754194975f,
    (float16_t)0.657806693f,  (float16_t)0.753186799f,
    (float16_t)0.658961293f,  (float16_t)0.752176850f,
    (float16_t)0.660114342f,  (float16_t)0.751165132f,
    (float16_t)0.661265838f,  (float16_t)0.750151646f,
    (float16_t)0.662415778f,  (float16_t)0.749136395f,
    (float16_t)0.663564159f,  (float16_t)0.748119380f,
    (float16_t)0.664710978f,  (float16_t)0.747100606f,
    (float16_t)0.665856234f,  (float16_t)0.746080074f,
    (float16_t)0.666999922f,  (float16_t)0.745057785f,
    (float16_t)0.668142041f,  (float16_t)0.744033744f,
    (float16_t)0.669282588f,  (float16_t)0.743007952f,
    (float16_t)0.670421560f,  (float16_t)0.741980412f,
    (float16_t)0.671558955f,  (float16_t)0.740951125f,
    (float16_t)0.672694769f,  (float16_t)0.739920095f,
    (float16_t)0.673829000f,  (float16_t)0.738887324f,
    (float16_t)0.674961646f,  (float16_t)0.737852815f,
    (float16_t)0.676092704f,  (float16_t)0.736816569f,
    (float16_t)0.677222170f,  (float16_t)0.735778589f,
    (float16_t)0.678350043f,  (float16_t)0.734738878f,
    (float16_t)0.679476320f,  (float16_t)0.733697438f,
    (float16_t)0.680600998f,  (float16_t)0.732654272f,
    (float16_t)0.681724074f,  (float16_t)0.731609381f,
    (float16_t)0.682845546f,  (float16_t)0.730562769f,
    (float16_t)0.683965412f,  (float16_t)0.729514438f,
    (float16_t)0.685083668f,  (float16_t)0.728464390f,
    (float16_t)0.686200312f,  (float16_t)0.727412629f,
    (float16_t)0.687315341f,  (float16_t)0.726359155f,
    (float16_t)0.688428753f,  (float16_t)0.725303972f,
    (float16_t)0.689540545f,  (float16_t)0.724247083f,
    (float16_t)0.690650714f,  (float16_t)0.723188489f,
    (float16_t)0.691759258f,  (float16_t)0.722128194f,
    (float16_t)0.692866175f,  (float16_t)0.721066199f,
    (float16_t)0.693971461f,  (float16_t)0.720002508f,
    (float16_t)0.695075114f,  (float16_t)0.718937122f,
    (float16_t)0.696177131f,  (float16_t)0.717870045f,
    (float16_t)0.697277511f,  (float16_t)0.716801279f,
    (float16_t)0.698376249f,  (float16_t)0.715730825f,
    (float16_t)0.699473345f,  (float16_t)0.714658688f,
    (float16_t)0.700568794f,  (float16_t)0.713584869f,
    (float16_t)0.701662595f,  (float16_t)0.712509371f,
    (float16_t)0.702754744f,  (float16_t)0.711432196f,
    (float16_t)0.703845241f,  (float16_t)0.710353347f,
    (float16_t)0.704934080f,  (float16_t)0.709272826f,
    (float16_t)0.706021261f,  (float16_t)0.708190637f,
    (float16_t)0.707106781f,  (float16_t)0.707106781f,
    (float16_t)0.708190637f,  (float16_t)0.706021261f,
    (float16_t)0.709272826f,  (float16_t)0.704934080f,
    (float16_t)0.710353347f,  (float16_t)0.703845241f,
    (float16_t)0.711432196f,  (float16_t)0.702754744f,
    (float16_t)0.712509371f,  (float16_t)0.701662595f,
    (float16_t)0.713584869f,  (float16_t)0.700568794f,
    (float16_t)0.714658688f,  (float16_t)0.699473345f,
    (float16_t)0.715730825f,  (float16_t)0.698376249f,
    (float16_t)0.716801279f,  (float16_t)0.697277511f,
    (float16_t)0.717870045f,  (float16_t)0.696177131f,
    (float16_t)0.718937122f,  (float16_t)0.695075114f,
    (float16_t)0.720002508f,  (float16_t)0.693971461f,
    (float16_t)0.721066199f,  (float16_t)0.692866175f,
    (float16_t)0.722128194f,  (float16_t)0.691759258f,
    (float16_t)0.723188489f,  (float16_t)0.690650714f,
    (float16_t)0.724247083f,  (float16_t)0.689540545f,
    (float16_t)0.725303972f,  (float16_t)0.688428753f,
    (float16_t)0.726359155f,  (float16_t)0.687315341f,
    (float16_t)0.727412629f,  (float16_t)0.686200312f,
    (float16_t)0.728464390f,  (float16_t)0.685083668f,
    (float16_t)0.729514438f,  (float16_t)0.683965412f,
    (float16_t)0.730562769f,  (float16_t)0.682845546f,
    (float16_t)0.731609381f,  (float16_t)0.681724074f,
    (float16_t)0.732654272f,  (float16_t)0.680600998f,
    (float16_t)0.733697438f,  (float16_t)0.679476320f,
    (float16_t)0.734738878f,  (float16_t)0.678350043f,
    (float16_t)0.735778589f,  (float16_t)0.677222170f,
    (float16_t)0.736816569f,  (float16_t)0.676092704f,
    (float16_t)0.737852815f,  (float16_t)0.674961646f,
    (float16_t)0.738887324f,  (float16_t)0.673829000f,
    (float16_t)0.739920095f,  (float16_t)0.672694769f,
    (float16_t)0.740951125f,  (float16_t)0.671558955f,
    (float16_t)0.741980412f,  (float16_t)0.670421560f,
    (float16_t)0.743007952f,  (float16_t)0.669282588f,
    (float16_t)0.744033744f,  (float16_t)0.668142041f,
    (float16_t)0.745057785f,  (float16_t)0.666999922f,
    (float16_t)0.746080074f,  (float16_t)0.665856234f,
    (float16_t)0.747100606f,  (float16_t)0.664710978f,
    (float16_t)0.748119380f,  (float16_t)0.663564159f,
    (float16_t)0.749136395f,  (float16_t)0.662415778f,
    (float16_t)0.750151646f,  (float16_t)0.661265838f,
    (float16_t)0.751165132f,  (float16_t)0.660114342f,
    (float16_t)0.752176850f,  (float16_t)0.658961293f,
    (float16_t)0.753186799f,  (float16_t)0.657806693f,
    (float16_t)0.754194975f,  (float16_t)0.656650546f,
    (float16_t)0.755201377f,  (float16_t)0.655492853f,
    (float16_t)0.756206001f,  (float16_t)0.654333618f,
    (float16_t)0.757208847f,  (float16_t)0.653172843f,
    (float16_t)0.758209910f,  (float16_t)0.652010531f,
    (float16_t)0.759209189f,  (float16_t)0.650846685f,
    (float16_t)0.760206682f,  (float16_t)0.649681307f,
    (float16_t)0.761202385f,  (float16_t)0.648514401f,
    (float16_t)0.762196298f,  (float16_t)0.647345969f,
    (float16_t)0.763188417f,  (float16_t)0.646176013f,
    (float16_t)0.764178741f,  (float16_t)0.645004537f,
    (float16_t)0.765167266f,  (float16_t)0.643831543f,
    (float16_t)0.766153990f,  (float16_t)0.642657034f,
    (float16_t)0.767138912f,  (float16_t)0.641481013f,
    (float16_t)0.768122029f,  (float16_t)0.640303482f,
    (float16_t)0.769103338f,  (float16_t)0.639124445f,
    (float16_t)0.770082837f,  (float16_t)0.637943904f,
    (float16_t)0.771060524f,  (float16_t)0.636761861f,
    (float16_t)0.772036397f,  (float16_t)0.635578320f,
    (float16_t)0.773010453f,  (float16_t)0.634393284f,
    (float16_t)0.773982691f,  (float16_t)0.633206755f,
    (float16_t)0.774953107f,  (float16_t)0.632018736f,
    (float16_t)0.775921699f,  (float16_t)0.630829230f,
    (float16_t)0.776888466f,  (float16_t)0.629638239f,
    (float16_t)0.777853404f,  (float16_t)0.628445767f,
    (float16_t)0.778816512f,  (float16_t)0.627251815f,
    (float16_t)0.779777788f,  (float16_t)0.626056388f,
    (float16_t)0.780737229f,  (float16_t)0.624859488f,
    (float16_t)0.781694832f,  (float16_t)0.623661118f,
    (float16_t)0.782650596f,  (float16_t)0.622461279f,
    (float16_t)0.783604519f,  (float16_t)0.621259977f,
    (float16_t)0.784556597f,  (float16_t)0.620057212f,
    (float16_t)0.785506830f,  (float16_t)0.618852988f,
    (float16_t)0.786455214f,  (float16_t)0.617647308f,
    (float16_t)0.787401747f,  (float16_t)0.616440175f,
    (float16_t)0.788346428f,  (float16_t)0.615231591f,
    (float16_t)0.789289253f,  (float16_t)0.614021559f,
    (float16_t)0.790230221f,  (float16_t)0.612810082f,
    (float16_t)0.791169330f,  (float16_t)0.611597164f,
    (float16_t)0.792106577f,  (float16_t)0.610382806f,
    (float16_t)0.793041960f,  (float16_t)0.609167012f,
    (float16_t)0.793975478f,  (float16_t)0.607949785f,
    (float16_t)0.794907126f,  (float16_t)0.606731127f,
    (float16_t)0.795836905f,  (float16_t)0.605511041f,
    (float16_t)0.796764810f,  (float16_t)0.604289531f,
    (float16_t)0.797690841f,  (float16_t)0.603066599f,
    (float16_t)0.798614995f,  (float16_t)0.601842247f,
    (float16_t)0.799537269f,  (float16_t)0.600616479f,
    (float16_t)0.800457662f,  (float16_t)0.599389298f,
    (float16_t)0.801376172f,  (float16_t)0.598160707f,
    (float16_t)0.802292796f,  (float16_t)0.596930708f,
    (float16_t)0.803207531f,  (float16_t)0.595699304f,
    (float16_t)0.804120377f,  (float16_t)0.594466499f,
    (float16_t)0.805031331f,  (float16_t)0.593232295f,
    (float16_t)0.805940391f,  (float16_t)0.591996695f,
    (float16_t)0.806847554f,  (float16_t)0.590759702f,
    (float16_t)0.807752818f,  (float16_t)0.589521319f,
    (float16_t)0.808656182f,  (float16_t)0.588281548f,
    (float16_t)0.809557642f,  (float16_t)0.587040394f,
    (float16_t)0.810457198f,  (float16_t)0.585797857f,
    (float16_t)0.811354847f,  (float16_t)0.584553943f,
    (float16_t)0.812250587f,  (float16_t)0.583308653f,
    (float16_t)0.813144415f,  (float16_t)0.582061990f,
    (float16_t)0.814036330f,  (float16_t)0.580813958f,
    (float16_t)0.814926329f,  (float16_t)0.579564559f,
    (float16_t)0.815814411f,  (float16_t)0.578313796f,
    (float16_t)0.816700573f,  (float16_t)0.577061673f,
    (float16_t)0.817584813f,  (float16_t)0.575808191f,
    (float16_t)0.818467130f,  (float16_t)0.574553355f,
    (float16_t)0.819347520f,  (float16_t)0.573297167f,
    (float16_t)0.820225983f,  (float16_t)0.572039629f,
    (float16_t)0.821102515f,  (float16_t)0.570780746f,
    (float16_t)0.821977115f,  (float16_t)0.569520519f,
    (float16_t)0.822849781f,  (float16_t)0.568258953f,
    (float16_t)0.823720511f,  (float16_t)0.566996049f,
    (float16_t)0.824589303f,  (float16_t)0.565731811f,
    (float16_t)0.825456154f,  (float16_t)0.564466242f,
    (float16_t)0.826321063f,  (float16_t)0.563199344f,
    (float16_t)0.827184027f,  (float16_t)0.561931121f,
    (float16_t)0.828045045f,  (float16_t)0.560661576f,
    (float16_t)0.828904115f,  (float16_t)0.559390712f,
    (float16_t)0.829761234f,  (float16_t)0.558118531f,
    (float16_t)0.830616400f,  (float16_t)0.556845037f,
    (float16_t)0.831469612f,  (float16_t)0.555570233f,
    (float16_t)0.832320868f,  (float16_t)0.554294121f,
    (float16_t)0.833170165f,  (float16_t)0.553016706f,
    (float16_t)0.834017501f,  (float16_t)0.551737988f,
    (float16_t)0.834862875f,  (float16_t)0.550457973f,
    (float16_t)0.835706284f,  (float16_t)0.549176662f,
    (float16_t)0.836547727f,  (float16_t)0.547894059f,
    (float16_t)0.837387202f,  (float16_t)0.546610167f,
    (float16_t)0.838224706f,  (float16_t)0.545324988f,
    (float16_t)0.839060237f,  (float16_t)0.544038527f,
    (float16_t)0.839893794f,  (float16_t)0.542750785f,
    (float16_t)0.840725375f,  (float16_t)0.541461766f,
    (float16_t)0.841554977f,  (float16_t)0.540171473f,
    (float16_t)0.842382600f,  (float16_t)0.538879909f,
    (float16_t)0.843208240f,  (float16_t)0.537587076f,
    (float16_t)0.844031895f,  (float16_t)0.536292979f,
    (float16_t)0.844853565f,  (float16_t)0.534997620f,
    (float16_t)0.845673247f,  (float16_t)0.533701002f,
    (float16_t)0.846490939f,  (float16_t)0.532403128f,
    (float16_t)0.847306639f,  (float16_t)0.531104001f,
    (float16_t)0.848120345f,  (float16_t)0.529803625f,
    (float16_t)0.848932055f,  (float16_t)0.528502002f,
    (float16_t)0.849741768f,  (float16_t)0.527199135f,
    (float16_t)0.850549481f,  (float16_t)0.525895027f,
    (float16_t)0.851355193f,  (float16_t)0.524589683f,
    (float16_t)0.852158902f,  (float16_t)0.523283103f,
    (float16_t)0.852960605f,  (float16_t)0.521975293f,
    (float16_t)0.853760301f,  (float16_t)0.520666254f,
    (float16_t)0.854557988f,  (float16_t)0.519355990f,
    (float16_t)0.855353665f,  (float16_t)0.518044504f,
    (float16_t)0.856147328f,  (float16_t)0.516731799f,
    (float16_t)0.856938977f,  (float16_t)0.515417878f,
    (float16_t)0.857728610f,  (float16_t)0.514102744f,
    (float16_t)0.858516224f,  (float16_t)0.512786401f,
    (float16_t)0.859301818f,  (float16_t)0.511468850f,
    (float16_t)0.860085390f,  (float16_t)0.510150097f,
    (float16_t)0.860866939f,  (float16_t)0.508830143f,
    (float16_t)0.861646461f,  (float16_t)0.507508991f,
    (float16_t)0.862423956f,  (float16_t)0.506186645f,
    (float16_t)0.863199422f,  (float16_t)0.504863109f,
    (float16_t)0.863972856f,  (float16_t)0.503538384f,
    (float16_t)0.864744258f,  (float16_t)0.502212474f,
    (float16_t)0.865513624f,  (float16_t)0.500885383f,
    (float16_t)0.866280954f,  (float16_t)0.499557113f,
    (float16_t)0.867046246f,  (float16_t)0.498227667f,
    (float16_t)0.867809497f,  (float16_t)0.496897049f,
    (float16_t)0.868570706f,  (float16_t)0.495565262f,
    (float16_t)0.869329871f,  (float16_t)0.494232309f,
    (float16_t)0.870086991f,  (float16_t)0.492898192f,
    (float16_t)0.870842063f,  (float16_t)0.491562916f,
    (float16_t)0.871595087f,  (float16_t)0.490226483f,
    (float16_t)0.872346059f,  (float16_t)0.488888897f,
    (float16_t)0.873094978f,  (float16_t)0.487550160f,
    (float16_t)0.873841843f,  (float16_t)0.486210276f,
    (float16_t)0.874586652f,  (float16_t)0.484869248f,
    (float16_t)0.875329403f,  (float16_t)0.483527079f,
    (float16_t)0.876070094f,  (float16_t)0.482183772f,
    (float16_t)0.876808724f,  (float16_t)0.480839331f,
    (float16_t)0.877545290f,  (float16_t)0.479493758f,
    (float16_t)0.878279792f,  (float16_t)0.478147056f,
    (float16_t)0.879012226f,  (float16_t)0.476799230f,
    (float16_t)0.879742593f,  (float16_t)0.475450282f,
    (float16_t)0.880470889f,  (float16_t)0.474100215f,
    (float16_t)0.881197113f,  (float16_t)0.472749032f,
    (float16_t)0.881921264f,  (float16_t)0.471396737f,
    (float16_t)0.882643340f,  (float16_t)0.470043332f,
    (float16_t)0.883363339f,  (float16_t)0.468688822f,
    (float16_t)0.884081259f,  (float16_t)0.467333209f,
    (float16_t)0.884797098f,  (float16_t)0.465976496f,
    (float16_t)0.885510856f,  (float16_t)0.464618686f,
    (float16_t)0.886222530f,  (float16_t)0.463259784f,
    (float16_t)0.886932119f,  (float16_t)0.461899791f,
    (float16_t)0.887639620f,  (float16_t)0.460538711f,
    (float16_t)0.888345033f,  (float16_t)0.459176548f,
    (float16_t)0.889048356f,  (float16_t)0.457813304f,
    (float16_t)0.889749586f,  (float16_t)0.456448982f,
    (float16_t)0.890448723f,  (float16_t)0.455083587f,
    (float16_t)0.891145765f,  (float16_t)0.453717121f,
    (float16_t)0.891840709f,  (float16_t)0.452349587f,
    (float16_t)0.892533555f,  (float16_t)0.450980989f,
    (float16_t)0.893224301f,  (float16_t)0.449611330f,
    (float16_t)0.893912945f,  (float16_t)0.448240612f,
    (float16_t)0.894599486f,  (float16_t)0.446868840f,
    (float16_t)0.895283921f,  (float16_t)0.445496017f,
    (float16_t)0.895966250f,  (float16_t)0.444122145f,
    (float16_t)0.896646470f,  (float16_t)0.442747228f,
    (float16_t)0.897324581f,  (float16_t)0.441371269f,
    (float16_t)0.898000580f,  (float16_t)0.439994271f,
    (float16_t)0.898674466f,  (float16_t)0.438616239f,
    (float16_t)0.899346237f,  (float16_t)0.437237174f,
    (float16_t)0.900015892f,  (float16_t)0.435857080f,
    (float16_t)0.900683429f,  (float16_t)0.434475961f,
    (float16_t)0.901348847f,  (float16_t)0.433093819f,
    (float16_t)0.902012144f,  (float16_t)0.431710658f,
    (float16_t)0.902673318f,  (float16_t)0.430326481f,
    (float16_t)0.903332368f,  (float16_t)0.428941292f,
    (float16_t)0.903989293f,  (float16_t)0.427555093f,
    (float16_t)0.904644091f,  (float16_t)0.426167889f,
    (float16_t)0.905296759f,  (float16_t)0.424779681f,
    (float16_t)0.905947298f,  (float16_t)0.423390474f,
    (float16_t)0.906595705f,  (float16_t)0.422000271f,
    (float16_t)0.907241978f,  (float16_t)0.420609074f,
    (float16_t)0.907886116f,  (float16_t)0.419216888f,
    (float16_t)0.908528119f,  (float16_t)0.417823716f,
    (float16_t)0.909167983f,  (float16_t)0.416429560f,
    (float16_t)0.909805708f,  (float16_t)0.415034424f,
    (float16_t)0.910441292f,  (float16_t)0.413638312f,
    (float16_t)0.911074734f,  (float16_t)0.412241227f,
    (float16_t)0.911706032f,  (float16_t)0.410843171f,
    (float16_t)0.912335185f,  (float16_t)0.409444149f,
    (float16_t)0.912962190f,  (float16_t)0.408044163f,
    (float16_t)0.913587048f,  (float16_t)0.406643217f,
    (float16_t)0.914209756f,  (float16_t)0.405241314f,
    (float16_t)0.914830312f,  (float16_t)0.403838458f,
    (float16_t)0.915448716f,  (float16_t)0.402434651f,
    (float16_t)0.916064966f,  (float16_t)0.401029897f,
    (float16_t)0.916679060f,  (float16_t)0.399624200f,
    (float16_t)0.917290997f,  (float16_t)0.398217562f,
    (float16_t)0.917900776f,  (float16_t)0.396809987f,
    (float16_t)0.918508394f,  (float16_t)0.395401479f,
    (float16_t)0.919113852f,  (float16_t)0.393992040f,
    (float16_t)0.919717146f,  (float16_t)0.392581674f,
    (float16_t)0.920318277f,  (float16_t)0.391170384f,
    (float16_t)0.920917242f,  (float16_t)0.389758174f,
    (float16_t)0.921514039f,  (float16_t)0.388345047f,
    (float16_t)0.922108669f,  (float16_t)0.386931006f,
    (float16_t)0.922701128f,  (float16_t)0.385516054f,
    (float16_t)0.923291417f,  (float16_t)0.384100195f,
    (float16_t)0.923879533f,  (float16_t)0.382683432f,
    (float16_t)0.924465474f,  (float16_t)0.381265769f,
    (float16_t)0.925049241f,  (float16_t)0.379847209f,
    (float16_t)0.925630831f,  (float16_t)0.378427755f,
    (float16_t)0.926210242f,  (float16_t)0.377007410f,
    (float16_t)0.926787474f,  (float16_t)0.375586178f,
    (float16_t)0.927362526f,  (float16_t)0.374164063f,
    (float16_t)0.927935395f,  (float16_t)0.372741067f,
    (float16_t)0.928506080f,  (float16_t)0.371317194f,
    (float16_t)0.929074581f,  (float16_t)0.369892447f,
    (float16_t)0.929640896f,  (float16_t)0.368466830f,
    (float16_t)0.930205023f,  (float16_t)0.367040346f,
    (float16_t)0.930766961f,  (float16_t)0.365612998f,
    (float16_t)0.931326709f,  (float16_t)0.364184790f,
    (float16_t)0.931884266f,  (float16_t)0.362755724f,
    (float16_t)0.932439629f,  (float16_t)0.361325806f,
    (float16_t)0.932992799f,  (float16_t)0.359895037f,
    (float16_t)0.933543773f,  (float16_t)0.358463421f,
    (float16_t)0.934092550f,  (float16_t)0.357030961f,
    (float16_t)0.934639130f,  (float16_t)0.355597662f,
    (float16_t)0.935183510f,  (float16_t)0.354163525f,
    (float16_t)0.935725689f,  (float16_t)0.352728556f,
    (float16_t)0.936265667f,  (float16_t)0.351292756f,
    (float16_t)0.936803442f,  (float16_t)0.349856130f,
    (float16_t)0.937339012f,  (float16_t)0.348418680f,
    (float16_t)0.937872376f,  (float16_t)0.346980411f,
    (float16_t)0.938403534f,  (float16_t)0.345541325f,
    (float16_t)0.938932484f,  (float16_t)0.344101426f,
    (float16_t)0.939459224f,  (float16_t)0.342660717f,
    (float16_t)0.939983753f,  (float16_t)0.341219202f,
    (float16_t)0.940506071f,  (float16_t)0.339776884f,
    (float16_t)0.941026175f,  (float16_t)0.338333767f,
    (float16_t)0.941544065f,  (float16_t)0.336889853f,
    (float16_t)0.942059740f,  (float16_t)0.335445147f,
    (float16_t)0.942573198f,  (float16_t)0.333999651f,
    (float16_t)0.943084437f,  (float16_t)0.332553370f,
    (float16_t)0.943593458f,  (float16_t)0.331106306f,
    (float16_t)0.944100258f,  (float16_t)0.329658463f,
    (float16_t)0.944604837f,  (float16_t)0.328209844f,
    (float16_t)0.945107193f,  (float16_t)0.326760452f,
    (float16_t)0.945607325f,  (float16_t)0.325310292f,
    (float16_t)0.946105232f,  (float16_t)0.323859367f,
    (float16_t)0.946600913f,  (float16_t)0.322407679f,
    (float16_t)0.947094366f,  (float16_t)0.320955232f,
    (float16_t)0.947585591f,  (float16_t)0.319502031f,
    (float16_t)0.948074586f,  (float16_t)0.318048077f,
    (float16_t)0.948561350f,  (float16_t)0.316593376f,
    (float16_t)0.949045882f,  (float16_t)0.315137929f,
    (float16_t)0.949528181f,  (float16_t)0.313681740f,
    (float16_t)0.950008245f,  (float16_t)0.312224814f,
    (float16_t)0.950486074f,  (float16_t)0.310767153f,
    (float16_t)0.950961666f,  (float16_t)0.309308760f,
    (float16_t)0.951435021f,  (float16_t)0.307849640f,
    (float16_t)0.951906137f,  (float16_t)0.306389795f,
    (float16_t)0.952375013f,  (float16_t)0.304929230f,
    (float16_t)0.952841648f,  (float16_t)0.303467947f,
    (float16_t)0.953306040f,  (float16_t)0.302005949f,
    (float16_t)0.953768190f,  (float16_t)0.300543241f,
    (float16_t)0.954228095f,  (float16_t)0.299079826f,
    (float16_t)0.954685755f,  (float16_t)0.297615707f,
    (float16_t)0.955141168f,  (float16_t)0.296150888f,
    (float16_t)0.955594334f,  (float16_t)0.294685372f,
    (float16_t)0.956045251f,  (float16_t)0.293219163f,
    (float16_t)0.956493919f,  (float16_t)0.291752263f,
    (float16_t)0.956940336f,  (float16_t)0.290284677f,
    (float16_t)0.957384501f,  (float16_t)0.288816408f,
    (float16_t)0.957826413f,  (float16_t)0.287347460f,
    (float16_t)0.958266071f,  (float16_t)0.285877835f,
    (float16_t)0.958703475f,  (float16_t)0.284407537f,
    (float16_t)0.959138622f,  (float16_t)0.282936570f,
    (float16_t)0.959571513f,  (float16_t)0.281464938f,
    (float16_t)0.960002146f,  (float16_t)0.279992643f,
    (float16_t)0.960430519f,  (float16_t)0.278519689f,
    (float16_t)0.960856633f,  (float16_t)0.277046080f,
    (float16_t)0.961280486f,  (float16_t)0.275571819f,
    (float16_t)0.961702077f,  (float16_t)0.274096910f,
    (float16_t)0.962121404f,  (float16_t)0.272621355f,
    (float16_t)0.962538468f,  (float16_t)0.271145160f,
    (float16_t)0.962953267f,  (float16_t)0.269668326f,
    (float16_t)0.963365800f,  (float16_t)0.268190857f,
    (float16_t)0.963776066f,  (float16_t)0.266712757f,
    (float16_t)0.964184064f,  (float16_t)0.265234030f,
    (float16_t)0.964589793f,  (float16_t)0.263754679f,
    (float16_t)0.964993253f,  (float16_t)0.262274707f,
    (float16_t)0.965394442f,  (float16_t)0.260794118f,
    (float16_t)0.965793359f,  (float16_t)0.259312915f,
    (float16_t)0.966190003f,  (float16_t)0.257831102f,
    (float16_t)0.966584374f,  (float16_t)0.256348682f,
    (float16_t)0.966976471f,  (float16_t)0.254865660f,
    (float16_t)0.967366292f,  (float16_t)0.253382037f,
    (float16_t)0.967753837f,  (float16_t)0.251897818f,
    (float16_t)0.968139105f,  (float16_t)0.250413007f,
    (float16_t)0.968522094f,  (float16_t)0.248927606f,
    (float16_t)0.968902805f,  (float16_t)0.247441619f,
    (float16_t)0.969281235f,  (float16_t)0.245955050f,
    (float16_t)0.969657385f,  (float16_t)0.244467903f,
    (float16_t)0.970031253f,  (float16_t)0.242980180f,
    (float16_t)0.970402839f,  (float16_t)0.241491885f,
    (float16_t)0.970772141f,  (float16_t)0.240003022f,
    (float16_t)0.971139158f,  (float16_t)0.238513595f,
    (float16_t)0.971503891f,  (float16_t)0.237023606f,
    (float16_t)0.971866337f,  (float16_t)0.235533059f,
    (float16_t)0.972226497f,  (float16_t)0.234041959f,
    (float16_t)0.972584369f,  (float16_t)0.232550307f,
    (float16_t)0.972939952f,  (float16_t)0.231058108f,
    (float16_t)0.973293246f,  (float16_t)0.229565366f,
    (float16_t)0.973644250f,  (float16_t)0.228072083f,
    (float16_t)0.973992962f,  (float16_t)0.226578264f,
    (float16_t)0.974339383f,  (float16_t)0.225083911f,
    (float16_t)0.974683511f,  (float16_t)0.223589029f,
    (float16_t)0.975025345f,  (float16_t)0.222093621f,
    (float16_t)0.975364885f,  (float16_t)0.220597690f,
    (float16_t)0.975702130f,  (float16_t)0.219101240f,
    (float16_t)0.976037079f,  (float16_t)0.217604275f,
    (float16_t)0.976369731f,  (float16_t)0.216106797f,
    (float16_t)0.976700086f,  (float16_t)0.214608811f,
    (float16_t)0.977028143f,  (float16_t)0.213110320f,
    (float16_t)0.977353900f,  (float16_t)0.211611327f,
    (float16_t)0.977677358f,  (float16_t)0.210111837f,
    (float16_t)0.977998515f,  (float16_t)0.208611852f,
    (float16_t)0.978317371f,  (float16_t)0.207111376f,
    (float16_t)0.978633924f,  (float16_t)0.205610413f,
    (float16_t)0.978948175f,  (float16_t)0.204108966f,
    (float16_t)0.979260123f,  (float16_t)0.202607039f,
    (float16_t)0.979569766f,  (float16_t)0.201104635f,
    (float16_t)0.979877104f,  (float16_t)0.199601758f,
    (float16_t)0.980182136f,  (float16_t)0.198098411f,
    (float16_t)0.980484862f,  (float16_t)0.196594598f,
    (float16_t)0.980785280f,  (float16_t)0.195090322f,
    (float16_t)0.981083391f,  (float16_t)0.193585587f,
    (float16_t)0.981379193f,  (float16_t)0.192080397f,
    (float16_t)0.981672686f,  (float16_t)0.190574755f,
    (float16_t)0.981963869f,  (float16_t)0.189068664f,
    (float16_t)0.982252741f,  (float16_t)0.187562129f,
    (float16_t)0.982539302f,  (float16_t)0.186055152f,
    (float16_t)0.982823551f,  (float16_t)0.184547737f,
    (float16_t)0.983105487f,  (float16_t)0.183039888f,
    (float16_t)0.983385110f,  (float16_t)0.181531608f,
    (float16_t)0.983662419f,  (float16_t)0.180022901f,
    (float16_t)0.983937413f,  (float16_t)0.178513771f,
    (float16_t)0.984210092f,  (float16_t)0.177004220f,
    (float16_t)0.984480455f,  (float16_t)0.175494253f,
    (float16_t)0.984748502f,  (float16_t)0.173983873f,
    (float16_t)0.985014231f,  (float16_t)0.172473084f,
    (float16_t)0.985277642f,  (float16_t)0.170961889f,
    (float16_t)0.985538735f,  (float16_t)0.169450291f,
    (float16_t)0.985797509f,  (float16_t)0.167938295f,
    (float16_t)0.986053963f,  (float16_t)0.166425904f,
    (float16_t)0.986308097f,  (float16_t)0.164913120f,
    (float16_t)0.986559910f,  (float16_t)0.163399949f,
    (float16_t)0.986809402f,  (float16_t)0.161886394f,
    (float16_t)0.987056571f,  (float16_t)0.160372457f,
    (float16_t)0.987301418f,  (float16_t)0.158858143f,
    (float16_t)0.987543942f,  (float16_t)0.157343456f,
    (float16_t)0.987784142f,  (float16_t)0.155828398f,
    (float16_t)0.988022017f,  (float16_t)0.154312973f,
    (float16_t)0.988257568f,  (float16_t)0.152797185f,
    (float16_t)0.988490793f,  (float16_t)0.151281038f,
    (float16_t)0.988721692f,  (float16_t)0.149764535f,
    (float16_t)0.988950265f,  (float16_t)0.148247679f,
    (float16_t)0.989176510f,  (float16_t)0.146730474f,
    (float16_t)0.989400428f,  (float16_t)0.145212925f,
    (float16_t)0.989622017f,  (float16_t)0.143695033f,
    (float16_t)0.989841278f,  (float16_t)0.142176804f,
    (float16_t)0.990058210f,  (float16_t)0.140658239f,
    (float16_t)0.990272812f,  (float16_t)0.139139344f,
    (float16_t)0.990485084f,  (float16_t)0.137620122f,
    (float16_t)0.990695025f,  (float16_t)0.136100575f,
    (float16_t)0.990902635f,  (float16_t)0.134580709f,
    (float16_t)0.991107914f,  (float16_t)0.133060525f,
    (float16_t)0.991310860f,  (float16_t)0.131540029f,
    (float16_t)0.991511473f,  (float16_t)0.130019223f,
    (float16_t)0.991709754f,  (float16_t)0.128498111f,
    (float16_t)0.991905700f,  (float16_t)0.126976696f,
    (float16_t)0.992099313f,  (float16_t)0.125454983f,
    (float16_t)0.992290591f,  (float16_t)0.123932975f,
    (float16_t)0.992479535f,  (float16_t)0.122410675f,
    (float16_t)0.992666142f,  (float16_t)0.120888087f,
    (float16_t)0.992850414f,  (float16_t)0.119365215f,
    (float16_t)0.993032350f,  (float16_t)0.117842062f,
    (float16_t)0.993211949f,  (float16_t)0.116318631f,
    (float16_t)0.993389211f,  (float16_t)0.114794927f,
    (float16_t)0.993564136f,  (float16_t)0.113270952f,
    (float16_t)0.993736722f,  (float16_t)0.111746711f,
    (float16_t)0.993906970f,  (float16_t)0.110222207f,
    (float16_t)0.994074879f,  (float16_t)0.108697444f,
    (float16_t)0.994240449f,  (float16_t)0.107172425f,
    (float16_t)0.994403680f,  (float16_t)0.105647154f,
    (float16_t)0.994564571f,  (float16_t)0.104121634f,
    (float16_t)0.994723121f,  (float16_t)0.102595869f,
    (float16_t)0.994879331f,  (float16_t)0.101069863f,
    (float16_t)0.995033199f,  (float16_t)0.099543619f,
    (float16_t)0.995184727f,  (float16_t)0.098017140f,
    (float16_t)0.995333912f,  (float16_t)0.096490431f,
    (float16_t)0.995480755f,  (float16_t)0.094963495f,
    (float16_t)0.995625256f,  (float16_t)0.093436336f,
    (float16_t)0.995767414f,  (float16_t)0.091908956f,
    (float16_t)0.995907229f,  (float16_t)0.090381361f,
    (float16_t)0.996044701f,  (float16_t)0.088853553f,
    (float16_t)0.996179829f,  (float16_t)0.087325535f,
    (float16_t)0.996312612f,  (float16_t)0.085797312f,
    (float16_t)0.996443051f,  (float16_t)0.084268888f,
    (float16_t)0.996571146f,  (float16_t)0.082740265f,
    (float16_t)0.996696895f,  (float16_t)0.081211447f,
    (float16_t)0.996820299f,  (float16_t)0.079682438f,
    (float16_t)0.996941358f,  (float16_t)0.078153242f,
    (float16_t)0.997060070f,  (float16_t)0.076623861f,
    (float16_t)0.997176437f,  (float16_t)0.075094301f,
    (float16_t)0.997290457f,  (float16_t)0.073564564f,
    (float16_t)0.997402130f,  (float16_t)0.072034653f,
    (float16_t)0.997511456f,  (float16_t)0.070504573f,
    (float16_t)0.997618435f,  (float16_t)0.068974328f,
    (float16_t)0.997723067f,  (float16_t)0.067443920f,
    (float16_t)0.997825350f,  (float16_t)0.065913353f,
    (float16_t)0.997925286f,  (float16_t)0.064382631f,
    (float16_t)0.998022874f,  (float16_t)0.062851758f,
    (float16_t)0.998118113f,  (float16_t)0.061320736f,
    (float16_t)0.998211003f,  (float16_t)0.059789571f,
    (float16_t)0.998301545f,  (float16_t)0.058258265f,
    (float16_t)0.998389737f,  (float16_t)0.056726821f,
    (float16_t)0.998475581f,  (float16_t)0.055195244f,
    (float16_t)0.998559074f,  (float16_t)0.053663538f,
    (float16_t)0.998640218f,  (float16_t)0.052131705f,
    (float16_t)0.998719012f,  (float16_t)0.050599749f,
    (float16_t)0.998795456f,  (float16_t)0.049067674f,
    (float16_t)0.998869550f,  (float16_t)0.047535484f,
    (float16_t)0.998941293f,  (float16_t)0.046003182f,
    (float16_t)0.999010686f,  (float16_t)0.044470772f,
    (float16_t)0.999077728f,  (float16_t)0.042938257f,
    (float16_t)0.999142419f,  (float16_t)0.041405641f,
    (float16_t)0.999204759f,  (float16_t)0.039872928f,
    (float16_t)0.999264747f,  (float16_t)0.038340120f,
    (float16_t)0.999322385f,  (float16_t)0.036807223f,
    (float16_t)0.999377670f,  (float16_t)0.035274239f,
    (float16_t)0.999430605f,  (float16_t)0.033741172f,
    (float16_t)0.999481187f,  (float16_t)0.032208025f,
    (float16_t)0.999529418f,  (float16_t)0.030674803f,
    (float16_t)0.999575296f,  (float16_t)0.029141509f,
    (float16_t)0.999618822f,  (float16_t)0.027608146f,
    (float16_t)0.999659997f,  (float16_t)0.026074718f,
    (float16_t)0.999698819f,  (float16_t)0.024541229f,
    (float16_t)0.999735288f,  (float16_t)0.023007681f,
    (float16_t)0.999769405f,  (float16_t)0.021474080f,
    (float16_t)0.999801170f,  (float16_t)0.019940429f,
    (float16_t)0.999830582f,  (float16_t)0.018406730f,
    (float16_t)0.999857641f,  (float16_t)0.016872988f,
    (float16_t)0.999882347f,  (float16_t)0.015339206f,
    (float16_t)0.999904701f,  (float16_t)0.013805389f,
    (float16_t)0.999924702f,  (float16_t)0.012271538f,
    (float16_t)0.999942350f,  (float16_t)0.010737659f,
    (float16_t)0.999957645f,  (float16_t)0.009203755f,
    (float16_t)0.999970586f,  (float16_t)0.007669829f,
    (float16_t)0.999981175f,  (float16_t)0.006135885f,
    (float16_t)0.999989411f,  (float16_t)0.004601926f,
    (float16_t)0.999995294f,  (float16_t)0.003067957f,
    (float16_t)0.999998823f,  (float16_t)0.001533980f,
    (float16_t)1.000000000f,  (float16_t)0.000000000f,
    (float16_t)0.999998823f, (float16_t)-0.001533980f,
    (float16_t)0.999995294f, (float16_t)-0.003067957f,
    (float16_t)0.999989411f, (float16_t)-0.004601926f,
    (float16_t)0.999981175f, (float16_t)-0.006135885f,
    (float16_t)0.999970586f, (float16_t)-0.007669829f,
    (float16_t)0.999957645f, (float16_t)-0.009203755f,
    (float16_t)0.999942350f, (float16_t)-0.010737659f,
    (float16_t)0.999924702f, (float16_t)-0.012271538f,
    (float16_t)0.999904701f, (float16_t)-0.013805389f,
    (float16_t)0.999882347f, (float16_t)-0.015339206f,
    (float16_t)0.999857641f, (float16_t)-0.016872988f,
    (float16_t)0.999830582f, (float16_t)-0.018406730f,
    (float16_t)0.999801170f, (float16_t)-0.019940429f,
    (float16_t)0.999769405f, (float16_t)-0.021474080f,
    (float16_t)0.999735288f, (float16_t)-0.023007681f,
    (float16_t)0.999698819f, (float16_t)-0.024541229f,
    (float16_t)0.999659997f, (float16_t)-0.026074718f,
    (float16_t)0.999618822f, (float16_t)-0.027608146f,
    (float16_t)0.999575296f, (float16_t)-0.029141509f,
    (float16_t)0.999529418f, (float16_t)-0.030674803f,
    (float16_t)0.999481187f, (float16_t)-0.032208025f,
    (float16_t)0.999430605f, (float16_t)-0.033741172f,
    (float16_t)0.999377670f, (float16_t)-0.035274239f,
    (float16_t)0.999322385f, (float16_t)-0.036807223f,
    (float16_t)0.999264747f, (float16_t)-0.038340120f,
    (float16_t)0.999204759f, (float16_t)-0.039872928f,
    (float16_t)0.999142419f, (float16_t)-0.041405641f,
    (float16_t)0.999077728f, (float16_t)-0.042938257f,
    (float16_t)0.999010686f, (float16_t)-0.044470772f,
    (float16_t)0.998941293f, (float16_t)-0.046003182f,
    (float16_t)0.998869550f, (float16_t)-0.047535484f,
    (float16_t)0.998795456f, (float16_t)-0.049067674f,
    (float16_t)0.998719012f, (float16_t)-0.050599749f,
    (float16_t)0.998640218f, (float16_t)-0.052131705f,
    (float16_t)0.998559074f, (float16_t)-0.053663538f,
    (float16_t)0.998475581f, (float16_t)-0.055195244f,
    (float16_t)0.998389737f, (float16_t)-0.056726821f,
    (float16_t)0.998301545f, (float16_t)-0.058258265f,
    (float16_t)0.998211003f, (float16_t)-0.059789571f,
    (float16_t)0.998118113f, (float16_t)-0.061320736f,
    (float16_t)0.998022874f, (float16_t)-0.062851758f,
    (float16_t)0.997925286f, (float16_t)-0.064382631f,
    (float16_t)0.997825350f, (float16_t)-0.065913353f,
    (float16_t)0.997723067f, (float16_t)-0.067443920f,
    (float16_t)0.997618435f, (float16_t)-0.068974328f,
    (float16_t)0.997511456f, (float16_t)-0.070504573f,
    (float16_t)0.997402130f, (float16_t)-0.072034653f,
    (float16_t)0.997290457f, (float16_t)-0.073564564f,
    (float16_t)0.997176437f, (float16_t)-0.075094301f,
    (float16_t)0.997060070f, (float16_t)-0.076623861f,
    (float16_t)0.996941358f, (float16_t)-0.078153242f,
    (float16_t)0.996820299f, (float16_t)-0.079682438f,
    (float16_t)0.996696895f, (float16_t)-0.081211447f,
    (float16_t)0.996571146f, (float16_t)-0.082740265f,
    (float16_t)0.996443051f, (float16_t)-0.084268888f,
    (float16_t)0.996312612f, (float16_t)-0.085797312f,
    (float16_t)0.996179829f, (float16_t)-0.087325535f,
    (float16_t)0.996044701f, (float16_t)-0.088853553f,
    (float16_t)0.995907229f, (float16_t)-0.090381361f,
    (float16_t)0.995767414f, (float16_t)-0.091908956f,
    (float16_t)0.995625256f, (float16_t)-0.093436336f,
    (float16_t)0.995480755f, (float16_t)-0.094963495f,
    (float16_t)0.995333912f, (float16_t)-0.096490431f,
    (float16_t)0.995184727f, (float16_t)-0.098017140f,
    (float16_t)0.995033199f, (float16_t)-0.099543619f,
    (float16_t)0.994879331f, (float16_t)-0.101069863f,
    (float16_t)0.994723121f, (float16_t)-0.102595869f,
    (float16_t)0.994564571f, (float16_t)-0.104121634f,
    (float16_t)0.994403680f, (float16_t)-0.105647154f,
    (float16_t)0.994240449f, (float16_t)-0.107172425f,
    (float16_t)0.994074879f, (float16_t)-0.108697444f,
    (float16_t)0.993906970f, (float16_t)-0.110222207f,
    (float16_t)0.993736722f, (float16_t)-0.111746711f,
    (float16_t)0.993564136f, (float16_t)-0.113270952f,
    (float16_t)0.993389211f, (float16_t)-0.114794927f,
    (float16_t)0.993211949f, (float16_t)-0.116318631f,
    (float16_t)0.993032350f, (float16_t)-0.117842062f,
    (float16_t)0.992850414f, (float16_t)-0.119365215f,
    (float16_t)0.992666142f, (float16_t)-0.120888087f,
    (float16_t)0.992479535f, (float16_t)-0.122410675f,
    (float16_t)0.992290591f, (float16_t)-0.123932975f,
    (float16_t)0.992099313f, (float16_t)-0.125454983f,
    (float16_t)0.991905700f, (float16_t)-0.126976696f,
    (float16_t)0.991709754f, (float16_t)-0.128498111f,
    (float16_t)0.991511473f, (float16_t)-0.130019223f,
    (float16_t)0.991310860f, (float16_t)-0.131540029f,
    (float16_t)0.991107914f, (float16_t)-0.133060525f,
    (float16_t)0.990902635f, (float16_t)-0.134580709f,
    (float16_t)0.990695025f, (float16_t)-0.136100575f,
    (float16_t)0.990485084f, (float16_t)-0.137620122f,
    (float16_t)0.990272812f, (float16_t)-0.139139344f,
    (float16_t)0.990058210f, (float16_t)-0.140658239f,
    (float16_t)0.989841278f, (float16_t)-0.142176804f,
    (float16_t)0.989622017f, (float16_t)-0.143695033f,
    (float16_t)0.989400428f, (float16_t)-0.145212925f,
    (float16_t)0.989176510f, (float16_t)-0.146730474f,
    (float16_t)0.988950265f, (float16_t)-0.148247679f,
    (float16_t)0.988721692f, (float16_t)-0.149764535f,
    (float16_t)0.988490793f, (float16_t)-0.151281038f,
    (float16_t)0.988257568f, (float16_t)-0.152797185f,
    (float16_t)0.988022017f, (float16_t)-0.154312973f,
    (float16_t)0.987784142f, (float16_t)-0.155828398f,
    (float16_t)0.987543942f, (float16_t)-0.157343456f,
    (float16_t)0.987301418f, (float16_t)-0.158858143f,
    (float16_t)0.987056571f, (float16_t)-0.160372457f,
    (float16_t)0.986809402f, (float16_t)-0.161886394f,
    (float16_t)0.986559910f, (float16_t)-0.163399949f,
    (float16_t)0.986308097f, (float16_t)-0.164913120f,
    (float16_t)0.986053963f, (float16_t)-0.166425904f,
    (float16_t)0.985797509f, (float16_t)-0.167938295f,
    (float16_t)0.985538735f, (float16_t)-0.169450291f,
    (float16_t)0.985277642f, (float16_t)-0.170961889f,
    (float16_t)0.985014231f, (float16_t)-0.172473084f,
    (float16_t)0.984748502f, (float16_t)-0.173983873f,
    (float16_t)0.984480455f, (float16_t)-0.175494253f,
    (float16_t)0.984210092f, (float16_t)-0.177004220f,
    (float16_t)0.983937413f, (float16_t)-0.178513771f,
    (float16_t)0.983662419f, (float16_t)-0.180022901f,
    (float16_t)0.983385110f, (float16_t)-0.181531608f,
    (float16_t)0.983105487f, (float16_t)-0.183039888f,
    (float16_t)0.982823551f, (float16_t)-0.184547737f,
    (float16_t)0.982539302f, (float16_t)-0.186055152f,
    (float16_t)0.982252741f, (float16_t)-0.187562129f,
    (float16_t)0.981963869f, (float16_t)-0.189068664f,
    (float16_t)0.981672686f, (float16_t)-0.190574755f,
    (float16_t)0.981379193f, (float16_t)-0.192080397f,
    (float16_t)0.981083391f, (float16_t)-0.193585587f,
    (float16_t)0.980785280f, (float16_t)-0.195090322f,
    (float16_t)0.980484862f, (float16_t)-0.196594598f,
    (float16_t)0.980182136f, (float16_t)-0.198098411f,
    (float16_t)0.979877104f, (float16_t)-0.199601758f,
    (float16_t)0.979569766f, (float16_t)-0.201104635f,
    (float16_t)0.979260123f, (float16_t)-0.202607039f,
    (float16_t)0.978948175f, (float16_t)-0.204108966f,
    (float16_t)0.978633924f, (float16_t)-0.205610413f,
    (float16_t)0.978317371f, (float16_t)-0.207111376f,
    (float16_t)0.977998515f, (float16_t)-0.208611852f,
    (float16_t)0.977677358f, (float16_t)-0.210111837f,
    (float16_t)0.977353900f, (float16_t)-0.211611327f,
    (float16_t)0.977028143f, (float16_t)-0.213110320f,
    (float16_t)0.976700086f, (float16_t)-0.214608811f,
    (float16_t)0.976369731f, (float16_t)-0.216106797f,
    (float16_t)0.976037079f, (float16_t)-0.217604275f,
    (float16_t)0.975702130f, (float16_t)-0.219101240f,
    (float16_t)0.975364885f, (float16_t)-0.220597690f,
    (float16_t)0.975025345f, (float16_t)-0.222093621f,
    (float16_t)0.974683511f, (float16_t)-0.223589029f,
    (float16_t)0.974339383f, (float16_t)-0.225083911f,
    (float16_t)0.973992962f, (float16_t)-0.226578264f,
    (float16_t)0.973644250f, (float16_t)-0.228072083f,
    (float16_t)0.973293246f, (float16_t)-0.229565366f,
    (float16_t)0.972939952f, (float16_t)-0.231058108f,
    (float16_t)0.972584369f, (float16_t)-0.232550307f,
    (float16_t)0.972226497f, (float16_t)-0.234041959f,
    (float16_t)0.971866337f, (float16_t)-0.235533059f,
    (float16_t)0.971503891f, (float16_t)-0.237023606f,
    (float16_t)0.971139158f, (float16_t)-0.238513595f,
    (float16_t)0.970772141f, (float16_t)-0.240003022f,
    (float16_t)0.970402839f, (float16_t)-0.241491885f,
    (float16_t)0.970031253f, (float16_t)-0.242980180f,
    (float16_t)0.969657385f, (float16_t)-0.244467903f,
    (float16_t)0.969281235f, (float16_t)-0.245955050f,
    (float16_t)0.968902805f, (float16_t)-0.247441619f,
    (float16_t)0.968522094f, (float16_t)-0.248927606f,
    (float16_t)0.968139105f, (float16_t)-0.250413007f,
    (float16_t)0.967753837f, (float16_t)-0.251897818f,
    (float16_t)0.967366292f, (float16_t)-0.253382037f,
    (float16_t)0.966976471f, (float16_t)-0.254865660f,
    (float16_t)0.966584374f, (float16_t)-0.256348682f,
    (float16_t)0.966190003f, (float16_t)-0.257831102f,
    (float16_t)0.965793359f, (float16_t)-0.259312915f,
    (float16_t)0.965394442f, (float16_t)-0.260794118f,
    (float16_t)0.964993253f, (float16_t)-0.262274707f,
    (float16_t)0.964589793f, (float16_t)-0.263754679f,
    (float16_t)0.964184064f, (float16_t)-0.265234030f,
    (float16_t)0.963776066f, (float16_t)-0.266712757f,
    (float16_t)0.963365800f, (float16_t)-0.268190857f,
    (float16_t)0.962953267f, (float16_t)-0.269668326f,
    (float16_t)0.962538468f, (float16_t)-0.271145160f,
    (float16_t)0.962121404f, (float16_t)-0.272621355f,
    (float16_t)0.961702077f, (float16_t)-0.274096910f,
    (float16_t)0.961280486f, (float16_t)-0.275571819f,
    (float16_t)0.960856633f, (float16_t)-0.277046080f,
    (float16_t)0.960430519f, (float16_t)-0.278519689f,
    (float16_t)0.960002146f, (float16_t)-0.279992643f,
    (float16_t)0.959571513f, (float16_t)-0.281464938f,
    (float16_t)0.959138622f, (float16_t)-0.282936570f,
    (float16_t)0.958703475f, (float16_t)-0.284407537f,
    (float16_t)0.958266071f, (float16_t)-0.285877835f,
    (float16_t)0.957826413f, (float16_t)-0.287347460f,
    (float16_t)0.957384501f, (float16_t)-0.288816408f,
    (float16_t)0.956940336f, (float16_t)-0.290284677f,
    (float16_t)0.956493919f, (float16_t)-0.291752263f,
    (float16_t)0.956045251f, (float16_t)-0.293219163f,
    (float16_t)0.955594334f, (float16_t)-0.294685372f,
    (float16_t)0.955141168f, (float16_t)-0.296150888f,
    (float16_t)0.954685755f, (float16_t)-0.297615707f,
    (float16_t)0.954228095f, (float16_t)-0.299079826f,
    (float16_t)0.953768190f, (float16_t)-0.300543241f,
    (float16_t)0.953306040f, (float16_t)-0.302005949f,
    (float16_t)0.952841648f, (float16_t)-0.303467947f,
    (float16_t)0.952375013f, (float16_t)-0.304929230f,
    (float16_t)0.951906137f, (float16_t)-0.306389795f,
    (float16_t)0.951435021f, (float16_t)-0.307849640f,
    (float16_t)0.950961666f, (float16_t)-0.309308760f,
    (float16_t)0.950486074f, (float16_t)-0.310767153f,
    (float16_t)0.950008245f, (float16_t)-0.312224814f,
    (float16_t)0.949528181f, (float16_t)-0.313681740f,
    (float16_t)0.949045882f, (float16_t)-0.315137929f,
    (float16_t)0.948561350f, (float16_t)-0.316593376f,
    (float16_t)0.948074586f, (float16_t)-0.318048077f,
    (float16_t)0.947585591f, (float16_t)-0.319502031f,
    (float16_t)0.947094366f, (float16_t)-0.320955232f,
    (float16_t)0.946600913f, (float16_t)-0.322407679f,
    (float16_t)0.946105232f, (float16_t)-0.323859367f,
    (float16_t)0.945607325f, (float16_t)-0.325310292f,
    (float16_t)0.945107193f, (float16_t)-0.326760452f,
    (float16_t)0.944604837f, (float16_t)-0.328209844f,
    (float16_t)0.944100258f, (float16_t)-0.329658463f,
    (float16_t)0.943593458f, (float16_t)-0.331106306f,
    (float16_t)0.943084437f, (float16_t)-0.332553370f,
    (float16_t)0.942573198f, (float16_t)-0.333999651f,
    (float16_t)0.942059740f, (float16_t)-0.335445147f,
    (float16_t)0.941544065f, (float16_t)-0.336889853f,
    (float16_t)0.941026175f, (float16_t)-0.338333767f,
    (float16_t)0.940506071f, (float16_t)-0.339776884f,
    (float16_t)0.939983753f, (float16_t)-0.341219202f,
    (float16_t)0.939459224f, (float16_t)-0.342660717f,
    (float16_t)0.938932484f, (float16_t)-0.344101426f,
    (float16_t)0.938403534f, (float16_t)-0.345541325f,
    (float16_t)0.937872376f, (float16_t)-0.346980411f,
    (float16_t)0.937339012f, (float16_t)-0.348418680f,
    (float16_t)0.936803442f, (float16_t)-0.349856130f,
    (float16_t)0.936265667f, (float16_t)-0.351292756f,
    (float16_t)0.935725689f, (float16_t)-0.352728556f,
    (float16_t)0.935183510f, (float16_t)-0.354163525f,
    (float16_t)0.934639130f, (float16_t)-0.355597662f,
    (float16_t)0.934092550f, (float16_t)-0.357030961f,
    (float16_t)0.933543773f, (float16_t)-0.358463421f,
    (float16_t)0.932992799f, (float16_t)-0.359895037f,
    (float16_t)0.932439629f, (float16_t)-0.361325806f,
    (float16_t)0.931884266f, (float16_t)-0.362755724f,
    (float16_t)0.931326709f, (float16_t)-0.364184790f,
    (float16_t)0.930766961f, (float16_t)-0.365612998f,
    (float16_t)0.930205023f, (float16_t)-0.367040346f,
    (float16_t)0.929640896f, (float16_t)-0.368466830f,
    (float16_t)0.929074581f, (float16_t)-0.369892447f,
    (float16_t)0.928506080f, (float16_t)-0.371317194f,
    (float16_t)0.927935395f, (float16_t)-0.372741067f,
    (float16_t)0.927362526f, (float16_t)-0.374164063f,
    (float16_t)0.926787474f, (float16_t)-0.375586178f,
    (float16_t)0.926210242f, (float16_t)-0.377007410f,
    (float16_t)0.925630831f, (float16_t)-0.378427755f,
    (float16_t)0.925049241f, (float16_t)-0.379847209f,
    (float16_t)0.924465474f, (float16_t)-0.381265769f,
    (float16_t)0.923879533f, (float16_t)-0.382683432f,
    (float16_t)0.923291417f, (float16_t)-0.384100195f,
    (float16_t)0.922701128f, (float16_t)-0.385516054f,
    (float16_t)0.922108669f, (float16_t)-0.386931006f,
    (float16_t)0.921514039f, (float16_t)-0.388345047f,
    (float16_t)0.920917242f, (float16_t)-0.389758174f,
    (float16_t)0.920318277f, (float16_t)-0.391170384f,
    (float16_t)0.919717146f, (float16_t)-0.392581674f,
    (float16_t)0.919113852f, (float16_t)-0.393992040f,
    (float16_t)0.918508394f, (float16_t)-0.395401479f,
    (float16_t)0.917900776f, (float16_t)-0.396809987f,
    (float16_t)0.917290997f, (float16_t)-0.398217562f,
    (float16_t)0.916679060f, (float16_t)-0.399624200f,
    (float16_t)0.916064966f, (float16_t)-0.401029897f,
    (float16_t)0.915448716f, (float16_t)-0.402434651f,
    (float16_t)0.914830312f, (float16_t)-0.403838458f,
    (float16_t)0.914209756f, (float16_t)-0.405241314f,
    (float16_t)0.913587048f, (float16_t)-0.406643217f,
    (float16_t)0.912962190f, (float16_t)-0.408044163f,
    (float16_t)0.912335185f, (float16_t)-0.409444149f,
    (float16_t)0.911706032f, (float16_t)-0.410843171f,
    (float16_t)0.911074734f, (float16_t)-0.412241227f,
    (float16_t)0.910441292f, (float16_t)-0.413638312f,
    (float16_t)0.909805708f, (float16_t)-0.415034424f,
    (float16_t)0.909167983f, (float16_t)-0.416429560f,
    (float16_t)0.908528119f, (float16_t)-0.417823716f,
    (float16_t)0.907886116f, (float16_t)-0.419216888f,
    (float16_t)0.907241978f, (float16_t)-0.420609074f,
    (float16_t)0.906595705f, (float16_t)-0.422000271f,
    (float16_t)0.905947298f, (float16_t)-0.423390474f,
    (float16_t)0.905296759f, (float16_t)-0.424779681f,
    (float16_t)0.904644091f, (float16_t)-0.426167889f,
    (float16_t)0.903989293f, (float16_t)-0.427555093f,
    (float16_t)0.903332368f, (float16_t)-0.428941292f,
    (float16_t)0.902673318f, (float16_t)-0.430326481f,
    (float16_t)0.902012144f, (float16_t)-0.431710658f,
    (float16_t)0.901348847f, (float16_t)-0.433093819f,
    (float16_t)0.900683429f, (float16_t)-0.434475961f,
    (float16_t)0.900015892f, (float16_t)-0.435857080f,
    (float16_t)0.899346237f, (float16_t)-0.437237174f,
    (float16_t)0.898674466f, (float16_t)-0.438616239f,
    (float16_t)0.898000580f, (float16_t)-0.439994271f,
    (float16_t)0.897324581f, (float16_t)-0.441371269f,
    (float16_t)0.896646470f, (float16_t)-0.442747228f,
    (float16_t)0.895966250f, (float16_t)-0.444122145f,
    (float16_t)0.895283921f, (float16_t)-0.445496017f,
    (float16_t)0.894599486f, (float16_t)-0.446868840f,
    (float16_t)0.893912945f, (float16_t)-0.448240612f,
    (float16_t)0.893224301f, (float16_t)-0.449611330f,
    (float16_t)0.892533555f, (float16_t)-0.450980989f,
    (float16_t)0.891840709f, (float16_t)-0.452349587f,
    (float16_t)0.891145765f, (float16_t)-0.453717121f,
    (float16_t)0.890448723f, (float16_t)-0.455083587f,
    (float16_t)0.889749586f, (float16_t)-0.456448982f,
    (float16_t)0.889048356f, (float16_t)-0.457813304f,
    (float16_t)0.888345033f, (float16_t)-0.459176548f,
    (float16_t)0.887639620f, (float16_t)-0.460538711f,
    (float16_t)0.886932119f, (float16_t)-0.461899791f,
    (float16_t)0.886222530f, (float16_t)-0.463259784f,
    (float16_t)0.885510856f, (float16_t)-0.464618686f,
    (float16_t)0.884797098f, (float16_t)-0.465976496f,
    (float16_t)0.884081259f, (float16_t)-0.467333209f,
    (float16_t)0.883363339f, (float16_t)-0.468688822f,
    (float16_t)0.882643340f, (float16_t)-0.470043332f,
    (float16_t)0.881921264f, (float16_t)-0.471396737f,
    (float16_t)0.881197113f, (float16_t)-0.472749032f,
    (float16_t)0.880470889f, (float16_t)-0.474100215f,
    (float16_t)0.879742593f, (float16_t)-0.475450282f,
    (float16_t)0.879012226f, (float16_t)-0.476799230f,
    (float16_t)0.878279792f, (float16_t)-0.478147056f,
    (float16_t)0.877545290f, (float16_t)-0.479493758f,
    (float16_t)0.876808724f, (float16_t)-0.480839331f,
    (float16_t)0.876070094f, (float16_t)-0.482183772f,
    (float16_t)0.875329403f, (float16_t)-0.483527079f,
    (float16_t)0.874586652f, (float16_t)-0.484869248f,
    (float16_t)0.873841843f, (float16_t)-0.486210276f,
    (float16_t)0.873094978f, (float16_t)-0.487550160f,
    (float16_t)0.872346059f, (float16_t)-0.488888897f,
    (float16_t)0.871595087f, (float16_t)-0.490226483f,
    (float16_t)0.870842063f, (float16_t)-0.491562916f,
    (float16_t)0.870086991f, (float16_t)-0.492898192f,
    (float16_t)0.869329871f, (float16_t)-0.494232309f,
    (float16_t)0.868570706f, (float16_t)-0.495565262f,
    (float16_t)0.867809497f, (float16_t)-0.496897049f,
    (float16_t)0.867046246f, (float16_t)-0.498227667f,
    (float16_t)0.866280954f, (float16_t)-0.499557113f,
    (float16_t)0.865513624f, (float16_t)-0.500885383f,
    (float16_t)0.864744258f, (float16_t)-0.502212474f,
    (float16_t)0.863972856f, (float16_t)-0.503538384f,
    (float16_t)0.863199422f, (float16_t)-0.504863109f,
    (float16_t)0.862423956f, (float16_t)-0.506186645f,
    (float16_t)0.861646461f, (float16_t)-0.507508991f,
    (float16_t)0.860866939f, (float16_t)-0.508830143f,
    (float16_t)0.860085390f, (float16_t)-0.510150097f,
    (float16_t)0.859301818f, (float16_t)-0.511468850f,
    (float16_t)0.858516224f, (float16_t)-0.512786401f,
    (float16_t)0.857728610f, (float16_t)-0.514102744f,
    (float16_t)0.856938977f, (float16_t)-0.515417878f,
    (float16_t)0.856147328f, (float16_t)-0.516731799f,
    (float16_t)0.855353665f, (float16_t)-0.518044504f,
    (float16_t)0.854557988f, (float16_t)-0.519355990f,
    (float16_t)0.853760301f, (float16_t)-0.520666254f,
    (float16_t)0.852960605f, (float16_t)-0.521975293f,
    (float16_t)0.852158902f, (float16_t)-0.523283103f,
    (float16_t)0.851355193f, (float16_t)-0.524589683f,
    (float16_t)0.850549481f, (float16_t)-0.525895027f,
    (float16_t)0.849741768f, (float16_t)-0.527199135f,
    (float16_t)0.848932055f, (float16_t)-0.528502002f,
    (float16_t)0.848120345f, (float16_t)-0.529803625f,
    (float16_t)0.847306639f, (float16_t)-0.531104001f,
    (float16_t)0.846490939f, (float16_t)-0.532403128f,
    (float16_t)0.845673247f, (float16_t)-0.533701002f,
    (float16_t)0.844853565f, (float16_t)-0.534997620f,
    (float16_t)0.844031895f, (float16_t)-0.536292979f,
    (float16_t)0.843208240f, (float16_t)-0.537587076f,
    (float16_t)0.842382600f, (float16_t)-0.538879909f,
    (float16_t)0.841554977f, (float16_t)-0.540171473f,
    (float16_t)0.840725375f, (float16_t)-0.541461766f,
    (float16_t)0.839893794f, (float16_t)-0.542750785f,
    (float16_t)0.839060237f, (float16_t)-0.544038527f,
    (float16_t)0.838224706f, (float16_t)-0.545324988f,
    (float16_t)0.837387202f, (float16_t)-0.546610167f,
    (float16_t)0.836547727f, (float16_t)-0.547894059f,
    (float16_t)0.835706284f, (float16_t)-0.549176662f,
    (float16_t)0.834862875f, (float16_t)-0.550457973f,
    (float16_t)0.834017501f, (float16_t)-0.551737988f,
    (float16_t)0.833170165f, (float16_t)-0.553016706f,
    (float16_t)0.832320868f, (float16_t)-0.554294121f,
    (float16_t)0.831469612f, (float16_t)-0.555570233f,
    (float16_t)0.830616400f, (float16_t)-0.556845037f,
    (float16_t)0.829761234f, (float16_t)-0.558118531f,
    (float16_t)0.828904115f, (float16_t)-0.559390712f,
    (float16_t)0.828045045f, (float16_t)-0.560661576f,
    (float16_t)0.827184027f, (float16_t)-0.561931121f,
    (float16_t)0.826321063f, (float16_t)-0.563199344f,
    (float16_t)0.825456154f, (float16_t)-0.564466242f,
    (float16_t)0.824589303f, (float16_t)-0.565731811f,
    (float16_t)0.823720511f, (float16_t)-0.566996049f,
    (float16_t)0.822849781f, (float16_t)-0.568258953f,
    (float16_t)0.821977115f, (float16_t)-0.569520519f,
    (float16_t)0.821102515f, (float16_t)-0.570780746f,
    (float16_t)0.820225983f, (float16_t)-0.572039629f,
    (float16_t)0.819347520f, (float16_t)-0.573297167f,
    (float16_t)0.818467130f, (float16_t)-0.574553355f,
    (float16_t)0.817584813f, (float16_t)-0.575808191f,
    (float16_t)0.816700573f, (float16_t)-0.577061673f,
    (float16_t)0.815814411f, (float16_t)-0.578313796f,
    (float16_t)0.814926329f, (float16_t)-0.579564559f,
    (float16_t)0.814036330f, (float16_t)-0.580813958f,
    (float16_t)0.813144415f, (float16_t)-0.582061990f,
    (float16_t)0.812250587f, (float16_t)-0.583308653f,
    (float16_t)0.811354847f, (float16_t)-0.584553943f,
    (float16_t)0.810457198f, (float16_t)-0.585797857f,
    (float16_t)0.809557642f, (float16_t)-0.587040394f,
    (float16_t)0.808656182f, (float16_t)-0.588281548f,
    (float16_t)0.807752818f, (float16_t)-0.589521319f,
    (float16_t)0.806847554f, (float16_t)-0.590759702f,
    (float16_t)0.805940391f, (float16_t)-0.591996695f,
    (float16_t)0.805031331f, (float16_t)-0.593232295f,
    (float16_t)0.804120377f, (float16_t)-0.594466499f,
    (float16_t)0.803207531f, (float16_t)-0.595699304f,
    (float16_t)0.802292796f, (float16_t)-0.596930708f,
    (float16_t)0.801376172f, (float16_t)-0.598160707f,
    (float16_t)0.800457662f, (float16_t)-0.599389298f,
    (float16_t)0.799537269f, (float16_t)-0.600616479f,
    (float16_t)0.798614995f, (float16_t)-0.601842247f,
    (float16_t)0.797690841f, (float16_t)-0.603066599f,
    (float16_t)0.796764810f, (float16_t)-0.604289531f,
    (float16_t)0.795836905f, (float16_t)-0.605511041f,
    (float16_t)0.794907126f, (float16_t)-0.606731127f,
    (float16_t)0.793975478f, (float16_t)-0.607949785f,
    (float16_t)0.793041960f, (float16_t)-0.609167012f,
    (float16_t)0.792106577f, (float16_t)-0.610382806f,
    (float16_t)0.791169330f, (float16_t)-0.611597164f,
    (float16_t)0.790230221f, (float16_t)-0.612810082f,
    (float16_t)0.789289253f, (float16_t)-0.614021559f,
    (float16_t)0.788346428f, (float16_t)-0.615231591f,
    (float16_t)0.787401747f, (float16_t)-0.616440175f,
    (float16_t)0.786455214f, (float16_t)-0.617647308f,
    (float16_t)0.785506830f, (float16_t)-0.618852988f,
    (float16_t)0.784556597f, (float16_t)-0.620057212f,
    (float16_t)0.783604519f, (float16_t)-0.621259977f,
    (float16_t)0.782650596f, (float16_t)-0.622461279f,
    (float16_t)0.781694832f, (float16_t)-0.623661118f,
    (float16_t)0.780737229f, (float16_t)-0.624859488f,
    (float16_t)0.779777788f, (float16_t)-0.626056388f,
    (float16_t)0.778816512f, (float16_t)-0.627251815f,
    (float16_t)0.777853404f, (float16_t)-0.628445767f,
    (float16_t)0.776888466f, (float16_t)-0.629638239f,
    (float16_t)0.775921699f, (float16_t)-0.630829230f,
    (float16_t)0.774953107f, (float16_t)-0.632018736f,
    (float16_t)0.773982691f, (float16_t)-0.633206755f,
    (float16_t)0.773010453f, (float16_t)-0.634393284f,
    (float16_t)0.772036397f, (float16_t)-0.635578320f,
    (float16_t)0.771060524f, (float16_t)-0.636761861f,
    (float16_t)0.770082837f, (float16_t)-0.637943904f,
    (float16_t)0.769103338f, (float16_t)-0.639124445f,
    (float16_t)0.768122029f, (float16_t)-0.640303482f,
    (float16_t)0.767138912f, (float16_t)-0.641481013f,
    (float16_t)0.766153990f, (float16_t)-0.642657034f,
    (float16_t)0.765167266f, (float16_t)-0.643831543f,
    (float16_t)0.764178741f, (float16_t)-0.645004537f,
    (float16_t)0.763188417f, (float16_t)-0.646176013f,
    (float16_t)0.762196298f, (float16_t)-0.647345969f,
    (float16_t)0.761202385f, (float16_t)-0.648514401f,
    (float16_t)0.760206682f, (float16_t)-0.649681307f,
    (float16_t)0.759209189f, (float16_t)-0.650846685f,
    (float16_t)0.758209910f, (float16_t)-0.652010531f,
    (float16_t)0.757208847f, (float16_t)-0.653172843f,
    (float16_t)0.756206001f, (float16_t)-0.654333618f,
    (float16_t)0.755201377f, (float16_t)-0.655492853f,
    (float16_t)0.754194975f, (float16_t)-0.656650546f,
    (float16_t)0.753186799f, (float16_t)-0.657806693f,
    (float16_t)0.752176850f, (float16_t)-0.658961293f,
    (float16_t)0.751165132f, (float16_t)-0.660114342f,
    (float16_t)0.750151646f, (float16_t)-0.661265838f,
    (float16_t)0.749136395f, (float16_t)-0.662415778f,
    (float16_t)0.748119380f, (float16_t)-0.663564159f,
    (float16_t)0.747100606f, (float16_t)-0.664710978f,
    (float16_t)0.746080074f, (float16_t)-0.665856234f,
    (float16_t)0.745057785f, (float16_t)-0.666999922f,
    (float16_t)0.744033744f, (float16_t)-0.668142041f,
    (float16_t)0.743007952f, (float16_t)-0.669282588f,
    (float16_t)0.741980412f, (float16_t)-0.670421560f,
    (float16_t)0.740951125f, (float16_t)-0.671558955f,
    (float16_t)0.739920095f, (float16_t)-0.672694769f,
    (float16_t)0.738887324f, (float16_t)-0.673829000f,
    (float16_t)0.737852815f, (float16_t)-0.674961646f,
    (float16_t)0.736816569f, (float16_t)-0.676092704f,
    (float16_t)0.735778589f, (float16_t)-0.677222170f,
    (float16_t)0.734738878f, (float16_t)-0.678350043f,
    (float16_t)0.733697438f, (float16_t)-0.679476320f,
    (float16_t)0.732654272f, (float16_t)-0.680600998f,
    (float16_t)0.731609381f, (float16_t)-0.681724074f,
    (float16_t)0.730562769f, (float16_t)-0.682845546f,
    (float16_t)0.729514438f, (float16_t)-0.683965412f,
    (float16_t)0.728464390f, (float16_t)-0.685083668f,
    (float16_t)0.727412629f, (float16_t)-0.686200312f,
    (float16_t)0.726359155f, (float16_t)-0.687315341f,
    (float16_t)0.725303972f, (float16_t)-0.688428753f,
    (float16_t)0.724247083f, (float16_t)-0.689540545f,
    (float16_t)0.723188489f, (float16_t)-0.690650714f,
    (float16_t)0.722128194f, (float16_t)-0.691759258f,
    (float16_t)0.721066199f, (float16_t)-0.692866175f,
    (float16_t)0.720002508f, (float16_t)-0.693971461f,
    (float16_t)0.718937122f, (float16_t)-0.695075114f,
    (float16_t)0.717870045f, (float16_t)-0.696177131f,
    (float16_t)0.716801279f, (float16_t)-0.697277511f,
    (float16_t)0.715730825f, (float16_t)-0.698376249f,
    (float16_t)0.714658688f, (float16_t)-0.699473345f,
    (float16_t)0.713584869f, (float16_t)-0.700568794f,
    (float16_t)0.712509371f, (float16_t)-0.701662595f,
    (float16_t)0.711432196f, (float16_t)-0.702754744f,
    (float16_t)0.710353347f, (float16_t)-0.703845241f,
    (float16_t)0.709272826f, (float16_t)-0.704934080f,
    (float16_t)0.708190637f, (float16_t)-0.706021261f,
    (float16_t)0.707106781f, (float16_t)-0.707106781f,
    (float16_t)0.706021261f, (float16_t)-0.708190637f,
    (float16_t)0.704934080f, (float16_t)-0.709272826f,
    (float16_t)0.703845241f, (float16_t)-0.710353347f,
    (float16_t)0.702754744f, (float16_t)-0.711432196f,
    (float16_t)0.701662595f, (float16_t)-0.712509371f,
    (float16_t)0.700568794f, (float16_t)-0.713584869f,
    (float16_t)0.699473345f, (float16_t)-0.714658688f,
    (float16_t)0.698376249f, (float16_t)-0.715730825f,
    (float16_t)0.697277511f, (float16_t)-0.716801279f,
    (float16_t)0.696177131f, (float16_t)-0.717870045f,
    (float16_t)0.695075114f, (float16_t)-0.718937122f,
    (float16_t)0.693971461f, (float16_t)-0.720002508f,
    (float16_t)0.692866175f, (float16_t)-0.721066199f,
    (float16_t)0.691759258f, (float16_t)-0.722128194f,
    (float16_t)0.690650714f, (float16_t)-0.723188489f,
    (float16_t)0.689540545f, (float16_t)-0.724247083f,
    (float16_t)0.688428753f, (float16_t)-0.725303972f,
    (float16_t)0.687315341f, (float16_t)-0.726359155f,
    (float16_t)0.686200312f, (float16_t)-0.727412629f,
    (float16_t)0.685083668f, (float16_t)-0.728464390f,
    (float16_t)0.683965412f, (float16_t)-0.729514438f,
    (float16_t)0.682845546f, (float16_t)-0.730562769f,
    (float16_t)0.681724074f, (float16_t)-0.731609381f,
    (float16_t)0.680600998f, (float16_t)-0.732654272f,
    (float16_t)0.679476320f, (float16_t)-0.733697438f,
    (float16_t)0.678350043f, (float16_t)-0.734738878f,
    (float16_t)0.677222170f, (float16_t)-0.735778589f,
    (float16_t)0.676092704f, (float16_t)-0.736816569f,
    (float16_t)0.674961646f, (float16_t)-0.737852815f,
    (float16_t)0.673829000f, (float16_t)-0.738887324f,
    (float16_t)0.672694769f, (float16_t)-0.739920095f,
    (float16_t)0.671558955f, (float16_t)-0.740951125f,
    (float16_t)0.670421560f, (float16_t)-0.741980412f,
    (float16_t)0.669282588f, (float16_t)-0.743007952f,
    (float16_t)0.668142041f, (float16_t)-0.744033744f,
    (float16_t)0.666999922f, (float16_t)-0.745057785f,
    (float16_t)0.665856234f, (float16_t)-0.746080074f,
    (float16_t)0.664710978f, (float16_t)-0.747100606f,
    (float16_t)0.663564159f, (float16_t)-0.748119380f,
    (float16_t)0.662415778f, (float16_t)-0.749136395f,
    (float16_t)0.661265838f, (float16_t)-0.750151646f,
    (float16_t)0.660114342f, (float16_t)-0.751165132f,
    (float16_t)0.658961293f, (float16_t)-0.752176850f,
    (float16_t)0.657806693f, (float16_t)-0.753186799f,
    (float16_t)0.656650546f, (float16_t)-0.754194975f,
    (float16_t)0.655492853f, (float16_t)-0.755201377f,
    (float16_t)0.654333618f, (float16_t)-0.756206001f,
    (float16_t)0.653172843f, (float16_t)-0.757208847f,
    (float16_t)0.652010531f, (float16_t)-0.758209910f,
    (float16_t)0.650846685f, (float16_t)-0.759209189f,
    (float16_t)0.649681307f, (float16_t)-0.760206682f,
    (float16_t)0.648514401f, (float16_t)-0.761202385f,
    (float16_t)0.647345969f, (float16_t)-0.762196298f,
    (float16_t)0.646176013f, (float16_t)-0.763188417f,
    (float16_t)0.645004537f, (float16_t)-0.764178741f,
    (float16_t)0.643831543f, (float16_t)-0.765167266f,
    (float16_t)0.642657034f, (float16_t)-0.766153990f,
    (float16_t)0.641481013f, (float16_t)-0.767138912f,
    (float16_t)0.640303482f, (float16_t)-0.768122029f,
    (float16_t)0.639124445f, (float16_t)-0.769103338f,
    (float16_t)0.637943904f, (float16_t)-0.770082837f,
    (float16_t)0.636761861f, (float16_t)-0.771060524f,
    (float16_t)0.635578320f, (float16_t)-0.772036397f,
    (float16_t)0.634393284f, (float16_t)-0.773010453f,
    (float16_t)0.633206755f, (float16_t)-0.773982691f,
    (float16_t)0.632018736f, (float16_t)-0.774953107f,
    (float16_t)0.630829230f, (float16_t)-0.775921699f,
    (float16_t)0.629638239f, (float16_t)-0.776888466f,
    (float16_t)0.628445767f, (float16_t)-0.777853404f,
    (float16_t)0.627251815f, (float16_t)-0.778816512f,
    (float16_t)0.626056388f, (float16_t)-0.779777788f,
    (float16_t)0.624859488f, (float16_t)-0.780737229f,
    (float16_t)0.623661118f, (float16_t)-0.781694832f,
    (float16_t)0.622461279f, (float16_t)-0.782650596f,
    (float16_t)0.621259977f, (float16_t)-0.783604519f,
    (float16_t)0.620057212f, (float16_t)-0.784556597f,
    (float16_t)0.618852988f, (float16_t)-0.785506830f,
    (float16_t)0.617647308f, (float16_t)-0.786455214f,
    (float16_t)0.616440175f, (float16_t)-0.787401747f,
    (float16_t)0.615231591f, (float16_t)-0.788346428f,
    (float16_t)0.614021559f, (float16_t)-0.789289253f,
    (float16_t)0.612810082f, (float16_t)-0.790230221f,
    (float16_t)0.611597164f, (float16_t)-0.791169330f,
    (float16_t)0.610382806f, (float16_t)-0.792106577f,
    (float16_t)0.609167012f, (float16_t)-0.793041960f,
    (float16_t)0.607949785f, (float16_t)-0.793975478f,
    (float16_t)0.606731127f, (float16_t)-0.794907126f,
    (float16_t)0.605511041f, (float16_t)-0.795836905f,
    (float16_t)0.604289531f, (float16_t)-0.796764810f,
    (float16_t)0.603066599f, (float16_t)-0.797690841f,
    (float16_t)0.601842247f, (float16_t)-0.798614995f,
    (float16_t)0.600616479f, (float16_t)-0.799537269f,
    (float16_t)0.599389298f, (float16_t)-0.800457662f,
    (float16_t)0.598160707f, (float16_t)-0.801376172f,
    (float16_t)0.596930708f, (float16_t)-0.802292796f,
    (float16_t)0.595699304f, (float16_t)-0.803207531f,
    (float16_t)0.594466499f, (float16_t)-0.804120377f,
    (float16_t)0.593232295f, (float16_t)-0.805031331f,
    (float16_t)0.591996695f, (float16_t)-0.805940391f,
    (float16_t)0.590759702f, (float16_t)-0.806847554f,
    (float16_t)0.589521319f, (float16_t)-0.807752818f,
    (float16_t)0.588281548f, (float16_t)-0.808656182f,
    (float16_t)0.587040394f, (float16_t)-0.809557642f,
    (float16_t)0.585797857f, (float16_t)-0.810457198f,
    (float16_t)0.584553943f, (float16_t)-0.811354847f,
    (float16_t)0.583308653f, (float16_t)-0.812250587f,
    (float16_t)0.582061990f, (float16_t)-0.813144415f,
    (float16_t)0.580813958f, (float16_t)-0.814036330f,
    (float16_t)0.579564559f, (float16_t)-0.814926329f,
    (float16_t)0.578313796f, (float16_t)-0.815814411f,
    (float16_t)0.577061673f, (float16_t)-0.816700573f,
    (float16_t)0.575808191f, (float16_t)-0.817584813f,
    (float16_t)0.574553355f, (float16_t)-0.818467130f,
    (float16_t)0.573297167f, (float16_t)-0.819347520f,
    (float16_t)0.572039629f, (float16_t)-0.820225983f,
    (float16_t)0.570780746f, (float16_t)-0.821102515f,
    (float16_t)0.569520519f, (float16_t)-0.821977115f,
    (float16_t)0.568258953f, (float16_t)-0.822849781f,
    (float16_t)0.566996049f, (float16_t)-0.823720511f,
    (float16_t)0.565731811f, (float16_t)-0.824589303f,
    (float16_t)0.564466242f, (float16_t)-0.825456154f,
    (float16_t)0.563199344f, (float16_t)-0.826321063f,
    (float16_t)0.561931121f, (float16_t)-0.827184027f,
    (float16_t)0.560661576f, (float16_t)-0.828045045f,
    (float16_t)0.559390712f, (float16_t)-0.828904115f,
    (float16_t)0.558118531f, (float16_t)-0.829761234f,
    (float16_t)0.556845037f, (float16_t)-0.830616400f,
    (float16_t)0.555570233f, (float16_t)-0.831469612f,
    (float16_t)0.554294121f, (float16_t)-0.832320868f,
    (float16_t)0.553016706f, (float16_t)-0.833170165f,
    (float16_t)0.551737988f, (float16_t)-0.834017501f,
    (float16_t)0.550457973f, (float16_t)-0.834862875f,
    (float16_t)0.549176662f, (float16_t)-0.835706284f,
    (float16_t)0.547894059f, (float16_t)-0.836547727f,
    (float16_t)0.546610167f, (float16_t)-0.837387202f,
    (float16_t)0.545324988f, (float16_t)-0.838224706f,
    (float16_t)0.544038527f, (float16_t)-0.839060237f,
    (float16_t)0.542750785f, (float16_t)-0.839893794f,
    (float16_t)0.541461766f, (float16_t)-0.840725375f,
    (float16_t)0.540171473f, (float16_t)-0.841554977f,
    (float16_t)0.538879909f, (float16_t)-0.842382600f,
    (float16_t)0.537587076f, (float16_t)-0.843208240f,
    (float16_t)0.536292979f, (float16_t)-0.844031895f,
    (float16_t)0.534997620f, (float16_t)-0.844853565f,
    (float16_t)0.533701002f, (float16_t)-0.845673247f,
    (float16_t)0.532403128f, (float16_t)-0.846490939f,
    (float16_t)0.531104001f, (float16_t)-0.847306639f,
    (float16_t)0.529803625f, (float16_t)-0.848120345f,
    (float16_t)0.528502002f, (float16_t)-0.848932055f,
    (float16_t)0.527199135f, (float16_t)-0.849741768f,
    (float16_t)0.525895027f, (float16_t)-0.850549481f,
    (float16_t)0.524589683f, (float16_t)-0.851355193f,
    (float16_t)0.523283103f, (float16_t)-0.852158902f,
    (float16_t)0.521975293f, (float16_t)-0.852960605f,
    (float16_t)0.520666254f, (float16_t)-0.853760301f,
    (float16_t)0.519355990f, (float16_t)-0.854557988f,
    (float16_t)0.518044504f, (float16_t)-0.855353665f,
    (float16_t)0.516731799f, (float16_t)-0.856147328f,
    (float16_t)0.515417878f, (float16_t)-0.856938977f,
    (float16_t)0.514102744f, (float16_t)-0.857728610f,
    (float16_t)0.512786401f, (float16_t)-0.858516224f,
    (float16_t)0.511468850f, (float16_t)-0.859301818f,
    (float16_t)0.510150097f, (float16_t)-0.860085390f,
    (float16_t)0.508830143f, (float16_t)-0.860866939f,
    (float16_t)0.507508991f, (float16_t)-0.861646461f,
    (float16_t)0.506186645f, (float16_t)-0.862423956f,
    (float16_t)0.504863109f, (float16_t)-0.863199422f,
    (float16_t)0.503538384f, (float16_t)-0.863972856f,
    (float16_t)0.502212474f, (float16_t)-0.864744258f,
    (float16_t)0.500885383f, (float16_t)-0.865513624f,
    (float16_t)0.499557113f, (float16_t)-0.866280954f,
    (float16_t)0.498227667f, (float16_t)-0.867046246f,
    (float16_t)0.496897049f, (float16_t)-0.867809497f,
    (float16_t)0.495565262f, (float16_t)-0.868570706f,
    (float16_t)0.494232309f, (float16_t)-0.869329871f,
    (float16_t)0.492898192f, (float16_t)-0.870086991f,
    (float16_t)0.491562916f, (float16_t)-0.870842063f,
    (float16_t)0.490226483f, (float16_t)-0.871595087f,
    (float16_t)0.488888897f, (float16_t)-0.872346059f,
    (float16_t)0.487550160f, (float16_t)-0.873094978f,
    (float16_t)0.486210276f, (float16_t)-0.873841843f,
    (float16_t)0.484869248f, (float16_t)-0.874586652f,
    (float16_t)0.483527079f, (float16_t)-0.875329403f,
    (float16_t)0.482183772f, (float16_t)-0.876070094f,
    (float16_t)0.480839331f, (float16_t)-0.876808724f,
    (float16_t)0.479493758f, (float16_t)-0.877545290f,
    (float16_t)0.478147056f, (float16_t)-0.878279792f,
    (float16_t)0.476799230f, (float16_t)-0.879012226f,
    (float16_t)0.475450282f, (float16_t)-0.879742593f,
    (float16_t)0.474100215f, (float16_t)-0.880470889f,
    (float16_t)0.472749032f, (float16_t)-0.881197113f,
    (float16_t)0.471396737f, (float16_t)-0.881921264f,
    (float16_t)0.470043332f, (float16_t)-0.882643340f,
    (float16_t)0.468688822f, (float16_t)-0.883363339f,
    (float16_t)0.467333209f, (float16_t)-0.884081259f,
    (float16_t)0.465976496f, (float16_t)-0.884797098f,
    (float16_t)0.464618686f, (float16_t)-0.885510856f,
    (float16_t)0.463259784f, (float16_t)-0.886222530f,
    (float16_t)0.461899791f, (float16_t)-0.886932119f,
    (float16_t)0.460538711f, (float16_t)-0.887639620f,
    (float16_t)0.459176548f, (float16_t)-0.888345033f,
    (float16_t)0.457813304f, (float16_t)-0.889048356f,
    (float16_t)0.456448982f, (float16_t)-0.889749586f,
    (float16_t)0.455083587f, (float16_t)-0.890448723f,
    (float16_t)0.453717121f, (float16_t)-0.891145765f,
    (float16_t)0.452349587f, (float16_t)-0.891840709f,
    (float16_t)0.450980989f, (float16_t)-0.892533555f,
    (float16_t)0.449611330f, (float16_t)-0.893224301f,
    (float16_t)0.448240612f, (float16_t)-0.893912945f,
    (float16_t)0.446868840f, (float16_t)-0.894599486f,
    (float16_t)0.445496017f, (float16_t)-0.895283921f,
    (float16_t)0.444122145f, (float16_t)-0.895966250f,
    (float16_t)0.442747228f, (float16_t)-0.896646470f,
    (float16_t)0.441371269f, (float16_t)-0.897324581f,
    (float16_t)0.439994271f, (float16_t)-0.898000580f,
    (float16_t)0.438616239f, (float16_t)-0.898674466f,
    (float16_t)0.437237174f, (float16_t)-0.899346237f,
    (float16_t)0.435857080f, (float16_t)-0.900015892f,
    (float16_t)0.434475961f, (float16_t)-0.900683429f,
    (float16_t)0.433093819f, (float16_t)-0.901348847f,
    (float16_t)0.431710658f, (float16_t)-0.902012144f,
    (float16_t)0.430326481f, (float16_t)-0.902673318f,
    (float16_t)0.428941292f, (float16_t)-0.903332368f,
    (float16_t)0.427555093f, (float16_t)-0.903989293f,
    (float16_t)0.426167889f, (float16_t)-0.904644091f,
    (float16_t)0.424779681f, (float16_t)-0.905296759f,
    (float16_t)0.423390474f, (float16_t)-0.905947298f,
    (float16_t)0.422000271f, (float16_t)-0.906595705f,
    (float16_t)0.420609074f, (float16_t)-0.907241978f,
    (float16_t)0.419216888f, (float16_t)-0.907886116f,
    (float16_t)0.417823716f, (float16_t)-0.908528119f,
    (float16_t)0.416429560f, (float16_t)-0.909167983f,
    (float16_t)0.415034424f, (float16_t)-0.909805708f,
    (float16_t)0.413638312f, (float16_t)-0.910441292f,
    (float16_t)0.412241227f, (float16_t)-0.911074734f,
    (float16_t)0.410843171f, (float16_t)-0.911706032f,
    (float16_t)0.409444149f, (float16_t)-0.912335185f,
    (float16_t)0.408044163f, (float16_t)-0.912962190f,
    (float16_t)0.406643217f, (float16_t)-0.913587048f,
    (float16_t)0.405241314f, (float16_t)-0.914209756f,
    (float16_t)0.403838458f, (float16_t)-0.914830312f,
    (float16_t)0.402434651f, (float16_t)-0.915448716f,
    (float16_t)0.401029897f, (float16_t)-0.916064966f,
    (float16_t)0.399624200f, (float16_t)-0.916679060f,
    (float16_t)0.398217562f, (float16_t)-0.917290997f,
    (float16_t)0.396809987f, (float16_t)-0.917900776f,
    (float16_t)0.395401479f, (float16_t)-0.918508394f,
    (float16_t)0.393992040f, (float16_t)-0.919113852f,
    (float16_t)0.392581674f, (float16_t)-0.919717146f,
    (float16_t)0.391170384f, (float16_t)-0.920318277f,
    (float16_t)0.389758174f, (float16_t)-0.920917242f,
    (float16_t)0.388345047f, (float16_t)-0.921514039f,
    (float16_t)0.386931006f, (float16_t)-0.922108669f,
    (float16_t)0.385516054f, (float16_t)-0.922701128f,
    (float16_t)0.384100195f, (float16_t)-0.923291417f,
    (float16_t)0.382683432f, (float16_t)-0.923879533f,
    (float16_t)0.381265769f, (float16_t)-0.924465474f,
    (float16_t)0.379847209f, (float16_t)-0.925049241f,
    (float16_t)0.378427755f, (float16_t)-0.925630831f,
    (float16_t)0.377007410f, (float16_t)-0.926210242f,
    (float16_t)0.375586178f, (float16_t)-0.926787474f,
    (float16_t)0.374164063f, (float16_t)-0.927362526f,
    (float16_t)0.372741067f, (float16_t)-0.927935395f,
    (float16_t)0.371317194f, (float16_t)-0.928506080f,
    (float16_t)0.369892447f, (float16_t)-0.929074581f,
    (float16_t)0.368466830f, (float16_t)-0.929640896f,
    (float16_t)0.367040346f, (float16_t)-0.930205023f,
    (float16_t)0.365612998f, (float16_t)-0.930766961f,
    (float16_t)0.364184790f, (float16_t)-0.931326709f,
    (float16_t)0.362755724f, (float16_t)-0.931884266f,
    (float16_t)0.361325806f, (float16_t)-0.932439629f,
    (float16_t)0.359895037f, (float16_t)-0.932992799f,
    (float16_t)0.358463421f, (float16_t)-0.933543773f,
    (float16_t)0.357030961f, (float16_t)-0.934092550f,
    (float16_t)0.355597662f, (float16_t)-0.934639130f,
    (float16_t)0.354163525f, (float16_t)-0.935183510f,
    (float16_t)0.352728556f, (float16_t)-0.935725689f,
    (float16_t)0.351292756f, (float16_t)-0.936265667f,
    (float16_t)0.349856130f, (float16_t)-0.936803442f,
    (float16_t)0.348418680f, (float16_t)-0.937339012f,
    (float16_t)0.346980411f, (float16_t)-0.937872376f,
    (float16_t)0.345541325f, (float16_t)-0.938403534f,
    (float16_t)0.344101426f, (float16_t)-0.938932484f,
    (float16_t)0.342660717f, (float16_t)-0.939459224f,
    (float16_t)0.341219202f, (float16_t)-0.939983753f,
    (float16_t)0.339776884f, (float16_t)-0.940506071f,
    (float16_t)0.338333767f, (float16_t)-0.941026175f,
    (float16_t)0.336889853f, (float16_t)-0.941544065f,
    (float16_t)0.335445147f, (float16_t)-0.942059740f,
    (float16_t)0.333999651f, (float16_t)-0.942573198f,
    (float16_t)0.332553370f, (float16_t)-0.943084437f,
    (float16_t)0.331106306f, (float16_t)-0.943593458f,
    (float16_t)0.329658463f, (float16_t)-0.944100258f,
    (float16_t)0.328209844f, (float16_t)-0.944604837f,
    (float16_t)0.326760452f, (float16_t)-0.945107193f,
    (float16_t)0.325310292f, (float16_t)-0.945607325f,
    (float16_t)0.323859367f, (float16_t)-0.946105232f,
    (float16_t)0.322407679f, (float16_t)-0.946600913f,
    (float16_t)0.320955232f, (float16_t)-0.947094366f,
    (float16_t)0.319502031f, (float16_t)-0.947585591f,
    (float16_t)0.318048077f, (float16_t)-0.948074586f,
    (float16_t)0.316593376f, (float16_t)-0.948561350f,
    (float16_t)0.315137929f, (float16_t)-0.949045882f,
    (float16_t)0.313681740f, (float16_t)-0.949528181f,
    (float16_t)0.312224814f, (float16_t)-0.950008245f,
    (float16_t)0.310767153f, (float16_t)-0.950486074f,
    (float16_t)0.309308760f, (float16_t)-0.950961666f,
    (float16_t)0.307849640f, (float16_t)-0.951435021f,
    (float16_t)0.306389795f, (float16_t)-0.951906137f,
    (float16_t)0.304929230f, (float16_t)-0.952375013f,
    (float16_t)0.303467947f, (float16_t)-0.952841648f,
    (float16_t)0.302005949f, (float16_t)-0.953306040f,
    (float16_t)0.300543241f, (float16_t)-0.953768190f,
    (float16_t)0.299079826f, (float16_t)-0.954228095f,
    (float16_t)0.297615707f, (float16_t)-0.954685755f,
    (float16_t)0.296150888f, (float16_t)-0.955141168f,
    (float16_t)0.294685372f, (float16_t)-0.955594334f,
    (float16_t)0.293219163f, (float16_t)-0.956045251f,
    (float16_t)0.291752263f, (float16_t)-0.956493919f,
    (float16_t)0.290284677f, (float16_t)-0.956940336f,
    (float16_t)0.288816408f, (float16_t)-0.957384501f,
    (float16_t)0.287347460f, (float16_t)-0.957826413f,
    (float16_t)0.285877835f, (float16_t)-0.958266071f,
    (float16_t)0.284407537f, (float16_t)-0.958703475f,
    (float16_t)0.282936570f, (float16_t)-0.959138622f,
    (float16_t)0.281464938f, (float16_t)-0.959571513f,
    (float16_t)0.279992643f, (float16_t)-0.960002146f,
    (float16_t)0.278519689f, (float16_t)-0.960430519f,
    (float16_t)0.277046080f, (float16_t)-0.960856633f,
    (float16_t)0.275571819f, (float16_t)-0.961280486f,
    (float16_t)0.274096910f, (float16_t)-0.961702077f,
    (float16_t)0.272621355f, (float16_t)-0.962121404f,
    (float16_t)0.271145160f, (float16_t)-0.962538468f,
    (float16_t)0.269668326f, (float16_t)-0.962953267f,
    (float16_t)0.268190857f, (float16_t)-0.963365800f,
    (float16_t)0.266712757f, (float16_t)-0.963776066f,
    (float16_t)0.265234030f, (float16_t)-0.964184064f,
    (float16_t)0.263754679f, (float16_t)-0.964589793f,
    (float16_t)0.262274707f, (float16_t)-0.964993253f,
    (float16_t)0.260794118f, (float16_t)-0.965394442f,
    (float16_t)0.259312915f, (float16_t)-0.965793359f,
    (float16_t)0.257831102f, (float16_t)-0.966190003f,
    (float16_t)0.256348682f, (float16_t)-0.966584374f,
    (float16_t)0.254865660f, (float16_t)-0.966976471f,
    (float16_t)0.253382037f, (float16_t)-0.967366292f,
    (float16_t)0.251897818f, (float16_t)-0.967753837f,
    (float16_t)0.250413007f, (float16_t)-0.968139105f,
    (float16_t)0.248927606f, (float16_t)-0.968522094f,
    (float16_t)0.247441619f, (float16_t)-0.968902805f,
    (float16_t)0.245955050f, (float16_t)-0.969281235f,
    (float16_t)0.244467903f, (float16_t)-0.969657385f,
    (float16_t)0.242980180f, (float16_t)-0.970031253f,
    (float16_t)0.241491885f, (float16_t)-0.970402839f,
    (float16_t)0.240003022f, (float16_t)-0.970772141f,
    (float16_t)0.238513595f, (float16_t)-0.971139158f,
    (float16_t)0.237023606f, (float16_t)-0.971503891f,
    (float16_t)0.235533059f, (float16_t)-0.971866337f,
    (float16_t)0.234041959f, (float16_t)-0.972226497f,
    (float16_t)0.232550307f, (float16_t)-0.972584369f,
    (float16_t)0.231058108f, (float16_t)-0.972939952f,
    (float16_t)0.229565366f, (float16_t)-0.973293246f,
    (float16_t)0.228072083f, (float16_t)-0.973644250f,
    (float16_t)0.226578264f, (float16_t)-0.973992962f,
    (float16_t)0.225083911f, (float16_t)-0.974339383f,
    (float16_t)0.223589029f, (float16_t)-0.974683511f,
    (float16_t)0.222093621f, (float16_t)-0.975025345f,
    (float16_t)0.220597690f, (float16_t)-0.975364885f,
    (float16_t)0.219101240f, (float16_t)-0.975702130f,
    (float16_t)0.217604275f, (float16_t)-0.976037079f,
    (float16_t)0.216106797f, (float16_t)-0.976369731f,
    (float16_t)0.214608811f, (float16_t)-0.976700086f,
    (float16_t)0.213110320f, (float16_t)-0.977028143f,
    (float16_t)0.211611327f, (float16_t)-0.977353900f,
    (float16_t)0.210111837f, (float16_t)-0.977677358f,
    (float16_t)0.208611852f, (float16_t)-0.977998515f,
    (float16_t)0.207111376f, (float16_t)-0.978317371f,
    (float16_t)0.205610413f, (float16_t)-0.978633924f,
    (float16_t)0.204108966f, (float16_t)-0.978948175f,
    (float16_t)0.202607039f, (float16_t)-0.979260123f,
    (float16_t)0.201104635f, (float16_t)-0.979569766f,
    (float16_t)0.199601758f, (float16_t)-0.979877104f,
    (float16_t)0.198098411f, (float16_t)-0.980182136f,
    (float16_t)0.196594598f, (float16_t)-0.980484862f,
    (float16_t)0.195090322f, (float16_t)-0.980785280f,
    (float16_t)0.193585587f, (float16_t)-0.981083391f,
    (float16_t)0.192080397f, (float16_t)-0.981379193f,
    (float16_t)0.190574755f, (float16_t)-0.981672686f,
    (float16_t)0.189068664f, (float16_t)-0.981963869f,
    (float16_t)0.187562129f, (float16_t)-0.982252741f,
    (float16_t)0.186055152f, (float16_t)-0.982539302f,
    (float16_t)0.184547737f, (float16_t)-0.982823551f,
    (float16_t)0.183039888f, (float16_t)-0.983105487f,
    (float16_t)0.181531608f, (float16_t)-0.983385110f,
    (float16_t)0.180022901f, (float16_t)-0.983662419f,
    (float16_t)0.178513771f, (float16_t)-0.983937413f,
    (float16_t)0.177004220f, (float16_t)-0.984210092f,
    (float16_t)0.175494253f, (float16_t)-0.984480455f,
    (float16_t)0.173983873f, (float16_t)-0.984748502f,
    (float16_t)0.172473084f, (float16_t)-0.985014231f,
    (float16_t)0.170961889f, (float16_t)-0.985277642f,
    (float16_t)0.169450291f, (float16_t)-0.985538735f,
    (float16_t)0.167938295f, (float16_t)-0.985797509f,
    (float16_t)0.166425904f, (float16_t)-0.986053963f,
    (float16_t)0.164913120f, (float16_t)-0.986308097f,
    (float16_t)0.163399949f, (float16_t)-0.986559910f,
    (float16_t)0.161886394f, (float16_t)-0.986809402f,
    (float16_t)0.160372457f, (float16_t)-0.987056571f,
    (float16_t)0.158858143f, (float16_t)-0.987301418f,
    (float16_t)0.157343456f, (float16_t)-0.987543942f,
    (float16_t)0.155828398f, (float16_t)-0.987784142f,
    (float16_t)0.154312973f, (float16_t)-0.988022017f,
    (float16_t)0.152797185f, (float16_t)-0.988257568f,
    (float16_t)0.151281038f, (float16_t)-0.988490793f,
    (float16_t)0.149764535f, (float16_t)-0.988721692f,
    (float16_t)0.148247679f, (float16_t)-0.988950265f,
    (float16_t)0.146730474f, (float16_t)-0.989176510f,
    (float16_t)0.145212925f, (float16_t)-0.989400428f,
    (float16_t)0.143695033f, (float16_t)-0.989622017f,
    (float16_t)0.142176804f, (float16_t)-0.989841278f,
    (float16_t)0.140658239f, (float16_t)-0.990058210f,
    (float16_t)0.139139344f, (float16_t)-0.990272812f,
    (float16_t)0.137620122f, (float16_t)-0.990485084f,
    (float16_t)0.136100575f, (float16_t)-0.990695025f,
    (float16_t)0.134580709f, (float16_t)-0.990902635f,
    (float16_t)0.133060525f, (float16_t)-0.991107914f,
    (float16_t)0.131540029f, (float16_t)-0.991310860f,
    (float16_t)0.130019223f, (float16_t)-0.991511473f,
    (float16_t)0.128498111f, (float16_t)-0.991709754f,
    (float16_t)0.126976696f, (float16_t)-0.991905700f,
    (float16_t)0.125454983f, (float16_t)-0.992099313f,
    (float16_t)0.123932975f, (float16_t)-0.992290591f,
    (float16_t)0.122410675f, (float16_t)-0.992479535f,
    (float16_t)0.120888087f, (float16_t)-0.992666142f,
    (float16_t)0.119365215f, (float16_t)-0.992850414f,
    (float16_t)0.117842062f, (float16_t)-0.993032350f,
    (float16_t)0.116318631f, (float16_t)-0.993211949f,
    (float16_t)0.114794927f, (float16_t)-0.993389211f,
    (float16_t)0.113270952f, (float16_t)-0.993564136f,
    (float16_t)0.111746711f, (float16_t)-0.993736722f,
    (float16_t)0.110222207f, (float16_t)-0.993906970f,
    (float16_t)0.108697444f, (float16_t)-0.994074879f,
    (float16_t)0.107172425f, (float16_t)-0.994240449f,
    (float16_t)0.105647154f, (float16_t)-0.994403680f,
    (float16_t)0.104121634f, (float16_t)-0.994564571f,
    (float16_t)0.102595869f, (float16_t)-0.994723121f,
    (float16_t)0.101069863f, (float16_t)-0.994879331f,
    (float16_t)0.099543619f, (float16_t)-0.995033199f,
    (float16_t)0.098017140f, (float16_t)-0.995184727f,
    (float16_t)0.096490431f, (float16_t)-0.995333912f,
    (float16_t)0.094963495f, (float16_t)-0.995480755f,
    (float16_t)0.093436336f, (float16_t)-0.995625256f,
    (float16_t)0.091908956f, (float16_t)-0.995767414f,
    (float16_t)0.090381361f, (float16_t)-0.995907229f,
    (float16_t)0.088853553f, (float16_t)-0.996044701f,
    (float16_t)0.087325535f, (float16_t)-0.996179829f,
    (float16_t)0.085797312f, (float16_t)-0.996312612f,
    (float16_t)0.084268888f, (float16_t)-0.996443051f,
    (float16_t)0.082740265f, (float16_t)-0.996571146f,
    (float16_t)0.081211447f, (float16_t)-0.996696895f,
    (float16_t)0.079682438f, (float16_t)-0.996820299f,
    (float16_t)0.078153242f, (float16_t)-0.996941358f,
    (float16_t)0.076623861f, (float16_t)-0.997060070f,
    (float16_t)0.075094301f, (float16_t)-0.997176437f,
    (float16_t)0.073564564f, (float16_t)-0.997290457f,
    (float16_t)0.072034653f, (float16_t)-0.997402130f,
    (float16_t)0.070504573f, (float16_t)-0.997511456f,
    (float16_t)0.068974328f, (float16_t)-0.997618435f,
    (float16_t)0.067443920f, (float16_t)-0.997723067f,
    (float16_t)0.065913353f, (float16_t)-0.997825350f,
    (float16_t)0.064382631f, (float16_t)-0.997925286f,
    (float16_t)0.062851758f, (float16_t)-0.998022874f,
    (float16_t)0.061320736f, (float16_t)-0.998118113f,
    (float16_t)0.059789571f, (float16_t)-0.998211003f,
    (float16_t)0.058258265f, (float16_t)-0.998301545f,
    (float16_t)0.056726821f, (float16_t)-0.998389737f,
    (float16_t)0.055195244f, (float16_t)-0.998475581f,
    (float16_t)0.053663538f, (float16_t)-0.998559074f,
    (float16_t)0.052131705f, (float16_t)-0.998640218f,
    (float16_t)0.050599749f, (float16_t)-0.998719012f,
    (float16_t)0.049067674f, (float16_t)-0.998795456f,
    (float16_t)0.047535484f, (float16_t)-0.998869550f,
    (float16_t)0.046003182f, (float16_t)-0.998941293f,
    (float16_t)0.044470772f, (float16_t)-0.999010686f,
    (float16_t)0.042938257f, (float16_t)-0.999077728f,
    (float16_t)0.041405641f, (float16_t)-0.999142419f,
    (float16_t)0.039872928f, (float16_t)-0.999204759f,
    (float16_t)0.038340120f, (float16_t)-0.999264747f,
    (float16_t)0.036807223f, (float16_t)-0.999322385f,
    (float16_t)0.035274239f, (float16_t)-0.999377670f,
    (float16_t)0.033741172f, (float16_t)-0.999430605f,
    (float16_t)0.032208025f, (float16_t)-0.999481187f,
    (float16_t)0.030674803f, (float16_t)-0.999529418f,
    (float16_t)0.029141509f, (float16_t)-0.999575296f,
    (float16_t)0.027608146f, (float16_t)-0.999618822f,
    (float16_t)0.026074718f, (float16_t)-0.999659997f,
    (float16_t)0.024541229f, (float16_t)-0.999698819f,
    (float16_t)0.023007681f, (float16_t)-0.999735288f,
    (float16_t)0.021474080f, (float16_t)-0.999769405f,
    (float16_t)0.019940429f, (float16_t)-0.999801170f,
    (float16_t)0.018406730f, (float16_t)-0.999830582f,
    (float16_t)0.016872988f, (float16_t)-0.999857641f,
    (float16_t)0.015339206f, (float16_t)-0.999882347f,
    (float16_t)0.013805389f, (float16_t)-0.999904701f,
    (float16_t)0.012271538f, (float16_t)-0.999924702f,
    (float16_t)0.010737659f, (float16_t)-0.999942350f,
    (float16_t)0.009203755f, (float16_t)-0.999957645f,
    (float16_t)0.007669829f, (float16_t)-0.999970586f,
    (float16_t)0.006135885f, (float16_t)-0.999981175f,
    (float16_t)0.004601926f, (float16_t)-0.999989411f,
    (float16_t)0.003067957f, (float16_t)-0.999995294f,
    (float16_t)0.001533980f, (float16_t)-0.999998823f
};

#endif /* if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALL_TABLES) */

#endif /*!defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES)*/

#if (defined(ARM_MATH_MVEF) || defined(ARM_MATH_HELIUM)) && !defined(ARM_MATH_AUTOVECTORIZE)
const float16_t exp_tab_f16[8] = {
    (1.f16),
    (0.0416598916054f16),
    (0.500000596046f16),
    (0.00138889f16),
    (1.00000011921f16),
    (0.00833693705499f16),
    (0.166665703058f16),
    (0.000195780929062f16),
};

const float16_t __logf_lut_f16[8] = {
    -2.295614848256274f16,         /*p0*/
    -2.470711633419806f16,         /*p4*/
    -5.686926051100417f16,         /*p2*/
    -0.165253547131978f16,         /*p6*/
    +5.175912446351073f16,         /*p1*/
    +0.844006986174912f16,         /*p5*/
    +4.584458825456749f16,         /*p3*/
    +0.014127821926000f16          /*p7*/
};

#endif /* (defined(ARM_MATH_MVEF) || defined(ARM_MATH_HELIUM)) && !defined(ARM_MATH_AUTOVECTORIZE) */


#endif /* #if defined(ARM_FLOAT16_SUPPORTED) */

#endif /* Not ARM AC5 */


/**
  @} end of CFFT_CIFFT group
*/

#endif // EIDSP_LOAD_CMSIS_DSP_SOURCES
