/* Generated by Edge Impulse
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
// Generated on: 04.03.2023 16:58:50

#include <stdio.h>
#include <stdlib.h>
#include "edge-impulse-sdk/tensorflow/lite/c/builtin_op_data.h"
#include "edge-impulse-sdk/tensorflow/lite/c/common.h"
#include "edge-impulse-sdk/tensorflow/lite/micro/micro_mutable_op_resolver.h"
#include "edge-impulse-sdk/porting/ei_classifier_porting.h"

#if EI_CLASSIFIER_PRINT_STATE
#if defined(__cplusplus) && EI_C_LINKAGE == 1
extern "C" {
    extern void ei_printf(const char *format, ...);
}
#else
extern void ei_printf(const char *format, ...);
#endif
#endif

#if defined __GNUC__
#define ALIGN(X) __attribute__((aligned(X)))
#elif defined _MSC_VER
#define ALIGN(X) __declspec(align(X))
#elif defined __TASKING__
#define ALIGN(X) __align(X)
#endif

#ifndef EI_MAX_SCRATCH_BUFFER_COUNT
#define EI_MAX_SCRATCH_BUFFER_COUNT 14
#endif // EI_MAX_SCRATCH_BUFFER_COUNT

#ifndef EI_MAX_OVERFLOW_BUFFER_COUNT
#define EI_MAX_OVERFLOW_BUFFER_COUNT 10
#endif // EI_MAX_OVERFLOW_BUFFER_COUNT

using namespace tflite;
using namespace tflite::ops;
using namespace tflite::ops::micro;

namespace {

constexpr int kTensorArenaSize = 241424;

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX)
#pragma Bss(".tensor_arena")
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#pragma Bss()
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16) __attribute__((section(".tensor_arena")));
#else
#define EI_CLASSIFIER_ALLOCATION_HEAP 1
uint8_t* tensor_arena = NULL;
#endif

static uint8_t* tensor_boundary;
static uint8_t* current_location;

template <int SZ, class T> struct TfArray {
  int sz; T elem[SZ];
};
enum used_operators_e {
  OP_CONV_2D, OP_DEPTHWISE_CONV_2D, OP_PAD, OP_ADD, OP_SOFTMAX,  OP_LAST
};
struct TensorInfo_t { // subset of TfLiteTensor used for initialization from constant memory
  TfLiteAllocationType allocation_type;
  TfLiteType type;
  void* data;
  TfLiteIntArray* dims;
  size_t bytes;
  TfLiteQuantization quantization;
};
struct NodeInfo_t { // subset of TfLiteNode used for initialization from constant memory
  struct TfLiteIntArray* inputs;
  struct TfLiteIntArray* outputs;
  void* builtin_data;
  used_operators_e used_op_index;
};

TfLiteContext ctx{};
TfLiteTensor tflTensors[71];
TfLiteEvalTensor tflEvalTensors[71];
TfLiteRegistration registrations[OP_LAST];
TfLiteNode tflNodes[27];

const TfArray<4, int> tensor_dimension0 = { 4, { 1,96,96,3 } };
const TfArray<1, float> quant0_scale = { 1, { 0.0039215688593685627, } };
const TfArray<1, int> quant0_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant0 = { (TfLiteFloatArray*)&quant0_scale, (TfLiteIntArray*)&quant0_zero, 0 };
const ALIGN(16) int32_t tensor_data1[4*2] = { 
  0, 0, 
  0, 1, 
  0, 1, 
  0, 0, 
};
const TfArray<2, int> tensor_dimension1 = { 2, { 4,2 } };
const ALIGN(16) int8_t tensor_data2[16*3*3*3] = { 
  /* [0][0][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [0][1][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [0][2][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [1][0][][] */ 48,-9,29, -2,-28,14, -124,-127,-68, 
  /* [1][1][][] */ 3,-12,-3, -20,-5,-6, 3,-40,3, 
  /* [1][2][][] */ -4,7,-4, -4,-3,-5, 39,-29,9, 
  /* [2][0][][] */ 38,5,2, 82,117,1, 48,-29,12, 
  /* [2][1][][] */ 19,20,7, 76,127,-23, 29,3,0, 
  /* [2][2][][] */ 56,-52,27, 78,-31,-10, 38,-44,22, 
  /* [3][0][][] */ -2,33,6, 23,89,22, -2,5,-4, 
  /* [3][1][][] */ 17,43,12, 59,127,29, -15,-18,3, 
  /* [3][2][][] */ 7,9,9, 24,31,12, -2,-2,3, 
  /* [4][0][][] */ 27,69,-14, 4,80,-15, -25,7,-6, 
  /* [4][1][][] */ 36,94,44, 21,123,26, 20,53,-15, 
  /* [4][2][][] */ 49,88,29, 39,127,9, -25,28,19, 
  /* [5][0][][] */ 19,-4,-114, 8,-3,-95, 6,27,-19, 
  /* [5][1][][] */ 16,-53,-127, 11,-55,-116, 12,9,-19, 
  /* [5][2][][] */ 8,3,-18, 14,-8,-14, 15,9,-12, 
  /* [6][0][][] */ 28,-62,34, 49,-89,40, 12,-19,11, 
  /* [6][1][][] */ 41,-94,64, 67,-127,74, 10,-26,20, 
  /* [6][2][][] */ 24,-32,15, 17,-42,28, -10,10,2, 
  /* [7][0][][] */ -33,16,2, -121,-44,-3, -28,23,-3, 
  /* [7][1][][] */ -10,-9,-1, -127,-99,-10, -3,-6,3, 
  /* [7][2][][] */ -19,33,-10, -8,12,-1, -18,27,-3, 
  /* [8][0][][] */ -76,-112,-77, -81,-117,-86, -25,-93,-77, 
  /* [8][1][][] */ -85,-116,-81, -90,-120,-89, -34,-96,-79, 
  /* [8][2][][] */ -100,-124,-91, -104,-127,-97, -55,-107,-89, 
  /* [9][0][][] */ -19,-3,11, -10,-7,3, 9,7,-4, 
  /* [9][1][][] */ 99,116,-10, 77,127,16, -4,19,31, 
  /* [9][2][][] */ -24,-24,17, 5,-31,0, 13,3,-20, 
  /* [10][0][][] */ -25,-83,-19, 34,95,20, -9,-12,-2, 
  /* [10][1][][] */ -59,-102,-14, 78,127,14, -17,-26,-1, 
  /* [10][2][][] */ -32,-19,2, 36,23,-11, -9,-1,7, 
  /* [11][0][][] */ -16,-27,-4, 12,-40,2, 11,-100,-55, 
  /* [11][1][][] */ -51,-46,-22, -35,-63,-41, -14,-59,-57, 
  /* [11][2][][] */ -8,-40,-77, 117,127,66, -40,13,-46, 
  /* [12][0][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [12][1][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [12][2][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [13][0][][] */ -51,-97,-17, -62,-111,-24, -9,-17,-5, 
  /* [13][1][][] */ 61,114,16, 57,127,25, 8,16,12, 
  /* [13][2][][] */ -9,-19,4, 0,-19,-1, 0,4,-3, 
  /* [14][0][][] */ 48,-3,-33, 79,-23,-47, 31,-9,-19, 
  /* [14][1][][] */ 90,-13,-68, 127,-37,-84, 58,-17,-36, 
  /* [14][2][][] */ 57,-6,-42, 75,-18,-51, 25,-6,-20, 
  /* [15][0][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [15][1][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [15][2][][] */ 0,0,0, 0,0,0, 0,0,0, 
};
const TfArray<4, int> tensor_dimension2 = { 4, { 16,3,3,3 } };
const TfArray<16, float> quant2_scale = { 16, { 3.3410194077987398e-07, 0.033742602914571762, 0.034889165312051773, 0.0090479478240013123, 0.0028613882604986429, 0.037828203290700912, 0.011776522733271122, 0.066202573478221893, 0.0012400586856529117, 0.010186105966567993, 0.037407796829938889, 0.0017984617734327912, 2.9411381774480105e-07, 0.033440303057432175, 0.0075266240164637566, 3.1706054670621597e-08, } };
const TfArray<16, int> quant2_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant2 = { (TfLiteFloatArray*)&quant2_scale, (TfLiteIntArray*)&quant2_zero, 0 };
const ALIGN(16) int32_t tensor_data3[16] = { -1073741824, 36993, -172151, 3563, 245451, 16772, 63232, 40932, 499363, 23016, 20887, 836506, -1073741824, 28717, 63014, -1073741824, };
const TfArray<1, int> tensor_dimension3 = { 1, { 16 } };
const TfArray<16, float> quant3_scale = { 16, { 1.3102037232926023e-09, 0.00013232394121587276, 0.0001368202647427097, 3.5482149542076513e-05, 1.122113098972477e-05, 0.00014834590547252446, 4.6182445657905191e-05, 0.00025961795472539961, 4.8629754019202664e-06, 3.9945516618900001e-05, 0.00014669724623672664, 7.0527917159779463e-06, 1.1533876076441629e-09, 0.00013113845488987863, 2.9516173526644707e-05, 1.243374708748135e-10, } };
const TfArray<16, int> quant3_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant3 = { (TfLiteFloatArray*)&quant3_scale, (TfLiteIntArray*)&quant3_zero, 0 };
const ALIGN(16) int8_t tensor_data4[1*3*3*16] = { 
  /* [0][0][][] */ -108,19,-82,-127,39,-67,80,-76,-89,-3,-8,29,-127,4,54,-73, 51,25,-127,127,127,-127,127,-127,-84,127,-127,51,-105,5,127,-25, 24,-24,91,-2,-72,66,-94,77,-95,-27,4,-16,61,1,-101,-29, 
  /* [0][1][][] */ -127,127,-22,13,-44,14,-28,14,-27,0,3,-110,-49,8,-30,-14, -78,-41,-58,-15,-8,-26,8,-28,-108,-89,21,-12,-104,-127,1,23, 14,1,65,2,3,33,-25,33,-127,6,-2,1,-21,11,-4,43, 
  /* [0][2][][] */ -115,-72,68,2,-6,38,-39,52,-76,0,0,5,40,1,-27,23, 23,-4,31,-2,-27,39,-34,20,-124,-13,0,84,-58,0,-28,-111, 21,-7,19,0,4,13,9,22,-115,4,-1,-127,107,2,17,-127, 
};
const TfArray<4, int> tensor_dimension4 = { 4, { 1,3,3,16 } };
const TfArray<16, float> quant4_scale = { 16, { 0.079427838325500488, 0.0050576655194163322, 0.16792894899845123, 0.013399734161794186, 0.0064524891786277294, 0.0022549829445779324, 0.01660165935754776, 0.0016478551551699638, 0.00070792215410619974, 0.012609447352588177, 0.0084071401506662369, 0.031090697273612022, 0.030907778069376945, 0.010648042894899845, 0.0089104976505041122, 0.16606816649436951, } };
const TfArray<16, int> quant4_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant4 = { (TfLiteFloatArray*)&quant4_scale, (TfLiteIntArray*)&quant4_zero, 3 };
const ALIGN(16) int32_t tensor_data5[16] = { -161, 21640, 1011, 11109, 12048, 62679, 12694, 100866, -19044, 6146, 29757, 14430, -445, 26277, 9676, -107, };
const TfArray<1, int> tensor_dimension5 = { 1, { 16 } };
const TfArray<16, float> quant5_scale = { 16, { 0.0018688903655856848, 0.00011900389654329047, 0.0039512696675956249, 0.00031528787803836167, 0.00015182327479124069, 5.3058422054164112e-05, 0.00039062727591954172, 3.877306153299287e-05, 1.6656991647323593e-05, 0.00029669288778677583, 0.00019781506853178144, 0.00073154584970325232, 0.00072724185883998871, 0.00025054218713194132, 0.00020965877047274262, 0.003907486330717802, } };
const TfArray<16, int> quant5_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant5 = { (TfLiteFloatArray*)&quant5_scale, (TfLiteIntArray*)&quant5_zero, 0 };
const ALIGN(16) int8_t tensor_data6[8*1*1*16] = { 
  /* [0][0][][] */ 0,-20,2,0,126,-1,-5,2,0,-127,-91,-3,0,122,-2,0, 
  /* [1][0][][] */ 0,-30,0,83,71,12,21,5,1,-7,127,-44,0,30,-14,0, 
  /* [2][0][][] */ 0,0,-2,-12,-56,7,11,2,-1,6,-16,3,0,127,-8,0, 
  /* [3][0][][] */ 0,-8,-17,-127,83,21,68,15,-1,58,-2,41,0,-2,18,0, 
  /* [4][0][][] */ 0,48,-27,36,-55,35,127,7,-1,-59,20,-8,0,-5,16,0, 
  /* [5][0][][] */ 0,-16,-10,-1,-22,-23,-15,14,-1,11,-4,-46,0,-4,127,0, 
  /* [6][0][][] */ 0,20,0,4,50,-25,-22,-7,2,-108,113,65,0,127,59,0, 
  /* [7][0][][] */ 0,16,-12,127,2,-5,16,11,1,69,-53,71,0,-4,52,0, 
};
const TfArray<4, int> tensor_dimension6 = { 4, { 8,1,1,16 } };
const TfArray<8, float> quant6_scale = { 8, { 0.095110341906547546, 0.090737044811248779, 0.10038182139396667, 0.052244942635297775, 0.055919233709573746, 0.091368511319160461, 0.075356610119342804, 0.045626107603311539, } };
const TfArray<8, int> quant6_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant6 = { (TfLiteFloatArray*)&quant6_scale, (TfLiteIntArray*)&quant6_zero, 0 };
const ALIGN(16) int32_t tensor_data7[8] = { -757, -41191, -8675, -12489, -32643, -1844, -25592, -28080, };
const TfArray<1, int> tensor_dimension7 = { 1, { 8 } };
const TfArray<8, float> quant7_scale = { 8, { 0.0022378903813660145, 0.0021349892485886812, 0.0023619253188371658, 0.0012292928295210004, 0.0013157466892153025, 0.0021498473361134529, 0.0017730967374518514, 0.0010735554387792945, } };
const TfArray<8, int> quant7_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant7 = { (TfLiteFloatArray*)&quant7_scale, (TfLiteIntArray*)&quant7_zero, 0 };
const ALIGN(16) int8_t tensor_data8[48*1*1*8] = { 
  /* [0][0][][] */ 16,-127,45,-38,24,-12,-48,20, 
  /* [1][0][][] */ 76,76,-15,-107,14,-1,-90,127, 
  /* [2][0][][] */ 31,5,-38,118,46,127,53,87, 
  /* [3][0][][] */ 86,72,-88,127,-99,-9,-8,14, 
  /* [4][0][][] */ -36,-94,75,7,-3,24,-34,-127, 
  /* [5][0][][] */ 16,5,-35,37,2,-34,42,127, 
  /* [6][0][][] */ 63,-14,-126,-87,127,16,57,-35, 
  /* [7][0][][] */ 127,12,18,-18,31,-5,85,-55, 
  /* [8][0][][] */ 22,-104,8,116,10,22,-14,-127, 
  /* [9][0][][] */ 104,-127,19,-6,-7,22,-117,91, 
  /* [10][0][][] */ -127,-56,-123,18,-6,15,-105,61, 
  /* [11][0][][] */ -21,-41,-6,-104,-127,-33,47,-15, 
  /* [12][0][][] */ 22,2,-36,68,-78,-22,60,127, 
  /* [13][0][][] */ 0,0,0,0,0,0,0,0, 
  /* [14][0][][] */ -4,-33,-5,17,46,127,42,47, 
  /* [15][0][][] */ 34,7,15,-127,68,33,-49,71, 
  /* [16][0][][] */ 0,0,0,0,0,0,0,0, 
  /* [17][0][][] */ 15,20,127,28,-27,-12,34,35, 
  /* [18][0][][] */ 86,-127,29,29,-1,32,-110,4, 
  /* [19][0][][] */ -127,-1,29,90,-46,-66,-97,78, 
  /* [20][0][][] */ 33,30,-45,127,-22,-126,6,64, 
  /* [21][0][][] */ 57,23,127,11,-16,-11,66,10, 
  /* [22][0][][] */ -82,-13,-127,1,7,9,-99,4, 
  /* [23][0][][] */ -102,109,-20,-31,11,-5,127,-72, 
  /* [24][0][][] */ 7,-51,-46,84,-2,-62,91,127, 
  /* [25][0][][] */ 11,46,42,34,127,120,-68,-53, 
  /* [26][0][][] */ -87,-31,-127,-3,10,16,-86,2, 
  /* [27][0][][] */ -5,-33,-33,4,-53,127,83,51, 
  /* [28][0][][] */ 2,-15,-14,40,29,127,42,50, 
  /* [29][0][][] */ 84,28,127,-6,-26,-8,96,-13, 
  /* [30][0][][] */ -83,127,-27,-29,9,-12,109,-44, 
  /* [31][0][][] */ -48,-90,-21,0,37,-69,127,109, 
  /* [32][0][][] */ -1,1,-55,119,-14,93,88,127, 
  /* [33][0][][] */ 2,56,-9,-100,9,-9,-7,127, 
  /* [34][0][][] */ -19,71,-1,-89,32,2,19,127, 
  /* [35][0][][] */ 127,9,-12,-35,23,43,93,-40, 
  /* [36][0][][] */ -127,-11,31,64,-44,24,-111,84, 
  /* [37][0][][] */ 0,-20,-5,20,19,127,52,44, 
  /* [38][0][][] */ 12,21,5,84,127,-11,-18,35, 
  /* [39][0][][] */ 3,31,42,-127,25,-3,-38,125, 
  /* [40][0][][] */ 91,27,127,1,-6,-3,96,-13, 
  /* [41][0][][] */ 1,-31,-29,78,47,127,72,101, 
  /* [42][0][][] */ -93,-5,127,27,-32,15,-24,60, 
  /* [43][0][][] */ -10,-58,6,104,-18,-1,14,-127, 
  /* [44][0][][] */ 40,12,-66,-127,80,-22,-1,-125, 
  /* [45][0][][] */ -85,127,4,-44,16,1,67,-57, 
  /* [46][0][][] */ -127,-28,36,27,-24,39,-91,44, 
  /* [47][0][][] */ 105,27,112,2,28,-36,127,-5, 
};
const TfArray<4, int> tensor_dimension8 = { 4, { 48,1,1,8 } };
const TfArray<48, float> quant8_scale = { 48, { 0.0010190719040110707, 0.0010836579604074359, 0.00064608914544805884, 0.00054480857215821743, 0.00065695436205714941, 0.00059335154946893454, 0.00091206596698611975, 0.0032014495227485895, 0.00086204090621322393, 0.0043408148922026157, 0.0011406755074858665, 0.0034842237364500761, 0.00033194990828633308, 3.937008052901092e-09, 0.0016649854369461536, 0.00043945555808022618, 3.937008052901092e-09, 0.012419728562235832, 0.00079059530980885029, 0.00079125555930659175, 0.00047880911733955145, 0.0086010945960879326, 0.00060402811504900455, 0.0028264187276363373, 0.0020050520543009043, 0.0012127497466281056, 0.0042361062951385975, 0.0036436736118048429, 0.00060669565573334694, 0.0030990843661129475, 0.0021655866876244545, 0.0003061428724322468, 0.00039671070408076048, 0.024903241544961929, 0.0012578243622556329, 0.0015406114980578423, 0.010903478600084782, 0.00078129483154043555, 0.0047919172793626785, 0.00065221672412008047, 0.0024040478747338057, 0.00035222142469137907, 0.0013425025390461087, 0.022941669449210167, 0.00069122732384130359, 0.00096825044602155685, 0.00072293955599889159, 0.00037217835779301822, } };
const TfArray<48, int> quant8_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant8 = { (TfLiteFloatArray*)&quant8_scale, (TfLiteIntArray*)&quant8_zero, 0 };
const ALIGN(16) int32_t tensor_data9[48] = { 3643, 84, 8637, 6148, 5329, 6181, 7367, -34, 21, -305, 2280, 434, 11729, -72529256, 2763, 13185, -58549376, -102, -409, 8660, 3965, -17, 45, 395, 3336, -762, 59, 576, 3221, 1675, 2404, 13537, 3347, 229, 196, -1315, 245, 2900, -147, 9342, 2091, 11083, -204, -66, 12802, 130, 6826, 4204, };
const TfArray<1, int> tensor_dimension9 = { 1, { 48 } };
const TfArray<48, float> quant9_scale = { 48, { 0.00057880516396835446, 0.00061548827216029167, 0.00036696108873002231, 0.00030943646561354399, 0.00037313223583623767, 0.00033700757194310427, 0.00051802868256345391, 0.0018183364300057292, 0.00048961583524942398, 0.002465464873239398, 0.0006478726863861084, 0.0019789445213973522, 0.00018853852816391736, 2.2361137386184282e-09, 0.00094566651387140155, 0.00024959881557151675, 2.2361137386184282e-09, 0.0070540686137974262, 0.00044903665548190475, 0.00044941165833733976, 0.00027195058646611869, 0.0048851883038878441, 0.00034307155874557793, 0.0016053291037678719, 0.0011388150742277503, 0.00068880891194567084, 0.0024059934075921774, 0.0020695077255368233, 0.00034458664595149457, 0.0017601957079023123, 0.0012299944646656513, 0.00017388083506375551, 0.00022532090952154249, 0.01414436474442482, 0.00071441009640693665, 0.00087502546375617385, 0.0061928797513246536, 0.00044375425204634666, 0.0027216789312660694, 0.00037044138298369944, 0.0013654339127242565, 0.00020005220721941441, 0.00076250499114394188, 0.013030244968831539, 0.00039259833283722401, 0.00054993992671370506, 0.00041061002411879599, 0.00021138720330782235, } };
const TfArray<48, int> quant9_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant9 = { (TfLiteFloatArray*)&quant9_scale, (TfLiteIntArray*)&quant9_zero, 0 };
const ALIGN(16) int8_t tensor_data10[1*3*3*48] = { 
  /* [0][0][][] */ -42,-22,-7,-16,8,-39,-79,-67,-26,-50,8,67,34,-71,115,-43,-113,-84,37,-5,-1,-71,-110,-80,-35,-124,-62,-21,71,15,95,27,-127,-88,-7,54,19,47,-127,79,-76,-14,106,-110,-3,-35,-87,109, 76,12,-29,-29,57,-127,-127,-80,61,-76,-115,110,38,-82,-1,62,-52,-113,58,8,11,-112,-127,-70,-4,-127,-120,-40,-54,21,-57,54,28,-127,64,83,14,71,-92,127,-127,6,125,-127,2,-23,-127,95, -32,44,6,-5,-65,-109,-58,-17,87,-8,-127,38,8,-71,-101,-10,-127,-24,28,12,-17,-76,-35,-23,-10,-32,-59,-11,-9,18,-24,10,106,-86,69,32,15,35,-5,16,-78,4,7,-79,-17,5,-55,14, 
  /* [0][1][][] */ -86,-127,-45,-43,-10,55,99,-105,-25,-108,-21,113,89,-64,27,-97,-121,-94,90,-76,41,-88,-102,-127,41,-116,-76,-39,127,-61,127,85,-44,-84,-15,84,-35,-77,-108,91,41,60,105,-110,-91,-118,81,120, 127,-84,-127,-127,127,41,94,-127,101,-127,-110,127,127,-14,-7,127,-60,-127,127,-127,127,-127,-119,-117,127,-98,-127,-127,-120,-127,-70,127,28,-111,127,127,-68,-127,-97,91,60,127,127,-117,-112,-127,125,127, -53,31,-61,-84,-120,-23,31,-38,127,-21,-76,35,55,-70,-25,-43,-37,-29,54,-71,55,-82,-38,-24,48,-5,-46,-60,16,-89,-36,20,30,-98,117,23,-36,-62,0,-15,36,54,9,-74,-57,-37,65,35, 
  /* [0][2][][] */ -61,-106,-34,-35,1,35,-5,-35,-37,-59,-16,60,76,-127,-127,-64,-43,-19,64,76,52,-33,-13,-59,33,-54,-10,-59,75,28,77,63,106,-26,-38,-9,-95,34,-18,32,9,38,15,-57,95,-78,3,31, 87,-75,-88,-86,81,19,7,-47,49,-71,-32,55,83,-26,17,93,-24,-32,77,119,82,-53,-18,-57,93,-66,-18,-98,-51,39,-45,111,-18,-49,67,6,-127,49,-15,-1,10,32,17,-66,127,-100,-12,40, -29,28,-42,-37,-80,-19,22,-12,59,-6,-13,32,31,-43,112,-28,-93,-6,31,60,73,-29,-2,-3,44,2,-4,-65,-13,28,-20,40,-89,-43,66,4,-19,21,26,-39,6,36,-5,-14,63,-34,-5,18, 
};
const TfArray<4, int> tensor_dimension10 = { 4, { 1,3,3,48 } };
const TfArray<48, float> quant10_scale = { 48, { 0.0032980199903249741, 0.0030221985653042793, 0.006420196034014225, 0.0050196005031466484, 0.010575855150818825, 0.0081192292273044586, 0.007596026174724102, 0.0021056362893432379, 0.0042800968512892723, 0.0013143079122528434, 0.0027690932620316744, 0.0010005873627960682, 0.0074623455293476582, 0.23551659286022186, 0.0035965056158602238, 0.011950477957725525, 0.1168077290058136, 0.00067030458012595773, 0.0033345702104270458, 0.0062905461527407169, 0.0045233294367790222, 0.0042696399614214897, 0.005173433106392622, 0.001610900741070509, 0.0045499899424612522, 0.0030002247076481581, 0.0013790699886158109, 0.0017190505750477314, 0.013328269124031067, 0.0027432367205619812, 0.0023405503015965223, 0.0083841634914278984, 0.010482042096555233, 0.00037099994369782507, 0.0039324816316366196, 0.007063775323331356, 0.00060556182870641351, 0.022427147254347801, 0.0012749052839353681, 0.0037952950224280357, 0.0031855243723839521, 0.0092318225651979446, 0.0045592179521918297, 0.00038945249980315566, 0.006912935059517622, 0.0043312432244420052, 0.0097650913521647453, 0.0039435038343071938, } };
const TfArray<48, int> quant10_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant10 = { (TfLiteFloatArray*)&quant10_scale, (TfLiteIntArray*)&quant10_zero, 3 };
const ALIGN(16) int32_t tensor_data11[48] = { 76023, 55441, 62151, 43180, -84, 13777, 2480, 33170, 22100, 21086, 27932, 14231, -46234, -127, 29925, 509, -204, 36467, 3478, 1229, -14968, -8547, 48729, 32665, -25021, 37796, 42002, 16167, -2313, 14575, -8482, -51126, 10052, 93098, 27953, 1620, 64157, 278, 149165, -25928, 16541, -28217, 2956, 106636, -1302, 58515, 727, -22955, };
const TfArray<1, int> tensor_dimension11 = { 1, { 48 } };
const TfArray<48, float> quant11_scale = { 48, { 7.7600474469363689e-05, 7.1110553108155727e-05, 0.00015106343198567629, 0.00011810824798885733, 0.00024884365848265588, 0.00019104068633168936, 0.00017873002798296511, 4.9544385547051206e-05, 0.00010070816642837599, 3.0924893508199602e-05, 6.5155138145200908e-05, 2.3543232600786723e-05, 0.00017558460240252316, 0.005541567225009203, 8.4623665316030383e-05, 0.00028118773479945958, 0.0027484172023832798, 1.5771873222547583e-05, 7.8460478107444942e-05, 0.00014801285578869283, 0.00010643128189258277, 0.00010046211536973715, 0.000121727840451058, 3.7903548218309879e-05, 0.00010705858585424721, 7.0593523560091853e-05, 3.2448704587295651e-05, 4.0448248910252005e-05, 0.00031360634602606297, 6.4546744397375733e-05, 5.507177411345765e-05, 0.00019727443577721715, 0.00024663627846166492, 8.7294101831503212e-06, 9.2528978711925447e-05, 0.00016620647511444986, 1.4248514162318315e-05, 0.0005276976153254509, 2.9997772799106315e-05, 8.9301058324053884e-05, 7.495351746911183e-05, 0.0002172193635487929, 0.00010727572225732729, 9.1635884018614888e-06, 0.00016265729209408164, 0.00010191160981776193, 0.00022976685431785882, 9.2788330221083015e-05, } };
const TfArray<48, int> quant11_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant11 = { (TfLiteFloatArray*)&quant11_scale, (TfLiteIntArray*)&quant11_zero, 0 };
const ALIGN(16) int8_t tensor_data12[8*1*1*48] = { 
  /* [0][0][][] */ -14,-3,9,-95,12,25,5,4,6,2,1,-6,99,0,2,6,0,-9,-4,1,77,-4,-1,4,28,38,11,10,4,6,4,-127,10,8,-1,1,-29,2,-14,33,10,-27,-9,4,2,-4,8,2, 
  /* [1][0][][] */ -37,-4,-5,-8,44,26,-30,74,18,4,-27,-23,10,0,23,35,0,40,17,-45,-2,21,127,22,-30,0,54,3,22,-5,11,-15,14,-10,-4,-18,7,-56,14,1,-8,-9,-78,-6,-31,7,-47,-95, 
  /* [2][0][][] */ -58,18,3,9,45,-8,27,29,-12,55,6,-7,2,0,6,53,0,16,-127,22,3,15,8,-13,-33,5,37,8,8,29,21,3,6,-6,-13,-13,9,5,8,-1,35,-12,-34,2,22,-55,24,10, 
  /* [3][0][][] */ 3,3,6,7,-3,25,1,-1,61,16,-6,-3,22,0,-31,-6,0,0,-9,1,-1,0,3,-15,-12,-4,-11,0,-9,0,-1,-10,-43,42,-52,-5,4,7,4,-127,0,-1,-2,-47,-1,-1,0,3, 
  /* [4][0][][] */ -2,-5,78,35,7,-17,0,1,2,-5,-4,-8,-80,0,-11,5,0,15,6,3,66,6,-3,-4,-16,28,-13,47,-6,1,2,99,4,1,1,1,12,-14,-15,-18,3,-127,5,5,0,-6,0,-2, 
  /* [5][0][][] */ -7,42,1,-10,3,48,28,10,-19,27,9,53,27,0,-127,-2,0,12,-37,22,-8,9,-14,38,-18,1,28,-4,-14,23,25,-17,50,28,-40,-2,5,16,-47,17,27,-14,-9,27,23,58,24,26, 
  /* [6][0][][] */ -21,-52,2,9,39,-47,-22,6,25,-27,-12,79,-7,0,-127,39,0,-13,47,-17,-7,3,24,-29,29,-6,-2,-14,44,-12,-11,-6,93,-34,31,-1,-3,-6,-71,-24,-15,-16,-3,-24,-18,-80,-16,-26, 
  /* [7][0][][] */ -114,-25,-6,7,127,22,65,33,11,7,21,-40,-30,0,87,105,0,14,2,60,-8,1,-30,50,19,6,46,10,53,66,55,-9,-11,-15,-18,-27,2,27,26,36,69,-2,-32,-8,58,4,66,73, 
};
const TfArray<4, int> tensor_dimension12 = { 4, { 8,1,1,48 } };
const TfArray<8, float> quant12_scale = { 8, { 0.055136099457740784, 0.031410768628120422, 0.047752246260643005, 0.052119608968496323, 0.052907519042491913, 0.054301988333463669, 0.035633962601423264, 0.032793290913105011, } };
const TfArray<8, int> quant12_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant12 = { (TfLiteFloatArray*)&quant12_scale, (TfLiteIntArray*)&quant12_zero, 0 };
const ALIGN(16) int32_t tensor_data13[8] = { -3590, -26598, 22955, 21337, 6154, 1444, 37573, 10420, };
const TfArray<1, int> tensor_dimension13 = { 1, { 8 } };
const TfArray<8, float> quant13_scale = { 8, { 0.0012973200064152479, 0.00073907693149521947, 0.0011235822457820177, 0.0012263437965884805, 0.001244882820174098, 0.0012776938965544105, 0.00083844619803130627, 0.00077160686487331986, } };
const TfArray<8, int> quant13_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant13 = { (TfLiteFloatArray*)&quant13_scale, (TfLiteIntArray*)&quant13_zero, 0 };
const ALIGN(16) int8_t tensor_data14[48*1*1*8] = { 
  /* [0][0][][] */ 69,30,-1,-19,127,20,-36,-11, 
  /* [1][0][][] */ 1,-5,7,127,20,-2,10,20, 
  /* [2][0][][] */ 21,-127,-23,43,-13,-63,77,0, 
  /* [3][0][][] */ 127,-26,-10,13,-8,-28,27,1, 
  /* [4][0][][] */ 16,-47,127,-8,-6,-48,11,-98, 
  /* [5][0][][] */ 79,-8,6,-9,127,19,-2,12, 
  /* [6][0][][] */ -11,101,-5,127,34,48,-75,-41, 
  /* [7][0][][] */ -7,127,-2,6,-2,-19,15,-2, 
  /* [8][0][][] */ 127,50,-6,-5,-55,-29,-9,-37, 
  /* [9][0][][] */ -127,6,6,23,45,12,-8,6, 
  /* [10][0][][] */ -84,-3,15,127,51,42,-22,-11, 
  /* [11][0][][] */ -127,-3,3,-57,29,11,-20,-44, 
  /* [12][0][][] */ 127,30,-1,20,-43,-13,4,-42, 
  /* [13][0][][] */ -6,75,-127,-4,-4,107,-77,74, 
  /* [14][0][][] */ -54,-34,-2,127,22,11,-13,-15, 
  /* [15][0][][] */ -6,127,2,-5,2,-18,14,-44, 
  /* [16][0][][] */ -2,-127,-30,0,-15,-98,103,-37, 
  /* [17][0][][] */ 26,127,1,-14,-4,74,-92,-16, 
  /* [18][0][][] */ -12,38,-127,-6,8,57,-23,67, 
  /* [19][0][][] */ -94,45,1,-12,-127,-15,20,12, 
  /* [20][0][][] */ -127,-14,-12,0,66,-31,39,-4, 
  /* [21][0][][] */ -93,2,-5,3,-127,9,19,-4, 
  /* [22][0][][] */ -127,-32,2,-3,78,-2,39,46, 
  /* [23][0][][] */ -23,-35,-6,-6,-8,92,-127,-97, 
  /* [24][0][][] */ -8,46,-127,3,9,47,-18,75, 
  /* [25][0][][] */ 102,-40,-21,127,-78,-19,3,-50, 
  /* [26][0][][] */ -2,-23,-5,-2,-16,113,127,-25, 
  /* [27][0][][] */ 75,1,-8,7,127,39,40,-26, 
  /* [28][0][][] */ 10,127,-63,10,16,72,-26,106, 
  /* [29][0][][] */ -11,15,2,-4,1,83,-127,-81, 
  /* [30][0][][] */ 2,-8,4,-127,-9,3,-5,-16, 
  /* [31][0][][] */ -61,5,-8,7,-127,13,15,-6, 
  /* [32][0][][] */ -23,27,7,-127,-7,43,-85,-107, 
  /* [33][0][][] */ -69,-17,-9,4,-127,47,50,-3, 
  /* [34][0][][] */ -127,60,5,30,38,-16,8,9, 
  /* [35][0][][] */ -34,118,-23,-17,-14,-127,68,-21, 
  /* [36][0][][] */ -8,48,-6,-28,-10,84,-127,-31, 
  /* [37][0][][] */ 14,-79,-9,29,16,-101,127,-28, 
  /* [38][0][][] */ 24,-127,2,12,7,42,-49,57, 
  /* [39][0][][] */ 3,-127,-11,-2,-1,-7,-41,-82, 
  /* [40][0][][] */ 127,36,11,-9,-49,79,-111,-91, 
  /* [41][0][][] */ 18,-117,15,-8,2,86,-62,127, 
  /* [42][0][][] */ 56,-14,-8,-127,-57,-7,12,-32, 
  /* [43][0][][] */ -93,-20,14,-127,57,9,-28,-7, 
  /* [44][0][][] */ -3,-45,0,25,-14,105,127,-2, 
  /* [45][0][][] */ -127,-25,-3,-2,14,1,12,-19, 
  /* [46][0][][] */ 16,86,127,-6,-3,23,5,19, 
  /* [47][0][][] */ -8,7,11,127,15,3,7,-1, 
};
const TfArray<4, int> tensor_dimension14 = { 4, { 48,1,1,8 } };
const TfArray<48, float> quant14_scale = { 48, { 0.00023962237173691392, 0.00070718966890126467, 0.00060826551634818316, 0.0010871604317799211, 0.0041292682290077209, 0.0010423524072393775, 0.0023619276471436024, 0.0027153175324201584, 0.001436432939954102, 0.0016040161717683077, 0.0015338704688474536, 0.0013290345668792725, 0.0012763370759785175, 0.0014831615844741464, 0.0013624093262478709, 0.0044383821077644825, 0.00081300927558913827, 0.00088304770179092884, 0.0053751156665384769, 0.00019999107462354004, 0.00078108644811436534, 0.00075907749123871326, 0.0011860033264383674, 0.0024605588987469673, 0.00096211762866005301, 0.00055885076289996505, 0.00037919968599453568, 0.00078339042374864221, 0.0023038599174469709, 0.0026026759296655655, 0.0013521128566935658, 0.00088408729061484337, 0.0024479047860950232, 0.00047097227070480585, 0.001011858694255352, 0.00057759019546210766, 0.0013528586132451892, 0.00079159182496368885, 0.00028329505585134029, 0.006171992514282465, 0.0016062305076047778, 0.0025035259313881397, 0.0010212489869445562, 0.001045675715431571, 0.00054390163859352469, 0.001232380629517138, 0.0018532831454649568, 0.002374185249209404, } };
const TfArray<48, int> quant14_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant14 = { (TfLiteFloatArray*)&quant14_scale, (TfLiteIntArray*)&quant14_zero, 0 };
const ALIGN(16) int32_t tensor_data15[48] = { 37183, 6744, 5378, 6196, 1127, 10139, -1710, -237, 847, 1796, 3066, 231, 1618, -674, 697, -1716, 4113, 10046, -206, 28264, 3237, 2634, 7043, -451, 2652, 4420, 22321, 9756, -42, -2111, 77, 1974, -1692, 9931, 2143, 6800, 5653, 3534, 17236, 1524, -777, 2315, 995, 2968, 4567, 1837, -1271, 2353, };
const TfArray<1, int> tensor_dimension15 = { 1, { 48 } };
const TfArray<48, float> quant15_scale = { 48, { 0.00011466303112683818, 0.00033840126707218587, 0.00029106452711857855, 0.00052022316958755255, 0.0019759191200137138, 0.00049878185382112861, 0.0011302191996946931, 0.0012993216514587402, 0.00068735552486032248, 0.00076754670590162277, 0.00073398090898990631, 0.00063596374820917845, 0.00061074714176356792, 0.00070971588138490915, 0.00065193406771868467, 0.0021238350309431553, 0.00038903759559616446, 0.0004225520824547857, 0.002572076627984643, 9.5698844233993441e-05, 0.00037376201362349093, 0.00036323038511909544, 0.00056752102682366967, 0.0011774157173931599, 0.00046038825530558825, 0.00026741879992187023, 0.00018145295325666666, 0.00037486452492885292, 0.0011024328414350748, 0.0012454208917915821, 0.00064700702205300331, 0.0004230495251249522, 0.0011713604908436537, 0.00022536756296176463, 0.00048419012455269694, 0.00027638589381240308, 0.00064736389322206378, 0.00037878900184296072, 0.00013556108751799911, 0.0029533945489674807, 0.00076860631816089153, 0.0011979761766269803, 0.00048868352314457297, 0.00050037208711728454, 0.00026026539853774011, 0.00058971333783119917, 0.00088682485511526465, 0.0011360845528542995, } };
const TfArray<48, int> quant15_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant15 = { (TfLiteFloatArray*)&quant15_scale, (TfLiteIntArray*)&quant15_zero, 0 };
const ALIGN(16) int8_t tensor_data16[1*3*3*48] = { 
  /* [0][0][][] */ 4,-2,21,109,4,82,-1,28,15,7,9,7,-9,-9,-45,9,-2,8,-23,-115,-7,-22,127,-10,-2,6,-6,9,-5,4,16,99,21,28,38,-27,1,35,-1,2,17,-67,-9,-8,17,3,-7,-11, 127,10,15,-127,28,87,11,11,122,127,6,43,-51,-24,6,9,127,-56,-59,-57,-101,25,-110,15,18,70,-32,-83,23,21,9,-123,5,-61,127,10,-40,-46,-6,115,-79,-96,-30,3,-35,-7,-127,22, -31,-3,8,14,-1,64,4,18,27,8,-14,31,-15,-3,15,4,-103,28,-3,76,-32,-11,-18,-6,-4,-59,-3,29,-17,5,4,-22,7,-24,17,-18,-1,48,42,-12,50,39,-16,11,-43,4,-2,-6, 
  /* [0][1][][] */ 126,8,1,-97,14,-27,35,-16,8,8,-12,52,-7,-1,18,-32,0,-50,-59,-86,10,-73,-124,-18,5,98,-15,-127,-9,33,12,-108,18,-53,-3,127,-3,59,-41,41,-62,-127,39,-88,-45,-13,-12,-5, 28,-127,-127,114,-127,-127,-127,-127,-127,-98,127,-127,127,127,35,-127,-82,127,127,-106,127,127,112,127,127,-127,-127,29,-127,-127,94,127,-127,127,-30,-41,127,-127,127,127,127,-79,127,127,127,-119,101,106, 55,5,49,-13,6,-61,44,19,-24,14,-106,-8,0,-40,127,4,63,-66,-70,84,13,-45,10,-33,2,7,-38,69,19,40,0,3,32,-44,9,66,-6,65,68,-9,-81,10,-84,-31,27,-15,-11,6, 
  /* [0][2][][] */ -53,-6,26,-16,7,34,-37,22,8,-25,12,32,6,-7,-38,17,5,22,-13,105,5,-32,-16,-12,-4,21,0,51,-10,4,47,-31,-17,-43,-32,-39,-1,31,9,-21,9,-4,41,-37,-36,19,-10,17, 69,127,75,21,17,-21,124,35,18,-4,43,26,-5,-1,-90,24,-57,-56,-35,122,-38,49,12,19,31,-63,-40,30,76,1,127,23,85,-25,7,-35,-25,-17,-12,120,-28,-12,-40,45,21,-31,7,-127, -41,-4,6,-3,5,-5,-61,8,-18,-11,-41,-40,19,-9,-9,11,33,23,-8,-127,22,-10,4,-9,-7,11,-10,-54,-15,8,6,9,-21,88,-37,-22,-5,37,25,-60,5,9,-38,7,-42,127,-5,-3, 
};
const TfArray<4, int> tensor_dimension16 = { 4, { 1,3,3,48 } };
const TfArray<48, float> quant16_scale = { 48, { 0.013482180424034595, 0.011516716331243515, 0.0072875223122537136, 0.011865061707794666, 0.0064928466454148293, 0.0041370573453605175, 0.044050145894289017, 0.0073348181322216988, 0.0081628831103444099, 0.0070637189783155918, 0.0047669801861047745, 0.0080187162384390831, 0.015585405752062798, 0.0089075211435556412, 0.0039341882802546024, 0.02019730769097805, 0.0087921665981411934, 0.009571591392159462, 0.003218925790861249, 0.0068052103742957115, 0.011417470872402191, 0.010064485482871532, 0.010263180360198021, 0.0048179174773395061, 0.0066027236171066761, 0.006852518767118454, 0.023673461750149727, 0.004413203801959753, 0.010131704621016979, 0.016312843188643456, 0.0035474088508635759, 0.0095218699425458908, 0.040986552834510803, 0.0081733120605349541, 0.0078548472374677658, 0.0068929041735827923, 0.016051899641752243, 0.0049238982610404491, 0.011365620419383049, 0.00086811388609930873, 0.0082194767892360687, 0.0026728252414613962, 0.0058205537497997284, 0.0067690755240619183, 0.006261755246669054, 0.005686149001121521, 0.012755853123962879, 0.0051820133812725544, } };
const TfArray<48, int> quant16_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant16 = { (TfLiteFloatArray*)&quant16_scale, (TfLiteIntArray*)&quant16_zero, 3 };
const ALIGN(16) int32_t tensor_data17[48] = { -52372, -669, 9665, -165, 5601, -5108, 1046, 19932, 340, 29452, -2341, 22811, -5654, -1016, 27375, 3198, 137, 18002, 30780, 11778, 321, -380, 302, 19337, -8175, 23095, 45945, 32623, 3204, 2038, 49, 955, 873, 14975, -6931, 15201, -10974, 22722, -22707, 127254, 16837, 20498, 12406, -1576, 16292, 2675, 1057, 35, };
const TfArray<1, int> tensor_dimension17 = { 1, { 48 } };
const TfArray<48, float> quant17_scale = { 48, { 0.00031722779385745525, 0.00027098157443106174, 0.0001714711106615141, 0.00027917794068343937, 0.00015277286001946777, 9.7342526714783162e-05, 0.0010364740155637264, 0.00017258395382668823, 0.00019206784781999886, 0.00016620515089016408, 0.00011216424172744155, 0.00018867567996494472, 0.00036671542329713702, 0.00020958873210474849, 9.2569134721998125e-05, 0.00047523077228106558, 0.0002068745088763535, 0.00022521392384078354, 7.5739430030807853e-05, 0.00016012259584385902, 0.0002686463703867048, 0.00023681142192799598, 0.00024148660304490477, 0.0001133627665694803, 0.00015535821148660034, 0.00016123574459925294, 0.00055702263489365578, 0.00010384009510744363, 0.00023839305504225194, 0.00038383161881938577, 8.3468446973711252e-05, 0.00022404400806408376, 0.00096438947366550565, 0.00019231322221457958, 0.0001848199317464605, 0.00016218598466366529, 0.0003776917583309114, 0.00011585643369471654, 0.00026742636691778898, 2.0426208720891736e-05, 0.00019339946447871625, 6.2890008848626167e-05, 0.00013695421512238681, 0.00015927237109281123, 0.00014733542047906667, 0.00013379174924921244, 0.00030013773357495666, 0.00012192972644697875, } };
const TfArray<48, int> quant17_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant17 = { (TfLiteFloatArray*)&quant17_scale, (TfLiteIntArray*)&quant17_zero, 0 };
const ALIGN(16) int8_t tensor_data18[8*1*1*48] = { 
  /* [0][0][][] */ -55,-11,-38,19,13,-24,0,6,-108,127,-30,112,113,10,60,-11,-15,-39,5,-3,-14,-3,-31,-36,27,-90,12,60,-8,8,8,-27,-11,-76,112,8,-8,-10,-5,-13,107,-9,40,-23,-27,16,-14,-22, 
  /* [1][0][][] */ -2,40,127,4,-5,-24,3,-78,32,2,24,5,-21,6,-11,-116,17,-59,5,7,-32,33,27,-31,-18,-3,15,-2,16,-5,15,-5,0,15,17,8,-14,-34,67,-52,5,42,-16,24,-17,10,24,-2, 
  /* [2][0][][] */ 6,-50,15,-46,31,29,-4,-28,5,-3,-4,12,-12,60,3,-1,-39,127,-29,-33,-16,26,-40,-8,124,2,1,-8,-31,-9,2,-41,-10,-16,-1,9,-10,-3,-14,4,14,-18,-18,-2,3,28,-23,-45, 
  /* [3][0][][] */ -1,-82,0,8,-1,-8,-9,0,-8,-11,17,21,16,-13,52,1,-8,-17,7,19,-6,14,-19,1,2,51,-1,12,-6,3,127,-1,10,9,-6,1,-17,-14,-4,13,-9,5,-5,27,-8,2,-3,33, 
  /* [4][0][][] */ -106,15,-2,4,3,-35,4,10,46,-46,24,-20,-33,0,-19,-3,9,6,-2,27,14,-26,16,6,-9,51,11,111,3,0,-9,-26,-3,-127,-29,7,2,-7,6,0,-51,-9,-14,22,-53,-3,11,7, 
  /* [5][0][][] */ -18,28,21,9,-44,4,0,46,25,6,15,6,1,-46,8,34,1,-93,16,1,48,-56,13,33,15,4,-83,-50,-38,-34,20,-8,-4,-67,2,-73,61,7,-41,16,23,-46,4,7,127,-15,-39,-2, 
  /* [6][0][][] */ -31,-22,-13,-10,37,-29,3,-19,-3,-1,36,-15,-9,36,1,-55,-4,4,4,-31,-39,50,-7,-78,-2,-10,-59,-63,29,40,-13,3,-3,-65,-12,62,-66,-45,11,-54,-5,12,15,42,127,-35,42,10, 
  /* [7][0][][] */ 20,32,-80,22,-23,13,8,62,1,-8,63,-36,11,-31,-12,-2,-17,-127,39,-36,62,36,15,-55,22,-19,26,0,-23,26,-14,2,-2,35,-4,-21,-5,-57,-43,-71,-18,-25,38,60,-24,-28,-1,1, 
};
const TfArray<4, int> tensor_dimension18 = { 4, { 8,1,1,48 } };
const TfArray<8, float> quant18_scale = { 8, { 0.020484432578086853, 0.031583555042743683, 0.062938757240772247, 0.072696685791015625, 0.037752475589513779, 0.028182538226246834, 0.033290736377239227, 0.043889541178941727, } };
const TfArray<8, int> quant18_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant18 = { (TfLiteFloatArray*)&quant18_scale, (TfLiteIntArray*)&quant18_zero, 0 };
const ALIGN(16) int32_t tensor_data19[8] = { -36680, 25696, -10598, -15303, 21075, 1083, 27417, 46611, };
const TfArray<1, int> tensor_dimension19 = { 1, { 8 } };
const TfArray<8, float> quant19_scale = { 8, { 0.00048198664444498718, 0.00074314250377938151, 0.0014809119747951627, 0.0017105102306231856, 0.00088829355081543326, 0.00066311855334788561, 0.00078331143595278263, 0.0010326950578019023, } };
const TfArray<8, int> quant19_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant19 = { (TfLiteFloatArray*)&quant19_scale, (TfLiteIntArray*)&quant19_zero, 0 };
const ALIGN(16) int8_t tensor_data20[48*1*1*8] = { 
  /* [0][0][][] */ -127,2,-1,68,-32,35,22,-27, 
  /* [1][0][][] */ 20,74,42,26,4,-48,101,127, 
  /* [2][0][][] */ -38,7,8,7,-127,-24,10,1, 
  /* [3][0][][] */ 97,-3,-8,-127,-125,8,30,-18, 
  /* [4][0][][] */ -127,44,-10,-16,62,-11,37,9, 
  /* [5][0][][] */ -102,-26,20,-14,-127,7,6,77, 
  /* [6][0][][] */ -21,-127,17,-17,10,-2,9,42, 
  /* [7][0][][] */ -69,-4,5,104,127,-28,-35,3, 
  /* [8][0][][] */ 63,4,6,-127,-10,-21,-40,-42, 
  /* [9][0][][] */ -8,-127,-4,2,16,80,-53,96, 
  /* [10][0][][] */ -99,-9,-1,14,-127,82,56,-17, 
  /* [11][0][][] */ 113,4,36,16,-59,-37,-28,-127, 
  /* [12][0][][] */ 3,8,38,-4,7,-82,127,69, 
  /* [13][0][][] */ 63,-20,-4,-2,107,127,123,-40, 
  /* [14][0][][] */ 127,59,-17,4,-117,-11,-37,-20, 
  /* [15][0][][] */ -16,-127,15,-10,3,2,10,38, 
  /* [16][0][][] */ -46,-9,-3,1,-127,0,24,6, 
  /* [17][0][][] */ -34,97,-123,-1,15,-127,108,-91, 
  /* [18][0][][] */ 127,-34,-45,17,-59,27,10,108, 
  /* [19][0][][] */ 127,-58,-17,1,39,-19,45,19, 
  /* [20][0][][] */ 127,34,-8,125,-6,23,8,-61, 
  /* [21][0][][] */ -4,34,-53,2,-21,90,-127,-81, 
  /* [22][0][][] */ -127,17,32,-1,-26,1,-45,-19, 
  /* [23][0][][] */ -37,-59,2,25,-127,67,80,-15, 
  /* [24][0][][] */ 127,-3,-5,-14,-81,-6,-11,1, 
  /* [25][0][][] */ 21,-17,-2,-23,127,52,53,-29, 
  /* [26][0][][] */ 1,-79,16,-45,3,-127,73,-46, 
  /* [27][0][][] */ -20,-127,32,-17,-2,-58,36,-7, 
  /* [28][0][][] */ -111,35,-11,4,-7,-3,127,99, 
  /* [29][0][][] */ -12,37,15,8,-7,39,-99,-127, 
  /* [30][0][][] */ 127,-31,5,17,-97,0,-40,-15, 
  /* [31][0][][] */ -10,-31,65,-29,28,-91,127,57, 
  /* [32][0][][] */ -75,33,-1,-7,-127,-100,-118,54, 
  /* [33][0][][] */ -26,16,5,28,-127,-51,-43,13, 
  /* [34][0][][] */ 11,-127,53,-9,2,93,-76,70, 
  /* [35][0][][] */ -25,-54,-127,-5,-5,-67,46,-54, 
  /* [36][0][][] */ 2,127,57,11,-5,7,-17,-33, 
  /* [37][0][][] */ -127,34,37,-12,50,-33,-11,-113, 
  /* [38][0][][] */ -127,-10,-55,-10,47,25,36,114, 
  /* [39][0][][] */ 5,-22,80,8,8,-77,127,70, 
  /* [40][0][][] */ -28,-8,-4,-35,-127,115,113,-41, 
  /* [41][0][][] */ -127,59,10,-68,-91,-93,-100,46, 
  /* [42][0][][] */ -39,-127,-102,1,-14,51,-115,-77, 
  /* [43][0][][] */ -64,13,-15,-127,94,58,67,4, 
  /* [44][0][][] */ 127,-6,15,-105,43,-46,-18,54, 
  /* [45][0][][] */ -19,-127,-2,-8,-16,-75,84,8, 
  /* [46][0][][] */ 107,-4,-5,-25,127,-28,-31,4, 
  /* [47][0][][] */ 127,6,-2,98,-2,23,14,-39, 
};
const TfArray<4, int> tensor_dimension20 = { 4, { 48,1,1,8 } };
const TfArray<48, float> quant20_scale = { 48, { 0.00071867293445393443, 0.0017124320147559047, 0.00054939312394708395, 0.00059891905402764678, 0.0005192651879042387, 0.00053793744882568717, 0.00082771241432055831, 0.00050121999811381102, 0.00072306348010897636, 0.0013429041719064116, 0.0016965731047093868, 0.00055539369350299239, 0.0008096161182038486, 0.0012890603393316269, 0.00025491902488283813, 0.0007720068097114563, 0.00056263041915372014, 0.00068742199800908566, 0.00048360362416133285, 0.00053408154053613544, 0.00066172872902825475, 0.00049921119352802634, 0.00074136862531304359, 0.00028391196974553168, 0.00060521549312397838, 0.00059475156012922525, 0.0034684499260038137, 0.00087361462647095323, 0.00038091427995823324, 0.00087209796765819192, 0.00056755688274279237, 0.00047003343934193254, 0.0012398534454405308, 0.00054161890875548124, 0.001458187005482614, 0.0010103692766278982, 0.0014665095368400216, 0.00067830417538061738, 0.0004154516791459173, 0.00080229289596900344, 0.00032470739097334445, 0.00042440823744982481, 0.00070987205253913999, 0.00060267065418884158, 0.0032573805656284094, 0.00074534874875098467, 0.00059225253062322736, 0.0024207844398915768, } };
const TfArray<48, int> quant20_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant20 = { (TfLiteFloatArray*)&quant20_scale, (TfLiteIntArray*)&quant20_zero, 0 };
const ALIGN(16) int32_t tensor_data21[48] = { 496, 694, 1645, 513, 7051, 12517, 2259, -83, -579, -563, 1006, 941, 2656, 998, 23771, 2770, 1405, -1008, -152, 2905, -1509, 8631, 8323, 9200, 4454, 286, 3362, 3554, 7730, -464, 7600, 4419, 524, -47, 4213, 3043, -1572, 293, -742, 3846, 957, -572, -690, 31, 984, 3058, 737, 826, };
const TfArray<1, int> tensor_dimension21 = { 1, { 48 } };
const TfArray<48, float> quant21_scale = { 48, { 0.00043014166294597089, 0.0010249284096062183, 0.00032882395316846669, 0.00035846629180014133, 0.00031079171458259225, 0.00032196746906265616, 0.00049540417967364192, 0.00029999125399626791, 0.00043276950600557029, 0.00080375786637887359, 0.0010154364863410592, 0.00033241542405448854, 0.00048457316006533802, 0.00077153113670647144, 0.00015257467748597264, 0.00046206315164454281, 0.00033674674341455102, 0.00041143727139569819, 0.00028944746009074152, 0.00031965962261892855, 0.00039605927304364741, 0.00029878894565626979, 0.00044372552656568587, 0.00016992758901324123, 0.00036223485949449241, 0.00035597197711467743, 0.0020759440958499908, 0.00052287767175585032, 0.00022798562713433057, 0.00052196992328390479, 0.00033969533978961408, 0.00028132542502135038, 0.00074207974830642343, 0.00032417089096270502, 0.00087275716941803694, 0.00060472835320979357, 0.00087773840641602874, 0.00040598007035441697, 0.00024865701561793685, 0.00048019003588706255, 0.00019434455316513777, 0.00025401770835742354, 0.0004248741315677762, 0.00036071171052753925, 0.001949614379554987, 0.00044610770419239998, 0.00035447624395601451, 0.0014488931046798825, } };
const TfArray<48, int> quant21_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant21 = { (TfLiteFloatArray*)&quant21_scale, (TfLiteIntArray*)&quant21_zero, 0 };
const ALIGN(16) int8_t tensor_data22[1*3*3*48] = { 
  /* [0][0][][] */ 71,-92,97,70,52,-33,106,-65,60,-89,-78,48,52,-43,-70,-90,101,77,49,78,67,-74,-82,51,-32,-39,-63,-64,-66,61,-61,-114,-13,41,69,66,-65,52,-50,-23,51,-73,58,61,-93,11,75,-36, 82,-96,127,85,-76,-67,-58,-85,95,-100,-64,74,78,-108,-93,92,-37,97,82,127,85,-116,52,71,-51,-76,-70,-80,55,79,-30,-127,-85,78,81,85,-81,81,-83,-15,76,-96,83,89,-73,-127,93,-102, 34,-45,69,37,18,-41,-47,-40,42,-31,6,34,29,-77,-55,-1,-52,39,35,70,33,-55,31,26,-29,-45,-45,-23,31,30,87,-90,-84,43,36,35,-30,39,-37,-11,40,-42,34,43,-5,-9,37,-72, 
  /* [0][1][][] */ 92,-112,-41,94,54,-82,127,-89,87,-112,-70,81,84,-111,-13,-127,127,108,75,-39,82,108,-127,73,72,-75,-94,-98,-127,85,-68,-9,-87,70,107,97,-85,80,-81,88,85,-100,86,91,-89,106,94,-91, 127,-127,-64,127,-127,-127,-92,-127,127,-127,-127,127,127,-127,-21,97,-64,127,127,-51,127,127,68,127,127,-127,-127,-127,52,127,-27,17,-127,127,127,127,-127,127,-127,127,127,-127,127,127,-127,-12,127,-127, 65,-76,-34,64,37,-62,-49,-61,57,-42,-60,58,48,-52,-17,11,-61,51,58,-30,58,64,50,63,64,-64,-64,-45,36,54,127,15,-60,68,50,50,-49,61,-59,55,61,-60,53,62,-62,-68,59,-56, 
  /* [0][2][][] */ 44,-52,-46,51,26,-54,63,-43,41,-72,-5,40,57,-73,82,-80,74,51,35,-30,24,-11,-76,30,-24,-45,-47,-48,-75,31,-40,90,-74,37,48,43,-27,37,-43,-86,48,-51,41,45,-26,15,41,-74, 74,-75,-48,79,-57,-64,-73,-66,53,-75,-66,61,75,-48,127,32,-45,60,62,-43,53,-19,41,67,-48,-66,-76,-60,30,62,-24,118,-55,65,56,57,-50,62,-66,-104,70,-67,61,62,-88,48,65,-52, 43,-41,-27,45,28,-19,-18,-33,15,-25,-52,28,33,5,66,24,-34,24,28,-31,28,-1,39,42,-25,-28,-49,-24,34,34,61,67,0,33,15,22,-23,30,-29,-55,28,-32,26,29,-64,8,33,-4, 
};
const TfArray<4, int> tensor_dimension22 = { 4, { 1,3,3,48 } };
const TfArray<48, float> quant22_scale = { 48, { 0.0021058395504951477, 0.0017351610586047173, 0.0077943289652466774, 0.0023435489274561405, 0.0071081598289310932, 0.0025434175040572882, 0.0060054617933928967, 0.0035256503615528345, 0.0039097587577998638, 0.0016881804913282394, 0.0013882688945159316, 0.004520840011537075, 0.001898153917863965, 0.0015090132365003228, 0.0065124682150781155, 0.0073550012893974781, 0.0070067141205072403, 0.0033124510664492846, 0.0050464235246181488, 0.0070682922378182411, 0.0033732389565557241, 0.010457964614033699, 0.0038297034334391356, 0.0048476653173565865, 0.0058877929113805294, 0.0034853017423301935, 0.0013222208945080638, 0.0031191706657409668, 0.0051520657725632191, 0.0053374757990241051, 0.0046500610187649727, 0.0061666360124945641, 0.0019783838652074337, 0.0043249842710793018, 0.0013687802711501718, 0.002183426870033145, 0.0061645437963306904, 0.0034348764456808567, 0.0037611930165439844, 0.0042428877204656601, 0.0037987420801073313, 0.0038649220950901508, 0.0031561758369207382, 0.0027577842120081186, 0.0011006226995959878, 0.0073505179025232792, 0.0044449856504797935, 0.0014490255853161216, } };
const TfArray<48, int> quant22_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant22 = { (TfLiteFloatArray*)&quant22_scale, (TfLiteIntArray*)&quant22_zero, 3 };
const ALIGN(16) int32_t tensor_data23[48] = { 12673, 35553, -1126, 41042, 4140, 129923, -2635, 65890, 1931, 30248, 18704, 507, -1067, 25506, -1551, -2700, -205, 380, 1781, -2255, 1792, -2586, 1510, -18222, -4574, 51516, 132744, 97839, 2071, 3152, -1901, 445, 20474, 2551, 27911, 2615, 40290, 3846, 62767, 1608, 2904, 62456, 240, 8396, 56020, 795, 1248, 46989, };
const TfArray<1, int> tensor_dimension23 = { 1, { 48 } };
const TfArray<48, float> quant23_scale = { 48, { 4.9549165851203725e-05, 4.0827319025993347e-05, 0.00018339598318561912, 5.5142329074442387e-05, 0.00016725082241464406, 5.9845118812518194e-05, 0.00014130499039310962, 8.295648149214685e-05, 9.199432679452002e-05, 3.9721893699606881e-05, 3.266514977440238e-05, 0.0001063727104337886, 4.4662447180598974e-05, 3.5506192944012582e-05, 0.00015323454863391817, 0.00017305885558016598, 0.00016486387175973505, 7.7940028859302402e-05, 0.00011873937910422683, 0.00016631276230327785, 7.9370329331140965e-05, 0.00024606977240182459, 9.0110668679699302e-05, 0.00011406271369196475, 0.00013853629934601486, 8.2007099990732968e-05, 3.1111081625567749e-05, 7.3392249760217965e-05, 0.00012122507905587554, 0.00012558767048176378, 0.0001094132021535188, 0.00014509732136502862, 4.6550208935514092e-05, 0.00010176433715969324, 3.2206593459704891e-05, 5.1374750910326838e-05, 0.00014504809223581105, 8.0820624134503305e-05, 8.8498658442404121e-05, 9.9832657724618912e-05, 8.93821706995368e-05, 9.093934204429388e-05, 7.4262963607907295e-05, 6.4889041823334992e-05, 2.5897004888975061e-05, 0.00017295336874667555, 0.00010458789620315656, 3.4094719012500718e-05, } };
const TfArray<48, int> quant23_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant23 = { (TfLiteFloatArray*)&quant23_scale, (TfLiteIntArray*)&quant23_zero, 0 };
const ALIGN(16) int8_t tensor_data24[16*1*1*48] = { 
  /* [0][0][][] */ -14,-8,-23,9,26,-5,1,99,-53,11,33,-8,19,-7,-17,14,17,-15,-5,-6,60,-8,17,126,-11,82,-8,-17,34,-19,19,-26,-18,53,22,-44,16,41,15,-7,-102,-17,19,44,42,20,-127,-42, 
  /* [1][0][][] */ -40,-16,26,5,-37,12,5,59,-54,-29,11,-48,-20,-18,2,-2,-25,127,-17,9,6,7,-23,-22,17,-42,16,31,-25,-83,-40,24,-19,-7,25,-2,-8,-34,3,6,-25,-37,124,11,7,2,27,-9, 
  /* [2][0][][] */ -19,-3,-11,-38,-2,-63,4,-20,0,15,18,27,12,12,-15,9,-4,-20,-27,-8,-6,0,-3,-127,-14,73,-11,5,1,-17,-3,-8,-5,55,10,-2,22,14,25,3,-37,0,-15,-5,0,-12,18,8, 
  /* [3][0][][] */ -4,33,1,-32,-2,-2,3,-8,-22,-3,-1,37,-127,7,-2,-1,3,5,-20,0,-28,8,7,18,-9,-13,1,24,-5,21,1,15,6,0,18,20,-11,29,38,7,13,7,28,-26,10,-7,2,21, 
  /* [4][0][][] */ 36,-29,2,6,17,27,18,-20,-30,8,-16,-22,-2,17,1,14,18,-9,-83,-1,-8,8,18,73,0,-21,1,51,5,-78,20,8,11,-37,31,-127,10,34,2,13,-24,20,10,-30,-9,-16,5,8, 
  /* [5][0][][] */ 32,-1,-16,58,1,-13,9,24,-2,-9,37,7,7,51,-4,1,-25,20,30,10,12,-4,0,-25,1,-55,-1,-28,-1,-13,8,12,61,-127,7,35,-11,-13,9,6,-96,52,23,0,-4,0,-106,-6, 
  /* [6][0][][] */ 23,-4,8,2,-14,-4,5,-11,-2,5,0,3,-15,6,2,4,1,-10,127,7,5,10,17,-36,5,4,27,-12,-12,-6,-4,8,-1,-11,28,-38,-1,-44,70,9,-2,-10,-8,5,-12,6,7,-10, 
  /* [7][0][][] */ -48,-19,-11,29,-11,82,-10,48,-6,28,-14,127,81,-5,-10,-7,-9,-33,-13,-29,-34,-11,-18,69,0,-42,-53,-32,-13,-19,-19,-10,3,-1,-20,0,12,-64,103,-3,21,30,-71,-60,20,-8,-1,0, 
  /* [8][0][][] */ -49,-45,-2,1,-7,2,9,32,3,-76,7,42,51,4,6,9,-11,66,-30,7,-51,24,-6,-14,-6,3,7,43,-4,122,-9,22,1,0,-16,-127,-115,71,32,20,18,-6,115,-26,7,30,29,30, 
  /* [9][0][][] */ -28,6,-6,36,18,-27,-1,-1,61,-39,15,59,-51,-6,12,1,-3,22,-31,-12,52,14,-15,-20,5,9,48,-21,7,12,12,-1,6,12,72,-105,-10,-127,-95,15,-27,35,56,11,0,7,-11,-45, 
  /* [10][0][][] */ -18,-11,-29,-127,44,88,12,-16,3,27,20,9,52,-56,-26,25,36,-43,63,-30,38,-18,42,57,-46,-117,6,-38,45,28,51,-38,-28,-85,31,-2,21,-45,1,-32,-31,-69,-5,18,15,16,18,-41, 
  /* [11][0][][] */ 5,61,9,74,41,-74,-69,-21,4,53,-18,7,-15,47,-4,-72,19,40,14,-9,-60,-102,15,9,14,-42,20,-28,60,-29,24,-87,52,-17,-26,-87,104,29,0,-127,6,69,112,-67,-9,-52,32,33, 
  /* [12][0][][] */ 127,-5,-9,14,7,17,2,92,21,-10,-54,-23,2,13,-6,-2,-9,11,-6,-9,0,2,6,17,-2,13,0,3,-1,16,-5,5,0,-57,-13,11,-19,-11,-32,-3,-15,-84,7,-119,-55,-9,78,-6, 
  /* [13][0][][] */ 9,5,-2,7,8,-11,4,2,2,4,2,23,-7,4,5,2,6,1,12,4,14,-10,7,-2,2,2,16,127,7,-4,7,-3,3,-1,-35,23,10,-8,7,-18,-13,-2,3,3,0,-3,-9,-15, 
  /* [14][0][][] */ 72,-26,49,-68,57,24,32,-99,-61,-53,-10,122,-71,-5,66,11,54,23,-53,73,18,19,78,-8,29,57,-35,-123,27,-40,61,44,-15,82,-127,-48,-36,49,93,10,-29,4,51,1,5,-4,12,-29, 
  /* [15][0][][] */ -2,-47,-82,-32,57,25,65,-52,-13,7,-26,-36,76,24,-94,58,58,41,86,-78,-90,-24,53,-9,-82,44,30,49,50,44,52,-49,18,64,103,127,-13,-114,-8,-25,98,62,115,-49,3,-24,-22,59, 
};
const TfArray<4, int> tensor_dimension24 = { 4, { 16,1,1,48 } };
const TfArray<16, float> quant24_scale = { 16, { 0.030494827777147293, 0.035558592528104782, 0.039968311786651611, 0.047122351825237274, 0.031572528183460236, 0.051237780600786209, 0.040452662855386734, 0.024297714233398438, 0.030170397832989693, 0.028243428096175194, 0.030932269990444183, 0.02562003955245018, 0.04783785343170166, 0.059712447226047516, 0.018449326977133751, 0.026038400828838348, } };
const TfArray<16, int> quant24_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant24 = { (TfLiteFloatArray*)&quant24_scale, (TfLiteIntArray*)&quant24_zero, 0 };
const ALIGN(16) int32_t tensor_data25[16] = { -36279, 6356, 1926, -6835, 747, -2741, -9386, -41599, 3840, 20594, 34322, -14720, 2350, -24052, 39852, -45779, };
const TfArray<1, int> tensor_dimension25 = { 1, { 16 } };
const TfArray<16, float> quant25_scale = { 16, { 0.00071752537041902542, 0.00083667278522625566, 0.0009404309093952179, 0.0011087612947449088, 0.00074288301402702928, 0.0012055948609486222, 0.00095182738732546568, 0.00057171093067154288, 0.00070989172672852874, 0.0006645512767136097, 0.00072781811468303204, 0.00060282449703663588, 0.0011255965800955892, 0.0014049988240003586, 0.00043410182115621865, 0.00061266828561201692, } };
const TfArray<16, int> quant25_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant25 = { (TfLiteFloatArray*)&quant25_scale, (TfLiteIntArray*)&quant25_zero, 0 };
const ALIGN(16) int8_t tensor_data26[96*1*1*16] = { 
  /* [0][0][][] */ 42,1,127,101,88,-42,26,-66,101,-34,-84,-85,53,62,-17,-104, 
  /* [1][0][][] */ 51,63,6,-1,107,-11,-5,21,46,65,-44,127,3,-24,90,-111, 
  /* [2][0][][] */ 30,-80,-15,35,-68,28,-49,83,-52,-80,13,85,-25,-127,101,-98, 
  /* [3][0][][] */ 127,113,-25,28,-121,-6,-54,-27,-2,7,109,-65,-62,62,-15,-26, 
  /* [4][0][][] */ -13,-7,12,19,-29,36,-21,52,-59,-49,-22,5,-7,-127,33,0, 
  /* [5][0][][] */ 120,-88,-45,-4,-1,-95,-34,14,-14,4,-127,5,20,-21,16,53, 
  /* [6][0][][] */ -127,-64,-26,81,-49,7,-50,-2,-120,-59,-36,-51,19,7,12,90, 
  /* [7][0][][] */ -24,15,-62,34,50,-127,-31,32,4,-34,20,-12,-9,9,-41,1, 
  /* [8][0][][] */ 28,-44,-11,-26,-2,12,-66,-72,-10,9,-63,-1,-127,-8,16,24, 
  /* [9][0][][] */ 15,-51,62,95,-7,12,-43,-98,127,-114,23,-20,-17,42,-65,43, 
  /* [10][0][][] */ -76,-104,-20,-13,127,10,27,90,118,-69,-94,70,77,-94,-77,99, 
  /* [11][0][][] */ 41,-16,-127,17,38,26,-17,32,-13,-24,-6,-5,-2,13,-41,15, 
  /* [12][0][][] */ 105,-51,-8,11,-29,-48,-55,-44,35,3,-127,-27,-64,-20,-11,52, 
  /* [13][0][][] */ 2,-72,35,-81,101,33,-106,-127,56,-63,73,-13,31,-2,28,-3, 
  /* [14][0][][] */ -56,15,-91,-42,79,-119,59,-61,67,55,2,-123,29,127,-19,39, 
  /* [15][0][][] */ 27,5,77,43,56,-19,-25,3,0,-56,-59,-4,-127,-48,-52,55, 
  /* [16][0][][] */ -116,82,-22,20,-4,109,56,71,-35,20,127,-4,-10,2,24,-41, 
  /* [17][0][][] */ -8,0,-44,-33,-37,17,41,65,-27,127,-15,2,-11,60,58,2, 
  /* [18][0][][] */ 4,127,-55,-11,-12,-19,53,-76,14,95,-58,88,8,-57,45,-76, 
  /* [19][0][][] */ 15,-22,50,30,5,45,-8,25,15,3,-54,1,-127,7,-21,36, 
  /* [20][0][][] */ 94,-57,12,-98,-32,22,36,-66,-72,21,-127,-40,25,10,45,7, 
  /* [21][0][][] */ 76,-33,127,50,-19,35,28,14,24,51,-23,4,-7,69,-1,-3, 
  /* [22][0][][] */ 17,10,18,2,-11,6,28,127,17,5,25,25,3,38,24,8, 
  /* [23][0][][] */ -17,4,-100,25,2,-127,13,26,-7,-32,-18,-22,-85,-5,20,41, 
  /* [24][0][][] */ 45,-54,-10,-59,48,-4,-37,-22,21,39,47,98,-53,59,127,51, 
  /* [25][0][][] */ -127,-90,-31,-11,-7,4,5,-33,-45,-21,-67,3,26,42,36,32, 
  /* [26][0][][] */ 24,-19,45,-6,5,-17,-49,46,-50,-72,-9,18,9,-127,39,-6, 
  /* [27][0][][] */ -106,38,-44,37,20,-20,7,29,38,-33,127,31,-17,6,-14,-28, 
  /* [28][0][][] */ -11,-9,17,33,1,10,13,81,19,10,-22,-6,-127,-11,-15,42, 
  /* [29][0][][] */ -5,65,47,-33,34,-25,14,-24,-127,27,-39,7,7,40,-87,9, 
  /* [30][0][][] */ -18,4,-127,-45,25,-48,6,15,-11,-10,2,-37,-32,-16,7,7, 
  /* [31][0][][] */ 126,-47,-127,7,69,19,-54,67,-20,7,-68,-19,-7,-44,-68,25, 
  /* [32][0][][] */ -127,42,18,24,8,84,14,13,16,-23,121,2,-19,19,-11,-19, 
  /* [33][0][][] */ -4,2,127,-34,-53,29,5,-42,-5,-2,-9,4,-10,18,36,-3, 
  /* [34][0][][] */ -12,-35,-27,-127,50,-19,-17,-42,-11,-57,-47,-113,-30,5,31,9, 
  /* [35][0][][] */ -7,-29,35,51,52,-6,21,-9,-127,46,-4,33,-38,119,-42,-45, 
  /* [36][0][][] */ -113,58,-15,0,-19,41,38,97,-1,61,127,-5,-6,31,12,-24, 
  /* [37][0][][] */ -47,21,127,-57,-88,-89,33,-48,12,2,5,-14,-13,-76,87,6, 
  /* [38][0][][] */ 23,-28,-29,39,23,-54,-61,17,-15,0,66,-9,127,33,-11,28, 
  /* [39][0][][] */ -51,-39,-39,-60,-70,-94,50,127,-48,8,40,-47,-8,41,92,74, 
  /* [40][0][][] */ 66,-25,-12,4,-2,79,-24,1,18,0,4,23,127,9,-20,-13, 
  /* [41][0][][] */ -9,-17,-27,-127,41,2,-48,-83,7,-47,15,-31,-26,-16,-10,28, 
  /* [42][0][][] */ 26,84,-12,101,-127,2,-93,-5,-99,-43,121,-108,-57,127,-47,25, 
  /* [43][0][][] */ 19,111,-29,127,22,45,39,-71,-42,86,4,34,1,-43,38,32, 
  /* [44][0][][] */ -11,-3,-127,2,71,94,-52,62,-38,-17,62,-34,-7,-55,-65,-10, 
  /* [45][0][][] */ -11,16,-6,-127,-20,7,64,-24,4,35,-13,16,-6,-101,24,-47, 
  /* [46][0][][] */ 23,41,51,-17,14,15,-44,53,27,-39,-38,6,8,127,54,-13, 
  /* [47][0][][] */ 12,-27,29,-39,-29,16,-68,53,-9,-37,20,39,-1,-127,34,7, 
  /* [48][0][][] */ 6,-3,16,-127,-13,-13,0,8,16,-23,14,-16,18,45,-9,66, 
  /* [49][0][][] */ 30,-31,3,122,109,15,-5,44,-60,7,48,48,-8,38,127,-22, 
  /* [50][0][][] */ 15,-6,96,18,6,127,-39,-84,63,-14,85,52,121,-18,-25,-112, 
  /* [51][0][][] */ 23,38,13,16,24,8,-44,17,39,5,1,127,14,19,21,-47, 
  /* [52][0][][] */ -31,40,127,-4,13,-25,4,-52,-15,-1,16,31,12,75,-95,-6, 
  /* [53][0][][] */ 0,-8,-51,-127,-50,18,22,-38,-26,49,7,5,24,-38,53,17, 
  /* [54][0][][] */ 8,7,-44,-57,-1,15,5,14,50,-41,15,-51,-2,127,33,32, 
  /* [55][0][][] */ -21,-10,-55,-35,1,-45,20,-127,8,-71,4,-25,-12,-88,-45,-11, 
  /* [56][0][][] */ 49,56,38,53,16,-34,7,127,20,-38,5,-45,96,-4,-51,35, 
  /* [57][0][][] */ 61,-30,127,-13,-123,-91,27,-39,44,45,-89,1,88,-57,56,53, 
  /* [58][0][][] */ 111,100,11,91,-127,-46,-6,47,-29,19,111,-49,-57,-53,-28,-80, 
  /* [59][0][][] */ 116,-37,-22,-2,-38,-10,-5,3,-39,6,-127,-10,2,-14,30,29, 
  /* [60][0][][] */ -127,48,-26,-31,-2,-5,45,40,-10,18,109,-20,-47,-18,40,-11, 
  /* [61][0][][] */ -127,69,-5,12,61,27,-92,-73,118,-69,77,4,38,-73,-115,-34, 
  /* [62][0][][] */ -35,-17,-126,60,64,127,22,102,30,-49,54,-22,-65,-21,-112,-9, 
  /* [63][0][][] */ -48,8,127,-22,-57,-53,25,-26,22,16,8,12,-17,-32,65,3, 
  /* [64][0][][] */ 11,80,18,22,53,14,103,-127,-9,111,14,-28,-26,-101,-6,32, 
  /* [65][0][][] */ 12,3,14,-16,68,-4,-17,-127,-28,-68,-46,-28,-1,-50,48,26, 
  /* [66][0][][] */ -127,-2,-24,3,-54,0,27,-40,-71,-26,-84,40,66,21,55,91, 
  /* [67][0][][] */ -30,-43,13,127,20,8,-15,58,74,45,19,-41,-7,-29,-111,-51, 
  /* [68][0][][] */ 8,23,-34,127,-79,-10,-9,-49,-55,41,33,-24,-23,-114,-22,-50, 
  /* [69][0][][] */ 69,91,10,109,49,-18,54,-127,35,92,39,61,26,-31,46,-4, 
  /* [70][0][][] */ -7,-11,46,-75,123,-27,35,-16,59,-58,74,-82,22,127,58,66, 
  /* [71][0][][] */ -3,45,11,93,46,-127,-37,97,47,-90,18,18,18,-56,-67,29, 
  /* [72][0][][] */ -127,-81,-36,58,8,32,-10,19,-53,-27,-95,23,61,8,7,89, 
  /* [73][0][][] */ 2,-25,-25,58,10,-25,-6,-7,68,20,-10,5,10,127,-44,-25, 
  /* [74][0][][] */ 58,-47,20,-40,-40,6,29,-26,-44,-21,-119,26,-127,-7,30,51, 
  /* [75][0][][] */ -10,-13,-5,127,-19,10,-3,-15,-51,19,-28,-17,2,-35,-29,-45, 
  /* [76][0][][] */ 11,-25,-14,44,24,10,-35,-127,9,-121,5,21,-30,-24,41,-28, 
  /* [77][0][][] */ 127,-30,38,55,-32,7,-31,12,55,4,-23,48,26,15,-79,30, 
  /* [78][0][][] */ -19,-8,39,-2,17,0,-87,27,55,-40,-59,-17,18,127,48,-13, 
  /* [79][0][][] */ -7,24,50,17,48,74,-57,-66,5,-46,79,-20,127,-37,-29,-44, 
  /* [80][0][][] */ -127,-94,-88,98,5,13,22,-17,-75,27,-78,12,38,-104,3,64, 
  /* [81][0][][] */ 86,-7,-49,58,127,65,-47,-24,13,-123,-43,-75,-1,16,-88,23, 
  /* [82][0][][] */ 103,114,25,35,-127,-28,-69,-21,-58,-17,93,-69,-47,106,-32,-43, 
  /* [83][0][][] */ 127,45,11,-30,4,-17,-11,25,34,22,85,-38,-51,-36,-20,-74, 
  /* [84][0][][] */ 6,-48,-38,-19,46,33,-6,-127,-14,-50,26,11,-19,8,0,-22, 
  /* [85][0][][] */ -34,7,-44,-61,-8,-5,94,95,-29,127,-1,-54,43,64,80,-41, 
  /* [86][0][][] */ 100,-23,0,-2,-14,-27,0,-24,-2,-5,-127,1,10,15,-10,28, 
  /* [87][0][][] */ -15,20,31,-33,-9,74,-22,59,0,-29,44,14,15,-127,6,-8, 
  /* [88][0][][] */ -25,-94,-112,-54,68,-39,-34,-127,34,-60,-20,-39,29,35,16,-42, 
  /* [89][0][][] */ 9,-39,54,-127,42,-14,-90,117,99,-86,44,30,-6,51,44,32, 
  /* [90][0][][] */ -4,55,-58,26,75,-10,96,-109,64,127,-20,27,22,-11,-20,-23, 
  /* [91][0][][] */ 36,-6,-27,-11,11,-127,-19,-14,-16,-15,-36,-17,27,-22,9,17, 
  /* [92][0][][] */ 52,-7,127,80,37,3,13,62,-44,66,-53,50,17,71,13,16, 
  /* [93][0][][] */ 127,-43,-46,-31,-35,-60,-9,48,-23,26,-104,-10,-9,35,8,68, 
  /* [94][0][][] */ 13,-16,55,77,114,-31,-5,56,6,-12,1,62,4,127,-32,-72, 
  /* [95][0][][] */ -119,56,22,48,17,62,20,-3,14,10,127,-3,-34,45,-17,-28, 
};
const TfArray<4, int> tensor_dimension26 = { 4, { 96,1,1,16 } };
const TfArray<96, float> quant26_scale = { 96, { 0.00045153655810281634, 0.00088939414126798511, 0.0004670514608733356, 0.0028757133986800909, 0.00098664755932986736, 0.00046553966240026057, 0.00076693325536325574, 0.0020981049165129662, 0.00098702684044837952, 0.0003982295747846365, 0.00067958951694890857, 0.0021362327970564365, 0.0012686752015724778, 0.00046094477875158191, 0.00072352925781160593, 0.0010172907495871186, 0.00063670886447653174, 0.00071445299545302987, 0.0008846380515024066, 0.0016954697202891111, 0.0013603189727291465, 0.00050348718650639057, 0.0011323958169668913, 0.00080258212983608246, 0.00083932548295706511, 0.0016339509747922421, 0.00091396563220769167, 0.0006753129418939352, 0.0018831138731911778, 0.0011848451104015112, 0.00084248476196080446, 0.00070241198409348726, 0.00044521209201775491, 0.0029914567712694407, 0.00076625827932730317, 0.0013456591404974461, 0.00033670902485027909, 0.0010364551562815905, 0.001776569290086627, 0.00057608360657468438, 0.0025483369827270508, 0.00050026987446472049, 0.00060376414330676198, 0.00051112071378156543, 0.00086703483248129487, 0.00093344488414004445, 0.00059894437436014414, 0.00074991409201174974, 0.0010942649096250534, 0.00085656176088377833, 0.0015008242335170507, 0.0032447578851133585, 0.00047888624249026179, 0.00063392420997843146, 0.00092217151541262865, 0.00035525896237231791, 0.0011294020805507898, 0.0006189322448335588, 0.0010102700907737017, 0.0012691011652350426, 0.000301352672977373, 0.00059662619605660439, 0.0011867267312481999, 0.0020236165728420019, 0.00056405045324936509, 0.00075519608799368143, 0.0010882847709581256, 0.0011439931113272905, 0.00035818168544210494, 0.00050369609380140901, 0.00072197202825918794, 0.0010576976928859949, 0.00091833050828427076, 0.0013260940322652459, 0.00078565726289525628, 0.0013511504512280226, 0.00028590226429514587, 0.0010098709026351571, 0.00035111853503622115, 0.0015811672201380134, 0.0006148807005956769, 0.0011660780292004347, 0.00064203538931906223, 0.0015995781868696213, 0.00085229967953637242, 0.00086271454347297549, 0.00079078518319875002, 0.00094646983779966831, 0.00054431729950010777, 0.00107325438875705, 0.00060091115301474929, 0.0014375940663740039, 0.00037262219120748341, 0.00040493713458999991, 0.00084277265705168247, 0.00065301574068143964, } };
const TfArray<96, int> quant26_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant26 = { (TfLiteFloatArray*)&quant26_scale, (TfLiteIntArray*)&quant26_zero, 0 };
const ALIGN(16) int32_t tensor_data27[96] = { 19705, 1352, 10138, -673, 5491, 6936, 13813, 5733, -1651, 15730, 7329, 1311, 7535, 35843, -605, -2462, 12024, 11006, 1760, -217, -687, 16826, 4512, 3313, 7148, 4398, 5247, 4790, 83, 54, 5889, 9110, 15109, 1198, 7318, -734, 23118, 8637, 830, 5733, 652, 12851, 12008, 4968, 4366, 11882, 16298, 6699, 4974, 3583, 313, -690, 19007, 8605, 8703, 18178, -346, 9532, 2632, 4502, 19602, 8013, 3050, 4692, 6307, 5142, 6062, -1033, 26012, 7973, 9322, -1478, -1504, 3456, 1830, 3150, 28784, 15174, 16497, -2630, 6012, -6041, -2292, 552, 6395, 6189, 6942, 4930, 10146, 5193, 7818, 3992, 19635, 23434, -11945, 17335, };
const TfArray<1, int> tensor_dimension27 = { 1, { 96 } };
const TfArray<96, float> quant27_scale = { 96, { 0.0001317445858148858, 0.00025949804694391787, 0.0001362713665002957, 0.0008390453876927495, 0.00028787364135496318, 0.00013583026884589344, 0.00022376771084964275, 0.00061216298490762711, 0.00028798429411835968, 0.00011619123688433319, 0.00019828348013106734, 0.00062328751664608717, 0.0003701607056427747, 0.00013448961544781923, 0.00021110374655108899, 0.00029681439627893269, 0.00018577220907900482, 0.00020845557446591556, 0.00025811037630774081, 0.00049468630459159613, 0.00039689955883659422, 0.00014690219541080296, 0.00033039852860383689, 0.0002341689687455073, 0.00024488955386914313, 0.00047673701192252338, 0.00026666728081181645, 0.00019703569705598056, 0.00054943514987826347, 0.0003457016428001225, 0.0002458113303873688, 0.00020494237833190709, 0.00012989930110052228, 0.0008728157845325768, 0.00022357077978085726, 0.00039262225618585944, 9.8241413070354611e-05, 0.00030240596970543265, 0.00051834870828315616, 0.00016808361397124827, 0.00074352696537971497, 0.00014596348046325147, 0.0001761599414749071, 0.00014912942424416542, 0.00025297430693171918, 0.00027235073503106833, 0.00017475368804298341, 0.00021880204440094531, 0.00031927309464663267, 0.00024991857935674489, 0.0004378946905490011, 0.00094672129489481449, 0.00013972439046483487, 0.00018495973199605942, 0.00026906150742433965, 0.00010365372145315632, 0.0003295250644441694, 0.00018058554269373417, 0.0002947659813798964, 0.00037028497899882495, 8.792550943326205e-05, 0.00017407731502316892, 0.00034625062835402787, 0.00059042952489107847, 0.00016457270248793066, 0.0002203431649832055, 0.00031752826180309057, 0.00033378225634805858, 0.00010450648551341146, 0.00014696313883177936, 0.00021064940665382892, 0.00030860389233566821, 0.00026794080622494221, 0.00038691377267241478, 0.00022923080541659147, 0.00039422445115633309, 8.3417551650200039e-05, 0.00029464950785040855, 0.00010244567238260061, 0.0004613363416865468, 0.00017940341786015779, 0.00034022596082650125, 0.00018732632452156395, 0.00046670809388160706, 0.00024867503088898957, 0.00025171376182697713, 0.00023072697513271123, 0.00027615099679678679, 0.0001588151790201664, 0.00031314286752603948, 0.00017532752826809883, 0.00041944606346078217, 0.00010871978156501427, 0.00011814829485956579, 0.00024589532404206693, 0.00019053005962632596, } };
const TfArray<96, int> quant27_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant27 = { (TfLiteFloatArray*)&quant27_scale, (TfLiteIntArray*)&quant27_zero, 0 };
const ALIGN(16) int8_t tensor_data28[1*3*3*96] = { 
  /* [0][0][][] */ -17,6,-21,105,-17,24,-62,-54,15,-7,95,-9,3,-7,-5,47,4,16,-30,3,73,2,32,-35,2,16,44,48,23,13,23,50,-8,29,12,-14,5,49,-60,-28,19,10,27,17,-84,-54,25,-5,-11,-23,-8,-7,51,5,-8,1,-1,-35,24,-31,26,-4,127,27,-14,-10,10,-54,64,34,-1,-8,80,-32,68,3,16,-127,29,66,1,15,127,-14,38,28,-27,-20,39,-6,-15,81,1,21,-3,13, -48,11,-8,12,52,-8,-10,-127,36,13,-127,-5,-16,-11,6,88,17,-30,-13,-17,76,-95,127,25,-61,-32,-104,-17,28,36,-49,19,119,13,-12,-1,-25,127,-59,-127,8,-18,-29,14,47,-127,127,-43,-77,52,48,6,40,-65,31,55,36,41,-100,84,127,33,2,-20,43,-37,-94,-2,36,-30,-19,45,-48,-49,105,-4,-30,-59,-34,64,-65,60,-19,8,-10,46,54,-41,-26,55,-14,73,-127,-30,23,-127, 0,-5,-23,-73,8,19,37,21,-4,-2,4,62,0,-12,-11,6,-15,17,-13,15,7,26,25,-33,1,-32,13,13,-5,5,45,-78,42,20,10,-22,11,4,-28,-21,8,4,-16,9,23,-33,21,1,7,-6,6,-5,6,5,-7,8,-5,43,8,-1,11,-20,2,-17,-27,-17,30,-51,-105,-6,43,-21,-127,-23,-11,16,10,-11,5,11,-13,22,-38,-3,-40,20,26,36,-21,-17,23,-11,20,8,-2,-45, 
  /* [0][1][][] */ -40,57,-19,39,-85,-16,-10,-45,25,94,-45,-21,-31,-24,-8,60,127,-25,-93,-13,56,-127,-28,15,-36,-48,-127,-7,38,36,-50,28,-127,-75,-56,4,65,-3,-50,45,-20,86,1,-3,35,-50,-13,-32,127,43,-4,20,46,9,-35,-18,32,9,-125,127,-38,-91,20,127,-60,-35,-85,127,-35,127,-21,51,-34,-56,37,9,-36,-70,127,50,127,36,4,-2,127,28,-94,46,-37,-36,-101,39,96,105,29,-59, 127,127,127,127,-45,-127,127,23,127,-127,16,-127,-107,127,127,127,-17,-127,-63,-127,127,24,-66,127,127,127,-55,-127,127,127,-127,127,-11,-127,-124,127,-127,-44,89,107,-127,-127,127,127,127,-118,-106,127,-14,127,-127,-127,-127,127,127,-127,127,-127,-41,41,-106,-29,-71,-68,127,127,-69,125,127,-105,-127,127,-44,127,-127,-127,-127,124,-77,127,-41,127,82,127,-38,-127,-24,-108,-127,-126,-23,-127,-21,-127,-127,119, -24,64,-39,3,127,71,-21,48,4,23,-13,-4,-27,-30,-13,-5,-106,-22,-127,37,31,80,-11,-116,-34,-41,127,71,12,36,72,10,124,-47,127,-3,54,5,-87,13,38,24,-23,2,-22,-54,-12,-42,81,15,-11,39,-5,-4,-77,-14,25,19,127,-89,1,127,-2,-36,-112,-27,-75,98,15,-15,113,22,-17,-57,11,48,-29,-7,-44,-4,-45,8,45,25,-89,34,127,-48,34,-23,127,-10,-110,37,33,20, 
  /* [0][2][][] */ -5,-37,-22,-59,-5,16,40,30,-2,8,-21,52,23,-34,-7,9,40,2,12,21,-8,32,-16,-27,1,-26,12,4,-9,-8,49,-74,-40,71,-27,-24,31,-34,-63,17,10,9,-34,19,11,-84,-12,-1,-9,7,19,-8,8,1,-20,6,1,43,-51,35,-4,-14,4,17,-7,-10,22,-51,-55,11,-24,-14,-121,-34,0,18,13,-12,56,18,22,21,-44,16,13,25,-20,9,7,24,21,-5,19,42,-7,-31, -28,-8,-28,25,-44,74,-25,65,6,-7,52,-11,127,-7,-19,-12,-2,-40,-59,22,-20,79,-43,-112,-47,-48,103,70,16,45,53,0,-126,66,-15,-22,-29,-25,-127,-4,47,-15,-15,36,-25,-51,-17,-47,-60,27,70,24,-9,-81,29,52,17,26,73,-55,22,-60,-8,1,19,-25,-127,-54,-10,-26,-62,22,36,-48,-30,-8,-46,24,-57,2,49,33,18,10,5,61,-90,127,18,127,-31,-18,115,-20,46,84, -10,-32,-27,28,13,65,-43,12,3,-6,0,14,12,-51,-10,-12,-45,-5,19,18,-21,6,-20,3,-4,19,-2,51,-1,-5,33,31,14,45,20,-22,-7,-26,-28,8,12,-11,22,9,-71,-36,-12,5,-1,-17,1,-5,-7,8,-18,-5,1,-49,12,-30,-20,49,9,-29,-11,-2,33,-54,45,7,53,-23,30,-57,-19,22,10,12,-4,22,-30,30,94,-14,-17,53,39,-9,115,11,1,-19,12,-21,-7,-51, 
};
const TfArray<4, int> tensor_dimension28 = { 4, { 1,3,3,96 } };
const TfArray<96, float> quant28_scale = { 96, { 0.0081610884517431259, 0.0066801547072827816, 0.010785060003399849, 0.0013495545135810971, 0.0062900758348405361, 0.0074332738295197487, 0.014512760564684868, 0.0032152971252799034, 0.0045542838051915169, 0.015142820775508881, 0.0075739775784313679, 0.014292154461145401, 0.0047825411893427372, 0.018398001790046692, 0.0070556565187871456, 0.0081129949539899826, 0.0044909319840371609, 0.012762199155986309, 0.0027561800088733435, 0.014379781670868397, 0.0016902296338230371, 0.0071972855366766453, 0.0058420132845640182, 0.014645710587501526, 0.0094904452562332153, 0.010759857483208179, 0.005414172075688839, 0.0084253111854195595, 0.005959799513220787, 0.0042475149966776371, 0.0053027505055069923, 0.0073096249252557755, 0.0052027446217834949, 0.0057399086654186249, 0.0080597782507538795, 0.0073306462727487087, 0.0159637201577425, 0.0054907221347093582, 0.0016444181092083454, 0.0066240802407264709, 0.010461459867656231, 0.01434994675219059, 0.012660890817642212, 0.0071523427031934261, 0.0074741095304489136, 0.0024650141131132841, 0.0081968773156404495, 0.0092026377096772194, 0.0036066637840121984, 0.0077319061383605003, 0.0098258303478360176, 0.0079452274367213249, 0.0089360000565648079, 0.009828704409301281, 0.0097626307979226112, 0.019673664122819901, 0.017779726535081863, 0.0089814625680446625, 0.0043791132047772408, 0.0031332799699157476, 0.013486659154295921, 0.0059467460960149765, 0.015581411309540272, 0.0047697569243609905, 0.0074054328724741936, 0.0081698186695575714, 0.003378329100087285, 0.0033802199177443981, 0.0154541851952672, 0.0081630656495690346, 0.0085191968828439713, 0.0049335518851876259, 0.0049345614388585091, 0.0068527939729392529, 0.0073681836947798729, 0.010461601428687572, 0.021371554583311081, 0.0021607088856399059, 0.010647433809936047, 0.0076920432038605213, 0.0067858565598726273, 0.0091926176100969315, 0.0052315425127744675, 0.0062864241190254688, 0.0054743736982345581, 0.0046722739934921265, 0.0053964410908520222, 0.007391585037112236, 0.0089395958930253983, 0.0045392955653369427, 0.0092143397778272629, 0.0055234408937394619, 0.0060030156746506691, 0.019760709255933762, 1.1906290054321289, 0.0034149282146245241, } };
const TfArray<96, int> quant28_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant28 = { (TfLiteFloatArray*)&quant28_scale, (TfLiteIntArray*)&quant28_zero, 3 };
const ALIGN(16) int32_t tensor_data29[96] = { 9897, -8811, 3387, 69839, -2476, -4509, -10385, 4207, -3124, 1501, 3492, -1882, 1777, -5922, 6202, -4333, 283, 16637, 24052, 2179, 4775, -3107, -911, 160, 16072, -101, -1802, -3287, -5544, -7890, 6338, -9569, 1206, -1572, -1775, 13483, 1808, -4080, 19393, 1219, -538, 1925, -10599, -7467, -7889, 67067, -654, 15538, 31507, -12820, -12, 7234, 6454, -203, -6076, 2818, -10199, 1970, 1939, -6448, -1278, 439, -9285, -1226, 1460, 15130, 29316, 22570, -12235, -523, -8025, -1313, 49676, 11417, 53, 505, 19290, 33287, -41, -9581, -1940, -9738, 1124, -2763, 457, -228, 517, -111, 135, -3219, 891, -772, -92, -1224, 43, 47323, };
const TfArray<1, int> tensor_dimension29 = { 1, { 96 } };
const TfArray<96, float> quant29_scale = { 96, { 0.00019202561816200614, 0.00015718011127319187, 0.00025376613484695554, 3.1754225346958265e-05, 0.00014800178178120404, 0.00017490056052338332, 0.00034147672704420984, 7.5654053944163024e-05, 0.00010715961980167776, 0.00035630166530609131, 0.00017821123765315861, 0.00033628600067459047, 0.00011253038246650249, 0.00043289415771141648, 0.00016601545212324709, 0.00019089400302618742, 0.00010566898708930239, 0.0003002870362251997, 6.4851294155232608e-05, 0.00033834780333563685, 3.9770111470716074e-05, 0.00016934789891820401, 0.00013745913747698069, 0.00034460495226085186, 0.00022330459614749998, 0.00025317311519756913, 0.00012739228259306401, 0.00019824261835310608, 0.00014023057883605361, 9.9941527878399938e-05, 0.00012477060954552144, 0.00017199118155986071, 0.00012241752119734883, 0.00013505667448043823, 0.00018964183982461691, 0.0001724858011584729, 0.00037561694625765085, 0.00012919346045237035, 3.8692192902090028e-05, 0.0001558607182232663, 0.00024615199072286487, 0.00033764581894502044, 0.00029790331609547138, 0.00016829042579047382, 0.00017586140893399715, 5.8000332501251251e-05, 0.00019286770839244127, 0.00021653265866916627, 8.4862680523656309e-05, 0.00018192720017395914, 0.00023119601246435195, 0.0001869465340860188, 0.00021025883324909955, 0.00023126363521441817, 0.00022970896679908037, 0.00046290975296869874, 0.00041834652074612677, 0.00021132852998562157, 0.00010303795716026798, 7.3724237154237926e-05, 0.00031733314972370863, 0.0001399234461132437, 0.00036662144702859223, 0.00011222957982681692, 0.00017424547695554793, 0.00019223103299736977, 7.9490098869428039e-05, 7.953459135023877e-05, 0.00036362788523547351, 0.00019207214063499123, 0.00020045170094817877, 0.00011608357453951612, 0.00011610733054112643, 0.00016124222020152956, 0.00017336902965325862, 0.00024615533766336739, 0.00050286011537536979, 5.0840211770264432e-05, 0.00025052786804735661, 0.00018098925647791475, 0.00015966722276061773, 0.00021629688853863627, 0.00012309511657804251, 0.00014791586727369577, 0.0001288087951252237, 0.00010993586329277605, 0.00012697509373538196, 0.00017391964502166957, 0.00021034343808423728, 0.00010680695413611829, 0.0002168079954572022, 0.00012996331497561187, 0.00014124743756838143, 0.00046495787682943046, 0.028014801442623138, 8.0351252108812332e-05, } };
const TfArray<96, int> quant29_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant29 = { (TfLiteFloatArray*)&quant29_scale, (TfLiteIntArray*)&quant29_zero, 0 };
const ALIGN(16) int8_t tensor_data30[16*1*1*96] = { 
  /* [0][0][][] */ -3,19,-21,10,30,84,-31,-19,44,1,8,5,0,6,30,78,-6,-7,-10,-3,98,-59,19,-9,-32,-29,-44,-119,4,-1,52,57,127,1,2,-11,4,-18,-13,5,-47,7,7,-28,8,-24,-9,20,-15,21,-1,-7,-33,-3,-6,-6,44,13,-28,-32,-56,31,0,-13,13,14,56,4,3,0,-11,-26,-64,1,-11,-6,-1,-92,1,-35,29,-19,-71,-43,15,-24,-9,12,3,5,11,-44,32,23,-15,124, 
  /* [1][0][][] */ 49,-88,35,87,7,-76,22,-51,-23,-67,-18,26,2,-54,-45,-48,-72,13,17,27,-19,-88,-31,10,126,-49,-54,18,-42,75,-28,51,17,15,-47,9,0,-6,29,-33,2,-62,59,-32,-54,11,55,-1,12,11,11,-39,58,-70,46,-23,3,18,-16,-78,33,-58,6,-30,-11,-72,18,45,38,80,-46,1,-127,22,-1,77,15,85,27,-1,69,3,-59,37,-64,62,16,68,-65,28,26,30,11,-43,37,6, 
  /* [2][0][][] */ 29,19,26,-23,19,-7,2,25,58,-8,14,67,-8,25,43,-4,-12,-17,8,-10,-18,-54,5,-50,6,-17,-25,34,-18,13,107,-53,28,-61,-19,62,21,127,-47,-16,20,2,0,38,-41,-54,-55,33,30,28,-17,-35,30,-1,-7,-33,-41,-6,8,21,19,9,80,105,19,-75,21,-61,5,-7,8,1,-18,8,-19,8,1,62,11,26,31,79,26,-16,1,20,13,13,15,3,6,-47,-32,-2,-3,49, 
  /* [3][0][][] */ -12,-30,-31,36,32,-5,0,-19,-2,22,2,9,7,1,43,-12,36,-31,14,4,-13,-1,-16,0,-11,19,16,-2,36,-44,37,-18,17,-35,-20,27,-26,-8,-6,5,6,-66,22,-18,4,-6,-5,12,-127,40,-15,24,-115,-47,-11,-34,25,13,-5,44,-2,21,17,12,4,-76,-35,13,40,28,-5,20,-48,2,-6,-20,-38,-52,22,-21,10,-16,17,57,37,51,27,6,21,-12,-2,2,-22,10,-18,-22, 
  /* [4][0][][] */ -5,-24,3,-66,-11,-6,-67,3,-32,-47,-29,-9,11,64,21,5,52,-11,18,10,-12,18,54,4,-16,-6,12,-4,6,-8,-5,-18,-45,19,-3,17,24,-27,-2,-18,7,-7,-81,-25,34,4,-3,-26,1,83,-24,-14,-22,-13,11,-8,8,-25,16,31,9,-4,0,-17,24,-105,18,-16,-47,5,-27,3,-2,13,-24,21,-16,57,50,0,-8,5,127,-45,39,-26,-14,-7,65,14,-12,16,-34,26,-4,-22, 
  /* [5][0][][] */ -10,-7,-4,-10,4,-13,9,100,63,-20,-2,-28,-7,29,32,34,-15,-3,2,-32,-35,-18,3,-49,5,5,26,74,58,8,75,40,-46,34,12,-13,-35,-60,-20,-7,-26,-1,-5,-16,62,-1,16,19,32,-1,-5,12,-17,-5,-3,-13,-15,-18,10,35,-58,26,-15,-35,16,12,-23,-8,9,2,15,-6,42,22,8,-8,-22,17,19,123,14,-37,28,46,7,1,24,-29,19,-12,17,-119,-33,-8,-3,-127, 
  /* [6][0][][] */ -32,-4,-9,-52,4,-35,-13,19,4,11,-17,-3,30,-58,-4,-2,5,-64,30,11,6,5,-22,16,95,-16,1,5,10,-3,11,-17,-32,7,-23,3,34,-1,17,37,11,-26,-42,-30,-8,-27,22,-127,25,27,32,13,15,2,0,-46,34,-6,4,17,18,23,-7,20,40,67,25,-25,-6,-8,17,-24,20,12,54,-3,-37,32,13,14,-5,-5,65,-24,10,45,37,-12,20,22,-31,-1,-32,5,-2,16, 
  /* [7][0][][] */ 22,11,26,-28,-5,4,-12,-21,4,-17,-8,-11,-5,-89,20,4,-7,-28,-23,-7,12,-19,-30,-10,-20,-8,-2,-22,7,12,11,-4,-14,2,-14,-30,5,-12,-26,27,9,-15,-26,31,1,7,-10,63,3,14,-19,-17,-25,10,-6,-45,42,0,-2,2,-6,5,-18,-7,-18,40,7,-27,-11,-12,-5,38,0,-2,-8,3,44,6,4,-14,-2,-28,31,4,-35,127,-8,-1,-40,-18,-6,21,-25,2,-7,6, 
  /* [8][0][][] */ -65,48,-41,5,55,-22,10,24,3,72,-44,23,3,52,60,-18,17,35,-82,19,12,37,-29,-6,-25,-25,27,24,34,-89,-7,-7,32,18,22,0,-3,37,-38,50,20,25,14,-127,-36,-22,47,-8,-51,11,19,53,-96,70,26,1,-3,-26,-8,-23,4,-31,14,32,-27,26,38,-17,8,18,52,73,-33,29,45,25,-10,-82,-3,-29,17,-23,27,-2,-49,14,31,-39,6,47,-11,6,52,-17,-14,-23, 
  /* [9][0][][] */ 21,-52,-33,-30,15,30,-15,13,33,-9,-9,15,-50,-25,11,15,-1,-5,30,-27,-30,8,-24,-40,33,15,21,-2,-14,-43,-27,9,-12,-8,11,20,-1,37,-35,17,-9,-6,-17,-76,2,-10,31,-127,-53,8,-11,23,-29,8,-4,2,-52,17,-28,11,4,17,21,16,11,126,40,42,-3,9,2,-35,-35,-15,-32,26,65,-14,-4,3,-11,-4,8,-52,1,23,-10,-6,-71,21,-19,-8,12,3,7,-26, 
  /* [10][0][][] */ 25,50,-21,14,70,-108,0,-38,10,63,37,0,-11,22,17,-83,15,32,-36,35,-75,-10,-13,-38,-76,-13,-63,45,18,10,8,52,-19,-20,10,-15,70,-16,-12,-12,-34,72,25,-14,-56,-25,-44,5,-17,-14,-58,2,-10,-11,-4,-17,11,30,-32,-18,2,2,-25,25,3,49,48,16,16,6,25,56,-51,-31,-41,-24,1,21,-3,16,30,-4,-85,-43,74,-44,89,-15,-50,6,24,1,85,42,-18,-127, 
  /* [11][0][][] */ 42,42,-33,15,9,12,56,0,-4,-14,-16,-12,-6,14,36,6,8,-4,-101,-7,6,16,3,-3,-48,-19,-10,8,5,18,1,-3,-9,17,16,19,17,14,1,28,14,33,66,-97,29,-53,7,1,-127,12,15,-47,28,26,-12,8,-16,-10,19,1,12,-12,0,9,-42,53,-12,5,22,-3,39,11,-49,-29,15,26,0,-34,-50,8,31,0,91,43,12,-8,-2,-17,12,30,-9,-6,-2,4,-21,8, 
  /* [12][0][][] */ -35,3,15,11,-17,29,8,-4,127,11,-15,7,-11,10,-44,-42,31,31,14,73,65,34,-13,-28,13,8,22,-18,-116,11,21,-43,1,2,-7,-10,29,3,28,-12,-29,-12,8,5,5,28,4,-3,24,-3,-31,6,6,-2,7,1,59,-23,19,22,22,-19,13,-6,2,30,-43,9,5,8,-4,-30,10,16,-65,11,16,1,12,-53,-4,-1,54,32,-8,-3,-14,-9,-1,21,-3,53,-14,-22,8,18, 
  /* [13][0][][] */ 28,-5,-28,30,26,0,17,2,-11,5,11,-2,20,-10,6,-14,20,-78,-46,15,-15,-18,14,1,2,8,0,-9,-9,-39,-4,22,-1,10,9,41,18,-5,10,15,-5,9,30,44,19,16,-4,-127,19,-1,3,11,-12,4,14,6,-11,15,26,10,0,18,1,5,-11,-15,-18,-57,16,16,1,-35,-21,33,-7,15,-29,-1,15,1,38,-13,-12,20,11,23,12,15,1,5,27,-8,4,12,-11,-11, 
  /* [14][0][][] */ -119,-52,21,38,35,-15,-54,20,-10,16,1,18,80,-6,-123,7,94,-8,-20,38,-4,-13,37,22,-123,17,35,-22,-52,-78,-22,5,-5,21,12,-73,33,42,-14,32,39,34,-11,-35,29,127,69,46,-108,58,12,43,-48,-3,26,4,27,21,64,62,49,56,11,55,-3,-28,-54,44,-9,66,-73,-77,-60,13,-5,46,-5,53,97,-3,35,21,19,35,52,3,58,34,39,37,63,-8,-5,34,21,-25, 
  /* [15][0][][] */ 110,-8,34,-1,-30,93,12,-9,-6,54,22,7,-81,-20,-4,48,9,43,36,-2,16,21,-79,86,2,3,38,-10,38,51,-58,-82,9,-38,51,-4,30,-28,-44,-101,-15,37,20,58,3,56,-5,-50,127,-34,-76,32,56,-109,57,-121,20,-46,27,17,-121,3,26,23,87,-26,-66,47,-19,55,-23,32,71,41,20,-22,35,-57,75,-29,-33,9,43,93,-28,-18,-10,-76,26,0,70,-5,-71,81,24,-12, 
};
const TfArray<4, int> tensor_dimension30 = { 4, { 16,1,1,96 } };
const TfArray<16, float> quant30_scale = { 16, { 0.018179766833782196, 0.014024249278008938, 0.011999650858342648, 0.0096543347463011742, 0.015086456201970577, 0.01381637342274189, 0.01390449982136488, 0.0168889369815588, 0.0085394801571965218, 0.01245424896478653, 0.016878269612789154, 0.024532057344913483, 0.016450002789497375, 0.01563347689807415, 0.014970552176237106, 0.013889816589653492, } };
const TfArray<16, int> quant30_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant30 = { (TfLiteFloatArray*)&quant30_scale, (TfLiteIntArray*)&quant30_zero, 0 };
const ALIGN(16) int32_t tensor_data31[16] = { 1500, 1394, -16525, 31906, 25276, -671, -11588, -3942, 19046, 14411, 33183, 21719, -15832, 15347, 36345, -34820, };
const TfArray<1, int> tensor_dimension31 = { 1, { 16 } };
const TfArray<16, float> quant31_scale = { 16, { 0.00042775922338478267, 0.0003299823438283056, 0.00028234472847543657, 0.00022716082457918674, 0.00035497543285600841, 0.00032509115408174694, 0.00032716471469029784, 0.00039738675695843995, 0.00020092894556000829, 0.00029304117197170854, 0.00039713576552458107, 0.00057722488418221474, 0.00038705888437107205, 0.00036784651456400752, 0.00035224828752689064, 0.00032681922311894596, } };
const TfArray<16, int> quant31_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant31 = { (TfLiteFloatArray*)&quant31_scale, (TfLiteIntArray*)&quant31_zero, 0 };
const ALIGN(16) int8_t tensor_data32[96*1*1*16] = { 
  /* [0][0][][] */ -9,62,-23,63,53,24,8,-15,49,33,-51,95,-9,-106,60,-127, 
  /* [1][0][][] */ 29,56,-15,-14,23,-18,114,-127,9,93,-9,-8,-4,-59,33,11, 
  /* [2][0][][] */ -106,44,-32,-29,-16,-8,52,127,-33,52,108,-19,-57,29,21,-66, 
  /* [3][0][][] */ -68,104,41,74,-111,83,81,121,12,55,-127,-5,64,-91,-113,-86, 
  /* [4][0][][] */ -7,12,25,68,-29,63,-4,33,25,8,16,-3,8,7,-127,-30, 
  /* [5][0][][] */ -18,-20,63,-31,14,-34,-5,21,-71,93,-26,-127,-23,16,-52,-32, 
  /* [6][0][][] */ 17,13,38,-15,28,50,-69,-82,-6,0,54,3,127,-38,-3,-37, 
  /* [7][0][][] */ 30,-2,127,6,-4,-21,2,-5,-98,50,-99,-42,-5,-1,15,-11, 
  /* [8][0][][] */ 7,23,51,48,-49,99,20,24,41,17,1,-62,-40,2,-127,-49, 
  /* [9][0][][] */ 35,-127,59,58,7,-30,2,25,122,5,75,15,-39,23,-123,-39, 
  /* [10][0][][] */ -39,-74,17,-23,-72,20,-17,44,80,127,47,-32,-20,63,59,-29, 
  /* [11][0][][] */ 15,-32,-11,-119,42,-3,-123,-127,-69,48,-34,-56,2,-34,29,-100, 
  /* [12][0][][] */ -39,6,-8,-60,-42,-23,-105,-27,-72,-84,-11,4,5,127,92,54, 
  /* [13][0][][] */ -57,-78,-56,33,-13,-107,13,-2,78,17,-37,3,35,30,127,22, 
  /* [14][0][][] */ 12,-40,40,46,14,21,1,127,31,55,2,-43,8,47,-74,118, 
  /* [15][0][][] */ 16,-25,8,48,26,3,80,-6,0,-127,11,-37,5,-22,-7,-32, 
  /* [16][0][][] */ 34,-96,-24,16,32,9,34,-51,101,61,107,-6,15,92,56,127, 
  /* [17][0][][] */ -87,-59,22,115,118,55,12,-26,100,-58,-20,-57,36,46,-127,57, 
  /* [18][0][][] */ -13,9,23,27,-69,-14,-11,39,-64,-2,-28,-57,-12,-127,60,-4, 
  /* [19][0][][] */ 56,-67,64,-45,90,32,-80,95,126,-52,99,22,-5,76,25,127, 
  /* [20][0][][] */ 34,-29,66,-75,-5,6,-36,46,-27,-54,99,-20,18,8,-40,127, 
  /* [21][0][][] */ -45,-19,-8,-34,13,13,-81,-49,-21,46,-7,1,-127,-15,30,2, 
  /* [22][0][][] */ 22,-24,6,-17,32,-81,11,-16,-127,49,-9,-56,-25,-6,77,-26, 
  /* [23][0][][] */ 12,6,9,-11,-2,24,-14,-5,-7,0,61,-4,127,-11,14,-37, 
  /* [24][0][][] */ -15,6,0,-62,-21,-5,64,33,-50,24,-23,-127,5,-84,38,7, 
  /* [25][0][][] */ -104,11,-38,6,61,-27,-65,-127,-21,32,-31,-34,-64,-62,11,-51, 
  /* [26][0][][] */ 12,7,55,-127,93,-35,-1,2,92,-78,86,12,15,81,30,61, 
  /* [27][0][][] */ 87,-19,21,-34,-38,-58,1,-29,-13,35,-127,33,14,-14,5,36, 
  /* [28][0][][] */ -127,-16,-94,-68,69,-3,56,-64,7,37,-47,21,19,-16,-36,32, 
  /* [29][0][][] */ -50,-43,-10,127,-28,-1,5,-47,-18,-15,-74,34,19,-88,43,-8, 
  /* [30][0][][] */ 59,-31,127,-7,69,47,-54,74,-54,-121,102,-94,-1,10,-76,126, 
  /* [31][0][][] */ 23,-88,-7,-37,-8,-81,22,-47,-1,50,89,33,0,93,71,127, 
  /* [32][0][][] */ -7,64,-39,30,-127,14,-65,-43,-55,-31,-5,41,8,43,38,63, 
  /* [33][0][][] */ 33,-24,19,127,26,24,30,-33,-105,61,59,-24,-12,5,-22,101, 
  /* [34][0][][] */ 36,-3,-5,-5,67,-33,-127,-24,-48,91,-21,5,-54,10,-1,19, 
  /* [35][0][][] */ 98,9,-8,-4,10,-127,-22,-13,-43,-14,-103,11,65,-2,10,29, 
  /* [36][0][][] */ 23,1,-127,16,30,4,-28,14,-19,-16,11,-3,8,10,-10,0, 
  /* [37][0][][] */ 11,-4,127,3,-44,16,14,-55,-16,22,-42,6,9,-3,13,8, 
  /* [38][0][][] */ -122,74,16,39,-9,68,15,-17,29,-6,127,3,1,6,-38,-72, 
  /* [39][0][][] */ -15,-12,5,33,27,-11,-127,36,8,35,-6,-38,-3,-25,-2,-5, 
  /* [40][0][][] */ 1,43,-52,127,5,27,59,22,-52,-5,-37,73,9,27,-55,-10, 
  /* [41][0][][] */ 31,8,-29,-13,-41,19,127,110,-67,85,-44,-21,0,70,35,-20, 
  /* [42][0][][] */ -9,-66,-33,-40,42,38,-93,31,70,-89,127,22,-47,15,-62,33, 
  /* [43][0][][] */ -94,11,32,-45,55,38,-95,-75,-21,65,30,-53,-127,0,19,-15, 
  /* [44][0][][] */ 9,-6,-27,-13,-1,-25,0,-57,127,-11,27,46,20,80,11,57, 
  /* [45][0][][] */ -44,-90,21,-56,49,-6,-12,80,-7,-46,-10,-17,2,116,-53,127, 
  /* [46][0][][] */ -50,26,-34,97,-89,-36,8,-80,-127,46,-50,-14,8,41,8,-40, 
  /* [47][0][][] */ -36,-2,-102,127,10,60,-2,-20,24,44,60,76,-23,-11,31,-8, 
  /* [48][0][][] */ -1,14,34,-127,45,-72,-1,8,-37,20,14,-6,-2,95,102,46, 
  /* [49][0][][] */ -29,33,38,119,-7,6,-92,-22,64,-67,-127,-48,-51,-57,-113,-111, 
  /* [50][0][][] */ 21,74,21,-119,78,18,-13,56,127,-16,-38,14,19,-48,8,-32, 
  /* [51][0][][] */ 36,-26,24,-7,59,1,-57,-127,-10,-110,-19,8,-10,-22,-18,8, 
  /* [52][0][][] */ 40,26,-23,19,37,-2,-89,127,-88,127,-59,-45,94,114,10,-34, 
  /* [53][0][][] */ -18,127,-2,-80,-58,-19,31,-30,-46,-46,-58,78,6,-113,-83,-25, 
  /* [54][0][][] */ 0,-4,19,41,48,-22,4,-31,-20,28,-6,-20,-16,127,-37,-14, 
  /* [55][0][][] */ -123,118,109,-36,72,-1,-27,-7,-73,7,87,-45,-6,-42,127,-16, 
  /* [56][0][][] */ 40,-1,0,-78,74,-12,10,22,61,-14,62,127,-23,19,98,30, 
  /* [57][0][][] */ -16,-2,33,86,-23,-2,26,127,4,17,22,-27,-2,47,4,27, 
  /* [58][0][][] */ 27,120,-6,-127,2,18,-10,16,96,-15,-9,67,18,-82,52,70, 
  /* [59][0][][] */ 35,85,28,-127,-67,-4,31,-13,11,19,36,-54,-3,-112,-83,18, 
  /* [60][0][][] */ 58,-31,127,-52,-43,100,20,-50,-19,33,-45,-30,35,-5,50,3, 
  /* [61][0][][] */ 7,20,-35,-33,-55,0,106,127,-44,58,0,-12,17,61,5,-45, 
  /* [62][0][][] */ -6,-27,7,3,-72,27,-65,19,-32,-49,10,-49,29,-127,67,11, 
  /* [63][0][][] */ 23,-15,-30,-98,43,-15,-119,-127,-81,94,-9,-14,52,7,38,-59, 
  /* [64][0][][] */ -25,-21,64,50,68,-38,-30,-112,38,-127,-20,-56,2,-18,-8,18, 
  /* [65][0][][] */ -127,7,36,-74,23,77,37,-54,-97,12,53,-20,2,12,-13,-20, 
  /* [66][0][][] */ 93,34,70,28,-95,17,-20,64,-34,2,50,-92,-13,58,-127,-13, 
  /* [67][0][][] */ 24,-14,-35,45,58,-31,-80,-123,37,-127,-53,-35,-109,1,-82,23, 
  /* [68][0][][] */ -1,-8,-52,40,-76,-87,7,-53,-2,-7,59,-27,-4,57,127,-23, 
  /* [69][0][][] */ -36,40,-71,80,-32,-127,22,97,43,17,62,14,100,53,-18,17, 
  /* [70][0][][] */ -7,-6,-39,-53,-31,22,127,105,-27,48,-32,2,21,42,16,-4, 
  /* [71][0][][] */ 2,-21,-6,-70,49,-9,14,83,-42,-63,-29,-30,39,-127,73,14, 
  /* [72][0][][] */ 29,34,-27,28,16,-66,-34,-127,5,60,-65,27,44,42,64,52, 
  /* [73][0][][] */ -38,-127,-18,-48,-92,-1,30,-20,-21,-6,-41,-30,5,-39,52,16, 
  /* [74][0][][] */ -33,28,71,99,-30,-8,-127,99,32,-34,-35,-40,9,-10,-12,-4, 
  /* [75][0][][] */ -77,48,-34,7,-40,109,86,127,8,67,18,-20,-119,87,29,31, 
  /* [76][0][][] */ 42,-48,-20,2,46,-88,-127,-85,-18,-35,-10,-8,63,-26,66,-5, 
  /* [77][0][][] */ -43,5,-43,-30,-64,1,-13,-55,127,-1,-67,6,-6,39,33,-89, 
  /* [78][0][][] */ -98,-127,17,50,112,80,-32,25,-35,-82,-109,62,42,-47,73,56, 
  /* [79][0][][] */ 47,-20,32,-65,127,-2,25,9,65,2,18,50,-9,-19,34,-29, 
  /* [80][0][][] */ 10,-26,60,-116,-38,-44,11,28,-92,-40,-30,-56,5,127,-31,13, 
  /* [81][0][][] */ 76,-53,21,76,-25,25,-49,-37,-21,-26,-28,-44,-5,19,-127,59, 
  /* [82][0][][] */ -54,-26,39,-127,16,-43,-6,-48,-13,-4,-37,-67,6,-90,-72,23, 
  /* [83][0][][] */ 10,6,-16,-62,-33,-3,-7,70,-77,-18,19,-127,19,-125,-12,75, 
  /* [84][0][][] */ 127,26,25,32,-39,22,-54,32,-32,-44,71,-20,-59,-5,53,-63, 
  /* [85][0][][] */ -22,-24,24,-14,37,3,-37,98,-74,-96,-42,-36,-36,66,77,-127, 
  /* [86][0][][] */ 30,-4,26,11,-52,47,-66,62,-127,-50,36,-48,-23,-123,11,16, 
  /* [87][0][][] */ 127,-37,24,3,-33,-14,-21,-18,11,11,-110,10,23,-12,-5,28, 
  /* [88][0][][] */ 27,51,-21,-28,-19,-31,-38,8,57,-7,58,8,-31,-78,127,-109, 
  /* [89][0][][] */ 52,75,-96,-10,-44,-25,12,-71,62,54,35,-3,-38,-11,-27,-127, 
  /* [90][0][][] */ -22,0,5,-73,-75,28,127,-63,110,-83,-2,-58,44,2,-42,-29, 
  /* [91][0][][] */ 3,32,8,-89,-73,-13,15,-42,-37,2,91,78,38,-11,49,127, 
  /* [92][0][][] */ 34,6,-1,25,58,-17,-63,-127,55,-61,11,-40,-21,0,-7,-1, 
  /* [93][0][][] */ 48,-6,24,-127,-25,5,-27,45,25,-59,99,-29,-49,101,-3,18, 
  /* [94][0][][] */ -127,61,-99,3,79,-113,-19,-1,4,-64,92,-32,3,11,-32,-26, 
  /* [95][0][][] */ -17,79,38,-127,-3,17,-45,5,35,-50,-87,-59,6,42,-82,-11, 
};
const TfArray<4, int> tensor_dimension32 = { 4, { 96,1,1,16 } };
const TfArray<96, float> quant32_scale = { 96, { 0.00090104877017438412, 0.00060673110419884324, 0.0003863673482555896, 0.00020964360737707466, 0.00055965466890484095, 0.00071229215245693922, 0.0014339206973090768, 0.00077727873576804996, 0.00022905466903466731, 0.00091806403361260891, 0.00095842342125251889, 0.00062196108046919107, 0.00041237601544708014, 0.0005001458921469748, 0.00020405219402164221, 0.0013866606168448925, 0.00058670545695349574, 0.0004525872936937958, 0.00070680596400052309, 0.00074062409112229943, 0.0010667361784726381, 0.0018393039936199784, 0.0006625419482588768, 0.0018746445421129465, 0.002388485474511981, 0.00092418631538748741, 0.00066306226653978229, 0.00060369202401489019, 0.00097922713030129671, 0.00028562682564370334, 0.00016772894014138728, 0.00037339172558858991, 0.00052984588546678424, 0.00097881455440074205, 0.00074971461435779929, 0.00058830995112657547, 0.0012955814599990845, 0.0019760355353355408, 0.00035545547143556178, 0.0020229362417012453, 0.00055494613479822874, 0.00057115114759653807, 0.00027821608819067478, 0.00084756803698837757, 0.00031856508576311171, 0.00061376253142952919, 0.00088878948008641601, 0.00052589620463550091, 0.00026316026924178004, 0.0005018431693315506, 0.00064368278253823519, 0.000590997573453933, 0.00082099909195676446, 0.00082539289724081755, 0.0012216679751873016, 0.0005000309320166707, 0.00075788050889968872, 0.0003633715386968106, 0.00098690122831612825, 0.00054229429224506021, 0.001203809049911797, 0.00029829121194779873, 0.00060033856425434351, 0.00057116226525977254, 0.00076199625618755817, 0.00051675591384992003, 0.00066460378002375364, 0.00075656926492229104, 0.00056811812100932002, 0.00060365587705746293, 0.00074054859578609467, 0.00046929749078117311, 0.000266398856183514, 0.00059081224026158452, 0.0010086301481351256, 0.00072719278978183866, 0.00067545438650995493, 0.00099052395671606064, 0.00099890062119811773, 0.0013523307861760259, 0.00040276505751535296, 0.000410178501624614, 0.00071024621138349175, 0.000437893409980461, 0.0013069326523691416, 0.00083668588194996119, 0.00062406464712694287, 0.00018641198403201997, 0.00044550208258442581, 0.00069404742680490017, 0.00064084603218361735, 0.0008697540033608675, 0.00079922174336388707, 0.00071279122494161129, 0.00076709501445293427, 0.00031286527519114316, } };
const TfArray<96, int> quant32_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant32 = { (TfLiteFloatArray*)&quant32_scale, (TfLiteIntArray*)&quant32_zero, 0 };
const ALIGN(16) int32_t tensor_data33[96] = { 1415, 8100, 16136, 36473, 17697, -4668, -1812, 7077, 34360, -4979, 9269, 4714, 10386, 15197, 38831, 1402, 2391, 9076, 10380, 5269, -205, 360, 9866, -1117, 3624, -4, 11279, 8067, 5519, 40936, 55363, 22068, 10354, -774, 8586, 3382, 1307, 2492, 24727, -937, 11260, 9141, 32302, -4237, 34201, 8436, 6424, 16977, 51764, 14097, -559, 9549, -4329, -129, -2695, 7252, -439, 17148, 6871, 9002, 4379, 15782, 8159, 5800, 10738, 12548, 6437, -5976, 10060, -3910, 4936, 11050, 26022, 5766, -5149, -6177, 8257, 370, 2328, -885, 16921, 13060, 4103, 14707, 2902, 287, 12516, 68027, 10573, 10668, 6611, -364, 6151, 7321, 4897, 18297, };
const TfArray<1, int> tensor_dimension33 = { 1, { 96 } };
const TfArray<96, float> quant33_scale = { 96, { 0.00027144741034135222, 0.00018278209608979523, 0.00011639593139989302, 6.3156636315397918e-05, 0.00016859997413121164, 0.0002145831094821915, 0.00043197887134738266, 0.00023416079056914896, 6.9004359829705209e-05, 0.00027657338068820536, 0.00028873191331513226, 0.00018737022764980793, 0.00012423122825566679, 0.0001506725384388119, 6.1472186644095927e-05, 0.00041774145211093128, 0.00017674922128207982, 0.00013634515926241875, 0.00021293036115821451, 0.00022311831708066165, 0.00032136190566234291, 0.00055410352069884539, 0.00019959550991188735, 0.00056475010933354497, 0.00071954837767407298, 0.00027841774863190949, 0.00019975226314272732, 0.0001818665477912873, 0.00029499919037334621, 8.6047126387711614e-05, 5.0529542932054028e-05, 0.00011248693044763058, 0.00015961987082846463, 0.0002948748879134655, 0.00022585690021514893, 0.00017723259225022048, 0.00039030320476740599, 0.00059529487043619156, 0.00010708350600907579, 0.0006094240234233439, 0.00016718149709049612, 0.00017206337361130863, 8.38145861052908e-05, 0.00025533593725413084, 9.5970011898316443e-05, 0.00018490036018192768, 0.00026775419246405363, 0.00015843000437598675, 7.9278914199676365e-05, 0.00015118384908419102, 0.00019391404930502176, 0.00017804224626161158, 0.00024733186000958085, 0.00024865553132258356, 0.00036803624243475497, 0.00015063790488056839, 0.0002283169305883348, 0.00010946828115265816, 0.00029731105314567685, 0.00016337004490196705, 0.00036265610833652318, 8.9862362074200064e-05, 0.00018085629562847316, 0.00017206672055181116, 0.0002295568265253678, 0.00015567641821689904, 0.00020021664386149496, 0.00022792190429754555, 0.00017114965885411948, 0.00018185566295869648, 0.00022309557243715972, 0.00014137923426460475, 8.0254561908077449e-05, 0.00017798642511479557, 0.00030385705758817494, 0.00021907204063609242, 0.00020348546968307346, 0.00029840244678780437, 0.00030092598171904683, 0.00040739934775047004, 0.00012133585551055148, 0.0001235692179761827, 0.00021396676311269403, 0.00013191852485761046, 0.00039372281753458083, 0.00025205762358382344, 0.00018800394900608808, 5.6157947255996987e-05, 0.00013421069888863713, 0.00020908676378894597, 0.00019305945897940546, 0.00026201963191851974, 0.00024077127454802394, 0.00021473345987033099, 0.00023109286848921329, 9.4252907729241997e-05, } };
const TfArray<96, int> quant33_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant33 = { (TfLiteFloatArray*)&quant33_scale, (TfLiteIntArray*)&quant33_zero, 0 };
const ALIGN(16) int8_t tensor_data34[1*3*3*96] = { 
  /* [0][0][][] */ -46,-72,-12,127,22,71,78,-58,-14,-18,-15,-4,-29,1,37,1,-7,-43,27,22,17,-127,127,6,-82,7,49,-28,-124,-127,38,24,12,26,62,-17,-33,-11,32,-10,-14,27,-107,70,25,-73,38,46,-18,51,-23,19,5,-6,16,48,-96,-49,-62,-18,-12,-1,12,37,69,-24,73,15,-8,14,20,127,23,23,25,-1,-10,20,127,-3,-14,12,-28,21,127,20,-81,-16,0,-32,-15,-42,1,-26,-15,26, 127,-127,72,105,-43,127,41,-118,71,4,-17,127,127,-97,-13,16,12,127,127,-111,127,-78,83,70,-127,-113,-67,-34,-53,47,-58,-19,-88,54,-127,-83,-45,-15,-49,58,-1,127,127,84,-51,-121,-111,-50,-15,-127,42,84,68,-32,44,82,-51,42,-77,-114,-45,-41,-61,68,73,-60,26,33,-81,34,-18,92,118,127,15,19,3,60,-33,53,65,127,127,-23,-9,71,-116,127,-120,-99,4,-127,-91,-127,-37,105, -75,-12,27,-82,14,-27,66,-9,82,-35,-27,18,-20,-5,-9,-11,-7,-15,8,-4,-23,-106,32,-2,-121,97,6,-54,117,49,-13,11,0,14,15,-29,-9,33,19,9,25,13,-122,64,17,-22,37,13,-15,11,-16,5,-9,2,-4,20,-70,6,-32,54,2,42,35,-1,-8,-38,-34,25,8,2,-4,38,9,-26,-4,4,-11,-3,-86,4,-20,-26,-19,4,-111,6,-36,-23,-51,24,-26,-36,29,-27,-13,1, 
  /* [0][1][][] */ -66,-75,71,-35,-48,94,21,127,-51,-21,0,-116,26,-113,77,33,-2,-60,-17,89,57,-70,46,51,-93,-12,127,-22,-25,64,120,-104,-127,93,-86,-54,-38,30,-26,93,-50,-27,-3,46,-48,127,-22,65,16,94,20,-2,14,-55,27,30,127,123,-72,-85,127,-34,-34,127,72,-37,-16,-2,127,37,127,97,-41,103,-7,12,14,15,-31,11,-43,124,-79,112,4,35,-59,31,79,-127,-31,-10,127,-70,-22,0, 67,127,54,-113,127,85,91,37,-127,127,127,-38,-66,-127,-127,127,127,-62,-122,-51,111,98,-123,127,-105,-88,-44,127,-127,110,-127,-127,-88,127,109,127,127,-127,-103,127,-66,-98,109,-127,-127,-37,-127,-127,127,-112,84,43,127,127,127,-127,101,-127,-127,127,19,-82,-127,-99,-127,127,-127,127,-124,-127,-107,-81,-127,-79,127,127,-127,127,-79,127,127,32,-42,-127,61,127,94,46,127,11,127,6,-69,35,127,-127, -54,-12,-51,37,-56,-100,37,-28,20,-34,-29,92,1,93,13,12,-3,64,-6,127,4,-87,-41,5,-72,104,-73,-19,-73,-18,18,-61,-71,39,5,-17,-30,45,-65,43,127,-4,-42,31,-41,-63,17,44,8,118,-11,5,-38,-72,3,18,96,3,1,23,-37,127,94,-52,-44,13,35,-11,-76,121,-18,-83,-2,-53,-19,-20,27,17,77,-36,-69,-44,54,15,-49,-17,73,22,15,59,-43,15,-43,95,-26,-5, 
  /* [0][2][][] */ -67,0,-6,-19,13,-47,72,24,54,-29,-35,-2,18,19,-27,3,-6,64,8,2,-53,-81,2,-7,-20,-52,35,-67,85,38,25,26,15,-4,-11,-45,-8,35,-1,4,-16,-8,-67,103,3,27,12,37,-15,-33,11,-20,21,-1,11,13,-74,25,-17,15,14,-1,-19,-5,1,-45,-48,15,-31,13,25,32,14,-19,26,5,17,5,-77,-12,-7,-11,16,16,-125,7,10,-44,-57,-52,-27,-55,10,55,-18,-7, 122,33,-127,-35,-72,-26,47,29,-67,-30,-19,-108,-78,111,-13,40,4,-50,-8,-125,96,-50,-38,0,-108,127,-52,21,-39,-21,-10,-5,-64,20,29,6,-23,-29,127,55,11,-15,67,-37,-39,76,-66,-43,-32,-7,-127,-127,-50,-26,4,37,-69,-6,8,40,-8,-20,10,-48,-53,34,63,-22,115,109,-24,-66,13,-57,1,4,99,3,53,20,14,-99,-49,3,6,8,127,40,-60,35,-19,-112,40,79,-9,27, -53,12,-19,27,16,-70,-127,1,-11,-9,-16,3,14,-25,18,1,-7,-16,6,19,-51,-71,14,2,20,-92,18,4,-54,-40,-6,16,41,-16,-6,-25,-36,2,42,-35,23,-3,-52,-32,2,64,24,16,-9,-4,10,-9,18,6,-4,-7,-64,-12,3,-36,-13,8,87,-11,35,-1,-1,28,1,6,-4,22,-17,16,-2,15,36,1,76,-10,4,-11,-7,-17,76,0,42,-39,59,36,-17,-59,-6,1,-14,-14, 
};
const TfArray<4, int> tensor_dimension34 = { 4, { 1,3,3,96 } };
const TfArray<96, float> quant34_scale = { 96, { 0.0047621778212487698, 0.0038443163502961397, 0.0050930152647197247, 0.0090818470343947411, 0.011493233032524586, 0.012125351466238499, 0.0015925569459795952, 0.0033388456795364618, 0.0099840406328439713, 0.0091088023036718369, 0.010351915843784809, 0.0049086329527199268, 0.013627453707158566, 0.0086699286475777626, 0.015526932664215565, 0.0063244928605854511, 0.0084894606843590736, 0.0077964263036847115, 0.0086891632527112961, 0.0032111962791532278, 0.002808824647217989, 0.0015788400778546929, 0.0059947618283331394, 0.0023452427703887224, 0.0042811394669115543, 0.0043211397714912891, 0.0065996092744171619, 0.0073732472956180573, 0.003693475853651762, 0.021680163219571114, 0.016452182084321976, 0.010321992449462414, 0.004405695479363203, 0.0056016556918621063, 0.011186198331415653, 0.018940625712275505, 0.015594351105391979, 0.0079272175207734108, 0.0097878128290176392, 0.0045744162052869797, 0.0095348479226231575, 0.0095748668536543846, 0.01407515536993742, 0.003899772884324193, 0.016096225008368492, 0.0039872629567980766, 0.0047690039500594139, 0.012490992434322834, 0.030357930809259415, 0.0049965665675699711, 0.020193947479128838, 0.0064997365698218346, 0.013218201696872711, 0.0059523768723011017, 0.01216539740562439, 0.0055153672583401203, 0.0060358480550348759, 0.016427015885710716, 0.0018373553175479174, 0.007635090034455061, 0.012745353393256664, 0.011792303994297981, 0.0046565253287553787, 0.0067236744798719883, 0.005608860868960619, 0.0063584586605429649, 0.014103295281529427, 0.0089555773884057999, 0.0087601495906710625, 0.005112246610224247, 0.011019314639270306, 0.0045498134568333626, 0.013423209078609943, 0.0071163554675877094, 0.017434300854802132, 0.02377026155591011, 0.0062438743188977242, 0.0030716252513229847, 0.0027543837204575539, 0.007449182216078043, 0.011492710560560226, 0.0095747960731387138, 0.0078885247930884361, 0.012072132900357246, 0.0025790100917220116, 0.0054536676034331322, 0.0031336997635662556, 0.020919371396303177, 0.013244404457509518, 0.0057482356205582619, 0.015880580991506577, 0.0012115889694541693, 0.0065740472637116909, 0.0046558375470340252, 0.015946602448821068, 0.011751469224691391, } };
const TfArray<96, int> quant34_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant34 = { (TfLiteFloatArray*)&quant34_scale, (TfLiteIntArray*)&quant34_zero, 3 };
const ALIGN(16) int32_t tensor_data35[96] = { 20756, 62051, 191, -496, 13029, -3054, 614, 559, 5410, 11372, -5330, -51, 849, 4047, 5454, -9773, -4418, -702, -820, 15281, -11831, 12855, -2361, 14721, 28228, -332, -5206, 17307, 15968, -19229, 1618, 21763, 23615, -11465, 1631, -16, -272, -500, 2377, -7338, -4931, -394, -7978, -128, 30830, 472, 11801, -933, -14708, 2527, -98, 533, -1715, 20064, -3244, 13482, 20570, -363, 35029, -656, -8202, -504, 433, -54, -2199, 11481, -273, -10245, -3220, 3243, 1007, -4495, 1531, 295, -1834, -3207, -780, -1305, 39630, -7411, -6337, -10985, -265, 213, 58208, -12728, -9490, -27167, -6034, 10528, -2376, 37544, -69, -1588, -2696, 633, };
const TfArray<1, int> tensor_dimension35 = { 1, { 96 } };
const TfArray<96, float> quant35_scale = { 96, { 0.00011205124610569328, 9.0454501332715154e-05, 0.00011983565491391346, 0.00021369052410591394, 0.0002704290091060102, 0.00028530240524560213, 3.7471927498700097e-05, 7.8561075497418642e-05, 0.00023491861065849662, 0.00021432476933114231, 0.00024357449728995562, 0.00011549724877113476, 0.00032064598053693771, 0.00020399832283146679, 0.00036533959791995585, 0.00014881159586366266, 0.00019975201576016843, 0.00018344532873015851, 0.00020445090194698423, 7.5557560194283724e-05, 6.6089989559259266e-05, 3.7149180570850149e-05, 0.00014105322770774364, 5.5182183132274076e-05, 0.0001007326936814934, 0.00010167388245463371, 0.00015528492804151028, 0.00017348818073514849, 8.6905318312346935e-05, 0.00051012152107432485, 0.00038711016532033682, 0.00024287041742354631, 0.00010366342758061364, 0.00013180366659071296, 0.00026320468168705702, 0.00044566180440597236, 0.00036692590219900012, 0.00018652276776265353, 0.00023030147713143378, 0.00010763332102214918, 0.00022434936545323581, 0.00022529099078383297, 0.00033118014107458293, 9.1759364295285195e-05, 0.00037873472319915891, 9.3817950983066112e-05, 0.00011221186287002638, 0.00029390570125542581, 0.00071430427487939596, 0.00011756627645809203, 0.00047515172627754509, 0.00015293498290702701, 0.00031101651256904006, 0.00014005592674948275, 0.00028624464175663888, 0.00012977335427422076, 0.00014201995509210974, 0.00038651801878586411, 4.3231892050243914e-05, 0.00017964918515644968, 0.00029989067115820944, 0.00027746599516831338, 0.0001095653060474433, 0.00015820411499589682, 0.00013197319640312344, 0.0001496108015999198, 0.00033184225321747363, 0.00021071947412565351, 0.00020612117077689618, 0.00012028816126985475, 0.00025927799288183451, 0.00010705443855840713, 0.00031584021053276956, 0.00016744366439525038, 0.00041021883953362703, 0.00055930030066519976, 0.00014691469550598413, 7.2273534897249192e-05, 6.4809028117451817e-05, 0.0001752748794388026, 0.00027041672728955746, 0.00022528931731358171, 0.00018561235629022121, 0.00028405018383637071, 6.0682592447847128e-05, 0.00012832159700337797, 7.3734110628720373e-05, 0.00049222051165997982, 0.00031163304811343551, 0.00013525260146707296, 0.0003736607322935015, 2.8507976821856573e-05, 0.00015468346828129143, 0.00010954912431770936, 0.00037521417834796011, 0.00027650516130961478, } };
const TfArray<96, int> quant35_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant35 = { (TfLiteFloatArray*)&quant35_scale, (TfLiteIntArray*)&quant35_zero, 0 };
const ALIGN(16) int8_t tensor_data36[16*1*1*96] = { 
  /* [0][0][][] */ -12,-13,13,-41,9,-3,-45,-3,20,8,-12,7,-11,-12,-27,8,-9,5,-2,-1,1,-34,9,1,9,-2,-3,127,32,-40,45,-16,-1,17,-7,12,-16,8,-57,-3,-19,10,-5,44,8,12,11,7,30,-1,-8,8,21,-11,-11,67,13,6,-25,-33,-10,17,-4,-22,-38,-69,-23,32,2,-2,15,-13,-16,-29,-2,-20,-28,15,10,4,-14,-36,29,20,-14,-9,-14,-102,2,-17,9,3,42,-40,-31,-10, 
  /* [1][0][][] */ 23,-64,-88,-52,127,-19,74,39,-19,-85,-39,-17,0,1,-62,33,-49,7,47,33,31,49,-27,-48,10,7,0,-64,41,-14,-70,42,-22,14,18,-12,9,7,26,25,-21,25,-27,-27,-45,93,17,2,15,-78,11,-45,-29,25,49,25,-61,-21,-41,-43,24,-2,-2,-47,-87,103,-25,-15,4,-12,-8,15,51,-109,-27,-8,34,-46,28,11,10,-12,20,2,-31,32,-15,35,31,-30,-12,9,28,17,29,90, 
  /* [2][0][][] */ -8,60,-105,-15,115,81,39,93,-14,-127,0,-6,9,8,27,17,20,-17,-60,77,29,-1,72,30,45,56,7,-28,39,5,47,-53,34,21,-2,43,-117,-87,51,38,14,-58,27,-26,19,-30,-5,95,-25,29,-25,7,87,0,-9,89,15,9,30,1,32,37,45,-31,11,-3,-35,7,-37,26,-20,-47,-34,-93,15,71,73,64,18,-9,46,-33,8,-20,-26,25,17,62,-18,24,14,-31,-1,-29,-75,-9, 
  /* [3][0][][] */ 61,-14,96,4,48,-30,12,-9,-42,-75,8,-39,8,27,42,87,37,-15,31,-5,124,-15,55,26,44,-19,-22,11,29,35,-4,90,-112,29,26,-14,-27,-33,-12,45,-76,-17,86,2,18,42,-40,-66,-67,-10,-37,59,-5,-127,-5,13,-115,76,71,50,17,83,-7,-55,23,82,2,-61,26,-30,-5,-75,67,-32,55,-19,4,20,56,55,-8,-80,34,-12,-21,1,40,49,13,-31,34,31,41,111,34,-38, 
  /* [4][0][][] */ 23,3,32,-22,127,41,-14,-37,-46,-52,-28,-36,-66,16,-13,64,24,-80,-36,74,-19,24,49,-20,0,-27,-2,-65,17,-28,79,-45,91,16,-44,11,35,19,-20,1,-42,0,-24,-38,-22,-65,-3,-11,29,18,-29,-6,4,-47,11,-44,45,-14,-32,28,-12,52,49,21,54,51,-18,-27,-49,-13,37,73,-4,-78,-50,-18,32,42,102,-20,-12,-57,14,-10,-86,11,33,33,-52,47,-7,-37,8,-1,23,-9, 
  /* [5][0][][] */ 11,-7,-13,19,25,-18,49,-18,-8,-40,-18,1,-5,19,4,15,0,1,6,-5,36,-6,-56,65,9,1,24,-88,-16,34,-2,21,-10,1,15,-63,30,16,5,6,-1,0,21,-5,-1,2,6,-22,-13,-33,6,-17,-8,-21,-8,-41,-4,22,-37,17,77,23,10,34,-12,42,9,85,8,94,25,24,4,12,-11,69,-24,-15,13,12,-16,-15,-12,26,-23,20,-6,127,-2,35,-7,-28,8,17,-51,18, 
  /* [6][0][][] */ 18,-66,7,-25,-26,5,42,21,18,-3,-9,-76,-35,3,-26,34,27,0,-5,-12,-30,29,-6,11,-34,4,-1,-5,-15,19,24,-6,50,-2,75,-12,2,-8,38,-88,-5,87,9,-25,16,-19,-12,8,-22,19,-23,47,-30,-60,-5,0,0,-49,-17,-1,-8,71,37,-76,25,-35,6,-1,5,14,127,2,-43,7,-32,17,-73,-12,-1,7,26,50,7,7,-8,8,41,30,13,23,37,-43,-4,0,-25,-18, 
  /* [7][0][][] */ 9,127,54,16,103,48,53,-45,-13,-24,38,-17,-36,22,28,35,5,-30,8,29,19,-30,38,13,-8,-1,4,3,14,-24,6,13,45,6,-46,15,20,14,-22,78,-51,34,11,30,-6,-23,20,-36,-24,-37,22,4,13,-39,-35,33,66,11,-24,9,-16,-34,-11,-5,-45,72,-31,-88,-16,-51,1,68,-25,-22,13,7,57,53,48,-19,-56,-46,-14,-8,-27,55,-1,-14,-27,37,-42,-31,-50,-11,39,-2, 
  /* [8][0][][] */ -14,-5,40,39,-109,-33,51,-7,34,81,67,10,-3,22,27,-1,-33,11,9,-3,-29,-13,-127,71,7,-14,71,-3,7,28,-21,60,70,-34,20,-20,-10,-20,41,35,31,-34,54,3,-45,-3,50,13,-111,9,30,36,-69,-43,-31,61,-2,-47,-91,-30,29,-15,-24,-9,-4,72,1,-43,31,5,-36,-29,46,53,54,-19,-23,-35,-35,27,-84,33,-24,7,42,17,66,61,31,-41,40,39,6,0,38,15, 
  /* [9][0][][] */ 3,-111,-29,22,96,80,-49,-10,16,-56,95,89,-9,15,88,-119,26,-27,-13,1,-65,-54,29,-13,-14,12,-21,37,-16,4,4,0,20,29,-118,48,-16,0,-15,72,42,-84,-13,59,-6,-18,-68,-9,40,49,3,-54,55,39,-16,-64,-23,84,-3,9,18,-77,-22,127,-97,-1,9,-34,2,18,-72,-93,69,-10,8,24,48,-49,15,14,5,-13,5,34,7,-82,16,-4,1,-69,-39,44,-77,-8,-25,-61, 
  /* [10][0][][] */ -40,-28,-23,-43,-26,-2,53,-21,27,19,21,39,28,-12,-3,-10,-12,16,-25,-14,-11,23,24,15,-14,-8,8,-127,20,-47,58,-33,3,26,-10,-1,-5,26,-6,-8,6,-30,22,-49,13,-6,22,24,0,44,-21,-7,-29,-18,-9,-58,16,10,5,-31,20,-4,-5,14,-33,87,-14,-34,7,-33,-8,-17,-17,-5,19,57,-8,38,-12,13,-18,-2,13,22,4,-21,-5,109,-9,-18,22,12,20,-38,37,-36, 
  /* [11][0][][] */ -80,14,-11,9,17,-56,-12,5,-47,-9,-7,22,35,18,-23,-14,59,0,-69,-38,18,-21,-20,0,53,14,74,9,-29,40,-57,23,-12,29,5,-22,1,-1,47,8,-5,-4,0,-6,73,14,65,32,39,29,-8,37,8,-52,18,2,-80,-9,-29,-44,0,-4,2,17,-15,-30,32,19,18,21,-2,23,-20,13,27,2,-20,77,-127,53,-45,0,-69,-67,117,14,46,3,13,27,-29,-61,-17,44,-23,-1, 
  /* [12][0][][] */ -4,-17,-45,6,88,15,10,-23,-19,27,31,-13,5,-14,41,-4,-37,-13,24,-12,7,-9,-28,59,-39,54,-14,91,-16,35,-23,3,-15,10,25,16,-13,-4,26,7,-2,-15,9,5,-16,8,27,9,-22,-6,2,-40,-24,2,-15,2,-11,-7,4,30,-21,-8,-8,46,52,-78,13,57,-30,-127,2,68,7,9,1,82,7,-10,-12,6,4,42,-38,10,26,-9,1,-39,-8,31,1,-9,-40,51,-9,12, 
  /* [13][0][][] */ -77,61,-9,0,-55,10,-11,24,-42,-37,38,17,81,11,-28,-5,-19,28,-50,-6,8,-19,34,-59,60,36,5,9,10,-10,-51,-85,-85,-15,14,-4,4,13,51,-12,-26,74,-4,13,41,16,-19,13,64,-22,32,80,57,-52,61,-18,-30,44,43,-1,21,26,-20,22,-6,-25,11,14,9,20,23,-127,11,-20,-76,-5,40,35,-55,-44,66,-14,-5,-32,34,-26,89,17,-8,-6,-14,27,28,-31,-23,9, 
  /* [14][0][][] */ -26,14,-2,-54,27,2,-15,19,-83,-1,18,10,-36,-62,-74,-17,-97,-14,81,18,32,6,34,-95,-35,11,-55,-31,16,-35,14,-39,-65,-31,11,28,-17,9,-6,3,-2,89,-89,-9,-50,16,2,8,127,-22,26,-26,42,49,-99,16,-12,29,-106,24,-2,34,45,25,14,33,-11,-11,-54,20,60,45,31,-9,-27,16,67,-77,-16,-104,18,-39,20,43,26,-69,-43,-7,-45,27,37,50,21,33,24,-14, 
  /* [15][0][][] */ -34,-77,3,-38,-8,16,-1,-70,-14,22,-6,-25,41,-21,56,-6,-103,0,-23,15,-32,-3,-66,-54,-3,-12,-22,12,-23,-13,67,-103,-9,48,1,18,-12,21,-115,8,19,-68,-8,40,-20,-50,48,22,63,17,-15,-127,-2,57,-6,24,47,-9,-13,48,8,-13,42,2,11,-8,-11,-3,-31,8,5,42,-48,12,2,-28,-27,-12,14,4,-12,29,-8,65,-28,-44,-32,-44,-40,57,38,90,-39,-12,8,0, 
};
const TfArray<4, int> tensor_dimension36 = { 4, { 16,1,1,96 } };
const TfArray<16, float> quant36_scale = { 16, { 0.033675473183393478, 0.019954033195972443, 0.0092686032876372337, 0.0099674118682742119, 0.018687019124627113, 0.014544055797159672, 0.017918555065989494, 0.013291552662849426, 0.014114993624389172, 0.011520830914378166, 0.031113777309656143, 0.027930684387683868, 0.01528941560536623, 0.011587724089622498, 0.02548987977206707, 0.021592827513813972, } };
const TfArray<16, int> quant36_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant36 = { (TfLiteFloatArray*)&quant36_scale, (TfLiteIntArray*)&quant36_zero, 0 };
const ALIGN(16) int32_t tensor_data37[16] = { -6626, 14068, -26831, 4597, -5738, 9096, 23834, -52126, -4713, 20402, 25257, 17041, -16442, 16356, -6028, 12809, };
const TfArray<1, int> tensor_dimension37 = { 1, { 16 } };
const TfArray<16, float> quant37_scale = { 16, { 0.00079236406600102782, 0.00046950666001066566, 0.0002180847804993391, 0.00023452733876183629, 0.00043969458783976734, 0.00034221308305859566, 0.00042161307646892965, 0.00031274242792278528, 0.00033211751724593341, 0.00027107837377116084, 0.00073208886897191405, 0.00065719260601326823, 0.00035975096398033202, 0.00027265233802609146, 0.00059976190095767379, 0.00050806655781343579, } };
const TfArray<16, int> quant37_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant37 = { (TfLiteFloatArray*)&quant37_scale, (TfLiteIntArray*)&quant37_zero, 0 };
const ALIGN(16) int8_t tensor_data38[96*1*1*16] = { 
  /* [0][0][][] */ -31,77,-8,-127,-35,-24,-30,-70,-24,16,4,65,8,-60,-11,53, 
  /* [1][0][][] */ -29,30,-51,6,-32,-19,13,-72,64,43,-51,23,9,10,36,-127, 
  /* [2][0][][] */ 2,-6,-47,53,58,58,-58,-58,127,-16,-10,-9,-48,105,-121,41, 
  /* [3][0][][] */ 47,-81,-12,-106,4,-8,-1,-6,88,1,62,34,-12,26,9,127, 
  /* [4][0][][] */ -76,39,7,41,10,-12,-5,31,3,15,22,-19,-127,-16,-6,28, 
  /* [5][0][][] */ -5,70,120,8,12,77,-80,69,-49,61,-16,-25,26,-39,-127,11, 
  /* [6][0][][] */ 47,-67,99,-127,48,14,-31,88,-86,-84,34,-49,-14,75,-21,95, 
  /* [7][0][][] */ 49,118,-40,-76,121,8,1,-48,127,100,-36,3,25,-35,74,62, 
  /* [8][0][][] */ 7,-74,11,-81,19,-67,23,-66,30,71,63,-9,18,127,74,47, 
  /* [9][0][][] */ 15,-44,-13,127,48,4,39,-65,-73,115,30,-28,-16,-69,-5,0, 
  /* [10][0][][] */ 4,35,-45,-127,28,-4,-25,44,27,-58,10,-42,-14,-55,-7,34, 
  /* [11][0][][] */ -4,24,28,-14,73,-28,77,-56,-77,36,6,36,-1,127,-70,-35, 
  /* [12][0][][] */ 71,-7,-119,-20,29,-105,31,26,12,66,-94,-45,-29,127,-3,23, 
  /* [13][0][][] */ -20,8,-24,18,7,-127,-4,26,9,-6,7,0,8,-9,4,8, 
  /* [14][0][][] */ 22,-18,101,-22,51,8,-127,-86,-9,-50,39,28,18,-51,-12,-40, 
  /* [15][0][][] */ -114,37,-5,-38,-7,-22,127,55,-28,52,106,-17,18,100,71,-14, 
  /* [16][0][][] */ 26,53,127,89,11,51,93,73,-111,0,-87,-20,6,1,11,-66, 
  /* [17][0][][] */ -38,-92,-10,33,-62,-14,-63,25,-127,-40,15,-50,0,38,62,-36, 
  /* [18][0][][] */ 4,47,-3,85,41,4,9,-11,79,35,-32,-26,3,127,80,24, 
  /* [19][0][][] */ 15,-4,58,21,121,13,-118,-63,-104,-113,-53,-127,-27,-47,1,-57, 
  /* [20][0][][] */ 74,-30,-63,-27,-2,-127,12,18,-35,35,-73,-4,32,10,31,-14, 
  /* [21][0][][] */ 78,-51,52,-12,-45,-23,13,98,12,-57,54,37,-3,127,30,78, 
  /* [22][0][][] */ -26,42,-53,127,-55,-1,100,62,-20,39,-28,31,-9,0,38,5, 
  /* [23][0][][] */ 83,-18,102,-127,88,-39,-11,58,-2,-4,9,-54,10,-35,-126,62, 
  /* [24][0][][] */ -127,39,8,-17,4,119,26,-20,-7,12,108,-10,-79,17,65,-24, 
  /* [25][0][][] */ 21,27,15,22,8,3,58,-50,2,-127,-8,-12,-5,-25,18,14, 
  /* [26][0][][] */ -32,-12,-5,6,-51,-4,-36,-33,-119,-28,-7,-39,3,127,-43,60, 
  /* [27][0][][] */ -2,28,10,71,41,-20,-15,-25,53,11,-28,-5,3,127,-17,16, 
  /* [28][0][][] */ 20,60,51,50,127,10,32,40,-95,-26,-56,-39,13,81,43,-19, 
  /* [29][0][][] */ 4,-3,9,17,38,10,7,40,-33,-23,-16,-127,-2,-23,-11,6, 
  /* [30][0][][] */ -23,95,-57,79,-25,-13,41,-127,-55,48,-14,-12,60,34,94,98, 
  /* [31][0][][] */ -15,-44,-10,-65,-6,4,-34,-87,2,95,-38,-127,-48,-23,0,33, 
  /* [32][0][][] */ -127,-68,-6,57,48,36,-18,3,1,-53,-96,51,73,-1,63,66, 
  /* [33][0][][] */ -11,-48,-49,-7,-93,3,-86,2,58,28,14,-57,19,-127,125,34, 
  /* [34][0][][] */ 52,-14,54,28,38,13,-45,83,-83,-33,58,9,13,-5,-18,127, 
  /* [35][0][][] */ -47,48,-81,17,0,-18,32,-127,87,101,-85,-8,-2,-10,82,-125, 
  /* [36][0][][] */ -46,42,11,127,24,23,102,11,3,54,-6,1,-16,28,-30,-65, 
  /* [37][0][][] */ 20,-28,5,-71,7,11,-25,-36,-90,8,-19,-24,-16,-127,46,-17, 
  /* [38][0][][] */ 47,103,-2,-41,124,7,33,-36,127,81,-18,7,16,-23,40,8, 
  /* [39][0][][] */ -22,63,-8,-127,-10,0,-48,44,40,-88,-36,-22,19,75,49,42, 
  /* [40][0][][] */ 11,-38,6,-75,13,-22,4,-18,-127,18,-31,-46,-17,-97,64,-41, 
  /* [41][0][][] */ -2,-19,-41,-9,13,-24,15,3,-33,19,-51,-16,-127,7,17,42, 
  /* [42][0][][] */ 127,74,-40,-21,-72,-61,-21,-46,2,42,80,-64,-70,47,97,-104, 
  /* [43][0][][] */ -27,127,-49,8,36,-32,104,-37,72,96,-27,20,44,-97,-85,-79, 
  /* [44][0][][] */ -30,1,19,-36,75,7,-127,-121,-17,-22,27,12,4,-35,99,-88, 
  /* [45][0][][] */ 11,64,-127,-52,58,-62,24,-55,-18,-2,-13,-118,38,-43,70,-2, 
  /* [46][0][][] */ 5,-3,-28,-89,-21,-2,21,-35,-115,-18,13,20,-8,-127,81,-37, 
  /* [47][0][][] */ 21,48,22,-21,127,-20,-22,16,-61,44,-6,17,0,0,114,-25, 
  /* [48][0][][] */ -127,-83,-29,35,67,11,13,-25,-4,-15,-110,37,67,7,89,54, 
  /* [49][0][][] */ 6,16,103,80,127,1,40,31,-114,-55,-30,-72,11,118,9,-65, 
  /* [50][0][][] */ 32,-11,-94,-3,51,-127,-50,-8,-21,-27,7,-69,55,-30,1,16, 
  /* [51][0][][] */ 0,48,52,17,36,10,-5,25,-127,50,5,-108,15,-119,-31,82, 
  /* [52][0][][] */ -4,52,9,52,28,2,28,18,74,80,-20,-38,37,127,49,6, 
  /* [53][0][][] */ -5,-56,-25,-22,-85,-14,-79,-2,38,33,4,-66,23,-127,113,25, 
  /* [54][0][][] */ 68,-25,-60,8,127,78,-111,-23,-92,-15,-30,-100,6,-35,-4,-22, 
  /* [55][0][][] */ 53,-4,8,-5,46,-30,-68,-127,-49,-90,-77,3,-7,-35,17,-1, 
  /* [56][0][][] */ -18,15,16,-15,-7,-28,-102,70,-8,127,0,-15,28,5,8,8, 
  /* [57][0][][] */ 8,27,-42,-22,-49,-43,116,95,-39,8,-19,-5,30,19,127,0, 
  /* [58][0][][] */ 58,2,-127,46,82,123,-40,58,-94,-23,10,0,-53,32,-26,-10, 
  /* [59][0][][] */ -126,75,113,9,-103,-87,127,122,32,-1,60,-8,22,1,101,-7, 
  /* [60][0][][] */ 3,4,-50,1,32,-127,-29,-2,-12,-19,2,-32,23,-14,10,3, 
  /* [61][0][][] */ 25,-12,24,127,83,14,23,8,-100,1,13,32,-10,27,34,-49, 
  /* [62][0][][] */ -44,127,22,-38,-26,-4,-67,59,-22,-66,-79,-46,-6,-85,-55,-40, 
  /* [63][0][][] */ -44,29,-33,127,-79,-1,-74,-41,-56,-25,-23,-37,32,74,53,34, 
  /* [64][0][][] */ 2,1,-5,35,16,9,-11,60,19,-5,-6,-51,-16,-127,60,4, 
  /* [65][0][][] */ -13,-42,9,-127,46,-53,64,-36,2,54,9,-117,-4,19,20,-51, 
  /* [66][0][][] */ 21,-4,65,-16,-27,-2,-4,73,20,-72,40,51,12,127,20,56, 
  /* [67][0][][] */ 4,54,-16,-127,-5,-3,-68,35,78,-108,-28,-10,29,78,75,41, 
  /* [68][0][][] */ -36,32,127,3,14,-9,1,-9,-39,-17,-11,-43,15,-24,95,-34, 
  /* [69][0][][] */ 127,95,-7,-10,-114,-26,-22,-51,22,26,94,-41,-68,68,63,-116, 
  /* [70][0][][] */ 36,14,-45,-13,-24,30,54,127,-30,77,-32,11,19,61,-25,14, 
  /* [71][0][][] */ 10,-11,-10,11,-4,-75,5,23,-30,30,-78,4,-127,1,35,51, 
  /* [72][0][][] */ 17,11,-127,5,13,11,29,84,-45,-33,-2,-14,18,9,-6,19, 
  /* [73][0][][] */ -48,22,47,1,37,-57,-74,-127,21,-75,34,-12,26,-40,57,-22, 
  /* [74][0][][] */ -10,43,41,127,13,-5,-74,74,-57,28,-42,50,17,-109,18,-111, 
  /* [75][0][][] */ -22,42,-38,6,1,2,8,-29,127,10,4,14,15,116,-25,-11, 
  /* [76][0][][] */ -7,-6,1,12,8,-11,-7,58,13,-36,-22,-127,-4,-10,6,7, 
  /* [77][0][][] */ -9,30,-3,127,-45,13,74,96,14,36,-7,34,-6,-8,-18,-21, 
  /* [78][0][][] */ -10,19,29,-95,34,-48,-39,39,39,-48,23,-21,47,127,33,30, 
  /* [79][0][][] */ -10,-111,-93,-88,-119,-20,38,-88,127,14,12,72,27,39,77,-49, 
  /* [80][0][][] */ -39,11,127,-83,22,-22,16,-70,-70,56,-62,-110,22,111,83,-45, 
  /* [81][0][][] */ -42,41,-122,26,79,-127,-18,53,-12,-41,51,-12,25,-2,16,-1, 
  /* [82][0][][] */ 127,-5,-8,18,19,-122,-26,22,-19,-13,-100,-10,113,8,-4,31, 
  /* [83][0][][] */ -49,78,-113,-73,-43,-30,43,-127,73,62,-29,-103,23,57,53,83, 
  /* [84][0][][] */ -38,61,92,-28,8,-21,67,-127,-38,23,-2,-53,45,62,74,-13, 
  /* [85][0][][] */ -83,127,32,-109,-78,-25,-30,-3,-47,-8,-58,30,12,-4,-90,-32, 
  /* [86][0][][] */ 4,0,-36,-5,-22,-25,127,24,-8,-39,-15,0,11,22,87,-5, 
  /* [87][0][][] */ -34,-38,6,-127,2,-47,58,-19,6,29,2,-122,-17,13,9,-53, 
  /* [88][0][][] */ 97,-29,20,-10,47,-127,-6,26,-61,31,-103,-85,47,13,101,14, 
  /* [89][0][][] */ 15,-8,-44,-54,43,-16,-30,-11,-47,5,44,-77,127,-8,32,-60, 
  /* [90][0][][] */ 10,-56,44,-68,77,-2,-67,104,56,-97,-56,-39,2,123,21,-127, 
  /* [91][0][][] */ -46,-4,-18,-28,21,-8,-27,-87,15,68,-3,-127,-35,-3,-2,6, 
  /* [92][0][][] */ -24,24,44,20,-3,-127,13,2,5,-22,2,-9,4,-21,18,2, 
  /* [93][0][][] */ 38,-16,127,-2,-52,51,19,-29,-15,17,-67,-11,-20,1,33,-2, 
  /* [94][0][][] */ 34,-3,-15,-20,33,-16,-16,1,-36,-18,11,-65,127,-7,22,-28, 
  /* [95][0][][] */ 127,89,-5,33,-99,-32,-68,-3,-25,-11,91,-47,-43,26,80,-67, 
};
const TfArray<4, int> tensor_dimension38 = { 4, { 96,1,1,16 } };
const TfArray<96, float> quant38_scale = { 96, { 0.00083864328917115927, 0.0013742831069976091, 0.00068416690919548273, 0.0010042424546554685, 0.00098092400003224611, 0.00088561454322189093, 0.00053983338875696063, 0.00082190660759806633, 0.00063831714214757085, 0.0011379809584468603, 0.00051063962746411562, 0.00066922185942530632, 0.00066601805156096816, 0.0034892293624579906, 0.00062685314333066344, 0.00042262629722245038, 0.00034149744897149503, 0.00072346907109022141, 0.0012495171977207065, 0.00058942899340763688, 0.00045921895070932806, 0.0003025989281013608, 0.00046454340917989612, 0.00018331350293010473, 0.00041674601379781961, 0.0013389751547947526, 0.0023959167301654816, 0.0008720732294023037, 0.00057032133918255568, 0.00092870095977559686, 0.00046063287300057709, 0.0010879645124077797, 0.00056000385666266084, 0.00052437750855460763, 0.0010415978031232953, 0.00073526636697351933, 0.00056755385594442487, 0.00062220869585871696, 0.00092437444254755974, 0.0010327915661036968, 0.00050454976735636592, 0.001431866898201406, 0.00083951902342960238, 0.00056797591969370842, 0.00098467816133052111, 0.00061215891037136316, 0.00062605313723906875, 0.00076753098983317614, 0.00070976355345919728, 0.00054173171520233154, 0.0007665155571885407, 0.00049824442248791456, 0.0014929339522495866, 0.00055527291260659695, 0.00084603799041360617, 0.00085405283607542515, 0.0012938783038407564, 0.00084180035628378391, 0.00087867287220433354, 0.00045943172881379724, 0.0026153232902288437, 0.0012381500564515591, 0.00056349171791225672, 0.0011057882802560925, 0.0016462724888697267, 0.00074212922481819987, 0.00038184170261956751, 0.00058623537188395858, 0.0014283175114542246, 0.00098779390100389719, 0.00069446425186470151, 0.00067156093427911401, 0.0026534183416515589, 0.00085728662088513374, 0.0008080005063675344, 0.00055692903697490692, 0.00068491417914628983, 0.00035608519101515412, 0.00036585330963134766, 0.00038444323581643403, 0.00052549876272678375, 0.00057407940039411187, 0.00043314063805155456, 0.00048051163321360946, 0.00040658426587469876, 0.00074832444079220295, 0.0014911590842530131, 0.00053716474212706089, 0.0003072255349252373, 0.0015168935060501099, 0.00057367520639672875, 0.00090356153668835759, 0.00077945669181644917, 0.0016629982274025679, 0.0010566237615421414, 0.00049221300287172198, } };
const TfArray<96, int> quant38_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant38 = { (TfLiteFloatArray*)&quant38_scale, (TfLiteIntArray*)&quant38_zero, 0 };
const ALIGN(16) int32_t tensor_data39[96] = { -1939, 3025, 9268, 2363, -2831, -4380, 16327, 2306, 2452, -1475, 10223, -259, -10122, 2146, 13048, 7204, 14513, 5280, -4123, -7721, 3507, 23697, 17529, 24267, 1248, 934, 3310, 3295, 2450, -5608, 8356, -1807, -309, 5792, 55, 851, 8871, 4619, -1800, 4631, 6741, 4805, 4808, 10800, 5157, 4370, 2089, 7444, 5093, -6470, -5326, 455, -276, -1407, 2453, -45, 167, -740, -4595, 10728, -751, 1384, -1284, -1859, -2980, 6866, 14976, 1865, -2140, 835, 1435, 2043, 1348, -1282, 547, 10273, -538, 13932, 13123, -832, 7294, 1576, -481, 1318, 11837, 8442, 4191, 1415, 6080, 3556, -406, -5756, 725, -1659, -1528, -2167, };
const TfArray<1, int> tensor_dimension39 = { 1, { 96 } };
const TfArray<96, float> quant39_scale = { 96, { 0.00031659295200370252, 0.00051880022510886192, 0.00025827717036008835, 0.00037910763057880104, 0.00037030476960353553, 0.00033432486816309392, 0.00020379039051476866, 0.00031027474324218929, 0.00024096859851852059, 0.0004295947146601975, 0.00019276955572422594, 0.00025263530551455915, 0.00025142586673609912, 0.0013172052567824721, 0.00023664087348151952, 0.00015954399714246392, 0.00012891736696474254, 0.00027311398298479617, 0.0004717003321275115, 0.00022251303016673774, 0.00017335794109385461, 0.00011423293472034857, 0.00017536795348860323, 6.9201960286591202e-05, 0.00015732414613012224, 0.00050547125283628702, 0.0009044731268659234, 0.00032921295496635139, 0.00021529977675527334, 0.00035059024230577052, 0.0001738917053444311, 0.00041071322630159557, 0.00021140485478099436, 0.00019795569824054837, 0.00039320951327681541, 0.00027756750932894647, 0.00021425503655336797, 0.00023488755687139928, 0.00034895696444436908, 0.00038988509913906455, 0.00019047060050070286, 0.00054053845815360546, 0.00031692354241386056, 0.00021441436547320336, 0.00037172198062762618, 0.00023109371250029653, 0.00023633886303286999, 0.00028974760789424181, 0.00026794004952535033, 0.00020450701413210481, 0.00028936428134329617, 0.00018809030007105321, 0.00056359166046604514, 0.00020961889822501689, 0.00031938447500579059, 0.00032241013832390308, 0.00048844690900295973, 0.00031778475386090577, 0.00033170435926876962, 0.00017343826766591519, 0.00098730041645467281, 0.00046740917605347931, 0.00021272154117468745, 0.00041744179907254875, 0.00062147784046828747, 0.00028015830321237445, 0.0001441475615138188, 0.00022130741854198277, 0.00053919851779937744, 0.00037289821193553507, 0.0002621644816827029, 0.00025351834483444691, 0.0010016815504059196, 0.00032363089849241078, 0.00030502511071972549, 0.00021024409215897322, 0.00025855927378870547, 0.00013442432100418955, 0.00013811184908263385, 0.00014512965572066605, 0.00019837896979879588, 0.00021671845752280205, 0.00016351322119589895, 0.00018139605526812375, 0.00015348802844528109, 0.00028249702882021666, 0.00056292163208127022, 0.00020278296142350882, 0.00011597950651776046, 0.00057263649068772793, 0.00021656588069163263, 0.00034109997795894742, 0.00029424965032376349, 0.00062779191648587584, 0.00039888187893666327, 0.00018581340555101633, } };
const TfArray<96, int> quant39_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant39 = { (TfLiteFloatArray*)&quant39_scale, (TfLiteIntArray*)&quant39_zero, 0 };
const ALIGN(16) int8_t tensor_data40[32*1*1*96] = { 
  /* [0][0][][] */ 20,55,32,-85,-66,-3,1,75,-20,-27,-115,-99,-120,122,-55,67,41,101,0,6,-41,-105,-40,30,108,-115,5,109,61,-82,76,12,-89,99,38,-67,-28,21,-98,-19,-99,-42,115,-73,76,-9,-76,115,-109,97,-86,37,-37,93,14,55,-56,-99,17,32,-14,96,31,-127,86,-113,-107,54,57,-92,-10,125,-54,41,-48,114,-43,-60,-31,-30,-110,64,70,37,-46,-76,-62,-48,31,50,28,74,-102,-122,-40,52, 
  /* [1][0][][] */ 78,14,81,61,22,-76,6,120,50,57,-74,64,-120,-92,31,-69,-57,-31,55,-37,99,95,-80,-69,39,-4,-29,-63,82,38,-13,-73,-21,-82,-87,-60,37,-68,-50,22,4,110,1,32,47,0,-39,39,22,-99,-9,-54,-11,-114,-63,-104,40,49,93,18,68,-86,-43,-24,109,-12,7,99,75,105,45,114,-5,29,51,45,62,-66,127,52,-80,108,-76,82,38,25,-100,31,-59,-63,59,-37,-41,17,36,37, 
  /* [2][0][][] */ -1,-65,-85,-115,-33,11,80,7,36,-39,-61,-48,64,88,-67,-111,-94,44,-51,39,-82,-48,34,32,-76,75,-37,-48,-19,-26,-79,41,54,-62,59,9,-77,28,-70,76,66,-28,123,86,-60,-10,57,34,-11,-67,33,100,-86,-71,10,-73,-31,34,85,121,114,90,-61,111,116,103,-71,-73,8,26,75,-13,44,16,-13,-67,109,123,-97,-85,-80,127,98,43,-67,41,50,42,86,91,84,127,-40,-38,104,91, 
  /* [3][0][][] */ -84,94,75,-85,98,115,81,69,101,17,37,-57,114,42,110,109,-110,72,-45,99,-65,85,-77,8,103,78,-98,31,67,31,-47,104,-96,25,47,-100,-87,-46,-87,-62,-95,-45,-70,21,-78,-112,-34,-36,-58,117,-41,-106,30,42,101,-65,-88,-105,74,-98,-91,50,-93,-18,3,86,-46,-36,-48,-47,102,4,96,82,-39,-68,-127,-47,84,-64,55,97,-68,-96,74,-118,97,-95,-23,-115,109,90,-94,-38,23,-38, 
  /* [4][0][][] */ -99,16,85,-16,53,23,-27,-50,9,71,-109,-54,-69,81,23,-105,84,35,-39,-81,-103,73,-116,-29,-34,-127,88,36,11,-102,106,25,-118,35,-50,-61,99,-25,-122,-109,98,90,-110,-111,-26,78,-49,-48,109,-23,96,112,90,-126,-2,29,-114,-36,120,-63,65,-25,-26,66,-61,22,-116,-93,19,84,43,-16,-62,-17,12,-73,-27,83,-46,33,24,-122,39,-5,44,109,3,-72,-38,-22,94,53,84,3,-120,-127, 
  /* [5][0][][] */ -100,97,-51,-55,39,-31,-49,56,-20,-86,44,26,-86,34,90,94,-110,103,95,-14,94,0,-53,90,-100,40,-42,-59,-29,25,54,-14,-62,60,55,57,87,-61,-61,-40,66,-14,-14,-59,90,106,-1,-11,18,88,127,37,-83,-35,35,-39,98,-37,-76,63,67,56,-8,62,74,-59,35,57,116,-55,25,-6,-98,81,14,-86,-54,50,24,-13,63,122,-84,-48,39,-36,-83,-21,69,94,-35,98,-2,76,16,106, 
  /* [6][0][][] */ 81,42,31,-57,-57,25,47,-49,35,46,29,127,31,-42,2,108,-43,67,59,29,-95,95,82,34,-16,19,-78,-47,-41,-93,14,18,-65,13,37,117,-58,-44,33,49,-71,32,68,25,-52,54,-83,-17,53,91,7,-32,-49,-91,-70,-81,-54,-20,-42,90,37,-34,62,10,59,69,-1,38,-30,-43,-39,-26,38,-7,91,115,-51,55,-22,-5,23,-10,-43,-71,74,26,0,84,-23,-80,-35,-37,-51,-10,45,-55, 
  /* [7][0][][] */ 73,54,-45,-110,115,-17,-22,-52,30,-62,-2,-37,-58,118,110,66,86,10,-36,65,83,-86,-3,-50,115,-65,63,108,-88,-23,-5,22,-116,-31,75,-23,122,7,9,-97,-97,46,-46,89,24,-51,-82,-44,70,-51,-16,113,-42,50,75,42,76,-114,5,-107,27,-64,-43,-43,4,-49,-100,-98,57,-95,-118,19,-97,79,-22,73,-60,-38,-66,-14,-95,46,14,76,-53,-79,-15,-74,57,127,112,-76,37,-88,103,-93, 
  /* [8][0][][] */ -62,-53,-127,-14,72,-10,-35,-104,86,-116,118,-112,-37,-99,-127,-9,12,75,70,-77,92,51,90,-68,-67,-116,2,-113,-89,-96,-112,-6,-46,-4,-106,123,-127,-102,-49,-82,-24,17,41,-29,-2,-57,-21,92,66,79,-36,-34,107,25,-19,-104,-10,-5,-27,13,-93,-21,-111,88,-9,-46,-4,-78,-72,33,-121,49,33,105,125,79,86,-17,-24,-33,31,113,-15,61,67,-62,-26,70,51,55,-76,83,-109,104,121,-53, 
  /* [9][0][][] */ -29,-35,29,83,38,65,95,38,23,63,78,66,127,62,-27,-20,-3,-54,-75,-73,-80,91,28,-16,-79,-61,-37,54,73,-106,-25,68,-100,-60,125,-25,-25,5,-67,-63,117,104,9,13,45,69,38,-15,-22,-38,-80,-54,-105,38,36,84,6,-67,31,10,9,-62,39,88,-125,90,80,70,102,-64,-100,30,62,27,72,-108,127,-65,21,-50,-107,-36,99,-71,68,-69,-88,33,-62,103,36,23,-75,35,42,58, 
  /* [10][0][][] */ -99,60,-76,-96,-50,94,-127,-100,82,-113,82,70,-19,32,72,-5,108,7,-68,26,-16,-65,-45,81,34,100,-37,-22,-117,-91,-17,-122,61,30,97,-100,117,-90,46,112,79,22,32,59,-16,21,-12,-9,-92,111,88,100,101,-109,87,53,21,-20,62,-8,69,61,96,53,-58,101,-3,54,3,-5,67,20,-110,-110,28,63,60,97,77,39,-5,35,0,19,13,76,-89,20,-19,29,-56,78,49,65,12,-8, 
  /* [11][0][][] */ 93,89,2,-51,90,77,-33,-61,-59,46,43,10,25,-58,66,-58,-91,75,16,-61,-32,-19,80,-60,-72,86,74,118,9,27,13,32,57,82,-127,-41,42,110,-41,-62,50,-95,115,-78,94,25,-94,-12,56,84,-45,68,80,-71,-49,-81,8,73,-127,88,-34,24,110,-41,32,-25,109,7,85,110,-29,29,-100,-27,36,-37,-23,93,-53,25,-71,-18,-93,95,20,-51,-34,-26,-71,41,11,-52,88,32,97,26, 
  /* [12][0][][] */ -85,-44,-87,108,4,-48,-63,-85,-25,-6,-56,35,-80,-98,-56,64,30,-61,24,110,-102,-40,58,43,-24,86,-89,-5,96,-92,74,71,18,-54,-11,-82,1,-101,68,59,77,82,43,-88,22,-19,-87,79,-100,96,-56,53,-64,-113,83,38,-1,-87,-98,-107,46,-37,107,-20,-86,-10,-3,-72,-127,-113,34,-29,-123,-93,-26,-25,-117,-26,78,-61,19,75,91,-17,61,-74,-32,-76,-82,-94,-5,-1,-111,-94,-119,86, 
  /* [13][0][][] */ 52,46,92,-80,101,29,34,-69,14,-127,35,31,-19,89,36,76,84,50,1,81,114,-19,-11,-84,89,-94,-4,-79,29,-118,-63,-23,-20,-124,25,-8,75,-123,75,41,-24,-77,69,94,52,-21,61,67,-104,82,-68,-8,-40,-115,-8,89,35,-70,75,-73,-127,-13,80,-66,-109,32,-43,-124,-110,-77,-107,91,-53,-31,113,-27,-44,100,-19,-62,78,40,-20,115,101,-48,-125,74,-64,-68,36,-48,61,117,-40,-98, 
  /* [14][0][][] */ -48,-66,91,58,63,-87,19,-6,-2,87,-30,-71,20,109,-33,37,-93,-25,-25,-106,2,40,-49,-37,-41,-46,73,21,76,-70,80,-28,-52,99,121,32,31,74,-91,-104,109,127,119,23,73,-64,-8,-48,-108,12,-12,-58,-12,-111,99,-118,42,-83,-19,-103,-90,-95,12,19,-3,69,6,-26,-116,-14,43,-50,-94,-84,55,-15,-79,-11,69,-4,124,-28,119,50,-77,-72,-65,86,62,-8,-78,-21,-16,-101,-85,-63, 
  /* [15][0][][] */ 33,42,6,-62,-112,68,21,55,-120,-32,113,-47,-10,-67,-39,-45,-25,100,-122,37,-20,-81,-55,-17,-10,0,112,111,-6,-64,-118,37,48,108,-27,-38,-25,114,-35,-93,-56,127,110,-63,86,56,-72,-90,28,-13,-57,-80,-76,-8,50,27,38,-19,121,-61,-126,-85,-101,-62,-48,38,-10,-87,-34,-82,-72,20,78,46,3,84,-20,107,-102,-32,-22,-84,-43,-53,-49,-40,101,-31,71,-96,-82,106,-15,-24,116,-84, 
  /* [16][0][][] */ -11,12,-107,122,99,-77,115,113,-42,60,98,-70,-39,95,-117,-31,44,96,-75,-7,-110,-16,-103,23,115,-54,-70,22,-40,120,122,56,-78,-39,38,-1,-14,108,-117,76,61,46,87,-56,-95,-1,-92,-53,-16,55,105,90,-41,-112,78,20,40,105,-16,-68,52,-16,7,73,16,43,78,-38,7,-63,89,33,96,2,51,-90,106,-54,-93,-78,-22,35,3,-100,104,-67,7,-104,127,-87,105,-90,55,38,95,-104, 
  /* [17][0][][] */ -36,75,-113,-37,-20,20,-36,99,23,-30,102,-23,-51,107,36,-61,33,84,-23,78,22,-10,-54,-12,-101,19,-29,-70,-18,40,67,-101,74,-34,-9,31,29,-50,-26,51,-36,115,-22,-82,108,29,-77,-81,37,-106,5,-98,-68,16,58,37,-50,79,-61,-61,111,104,72,90,-32,35,-86,83,-54,-59,2,-21,-23,-29,-5,43,-93,-55,114,-126,-56,11,105,-51,77,32,-38,96,24,127,-24,66,-88,-85,98,-13, 
  /* [18][0][][] */ 76,-74,-87,-1,65,73,-97,-60,-33,46,-66,-42,-8,101,30,53,26,86,-33,-49,-69,54,34,39,40,-21,35,-78,-12,-98,39,-106,-12,84,92,-30,45,-32,-31,-62,-85,26,115,-33,-6,48,86,-41,89,5,-12,-88,-14,10,-37,28,102,32,-123,77,-71,-15,71,105,-15,29,-74,-79,113,-13,-64,80,-86,114,10,127,23,93,2,-2,-43,-16,-77,95,19,-36,100,18,67,30,-26,103,-61,-25,16,-79, 
  /* [19][0][][] */ 56,44,-117,72,91,64,-53,-3,77,-66,9,-51,48,85,124,-60,33,-95,-37,127,-109,-79,18,118,71,6,29,-30,88,21,106,-122,82,-23,-76,59,-125,-19,-69,31,69,33,47,35,-30,45,-102,111,122,19,44,-19,54,-87,95,116,36,-15,-104,-63,-42,52,114,-48,118,-16,-71,99,112,0,-113,-13,12,91,5,80,0,75,-77,91,-112,-53,94,-116,40,12,89,-94,-92,0,-15,6,-39,-60,93,-96, 
  /* [20][0][][] */ -9,-95,-22,60,93,22,78,42,-60,-73,15,-5,-31,-89,-3,-99,-21,-61,108,36,53,-118,91,-30,-109,105,-88,16,-1,-81,-53,1,43,97,82,-66,99,12,-111,16,93,-117,-94,-30,42,11,-48,-50,76,-15,107,-84,-1,88,22,-93,-63,-127,67,10,-39,90,66,86,26,93,28,-83,28,75,-78,19,-103,-99,-37,110,-15,-94,37,-70,9,95,83,-57,49,12,-82,-118,109,8,-116,-87,59,-65,21,66, 
  /* [21][0][][] */ 82,110,116,-76,-24,-65,-78,-43,-17,123,35,-90,-34,-68,-91,-95,-22,-11,-85,-95,-21,66,120,-45,102,39,92,-16,-52,-90,114,23,-96,39,114,111,-108,-72,-110,31,16,63,-33,20,-72,110,-114,81,77,-118,21,-58,68,-38,-99,-48,-20,-54,110,95,28,-33,-4,75,-38,61,-63,6,-6,-53,3,24,-24,-96,-51,10,-74,118,123,87,-33,116,15,-4,-114,-66,28,47,-30,60,-70,103,-19,-69,127,-25, 
  /* [22][0][][] */ -35,-65,62,-41,-102,-116,98,60,44,-31,-41,14,-66,26,-43,-124,-120,-19,-48,71,41,110,-30,78,-116,29,-92,50,-60,-99,-82,-94,-108,114,21,48,17,-118,-85,-86,-40,-20,-91,-10,59,-58,113,-94,-96,-33,-110,73,-97,114,-27,41,109,106,-127,89,-85,-42,-22,10,82,-126,-113,-41,62,106,-110,-57,-7,86,-99,-34,-126,-116,50,-26,99,-99,-118,-65,39,80,-44,109,21,94,108,15,-125,92,92,84, 
  /* [23][0][][] */ -34,-4,10,-34,-81,-10,61,10,23,-80,57,-105,-87,81,61,-47,32,45,36,28,59,96,59,-2,43,-56,-63,-66,-93,89,-4,127,64,-60,107,-19,-3,110,67,-83,117,49,97,-95,-101,5,-87,101,27,95,-16,-5,-83,112,75,12,41,9,71,-26,-40,58,67,-108,100,-86,10,-20,82,99,-62,117,104,32,20,-47,-99,18,-91,-23,-100,13,-81,-67,-50,-120,109,-98,-28,-70,-39,-61,16,-43,-69,107, 
  /* [24][0][][] */ -14,83,109,97,62,-29,-119,101,-12,-107,-94,86,18,-9,-17,-73,-33,31,-66,81,111,-35,-33,26,-32,56,-79,-66,83,111,91,-35,108,-58,-20,-32,10,-55,-93,-99,-4,103,-92,38,-57,67,42,-78,-106,-62,21,-30,-65,72,109,-56,58,-55,-24,-35,101,35,48,-20,-127,-17,-75,107,66,-92,-22,24,-14,-112,-20,-47,17,-65,-40,64,59,-56,49,-58,-92,-78,-28,-73,-97,72,-60,-34,-79,-81,64,108, 
  /* [25][0][][] */ -2,2,11,101,-3,65,-78,50,-13,75,76,71,-81,78,102,-92,-38,-9,-101,9,74,122,-21,116,43,-81,-53,-47,71,80,-101,70,-103,-68,106,120,-99,65,-102,127,-96,117,69,13,-4,-89,-106,-116,-40,41,-99,-47,-7,-8,-116,-103,37,-40,126,34,-85,117,-100,22,-102,-84,-80,104,7,0,41,62,23,68,-27,16,27,2,46,-79,-88,-12,-69,46,99,23,-24,50,-103,112,-47,-20,-23,98,94,49, 
  /* [26][0][][] */ 78,-90,-4,-4,91,-103,109,-39,50,-17,-81,6,-22,-64,41,-21,109,19,-89,-61,59,-47,73,98,-4,-24,56,44,31,10,-44,-23,-28,57,58,105,2,102,-115,112,106,17,-24,-96,-4,64,127,19,25,62,106,-7,102,110,78,42,91,14,-37,-17,27,123,-80,-110,70,-19,-104,-28,2,-54,41,56,-98,-61,-84,-79,-2,25,-17,43,115,22,-36,-11,-7,-41,-6,-77,37,25,92,125,-40,68,60,-46, 
  /* [27][0][][] */ 55,56,-102,127,-17,-34,3,7,-84,91,-31,-13,-123,76,82,-48,39,-113,5,-114,-29,55,85,-91,-96,67,-45,56,84,-71,68,-125,119,-78,30,124,107,55,-73,-43,31,51,-19,61,74,-90,99,-70,-16,-74,80,85,109,67,-120,-84,91,-35,-40,12,37,-75,-117,-80,25,105,26,-88,39,8,26,-111,18,-59,7,-76,-92,-3,70,35,-64,-71,85,0,-107,-94,58,-41,105,15,41,101,93,22,68,-72, 
  /* [28][0][][] */ -112,120,-42,78,2,97,-107,-6,54,-74,-102,76,57,-77,19,-98,-69,70,46,84,92,74,12,-87,64,-70,73,114,-56,12,-22,28,-18,14,-41,-51,40,93,-42,115,-97,-32,-7,62,103,101,-20,1,111,1,-127,-3,62,-48,16,57,92,46,35,89,36,-28,-1,-112,-89,-11,90,-44,-85,60,66,103,-113,49,123,36,51,-37,-12,95,-74,58,49,-31,51,15,-73,-69,-99,12,85,-96,42,55,-24,104, 
  /* [29][0][][] */ 21,-22,30,15,-31,6,15,-120,-60,-39,-58,-86,69,-27,-89,-26,85,87,-72,93,23,-75,-94,-98,88,-72,-107,-55,-54,84,-70,27,-109,111,103,-2,-34,-103,24,-35,105,-60,-27,29,-92,56,-123,-5,-41,65,18,38,-83,-20,80,85,44,-20,-72,8,111,96,-79,34,71,-89,-125,34,67,-11,-35,-57,-34,-127,-33,-102,-68,27,-5,64,-11,-45,21,-30,17,-118,-73,89,-22,27,-76,-59,-110,-17,-74,-71, 
  /* [30][0][][] */ -80,-103,-93,-62,41,69,55,-1,-93,14,32,48,65,53,-90,-117,93,107,62,20,-22,-68,109,-66,15,66,-20,6,88,-61,6,40,9,-28,38,2,-98,-26,74,-11,-5,-84,-68,-85,79,109,-30,-24,-58,91,-125,-30,-119,-22,99,-84,64,30,7,-18,-50,-102,48,70,127,86,29,67,84,74,85,-90,35,-98,-87,2,56,-29,-4,-70,42,45,86,23,73,-55,63,29,96,40,56,-109,-4,58,-59,-58, 
  /* [31][0][][] */ 43,110,65,-44,-72,-12,103,-91,-90,-63,64,-68,-87,-88,98,16,-7,51,-26,47,-31,-40,93,5,65,124,-40,-60,-12,76,55,68,83,34,71,92,42,122,-22,-73,2,105,-97,27,34,100,61,-3,-105,-20,-87,75,20,-86,1,9,-10,28,50,110,-11,-127,120,-109,48,-93,78,-61,-109,29,104,-35,77,-68,-40,50,-6,80,54,-88,-9,-23,-116,-91,-33,75,120,-107,-72,94,44,-26,-63,-33,-103,64, 
};
const TfArray<4, int> tensor_dimension40 = { 4, { 32,1,1,96 } };
const TfArray<32, float> quant40_scale = { 32, { 0.0017317571910098195, 0.0018262631492689252, 0.0017454060725867748, 0.0018043625168502331, 0.0018133861012756824, 0.0020340895280241966, 0.0024298604112118483, 0.0018057225970551372, 0.0017598473932594061, 0.0017091938061639667, 0.001755743520334363, 0.0019447619561105967, 0.0018590530380606651, 0.0017349675763398409, 0.0017809460405260324, 0.0018112917896360159, 0.0017314313445240259, 0.00186436518561095, 0.0020525720901787281, 0.0017467230791226029, 0.001826678984798491, 0.0017703390913084149, 0.0017962948186323047, 0.0018867871258407831, 0.001777293742634356, 0.0017587337642908096, 0.0018211001297459006, 0.0018367191078141332, 0.0018630161648616195, 0.0017893951153382659, 0.0019609262235462666, 0.0017646716441959143, } };
const TfArray<32, int> quant40_zero = { 32, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant40 = { (TfLiteFloatArray*)&quant40_scale, (TfLiteIntArray*)&quant40_zero, 0 };
const ALIGN(16) int32_t tensor_data41[32] = { 57, 367, 146, -138, -49, -245, 806, 282, -363, 186, -179, 749, -208, -92, 133, 259, 176, 256, 434, 13, -288, 136, -235, 104, -437, 549, 155, 13, -10, -281, 189, -199, };
const TfArray<1, int> tensor_dimension41 = { 1, { 32 } };
const TfArray<32, float> quant41_scale = { 32, { 4.0747228922555223e-05, 4.2970899812644348e-05, 4.1068378777708858e-05, 4.2455591028556228e-05, 4.2667910747695714e-05, 4.7860932681942359e-05, 5.717318708775565e-05, 4.2487590690143406e-05, 4.1408173274248838e-05, 4.0216324123321101e-05, 4.131161404075101e-05, 4.575910497806035e-05, 4.3742424168158323e-05, 4.0822767914505675e-05, 4.1904611862264574e-05, 4.261863068677485e-05, 4.0739560063229874e-05, 4.386741784401238e-05, 4.8295813030563295e-05, 4.1099367081187665e-05, 4.2980682337656617e-05, 4.1655039240140468e-05, 4.2265761294402182e-05, 4.4394990254659206e-05, 4.1818675526883453e-05, 4.1381972550880164e-05, 4.2849416786339134e-05, 4.3216921767452732e-05, 4.3835676478920504e-05, 4.2103416490135714e-05, 4.613944111042656e-05, 4.1521685488987714e-05, } };
const TfArray<32, int> quant41_zero = { 32, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant41 = { (TfLiteFloatArray*)&quant41_scale, (TfLiteIntArray*)&quant41_zero, 0 };
const ALIGN(16) int8_t tensor_data42[4*1*1*32] = { 
  /* [0][0][][] */ -65,1,51,52,26,-120,117,77,-84,44,79,127,-38,45,-52,-9,-44,-15,22,39,-12,18,37,-77,84,9,-67,73,-33,23,24,-34, 
  /* [1][0][][] */ 84,-95,19,27,77,-94,-87,28,-88,109,-70,-39,101,-83,68,127,35,-65,-87,-56,-34,73,90,125,-108,80,127,-78,-15,-76,-39,-44, 
  /* [2][0][][] */ -14,-107,11,7,-96,-55,-58,-23,14,19,-37,-71,81,-113,-90,23,104,50,-127,86,-25,16,-49,-27,47,-124,107,-43,-114,107,106,105, 
  /* [3][0][][] */ 127,-80,109,-52,-102,64,-14,91,101,80,4,36,-5,-91,95,-118,16,58,47,-17,-15,75,-68,56,-57,-93,37,33,-73,100,-16,-117, 
};
const TfArray<4, int> tensor_dimension42 = { 4, { 4,1,1,32 } };
const TfArray<4, float> quant42_scale = { 4, { 0.0038488069549202919, 0.0032159173861145973, 0.0033165046479552984, 0.0032308630179613829, } };
const TfArray<4, int> quant42_zero = { 4, { 0,0,0,0 } };
const TfLiteAffineQuantization quant42 = { (TfLiteFloatArray*)&quant42_scale, (TfLiteIntArray*)&quant42_zero, 0 };
const ALIGN(16) int32_t tensor_data43[4] = { 29356, -41905, -41090, -42900, };
const TfArray<1, int> tensor_dimension43 = { 1, { 4 } };
const TfArray<4, float> quant43_scale = { 4, { 0.00016761785082053393, 0.00014005512639414519, 0.00014443576219491661, 0.00014070601901039481, } };
const TfArray<4, int> quant43_zero = { 4, { 0,0,0,0 } };
const TfLiteAffineQuantization quant43 = { (TfLiteFloatArray*)&quant43_scale, (TfLiteIntArray*)&quant43_zero, 0 };
const TfArray<4, int> tensor_dimension44 = { 4, { 1,48,48,16 } };
const TfArray<1, float> quant44_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant44_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant44 = { (TfLiteFloatArray*)&quant44_scale, (TfLiteIntArray*)&quant44_zero, 0 };
const TfArray<4, int> tensor_dimension45 = { 4, { 1,48,48,16 } };
const TfArray<1, float> quant45_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant45_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant45 = { (TfLiteFloatArray*)&quant45_scale, (TfLiteIntArray*)&quant45_zero, 0 };
const TfArray<4, int> tensor_dimension46 = { 4, { 1,48,48,8 } };
const TfArray<1, float> quant46_scale = { 1, { 0.56797283887863159, } };
const TfArray<1, int> quant46_zero = { 1, { -26 } };
const TfLiteAffineQuantization quant46 = { (TfLiteFloatArray*)&quant46_scale, (TfLiteIntArray*)&quant46_zero, 0 };
const TfArray<4, int> tensor_dimension47 = { 4, { 1,48,48,48 } };
const TfArray<1, float> quant47_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant47_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant47 = { (TfLiteFloatArray*)&quant47_scale, (TfLiteIntArray*)&quant47_zero, 0 };
const TfArray<4, int> tensor_dimension48 = { 4, { 1,49,49,48 } };
const TfArray<1, float> quant48_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant48_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant48 = { (TfLiteFloatArray*)&quant48_scale, (TfLiteIntArray*)&quant48_zero, 0 };
const TfArray<4, int> tensor_dimension49 = { 4, { 1,24,24,48 } };
const TfArray<1, float> quant49_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant49_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant49 = { (TfLiteFloatArray*)&quant49_scale, (TfLiteIntArray*)&quant49_zero, 0 };
const TfArray<4, int> tensor_dimension50 = { 4, { 1,24,24,8 } };
const TfArray<1, float> quant50_scale = { 1, { 0.47851556539535522, } };
const TfArray<1, int> quant50_zero = { 1, { 11 } };
const TfLiteAffineQuantization quant50 = { (TfLiteFloatArray*)&quant50_scale, (TfLiteIntArray*)&quant50_zero, 0 };
const TfArray<4, int> tensor_dimension51 = { 4, { 1,24,24,48 } };
const TfArray<1, float> quant51_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant51_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant51 = { (TfLiteFloatArray*)&quant51_scale, (TfLiteIntArray*)&quant51_zero, 0 };
const TfArray<4, int> tensor_dimension52 = { 4, { 1,24,24,48 } };
const TfArray<1, float> quant52_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant52_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant52 = { (TfLiteFloatArray*)&quant52_scale, (TfLiteIntArray*)&quant52_zero, 0 };
const TfArray<4, int> tensor_dimension53 = { 4, { 1,24,24,8 } };
const TfArray<1, float> quant53_scale = { 1, { 0.44756165146827698, } };
const TfArray<1, int> quant53_zero = { 1, { 3 } };
const TfLiteAffineQuantization quant53 = { (TfLiteFloatArray*)&quant53_scale, (TfLiteIntArray*)&quant53_zero, 0 };
const TfArray<4, int> tensor_dimension54 = { 4, { 1,24,24,8 } };
const TfArray<1, float> quant54_scale = { 1, { 0.5985221266746521, } };
const TfArray<1, int> quant54_zero = { 1, { -4 } };
const TfLiteAffineQuantization quant54 = { (TfLiteFloatArray*)&quant54_scale, (TfLiteIntArray*)&quant54_zero, 0 };
const TfArray<4, int> tensor_dimension55 = { 4, { 1,24,24,48 } };
const TfArray<1, float> quant55_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant55_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant55 = { (TfLiteFloatArray*)&quant55_scale, (TfLiteIntArray*)&quant55_zero, 0 };
const TfArray<4, int> tensor_dimension56 = { 4, { 1,25,25,48 } };
const TfArray<1, float> quant56_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant56_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant56 = { (TfLiteFloatArray*)&quant56_scale, (TfLiteIntArray*)&quant56_zero, 0 };
const TfArray<4, int> tensor_dimension57 = { 4, { 1,12,12,48 } };
const TfArray<1, float> quant57_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant57_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant57 = { (TfLiteFloatArray*)&quant57_scale, (TfLiteIntArray*)&quant57_zero, 0 };
const TfArray<4, int> tensor_dimension58 = { 4, { 1,12,12,16 } };
const TfArray<1, float> quant58_scale = { 1, { 0.29176947474479675, } };
const TfArray<1, int> quant58_zero = { 1, { 19 } };
const TfLiteAffineQuantization quant58 = { (TfLiteFloatArray*)&quant58_scale, (TfLiteIntArray*)&quant58_zero, 0 };
const TfArray<4, int> tensor_dimension59 = { 4, { 1,12,12,96 } };
const TfArray<1, float> quant59_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant59_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant59 = { (TfLiteFloatArray*)&quant59_scale, (TfLiteIntArray*)&quant59_zero, 0 };
const TfArray<4, int> tensor_dimension60 = { 4, { 1,12,12,96 } };
const TfArray<1, float> quant60_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant60_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant60 = { (TfLiteFloatArray*)&quant60_scale, (TfLiteIntArray*)&quant60_zero, 0 };
const TfArray<4, int> tensor_dimension61 = { 4, { 1,12,12,16 } };
const TfArray<1, float> quant61_scale = { 1, { 0.22182375192642212, } };
const TfArray<1, int> quant61_zero = { 1, { -25 } };
const TfLiteAffineQuantization quant61 = { (TfLiteFloatArray*)&quant61_scale, (TfLiteIntArray*)&quant61_zero, 0 };
const TfArray<4, int> tensor_dimension62 = { 4, { 1,12,12,16 } };
const TfArray<1, float> quant62_scale = { 1, { 0.30125716328620911, } };
const TfArray<1, int> quant62_zero = { 1, { 11 } };
const TfLiteAffineQuantization quant62 = { (TfLiteFloatArray*)&quant62_scale, (TfLiteIntArray*)&quant62_zero, 0 };
const TfArray<4, int> tensor_dimension63 = { 4, { 1,12,12,96 } };
const TfArray<1, float> quant63_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant63_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant63 = { (TfLiteFloatArray*)&quant63_scale, (TfLiteIntArray*)&quant63_zero, 0 };
const TfArray<4, int> tensor_dimension64 = { 4, { 1,12,12,96 } };
const TfArray<1, float> quant64_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant64_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant64 = { (TfLiteFloatArray*)&quant64_scale, (TfLiteIntArray*)&quant64_zero, 0 };
const TfArray<4, int> tensor_dimension65 = { 4, { 1,12,12,16 } };
const TfArray<1, float> quant65_scale = { 1, { 0.25893041491508484, } };
const TfArray<1, int> quant65_zero = { 1, { 25 } };
const TfLiteAffineQuantization quant65 = { (TfLiteFloatArray*)&quant65_scale, (TfLiteIntArray*)&quant65_zero, 0 };
const TfArray<4, int> tensor_dimension66 = { 4, { 1,12,12,16 } };
const TfArray<1, float> quant66_scale = { 1, { 0.3775060772895813, } };
const TfArray<1, int> quant66_zero = { 1, { 24 } };
const TfLiteAffineQuantization quant66 = { (TfLiteFloatArray*)&quant66_scale, (TfLiteIntArray*)&quant66_zero, 0 };
const TfArray<4, int> tensor_dimension67 = { 4, { 1,12,12,96 } };
const TfArray<1, float> quant67_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant67_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant67 = { (TfLiteFloatArray*)&quant67_scale, (TfLiteIntArray*)&quant67_zero, 0 };
const TfArray<4, int> tensor_dimension68 = { 4, { 1,12,12,32 } };
const TfArray<1, float> quant68_scale = { 1, { 0.043550599366426468, } };
const TfArray<1, int> quant68_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant68 = { (TfLiteFloatArray*)&quant68_scale, (TfLiteIntArray*)&quant68_zero, 0 };
const TfArray<4, int> tensor_dimension69 = { 4, { 1,12,12,4 } };
const TfArray<1, float> quant69_scale = { 1, { 0.10496486723423004, } };
const TfArray<1, int> quant69_zero = { 1, { 13 } };
const TfLiteAffineQuantization quant69 = { (TfLiteFloatArray*)&quant69_scale, (TfLiteIntArray*)&quant69_zero, 0 };
const TfArray<4, int> tensor_dimension70 = { 4, { 1,12,12,4 } };
const TfArray<1, float> quant70_scale = { 1, { 0.00390625, } };
const TfArray<1, int> quant70_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant70 = { (TfLiteFloatArray*)&quant70_scale, (TfLiteIntArray*)&quant70_zero, 0 };
const TfLiteConvParams opdata0 = { kTfLitePaddingSame, 2,2, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs0 = { 3, { 0,2,3 } };
const TfArray<1, int> outputs0 = { 1, { 44 } };
const TfLiteDepthwiseConvParams opdata1 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs1 = { 3, { 44,4,5 } };
const TfArray<1, int> outputs1 = { 1, { 45 } };
const TfLiteConvParams opdata2 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs2 = { 3, { 45,6,7 } };
const TfArray<1, int> outputs2 = { 1, { 46 } };
const TfLiteConvParams opdata3 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs3 = { 3, { 46,8,9 } };
const TfArray<1, int> outputs3 = { 1, { 47 } };
const TfArray<2, int> inputs4 = { 2, { 47,1 } };
const TfArray<1, int> outputs4 = { 1, { 48 } };
const TfLiteDepthwiseConvParams opdata5 = { kTfLitePaddingValid, 2,2, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs5 = { 3, { 48,10,11 } };
const TfArray<1, int> outputs5 = { 1, { 49 } };
const TfLiteConvParams opdata6 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs6 = { 3, { 49,12,13 } };
const TfArray<1, int> outputs6 = { 1, { 50 } };
const TfLiteConvParams opdata7 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs7 = { 3, { 50,14,15 } };
const TfArray<1, int> outputs7 = { 1, { 51 } };
const TfLiteDepthwiseConvParams opdata8 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs8 = { 3, { 51,16,17 } };
const TfArray<1, int> outputs8 = { 1, { 52 } };
const TfLiteConvParams opdata9 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs9 = { 3, { 52,18,19 } };
const TfArray<1, int> outputs9 = { 1, { 53 } };
const TfLiteAddParams opdata10 = { kTfLiteActNone };
const TfArray<2, int> inputs10 = { 2, { 50,53 } };
const TfArray<1, int> outputs10 = { 1, { 54 } };
const TfLiteConvParams opdata11 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs11 = { 3, { 54,20,21 } };
const TfArray<1, int> outputs11 = { 1, { 55 } };
const TfArray<2, int> inputs12 = { 2, { 55,1 } };
const TfArray<1, int> outputs12 = { 1, { 56 } };
const TfLiteDepthwiseConvParams opdata13 = { kTfLitePaddingValid, 2,2, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs13 = { 3, { 56,22,23 } };
const TfArray<1, int> outputs13 = { 1, { 57 } };
const TfLiteConvParams opdata14 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs14 = { 3, { 57,24,25 } };
const TfArray<1, int> outputs14 = { 1, { 58 } };
const TfLiteConvParams opdata15 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs15 = { 3, { 58,26,27 } };
const TfArray<1, int> outputs15 = { 1, { 59 } };
const TfLiteDepthwiseConvParams opdata16 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs16 = { 3, { 59,28,29 } };
const TfArray<1, int> outputs16 = { 1, { 60 } };
const TfLiteConvParams opdata17 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs17 = { 3, { 60,30,31 } };
const TfArray<1, int> outputs17 = { 1, { 61 } };
const TfLiteAddParams opdata18 = { kTfLiteActNone };
const TfArray<2, int> inputs18 = { 2, { 58,61 } };
const TfArray<1, int> outputs18 = { 1, { 62 } };
const TfLiteConvParams opdata19 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs19 = { 3, { 62,32,33 } };
const TfArray<1, int> outputs19 = { 1, { 63 } };
const TfLiteDepthwiseConvParams opdata20 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs20 = { 3, { 63,34,35 } };
const TfArray<1, int> outputs20 = { 1, { 64 } };
const TfLiteConvParams opdata21 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs21 = { 3, { 64,36,37 } };
const TfArray<1, int> outputs21 = { 1, { 65 } };
const TfLiteAddParams opdata22 = { kTfLiteActNone };
const TfArray<2, int> inputs22 = { 2, { 62,65 } };
const TfArray<1, int> outputs22 = { 1, { 66 } };
const TfLiteConvParams opdata23 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs23 = { 3, { 66,38,39 } };
const TfArray<1, int> outputs23 = { 1, { 67 } };
const TfLiteConvParams opdata24 = { kTfLitePaddingValid, 1,1, kTfLiteActRelu, 1,1 };
const TfArray<3, int> inputs24 = { 3, { 67,40,41 } };
const TfArray<1, int> outputs24 = { 1, { 68 } };
const TfLiteConvParams opdata25 = { kTfLitePaddingValid, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs25 = { 3, { 68,42,43 } };
const TfArray<1, int> outputs25 = { 1, { 69 } };
const TfLiteSoftmaxParams opdata26 = { 1 };
const TfArray<1, int> inputs26 = { 1, { 69 } };
const TfArray<1, int> outputs26 = { 1, { 70 } };
const TensorInfo_t tensorData[] = {
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension0, 27648, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant0))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data1, (TfLiteIntArray*)&tensor_dimension1, 32, {kTfLiteNoQuantization, nullptr}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data2, (TfLiteIntArray*)&tensor_dimension2, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant2))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data3, (TfLiteIntArray*)&tensor_dimension3, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant3))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data4, (TfLiteIntArray*)&tensor_dimension4, 144, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant4))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data5, (TfLiteIntArray*)&tensor_dimension5, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant5))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data6, (TfLiteIntArray*)&tensor_dimension6, 128, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant6))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data7, (TfLiteIntArray*)&tensor_dimension7, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant7))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data8, (TfLiteIntArray*)&tensor_dimension8, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant8))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data9, (TfLiteIntArray*)&tensor_dimension9, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant9))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data10, (TfLiteIntArray*)&tensor_dimension10, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant10))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data11, (TfLiteIntArray*)&tensor_dimension11, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant11))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data12, (TfLiteIntArray*)&tensor_dimension12, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant12))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data13, (TfLiteIntArray*)&tensor_dimension13, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant13))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data14, (TfLiteIntArray*)&tensor_dimension14, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant14))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data15, (TfLiteIntArray*)&tensor_dimension15, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant15))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data16, (TfLiteIntArray*)&tensor_dimension16, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant16))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data17, (TfLiteIntArray*)&tensor_dimension17, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant17))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data18, (TfLiteIntArray*)&tensor_dimension18, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant18))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data19, (TfLiteIntArray*)&tensor_dimension19, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant19))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data20, (TfLiteIntArray*)&tensor_dimension20, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant20))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data21, (TfLiteIntArray*)&tensor_dimension21, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant21))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data22, (TfLiteIntArray*)&tensor_dimension22, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant22))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data23, (TfLiteIntArray*)&tensor_dimension23, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant23))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data24, (TfLiteIntArray*)&tensor_dimension24, 768, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant24))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data25, (TfLiteIntArray*)&tensor_dimension25, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant25))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data26, (TfLiteIntArray*)&tensor_dimension26, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant26))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data27, (TfLiteIntArray*)&tensor_dimension27, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant27))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data28, (TfLiteIntArray*)&tensor_dimension28, 864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant28))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data29, (TfLiteIntArray*)&tensor_dimension29, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant29))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data30, (TfLiteIntArray*)&tensor_dimension30, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant30))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data31, (TfLiteIntArray*)&tensor_dimension31, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant31))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data32, (TfLiteIntArray*)&tensor_dimension32, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant32))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data33, (TfLiteIntArray*)&tensor_dimension33, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant33))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data34, (TfLiteIntArray*)&tensor_dimension34, 864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant34))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data35, (TfLiteIntArray*)&tensor_dimension35, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant35))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data36, (TfLiteIntArray*)&tensor_dimension36, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant36))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data37, (TfLiteIntArray*)&tensor_dimension37, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant37))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data38, (TfLiteIntArray*)&tensor_dimension38, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant38))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data39, (TfLiteIntArray*)&tensor_dimension39, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant39))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data40, (TfLiteIntArray*)&tensor_dimension40, 3072, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant40))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data41, (TfLiteIntArray*)&tensor_dimension41, 128, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant41))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data42, (TfLiteIntArray*)&tensor_dimension42, 128, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant42))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data43, (TfLiteIntArray*)&tensor_dimension43, 16, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant43))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 36864, (TfLiteIntArray*)&tensor_dimension44, 36864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant44))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension45, 36864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant45))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 36864, (TfLiteIntArray*)&tensor_dimension46, 18432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant46))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 115248, (TfLiteIntArray*)&tensor_dimension47, 110592, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant47))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension48, 115248, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant48))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 115248, (TfLiteIntArray*)&tensor_dimension49, 27648, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant49))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 55296, (TfLiteIntArray*)&tensor_dimension50, 4608, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant50))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 27648, (TfLiteIntArray*)&tensor_dimension51, 27648, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant51))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension52, 27648, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant52))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 27648, (TfLiteIntArray*)&tensor_dimension53, 4608, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant53))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension54, 4608, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant54))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 30000, (TfLiteIntArray*)&tensor_dimension55, 27648, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant55))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension56, 30000, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant56))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 30000, (TfLiteIntArray*)&tensor_dimension57, 6912, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant57))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 36912, (TfLiteIntArray*)&tensor_dimension58, 2304, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant58))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 13824, (TfLiteIntArray*)&tensor_dimension59, 13824, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant59))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension60, 13824, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant60))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 13824, (TfLiteIntArray*)&tensor_dimension61, 2304, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant61))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 27648, (TfLiteIntArray*)&tensor_dimension62, 2304, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant62))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 13824, (TfLiteIntArray*)&tensor_dimension63, 13824, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant63))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension64, 13824, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant64))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 16128, (TfLiteIntArray*)&tensor_dimension65, 2304, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant65))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 13824, (TfLiteIntArray*)&tensor_dimension66, 2304, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant66))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension67, 13824, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant67))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 13824, (TfLiteIntArray*)&tensor_dimension68, 4608, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant68))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 576, (TfLiteIntArray*)&tensor_dimension69, 576, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant69))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension70, 576, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant70))}, },
};const NodeInfo_t nodeData[] = {
  { (TfLiteIntArray*)&inputs0, (TfLiteIntArray*)&outputs0, const_cast<void*>(static_cast<const void*>(&opdata0)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs1, (TfLiteIntArray*)&outputs1, const_cast<void*>(static_cast<const void*>(&opdata1)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs2, (TfLiteIntArray*)&outputs2, const_cast<void*>(static_cast<const void*>(&opdata2)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs3, (TfLiteIntArray*)&outputs3, const_cast<void*>(static_cast<const void*>(&opdata3)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs4, (TfLiteIntArray*)&outputs4, nullptr, OP_PAD, },
  { (TfLiteIntArray*)&inputs5, (TfLiteIntArray*)&outputs5, const_cast<void*>(static_cast<const void*>(&opdata5)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs6, (TfLiteIntArray*)&outputs6, const_cast<void*>(static_cast<const void*>(&opdata6)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs7, (TfLiteIntArray*)&outputs7, const_cast<void*>(static_cast<const void*>(&opdata7)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs8, (TfLiteIntArray*)&outputs8, const_cast<void*>(static_cast<const void*>(&opdata8)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs9, (TfLiteIntArray*)&outputs9, const_cast<void*>(static_cast<const void*>(&opdata9)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs10, (TfLiteIntArray*)&outputs10, const_cast<void*>(static_cast<const void*>(&opdata10)), OP_ADD, },
  { (TfLiteIntArray*)&inputs11, (TfLiteIntArray*)&outputs11, const_cast<void*>(static_cast<const void*>(&opdata11)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs12, (TfLiteIntArray*)&outputs12, nullptr, OP_PAD, },
  { (TfLiteIntArray*)&inputs13, (TfLiteIntArray*)&outputs13, const_cast<void*>(static_cast<const void*>(&opdata13)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs14, (TfLiteIntArray*)&outputs14, const_cast<void*>(static_cast<const void*>(&opdata14)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs15, (TfLiteIntArray*)&outputs15, const_cast<void*>(static_cast<const void*>(&opdata15)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs16, (TfLiteIntArray*)&outputs16, const_cast<void*>(static_cast<const void*>(&opdata16)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs17, (TfLiteIntArray*)&outputs17, const_cast<void*>(static_cast<const void*>(&opdata17)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs18, (TfLiteIntArray*)&outputs18, const_cast<void*>(static_cast<const void*>(&opdata18)), OP_ADD, },
  { (TfLiteIntArray*)&inputs19, (TfLiteIntArray*)&outputs19, const_cast<void*>(static_cast<const void*>(&opdata19)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs20, (TfLiteIntArray*)&outputs20, const_cast<void*>(static_cast<const void*>(&opdata20)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs21, (TfLiteIntArray*)&outputs21, const_cast<void*>(static_cast<const void*>(&opdata21)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs22, (TfLiteIntArray*)&outputs22, const_cast<void*>(static_cast<const void*>(&opdata22)), OP_ADD, },
  { (TfLiteIntArray*)&inputs23, (TfLiteIntArray*)&outputs23, const_cast<void*>(static_cast<const void*>(&opdata23)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs24, (TfLiteIntArray*)&outputs24, const_cast<void*>(static_cast<const void*>(&opdata24)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs25, (TfLiteIntArray*)&outputs25, const_cast<void*>(static_cast<const void*>(&opdata25)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs26, (TfLiteIntArray*)&outputs26, const_cast<void*>(static_cast<const void*>(&opdata26)), OP_SOFTMAX, },
};
static void* overflow_buffers[EI_MAX_OVERFLOW_BUFFER_COUNT];
static size_t overflow_buffers_ix = 0;
static void * AllocatePersistentBuffer(struct TfLiteContext* ctx,
                                       size_t bytes) {
  void *ptr;
  if (current_location - bytes < tensor_boundary) {
    if (overflow_buffers_ix > EI_MAX_OVERFLOW_BUFFER_COUNT - 1) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d, does not fit in tensor arena and reached EI_MAX_OVERFLOW_BUFFER_COUNT\n",
        (int)bytes);
      return NULL;
    }

    // OK, this will look super weird, but.... we have CMSIS-NN buffers which
    // we cannot calculate beforehand easily.
    ptr = ei_calloc(bytes, 1);
    if (ptr == NULL) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d\n", (int)bytes);
      return NULL;
    }
    overflow_buffers[overflow_buffers_ix++] = ptr;
    return ptr;
  }

  current_location -= bytes;

  ptr = current_location;
  memset(ptr, 0, bytes);

  return ptr;
}
typedef struct {
  size_t bytes;
  void *ptr;
} scratch_buffer_t;
static scratch_buffer_t scratch_buffers[EI_MAX_SCRATCH_BUFFER_COUNT];
static size_t scratch_buffers_ix = 0;

static TfLiteStatus RequestScratchBufferInArena(struct TfLiteContext* ctx, size_t bytes,
                                                int* buffer_idx) {
  if (scratch_buffers_ix > EI_MAX_SCRATCH_BUFFER_COUNT - 1) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d, reached EI_MAX_SCRATCH_BUFFER_COUNT\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffer_t b;
  b.bytes = bytes;

  b.ptr = AllocatePersistentBuffer(ctx, b.bytes);
  if (!b.ptr) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffers[scratch_buffers_ix] = b;
  *buffer_idx = scratch_buffers_ix;

  scratch_buffers_ix++;

  return kTfLiteOk;
}

static void* GetScratchBuffer(struct TfLiteContext* ctx, int buffer_idx) {
  if (buffer_idx > (int)scratch_buffers_ix) {
    return NULL;
  }
  return scratch_buffers[buffer_idx].ptr;
}

static TfLiteTensor* GetTensor(const struct TfLiteContext* context,
                               int tensor_idx) {
  return &tflTensors[tensor_idx];
}

static TfLiteEvalTensor* GetEvalTensor(const struct TfLiteContext* context,
                                       int tensor_idx) {
  return &tflEvalTensors[tensor_idx];
}

} // namespace

TfLiteStatus trained_model_init( void*(*alloc_fnc)(size_t,size_t) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  tensor_arena = (uint8_t*) alloc_fnc(16, kTensorArenaSize);
  if (!tensor_arena) {
    ei_printf("ERR: failed to allocate tensor arena\n");
    return kTfLiteError;
  }
#else
  memset(tensor_arena, 0, kTensorArenaSize);
#endif
  tensor_boundary = tensor_arena;
  current_location = tensor_arena + kTensorArenaSize;
  ctx.AllocatePersistentBuffer = &AllocatePersistentBuffer;
  ctx.RequestScratchBufferInArena = &RequestScratchBufferInArena;
  ctx.GetScratchBuffer = &GetScratchBuffer;
  ctx.GetTensor = &GetTensor;
  ctx.GetEvalTensor = &GetEvalTensor;
  ctx.tensors = tflTensors;
  ctx.tensors_size = 71;
  for (size_t i = 0; i < 71; ++i) {
    tflTensors[i].type = tensorData[i].type;
    tflEvalTensors[i].type = tensorData[i].type;
    tflTensors[i].is_variable = 0;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
    tflTensors[i].allocation_type = tensorData[i].allocation_type;
#else
    tflTensors[i].allocation_type = (tensor_arena <= tensorData[i].data && tensorData[i].data < tensor_arena + kTensorArenaSize) ? kTfLiteArenaRw : kTfLiteMmapRo;
#endif
    tflTensors[i].bytes = tensorData[i].bytes;
    tflTensors[i].dims = tensorData[i].dims;
    tflEvalTensors[i].dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
    if(tflTensors[i].allocation_type == kTfLiteArenaRw){
      uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

     tflTensors[i].data.data =  start;
     tflEvalTensors[i].data.data =  start;
    }
    else {
       tflTensors[i].data.data = tensorData[i].data;
       tflEvalTensors[i].data.data = tensorData[i].data;
    }
#else
    tflTensors[i].data.data = tensorData[i].data;
    tflEvalTensors[i].data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
    tflTensors[i].quantization = tensorData[i].quantization;
    if (tflTensors[i].quantization.type == kTfLiteAffineQuantization) {
      TfLiteAffineQuantization const* quant = ((TfLiteAffineQuantization const*)(tensorData[i].quantization.params));
      tflTensors[i].params.scale = quant->scale->data[0];
      tflTensors[i].params.zero_point = quant->zero_point->data[0];
    }
    if (tflTensors[i].allocation_type == kTfLiteArenaRw) {
      auto data_end_ptr = (uint8_t*)tflTensors[i].data.data + tensorData[i].bytes;
      if (data_end_ptr > tensor_boundary) {
        tensor_boundary = data_end_ptr;
      }
    }
  }
  if (tensor_boundary > current_location /* end of arena size */) {
    ei_printf("ERR: tensor arena is too small, does not fit model - even without scratch buffers\n");
    return kTfLiteError;
  }
  registrations[OP_CONV_2D] = Register_CONV_2D();
  registrations[OP_DEPTHWISE_CONV_2D] = Register_DEPTHWISE_CONV_2D();
  registrations[OP_PAD] = Register_PAD();
  registrations[OP_ADD] = Register_ADD();
  registrations[OP_SOFTMAX] = Register_SOFTMAX();

  for (size_t i = 0; i < 27; ++i) {
    tflNodes[i].inputs = nodeData[i].inputs;
    tflNodes[i].outputs = nodeData[i].outputs;
    tflNodes[i].builtin_data = nodeData[i].builtin_data;
tflNodes[i].custom_initial_data = nullptr;
      tflNodes[i].custom_initial_data_size = 0;
if (registrations[nodeData[i].used_op_index].init) {
      tflNodes[i].user_data = registrations[nodeData[i].used_op_index].init(&ctx, (const char*)tflNodes[i].builtin_data, 0);
    }
  }
  for (size_t i = 0; i < 27; ++i) {
    if (registrations[nodeData[i].used_op_index].prepare) {
      TfLiteStatus status = registrations[nodeData[i].used_op_index].prepare(&ctx, &tflNodes[i]);
      if (status != kTfLiteOk) {
        return status;
      }
    }
  }
  return kTfLiteOk;
}

static const int inTensorIndices[] = {
  0, 
};
TfLiteTensor* trained_model_input(int index) {
  return &ctx.tensors[inTensorIndices[index]];
}

static const int outTensorIndices[] = {
  70, 
};
TfLiteTensor* trained_model_output(int index) {
  return &ctx.tensors[outTensorIndices[index]];
}

TfLiteStatus trained_model_invoke() {
  for (size_t i = 0; i < 27; ++i) {
    TfLiteStatus status = registrations[nodeData[i].used_op_index].invoke(&ctx, &tflNodes[i]);

#if EI_CLASSIFIER_PRINT_STATE
    ei_printf("layer %lu\n", i);
    ei_printf("    inputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].inputs->size; ix++) {
      auto d = tensorData[tflNodes[i].inputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");

    ei_printf("    outputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].outputs->size; ix++) {
      auto d = tensorData[tflNodes[i].outputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");
#endif // EI_CLASSIFIER_PRINT_STATE

    if (status != kTfLiteOk) {
      return status;
    }
  }
  return kTfLiteOk;
}

TfLiteStatus trained_model_reset( void (*free_fnc)(void* ptr) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  free_fnc(tensor_arena);
#endif

  // scratch buffers are allocated within the arena, so just reset the counter so memory can be reused
  scratch_buffers_ix = 0;

  // overflow buffers are on the heap, so free them first
  for (size_t ix = 0; ix < overflow_buffers_ix; ix++) {
    ei_free(overflow_buffers[ix]);
  }
  overflow_buffers_ix = 0;
  return kTfLiteOk;
}
