/*
 * Copyright (c) 2019-2021 Arm Limited. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef ETHOSU55_INTERFACE_H
#define ETHOSU55_INTERFACE_H

#ifdef __KERNEL__
#include <linux/types.h>
#else
#include <stdint.h>
#endif

#if !defined(__cplusplus) || __cplusplus < 201402L
#define CONSTEXPR
#else
#define CONSTEXPR constexpr
#endif

#ifndef __cplusplus
#define STRUCT struct
#else
#define STRUCT
#include <stdexcept>
#endif

#define NNX_ARCH_VERSION_MAJOR 1
#define NNX_ARCH_VERSION_MINOR 0
#define NNX_ARCH_VERSION_PATCH 6

// Register offsets

//
// Register subpage BASE
//
#define NPU_REG_ID 0x0000
#define NPU_REG_STATUS 0x0004
#define NPU_REG_CMD 0x0008
#define NPU_REG_RESET 0x000C
#define NPU_REG_QBASE0 0x0010
#define NPU_REG_QBASE1 0x0014
#define NPU_REG_QREAD 0x0018
#define NPU_REG_QCONFIG 0x001C
#define NPU_REG_QSIZE 0x0020
#define NPU_REG_PROT 0x0024
#define NPU_REG_CONFIG 0x0028
#define NPU_REG_LOCK 0x002C
#define NPU_REG_REGIONCFG 0x003C
#define NPU_REG_AXI_LIMIT0 0x0040
#define NPU_REG_AXI_LIMIT1 0x0044
#define NPU_REG_AXI_LIMIT2 0x0048
#define NPU_REG_AXI_LIMIT3 0x004C
#define BASE_REGISTERS_SIZE 0x0050

//
// Register subpage BASE_POINTERS
//
#define NPU_REG_BASEP0 0x0080
#define NPU_REG_BASEP1 0x0084
#define NPU_REG_BASEP2 0x0088
#define NPU_REG_BASEP3 0x008C
#define NPU_REG_BASEP4 0x0090
#define NPU_REG_BASEP5 0x0094
#define NPU_REG_BASEP6 0x0098
#define NPU_REG_BASEP7 0x009C
#define NPU_REG_BASEP8 0x00A0
#define NPU_REG_BASEP9 0x00A4
#define NPU_REG_BASEP10 0x00A8
#define NPU_REG_BASEP11 0x00AC
#define NPU_REG_BASEP12 0x00B0
#define NPU_REG_BASEP13 0x00B4
#define NPU_REG_BASEP14 0x00B8
#define NPU_REG_BASEP15 0x00BC
#define BASE_POINTERS_REGISTERS_SIZE 0x00C0

//
// Register subpage DEBUG
//
#define NPU_REG_WD_STATUS 0x0100
#define NPU_REG_MAC_STATUS 0x0104
#define NPU_REG_AO_STATUS 0x0108
#define NPU_REG_DMA_STATUS0 0x0110
#define NPU_REG_DMA_STATUS1 0x0114
#define NPU_REG_CLKFORCE 0x0140
#define NPU_REG_DEBUG_ADDRESS 0x0144
#define NPU_REG_DEBUG_MISC 0x0148
#define NPU_REG_DEBUGCORE 0x014C
#define NPU_REG_DEBUG_BLOCK 0x0150
#define DEBUG_REGISTERS_SIZE 0x0154

//
// Register subpage ID
//
#define NPU_REG_REVISION 0x0FC0
#define NPU_REG_PID4 0x0FD0
#define NPU_REG_PID5 0x0FD4
#define NPU_REG_PID6 0x0FD8
#define NPU_REG_PID7 0x0FDC
#define NPU_REG_PID0 0x0FE0
#define NPU_REG_PID1 0x0FE4
#define NPU_REG_PID2 0x0FE8
#define NPU_REG_PID3 0x0FEC
#define NPU_REG_CID0 0x0FF0
#define NPU_REG_CID1 0x0FF4
#define NPU_REG_CID2 0x0FF8
#define NPU_REG_CID3 0x0FFC
#define ID_REGISTERS_SIZE 0x1000

//
// Register subpage PMU
//
#define NPU_REG_PMCR 0x0180
#define NPU_REG_PMCNTENSET 0x0184
#define NPU_REG_PMCNTENCLR 0x0188
#define NPU_REG_PMOVSSET 0x018C
#define NPU_REG_PMOVSCLR 0x0190
#define NPU_REG_PMINTSET 0x0194
#define NPU_REG_PMINTCLR 0x0198
#define NPU_REG_PMCCNTR_LO 0x01A0
#define NPU_REG_PMCCNTR_HI 0x01A4
#define NPU_REG_PMCCNTR_CFG 0x01A8
#define NPU_REG_PMCAXI_CHAN 0x01AC
#define NPU_REG_PMEVCNTR0 0x0300
#define NPU_REG_PMEVCNTR1 0x0304
#define NPU_REG_PMEVCNTR2 0x0308
#define NPU_REG_PMEVCNTR3 0x030C
#define NPU_REG_PMEVTYPER0 0x0380
#define NPU_REG_PMEVTYPER1 0x0384
#define NPU_REG_PMEVTYPER2 0x0388
#define NPU_REG_PMEVTYPER3 0x038C
#define PMU_REGISTERS_SIZE 0x0390

//
// Register subpage SHARED_BUFFER
//
#define NPU_REG_SHARED_BUFFER0 0x0400
#define NPU_REG_SHARED_BUFFER1 0x0404
#define NPU_REG_SHARED_BUFFER2 0x0408
#define NPU_REG_SHARED_BUFFER3 0x040C
#define NPU_REG_SHARED_BUFFER4 0x0410
#define NPU_REG_SHARED_BUFFER5 0x0414
#define NPU_REG_SHARED_BUFFER6 0x0418
#define NPU_REG_SHARED_BUFFER7 0x041C
#define NPU_REG_SHARED_BUFFER8 0x0420
#define NPU_REG_SHARED_BUFFER9 0x0424
#define NPU_REG_SHARED_BUFFER10 0x0428
#define NPU_REG_SHARED_BUFFER11 0x042C
#define NPU_REG_SHARED_BUFFER12 0x0430
#define NPU_REG_SHARED_BUFFER13 0x0434
#define NPU_REG_SHARED_BUFFER14 0x0438
#define NPU_REG_SHARED_BUFFER15 0x043C
#define NPU_REG_SHARED_BUFFER16 0x0440
#define NPU_REG_SHARED_BUFFER17 0x0444
#define NPU_REG_SHARED_BUFFER18 0x0448
#define NPU_REG_SHARED_BUFFER19 0x044C
#define NPU_REG_SHARED_BUFFER20 0x0450
#define NPU_REG_SHARED_BUFFER21 0x0454
#define NPU_REG_SHARED_BUFFER22 0x0458
#define NPU_REG_SHARED_BUFFER23 0x045C
#define NPU_REG_SHARED_BUFFER24 0x0460
#define NPU_REG_SHARED_BUFFER25 0x0464
#define NPU_REG_SHARED_BUFFER26 0x0468
#define NPU_REG_SHARED_BUFFER27 0x046C
#define NPU_REG_SHARED_BUFFER28 0x0470
#define NPU_REG_SHARED_BUFFER29 0x0474
#define NPU_REG_SHARED_BUFFER30 0x0478
#define NPU_REG_SHARED_BUFFER31 0x047C
#define NPU_REG_SHARED_BUFFER32 0x0480
#define NPU_REG_SHARED_BUFFER33 0x0484
#define NPU_REG_SHARED_BUFFER34 0x0488
#define NPU_REG_SHARED_BUFFER35 0x048C
#define NPU_REG_SHARED_BUFFER36 0x0490
#define NPU_REG_SHARED_BUFFER37 0x0494
#define NPU_REG_SHARED_BUFFER38 0x0498
#define NPU_REG_SHARED_BUFFER39 0x049C
#define NPU_REG_SHARED_BUFFER40 0x04A0
#define NPU_REG_SHARED_BUFFER41 0x04A4
#define NPU_REG_SHARED_BUFFER42 0x04A8
#define NPU_REG_SHARED_BUFFER43 0x04AC
#define NPU_REG_SHARED_BUFFER44 0x04B0
#define NPU_REG_SHARED_BUFFER45 0x04B4
#define NPU_REG_SHARED_BUFFER46 0x04B8
#define NPU_REG_SHARED_BUFFER47 0x04BC
#define NPU_REG_SHARED_BUFFER48 0x04C0
#define NPU_REG_SHARED_BUFFER49 0x04C4
#define NPU_REG_SHARED_BUFFER50 0x04C8
#define NPU_REG_SHARED_BUFFER51 0x04CC
#define NPU_REG_SHARED_BUFFER52 0x04D0
#define NPU_REG_SHARED_BUFFER53 0x04D4
#define NPU_REG_SHARED_BUFFER54 0x04D8
#define NPU_REG_SHARED_BUFFER55 0x04DC
#define NPU_REG_SHARED_BUFFER56 0x04E0
#define NPU_REG_SHARED_BUFFER57 0x04E4
#define NPU_REG_SHARED_BUFFER58 0x04E8
#define NPU_REG_SHARED_BUFFER59 0x04EC
#define NPU_REG_SHARED_BUFFER60 0x04F0
#define NPU_REG_SHARED_BUFFER61 0x04F4
#define NPU_REG_SHARED_BUFFER62 0x04F8
#define NPU_REG_SHARED_BUFFER63 0x04FC
#define NPU_REG_SHARED_BUFFER64 0x0500
#define NPU_REG_SHARED_BUFFER65 0x0504
#define NPU_REG_SHARED_BUFFER66 0x0508
#define NPU_REG_SHARED_BUFFER67 0x050C
#define NPU_REG_SHARED_BUFFER68 0x0510
#define NPU_REG_SHARED_BUFFER69 0x0514
#define NPU_REG_SHARED_BUFFER70 0x0518
#define NPU_REG_SHARED_BUFFER71 0x051C
#define NPU_REG_SHARED_BUFFER72 0x0520
#define NPU_REG_SHARED_BUFFER73 0x0524
#define NPU_REG_SHARED_BUFFER74 0x0528
#define NPU_REG_SHARED_BUFFER75 0x052C
#define NPU_REG_SHARED_BUFFER76 0x0530
#define NPU_REG_SHARED_BUFFER77 0x0534
#define NPU_REG_SHARED_BUFFER78 0x0538
#define NPU_REG_SHARED_BUFFER79 0x053C
#define NPU_REG_SHARED_BUFFER80 0x0540
#define NPU_REG_SHARED_BUFFER81 0x0544
#define NPU_REG_SHARED_BUFFER82 0x0548
#define NPU_REG_SHARED_BUFFER83 0x054C
#define NPU_REG_SHARED_BUFFER84 0x0550
#define NPU_REG_SHARED_BUFFER85 0x0554
#define NPU_REG_SHARED_BUFFER86 0x0558
#define NPU_REG_SHARED_BUFFER87 0x055C
#define NPU_REG_SHARED_BUFFER88 0x0560
#define NPU_REG_SHARED_BUFFER89 0x0564
#define NPU_REG_SHARED_BUFFER90 0x0568
#define NPU_REG_SHARED_BUFFER91 0x056C
#define NPU_REG_SHARED_BUFFER92 0x0570
#define NPU_REG_SHARED_BUFFER93 0x0574
#define NPU_REG_SHARED_BUFFER94 0x0578
#define NPU_REG_SHARED_BUFFER95 0x057C
#define NPU_REG_SHARED_BUFFER96 0x0580
#define NPU_REG_SHARED_BUFFER97 0x0584
#define NPU_REG_SHARED_BUFFER98 0x0588
#define NPU_REG_SHARED_BUFFER99 0x058C
#define NPU_REG_SHARED_BUFFER100 0x0590
#define NPU_REG_SHARED_BUFFER101 0x0594
#define NPU_REG_SHARED_BUFFER102 0x0598
#define NPU_REG_SHARED_BUFFER103 0x059C
#define NPU_REG_SHARED_BUFFER104 0x05A0
#define NPU_REG_SHARED_BUFFER105 0x05A4
#define NPU_REG_SHARED_BUFFER106 0x05A8
#define NPU_REG_SHARED_BUFFER107 0x05AC
#define NPU_REG_SHARED_BUFFER108 0x05B0
#define NPU_REG_SHARED_BUFFER109 0x05B4
#define NPU_REG_SHARED_BUFFER110 0x05B8
#define NPU_REG_SHARED_BUFFER111 0x05BC
#define NPU_REG_SHARED_BUFFER112 0x05C0
#define NPU_REG_SHARED_BUFFER113 0x05C4
#define NPU_REG_SHARED_BUFFER114 0x05C8
#define NPU_REG_SHARED_BUFFER115 0x05CC
#define NPU_REG_SHARED_BUFFER116 0x05D0
#define NPU_REG_SHARED_BUFFER117 0x05D4
#define NPU_REG_SHARED_BUFFER118 0x05D8
#define NPU_REG_SHARED_BUFFER119 0x05DC
#define NPU_REG_SHARED_BUFFER120 0x05E0
#define NPU_REG_SHARED_BUFFER121 0x05E4
#define NPU_REG_SHARED_BUFFER122 0x05E8
#define NPU_REG_SHARED_BUFFER123 0x05EC
#define NPU_REG_SHARED_BUFFER124 0x05F0
#define NPU_REG_SHARED_BUFFER125 0x05F4
#define NPU_REG_SHARED_BUFFER126 0x05F8
#define NPU_REG_SHARED_BUFFER127 0x05FC
#define NPU_REG_SHARED_BUFFER128 0x0600
#define NPU_REG_SHARED_BUFFER129 0x0604
#define NPU_REG_SHARED_BUFFER130 0x0608
#define NPU_REG_SHARED_BUFFER131 0x060C
#define NPU_REG_SHARED_BUFFER132 0x0610
#define NPU_REG_SHARED_BUFFER133 0x0614
#define NPU_REG_SHARED_BUFFER134 0x0618
#define NPU_REG_SHARED_BUFFER135 0x061C
#define NPU_REG_SHARED_BUFFER136 0x0620
#define NPU_REG_SHARED_BUFFER137 0x0624
#define NPU_REG_SHARED_BUFFER138 0x0628
#define NPU_REG_SHARED_BUFFER139 0x062C
#define NPU_REG_SHARED_BUFFER140 0x0630
#define NPU_REG_SHARED_BUFFER141 0x0634
#define NPU_REG_SHARED_BUFFER142 0x0638
#define NPU_REG_SHARED_BUFFER143 0x063C
#define NPU_REG_SHARED_BUFFER144 0x0640
#define NPU_REG_SHARED_BUFFER145 0x0644
#define NPU_REG_SHARED_BUFFER146 0x0648
#define NPU_REG_SHARED_BUFFER147 0x064C
#define NPU_REG_SHARED_BUFFER148 0x0650
#define NPU_REG_SHARED_BUFFER149 0x0654
#define NPU_REG_SHARED_BUFFER150 0x0658
#define NPU_REG_SHARED_BUFFER151 0x065C
#define NPU_REG_SHARED_BUFFER152 0x0660
#define NPU_REG_SHARED_BUFFER153 0x0664
#define NPU_REG_SHARED_BUFFER154 0x0668
#define NPU_REG_SHARED_BUFFER155 0x066C
#define NPU_REG_SHARED_BUFFER156 0x0670
#define NPU_REG_SHARED_BUFFER157 0x0674
#define NPU_REG_SHARED_BUFFER158 0x0678
#define NPU_REG_SHARED_BUFFER159 0x067C
#define NPU_REG_SHARED_BUFFER160 0x0680
#define NPU_REG_SHARED_BUFFER161 0x0684
#define NPU_REG_SHARED_BUFFER162 0x0688
#define NPU_REG_SHARED_BUFFER163 0x068C
#define NPU_REG_SHARED_BUFFER164 0x0690
#define NPU_REG_SHARED_BUFFER165 0x0694
#define NPU_REG_SHARED_BUFFER166 0x0698
#define NPU_REG_SHARED_BUFFER167 0x069C
#define NPU_REG_SHARED_BUFFER168 0x06A0
#define NPU_REG_SHARED_BUFFER169 0x06A4
#define NPU_REG_SHARED_BUFFER170 0x06A8
#define NPU_REG_SHARED_BUFFER171 0x06AC
#define NPU_REG_SHARED_BUFFER172 0x06B0
#define NPU_REG_SHARED_BUFFER173 0x06B4
#define NPU_REG_SHARED_BUFFER174 0x06B8
#define NPU_REG_SHARED_BUFFER175 0x06BC
#define NPU_REG_SHARED_BUFFER176 0x06C0
#define NPU_REG_SHARED_BUFFER177 0x06C4
#define NPU_REG_SHARED_BUFFER178 0x06C8
#define NPU_REG_SHARED_BUFFER179 0x06CC
#define NPU_REG_SHARED_BUFFER180 0x06D0
#define NPU_REG_SHARED_BUFFER181 0x06D4
#define NPU_REG_SHARED_BUFFER182 0x06D8
#define NPU_REG_SHARED_BUFFER183 0x06DC
#define NPU_REG_SHARED_BUFFER184 0x06E0
#define NPU_REG_SHARED_BUFFER185 0x06E4
#define NPU_REG_SHARED_BUFFER186 0x06E8
#define NPU_REG_SHARED_BUFFER187 0x06EC
#define NPU_REG_SHARED_BUFFER188 0x06F0
#define NPU_REG_SHARED_BUFFER189 0x06F4
#define NPU_REG_SHARED_BUFFER190 0x06F8
#define NPU_REG_SHARED_BUFFER191 0x06FC
#define NPU_REG_SHARED_BUFFER192 0x0700
#define NPU_REG_SHARED_BUFFER193 0x0704
#define NPU_REG_SHARED_BUFFER194 0x0708
#define NPU_REG_SHARED_BUFFER195 0x070C
#define NPU_REG_SHARED_BUFFER196 0x0710
#define NPU_REG_SHARED_BUFFER197 0x0714
#define NPU_REG_SHARED_BUFFER198 0x0718
#define NPU_REG_SHARED_BUFFER199 0x071C
#define NPU_REG_SHARED_BUFFER200 0x0720
#define NPU_REG_SHARED_BUFFER201 0x0724
#define NPU_REG_SHARED_BUFFER202 0x0728
#define NPU_REG_SHARED_BUFFER203 0x072C
#define NPU_REG_SHARED_BUFFER204 0x0730
#define NPU_REG_SHARED_BUFFER205 0x0734
#define NPU_REG_SHARED_BUFFER206 0x0738
#define NPU_REG_SHARED_BUFFER207 0x073C
#define NPU_REG_SHARED_BUFFER208 0x0740
#define NPU_REG_SHARED_BUFFER209 0x0744
#define NPU_REG_SHARED_BUFFER210 0x0748
#define NPU_REG_SHARED_BUFFER211 0x074C
#define NPU_REG_SHARED_BUFFER212 0x0750
#define NPU_REG_SHARED_BUFFER213 0x0754
#define NPU_REG_SHARED_BUFFER214 0x0758
#define NPU_REG_SHARED_BUFFER215 0x075C
#define NPU_REG_SHARED_BUFFER216 0x0760
#define NPU_REG_SHARED_BUFFER217 0x0764
#define NPU_REG_SHARED_BUFFER218 0x0768
#define NPU_REG_SHARED_BUFFER219 0x076C
#define NPU_REG_SHARED_BUFFER220 0x0770
#define NPU_REG_SHARED_BUFFER221 0x0774
#define NPU_REG_SHARED_BUFFER222 0x0778
#define NPU_REG_SHARED_BUFFER223 0x077C
#define NPU_REG_SHARED_BUFFER224 0x0780
#define NPU_REG_SHARED_BUFFER225 0x0784
#define NPU_REG_SHARED_BUFFER226 0x0788
#define NPU_REG_SHARED_BUFFER227 0x078C
#define NPU_REG_SHARED_BUFFER228 0x0790
#define NPU_REG_SHARED_BUFFER229 0x0794
#define NPU_REG_SHARED_BUFFER230 0x0798
#define NPU_REG_SHARED_BUFFER231 0x079C
#define NPU_REG_SHARED_BUFFER232 0x07A0
#define NPU_REG_SHARED_BUFFER233 0x07A4
#define NPU_REG_SHARED_BUFFER234 0x07A8
#define NPU_REG_SHARED_BUFFER235 0x07AC
#define NPU_REG_SHARED_BUFFER236 0x07B0
#define NPU_REG_SHARED_BUFFER237 0x07B4
#define NPU_REG_SHARED_BUFFER238 0x07B8
#define NPU_REG_SHARED_BUFFER239 0x07BC
#define NPU_REG_SHARED_BUFFER240 0x07C0
#define NPU_REG_SHARED_BUFFER241 0x07C4
#define NPU_REG_SHARED_BUFFER242 0x07C8
#define NPU_REG_SHARED_BUFFER243 0x07CC
#define NPU_REG_SHARED_BUFFER244 0x07D0
#define NPU_REG_SHARED_BUFFER245 0x07D4
#define NPU_REG_SHARED_BUFFER246 0x07D8
#define NPU_REG_SHARED_BUFFER247 0x07DC
#define NPU_REG_SHARED_BUFFER248 0x07E0
#define NPU_REG_SHARED_BUFFER249 0x07E4
#define NPU_REG_SHARED_BUFFER250 0x07E8
#define NPU_REG_SHARED_BUFFER251 0x07EC
#define NPU_REG_SHARED_BUFFER252 0x07F0
#define NPU_REG_SHARED_BUFFER253 0x07F4
#define NPU_REG_SHARED_BUFFER254 0x07F8
#define NPU_REG_SHARED_BUFFER255 0x07FC
#define SHARED_BUFFER_REGISTERS_SIZE 0x0800

//
// Register subpage TSU
//
#define NPU_REG_IFM_PAD_TOP 0x0800
#define NPU_REG_IFM_PAD_LEFT 0x0804
#define NPU_REG_IFM_PAD_RIGHT 0x0808
#define NPU_REG_IFM_PAD_BOTTOM 0x080C
#define NPU_REG_IFM_DEPTH_M1 0x0810
#define NPU_REG_IFM_PRECISION 0x0814
#define NPU_REG_IFM_UPSCALE 0x081C
#define NPU_REG_IFM_ZERO_POINT 0x0824
#define NPU_REG_IFM_WIDTH0_M1 0x0828
#define NPU_REG_IFM_HEIGHT0_M1 0x082C
#define NPU_REG_IFM_HEIGHT1_M1 0x0830
#define NPU_REG_IFM_IB_END 0x0834
#define NPU_REG_IFM_REGION 0x083C
#define NPU_REG_OFM_WIDTH_M1 0x0844
#define NPU_REG_OFM_HEIGHT_M1 0x0848
#define NPU_REG_OFM_DEPTH_M1 0x084C
#define NPU_REG_OFM_PRECISION 0x0850
#define NPU_REG_OFM_BLK_WIDTH_M1 0x0854
#define NPU_REG_OFM_BLK_HEIGHT_M1 0x0858
#define NPU_REG_OFM_BLK_DEPTH_M1 0x085C
#define NPU_REG_OFM_ZERO_POINT 0x0860
#define NPU_REG_OFM_WIDTH0_M1 0x0868
#define NPU_REG_OFM_HEIGHT0_M1 0x086C
#define NPU_REG_OFM_HEIGHT1_M1 0x0870
#define NPU_REG_OFM_REGION 0x087C
#define NPU_REG_KERNEL_WIDTH_M1 0x0880
#define NPU_REG_KERNEL_HEIGHT_M1 0x0884
#define NPU_REG_KERNEL_STRIDE 0x0888
#define NPU_REG_PARALLEL_MODE 0x088C
#define NPU_REG_ACC_FORMAT 0x0890
#define NPU_REG_ACTIVATION 0x0894
#define NPU_REG_ACTIVATION_MIN 0x0898
#define NPU_REG_ACTIVATION_MAX 0x089C
#define NPU_REG_WEIGHT_REGION 0x08A0
#define NPU_REG_SCALE_REGION 0x08A4
#define NPU_REG_AB_START 0x08B4
#define NPU_REG_BLOCKDEP 0x08BC
#define NPU_REG_DMA0_SRC_REGION 0x08C0
#define NPU_REG_DMA0_DST_REGION 0x08C4
#define NPU_REG_DMA0_SIZE0 0x08C8
#define NPU_REG_DMA0_SIZE1 0x08CC
#define NPU_REG_IFM2_BROADCAST 0x0900
#define NPU_REG_IFM2_SCALAR 0x0904
#define NPU_REG_IFM2_PRECISION 0x0914
#define NPU_REG_IFM2_ZERO_POINT 0x0924
#define NPU_REG_IFM2_WIDTH0_M1 0x0928
#define NPU_REG_IFM2_HEIGHT0_M1 0x092C
#define NPU_REG_IFM2_HEIGHT1_M1 0x0930
#define NPU_REG_IFM2_IB_START 0x0934
#define NPU_REG_IFM2_REGION 0x093C
#define NPU_REG_IFM_BASE0 0x0A00
#define NPU_REG_IFM_BASE0_HI 0x0A04
#define NPU_REG_IFM_BASE1 0x0A08
#define NPU_REG_IFM_BASE1_HI 0x0A0C
#define NPU_REG_IFM_BASE2 0x0A10
#define NPU_REG_IFM_BASE2_HI 0x0A14
#define NPU_REG_IFM_BASE3 0x0A18
#define NPU_REG_IFM_BASE3_HI 0x0A1C
#define NPU_REG_IFM_STRIDE_X 0x0A20
#define NPU_REG_IFM_STRIDE_X_HI 0x0A24
#define NPU_REG_IFM_STRIDE_Y 0x0A28
#define NPU_REG_IFM_STRIDE_Y_HI 0x0A2C
#define NPU_REG_IFM_STRIDE_C 0x0A30
#define NPU_REG_IFM_STRIDE_C_HI 0x0A34
#define NPU_REG_OFM_BASE0 0x0A40
#define NPU_REG_OFM_BASE0_HI 0x0A44
#define NPU_REG_OFM_BASE1 0x0A48
#define NPU_REG_OFM_BASE1_HI 0x0A4C
#define NPU_REG_OFM_BASE2 0x0A50
#define NPU_REG_OFM_BASE2_HI 0x0A54
#define NPU_REG_OFM_BASE3 0x0A58
#define NPU_REG_OFM_BASE3_HI 0x0A5C
#define NPU_REG_OFM_STRIDE_X 0x0A60
#define NPU_REG_OFM_STRIDE_X_HI 0x0A64
#define NPU_REG_OFM_STRIDE_Y 0x0A68
#define NPU_REG_OFM_STRIDE_Y_HI 0x0A6C
#define NPU_REG_OFM_STRIDE_C 0x0A70
#define NPU_REG_OFM_STRIDE_C_HI 0x0A74
#define NPU_REG_WEIGHT_BASE 0x0A80
#define NPU_REG_WEIGHT_BASE_HI 0x0A84
#define NPU_REG_WEIGHT_LENGTH 0x0A88
#define NPU_REG_SCALE_BASE 0x0A90
#define NPU_REG_SCALE_BASE_HI 0x0A94
#define NPU_REG_SCALE_LENGTH 0x0A98
#define NPU_REG_OFM_SCALE 0x0AA0
#define NPU_REG_OFM_SCALE_SHIFT 0x0AA4
#define NPU_REG_OPA_SCALE 0x0AA8
#define NPU_REG_OPA_SCALE_SHIFT 0x0AAC
#define NPU_REG_OPB_SCALE 0x0AB0
#define NPU_REG_DMA0_SRC 0x0AC0
#define NPU_REG_DMA0_SRC_HI 0x0AC4
#define NPU_REG_DMA0_DST 0x0AC8
#define NPU_REG_DMA0_DST_HI 0x0ACC
#define NPU_REG_DMA0_LEN 0x0AD0
#define NPU_REG_DMA0_LEN_HI 0x0AD4
#define NPU_REG_DMA0_SKIP0 0x0AD8
#define NPU_REG_DMA0_SKIP0_HI 0x0ADC
#define NPU_REG_DMA0_SKIP1 0x0AE0
#define NPU_REG_DMA0_SKIP1_HI 0x0AE4
#define NPU_REG_IFM2_BASE0 0x0B00
#define NPU_REG_IFM2_BASE0_HI 0x0B04
#define NPU_REG_IFM2_BASE1 0x0B08
#define NPU_REG_IFM2_BASE1_HI 0x0B0C
#define NPU_REG_IFM2_BASE2 0x0B10
#define NPU_REG_IFM2_BASE2_HI 0x0B14
#define NPU_REG_IFM2_BASE3 0x0B18
#define NPU_REG_IFM2_BASE3_HI 0x0B1C
#define NPU_REG_IFM2_STRIDE_X 0x0B20
#define NPU_REG_IFM2_STRIDE_X_HI 0x0B24
#define NPU_REG_IFM2_STRIDE_Y 0x0B28
#define NPU_REG_IFM2_STRIDE_Y_HI 0x0B2C
#define NPU_REG_IFM2_STRIDE_C 0x0B30
#define NPU_REG_IFM2_STRIDE_C_HI 0x0B34
#define NPU_REG_WEIGHT1_BASE 0x0B40
#define NPU_REG_WEIGHT1_BASE_HI 0x0B44
#define NPU_REG_WEIGHT1_LENGTH 0x0B48
#define NPU_REG_SCALE1_BASE 0x0B50
#define NPU_REG_SCALE1_BASE_HI 0x0B54
#define NPU_REG_SCALE1_LENGTH 0x0B58
#define TSU_REGISTERS_SIZE 0x0B5C

//
// Register subpage TSU_DEBUG
//
#define NPU_REG_KERNEL_X 0x0200
#define NPU_REG_KERNEL_Y 0x0204
#define NPU_REG_KERNEL_W_M1 0x0208
#define NPU_REG_KERNEL_H_M1 0x020C
#define NPU_REG_OFM_CBLK_WIDTH_M1 0x0210
#define NPU_REG_OFM_CBLK_HEIGHT_M1 0x0214
#define NPU_REG_OFM_CBLK_DEPTH_M1 0x0218
#define NPU_REG_IFM_CBLK_DEPTH_M1 0x021C
#define NPU_REG_OFM_X 0x0220
#define NPU_REG_OFM_Y 0x0224
#define NPU_REG_OFM_Z 0x0228
#define NPU_REG_IFM_Z 0x022C
#define NPU_REG_PAD_TOP 0x0230
#define NPU_REG_PAD_LEFT 0x0234
#define NPU_REG_IFM_CBLK_WIDTH 0x0238
#define NPU_REG_IFM_CBLK_HEIGHT 0x023C
#define NPU_REG_DMA_IFM_SRC 0x0240
#define NPU_REG_DMA_IFM_SRC_HI 0x0244
#define NPU_REG_DMA_IFM_DST 0x0248
#define NPU_REG_DMA_OFM_SRC 0x024C
#define NPU_REG_DMA_OFM_DST 0x0250
#define NPU_REG_DMA_OFM_DST_HI 0x0254
#define NPU_REG_DMA_WEIGHT_SRC 0x0258
#define NPU_REG_DMA_WEIGHT_SRC_HI 0x025C
#define NPU_REG_DMA_CMD_SRC 0x0260
#define NPU_REG_DMA_CMD_SRC_HI 0x0264
#define NPU_REG_DMA_CMD_SIZE 0x0268
#define NPU_REG_DMA_M2M_SRC 0x026C
#define NPU_REG_DMA_M2M_SRC_HI 0x0270
#define NPU_REG_DMA_M2M_DST 0x0274
#define NPU_REG_DMA_M2M_DST_HI 0x0278
#define NPU_REG_CURRENT_QREAD 0x027C
#define NPU_REG_DMA_SCALE_SRC 0x0280
#define NPU_REG_DMA_SCALE_SRC_HI 0x0284
#define NPU_REG_CURRENT_BLOCK 0x02B4
#define NPU_REG_CURRENT_OP 0x02B8
#define NPU_REG_CURRENT_CMD 0x02BC
#define TSU_DEBUG_REGISTERS_SIZE 0x02C0

#ifdef __cplusplus

// Enum types

enum class acc_format : uint16_t
{
    INT_32BIT = 0,
    INT_40BIT = 1,
    FP_S5_10  = 2,
};

enum class activation : uint16_t
{
    NONE      = 0,
    TANH      = 3,
    SIGMOID   = 4,
    LUT_START = 16,
    LUT_END   = 23,
};

enum class axi_mem_encoding_type : uint8_t
{
    DEVICE_NON_BUFFERABLE                 = 0x0,
    DEVICE_BUFFERABLE                     = 0x1,
    NORMAL_NON_CACHEABLE_NON_BUFFERABLE   = 0x2,
    NORMAL_NON_CACHEABLE_BUFFERABLE       = 0x3,
    WRITE_THROUGH_NO_ALLOCATE             = 0x4,
    WRITE_THROUGH_READ_ALLOCATE           = 0x5,
    WRITE_THROUGH_WRITE_ALLOCATE          = 0x6,
    WRITE_THROUGH_READ_AND_WRITE_ALLOCATE = 0x7,
    WRITE_BACK_NO_ALLOCATE                = 0x8,
    WRITE_BACK_READ_ALLOCATE              = 0x9,
    WRITE_BACK_WRITE_ALLOCATE             = 0xA,
    WRITE_BACK_READ_AND_WRITE_ALLOCATE    = 0xB,
    RESERVED_12                           = 0xC,
    RESERVED_13                           = 0xD,
    RESERVED_14                           = 0xE,
    RESERVED_15                           = 0xF,
};

enum class clip_range : uint8_t
{
    OFM_PRECISION = 0,
    FORCE_UINT8   = 2,
    FORCE_INT8    = 3,
    FORCE_INT16   = 5,
};

enum class cmd0 : uint16_t
{
    NPU_OP_STOP               = 0x000,
    NPU_OP_IRQ                = 0x001,
    NPU_OP_CONV               = 0x002,
    NPU_OP_DEPTHWISE          = 0x003,
    NPU_OP_POOL               = 0x005,
    NPU_OP_ELEMENTWISE        = 0x006,
    NPU_OP_DMA_START          = 0x010,
    NPU_OP_DMA_WAIT           = 0x011,
    NPU_OP_KERNEL_WAIT        = 0x012,
    NPU_OP_PMU_MASK           = 0x013,
    NPU_SET_IFM_PAD_TOP       = 0x100,
    NPU_SET_IFM_PAD_LEFT      = 0x101,
    NPU_SET_IFM_PAD_RIGHT     = 0x102,
    NPU_SET_IFM_PAD_BOTTOM    = 0x103,
    NPU_SET_IFM_DEPTH_M1      = 0x104,
    NPU_SET_IFM_PRECISION     = 0x105,
    NPU_SET_IFM_UPSCALE       = 0x107,
    NPU_SET_IFM_ZERO_POINT    = 0x109,
    NPU_SET_IFM_WIDTH0_M1     = 0x10A,
    NPU_SET_IFM_HEIGHT0_M1    = 0x10B,
    NPU_SET_IFM_HEIGHT1_M1    = 0x10C,
    NPU_SET_IFM_IB_END        = 0x10D,
    NPU_SET_IFM_REGION        = 0x10F,
    NPU_SET_OFM_WIDTH_M1      = 0x111,
    NPU_SET_OFM_HEIGHT_M1     = 0x112,
    NPU_SET_OFM_DEPTH_M1      = 0x113,
    NPU_SET_OFM_PRECISION     = 0x114,
    NPU_SET_OFM_BLK_WIDTH_M1  = 0x115,
    NPU_SET_OFM_BLK_HEIGHT_M1 = 0x116,
    NPU_SET_OFM_BLK_DEPTH_M1  = 0x117,
    NPU_SET_OFM_ZERO_POINT    = 0x118,
    NPU_SET_OFM_WIDTH0_M1     = 0x11A,
    NPU_SET_OFM_HEIGHT0_M1    = 0x11B,
    NPU_SET_OFM_HEIGHT1_M1    = 0x11C,
    NPU_SET_OFM_REGION        = 0x11F,
    NPU_SET_KERNEL_WIDTH_M1   = 0x120,
    NPU_SET_KERNEL_HEIGHT_M1  = 0x121,
    NPU_SET_KERNEL_STRIDE     = 0x122,
    NPU_SET_PARALLEL_MODE     = 0x123,
    NPU_SET_ACC_FORMAT        = 0x124,
    NPU_SET_ACTIVATION        = 0x125,
    NPU_SET_ACTIVATION_MIN    = 0x126,
    NPU_SET_ACTIVATION_MAX    = 0x127,
    NPU_SET_WEIGHT_REGION     = 0x128,
    NPU_SET_SCALE_REGION      = 0x129,
    NPU_SET_AB_START          = 0x12D,
    NPU_SET_BLOCKDEP          = 0x12F,
    NPU_SET_DMA0_SRC_REGION   = 0x130,
    NPU_SET_DMA0_DST_REGION   = 0x131,
    NPU_SET_DMA0_SIZE0        = 0x132,
    NPU_SET_DMA0_SIZE1        = 0x133,
    NPU_SET_IFM2_BROADCAST    = 0x180,
    NPU_SET_IFM2_SCALAR       = 0x181,
    NPU_SET_IFM2_PRECISION    = 0x185,
    NPU_SET_IFM2_ZERO_POINT   = 0x189,
    NPU_SET_IFM2_WIDTH0_M1    = 0x18A,
    NPU_SET_IFM2_HEIGHT0_M1   = 0x18B,
    NPU_SET_IFM2_HEIGHT1_M1   = 0x18C,
    NPU_SET_IFM2_IB_START     = 0x18D,
    NPU_SET_IFM2_REGION       = 0x18F,
};

enum class cmd1 : uint16_t
{
    NPU_SET_IFM_BASE0      = 0x000,
    NPU_SET_IFM_BASE1      = 0x001,
    NPU_SET_IFM_BASE2      = 0x002,
    NPU_SET_IFM_BASE3      = 0x003,
    NPU_SET_IFM_STRIDE_X   = 0x004,
    NPU_SET_IFM_STRIDE_Y   = 0x005,
    NPU_SET_IFM_STRIDE_C   = 0x006,
    NPU_SET_OFM_BASE0      = 0x010,
    NPU_SET_OFM_BASE1      = 0x011,
    NPU_SET_OFM_BASE2      = 0x012,
    NPU_SET_OFM_BASE3      = 0x013,
    NPU_SET_OFM_STRIDE_X   = 0x014,
    NPU_SET_OFM_STRIDE_Y   = 0x015,
    NPU_SET_OFM_STRIDE_C   = 0x016,
    NPU_SET_WEIGHT_BASE    = 0x020,
    NPU_SET_WEIGHT_LENGTH  = 0x021,
    NPU_SET_SCALE_BASE     = 0x022,
    NPU_SET_SCALE_LENGTH   = 0x023,
    NPU_SET_OFM_SCALE      = 0x024,
    NPU_SET_OPA_SCALE      = 0x025,
    NPU_SET_OPB_SCALE      = 0x026,
    NPU_SET_DMA0_SRC       = 0x030,
    NPU_SET_DMA0_DST       = 0x031,
    NPU_SET_DMA0_LEN       = 0x032,
    NPU_SET_DMA0_SKIP0     = 0x033,
    NPU_SET_DMA0_SKIP1     = 0x034,
    NPU_SET_IFM2_BASE0     = 0x080,
    NPU_SET_IFM2_BASE1     = 0x081,
    NPU_SET_IFM2_BASE2     = 0x082,
    NPU_SET_IFM2_BASE3     = 0x083,
    NPU_SET_IFM2_STRIDE_X  = 0x084,
    NPU_SET_IFM2_STRIDE_Y  = 0x085,
    NPU_SET_IFM2_STRIDE_C  = 0x086,
    NPU_SET_WEIGHT1_BASE   = 0x090,
    NPU_SET_WEIGHT1_LENGTH = 0x091,
    NPU_SET_SCALE1_BASE    = 0x092,
    NPU_SET_SCALE1_LENGTH  = 0x093,
};

enum class data_format : uint8_t
{
    NHWC    = 0,
    NHCWB16 = 1,
};

enum class elementwise_mode : uint16_t
{
    MUL   = 0,
    ADD   = 1,
    SUB   = 2,
    MIN   = 3,
    MAX   = 4,
    LRELU = 5,
    ABS   = 6,
    CLZ   = 7,
    SHR   = 8,
    SHL   = 9,
};

enum class ifm_precision : uint8_t
{
    U8  = 0,
    S8  = 1,
    U16 = 4,
    S16 = 5,
    S32 = 9,
};

enum class ifm_scale_mode : uint8_t
{
    SCALE_16BIT     = 0,
    SCALE_OPA_32BIT = 1,
    SCALE_OPB_32BIT = 2,
};

enum class macs_per_cc : uint8_t
{
    MACS_PER_CC_IS_5 = 0x5,
    MACS_PER_CC_IS_6 = 0x6,
    MACS_PER_CC_IS_7 = 0x7,
    MACS_PER_CC_IS_8 = 0x8,
};

enum class memory_type : uint8_t
{
    AXI0_OUTSTANDING_COUNTER0 = 0,
    AXI0_OUTSTANDING_COUNTER1 = 1,
    AXI1_OUTSTANDING_COUNTER2 = 2,
    AXI1_OUTSTANDING_COUNTER3 = 3,
};

enum class ofm_precision : uint8_t
{
    U8  = 0,
    S8  = 1,
    U16 = 2,
    S16 = 3,
    S32 = 5,
};

enum class pmu_event_type : uint16_t
{
    NO_EVENT                     = 0x00,
    CYCLE                        = 0x11,
    NPU_IDLE                     = 0x20,
    CC_STALLED_ON_BLOCKDEP       = 0x21,
    CC_STALLED_ON_SHRAM_RECONFIG = 0x22,
    NPU_ACTIVE                   = 0x23,
    MAC_ACTIVE                   = 0x30,
    MAC_ACTIVE_8BIT              = 0x31,
    MAC_ACTIVE_16BIT             = 0x32,
    MAC_DPU_ACTIVE               = 0x33,
    MAC_STALLED_BY_WD_ACC        = 0x34,
    MAC_STALLED_BY_WD            = 0x35,
    MAC_STALLED_BY_ACC           = 0x36,
    MAC_STALLED_BY_IB            = 0x37,
    MAC_ACTIVE_32BIT             = 0x38,
    MAC_STALLED_BY_INT_W         = 0x39,
    MAC_STALLED_BY_INT_ACC       = 0x3A,
    AO_ACTIVE                    = 0x40,
    AO_ACTIVE_8BIT               = 0x41,
    AO_ACTIVE_16BIT              = 0x42,
    AO_STALLED_BY_OFMP_OB        = 0x43,
    AO_STALLED_BY_OFMP           = 0x44,
    AO_STALLED_BY_OB             = 0x45,
    AO_STALLED_BY_ACC_IB         = 0x46,
    AO_STALLED_BY_ACC            = 0x47,
    AO_STALLED_BY_IB             = 0x48,
    WD_ACTIVE                    = 0x50,
    WD_STALLED                   = 0x51,
    WD_STALLED_BY_WS             = 0x52,
    WD_STALLED_BY_WD_BUF         = 0x53,
    WD_PARSE_ACTIVE              = 0x54,
    WD_PARSE_STALLED             = 0x55,
    WD_PARSE_STALLED_IN          = 0x56,
    WD_PARSE_STALLED_OUT         = 0x57,
    WD_TRANS_WS                  = 0x58,
    WD_TRANS_WB                  = 0x59,
    WD_TRANS_DW0                 = 0x5a,
    WD_TRANS_DW1                 = 0x5b,
    AXI0_RD_TRANS_ACCEPTED       = 0x80,
    AXI0_RD_TRANS_COMPLETED      = 0x81,
    AXI0_RD_DATA_BEAT_RECEIVED   = 0x82,
    AXI0_RD_TRAN_REQ_STALLED     = 0x83,
    AXI0_WR_TRANS_ACCEPTED       = 0x84,
    AXI0_WR_TRANS_COMPLETED_M    = 0x85,
    AXI0_WR_TRANS_COMPLETED_S    = 0x86,
    AXI0_WR_DATA_BEAT_WRITTEN    = 0x87,
    AXI0_WR_TRAN_REQ_STALLED     = 0x88,
    AXI0_WR_DATA_BEAT_STALLED    = 0x89,
    AXI0_ENABLED_CYCLES          = 0x8c,
    AXI0_RD_STALL_LIMIT          = 0x8e,
    AXI0_WR_STALL_LIMIT          = 0x8f,
    AXI1_RD_TRANS_ACCEPTED       = 0x180,
    AXI1_RD_TRANS_COMPLETED      = 0x181,
    AXI1_RD_DATA_BEAT_RECEIVED   = 0x182,
    AXI1_RD_TRAN_REQ_STALLED     = 0x183,
    AXI1_WR_TRANS_ACCEPTED       = 0x184,
    AXI1_WR_TRANS_COMPLETED_M    = 0x185,
    AXI1_WR_TRANS_COMPLETED_S    = 0x186,
    AXI1_WR_DATA_BEAT_WRITTEN    = 0x187,
    AXI1_WR_TRAN_REQ_STALLED     = 0x188,
    AXI1_WR_DATA_BEAT_STALLED    = 0x189,
    AXI1_ENABLED_CYCLES          = 0x18c,
    AXI1_RD_STALL_LIMIT          = 0x18e,
    AXI1_WR_STALL_LIMIT          = 0x18f,
    AXI_LATENCY_ANY              = 0xa0,
    AXI_LATENCY_32               = 0xa1,
    AXI_LATENCY_64               = 0xa2,
    AXI_LATENCY_128              = 0xa3,
    AXI_LATENCY_256              = 0xa4,
    AXI_LATENCY_512              = 0xa5,
    AXI_LATENCY_1024             = 0xa6,
    ECC_DMA                      = 0xb0,
    ECC_SB0                      = 0xb1,
    ECC_SB1                      = 0x1b1,
};

enum class pooling_mode : uint16_t
{
    MAX        = 0,
    AVERAGE    = 1,
    REDUCE_SUM = 2,
};

enum class privilege_level : uint8_t
{
    USER       = 0,
    PRIVILEGED = 1,
};

enum class resampling_mode : uint8_t
{
    NONE      = 0,
    NEAREST   = 1,
    TRANSPOSE = 2,
};

enum class rounding : uint8_t
{
    TFL      = 0,
    TRUNCATE = 1,
    NATURAL  = 2,
};

enum class security_level : uint8_t
{
    SECURE     = 0,
    NON_SECURE = 1,
};

enum class shram_size : uint8_t
{
    SHRAM_96KB = 0x60,
    SHRAM_48KB = 0x30,
    SHRAM_24KB = 0x18,
    SHRAM_16KB = 0x10,
};

enum class state : uint8_t
{
    STOPPED = 0,
    RUNNING = 1,
};

enum class stride_mode : uint8_t
{
    STRIDE_MODE_1D = 0,
    STRIDE_MODE_2D = 1,
    STRIDE_MODE_3D = 2,
};

#else

enum acc_format
{
    ACC_FORMAT_INT_32BIT = 0,
    ACC_FORMAT_INT_40BIT = 1,
    ACC_FORMAT_FP_S5_10  = 2,
};

enum activation
{
    ACTIVATION_NONE      = 0,
    ACTIVATION_TANH      = 3,
    ACTIVATION_SIGMOID   = 4,
    ACTIVATION_LUT_START = 16,
    ACTIVATION_LUT_END   = 23,
};

enum axi_mem_encoding_type
{
    AXI_MEM_ENCODING_TYPE_DEVICE_NON_BUFFERABLE                 = 0x0,
    AXI_MEM_ENCODING_TYPE_DEVICE_BUFFERABLE                     = 0x1,
    AXI_MEM_ENCODING_TYPE_NORMAL_NON_CACHEABLE_NON_BUFFERABLE   = 0x2,
    AXI_MEM_ENCODING_TYPE_NORMAL_NON_CACHEABLE_BUFFERABLE       = 0x3,
    AXI_MEM_ENCODING_TYPE_WRITE_THROUGH_NO_ALLOCATE             = 0x4,
    AXI_MEM_ENCODING_TYPE_WRITE_THROUGH_READ_ALLOCATE           = 0x5,
    AXI_MEM_ENCODING_TYPE_WRITE_THROUGH_WRITE_ALLOCATE          = 0x6,
    AXI_MEM_ENCODING_TYPE_WRITE_THROUGH_READ_AND_WRITE_ALLOCATE = 0x7,
    AXI_MEM_ENCODING_TYPE_WRITE_BACK_NO_ALLOCATE                = 0x8,
    AXI_MEM_ENCODING_TYPE_WRITE_BACK_READ_ALLOCATE              = 0x9,
    AXI_MEM_ENCODING_TYPE_WRITE_BACK_WRITE_ALLOCATE             = 0xA,
    AXI_MEM_ENCODING_TYPE_WRITE_BACK_READ_AND_WRITE_ALLOCATE    = 0xB,
    AXI_MEM_ENCODING_TYPE_RESERVED_12                           = 0xC,
    AXI_MEM_ENCODING_TYPE_RESERVED_13                           = 0xD,
    AXI_MEM_ENCODING_TYPE_RESERVED_14                           = 0xE,
    AXI_MEM_ENCODING_TYPE_RESERVED_15                           = 0xF,
};

enum clip_range
{
    CLIP_RANGE_OFM_PRECISION = 0,
    CLIP_RANGE_FORCE_UINT8   = 2,
    CLIP_RANGE_FORCE_INT8    = 3,
    CLIP_RANGE_FORCE_INT16   = 5,
};

enum cmd0
{
    CMD0_NPU_OP_STOP               = 0x000,
    CMD0_NPU_OP_IRQ                = 0x001,
    CMD0_NPU_OP_CONV               = 0x002,
    CMD0_NPU_OP_DEPTHWISE          = 0x003,
    CMD0_NPU_OP_POOL               = 0x005,
    CMD0_NPU_OP_ELEMENTWISE        = 0x006,
    CMD0_NPU_OP_DMA_START          = 0x010,
    CMD0_NPU_OP_DMA_WAIT           = 0x011,
    CMD0_NPU_OP_KERNEL_WAIT        = 0x012,
    CMD0_NPU_OP_PMU_MASK           = 0x013,
    CMD0_NPU_SET_IFM_PAD_TOP       = 0x100,
    CMD0_NPU_SET_IFM_PAD_LEFT      = 0x101,
    CMD0_NPU_SET_IFM_PAD_RIGHT     = 0x102,
    CMD0_NPU_SET_IFM_PAD_BOTTOM    = 0x103,
    CMD0_NPU_SET_IFM_DEPTH_M1      = 0x104,
    CMD0_NPU_SET_IFM_PRECISION     = 0x105,
    CMD0_NPU_SET_IFM_UPSCALE       = 0x107,
    CMD0_NPU_SET_IFM_ZERO_POINT    = 0x109,
    CMD0_NPU_SET_IFM_WIDTH0_M1     = 0x10A,
    CMD0_NPU_SET_IFM_HEIGHT0_M1    = 0x10B,
    CMD0_NPU_SET_IFM_HEIGHT1_M1    = 0x10C,
    CMD0_NPU_SET_IFM_IB_END        = 0x10D,
    CMD0_NPU_SET_IFM_REGION        = 0x10F,
    CMD0_NPU_SET_OFM_WIDTH_M1      = 0x111,
    CMD0_NPU_SET_OFM_HEIGHT_M1     = 0x112,
    CMD0_NPU_SET_OFM_DEPTH_M1      = 0x113,
    CMD0_NPU_SET_OFM_PRECISION     = 0x114,
    CMD0_NPU_SET_OFM_BLK_WIDTH_M1  = 0x115,
    CMD0_NPU_SET_OFM_BLK_HEIGHT_M1 = 0x116,
    CMD0_NPU_SET_OFM_BLK_DEPTH_M1  = 0x117,
    CMD0_NPU_SET_OFM_ZERO_POINT    = 0x118,
    CMD0_NPU_SET_OFM_WIDTH0_M1     = 0x11A,
    CMD0_NPU_SET_OFM_HEIGHT0_M1    = 0x11B,
    CMD0_NPU_SET_OFM_HEIGHT1_M1    = 0x11C,
    CMD0_NPU_SET_OFM_REGION        = 0x11F,
    CMD0_NPU_SET_KERNEL_WIDTH_M1   = 0x120,
    CMD0_NPU_SET_KERNEL_HEIGHT_M1  = 0x121,
    CMD0_NPU_SET_KERNEL_STRIDE     = 0x122,
    CMD0_NPU_SET_PARALLEL_MODE     = 0x123,
    CMD0_NPU_SET_ACC_FORMAT        = 0x124,
    CMD0_NPU_SET_ACTIVATION        = 0x125,
    CMD0_NPU_SET_ACTIVATION_MIN    = 0x126,
    CMD0_NPU_SET_ACTIVATION_MAX    = 0x127,
    CMD0_NPU_SET_WEIGHT_REGION     = 0x128,
    CMD0_NPU_SET_SCALE_REGION      = 0x129,
    CMD0_NPU_SET_AB_START          = 0x12D,
    CMD0_NPU_SET_BLOCKDEP          = 0x12F,
    CMD0_NPU_SET_DMA0_SRC_REGION   = 0x130,
    CMD0_NPU_SET_DMA0_DST_REGION   = 0x131,
    CMD0_NPU_SET_DMA0_SIZE0        = 0x132,
    CMD0_NPU_SET_DMA0_SIZE1        = 0x133,
    CMD0_NPU_SET_IFM2_BROADCAST    = 0x180,
    CMD0_NPU_SET_IFM2_SCALAR       = 0x181,
    CMD0_NPU_SET_IFM2_PRECISION    = 0x185,
    CMD0_NPU_SET_IFM2_ZERO_POINT   = 0x189,
    CMD0_NPU_SET_IFM2_WIDTH0_M1    = 0x18A,
    CMD0_NPU_SET_IFM2_HEIGHT0_M1   = 0x18B,
    CMD0_NPU_SET_IFM2_HEIGHT1_M1   = 0x18C,
    CMD0_NPU_SET_IFM2_IB_START     = 0x18D,
    CMD0_NPU_SET_IFM2_REGION       = 0x18F,
};

enum cmd1
{
    CMD1_NPU_SET_IFM_BASE0      = 0x000,
    CMD1_NPU_SET_IFM_BASE1      = 0x001,
    CMD1_NPU_SET_IFM_BASE2      = 0x002,
    CMD1_NPU_SET_IFM_BASE3      = 0x003,
    CMD1_NPU_SET_IFM_STRIDE_X   = 0x004,
    CMD1_NPU_SET_IFM_STRIDE_Y   = 0x005,
    CMD1_NPU_SET_IFM_STRIDE_C   = 0x006,
    CMD1_NPU_SET_OFM_BASE0      = 0x010,
    CMD1_NPU_SET_OFM_BASE1      = 0x011,
    CMD1_NPU_SET_OFM_BASE2      = 0x012,
    CMD1_NPU_SET_OFM_BASE3      = 0x013,
    CMD1_NPU_SET_OFM_STRIDE_X   = 0x014,
    CMD1_NPU_SET_OFM_STRIDE_Y   = 0x015,
    CMD1_NPU_SET_OFM_STRIDE_C   = 0x016,
    CMD1_NPU_SET_WEIGHT_BASE    = 0x020,
    CMD1_NPU_SET_WEIGHT_LENGTH  = 0x021,
    CMD1_NPU_SET_SCALE_BASE     = 0x022,
    CMD1_NPU_SET_SCALE_LENGTH   = 0x023,
    CMD1_NPU_SET_OFM_SCALE      = 0x024,
    CMD1_NPU_SET_OPA_SCALE      = 0x025,
    CMD1_NPU_SET_OPB_SCALE      = 0x026,
    CMD1_NPU_SET_DMA0_SRC       = 0x030,
    CMD1_NPU_SET_DMA0_DST       = 0x031,
    CMD1_NPU_SET_DMA0_LEN       = 0x032,
    CMD1_NPU_SET_DMA0_SKIP0     = 0x033,
    CMD1_NPU_SET_DMA0_SKIP1     = 0x034,
    CMD1_NPU_SET_IFM2_BASE0     = 0x080,
    CMD1_NPU_SET_IFM2_BASE1     = 0x081,
    CMD1_NPU_SET_IFM2_BASE2     = 0x082,
    CMD1_NPU_SET_IFM2_BASE3     = 0x083,
    CMD1_NPU_SET_IFM2_STRIDE_X  = 0x084,
    CMD1_NPU_SET_IFM2_STRIDE_Y  = 0x085,
    CMD1_NPU_SET_IFM2_STRIDE_C  = 0x086,
    CMD1_NPU_SET_WEIGHT1_BASE   = 0x090,
    CMD1_NPU_SET_WEIGHT1_LENGTH = 0x091,
    CMD1_NPU_SET_SCALE1_BASE    = 0x092,
    CMD1_NPU_SET_SCALE1_LENGTH  = 0x093,
};

enum data_format
{
    DATA_FORMAT_NHWC    = 0,
    DATA_FORMAT_NHCWB16 = 1,
};

enum elementwise_mode
{
    ELEMENTWISE_MODE_MUL   = 0,
    ELEMENTWISE_MODE_ADD   = 1,
    ELEMENTWISE_MODE_SUB   = 2,
    ELEMENTWISE_MODE_MIN   = 3,
    ELEMENTWISE_MODE_MAX   = 4,
    ELEMENTWISE_MODE_LRELU = 5,
    ELEMENTWISE_MODE_ABS   = 6,
    ELEMENTWISE_MODE_CLZ   = 7,
    ELEMENTWISE_MODE_SHR   = 8,
    ELEMENTWISE_MODE_SHL   = 9,
};

enum ifm_precision
{
    IFM_PRECISION_U8  = 0,
    IFM_PRECISION_S8  = 1,
    IFM_PRECISION_U16 = 4,
    IFM_PRECISION_S16 = 5,
    IFM_PRECISION_S32 = 9,
};

enum ifm_scale_mode
{
    IFM_SCALE_MODE_SCALE_16BIT     = 0,
    IFM_SCALE_MODE_SCALE_OPA_32BIT = 1,
    IFM_SCALE_MODE_SCALE_OPB_32BIT = 2,
};

enum macs_per_cc
{
    MACS_PER_CC_MACS_PER_CC_IS_5 = 0x5,
    MACS_PER_CC_MACS_PER_CC_IS_6 = 0x6,
    MACS_PER_CC_MACS_PER_CC_IS_7 = 0x7,
    MACS_PER_CC_MACS_PER_CC_IS_8 = 0x8,
};

enum memory_type
{
    MEMORY_TYPE_AXI0_OUTSTANDING_COUNTER0 = 0,
    MEMORY_TYPE_AXI0_OUTSTANDING_COUNTER1 = 1,
    MEMORY_TYPE_AXI1_OUTSTANDING_COUNTER2 = 2,
    MEMORY_TYPE_AXI1_OUTSTANDING_COUNTER3 = 3,
};

enum ofm_precision
{
    OFM_PRECISION_U8  = 0,
    OFM_PRECISION_S8  = 1,
    OFM_PRECISION_U16 = 2,
    OFM_PRECISION_S16 = 3,
    OFM_PRECISION_S32 = 5,
};

enum pmu_event_type
{
    PMU_EVENT_TYPE_NO_EVENT                     = 0x00,
    PMU_EVENT_TYPE_CYCLE                        = 0x11,
    PMU_EVENT_TYPE_NPU_IDLE                     = 0x20,
    PMU_EVENT_TYPE_CC_STALLED_ON_BLOCKDEP       = 0x21,
    PMU_EVENT_TYPE_CC_STALLED_ON_SHRAM_RECONFIG = 0x22,
    PMU_EVENT_TYPE_NPU_ACTIVE                   = 0x23,
    PMU_EVENT_TYPE_MAC_ACTIVE                   = 0x30,
    PMU_EVENT_TYPE_MAC_ACTIVE_8BIT              = 0x31,
    PMU_EVENT_TYPE_MAC_ACTIVE_16BIT             = 0x32,
    PMU_EVENT_TYPE_MAC_DPU_ACTIVE               = 0x33,
    PMU_EVENT_TYPE_MAC_STALLED_BY_WD_ACC        = 0x34,
    PMU_EVENT_TYPE_MAC_STALLED_BY_WD            = 0x35,
    PMU_EVENT_TYPE_MAC_STALLED_BY_ACC           = 0x36,
    PMU_EVENT_TYPE_MAC_STALLED_BY_IB            = 0x37,
    PMU_EVENT_TYPE_MAC_ACTIVE_32BIT             = 0x38,
    PMU_EVENT_TYPE_MAC_STALLED_BY_INT_W         = 0x39,
    PMU_EVENT_TYPE_MAC_STALLED_BY_INT_ACC       = 0x3A,
    PMU_EVENT_TYPE_AO_ACTIVE                    = 0x40,
    PMU_EVENT_TYPE_AO_ACTIVE_8BIT               = 0x41,
    PMU_EVENT_TYPE_AO_ACTIVE_16BIT              = 0x42,
    PMU_EVENT_TYPE_AO_STALLED_BY_OFMP_OB        = 0x43,
    PMU_EVENT_TYPE_AO_STALLED_BY_OFMP           = 0x44,
    PMU_EVENT_TYPE_AO_STALLED_BY_OB             = 0x45,
    PMU_EVENT_TYPE_AO_STALLED_BY_ACC_IB         = 0x46,
    PMU_EVENT_TYPE_AO_STALLED_BY_ACC            = 0x47,
    PMU_EVENT_TYPE_AO_STALLED_BY_IB             = 0x48,
    PMU_EVENT_TYPE_WD_ACTIVE                    = 0x50,
    PMU_EVENT_TYPE_WD_STALLED                   = 0x51,
    PMU_EVENT_TYPE_WD_STALLED_BY_WS             = 0x52,
    PMU_EVENT_TYPE_WD_STALLED_BY_WD_BUF         = 0x53,
    PMU_EVENT_TYPE_WD_PARSE_ACTIVE              = 0x54,
    PMU_EVENT_TYPE_WD_PARSE_STALLED             = 0x55,
    PMU_EVENT_TYPE_WD_PARSE_STALLED_IN          = 0x56,
    PMU_EVENT_TYPE_WD_PARSE_STALLED_OUT         = 0x57,
    PMU_EVENT_TYPE_WD_TRANS_WS                  = 0x58,
    PMU_EVENT_TYPE_WD_TRANS_WB                  = 0x59,
    PMU_EVENT_TYPE_WD_TRANS_DW0                 = 0x5a,
    PMU_EVENT_TYPE_WD_TRANS_DW1                 = 0x5b,
    PMU_EVENT_TYPE_AXI0_RD_TRANS_ACCEPTED       = 0x80,
    PMU_EVENT_TYPE_AXI0_RD_TRANS_COMPLETED      = 0x81,
    PMU_EVENT_TYPE_AXI0_RD_DATA_BEAT_RECEIVED   = 0x82,
    PMU_EVENT_TYPE_AXI0_RD_TRAN_REQ_STALLED     = 0x83,
    PMU_EVENT_TYPE_AXI0_WR_TRANS_ACCEPTED       = 0x84,
    PMU_EVENT_TYPE_AXI0_WR_TRANS_COMPLETED_M    = 0x85,
    PMU_EVENT_TYPE_AXI0_WR_TRANS_COMPLETED_S    = 0x86,
    PMU_EVENT_TYPE_AXI0_WR_DATA_BEAT_WRITTEN    = 0x87,
    PMU_EVENT_TYPE_AXI0_WR_TRAN_REQ_STALLED     = 0x88,
    PMU_EVENT_TYPE_AXI0_WR_DATA_BEAT_STALLED    = 0x89,
    PMU_EVENT_TYPE_AXI0_ENABLED_CYCLES          = 0x8c,
    PMU_EVENT_TYPE_AXI0_RD_STALL_LIMIT          = 0x8e,
    PMU_EVENT_TYPE_AXI0_WR_STALL_LIMIT          = 0x8f,
    PMU_EVENT_TYPE_AXI1_RD_TRANS_ACCEPTED       = 0x180,
    PMU_EVENT_TYPE_AXI1_RD_TRANS_COMPLETED      = 0x181,
    PMU_EVENT_TYPE_AXI1_RD_DATA_BEAT_RECEIVED   = 0x182,
    PMU_EVENT_TYPE_AXI1_RD_TRAN_REQ_STALLED     = 0x183,
    PMU_EVENT_TYPE_AXI1_WR_TRANS_ACCEPTED       = 0x184,
    PMU_EVENT_TYPE_AXI1_WR_TRANS_COMPLETED_M    = 0x185,
    PMU_EVENT_TYPE_AXI1_WR_TRANS_COMPLETED_S    = 0x186,
    PMU_EVENT_TYPE_AXI1_WR_DATA_BEAT_WRITTEN    = 0x187,
    PMU_EVENT_TYPE_AXI1_WR_TRAN_REQ_STALLED     = 0x188,
    PMU_EVENT_TYPE_AXI1_WR_DATA_BEAT_STALLED    = 0x189,
    PMU_EVENT_TYPE_AXI1_ENABLED_CYCLES          = 0x18c,
    PMU_EVENT_TYPE_AXI1_RD_STALL_LIMIT          = 0x18e,
    PMU_EVENT_TYPE_AXI1_WR_STALL_LIMIT          = 0x18f,
    PMU_EVENT_TYPE_AXI_LATENCY_ANY              = 0xa0,
    PMU_EVENT_TYPE_AXI_LATENCY_32               = 0xa1,
    PMU_EVENT_TYPE_AXI_LATENCY_64               = 0xa2,
    PMU_EVENT_TYPE_AXI_LATENCY_128              = 0xa3,
    PMU_EVENT_TYPE_AXI_LATENCY_256              = 0xa4,
    PMU_EVENT_TYPE_AXI_LATENCY_512              = 0xa5,
    PMU_EVENT_TYPE_AXI_LATENCY_1024             = 0xa6,
    PMU_EVENT_TYPE_ECC_DMA                      = 0xb0,
    PMU_EVENT_TYPE_ECC_SB0                      = 0xb1,
    PMU_EVENT_TYPE_ECC_SB1                      = 0x1b1,
};

enum pooling_mode
{
    POOLING_MODE_MAX        = 0,
    POOLING_MODE_AVERAGE    = 1,
    POOLING_MODE_REDUCE_SUM = 2,
};

enum privilege_level
{
    PRIVILEGE_LEVEL_USER       = 0,
    PRIVILEGE_LEVEL_PRIVILEGED = 1,
};

enum resampling_mode
{
    RESAMPLING_MODE_NONE      = 0,
    RESAMPLING_MODE_NEAREST   = 1,
    RESAMPLING_MODE_TRANSPOSE = 2,
};

enum rounding
{
    ROUNDING_TFL      = 0,
    ROUNDING_TRUNCATE = 1,
    ROUNDING_NATURAL  = 2,
};

enum security_level
{
    SECURITY_LEVEL_SECURE     = 0,
    SECURITY_LEVEL_NON_SECURE = 1,
};

enum shram_size
{
    SHRAM_SIZE_SHRAM_96KB = 0x60,
    SHRAM_SIZE_SHRAM_48KB = 0x30,
    SHRAM_SIZE_SHRAM_24KB = 0x18,
    SHRAM_SIZE_SHRAM_16KB = 0x10,
};

enum state
{
    STATE_STOPPED = 0,
    STATE_RUNNING = 1,
};

enum stride_mode
{
    STRIDE_MODE_STRIDE_MODE_1D = 0,
    STRIDE_MODE_STRIDE_MODE_2D = 1,
    STRIDE_MODE_STRIDE_MODE_3D = 2,
};

#endif

// id_r - ID register
struct id_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t version_status : 4; // This is the version of the product
            uint32_t version_minor : 4;  // This is the n for the P part of an RnPn release number
            uint32_t version_major : 4;  // This is the n for the R part of an RnPn release number
            uint32_t product_major : 4;  // This is the X part of the ML00X product number
            uint32_t arch_patch_rev : 4; // This is the patch number of the architecture version a.b
            uint32_t
                arch_minor_rev : 8; // This is the minor architecture version number, b in the architecture version a.b
            uint32_t
                arch_major_rev : 4; // This is the major architecture version number, a in the architecture version a.b
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR id_r() :
        version_status(static_cast<uint32_t>(1)), version_minor(static_cast<uint32_t>(0x0)),
        version_major(static_cast<uint32_t>(0x1)), product_major(static_cast<uint32_t>(4)),
        arch_patch_rev(static_cast<uint32_t>(6)), arch_minor_rev(static_cast<uint32_t>(0)),
        arch_major_rev(static_cast<uint32_t>(1))
    {
    }
    CONSTEXPR id_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    id_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_version_status() const
    {
        uint32_t value = static_cast<uint32_t>(version_status);
        return value;
    }
    uint32_t get_version_status() const volatile
    {
        uint32_t value = static_cast<uint32_t>(version_status);
        return value;
    }
    CONSTEXPR id_r &set_version_status(uint32_t value)
    {
        version_status = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_version_minor() const
    {
        uint32_t value = static_cast<uint32_t>(version_minor);
        return value;
    }
    uint32_t get_version_minor() const volatile
    {
        uint32_t value = static_cast<uint32_t>(version_minor);
        return value;
    }
    CONSTEXPR id_r &set_version_minor(uint32_t value)
    {
        version_minor = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_version_major() const
    {
        uint32_t value = static_cast<uint32_t>(version_major);
        return value;
    }
    uint32_t get_version_major() const volatile
    {
        uint32_t value = static_cast<uint32_t>(version_major);
        return value;
    }
    CONSTEXPR id_r &set_version_major(uint32_t value)
    {
        version_major = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_product_major() const
    {
        uint32_t value = static_cast<uint32_t>(product_major);
        return value;
    }
    uint32_t get_product_major() const volatile
    {
        uint32_t value = static_cast<uint32_t>(product_major);
        return value;
    }
    CONSTEXPR id_r &set_product_major(uint32_t value)
    {
        product_major = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_arch_patch_rev() const
    {
        uint32_t value = static_cast<uint32_t>(arch_patch_rev);
        return value;
    }
    uint32_t get_arch_patch_rev() const volatile
    {
        uint32_t value = static_cast<uint32_t>(arch_patch_rev);
        return value;
    }
    CONSTEXPR id_r &set_arch_patch_rev(uint32_t value)
    {
        arch_patch_rev = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_arch_minor_rev() const
    {
        uint32_t value = static_cast<uint32_t>(arch_minor_rev);
        return value;
    }
    uint32_t get_arch_minor_rev() const volatile
    {
        uint32_t value = static_cast<uint32_t>(arch_minor_rev);
        return value;
    }
    CONSTEXPR id_r &set_arch_minor_rev(uint32_t value)
    {
        arch_minor_rev = ((1u << 8) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_arch_major_rev() const
    {
        uint32_t value = static_cast<uint32_t>(arch_major_rev);
        return value;
    }
    uint32_t get_arch_major_rev() const volatile
    {
        uint32_t value = static_cast<uint32_t>(arch_major_rev);
        return value;
    }
    CONSTEXPR id_r &set_arch_major_rev(uint32_t value)
    {
        arch_major_rev = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// status_r - Register describes the current operating status of the NPU
struct status_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t state : 1;      // NPU state, 0 = Stopped, 1 = Running
            uint32_t irq_raised : 1; // Raw IRQ status, 0 = IRQ not raised, 1 = IRQ raised. IRQ is cleared using command
                                     // register bit 1
            uint32_t
                bus_status : 1; // 0=OK, 1=Bus abort detected and processing halted (NPU will reach IDLE state and not
                                // to start process any more commands/AXI transactions). Can only be cleared by a reset
            uint32_t reset_status : 1; // Reset is ongoing and only this register can be read (other registers read as 0
                                       // and writes are ignored.) A value of 0 means NPU is not being reset and can be
                                       // accessed as normal
            uint32_t
                cmd_parse_error : 1; // 0=No error 1=Command stream parsing error detected. Can only be cleared by reset
            uint32_t cmd_end_reached : 1; // 0=Not reached, 1=Reached. Cleared by writing QBASE or QSIZE when NPU is in
                                          // stopped state
            uint32_t pmu_irq_raised : 1;  // 0=No PMU IRQ, 1=PMU IRQ raised. Cleared by using command register bit 1
            uint32_t wd_fault : 1; // Weight decoder state: 0=no fault 1=weight decoder decompression fault. Can only be
                                   // cleared by reset
            uint32_t ecc_fault : 1; // ECC state for internal RAMs: 0=no fault 1=ECC fault signalled. Can only be
                                    // cleared by reset
            uint32_t reserved0 : 2;
            uint32_t faulting_interface : 1; // Faulting interface on bus abort. 0=AXI-M0 1=AXI-M1
            uint32_t faulting_channel : 4;  // Faulting channel on a bus abort. Read: 0=Cmd 1=IFM 2=Weights 3=Scale+Bias
                                            // 4=Mem2Mem; Write: 8=OFM 9=Mem2Mem
            uint32_t irq_history_mask : 16; // IRQ History mask
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR status_r() :
        state(static_cast<uint32_t>(::state::STOPPED)), irq_raised(static_cast<uint32_t>(0x0)),
        bus_status(static_cast<uint32_t>(0x0)), reset_status(static_cast<uint32_t>(0x1)),
        cmd_parse_error(static_cast<uint32_t>(0x0)), cmd_end_reached(static_cast<uint32_t>(0x0)),
        pmu_irq_raised(static_cast<uint32_t>(0x0)), wd_fault(static_cast<uint32_t>(0x0)),
        ecc_fault(static_cast<uint32_t>(0x0)), reserved0(static_cast<uint32_t>(0)),
        faulting_interface(static_cast<uint32_t>(0x0)), faulting_channel(static_cast<uint32_t>(0x0)),
        irq_history_mask(static_cast<uint32_t>(0x0))
    {
    }
    CONSTEXPR status_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    status_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR ::state get_state() const
    {
        ::state value = static_cast<::state>(state);
        return value;
    }
    ::state get_state() const volatile
    {
        ::state value = static_cast<::state>(state);
        return value;
    }
    CONSTEXPR status_r &set_state(::state value)
    {
        state = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_irq_raised() const
    {
        uint32_t value = static_cast<uint32_t>(irq_raised);
        return value;
    }
    uint32_t get_irq_raised() const volatile
    {
        uint32_t value = static_cast<uint32_t>(irq_raised);
        return value;
    }
    CONSTEXPR status_r &set_irq_raised(uint32_t value)
    {
        irq_raised = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_bus_status() const
    {
        uint32_t value = static_cast<uint32_t>(bus_status);
        return value;
    }
    uint32_t get_bus_status() const volatile
    {
        uint32_t value = static_cast<uint32_t>(bus_status);
        return value;
    }
    CONSTEXPR status_r &set_bus_status(uint32_t value)
    {
        bus_status = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_reset_status() const
    {
        uint32_t value = static_cast<uint32_t>(reset_status);
        return value;
    }
    uint32_t get_reset_status() const volatile
    {
        uint32_t value = static_cast<uint32_t>(reset_status);
        return value;
    }
    CONSTEXPR status_r &set_reset_status(uint32_t value)
    {
        reset_status = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_cmd_parse_error() const
    {
        uint32_t value = static_cast<uint32_t>(cmd_parse_error);
        return value;
    }
    uint32_t get_cmd_parse_error() const volatile
    {
        uint32_t value = static_cast<uint32_t>(cmd_parse_error);
        return value;
    }
    CONSTEXPR status_r &set_cmd_parse_error(uint32_t value)
    {
        cmd_parse_error = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_cmd_end_reached() const
    {
        uint32_t value = static_cast<uint32_t>(cmd_end_reached);
        return value;
    }
    uint32_t get_cmd_end_reached() const volatile
    {
        uint32_t value = static_cast<uint32_t>(cmd_end_reached);
        return value;
    }
    CONSTEXPR status_r &set_cmd_end_reached(uint32_t value)
    {
        cmd_end_reached = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_pmu_irq_raised() const
    {
        uint32_t value = static_cast<uint32_t>(pmu_irq_raised);
        return value;
    }
    uint32_t get_pmu_irq_raised() const volatile
    {
        uint32_t value = static_cast<uint32_t>(pmu_irq_raised);
        return value;
    }
    CONSTEXPR status_r &set_pmu_irq_raised(uint32_t value)
    {
        pmu_irq_raised = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_wd_fault() const
    {
        uint32_t value = static_cast<uint32_t>(wd_fault);
        return value;
    }
    uint32_t get_wd_fault() const volatile
    {
        uint32_t value = static_cast<uint32_t>(wd_fault);
        return value;
    }
    CONSTEXPR status_r &set_wd_fault(uint32_t value)
    {
        wd_fault = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_ecc_fault() const
    {
        uint32_t value = static_cast<uint32_t>(ecc_fault);
        return value;
    }
    uint32_t get_ecc_fault() const volatile
    {
        uint32_t value = static_cast<uint32_t>(ecc_fault);
        return value;
    }
    CONSTEXPR status_r &set_ecc_fault(uint32_t value)
    {
        ecc_fault = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_faulting_interface() const
    {
        uint32_t value = static_cast<uint32_t>(faulting_interface);
        return value;
    }
    uint32_t get_faulting_interface() const volatile
    {
        uint32_t value = static_cast<uint32_t>(faulting_interface);
        return value;
    }
    CONSTEXPR status_r &set_faulting_interface(uint32_t value)
    {
        faulting_interface = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_faulting_channel() const
    {
        uint32_t value = static_cast<uint32_t>(faulting_channel);
        return value;
    }
    uint32_t get_faulting_channel() const volatile
    {
        uint32_t value = static_cast<uint32_t>(faulting_channel);
        return value;
    }
    CONSTEXPR status_r &set_faulting_channel(uint32_t value)
    {
        faulting_channel = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_irq_history_mask() const
    {
        uint32_t value = static_cast<uint32_t>(irq_history_mask);
        return value;
    }
    uint32_t get_irq_history_mask() const volatile
    {
        uint32_t value = static_cast<uint32_t>(irq_history_mask);
        return value;
    }
    CONSTEXPR status_r &set_irq_history_mask(uint32_t value)
    {
        irq_history_mask = ((1u << 16) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// cmd_r - Command register, reads as last written command
struct cmd_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t transition_to_running_state : 1; // Write 1 to transition the NPU to running state. Writing 0 has
                                                      // no effect
            uint32_t clear_irq : 1; // Write 1 to clear the IRQ status in the STATUS register. Writing 0 has no effect
            uint32_t clock_q_enable : 1; // Write 1 to this bit to enable clock off using clock q-interface and enable
                                         // the master clock gate
            uint32_t power_q_enable : 1; // Write 1 to this bit to enable power off using power q-interface
            uint32_t
                stop_request : 1; // Write 1 to this bit to request STOP after completing any already-started commands
            uint32_t reserved0 : 11;
            uint32_t clear_irq_history : 16; // Clears the IRQ history mask
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR cmd_r() :
        transition_to_running_state(static_cast<uint32_t>(0x0)), clear_irq(static_cast<uint32_t>(0x0)),
        clock_q_enable(static_cast<uint32_t>(0x1)), power_q_enable(static_cast<uint32_t>(0x1)),
        stop_request(static_cast<uint32_t>(0x0)), reserved0(static_cast<uint32_t>(0)),
        clear_irq_history(static_cast<uint32_t>(0x0))
    {
    }
    CONSTEXPR cmd_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    cmd_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_transition_to_running_state() const
    {
        uint32_t value = static_cast<uint32_t>(transition_to_running_state);
        return value;
    }
    uint32_t get_transition_to_running_state() const volatile
    {
        uint32_t value = static_cast<uint32_t>(transition_to_running_state);
        return value;
    }
    CONSTEXPR cmd_r &set_transition_to_running_state(uint32_t value)
    {
        transition_to_running_state = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_clear_irq() const
    {
        uint32_t value = static_cast<uint32_t>(clear_irq);
        return value;
    }
    uint32_t get_clear_irq() const volatile
    {
        uint32_t value = static_cast<uint32_t>(clear_irq);
        return value;
    }
    CONSTEXPR cmd_r &set_clear_irq(uint32_t value)
    {
        clear_irq = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_clock_q_enable() const
    {
        uint32_t value = static_cast<uint32_t>(clock_q_enable);
        return value;
    }
    uint32_t get_clock_q_enable() const volatile
    {
        uint32_t value = static_cast<uint32_t>(clock_q_enable);
        return value;
    }
    CONSTEXPR cmd_r &set_clock_q_enable(uint32_t value)
    {
        clock_q_enable = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_power_q_enable() const
    {
        uint32_t value = static_cast<uint32_t>(power_q_enable);
        return value;
    }
    uint32_t get_power_q_enable() const volatile
    {
        uint32_t value = static_cast<uint32_t>(power_q_enable);
        return value;
    }
    CONSTEXPR cmd_r &set_power_q_enable(uint32_t value)
    {
        power_q_enable = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_stop_request() const
    {
        uint32_t value = static_cast<uint32_t>(stop_request);
        return value;
    }
    uint32_t get_stop_request() const volatile
    {
        uint32_t value = static_cast<uint32_t>(stop_request);
        return value;
    }
    CONSTEXPR cmd_r &set_stop_request(uint32_t value)
    {
        stop_request = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_clear_irq_history() const
    {
        uint32_t value = static_cast<uint32_t>(clear_irq_history);
        return value;
    }
    uint32_t get_clear_irq_history() const volatile
    {
        uint32_t value = static_cast<uint32_t>(clear_irq_history);
        return value;
    }
    CONSTEXPR cmd_r &set_clear_irq_history(uint32_t value)
    {
        clear_irq_history = ((1u << 16) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// reset_r - Request Reset and new security mode
struct reset_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t pending_CPL : 1; // Current privilege level 0=User 1=Privileged
            uint32_t pending_CSL : 1; // Current security level 0=Secure 1=Non secure
            uint32_t reserved0 : 30;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR reset_r() :
        pending_CPL(static_cast<uint32_t>(::privilege_level::USER)),
        pending_CSL(static_cast<uint32_t>(::security_level::SECURE)), reserved0(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR reset_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    reset_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR ::privilege_level get_pending_CPL() const
    {
        ::privilege_level value = static_cast<::privilege_level>(pending_CPL);
        return value;
    }
    ::privilege_level get_pending_CPL() const volatile
    {
        ::privilege_level value = static_cast<::privilege_level>(pending_CPL);
        return value;
    }
    CONSTEXPR reset_r &set_pending_CPL(::privilege_level value)
    {
        pending_CPL = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::security_level get_pending_CSL() const
    {
        ::security_level value = static_cast<::security_level>(pending_CSL);
        return value;
    }
    ::security_level get_pending_CSL() const volatile
    {
        ::security_level value = static_cast<::security_level>(pending_CSL);
        return value;
    }
    CONSTEXPR reset_r &set_pending_CSL(::security_level value)
    {
        pending_CSL = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// qbase0_r - Base address of command queue bits [31:0]. The address is 4 byte aligned
struct qbase0_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t QBASE0; // The 4 byte aligned lower bytes of the base address value for the command stream
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR qbase0_r() : QBASE0(static_cast<uint32_t>(0x00000000)) {}
    CONSTEXPR qbase0_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    qbase0_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_QBASE0() const
    {
        uint32_t value = static_cast<uint32_t>(QBASE0);
        return value;
    }
    uint32_t get_QBASE0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(QBASE0);
        return value;
    }
    CONSTEXPR qbase0_r &set_QBASE0(uint32_t value)
    {
        QBASE0 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// qbase1_r - Address extension bits [47:32] bits for queue base
struct qbase1_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t QBASE1; // The 4 byte aligned upper bytes of the base address value for the command stream
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR qbase1_r() : QBASE1(static_cast<uint32_t>(0x00000000)) {}
    CONSTEXPR qbase1_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    qbase1_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_QBASE1() const
    {
        uint32_t value = static_cast<uint32_t>(QBASE1);
        return value;
    }
    uint32_t get_QBASE1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(QBASE1);
        return value;
    }
    CONSTEXPR qbase1_r &set_QBASE1(uint32_t value)
    {
        QBASE1 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// qread_r - Read offset in the command stream in bytes. Multiple of 4 in the range 0 to 16 MB
struct qread_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t QREAD; // The read offset of the current command under execution
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR qread_r() : QREAD(static_cast<uint32_t>(0x00000000)) {}
    CONSTEXPR qread_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    qread_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_QREAD() const
    {
        uint32_t value = static_cast<uint32_t>(QREAD);
        return value;
    }
    uint32_t get_QREAD() const volatile
    {
        uint32_t value = static_cast<uint32_t>(QREAD);
        return value;
    }
    CONSTEXPR qread_r &set_QREAD(uint32_t value)
    {
        QREAD = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// qconfig_r - AXI configuration for the command stream in the range 0-3. Same encoding as for REGIONCFG
struct qconfig_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t QCONFIG; // AXI configuration for the command stream in the range 0-3
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR qconfig_r() : QCONFIG(static_cast<uint32_t>(0x00000000)) {}
    CONSTEXPR qconfig_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    qconfig_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_QCONFIG() const
    {
        uint32_t value = static_cast<uint32_t>(QCONFIG);
        return value;
    }
    uint32_t get_QCONFIG() const volatile
    {
        uint32_t value = static_cast<uint32_t>(QCONFIG);
        return value;
    }
    CONSTEXPR qconfig_r &set_QCONFIG(uint32_t value)
    {
        QCONFIG = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// qsize_r - Size of the command stream in bytes. Multiple of 4 in the range 0 to 16 MB
struct qsize_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t QSIZE; // Size of the next command stream to be executed by the NPU
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR qsize_r() : QSIZE(static_cast<uint32_t>(0x00000000)) {}
    CONSTEXPR qsize_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    qsize_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_QSIZE() const
    {
        uint32_t value = static_cast<uint32_t>(QSIZE);
        return value;
    }
    uint32_t get_QSIZE() const volatile
    {
        uint32_t value = static_cast<uint32_t>(QSIZE);
        return value;
    }
    CONSTEXPR qsize_r &set_QSIZE(uint32_t value)
    {
        QSIZE = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// prot_r - Protection level configured for the NPU when acting as an AXI master
struct prot_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t active_CPL : 1; // Current privilege level 0=User 1=Privileged
            uint32_t active_CSL : 1; // Current security level 0=Secure 1=Non secure
            uint32_t reserved0 : 30;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR prot_r() :
        active_CPL(static_cast<uint32_t>(::privilege_level::USER)),
        active_CSL(static_cast<uint32_t>(::security_level::SECURE)), reserved0(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR prot_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    prot_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR ::privilege_level get_active_CPL() const
    {
        ::privilege_level value = static_cast<::privilege_level>(active_CPL);
        return value;
    }
    ::privilege_level get_active_CPL() const volatile
    {
        ::privilege_level value = static_cast<::privilege_level>(active_CPL);
        return value;
    }
    CONSTEXPR prot_r &set_active_CPL(::privilege_level value)
    {
        active_CPL = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::security_level get_active_CSL() const
    {
        ::security_level value = static_cast<::security_level>(active_CSL);
        return value;
    }
    ::security_level get_active_CSL() const volatile
    {
        ::security_level value = static_cast<::security_level>(active_CSL);
        return value;
    }
    CONSTEXPR prot_r &set_active_CSL(::security_level value)
    {
        active_CSL = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// config_r - RTL configuration
struct config_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t macs_per_cc : 4;        // The log2(macs/clock cycle). Valid encoding range is 5 to 8 for 32 to 256
                                             // MACs/clock cycle.
            uint32_t cmd_stream_version : 4; // command stream version accepted by this NPU.
            uint32_t shram_size : 8;         // Size in KB of SHRAM in the range 8 to 48.
            uint32_t reserved0 : 11;
            uint32_t custom_dma : 1; // Custom DMA enable bit.
            uint32_t product : 4;    // Product configuration
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR config_r() :
        macs_per_cc(static_cast<uint32_t>(0)), cmd_stream_version(static_cast<uint32_t>(0x0)),
        shram_size(static_cast<uint32_t>(0)), reserved0(static_cast<uint32_t>(0)), product(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR config_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    config_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR ::macs_per_cc get_macs_per_cc() const
    {
        ::macs_per_cc value = static_cast<::macs_per_cc>(macs_per_cc);
        return value;
    }
    ::macs_per_cc get_macs_per_cc() const volatile
    {
        ::macs_per_cc value = static_cast<::macs_per_cc>(macs_per_cc);
        return value;
    }
    CONSTEXPR config_r &set_macs_per_cc(::macs_per_cc value)
    {
        macs_per_cc = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_cmd_stream_version() const
    {
        uint32_t value = static_cast<uint32_t>(cmd_stream_version);
        return value;
    }
    uint32_t get_cmd_stream_version() const volatile
    {
        uint32_t value = static_cast<uint32_t>(cmd_stream_version);
        return value;
    }
    CONSTEXPR config_r &set_cmd_stream_version(uint32_t value)
    {
        cmd_stream_version = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::shram_size get_shram_size() const
    {
        ::shram_size value = static_cast<::shram_size>(shram_size);
        return value;
    }
    ::shram_size get_shram_size() const volatile
    {
        ::shram_size value = static_cast<::shram_size>(shram_size);
        return value;
    }
    CONSTEXPR config_r &set_shram_size(::shram_size value)
    {
        shram_size = ((1u << 8) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_product() const
    {
        uint32_t value = static_cast<uint32_t>(product);
        return value;
    }
    uint32_t get_product() const volatile
    {
        uint32_t value = static_cast<uint32_t>(product);
        return value;
    }
    CONSTEXPR config_r &set_product(uint32_t value)
    {
        product = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// lock_r - Lock register. This register is designed for driver use and does not affect NPU functionality
struct lock_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t LOCK; // 32 bit value for LOCK configuration
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR lock_r() : LOCK(static_cast<uint32_t>(0x00000000)) {}
    CONSTEXPR lock_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    lock_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_LOCK() const
    {
        uint32_t value = static_cast<uint32_t>(LOCK);
        return value;
    }
    uint32_t get_LOCK() const volatile
    {
        uint32_t value = static_cast<uint32_t>(LOCK);
        return value;
    }
    CONSTEXPR lock_r &set_LOCK(uint32_t value)
    {
        LOCK = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// regioncfg_r - Region memory type configuration. Bits[2*k+1:2*k] give the memory type for REGION[k]
struct regioncfg_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t region0 : 2; // Bits for Region0 Configurion
            uint32_t region1 : 2; // Bits for Region1 Configurion
            uint32_t region2 : 2; // Bits for Region2 Configurion
            uint32_t region3 : 2; // Bits for Region3 Configurion
            uint32_t region4 : 2; // Bits for Region4 Configurion
            uint32_t region5 : 2; // Bits for Region5 Configurion
            uint32_t region6 : 2; // Bits for Region6 Configurion
            uint32_t region7 : 2; // Bits for Region7 Configurion
            uint32_t reserved0 : 16;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR regioncfg_r() :
        region0(static_cast<uint32_t>(::memory_type::AXI0_OUTSTANDING_COUNTER0)),
        region1(static_cast<uint32_t>(::memory_type::AXI0_OUTSTANDING_COUNTER0)),
        region2(static_cast<uint32_t>(::memory_type::AXI0_OUTSTANDING_COUNTER0)),
        region3(static_cast<uint32_t>(::memory_type::AXI0_OUTSTANDING_COUNTER0)),
        region4(static_cast<uint32_t>(::memory_type::AXI0_OUTSTANDING_COUNTER0)),
        region5(static_cast<uint32_t>(::memory_type::AXI0_OUTSTANDING_COUNTER0)),
        region6(static_cast<uint32_t>(::memory_type::AXI0_OUTSTANDING_COUNTER0)),
        region7(static_cast<uint32_t>(::memory_type::AXI0_OUTSTANDING_COUNTER0)), reserved0(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR regioncfg_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    regioncfg_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR ::memory_type get_region0() const
    {
        ::memory_type value = static_cast<::memory_type>(region0);
        return value;
    }
    ::memory_type get_region0() const volatile
    {
        ::memory_type value = static_cast<::memory_type>(region0);
        return value;
    }
    CONSTEXPR regioncfg_r &set_region0(::memory_type value)
    {
        region0 = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::memory_type get_region1() const
    {
        ::memory_type value = static_cast<::memory_type>(region1);
        return value;
    }
    ::memory_type get_region1() const volatile
    {
        ::memory_type value = static_cast<::memory_type>(region1);
        return value;
    }
    CONSTEXPR regioncfg_r &set_region1(::memory_type value)
    {
        region1 = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::memory_type get_region2() const
    {
        ::memory_type value = static_cast<::memory_type>(region2);
        return value;
    }
    ::memory_type get_region2() const volatile
    {
        ::memory_type value = static_cast<::memory_type>(region2);
        return value;
    }
    CONSTEXPR regioncfg_r &set_region2(::memory_type value)
    {
        region2 = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::memory_type get_region3() const
    {
        ::memory_type value = static_cast<::memory_type>(region3);
        return value;
    }
    ::memory_type get_region3() const volatile
    {
        ::memory_type value = static_cast<::memory_type>(region3);
        return value;
    }
    CONSTEXPR regioncfg_r &set_region3(::memory_type value)
    {
        region3 = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::memory_type get_region4() const
    {
        ::memory_type value = static_cast<::memory_type>(region4);
        return value;
    }
    ::memory_type get_region4() const volatile
    {
        ::memory_type value = static_cast<::memory_type>(region4);
        return value;
    }
    CONSTEXPR regioncfg_r &set_region4(::memory_type value)
    {
        region4 = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::memory_type get_region5() const
    {
        ::memory_type value = static_cast<::memory_type>(region5);
        return value;
    }
    ::memory_type get_region5() const volatile
    {
        ::memory_type value = static_cast<::memory_type>(region5);
        return value;
    }
    CONSTEXPR regioncfg_r &set_region5(::memory_type value)
    {
        region5 = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::memory_type get_region6() const
    {
        ::memory_type value = static_cast<::memory_type>(region6);
        return value;
    }
    ::memory_type get_region6() const volatile
    {
        ::memory_type value = static_cast<::memory_type>(region6);
        return value;
    }
    CONSTEXPR regioncfg_r &set_region6(::memory_type value)
    {
        region6 = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::memory_type get_region7() const
    {
        ::memory_type value = static_cast<::memory_type>(region7);
        return value;
    }
    ::memory_type get_region7() const volatile
    {
        ::memory_type value = static_cast<::memory_type>(region7);
        return value;
    }
    CONSTEXPR regioncfg_r &set_region7(::memory_type value)
    {
        region7 = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// axi_limit0_r - AXI limits for port 0 counter 0
struct axi_limit0_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t max_beats : 2; // Burst split alignment: 0=64 bytes, 1=128 bytes, 2=256 bytes, 3=reserved
            uint32_t reserved0 : 2;
            uint32_t memtype : 4; // Memtype to be used to encode AxCACHE signals
            uint32_t reserved1 : 8;
            uint32_t
                max_outstanding_read_m1 : 8; // Maximum number of outstanding AXI read transactions - 1 in range 0 to 31
            uint32_t max_outstanding_write_m1 : 8; // Maximum number of outstanding AXI write transactions - 1 in range
                                                   // 0 to 15
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR axi_limit0_r() :
        max_beats(static_cast<uint32_t>(0x0)), reserved0(static_cast<uint32_t>(0)),
        memtype(static_cast<uint32_t>(::axi_mem_encoding_type::DEVICE_NON_BUFFERABLE)),
        reserved1(static_cast<uint32_t>(0)), max_outstanding_read_m1(static_cast<uint32_t>(0x00)),
        max_outstanding_write_m1(static_cast<uint32_t>(0x00))
    {
    }
    CONSTEXPR axi_limit0_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    axi_limit0_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_max_beats() const
    {
        uint32_t value = static_cast<uint32_t>(max_beats);
        return value;
    }
    uint32_t get_max_beats() const volatile
    {
        uint32_t value = static_cast<uint32_t>(max_beats);
        return value;
    }
    CONSTEXPR axi_limit0_r &set_max_beats(uint32_t value)
    {
        max_beats = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::axi_mem_encoding_type get_memtype() const
    {
        ::axi_mem_encoding_type value = static_cast<::axi_mem_encoding_type>(memtype);
        return value;
    }
    ::axi_mem_encoding_type get_memtype() const volatile
    {
        ::axi_mem_encoding_type value = static_cast<::axi_mem_encoding_type>(memtype);
        return value;
    }
    CONSTEXPR axi_limit0_r &set_memtype(::axi_mem_encoding_type value)
    {
        memtype = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_max_outstanding_read_m1() const
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_read_m1);
        return value;
    }
    uint32_t get_max_outstanding_read_m1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_read_m1);
        return value;
    }
    CONSTEXPR axi_limit0_r &set_max_outstanding_read_m1(uint32_t value)
    {
        max_outstanding_read_m1 = ((1u << 8) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_max_outstanding_write_m1() const
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_write_m1);
        return value;
    }
    uint32_t get_max_outstanding_write_m1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_write_m1);
        return value;
    }
    CONSTEXPR axi_limit0_r &set_max_outstanding_write_m1(uint32_t value)
    {
        max_outstanding_write_m1 = ((1u << 8) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// axi_limit1_r - AXI limits for port 0 counter 1
struct axi_limit1_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t max_beats : 2; // Burst split alignment: 0=64 bytes, 1=128 bytes, 2=256 bytes, 3=reserved
            uint32_t reserved0 : 2;
            uint32_t memtype : 4; // Memtype to be used to encode AxCACHE signals
            uint32_t reserved1 : 8;
            uint32_t
                max_outstanding_read_m1 : 8; // Maximum number of outstanding AXI read transactions - 1 in range 0 to 31
            uint32_t max_outstanding_write_m1 : 8; // Maximum number of outstanding AXI write transactions - 1 in range
                                                   // 0 to 15
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR axi_limit1_r() :
        max_beats(static_cast<uint32_t>(0x0)), reserved0(static_cast<uint32_t>(0)),
        memtype(static_cast<uint32_t>(::axi_mem_encoding_type::DEVICE_NON_BUFFERABLE)),
        reserved1(static_cast<uint32_t>(0)), max_outstanding_read_m1(static_cast<uint32_t>(0x00)),
        max_outstanding_write_m1(static_cast<uint32_t>(0x00))
    {
    }
    CONSTEXPR axi_limit1_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    axi_limit1_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_max_beats() const
    {
        uint32_t value = static_cast<uint32_t>(max_beats);
        return value;
    }
    uint32_t get_max_beats() const volatile
    {
        uint32_t value = static_cast<uint32_t>(max_beats);
        return value;
    }
    CONSTEXPR axi_limit1_r &set_max_beats(uint32_t value)
    {
        max_beats = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::axi_mem_encoding_type get_memtype() const
    {
        ::axi_mem_encoding_type value = static_cast<::axi_mem_encoding_type>(memtype);
        return value;
    }
    ::axi_mem_encoding_type get_memtype() const volatile
    {
        ::axi_mem_encoding_type value = static_cast<::axi_mem_encoding_type>(memtype);
        return value;
    }
    CONSTEXPR axi_limit1_r &set_memtype(::axi_mem_encoding_type value)
    {
        memtype = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_max_outstanding_read_m1() const
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_read_m1);
        return value;
    }
    uint32_t get_max_outstanding_read_m1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_read_m1);
        return value;
    }
    CONSTEXPR axi_limit1_r &set_max_outstanding_read_m1(uint32_t value)
    {
        max_outstanding_read_m1 = ((1u << 8) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_max_outstanding_write_m1() const
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_write_m1);
        return value;
    }
    uint32_t get_max_outstanding_write_m1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_write_m1);
        return value;
    }
    CONSTEXPR axi_limit1_r &set_max_outstanding_write_m1(uint32_t value)
    {
        max_outstanding_write_m1 = ((1u << 8) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// axi_limit2_r - AXI limits for port 1 counter 2
struct axi_limit2_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t max_beats : 2; // Burst split alignment: 0=64 bytes, 1=128 bytes, 2=256 bytes, 3=reserved
            uint32_t reserved0 : 2;
            uint32_t memtype : 4; // Memtype to be used to encode AxCACHE signals
            uint32_t reserved1 : 8;
            uint32_t
                max_outstanding_read_m1 : 8; // Maximum number of outstanding AXI read transactions - 1 in range 0 to 31
            uint32_t max_outstanding_write_m1 : 8; // Maximum number of outstanding AXI write transactions - 1 in range
                                                   // 0 to 15
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR axi_limit2_r() :
        max_beats(static_cast<uint32_t>(0x0)), reserved0(static_cast<uint32_t>(0)),
        memtype(static_cast<uint32_t>(::axi_mem_encoding_type::DEVICE_NON_BUFFERABLE)),
        reserved1(static_cast<uint32_t>(0)), max_outstanding_read_m1(static_cast<uint32_t>(0x00)),
        max_outstanding_write_m1(static_cast<uint32_t>(0x00))
    {
    }
    CONSTEXPR axi_limit2_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    axi_limit2_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_max_beats() const
    {
        uint32_t value = static_cast<uint32_t>(max_beats);
        return value;
    }
    uint32_t get_max_beats() const volatile
    {
        uint32_t value = static_cast<uint32_t>(max_beats);
        return value;
    }
    CONSTEXPR axi_limit2_r &set_max_beats(uint32_t value)
    {
        max_beats = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::axi_mem_encoding_type get_memtype() const
    {
        ::axi_mem_encoding_type value = static_cast<::axi_mem_encoding_type>(memtype);
        return value;
    }
    ::axi_mem_encoding_type get_memtype() const volatile
    {
        ::axi_mem_encoding_type value = static_cast<::axi_mem_encoding_type>(memtype);
        return value;
    }
    CONSTEXPR axi_limit2_r &set_memtype(::axi_mem_encoding_type value)
    {
        memtype = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_max_outstanding_read_m1() const
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_read_m1);
        return value;
    }
    uint32_t get_max_outstanding_read_m1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_read_m1);
        return value;
    }
    CONSTEXPR axi_limit2_r &set_max_outstanding_read_m1(uint32_t value)
    {
        max_outstanding_read_m1 = ((1u << 8) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_max_outstanding_write_m1() const
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_write_m1);
        return value;
    }
    uint32_t get_max_outstanding_write_m1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_write_m1);
        return value;
    }
    CONSTEXPR axi_limit2_r &set_max_outstanding_write_m1(uint32_t value)
    {
        max_outstanding_write_m1 = ((1u << 8) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// axi_limit3_r - AXI limits for port 1 counter 3
struct axi_limit3_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t max_beats : 2; // Burst split alignment: 0=64 bytes, 1=128 bytes, 2=256 bytes, 3=reserved
            uint32_t reserved0 : 2;
            uint32_t memtype : 4; // Memtype to be used to encode AxCACHE signals
            uint32_t reserved1 : 8;
            uint32_t
                max_outstanding_read_m1 : 8; // Maximum number of outstanding AXI read transactions - 1 in range 0 to 31
            uint32_t max_outstanding_write_m1 : 8; // Maximum number of outstanding AXI write transactions - 1 in range
                                                   // 0 to 15
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR axi_limit3_r() :
        max_beats(static_cast<uint32_t>(0x0)), reserved0(static_cast<uint32_t>(0)),
        memtype(static_cast<uint32_t>(::axi_mem_encoding_type::DEVICE_NON_BUFFERABLE)),
        reserved1(static_cast<uint32_t>(0)), max_outstanding_read_m1(static_cast<uint32_t>(0x00)),
        max_outstanding_write_m1(static_cast<uint32_t>(0x00))
    {
    }
    CONSTEXPR axi_limit3_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    axi_limit3_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_max_beats() const
    {
        uint32_t value = static_cast<uint32_t>(max_beats);
        return value;
    }
    uint32_t get_max_beats() const volatile
    {
        uint32_t value = static_cast<uint32_t>(max_beats);
        return value;
    }
    CONSTEXPR axi_limit3_r &set_max_beats(uint32_t value)
    {
        max_beats = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::axi_mem_encoding_type get_memtype() const
    {
        ::axi_mem_encoding_type value = static_cast<::axi_mem_encoding_type>(memtype);
        return value;
    }
    ::axi_mem_encoding_type get_memtype() const volatile
    {
        ::axi_mem_encoding_type value = static_cast<::axi_mem_encoding_type>(memtype);
        return value;
    }
    CONSTEXPR axi_limit3_r &set_memtype(::axi_mem_encoding_type value)
    {
        memtype = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_max_outstanding_read_m1() const
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_read_m1);
        return value;
    }
    uint32_t get_max_outstanding_read_m1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_read_m1);
        return value;
    }
    CONSTEXPR axi_limit3_r &set_max_outstanding_read_m1(uint32_t value)
    {
        max_outstanding_read_m1 = ((1u << 8) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_max_outstanding_write_m1() const
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_write_m1);
        return value;
    }
    uint32_t get_max_outstanding_write_m1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(max_outstanding_write_m1);
        return value;
    }
    CONSTEXPR axi_limit3_r &set_max_outstanding_write_m1(uint32_t value)
    {
        max_outstanding_write_m1 = ((1u << 8) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep0_r - Lower 32 bits of the Base pointer for region index 0
struct basep0_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The low word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep0_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep0_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep0_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep0_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep1_r - Upper 32 bits of the Base pointer for region index 0
struct basep1_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The high word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep1_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep1_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep1_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep1_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep2_r - Lower 32 bits of the Base pointer for region index 1
struct basep2_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The low word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep2_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep2_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep2_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep2_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep3_r - Upper 32 bits of the Base pointer for region index 1
struct basep3_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The high word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep3_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep3_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep3_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep3_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep4_r - Lower 32 bits of the Base pointer for region index 2
struct basep4_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The low word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep4_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep4_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep4_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep4_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep5_r - Upper 32 bits of the Base pointer for region index 2
struct basep5_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The high word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep5_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep5_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep5_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep5_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep6_r - Lower 32 bits of the Base pointer for region index 3
struct basep6_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The low word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep6_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep6_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep6_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep6_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep7_r - Upper 32 bits of the Base pointer for region index 3
struct basep7_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The high word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep7_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep7_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep7_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep7_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep8_r - Lower 32 bits of the Base pointer for region index 4
struct basep8_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The low word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep8_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep8_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep8_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep8_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep9_r - Upper 32 bits of the Base pointer for region index 4
struct basep9_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The high word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep9_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep9_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep9_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep9_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep10_r - Lower 32 bits of the Base pointer for region index 5
struct basep10_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The low word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep10_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep10_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep10_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep10_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep11_r - Upper 32 bits of the Base pointer for region index 5
struct basep11_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The high word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep11_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep11_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep11_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep11_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep12_r - Lower 32 bits of the Base pointer for region index 6
struct basep12_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The low word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep12_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep12_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep12_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep12_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep13_r - Upper 32 bits of the Base pointer for region index 6
struct basep13_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The high word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep13_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep13_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep13_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep13_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep14_r - Lower 32 bits of the Base pointer for region index 7
struct basep14_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The low word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep14_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep14_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep14_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep14_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// basep15_r - Upper 32 bits of the Base pointer for region index 7
struct basep15_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t addr_word; // The high word of the 64-bit address
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR basep15_r() : addr_word(static_cast<uint32_t>(0)) {}
    CONSTEXPR basep15_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    basep15_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_addr_word() const
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    uint32_t get_addr_word() const volatile
    {
        uint32_t value = static_cast<uint32_t>(addr_word);
        return value;
    }
    CONSTEXPR basep15_r &set_addr_word(uint32_t value)
    {
        addr_word = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// wd_status_r - WD_STATUS of core DEBUGCORE
struct wd_status_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t core_slice_state : 2; // STATE_HEADER=0, STATE_PALETTE=1, STATE_WEIGHTS=2
            uint32_t core_idle : 1;        // Core idle
            uint32_t ctrl_state : 2;       // IDLE=0, DRAIN=1, OFD_INIT=2, OFD_RUN=3
            uint32_t ctrl_idle : 1;        // All stripe jobs idle (all weights consumed)
            uint32_t write_buf_index0 : 3; // current write index for next data from core
            uint32_t write_buf_valid0 : 1; // write buf valid (full)
            uint32_t write_buf_idle0 : 1;  // write buf idle (empty)
            uint32_t write_buf_index1 : 3; // current write index for next data from core
            uint32_t write_buf_valid1 : 1; // write buf valid (full)
            uint32_t write_buf_idle1 : 1;  // write buf idle (empty)
            uint32_t events : 12;          // WD events mapped as appendix A
            uint32_t reserved0 : 4;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR wd_status_r() :
        core_slice_state(static_cast<uint32_t>(0)), core_idle(static_cast<uint32_t>(0)),
        ctrl_state(static_cast<uint32_t>(0)), ctrl_idle(static_cast<uint32_t>(0)),
        write_buf_index0(static_cast<uint32_t>(0)), write_buf_valid0(static_cast<uint32_t>(0)),
        write_buf_idle0(static_cast<uint32_t>(0)), write_buf_index1(static_cast<uint32_t>(0)),
        write_buf_valid1(static_cast<uint32_t>(0)), write_buf_idle1(static_cast<uint32_t>(0)),
        events(static_cast<uint32_t>(0)), reserved0(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR wd_status_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    wd_status_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_core_slice_state() const
    {
        uint32_t value = static_cast<uint32_t>(core_slice_state);
        return value;
    }
    uint32_t get_core_slice_state() const volatile
    {
        uint32_t value = static_cast<uint32_t>(core_slice_state);
        return value;
    }
    CONSTEXPR wd_status_r &set_core_slice_state(uint32_t value)
    {
        core_slice_state = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_core_idle() const
    {
        uint32_t value = static_cast<uint32_t>(core_idle);
        return value;
    }
    uint32_t get_core_idle() const volatile
    {
        uint32_t value = static_cast<uint32_t>(core_idle);
        return value;
    }
    CONSTEXPR wd_status_r &set_core_idle(uint32_t value)
    {
        core_idle = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_ctrl_state() const
    {
        uint32_t value = static_cast<uint32_t>(ctrl_state);
        return value;
    }
    uint32_t get_ctrl_state() const volatile
    {
        uint32_t value = static_cast<uint32_t>(ctrl_state);
        return value;
    }
    CONSTEXPR wd_status_r &set_ctrl_state(uint32_t value)
    {
        ctrl_state = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_ctrl_idle() const
    {
        uint32_t value = static_cast<uint32_t>(ctrl_idle);
        return value;
    }
    uint32_t get_ctrl_idle() const volatile
    {
        uint32_t value = static_cast<uint32_t>(ctrl_idle);
        return value;
    }
    CONSTEXPR wd_status_r &set_ctrl_idle(uint32_t value)
    {
        ctrl_idle = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_write_buf_index0() const
    {
        uint32_t value = static_cast<uint32_t>(write_buf_index0);
        return value;
    }
    uint32_t get_write_buf_index0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(write_buf_index0);
        return value;
    }
    CONSTEXPR wd_status_r &set_write_buf_index0(uint32_t value)
    {
        write_buf_index0 = ((1u << 3) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_write_buf_valid0() const
    {
        uint32_t value = static_cast<uint32_t>(write_buf_valid0);
        return value;
    }
    uint32_t get_write_buf_valid0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(write_buf_valid0);
        return value;
    }
    CONSTEXPR wd_status_r &set_write_buf_valid0(uint32_t value)
    {
        write_buf_valid0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_write_buf_idle0() const
    {
        uint32_t value = static_cast<uint32_t>(write_buf_idle0);
        return value;
    }
    uint32_t get_write_buf_idle0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(write_buf_idle0);
        return value;
    }
    CONSTEXPR wd_status_r &set_write_buf_idle0(uint32_t value)
    {
        write_buf_idle0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_write_buf_index1() const
    {
        uint32_t value = static_cast<uint32_t>(write_buf_index1);
        return value;
    }
    uint32_t get_write_buf_index1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(write_buf_index1);
        return value;
    }
    CONSTEXPR wd_status_r &set_write_buf_index1(uint32_t value)
    {
        write_buf_index1 = ((1u << 3) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_write_buf_valid1() const
    {
        uint32_t value = static_cast<uint32_t>(write_buf_valid1);
        return value;
    }
    uint32_t get_write_buf_valid1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(write_buf_valid1);
        return value;
    }
    CONSTEXPR wd_status_r &set_write_buf_valid1(uint32_t value)
    {
        write_buf_valid1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_write_buf_idle1() const
    {
        uint32_t value = static_cast<uint32_t>(write_buf_idle1);
        return value;
    }
    uint32_t get_write_buf_idle1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(write_buf_idle1);
        return value;
    }
    CONSTEXPR wd_status_r &set_write_buf_idle1(uint32_t value)
    {
        write_buf_idle1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_events() const
    {
        uint32_t value = static_cast<uint32_t>(events);
        return value;
    }
    uint32_t get_events() const volatile
    {
        uint32_t value = static_cast<uint32_t>(events);
        return value;
    }
    CONSTEXPR wd_status_r &set_events(uint32_t value)
    {
        events = ((1u << 12) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// mac_status_r - MAC_STATUS of core DEBUGCORE
struct mac_status_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t block_cfg_valid : 1;     // MAC has a valid block configuration
            uint32_t trav_en : 1;             // MAC is doing block traversal
            uint32_t wait_for_ib : 1;         // MAC is waiting for an Input Buffer to become available
            uint32_t wait_for_acc_buf : 1;    // MAC is waiting for an Accumulator Buffer to become available
            uint32_t wait_for_weights : 1;    // MAC is waiting for a Weight Block to become available
            uint32_t stall_stripe : 1;        // MAC is stalling between two stripes
            uint32_t dw_sel : 1;              // Currently used weight interface in MAC AI
            uint32_t wait_for_dw0_ready : 1;  // MAC AI is waiting for MAC DPU to send dw0_ready to WD
            uint32_t wait_for_dw1_ready : 1;  // MAC AI is waiting for MAC DPU to send dw1_ready to WD
            uint32_t acc_buf_sel_ai : 1;      // Currently used AccBuf interface in MAC AI
            uint32_t wait_for_acc0_ready : 1; // MAC AI is waiting for acc0_ready from AO
            uint32_t wait_for_acc1_ready : 1; // MAC AI is waiting for acc1_ready from AO
            uint32_t acc_buf_sel_aa : 1;      // Currently used AccBuf interface in MAC ADDER_ARRAY
            uint32_t acc0_valid : 1;          // MAC outgoing value of acc0_valid
            uint32_t acc1_valid : 1;          // MAC outgoing value of acc1_valid
            uint32_t reserved0 : 1;
            uint32_t events : 11; // Mapped to MAC events described in Appendix A
            uint32_t reserved1 : 5;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR mac_status_r() :
        block_cfg_valid(static_cast<uint32_t>(0)), trav_en(static_cast<uint32_t>(0)),
        wait_for_ib(static_cast<uint32_t>(0)), wait_for_acc_buf(static_cast<uint32_t>(0)),
        wait_for_weights(static_cast<uint32_t>(0)), stall_stripe(static_cast<uint32_t>(0)),
        dw_sel(static_cast<uint32_t>(0)), wait_for_dw0_ready(static_cast<uint32_t>(0)),
        wait_for_dw1_ready(static_cast<uint32_t>(0)), acc_buf_sel_ai(static_cast<uint32_t>(0)),
        wait_for_acc0_ready(static_cast<uint32_t>(0)), wait_for_acc1_ready(static_cast<uint32_t>(0)),
        acc_buf_sel_aa(static_cast<uint32_t>(0)), acc0_valid(static_cast<uint32_t>(0)),
        acc1_valid(static_cast<uint32_t>(0)), reserved0(static_cast<uint32_t>(0)), events(static_cast<uint32_t>(0)),
        reserved1(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR mac_status_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    mac_status_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_block_cfg_valid() const
    {
        uint32_t value = static_cast<uint32_t>(block_cfg_valid);
        return value;
    }
    uint32_t get_block_cfg_valid() const volatile
    {
        uint32_t value = static_cast<uint32_t>(block_cfg_valid);
        return value;
    }
    CONSTEXPR mac_status_r &set_block_cfg_valid(uint32_t value)
    {
        block_cfg_valid = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_trav_en() const
    {
        uint32_t value = static_cast<uint32_t>(trav_en);
        return value;
    }
    uint32_t get_trav_en() const volatile
    {
        uint32_t value = static_cast<uint32_t>(trav_en);
        return value;
    }
    CONSTEXPR mac_status_r &set_trav_en(uint32_t value)
    {
        trav_en = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_wait_for_ib() const
    {
        uint32_t value = static_cast<uint32_t>(wait_for_ib);
        return value;
    }
    uint32_t get_wait_for_ib() const volatile
    {
        uint32_t value = static_cast<uint32_t>(wait_for_ib);
        return value;
    }
    CONSTEXPR mac_status_r &set_wait_for_ib(uint32_t value)
    {
        wait_for_ib = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_wait_for_acc_buf() const
    {
        uint32_t value = static_cast<uint32_t>(wait_for_acc_buf);
        return value;
    }
    uint32_t get_wait_for_acc_buf() const volatile
    {
        uint32_t value = static_cast<uint32_t>(wait_for_acc_buf);
        return value;
    }
    CONSTEXPR mac_status_r &set_wait_for_acc_buf(uint32_t value)
    {
        wait_for_acc_buf = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_wait_for_weights() const
    {
        uint32_t value = static_cast<uint32_t>(wait_for_weights);
        return value;
    }
    uint32_t get_wait_for_weights() const volatile
    {
        uint32_t value = static_cast<uint32_t>(wait_for_weights);
        return value;
    }
    CONSTEXPR mac_status_r &set_wait_for_weights(uint32_t value)
    {
        wait_for_weights = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_stall_stripe() const
    {
        uint32_t value = static_cast<uint32_t>(stall_stripe);
        return value;
    }
    uint32_t get_stall_stripe() const volatile
    {
        uint32_t value = static_cast<uint32_t>(stall_stripe);
        return value;
    }
    CONSTEXPR mac_status_r &set_stall_stripe(uint32_t value)
    {
        stall_stripe = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_dw_sel() const
    {
        uint32_t value = static_cast<uint32_t>(dw_sel);
        return value;
    }
    uint32_t get_dw_sel() const volatile
    {
        uint32_t value = static_cast<uint32_t>(dw_sel);
        return value;
    }
    CONSTEXPR mac_status_r &set_dw_sel(uint32_t value)
    {
        dw_sel = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_wait_for_dw0_ready() const
    {
        uint32_t value = static_cast<uint32_t>(wait_for_dw0_ready);
        return value;
    }
    uint32_t get_wait_for_dw0_ready() const volatile
    {
        uint32_t value = static_cast<uint32_t>(wait_for_dw0_ready);
        return value;
    }
    CONSTEXPR mac_status_r &set_wait_for_dw0_ready(uint32_t value)
    {
        wait_for_dw0_ready = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_wait_for_dw1_ready() const
    {
        uint32_t value = static_cast<uint32_t>(wait_for_dw1_ready);
        return value;
    }
    uint32_t get_wait_for_dw1_ready() const volatile
    {
        uint32_t value = static_cast<uint32_t>(wait_for_dw1_ready);
        return value;
    }
    CONSTEXPR mac_status_r &set_wait_for_dw1_ready(uint32_t value)
    {
        wait_for_dw1_ready = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_acc_buf_sel_ai() const
    {
        uint32_t value = static_cast<uint32_t>(acc_buf_sel_ai);
        return value;
    }
    uint32_t get_acc_buf_sel_ai() const volatile
    {
        uint32_t value = static_cast<uint32_t>(acc_buf_sel_ai);
        return value;
    }
    CONSTEXPR mac_status_r &set_acc_buf_sel_ai(uint32_t value)
    {
        acc_buf_sel_ai = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_wait_for_acc0_ready() const
    {
        uint32_t value = static_cast<uint32_t>(wait_for_acc0_ready);
        return value;
    }
    uint32_t get_wait_for_acc0_ready() const volatile
    {
        uint32_t value = static_cast<uint32_t>(wait_for_acc0_ready);
        return value;
    }
    CONSTEXPR mac_status_r &set_wait_for_acc0_ready(uint32_t value)
    {
        wait_for_acc0_ready = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_wait_for_acc1_ready() const
    {
        uint32_t value = static_cast<uint32_t>(wait_for_acc1_ready);
        return value;
    }
    uint32_t get_wait_for_acc1_ready() const volatile
    {
        uint32_t value = static_cast<uint32_t>(wait_for_acc1_ready);
        return value;
    }
    CONSTEXPR mac_status_r &set_wait_for_acc1_ready(uint32_t value)
    {
        wait_for_acc1_ready = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_acc_buf_sel_aa() const
    {
        uint32_t value = static_cast<uint32_t>(acc_buf_sel_aa);
        return value;
    }
    uint32_t get_acc_buf_sel_aa() const volatile
    {
        uint32_t value = static_cast<uint32_t>(acc_buf_sel_aa);
        return value;
    }
    CONSTEXPR mac_status_r &set_acc_buf_sel_aa(uint32_t value)
    {
        acc_buf_sel_aa = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_acc0_valid() const
    {
        uint32_t value = static_cast<uint32_t>(acc0_valid);
        return value;
    }
    uint32_t get_acc0_valid() const volatile
    {
        uint32_t value = static_cast<uint32_t>(acc0_valid);
        return value;
    }
    CONSTEXPR mac_status_r &set_acc0_valid(uint32_t value)
    {
        acc0_valid = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_acc1_valid() const
    {
        uint32_t value = static_cast<uint32_t>(acc1_valid);
        return value;
    }
    uint32_t get_acc1_valid() const volatile
    {
        uint32_t value = static_cast<uint32_t>(acc1_valid);
        return value;
    }
    CONSTEXPR mac_status_r &set_acc1_valid(uint32_t value)
    {
        acc1_valid = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_events() const
    {
        uint32_t value = static_cast<uint32_t>(events);
        return value;
    }
    uint32_t get_events() const volatile
    {
        uint32_t value = static_cast<uint32_t>(events);
        return value;
    }
    CONSTEXPR mac_status_r &set_events(uint32_t value)
    {
        events = ((1u << 11) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// ao_status_r - AO_STATUS of core DEBUGCORE
struct ao_status_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t cmd_sbw_valid : 1; // Block command to shared buffer write module is valid.
            uint32_t cmd_act_valid : 1; // Block command to activation function module is valid.
            uint32_t cmd_ctl_valid : 1; // Block command to control module is valid.
            uint32_t cmd_scl_valid : 1; // Block command to scale module is valid.
            uint32_t cmd_sbr_valid : 1; // Block command to shared buffer read module is valid.
            uint32_t cmd_ofm_valid : 1; // Block command to ofm parameter module is valid.
            uint32_t blk_cmd_ready : 1; // Ready to accept block command.
            uint32_t blk_cmd_valid : 1; // Block command from CC is valid.
            uint32_t reserved0 : 8;
            uint32_t events : 8; // Mapped to AO events described in Appendix A.
            uint32_t reserved1 : 8;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR ao_status_r() :
        cmd_sbw_valid(static_cast<uint32_t>(0)), cmd_act_valid(static_cast<uint32_t>(0)),
        cmd_ctl_valid(static_cast<uint32_t>(0)), cmd_scl_valid(static_cast<uint32_t>(0)),
        cmd_sbr_valid(static_cast<uint32_t>(0)), cmd_ofm_valid(static_cast<uint32_t>(0)),
        blk_cmd_ready(static_cast<uint32_t>(0)), blk_cmd_valid(static_cast<uint32_t>(0)),
        reserved0(static_cast<uint32_t>(0)), events(static_cast<uint32_t>(0)), reserved1(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR ao_status_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    ao_status_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_cmd_sbw_valid() const
    {
        uint32_t value = static_cast<uint32_t>(cmd_sbw_valid);
        return value;
    }
    uint32_t get_cmd_sbw_valid() const volatile
    {
        uint32_t value = static_cast<uint32_t>(cmd_sbw_valid);
        return value;
    }
    CONSTEXPR ao_status_r &set_cmd_sbw_valid(uint32_t value)
    {
        cmd_sbw_valid = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_cmd_act_valid() const
    {
        uint32_t value = static_cast<uint32_t>(cmd_act_valid);
        return value;
    }
    uint32_t get_cmd_act_valid() const volatile
    {
        uint32_t value = static_cast<uint32_t>(cmd_act_valid);
        return value;
    }
    CONSTEXPR ao_status_r &set_cmd_act_valid(uint32_t value)
    {
        cmd_act_valid = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_cmd_ctl_valid() const
    {
        uint32_t value = static_cast<uint32_t>(cmd_ctl_valid);
        return value;
    }
    uint32_t get_cmd_ctl_valid() const volatile
    {
        uint32_t value = static_cast<uint32_t>(cmd_ctl_valid);
        return value;
    }
    CONSTEXPR ao_status_r &set_cmd_ctl_valid(uint32_t value)
    {
        cmd_ctl_valid = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_cmd_scl_valid() const
    {
        uint32_t value = static_cast<uint32_t>(cmd_scl_valid);
        return value;
    }
    uint32_t get_cmd_scl_valid() const volatile
    {
        uint32_t value = static_cast<uint32_t>(cmd_scl_valid);
        return value;
    }
    CONSTEXPR ao_status_r &set_cmd_scl_valid(uint32_t value)
    {
        cmd_scl_valid = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_cmd_sbr_valid() const
    {
        uint32_t value = static_cast<uint32_t>(cmd_sbr_valid);
        return value;
    }
    uint32_t get_cmd_sbr_valid() const volatile
    {
        uint32_t value = static_cast<uint32_t>(cmd_sbr_valid);
        return value;
    }
    CONSTEXPR ao_status_r &set_cmd_sbr_valid(uint32_t value)
    {
        cmd_sbr_valid = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_cmd_ofm_valid() const
    {
        uint32_t value = static_cast<uint32_t>(cmd_ofm_valid);
        return value;
    }
    uint32_t get_cmd_ofm_valid() const volatile
    {
        uint32_t value = static_cast<uint32_t>(cmd_ofm_valid);
        return value;
    }
    CONSTEXPR ao_status_r &set_cmd_ofm_valid(uint32_t value)
    {
        cmd_ofm_valid = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_blk_cmd_ready() const
    {
        uint32_t value = static_cast<uint32_t>(blk_cmd_ready);
        return value;
    }
    uint32_t get_blk_cmd_ready() const volatile
    {
        uint32_t value = static_cast<uint32_t>(blk_cmd_ready);
        return value;
    }
    CONSTEXPR ao_status_r &set_blk_cmd_ready(uint32_t value)
    {
        blk_cmd_ready = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_blk_cmd_valid() const
    {
        uint32_t value = static_cast<uint32_t>(blk_cmd_valid);
        return value;
    }
    uint32_t get_blk_cmd_valid() const volatile
    {
        uint32_t value = static_cast<uint32_t>(blk_cmd_valid);
        return value;
    }
    CONSTEXPR ao_status_r &set_blk_cmd_valid(uint32_t value)
    {
        blk_cmd_valid = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_events() const
    {
        uint32_t value = static_cast<uint32_t>(events);
        return value;
    }
    uint32_t get_events() const volatile
    {
        uint32_t value = static_cast<uint32_t>(events);
        return value;
    }
    CONSTEXPR ao_status_r &set_events(uint32_t value)
    {
        events = ((1u << 8) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// dma_status0_r - DMA_STATUS0 of core DEBUGCORE
struct dma_status0_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t CMD_IDLE : 1; // When this bit is high means that the CMD block is not busy in generating addresses
                                   // for a CMD job.
            uint32_t IFM_IDLE : 1; // When this bit is high means that there are no ongoing IFM jobs
            uint32_t WGT_IDLE_C0 : 1; // When this bit is high means that the WGT block is not busy in generating
                                      // addresses for a WGT job
            uint32_t BAS_IDLE_C0 : 1; // When this bit is high means that the BAS block is not busy in generating
                                      // addresses for a BAS job
            uint32_t M2M_IDLE : 1;    // When this bit is high means that there are no ongoing M2M jobs
            uint32_t OFM_IDLE : 1;    // When this bit is high means that there are no ongoing OFM jobs
            uint32_t HALT_REQ : 1;    // CPM has requested to HALT AXI bus before soft reset
            uint32_t HALT_ACK : 1;    // DMA is in condition to halt the AXI bus since there are no pending transactions
            uint32_t PAUSE_REQ : 1;   // CC has requested to pause the AXI
            uint32_t PAUSE_ACK : 1; // DMA is in condition to pause the AXI bus since there are no pending transactions
            uint32_t IB0_AI_VALID_C0 : 1;       // Data for AI to be read in IFM input buffer 0 - Core 0
            uint32_t IB0_AI_READY_C0 : 1;       // Data consumed from AI in IFM input buffer 0 - Core 0
            uint32_t IB1_AI_VALID_C0 : 1;       // Data for AI to be read in IFM input buffer 1 - Core 0
            uint32_t IB1_AI_READY_C0 : 1;       // Data consumed from AI in IFM input buffer 1 - Core 0
            uint32_t IB0_AO_VALID_C0 : 1;       // Data for AO to be read in IFM input buffer 0 - Core 0
            uint32_t IB0_AO_READY_C0 : 1;       // Data consumed from AO in IFM input buffer 0 - Core 0
            uint32_t IB1_AO_VALID_C0 : 1;       // Data for AO to be read in IFM input buffer 0 - Core 0
            uint32_t IB1_AO_READY_C0 : 1;       // Data consumed from AO in IFM input buffer 1 - Core 0
            uint32_t OB0_VALID_C0 : 1;          // Data for DMA ready to be consumed in OFM output buffer 0 -  Core 0
            uint32_t OB0_READY_C0 : 1;          // Data consumed from DMA in OFM output buffer 0 - Core 0
            uint32_t OB1_VALID_C0 : 1;          // Data for DMA ready to be consumed in OFM output buffer 1 -  Core 0
            uint32_t OB1_READY_C0 : 1;          // Data consumed from DMA in OFM output buffer 1 - Core 0
            uint32_t CMD_VALID : 1;             // New command word for CC to be consumed
            uint32_t CMD_READY : 1;             // command word consumed by CC
            uint32_t WD_BITSTREAM_VALID_C0 : 1; // New weight word for WD to be consumed - Core 0
            uint32_t WD_BITSTREAM_READY_C0 : 1; // Weight word consumed by WD - Core 0
            uint32_t BS_BITSTREAM_VALID_C0 : 1; // New BaS word for AO to be consumed - Core 0
            uint32_t BS_BITSTREAM_READY_C0 : 1; // BaS word consumed by AO - Core 0
            uint32_t AXI0_AR_STALLED : 1; // Read transfer request stalled on arready low AXI0 (due to memory system)
            uint32_t AXI0_RD_LIMIT_STALL : 1; // Read stalled due to one AXI0 limit counter being reached
            uint32_t AXI0_AW_STALLED : 1; // Write transfer request stalled on awready low AXI0 (due to memory system)
            uint32_t AXI0_W_STALLED : 1;  // Write transfer stalled on awready low AXI0 (due to memory system)
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR dma_status0_r() :
        CMD_IDLE(static_cast<uint32_t>(0)), IFM_IDLE(static_cast<uint32_t>(0)), WGT_IDLE_C0(static_cast<uint32_t>(0)),
        BAS_IDLE_C0(static_cast<uint32_t>(0)), M2M_IDLE(static_cast<uint32_t>(0)), OFM_IDLE(static_cast<uint32_t>(0)),
        HALT_REQ(static_cast<uint32_t>(0)), HALT_ACK(static_cast<uint32_t>(0)), PAUSE_REQ(static_cast<uint32_t>(0)),
        PAUSE_ACK(static_cast<uint32_t>(0)), IB0_AI_VALID_C0(static_cast<uint32_t>(0)),
        IB0_AI_READY_C0(static_cast<uint32_t>(0)), IB1_AI_VALID_C0(static_cast<uint32_t>(0)),
        IB1_AI_READY_C0(static_cast<uint32_t>(0)), IB0_AO_VALID_C0(static_cast<uint32_t>(0)),
        IB0_AO_READY_C0(static_cast<uint32_t>(0)), IB1_AO_VALID_C0(static_cast<uint32_t>(0)),
        IB1_AO_READY_C0(static_cast<uint32_t>(0)), OB0_VALID_C0(static_cast<uint32_t>(0)),
        OB0_READY_C0(static_cast<uint32_t>(0)), OB1_VALID_C0(static_cast<uint32_t>(0)),
        OB1_READY_C0(static_cast<uint32_t>(0)), CMD_VALID(static_cast<uint32_t>(0)),
        CMD_READY(static_cast<uint32_t>(0)), WD_BITSTREAM_VALID_C0(static_cast<uint32_t>(0)),
        WD_BITSTREAM_READY_C0(static_cast<uint32_t>(0)), BS_BITSTREAM_VALID_C0(static_cast<uint32_t>(0)),
        BS_BITSTREAM_READY_C0(static_cast<uint32_t>(0)), AXI0_AR_STALLED(static_cast<uint32_t>(0)),
        AXI0_RD_LIMIT_STALL(static_cast<uint32_t>(0)), AXI0_AW_STALLED(static_cast<uint32_t>(0)),
        AXI0_W_STALLED(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR dma_status0_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    dma_status0_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_CMD_IDLE() const
    {
        uint32_t value = static_cast<uint32_t>(CMD_IDLE);
        return value;
    }
    uint32_t get_CMD_IDLE() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CMD_IDLE);
        return value;
    }
    CONSTEXPR dma_status0_r &set_CMD_IDLE(uint32_t value)
    {
        CMD_IDLE = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IFM_IDLE() const
    {
        uint32_t value = static_cast<uint32_t>(IFM_IDLE);
        return value;
    }
    uint32_t get_IFM_IDLE() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IFM_IDLE);
        return value;
    }
    CONSTEXPR dma_status0_r &set_IFM_IDLE(uint32_t value)
    {
        IFM_IDLE = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_WGT_IDLE_C0() const
    {
        uint32_t value = static_cast<uint32_t>(WGT_IDLE_C0);
        return value;
    }
    uint32_t get_WGT_IDLE_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(WGT_IDLE_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_WGT_IDLE_C0(uint32_t value)
    {
        WGT_IDLE_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_BAS_IDLE_C0() const
    {
        uint32_t value = static_cast<uint32_t>(BAS_IDLE_C0);
        return value;
    }
    uint32_t get_BAS_IDLE_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(BAS_IDLE_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_BAS_IDLE_C0(uint32_t value)
    {
        BAS_IDLE_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_M2M_IDLE() const
    {
        uint32_t value = static_cast<uint32_t>(M2M_IDLE);
        return value;
    }
    uint32_t get_M2M_IDLE() const volatile
    {
        uint32_t value = static_cast<uint32_t>(M2M_IDLE);
        return value;
    }
    CONSTEXPR dma_status0_r &set_M2M_IDLE(uint32_t value)
    {
        M2M_IDLE = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_OFM_IDLE() const
    {
        uint32_t value = static_cast<uint32_t>(OFM_IDLE);
        return value;
    }
    uint32_t get_OFM_IDLE() const volatile
    {
        uint32_t value = static_cast<uint32_t>(OFM_IDLE);
        return value;
    }
    CONSTEXPR dma_status0_r &set_OFM_IDLE(uint32_t value)
    {
        OFM_IDLE = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_HALT_REQ() const
    {
        uint32_t value = static_cast<uint32_t>(HALT_REQ);
        return value;
    }
    uint32_t get_HALT_REQ() const volatile
    {
        uint32_t value = static_cast<uint32_t>(HALT_REQ);
        return value;
    }
    CONSTEXPR dma_status0_r &set_HALT_REQ(uint32_t value)
    {
        HALT_REQ = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_HALT_ACK() const
    {
        uint32_t value = static_cast<uint32_t>(HALT_ACK);
        return value;
    }
    uint32_t get_HALT_ACK() const volatile
    {
        uint32_t value = static_cast<uint32_t>(HALT_ACK);
        return value;
    }
    CONSTEXPR dma_status0_r &set_HALT_ACK(uint32_t value)
    {
        HALT_ACK = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_PAUSE_REQ() const
    {
        uint32_t value = static_cast<uint32_t>(PAUSE_REQ);
        return value;
    }
    uint32_t get_PAUSE_REQ() const volatile
    {
        uint32_t value = static_cast<uint32_t>(PAUSE_REQ);
        return value;
    }
    CONSTEXPR dma_status0_r &set_PAUSE_REQ(uint32_t value)
    {
        PAUSE_REQ = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_PAUSE_ACK() const
    {
        uint32_t value = static_cast<uint32_t>(PAUSE_ACK);
        return value;
    }
    uint32_t get_PAUSE_ACK() const volatile
    {
        uint32_t value = static_cast<uint32_t>(PAUSE_ACK);
        return value;
    }
    CONSTEXPR dma_status0_r &set_PAUSE_ACK(uint32_t value)
    {
        PAUSE_ACK = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB0_AI_VALID_C0() const
    {
        uint32_t value = static_cast<uint32_t>(IB0_AI_VALID_C0);
        return value;
    }
    uint32_t get_IB0_AI_VALID_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB0_AI_VALID_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_IB0_AI_VALID_C0(uint32_t value)
    {
        IB0_AI_VALID_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB0_AI_READY_C0() const
    {
        uint32_t value = static_cast<uint32_t>(IB0_AI_READY_C0);
        return value;
    }
    uint32_t get_IB0_AI_READY_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB0_AI_READY_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_IB0_AI_READY_C0(uint32_t value)
    {
        IB0_AI_READY_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB1_AI_VALID_C0() const
    {
        uint32_t value = static_cast<uint32_t>(IB1_AI_VALID_C0);
        return value;
    }
    uint32_t get_IB1_AI_VALID_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB1_AI_VALID_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_IB1_AI_VALID_C0(uint32_t value)
    {
        IB1_AI_VALID_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB1_AI_READY_C0() const
    {
        uint32_t value = static_cast<uint32_t>(IB1_AI_READY_C0);
        return value;
    }
    uint32_t get_IB1_AI_READY_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB1_AI_READY_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_IB1_AI_READY_C0(uint32_t value)
    {
        IB1_AI_READY_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB0_AO_VALID_C0() const
    {
        uint32_t value = static_cast<uint32_t>(IB0_AO_VALID_C0);
        return value;
    }
    uint32_t get_IB0_AO_VALID_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB0_AO_VALID_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_IB0_AO_VALID_C0(uint32_t value)
    {
        IB0_AO_VALID_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB0_AO_READY_C0() const
    {
        uint32_t value = static_cast<uint32_t>(IB0_AO_READY_C0);
        return value;
    }
    uint32_t get_IB0_AO_READY_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB0_AO_READY_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_IB0_AO_READY_C0(uint32_t value)
    {
        IB0_AO_READY_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB1_AO_VALID_C0() const
    {
        uint32_t value = static_cast<uint32_t>(IB1_AO_VALID_C0);
        return value;
    }
    uint32_t get_IB1_AO_VALID_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB1_AO_VALID_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_IB1_AO_VALID_C0(uint32_t value)
    {
        IB1_AO_VALID_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB1_AO_READY_C0() const
    {
        uint32_t value = static_cast<uint32_t>(IB1_AO_READY_C0);
        return value;
    }
    uint32_t get_IB1_AO_READY_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB1_AO_READY_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_IB1_AO_READY_C0(uint32_t value)
    {
        IB1_AO_READY_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_OB0_VALID_C0() const
    {
        uint32_t value = static_cast<uint32_t>(OB0_VALID_C0);
        return value;
    }
    uint32_t get_OB0_VALID_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(OB0_VALID_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_OB0_VALID_C0(uint32_t value)
    {
        OB0_VALID_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_OB0_READY_C0() const
    {
        uint32_t value = static_cast<uint32_t>(OB0_READY_C0);
        return value;
    }
    uint32_t get_OB0_READY_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(OB0_READY_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_OB0_READY_C0(uint32_t value)
    {
        OB0_READY_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_OB1_VALID_C0() const
    {
        uint32_t value = static_cast<uint32_t>(OB1_VALID_C0);
        return value;
    }
    uint32_t get_OB1_VALID_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(OB1_VALID_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_OB1_VALID_C0(uint32_t value)
    {
        OB1_VALID_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_OB1_READY_C0() const
    {
        uint32_t value = static_cast<uint32_t>(OB1_READY_C0);
        return value;
    }
    uint32_t get_OB1_READY_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(OB1_READY_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_OB1_READY_C0(uint32_t value)
    {
        OB1_READY_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_CMD_VALID() const
    {
        uint32_t value = static_cast<uint32_t>(CMD_VALID);
        return value;
    }
    uint32_t get_CMD_VALID() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CMD_VALID);
        return value;
    }
    CONSTEXPR dma_status0_r &set_CMD_VALID(uint32_t value)
    {
        CMD_VALID = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_CMD_READY() const
    {
        uint32_t value = static_cast<uint32_t>(CMD_READY);
        return value;
    }
    uint32_t get_CMD_READY() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CMD_READY);
        return value;
    }
    CONSTEXPR dma_status0_r &set_CMD_READY(uint32_t value)
    {
        CMD_READY = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_WD_BITSTREAM_VALID_C0() const
    {
        uint32_t value = static_cast<uint32_t>(WD_BITSTREAM_VALID_C0);
        return value;
    }
    uint32_t get_WD_BITSTREAM_VALID_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(WD_BITSTREAM_VALID_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_WD_BITSTREAM_VALID_C0(uint32_t value)
    {
        WD_BITSTREAM_VALID_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_WD_BITSTREAM_READY_C0() const
    {
        uint32_t value = static_cast<uint32_t>(WD_BITSTREAM_READY_C0);
        return value;
    }
    uint32_t get_WD_BITSTREAM_READY_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(WD_BITSTREAM_READY_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_WD_BITSTREAM_READY_C0(uint32_t value)
    {
        WD_BITSTREAM_READY_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_BS_BITSTREAM_VALID_C0() const
    {
        uint32_t value = static_cast<uint32_t>(BS_BITSTREAM_VALID_C0);
        return value;
    }
    uint32_t get_BS_BITSTREAM_VALID_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(BS_BITSTREAM_VALID_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_BS_BITSTREAM_VALID_C0(uint32_t value)
    {
        BS_BITSTREAM_VALID_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_BS_BITSTREAM_READY_C0() const
    {
        uint32_t value = static_cast<uint32_t>(BS_BITSTREAM_READY_C0);
        return value;
    }
    uint32_t get_BS_BITSTREAM_READY_C0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(BS_BITSTREAM_READY_C0);
        return value;
    }
    CONSTEXPR dma_status0_r &set_BS_BITSTREAM_READY_C0(uint32_t value)
    {
        BS_BITSTREAM_READY_C0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_AXI0_AR_STALLED() const
    {
        uint32_t value = static_cast<uint32_t>(AXI0_AR_STALLED);
        return value;
    }
    uint32_t get_AXI0_AR_STALLED() const volatile
    {
        uint32_t value = static_cast<uint32_t>(AXI0_AR_STALLED);
        return value;
    }
    CONSTEXPR dma_status0_r &set_AXI0_AR_STALLED(uint32_t value)
    {
        AXI0_AR_STALLED = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_AXI0_RD_LIMIT_STALL() const
    {
        uint32_t value = static_cast<uint32_t>(AXI0_RD_LIMIT_STALL);
        return value;
    }
    uint32_t get_AXI0_RD_LIMIT_STALL() const volatile
    {
        uint32_t value = static_cast<uint32_t>(AXI0_RD_LIMIT_STALL);
        return value;
    }
    CONSTEXPR dma_status0_r &set_AXI0_RD_LIMIT_STALL(uint32_t value)
    {
        AXI0_RD_LIMIT_STALL = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_AXI0_AW_STALLED() const
    {
        uint32_t value = static_cast<uint32_t>(AXI0_AW_STALLED);
        return value;
    }
    uint32_t get_AXI0_AW_STALLED() const volatile
    {
        uint32_t value = static_cast<uint32_t>(AXI0_AW_STALLED);
        return value;
    }
    CONSTEXPR dma_status0_r &set_AXI0_AW_STALLED(uint32_t value)
    {
        AXI0_AW_STALLED = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_AXI0_W_STALLED() const
    {
        uint32_t value = static_cast<uint32_t>(AXI0_W_STALLED);
        return value;
    }
    uint32_t get_AXI0_W_STALLED() const volatile
    {
        uint32_t value = static_cast<uint32_t>(AXI0_W_STALLED);
        return value;
    }
    CONSTEXPR dma_status0_r &set_AXI0_W_STALLED(uint32_t value)
    {
        AXI0_W_STALLED = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// dma_status1_r - DMA_STATUS1 of core DEBUGCORE
struct dma_status1_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t AXI0_WR_LIMIT_STALL : 1; // Write stalled due to one AXI0 limit counter being reached
            uint32_t AXI1_AR_STALLED : 1; // Read transfer request stalled on arready low AXI1 (due to memory system)
            uint32_t AXI1_RD_LIMIT_STALL : 1; // Read stalled due to one AXI1 limit counter being reached
            uint32_t AXI1_WR_STALLED : 1; // Write transfer request stalled on awready low AXI1 (due to memory system)
            uint32_t AXI1_W_STALLED : 1;  // Write transfer stalled on wready low AXI1 (due to memory system)
            uint32_t AXI1_WR_LIMIT_STALL : 1; // Write stalled due to one AXI1 limit counter being reached
            uint32_t WGT_IDLE_C1 : 1;     // When this bit is high means that the WGT block is not busy in generating
                                          // addresses for a WGT job
            uint32_t BAS_IDLE_C1 : 1;     // When this bit is high means that the BAS block is not busy in generating
                                          // addresses for a BAS job.
            uint32_t IB0_AI_VALID_C1 : 1; // Data for AI to be read in IFM input buffer 0 - Core 1
            uint32_t IB0_AI_READY_C1 : 1; // Data consumed from AI in IFM input buffer 0 - Core 1
            uint32_t IB1_AI_VALID_C1 : 1; // Data for AI to be read in IFM input buffer 1 - Core 1
            uint32_t IB1_AI_READY_C1 : 1; // Data consumed from AI in IFM input buffer 1 - Core 1
            uint32_t IB0_AO_VALID_C1 : 1; // Data for AO to be read in IFM input buffer 0 - Core 1
            uint32_t IB0_AO_READY_C1 : 1; // Data consumed from AO in IFM input buffer 0 - Core 1
            uint32_t IB1_AO_VALID_C1 : 1; // Data for AO to be read in IFM input buffer 0 - Core 1
            uint32_t IB1_AO_READY_C1 : 1; // Data consumed from AO in IFM input buffer 1 - Core 1
            uint32_t OB0_VALID_C1 : 1;    // Data for DMA ready to be consumed in OFM output buffer 0 - Core 1
            uint32_t OB0_READY_C1 : 1;    // Data consumed from DMA in OFM output buffer 0 - Core 1
            uint32_t OB1_VALID_C1 : 1;    // Data for DMA ready to be consumed in OFM output buffer 1 - Core 1
            uint32_t OB1_READY_C1 : 1;    // Data consumed from DMA in OFM output buffer 1 - Core 1
            uint32_t WD_BITSTREAM_VALID_C1 : 1; // New weight word for WD to be consumed - Core 1
            uint32_t WD_BITSTREAM_READY_C1 : 1; // Weight word consumed by WD - Core 1
            uint32_t BS_BITSTREAM_VALID_C1 : 1; // New BaS word for AO to be consumed - Core 1
            uint32_t BS_BITSTREAM_READY_C1 : 1; // BaS word consumed by AO - Core 1
            uint32_t reserved0 : 8;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR dma_status1_r() :
        AXI0_WR_LIMIT_STALL(static_cast<uint32_t>(0)), AXI1_AR_STALLED(static_cast<uint32_t>(0)),
        AXI1_RD_LIMIT_STALL(static_cast<uint32_t>(0)), AXI1_WR_STALLED(static_cast<uint32_t>(0)),
        AXI1_W_STALLED(static_cast<uint32_t>(0)), AXI1_WR_LIMIT_STALL(static_cast<uint32_t>(0)),
        WGT_IDLE_C1(static_cast<uint32_t>(0)), BAS_IDLE_C1(static_cast<uint32_t>(0)),
        IB0_AI_VALID_C1(static_cast<uint32_t>(0)), IB0_AI_READY_C1(static_cast<uint32_t>(0)),
        IB1_AI_VALID_C1(static_cast<uint32_t>(0)), IB1_AI_READY_C1(static_cast<uint32_t>(0)),
        IB0_AO_VALID_C1(static_cast<uint32_t>(0)), IB0_AO_READY_C1(static_cast<uint32_t>(0)),
        IB1_AO_VALID_C1(static_cast<uint32_t>(0)), IB1_AO_READY_C1(static_cast<uint32_t>(0)),
        OB0_VALID_C1(static_cast<uint32_t>(0)), OB0_READY_C1(static_cast<uint32_t>(0)),
        OB1_VALID_C1(static_cast<uint32_t>(0)), OB1_READY_C1(static_cast<uint32_t>(0)),
        WD_BITSTREAM_VALID_C1(static_cast<uint32_t>(0)), WD_BITSTREAM_READY_C1(static_cast<uint32_t>(0)),
        BS_BITSTREAM_VALID_C1(static_cast<uint32_t>(0)), BS_BITSTREAM_READY_C1(static_cast<uint32_t>(0)),
        reserved0(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR dma_status1_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    dma_status1_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_AXI0_WR_LIMIT_STALL() const
    {
        uint32_t value = static_cast<uint32_t>(AXI0_WR_LIMIT_STALL);
        return value;
    }
    uint32_t get_AXI0_WR_LIMIT_STALL() const volatile
    {
        uint32_t value = static_cast<uint32_t>(AXI0_WR_LIMIT_STALL);
        return value;
    }
    CONSTEXPR dma_status1_r &set_AXI0_WR_LIMIT_STALL(uint32_t value)
    {
        AXI0_WR_LIMIT_STALL = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_AXI1_AR_STALLED() const
    {
        uint32_t value = static_cast<uint32_t>(AXI1_AR_STALLED);
        return value;
    }
    uint32_t get_AXI1_AR_STALLED() const volatile
    {
        uint32_t value = static_cast<uint32_t>(AXI1_AR_STALLED);
        return value;
    }
    CONSTEXPR dma_status1_r &set_AXI1_AR_STALLED(uint32_t value)
    {
        AXI1_AR_STALLED = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_AXI1_RD_LIMIT_STALL() const
    {
        uint32_t value = static_cast<uint32_t>(AXI1_RD_LIMIT_STALL);
        return value;
    }
    uint32_t get_AXI1_RD_LIMIT_STALL() const volatile
    {
        uint32_t value = static_cast<uint32_t>(AXI1_RD_LIMIT_STALL);
        return value;
    }
    CONSTEXPR dma_status1_r &set_AXI1_RD_LIMIT_STALL(uint32_t value)
    {
        AXI1_RD_LIMIT_STALL = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_AXI1_WR_STALLED() const
    {
        uint32_t value = static_cast<uint32_t>(AXI1_WR_STALLED);
        return value;
    }
    uint32_t get_AXI1_WR_STALLED() const volatile
    {
        uint32_t value = static_cast<uint32_t>(AXI1_WR_STALLED);
        return value;
    }
    CONSTEXPR dma_status1_r &set_AXI1_WR_STALLED(uint32_t value)
    {
        AXI1_WR_STALLED = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_AXI1_W_STALLED() const
    {
        uint32_t value = static_cast<uint32_t>(AXI1_W_STALLED);
        return value;
    }
    uint32_t get_AXI1_W_STALLED() const volatile
    {
        uint32_t value = static_cast<uint32_t>(AXI1_W_STALLED);
        return value;
    }
    CONSTEXPR dma_status1_r &set_AXI1_W_STALLED(uint32_t value)
    {
        AXI1_W_STALLED = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_AXI1_WR_LIMIT_STALL() const
    {
        uint32_t value = static_cast<uint32_t>(AXI1_WR_LIMIT_STALL);
        return value;
    }
    uint32_t get_AXI1_WR_LIMIT_STALL() const volatile
    {
        uint32_t value = static_cast<uint32_t>(AXI1_WR_LIMIT_STALL);
        return value;
    }
    CONSTEXPR dma_status1_r &set_AXI1_WR_LIMIT_STALL(uint32_t value)
    {
        AXI1_WR_LIMIT_STALL = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_WGT_IDLE_C1() const
    {
        uint32_t value = static_cast<uint32_t>(WGT_IDLE_C1);
        return value;
    }
    uint32_t get_WGT_IDLE_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(WGT_IDLE_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_WGT_IDLE_C1(uint32_t value)
    {
        WGT_IDLE_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_BAS_IDLE_C1() const
    {
        uint32_t value = static_cast<uint32_t>(BAS_IDLE_C1);
        return value;
    }
    uint32_t get_BAS_IDLE_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(BAS_IDLE_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_BAS_IDLE_C1(uint32_t value)
    {
        BAS_IDLE_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB0_AI_VALID_C1() const
    {
        uint32_t value = static_cast<uint32_t>(IB0_AI_VALID_C1);
        return value;
    }
    uint32_t get_IB0_AI_VALID_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB0_AI_VALID_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_IB0_AI_VALID_C1(uint32_t value)
    {
        IB0_AI_VALID_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB0_AI_READY_C1() const
    {
        uint32_t value = static_cast<uint32_t>(IB0_AI_READY_C1);
        return value;
    }
    uint32_t get_IB0_AI_READY_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB0_AI_READY_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_IB0_AI_READY_C1(uint32_t value)
    {
        IB0_AI_READY_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB1_AI_VALID_C1() const
    {
        uint32_t value = static_cast<uint32_t>(IB1_AI_VALID_C1);
        return value;
    }
    uint32_t get_IB1_AI_VALID_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB1_AI_VALID_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_IB1_AI_VALID_C1(uint32_t value)
    {
        IB1_AI_VALID_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB1_AI_READY_C1() const
    {
        uint32_t value = static_cast<uint32_t>(IB1_AI_READY_C1);
        return value;
    }
    uint32_t get_IB1_AI_READY_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB1_AI_READY_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_IB1_AI_READY_C1(uint32_t value)
    {
        IB1_AI_READY_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB0_AO_VALID_C1() const
    {
        uint32_t value = static_cast<uint32_t>(IB0_AO_VALID_C1);
        return value;
    }
    uint32_t get_IB0_AO_VALID_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB0_AO_VALID_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_IB0_AO_VALID_C1(uint32_t value)
    {
        IB0_AO_VALID_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB0_AO_READY_C1() const
    {
        uint32_t value = static_cast<uint32_t>(IB0_AO_READY_C1);
        return value;
    }
    uint32_t get_IB0_AO_READY_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB0_AO_READY_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_IB0_AO_READY_C1(uint32_t value)
    {
        IB0_AO_READY_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB1_AO_VALID_C1() const
    {
        uint32_t value = static_cast<uint32_t>(IB1_AO_VALID_C1);
        return value;
    }
    uint32_t get_IB1_AO_VALID_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB1_AO_VALID_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_IB1_AO_VALID_C1(uint32_t value)
    {
        IB1_AO_VALID_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_IB1_AO_READY_C1() const
    {
        uint32_t value = static_cast<uint32_t>(IB1_AO_READY_C1);
        return value;
    }
    uint32_t get_IB1_AO_READY_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(IB1_AO_READY_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_IB1_AO_READY_C1(uint32_t value)
    {
        IB1_AO_READY_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_OB0_VALID_C1() const
    {
        uint32_t value = static_cast<uint32_t>(OB0_VALID_C1);
        return value;
    }
    uint32_t get_OB0_VALID_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(OB0_VALID_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_OB0_VALID_C1(uint32_t value)
    {
        OB0_VALID_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_OB0_READY_C1() const
    {
        uint32_t value = static_cast<uint32_t>(OB0_READY_C1);
        return value;
    }
    uint32_t get_OB0_READY_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(OB0_READY_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_OB0_READY_C1(uint32_t value)
    {
        OB0_READY_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_OB1_VALID_C1() const
    {
        uint32_t value = static_cast<uint32_t>(OB1_VALID_C1);
        return value;
    }
    uint32_t get_OB1_VALID_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(OB1_VALID_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_OB1_VALID_C1(uint32_t value)
    {
        OB1_VALID_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_OB1_READY_C1() const
    {
        uint32_t value = static_cast<uint32_t>(OB1_READY_C1);
        return value;
    }
    uint32_t get_OB1_READY_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(OB1_READY_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_OB1_READY_C1(uint32_t value)
    {
        OB1_READY_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_WD_BITSTREAM_VALID_C1() const
    {
        uint32_t value = static_cast<uint32_t>(WD_BITSTREAM_VALID_C1);
        return value;
    }
    uint32_t get_WD_BITSTREAM_VALID_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(WD_BITSTREAM_VALID_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_WD_BITSTREAM_VALID_C1(uint32_t value)
    {
        WD_BITSTREAM_VALID_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_WD_BITSTREAM_READY_C1() const
    {
        uint32_t value = static_cast<uint32_t>(WD_BITSTREAM_READY_C1);
        return value;
    }
    uint32_t get_WD_BITSTREAM_READY_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(WD_BITSTREAM_READY_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_WD_BITSTREAM_READY_C1(uint32_t value)
    {
        WD_BITSTREAM_READY_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_BS_BITSTREAM_VALID_C1() const
    {
        uint32_t value = static_cast<uint32_t>(BS_BITSTREAM_VALID_C1);
        return value;
    }
    uint32_t get_BS_BITSTREAM_VALID_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(BS_BITSTREAM_VALID_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_BS_BITSTREAM_VALID_C1(uint32_t value)
    {
        BS_BITSTREAM_VALID_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_BS_BITSTREAM_READY_C1() const
    {
        uint32_t value = static_cast<uint32_t>(BS_BITSTREAM_READY_C1);
        return value;
    }
    uint32_t get_BS_BITSTREAM_READY_C1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(BS_BITSTREAM_READY_C1);
        return value;
    }
    CONSTEXPR dma_status1_r &set_BS_BITSTREAM_READY_C1(uint32_t value)
    {
        BS_BITSTREAM_READY_C1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// clkforce_r - Force clocks on for clock gating
struct clkforce_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t top_level_clk : 1; // set to 1 to force on TOP level clock
            uint32_t cc_clk : 1;        // set to 1 to force on CC clock
            uint32_t dma_clk : 1;       // set to 1 to force on DMA clock
            uint32_t mac_clk : 1;       // set to 1 to force on MAC clock
            uint32_t ao_clk : 1;        // set to 1 to force on AO clock
            uint32_t wd_clk : 1;        // set to 1 to force on WD clock
            uint32_t reserved0 : 26;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR clkforce_r() :
        top_level_clk(static_cast<uint32_t>(0)), cc_clk(static_cast<uint32_t>(0)), dma_clk(static_cast<uint32_t>(0)),
        mac_clk(static_cast<uint32_t>(0)), ao_clk(static_cast<uint32_t>(0)), wd_clk(static_cast<uint32_t>(0)),
        reserved0(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR clkforce_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    clkforce_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_top_level_clk() const
    {
        uint32_t value = static_cast<uint32_t>(top_level_clk);
        return value;
    }
    uint32_t get_top_level_clk() const volatile
    {
        uint32_t value = static_cast<uint32_t>(top_level_clk);
        return value;
    }
    CONSTEXPR clkforce_r &set_top_level_clk(uint32_t value)
    {
        top_level_clk = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_cc_clk() const
    {
        uint32_t value = static_cast<uint32_t>(cc_clk);
        return value;
    }
    uint32_t get_cc_clk() const volatile
    {
        uint32_t value = static_cast<uint32_t>(cc_clk);
        return value;
    }
    CONSTEXPR clkforce_r &set_cc_clk(uint32_t value)
    {
        cc_clk = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_dma_clk() const
    {
        uint32_t value = static_cast<uint32_t>(dma_clk);
        return value;
    }
    uint32_t get_dma_clk() const volatile
    {
        uint32_t value = static_cast<uint32_t>(dma_clk);
        return value;
    }
    CONSTEXPR clkforce_r &set_dma_clk(uint32_t value)
    {
        dma_clk = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_mac_clk() const
    {
        uint32_t value = static_cast<uint32_t>(mac_clk);
        return value;
    }
    uint32_t get_mac_clk() const volatile
    {
        uint32_t value = static_cast<uint32_t>(mac_clk);
        return value;
    }
    CONSTEXPR clkforce_r &set_mac_clk(uint32_t value)
    {
        mac_clk = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_ao_clk() const
    {
        uint32_t value = static_cast<uint32_t>(ao_clk);
        return value;
    }
    uint32_t get_ao_clk() const volatile
    {
        uint32_t value = static_cast<uint32_t>(ao_clk);
        return value;
    }
    CONSTEXPR clkforce_r &set_ao_clk(uint32_t value)
    {
        ao_clk = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_wd_clk() const
    {
        uint32_t value = static_cast<uint32_t>(wd_clk);
        return value;
    }
    uint32_t get_wd_clk() const volatile
    {
        uint32_t value = static_cast<uint32_t>(wd_clk);
        return value;
    }
    CONSTEXPR clkforce_r &set_wd_clk(uint32_t value)
    {
        wd_clk = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pid4_r - Peripheral ID byte 4 (Arm=code 4)
struct pid4_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t PID4; // Byte 4 of Peripheral ID (Lower 8 bits valid)
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pid4_r() : PID4(static_cast<uint32_t>(0x04)) {}
    CONSTEXPR pid4_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pid4_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_PID4() const
    {
        uint32_t value = static_cast<uint32_t>(PID4);
        return value;
    }
    uint32_t get_PID4() const volatile
    {
        uint32_t value = static_cast<uint32_t>(PID4);
        return value;
    }
    CONSTEXPR pid4_r &set_PID4(uint32_t value)
    {
        PID4 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pid5_r - Peripheral ID byte 5 (reserved)
struct pid5_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t PID5; // Byte 5 of Peripheral ID (Lower 8 bits valid)
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pid5_r() : PID5(static_cast<uint32_t>(0x00)) {}
    CONSTEXPR pid5_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pid5_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_PID5() const
    {
        uint32_t value = static_cast<uint32_t>(PID5);
        return value;
    }
    uint32_t get_PID5() const volatile
    {
        uint32_t value = static_cast<uint32_t>(PID5);
        return value;
    }
    CONSTEXPR pid5_r &set_PID5(uint32_t value)
    {
        PID5 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pid6_r - Peripheral ID byte 6 (reserved)
struct pid6_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t PID6; // Byte 6 of Peripheral ID (Lower 8 bits valid)
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pid6_r() : PID6(static_cast<uint32_t>(0x00)) {}
    CONSTEXPR pid6_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pid6_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_PID6() const
    {
        uint32_t value = static_cast<uint32_t>(PID6);
        return value;
    }
    uint32_t get_PID6() const volatile
    {
        uint32_t value = static_cast<uint32_t>(PID6);
        return value;
    }
    CONSTEXPR pid6_r &set_PID6(uint32_t value)
    {
        PID6 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pid7_r - Peripheral ID byte 7 (reserved)
struct pid7_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t PID7; // Byte 7 of Peripheral ID (Lower 8 bits valid)
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pid7_r() : PID7(static_cast<uint32_t>(0x00)) {}
    CONSTEXPR pid7_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pid7_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_PID7() const
    {
        uint32_t value = static_cast<uint32_t>(PID7);
        return value;
    }
    uint32_t get_PID7() const volatile
    {
        uint32_t value = static_cast<uint32_t>(PID7);
        return value;
    }
    CONSTEXPR pid7_r &set_PID7(uint32_t value)
    {
        PID7 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pid0_r - Peripheral ID byte 0. This is bits[7:0] of the part number.
struct pid0_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t PID0; // Byte 0 of Peripheral ID (Lower 8 bits valid)
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pid0_r() : PID0(static_cast<uint32_t>(0x80)) {}
    CONSTEXPR pid0_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pid0_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_PID0() const
    {
        uint32_t value = static_cast<uint32_t>(PID0);
        return value;
    }
    uint32_t get_PID0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(PID0);
        return value;
    }
    CONSTEXPR pid0_r &set_PID0(uint32_t value)
    {
        PID0 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pid1_r - Peripheral ID byte 1. This is bits[11:8] of the part number in bits[3:0], and bits[3:0] of the Arm ID in
// bits[7:4].
struct pid1_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t PID1; // Byte 1 of Peripheral ID (Lower 8 bits valid)
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pid1_r() : PID1(static_cast<uint32_t>(0xB5)) {}
    CONSTEXPR pid1_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pid1_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_PID1() const
    {
        uint32_t value = static_cast<uint32_t>(PID1);
        return value;
    }
    uint32_t get_PID1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(PID1);
        return value;
    }
    CONSTEXPR pid1_r &set_PID1(uint32_t value)
    {
        PID1 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pid2_r - Peripheral ID byte 2. This is bits[6:4] of the Arm ID in bits[2:0], and bit 3 indicates format B.
struct pid2_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t PID2; // Byte 2 of Peripheral ID (Lower 8 bits valid)
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pid2_r() : PID2(static_cast<uint32_t>(0x0B)) {}
    CONSTEXPR pid2_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pid2_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_PID2() const
    {
        uint32_t value = static_cast<uint32_t>(PID2);
        return value;
    }
    uint32_t get_PID2() const volatile
    {
        uint32_t value = static_cast<uint32_t>(PID2);
        return value;
    }
    CONSTEXPR pid2_r &set_PID2(uint32_t value)
    {
        PID2 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pid3_r - Peripheral ID byte 3.
struct pid3_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t PID3; // Byte 1 of Peripheral ID (Lower 8 bits valid)
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pid3_r() : PID3(static_cast<uint32_t>(0x0)) {}
    CONSTEXPR pid3_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pid3_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_PID3() const
    {
        uint32_t value = static_cast<uint32_t>(PID3);
        return value;
    }
    uint32_t get_PID3() const volatile
    {
        uint32_t value = static_cast<uint32_t>(PID3);
        return value;
    }
    CONSTEXPR pid3_r &set_PID3(uint32_t value)
    {
        PID3 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// cid0_r - Component ID byte 0.
struct cid0_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t CID0; // Byte 0 of Component ID (Lower 8 bits valid)
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR cid0_r() : CID0(static_cast<uint32_t>(0x0D)) {}
    CONSTEXPR cid0_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    cid0_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_CID0() const
    {
        uint32_t value = static_cast<uint32_t>(CID0);
        return value;
    }
    uint32_t get_CID0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CID0);
        return value;
    }
    CONSTEXPR cid0_r &set_CID0(uint32_t value)
    {
        CID0 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// cid1_r - Component ID byte 1.
struct cid1_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t CID1; // Byte 1 of Component ID (Lower 8 bits valid)
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR cid1_r() : CID1(static_cast<uint32_t>(0xF0)) {}
    CONSTEXPR cid1_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    cid1_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_CID1() const
    {
        uint32_t value = static_cast<uint32_t>(CID1);
        return value;
    }
    uint32_t get_CID1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CID1);
        return value;
    }
    CONSTEXPR cid1_r &set_CID1(uint32_t value)
    {
        CID1 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// cid2_r - Component ID byte 2.
struct cid2_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t CID2; // Byte 2 of Component ID (Lower 8 bits valid)
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR cid2_r() : CID2(static_cast<uint32_t>(0x05)) {}
    CONSTEXPR cid2_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    cid2_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_CID2() const
    {
        uint32_t value = static_cast<uint32_t>(CID2);
        return value;
    }
    uint32_t get_CID2() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CID2);
        return value;
    }
    CONSTEXPR cid2_r &set_CID2(uint32_t value)
    {
        CID2 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// cid3_r - Component ID byte 3.
struct cid3_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t CID3; // Byte 3 of Component ID (Lower 8 bits valid)
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR cid3_r() : CID3(static_cast<uint32_t>(0xB1)) {}
    CONSTEXPR cid3_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    cid3_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_CID3() const
    {
        uint32_t value = static_cast<uint32_t>(CID3);
        return value;
    }
    uint32_t get_CID3() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CID3);
        return value;
    }
    CONSTEXPR cid3_r &set_CID3(uint32_t value)
    {
        CID3 = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmcr_r - PMU Register control
struct pmcr_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t cnt_en : 1;        // Enable counter
            uint32_t event_cnt_rst : 1; // Reset event counter
            uint32_t cycle_cnt_rst : 1; // Reset cycle counter
            uint32_t mask_en : 1;       // PMU can be enabled/disabled by command stream operation NPU_OP_PMU_MASK
            uint32_t reserved0 : 7;
            uint32_t num_event_cnt : 5; // Number of event counters
            uint32_t reserved1 : 16;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmcr_r() :
        cnt_en(static_cast<uint32_t>(0x0)), event_cnt_rst(static_cast<uint32_t>(0)),
        cycle_cnt_rst(static_cast<uint32_t>(0)), mask_en(static_cast<uint32_t>(0x0)),
        reserved0(static_cast<uint32_t>(0)), num_event_cnt(static_cast<uint32_t>(0x04)),
        reserved1(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR pmcr_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmcr_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_cnt_en() const
    {
        uint32_t value = static_cast<uint32_t>(cnt_en);
        return value;
    }
    uint32_t get_cnt_en() const volatile
    {
        uint32_t value = static_cast<uint32_t>(cnt_en);
        return value;
    }
    CONSTEXPR pmcr_r &set_cnt_en(uint32_t value)
    {
        cnt_en = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_event_cnt_rst() const
    {
        uint32_t value = static_cast<uint32_t>(event_cnt_rst);
        return value;
    }
    uint32_t get_event_cnt_rst() const volatile
    {
        uint32_t value = static_cast<uint32_t>(event_cnt_rst);
        return value;
    }
    CONSTEXPR pmcr_r &set_event_cnt_rst(uint32_t value)
    {
        event_cnt_rst = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_cycle_cnt_rst() const
    {
        uint32_t value = static_cast<uint32_t>(cycle_cnt_rst);
        return value;
    }
    uint32_t get_cycle_cnt_rst() const volatile
    {
        uint32_t value = static_cast<uint32_t>(cycle_cnt_rst);
        return value;
    }
    CONSTEXPR pmcr_r &set_cycle_cnt_rst(uint32_t value)
    {
        cycle_cnt_rst = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_mask_en() const
    {
        uint32_t value = static_cast<uint32_t>(mask_en);
        return value;
    }
    uint32_t get_mask_en() const volatile
    {
        uint32_t value = static_cast<uint32_t>(mask_en);
        return value;
    }
    CONSTEXPR pmcr_r &set_mask_en(uint32_t value)
    {
        mask_en = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_num_event_cnt() const
    {
        uint32_t value = static_cast<uint32_t>(num_event_cnt);
        return value;
    }
    uint32_t get_num_event_cnt() const volatile
    {
        uint32_t value = static_cast<uint32_t>(num_event_cnt);
        return value;
    }
    CONSTEXPR pmcr_r &set_num_event_cnt(uint32_t value)
    {
        num_event_cnt = ((1u << 5) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmcntenset_r - Count enable set register
struct pmcntenset_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t EVENT_CNT_0 : 1; // Event counter enable bit for PMEVCNTR0
            uint32_t EVENT_CNT_1 : 1; // Event counter enable bit for PMEVCNTR1
            uint32_t EVENT_CNT_2 : 1; // Event counter enable bit for PMEVCNTR2
            uint32_t EVENT_CNT_3 : 1; // Event counter enable bit for PMEVCNTR3
            uint32_t reserved0 : 27;
            uint32_t CYCLE_CNT : 1; // PMCCNTR enable bit
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmcntenset_r() :
        EVENT_CNT_0(static_cast<uint32_t>(0)), EVENT_CNT_1(static_cast<uint32_t>(0)),
        EVENT_CNT_2(static_cast<uint32_t>(0)), EVENT_CNT_3(static_cast<uint32_t>(0)),
        reserved0(static_cast<uint32_t>(0)), CYCLE_CNT(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR pmcntenset_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmcntenset_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_0() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_0);
        return value;
    }
    uint32_t get_EVENT_CNT_0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_0);
        return value;
    }
    CONSTEXPR pmcntenset_r &set_EVENT_CNT_0(uint32_t value)
    {
        EVENT_CNT_0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_1() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_1);
        return value;
    }
    uint32_t get_EVENT_CNT_1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_1);
        return value;
    }
    CONSTEXPR pmcntenset_r &set_EVENT_CNT_1(uint32_t value)
    {
        EVENT_CNT_1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_2() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_2);
        return value;
    }
    uint32_t get_EVENT_CNT_2() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_2);
        return value;
    }
    CONSTEXPR pmcntenset_r &set_EVENT_CNT_2(uint32_t value)
    {
        EVENT_CNT_2 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_3() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_3);
        return value;
    }
    uint32_t get_EVENT_CNT_3() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_3);
        return value;
    }
    CONSTEXPR pmcntenset_r &set_EVENT_CNT_3(uint32_t value)
    {
        EVENT_CNT_3 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_CYCLE_CNT() const
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT);
        return value;
    }
    uint32_t get_CYCLE_CNT() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT);
        return value;
    }
    CONSTEXPR pmcntenset_r &set_CYCLE_CNT(uint32_t value)
    {
        CYCLE_CNT = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmcntenclr_r - Count enable clear register
struct pmcntenclr_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t EVENT_CNT_0 : 1; // Event counter disable bit for PMEVCNTR0
            uint32_t EVENT_CNT_1 : 1; // Event counter disable bit for PMEVCNTR1
            uint32_t EVENT_CNT_2 : 1; // Event counter disable bit for PMEVCNTR2
            uint32_t EVENT_CNT_3 : 1; // Event counter disable bit for PMEVCNTR3
            uint32_t reserved0 : 27;
            uint32_t CYCLE_CNT : 1; // PMCCNTR disable bit
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmcntenclr_r() :
        EVENT_CNT_0(static_cast<uint32_t>(0)), EVENT_CNT_1(static_cast<uint32_t>(0)),
        EVENT_CNT_2(static_cast<uint32_t>(0)), EVENT_CNT_3(static_cast<uint32_t>(0)),
        reserved0(static_cast<uint32_t>(0)), CYCLE_CNT(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR pmcntenclr_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmcntenclr_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_0() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_0);
        return value;
    }
    uint32_t get_EVENT_CNT_0() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_0);
        return value;
    }
    CONSTEXPR pmcntenclr_r &set_EVENT_CNT_0(uint32_t value)
    {
        EVENT_CNT_0 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_1() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_1);
        return value;
    }
    uint32_t get_EVENT_CNT_1() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_1);
        return value;
    }
    CONSTEXPR pmcntenclr_r &set_EVENT_CNT_1(uint32_t value)
    {
        EVENT_CNT_1 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_2() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_2);
        return value;
    }
    uint32_t get_EVENT_CNT_2() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_2);
        return value;
    }
    CONSTEXPR pmcntenclr_r &set_EVENT_CNT_2(uint32_t value)
    {
        EVENT_CNT_2 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_3() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_3);
        return value;
    }
    uint32_t get_EVENT_CNT_3() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_3);
        return value;
    }
    CONSTEXPR pmcntenclr_r &set_EVENT_CNT_3(uint32_t value)
    {
        EVENT_CNT_3 = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_CYCLE_CNT() const
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT);
        return value;
    }
    uint32_t get_CYCLE_CNT() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT);
        return value;
    }
    CONSTEXPR pmcntenclr_r &set_CYCLE_CNT(uint32_t value)
    {
        CYCLE_CNT = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmovsset_r - Overflow flag status set register
struct pmovsset_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t EVENT_CNT_0_OVF : 1; // Event counter overflow set bit for PMEVCNTR0
            uint32_t EVENT_CNT_1_OVF : 1; // Event counter overflow set bit for PMEVCNTR1
            uint32_t EVENT_CNT_2_OVF : 1; // Event counter overflow set bit for PMEVCNTR2
            uint32_t EVENT_CNT_3_OVF : 1; // Event counter overflow set bit for PMEVCNTR3
            uint32_t reserved0 : 27;
            uint32_t CYCLE_CNT_OVF : 1; // PMCCNTR overflow set bit
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmovsset_r() :
        EVENT_CNT_0_OVF(static_cast<uint32_t>(0)), EVENT_CNT_1_OVF(static_cast<uint32_t>(0)),
        EVENT_CNT_2_OVF(static_cast<uint32_t>(0)), EVENT_CNT_3_OVF(static_cast<uint32_t>(0)),
        reserved0(static_cast<uint32_t>(0)), CYCLE_CNT_OVF(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR pmovsset_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmovsset_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_0_OVF() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_0_OVF);
        return value;
    }
    uint32_t get_EVENT_CNT_0_OVF() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_0_OVF);
        return value;
    }
    CONSTEXPR pmovsset_r &set_EVENT_CNT_0_OVF(uint32_t value)
    {
        EVENT_CNT_0_OVF = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_1_OVF() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_1_OVF);
        return value;
    }
    uint32_t get_EVENT_CNT_1_OVF() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_1_OVF);
        return value;
    }
    CONSTEXPR pmovsset_r &set_EVENT_CNT_1_OVF(uint32_t value)
    {
        EVENT_CNT_1_OVF = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_2_OVF() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_2_OVF);
        return value;
    }
    uint32_t get_EVENT_CNT_2_OVF() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_2_OVF);
        return value;
    }
    CONSTEXPR pmovsset_r &set_EVENT_CNT_2_OVF(uint32_t value)
    {
        EVENT_CNT_2_OVF = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_3_OVF() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_3_OVF);
        return value;
    }
    uint32_t get_EVENT_CNT_3_OVF() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_3_OVF);
        return value;
    }
    CONSTEXPR pmovsset_r &set_EVENT_CNT_3_OVF(uint32_t value)
    {
        EVENT_CNT_3_OVF = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_CYCLE_CNT_OVF() const
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_OVF);
        return value;
    }
    uint32_t get_CYCLE_CNT_OVF() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_OVF);
        return value;
    }
    CONSTEXPR pmovsset_r &set_CYCLE_CNT_OVF(uint32_t value)
    {
        CYCLE_CNT_OVF = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmovsclr_r - Overflow flag status clear register
struct pmovsclr_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t EVENT_CNT_0_OVF : 1; // Event counter overflow clear bit for PMEVCNTR0
            uint32_t EVENT_CNT_1_OVF : 1; // Event counter overflow clear bit for PMEVCNTR1
            uint32_t EVENT_CNT_2_OVF : 1; // Event counter overflow clear bit for PMEVCNTR2
            uint32_t EVENT_CNT_3_OVF : 1; // Event counter overflow clear bit for PMEVCNTR3
            uint32_t reserved0 : 27;
            uint32_t CYCLE_CNT_OVF : 1; // PMCCNTR overflow clear bit
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmovsclr_r() :
        EVENT_CNT_0_OVF(static_cast<uint32_t>(0)), EVENT_CNT_1_OVF(static_cast<uint32_t>(0)),
        EVENT_CNT_2_OVF(static_cast<uint32_t>(0)), EVENT_CNT_3_OVF(static_cast<uint32_t>(0)),
        reserved0(static_cast<uint32_t>(0)), CYCLE_CNT_OVF(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR pmovsclr_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmovsclr_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_0_OVF() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_0_OVF);
        return value;
    }
    uint32_t get_EVENT_CNT_0_OVF() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_0_OVF);
        return value;
    }
    CONSTEXPR pmovsclr_r &set_EVENT_CNT_0_OVF(uint32_t value)
    {
        EVENT_CNT_0_OVF = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_1_OVF() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_1_OVF);
        return value;
    }
    uint32_t get_EVENT_CNT_1_OVF() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_1_OVF);
        return value;
    }
    CONSTEXPR pmovsclr_r &set_EVENT_CNT_1_OVF(uint32_t value)
    {
        EVENT_CNT_1_OVF = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_2_OVF() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_2_OVF);
        return value;
    }
    uint32_t get_EVENT_CNT_2_OVF() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_2_OVF);
        return value;
    }
    CONSTEXPR pmovsclr_r &set_EVENT_CNT_2_OVF(uint32_t value)
    {
        EVENT_CNT_2_OVF = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_3_OVF() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_3_OVF);
        return value;
    }
    uint32_t get_EVENT_CNT_3_OVF() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_3_OVF);
        return value;
    }
    CONSTEXPR pmovsclr_r &set_EVENT_CNT_3_OVF(uint32_t value)
    {
        EVENT_CNT_3_OVF = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_CYCLE_CNT_OVF() const
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_OVF);
        return value;
    }
    uint32_t get_CYCLE_CNT_OVF() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_OVF);
        return value;
    }
    CONSTEXPR pmovsclr_r &set_CYCLE_CNT_OVF(uint32_t value)
    {
        CYCLE_CNT_OVF = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmintset_r - Interrupt enable set register
struct pmintset_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t EVENT_CNT_0_INT : 1; // Event counter overflow interrupt request enable bit for PMEVCNTR0
            uint32_t EVENT_CNT_1_INT : 1; // Event counter overflow interrupt request enable bit for PMEVCNTR1
            uint32_t EVENT_CNT_2_INT : 1; // Event counter overflow interrupt request enable bit for PMEVCNTR2
            uint32_t EVENT_CNT_3_INT : 1; // Event counter overflow interrupt request enable bit for PMEVCNTR3
            uint32_t reserved0 : 27;
            uint32_t CYCLE_CNT_INT : 1; // PMCCNTR overflow interrupt request enable bit
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmintset_r() :
        EVENT_CNT_0_INT(static_cast<uint32_t>(0)), EVENT_CNT_1_INT(static_cast<uint32_t>(0)),
        EVENT_CNT_2_INT(static_cast<uint32_t>(0)), EVENT_CNT_3_INT(static_cast<uint32_t>(0)),
        reserved0(static_cast<uint32_t>(0)), CYCLE_CNT_INT(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR pmintset_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmintset_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_0_INT() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_0_INT);
        return value;
    }
    uint32_t get_EVENT_CNT_0_INT() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_0_INT);
        return value;
    }
    CONSTEXPR pmintset_r &set_EVENT_CNT_0_INT(uint32_t value)
    {
        EVENT_CNT_0_INT = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_1_INT() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_1_INT);
        return value;
    }
    uint32_t get_EVENT_CNT_1_INT() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_1_INT);
        return value;
    }
    CONSTEXPR pmintset_r &set_EVENT_CNT_1_INT(uint32_t value)
    {
        EVENT_CNT_1_INT = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_2_INT() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_2_INT);
        return value;
    }
    uint32_t get_EVENT_CNT_2_INT() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_2_INT);
        return value;
    }
    CONSTEXPR pmintset_r &set_EVENT_CNT_2_INT(uint32_t value)
    {
        EVENT_CNT_2_INT = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_3_INT() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_3_INT);
        return value;
    }
    uint32_t get_EVENT_CNT_3_INT() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_3_INT);
        return value;
    }
    CONSTEXPR pmintset_r &set_EVENT_CNT_3_INT(uint32_t value)
    {
        EVENT_CNT_3_INT = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_CYCLE_CNT_INT() const
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_INT);
        return value;
    }
    uint32_t get_CYCLE_CNT_INT() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_INT);
        return value;
    }
    CONSTEXPR pmintset_r &set_CYCLE_CNT_INT(uint32_t value)
    {
        CYCLE_CNT_INT = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmintclr_r - Interrupt enable clear register
struct pmintclr_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t EVENT_CNT_0_INT : 1; // Event counter overflow interrupt request disable bit for PMEVCNTR0
            uint32_t EVENT_CNT_1_INT : 1; // Event counter overflow interrupt request disable bit for PMEVCNTR1
            uint32_t EVENT_CNT_2_INT : 1; // Event counter overflow interrupt request disable bit for PMEVCNTR2
            uint32_t EVENT_CNT_3_INT : 1; // Event counter overflow interrupt request disable bit for PMEVCNTR3
            uint32_t reserved0 : 27;
            uint32_t CYCLE_CNT_INT : 1; // PMCCNTR overflow interrupt request disable bit
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmintclr_r() :
        EVENT_CNT_0_INT(static_cast<uint32_t>(0)), EVENT_CNT_1_INT(static_cast<uint32_t>(0)),
        EVENT_CNT_2_INT(static_cast<uint32_t>(0)), EVENT_CNT_3_INT(static_cast<uint32_t>(0)),
        reserved0(static_cast<uint32_t>(0)), CYCLE_CNT_INT(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR pmintclr_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmintclr_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_0_INT() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_0_INT);
        return value;
    }
    uint32_t get_EVENT_CNT_0_INT() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_0_INT);
        return value;
    }
    CONSTEXPR pmintclr_r &set_EVENT_CNT_0_INT(uint32_t value)
    {
        EVENT_CNT_0_INT = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_1_INT() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_1_INT);
        return value;
    }
    uint32_t get_EVENT_CNT_1_INT() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_1_INT);
        return value;
    }
    CONSTEXPR pmintclr_r &set_EVENT_CNT_1_INT(uint32_t value)
    {
        EVENT_CNT_1_INT = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_2_INT() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_2_INT);
        return value;
    }
    uint32_t get_EVENT_CNT_2_INT() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_2_INT);
        return value;
    }
    CONSTEXPR pmintclr_r &set_EVENT_CNT_2_INT(uint32_t value)
    {
        EVENT_CNT_2_INT = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_EVENT_CNT_3_INT() const
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_3_INT);
        return value;
    }
    uint32_t get_EVENT_CNT_3_INT() const volatile
    {
        uint32_t value = static_cast<uint32_t>(EVENT_CNT_3_INT);
        return value;
    }
    CONSTEXPR pmintclr_r &set_EVENT_CNT_3_INT(uint32_t value)
    {
        EVENT_CNT_3_INT = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_CYCLE_CNT_INT() const
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_INT);
        return value;
    }
    uint32_t get_CYCLE_CNT_INT() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_INT);
        return value;
    }
    CONSTEXPR pmintclr_r &set_CYCLE_CNT_INT(uint32_t value)
    {
        CYCLE_CNT_INT = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmccntr_lo_r - Performance monitor cycle count low register
struct pmccntr_lo_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        uint32_t CYCLE_CNT_LO; // Cycle count low
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmccntr_lo_r() : CYCLE_CNT_LO(static_cast<uint32_t>(0x00000000)) {}
    CONSTEXPR pmccntr_lo_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmccntr_lo_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_CYCLE_CNT_LO() const
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_LO);
        return value;
    }
    uint32_t get_CYCLE_CNT_LO() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_LO);
        return value;
    }
    CONSTEXPR pmccntr_lo_r &set_CYCLE_CNT_LO(uint32_t value)
    {
        CYCLE_CNT_LO = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmccntr_hi_r - Performance monitor cycle count high register
struct pmccntr_hi_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t CYCLE_CNT_HI : 16; // Cycle count high
            uint32_t reserved0 : 16;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmccntr_hi_r() : CYCLE_CNT_HI(static_cast<uint32_t>(0x0000)), reserved0(static_cast<uint32_t>(0)) {}
    CONSTEXPR pmccntr_hi_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmccntr_hi_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_CYCLE_CNT_HI() const
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_HI);
        return value;
    }
    uint32_t get_CYCLE_CNT_HI() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_HI);
        return value;
    }
    CONSTEXPR pmccntr_hi_r &set_CYCLE_CNT_HI(uint32_t value)
    {
        CYCLE_CNT_HI = ((1u << 16) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmccntr_cfg_r - Set start/stop event on the cycle counter
struct pmccntr_cfg_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t CYCLE_CNT_CFG_START : 10; // Cycle counter start event
            uint32_t reserved0 : 6;
            uint32_t CYCLE_CNT_CFG_STOP : 10; // Cycle counter stop event
            uint32_t reserved1 : 6;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmccntr_cfg_r() :
        CYCLE_CNT_CFG_START(static_cast<uint32_t>(0x00)), reserved0(static_cast<uint32_t>(0)),
        CYCLE_CNT_CFG_STOP(static_cast<uint32_t>(0x00)), reserved1(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR pmccntr_cfg_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmccntr_cfg_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_CYCLE_CNT_CFG_START() const
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_CFG_START);
        return value;
    }
    uint32_t get_CYCLE_CNT_CFG_START() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_CFG_START);
        return value;
    }
    CONSTEXPR pmccntr_cfg_r &set_CYCLE_CNT_CFG_START(uint32_t value)
    {
        CYCLE_CNT_CFG_START = ((1u << 10) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_CYCLE_CNT_CFG_STOP() const
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_CFG_STOP);
        return value;
    }
    uint32_t get_CYCLE_CNT_CFG_STOP() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CYCLE_CNT_CFG_STOP);
        return value;
    }
    CONSTEXPR pmccntr_cfg_r &set_CYCLE_CNT_CFG_STOP(uint32_t value)
    {
        CYCLE_CNT_CFG_STOP = ((1u << 10) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmcaxi_chan_r - Set which AXI channel to monitor for latency measurements in PMU
struct pmcaxi_chan_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t CH_SEL : 4; // Channel number to monitor for latency measurements (Read: 0=Cmd 1=IFM 2=Weights
                                 // 3=Scale+Bias 4=Mem2Mem; Write: 8=OFM 9=Mem2Mem)
            uint32_t reserved0 : 4;
            uint32_t AXI_CNT_SEL : 2;  // AXI counter to monitor for latency measurements (0=AXI0 counter0, 1=AXI0
                                       // counter1, 2=AXI1 counter 2, 3=AXI counter3)
            uint32_t BW_CH_SEL_EN : 1; // Bandwidth channel selector enable: {0=AXI bw events measured for all channels,
                                       // 1=AXI bw events measured for channel specified by CH_SEL
            uint32_t reserved1 : 21;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmcaxi_chan_r() :
        CH_SEL(static_cast<uint32_t>(0x0)), reserved0(static_cast<uint32_t>(0)),
        AXI_CNT_SEL(static_cast<uint32_t>(0x000000)), BW_CH_SEL_EN(static_cast<uint32_t>(0x000000)),
        reserved1(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR pmcaxi_chan_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmcaxi_chan_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR uint32_t get_CH_SEL() const
    {
        uint32_t value = static_cast<uint32_t>(CH_SEL);
        return value;
    }
    uint32_t get_CH_SEL() const volatile
    {
        uint32_t value = static_cast<uint32_t>(CH_SEL);
        return value;
    }
    CONSTEXPR pmcaxi_chan_r &set_CH_SEL(uint32_t value)
    {
        CH_SEL = ((1u << 4) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_AXI_CNT_SEL() const
    {
        uint32_t value = static_cast<uint32_t>(AXI_CNT_SEL);
        return value;
    }
    uint32_t get_AXI_CNT_SEL() const volatile
    {
        uint32_t value = static_cast<uint32_t>(AXI_CNT_SEL);
        return value;
    }
    CONSTEXPR pmcaxi_chan_r &set_AXI_CNT_SEL(uint32_t value)
    {
        AXI_CNT_SEL = ((1u << 2) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_BW_CH_SEL_EN() const
    {
        uint32_t value = static_cast<uint32_t>(BW_CH_SEL_EN);
        return value;
    }
    uint32_t get_BW_CH_SEL_EN() const volatile
    {
        uint32_t value = static_cast<uint32_t>(BW_CH_SEL_EN);
        return value;
    }
    CONSTEXPR pmcaxi_chan_r &set_BW_CH_SEL_EN(uint32_t value)
    {
        BW_CH_SEL_EN = ((1u << 1) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmevtyper0_r - Performance monitor event type register 0
struct pmevtyper0_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t EV_TYPE : 10; // Event Type
            uint32_t reserved0 : 22;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmevtyper0_r() :
        EV_TYPE(static_cast<uint32_t>(::pmu_event_type::NO_EVENT)), reserved0(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR pmevtyper0_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmevtyper0_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR ::pmu_event_type get_EV_TYPE() const
    {
        ::pmu_event_type value = static_cast<::pmu_event_type>(EV_TYPE);
        return value;
    }
    ::pmu_event_type get_EV_TYPE() const volatile
    {
        ::pmu_event_type value = static_cast<::pmu_event_type>(EV_TYPE);
        return value;
    }
    CONSTEXPR pmevtyper0_r &set_EV_TYPE(::pmu_event_type value)
    {
        EV_TYPE = ((1u << 10) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmevtyper1_r - Performance monitor event type register 1
struct pmevtyper1_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t EV_TYPE : 10; // Event Type
            uint32_t reserved0 : 22;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmevtyper1_r() :
        EV_TYPE(static_cast<uint32_t>(::pmu_event_type::NO_EVENT)), reserved0(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR pmevtyper1_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmevtyper1_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR ::pmu_event_type get_EV_TYPE() const
    {
        ::pmu_event_type value = static_cast<::pmu_event_type>(EV_TYPE);
        return value;
    }
    ::pmu_event_type get_EV_TYPE() const volatile
    {
        ::pmu_event_type value = static_cast<::pmu_event_type>(EV_TYPE);
        return value;
    }
    CONSTEXPR pmevtyper1_r &set_EV_TYPE(::pmu_event_type value)
    {
        EV_TYPE = ((1u << 10) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmevtyper2_r - Performance monitor event type register 2
struct pmevtyper2_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t EV_TYPE : 10; // Event Type
            uint32_t reserved0 : 22;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmevtyper2_r() :
        EV_TYPE(static_cast<uint32_t>(::pmu_event_type::NO_EVENT)), reserved0(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR pmevtyper2_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmevtyper2_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR ::pmu_event_type get_EV_TYPE() const
    {
        ::pmu_event_type value = static_cast<::pmu_event_type>(EV_TYPE);
        return value;
    }
    ::pmu_event_type get_EV_TYPE() const volatile
    {
        ::pmu_event_type value = static_cast<::pmu_event_type>(EV_TYPE);
        return value;
    }
    CONSTEXPR pmevtyper2_r &set_EV_TYPE(::pmu_event_type value)
    {
        EV_TYPE = ((1u << 10) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// pmevtyper3_r - Performance monitor event type register 3
struct pmevtyper3_r
{
#ifdef __cplusplus
  private:
#endif //__cplusplus
    union
    {
        struct
        {
            uint32_t EV_TYPE : 10; // Event Type
            uint32_t reserved0 : 22;
        };
        uint32_t word;
    };
#ifdef __cplusplus
  public:
    CONSTEXPR pmevtyper3_r() :
        EV_TYPE(static_cast<uint32_t>(::pmu_event_type::NO_EVENT)), reserved0(static_cast<uint32_t>(0))
    {
    }
    CONSTEXPR pmevtyper3_r(uint32_t init) : word(init) {}
    CONSTEXPR void operator=(uint32_t value)
    {
        word = value;
    }
    void operator=(uint32_t value) volatile
    {
        word = value;
    }
    CONSTEXPR operator uint32_t()
    {
        return word;
    }
    operator uint32_t() volatile
    {
        return word;
    }
    pmevtyper3_r copy() volatile
    {
        return *this;
    }
    CONSTEXPR ::pmu_event_type get_EV_TYPE() const
    {
        ::pmu_event_type value = static_cast<::pmu_event_type>(EV_TYPE);
        return value;
    }
    ::pmu_event_type get_EV_TYPE() const volatile
    {
        ::pmu_event_type value = static_cast<::pmu_event_type>(EV_TYPE);
        return value;
    }
    CONSTEXPR pmevtyper3_r &set_EV_TYPE(::pmu_event_type value)
    {
        EV_TYPE = ((1u << 10) - 1) & static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

struct NPU_REG
{
    STRUCT id_r ID;           // 0x0
    STRUCT status_r STATUS;   // 0x4
    STRUCT cmd_r CMD;         // 0x8
    STRUCT reset_r RESET;     // 0xc
    STRUCT qbase0_r QBASE0;   // 0x10
    STRUCT qbase1_r QBASE1;   // 0x14
    STRUCT qread_r QREAD;     // 0x18
    STRUCT qconfig_r QCONFIG; // 0x1c
    STRUCT qsize_r QSIZE;     // 0x20
    STRUCT prot_r PROT;       // 0x24
    STRUCT config_r CONFIG;   // 0x28
    STRUCT lock_r LOCK;       // 0x2c
    uint32_t unused0[3];
    STRUCT regioncfg_r REGIONCFG;   // 0x3c
    STRUCT axi_limit0_r AXI_LIMIT0; // 0x40
    STRUCT axi_limit1_r AXI_LIMIT1; // 0x44
    STRUCT axi_limit2_r AXI_LIMIT2; // 0x48
    STRUCT axi_limit3_r AXI_LIMIT3; // 0x4c
    uint32_t unused1[12];
    STRUCT basep0_r BASEP0;   // 0x80
    STRUCT basep1_r BASEP1;   // 0x84
    STRUCT basep2_r BASEP2;   // 0x88
    STRUCT basep3_r BASEP3;   // 0x8c
    STRUCT basep4_r BASEP4;   // 0x90
    STRUCT basep5_r BASEP5;   // 0x94
    STRUCT basep6_r BASEP6;   // 0x98
    STRUCT basep7_r BASEP7;   // 0x9c
    STRUCT basep8_r BASEP8;   // 0xa0
    STRUCT basep9_r BASEP9;   // 0xa4
    STRUCT basep10_r BASEP10; // 0xa8
    STRUCT basep11_r BASEP11; // 0xac
    STRUCT basep12_r BASEP12; // 0xb0
    STRUCT basep13_r BASEP13; // 0xb4
    STRUCT basep14_r BASEP14; // 0xb8
    STRUCT basep15_r BASEP15; // 0xbc
    uint32_t unused2[16];
    STRUCT wd_status_r WD_STATUS;   // 0x100
    STRUCT mac_status_r MAC_STATUS; // 0x104
    STRUCT ao_status_r AO_STATUS;   // 0x108
    uint32_t unused3[1];
    STRUCT dma_status0_r DMA_STATUS0; // 0x110
    STRUCT dma_status1_r DMA_STATUS1; // 0x114
    uint32_t unused4[10];
    STRUCT clkforce_r CLKFORCE; // 0x140
    uint32_t DEBUG_ADDRESS;     // 0x144
    uint32_t DEBUG_MISC;        // 0x148
    uint32_t DEBUGCORE;         // 0x14c
    uint32_t DEBUG_BLOCK;       // 0x150
    uint32_t unused5[11];
    STRUCT pmcr_r PMCR;             // 0x180
    STRUCT pmcntenset_r PMCNTENSET; // 0x184
    STRUCT pmcntenclr_r PMCNTENCLR; // 0x188
    STRUCT pmovsset_r PMOVSSET;     // 0x18c
    STRUCT pmovsclr_r PMOVSCLR;     // 0x190
    STRUCT pmintset_r PMINTSET;     // 0x194
    STRUCT pmintclr_r PMINTCLR;     // 0x198
    uint32_t unused6[1];
    STRUCT pmccntr_lo_r PMCCNTR_LO;   // 0x1a0
    STRUCT pmccntr_hi_r PMCCNTR_HI;   // 0x1a4
    STRUCT pmccntr_cfg_r PMCCNTR_CFG; // 0x1a8
    STRUCT pmcaxi_chan_r PMCAXI_CHAN; // 0x1ac
    uint32_t unused7[20];
    uint32_t KERNEL_X;           // 0x200
    uint32_t KERNEL_Y;           // 0x204
    uint32_t KERNEL_W_M1;        // 0x208
    uint32_t KERNEL_H_M1;        // 0x20c
    uint32_t OFM_CBLK_WIDTH_M1;  // 0x210
    uint32_t OFM_CBLK_HEIGHT_M1; // 0x214
    uint32_t OFM_CBLK_DEPTH_M1;  // 0x218
    uint32_t IFM_CBLK_DEPTH_M1;  // 0x21c
    uint32_t OFM_X;              // 0x220
    uint32_t OFM_Y;              // 0x224
    uint32_t OFM_Z;              // 0x228
    uint32_t IFM_Z;              // 0x22c
    uint32_t PAD_TOP;            // 0x230
    uint32_t PAD_LEFT;           // 0x234
    uint32_t IFM_CBLK_WIDTH;     // 0x238
    uint32_t IFM_CBLK_HEIGHT;    // 0x23c
    uint32_t DMA_IFM_SRC;        // 0x240
    uint32_t DMA_IFM_SRC_HI;     // 0x244
    uint32_t DMA_IFM_DST;        // 0x248
    uint32_t DMA_OFM_SRC;        // 0x24c
    uint32_t DMA_OFM_DST;        // 0x250
    uint32_t DMA_OFM_DST_HI;     // 0x254
    uint32_t DMA_WEIGHT_SRC;     // 0x258
    uint32_t DMA_WEIGHT_SRC_HI;  // 0x25c
    uint32_t DMA_CMD_SRC;        // 0x260
    uint32_t DMA_CMD_SRC_HI;     // 0x264
    uint32_t DMA_CMD_SIZE;       // 0x268
    uint32_t DMA_M2M_SRC;        // 0x26c
    uint32_t DMA_M2M_SRC_HI;     // 0x270
    uint32_t DMA_M2M_DST;        // 0x274
    uint32_t DMA_M2M_DST_HI;     // 0x278
    uint32_t CURRENT_QREAD;      // 0x27c
    uint32_t DMA_SCALE_SRC;      // 0x280
    uint32_t DMA_SCALE_SRC_HI;   // 0x284
    uint32_t unused8[11];
    uint32_t CURRENT_BLOCK; // 0x2b4
    uint32_t CURRENT_OP;    // 0x2b8
    uint32_t CURRENT_CMD;   // 0x2bc
    uint32_t unused9[16];
    uint32_t PMEVCNTR[4]; // 0x300
    uint32_t unused10[28];
    STRUCT pmevtyper0_r PMEVTYPER[4]; // 0x380
    uint32_t unused11[28];
    uint32_t SHARED_BUFFER[256]; // 0x400
    uint32_t IFM_PAD_TOP;        // 0x800
    uint32_t IFM_PAD_LEFT;       // 0x804
    uint32_t IFM_PAD_RIGHT;      // 0x808
    uint32_t IFM_PAD_BOTTOM;     // 0x80c
    uint32_t IFM_DEPTH_M1;       // 0x810
    uint32_t IFM_PRECISION;      // 0x814
    uint32_t unused12[1];
    uint32_t IFM_UPSCALE; // 0x81c
    uint32_t unused13[1];
    uint32_t IFM_ZERO_POINT; // 0x824
    uint32_t IFM_WIDTH0_M1;  // 0x828
    uint32_t IFM_HEIGHT0_M1; // 0x82c
    uint32_t IFM_HEIGHT1_M1; // 0x830
    uint32_t IFM_IB_END;     // 0x834
    uint32_t unused14[1];
    uint32_t IFM_REGION; // 0x83c
    uint32_t unused15[1];
    uint32_t OFM_WIDTH_M1;      // 0x844
    uint32_t OFM_HEIGHT_M1;     // 0x848
    uint32_t OFM_DEPTH_M1;      // 0x84c
    uint32_t OFM_PRECISION;     // 0x850
    uint32_t OFM_BLK_WIDTH_M1;  // 0x854
    uint32_t OFM_BLK_HEIGHT_M1; // 0x858
    uint32_t OFM_BLK_DEPTH_M1;  // 0x85c
    uint32_t OFM_ZERO_POINT;    // 0x860
    uint32_t unused16[1];
    uint32_t OFM_WIDTH0_M1;  // 0x868
    uint32_t OFM_HEIGHT0_M1; // 0x86c
    uint32_t OFM_HEIGHT1_M1; // 0x870
    uint32_t unused17[2];
    uint32_t OFM_REGION;       // 0x87c
    uint32_t KERNEL_WIDTH_M1;  // 0x880
    uint32_t KERNEL_HEIGHT_M1; // 0x884
    uint32_t KERNEL_STRIDE;    // 0x888
    uint32_t PARALLEL_MODE;    // 0x88c
    uint32_t ACC_FORMAT;       // 0x890
    uint32_t ACTIVATION;       // 0x894
    uint32_t ACTIVATION_MIN;   // 0x898
    uint32_t ACTIVATION_MAX;   // 0x89c
    uint32_t WEIGHT_REGION;    // 0x8a0
    uint32_t SCALE_REGION;     // 0x8a4
    uint32_t unused18[3];
    uint32_t AB_START; // 0x8b4
    uint32_t unused19[1];
    uint32_t BLOCKDEP;        // 0x8bc
    uint32_t DMA0_SRC_REGION; // 0x8c0
    uint32_t DMA0_DST_REGION; // 0x8c4
    uint32_t DMA0_SIZE0;      // 0x8c8
    uint32_t DMA0_SIZE1;      // 0x8cc
    uint32_t unused20[12];
    uint32_t IFM2_BROADCAST; // 0x900
    uint32_t IFM2_SCALAR;    // 0x904
    uint32_t unused21[3];
    uint32_t IFM2_PRECISION; // 0x914
    uint32_t unused22[3];
    uint32_t IFM2_ZERO_POINT; // 0x924
    uint32_t IFM2_WIDTH0_M1;  // 0x928
    uint32_t IFM2_HEIGHT0_M1; // 0x92c
    uint32_t IFM2_HEIGHT1_M1; // 0x930
    uint32_t IFM2_IB_START;   // 0x934
    uint32_t unused23[1];
    uint32_t IFM2_REGION; // 0x93c
    uint32_t unused24[48];
    uint32_t IFM_BASE0;       // 0xa00
    uint32_t IFM_BASE0_HI;    // 0xa04
    uint32_t IFM_BASE1;       // 0xa08
    uint32_t IFM_BASE1_HI;    // 0xa0c
    uint32_t IFM_BASE2;       // 0xa10
    uint32_t IFM_BASE2_HI;    // 0xa14
    uint32_t IFM_BASE3;       // 0xa18
    uint32_t IFM_BASE3_HI;    // 0xa1c
    uint32_t IFM_STRIDE_X;    // 0xa20
    uint32_t IFM_STRIDE_X_HI; // 0xa24
    uint32_t IFM_STRIDE_Y;    // 0xa28
    uint32_t IFM_STRIDE_Y_HI; // 0xa2c
    uint32_t IFM_STRIDE_C;    // 0xa30
    uint32_t IFM_STRIDE_C_HI; // 0xa34
    uint32_t unused25[2];
    uint32_t OFM_BASE0;       // 0xa40
    uint32_t OFM_BASE0_HI;    // 0xa44
    uint32_t OFM_BASE1;       // 0xa48
    uint32_t OFM_BASE1_HI;    // 0xa4c
    uint32_t OFM_BASE2;       // 0xa50
    uint32_t OFM_BASE2_HI;    // 0xa54
    uint32_t OFM_BASE3;       // 0xa58
    uint32_t OFM_BASE3_HI;    // 0xa5c
    uint32_t OFM_STRIDE_X;    // 0xa60
    uint32_t OFM_STRIDE_X_HI; // 0xa64
    uint32_t OFM_STRIDE_Y;    // 0xa68
    uint32_t OFM_STRIDE_Y_HI; // 0xa6c
    uint32_t OFM_STRIDE_C;    // 0xa70
    uint32_t OFM_STRIDE_C_HI; // 0xa74
    uint32_t unused26[2];
    uint32_t WEIGHT_BASE;    // 0xa80
    uint32_t WEIGHT_BASE_HI; // 0xa84
    uint32_t WEIGHT_LENGTH;  // 0xa88
    uint32_t unused27[1];
    uint32_t SCALE_BASE;    // 0xa90
    uint32_t SCALE_BASE_HI; // 0xa94
    uint32_t SCALE_LENGTH;  // 0xa98
    uint32_t unused28[1];
    uint32_t OFM_SCALE;       // 0xaa0
    uint32_t OFM_SCALE_SHIFT; // 0xaa4
    uint32_t OPA_SCALE;       // 0xaa8
    uint32_t OPA_SCALE_SHIFT; // 0xaac
    uint32_t OPB_SCALE;       // 0xab0
    uint32_t unused29[3];
    uint32_t DMA0_SRC;      // 0xac0
    uint32_t DMA0_SRC_HI;   // 0xac4
    uint32_t DMA0_DST;      // 0xac8
    uint32_t DMA0_DST_HI;   // 0xacc
    uint32_t DMA0_LEN;      // 0xad0
    uint32_t DMA0_LEN_HI;   // 0xad4
    uint32_t DMA0_SKIP0;    // 0xad8
    uint32_t DMA0_SKIP0_HI; // 0xadc
    uint32_t DMA0_SKIP1;    // 0xae0
    uint32_t DMA0_SKIP1_HI; // 0xae4
    uint32_t unused30[6];
    uint32_t IFM2_BASE0;       // 0xb00
    uint32_t IFM2_BASE0_HI;    // 0xb04
    uint32_t IFM2_BASE1;       // 0xb08
    uint32_t IFM2_BASE1_HI;    // 0xb0c
    uint32_t IFM2_BASE2;       // 0xb10
    uint32_t IFM2_BASE2_HI;    // 0xb14
    uint32_t IFM2_BASE3;       // 0xb18
    uint32_t IFM2_BASE3_HI;    // 0xb1c
    uint32_t IFM2_STRIDE_X;    // 0xb20
    uint32_t IFM2_STRIDE_X_HI; // 0xb24
    uint32_t IFM2_STRIDE_Y;    // 0xb28
    uint32_t IFM2_STRIDE_Y_HI; // 0xb2c
    uint32_t IFM2_STRIDE_C;    // 0xb30
    uint32_t IFM2_STRIDE_C_HI; // 0xb34
    uint32_t unused31[2];
    uint32_t WEIGHT1_BASE;    // 0xb40
    uint32_t WEIGHT1_BASE_HI; // 0xb44
    uint32_t WEIGHT1_LENGTH;  // 0xb48
    uint32_t unused32[1];
    uint32_t SCALE1_BASE;    // 0xb50
    uint32_t SCALE1_BASE_HI; // 0xb54
    uint32_t SCALE1_LENGTH;  // 0xb58
    uint32_t unused33[281];
    uint32_t REVISION; // 0xfc0
    uint32_t unused34[3];
    STRUCT pid4_r PID4; // 0xfd0
    STRUCT pid5_r PID5; // 0xfd4
    STRUCT pid6_r PID6; // 0xfd8
    STRUCT pid7_r PID7; // 0xfdc
    STRUCT pid0_r PID0; // 0xfe0
    STRUCT pid1_r PID1; // 0xfe4
    STRUCT pid2_r PID2; // 0xfe8
    STRUCT pid3_r PID3; // 0xfec
    STRUCT cid0_r CID0; // 0xff0
    STRUCT cid1_r CID1; // 0xff4
    STRUCT cid2_r CID2; // 0xff8
    STRUCT cid3_r CID3; // 0xffc
#ifdef __cplusplus
    NPU_REG()
    {
        reset();
    }
    void reset()
    {
        ID                 = 268845313;
        STATUS             = 8;
        CMD                = 12;
        RESET              = 0;
        QBASE0             = 0;
        QBASE1             = 0;
        QREAD              = 0;
        QCONFIG            = 0;
        QSIZE              = 0;
        PROT               = 0;
        CONFIG             = 0;
        LOCK               = 0;
        REGIONCFG          = 0;
        AXI_LIMIT0         = 0;
        AXI_LIMIT1         = 0;
        AXI_LIMIT2         = 0;
        AXI_LIMIT3         = 0;
        BASEP0             = 0;
        BASEP1             = 0;
        BASEP2             = 0;
        BASEP3             = 0;
        BASEP4             = 0;
        BASEP5             = 0;
        BASEP6             = 0;
        BASEP7             = 0;
        BASEP8             = 0;
        BASEP9             = 0;
        BASEP10            = 0;
        BASEP11            = 0;
        BASEP12            = 0;
        BASEP13            = 0;
        BASEP14            = 0;
        BASEP15            = 0;
        REVISION           = 0;
        PID4               = 4;
        PID5               = 0;
        PID6               = 0;
        PID7               = 0;
        PID0               = 128;
        PID1               = 181;
        PID2               = 11;
        PID3               = 0;
        CID0               = 13;
        CID1               = 240;
        CID2               = 5;
        CID3               = 177;
        WD_STATUS          = 0;
        MAC_STATUS         = 0;
        AO_STATUS          = 0;
        DMA_STATUS0        = 0;
        DMA_STATUS1        = 0;
        CLKFORCE           = 0;
        DEBUG_ADDRESS      = 0;
        DEBUG_MISC         = 0;
        DEBUGCORE          = 0;
        DEBUG_BLOCK        = 0;
        KERNEL_X           = 0;
        KERNEL_Y           = 0;
        KERNEL_W_M1        = 0;
        KERNEL_H_M1        = 0;
        OFM_CBLK_WIDTH_M1  = 0;
        OFM_CBLK_HEIGHT_M1 = 0;
        OFM_CBLK_DEPTH_M1  = 0;
        IFM_CBLK_DEPTH_M1  = 0;
        OFM_X              = 0;
        OFM_Y              = 0;
        OFM_Z              = 0;
        IFM_Z              = 0;
        PAD_TOP            = 0;
        PAD_LEFT           = 0;
        IFM_CBLK_WIDTH     = 0;
        IFM_CBLK_HEIGHT    = 0;
        DMA_IFM_SRC        = 0;
        DMA_IFM_SRC_HI     = 0;
        DMA_IFM_DST        = 0;
        DMA_OFM_SRC        = 0;
        DMA_OFM_DST        = 0;
        DMA_OFM_DST_HI     = 0;
        DMA_WEIGHT_SRC     = 0;
        DMA_WEIGHT_SRC_HI  = 0;
        DMA_CMD_SRC        = 0;
        DMA_CMD_SRC_HI     = 0;
        DMA_CMD_SIZE       = 0;
        DMA_M2M_SRC        = 0;
        DMA_M2M_SRC_HI     = 0;
        DMA_M2M_DST        = 0;
        DMA_M2M_DST_HI     = 0;
        CURRENT_QREAD      = 0;
        DMA_SCALE_SRC      = 0;
        DMA_SCALE_SRC_HI   = 0;
        CURRENT_BLOCK      = 0;
        CURRENT_OP         = 0;
        CURRENT_CMD        = 0;
        IFM_PAD_TOP        = 0;
        IFM_PAD_LEFT       = 0;
        IFM_PAD_RIGHT      = 0;
        IFM_PAD_BOTTOM     = 0;
        IFM_DEPTH_M1       = 0;
        IFM_PRECISION      = 0;
        IFM_UPSCALE        = 0;
        IFM_ZERO_POINT     = 0;
        IFM_WIDTH0_M1      = 0;
        IFM_HEIGHT0_M1     = 0;
        IFM_HEIGHT1_M1     = 0;
        IFM_IB_END         = 0;
        IFM_REGION         = 0;
        OFM_WIDTH_M1       = 0;
        OFM_HEIGHT_M1      = 0;
        OFM_DEPTH_M1       = 0;
        OFM_PRECISION      = 0;
        OFM_BLK_WIDTH_M1   = 0;
        OFM_BLK_HEIGHT_M1  = 0;
        OFM_BLK_DEPTH_M1   = 0;
        OFM_ZERO_POINT     = 0;
        OFM_WIDTH0_M1      = 0;
        OFM_HEIGHT0_M1     = 0;
        OFM_HEIGHT1_M1     = 0;
        OFM_REGION         = 0;
        KERNEL_WIDTH_M1    = 0;
        KERNEL_HEIGHT_M1   = 0;
        KERNEL_STRIDE      = 0;
        PARALLEL_MODE      = 0;
        ACC_FORMAT         = 0;
        ACTIVATION         = 0;
        ACTIVATION_MIN     = 0;
        ACTIVATION_MAX     = 0;
        WEIGHT_REGION      = 0;
        SCALE_REGION       = 0;
        AB_START           = 0;
        BLOCKDEP           = 0;
        DMA0_SRC_REGION    = 0;
        DMA0_DST_REGION    = 0;
        DMA0_SIZE0         = 0;
        DMA0_SIZE1         = 0;
        IFM2_BROADCAST     = 0;
        IFM2_SCALAR        = 0;
        IFM2_PRECISION     = 0;
        IFM2_ZERO_POINT    = 0;
        IFM2_WIDTH0_M1     = 0;
        IFM2_HEIGHT0_M1    = 0;
        IFM2_HEIGHT1_M1    = 0;
        IFM2_IB_START      = 0;
        IFM2_REGION        = 0;
        IFM_BASE0          = 0;
        IFM_BASE0_HI       = 0;
        IFM_BASE1          = 0;
        IFM_BASE1_HI       = 0;
        IFM_BASE2          = 0;
        IFM_BASE2_HI       = 0;
        IFM_BASE3          = 0;
        IFM_BASE3_HI       = 0;
        IFM_STRIDE_X       = 0;
        IFM_STRIDE_X_HI    = 0;
        IFM_STRIDE_Y       = 0;
        IFM_STRIDE_Y_HI    = 0;
        IFM_STRIDE_C       = 0;
        IFM_STRIDE_C_HI    = 0;
        OFM_BASE0          = 0;
        OFM_BASE0_HI       = 0;
        OFM_BASE1          = 0;
        OFM_BASE1_HI       = 0;
        OFM_BASE2          = 0;
        OFM_BASE2_HI       = 0;
        OFM_BASE3          = 0;
        OFM_BASE3_HI       = 0;
        OFM_STRIDE_X       = 0;
        OFM_STRIDE_X_HI    = 0;
        OFM_STRIDE_Y       = 0;
        OFM_STRIDE_Y_HI    = 0;
        OFM_STRIDE_C       = 0;
        OFM_STRIDE_C_HI    = 0;
        WEIGHT_BASE        = 0;
        WEIGHT_BASE_HI     = 0;
        WEIGHT_LENGTH      = 0;
        SCALE_BASE         = 0;
        SCALE_BASE_HI      = 0;
        SCALE_LENGTH       = 0;
        OFM_SCALE          = 0;
        OFM_SCALE_SHIFT    = 0;
        OPA_SCALE          = 0;
        OPA_SCALE_SHIFT    = 0;
        OPB_SCALE          = 0;
        DMA0_SRC           = 0;
        DMA0_SRC_HI        = 0;
        DMA0_DST           = 0;
        DMA0_DST_HI        = 0;
        DMA0_LEN           = 0;
        DMA0_LEN_HI        = 0;
        DMA0_SKIP0         = 0;
        DMA0_SKIP0_HI      = 0;
        DMA0_SKIP1         = 0;
        DMA0_SKIP1_HI      = 0;
        IFM2_BASE0         = 0;
        IFM2_BASE0_HI      = 0;
        IFM2_BASE1         = 0;
        IFM2_BASE1_HI      = 0;
        IFM2_BASE2         = 0;
        IFM2_BASE2_HI      = 0;
        IFM2_BASE3         = 0;
        IFM2_BASE3_HI      = 0;
        IFM2_STRIDE_X      = 0;
        IFM2_STRIDE_X_HI   = 0;
        IFM2_STRIDE_Y      = 0;
        IFM2_STRIDE_Y_HI   = 0;
        IFM2_STRIDE_C      = 0;
        IFM2_STRIDE_C_HI   = 0;
        WEIGHT1_BASE       = 0;
        WEIGHT1_BASE_HI    = 0;
        WEIGHT1_LENGTH     = 0;
        SCALE1_BASE        = 0;
        SCALE1_BASE_HI     = 0;
        SCALE1_LENGTH      = 0;
        PMCR               = 8192;
        PMCNTENSET         = 0;
        PMCNTENCLR         = 0;
        PMOVSSET           = 0;
        PMOVSCLR           = 0;
        PMINTSET           = 0;
        PMINTCLR           = 0;
        PMCCNTR_LO         = 0;
        PMCCNTR_HI         = 0;
        PMCCNTR_CFG        = 0;
        PMCAXI_CHAN        = 0;
        for (size_t i = 0; i < (sizeof(PMEVCNTR) / sizeof(PMEVCNTR[0])); ++i)
            PMEVCNTR[i] = 0;
        for (size_t i = 0; i < (sizeof(PMEVTYPER) / sizeof(PMEVTYPER[0])); ++i)
            PMEVTYPER[i] = 0;
        for (size_t i = 0; i < (sizeof(SHARED_BUFFER) / sizeof(SHARED_BUFFER[0])); ++i)
            SHARED_BUFFER[i] = 0;
    }
    uint32_t &operator[](const int addr_offset)
    {
        return reinterpret_cast<uint32_t *>(this)[addr_offset / 4];
    }
    enum class access_type_t : bool
    {
        RO,
        RW
    };
    access_type_t get_access_type(uint32_t offset)
    {
        switch (offset)
        {
        case 0:
            return access_type_t::RO;
        case 4:
            return access_type_t::RO;
        case 8:
            return access_type_t::RW;
        case 12:
            return access_type_t::RW;
        case 16:
            return access_type_t::RW;
        case 20:
            return access_type_t::RW;
        case 24:
            return access_type_t::RO;
        case 28:
            return access_type_t::RW;
        case 32:
            return access_type_t::RW;
        case 36:
            return access_type_t::RO;
        case 40:
            return access_type_t::RO;
        case 44:
            return access_type_t::RW;
        case 60:
            return access_type_t::RW;
        case 64:
            return access_type_t::RW;
        case 68:
            return access_type_t::RW;
        case 72:
            return access_type_t::RW;
        case 76:
            return access_type_t::RW;
        case 128:
            return access_type_t::RW;
        case 132:
            return access_type_t::RW;
        case 136:
            return access_type_t::RW;
        case 140:
            return access_type_t::RW;
        case 144:
            return access_type_t::RW;
        case 148:
            return access_type_t::RW;
        case 152:
            return access_type_t::RW;
        case 156:
            return access_type_t::RW;
        case 160:
            return access_type_t::RW;
        case 164:
            return access_type_t::RW;
        case 168:
            return access_type_t::RW;
        case 172:
            return access_type_t::RW;
        case 176:
            return access_type_t::RW;
        case 180:
            return access_type_t::RW;
        case 184:
            return access_type_t::RW;
        case 188:
            return access_type_t::RW;
        case 4032:
            return access_type_t::RO;
        case 4048:
            return access_type_t::RO;
        case 4052:
            return access_type_t::RO;
        case 4056:
            return access_type_t::RO;
        case 4060:
            return access_type_t::RO;
        case 4064:
            return access_type_t::RO;
        case 4068:
            return access_type_t::RO;
        case 4072:
            return access_type_t::RO;
        case 4076:
            return access_type_t::RO;
        case 4080:
            return access_type_t::RO;
        case 4084:
            return access_type_t::RO;
        case 4088:
            return access_type_t::RO;
        case 4092:
            return access_type_t::RO;
        case 256:
            return access_type_t::RO;
        case 260:
            return access_type_t::RO;
        case 264:
            return access_type_t::RO;
        case 272:
            return access_type_t::RO;
        case 276:
            return access_type_t::RO;
        case 320:
            return access_type_t::RW;
        case 324:
            return access_type_t::RW;
        case 328:
            return access_type_t::RW;
        case 332:
            return access_type_t::RW;
        case 336:
            return access_type_t::RW;
        case 512:
            return access_type_t::RO;
        case 516:
            return access_type_t::RO;
        case 520:
            return access_type_t::RO;
        case 524:
            return access_type_t::RO;
        case 528:
            return access_type_t::RO;
        case 532:
            return access_type_t::RO;
        case 536:
            return access_type_t::RO;
        case 540:
            return access_type_t::RO;
        case 544:
            return access_type_t::RO;
        case 548:
            return access_type_t::RO;
        case 552:
            return access_type_t::RO;
        case 556:
            return access_type_t::RO;
        case 560:
            return access_type_t::RO;
        case 564:
            return access_type_t::RO;
        case 568:
            return access_type_t::RO;
        case 572:
            return access_type_t::RO;
        case 576:
            return access_type_t::RO;
        case 580:
            return access_type_t::RO;
        case 584:
            return access_type_t::RO;
        case 588:
            return access_type_t::RO;
        case 592:
            return access_type_t::RO;
        case 596:
            return access_type_t::RO;
        case 600:
            return access_type_t::RO;
        case 604:
            return access_type_t::RO;
        case 608:
            return access_type_t::RO;
        case 612:
            return access_type_t::RO;
        case 616:
            return access_type_t::RO;
        case 620:
            return access_type_t::RO;
        case 624:
            return access_type_t::RO;
        case 628:
            return access_type_t::RO;
        case 632:
            return access_type_t::RO;
        case 636:
            return access_type_t::RO;
        case 640:
            return access_type_t::RO;
        case 644:
            return access_type_t::RO;
        case 692:
            return access_type_t::RO;
        case 696:
            return access_type_t::RO;
        case 700:
            return access_type_t::RO;
        case 2048:
            return access_type_t::RW;
        case 2052:
            return access_type_t::RW;
        case 2056:
            return access_type_t::RW;
        case 2060:
            return access_type_t::RW;
        case 2064:
            return access_type_t::RW;
        case 2068:
            return access_type_t::RW;
        case 2076:
            return access_type_t::RW;
        case 2084:
            return access_type_t::RW;
        case 2088:
            return access_type_t::RW;
        case 2092:
            return access_type_t::RW;
        case 2096:
            return access_type_t::RW;
        case 2100:
            return access_type_t::RW;
        case 2108:
            return access_type_t::RW;
        case 2116:
            return access_type_t::RW;
        case 2120:
            return access_type_t::RW;
        case 2124:
            return access_type_t::RW;
        case 2128:
            return access_type_t::RW;
        case 2132:
            return access_type_t::RW;
        case 2136:
            return access_type_t::RW;
        case 2140:
            return access_type_t::RW;
        case 2144:
            return access_type_t::RW;
        case 2152:
            return access_type_t::RW;
        case 2156:
            return access_type_t::RW;
        case 2160:
            return access_type_t::RW;
        case 2172:
            return access_type_t::RW;
        case 2176:
            return access_type_t::RW;
        case 2180:
            return access_type_t::RW;
        case 2184:
            return access_type_t::RW;
        case 2188:
            return access_type_t::RW;
        case 2192:
            return access_type_t::RW;
        case 2196:
            return access_type_t::RW;
        case 2200:
            return access_type_t::RW;
        case 2204:
            return access_type_t::RW;
        case 2208:
            return access_type_t::RW;
        case 2212:
            return access_type_t::RW;
        case 2228:
            return access_type_t::RW;
        case 2236:
            return access_type_t::RW;
        case 2240:
            return access_type_t::RW;
        case 2244:
            return access_type_t::RW;
        case 2248:
            return access_type_t::RW;
        case 2252:
            return access_type_t::RW;
        case 2304:
            return access_type_t::RW;
        case 2308:
            return access_type_t::RW;
        case 2324:
            return access_type_t::RW;
        case 2340:
            return access_type_t::RW;
        case 2344:
            return access_type_t::RW;
        case 2348:
            return access_type_t::RW;
        case 2352:
            return access_type_t::RW;
        case 2356:
            return access_type_t::RW;
        case 2364:
            return access_type_t::RW;
        case 2560:
            return access_type_t::RW;
        case 2564:
            return access_type_t::RW;
        case 2568:
            return access_type_t::RW;
        case 2572:
            return access_type_t::RW;
        case 2576:
            return access_type_t::RW;
        case 2580:
            return access_type_t::RW;
        case 2584:
            return access_type_t::RW;
        case 2588:
            return access_type_t::RW;
        case 2592:
            return access_type_t::RW;
        case 2596:
            return access_type_t::RW;
        case 2600:
            return access_type_t::RW;
        case 2604:
            return access_type_t::RW;
        case 2608:
            return access_type_t::RW;
        case 2612:
            return access_type_t::RW;
        case 2624:
            return access_type_t::RW;
        case 2628:
            return access_type_t::RW;
        case 2632:
            return access_type_t::RW;
        case 2636:
            return access_type_t::RW;
        case 2640:
            return access_type_t::RW;
        case 2644:
            return access_type_t::RW;
        case 2648:
            return access_type_t::RW;
        case 2652:
            return access_type_t::RW;
        case 2656:
            return access_type_t::RW;
        case 2660:
            return access_type_t::RW;
        case 2664:
            return access_type_t::RW;
        case 2668:
            return access_type_t::RW;
        case 2672:
            return access_type_t::RW;
        case 2676:
            return access_type_t::RW;
        case 2688:
            return access_type_t::RW;
        case 2692:
            return access_type_t::RW;
        case 2696:
            return access_type_t::RW;
        case 2704:
            return access_type_t::RW;
        case 2708:
            return access_type_t::RW;
        case 2712:
            return access_type_t::RW;
        case 2720:
            return access_type_t::RW;
        case 2724:
            return access_type_t::RW;
        case 2728:
            return access_type_t::RW;
        case 2732:
            return access_type_t::RW;
        case 2736:
            return access_type_t::RW;
        case 2752:
            return access_type_t::RW;
        case 2756:
            return access_type_t::RW;
        case 2760:
            return access_type_t::RW;
        case 2764:
            return access_type_t::RW;
        case 2768:
            return access_type_t::RW;
        case 2772:
            return access_type_t::RW;
        case 2776:
            return access_type_t::RW;
        case 2780:
            return access_type_t::RW;
        case 2784:
            return access_type_t::RW;
        case 2788:
            return access_type_t::RW;
        case 2816:
            return access_type_t::RW;
        case 2820:
            return access_type_t::RW;
        case 2824:
            return access_type_t::RW;
        case 2828:
            return access_type_t::RW;
        case 2832:
            return access_type_t::RW;
        case 2836:
            return access_type_t::RW;
        case 2840:
            return access_type_t::RW;
        case 2844:
            return access_type_t::RW;
        case 2848:
            return access_type_t::RW;
        case 2852:
            return access_type_t::RW;
        case 2856:
            return access_type_t::RW;
        case 2860:
            return access_type_t::RW;
        case 2864:
            return access_type_t::RW;
        case 2868:
            return access_type_t::RW;
        case 2880:
            return access_type_t::RW;
        case 2884:
            return access_type_t::RW;
        case 2888:
            return access_type_t::RW;
        case 2896:
            return access_type_t::RW;
        case 2900:
            return access_type_t::RW;
        case 2904:
            return access_type_t::RW;
        case 384:
            return access_type_t::RW;
        case 388:
            return access_type_t::RW;
        case 392:
            return access_type_t::RW;
        case 396:
            return access_type_t::RW;
        case 400:
            return access_type_t::RW;
        case 404:
            return access_type_t::RW;
        case 408:
            return access_type_t::RW;
        case 416:
            return access_type_t::RW;
        case 420:
            return access_type_t::RW;
        case 424:
            return access_type_t::RW;
        case 428:
            return access_type_t::RW;
        case 768:
            return access_type_t::RW;
        case 772:
            return access_type_t::RW;
        case 776:
            return access_type_t::RW;
        case 780:
            return access_type_t::RW;
        case 896:
            return access_type_t::RW;
        case 900:
            return access_type_t::RW;
        case 904:
            return access_type_t::RW;
        case 908:
            return access_type_t::RW;
        case 1024:
            return access_type_t::RW;
        case 1028:
            return access_type_t::RW;
        case 1032:
            return access_type_t::RW;
        case 1036:
            return access_type_t::RW;
        case 1040:
            return access_type_t::RW;
        case 1044:
            return access_type_t::RW;
        case 1048:
            return access_type_t::RW;
        case 1052:
            return access_type_t::RW;
        case 1056:
            return access_type_t::RW;
        case 1060:
            return access_type_t::RW;
        case 1064:
            return access_type_t::RW;
        case 1068:
            return access_type_t::RW;
        case 1072:
            return access_type_t::RW;
        case 1076:
            return access_type_t::RW;
        case 1080:
            return access_type_t::RW;
        case 1084:
            return access_type_t::RW;
        case 1088:
            return access_type_t::RW;
        case 1092:
            return access_type_t::RW;
        case 1096:
            return access_type_t::RW;
        case 1100:
            return access_type_t::RW;
        case 1104:
            return access_type_t::RW;
        case 1108:
            return access_type_t::RW;
        case 1112:
            return access_type_t::RW;
        case 1116:
            return access_type_t::RW;
        case 1120:
            return access_type_t::RW;
        case 1124:
            return access_type_t::RW;
        case 1128:
            return access_type_t::RW;
        case 1132:
            return access_type_t::RW;
        case 1136:
            return access_type_t::RW;
        case 1140:
            return access_type_t::RW;
        case 1144:
            return access_type_t::RW;
        case 1148:
            return access_type_t::RW;
        case 1152:
            return access_type_t::RW;
        case 1156:
            return access_type_t::RW;
        case 1160:
            return access_type_t::RW;
        case 1164:
            return access_type_t::RW;
        case 1168:
            return access_type_t::RW;
        case 1172:
            return access_type_t::RW;
        case 1176:
            return access_type_t::RW;
        case 1180:
            return access_type_t::RW;
        case 1184:
            return access_type_t::RW;
        case 1188:
            return access_type_t::RW;
        case 1192:
            return access_type_t::RW;
        case 1196:
            return access_type_t::RW;
        case 1200:
            return access_type_t::RW;
        case 1204:
            return access_type_t::RW;
        case 1208:
            return access_type_t::RW;
        case 1212:
            return access_type_t::RW;
        case 1216:
            return access_type_t::RW;
        case 1220:
            return access_type_t::RW;
        case 1224:
            return access_type_t::RW;
        case 1228:
            return access_type_t::RW;
        case 1232:
            return access_type_t::RW;
        case 1236:
            return access_type_t::RW;
        case 1240:
            return access_type_t::RW;
        case 1244:
            return access_type_t::RW;
        case 1248:
            return access_type_t::RW;
        case 1252:
            return access_type_t::RW;
        case 1256:
            return access_type_t::RW;
        case 1260:
            return access_type_t::RW;
        case 1264:
            return access_type_t::RW;
        case 1268:
            return access_type_t::RW;
        case 1272:
            return access_type_t::RW;
        case 1276:
            return access_type_t::RW;
        case 1280:
            return access_type_t::RW;
        case 1284:
            return access_type_t::RW;
        case 1288:
            return access_type_t::RW;
        case 1292:
            return access_type_t::RW;
        case 1296:
            return access_type_t::RW;
        case 1300:
            return access_type_t::RW;
        case 1304:
            return access_type_t::RW;
        case 1308:
            return access_type_t::RW;
        case 1312:
            return access_type_t::RW;
        case 1316:
            return access_type_t::RW;
        case 1320:
            return access_type_t::RW;
        case 1324:
            return access_type_t::RW;
        case 1328:
            return access_type_t::RW;
        case 1332:
            return access_type_t::RW;
        case 1336:
            return access_type_t::RW;
        case 1340:
            return access_type_t::RW;
        case 1344:
            return access_type_t::RW;
        case 1348:
            return access_type_t::RW;
        case 1352:
            return access_type_t::RW;
        case 1356:
            return access_type_t::RW;
        case 1360:
            return access_type_t::RW;
        case 1364:
            return access_type_t::RW;
        case 1368:
            return access_type_t::RW;
        case 1372:
            return access_type_t::RW;
        case 1376:
            return access_type_t::RW;
        case 1380:
            return access_type_t::RW;
        case 1384:
            return access_type_t::RW;
        case 1388:
            return access_type_t::RW;
        case 1392:
            return access_type_t::RW;
        case 1396:
            return access_type_t::RW;
        case 1400:
            return access_type_t::RW;
        case 1404:
            return access_type_t::RW;
        case 1408:
            return access_type_t::RW;
        case 1412:
            return access_type_t::RW;
        case 1416:
            return access_type_t::RW;
        case 1420:
            return access_type_t::RW;
        case 1424:
            return access_type_t::RW;
        case 1428:
            return access_type_t::RW;
        case 1432:
            return access_type_t::RW;
        case 1436:
            return access_type_t::RW;
        case 1440:
            return access_type_t::RW;
        case 1444:
            return access_type_t::RW;
        case 1448:
            return access_type_t::RW;
        case 1452:
            return access_type_t::RW;
        case 1456:
            return access_type_t::RW;
        case 1460:
            return access_type_t::RW;
        case 1464:
            return access_type_t::RW;
        case 1468:
            return access_type_t::RW;
        case 1472:
            return access_type_t::RW;
        case 1476:
            return access_type_t::RW;
        case 1480:
            return access_type_t::RW;
        case 1484:
            return access_type_t::RW;
        case 1488:
            return access_type_t::RW;
        case 1492:
            return access_type_t::RW;
        case 1496:
            return access_type_t::RW;
        case 1500:
            return access_type_t::RW;
        case 1504:
            return access_type_t::RW;
        case 1508:
            return access_type_t::RW;
        case 1512:
            return access_type_t::RW;
        case 1516:
            return access_type_t::RW;
        case 1520:
            return access_type_t::RW;
        case 1524:
            return access_type_t::RW;
        case 1528:
            return access_type_t::RW;
        case 1532:
            return access_type_t::RW;
        case 1536:
            return access_type_t::RW;
        case 1540:
            return access_type_t::RW;
        case 1544:
            return access_type_t::RW;
        case 1548:
            return access_type_t::RW;
        case 1552:
            return access_type_t::RW;
        case 1556:
            return access_type_t::RW;
        case 1560:
            return access_type_t::RW;
        case 1564:
            return access_type_t::RW;
        case 1568:
            return access_type_t::RW;
        case 1572:
            return access_type_t::RW;
        case 1576:
            return access_type_t::RW;
        case 1580:
            return access_type_t::RW;
        case 1584:
            return access_type_t::RW;
        case 1588:
            return access_type_t::RW;
        case 1592:
            return access_type_t::RW;
        case 1596:
            return access_type_t::RW;
        case 1600:
            return access_type_t::RW;
        case 1604:
            return access_type_t::RW;
        case 1608:
            return access_type_t::RW;
        case 1612:
            return access_type_t::RW;
        case 1616:
            return access_type_t::RW;
        case 1620:
            return access_type_t::RW;
        case 1624:
            return access_type_t::RW;
        case 1628:
            return access_type_t::RW;
        case 1632:
            return access_type_t::RW;
        case 1636:
            return access_type_t::RW;
        case 1640:
            return access_type_t::RW;
        case 1644:
            return access_type_t::RW;
        case 1648:
            return access_type_t::RW;
        case 1652:
            return access_type_t::RW;
        case 1656:
            return access_type_t::RW;
        case 1660:
            return access_type_t::RW;
        case 1664:
            return access_type_t::RW;
        case 1668:
            return access_type_t::RW;
        case 1672:
            return access_type_t::RW;
        case 1676:
            return access_type_t::RW;
        case 1680:
            return access_type_t::RW;
        case 1684:
            return access_type_t::RW;
        case 1688:
            return access_type_t::RW;
        case 1692:
            return access_type_t::RW;
        case 1696:
            return access_type_t::RW;
        case 1700:
            return access_type_t::RW;
        case 1704:
            return access_type_t::RW;
        case 1708:
            return access_type_t::RW;
        case 1712:
            return access_type_t::RW;
        case 1716:
            return access_type_t::RW;
        case 1720:
            return access_type_t::RW;
        case 1724:
            return access_type_t::RW;
        case 1728:
            return access_type_t::RW;
        case 1732:
            return access_type_t::RW;
        case 1736:
            return access_type_t::RW;
        case 1740:
            return access_type_t::RW;
        case 1744:
            return access_type_t::RW;
        case 1748:
            return access_type_t::RW;
        case 1752:
            return access_type_t::RW;
        case 1756:
            return access_type_t::RW;
        case 1760:
            return access_type_t::RW;
        case 1764:
            return access_type_t::RW;
        case 1768:
            return access_type_t::RW;
        case 1772:
            return access_type_t::RW;
        case 1776:
            return access_type_t::RW;
        case 1780:
            return access_type_t::RW;
        case 1784:
            return access_type_t::RW;
        case 1788:
            return access_type_t::RW;
        case 1792:
            return access_type_t::RW;
        case 1796:
            return access_type_t::RW;
        case 1800:
            return access_type_t::RW;
        case 1804:
            return access_type_t::RW;
        case 1808:
            return access_type_t::RW;
        case 1812:
            return access_type_t::RW;
        case 1816:
            return access_type_t::RW;
        case 1820:
            return access_type_t::RW;
        case 1824:
            return access_type_t::RW;
        case 1828:
            return access_type_t::RW;
        case 1832:
            return access_type_t::RW;
        case 1836:
            return access_type_t::RW;
        case 1840:
            return access_type_t::RW;
        case 1844:
            return access_type_t::RW;
        case 1848:
            return access_type_t::RW;
        case 1852:
            return access_type_t::RW;
        case 1856:
            return access_type_t::RW;
        case 1860:
            return access_type_t::RW;
        case 1864:
            return access_type_t::RW;
        case 1868:
            return access_type_t::RW;
        case 1872:
            return access_type_t::RW;
        case 1876:
            return access_type_t::RW;
        case 1880:
            return access_type_t::RW;
        case 1884:
            return access_type_t::RW;
        case 1888:
            return access_type_t::RW;
        case 1892:
            return access_type_t::RW;
        case 1896:
            return access_type_t::RW;
        case 1900:
            return access_type_t::RW;
        case 1904:
            return access_type_t::RW;
        case 1908:
            return access_type_t::RW;
        case 1912:
            return access_type_t::RW;
        case 1916:
            return access_type_t::RW;
        case 1920:
            return access_type_t::RW;
        case 1924:
            return access_type_t::RW;
        case 1928:
            return access_type_t::RW;
        case 1932:
            return access_type_t::RW;
        case 1936:
            return access_type_t::RW;
        case 1940:
            return access_type_t::RW;
        case 1944:
            return access_type_t::RW;
        case 1948:
            return access_type_t::RW;
        case 1952:
            return access_type_t::RW;
        case 1956:
            return access_type_t::RW;
        case 1960:
            return access_type_t::RW;
        case 1964:
            return access_type_t::RW;
        case 1968:
            return access_type_t::RW;
        case 1972:
            return access_type_t::RW;
        case 1976:
            return access_type_t::RW;
        case 1980:
            return access_type_t::RW;
        case 1984:
            return access_type_t::RW;
        case 1988:
            return access_type_t::RW;
        case 1992:
            return access_type_t::RW;
        case 1996:
            return access_type_t::RW;
        case 2000:
            return access_type_t::RW;
        case 2004:
            return access_type_t::RW;
        case 2008:
            return access_type_t::RW;
        case 2012:
            return access_type_t::RW;
        case 2016:
            return access_type_t::RW;
        case 2020:
            return access_type_t::RW;
        case 2024:
            return access_type_t::RW;
        case 2028:
            return access_type_t::RW;
        case 2032:
            return access_type_t::RW;
        case 2036:
            return access_type_t::RW;
        case 2040:
            return access_type_t::RW;
        case 2044:
            return access_type_t::RW;
        default:
            throw std::runtime_error("invalid register address");
        }
    }
#endif //__cplusplus
};

// Data structure for commands without payload
struct command_no_payload_t
{
    uint32_t cmd_code : 10;
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR command_no_payload_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR command_no_payload_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Data structure for commands with payload
struct command_with_payload_t
{
    uint32_t cmd_code : 10;
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t param : 16;
    uint32_t data : 32;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return must_be_zero == 0 && payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR command_with_payload_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR command_with_payload_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR command_with_payload_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR command_with_payload_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Move to stopped state once all commands to this point are done. Raise IRQ to the host and logically OR the mask into
// the status register upper 16 bits (see the status register)
struct npu_op_stop_t
{
    uint32_t cmd_code : 10;     // NPU_OP_STOP
    uint32_t must_be_zero0 : 6; // 0
    uint32_t mask : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_OP_STOP) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_OP_STOP);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_op_stop_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_mask() const
    {
        return static_cast<uint32_t>(mask);
    }
    CONSTEXPR npu_op_stop_t &set_mask(uint32_t value)
    {
        mask = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Raise IRQ to the host and logically OR the mask into the status register upper 16 bits (see the status register)
struct npu_op_irq_t
{
    uint32_t cmd_code : 10;     // NPU_OP_IRQ
    uint32_t must_be_zero0 : 6; // 0
    uint32_t mask : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_OP_IRQ) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_OP_IRQ);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_op_irq_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_mask() const
    {
        return static_cast<uint32_t>(mask);
    }
    CONSTEXPR npu_op_irq_t &set_mask(uint32_t value)
    {
        mask = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Start stripe with full convolution or deconvolution
struct npu_op_conv_t
{
    uint32_t cmd_code : 10;     // NPU_OP_CONV
    uint32_t must_be_zero0 : 6; // 0
    uint32_t reserved0 : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_OP_CONV) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_OP_CONV);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_op_conv_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Start stripe width depth-wise convolution or deconvolution operation
struct npu_op_depthwise_t
{
    uint32_t cmd_code : 10;     // NPU_OP_DEPTHWISE
    uint32_t must_be_zero0 : 6; // 0
    uint32_t reserved0 : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_OP_DEPTHWISE) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_OP_DEPTHWISE);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_op_depthwise_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Start stripe with pooling operation
struct npu_op_pool_t
{
    uint32_t cmd_code : 10;     // NPU_OP_POOL
    uint32_t must_be_zero0 : 6; // 0
    uint32_t mode : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_OP_POOL) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_OP_POOL);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_op_pool_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::pooling_mode get_mode() const
    {
        return static_cast<::pooling_mode>(mode);
    }
    CONSTEXPR npu_op_pool_t &set_mode(::pooling_mode value)
    {
        mode = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Start stripe with pointwise operation
struct npu_op_elementwise_t
{
    uint32_t cmd_code : 10;     // NPU_OP_ELEMENTWISE
    uint32_t must_be_zero0 : 6; // 0
    uint32_t mode : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_OP_ELEMENTWISE) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_OP_ELEMENTWISE);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_op_elementwise_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::elementwise_mode get_mode() const
    {
        return static_cast<::elementwise_mode>(mode);
    }
    CONSTEXPR npu_op_elementwise_t &set_mode(::elementwise_mode value)
    {
        mode = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Queue new DMA for the given channel with the given mode. Mode bit 0 specifies the source address type 0=external,
// 1=internal Mode bit 1 specifies the destination address type 0=external, 1=internal In Ethos-U55 there is only one
// user channel so channel=0. If the channel is fully in use then the command blocks until a new DMA can start
struct npu_op_dma_start_t
{
    uint32_t cmd_code : 10;     // NPU_OP_DMA_START
    uint32_t must_be_zero0 : 6; // 0
    uint32_t channel_mode : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_OP_DMA_START) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_OP_DMA_START);
        must_be_zero0 = 0;
    }
    CONSTEXPR uint32_t get_channel_mode() const
    {
        return static_cast<uint32_t>(channel_mode);
    }
    CONSTEXPR npu_op_dma_start_t &set_channel_mode(uint32_t value)
    {
        channel_mode = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_op_dma_start_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Wait for the DMA channel to have k or fewer active descriptors outstanding. In Ethos-U55 there is only one user
// channel so channel=0. In Ethos-U55 there is only one descriptor per channel so k=0 and the command waits for the
// single DMA to be complete.
struct npu_op_dma_wait_t
{
    uint32_t cmd_code : 10;     // NPU_OP_DMA_WAIT
    uint32_t must_be_zero0 : 6; // 0
    uint32_t reserved0 : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_OP_DMA_WAIT) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_OP_DMA_WAIT);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_op_dma_wait_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Wait for n or fewer kernel operations to be remaining (not complete) before starting the next command. A kernel
// operation is Conv, Depthwise, Pool, VectorProd Elementwise. This command is typically placed before an
// NPU_OP_DMA_START command to prevent the DMA from starting until a previous kernel operation reading the memory has
// completed.
struct npu_op_kernel_wait_t
{
    uint32_t cmd_code : 10;     // NPU_OP_KERNEL_WAIT
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_OP_KERNEL_WAIT) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_OP_KERNEL_WAIT);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_op_kernel_wait_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_op_kernel_wait_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Enable or disable PMU counting (debug feature only).
struct npu_op_pmu_mask_t
{
    uint32_t cmd_code : 10;     // NPU_OP_PMU_MASK
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_OP_PMU_MASK) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_OP_PMU_MASK);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_op_pmu_mask_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_op_pmu_mask_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// IFM top pad
struct npu_set_ifm_pad_top_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM_PAD_TOP
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM_PAD_TOP) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM_PAD_TOP);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_pad_top_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm_pad_top_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// IFM left pad
struct npu_set_ifm_pad_left_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM_PAD_LEFT
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM_PAD_LEFT) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM_PAD_LEFT);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_pad_left_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm_pad_left_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// IFM right pad
struct npu_set_ifm_pad_right_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM_PAD_RIGHT
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM_PAD_RIGHT) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM_PAD_RIGHT);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_pad_right_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm_pad_right_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// IFM bottom pad
struct npu_set_ifm_pad_bottom_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM_PAD_BOTTOM
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM_PAD_BOTTOM) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM_PAD_BOTTOM);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_pad_bottom_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm_pad_bottom_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Number of input channels - 1
struct npu_set_ifm_depth_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM_DEPTH_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM_DEPTH_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM_DEPTH_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_depth_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm_depth_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM precision
struct npu_set_ifm_precision_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM_PRECISION
    uint32_t must_be_zero0 : 6; // 0
    uint32_t precision : 4;
    uint32_t reserved0 : 2;
    uint32_t format : 2;
    uint32_t scale_mode : 2;
    uint32_t reserved1 : 4;
    uint32_t round_mode : 2;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM_PRECISION) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM_PRECISION);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_precision_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::data_format get_format() const
    {
        return static_cast<::data_format>(format);
    }
    CONSTEXPR npu_set_ifm_precision_t &set_format(::data_format value)
    {
        format = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::ifm_precision get_precision() const
    {
        return static_cast<::ifm_precision>(precision);
    }
    CONSTEXPR npu_set_ifm_precision_t &set_precision(::ifm_precision value)
    {
        precision = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::rounding get_round_mode() const
    {
        return static_cast<::rounding>(round_mode);
    }
    CONSTEXPR npu_set_ifm_precision_t &set_round_mode(::rounding value)
    {
        round_mode = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::ifm_scale_mode get_scale_mode() const
    {
        return static_cast<::ifm_scale_mode>(scale_mode);
    }
    CONSTEXPR npu_set_ifm_precision_t &set_scale_mode(::ifm_scale_mode value)
    {
        scale_mode = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// b[1:0] = upscale mode (0=none, 1=2x2 nearest, 2=2x2 transpose)
struct npu_set_ifm_upscale_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM_UPSCALE
    uint32_t must_be_zero0 : 6; // 0
    uint32_t mode : 2;
    uint32_t reserved0 : 14;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM_UPSCALE) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM_UPSCALE);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_upscale_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::resampling_mode get_mode() const
    {
        return static_cast<::resampling_mode>(mode);
    }
    CONSTEXPR npu_set_ifm_upscale_t &set_mode(::resampling_mode value)
    {
        mode = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Zero point offset (so value that 0 is encoded as)
struct npu_set_ifm_zero_point_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM_ZERO_POINT
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM_ZERO_POINT) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM_ZERO_POINT);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_zero_point_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm_zero_point_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// IFM Tile 0 and tile 2 (width-1)
struct npu_set_ifm_width0_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM_WIDTH0_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM_WIDTH0_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM_WIDTH0_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_width0_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm_width0_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// IFM Tile 0 (height-1)
struct npu_set_ifm_height0_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM_HEIGHT0_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM_HEIGHT0_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM_HEIGHT0_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_height0_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm_height0_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// IFM Tile 1 (height-1)
struct npu_set_ifm_height1_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM_HEIGHT1_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM_HEIGHT1_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM_HEIGHT1_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_height1_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm_height1_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// End of IB0,IB1 buffers in the SHRAM in KB units. Multiple of 2.
struct npu_set_ifm_ib_end_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM_IB_END
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM_IB_END) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM_IB_END);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_ib_end_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm_ib_end_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Index n for IFM access: BasePointer[n] is added to all IFM offsets
struct npu_set_ifm_region_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM_REGION
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM_REGION) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM_REGION);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_region_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm_region_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Output feature map width -1 (for the stripe to process)
struct npu_set_ofm_width_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_OFM_WIDTH_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_OFM_WIDTH_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_OFM_WIDTH_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_width_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ofm_width_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Output feature map height -1 (for the stripe to process)
struct npu_set_ofm_height_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_OFM_HEIGHT_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_OFM_HEIGHT_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_OFM_HEIGHT_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_height_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ofm_height_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Output feature map depth -1 (for the stripe to process)
struct npu_set_ofm_depth_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_OFM_DEPTH_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_OFM_DEPTH_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_OFM_DEPTH_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_depth_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ofm_depth_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set OFM precision
struct npu_set_ofm_precision_t
{
    uint32_t cmd_code : 10;     // NPU_SET_OFM_PRECISION
    uint32_t must_be_zero0 : 6; // 0
    uint32_t precision : 3;
    uint32_t reserved0 : 3;
    uint32_t format : 2;
    uint32_t scaling : 1; // 0=Per channel scale/bias 1=Global scale (SET_OFM_SCALE), no bias
    uint32_t reserved1 : 5;
    uint32_t rounding : 2; // 0=TFL rounding 1=truncate towards zero 2=natural rounding
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_OFM_PRECISION) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_OFM_PRECISION);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_precision_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::data_format get_format() const
    {
        return static_cast<::data_format>(format);
    }
    CONSTEXPR npu_set_ofm_precision_t &set_format(::data_format value)
    {
        format = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::ofm_precision get_precision() const
    {
        return static_cast<::ofm_precision>(precision);
    }
    CONSTEXPR npu_set_ofm_precision_t &set_precision(::ofm_precision value)
    {
        precision = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::rounding get_rounding() const
    {
        return static_cast<::rounding>(rounding);
    }
    CONSTEXPR npu_set_ofm_precision_t &set_rounding(::rounding value)
    {
        rounding = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_scaling() const
    {
        return static_cast<uint32_t>(scaling);
    }
    CONSTEXPR npu_set_ofm_precision_t &set_scaling(uint32_t value)
    {
        scaling = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// TSU block width - 1 (provided sufficient data remaining)
struct npu_set_ofm_blk_width_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_OFM_BLK_WIDTH_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_OFM_BLK_WIDTH_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_OFM_BLK_WIDTH_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_blk_width_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ofm_blk_width_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// TSU block height -1 (provided sufficient data remaining)
struct npu_set_ofm_blk_height_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_OFM_BLK_HEIGHT_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_OFM_BLK_HEIGHT_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_OFM_BLK_HEIGHT_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_blk_height_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ofm_blk_height_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// TSU block depth -1 (provided sufficient data remaining)
struct npu_set_ofm_blk_depth_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_OFM_BLK_DEPTH_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_OFM_BLK_DEPTH_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_OFM_BLK_DEPTH_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_blk_depth_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ofm_blk_depth_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Zero point offset (so value that 0 is encoded as)
struct npu_set_ofm_zero_point_t
{
    uint32_t cmd_code : 10;     // NPU_SET_OFM_ZERO_POINT
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_OFM_ZERO_POINT) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_OFM_ZERO_POINT);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_zero_point_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ofm_zero_point_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// OFM Tile 0 and tile 2 (width-1)
struct npu_set_ofm_width0_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_OFM_WIDTH0_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_OFM_WIDTH0_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_OFM_WIDTH0_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_width0_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ofm_width0_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// OFM Tile 0 (height-1)
struct npu_set_ofm_height0_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_OFM_HEIGHT0_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_OFM_HEIGHT0_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_OFM_HEIGHT0_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_height0_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ofm_height0_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// OFM Tile 1 (height-1)
struct npu_set_ofm_height1_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_OFM_HEIGHT1_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_OFM_HEIGHT1_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_OFM_HEIGHT1_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_height1_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ofm_height1_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Index n for OFM access: BasePointer[n] is added to all OFM offsets
struct npu_set_ofm_region_t
{
    uint32_t cmd_code : 10;     // NPU_SET_OFM_REGION
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_OFM_REGION) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_OFM_REGION);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_region_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ofm_region_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set kernel width - 1
struct npu_set_kernel_width_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_KERNEL_WIDTH_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_KERNEL_WIDTH_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_KERNEL_WIDTH_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_kernel_width_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_kernel_width_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set kernel height - 1
struct npu_set_kernel_height_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_KERNEL_HEIGHT_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_KERNEL_HEIGHT_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_KERNEL_HEIGHT_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_kernel_height_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_kernel_height_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Kernel stride b0=(X stride-1)&1, b1=(Y stride-1)&1, b2=weight order (0=depth, 1=kernel) b3 = kernel_x_dilation - 1
// (0=no x dilation, 1=x dilation of x2) b4 = kernel_y_dilation -1 (0=no y dilation, 1=y dilation of x2) b5 = kernel
// decomposition size (0 for kernel_split_size=8, 1 for kernel_split_size=4) b[8:6] = (X stride-1)>>1 b[11:9] = (Y
// stride-1)>>1
struct npu_set_kernel_stride_t
{
    uint32_t cmd_code : 10;     // NPU_SET_KERNEL_STRIDE
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_KERNEL_STRIDE) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_KERNEL_STRIDE);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_kernel_stride_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_kernel_stride_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// 0=1-core, 1=2-core depth (this command is Ethos-U65 only and UNPREDICTABLE for Ethos-U55)
struct npu_set_parallel_mode_t
{
    uint32_t cmd_code : 10;     // NPU_SET_PARALLEL_MODE
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_PARALLEL_MODE) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_PARALLEL_MODE);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_parallel_mode_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_parallel_mode_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set accumulator format
struct npu_set_acc_format_t
{
    uint32_t cmd_code : 10;     // NPU_SET_ACC_FORMAT
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_ACC_FORMAT) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_ACC_FORMAT);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_acc_format_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::acc_format get_param() const
    {
        return static_cast<::acc_format>(param);
    }
    CONSTEXPR npu_set_acc_format_t &set_param(::acc_format value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set activation
struct npu_set_activation_t
{
    uint32_t cmd_code : 10;     // NPU_SET_ACTIVATION
    uint32_t must_be_zero0 : 6; // 0
    uint32_t type : 12;
    uint32_t act_clip_range : 4;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_ACTIVATION) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_ACTIVATION);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::clip_range get_act_clip_range() const
    {
        return static_cast<::clip_range>(act_clip_range);
    }
    CONSTEXPR npu_set_activation_t &set_act_clip_range(::clip_range value)
    {
        act_clip_range = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_activation_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::activation get_type() const
    {
        return static_cast<::activation>(type);
    }
    CONSTEXPR npu_set_activation_t &set_type(::activation value)
    {
        type = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Lower bound clip for OFM activations – range is the OFM type range
struct npu_set_activation_min_t
{
    uint32_t cmd_code : 10;     // NPU_SET_ACTIVATION_MIN
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_ACTIVATION_MIN) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_ACTIVATION_MIN);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_activation_min_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_activation_min_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Upper bound clip for OFM activations – range is the OFM type range
struct npu_set_activation_max_t
{
    uint32_t cmd_code : 10;     // NPU_SET_ACTIVATION_MAX
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_ACTIVATION_MAX) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_ACTIVATION_MAX);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_activation_max_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_activation_max_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Index n for weight access: BasePointer[n] is added to all Weight stream offsets
struct npu_set_weight_region_t
{
    uint32_t cmd_code : 10;     // NPU_SET_WEIGHT_REGION
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_WEIGHT_REGION) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_WEIGHT_REGION);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_weight_region_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_weight_region_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Index n for weight access: BasePointer[n] is added to all scale stream offsets
struct npu_set_scale_region_t
{
    uint32_t cmd_code : 10;     // NPU_SET_SCALE_REGION
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_SCALE_REGION) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_SCALE_REGION);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_scale_region_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_scale_region_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Start of ACC0,ACC1 buffers in the SHRAM in KB units. Multiple of 4.)
struct npu_set_ab_start_t
{
    uint32_t cmd_code : 10;     // NPU_SET_AB_START
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_AB_START) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_AB_START);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ab_start_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ab_start_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set block number of blocks dependency between kernel operations
struct npu_set_blockdep_t
{
    uint32_t cmd_code : 10;     // NPU_SET_BLOCKDEP
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_BLOCKDEP) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_BLOCKDEP);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_blockdep_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_blockdep_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// DMA0 SRC region bitmap
struct npu_set_dma0_src_region_t
{
    uint32_t cmd_code : 10;     // NPU_SET_DMA0_SRC_REGION
    uint32_t must_be_zero0 : 6; // 0
    uint32_t region : 8;        // If Bit[8]=0, Bit[7:0]=Region number in the range [0, 8) of SRC offset. If Bit[8]=1,
                                // Bit[7:0]=Core number (0 or 1) to read.
    uint32_t internal : 1;      // Must be 0 (external)
    uint32_t stride_mode : 2;   // stride mode 0/1/2=1D/2D/3D
    uint32_t reserved0 : 5;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_DMA0_SRC_REGION) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_DMA0_SRC_REGION);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_dma0_src_region_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_internal() const
    {
        return static_cast<uint32_t>(internal);
    }
    CONSTEXPR npu_set_dma0_src_region_t &set_internal(uint32_t value)
    {
        internal = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_region() const
    {
        return static_cast<uint32_t>(region);
    }
    CONSTEXPR npu_set_dma0_src_region_t &set_region(uint32_t value)
    {
        region = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::stride_mode get_stride_mode() const
    {
        return static_cast<::stride_mode>(stride_mode);
    }
    CONSTEXPR npu_set_dma0_src_region_t &set_stride_mode(::stride_mode value)
    {
        stride_mode = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// DMA0 DST region bitmap
struct npu_set_dma0_dst_region_t
{
    uint32_t cmd_code : 10;     // NPU_SET_DMA0_DST_REGION
    uint32_t must_be_zero0 : 6; // 0
    uint32_t region : 8;        // If Bit[8]=0, Bit[7:0]=Region number in the range [0, 8) of DST offset. If Bit[8]=1,
                                // Bit[7:0]=Core mask to write to (bit k set for core k=0,1).
    uint32_t internal : 1;      // Select external/internal=0/1
    uint32_t stride_mode : 2;   // stride mode 0/1/2=1D/2D/3D
    uint32_t reserved0 : 5;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_DMA0_DST_REGION) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_DMA0_DST_REGION);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_dma0_dst_region_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_internal() const
    {
        return static_cast<uint32_t>(internal);
    }
    CONSTEXPR npu_set_dma0_dst_region_t &set_internal(uint32_t value)
    {
        internal = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_region() const
    {
        return static_cast<uint32_t>(region);
    }
    CONSTEXPR npu_set_dma0_dst_region_t &set_region(uint32_t value)
    {
        region = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::stride_mode get_stride_mode() const
    {
        return static_cast<::stride_mode>(stride_mode);
    }
    CONSTEXPR npu_set_dma0_dst_region_t &set_stride_mode(::stride_mode value)
    {
        stride_mode = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Inner size for 2D/3D mode.
struct npu_set_dma0_size0_t
{
    uint32_t cmd_code : 10;     // NPU_SET_DMA0_SIZE0
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_DMA0_SIZE0) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_DMA0_SIZE0);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_dma0_size0_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_dma0_size0_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Outer size for 3D mode.
struct npu_set_dma0_size1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_DMA0_SIZE1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_DMA0_SIZE1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_DMA0_SIZE1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_dma0_size1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_dma0_size1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM2 Broadcast mode
struct npu_set_ifm2_broadcast_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM2_BROADCAST
    uint32_t must_be_zero0 : 6; // 0
    uint32_t broadcast_height : 1;
    uint32_t broadcast_width : 1;
    uint32_t broadcast_depth : 1;
    uint32_t reserved0 : 3;
    uint32_t operand_order : 1;
    uint32_t broadcast_scalar : 1;
    uint32_t reserved1 : 8;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM2_BROADCAST) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM2_BROADCAST);
        must_be_zero0 = 0;
    }
    CONSTEXPR uint32_t get_broadcast_depth() const
    {
        return static_cast<uint32_t>(broadcast_depth);
    }
    CONSTEXPR npu_set_ifm2_broadcast_t &set_broadcast_depth(uint32_t value)
    {
        broadcast_depth = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_broadcast_height() const
    {
        return static_cast<uint32_t>(broadcast_height);
    }
    CONSTEXPR npu_set_ifm2_broadcast_t &set_broadcast_height(uint32_t value)
    {
        broadcast_height = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_broadcast_scalar() const
    {
        return static_cast<uint32_t>(broadcast_scalar);
    }
    CONSTEXPR npu_set_ifm2_broadcast_t &set_broadcast_scalar(uint32_t value)
    {
        broadcast_scalar = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_broadcast_width() const
    {
        return static_cast<uint32_t>(broadcast_width);
    }
    CONSTEXPR npu_set_ifm2_broadcast_t &set_broadcast_width(uint32_t value)
    {
        broadcast_width = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_broadcast_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_operand_order() const
    {
        return static_cast<uint32_t>(operand_order);
    }
    CONSTEXPR npu_set_ifm2_broadcast_t &set_operand_order(uint32_t value)
    {
        operand_order = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// IFM2 scalar value at range IFM_PRECISION
struct npu_set_ifm2_scalar_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM2_SCALAR
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM2_SCALAR) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM2_SCALAR);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_scalar_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm2_scalar_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set activation
struct npu_set_ifm2_precision_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM2_PRECISION
    uint32_t must_be_zero0 : 6; // 0
    uint32_t precision : 4;
    uint32_t reserved0 : 2;
    uint32_t format : 2;
    uint32_t reserved1 : 8;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM2_PRECISION) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM2_PRECISION);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_precision_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::data_format get_format() const
    {
        return static_cast<::data_format>(format);
    }
    CONSTEXPR npu_set_ifm2_precision_t &set_format(::data_format value)
    {
        format = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR ::ifm_precision get_precision() const
    {
        return static_cast<::ifm_precision>(precision);
    }
    CONSTEXPR npu_set_ifm2_precision_t &set_precision(::ifm_precision value)
    {
        precision = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Zero point offset (so value that 0 is encoded as) at range IFM_PRECISION
struct npu_set_ifm2_zero_point_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM2_ZERO_POINT
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM2_ZERO_POINT) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM2_ZERO_POINT);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_zero_point_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm2_zero_point_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// IFM2 Tile 0 and tile 2 (width-1)
struct npu_set_ifm2_width0_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM2_WIDTH0_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM2_WIDTH0_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM2_WIDTH0_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_width0_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm2_width0_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// IFM2 Tile 0 (height-1)
struct npu_set_ifm2_height0_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM2_HEIGHT0_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM2_HEIGHT0_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM2_HEIGHT0_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_height0_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm2_height0_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// IFM2 Tile 1 (height-1)
struct npu_set_ifm2_height1_m1_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM2_HEIGHT1_M1
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM2_HEIGHT1_M1) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM2_HEIGHT1_M1);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_height1_m1_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm2_height1_m1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Start of IB0, IB1 buffers for IFM2 in SHRAM. In KB units, multiple of 2.
struct npu_set_ifm2_ib_start_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM2_IB_START
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM2_IB_START) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM2_IB_START);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_ib_start_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm2_ib_start_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Index n for IFM2 access: Region[n] is added to all IFM2 addresses
struct npu_set_ifm2_region_t
{
    uint32_t cmd_code : 10;     // NPU_SET_IFM2_REGION
    uint32_t must_be_zero0 : 6; // 0
    uint32_t param : 16;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd0::NPU_SET_IFM2_REGION) && must_be_zero0 == 0;
    }
    CONSTEXPR void init()
    {
        cmd_code      = static_cast<uint32_t>(cmd0::NPU_SET_IFM2_REGION);
        must_be_zero0 = 0;
    }
    CONSTEXPR ::cmd0 get_cmd_code() const
    {
        return static_cast<::cmd0>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_region_t &set_cmd_code(::cmd0 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_ifm2_region_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM base address (top left tile)
struct npu_set_ifm_base0_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM_BASE0
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM base address (top left tile)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM_BASE0) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM_BASE0);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_base0_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm_base0_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm_base0_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM base address (top right tile)
struct npu_set_ifm_base1_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM_BASE1
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM base address (top right tile)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM_BASE1) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM_BASE1);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_base1_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm_base1_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm_base1_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM base address (bottom left tile)
struct npu_set_ifm_base2_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM_BASE2
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM base address (bottom left tile)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM_BASE2) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM_BASE2);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_base2_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm_base2_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm_base2_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM base address (bottom right tile)
struct npu_set_ifm_base3_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM_BASE3
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM base address (bottom right tile)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM_BASE3) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM_BASE3);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_base3_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm_base3_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm_base3_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM byte stride between horizontal values
struct npu_set_ifm_stride_x_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM_STRIDE_X
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM byte stride between horizontal values
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM_STRIDE_X) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM_STRIDE_X);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_stride_x_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm_stride_x_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm_stride_x_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM byte stride between vertical values
struct npu_set_ifm_stride_y_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM_STRIDE_Y
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM byte stride between vertical values
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM_STRIDE_Y) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM_STRIDE_Y);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_stride_y_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm_stride_y_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm_stride_y_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM byte stride between channel blocks (of 16 bytes each block)
struct npu_set_ifm_stride_c_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM_STRIDE_C
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM byte stride between channel blocks (of 16 bytes each block)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM_STRIDE_C) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM_STRIDE_C);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm_stride_c_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm_stride_c_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm_stride_c_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set OFM base address (top left tile)
struct npu_set_ofm_base0_t
{
    uint32_t cmd_code : 10;    // NPU_SET_OFM_BASE0
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // OFM base address (top left tile)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_OFM_BASE0) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_OFM_BASE0);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_base0_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ofm_base0_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ofm_base0_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set OFM base address (top right tile)
struct npu_set_ofm_base1_t
{
    uint32_t cmd_code : 10;    // NPU_SET_OFM_BASE1
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // OFM base address (top right tile)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_OFM_BASE1) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_OFM_BASE1);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_base1_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ofm_base1_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ofm_base1_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set OFM base address (bottom left tile)
struct npu_set_ofm_base2_t
{
    uint32_t cmd_code : 10;    // NPU_SET_OFM_BASE2
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // OFM base address (bottom left tile)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_OFM_BASE2) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_OFM_BASE2);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_base2_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ofm_base2_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ofm_base2_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set OFM base address (bottom right tile)
struct npu_set_ofm_base3_t
{
    uint32_t cmd_code : 10;    // NPU_SET_OFM_BASE3
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // OFM base address (bottom right tile)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_OFM_BASE3) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_OFM_BASE3);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_base3_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ofm_base3_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ofm_base3_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set OFM byte stride between horizontal values
struct npu_set_ofm_stride_x_t
{
    uint32_t cmd_code : 10;    // NPU_SET_OFM_STRIDE_X
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // OFM byte stride between horizontal values
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_OFM_STRIDE_X) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_OFM_STRIDE_X);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_stride_x_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ofm_stride_x_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ofm_stride_x_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set OFM byte stride between vertical values
struct npu_set_ofm_stride_y_t
{
    uint32_t cmd_code : 10;    // NPU_SET_OFM_STRIDE_Y
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // OFM byte stride between vertical values
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_OFM_STRIDE_Y) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_OFM_STRIDE_Y);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_stride_y_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ofm_stride_y_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ofm_stride_y_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set OFM byte stride between channel blocks (of 16 bytes each block)
struct npu_set_ofm_stride_c_t
{
    uint32_t cmd_code : 10;    // NPU_SET_OFM_STRIDE_C
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // OFM byte stride between channel blocks (of 16 bytes each block)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_OFM_STRIDE_C) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_OFM_STRIDE_C);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_stride_c_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ofm_stride_c_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ofm_stride_c_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set Weight stream input base address
struct npu_set_weight_base_t
{
    uint32_t cmd_code : 10;    // NPU_SET_WEIGHT_BASE
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // Weight stream input base address
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_WEIGHT_BASE) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_WEIGHT_BASE);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_weight_base_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_weight_base_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_weight_base_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set Weight stream length
struct npu_set_weight_length_t
{
    uint32_t cmd_code : 10;    // NPU_SET_WEIGHT_LENGTH
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // Weight stream length
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_WEIGHT_LENGTH) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_WEIGHT_LENGTH);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_weight_length_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_weight_length_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_weight_length_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set Scale and bias stream input base address
struct npu_set_scale_base_t
{
    uint32_t cmd_code : 10;    // NPU_SET_SCALE_BASE
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // Scale and bias stream input base address
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_SCALE_BASE) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_SCALE_BASE);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_scale_base_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_scale_base_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_scale_base_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set Scale and bias stream input length
struct npu_set_scale_length_t
{
    uint32_t cmd_code : 10;    // NPU_SET_SCALE_LENGTH
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // Scale and bias stream input length
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_SCALE_LENGTH) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_SCALE_LENGTH);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_scale_length_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_scale_length_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_scale_length_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set scale (32-bit). Used by average pool with pad=0, elementwise MUL, ADD, SUB
struct npu_set_ofm_scale_t
{
    uint32_t cmd_code : 10;    // NPU_SET_OFM_SCALE
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t shift : 16;
    uint32_t data : 32; // scale (32-bit). Used by average pool with pad=0, elementwise MUL, ADD, SUB
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_OFM_SCALE) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_OFM_SCALE);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ofm_scale_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ofm_scale_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ofm_scale_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_shift() const
    {
        return static_cast<uint32_t>(shift);
    }
    CONSTEXPR npu_set_ofm_scale_t &set_shift(uint32_t value)
    {
        shift = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set scale (32-bit) used for elementwise ADD/SUB OPA prescale. If IFM scale mode is 0 then shift is ignored and scale
// is 16-bit. If IFM scale mode is 1 or 2 then shift is 6-bit and scale is 32-bit
struct npu_set_opa_scale_t
{
    uint32_t cmd_code : 10;    // NPU_SET_OPA_SCALE
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t shift : 16;
    uint32_t
        data : 32; // scale (32-bit) used for elementwise ADD/SUB OPA prescale. If IFM scale mode is 0 then shift is
                   // ignored and scale is 16-bit. If IFM scale mode is 1 or 2 then shift is 6-bit and scale is 32-bit
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_OPA_SCALE) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_OPA_SCALE);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_opa_scale_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_opa_scale_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_opa_scale_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_shift() const
    {
        return static_cast<uint32_t>(shift);
    }
    CONSTEXPR npu_set_opa_scale_t &set_shift(uint32_t value)
    {
        shift = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set scale (16-bit) used for elementwise ADD/SUB OPB prescale. If IFM scale mode is 0 then scale is 16-bit. If IFM
// scale mode is 1 or 2 then this register is not used
struct npu_set_opb_scale_t
{
    uint32_t cmd_code : 10;    // NPU_SET_OPB_SCALE
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // scale (16-bit) used for elementwise ADD/SUB OPB prescale. If IFM scale mode is 0 then scale
                        // is 16-bit. If IFM scale mode is 1 or 2 then this register is not used
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_OPB_SCALE) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_OPB_SCALE);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_opb_scale_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_opb_scale_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_opb_scale_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set DMA source address
struct npu_set_dma0_src_t
{
    uint32_t cmd_code : 10;    // NPU_SET_DMA0_SRC
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_DMA0_SRC) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_DMA0_SRC);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_dma0_src_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_dma0_src_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_dma0_src_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set DMA destination address
struct npu_set_dma0_dst_t
{
    uint32_t cmd_code : 10;    // NPU_SET_DMA0_DST
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32;
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_DMA0_DST) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_DMA0_DST);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_dma0_dst_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_dma0_dst_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_dma0_dst_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set DMA length
struct npu_set_dma0_len_t
{
    uint32_t cmd_code : 10;    // NPU_SET_DMA0_LEN
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // DMA length
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_DMA0_LEN) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_DMA0_LEN);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_dma0_len_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_dma0_len_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_dma0_len_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set Byte distance to skip after inner size (2D/3D mode)
struct npu_set_dma0_skip0_t
{
    uint32_t cmd_code : 10;    // NPU_SET_DMA0_SKIP0
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t param : 16;
    uint32_t data : 32; // Byte distance to skip after inner size (2D/3D mode)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_DMA0_SKIP0) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_DMA0_SKIP0);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_dma0_skip0_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_dma0_skip0_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_dma0_skip0_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_dma0_skip0_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set Byte distance to skip after outer size (3D mode)
struct npu_set_dma0_skip1_t
{
    uint32_t cmd_code : 10;    // NPU_SET_DMA0_SKIP1
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t param : 16;
    uint32_t data : 32; // Byte distance to skip after outer size (3D mode)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_DMA0_SKIP1) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_DMA0_SKIP1);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_dma0_skip1_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_dma0_skip1_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_dma0_skip1_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_dma0_skip1_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM2 tile0 offset (top left tile) from IFM_REGION start
struct npu_set_ifm2_base0_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM2_BASE0
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM2 tile0 offset (top left tile) from IFM_REGION start
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM2_BASE0) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM2_BASE0);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_base0_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm2_base0_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm2_base0_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM2 tile1 offset (top right tile) from IFM_REGION start
struct npu_set_ifm2_base1_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM2_BASE1
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM2 tile1 offset (top right tile) from IFM_REGION start
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM2_BASE1) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM2_BASE1);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_base1_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm2_base1_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm2_base1_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM2 tile2 offset (bottom left tile) from IFM_REGION start
struct npu_set_ifm2_base2_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM2_BASE2
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM2 tile2 offset (bottom left tile) from IFM_REGION start
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM2_BASE2) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM2_BASE2);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_base2_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm2_base2_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm2_base2_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM2 tile3 offset (bottom right tile) from IFM_REGION start
struct npu_set_ifm2_base3_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM2_BASE3
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM2 tile3 offset (bottom right tile) from IFM_REGION start
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM2_BASE3) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM2_BASE3);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_base3_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm2_base3_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm2_base3_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM2 byte stride between horizontal values
struct npu_set_ifm2_stride_x_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM2_STRIDE_X
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM2 byte stride between horizontal values
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM2_STRIDE_X) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM2_STRIDE_X);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_stride_x_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm2_stride_x_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm2_stride_x_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM2 byte stride between vertical values
struct npu_set_ifm2_stride_y_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM2_STRIDE_Y
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM2 byte stride between vertical values
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM2_STRIDE_Y) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM2_STRIDE_Y);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_stride_y_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm2_stride_y_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm2_stride_y_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set IFM2 byte stride between channel blocks (of 16 bytes each block)
struct npu_set_ifm2_stride_c_t
{
    uint32_t cmd_code : 10;    // NPU_SET_IFM2_STRIDE_C
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // IFM2 byte stride between channel blocks (of 16 bytes each block)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_IFM2_STRIDE_C) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_IFM2_STRIDE_C);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_ifm2_stride_c_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_ifm2_stride_c_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_ifm2_stride_c_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set Weight stream byte offset in WEIGHT_REGION
struct npu_set_weight1_base_t
{
    uint32_t cmd_code : 10;    // NPU_SET_WEIGHT1_BASE
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t param : 16;
    uint32_t data : 32; // Weight stream byte offset in WEIGHT_REGION
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_WEIGHT1_BASE) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_WEIGHT1_BASE);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_weight1_base_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_weight1_base_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_weight1_base_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_weight1_base_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set Weight stream byte length (unsigned 32 bits)
struct npu_set_weight1_length_t
{
    uint32_t cmd_code : 10;    // NPU_SET_WEIGHT1_LENGTH
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // Weight stream byte length (unsigned 32 bits)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_WEIGHT1_LENGTH) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_WEIGHT1_LENGTH);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_weight1_length_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_weight1_length_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_weight1_length_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set Scale and bias stream input byte offset from SCALE_REGION
struct npu_set_scale1_base_t
{
    uint32_t cmd_code : 10;    // NPU_SET_SCALE1_BASE
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t param : 16;
    uint32_t data : 32; // Scale and bias stream input byte offset from SCALE_REGION
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_SCALE1_BASE) && must_be_zero == 0 && payload_size >= 1 &&
               payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_SCALE1_BASE);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_scale1_base_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_scale1_base_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_param() const
    {
        return static_cast<uint32_t>(param);
    }
    CONSTEXPR npu_set_scale1_base_t &set_param(uint32_t value)
    {
        param = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_scale1_base_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

// Set Scale and bias stream input byte length (unsigned 20 bits)
struct npu_set_scale1_length_t
{
    uint32_t cmd_code : 10;    // NPU_SET_SCALE1_LENGTH
    uint32_t must_be_zero : 4; // 0
    uint32_t payload_size : 2; // Min:1 Max:2
    uint32_t reserved0 : 16;
    uint32_t data : 32; // Scale and bias stream input byte length (unsigned 20 bits)
#ifdef __cplusplus
    CONSTEXPR bool valid() const
    {
        return cmd_code == static_cast<uint32_t>(cmd1::NPU_SET_SCALE1_LENGTH) && must_be_zero == 0 &&
               payload_size >= 1 && payload_size <= 2;
    }
    CONSTEXPR void init()
    {
        cmd_code     = static_cast<uint32_t>(cmd1::NPU_SET_SCALE1_LENGTH);
        must_be_zero = 0;
        payload_size = 1;
    }
    CONSTEXPR ::cmd1 get_cmd_code() const
    {
        return static_cast<::cmd1>(cmd_code);
    }
    CONSTEXPR npu_set_scale1_length_t &set_cmd_code(::cmd1 value)
    {
        cmd_code = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_data() const
    {
        return static_cast<uint32_t>(data);
    }
    CONSTEXPR npu_set_scale1_length_t &set_data(uint32_t value)
    {
        data = static_cast<uint32_t>(value);
        return *this;
    }
    CONSTEXPR uint32_t get_payload_size() const
    {
        return static_cast<uint32_t>(payload_size);
    }
    CONSTEXPR npu_set_scale1_length_t &set_payload_size(uint32_t value)
    {
        payload_size = static_cast<uint32_t>(value);
        return *this;
    }
#endif //__cplusplus
};

#define NPU_DATA_STRUCTS                                                                                               \
    NPU_STRUCT(command_no_payload)                                                                                     \
    NPU_STRUCT(command_with_payload)                                                                                   \
    NPU_STRUCT(npu_op_stop)                                                                                            \
    NPU_STRUCT(npu_op_irq)                                                                                             \
    NPU_STRUCT(npu_op_conv)                                                                                            \
    NPU_STRUCT(npu_op_depthwise)                                                                                       \
    NPU_STRUCT(npu_op_pool)                                                                                            \
    NPU_STRUCT(npu_op_elementwise)                                                                                     \
    NPU_STRUCT(npu_op_dma_start)                                                                                       \
    NPU_STRUCT(npu_op_dma_wait)                                                                                        \
    NPU_STRUCT(npu_op_kernel_wait)                                                                                     \
    NPU_STRUCT(npu_op_pmu_mask)                                                                                        \
    NPU_STRUCT(npu_set_ifm_pad_top)                                                                                    \
    NPU_STRUCT(npu_set_ifm_pad_left)                                                                                   \
    NPU_STRUCT(npu_set_ifm_pad_right)                                                                                  \
    NPU_STRUCT(npu_set_ifm_pad_bottom)                                                                                 \
    NPU_STRUCT(npu_set_ifm_depth_m1)                                                                                   \
    NPU_STRUCT(npu_set_ifm_precision)                                                                                  \
    NPU_STRUCT(npu_set_ifm_upscale)                                                                                    \
    NPU_STRUCT(npu_set_ifm_zero_point)                                                                                 \
    NPU_STRUCT(npu_set_ifm_width0_m1)                                                                                  \
    NPU_STRUCT(npu_set_ifm_height0_m1)                                                                                 \
    NPU_STRUCT(npu_set_ifm_height1_m1)                                                                                 \
    NPU_STRUCT(npu_set_ifm_ib_end)                                                                                     \
    NPU_STRUCT(npu_set_ifm_region)                                                                                     \
    NPU_STRUCT(npu_set_ofm_width_m1)                                                                                   \
    NPU_STRUCT(npu_set_ofm_height_m1)                                                                                  \
    NPU_STRUCT(npu_set_ofm_depth_m1)                                                                                   \
    NPU_STRUCT(npu_set_ofm_precision)                                                                                  \
    NPU_STRUCT(npu_set_ofm_blk_width_m1)                                                                               \
    NPU_STRUCT(npu_set_ofm_blk_height_m1)                                                                              \
    NPU_STRUCT(npu_set_ofm_blk_depth_m1)                                                                               \
    NPU_STRUCT(npu_set_ofm_zero_point)                                                                                 \
    NPU_STRUCT(npu_set_ofm_width0_m1)                                                                                  \
    NPU_STRUCT(npu_set_ofm_height0_m1)                                                                                 \
    NPU_STRUCT(npu_set_ofm_height1_m1)                                                                                 \
    NPU_STRUCT(npu_set_ofm_region)                                                                                     \
    NPU_STRUCT(npu_set_kernel_width_m1)                                                                                \
    NPU_STRUCT(npu_set_kernel_height_m1)                                                                               \
    NPU_STRUCT(npu_set_kernel_stride)                                                                                  \
    NPU_STRUCT(npu_set_parallel_mode)                                                                                  \
    NPU_STRUCT(npu_set_acc_format)                                                                                     \
    NPU_STRUCT(npu_set_activation)                                                                                     \
    NPU_STRUCT(npu_set_activation_min)                                                                                 \
    NPU_STRUCT(npu_set_activation_max)                                                                                 \
    NPU_STRUCT(npu_set_weight_region)                                                                                  \
    NPU_STRUCT(npu_set_scale_region)                                                                                   \
    NPU_STRUCT(npu_set_ab_start)                                                                                       \
    NPU_STRUCT(npu_set_blockdep)                                                                                       \
    NPU_STRUCT(npu_set_dma0_src_region)                                                                                \
    NPU_STRUCT(npu_set_dma0_dst_region)                                                                                \
    NPU_STRUCT(npu_set_dma0_size0)                                                                                     \
    NPU_STRUCT(npu_set_dma0_size1)                                                                                     \
    NPU_STRUCT(npu_set_ifm2_broadcast)                                                                                 \
    NPU_STRUCT(npu_set_ifm2_scalar)                                                                                    \
    NPU_STRUCT(npu_set_ifm2_precision)                                                                                 \
    NPU_STRUCT(npu_set_ifm2_zero_point)                                                                                \
    NPU_STRUCT(npu_set_ifm2_width0_m1)                                                                                 \
    NPU_STRUCT(npu_set_ifm2_height0_m1)                                                                                \
    NPU_STRUCT(npu_set_ifm2_height1_m1)                                                                                \
    NPU_STRUCT(npu_set_ifm2_ib_start)                                                                                  \
    NPU_STRUCT(npu_set_ifm2_region)                                                                                    \
    NPU_STRUCT(npu_set_ifm_base0)                                                                                      \
    NPU_STRUCT(npu_set_ifm_base1)                                                                                      \
    NPU_STRUCT(npu_set_ifm_base2)                                                                                      \
    NPU_STRUCT(npu_set_ifm_base3)                                                                                      \
    NPU_STRUCT(npu_set_ifm_stride_x)                                                                                   \
    NPU_STRUCT(npu_set_ifm_stride_y)                                                                                   \
    NPU_STRUCT(npu_set_ifm_stride_c)                                                                                   \
    NPU_STRUCT(npu_set_ofm_base0)                                                                                      \
    NPU_STRUCT(npu_set_ofm_base1)                                                                                      \
    NPU_STRUCT(npu_set_ofm_base2)                                                                                      \
    NPU_STRUCT(npu_set_ofm_base3)                                                                                      \
    NPU_STRUCT(npu_set_ofm_stride_x)                                                                                   \
    NPU_STRUCT(npu_set_ofm_stride_y)                                                                                   \
    NPU_STRUCT(npu_set_ofm_stride_c)                                                                                   \
    NPU_STRUCT(npu_set_weight_base)                                                                                    \
    NPU_STRUCT(npu_set_weight_length)                                                                                  \
    NPU_STRUCT(npu_set_scale_base)                                                                                     \
    NPU_STRUCT(npu_set_scale_length)                                                                                   \
    NPU_STRUCT(npu_set_ofm_scale)                                                                                      \
    NPU_STRUCT(npu_set_opa_scale)                                                                                      \
    NPU_STRUCT(npu_set_opb_scale)                                                                                      \
    NPU_STRUCT(npu_set_dma0_src)                                                                                       \
    NPU_STRUCT(npu_set_dma0_dst)                                                                                       \
    NPU_STRUCT(npu_set_dma0_len)                                                                                       \
    NPU_STRUCT(npu_set_dma0_skip0)                                                                                     \
    NPU_STRUCT(npu_set_dma0_skip1)                                                                                     \
    NPU_STRUCT(npu_set_ifm2_base0)                                                                                     \
    NPU_STRUCT(npu_set_ifm2_base1)                                                                                     \
    NPU_STRUCT(npu_set_ifm2_base2)                                                                                     \
    NPU_STRUCT(npu_set_ifm2_base3)                                                                                     \
    NPU_STRUCT(npu_set_ifm2_stride_x)                                                                                  \
    NPU_STRUCT(npu_set_ifm2_stride_y)                                                                                  \
    NPU_STRUCT(npu_set_ifm2_stride_c)                                                                                  \
    NPU_STRUCT(npu_set_weight1_base)                                                                                   \
    NPU_STRUCT(npu_set_weight1_length)                                                                                 \
    NPU_STRUCT(npu_set_scale1_base)                                                                                    \
    NPU_STRUCT(npu_set_scale1_length)
#define NPU_OP_STRUCTS                                                                                                 \
    NPU_OP_(stop)                                                                                                      \
    NPU_OP_(irq)                                                                                                       \
    NPU_OP_(conv)                                                                                                      \
    NPU_OP_(depthwise)                                                                                                 \
    NPU_OP_(pool)                                                                                                      \
    NPU_OP_(elementwise)                                                                                               \
    NPU_OP_(dma_start)                                                                                                 \
    NPU_OP_(dma_wait)                                                                                                  \
    NPU_OP_(kernel_wait)                                                                                               \
    NPU_OP_(pmu_mask)
#define NPU_SET_STRUCTS                                                                                                \
    NPU_SET_(ifm_pad_top)                                                                                              \
    NPU_SET_(ifm_pad_left)                                                                                             \
    NPU_SET_(ifm_pad_right)                                                                                            \
    NPU_SET_(ifm_pad_bottom)                                                                                           \
    NPU_SET_(ifm_depth_m1)                                                                                             \
    NPU_SET_(ifm_precision)                                                                                            \
    NPU_SET_(ifm_upscale)                                                                                              \
    NPU_SET_(ifm_zero_point)                                                                                           \
    NPU_SET_(ifm_width0_m1)                                                                                            \
    NPU_SET_(ifm_height0_m1)                                                                                           \
    NPU_SET_(ifm_height1_m1)                                                                                           \
    NPU_SET_(ifm_ib_end)                                                                                               \
    NPU_SET_(ifm_region)                                                                                               \
    NPU_SET_(ofm_width_m1)                                                                                             \
    NPU_SET_(ofm_height_m1)                                                                                            \
    NPU_SET_(ofm_depth_m1)                                                                                             \
    NPU_SET_(ofm_precision)                                                                                            \
    NPU_SET_(ofm_blk_width_m1)                                                                                         \
    NPU_SET_(ofm_blk_height_m1)                                                                                        \
    NPU_SET_(ofm_blk_depth_m1)                                                                                         \
    NPU_SET_(ofm_zero_point)                                                                                           \
    NPU_SET_(ofm_width0_m1)                                                                                            \
    NPU_SET_(ofm_height0_m1)                                                                                           \
    NPU_SET_(ofm_height1_m1)                                                                                           \
    NPU_SET_(ofm_region)                                                                                               \
    NPU_SET_(kernel_width_m1)                                                                                          \
    NPU_SET_(kernel_height_m1)                                                                                         \
    NPU_SET_(kernel_stride)                                                                                            \
    NPU_SET_(parallel_mode)                                                                                            \
    NPU_SET_(acc_format)                                                                                               \
    NPU_SET_(activation)                                                                                               \
    NPU_SET_(activation_min)                                                                                           \
    NPU_SET_(activation_max)                                                                                           \
    NPU_SET_(weight_region)                                                                                            \
    NPU_SET_(scale_region)                                                                                             \
    NPU_SET_(ab_start)                                                                                                 \
    NPU_SET_(blockdep)                                                                                                 \
    NPU_SET_(dma0_src_region)                                                                                          \
    NPU_SET_(dma0_dst_region)                                                                                          \
    NPU_SET_(dma0_size0)                                                                                               \
    NPU_SET_(dma0_size1)                                                                                               \
    NPU_SET_(ifm2_broadcast)                                                                                           \
    NPU_SET_(ifm2_scalar)                                                                                              \
    NPU_SET_(ifm2_precision)                                                                                           \
    NPU_SET_(ifm2_zero_point)                                                                                          \
    NPU_SET_(ifm2_width0_m1)                                                                                           \
    NPU_SET_(ifm2_height0_m1)                                                                                          \
    NPU_SET_(ifm2_height1_m1)                                                                                          \
    NPU_SET_(ifm2_ib_start)                                                                                            \
    NPU_SET_(ifm2_region)                                                                                              \
    NPU_SET_(ifm_base0)                                                                                                \
    NPU_SET_(ifm_base1)                                                                                                \
    NPU_SET_(ifm_base2)                                                                                                \
    NPU_SET_(ifm_base3)                                                                                                \
    NPU_SET_(ifm_stride_x)                                                                                             \
    NPU_SET_(ifm_stride_y)                                                                                             \
    NPU_SET_(ifm_stride_c)                                                                                             \
    NPU_SET_(ofm_base0)                                                                                                \
    NPU_SET_(ofm_base1)                                                                                                \
    NPU_SET_(ofm_base2)                                                                                                \
    NPU_SET_(ofm_base3)                                                                                                \
    NPU_SET_(ofm_stride_x)                                                                                             \
    NPU_SET_(ofm_stride_y)                                                                                             \
    NPU_SET_(ofm_stride_c)                                                                                             \
    NPU_SET_(weight_base)                                                                                              \
    NPU_SET_(weight_length)                                                                                            \
    NPU_SET_(scale_base)                                                                                               \
    NPU_SET_(scale_length)                                                                                             \
    NPU_SET_(ofm_scale)                                                                                                \
    NPU_SET_(opa_scale)                                                                                                \
    NPU_SET_(opb_scale)                                                                                                \
    NPU_SET_(dma0_src)                                                                                                 \
    NPU_SET_(dma0_dst)                                                                                                 \
    NPU_SET_(dma0_len)                                                                                                 \
    NPU_SET_(dma0_skip0)                                                                                               \
    NPU_SET_(dma0_skip1)                                                                                               \
    NPU_SET_(ifm2_base0)                                                                                               \
    NPU_SET_(ifm2_base1)                                                                                               \
    NPU_SET_(ifm2_base2)                                                                                               \
    NPU_SET_(ifm2_base3)                                                                                               \
    NPU_SET_(ifm2_stride_x)                                                                                            \
    NPU_SET_(ifm2_stride_y)                                                                                            \
    NPU_SET_(ifm2_stride_c)                                                                                            \
    NPU_SET_(weight1_base)                                                                                             \
    NPU_SET_(weight1_length)                                                                                           \
    NPU_SET_(scale1_base)                                                                                              \
    NPU_SET_(scale1_length)
#define COMMAND_STRUCTS                                                                                                \
    COMMAND_(no_payload)                                                                                               \
    COMMAND_(with_payload)

#define EXPAND_ACC_FORMAT(FUNC, SEP)                                                                                   \
    FUNC(acc_format, INT_32BIT) SEP FUNC(acc_format, INT_40BIT) SEP FUNC(acc_format, FP_S5_10)

#define EXPAND_ACTIVATION(FUNC, SEP)                                                                                   \
    FUNC(activation, NONE)                                                                                             \
    SEP FUNC(activation, TANH) SEP FUNC(activation, SIGMOID) SEP FUNC(activation, LUT_START)                           \
        SEP FUNC(activation, LUT_END)

#define EXPAND_AXI_MEM_ENCODING_TYPE(FUNC, SEP)                                                                        \
    FUNC(axi_mem_encoding_type, DEVICE_NON_BUFFERABLE)                                                                 \
    SEP FUNC(axi_mem_encoding_type, DEVICE_BUFFERABLE)                                                                 \
        SEP FUNC(axi_mem_encoding_type, NORMAL_NON_CACHEABLE_NON_BUFFERABLE)                                           \
            SEP FUNC(axi_mem_encoding_type, NORMAL_NON_CACHEABLE_BUFFERABLE)                                           \
                SEP FUNC(axi_mem_encoding_type, WRITE_THROUGH_NO_ALLOCATE)                                             \
                    SEP FUNC(axi_mem_encoding_type, WRITE_THROUGH_READ_ALLOCATE)                                       \
                        SEP FUNC(axi_mem_encoding_type, WRITE_THROUGH_WRITE_ALLOCATE)                                  \
                            SEP FUNC(axi_mem_encoding_type, WRITE_THROUGH_READ_AND_WRITE_ALLOCATE)                     \
                                SEP FUNC(axi_mem_encoding_type, WRITE_BACK_NO_ALLOCATE)                                \
                                    SEP FUNC(axi_mem_encoding_type, WRITE_BACK_READ_ALLOCATE)                          \
                                        SEP FUNC(axi_mem_encoding_type, WRITE_BACK_WRITE_ALLOCATE)                     \
                                            SEP FUNC(axi_mem_encoding_type, WRITE_BACK_READ_AND_WRITE_ALLOCATE)        \
                                                SEP FUNC(axi_mem_encoding_type, RESERVED_12)                           \
                                                    SEP FUNC(axi_mem_encoding_type, RESERVED_13)                       \
                                                        SEP FUNC(axi_mem_encoding_type, RESERVED_14)                   \
                                                            SEP FUNC(axi_mem_encoding_type, RESERVED_15)

#define EXPAND_CLIP_RANGE(FUNC, SEP)                                                                                   \
    FUNC(clip_range, OFM_PRECISION)                                                                                    \
    SEP FUNC(clip_range, FORCE_UINT8) SEP FUNC(clip_range, FORCE_INT8) SEP FUNC(clip_range, FORCE_INT16)

#define EXPAND_CMD0(FUNC, SEP)                                                                                         \
    FUNC(cmd0, NPU_OP_STOP)                                                                                            \
    SEP FUNC(cmd0, NPU_OP_IRQ) SEP FUNC(cmd0, NPU_OP_CONV) SEP FUNC(cmd0, NPU_OP_DEPTHWISE) SEP FUNC(                  \
        cmd0, NPU_OP_POOL) SEP FUNC(cmd0, NPU_OP_ELEMENTWISE) SEP FUNC(cmd0, NPU_OP_DMA_START)                         \
        SEP FUNC(cmd0, NPU_OP_DMA_WAIT) SEP FUNC(cmd0, NPU_OP_KERNEL_WAIT) SEP FUNC(cmd0, NPU_OP_PMU_MASK) SEP FUNC(   \
            cmd0, NPU_SET_IFM_PAD_TOP) SEP FUNC(cmd0, NPU_SET_IFM_PAD_LEFT) SEP FUNC(cmd0, NPU_SET_IFM_PAD_RIGHT)      \
            SEP FUNC(cmd0, NPU_SET_IFM_PAD_BOTTOM) SEP FUNC(cmd0, NPU_SET_IFM_DEPTH_M1) SEP FUNC(                      \
                cmd0, NPU_SET_IFM_PRECISION) SEP FUNC(cmd0, NPU_SET_IFM_UPSCALE)                                       \
                SEP FUNC(cmd0, NPU_SET_IFM_ZERO_POINT) SEP FUNC(cmd0, NPU_SET_IFM_WIDTH0_M1) SEP FUNC(                 \
                    cmd0, NPU_SET_IFM_HEIGHT0_M1) SEP FUNC(cmd0, NPU_SET_IFM_HEIGHT1_M1) SEP FUNC(cmd0,                \
                                                                                                  NPU_SET_IFM_IB_END)  \
                    SEP FUNC(cmd0, NPU_SET_IFM_REGION) SEP FUNC(cmd0, NPU_SET_OFM_WIDTH_M1) SEP FUNC(                  \
                        cmd0, NPU_SET_OFM_HEIGHT_M1) SEP FUNC(cmd0, NPU_SET_OFM_DEPTH_M1)                              \
                        SEP FUNC(cmd0, NPU_SET_OFM_PRECISION) SEP FUNC(cmd0, NPU_SET_OFM_BLK_WIDTH_M1) SEP FUNC(       \
                            cmd0, NPU_SET_OFM_BLK_HEIGHT_M1) SEP FUNC(cmd0, NPU_SET_OFM_BLK_DEPTH_M1)                  \
                            SEP FUNC(cmd0, NPU_SET_OFM_ZERO_POINT) SEP FUNC(cmd0, NPU_SET_OFM_WIDTH0_M1) SEP FUNC(     \
                                cmd0, NPU_SET_OFM_HEIGHT0_M1) SEP FUNC(cmd0, NPU_SET_OFM_HEIGHT1_M1)                   \
                                SEP FUNC(cmd0, NPU_SET_OFM_REGION) SEP FUNC(cmd0, NPU_SET_KERNEL_WIDTH_M1) SEP FUNC(   \
                                    cmd0, NPU_SET_KERNEL_HEIGHT_M1) SEP FUNC(cmd0, NPU_SET_KERNEL_STRIDE)              \
                                    SEP FUNC(cmd0, NPU_SET_PARALLEL_MODE) SEP FUNC(cmd0, NPU_SET_ACC_FORMAT) SEP FUNC( \
                                        cmd0, NPU_SET_ACTIVATION) SEP FUNC(cmd0, NPU_SET_ACTIVATION_MIN)               \
                                        SEP FUNC(cmd0, NPU_SET_ACTIVATION_MAX) SEP FUNC(cmd0, NPU_SET_WEIGHT_REGION)   \
                                            SEP FUNC(cmd0, NPU_SET_SCALE_REGION) SEP FUNC(cmd0, NPU_SET_AB_START)      \
                                                SEP FUNC(cmd0,                                                         \
                                                         NPU_SET_BLOCKDEP) SEP FUNC(cmd0, NPU_SET_DMA0_SRC_REGION)     \
                                                    SEP FUNC(cmd0, NPU_SET_DMA0_DST_REGION) SEP FUNC(                  \
                                                        cmd0, NPU_SET_DMA0_SIZE0) SEP FUNC(cmd0, NPU_SET_DMA0_SIZE1)   \
                                                        SEP FUNC(cmd0, NPU_SET_IFM2_BROADCAST)                         \
                                                            SEP FUNC(cmd0, NPU_SET_IFM2_SCALAR)                        \
                                                                SEP FUNC(cmd0, NPU_SET_IFM2_PRECISION) SEP FUNC(       \
                                                                    cmd0, NPU_SET_IFM2_ZERO_POINT)                     \
                                                                    SEP FUNC(cmd0, NPU_SET_IFM2_WIDTH0_M1) SEP FUNC(   \
                                                                        cmd0, NPU_SET_IFM2_HEIGHT0_M1)                 \
                                                                        SEP FUNC(cmd0, NPU_SET_IFM2_HEIGHT1_M1)        \
                                                                            SEP FUNC(cmd0, NPU_SET_IFM2_IB_START)      \
                                                                                SEP FUNC(cmd0, NPU_SET_IFM2_REGION)

#define EXPAND_CMD1(FUNC, SEP)                                                                                         \
    FUNC(cmd1, NPU_SET_IFM_BASE0)                                                                                      \
    SEP FUNC(cmd1, NPU_SET_IFM_BASE1) SEP FUNC(cmd1, NPU_SET_IFM_BASE2) SEP FUNC(cmd1, NPU_SET_IFM_BASE3)              \
        SEP FUNC(cmd1, NPU_SET_IFM_STRIDE_X) SEP FUNC(cmd1, NPU_SET_IFM_STRIDE_Y) SEP FUNC(cmd1, NPU_SET_IFM_STRIDE_C) \
            SEP FUNC(cmd1, NPU_SET_OFM_BASE0) SEP FUNC(cmd1, NPU_SET_OFM_BASE1) SEP FUNC(cmd1, NPU_SET_OFM_BASE2)      \
                SEP FUNC(cmd1, NPU_SET_OFM_BASE3) SEP FUNC(cmd1, NPU_SET_OFM_STRIDE_X)                                 \
                    SEP FUNC(cmd1, NPU_SET_OFM_STRIDE_Y) SEP FUNC(cmd1, NPU_SET_OFM_STRIDE_C)                          \
                        SEP FUNC(cmd1, NPU_SET_WEIGHT_BASE) SEP FUNC(cmd1, NPU_SET_WEIGHT_LENGTH)                      \
                            SEP FUNC(cmd1, NPU_SET_SCALE_BASE) SEP FUNC(cmd1, NPU_SET_SCALE_LENGTH)                    \
                                SEP FUNC(cmd1, NPU_SET_OFM_SCALE) SEP FUNC(cmd1, NPU_SET_OPA_SCALE)                    \
                                    SEP FUNC(cmd1, NPU_SET_OPB_SCALE) SEP FUNC(cmd1, NPU_SET_DMA0_SRC)                 \
                                        SEP FUNC(cmd1, NPU_SET_DMA0_DST) SEP FUNC(cmd1, NPU_SET_DMA0_LEN) SEP FUNC(    \
                                            cmd1, NPU_SET_DMA0_SKIP0) SEP FUNC(cmd1, NPU_SET_DMA0_SKIP1)               \
                                            SEP FUNC(cmd1, NPU_SET_IFM2_BASE0) SEP FUNC(cmd1, NPU_SET_IFM2_BASE1)      \
                                                SEP FUNC(cmd1, NPU_SET_IFM2_BASE2) SEP FUNC(cmd1, NPU_SET_IFM2_BASE3)  \
                                                    SEP FUNC(cmd1, NPU_SET_IFM2_STRIDE_X)                              \
                                                        SEP FUNC(cmd1, NPU_SET_IFM2_STRIDE_Y)                          \
                                                            SEP FUNC(cmd1, NPU_SET_IFM2_STRIDE_C)                      \
                                                                SEP FUNC(cmd1, NPU_SET_WEIGHT1_BASE)                   \
                                                                    SEP FUNC(cmd1, NPU_SET_WEIGHT1_LENGTH)             \
                                                                        SEP FUNC(cmd1, NPU_SET_SCALE1_BASE)            \
                                                                            SEP FUNC(cmd1, NPU_SET_SCALE1_LENGTH)

#define EXPAND_DATA_FORMAT(FUNC, SEP) FUNC(data_format, NHWC) SEP FUNC(data_format, NHCWB16)

#define EXPAND_ELEMENTWISE_MODE(FUNC, SEP)                                                                             \
    FUNC(elementwise_mode, MUL)                                                                                        \
    SEP FUNC(elementwise_mode, ADD) SEP FUNC(elementwise_mode, SUB) SEP FUNC(elementwise_mode, MIN)                    \
        SEP FUNC(elementwise_mode, MAX) SEP FUNC(elementwise_mode, LRELU) SEP FUNC(elementwise_mode, ABS)              \
            SEP FUNC(elementwise_mode, CLZ) SEP FUNC(elementwise_mode, SHR) SEP FUNC(elementwise_mode, SHL)

#define EXPAND_IFM_PRECISION(FUNC, SEP)                                                                                \
    FUNC(ifm_precision, U8)                                                                                            \
    SEP FUNC(ifm_precision, S8) SEP FUNC(ifm_precision, U16) SEP FUNC(ifm_precision, S16) SEP FUNC(ifm_precision, S32)

#define EXPAND_IFM_SCALE_MODE(FUNC, SEP)                                                                               \
    FUNC(ifm_scale_mode, SCALE_16BIT)                                                                                  \
    SEP FUNC(ifm_scale_mode, SCALE_OPA_32BIT) SEP FUNC(ifm_scale_mode, SCALE_OPB_32BIT)

#define EXPAND_MACS_PER_CC(FUNC, SEP)                                                                                  \
    FUNC(macs_per_cc, MACS_PER_CC_IS_5)                                                                                \
    SEP FUNC(macs_per_cc, MACS_PER_CC_IS_6) SEP FUNC(macs_per_cc, MACS_PER_CC_IS_7)                                    \
        SEP FUNC(macs_per_cc, MACS_PER_CC_IS_8)

#define EXPAND_MEMORY_TYPE(FUNC, SEP)                                                                                  \
    FUNC(memory_type, AXI0_OUTSTANDING_COUNTER0)                                                                       \
    SEP FUNC(memory_type, AXI0_OUTSTANDING_COUNTER1) SEP FUNC(memory_type, AXI1_OUTSTANDING_COUNTER2)                  \
        SEP FUNC(memory_type, AXI1_OUTSTANDING_COUNTER3)

#define EXPAND_OFM_PRECISION(FUNC, SEP)                                                                                \
    FUNC(ofm_precision, U8)                                                                                            \
    SEP FUNC(ofm_precision, S8) SEP FUNC(ofm_precision, U16) SEP FUNC(ofm_precision, S16) SEP FUNC(ofm_precision, S32)

#define EXPAND_PMU_EVENT_TYPE(FUNC, SEP)                                                                                           \
    FUNC(pmu_event_type, NO_EVENT)                                                                                                 \
    SEP FUNC(pmu_event_type, CYCLE) SEP FUNC(pmu_event_type, NPU_IDLE) SEP FUNC(                                                   \
        pmu_event_type, CC_STALLED_ON_BLOCKDEP) SEP FUNC(pmu_event_type,                                                           \
                                                         CC_STALLED_ON_SHRAM_RECONFIG) SEP FUNC(pmu_event_type,                    \
                                                                                                NPU_ACTIVE)                        \
        SEP FUNC(pmu_event_type, MAC_ACTIVE) SEP FUNC(pmu_event_type, MAC_ACTIVE_8BIT) SEP FUNC(                                   \
            pmu_event_type, MAC_ACTIVE_16BIT) SEP FUNC(pmu_event_type, MAC_DPU_ACTIVE) SEP FUNC(pmu_event_type,                    \
                                                                                                MAC_STALLED_BY_WD_ACC)             \
            SEP FUNC(pmu_event_type, MAC_STALLED_BY_WD) SEP FUNC(pmu_event_type, MAC_STALLED_BY_ACC) SEP FUNC(                     \
                pmu_event_type, MAC_STALLED_BY_IB) SEP FUNC(pmu_event_type,                                                        \
                                                            MAC_ACTIVE_32BIT) SEP FUNC(pmu_event_type,                             \
                                                                                       MAC_STALLED_BY_INT_W)                       \
                SEP FUNC(pmu_event_type, MAC_STALLED_BY_INT_ACC) SEP FUNC(pmu_event_type, AO_ACTIVE) SEP FUNC(                     \
                    pmu_event_type, AO_ACTIVE_8BIT) SEP FUNC(pmu_event_type,                                                       \
                                                             AO_ACTIVE_16BIT) SEP FUNC(pmu_event_type,                             \
                                                                                       AO_STALLED_BY_OFMP_OB)                      \
                    SEP FUNC(pmu_event_type, AO_STALLED_BY_OFMP) SEP FUNC(pmu_event_type, AO_STALLED_BY_OB) SEP FUNC(              \
                        pmu_event_type,                                                                                            \
                        AO_STALLED_BY_ACC_IB) SEP FUNC(pmu_event_type,                                                             \
                                                       AO_STALLED_BY_ACC) SEP FUNC(pmu_event_type,                                 \
                                                                                   AO_STALLED_BY_IB) SEP FUNC(pmu_event_type,      \
                                                                                                              WD_ACTIVE) SEP       \
                        FUNC(pmu_event_type, WD_STALLED) SEP FUNC(pmu_event_type, WD_STALLED_BY_WS) SEP FUNC(                      \
                            pmu_event_type,                                                                                        \
                            WD_STALLED_BY_WD_BUF) SEP                                                                              \
                            FUNC(pmu_event_type, WD_PARSE_ACTIVE) SEP FUNC(pmu_event_type, WD_PARSE_STALLED) SEP FUNC(             \
                                pmu_event_type,                                                                                    \
                                WD_PARSE_STALLED_IN) SEP FUNC(pmu_event_type,                                                      \
                                                              WD_PARSE_STALLED_OUT) SEP                                            \
                                FUNC(pmu_event_type, WD_TRANS_WS) SEP FUNC(pmu_event_type, WD_TRANS_WB) SEP FUNC(                  \
                                    pmu_event_type,                                                                                \
                                    WD_TRANS_DW0) SEP FUNC(pmu_event_type,                                                         \
                                                           WD_TRANS_DW1) SEP FUNC(pmu_event_type,                                  \
                                                                                  AXI0_RD_TRANS_ACCEPTED) SEP                      \
                                    FUNC(pmu_event_type, AXI0_RD_TRANS_COMPLETED) SEP FUNC(                                        \
                                        pmu_event_type,                                                                            \
                                        AXI0_RD_DATA_BEAT_RECEIVED) SEP FUNC(pmu_event_type, AXI0_RD_TRAN_REQ_STALLED)             \
                                        SEP FUNC(pmu_event_type,                                                                   \
                                                 AXI0_WR_TRANS_ACCEPTED) SEP FUNC(pmu_event_type,                                  \
                                                                                  AXI0_WR_TRANS_COMPLETED_M)                       \
                                            SEP FUNC(pmu_event_type, AXI0_WR_TRANS_COMPLETED_S) SEP FUNC(                          \
                                                pmu_event_type,                                                                    \
                                                AXI0_WR_DATA_BEAT_WRITTEN)                                                         \
                                                SEP FUNC(pmu_event_type, AXI0_WR_TRAN_REQ_STALLED) SEP FUNC(                       \
                                                    pmu_event_type,                                                                \
                                                    AXI0_WR_DATA_BEAT_STALLED) SEP                                                 \
                                                    FUNC(pmu_event_type, AXI0_ENABLED_CYCLES) SEP FUNC(                            \
                                                        pmu_event_type,                                                            \
                                                        AXI0_RD_STALL_LIMIT) SEP FUNC(pmu_event_type,                              \
                                                                                      AXI0_WR_STALL_LIMIT) SEP                     \
                                                        FUNC(pmu_event_type, AXI1_RD_TRANS_ACCEPTED) SEP FUNC(                     \
                                                            pmu_event_type,                                                        \
                                                            AXI1_RD_TRANS_COMPLETED) SEP FUNC(pmu_event_type,                      \
                                                                                              AXI1_RD_DATA_BEAT_RECEIVED) SEP      \
                                                            FUNC(pmu_event_type, AXI1_RD_TRAN_REQ_STALLED) SEP FUNC(               \
                                                                pmu_event_type,                                                    \
                                                                AXI1_WR_TRANS_ACCEPTED) SEP                                        \
                                                                FUNC(pmu_event_type, AXI1_WR_TRANS_COMPLETED_M) SEP FUNC(          \
                                                                    pmu_event_type,                                                \
                                                                    AXI1_WR_TRANS_COMPLETED_S) SEP                                 \
                                                                    FUNC(pmu_event_type, AXI1_WR_DATA_BEAT_WRITTEN) SEP FUNC(      \
                                                                        pmu_event_type,                                            \
                                                                        AXI1_WR_TRAN_REQ_STALLED) SEP                              \
                                                                        FUNC(pmu_event_type, AXI1_WR_DATA_BEAT_STALLED) SEP FUNC(  \
                                                                            pmu_event_type,                                        \
                                                                            AXI1_ENABLED_CYCLES) SEP FUNC(pmu_event_type,          \
                                                                                                          AXI1_RD_STALL_LIMIT) SEP \
                                                                            FUNC(pmu_event_type, AXI1_WR_STALL_LIMIT) SEP FUNC(    \
                                                                                pmu_event_type,                                    \
                                                                                AXI_LATENCY_ANY) SEP FUNC(pmu_event_type,          \
                                                                                                          AXI_LATENCY_32) SEP      \
                                                                                FUNC(pmu_event_type, AXI_LATENCY_64) SEP FUNC(     \
                                                                                    pmu_event_type,                                \
                                                                                    AXI_LATENCY_128) SEP                           \
                                                                                    FUNC(pmu_event_type,                           \
                                                                                         AXI_LATENCY_256) SEP                      \
                                                                                        FUNC(pmu_event_type,                       \
                                                                                             AXI_LATENCY_512) SEP                  \
                                                                                            FUNC(pmu_event_type,                   \
                                                                                                 AXI_LATENCY_1024) SEP             \
                                                                                                FUNC(pmu_event_type,               \
                                                                                                     ECC_DMA) SEP                  \
                                                                                                    FUNC(                          \
                                                                                                        pmu_event_type,            \
                                                                                                        ECC_SB0) SEP               \
                                                                                                        FUNC(                      \
                                                                                                            pmu_event_type,        \
                                                                                                            ECC_SB1)

#define EXPAND_POOLING_MODE(FUNC, SEP)                                                                                 \
    FUNC(pooling_mode, MAX) SEP FUNC(pooling_mode, AVERAGE) SEP FUNC(pooling_mode, REDUCE_SUM)

#define EXPAND_PRIVILEGE_LEVEL(FUNC, SEP) FUNC(privilege_level, USER) SEP FUNC(privilege_level, PRIVILEGED)

#define EXPAND_RESAMPLING_MODE(FUNC, SEP)                                                                              \
    FUNC(resampling_mode, NONE) SEP FUNC(resampling_mode, NEAREST) SEP FUNC(resampling_mode, TRANSPOSE)

#define EXPAND_ROUNDING(FUNC, SEP) FUNC(rounding, TFL) SEP FUNC(rounding, TRUNCATE) SEP FUNC(rounding, NATURAL)

#define EXPAND_SECURITY_LEVEL(FUNC, SEP) FUNC(security_level, SECURE) SEP FUNC(security_level, NON_SECURE)

#define EXPAND_SHRAM_SIZE(FUNC, SEP)                                                                                   \
    FUNC(shram_size, SHRAM_96KB)                                                                                       \
    SEP FUNC(shram_size, SHRAM_48KB) SEP FUNC(shram_size, SHRAM_24KB) SEP FUNC(shram_size, SHRAM_16KB)

#define EXPAND_STATE(FUNC, SEP) FUNC(state, STOPPED) SEP FUNC(state, RUNNING)

#define EXPAND_STRIDE_MODE(FUNC, SEP)                                                                                  \
    FUNC(stride_mode, STRIDE_MODE_1D) SEP FUNC(stride_mode, STRIDE_MODE_2D) SEP FUNC(stride_mode, STRIDE_MODE_3D)
#endif /* ETHOSU55_INTERFACE_H */
