/* Edge Impulse inferencing library
 * Copyright (c) 2022 EdgeImpulse Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#pragma once

#include <array>

namespace ei{
namespace spectral{
//generated by autotune.export

static const std::array<std::array<float, 6>, 2> bior1p3 = {{
    {{-0.08838834764831845, 0.08838834764831845, 0.7071067811865476, 0.7071067811865476, 0.08838834764831845, -0.08838834764831845}},
    {{-0.0, 0.0, -0.7071067811865476, 0.7071067811865476, -0.0, 0.0}}
}};

static const std::array<std::array<float, 10>, 2> bior1p5 = {{
    {{0.016572815184059706, -0.016572815184059706, -0.12153397801643785, 0.12153397801643785, 0.7071067811865476, 0.7071067811865476, 0.12153397801643785, -0.12153397801643785, -0.016572815184059706, 0.016572815184059706}},
    {{-0.0, 0.0, -0.0, 0.0, -0.7071067811865476, 0.7071067811865476, -0.0, 0.0, -0.0, 0.0}}
}};

static const std::array<std::array<float, 6>, 2> bior2p2 = {{
    {{0.0, -0.1767766952966369, 0.3535533905932738, 1.0606601717798212, 0.3535533905932738, -0.1767766952966369}},
    {{-0.0, 0.3535533905932738, -0.7071067811865476, 0.3535533905932738, -0.0, 0.0}}
}};

static const std::array<std::array<float, 10>, 2> bior2p4 = {{
    {{0.0, 0.03314563036811941, -0.06629126073623882, -0.1767766952966369, 0.4198446513295126, 0.9943689110435825, 0.4198446513295126, -0.1767766952966369, -0.06629126073623882, 0.03314563036811941}},
    {{-0.0, 0.0, -0.0, 0.3535533905932738, -0.7071067811865476, 0.3535533905932738, -0.0, 0.0, -0.0, 0.0}}
}};

static const std::array<std::array<float, 14>, 2> bior2p6 = {{
    {{0.0, -0.006905339660024878, 0.013810679320049757, 0.04695630968816917, -0.1077232986963881, -0.16987135563661201, 0.4474660099696121, 0.966747552403483, 0.4474660099696121, -0.16987135563661201, -0.1077232986963881, 0.04695630968816917, 0.013810679320049757, -0.006905339660024878}},
    {{-0.0, 0.0, -0.0, 0.0, -0.0, 0.3535533905932738, -0.7071067811865476, 0.3535533905932738, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0}}
}};

static const std::array<std::array<float, 18>, 2> bior2p8 = {{
    {{0.0, 0.0015105430506304422, -0.0030210861012608843, -0.012947511862546647, 0.02891610982635418, 0.05299848189069094, -0.13491307360773605, -0.16382918343409023, 0.46257144047591653, 0.9516421218971786, 0.46257144047591653, -0.16382918343409023, -0.13491307360773605, 0.05299848189069094, 0.02891610982635418, -0.012947511862546647, -0.0030210861012608843, 0.0015105430506304422}},
    {{-0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.3535533905932738, -0.7071067811865476, 0.3535533905932738, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0}}
}};

static const std::array<std::array<float, 4>, 2> bior3p1 = {{
    {{-0.3535533905932738, 1.0606601717798212, 1.0606601717798212, -0.3535533905932738}},
    {{-0.1767766952966369, 0.5303300858899106, -0.5303300858899106, 0.1767766952966369}}
}};

static const std::array<std::array<float, 8>, 2> bior3p3 = {{
    {{0.06629126073623882, -0.1988737822087165, -0.15467960838455727, 0.9943689110435825, 0.9943689110435825, -0.15467960838455727, -0.1988737822087165, 0.06629126073623882}},
    {{-0.0, 0.0, -0.1767766952966369, 0.5303300858899106, -0.5303300858899106, 0.1767766952966369, -0.0, 0.0}}
}};

static const std::array<std::array<float, 12>, 2> bior3p5 = {{
    {{-0.013810679320049757, 0.04143203796014927, 0.052480581416189075, -0.26792717880896527, -0.07181553246425873, 0.966747552403483, 0.966747552403483, -0.07181553246425873, -0.26792717880896527, 0.052480581416189075, 0.04143203796014927, -0.013810679320049757}},
    {{-0.0, 0.0, -0.0, 0.0, -0.1767766952966369, 0.5303300858899106, -0.5303300858899106, 0.1767766952966369, -0.0, 0.0, -0.0, 0.0}}
}};

static const std::array<std::array<float, 16>, 2> bior3p7 = {{
    {{0.0030210861012608843, -0.009063258303782653, -0.01683176542131064, 0.074663985074019, 0.03133297870736289, -0.301159125922835, -0.02649924094534547, 0.9516421218971786, 0.9516421218971786, -0.02649924094534547, -0.301159125922835, 0.03133297870736289, 0.074663985074019, -0.01683176542131064, -0.009063258303782653, 0.0030210861012608843}},
    {{-0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.1767766952966369, 0.5303300858899106, -0.5303300858899106, 0.1767766952966369, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0}}
}};

static const std::array<std::array<float, 20>, 2> bior3p9 = {{
    {{-0.0006797443727836989, 0.002039233118351097, 0.005060319219611981, -0.020618912641105536, -0.014112787930175844, 0.09913478249423216, 0.012300136269419315, -0.32019196836077857, 0.0020500227115698858, 0.9421257006782068, 0.9421257006782068, 0.0020500227115698858, -0.32019196836077857, 0.012300136269419315, 0.09913478249423216, -0.014112787930175844, -0.020618912641105536, 0.005060319219611981, 0.002039233118351097, -0.0006797443727836989}},
    {{-0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.1767766952966369, 0.5303300858899106, -0.5303300858899106, 0.1767766952966369, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0}}
}};

static const std::array<std::array<float, 10>, 2> bior4p4 = {{
    {{0.0, 0.03782845550726404, -0.023849465019556843, -0.11062440441843718, 0.37740285561283066, 0.8526986790088938, 0.37740285561283066, -0.11062440441843718, -0.023849465019556843, 0.03782845550726404}},
    {{-0.0, -0.06453888262869706, 0.04068941760916406, 0.41809227322161724, -0.7884856164055829, 0.41809227322161724, 0.04068941760916406, -0.06453888262869706, -0.0, 0.0}}
}};

static const std::array<std::array<float, 12>, 2> bior5p5 = {{
    {{0.0, 0.0, 0.03968708834740544, 0.007948108637240322, -0.05446378846823691, 0.34560528195603346, 0.7366601814282105, 0.34560528195603346, -0.05446378846823691, 0.007948108637240322, 0.03968708834740544, 0.0}},
    {{-0.013456709459118716, -0.002694966880111507, 0.13670658466432914, -0.09350469740093886, -0.47680326579848425, 0.8995061097486484, -0.47680326579848425, -0.09350469740093886, 0.13670658466432914, -0.002694966880111507, -0.013456709459118716, 0.0}}
}};

static const std::array<std::array<float, 18>, 2> bior6p8 = {{
    {{0.0, 0.0019088317364812906, -0.0019142861290887667, -0.016990639867602342, 0.01193456527972926, 0.04973290349094079, -0.07726317316720414, -0.09405920349573646, 0.4207962846098268, 0.8259229974584023, 0.4207962846098268, -0.09405920349573646, -0.07726317316720414, 0.04973290349094079, 0.01193456527972926, -0.016990639867602342, -0.0019142861290887667, 0.0019088317364812906}},
    {{-0.0, 0.0, -0.0, 0.014426282505624435, -0.014467504896790148, -0.07872200106262882, 0.04036797903033992, 0.41784910915027457, -0.7589077294536541, 0.41784910915027457, 0.04036797903033992, -0.07872200106262882, -0.014467504896790148, 0.014426282505624435, -0.0, 0.0, -0.0, 0.0}}
}};

static const std::array<std::array<float, 6>, 2> coif1 = {{
    {{-0.015655728135791993, -0.07273261951252645, 0.3848648468648578, 0.8525720202116004, 0.3378976624574818, -0.07273261951252645}},
    {{0.07273261951252645, 0.3378976624574818, -0.8525720202116004, 0.3848648468648578, 0.07273261951252645, -0.015655728135791993}}
}};

static const std::array<std::array<float, 12>, 2> coif2 = {{
    {{-0.000720549445520347, -0.0018232088709110323, 0.005611434819368834, 0.02368017194684777, -0.05943441864643109, -0.07648859907828076, 0.4170051844232391, 0.8127236354494135, 0.3861100668227629, -0.0673725547237256, -0.04146493678687178, 0.01638733646320364}},
    {{-0.01638733646320364, -0.04146493678687178, 0.0673725547237256, 0.3861100668227629, -0.8127236354494135, 0.4170051844232391, 0.07648859907828076, -0.05943441864643109, -0.02368017194684777, 0.005611434819368834, 0.0018232088709110323, -0.000720549445520347}}
}};

static const std::array<std::array<float, 18>, 2> coif3 = {{
    {{-3.459977319727278e-05, -7.0983302506379e-05, 0.0004662169598204029, 0.0011175187708306303, -0.0025745176881367972, -0.009007976136730624, 0.015880544863669452, 0.03455502757329774, -0.08230192710629983, -0.07179982161915484, 0.42848347637737, 0.7937772226260872, 0.40517690240911824, -0.06112339000297255, -0.06577191128146936, 0.023452696142077168, 0.007782596425672746, -0.003793512864380802}},
    {{0.003793512864380802, 0.007782596425672746, -0.023452696142077168, -0.06577191128146936, 0.06112339000297255, 0.40517690240911824, -0.7937772226260872, 0.42848347637737, 0.07179982161915484, -0.08230192710629983, -0.03455502757329774, 0.015880544863669452, 0.009007976136730624, -0.0025745176881367972, -0.0011175187708306303, 0.0004662169598204029, 7.0983302506379e-05, -3.459977319727278e-05}}
}};

static const std::array<std::array<float, 4>, 2> db2 = {{
    {{-0.12940952255126037, 0.2241438680420134, 0.8365163037378079, 0.48296291314453416}},
    {{-0.48296291314453416, 0.8365163037378079, -0.2241438680420134, -0.12940952255126037}}
}};

static const std::array<std::array<float, 6>, 2> db3 = {{
    {{0.03522629188570953, -0.08544127388202666, -0.13501102001025458, 0.45987750211849154, 0.8068915093110925, 0.33267055295008263}},
    {{-0.33267055295008263, 0.8068915093110925, -0.45987750211849154, -0.13501102001025458, 0.08544127388202666, 0.03522629188570953}}
}};

static const std::array<std::array<float, 8>, 2> db4 = {{
    {{-0.010597401785069032, 0.0328830116668852, 0.030841381835560764, -0.18703481171909309, -0.027983769416859854, 0.6308807679298589, 0.7148465705529157, 0.2303778133088965}},
    {{-0.2303778133088965, 0.7148465705529157, -0.6308807679298589, -0.027983769416859854, 0.18703481171909309, 0.030841381835560764, -0.0328830116668852, -0.010597401785069032}}
}};

static const std::array<std::array<float, 10>, 2> db5 = {{
    {{0.0033357252854737712, -0.012580751999081999, -0.006241490212798274, 0.07757149384004572, -0.032244869584638375, -0.24229488706638203, 0.13842814590132074, 0.7243085284377729, 0.6038292697971896, 0.16010239797419293}},
    {{-0.16010239797419293, 0.6038292697971896, -0.7243085284377729, 0.13842814590132074, 0.24229488706638203, -0.032244869584638375, -0.07757149384004572, -0.006241490212798274, 0.012580751999081999, 0.0033357252854737712}}
}};

static const std::array<std::array<float, 12>, 2> db6 = {{
    {{-0.0010773010853084796, 0.004777257510945511, 0.0005538422011614961, -0.03158203931748603, 0.027522865530305727, 0.09750160558732304, -0.12976686756726194, -0.22626469396543983, 0.31525035170919763, 0.7511339080210954, 0.49462389039845306, 0.11154074335010947}},
    {{-0.11154074335010947, 0.49462389039845306, -0.7511339080210954, 0.31525035170919763, 0.22626469396543983, -0.12976686756726194, -0.09750160558732304, 0.027522865530305727, 0.03158203931748603, 0.0005538422011614961, -0.004777257510945511, -0.0010773010853084796}}
}};

static const std::array<std::array<float, 14>, 2> db7 = {{
    {{0.00035371379997452024, -0.0018016407040474908, 0.0004295779729213665, 0.01255099855609984, -0.01657454163066688, -0.03802993693501441, 0.08061260915108308, 0.07130921926683026, -0.22403618499387498, -0.14390600392856498, 0.4697822874051931, 0.7291320908462351, 0.3965393194819173, 0.07785205408500918}},
    {{-0.07785205408500918, 0.3965393194819173, -0.7291320908462351, 0.4697822874051931, 0.14390600392856498, -0.22403618499387498, -0.07130921926683026, 0.08061260915108308, 0.03802993693501441, -0.01657454163066688, -0.01255099855609984, 0.0004295779729213665, 0.0018016407040474908, 0.00035371379997452024}}
}};

static const std::array<std::array<float, 16>, 2> db8 = {{
    {{-0.00011747678412476953, 0.0006754494064505693, -0.00039174037337694705, -0.004870352993451574, 0.008746094047405777, 0.013981027917398282, -0.044088253930794755, -0.017369301001807547, 0.12874742662047847, 0.0004724845739132828, -0.2840155429615469, -0.015829105256349306, 0.5853546836542067, 0.6756307362972898, 0.31287159091429995, 0.05441584224310401}},
    {{-0.05441584224310401, 0.31287159091429995, -0.6756307362972898, 0.5853546836542067, 0.015829105256349306, -0.2840155429615469, -0.0004724845739132828, 0.12874742662047847, 0.017369301001807547, -0.044088253930794755, -0.013981027917398282, 0.008746094047405777, 0.004870352993451574, -0.00039174037337694705, -0.0006754494064505693, -0.00011747678412476953}}
}};

static const std::array<std::array<float, 18>, 2> db9 = {{
    {{3.93473203162716e-05, -0.0002519631889427101, 0.00023038576352319597, 0.0018476468830562265, -0.00428150368246343, -0.004723204757751397, 0.022361662123679096, 0.00025094711483145197, -0.06763282906132997, 0.03072568147933338, 0.14854074933810638, -0.09684078322297646, -0.2932737832791749, 0.13319738582500756, 0.6572880780513005, 0.6048231236901112, 0.24383467461259034, 0.038077947363878345}},
    {{-0.038077947363878345, 0.24383467461259034, -0.6048231236901112, 0.6572880780513005, -0.13319738582500756, -0.2932737832791749, 0.09684078322297646, 0.14854074933810638, -0.03072568147933338, -0.06763282906132997, -0.00025094711483145197, 0.022361662123679096, 0.004723204757751397, -0.00428150368246343, -0.0018476468830562265, 0.00023038576352319597, 0.0002519631889427101, 3.93473203162716e-05}}
}};

static const std::array<std::array<float, 20>, 2> db10 = {{
    {{-1.3264202894521244e-05, 9.358867032006959e-05, -0.00011646685512928545, -0.0006858566949597116, 0.001992405295185056, 0.001395351747052901, -0.010733175483330575, 0.0036065535669561697, 0.033212674059341, -0.029457536821875813, -0.07139414716639708, 0.09305736460357235, 0.12736934033579325, -0.19594627437737705, -0.24984642432731538, 0.2811723436605775, 0.6884590394536035, 0.5272011889317256, 0.1881768000776915, 0.026670057900555554}},
    {{-0.026670057900555554, 0.1881768000776915, -0.5272011889317256, 0.6884590394536035, -0.2811723436605775, -0.24984642432731538, 0.19594627437737705, 0.12736934033579325, -0.09305736460357235, -0.07139414716639708, 0.029457536821875813, 0.033212674059341, -0.0036065535669561697, -0.010733175483330575, -0.001395351747052901, 0.001992405295185056, 0.0006858566949597116, -0.00011646685512928545, -9.358867032006959e-05, -1.3264202894521244e-05}}
}};

static const std::array<std::array<float, 2>, 2> haar = {{
    {{0.7071067811865476, 0.7071067811865476}},
    {{-0.7071067811865476, 0.7071067811865476}}
}};

static const std::array<std::array<float, 6>, 2> rbio1p3 = {{
    {{0.0, 0.0, 0.7071067811865476, 0.7071067811865476, 0.0, 0.0}},
    {{0.08838834764831845, 0.08838834764831845, -0.7071067811865476, 0.7071067811865476, -0.08838834764831845, -0.08838834764831845}}
}};

static const std::array<std::array<float, 10>, 2> rbio1p5 = {{
    {{0.0, 0.0, 0.0, 0.0, 0.7071067811865476, 0.7071067811865476, 0.0, 0.0, 0.0, 0.0}},
    {{-0.016572815184059706, -0.016572815184059706, 0.12153397801643785, 0.12153397801643785, -0.7071067811865476, 0.7071067811865476, -0.12153397801643785, -0.12153397801643785, 0.016572815184059706, 0.016572815184059706}}
}};

static const std::array<std::array<float, 6>, 2> rbio2p2 = {{
    {{0.0, 0.0, 0.3535533905932738, 0.7071067811865476, 0.3535533905932738, 0.0}},
    {{0.1767766952966369, 0.3535533905932738, -1.0606601717798212, 0.3535533905932738, 0.1767766952966369, 0.0}}
}};

static const std::array<std::array<float, 10>, 2> rbio2p4 = {{
    {{0.0, 0.0, 0.0, 0.0, 0.3535533905932738, 0.7071067811865476, 0.3535533905932738, 0.0, 0.0, 0.0}},
    {{-0.03314563036811941, -0.06629126073623882, 0.1767766952966369, 0.4198446513295126, -0.9943689110435825, 0.4198446513295126, 0.1767766952966369, -0.06629126073623882, -0.03314563036811941, 0.0}}
}};

static const std::array<std::array<float, 14>, 2> rbio2p6 = {{
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.3535533905932738, 0.7071067811865476, 0.3535533905932738, 0.0, 0.0, 0.0, 0.0, 0.0}},
    {{0.006905339660024878, 0.013810679320049757, -0.04695630968816917, -0.1077232986963881, 0.16987135563661201, 0.4474660099696121, -0.966747552403483, 0.4474660099696121, 0.16987135563661201, -0.1077232986963881, -0.04695630968816917, 0.013810679320049757, 0.006905339660024878, 0.0}}
}};

static const std::array<std::array<float, 18>, 2> rbio2p8 = {{
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.3535533905932738, 0.7071067811865476, 0.3535533905932738, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}},
    {{-0.0015105430506304422, -0.0030210861012608843, 0.012947511862546647, 0.02891610982635418, -0.05299848189069094, -0.13491307360773605, 0.16382918343409023, 0.46257144047591653, -0.9516421218971786, 0.46257144047591653, 0.16382918343409023, -0.13491307360773605, -0.05299848189069094, 0.02891610982635418, 0.012947511862546647, -0.0030210861012608843, -0.0015105430506304422, 0.0}}
}};

static const std::array<std::array<float, 4>, 2> rbio3p1 = {{
    {{0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369}},
    {{0.3535533905932738, 1.0606601717798212, -1.0606601717798212, -0.3535533905932738}}
}};

static const std::array<std::array<float, 8>, 2> rbio3p3 = {{
    {{0.0, 0.0, 0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369, 0.0, 0.0}},
    {{-0.06629126073623882, -0.1988737822087165, 0.15467960838455727, 0.9943689110435825, -0.9943689110435825, -0.15467960838455727, 0.1988737822087165, 0.06629126073623882}}
}};

static const std::array<std::array<float, 12>, 2> rbio3p5 = {{
    {{0.0, 0.0, 0.0, 0.0, 0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369, 0.0, 0.0, 0.0, 0.0}},
    {{0.013810679320049757, 0.04143203796014927, -0.052480581416189075, -0.26792717880896527, 0.07181553246425873, 0.966747552403483, -0.966747552403483, -0.07181553246425873, 0.26792717880896527, 0.052480581416189075, -0.04143203796014927, -0.013810679320049757}}
}};

static const std::array<std::array<float, 16>, 2> rbio3p7 = {{
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}},
    {{-0.0030210861012608843, -0.009063258303782653, 0.01683176542131064, 0.074663985074019, -0.03133297870736289, -0.301159125922835, 0.02649924094534547, 0.9516421218971786, -0.9516421218971786, -0.02649924094534547, 0.301159125922835, 0.03133297870736289, -0.074663985074019, -0.01683176542131064, 0.009063258303782653, 0.0030210861012608843}}
}};

static const std::array<std::array<float, 20>, 2> rbio3p9 = {{
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}},
    {{0.0006797443727836989, 0.002039233118351097, -0.005060319219611981, -0.020618912641105536, 0.014112787930175844, 0.09913478249423216, -0.012300136269419315, -0.32019196836077857, -0.0020500227115698858, 0.9421257006782068, -0.9421257006782068, 0.0020500227115698858, 0.32019196836077857, 0.012300136269419315, -0.09913478249423216, -0.014112787930175844, 0.020618912641105536, 0.005060319219611981, -0.002039233118351097, -0.0006797443727836989}}
}};

static const std::array<std::array<float, 10>, 2> rbio4p4 = {{
    {{0.0, 0.0, -0.06453888262869706, -0.04068941760916406, 0.41809227322161724, 0.7884856164055829, 0.41809227322161724, -0.04068941760916406, -0.06453888262869706, 0.0}},
    {{-0.03782845550726404, -0.023849465019556843, 0.11062440441843718, 0.37740285561283066, -0.8526986790088938, 0.37740285561283066, 0.11062440441843718, -0.023849465019556843, -0.03782845550726404, 0.0}}
}};

static const std::array<std::array<float, 12>, 2> rbio5p5 = {{
    {{0.0, 0.013456709459118716, -0.002694966880111507, -0.13670658466432914, -0.09350469740093886, 0.47680326579848425, 0.8995061097486484, 0.47680326579848425, -0.09350469740093886, -0.13670658466432914, -0.002694966880111507, 0.013456709459118716}},
    {{-0.0, 0.03968708834740544, -0.007948108637240322, -0.05446378846823691, -0.34560528195603346, 0.7366601814282105, -0.34560528195603346, -0.05446378846823691, -0.007948108637240322, 0.03968708834740544, -0.0, 0.0}}
}};

static const std::array<std::array<float, 18>, 2> rbio6p8 = {{
    {{0.0, 0.0, 0.0, 0.0, 0.014426282505624435, 0.014467504896790148, -0.07872200106262882, -0.04036797903033992, 0.41784910915027457, 0.7589077294536541, 0.41784910915027457, -0.04036797903033992, -0.07872200106262882, 0.014467504896790148, 0.014426282505624435, 0.0, 0.0, 0.0}},
    {{-0.0019088317364812906, -0.0019142861290887667, 0.016990639867602342, 0.01193456527972926, -0.04973290349094079, -0.07726317316720414, 0.09405920349573646, 0.4207962846098268, -0.8259229974584023, 0.4207962846098268, 0.09405920349573646, -0.07726317316720414, -0.04973290349094079, 0.01193456527972926, 0.016990639867602342, -0.0019142861290887667, -0.0019088317364812906, 0.0}}
}};

static const std::array<std::array<float, 4>, 2> sym2 = {{
    {{-0.12940952255092145, 0.22414386804185735, 0.836516303737469, 0.48296291314469025}},
    {{-0.48296291314469025, 0.836516303737469, -0.22414386804185735, -0.12940952255092145}}
}};

static const std::array<std::array<float, 6>, 2> sym3 = {{
    {{0.035226291882100656, -0.08544127388224149, -0.13501102001039084, 0.4598775021193313, 0.8068915093133388, 0.3326705529509569}},
    {{-0.3326705529509569, 0.8068915093133388, -0.4598775021193313, -0.13501102001039084, 0.08544127388224149, 0.035226291882100656}}
}};

static const std::array<std::array<float, 8>, 2> sym4 = {{
    {{-0.07576571478927333, -0.02963552764599851, 0.49761866763201545, 0.8037387518059161, 0.29785779560527736, -0.09921954357684722, -0.012603967262037833, 0.0322231006040427}},
    {{-0.0322231006040427, -0.012603967262037833, 0.09921954357684722, 0.29785779560527736, -0.8037387518059161, 0.49761866763201545, 0.02963552764599851, -0.07576571478927333}}
}};

static const std::array<std::array<float, 10>, 2> sym5 = {{
    {{0.027333068345077982, 0.029519490925774643, -0.039134249302383094, 0.1993975339773936, 0.7234076904024206, 0.6339789634582119, 0.01660210576452232, -0.17532808990845047, -0.021101834024758855, 0.019538882735286728}},
    {{-0.019538882735286728, -0.021101834024758855, 0.17532808990845047, 0.01660210576452232, -0.6339789634582119, 0.7234076904024206, -0.1993975339773936, -0.039134249302383094, -0.029519490925774643, 0.027333068345077982}}
}};

static const std::array<std::array<float, 12>, 2> sym6 = {{
    {{0.015404109327027373, 0.0034907120842174702, -0.11799011114819057, -0.048311742585633, 0.4910559419267466, 0.787641141030194, 0.3379294217276218, -0.07263752278646252, -0.021060292512300564, 0.04472490177066578, 0.0017677118642428036, -0.007800708325034148}},
    {{0.007800708325034148, 0.0017677118642428036, -0.04472490177066578, -0.021060292512300564, 0.07263752278646252, 0.3379294217276218, -0.787641141030194, 0.4910559419267466, 0.048311742585633, -0.11799011114819057, -0.0034907120842174702, 0.015404109327027373}}
}};

static const std::array<std::array<float, 14>, 2> sym7 = {{
    {{0.002681814568257878, -0.0010473848886829163, -0.01263630340325193, 0.03051551316596357, 0.0678926935013727, -0.049552834937127255, 0.017441255086855827, 0.5361019170917628, 0.767764317003164, 0.2886296317515146, -0.14004724044296152, -0.10780823770381774, 0.004010244871533663, 0.010268176708511255}},
    {{-0.010268176708511255, 0.004010244871533663, 0.10780823770381774, -0.14004724044296152, -0.2886296317515146, 0.767764317003164, -0.5361019170917628, 0.017441255086855827, 0.049552834937127255, 0.0678926935013727, -0.03051551316596357, -0.01263630340325193, 0.0010473848886829163, 0.002681814568257878}}
}};

static const std::array<std::array<float, 16>, 2> sym8 = {{
    {{-0.0033824159510061256, -0.0005421323317911481, 0.03169508781149298, 0.007607487324917605, -0.1432942383508097, -0.061273359067658524, 0.4813596512583722, 0.7771857517005235, 0.3644418948353314, -0.05194583810770904, -0.027219029917056003, 0.049137179673607506, 0.003808752013890615, -0.01495225833704823, -0.0003029205147213668, 0.0018899503327594609}},
    {{-0.0018899503327594609, -0.0003029205147213668, 0.01495225833704823, 0.003808752013890615, -0.049137179673607506, -0.027219029917056003, 0.05194583810770904, 0.3644418948353314, -0.7771857517005235, 0.4813596512583722, 0.061273359067658524, -0.1432942383508097, -0.007607487324917605, 0.03169508781149298, 0.0005421323317911481, -0.0033824159510061256}}
}};

static const std::array<std::array<float, 18>, 2> sym9 = {{
    {{0.0014009155259146807, 0.0006197808889855868, -0.013271967781817119, -0.01152821020767923, 0.03022487885827568, 0.0005834627461258068, -0.05456895843083407, 0.238760914607303, 0.717897082764412, 0.6173384491409358, 0.035272488035271894, -0.19155083129728512, -0.018233770779395985, 0.06207778930288603, 0.008859267493400484, -0.010264064027633142, -0.0004731544986800831, 0.0010694900329086053}},
    {{-0.0010694900329086053, -0.0004731544986800831, 0.010264064027633142, 0.008859267493400484, -0.06207778930288603, -0.018233770779395985, 0.19155083129728512, 0.035272488035271894, -0.6173384491409358, 0.717897082764412, -0.238760914607303, -0.05456895843083407, -0.0005834627461258068, 0.03022487885827568, 0.01152821020767923, -0.013271967781817119, -0.0006197808889855868, 0.0014009155259146807}}
}};

static const std::array<std::array<float, 20>, 2> sym10 = {{
    {{0.0007701598091144901, 9.563267072289475e-05, -0.008641299277022422, -0.0014653825813050513, 0.0459272392310922, 0.011609893903711381, -0.15949427888491757, -0.07088053578324385, 0.47169066693843925, 0.7695100370211071, 0.38382676106708546, -0.03553674047381755, -0.0319900568824278, 0.04999497207737669, 0.005764912033581909, -0.02035493981231129, -0.0008043589320165449, 0.004593173585311828, 5.7036083618494284e-05, -0.0004593294210046588}},
    {{0.0004593294210046588, 5.7036083618494284e-05, -0.004593173585311828, -0.0008043589320165449, 0.02035493981231129, 0.005764912033581909, -0.04999497207737669, -0.0319900568824278, 0.03553674047381755, 0.38382676106708546, -0.7695100370211071, 0.47169066693843925, 0.07088053578324385, -0.15949427888491757, -0.011609893903711381, 0.0459272392310922, 0.0014653825813050513, -0.008641299277022422, -9.563267072289475e-05, 0.0007701598091144901}}
}};

}
}
