#include "edge-impulse-sdk/dsp/config.hpp"
#if EIDSP_LOAD_CMSIS_DSP_SOURCES
/* ----------------------------------------------------------------------
 * Project:      CMSIS DSP Library
 * Title:        arm_mve_tables_f16.c
 * Description:  common tables like fft twiddle factors, Bitreverse, reciprocal etc
 *               used for MVE implementation only
 *
 * $Date:        14. April 2020
 *
 * Target Processor: Cortex-M cores
 * -------------------------------------------------------------------- */
/*
 * Copyright (C) 2010-2020 ARM Limited or its affiliates. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "edge-impulse-sdk/CMSIS/DSP/Include/arm_math_types_f16.h"

#if defined(ARM_FLOAT16_SUPPORTED)

#if defined(ARM_MATH_MVE_FLOAT16) && !defined(ARM_MATH_AUTOVECTORIZE)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_16) || defined(ARM_TABLE_TWIDDLECOEF_F16_32)

uint32_t rearranged_twiddle_tab_stride1_arr_16_f16[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_16_f16[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_16_f16[2]={
0,0,};

float16_t rearranged_twiddle_stride1_16_f16[8]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,};

float16_t rearranged_twiddle_stride2_16_f16[8]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,};

float16_t rearranged_twiddle_stride3_16_f16[8]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_64) || defined(ARM_TABLE_TWIDDLECOEF_F16_128)

uint32_t rearranged_twiddle_tab_stride1_arr_64_f16[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_64_f16[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_64_f16[3]={
0,32,0,};

float16_t rearranged_twiddle_stride1_64_f16[40]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,};

float16_t rearranged_twiddle_stride2_64_f16[40]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.38268343236508972627f,(float16_t)0.92387953251128673848f,
(float16_t)-0.55557023301960195560f,(float16_t)0.83146961230254534669f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.83146961230254534669f,(float16_t)0.55557023301960217765f,
(float16_t)-0.92387953251128673848f,(float16_t)0.38268343236508989280f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,};

float16_t rearranged_twiddle_stride3_64_f16[40]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.99518472667219692873f,(float16_t)-0.09801714032956058975f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,
(float16_t)-0.77301045336273710440f,(float16_t)-0.63439328416364526575f,
(float16_t)-0.55557023301960217765f,(float16_t)-0.83146961230254523567f,
(float16_t)-0.29028467725446244208f,(float16_t)-0.95694033573220882438f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_256) || defined(ARM_TABLE_TWIDDLECOEF_F16_512)

uint32_t rearranged_twiddle_tab_stride1_arr_256_f16[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_256_f16[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_256_f16[4]={
0,128,160,0,};

float16_t rearranged_twiddle_stride1_256_f16[168]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99969881869620424997f,(float16_t)0.02454122852291228812f,
(float16_t)0.99879545620517240501f,(float16_t)0.04906767432741801493f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.99247953459870996706f,(float16_t)0.12241067519921619566f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98527764238894122162f,(float16_t)0.17096188876030121717f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.97003125319454397424f,(float16_t)0.24298017990326387094f,
(float16_t)0.96377606579543984022f,(float16_t)0.26671275747489836538f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.94952818059303667475f,(float16_t)0.31368174039889151761f,
(float16_t)0.94154406518302080631f,(float16_t)0.33688985339222005111f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.91420975570353069095f,(float16_t)0.40524131400498986100f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.89322430119551532446f,(float16_t)0.44961132965460653965f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.85772861000027211809f,(float16_t)0.51410274419322166128f,
(float16_t)0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.81758481315158371139f,(float16_t)0.57580819141784533866f,
(float16_t)0.80320753148064494287f,(float16_t)0.59569930449243335691f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.75720884650648456748f,(float16_t)0.65317284295377675551f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.72424708295146700276f,(float16_t)0.68954054473706682948f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.67155895484701833009f,(float16_t)0.74095112535495910588f,
(float16_t)0.65317284295377686654f,(float16_t)0.75720884650648456748f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.61523159058062681925f,(float16_t)0.78834642762660622761f,
(float16_t)0.59569930449243346793f,(float16_t)0.80320753148064483184f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.53499761988709726435f,(float16_t)0.84485356524970700587f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.49289819222978409341f,(float16_t)0.87008699110871134952f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.42755509343028219593f,(float16_t)0.90398929312344333820f,
(float16_t)0.40524131400498986100f,(float16_t)0.91420975570353069095f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.35989503653498827740f,(float16_t)0.93299279883473884567f,
(float16_t)0.33688985339222005111f,(float16_t)0.94154406518302080631f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.26671275747489842090f,(float16_t)0.96377606579543984022f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.21910124015686976984f,(float16_t)0.97570213003852857003f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.14673047445536174793f,(float16_t)0.98917650996478101444f,
(float16_t)0.12241067519921627893f,(float16_t)0.99247953459870996706f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.07356456359966745406f,(float16_t)0.99729045667869020697f,
(float16_t)0.04906767432741812596f,(float16_t)0.99879545620517240501f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,};

float16_t rearranged_twiddle_stride2_256_f16[168]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99879545620517240501f,(float16_t)0.04906767432741801493f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.97003125319454397424f,(float16_t)0.24298017990326387094f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.94154406518302080631f,(float16_t)0.33688985339222005111f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.85772861000027211809f,(float16_t)0.51410274419322166128f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.80320753148064494287f,(float16_t)0.59569930449243335691f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.67155895484701833009f,(float16_t)0.74095112535495910588f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.59569930449243346793f,(float16_t)0.80320753148064483184f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.42755509343028219593f,(float16_t)0.90398929312344333820f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.33688985339222005111f,(float16_t)0.94154406518302080631f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.14673047445536174793f,(float16_t)0.98917650996478101444f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.04906767432741812596f,(float16_t)0.99879545620517240501f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.04906767432741800800f,(float16_t)0.99879545620517240501f,
(float16_t)-0.09801714032956064526f,(float16_t)0.99518472667219692873f,
(float16_t)-0.14673047445536163691f,(float16_t)0.98917650996478101444f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.24298017990326387094f,(float16_t)0.97003125319454397424f,
(float16_t)-0.29028467725446216452f,(float16_t)0.95694033573220893540f,
(float16_t)-0.33688985339221994009f,(float16_t)0.94154406518302080631f,
(float16_t)-0.38268343236508972627f,(float16_t)0.92387953251128673848f,
(float16_t)-0.42755509343028186287f,(float16_t)0.90398929312344344922f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.51410274419322155026f,(float16_t)0.85772861000027211809f,
(float16_t)-0.55557023301960195560f,(float16_t)0.83146961230254534669f,
(float16_t)-0.59569930449243335691f,(float16_t)0.80320753148064494287f,
(float16_t)-0.63439328416364537677f,(float16_t)0.77301045336273710440f,
(float16_t)-0.67155895484701844111f,(float16_t)0.74095112535495899486f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.74095112535495888384f,(float16_t)0.67155895484701855214f,
(float16_t)-0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)-0.80320753148064483184f,(float16_t)0.59569930449243346793f,
(float16_t)-0.83146961230254534669f,(float16_t)0.55557023301960217765f,
(float16_t)-0.85772861000027200706f,(float16_t)0.51410274419322177231f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.90398929312344333820f,(float16_t)0.42755509343028202940f,
(float16_t)-0.92387953251128673848f,(float16_t)0.38268343236508989280f,
(float16_t)-0.94154406518302069529f,(float16_t)0.33688985339222032867f,
(float16_t)-0.95694033573220882438f,(float16_t)0.29028467725446238656f,
(float16_t)-0.97003125319454397424f,(float16_t)0.24298017990326406523f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.98917650996478101444f,(float16_t)0.14673047445536180344f,
(float16_t)-0.99518472667219681771f,(float16_t)0.09801714032956082567f,
(float16_t)-0.99879545620517240501f,(float16_t)0.04906767432741796636f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.38268343236508972627f,(float16_t)0.92387953251128673848f,
(float16_t)-0.55557023301960195560f,(float16_t)0.83146961230254534669f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.83146961230254534669f,(float16_t)0.55557023301960217765f,
(float16_t)-0.92387953251128673848f,(float16_t)0.38268343236508989280f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,};

float16_t rearranged_twiddle_stride3_256_f16[168]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)-0.04906767432741800800f,(float16_t)0.99879545620517240501f,
(float16_t)-0.12241067519921615403f,(float16_t)0.99247953459870996706f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.26671275747489830987f,(float16_t)0.96377606579543984022f,
(float16_t)-0.33688985339221994009f,(float16_t)0.94154406518302080631f,
(float16_t)-0.40524131400498974998f,(float16_t)0.91420975570353069095f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.53499761988709704230f,(float16_t)0.84485356524970722791f,
(float16_t)-0.59569930449243335691f,(float16_t)0.80320753148064494287f,
(float16_t)-0.65317284295377653347f,(float16_t)0.75720884650648467851f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.75720884650648467851f,(float16_t)0.65317284295377664449f,
(float16_t)-0.80320753148064483184f,(float16_t)0.59569930449243346793f,
(float16_t)-0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.91420975570353069095f,(float16_t)0.40524131400498991651f,
(float16_t)-0.94154406518302069529f,(float16_t)0.33688985339222032867f,
(float16_t)-0.96377606579543984022f,(float16_t)0.26671275747489847641f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.99247953459870996706f,(float16_t)0.12241067519921634832f,
(float16_t)-0.99879545620517240501f,(float16_t)0.04906767432741796636f,
(float16_t)-0.99969881869620424997f,(float16_t)-0.02454122852291207996f,
(float16_t)-0.99518472667219692873f,(float16_t)-0.09801714032956058975f,
(float16_t)-0.98527764238894133264f,(float16_t)-0.17096188876030096737f,
(float16_t)-0.97003125319454397424f,(float16_t)-0.24298017990326381543f,
(float16_t)-0.94952818059303678577f,(float16_t)-0.31368174039889118454f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,
(float16_t)-0.89322430119551532446f,(float16_t)-0.44961132965460665067f,
(float16_t)-0.85772861000027211809f,(float16_t)-0.51410274419322155026f,
(float16_t)-0.81758481315158371139f,(float16_t)-0.57580819141784533866f,
(float16_t)-0.77301045336273710440f,(float16_t)-0.63439328416364526575f,
(float16_t)-0.72424708295146700276f,(float16_t)-0.68954054473706682948f,
(float16_t)-0.67155895484701866316f,(float16_t)-0.74095112535495888384f,
(float16_t)-0.61523159058062726334f,(float16_t)-0.78834642762660589455f,
(float16_t)-0.55557023301960217765f,(float16_t)-0.83146961230254523567f,
(float16_t)-0.49289819222978420443f,(float16_t)-0.87008699110871134952f,
(float16_t)-0.42755509343028247349f,(float16_t)-0.90398929312344311615f,
(float16_t)-0.35989503653498794433f,(float16_t)-0.93299279883473895669f,
(float16_t)-0.29028467725446244208f,(float16_t)-0.95694033573220882438f,
(float16_t)-0.21910124015687010290f,(float16_t)-0.97570213003852845901f,
(float16_t)-0.14673047445536230304f,(float16_t)-0.98917650996478090342f,
(float16_t)-0.07356456359966735692f,(float16_t)-0.99729045667869020697f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.99518472667219692873f,(float16_t)-0.09801714032956058975f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,
(float16_t)-0.77301045336273710440f,(float16_t)-0.63439328416364526575f,
(float16_t)-0.55557023301960217765f,(float16_t)-0.83146961230254523567f,
(float16_t)-0.29028467725446244208f,(float16_t)-0.95694033573220882438f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_1024) || defined(ARM_TABLE_TWIDDLECOEF_F16_2048)

uint32_t rearranged_twiddle_tab_stride1_arr_1024_f16[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_1024_f16[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_1024_f16[5]={
0,512,640,672,0,};

float16_t rearranged_twiddle_stride1_1024_f16[680]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99998117528260110909f,(float16_t)0.00613588464915447527f,
(float16_t)0.99992470183914450299f,(float16_t)0.01227153828571992539f,
(float16_t)0.99983058179582340319f,(float16_t)0.01840672990580482019f,
(float16_t)0.99969881869620424997f,(float16_t)0.02454122852291228812f,
(float16_t)0.99952941750109314256f,(float16_t)0.03067480317663662595f,
(float16_t)0.99932238458834954375f,(float16_t)0.03680722294135883171f,
(float16_t)0.99907772775264536147f,(float16_t)0.04293825693494082024f,
(float16_t)0.99879545620517240501f,(float16_t)0.04906767432741801493f,
(float16_t)0.99847558057329477421f,(float16_t)0.05519524434968993420f,
(float16_t)0.99811811290014917919f,(float16_t)0.06132073630220857829f,
(float16_t)0.99772306664419163624f,(float16_t)0.06744391956366405094f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.99682029929116566791f,(float16_t)0.07968243797143012563f,
(float16_t)0.99631261218277800129f,(float16_t)0.08579731234443989385f,
(float16_t)0.99576741446765981713f,(float16_t)0.09190895649713272386f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.99456457073425541537f,(float16_t)0.10412163387205458642f,
(float16_t)0.99390697000235606051f,(float16_t)0.11022220729388305938f,
(float16_t)0.99321194923479450001f,(float16_t)0.11631863091190475235f,
(float16_t)0.99247953459870996706f,(float16_t)0.12241067519921619566f,
(float16_t)0.99170975366909952520f,(float16_t)0.12849811079379316880f,
(float16_t)0.99090263542778000971f,(float16_t)0.13458070850712616773f,
(float16_t)0.99005821026229712256f,(float16_t)0.14065823933284921088f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98825756773074946437f,(float16_t)0.15279718525844343535f,
(float16_t)0.98730141815785843473f,(float16_t)0.15885814333386144570f,
(float16_t)0.98630809724459866938f,(float16_t)0.16491312048996989437f,
(float16_t)0.98527764238894122162f,(float16_t)0.17096188876030121717f,
(float16_t)0.98421009238692902521f,(float16_t)0.17700422041214874946f,
(float16_t)0.98310548743121628501f,(float16_t)0.18303988795514095078f,
(float16_t)0.98196386910955524296f,(float16_t)0.18906866414980619262f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.97956976568544051887f,(float16_t)0.20110463484209190055f,
(float16_t)0.97831737071962765473f,(float16_t)0.20711137619221856032f,
(float16_t)0.97702814265775439484f,(float16_t)0.21311031991609136194f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.97433938278557585821f,(float16_t)0.22508391135979283204f,
(float16_t)0.97293995220556017678f,(float16_t)0.23105810828067110951f,
(float16_t)0.97150389098625178352f,(float16_t)0.23702360599436719801f,
(float16_t)0.97003125319454397424f,(float16_t)0.24298017990326387094f,
(float16_t)0.96852209427441737777f,(float16_t)0.24892760574572014853f,
(float16_t)0.96697647104485207059f,(float16_t)0.25486565960451457169f,
(float16_t)0.96539444169768939830f,(float16_t)0.26079411791527551401f,
(float16_t)0.96377606579543984022f,(float16_t)0.26671275747489836538f,
(float16_t)0.96212140426904158019f,(float16_t)0.27262135544994897662f,
(float16_t)0.96043051941556578655f,(float16_t)0.27851968938505305973f,
(float16_t)0.95870347489587159906f,(float16_t)0.28440753721127187692f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.95514116830577078243f,(float16_t)0.29615088824362378883f,
(float16_t)0.95330604035419386211f,(float16_t)0.30200594931922808417f,
(float16_t)0.95143502096900833820f,(float16_t)0.30784964004153486661f,
(float16_t)0.94952818059303667475f,(float16_t)0.31368174039889151761f,
(float16_t)0.94758559101774109124f,(float16_t)0.31950203081601569188f,
(float16_t)0.94560732538052127971f,(float16_t)0.32531029216226292622f,
(float16_t)0.94359345816196038559f,(float16_t)0.33110630575987642921f,
(float16_t)0.94154406518302080631f,(float16_t)0.33688985339222005111f,
(float16_t)0.93945922360218991898f,(float16_t)0.34266071731199437833f,
(float16_t)0.93733901191257495977f,(float16_t)0.34841868024943456472f,
(float16_t)0.93518350993894761025f,(float16_t)0.35416352542049034380f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.93076696107898371224f,(float16_t)0.36561299780477385379f,
(float16_t)0.92850608047321558924f,(float16_t)0.37131719395183754306f,
(float16_t)0.92621024213831137928f,(float16_t)0.37700741021641825945f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.92151403934204190183f,(float16_t)0.38834504669882624617f,
(float16_t)0.91911385169005777040f,(float16_t)0.39399204006104809883f,
(float16_t)0.91667905992104270485f,(float16_t)0.39962419984564678810f,
(float16_t)0.91420975570353069095f,(float16_t)0.40524131400498986100f,
(float16_t)0.91170603200542987832f,(float16_t)0.41084317105790391089f,
(float16_t)0.90916798309052238025f,(float16_t)0.41642956009763715253f,
(float16_t)0.90659570451491533483f,(float16_t)0.42200027079979968159f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.90134884704602202810f,(float16_t)0.43309381885315195726f,
(float16_t)0.89867446569395381673f,(float16_t)0.43861623853852765853f,
(float16_t)0.89596624975618521791f,(float16_t)0.44412214457042920035f,
(float16_t)0.89322430119551532446f,(float16_t)0.44961132965460653965f,
(float16_t)0.89044872324475787817f,(float16_t)0.45508358712634383592f,
(float16_t)0.88763962040285393496f,(float16_t)0.46053871095824000514f,
(float16_t)0.88479709843093778954f,(float16_t)0.46597649576796618121f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.87901222642863352519f,(float16_t)0.47679923006332208812f,
(float16_t)0.87607009419540660122f,(float16_t)0.48218377207912271887f,
(float16_t)0.87309497841829009079f,(float16_t)0.48755016014843599592f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.86704624551569264845f,(float16_t)0.49822766697278181303f,
(float16_t)0.86397285612158669643f,(float16_t)0.50353838372571757542f,
(float16_t)0.86086693863776730939f,(float16_t)0.50883014254310698909f,
(float16_t)0.85772861000027211809f,(float16_t)0.51410274419322166128f,
(float16_t)0.85455798836540053376f,(float16_t)0.51935599016558964269f,
(float16_t)0.85135519310526519554f,(float16_t)0.52458968267846894928f,
(float16_t)0.84812034480329723252f,(float16_t)0.52980362468629460526f,
(float16_t)0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)0.84155497743689844370f,(float16_t)0.54017147272989285423f,
(float16_t)0.83822470555483807875f,(float16_t)0.54532498842204646383f,
(float16_t)0.83486287498638001026f,(float16_t)0.55045797293660481131f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.82804504525775579626f,(float16_t)0.56066157619733603124f,
(float16_t)0.82458930278502529099f,(float16_t)0.56573181078361312046f,
(float16_t)0.82110251499110464835f,(float16_t)0.57078074588696725566f,
(float16_t)0.81758481315158371139f,(float16_t)0.57580819141784533866f,
(float16_t)0.81403632970594841378f,(float16_t)0.58081395809576452649f,
(float16_t)0.81045719825259476821f,(float16_t)0.58579785745643886408f,
(float16_t)0.80684755354379933401f,(float16_t)0.59075970185887416442f,
(float16_t)0.80320753148064494287f,(float16_t)0.59569930449243335691f,
(float16_t)0.79953726910790501314f,(float16_t)0.60061647938386897305f,
(float16_t)0.79583690460888356633f,(float16_t)0.60551104140432554512f,
(float16_t)0.79210657730021238887f,(float16_t)0.61038280627630947528f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.78455659715557524159f,(float16_t)0.62005721176328909561f,
(float16_t)0.78073722857209448822f,(float16_t)0.62485948814238634341f,
(float16_t)0.77688846567323244230f,(float16_t)0.62963823891492698426f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.76910333764557969882f,(float16_t)0.63912444486377573138f,
(float16_t)0.76516726562245895860f,(float16_t)0.64383154288979138613f,
(float16_t)0.76120238548426177871f,(float16_t)0.64851440102211244110f,
(float16_t)0.75720884650648456748f,(float16_t)0.65317284295377675551f,
(float16_t)0.75318679904361252042f,(float16_t)0.65780669329707863735f,
(float16_t)0.74913639452345937020f,(float16_t)0.66241577759017178373f,
(float16_t)0.74505778544146594733f,(float16_t)0.66699992230363747137f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.73681656887736979300f,(float16_t)0.67609270357531592310f,
(float16_t)0.73265427167241281570f,(float16_t)0.68060099779545302212f,
(float16_t)0.72846439044822519637f,(float16_t)0.68508366777270035541f,
(float16_t)0.72424708295146700276f,(float16_t)0.68954054473706682948f,
(float16_t)0.72000250796138165477f,(float16_t)0.69397146088965389055f,
(float16_t)0.71573082528381870571f,(float16_t)0.69837624940897280457f,
(float16_t)0.71143219574521643356f,(float16_t)0.70275474445722529993f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.70275474445722529993f,(float16_t)0.71143219574521643356f,
(float16_t)0.69837624940897291559f,(float16_t)0.71573082528381859468f,
(float16_t)0.69397146088965400157f,(float16_t)0.72000250796138165477f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.68508366777270035541f,(float16_t)0.72846439044822519637f,
(float16_t)0.68060099779545302212f,(float16_t)0.73265427167241281570f,
(float16_t)0.67609270357531603413f,(float16_t)0.73681656887736979300f,
(float16_t)0.67155895484701833009f,(float16_t)0.74095112535495910588f,
(float16_t)0.66699992230363747137f,(float16_t)0.74505778544146594733f,
(float16_t)0.66241577759017178373f,(float16_t)0.74913639452345925918f,
(float16_t)0.65780669329707874837f,(float16_t)0.75318679904361252042f,
(float16_t)0.65317284295377686654f,(float16_t)0.75720884650648456748f,
(float16_t)0.64851440102211255212f,(float16_t)0.76120238548426177871f,
(float16_t)0.64383154288979149715f,(float16_t)0.76516726562245895860f,
(float16_t)0.63912444486377573138f,(float16_t)0.76910333764557958780f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.62963823891492709528f,(float16_t)0.77688846567323244230f,
(float16_t)0.62485948814238645443f,(float16_t)0.78073722857209448822f,
(float16_t)0.62005721176328920663f,(float16_t)0.78455659715557524159f,
(float16_t)0.61523159058062681925f,(float16_t)0.78834642762660622761f,
(float16_t)0.61038280627630947528f,(float16_t)0.79210657730021227785f,
(float16_t)0.60551104140432554512f,(float16_t)0.79583690460888345530f,
(float16_t)0.60061647938386897305f,(float16_t)0.79953726910790501314f,
(float16_t)0.59569930449243346793f,(float16_t)0.80320753148064483184f,
(float16_t)0.59075970185887427544f,(float16_t)0.80684755354379922299f,
(float16_t)0.58579785745643886408f,(float16_t)0.81045719825259476821f,
(float16_t)0.58081395809576452649f,(float16_t)0.81403632970594830276f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.57078074588696736669f,(float16_t)0.82110251499110464835f,
(float16_t)0.56573181078361323149f,(float16_t)0.82458930278502529099f,
(float16_t)0.56066157619733603124f,(float16_t)0.82804504525775579626f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.55045797293660481131f,(float16_t)0.83486287498638001026f,
(float16_t)0.54532498842204646383f,(float16_t)0.83822470555483796772f,
(float16_t)0.54017147272989296525f,(float16_t)0.84155497743689833268f,
(float16_t)0.53499761988709726435f,(float16_t)0.84485356524970700587f,
(float16_t)0.52980362468629482731f,(float16_t)0.84812034480329712149f,
(float16_t)0.52458968267846883826f,(float16_t)0.85135519310526519554f,
(float16_t)0.51935599016558953167f,(float16_t)0.85455798836540053376f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.50883014254310698909f,(float16_t)0.86086693863776730939f,
(float16_t)0.50353838372571757542f,(float16_t)0.86397285612158669643f,
(float16_t)0.49822766697278186854f,(float16_t)0.86704624551569264845f,
(float16_t)0.49289819222978409341f,(float16_t)0.87008699110871134952f,
(float16_t)0.48755016014843605143f,(float16_t)0.87309497841829009079f,
(float16_t)0.48218377207912282989f,(float16_t)0.87607009419540660122f,
(float16_t)0.47679923006332225466f,(float16_t)0.87901222642863341417f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.46597649576796612569f,(float16_t)0.88479709843093778954f,
(float16_t)0.46053871095824000514f,(float16_t)0.88763962040285393496f,
(float16_t)0.45508358712634383592f,(float16_t)0.89044872324475787817f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.44412214457042925586f,(float16_t)0.89596624975618510689f,
(float16_t)0.43861623853852771404f,(float16_t)0.89867446569395381673f,
(float16_t)0.43309381885315201277f,(float16_t)0.90134884704602202810f,
(float16_t)0.42755509343028219593f,(float16_t)0.90398929312344333820f,
(float16_t)0.42200027079979979261f,(float16_t)0.90659570451491533483f,
(float16_t)0.41642956009763731906f,(float16_t)0.90916798309052226923f,
(float16_t)0.41084317105790391089f,(float16_t)0.91170603200542987832f,
(float16_t)0.40524131400498986100f,(float16_t)0.91420975570353069095f,
(float16_t)0.39962419984564678810f,(float16_t)0.91667905992104270485f,
(float16_t)0.39399204006104809883f,(float16_t)0.91911385169005777040f,
(float16_t)0.38834504669882630168f,(float16_t)0.92151403934204190183f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.37700741021641831496f,(float16_t)0.92621024213831126826f,
(float16_t)0.37131719395183759858f,(float16_t)0.92850608047321558924f,
(float16_t)0.36561299780477396482f,(float16_t)0.93076696107898371224f,
(float16_t)0.35989503653498827740f,(float16_t)0.93299279883473884567f,
(float16_t)0.35416352542049051033f,(float16_t)0.93518350993894749923f,
(float16_t)0.34841868024943450921f,(float16_t)0.93733901191257495977f,
(float16_t)0.34266071731199437833f,(float16_t)0.93945922360218991898f,
(float16_t)0.33688985339222005111f,(float16_t)0.94154406518302080631f,
(float16_t)0.33110630575987642921f,(float16_t)0.94359345816196038559f,
(float16_t)0.32531029216226298173f,(float16_t)0.94560732538052127971f,
(float16_t)0.31950203081601574739f,(float16_t)0.94758559101774109124f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.30784964004153497763f,(float16_t)0.95143502096900833820f,
(float16_t)0.30200594931922819519f,(float16_t)0.95330604035419375109f,
(float16_t)0.29615088824362395536f,(float16_t)0.95514116830577067141f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.28440753721127182141f,(float16_t)0.95870347489587159906f,
(float16_t)0.27851968938505305973f,(float16_t)0.96043051941556578655f,
(float16_t)0.27262135544994897662f,(float16_t)0.96212140426904158019f,
(float16_t)0.26671275747489842090f,(float16_t)0.96377606579543984022f,
(float16_t)0.26079411791527556952f,(float16_t)0.96539444169768939830f,
(float16_t)0.25486565960451462720f,(float16_t)0.96697647104485207059f,
(float16_t)0.24892760574572025956f,(float16_t)0.96852209427441726675f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.23702360599436733679f,(float16_t)0.97150389098625178352f,
(float16_t)0.23105810828067127605f,(float16_t)0.97293995220556006576f,
(float16_t)0.22508391135979277653f,(float16_t)0.97433938278557585821f,
(float16_t)0.21910124015686976984f,(float16_t)0.97570213003852857003f,
(float16_t)0.21311031991609136194f,(float16_t)0.97702814265775439484f,
(float16_t)0.20711137619221856032f,(float16_t)0.97831737071962765473f,
(float16_t)0.20110463484209195606f,(float16_t)0.97956976568544051887f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.18906866414980627589f,(float16_t)0.98196386910955524296f,
(float16_t)0.18303988795514106180f,(float16_t)0.98310548743121628501f,
(float16_t)0.17700422041214886049f,(float16_t)0.98421009238692902521f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.16491312048997008866f,(float16_t)0.98630809724459866938f,
(float16_t)0.15885814333386139019f,(float16_t)0.98730141815785843473f,
(float16_t)0.15279718525844340760f,(float16_t)0.98825756773074946437f,
(float16_t)0.14673047445536174793f,(float16_t)0.98917650996478101444f,
(float16_t)0.14065823933284923863f,(float16_t)0.99005821026229712256f,
(float16_t)0.13458070850712622324f,(float16_t)0.99090263542778000971f,
(float16_t)0.12849811079379322432f,(float16_t)0.99170975366909952520f,
(float16_t)0.12241067519921627893f,(float16_t)0.99247953459870996706f,
(float16_t)0.11631863091190487725f,(float16_t)0.99321194923479450001f,
(float16_t)0.11022220729388318428f,(float16_t)0.99390697000235606051f,
(float16_t)0.10412163387205472520f,(float16_t)0.99456457073425541537f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.09190895649713269611f,(float16_t)0.99576741446765981713f,
(float16_t)0.08579731234443987997f,(float16_t)0.99631261218277800129f,
(float16_t)0.07968243797143012563f,(float16_t)0.99682029929116566791f,
(float16_t)0.07356456359966745406f,(float16_t)0.99729045667869020697f,
(float16_t)0.06744391956366410645f,(float16_t)0.99772306664419163624f,
(float16_t)0.06132073630220864768f,(float16_t)0.99811811290014917919f,
(float16_t)0.05519524434969003135f,(float16_t)0.99847558057329477421f,
(float16_t)0.04906767432741812596f,(float16_t)0.99879545620517240501f,
(float16_t)0.04293825693494095902f,(float16_t)0.99907772775264536147f,
(float16_t)0.03680722294135899131f,(float16_t)0.99932238458834954375f,
(float16_t)0.03067480317663658085f,(float16_t)0.99952941750109314256f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)0.01840672990580482019f,(float16_t)0.99983058179582340319f,
(float16_t)0.01227153828571994447f,(float16_t)0.99992470183914450299f,
(float16_t)0.00613588464915451517f,(float16_t)0.99998117528260110909f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99969881869620424997f,(float16_t)0.02454122852291228812f,
(float16_t)0.99879545620517240501f,(float16_t)0.04906767432741801493f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.99247953459870996706f,(float16_t)0.12241067519921619566f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98527764238894122162f,(float16_t)0.17096188876030121717f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.97003125319454397424f,(float16_t)0.24298017990326387094f,
(float16_t)0.96377606579543984022f,(float16_t)0.26671275747489836538f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.94952818059303667475f,(float16_t)0.31368174039889151761f,
(float16_t)0.94154406518302080631f,(float16_t)0.33688985339222005111f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.91420975570353069095f,(float16_t)0.40524131400498986100f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.89322430119551532446f,(float16_t)0.44961132965460653965f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.85772861000027211809f,(float16_t)0.51410274419322166128f,
(float16_t)0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.81758481315158371139f,(float16_t)0.57580819141784533866f,
(float16_t)0.80320753148064494287f,(float16_t)0.59569930449243335691f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.75720884650648456748f,(float16_t)0.65317284295377675551f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.72424708295146700276f,(float16_t)0.68954054473706682948f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.67155895484701833009f,(float16_t)0.74095112535495910588f,
(float16_t)0.65317284295377686654f,(float16_t)0.75720884650648456748f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.61523159058062681925f,(float16_t)0.78834642762660622761f,
(float16_t)0.59569930449243346793f,(float16_t)0.80320753148064483184f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.53499761988709726435f,(float16_t)0.84485356524970700587f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.49289819222978409341f,(float16_t)0.87008699110871134952f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.42755509343028219593f,(float16_t)0.90398929312344333820f,
(float16_t)0.40524131400498986100f,(float16_t)0.91420975570353069095f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.35989503653498827740f,(float16_t)0.93299279883473884567f,
(float16_t)0.33688985339222005111f,(float16_t)0.94154406518302080631f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.26671275747489842090f,(float16_t)0.96377606579543984022f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.21910124015686976984f,(float16_t)0.97570213003852857003f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.14673047445536174793f,(float16_t)0.98917650996478101444f,
(float16_t)0.12241067519921627893f,(float16_t)0.99247953459870996706f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.07356456359966745406f,(float16_t)0.99729045667869020697f,
(float16_t)0.04906767432741812596f,(float16_t)0.99879545620517240501f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,};

float16_t rearranged_twiddle_stride2_1024_f16[680]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99992470183914450299f,(float16_t)0.01227153828571992539f,
(float16_t)0.99969881869620424997f,(float16_t)0.02454122852291228812f,
(float16_t)0.99932238458834954375f,(float16_t)0.03680722294135883171f,
(float16_t)0.99879545620517240501f,(float16_t)0.04906767432741801493f,
(float16_t)0.99811811290014917919f,(float16_t)0.06132073630220857829f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.99631261218277800129f,(float16_t)0.08579731234443989385f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.99390697000235606051f,(float16_t)0.11022220729388305938f,
(float16_t)0.99247953459870996706f,(float16_t)0.12241067519921619566f,
(float16_t)0.99090263542778000971f,(float16_t)0.13458070850712616773f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98730141815785843473f,(float16_t)0.15885814333386144570f,
(float16_t)0.98527764238894122162f,(float16_t)0.17096188876030121717f,
(float16_t)0.98310548743121628501f,(float16_t)0.18303988795514095078f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.97831737071962765473f,(float16_t)0.20711137619221856032f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.97293995220556017678f,(float16_t)0.23105810828067110951f,
(float16_t)0.97003125319454397424f,(float16_t)0.24298017990326387094f,
(float16_t)0.96697647104485207059f,(float16_t)0.25486565960451457169f,
(float16_t)0.96377606579543984022f,(float16_t)0.26671275747489836538f,
(float16_t)0.96043051941556578655f,(float16_t)0.27851968938505305973f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.95330604035419386211f,(float16_t)0.30200594931922808417f,
(float16_t)0.94952818059303667475f,(float16_t)0.31368174039889151761f,
(float16_t)0.94560732538052127971f,(float16_t)0.32531029216226292622f,
(float16_t)0.94154406518302080631f,(float16_t)0.33688985339222005111f,
(float16_t)0.93733901191257495977f,(float16_t)0.34841868024943456472f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.92850608047321558924f,(float16_t)0.37131719395183754306f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.91911385169005777040f,(float16_t)0.39399204006104809883f,
(float16_t)0.91420975570353069095f,(float16_t)0.40524131400498986100f,
(float16_t)0.90916798309052238025f,(float16_t)0.41642956009763715253f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.89867446569395381673f,(float16_t)0.43861623853852765853f,
(float16_t)0.89322430119551532446f,(float16_t)0.44961132965460653965f,
(float16_t)0.88763962040285393496f,(float16_t)0.46053871095824000514f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.87607009419540660122f,(float16_t)0.48218377207912271887f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.86397285612158669643f,(float16_t)0.50353838372571757542f,
(float16_t)0.85772861000027211809f,(float16_t)0.51410274419322166128f,
(float16_t)0.85135519310526519554f,(float16_t)0.52458968267846894928f,
(float16_t)0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)0.83822470555483807875f,(float16_t)0.54532498842204646383f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.82458930278502529099f,(float16_t)0.56573181078361312046f,
(float16_t)0.81758481315158371139f,(float16_t)0.57580819141784533866f,
(float16_t)0.81045719825259476821f,(float16_t)0.58579785745643886408f,
(float16_t)0.80320753148064494287f,(float16_t)0.59569930449243335691f,
(float16_t)0.79583690460888356633f,(float16_t)0.60551104140432554512f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.78073722857209448822f,(float16_t)0.62485948814238634341f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.76516726562245895860f,(float16_t)0.64383154288979138613f,
(float16_t)0.75720884650648456748f,(float16_t)0.65317284295377675551f,
(float16_t)0.74913639452345937020f,(float16_t)0.66241577759017178373f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.73265427167241281570f,(float16_t)0.68060099779545302212f,
(float16_t)0.72424708295146700276f,(float16_t)0.68954054473706682948f,
(float16_t)0.71573082528381870571f,(float16_t)0.69837624940897280457f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.69837624940897291559f,(float16_t)0.71573082528381859468f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.68060099779545302212f,(float16_t)0.73265427167241281570f,
(float16_t)0.67155895484701833009f,(float16_t)0.74095112535495910588f,
(float16_t)0.66241577759017178373f,(float16_t)0.74913639452345925918f,
(float16_t)0.65317284295377686654f,(float16_t)0.75720884650648456748f,
(float16_t)0.64383154288979149715f,(float16_t)0.76516726562245895860f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.62485948814238645443f,(float16_t)0.78073722857209448822f,
(float16_t)0.61523159058062681925f,(float16_t)0.78834642762660622761f,
(float16_t)0.60551104140432554512f,(float16_t)0.79583690460888345530f,
(float16_t)0.59569930449243346793f,(float16_t)0.80320753148064483184f,
(float16_t)0.58579785745643886408f,(float16_t)0.81045719825259476821f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.56573181078361323149f,(float16_t)0.82458930278502529099f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.54532498842204646383f,(float16_t)0.83822470555483796772f,
(float16_t)0.53499761988709726435f,(float16_t)0.84485356524970700587f,
(float16_t)0.52458968267846883826f,(float16_t)0.85135519310526519554f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.50353838372571757542f,(float16_t)0.86397285612158669643f,
(float16_t)0.49289819222978409341f,(float16_t)0.87008699110871134952f,
(float16_t)0.48218377207912282989f,(float16_t)0.87607009419540660122f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.46053871095824000514f,(float16_t)0.88763962040285393496f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.43861623853852771404f,(float16_t)0.89867446569395381673f,
(float16_t)0.42755509343028219593f,(float16_t)0.90398929312344333820f,
(float16_t)0.41642956009763731906f,(float16_t)0.90916798309052226923f,
(float16_t)0.40524131400498986100f,(float16_t)0.91420975570353069095f,
(float16_t)0.39399204006104809883f,(float16_t)0.91911385169005777040f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.37131719395183759858f,(float16_t)0.92850608047321558924f,
(float16_t)0.35989503653498827740f,(float16_t)0.93299279883473884567f,
(float16_t)0.34841868024943450921f,(float16_t)0.93733901191257495977f,
(float16_t)0.33688985339222005111f,(float16_t)0.94154406518302080631f,
(float16_t)0.32531029216226298173f,(float16_t)0.94560732538052127971f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.30200594931922819519f,(float16_t)0.95330604035419375109f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.27851968938505305973f,(float16_t)0.96043051941556578655f,
(float16_t)0.26671275747489842090f,(float16_t)0.96377606579543984022f,
(float16_t)0.25486565960451462720f,(float16_t)0.96697647104485207059f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.23105810828067127605f,(float16_t)0.97293995220556006576f,
(float16_t)0.21910124015686976984f,(float16_t)0.97570213003852857003f,
(float16_t)0.20711137619221856032f,(float16_t)0.97831737071962765473f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.18303988795514106180f,(float16_t)0.98310548743121628501f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.15885814333386139019f,(float16_t)0.98730141815785843473f,
(float16_t)0.14673047445536174793f,(float16_t)0.98917650996478101444f,
(float16_t)0.13458070850712622324f,(float16_t)0.99090263542778000971f,
(float16_t)0.12241067519921627893f,(float16_t)0.99247953459870996706f,
(float16_t)0.11022220729388318428f,(float16_t)0.99390697000235606051f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.08579731234443987997f,(float16_t)0.99631261218277800129f,
(float16_t)0.07356456359966745406f,(float16_t)0.99729045667869020697f,
(float16_t)0.06132073630220864768f,(float16_t)0.99811811290014917919f,
(float16_t)0.04906767432741812596f,(float16_t)0.99879545620517240501f,
(float16_t)0.03680722294135899131f,(float16_t)0.99932238458834954375f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)0.01227153828571994447f,(float16_t)0.99992470183914450299f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.01227153828571982304f,(float16_t)0.99992470183914450299f,
(float16_t)-0.02454122852291214241f,(float16_t)0.99969881869620424997f,
(float16_t)-0.03680722294135886641f,(float16_t)0.99932238458834954375f,
(float16_t)-0.04906767432741800800f,(float16_t)0.99879545620517240501f,
(float16_t)-0.06132073630220852972f,(float16_t)0.99811811290014917919f,
(float16_t)-0.07356456359966732916f,(float16_t)0.99729045667869020697f,
(float16_t)-0.08579731234443975507f,(float16_t)0.99631261218277800129f,
(float16_t)-0.09801714032956064526f,(float16_t)0.99518472667219692873f,
(float16_t)-0.11022220729388305938f,(float16_t)0.99390697000235606051f,
(float16_t)-0.12241067519921615403f,(float16_t)0.99247953459870996706f,
(float16_t)-0.13458070850712611222f,(float16_t)0.99090263542778000971f,
(float16_t)-0.14673047445536163691f,(float16_t)0.98917650996478101444f,
(float16_t)-0.15885814333386127917f,(float16_t)0.98730141815785843473f,
(float16_t)-0.17096188876030124493f,(float16_t)0.98527764238894122162f,
(float16_t)-0.18303988795514092303f,(float16_t)0.98310548743121628501f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.20711137619221844930f,(float16_t)0.97831737071962765473f,
(float16_t)-0.21910124015686965881f,(float16_t)0.97570213003852857003f,
(float16_t)-0.23105810828067113727f,(float16_t)0.97293995220556017678f,
(float16_t)-0.24298017990326387094f,(float16_t)0.97003125319454397424f,
(float16_t)-0.25486565960451451618f,(float16_t)0.96697647104485207059f,
(float16_t)-0.26671275747489830987f,(float16_t)0.96377606579543984022f,
(float16_t)-0.27851968938505294870f,(float16_t)0.96043051941556589757f,
(float16_t)-0.29028467725446216452f,(float16_t)0.95694033573220893540f,
(float16_t)-0.30200594931922808417f,(float16_t)0.95330604035419386211f,
(float16_t)-0.31368174039889140658f,(float16_t)0.94952818059303667475f,
(float16_t)-0.32531029216226287071f,(float16_t)0.94560732538052139073f,
(float16_t)-0.33688985339221994009f,(float16_t)0.94154406518302080631f,
(float16_t)-0.34841868024943439819f,(float16_t)0.93733901191257495977f,
(float16_t)-0.35989503653498816638f,(float16_t)0.93299279883473884567f,
(float16_t)-0.37131719395183748755f,(float16_t)0.92850608047321558924f,
(float16_t)-0.38268343236508972627f,(float16_t)0.92387953251128673848f,
(float16_t)-0.39399204006104798781f,(float16_t)0.91911385169005777040f,
(float16_t)-0.40524131400498974998f,(float16_t)0.91420975570353069095f,
(float16_t)-0.41642956009763698599f,(float16_t)0.90916798309052249127f,
(float16_t)-0.42755509343028186287f,(float16_t)0.90398929312344344922f,
(float16_t)-0.43861623853852738097f,(float16_t)0.89867446569395392775f,
(float16_t)-0.44961132965460670619f,(float16_t)0.89322430119551521344f,
(float16_t)-0.46053871095824006066f,(float16_t)0.88763962040285393496f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.48218377207912271887f,(float16_t)0.87607009419540660122f,
(float16_t)-0.49289819222978398239f,(float16_t)0.87008699110871146054f,
(float16_t)-0.50353838372571746440f,(float16_t)0.86397285612158680745f,
(float16_t)-0.51410274419322155026f,(float16_t)0.85772861000027211809f,
(float16_t)-0.52458968267846872724f,(float16_t)0.85135519310526519554f,
(float16_t)-0.53499761988709704230f,(float16_t)0.84485356524970722791f,
(float16_t)-0.54532498842204624179f,(float16_t)0.83822470555483818977f,
(float16_t)-0.55557023301960195560f,(float16_t)0.83146961230254534669f,
(float16_t)-0.56573181078361323149f,(float16_t)0.82458930278502517996f,
(float16_t)-0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)-0.58579785745643886408f,(float16_t)0.81045719825259476821f,
(float16_t)-0.59569930449243335691f,(float16_t)0.80320753148064494287f,
(float16_t)-0.60551104140432543410f,(float16_t)0.79583690460888356633f,
(float16_t)-0.61523159058062670823f,(float16_t)0.78834642762660633863f,
(float16_t)-0.62485948814238623239f,(float16_t)0.78073722857209459924f,
(float16_t)-0.63439328416364537677f,(float16_t)0.77301045336273710440f,
(float16_t)-0.64383154288979127511f,(float16_t)0.76516726562245906962f,
(float16_t)-0.65317284295377653347f,(float16_t)0.75720884650648467851f,
(float16_t)-0.66241577759017189475f,(float16_t)0.74913639452345925918f,
(float16_t)-0.67155895484701844111f,(float16_t)0.74095112535495899486f,
(float16_t)-0.68060099779545302212f,(float16_t)0.73265427167241281570f,
(float16_t)-0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)-0.69837624940897280457f,(float16_t)0.71573082528381870571f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.71573082528381859468f,(float16_t)0.69837624940897291559f,
(float16_t)-0.72424708295146678072f,(float16_t)0.68954054473706705153f,
(float16_t)-0.73265427167241270467f,(float16_t)0.68060099779545324417f,
(float16_t)-0.74095112535495888384f,(float16_t)0.67155895484701855214f,
(float16_t)-0.74913639452345914815f,(float16_t)0.66241577759017200577f,
(float16_t)-0.75720884650648467851f,(float16_t)0.65317284295377664449f,
(float16_t)-0.76516726562245895860f,(float16_t)0.64383154288979138613f,
(float16_t)-0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)-0.78073722857209448822f,(float16_t)0.62485948814238634341f,
(float16_t)-0.78834642762660622761f,(float16_t)0.61523159058062693028f,
(float16_t)-0.79583690460888345530f,(float16_t)0.60551104140432565615f,
(float16_t)-0.80320753148064483184f,(float16_t)0.59569930449243346793f,
(float16_t)-0.81045719825259465718f,(float16_t)0.58579785745643897510f,
(float16_t)-0.81758481315158360037f,(float16_t)0.57580819141784544968f,
(float16_t)-0.82458930278502506894f,(float16_t)0.56573181078361345353f,
(float16_t)-0.83146961230254534669f,(float16_t)0.55557023301960217765f,
(float16_t)-0.83822470555483807875f,(float16_t)0.54532498842204635281f,
(float16_t)-0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)-0.85135519310526519554f,(float16_t)0.52458968267846894928f,
(float16_t)-0.85772861000027200706f,(float16_t)0.51410274419322177231f,
(float16_t)-0.86397285612158669643f,(float16_t)0.50353838372571757542f,
(float16_t)-0.87008699110871134952f,(float16_t)0.49289819222978414892f,
(float16_t)-0.87607009419540649020f,(float16_t)0.48218377207912288540f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.88763962040285382393f,(float16_t)0.46053871095824022719f,
(float16_t)-0.89322430119551521344f,(float16_t)0.44961132965460687272f,
(float16_t)-0.89867446569395392775f,(float16_t)0.43861623853852754751f,
(float16_t)-0.90398929312344333820f,(float16_t)0.42755509343028202940f,
(float16_t)-0.90916798309052238025f,(float16_t)0.41642956009763715253f,
(float16_t)-0.91420975570353069095f,(float16_t)0.40524131400498991651f,
(float16_t)-0.91911385169005777040f,(float16_t)0.39399204006104815434f,
(float16_t)-0.92387953251128673848f,(float16_t)0.38268343236508989280f,
(float16_t)-0.92850608047321547822f,(float16_t)0.37131719395183770960f,
(float16_t)-0.93299279883473884567f,(float16_t)0.35989503653498833291f,
(float16_t)-0.93733901191257484875f,(float16_t)0.34841868024943478677f,
(float16_t)-0.94154406518302069529f,(float16_t)0.33688985339222032867f,
(float16_t)-0.94560732538052116869f,(float16_t)0.32531029216226325929f,
(float16_t)-0.94952818059303667475f,(float16_t)0.31368174039889140658f,
(float16_t)-0.95330604035419386211f,(float16_t)0.30200594931922802866f,
(float16_t)-0.95694033573220882438f,(float16_t)0.29028467725446238656f,
(float16_t)-0.96043051941556578655f,(float16_t)0.27851968938505317075f,
(float16_t)-0.96377606579543984022f,(float16_t)0.26671275747489847641f,
(float16_t)-0.96697647104485207059f,(float16_t)0.25486565960451468271f,
(float16_t)-0.97003125319454397424f,(float16_t)0.24298017990326406523f,
(float16_t)-0.97293995220556006576f,(float16_t)0.23105810828067133156f,
(float16_t)-0.97570213003852845901f,(float16_t)0.21910124015687004739f,
(float16_t)-0.97831737071962754371f,(float16_t)0.20711137619221883788f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.98310548743121628501f,(float16_t)0.18303988795514089527f,
(float16_t)-0.98527764238894122162f,(float16_t)0.17096188876030121717f,
(float16_t)-0.98730141815785843473f,(float16_t)0.15885814333386147346f,
(float16_t)-0.98917650996478101444f,(float16_t)0.14673047445536180344f,
(float16_t)-0.99090263542778000971f,(float16_t)0.13458070850712627875f,
(float16_t)-0.99247953459870996706f,(float16_t)0.12241067519921634832f,
(float16_t)-0.99390697000235606051f,(float16_t)0.11022220729388323979f,
(float16_t)-0.99518472667219681771f,(float16_t)0.09801714032956082567f,
(float16_t)-0.99631261218277800129f,(float16_t)0.08579731234444015753f,
(float16_t)-0.99729045667869020697f,(float16_t)0.07356456359966773162f,
(float16_t)-0.99811811290014917919f,(float16_t)0.06132073630220848809f,
(float16_t)-0.99879545620517240501f,(float16_t)0.04906767432741796636f,
(float16_t)-0.99932238458834954375f,(float16_t)0.03680722294135883171f,
(float16_t)-0.99969881869620424997f,(float16_t)0.02454122852291232629f,
(float16_t)-0.99992470183914450299f,(float16_t)0.01227153828572000692f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99879545620517240501f,(float16_t)0.04906767432741801493f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.97003125319454397424f,(float16_t)0.24298017990326387094f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.94154406518302080631f,(float16_t)0.33688985339222005111f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.85772861000027211809f,(float16_t)0.51410274419322166128f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.80320753148064494287f,(float16_t)0.59569930449243335691f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.67155895484701833009f,(float16_t)0.74095112535495910588f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.59569930449243346793f,(float16_t)0.80320753148064483184f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.42755509343028219593f,(float16_t)0.90398929312344333820f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.33688985339222005111f,(float16_t)0.94154406518302080631f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.14673047445536174793f,(float16_t)0.98917650996478101444f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.04906767432741812596f,(float16_t)0.99879545620517240501f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.04906767432741800800f,(float16_t)0.99879545620517240501f,
(float16_t)-0.09801714032956064526f,(float16_t)0.99518472667219692873f,
(float16_t)-0.14673047445536163691f,(float16_t)0.98917650996478101444f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.24298017990326387094f,(float16_t)0.97003125319454397424f,
(float16_t)-0.29028467725446216452f,(float16_t)0.95694033573220893540f,
(float16_t)-0.33688985339221994009f,(float16_t)0.94154406518302080631f,
(float16_t)-0.38268343236508972627f,(float16_t)0.92387953251128673848f,
(float16_t)-0.42755509343028186287f,(float16_t)0.90398929312344344922f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.51410274419322155026f,(float16_t)0.85772861000027211809f,
(float16_t)-0.55557023301960195560f,(float16_t)0.83146961230254534669f,
(float16_t)-0.59569930449243335691f,(float16_t)0.80320753148064494287f,
(float16_t)-0.63439328416364537677f,(float16_t)0.77301045336273710440f,
(float16_t)-0.67155895484701844111f,(float16_t)0.74095112535495899486f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.74095112535495888384f,(float16_t)0.67155895484701855214f,
(float16_t)-0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)-0.80320753148064483184f,(float16_t)0.59569930449243346793f,
(float16_t)-0.83146961230254534669f,(float16_t)0.55557023301960217765f,
(float16_t)-0.85772861000027200706f,(float16_t)0.51410274419322177231f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.90398929312344333820f,(float16_t)0.42755509343028202940f,
(float16_t)-0.92387953251128673848f,(float16_t)0.38268343236508989280f,
(float16_t)-0.94154406518302069529f,(float16_t)0.33688985339222032867f,
(float16_t)-0.95694033573220882438f,(float16_t)0.29028467725446238656f,
(float16_t)-0.97003125319454397424f,(float16_t)0.24298017990326406523f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.98917650996478101444f,(float16_t)0.14673047445536180344f,
(float16_t)-0.99518472667219681771f,(float16_t)0.09801714032956082567f,
(float16_t)-0.99879545620517240501f,(float16_t)0.04906767432741796636f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.38268343236508972627f,(float16_t)0.92387953251128673848f,
(float16_t)-0.55557023301960195560f,(float16_t)0.83146961230254534669f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.83146961230254534669f,(float16_t)0.55557023301960217765f,
(float16_t)-0.92387953251128673848f,(float16_t)0.38268343236508989280f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,};

float16_t rearranged_twiddle_stride3_1024_f16[680]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99983058179582340319f,(float16_t)0.01840672990580482019f,
(float16_t)0.99932238458834954375f,(float16_t)0.03680722294135883171f,
(float16_t)0.99847558057329477421f,(float16_t)0.05519524434968993420f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.99576741446765981713f,(float16_t)0.09190895649713272386f,
(float16_t)0.99390697000235606051f,(float16_t)0.11022220729388305938f,
(float16_t)0.99170975366909952520f,(float16_t)0.12849811079379316880f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98630809724459866938f,(float16_t)0.16491312048996989437f,
(float16_t)0.98310548743121628501f,(float16_t)0.18303988795514095078f,
(float16_t)0.97956976568544051887f,(float16_t)0.20110463484209190055f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.97150389098625178352f,(float16_t)0.23702360599436719801f,
(float16_t)0.96697647104485207059f,(float16_t)0.25486565960451457169f,
(float16_t)0.96212140426904158019f,(float16_t)0.27262135544994897662f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.95143502096900833820f,(float16_t)0.30784964004153486661f,
(float16_t)0.94560732538052127971f,(float16_t)0.32531029216226292622f,
(float16_t)0.93945922360218991898f,(float16_t)0.34266071731199437833f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.92621024213831137928f,(float16_t)0.37700741021641825945f,
(float16_t)0.91911385169005777040f,(float16_t)0.39399204006104809883f,
(float16_t)0.91170603200542987832f,(float16_t)0.41084317105790391089f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.89596624975618521791f,(float16_t)0.44412214457042920035f,
(float16_t)0.88763962040285393496f,(float16_t)0.46053871095824000514f,
(float16_t)0.87901222642863352519f,(float16_t)0.47679923006332208812f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.86086693863776730939f,(float16_t)0.50883014254310698909f,
(float16_t)0.85135519310526519554f,(float16_t)0.52458968267846894928f,
(float16_t)0.84155497743689844370f,(float16_t)0.54017147272989285423f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.82110251499110464835f,(float16_t)0.57078074588696725566f,
(float16_t)0.81045719825259476821f,(float16_t)0.58579785745643886408f,
(float16_t)0.79953726910790501314f,(float16_t)0.60061647938386897305f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.77688846567323244230f,(float16_t)0.62963823891492698426f,
(float16_t)0.76516726562245895860f,(float16_t)0.64383154288979138613f,
(float16_t)0.75318679904361252042f,(float16_t)0.65780669329707863735f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.72846439044822519637f,(float16_t)0.68508366777270035541f,
(float16_t)0.71573082528381870571f,(float16_t)0.69837624940897280457f,
(float16_t)0.70275474445722529993f,(float16_t)0.71143219574521643356f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.67609270357531603413f,(float16_t)0.73681656887736979300f,
(float16_t)0.66241577759017178373f,(float16_t)0.74913639452345925918f,
(float16_t)0.64851440102211255212f,(float16_t)0.76120238548426177871f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.62005721176328920663f,(float16_t)0.78455659715557524159f,
(float16_t)0.60551104140432554512f,(float16_t)0.79583690460888345530f,
(float16_t)0.59075970185887427544f,(float16_t)0.80684755354379922299f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.56066157619733603124f,(float16_t)0.82804504525775579626f,
(float16_t)0.54532498842204646383f,(float16_t)0.83822470555483796772f,
(float16_t)0.52980362468629482731f,(float16_t)0.84812034480329712149f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.49822766697278186854f,(float16_t)0.86704624551569264845f,
(float16_t)0.48218377207912282989f,(float16_t)0.87607009419540660122f,
(float16_t)0.46597649576796612569f,(float16_t)0.88479709843093778954f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.43309381885315201277f,(float16_t)0.90134884704602202810f,
(float16_t)0.41642956009763731906f,(float16_t)0.90916798309052226923f,
(float16_t)0.39962419984564678810f,(float16_t)0.91667905992104270485f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.36561299780477396482f,(float16_t)0.93076696107898371224f,
(float16_t)0.34841868024943450921f,(float16_t)0.93733901191257495977f,
(float16_t)0.33110630575987642921f,(float16_t)0.94359345816196038559f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.29615088824362395536f,(float16_t)0.95514116830577067141f,
(float16_t)0.27851968938505305973f,(float16_t)0.96043051941556578655f,
(float16_t)0.26079411791527556952f,(float16_t)0.96539444169768939830f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.22508391135979277653f,(float16_t)0.97433938278557585821f,
(float16_t)0.20711137619221856032f,(float16_t)0.97831737071962765473f,
(float16_t)0.18906866414980627589f,(float16_t)0.98196386910955524296f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.15279718525844340760f,(float16_t)0.98825756773074946437f,
(float16_t)0.13458070850712622324f,(float16_t)0.99090263542778000971f,
(float16_t)0.11631863091190487725f,(float16_t)0.99321194923479450001f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.07968243797143012563f,(float16_t)0.99682029929116566791f,
(float16_t)0.06132073630220864768f,(float16_t)0.99811811290014917919f,
(float16_t)0.04293825693494095902f,(float16_t)0.99907772775264536147f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)0.00613588464915451517f,(float16_t)0.99998117528260110909f,
(float16_t)-0.01227153828571982304f,(float16_t)0.99992470183914450299f,
(float16_t)-0.03067480317663645942f,(float16_t)0.99952941750109314256f,
(float16_t)-0.04906767432741800800f,(float16_t)0.99879545620517240501f,
(float16_t)-0.06744391956366398155f,(float16_t)0.99772306664419163624f,
(float16_t)-0.08579731234443975507f,(float16_t)0.99631261218277800129f,
(float16_t)-0.10412163387205460030f,(float16_t)0.99456457073425541537f,
(float16_t)-0.12241067519921615403f,(float16_t)0.99247953459870996706f,
(float16_t)-0.14065823933284912761f,(float16_t)0.99005821026229712256f,
(float16_t)-0.15885814333386127917f,(float16_t)0.98730141815785843473f,
(float16_t)-0.17700422041214874946f,(float16_t)0.98421009238692902521f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.21311031991609125091f,(float16_t)0.97702814265775439484f,
(float16_t)-0.23105810828067113727f,(float16_t)0.97293995220556017678f,
(float16_t)-0.24892760574572012078f,(float16_t)0.96852209427441737777f,
(float16_t)-0.26671275747489830987f,(float16_t)0.96377606579543984022f,
(float16_t)-0.28440753721127171039f,(float16_t)0.95870347489587159906f,
(float16_t)-0.30200594931922808417f,(float16_t)0.95330604035419386211f,
(float16_t)-0.31950203081601563637f,(float16_t)0.94758559101774120226f,
(float16_t)-0.33688985339221994009f,(float16_t)0.94154406518302080631f,
(float16_t)-0.35416352542049039931f,(float16_t)0.93518350993894761025f,
(float16_t)-0.37131719395183748755f,(float16_t)0.92850608047321558924f,
(float16_t)-0.38834504669882619066f,(float16_t)0.92151403934204201285f,
(float16_t)-0.40524131400498974998f,(float16_t)0.91420975570353069095f,
(float16_t)-0.42200027079979968159f,(float16_t)0.90659570451491533483f,
(float16_t)-0.43861623853852738097f,(float16_t)0.89867446569395392775f,
(float16_t)-0.45508358712634372489f,(float16_t)0.89044872324475798919f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.48755016014843571837f,(float16_t)0.87309497841829020182f,
(float16_t)-0.50353838372571746440f,(float16_t)0.86397285612158680745f,
(float16_t)-0.51935599016558964269f,(float16_t)0.85455798836540053376f,
(float16_t)-0.53499761988709704230f,(float16_t)0.84485356524970722791f,
(float16_t)-0.55045797293660470029f,(float16_t)0.83486287498638012128f,
(float16_t)-0.56573181078361323149f,(float16_t)0.82458930278502517996f,
(float16_t)-0.58081395809576441547f,(float16_t)0.81403632970594852480f,
(float16_t)-0.59569930449243335691f,(float16_t)0.80320753148064494287f,
(float16_t)-0.61038280627630958630f,(float16_t)0.79210657730021227785f,
(float16_t)-0.62485948814238623239f,(float16_t)0.78073722857209459924f,
(float16_t)-0.63912444486377573138f,(float16_t)0.76910333764557958780f,
(float16_t)-0.65317284295377653347f,(float16_t)0.75720884650648467851f,
(float16_t)-0.66699992230363736034f,(float16_t)0.74505778544146605835f,
(float16_t)-0.68060099779545302212f,(float16_t)0.73265427167241281570f,
(float16_t)-0.69397146088965377952f,(float16_t)0.72000250796138176579f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.72000250796138165477f,(float16_t)0.69397146088965389055f,
(float16_t)-0.73265427167241270467f,(float16_t)0.68060099779545324417f,
(float16_t)-0.74505778544146594733f,(float16_t)0.66699992230363758239f,
(float16_t)-0.75720884650648467851f,(float16_t)0.65317284295377664449f,
(float16_t)-0.76910333764557947678f,(float16_t)0.63912444486377584241f,
(float16_t)-0.78073722857209448822f,(float16_t)0.62485948814238634341f,
(float16_t)-0.79210657730021216683f,(float16_t)0.61038280627630969732f,
(float16_t)-0.80320753148064483184f,(float16_t)0.59569930449243346793f,
(float16_t)-0.81403632970594841378f,(float16_t)0.58081395809576452649f,
(float16_t)-0.82458930278502506894f,(float16_t)0.56573181078361345353f,
(float16_t)-0.83486287498638001026f,(float16_t)0.55045797293660492233f,
(float16_t)-0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)-0.85455798836540042274f,(float16_t)0.51935599016558975372f,
(float16_t)-0.86397285612158669643f,(float16_t)0.50353838372571757542f,
(float16_t)-0.87309497841829009079f,(float16_t)0.48755016014843588490f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.89044872324475787817f,(float16_t)0.45508358712634389143f,
(float16_t)-0.89867446569395392775f,(float16_t)0.43861623853852754751f,
(float16_t)-0.90659570451491533483f,(float16_t)0.42200027079979984812f,
(float16_t)-0.91420975570353069095f,(float16_t)0.40524131400498991651f,
(float16_t)-0.92151403934204179080f,(float16_t)0.38834504669882657923f,
(float16_t)-0.92850608047321547822f,(float16_t)0.37131719395183770960f,
(float16_t)-0.93518350993894761025f,(float16_t)0.35416352542049039931f,
(float16_t)-0.94154406518302069529f,(float16_t)0.33688985339222032867f,
(float16_t)-0.94758559101774109124f,(float16_t)0.31950203081601580291f,
(float16_t)-0.95330604035419386211f,(float16_t)0.30200594931922802866f,
(float16_t)-0.95870347489587148804f,(float16_t)0.28440753721127209896f,
(float16_t)-0.96377606579543984022f,(float16_t)0.26671275747489847641f,
(float16_t)-0.96852209427441737777f,(float16_t)0.24892760574572009302f,
(float16_t)-0.97293995220556006576f,(float16_t)0.23105810828067133156f,
(float16_t)-0.97702814265775439484f,(float16_t)0.21311031991609141745f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.98421009238692902521f,(float16_t)0.17700422041214894375f,
(float16_t)-0.98730141815785843473f,(float16_t)0.15885814333386147346f,
(float16_t)-0.99005821026229701154f,(float16_t)0.14065823933284954395f,
(float16_t)-0.99247953459870996706f,(float16_t)0.12241067519921634832f,
(float16_t)-0.99456457073425541537f,(float16_t)0.10412163387205457254f,
(float16_t)-0.99631261218277800129f,(float16_t)0.08579731234444015753f,
(float16_t)-0.99772306664419163624f,(float16_t)0.06744391956366417584f,
(float16_t)-0.99879545620517240501f,(float16_t)0.04906767432741796636f,
(float16_t)-0.99952941750109314256f,(float16_t)0.03067480317663686534f,
(float16_t)-0.99992470183914450299f,(float16_t)0.01227153828572000692f,
(float16_t)-0.99998117528260110909f,(float16_t)-0.00613588464915455420f,
(float16_t)-0.99969881869620424997f,(float16_t)-0.02454122852291207996f,
(float16_t)-0.99907772775264536147f,(float16_t)-0.04293825693494077861f,
(float16_t)-0.99811811290014917919f,(float16_t)-0.06132073630220824523f,
(float16_t)-0.99682029929116577893f,(float16_t)-0.07968243797142994522f,
(float16_t)-0.99518472667219692873f,(float16_t)-0.09801714032956058975f,
(float16_t)-0.99321194923479461103f,(float16_t)-0.11631863091190447479f,
(float16_t)-0.99090263542778000971f,(float16_t)-0.13458070850712605671f,
(float16_t)-0.98825756773074946437f,(float16_t)-0.15279718525844343535f,
(float16_t)-0.98527764238894133264f,(float16_t)-0.17096188876030096737f,
(float16_t)-0.98196386910955524296f,(float16_t)-0.18906866414980610935f,
(float16_t)-0.97831737071962765473f,(float16_t)-0.20711137619221858808f,
(float16_t)-0.97433938278557585821f,(float16_t)-0.22508391135979261000f,
(float16_t)-0.97003125319454397424f,(float16_t)-0.24298017990326381543f,
(float16_t)-0.96539444169768939830f,(float16_t)-0.26079411791527562503f,
(float16_t)-0.96043051941556589757f,(float16_t)-0.27851968938505289319f,
(float16_t)-0.95514116830577078243f,(float16_t)-0.29615088824362378883f,
(float16_t)-0.94952818059303678577f,(float16_t)-0.31368174039889118454f,
(float16_t)-0.94359345816196038559f,(float16_t)-0.33110630575987626267f,
(float16_t)-0.93733901191257495977f,(float16_t)-0.34841868024943456472f,
(float16_t)-0.93076696107898382326f,(float16_t)-0.36561299780477357624f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,
(float16_t)-0.91667905992104270485f,(float16_t)-0.39962419984564684361f,
(float16_t)-0.90916798309052249127f,(float16_t)-0.41642956009763693048f,
(float16_t)-0.90134884704602202810f,(float16_t)-0.43309381885315184624f,
(float16_t)-0.89322430119551532446f,(float16_t)-0.44961132965460665067f,
(float16_t)-0.88479709843093790056f,(float16_t)-0.46597649576796595916f,
(float16_t)-0.87607009419540660122f,(float16_t)-0.48218377207912266336f,
(float16_t)-0.86704624551569287050f,(float16_t)-0.49822766697278153547f,
(float16_t)-0.85772861000027211809f,(float16_t)-0.51410274419322155026f,
(float16_t)-0.84812034480329723252f,(float16_t)-0.52980362468629460526f,
(float16_t)-0.83822470555483818977f,(float16_t)-0.54532498842204613076f,
(float16_t)-0.82804504525775590729f,(float16_t)-0.56066157619733592021f,
(float16_t)-0.81758481315158371139f,(float16_t)-0.57580819141784533866f,
(float16_t)-0.80684755354379944503f,(float16_t)-0.59075970185887394237f,
(float16_t)-0.79583690460888356633f,(float16_t)-0.60551104140432543410f,
(float16_t)-0.78455659715557524159f,(float16_t)-0.62005721176328920663f,
(float16_t)-0.77301045336273710440f,(float16_t)-0.63439328416364526575f,
(float16_t)-0.76120238548426188974f,(float16_t)-0.64851440102211233008f,
(float16_t)-0.74913639452345925918f,(float16_t)-0.66241577759017178373f,
(float16_t)-0.73681656887737001504f,(float16_t)-0.67609270357531581208f,
(float16_t)-0.72424708295146700276f,(float16_t)-0.68954054473706682948f,
(float16_t)-0.71143219574521665560f,(float16_t)-0.70275474445722507788f,
(float16_t)-0.69837624940897302661f,(float16_t)-0.71573082528381848366f,
(float16_t)-0.68508366777270035541f,(float16_t)-0.72846439044822519637f,
(float16_t)-0.67155895484701866316f,(float16_t)-0.74095112535495888384f,
(float16_t)-0.65780669329707874837f,(float16_t)-0.75318679904361240940f,
(float16_t)-0.64383154288979149715f,(float16_t)-0.76516726562245895860f,
(float16_t)-0.62963823891492687324f,(float16_t)-0.77688846567323255332f,
(float16_t)-0.61523159058062726334f,(float16_t)-0.78834642762660589455f,
(float16_t)-0.60061647938386930612f,(float16_t)-0.79953726910790479110f,
(float16_t)-0.58579785745643908612f,(float16_t)-0.81045719825259465718f,
(float16_t)-0.57078074588696736669f,(float16_t)-0.82110251499110464835f,
(float16_t)-0.55557023301960217765f,(float16_t)-0.83146961230254523567f,
(float16_t)-0.54017147272989274320f,(float16_t)-0.84155497743689855472f,
(float16_t)-0.52458968267846928235f,(float16_t)-0.85135519310526486247f,
(float16_t)-0.50883014254310732216f,(float16_t)-0.86086693863776708735f,
(float16_t)-0.49289819222978420443f,(float16_t)-0.87008699110871134952f,
(float16_t)-0.47679923006332214364f,(float16_t)-0.87901222642863341417f,
(float16_t)-0.46053871095823989412f,(float16_t)-0.88763962040285404598f,
(float16_t)-0.44412214457042975546f,(float16_t)-0.89596624975618488484f,
(float16_t)-0.42755509343028247349f,(float16_t)-0.90398929312344311615f,
(float16_t)-0.41084317105790418845f,(float16_t)-0.91170603200542976730f,
(float16_t)-0.39399204006104820985f,(float16_t)-0.91911385169005765938f,
(float16_t)-0.37700741021641820394f,(float16_t)-0.92621024213831137928f,
(float16_t)-0.35989503653498794433f,(float16_t)-0.93299279883473895669f,
(float16_t)-0.34266071731199487793f,(float16_t)-0.93945922360218969693f,
(float16_t)-0.32531029216226331480f,(float16_t)-0.94560732538052116869f,
(float16_t)-0.30784964004153508865f,(float16_t)-0.95143502096900833820f,
(float16_t)-0.29028467725446244208f,(float16_t)-0.95694033573220882438f,
(float16_t)-0.27262135544994886560f,(float16_t)-0.96212140426904158019f,
(float16_t)-0.25486565960451434965f,(float16_t)-0.96697647104485218161f,
(float16_t)-0.23702360599436766986f,(float16_t)-0.97150389098625167250f,
(float16_t)-0.21910124015687010290f,(float16_t)-0.97570213003852845901f,
(float16_t)-0.20110463484209206708f,(float16_t)-0.97956976568544051887f,
(float16_t)-0.18303988795514095078f,(float16_t)-0.98310548743121628501f,
(float16_t)-0.16491312048996975559f,(float16_t)-0.98630809724459866938f,
(float16_t)-0.14673047445536230304f,(float16_t)-0.98917650996478090342f,
(float16_t)-0.12849811079379358514f,(float16_t)-0.99170975366909952520f,
(float16_t)-0.11022220729388330918f,(float16_t)-0.99390697000235606051f,
(float16_t)-0.09190895649713282101f,(float16_t)-0.99576741446765981713f,
(float16_t)-0.07356456359966735692f,(float16_t)-0.99729045667869020697f,
(float16_t)-0.05519524434968971216f,(float16_t)-0.99847558057329477421f,
(float16_t)-0.03680722294135933131f,(float16_t)-0.99932238458834943273f,
(float16_t)-0.01840672990580516366f,(float16_t)-0.99983058179582340319f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)-0.04906767432741800800f,(float16_t)0.99879545620517240501f,
(float16_t)-0.12241067519921615403f,(float16_t)0.99247953459870996706f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.26671275747489830987f,(float16_t)0.96377606579543984022f,
(float16_t)-0.33688985339221994009f,(float16_t)0.94154406518302080631f,
(float16_t)-0.40524131400498974998f,(float16_t)0.91420975570353069095f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.53499761988709704230f,(float16_t)0.84485356524970722791f,
(float16_t)-0.59569930449243335691f,(float16_t)0.80320753148064494287f,
(float16_t)-0.65317284295377653347f,(float16_t)0.75720884650648467851f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.75720884650648467851f,(float16_t)0.65317284295377664449f,
(float16_t)-0.80320753148064483184f,(float16_t)0.59569930449243346793f,
(float16_t)-0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.91420975570353069095f,(float16_t)0.40524131400498991651f,
(float16_t)-0.94154406518302069529f,(float16_t)0.33688985339222032867f,
(float16_t)-0.96377606579543984022f,(float16_t)0.26671275747489847641f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.99247953459870996706f,(float16_t)0.12241067519921634832f,
(float16_t)-0.99879545620517240501f,(float16_t)0.04906767432741796636f,
(float16_t)-0.99969881869620424997f,(float16_t)-0.02454122852291207996f,
(float16_t)-0.99518472667219692873f,(float16_t)-0.09801714032956058975f,
(float16_t)-0.98527764238894133264f,(float16_t)-0.17096188876030096737f,
(float16_t)-0.97003125319454397424f,(float16_t)-0.24298017990326381543f,
(float16_t)-0.94952818059303678577f,(float16_t)-0.31368174039889118454f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,
(float16_t)-0.89322430119551532446f,(float16_t)-0.44961132965460665067f,
(float16_t)-0.85772861000027211809f,(float16_t)-0.51410274419322155026f,
(float16_t)-0.81758481315158371139f,(float16_t)-0.57580819141784533866f,
(float16_t)-0.77301045336273710440f,(float16_t)-0.63439328416364526575f,
(float16_t)-0.72424708295146700276f,(float16_t)-0.68954054473706682948f,
(float16_t)-0.67155895484701866316f,(float16_t)-0.74095112535495888384f,
(float16_t)-0.61523159058062726334f,(float16_t)-0.78834642762660589455f,
(float16_t)-0.55557023301960217765f,(float16_t)-0.83146961230254523567f,
(float16_t)-0.49289819222978420443f,(float16_t)-0.87008699110871134952f,
(float16_t)-0.42755509343028247349f,(float16_t)-0.90398929312344311615f,
(float16_t)-0.35989503653498794433f,(float16_t)-0.93299279883473895669f,
(float16_t)-0.29028467725446244208f,(float16_t)-0.95694033573220882438f,
(float16_t)-0.21910124015687010290f,(float16_t)-0.97570213003852845901f,
(float16_t)-0.14673047445536230304f,(float16_t)-0.98917650996478090342f,
(float16_t)-0.07356456359966735692f,(float16_t)-0.99729045667869020697f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.99518472667219692873f,(float16_t)-0.09801714032956058975f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,
(float16_t)-0.77301045336273710440f,(float16_t)-0.63439328416364526575f,
(float16_t)-0.55557023301960217765f,(float16_t)-0.83146961230254523567f,
(float16_t)-0.29028467725446244208f,(float16_t)-0.95694033573220882438f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_4096) || defined(ARM_TABLE_TWIDDLECOEF_F16_8192)

uint32_t rearranged_twiddle_tab_stride1_arr_4096_f16[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_4096_f16[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_4096_f16[6]={
0,2048,2560,2688,2720,0,};

float16_t rearranged_twiddle_stride1_4096_f16[2728]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99999882345170187925f,(float16_t)0.00153398018628476550f,
(float16_t)0.99999529380957619118f,(float16_t)0.00306795676296597614f,
(float16_t)0.99998941108192840321f,(float16_t)0.00460192612044857050f,
(float16_t)0.99998117528260110909f,(float16_t)0.00613588464915447527f,
(float16_t)0.99997058643097413988f,(float16_t)0.00766982873953109701f,
(float16_t)0.99995764455196389786f,(float16_t)0.00920375478205981944f,
(float16_t)0.99994234967602391162f,(float16_t)0.01073765916726449055f,
(float16_t)0.99992470183914450299f,(float16_t)0.01227153828571992539f,
(float16_t)0.99990470108285289808f,(float16_t)0.01380538852806039059f,
(float16_t)0.99988234745421256111f,(float16_t)0.01533920628498810015f,
(float16_t)0.99985764100582386060f,(float16_t)0.01687298794728171042f,
(float16_t)0.99983058179582340319f,(float16_t)0.01840672990580482019f,
(float16_t)0.99980116988788425569f,(float16_t)0.01994042855151444138f,
(float16_t)0.99976940535121527898f,(float16_t)0.02147408027546950787f,
(float16_t)0.99973528826056168306f,(float16_t)0.02300768146883936868f,
(float16_t)0.99969881869620424997f,(float16_t)0.02454122852291228812f,
(float16_t)0.99965999674395922270f,(float16_t)0.02607471782910390085f,
(float16_t)0.99961882249517863830f,(float16_t)0.02760814577896573974f,
(float16_t)0.99957529604674921764f,(float16_t)0.02914150876419372219f,
(float16_t)0.99952941750109314256f,(float16_t)0.03067480317663662595f,
(float16_t)0.99948118696616694567f,(float16_t)0.03220802540830458582f,
(float16_t)0.99943060455546173237f,(float16_t)0.03374117185137757990f,
(float16_t)0.99937767038800284780f,(float16_t)0.03527423889821394709f,
(float16_t)0.99932238458834954375f,(float16_t)0.03680722294135883171f,
(float16_t)0.99926474728659442359f,(float16_t)0.03834012037355269409f,
(float16_t)0.99920475861836388631f,(float16_t)0.03987292758773981066f,
(float16_t)0.99914241872481690532f,(float16_t)0.04140564097707673946f,
(float16_t)0.99907772775264536147f,(float16_t)0.04293825693494082024f,
(float16_t)0.99901068585407337697f,(float16_t)0.04447077185493866769f,
(float16_t)0.99894129318685687124f,(float16_t)0.04600318213091462299f,
(float16_t)0.99886954991428356099f,(float16_t)0.04753548415695930257f,
(float16_t)0.99879545620517240501f,(float16_t)0.04906767432741801493f,
(float16_t)0.99871901223387293811f,(float16_t)0.05059974903689928166f,
(float16_t)0.99864021818026527111f,(float16_t)0.05213170468028332366f,
(float16_t)0.99855907422975931365f,(float16_t)0.05366353765273051968f,
(float16_t)0.99847558057329477421f,(float16_t)0.05519524434968993420f,
(float16_t)0.99838973740734016094f,(float16_t)0.05672682116690774823f,
(float16_t)0.99830154493389289261f,(float16_t)0.05825826450043575244f,
(float16_t)0.99821100336047818846f,(float16_t)0.05978957074663986820f,
(float16_t)0.99811811290014917919f,(float16_t)0.06132073630220857829f,
(float16_t)0.99802287377148624081f,(float16_t)0.06285175756416140624f,
(float16_t)0.99792528619859599548f,(float16_t)0.06438263092985746505f,
(float16_t)0.99782535041111164453f,(float16_t)0.06591335279700380467f,
(float16_t)0.99772306664419163624f,(float16_t)0.06744391956366405094f,
(float16_t)0.99761843513851955478f,(float16_t)0.06897432762826674613f,
(float16_t)0.99751145614030345410f,(float16_t)0.07050457338961385600f,
(float16_t)0.99740212990127530279f,(float16_t)0.07203465324688933247f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.99717643673532618820f,(float16_t)0.07509430084792130533f,
(float16_t)0.99706007033948296225f,(float16_t)0.07662386139203149205f,
(float16_t)0.99694135776498216117f,(float16_t)0.07815324163279423197f,
(float16_t)0.99682029929116566791f,(float16_t)0.07968243797143012563f,
(float16_t)0.99669689520289606044f,(float16_t)0.08121144680959244133f,
(float16_t)0.99657114579055483539f,(float16_t)0.08274026454937569164f,
(float16_t)0.99644305135004263008f,(float16_t)0.08426888759332407108f,
(float16_t)0.99631261218277800129f,(float16_t)0.08579731234443989385f,
(float16_t)0.99617982859569698117f,(float16_t)0.08732553520619205922f,
(float16_t)0.99604470090125196702f,(float16_t)0.08885355258252460031f,
(float16_t)0.99590722941741172125f,(float16_t)0.09038136087786498296f,
(float16_t)0.99576741446765981713f,(float16_t)0.09190895649713272386f,
(float16_t)0.99562525638099430569f,(float16_t)0.09343633584574778661f,
(float16_t)0.99548075549192693856f,(float16_t)0.09496349532963899165f,
(float16_t)0.99533391214048227980f,(float16_t)0.09649043135525259274f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.99503319943811863180f,(float16_t)0.09954361866006931903f,
(float16_t)0.99487933079480561638f,(float16_t)0.10106986275482782167f,
(float16_t)0.99472312110432570265f,(float16_t)0.10259586902243628126f,
(float16_t)0.99456457073425541537f,(float16_t)0.10412163387205458642f,
(float16_t)0.99440368005767909576f,(float16_t)0.10564715371341061589f,
(float16_t)0.99424044945318790223f,(float16_t)0.10717242495680884273f,
(float16_t)0.99407487930487936634f,(float16_t)0.10869744401313871651f,
(float16_t)0.99390697000235606051f,(float16_t)0.11022220729388305938f,
(float16_t)0.99373672194072459884f,(float16_t)0.11174671121112658700f,
(float16_t)0.99356413552059530403f,(float16_t)0.11327095217756434631f,
(float16_t)0.99338921114808065305f,(float16_t)0.11479492660651008373f,
(float16_t)0.99321194923479450001f,(float16_t)0.11631863091190475235f,
(float16_t)0.99303235019785141002f,(float16_t)0.11784206150832497728f,
(float16_t)0.99285041445986510489f,(float16_t)0.11936521481099135467f,
(float16_t)0.99266614244894801899f,(float16_t)0.12088808723577708359f,
(float16_t)0.99247953459870996706f,(float16_t)0.12241067519921619566f,
(float16_t)0.99229059134825736699f,(float16_t)0.12393297511851215920f,
(float16_t)0.99209931314219179654f,(float16_t)0.12545498341154623367f,
(float16_t)0.99190570043060932726f,(float16_t)0.12697669649688586579f,
(float16_t)0.99170975366909952520f,(float16_t)0.12849811079379316880f,
(float16_t)0.99151147331874389668f,(float16_t)0.13001922272223334631f,
(float16_t)0.99131085984611544415f,(float16_t)0.13154002870288311611f,
(float16_t)0.99110791372327688986f,(float16_t)0.13306052515713906459f,
(float16_t)0.99090263542778000971f,(float16_t)0.13458070850712616773f,
(float16_t)0.99069502544266463406f,(float16_t)0.13610057517570620100f,
(float16_t)0.99048508425645709341f,(float16_t)0.13762012158648603832f,
(float16_t)0.99027281236316910817f,(float16_t)0.13913934416382620074f,
(float16_t)0.99005821026229712256f,(float16_t)0.14065823933284921088f,
(float16_t)0.98984127845882052821f,(float16_t)0.14217680351944803063f,
(float16_t)0.98962201746320088702f,(float16_t)0.14369503315029447110f,
(float16_t)0.98940042779138037687f,(float16_t)0.14521292465284746376f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98895026451030298986f,(float16_t)0.14824767898689603096f,
(float16_t)0.98872169196032377858f,(float16_t)0.14976453467732150915f,
(float16_t)0.98849079285269658701f,(float16_t)0.15128103795733022219f,
(float16_t)0.98825756773074946437f,(float16_t)0.15279718525844343535f,
(float16_t)0.98802201714328352633f,(float16_t)0.15431297301302010494f,
(float16_t)0.98778414164457217783f,(float16_t)0.15582839765426523271f,
(float16_t)0.98754394179435922574f,(float16_t)0.15734345561623824805f,
(float16_t)0.98730141815785843473f,(float16_t)0.15885814333386144570f,
(float16_t)0.98705657130575097380f,(float16_t)0.16037245724292828464f,
(float16_t)0.98680940181418552726f,(float16_t)0.16188639378011182579f,
(float16_t)0.98655991026477540817f,(float16_t)0.16339994938297322524f,
(float16_t)0.98630809724459866938f,(float16_t)0.16491312048996989437f,
(float16_t)0.98605396334619543897f,(float16_t)0.16642590354046410406f,
(float16_t)0.98579750916756747614f,(float16_t)0.16793829497473117263f,
(float16_t)0.98553873531217606185f,(float16_t)0.16945029123396795900f,
(float16_t)0.98527764238894122162f,(float16_t)0.17096188876030121717f,
(float16_t)0.98501423101223983814f,(float16_t)0.17247308399679595059f,
(float16_t)0.98474850180190420801f,(float16_t)0.17398387338746382214f,
(float16_t)0.98448045538322093151f,(float16_t)0.17549425337727142526f,
(float16_t)0.98421009238692902521f,(float16_t)0.17700422041214874946f,
(float16_t)0.98393741344921892278f,(float16_t)0.17851377093899750692f,
(float16_t)0.98366241921173025453f,(float16_t)0.18002290140569951471f,
(float16_t)0.98338511032155118130f,(float16_t)0.18153160826112496595f,
(float16_t)0.98310548743121628501f,(float16_t)0.18303988795514095078f,
(float16_t)0.98282355119870523641f,(float16_t)0.18454773693861961648f,
(float16_t)0.98253930228744124076f,(float16_t)0.18605515166344663291f,
(float16_t)0.98225274136628937249f,(float16_t)0.18756212858252960252f,
(float16_t)0.98196386910955524296f,(float16_t)0.18906866414980619262f,
(float16_t)0.98167268619698311305f,(float16_t)0.19057475482025273972f,
(float16_t)0.98137919331375456089f,(float16_t)0.19208039704989243734f,
(float16_t)0.98108339115048670553f,(float16_t)0.19358558729580360724f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.98048486177346938497f,(float16_t)0.19659459767008022335f,
(float16_t)0.98018213596811742949f,(float16_t)0.19809841071795356027f,
(float16_t)0.97987710369951763756f,(float16_t)0.19960175762113097075f,
(float16_t)0.97956976568544051887f,(float16_t)0.20110463484209190055f,
(float16_t)0.97926012264908202098f,(float16_t)0.20260703884442113343f,
(float16_t)0.97894817531906219710f,(float16_t)0.20410896609281686809f,
(float16_t)0.97863392442942320759f,(float16_t)0.20561041305309923910f,
(float16_t)0.97831737071962765473f,(float16_t)0.20711137619221856032f,
(float16_t)0.97799851493455713936f,(float16_t)0.20861185197826348503f,
(float16_t)0.97767735782450992943f,(float16_t)0.21011183688046961016f,
(float16_t)0.97735390014519996082f,(float16_t)0.21161132736922755315f,
(float16_t)0.97702814265775439484f,(float16_t)0.21311031991609136194f,
(float16_t)0.97670008612871184184f,(float16_t)0.21460881099378675829f,
(float16_t)0.97636973133002114000f,(float16_t)0.21610679707621952006f,
(float16_t)0.97603707903903902388f,(float16_t)0.21760427463848364127f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.97536488511665697665f,(float16_t)0.22059769010887350649f,
(float16_t)0.97502534506699412020f,(float16_t)0.22209362097320350937f,
(float16_t)0.97468351068851066810f,(float16_t)0.22358902922978998729f,
(float16_t)0.97433938278557585821f,(float16_t)0.22508391135979283204f,
(float16_t)0.97399296216795583359f,(float16_t)0.22657826384561000066f,
(float16_t)0.97364424965081197705f,(float16_t)0.22807208317088573102f,
(float16_t)0.97329324605469824672f,(float16_t)0.22956536582051886852f,
(float16_t)0.97293995220556017678f,(float16_t)0.23105810828067110951f,
(float16_t)0.97258436893473221296f,(float16_t)0.23255030703877524467f,
(float16_t)0.97222649707893626925f,(float16_t)0.23404195858354343018f,
(float16_t)0.97186633748027939639f,(float16_t)0.23553305940497548665f,
(float16_t)0.97150389098625178352f,(float16_t)0.23702360599436719801f,
(float16_t)0.97113915844972509284f,(float16_t)0.23851359484431841618f,
(float16_t)0.97077214072895035013f,(float16_t)0.24000302244874149871f,
(float16_t)0.97040283868755550234f,(float16_t)0.24149188530286933019f,
(float16_t)0.97003125319454397424f,(float16_t)0.24298017990326387094f,
(float16_t)0.96965738512429244800f,(float16_t)0.24446790274782415064f,
(float16_t)0.96928123535654853171f,(float16_t)0.24595505033579459497f,
(float16_t)0.96890280477642887202f,(float16_t)0.24744161916777326904f,
(float16_t)0.96852209427441737777f,(float16_t)0.24892760574572014853f,
(float16_t)0.96813910474636244441f,(float16_t)0.25041300657296522436f,
(float16_t)0.96775383709347551076f,(float16_t)0.25189781815421696809f,
(float16_t)0.96736629222232850545f,(float16_t)0.25338203699557015902f,
(float16_t)0.96697647104485207059f,(float16_t)0.25486565960451457169f,
(float16_t)0.96658437447833311928f,(float16_t)0.25634868248994291395f,
(float16_t)0.96619000344541250413f,(float16_t)0.25783110216215898713f,
(float16_t)0.96579335887408368500f,(float16_t)0.25931291513288623474f,
(float16_t)0.96539444169768939830f,(float16_t)0.26079411791527551401f,
(float16_t)0.96499325285492032478f,(float16_t)0.26227470702391358914f,
(float16_t)0.96458979328981275803f,(float16_t)0.26375467897483134694f,
(float16_t)0.96418406395174582890f,(float16_t)0.26523403028551179039f,
(float16_t)0.96377606579543984022f,(float16_t)0.26671275747489836538f,
(float16_t)0.96336579978095404631f,(float16_t)0.26819085706340317632f,
(float16_t)0.96295326687368387741f,(float16_t)0.26966832557291509076f,
(float16_t)0.96253846804435916340f,(float16_t)0.27114515952680801059f,
(float16_t)0.96212140426904158019f,(float16_t)0.27262135544994897662f,
(float16_t)0.96170207652912254037f,(float16_t)0.27409690986870638429f,
(float16_t)0.96128048581132063966f,(float16_t)0.27557181931095814376f,
(float16_t)0.96085663310767965850f,(float16_t)0.27704608030609989555f,
(float16_t)0.96043051941556578655f,(float16_t)0.27851968938505305973f,
(float16_t)0.96000214573766595727f,(float16_t)0.27999264308027321801f,
(float16_t)0.95957151308198451733f,(float16_t)0.28146493792575794091f,
(float16_t)0.95913862246184189431f,(float16_t)0.28293657045705539188f,
(float16_t)0.95870347489587159906f,(float16_t)0.28440753721127187692f,
(float16_t)0.95826607140801767226f,(float16_t)0.28587783472708061527f,
(float16_t)0.95782641302753290802f,(float16_t)0.28734745954472951102f,
(float16_t)0.95738450078897585627f,(float16_t)0.28881640820604947972f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.95649391890239510161f,(float16_t)0.29175226323498926195f,
(float16_t)0.95604525134999640557f,(float16_t)0.29321916269425862822f,
(float16_t)0.95559433413077110586f,(float16_t)0.29468537218051432669f,
(float16_t)0.95514116830577078243f,(float16_t)0.29615088824362378883f,
(float16_t)0.95468575494133833814f,(float16_t)0.29761570743508619641f,
(float16_t)0.95422809510910566733f,(float16_t)0.29907982630804047508f,
(float16_t)0.95376818988599032512f,(float16_t)0.30054324141727345454f,
(float16_t)0.95330604035419386211f,(float16_t)0.30200594931922808417f,
(float16_t)0.95284164760119871573f,(float16_t)0.30346794657201131562f,
(float16_t)0.95237501271976587880f,(float16_t)0.30492922973540237397f,
(float16_t)0.95190613680793234597f,(float16_t)0.30638979537086091787f,
(float16_t)0.95143502096900833820f,(float16_t)0.30784964004153486661f,
(float16_t)0.95096166631157508231f,(float16_t)0.30930876031226872680f,
(float16_t)0.95048607394948170235f,(float16_t)0.31076715274961147495f,
(float16_t)0.95000824500184299914f,(float16_t)0.31222481392182488413f,
(float16_t)0.94952818059303667475f,(float16_t)0.31368174039889151761f,
(float16_t)0.94904588185270055689f,(float16_t)0.31513792875252244485f,
(float16_t)0.94856134991573026749f,(float16_t)0.31659337555616584581f,
(float16_t)0.94807458592227622507f,(float16_t)0.31804807738501494896f,
(float16_t)0.94758559101774109124f,(float16_t)0.31950203081601569188f,
(float16_t)0.94709436635277721717f,(float16_t)0.32095523242787521445f,
(float16_t)0.94660091308328353499f,(float16_t)0.32240767880106985244f,
(float16_t)0.94610523237040344835f,(float16_t)0.32385936651785285356f,
(float16_t)0.94560732538052127971f,(float16_t)0.32531029216226292622f,
(float16_t)0.94510719328526060501f,(float16_t)0.32676045232013173347f,
(float16_t)0.94460483726148025685f,(float16_t)0.32820984357909249729f,
(float16_t)0.94410025849127265918f,(float16_t)0.32965846252858749255f,
(float16_t)0.94359345816196038559f,(float16_t)0.33110630575987642921f,
(float16_t)0.94308443746609349478f,(float16_t)0.33255336986604422389f,
(float16_t)0.94257319760144686605f,(float16_t)0.33399965144200938205f,
(float16_t)0.94205973977101731265f,(float16_t)0.33544514708453160301f,
(float16_t)0.94154406518302080631f,(float16_t)0.33688985339222005111f,
(float16_t)0.94102617505088925753f,(float16_t)0.33833376696554112728f,
(float16_t)0.94050607059326829518f,(float16_t)0.33977688440682685123f,
(float16_t)0.93998375303401404679f,(float16_t)0.34121920232028235542f,
(float16_t)0.93945922360218991898f,(float16_t)0.34266071731199437833f,
(float16_t)0.93893248353206459900f,(float16_t)0.34410142598993881391f,
(float16_t)0.93840353406310805795f,(float16_t)0.34554132496398909380f,
(float16_t)0.93787237643998988545f,(float16_t)0.34698041084592368133f,
(float16_t)0.93733901191257495977f,(float16_t)0.34841868024943456472f,
(float16_t)0.93680344173592156043f,(float16_t)0.34985612979013491763f,
(float16_t)0.93626566717027825959f,(float16_t)0.35129275608556709276f,
(float16_t)0.93572568948108036935f,(float16_t)0.35272855575521072646f,
(float16_t)0.93518350993894761025f,(float16_t)0.35416352542049034380f,
(float16_t)0.93463912981968078064f,(float16_t)0.35559766170478385172f,
(float16_t)0.93409255040425887007f,(float16_t)0.35703096123342997759f,
(float16_t)0.93354377297883617270f,(float16_t)0.35846342063373654030f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.93243962926846235550f,(float16_t)0.36132580556845428355f,
(float16_t)0.93188426558166814750f,(float16_t)0.36275572436739722537f,
(float16_t)0.93132670908118042608f,(float16_t)0.36418478956707989180f,
(float16_t)0.93076696107898371224f,(float16_t)0.36561299780477385379f,
(float16_t)0.93020502289221906889f,(float16_t)0.36704034571976718038f,
(float16_t)0.92964089584318121418f,(float16_t)0.36846682995337232125f,
(float16_t)0.92907458125931585702f,(float16_t)0.36989244714893410038f,
(float16_t)0.92850608047321558924f,(float16_t)0.37131719395183754306f,
(float16_t)0.92793539482261788720f,(float16_t)0.37274106700951575855f,
(float16_t)0.92736252565040111495f,(float16_t)0.37416406297145793358f,
(float16_t)0.92678747430458174872f,(float16_t)0.37558617848921721505f,
(float16_t)0.92621024213831137928f,(float16_t)0.37700741021641825945f,
(float16_t)0.92563083050987271516f,(float16_t)0.37842775480876555960f,
(float16_t)0.92504924078267758425f,(float16_t)0.37984720892405116066f,
(float16_t)0.92446547432526260391f,(float16_t)0.38126576922216237620f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.92329141671952763559f,(float16_t)0.38410019501693504207f,
(float16_t)0.92270112833387862850f,(float16_t)0.38551605384391884890f,
(float16_t)0.92210866874334518339f,(float16_t)0.38693100551438858181f,
(float16_t)0.92151403934204190183f,(float16_t)0.38834504669882624617f,
(float16_t)0.92091724152918941204f,(float16_t)0.38975817406985641123f,
(float16_t)0.92031827670911059425f,(float16_t)0.39117038430225387069f,
(float16_t)0.91971714629122736095f,(float16_t)0.39258167407295146978f,
(float16_t)0.91911385169005777040f,(float16_t)0.39399204006104809883f,
(float16_t)0.91850839432521225181f,(float16_t)0.39540147894781635385f,
(float16_t)0.91790077562139049672f,(float16_t)0.39680998741671030805f,
(float16_t)0.91729099700837790632f,(float16_t)0.39821756215337356100f,
(float16_t)0.91667905992104270485f,(float16_t)0.39962419984564678810f,
(float16_t)0.91606496579933172075f,(float16_t)0.40102989718357562321f,
(float16_t)0.91544871608826783316f,(float16_t)0.40243465085941843018f,
(float16_t)0.91483031223794619713f,(float16_t)0.40383845756765407442f,
(float16_t)0.91420975570353069095f,(float16_t)0.40524131400498986100f,
(float16_t)0.91358704794525080750f,(float16_t)0.40664321687036902864f,
(float16_t)0.91296219042839821256f,(float16_t)0.40804416286497868782f,
(float16_t)0.91233518462332274801f,(float16_t)0.40944414869225759235f,
(float16_t)0.91170603200542987832f,(float16_t)0.41084317105790391089f,
(float16_t)0.91107473405517636067f,(float16_t)0.41224122666988288755f,
(float16_t)0.91044129225806724737f,(float16_t)0.41363831223843450235f,
(float16_t)0.90980570810465222209f,(float16_t)0.41503442447608163146f,
(float16_t)0.90916798309052238025f,(float16_t)0.41642956009763715253f,
(float16_t)0.90852811871630612117f,(float16_t)0.41782371582021227141f,
(float16_t)0.90788611648766626150f,(float16_t)0.41921688836322390515f,
(float16_t)0.90724197791529581636f,(float16_t)0.42060907444840250902f,
(float16_t)0.90659570451491533483f,(float16_t)0.42200027079979968159f,
(float16_t)0.90594729780726845902f,(float16_t)0.42339047414379604728f,
(float16_t)0.90529675931811881551f,(float16_t)0.42477968120910880589f,
(float16_t)0.90464409057824624050f,(float16_t)0.42616788872679961520f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.90333236849451181705f,(float16_t)0.42894129205532949278f,
(float16_t)0.90267331823725882600f,(float16_t)0.43032648134008261165f,
(float16_t)0.90201214390249317976f,(float16_t)0.43171065802505725895f,
(float16_t)0.90134884704602202810f,(float16_t)0.43309381885315195726f,
(float16_t)0.90068342922864685907f,(float16_t)0.43447596056965565037f,
(float16_t)0.90001589201616016833f,(float16_t)0.43585707992225547480f,
(float16_t)0.89934623697934157338f,(float16_t)0.43723717366104408732f,
(float16_t)0.89867446569395381673f,(float16_t)0.43861623853852765853f,
(float16_t)0.89800057974073987932f,(float16_t)0.43999427130963325583f,
(float16_t)0.89732458070541831763f,(float16_t)0.44137126873171667052f,
(float16_t)0.89664647017868015499f,(float16_t)0.44274722756457002282f,
(float16_t)0.89596624975618521791f,(float16_t)0.44412214457042920035f,
(float16_t)0.89528392103855758410f,(float16_t)0.44549601651398174074f,
(float16_t)0.89459948563138269595f,(float16_t)0.44686884016237415906f,
(float16_t)0.89391294514520325265f,(float16_t)0.44824061228521988598f,
(float16_t)0.89322430119551532446f,(float16_t)0.44961132965460653965f,
(float16_t)0.89253355540276457791f,(float16_t)0.45098098904510386387f,
(float16_t)0.89184070939234272313f,(float16_t)0.45234958723377088896f,
(float16_t)0.89114576479458318392f,(float16_t)0.45371712100016386993f,
(float16_t)0.89044872324475787817f,(float16_t)0.45508358712634383592f,
(float16_t)0.88974958638307277692f,(float16_t)0.45644898239688391772f,
(float16_t)0.88904835585466457371f,(float16_t)0.45781330359887717485f,
(float16_t)0.88834503330959635470f,(float16_t)0.45917654752194408951f,
(float16_t)0.88763962040285393496f,(float16_t)0.46053871095824000514f,
(float16_t)0.88693211879434219469f,(float16_t)0.46189979070246273141f,
(float16_t)0.88622253014888063838f,(float16_t)0.46325978355186014923f,
(float16_t)0.88551085613619995307f,(float16_t)0.46461868630623781584f,
(float16_t)0.88479709843093778954f,(float16_t)0.46597649576796618121f,
(float16_t)0.88408125871263498752f,(float16_t)0.46733320874198841510f,
(float16_t)0.88336333866573157891f,(float16_t)0.46868882203582790114f,
(float16_t)0.88264333997956279099f,(float16_t)0.47004333245959561971f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.88119711347122209322f,(float16_t)0.47274903195034279069f,
(float16_t)0.88047088905216075450f,(float16_t)0.47410021465054996703f,
(float16_t)0.87974259280004740713f,(float16_t)0.47545028174715586733f,
(float16_t)0.87901222642863352519f,(float16_t)0.47679923006332208812f,
(float16_t)0.87827979165654157523f,(float16_t)0.47814705642484300885f,
(float16_t)0.87754529020726135258f,(float16_t)0.47949375766015295275f,
(float16_t)0.87680872380914565145f,(float16_t)0.48083933060033395845f,
(float16_t)0.87607009419540660122f,(float16_t)0.48218377207912271887f,
(float16_t)0.87532940310411089246f,(float16_t)0.48352707893291868579f,
(float16_t)0.87458665227817611321f,(float16_t)0.48486924800079106435f,
(float16_t)0.87384184346536686316f,(float16_t)0.48621027612448641797f,
(float16_t)0.87309497841829009079f,(float16_t)0.48755016014843599592f,
(float16_t)0.87234605889439154058f,(float16_t)0.48888889691976317176f,
(float16_t)0.87159508665595097909f,(float16_t)0.49022648328829115938f,
(float16_t)0.87084206347007897531f,(float16_t)0.49156291610654989643f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.86932987134860684186f,(float16_t)0.49423230851595967295f,
(float16_t)0.86857070597134089507f,(float16_t)0.49556526182577254058f,
(float16_t)0.86780949676330332299f,(float16_t)0.49689704902265446895f,
(float16_t)0.86704624551569264845f,(float16_t)0.49822766697278181303f,
(float16_t)0.86628095402451299467f,(float16_t)0.49955711254508183838f,
(float16_t)0.86551362409056908920f,(float16_t)0.50088538261124071482f,
(float16_t)0.86474425751946237817f,(float16_t)0.50221247404571078832f,
(float16_t)0.86397285612158669643f,(float16_t)0.50353838372571757542f,
(float16_t)0.86319942171212415971f,(float16_t)0.50486310853126759035f,
(float16_t)0.86242395611104050168f,(float16_t)0.50618664534515522835f,
(float16_t)0.86164646114308129921f,(float16_t)0.50750899105297087033f,
(float16_t)0.86086693863776730939f,(float16_t)0.50883014254310698909f,
(float16_t)0.86008539042939013974f,(float16_t)0.51015009670676680908f,
(float16_t)0.85930181835700847337f,(float16_t)0.51146885043797030157f,
(float16_t)0.85851622426444273994f,(float16_t)0.51278640063356295542f,
(float16_t)0.85772861000027211809f,(float16_t)0.51410274419322166128f,
(float16_t)0.85693897741782876221f,(float16_t)0.51541787801946292724f,
(float16_t)0.85614732837519447184f,(float16_t)0.51673179901764987321f,
(float16_t)0.85535366473519602870f,(float16_t)0.51804450409599933636f,
(float16_t)0.85455798836540053376f,(float16_t)0.51935599016558964269f,
(float16_t)0.85376030113811141042f,(float16_t)0.52066625414036715735f,
(float16_t)0.85296060493036363059f,(float16_t)0.52197529293715438925f,
(float16_t)0.85215890162391982887f,(float16_t)0.52328310347565643035f,
(float16_t)0.85135519310526519554f,(float16_t)0.52458968267846894928f,
(float16_t)0.85054948126560347976f,(float16_t)0.52589502747108463065f,
(float16_t)0.84974176800085254868f,(float16_t)0.52719913478190127964f,
(float16_t)0.84893205521163961347f,(float16_t)0.52850200154222848337f,
(float16_t)0.84812034480329723252f,(float16_t)0.52980362468629460526f,
(float16_t)0.84730663868585831544f,(float16_t)0.53110400115125500076f,
(float16_t)0.84649093877405212627f,(float16_t)0.53240312787719790144f,
(float16_t)0.84567324698729906540f,(float16_t)0.53370100180715296379f,
(float16_t)0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)0.84403189549006640835f,(float16_t)0.53629297906596318235f,
(float16_t)0.84320823964184543620f,(float16_t)0.53758707629564539410f,
(float16_t)0.84238259964318584760f,(float16_t)0.53887990853100842248f,
(float16_t)0.84155497743689844370f,(float16_t)0.54017147272989285423f,
(float16_t)0.84072537497045807253f,(float16_t)0.54146176585312344454f,
(float16_t)0.83989379419599952126f,(float16_t)0.54275078486451588944f,
(float16_t)0.83906023707031274217f,(float16_t)0.54403852673088382019f,
(float16_t)0.83822470555483807875f,(float16_t)0.54532498842204646383f,
(float16_t)0.83738720161566193578f,(float16_t)0.54661016691083486041f,
(float16_t)0.83654772722351200542f,(float16_t)0.54789405917310018967f,
(float16_t)0.83570628435375260423f,(float16_t)0.54917666218771965525f,
(float16_t)0.83486287498638001026f,(float16_t)0.55045797293660481131f,
(float16_t)0.83401750110601813315f,(float16_t)0.55173798840470733573f,
(float16_t)0.83317016470191318511f,(float16_t)0.55301670558002746780f,
(float16_t)0.83232086776792968408f,(float16_t)0.55429412145362000341f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.83061640030884631436f,(float16_t)0.55684503727516010407f,
(float16_t)0.82976123379452304540f,(float16_t)0.55811853122055610221f,
(float16_t)0.82890411477186487499f,(float16_t)0.55939071185913613604f,
(float16_t)0.82804504525775579626f,(float16_t)0.56066157619733603124f,
(float16_t)0.82718402727366913130f,(float16_t)0.56193112124468935775f,
(float16_t)0.82632106284566353427f,(float16_t)0.56319934401383409117f,
(float16_t)0.82545615400437755138f,(float16_t)0.56446624152051938506f,
(float16_t)0.82458930278502529099f,(float16_t)0.56573181078361312046f,
(float16_t)0.82372051122739142759f,(float16_t)0.56699604882510867832f,
(float16_t)0.82284978137582642788f,(float16_t)0.56825895267013148970f,
(float16_t)0.82197711527924155472f,(float16_t)0.56952051934694714053f,
(float16_t)0.82110251499110464835f,(float16_t)0.57078074588696725566f,
(float16_t)0.82022598256943468620f,(float16_t)0.57203962932475704850f,
(float16_t)0.81934752007679700903f,(float16_t)0.57329716669804220430f,
(float16_t)0.81846712958029865792f,(float16_t)0.57455335504771576360f,
(float16_t)0.81758481315158371139f,(float16_t)0.57580819141784533866f,
(float16_t)0.81670057286682784525f,(float16_t)0.57706167285567944170f,
(float16_t)0.81581441080673378075f,(float16_t)0.57831379641165558958f,
(float16_t)0.81492632905652662156f,(float16_t)0.57956455913940563285f,
(float16_t)0.81403632970594841378f,(float16_t)0.58081395809576452649f,
(float16_t)0.81314441484925359394f,(float16_t)0.58206199034077543697f,
(float16_t)0.81225058658520399302f,(float16_t)0.58330865293769829094f,
(float16_t)0.81135484701706372945f,(float16_t)0.58455394295301532637f,
(float16_t)0.81045719825259476821f,(float16_t)0.58579785745643886408f,
(float16_t)0.80955764240405125864f,(float16_t)0.58704039352091796911f,
(float16_t)0.80865618158817498262f,(float16_t)0.58828154822264522306f,
(float16_t)0.80775281792619035848f,(float16_t)0.58952131864106394055f,
(float16_t)0.80684755354379933401f,(float16_t)0.59075970185887416442f,
(float16_t)0.80594039057117627944f,(float16_t)0.59199669496204099239f,
(float16_t)0.80503133114296365758f,(float16_t)0.59323229503979979516f,
(float16_t)0.80412037739826569549f,(float16_t)0.59446649918466443197f,
(float16_t)0.80320753148064494287f,(float16_t)0.59569930449243335691f,
(float16_t)0.80229279553811572168f,(float16_t)0.59693070806219639124f,
(float16_t)0.80137617172314024039f,(float16_t)0.59816070699634238395f,
(float16_t)0.80045766219262282082f,(float16_t)0.59938929840056454079f,
(float16_t)0.79953726910790501314f,(float16_t)0.60061647938386897305f,
(float16_t)0.79861499463476093297f,(float16_t)0.60184224705858002658f,
(float16_t)0.79769084094339115509f,(float16_t)0.60306659854034816437f,
(float16_t)0.79676481020841882774f,(float16_t)0.60428953094815596181f,
(float16_t)0.79583690460888356633f,(float16_t)0.60551104140432554512f,
(float16_t)0.79490712632823701256f,(float16_t)0.60673112703452447558f,
(float16_t)0.79397547755433717231f,(float16_t)0.60794978496777363208f,
(float16_t)0.79304196047944364167f,(float16_t)0.60916701233645320634f,
(float16_t)0.79210657730021238887f,(float16_t)0.61038280627630947528f,
(float16_t)0.79116933021769020318f,(float16_t)0.61159716392646190641f,
(float16_t)0.79023022143731003197f,(float16_t)0.61281008242940970820f,
(float16_t)0.78928925316888565167f,(float16_t)0.61402155893103849138f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.78740174702903142911f,(float16_t)0.61644017453085364622f,
(float16_t)0.78645521359908576731f,(float16_t)0.61764730793780386886f,
(float16_t)0.78550682956405393220f,(float16_t)0.61885298796097631957f,
(float16_t)0.78455659715557524159f,(float16_t)0.62005721176328909561f,
(float16_t)0.78360451860963820092f,(float16_t)0.62125997651108755271f,
(float16_t)0.78265059616657572938f,(float16_t)0.62246127937414996723f,
(float16_t)0.78169483207105938671f,(float16_t)0.62366111752569453053f,
(float16_t)0.78073722857209448822f,(float16_t)0.62485948814238634341f,
(float16_t)0.77977778792301455368f,(float16_t)0.62605638840434352232f,
(float16_t)0.77881651238147597827f,(float16_t)0.62725181549514408275f,
(float16_t)0.77785340420945314754f,(float16_t)0.62844576660183271155f,
(float16_t)0.77688846567323244230f,(float16_t)0.62963823891492698426f,
(float16_t)0.77592169904340768660f,(float16_t)0.63082922962842447046f,
(float16_t)0.77495310659487393057f,(float16_t)0.63201873593980906207f,
(float16_t)0.77398269060682289844f,(float16_t)0.63320675505005719064f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.77203639715038452351f,(float16_t)0.63557832048855611440f,
(float16_t)0.77106052426181381776f,(float16_t)0.63676186123628419899f,
(float16_t)0.77008283699334789674f,(float16_t)0.63794390362184405507f,
(float16_t)0.76910333764557969882f,(float16_t)0.63912444486377573138f,
(float16_t)0.76812202852336541881f,(float16_t)0.64030348218415167327f,
(float16_t)0.76713891193582040007f,(float16_t)0.64148101280858305095f,
(float16_t)0.76615399019631291733f,(float16_t)0.64265703396622686494f,
(float16_t)0.76516726562245895860f,(float16_t)0.64383154288979138613f,
(float16_t)0.76417874053611667406f,(float16_t)0.64500453681554392737f,
(float16_t)0.76318841726338138010f,(float16_t)0.64617601298331628357f,
(float16_t)0.76219629813457900891f,(float16_t)0.64734596863651205911f,
(float16_t)0.76120238548426177871f,(float16_t)0.64851440102211244110f,
(float16_t)0.76020668165120242055f,(float16_t)0.64968130739068319368f,
(float16_t)0.75920918897838796102f,(float16_t)0.65084668499638087535f,
(float16_t)0.75820990981301528144f,(float16_t)0.65201053109695950027f,
(float16_t)0.75720884650648456748f,(float16_t)0.65317284295377675551f,
(float16_t)0.75620600141439453523f,(float16_t)0.65433361783180044036f,
(float16_t)0.75520137689653654700f,(float16_t)0.65549285299961534967f,
(float16_t)0.75419497531688917125f,(float16_t)0.65665054572942893607f,
(float16_t)0.75318679904361252042f,(float16_t)0.65780669329707863735f,
(float16_t)0.75217685044904269986f,(float16_t)0.65896129298203731661f,
(float16_t)0.75116513190968636771f,(float16_t)0.66011434206742047870f,
(float16_t)0.75015164580621507273f,(float16_t)0.66126583783999226540f,
(float16_t)0.74913639452345937020f,(float16_t)0.66241577759017178373f,
(float16_t)0.74811938045040360379f,(float16_t)0.66356415861203976725f,
(float16_t)0.74710060598018013245f,(float16_t)0.66471097820334479334f,
(float16_t)0.74608007351006377927f,(float16_t)0.66585623366550972246f,
(float16_t)0.74505778544146594733f,(float16_t)0.66699992230363747137f,
(float16_t)0.74403374417992929057f,(float16_t)0.66814204142651845153f,
(float16_t)0.74300795213512171866f,(float16_t)0.66928258834663600929f,
(float16_t)0.74198041172083106787f,(float16_t)0.67042156038017308717f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.73992009545951620275f,(float16_t)0.67269476907077285777f,
(float16_t)0.73888732446061511361f,(float16_t)0.67382900037875603783f,
(float16_t)0.73785281478846598269f,(float16_t)0.67496164610201192513f,
(float16_t)0.73681656887736979300f,(float16_t)0.67609270357531592310f,
(float16_t)0.73577858916571359238f,(float16_t)0.67722217013718033485f,
(float16_t)0.73473887809596349907f,(float16_t)0.67835004312986146857f,
(float16_t)0.73369743811466026084f,(float16_t)0.67947631989936496666f,
(float16_t)0.73265427167241281570f,(float16_t)0.68060099779545302212f,
(float16_t)0.73160938122389262972f,(float16_t)0.68172407417164970767f,
(float16_t)0.73056276922782759087f,(float16_t)0.68284554638524808112f,
(float16_t)0.72951443814699701296f,(float16_t)0.68396541179731540350f,
(float16_t)0.72846439044822519637f,(float16_t)0.68508366777270035541f,
(float16_t)0.72741262860237576593f,(float16_t)0.68620031168003858824f,
(float16_t)0.72635915508434600873f,(float16_t)0.68731534089175905233f,
(float16_t)0.72530397237306076796f,(float16_t)0.68842875278409043638f,
(float16_t)0.72424708295146700276f,(float16_t)0.68954054473706682948f,
(float16_t)0.72318848930652745999f,(float16_t)0.69065071413453460458f,
(float16_t)0.72212819392921534511f,(float16_t)0.69175925836415774750f,
(float16_t)0.72106619931450810501f,(float16_t)0.69286617481742462932f,
(float16_t)0.72000250796138165477f,(float16_t)0.69397146088965389055f,
(float16_t)0.71893712237280449351f,(float16_t)0.69507511398000088043f,
(float16_t)0.71787004505573170920f,(float16_t)0.69617713149146298601f,
(float16_t)0.71680127852109953857f,(float16_t)0.69727751083088651551f,
(float16_t)0.71573082528381870571f,(float16_t)0.69837624940897280457f,
(float16_t)0.71465868786276909308f,(float16_t)0.69947334464028376733f,
(float16_t)0.71358486878079352422f,(float16_t)0.70056879394324833576f,
(float16_t)0.71250937056469243469f,(float16_t)0.70166259474016845488f,
(float16_t)0.71143219574521643356f,(float16_t)0.70275474445722529993f,
(float16_t)0.71035334685706241764f,(float16_t)0.70384524052448493858f,
(float16_t)0.70927282643886568891f,(float16_t)0.70493408037590488124f,
(float16_t)0.70819063703319540259f,(float16_t)0.70602126144933974317f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.70602126144933974317f,(float16_t)0.70819063703319540259f,
(float16_t)0.70493408037590499227f,(float16_t)0.70927282643886568891f,
(float16_t)0.70384524052448493858f,(float16_t)0.71035334685706241764f,
(float16_t)0.70275474445722529993f,(float16_t)0.71143219574521643356f,
(float16_t)0.70166259474016845488f,(float16_t)0.71250937056469232367f,
(float16_t)0.70056879394324844679f,(float16_t)0.71358486878079352422f,
(float16_t)0.69947334464028376733f,(float16_t)0.71465868786276909308f,
(float16_t)0.69837624940897291559f,(float16_t)0.71573082528381859468f,
(float16_t)0.69727751083088662654f,(float16_t)0.71680127852109942754f,
(float16_t)0.69617713149146298601f,(float16_t)0.71787004505573170920f,
(float16_t)0.69507511398000088043f,(float16_t)0.71893712237280438249f,
(float16_t)0.69397146088965400157f,(float16_t)0.72000250796138165477f,
(float16_t)0.69286617481742474034f,(float16_t)0.72106619931450810501f,
(float16_t)0.69175925836415774750f,(float16_t)0.72212819392921534511f,
(float16_t)0.69065071413453460458f,(float16_t)0.72318848930652734897f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.68842875278409043638f,(float16_t)0.72530397237306076796f,
(float16_t)0.68731534089175905233f,(float16_t)0.72635915508434600873f,
(float16_t)0.68620031168003858824f,(float16_t)0.72741262860237576593f,
(float16_t)0.68508366777270035541f,(float16_t)0.72846439044822519637f,
(float16_t)0.68396541179731551452f,(float16_t)0.72951443814699690193f,
(float16_t)0.68284554638524808112f,(float16_t)0.73056276922782759087f,
(float16_t)0.68172407417164981869f,(float16_t)0.73160938122389262972f,
(float16_t)0.68060099779545302212f,(float16_t)0.73265427167241281570f,
(float16_t)0.67947631989936496666f,(float16_t)0.73369743811466026084f,
(float16_t)0.67835004312986146857f,(float16_t)0.73473887809596349907f,
(float16_t)0.67722217013718044587f,(float16_t)0.73577858916571348136f,
(float16_t)0.67609270357531603413f,(float16_t)0.73681656887736979300f,
(float16_t)0.67496164610201203615f,(float16_t)0.73785281478846598269f,
(float16_t)0.67382900037875614885f,(float16_t)0.73888732446061511361f,
(float16_t)0.67269476907077296879f,(float16_t)0.73992009545951609173f,
(float16_t)0.67155895484701833009f,(float16_t)0.74095112535495910588f,
(float16_t)0.67042156038017308717f,(float16_t)0.74198041172083095685f,
(float16_t)0.66928258834663600929f,(float16_t)0.74300795213512171866f,
(float16_t)0.66814204142651856255f,(float16_t)0.74403374417992929057f,
(float16_t)0.66699992230363747137f,(float16_t)0.74505778544146594733f,
(float16_t)0.66585623366550972246f,(float16_t)0.74608007351006366825f,
(float16_t)0.66471097820334490436f,(float16_t)0.74710060598018013245f,
(float16_t)0.66356415861203987827f,(float16_t)0.74811938045040349277f,
(float16_t)0.66241577759017178373f,(float16_t)0.74913639452345925918f,
(float16_t)0.66126583783999226540f,(float16_t)0.75015164580621496171f,
(float16_t)0.66011434206742047870f,(float16_t)0.75116513190968636771f,
(float16_t)0.65896129298203731661f,(float16_t)0.75217685044904269986f,
(float16_t)0.65780669329707874837f,(float16_t)0.75318679904361252042f,
(float16_t)0.65665054572942904709f,(float16_t)0.75419497531688917125f,
(float16_t)0.65549285299961546070f,(float16_t)0.75520137689653654700f,
(float16_t)0.65433361783180055138f,(float16_t)0.75620600141439453523f,
(float16_t)0.65317284295377686654f,(float16_t)0.75720884650648456748f,
(float16_t)0.65201053109695950027f,(float16_t)0.75820990981301528144f,
(float16_t)0.65084668499638098638f,(float16_t)0.75920918897838796102f,
(float16_t)0.64968130739068319368f,(float16_t)0.76020668165120242055f,
(float16_t)0.64851440102211255212f,(float16_t)0.76120238548426177871f,
(float16_t)0.64734596863651205911f,(float16_t)0.76219629813457889789f,
(float16_t)0.64617601298331639459f,(float16_t)0.76318841726338126907f,
(float16_t)0.64500453681554403840f,(float16_t)0.76417874053611667406f,
(float16_t)0.64383154288979149715f,(float16_t)0.76516726562245895860f,
(float16_t)0.64265703396622686494f,(float16_t)0.76615399019631280630f,
(float16_t)0.64148101280858316198f,(float16_t)0.76713891193582040007f,
(float16_t)0.64030348218415167327f,(float16_t)0.76812202852336530778f,
(float16_t)0.63912444486377573138f,(float16_t)0.76910333764557958780f,
(float16_t)0.63794390362184416610f,(float16_t)0.77008283699334789674f,
(float16_t)0.63676186123628419899f,(float16_t)0.77106052426181381776f,
(float16_t)0.63557832048855622542f,(float16_t)0.77203639715038441249f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.63320675505005719064f,(float16_t)0.77398269060682278742f,
(float16_t)0.63201873593980906207f,(float16_t)0.77495310659487381955f,
(float16_t)0.63082922962842458148f,(float16_t)0.77592169904340757558f,
(float16_t)0.62963823891492709528f,(float16_t)0.77688846567323244230f,
(float16_t)0.62844576660183271155f,(float16_t)0.77785340420945303652f,
(float16_t)0.62725181549514419377f,(float16_t)0.77881651238147586724f,
(float16_t)0.62605638840434352232f,(float16_t)0.77977778792301444266f,
(float16_t)0.62485948814238645443f,(float16_t)0.78073722857209448822f,
(float16_t)0.62366111752569464155f,(float16_t)0.78169483207105938671f,
(float16_t)0.62246127937415007825f,(float16_t)0.78265059616657572938f,
(float16_t)0.62125997651108766373f,(float16_t)0.78360451860963820092f,
(float16_t)0.62005721176328920663f,(float16_t)0.78455659715557524159f,
(float16_t)0.61885298796097631957f,(float16_t)0.78550682956405393220f,
(float16_t)0.61764730793780397988f,(float16_t)0.78645521359908576731f,
(float16_t)0.61644017453085364622f,(float16_t)0.78740174702903131809f,
(float16_t)0.61523159058062681925f,(float16_t)0.78834642762660622761f,
(float16_t)0.61402155893103849138f,(float16_t)0.78928925316888565167f,
(float16_t)0.61281008242940970820f,(float16_t)0.79023022143731003197f,
(float16_t)0.61159716392646201744f,(float16_t)0.79116933021769009216f,
(float16_t)0.61038280627630947528f,(float16_t)0.79210657730021227785f,
(float16_t)0.60916701233645320634f,(float16_t)0.79304196047944364167f,
(float16_t)0.60794978496777374311f,(float16_t)0.79397547755433717231f,
(float16_t)0.60673112703452447558f,(float16_t)0.79490712632823701256f,
(float16_t)0.60551104140432554512f,(float16_t)0.79583690460888345530f,
(float16_t)0.60428953094815607283f,(float16_t)0.79676481020841871672f,
(float16_t)0.60306659854034827539f,(float16_t)0.79769084094339104407f,
(float16_t)0.60184224705858002658f,(float16_t)0.79861499463476082195f,
(float16_t)0.60061647938386897305f,(float16_t)0.79953726910790501314f,
(float16_t)0.59938929840056454079f,(float16_t)0.80045766219262270980f,
(float16_t)0.59816070699634238395f,(float16_t)0.80137617172314012937f,
(float16_t)0.59693070806219650226f,(float16_t)0.80229279553811572168f,
(float16_t)0.59569930449243346793f,(float16_t)0.80320753148064483184f,
(float16_t)0.59446649918466454299f,(float16_t)0.80412037739826569549f,
(float16_t)0.59323229503979979516f,(float16_t)0.80503133114296365758f,
(float16_t)0.59199669496204099239f,(float16_t)0.80594039057117627944f,
(float16_t)0.59075970185887427544f,(float16_t)0.80684755354379922299f,
(float16_t)0.58952131864106394055f,(float16_t)0.80775281792619024746f,
(float16_t)0.58828154822264533408f,(float16_t)0.80865618158817498262f,
(float16_t)0.58704039352091808013f,(float16_t)0.80955764240405125864f,
(float16_t)0.58579785745643886408f,(float16_t)0.81045719825259476821f,
(float16_t)0.58455394295301532637f,(float16_t)0.81135484701706372945f,
(float16_t)0.58330865293769829094f,(float16_t)0.81225058658520388200f,
(float16_t)0.58206199034077554799f,(float16_t)0.81314441484925359394f,
(float16_t)0.58081395809576452649f,(float16_t)0.81403632970594830276f,
(float16_t)0.57956455913940574387f,(float16_t)0.81492632905652662156f,
(float16_t)0.57831379641165558958f,(float16_t)0.81581441080673378075f,
(float16_t)0.57706167285567955272f,(float16_t)0.81670057286682784525f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.57455335504771576360f,(float16_t)0.81846712958029865792f,
(float16_t)0.57329716669804231532f,(float16_t)0.81934752007679689800f,
(float16_t)0.57203962932475704850f,(float16_t)0.82022598256943468620f,
(float16_t)0.57078074588696736669f,(float16_t)0.82110251499110464835f,
(float16_t)0.56952051934694725155f,(float16_t)0.82197711527924155472f,
(float16_t)0.56825895267013148970f,(float16_t)0.82284978137582631685f,
(float16_t)0.56699604882510867832f,(float16_t)0.82372051122739131657f,
(float16_t)0.56573181078361323149f,(float16_t)0.82458930278502529099f,
(float16_t)0.56446624152051949608f,(float16_t)0.82545615400437744036f,
(float16_t)0.56319934401383409117f,(float16_t)0.82632106284566353427f,
(float16_t)0.56193112124468946877f,(float16_t)0.82718402727366913130f,
(float16_t)0.56066157619733603124f,(float16_t)0.82804504525775579626f,
(float16_t)0.55939071185913613604f,(float16_t)0.82890411477186487499f,
(float16_t)0.55811853122055610221f,(float16_t)0.82976123379452304540f,
(float16_t)0.55684503727516010407f,(float16_t)0.83061640030884620334f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.55429412145362011444f,(float16_t)0.83232086776792968408f,
(float16_t)0.55301670558002757883f,(float16_t)0.83317016470191318511f,
(float16_t)0.55173798840470744675f,(float16_t)0.83401750110601813315f,
(float16_t)0.55045797293660481131f,(float16_t)0.83486287498638001026f,
(float16_t)0.54917666218771976627f,(float16_t)0.83570628435375260423f,
(float16_t)0.54789405917310018967f,(float16_t)0.83654772722351189440f,
(float16_t)0.54661016691083486041f,(float16_t)0.83738720161566193578f,
(float16_t)0.54532498842204646383f,(float16_t)0.83822470555483796772f,
(float16_t)0.54403852673088393122f,(float16_t)0.83906023707031263115f,
(float16_t)0.54275078486451600046f,(float16_t)0.83989379419599941023f,
(float16_t)0.54146176585312355556f,(float16_t)0.84072537497045796151f,
(float16_t)0.54017147272989296525f,(float16_t)0.84155497743689833268f,
(float16_t)0.53887990853100842248f,(float16_t)0.84238259964318584760f,
(float16_t)0.53758707629564550512f,(float16_t)0.84320823964184543620f,
(float16_t)0.53629297906596318235f,(float16_t)0.84403189549006640835f,
(float16_t)0.53499761988709726435f,(float16_t)0.84485356524970700587f,
(float16_t)0.53370100180715296379f,(float16_t)0.84567324698729906540f,
(float16_t)0.53240312787719801246f,(float16_t)0.84649093877405212627f,
(float16_t)0.53110400115125500076f,(float16_t)0.84730663868585831544f,
(float16_t)0.52980362468629482731f,(float16_t)0.84812034480329712149f,
(float16_t)0.52850200154222848337f,(float16_t)0.84893205521163961347f,
(float16_t)0.52719913478190139067f,(float16_t)0.84974176800085243766f,
(float16_t)0.52589502747108474168f,(float16_t)0.85054948126560336874f,
(float16_t)0.52458968267846883826f,(float16_t)0.85135519310526519554f,
(float16_t)0.52328310347565643035f,(float16_t)0.85215890162391982887f,
(float16_t)0.52197529293715438925f,(float16_t)0.85296060493036363059f,
(float16_t)0.52066625414036726838f,(float16_t)0.85376030113811129940f,
(float16_t)0.51935599016558953167f,(float16_t)0.85455798836540053376f,
(float16_t)0.51804450409599933636f,(float16_t)0.85535366473519602870f,
(float16_t)0.51673179901764998423f,(float16_t)0.85614732837519447184f,
(float16_t)0.51541787801946314929f,(float16_t)0.85693897741782865118f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.51278640063356306644f,(float16_t)0.85851622426444273994f,
(float16_t)0.51146885043797052361f,(float16_t)0.85930181835700836235f,
(float16_t)0.51015009670676669806f,(float16_t)0.86008539042939025077f,
(float16_t)0.50883014254310698909f,(float16_t)0.86086693863776730939f,
(float16_t)0.50750899105297087033f,(float16_t)0.86164646114308129921f,
(float16_t)0.50618664534515533937f,(float16_t)0.86242395611104050168f,
(float16_t)0.50486310853126747933f,(float16_t)0.86319942171212415971f,
(float16_t)0.50353838372571757542f,(float16_t)0.86397285612158669643f,
(float16_t)0.50221247404571089934f,(float16_t)0.86474425751946237817f,
(float16_t)0.50088538261124093687f,(float16_t)0.86551362409056897818f,
(float16_t)0.49955711254508183838f,(float16_t)0.86628095402451299467f,
(float16_t)0.49822766697278186854f,(float16_t)0.86704624551569264845f,
(float16_t)0.49689704902265463549f,(float16_t)0.86780949676330321196f,
(float16_t)0.49556526182577248507f,(float16_t)0.86857070597134089507f,
(float16_t)0.49423230851595972846f,(float16_t)0.86932987134860673084f,
(float16_t)0.49289819222978409341f,(float16_t)0.87008699110871134952f,
(float16_t)0.49156291610655006297f,(float16_t)0.87084206347007886428f,
(float16_t)0.49022648328829110387f,(float16_t)0.87159508665595109012f,
(float16_t)0.48888889691976322727f,(float16_t)0.87234605889439142956f,
(float16_t)0.48755016014843605143f,(float16_t)0.87309497841829009079f,
(float16_t)0.48621027612448652899f,(float16_t)0.87384184346536675214f,
(float16_t)0.48486924800079111986f,(float16_t)0.87458665227817611321f,
(float16_t)0.48352707893291874131f,(float16_t)0.87532940310411078144f,
(float16_t)0.48218377207912282989f,(float16_t)0.87607009419540660122f,
(float16_t)0.48083933060033390294f,(float16_t)0.87680872380914576247f,
(float16_t)0.47949375766015300826f,(float16_t)0.87754529020726124156f,
(float16_t)0.47814705642484311987f,(float16_t)0.87827979165654146421f,
(float16_t)0.47679923006332225466f,(float16_t)0.87901222642863341417f,
(float16_t)0.47545028174715586733f,(float16_t)0.87974259280004740713f,
(float16_t)0.47410021465055002254f,(float16_t)0.88047088905216075450f,
(float16_t)0.47274903195034290171f,(float16_t)0.88119711347122198219f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.47004333245959561971f,(float16_t)0.88264333997956279099f,
(float16_t)0.46868882203582795665f,(float16_t)0.88336333866573157891f,
(float16_t)0.46733320874198852612f,(float16_t)0.88408125871263498752f,
(float16_t)0.46597649576796612569f,(float16_t)0.88479709843093778954f,
(float16_t)0.46461868630623781584f,(float16_t)0.88551085613619995307f,
(float16_t)0.46325978355186026025f,(float16_t)0.88622253014888063838f,
(float16_t)0.46189979070246284243f,(float16_t)0.88693211879434208367f,
(float16_t)0.46053871095824000514f,(float16_t)0.88763962040285393496f,
(float16_t)0.45917654752194414502f,(float16_t)0.88834503330959635470f,
(float16_t)0.45781330359887728587f,(float16_t)0.88904835585466457371f,
(float16_t)0.45644898239688386221f,(float16_t)0.88974958638307288794f,
(float16_t)0.45508358712634383592f,(float16_t)0.89044872324475787817f,
(float16_t)0.45371712100016392544f,(float16_t)0.89114576479458318392f,
(float16_t)0.45234958723377099998f,(float16_t)0.89184070939234272313f,
(float16_t)0.45098098904510380835f,(float16_t)0.89253355540276468894f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.44824061228521999700f,(float16_t)0.89391294514520325265f,
(float16_t)0.44686884016237432560f,(float16_t)0.89459948563138258493f,
(float16_t)0.44549601651398174074f,(float16_t)0.89528392103855758410f,
(float16_t)0.44412214457042925586f,(float16_t)0.89596624975618510689f,
(float16_t)0.44274722756457013384f,(float16_t)0.89664647017868015499f,
(float16_t)0.44137126873171661501f,(float16_t)0.89732458070541831763f,
(float16_t)0.43999427130963325583f,(float16_t)0.89800057974073987932f,
(float16_t)0.43861623853852771404f,(float16_t)0.89867446569395381673f,
(float16_t)0.43723717366104419835f,(float16_t)0.89934623697934146236f,
(float16_t)0.43585707992225547480f,(float16_t)0.90001589201616027935f,
(float16_t)0.43447596056965570588f,(float16_t)0.90068342922864685907f,
(float16_t)0.43309381885315201277f,(float16_t)0.90134884704602202810f,
(float16_t)0.43171065802505736997f,(float16_t)0.90201214390249306874f,
(float16_t)0.43032648134008261165f,(float16_t)0.90267331823725882600f,
(float16_t)0.42894129205532954829f,(float16_t)0.90333236849451181705f,
(float16_t)0.42755509343028219593f,(float16_t)0.90398929312344333820f,
(float16_t)0.42616788872679961520f,(float16_t)0.90464409057824624050f,
(float16_t)0.42477968120910880589f,(float16_t)0.90529675931811881551f,
(float16_t)0.42339047414379610279f,(float16_t)0.90594729780726845902f,
(float16_t)0.42200027079979979261f,(float16_t)0.90659570451491533483f,
(float16_t)0.42060907444840250902f,(float16_t)0.90724197791529592738f,
(float16_t)0.41921688836322396066f,(float16_t)0.90788611648766626150f,
(float16_t)0.41782371582021238243f,(float16_t)0.90852811871630612117f,
(float16_t)0.41642956009763731906f,(float16_t)0.90916798309052226923f,
(float16_t)0.41503442447608163146f,(float16_t)0.90980570810465222209f,
(float16_t)0.41363831223843455787f,(float16_t)0.91044129225806713634f,
(float16_t)0.41224122666988299857f,(float16_t)0.91107473405517624965f,
(float16_t)0.41084317105790391089f,(float16_t)0.91170603200542987832f,
(float16_t)0.40944414869225764786f,(float16_t)0.91233518462332274801f,
(float16_t)0.40804416286497874333f,(float16_t)0.91296219042839810154f,
(float16_t)0.40664321687036913966f,(float16_t)0.91358704794525080750f,
(float16_t)0.40524131400498986100f,(float16_t)0.91420975570353069095f,
(float16_t)0.40383845756765412993f,(float16_t)0.91483031223794608611f,
(float16_t)0.40243465085941854120f,(float16_t)0.91544871608826783316f,
(float16_t)0.40102989718357578974f,(float16_t)0.91606496579933160973f,
(float16_t)0.39962419984564678810f,(float16_t)0.91667905992104270485f,
(float16_t)0.39821756215337361651f,(float16_t)0.91729099700837790632f,
(float16_t)0.39680998741671041907f,(float16_t)0.91790077562139038569f,
(float16_t)0.39540147894781629834f,(float16_t)0.91850839432521225181f,
(float16_t)0.39399204006104809883f,(float16_t)0.91911385169005777040f,
(float16_t)0.39258167407295152529f,(float16_t)0.91971714629122736095f,
(float16_t)0.39117038430225398171f,(float16_t)0.92031827670911048322f,
(float16_t)0.38975817406985641123f,(float16_t)0.92091724152918941204f,
(float16_t)0.38834504669882630168f,(float16_t)0.92151403934204190183f,
(float16_t)0.38693100551438869283f,(float16_t)0.92210866874334507237f,
(float16_t)0.38551605384391901543f,(float16_t)0.92270112833387851747f,
(float16_t)0.38410019501693504207f,(float16_t)0.92329141671952763559f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.38126576922216248722f,(float16_t)0.92446547432526260391f,
(float16_t)0.37984720892405110515f,(float16_t)0.92504924078267758425f,
(float16_t)0.37842775480876561511f,(float16_t)0.92563083050987271516f,
(float16_t)0.37700741021641831496f,(float16_t)0.92621024213831126826f,
(float16_t)0.37558617848921732607f,(float16_t)0.92678747430458174872f,
(float16_t)0.37416406297145798909f,(float16_t)0.92736252565040111495f,
(float16_t)0.37274106700951581406f,(float16_t)0.92793539482261788720f,
(float16_t)0.37131719395183759858f,(float16_t)0.92850608047321558924f,
(float16_t)0.36989244714893426691f,(float16_t)0.92907458125931574600f,
(float16_t)0.36846682995337232125f,(float16_t)0.92964089584318121418f,
(float16_t)0.36704034571976723589f,(float16_t)0.93020502289221906889f,
(float16_t)0.36561299780477396482f,(float16_t)0.93076696107898371224f,
(float16_t)0.36418478956707983629f,(float16_t)0.93132670908118042608f,
(float16_t)0.36275572436739722537f,(float16_t)0.93188426558166814750f,
(float16_t)0.36132580556845433906f,(float16_t)0.93243962926846235550f,
(float16_t)0.35989503653498827740f,(float16_t)0.93299279883473884567f,
(float16_t)0.35846342063373654030f,(float16_t)0.93354377297883617270f,
(float16_t)0.35703096123343003310f,(float16_t)0.93409255040425887007f,
(float16_t)0.35559766170478396274f,(float16_t)0.93463912981968078064f,
(float16_t)0.35416352542049051033f,(float16_t)0.93518350993894749923f,
(float16_t)0.35272855575521072646f,(float16_t)0.93572568948108036935f,
(float16_t)0.35129275608556714827f,(float16_t)0.93626566717027825959f,
(float16_t)0.34985612979013502866f,(float16_t)0.93680344173592156043f,
(float16_t)0.34841868024943450921f,(float16_t)0.93733901191257495977f,
(float16_t)0.34698041084592368133f,(float16_t)0.93787237643998988545f,
(float16_t)0.34554132496398914931f,(float16_t)0.93840353406310805795f,
(float16_t)0.34410142598993898044f,(float16_t)0.93893248353206448797f,
(float16_t)0.34266071731199437833f,(float16_t)0.93945922360218991898f,
(float16_t)0.34121920232028241093f,(float16_t)0.93998375303401393577f,
(float16_t)0.33977688440682696225f,(float16_t)0.94050607059326829518f,
(float16_t)0.33833376696554129381f,(float16_t)0.94102617505088925753f,
(float16_t)0.33688985339222005111f,(float16_t)0.94154406518302080631f,
(float16_t)0.33544514708453165852f,(float16_t)0.94205973977101731265f,
(float16_t)0.33399965144200949307f,(float16_t)0.94257319760144686605f,
(float16_t)0.33255336986604422389f,(float16_t)0.94308443746609349478f,
(float16_t)0.33110630575987642921f,(float16_t)0.94359345816196038559f,
(float16_t)0.32965846252858754806f,(float16_t)0.94410025849127265918f,
(float16_t)0.32820984357909266382f,(float16_t)0.94460483726148025685f,
(float16_t)0.32676045232013178898f,(float16_t)0.94510719328526060501f,
(float16_t)0.32531029216226298173f,(float16_t)0.94560732538052127971f,
(float16_t)0.32385936651785296458f,(float16_t)0.94610523237040333733f,
(float16_t)0.32240767880107001897f,(float16_t)0.94660091308328353499f,
(float16_t)0.32095523242787521445f,(float16_t)0.94709436635277721717f,
(float16_t)0.31950203081601574739f,(float16_t)0.94758559101774109124f,
(float16_t)0.31804807738501505998f,(float16_t)0.94807458592227622507f,
(float16_t)0.31659337555616584581f,(float16_t)0.94856134991573026749f,
(float16_t)0.31513792875252244485f,(float16_t)0.94904588185270055689f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.31222481392182505067f,(float16_t)0.95000824500184299914f,
(float16_t)0.31076715274961147495f,(float16_t)0.95048607394948170235f,
(float16_t)0.30930876031226878231f,(float16_t)0.95096166631157508231f,
(float16_t)0.30784964004153497763f,(float16_t)0.95143502096900833820f,
(float16_t)0.30638979537086108440f,(float16_t)0.95190613680793223494f,
(float16_t)0.30492922973540242948f,(float16_t)0.95237501271976587880f,
(float16_t)0.30346794657201137113f,(float16_t)0.95284164760119871573f,
(float16_t)0.30200594931922819519f,(float16_t)0.95330604035419375109f,
(float16_t)0.30054324141727339903f,(float16_t)0.95376818988599032512f,
(float16_t)0.29907982630804047508f,(float16_t)0.95422809510910566733f,
(float16_t)0.29761570743508630743f,(float16_t)0.95468575494133833814f,
(float16_t)0.29615088824362395536f,(float16_t)0.95514116830577067141f,
(float16_t)0.29468537218051432669f,(float16_t)0.95559433413077110586f,
(float16_t)0.29321916269425868373f,(float16_t)0.95604525134999640557f,
(float16_t)0.29175226323498937298f,(float16_t)0.95649391890239499059f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.28881640820604947972f,(float16_t)0.95738450078897585627f,
(float16_t)0.28734745954472956653f,(float16_t)0.95782641302753290802f,
(float16_t)0.28587783472708072630f,(float16_t)0.95826607140801767226f,
(float16_t)0.28440753721127182141f,(float16_t)0.95870347489587159906f,
(float16_t)0.28293657045705539188f,(float16_t)0.95913862246184189431f,
(float16_t)0.28146493792575805193f,(float16_t)0.95957151308198451733f,
(float16_t)0.27999264308027338455f,(float16_t)0.96000214573766584625f,
(float16_t)0.27851968938505305973f,(float16_t)0.96043051941556578655f,
(float16_t)0.27704608030609995106f,(float16_t)0.96085663310767965850f,
(float16_t)0.27557181931095825478f,(float16_t)0.96128048581132063966f,
(float16_t)0.27409690986870632878f,(float16_t)0.96170207652912254037f,
(float16_t)0.27262135544994897662f,(float16_t)0.96212140426904158019f,
(float16_t)0.27114515952680806610f,(float16_t)0.96253846804435916340f,
(float16_t)0.26966832557291520178f,(float16_t)0.96295326687368387741f,
(float16_t)0.26819085706340317632f,(float16_t)0.96336579978095404631f,
(float16_t)0.26671275747489842090f,(float16_t)0.96377606579543984022f,
(float16_t)0.26523403028551190141f,(float16_t)0.96418406395174571788f,
(float16_t)0.26375467897483151347f,(float16_t)0.96458979328981264700f,
(float16_t)0.26227470702391358914f,(float16_t)0.96499325285492032478f,
(float16_t)0.26079411791527556952f,(float16_t)0.96539444169768939830f,
(float16_t)0.25931291513288634576f,(float16_t)0.96579335887408357397f,
(float16_t)0.25783110216215893162f,(float16_t)0.96619000344541261516f,
(float16_t)0.25634868248994291395f,(float16_t)0.96658437447833311928f,
(float16_t)0.25486565960451462720f,(float16_t)0.96697647104485207059f,
(float16_t)0.25338203699557027004f,(float16_t)0.96736629222232850545f,
(float16_t)0.25189781815421691258f,(float16_t)0.96775383709347551076f,
(float16_t)0.25041300657296527987f,(float16_t)0.96813910474636244441f,
(float16_t)0.24892760574572025956f,(float16_t)0.96852209427441726675f,
(float16_t)0.24744161916777343557f,(float16_t)0.96890280477642887202f,
(float16_t)0.24595505033579459497f,(float16_t)0.96928123535654853171f,
(float16_t)0.24446790274782420616f,(float16_t)0.96965738512429244800f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.24149188530286930243f,(float16_t)0.97040283868755550234f,
(float16_t)0.24000302244874149871f,(float16_t)0.97077214072895035013f,
(float16_t)0.23851359484431849944f,(float16_t)0.97113915844972509284f,
(float16_t)0.23702360599436733679f,(float16_t)0.97150389098625178352f,
(float16_t)0.23553305940497545889f,(float16_t)0.97186633748027939639f,
(float16_t)0.23404195858354345794f,(float16_t)0.97222649707893626925f,
(float16_t)0.23255030703877532794f,(float16_t)0.97258436893473221296f,
(float16_t)0.23105810828067127605f,(float16_t)0.97293995220556006576f,
(float16_t)0.22956536582051886852f,(float16_t)0.97329324605469824672f,
(float16_t)0.22807208317088578653f,(float16_t)0.97364424965081186603f,
(float16_t)0.22657826384561011168f,(float16_t)0.97399296216795583359f,
(float16_t)0.22508391135979277653f,(float16_t)0.97433938278557585821f,
(float16_t)0.22358902922979001504f,(float16_t)0.97468351068851066810f,
(float16_t)0.22209362097320359264f,(float16_t)0.97502534506699412020f,
(float16_t)0.22059769010887364526f,(float16_t)0.97536488511665686563f,
(float16_t)0.21910124015686976984f,(float16_t)0.97570213003852857003f,
(float16_t)0.21760427463848366902f,(float16_t)0.97603707903903902388f,
(float16_t)0.21610679707621960333f,(float16_t)0.97636973133002114000f,
(float16_t)0.21460881099378692483f,(float16_t)0.97670008612871184184f,
(float16_t)0.21311031991609136194f,(float16_t)0.97702814265775439484f,
(float16_t)0.21161132736922760866f,(float16_t)0.97735390014519996082f,
(float16_t)0.21011183688046972118f,(float16_t)0.97767735782450992943f,
(float16_t)0.20861185197826345727f,(float16_t)0.97799851493455713936f,
(float16_t)0.20711137619221856032f,(float16_t)0.97831737071962765473f,
(float16_t)0.20561041305309932237f,(float16_t)0.97863392442942309657f,
(float16_t)0.20410896609281700687f,(float16_t)0.97894817531906219710f,
(float16_t)0.20260703884442110567f,(float16_t)0.97926012264908202098f,
(float16_t)0.20110463484209195606f,(float16_t)0.97956976568544051887f,
(float16_t)0.19960175762113105402f,(float16_t)0.97987710369951763756f,
(float16_t)0.19809841071795372680f,(float16_t)0.98018213596811731847f,
(float16_t)0.19659459767008022335f,(float16_t)0.98048486177346938497f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.19358558729580374602f,(float16_t)0.98108339115048659451f,
(float16_t)0.19208039704989238183f,(float16_t)0.98137919331375456089f,
(float16_t)0.19057475482025279523f,(float16_t)0.98167268619698311305f,
(float16_t)0.18906866414980627589f,(float16_t)0.98196386910955524296f,
(float16_t)0.18756212858252974129f,(float16_t)0.98225274136628937249f,
(float16_t)0.18605515166344663291f,(float16_t)0.98253930228744124076f,
(float16_t)0.18454773693861964423f,(float16_t)0.98282355119870523641f,
(float16_t)0.18303988795514106180f,(float16_t)0.98310548743121628501f,
(float16_t)0.18153160826112513249f,(float16_t)0.98338511032155118130f,
(float16_t)0.18002290140569951471f,(float16_t)0.98366241921173025453f,
(float16_t)0.17851377093899759019f,(float16_t)0.98393741344921892278f,
(float16_t)0.17700422041214886049f,(float16_t)0.98421009238692902521f,
(float16_t)0.17549425337727139751f,(float16_t)0.98448045538322093151f,
(float16_t)0.17398387338746384989f,(float16_t)0.98474850180190420801f,
(float16_t)0.17247308399679603386f,(float16_t)0.98501423101223983814f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.16945029123396793125f,(float16_t)0.98553873531217606185f,
(float16_t)0.16793829497473122814f,(float16_t)0.98579750916756736512f,
(float16_t)0.16642590354046421508f,(float16_t)0.98605396334619543897f,
(float16_t)0.16491312048997008866f,(float16_t)0.98630809724459866938f,
(float16_t)0.16339994938297322524f,(float16_t)0.98655991026477540817f,
(float16_t)0.16188639378011188130f,(float16_t)0.98680940181418541624f,
(float16_t)0.16037245724292839566f,(float16_t)0.98705657130575097380f,
(float16_t)0.15885814333386139019f,(float16_t)0.98730141815785843473f,
(float16_t)0.15734345561623827581f,(float16_t)0.98754394179435922574f,
(float16_t)0.15582839765426531597f,(float16_t)0.98778414164457217783f,
(float16_t)0.15431297301302024372f,(float16_t)0.98802201714328352633f,
(float16_t)0.15279718525844340760f,(float16_t)0.98825756773074946437f,
(float16_t)0.15128103795733024994f,(float16_t)0.98849079285269658701f,
(float16_t)0.14976453467732162017f,(float16_t)0.98872169196032377858f,
(float16_t)0.14824767898689619749f,(float16_t)0.98895026451030298986f,
(float16_t)0.14673047445536174793f,(float16_t)0.98917650996478101444f,
(float16_t)0.14521292465284751927f,(float16_t)0.98940042779138037687f,
(float16_t)0.14369503315029458212f,(float16_t)0.98962201746320077600f,
(float16_t)0.14217680351944800288f,(float16_t)0.98984127845882052821f,
(float16_t)0.14065823933284923863f,(float16_t)0.99005821026229712256f,
(float16_t)0.13913934416382628401f,(float16_t)0.99027281236316910817f,
(float16_t)0.13762012158648617710f,(float16_t)0.99048508425645698239f,
(float16_t)0.13610057517570620100f,(float16_t)0.99069502544266463406f,
(float16_t)0.13458070850712622324f,(float16_t)0.99090263542778000971f,
(float16_t)0.13306052515713917561f,(float16_t)0.99110791372327677884f,
(float16_t)0.13154002870288328264f,(float16_t)0.99131085984611544415f,
(float16_t)0.13001922272223334631f,(float16_t)0.99151147331874389668f,
(float16_t)0.12849811079379322432f,(float16_t)0.99170975366909952520f,
(float16_t)0.12697669649688597682f,(float16_t)0.99190570043060932726f,
(float16_t)0.12545498341154620592f,(float16_t)0.99209931314219179654f,
(float16_t)0.12393297511851220083f,(float16_t)0.99229059134825736699f,
(float16_t)0.12241067519921627893f,(float16_t)0.99247953459870996706f,
(float16_t)0.12088808723577722237f,(float16_t)0.99266614244894801899f,
(float16_t)0.11936521481099135467f,(float16_t)0.99285041445986510489f,
(float16_t)0.11784206150832501891f,(float16_t)0.99303235019785141002f,
(float16_t)0.11631863091190487725f,(float16_t)0.99321194923479450001f,
(float16_t)0.11479492660651025027f,(float16_t)0.99338921114808065305f,
(float16_t)0.11327095217756436019f,(float16_t)0.99356413552059530403f,
(float16_t)0.11174671121112665639f,(float16_t)0.99373672194072459884f,
(float16_t)0.11022220729388318428f,(float16_t)0.99390697000235606051f,
(float16_t)0.10869744401313867488f,(float16_t)0.99407487930487936634f,
(float16_t)0.10717242495680887049f,(float16_t)0.99424044945318790223f,
(float16_t)0.10564715371341069916f,(float16_t)0.99440368005767909576f,
(float16_t)0.10412163387205472520f,(float16_t)0.99456457073425541537f,
(float16_t)0.10259586902243628126f,(float16_t)0.99472312110432570265f,
(float16_t)0.10106986275482787718f,(float16_t)0.99487933079480561638f,
(float16_t)0.09954361866006944393f,(float16_t)0.99503319943811863180f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.09649043135525260662f,(float16_t)0.99533391214048227980f,
(float16_t)0.09496349532963906104f,(float16_t)0.99548075549192693856f,
(float16_t)0.09343633584574791151f,(float16_t)0.99562525638099430569f,
(float16_t)0.09190895649713269611f,(float16_t)0.99576741446765981713f,
(float16_t)0.09038136087786501072f,(float16_t)0.99590722941741172125f,
(float16_t)0.08885355258252468358f,(float16_t)0.99604470090125196702f,
(float16_t)0.08732553520619222576f,(float16_t)0.99617982859569687015f,
(float16_t)0.08579731234443987997f,(float16_t)0.99631261218277800129f,
(float16_t)0.08426888759332412659f,(float16_t)0.99644305135004263008f,
(float16_t)0.08274026454937580266f,(float16_t)0.99657114579055483539f,
(float16_t)0.08121144680959238582f,(float16_t)0.99669689520289606044f,
(float16_t)0.07968243797143012563f,(float16_t)0.99682029929116566791f,
(float16_t)0.07815324163279431524f,(float16_t)0.99694135776498216117f,
(float16_t)0.07662386139203161695f,(float16_t)0.99706007033948296225f,
(float16_t)0.07509430084792129145f,(float16_t)0.99717643673532618820f,
(float16_t)0.07356456359966745406f,(float16_t)0.99729045667869020697f,
(float16_t)0.07203465324688941573f,(float16_t)0.99740212990127530279f,
(float16_t)0.07050457338961400866f,(float16_t)0.99751145614030345410f,
(float16_t)0.06897432762826673225f,(float16_t)0.99761843513851955478f,
(float16_t)0.06744391956366410645f,(float16_t)0.99772306664419163624f,
(float16_t)0.06591335279700392957f,(float16_t)0.99782535041111164453f,
(float16_t)0.06438263092985740954f,(float16_t)0.99792528619859599548f,
(float16_t)0.06285175756416142012f,(float16_t)0.99802287377148624081f,
(float16_t)0.06132073630220864768f,(float16_t)0.99811811290014917919f,
(float16_t)0.05978957074664000698f,(float16_t)0.99821100336047818846f,
(float16_t)0.05825826450043573163f,(float16_t)0.99830154493389289261f,
(float16_t)0.05672682116690778292f,(float16_t)0.99838973740734016094f,
(float16_t)0.05519524434969003135f,(float16_t)0.99847558057329477421f,
(float16_t)0.05366353765273067927f,(float16_t)0.99855907422975931365f,
(float16_t)0.05213170468028331672f,(float16_t)0.99864021818026527111f,
(float16_t)0.05059974903689933717f,(float16_t)0.99871901223387293811f,
(float16_t)0.04906767432741812596f,(float16_t)0.99879545620517240501f,
(float16_t)0.04753548415695926094f,(float16_t)0.99886954991428356099f,
(float16_t)0.04600318213091464381f,(float16_t)0.99894129318685687124f,
(float16_t)0.04447077185493874402f,(float16_t)0.99901068585407337697f,
(float16_t)0.04293825693494095902f,(float16_t)0.99907772775264536147f,
(float16_t)0.04140564097707671171f,(float16_t)0.99914241872481690532f,
(float16_t)0.03987292758773984536f,(float16_t)0.99920475861836388631f,
(float16_t)0.03834012037355279123f,(float16_t)0.99926474728659442359f,
(float16_t)0.03680722294135899131f,(float16_t)0.99932238458834954375f,
(float16_t)0.03527423889821394709f,(float16_t)0.99937767038800284780f,
(float16_t)0.03374117185137764235f,(float16_t)0.99943060455546173237f,
(float16_t)0.03220802540830470378f,(float16_t)0.99948118696616694567f,
(float16_t)0.03067480317663658085f,(float16_t)0.99952941750109314256f,
(float16_t)0.02914150876419373953f,(float16_t)0.99957529604674921764f,
(float16_t)0.02760814577896581953f,(float16_t)0.99961882249517863830f,
(float16_t)0.02607471782910403962f,(float16_t)0.99965999674395922270f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)0.02300768146883941032f,(float16_t)0.99973528826056168306f,
(float16_t)0.02147408027546960502f,(float16_t)0.99976940535121527898f,
(float16_t)0.01994042855151459750f,(float16_t)0.99980116988788425569f,
(float16_t)0.01840672990580482019f,(float16_t)0.99983058179582340319f,
(float16_t)0.01687298794728177287f,(float16_t)0.99985764100582386060f,
(float16_t)0.01533920628498821985f,(float16_t)0.99988234745421256111f,
(float16_t)0.01380538852806034895f,(float16_t)0.99990470108285289808f,
(float16_t)0.01227153828571994447f,(float16_t)0.99992470183914450299f,
(float16_t)0.01073765916726457208f,(float16_t)0.99994234967602391162f,
(float16_t)0.00920375478205995995f,(float16_t)0.99995764455196389786f,
(float16_t)0.00766982873953107706f,(float16_t)0.99997058643097413988f,
(float16_t)0.00613588464915451517f,(float16_t)0.99998117528260110909f,
(float16_t)0.00460192612044867198f,(float16_t)0.99998941108192840321f,
(float16_t)0.00306795676296613791f,(float16_t)0.99999529380957619118f,
(float16_t)0.00153398018628476615f,(float16_t)0.99999882345170187925f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99998117528260110909f,(float16_t)0.00613588464915447527f,
(float16_t)0.99992470183914450299f,(float16_t)0.01227153828571992539f,
(float16_t)0.99983058179582340319f,(float16_t)0.01840672990580482019f,
(float16_t)0.99969881869620424997f,(float16_t)0.02454122852291228812f,
(float16_t)0.99952941750109314256f,(float16_t)0.03067480317663662595f,
(float16_t)0.99932238458834954375f,(float16_t)0.03680722294135883171f,
(float16_t)0.99907772775264536147f,(float16_t)0.04293825693494082024f,
(float16_t)0.99879545620517240501f,(float16_t)0.04906767432741801493f,
(float16_t)0.99847558057329477421f,(float16_t)0.05519524434968993420f,
(float16_t)0.99811811290014917919f,(float16_t)0.06132073630220857829f,
(float16_t)0.99772306664419163624f,(float16_t)0.06744391956366405094f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.99682029929116566791f,(float16_t)0.07968243797143012563f,
(float16_t)0.99631261218277800129f,(float16_t)0.08579731234443989385f,
(float16_t)0.99576741446765981713f,(float16_t)0.09190895649713272386f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.99456457073425541537f,(float16_t)0.10412163387205458642f,
(float16_t)0.99390697000235606051f,(float16_t)0.11022220729388305938f,
(float16_t)0.99321194923479450001f,(float16_t)0.11631863091190475235f,
(float16_t)0.99247953459870996706f,(float16_t)0.12241067519921619566f,
(float16_t)0.99170975366909952520f,(float16_t)0.12849811079379316880f,
(float16_t)0.99090263542778000971f,(float16_t)0.13458070850712616773f,
(float16_t)0.99005821026229712256f,(float16_t)0.14065823933284921088f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98825756773074946437f,(float16_t)0.15279718525844343535f,
(float16_t)0.98730141815785843473f,(float16_t)0.15885814333386144570f,
(float16_t)0.98630809724459866938f,(float16_t)0.16491312048996989437f,
(float16_t)0.98527764238894122162f,(float16_t)0.17096188876030121717f,
(float16_t)0.98421009238692902521f,(float16_t)0.17700422041214874946f,
(float16_t)0.98310548743121628501f,(float16_t)0.18303988795514095078f,
(float16_t)0.98196386910955524296f,(float16_t)0.18906866414980619262f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.97956976568544051887f,(float16_t)0.20110463484209190055f,
(float16_t)0.97831737071962765473f,(float16_t)0.20711137619221856032f,
(float16_t)0.97702814265775439484f,(float16_t)0.21311031991609136194f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.97433938278557585821f,(float16_t)0.22508391135979283204f,
(float16_t)0.97293995220556017678f,(float16_t)0.23105810828067110951f,
(float16_t)0.97150389098625178352f,(float16_t)0.23702360599436719801f,
(float16_t)0.97003125319454397424f,(float16_t)0.24298017990326387094f,
(float16_t)0.96852209427441737777f,(float16_t)0.24892760574572014853f,
(float16_t)0.96697647104485207059f,(float16_t)0.25486565960451457169f,
(float16_t)0.96539444169768939830f,(float16_t)0.26079411791527551401f,
(float16_t)0.96377606579543984022f,(float16_t)0.26671275747489836538f,
(float16_t)0.96212140426904158019f,(float16_t)0.27262135544994897662f,
(float16_t)0.96043051941556578655f,(float16_t)0.27851968938505305973f,
(float16_t)0.95870347489587159906f,(float16_t)0.28440753721127187692f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.95514116830577078243f,(float16_t)0.29615088824362378883f,
(float16_t)0.95330604035419386211f,(float16_t)0.30200594931922808417f,
(float16_t)0.95143502096900833820f,(float16_t)0.30784964004153486661f,
(float16_t)0.94952818059303667475f,(float16_t)0.31368174039889151761f,
(float16_t)0.94758559101774109124f,(float16_t)0.31950203081601569188f,
(float16_t)0.94560732538052127971f,(float16_t)0.32531029216226292622f,
(float16_t)0.94359345816196038559f,(float16_t)0.33110630575987642921f,
(float16_t)0.94154406518302080631f,(float16_t)0.33688985339222005111f,
(float16_t)0.93945922360218991898f,(float16_t)0.34266071731199437833f,
(float16_t)0.93733901191257495977f,(float16_t)0.34841868024943456472f,
(float16_t)0.93518350993894761025f,(float16_t)0.35416352542049034380f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.93076696107898371224f,(float16_t)0.36561299780477385379f,
(float16_t)0.92850608047321558924f,(float16_t)0.37131719395183754306f,
(float16_t)0.92621024213831137928f,(float16_t)0.37700741021641825945f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.92151403934204190183f,(float16_t)0.38834504669882624617f,
(float16_t)0.91911385169005777040f,(float16_t)0.39399204006104809883f,
(float16_t)0.91667905992104270485f,(float16_t)0.39962419984564678810f,
(float16_t)0.91420975570353069095f,(float16_t)0.40524131400498986100f,
(float16_t)0.91170603200542987832f,(float16_t)0.41084317105790391089f,
(float16_t)0.90916798309052238025f,(float16_t)0.41642956009763715253f,
(float16_t)0.90659570451491533483f,(float16_t)0.42200027079979968159f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.90134884704602202810f,(float16_t)0.43309381885315195726f,
(float16_t)0.89867446569395381673f,(float16_t)0.43861623853852765853f,
(float16_t)0.89596624975618521791f,(float16_t)0.44412214457042920035f,
(float16_t)0.89322430119551532446f,(float16_t)0.44961132965460653965f,
(float16_t)0.89044872324475787817f,(float16_t)0.45508358712634383592f,
(float16_t)0.88763962040285393496f,(float16_t)0.46053871095824000514f,
(float16_t)0.88479709843093778954f,(float16_t)0.46597649576796618121f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.87901222642863352519f,(float16_t)0.47679923006332208812f,
(float16_t)0.87607009419540660122f,(float16_t)0.48218377207912271887f,
(float16_t)0.87309497841829009079f,(float16_t)0.48755016014843599592f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.86704624551569264845f,(float16_t)0.49822766697278181303f,
(float16_t)0.86397285612158669643f,(float16_t)0.50353838372571757542f,
(float16_t)0.86086693863776730939f,(float16_t)0.50883014254310698909f,
(float16_t)0.85772861000027211809f,(float16_t)0.51410274419322166128f,
(float16_t)0.85455798836540053376f,(float16_t)0.51935599016558964269f,
(float16_t)0.85135519310526519554f,(float16_t)0.52458968267846894928f,
(float16_t)0.84812034480329723252f,(float16_t)0.52980362468629460526f,
(float16_t)0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)0.84155497743689844370f,(float16_t)0.54017147272989285423f,
(float16_t)0.83822470555483807875f,(float16_t)0.54532498842204646383f,
(float16_t)0.83486287498638001026f,(float16_t)0.55045797293660481131f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.82804504525775579626f,(float16_t)0.56066157619733603124f,
(float16_t)0.82458930278502529099f,(float16_t)0.56573181078361312046f,
(float16_t)0.82110251499110464835f,(float16_t)0.57078074588696725566f,
(float16_t)0.81758481315158371139f,(float16_t)0.57580819141784533866f,
(float16_t)0.81403632970594841378f,(float16_t)0.58081395809576452649f,
(float16_t)0.81045719825259476821f,(float16_t)0.58579785745643886408f,
(float16_t)0.80684755354379933401f,(float16_t)0.59075970185887416442f,
(float16_t)0.80320753148064494287f,(float16_t)0.59569930449243335691f,
(float16_t)0.79953726910790501314f,(float16_t)0.60061647938386897305f,
(float16_t)0.79583690460888356633f,(float16_t)0.60551104140432554512f,
(float16_t)0.79210657730021238887f,(float16_t)0.61038280627630947528f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.78455659715557524159f,(float16_t)0.62005721176328909561f,
(float16_t)0.78073722857209448822f,(float16_t)0.62485948814238634341f,
(float16_t)0.77688846567323244230f,(float16_t)0.62963823891492698426f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.76910333764557969882f,(float16_t)0.63912444486377573138f,
(float16_t)0.76516726562245895860f,(float16_t)0.64383154288979138613f,
(float16_t)0.76120238548426177871f,(float16_t)0.64851440102211244110f,
(float16_t)0.75720884650648456748f,(float16_t)0.65317284295377675551f,
(float16_t)0.75318679904361252042f,(float16_t)0.65780669329707863735f,
(float16_t)0.74913639452345937020f,(float16_t)0.66241577759017178373f,
(float16_t)0.74505778544146594733f,(float16_t)0.66699992230363747137f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.73681656887736979300f,(float16_t)0.67609270357531592310f,
(float16_t)0.73265427167241281570f,(float16_t)0.68060099779545302212f,
(float16_t)0.72846439044822519637f,(float16_t)0.68508366777270035541f,
(float16_t)0.72424708295146700276f,(float16_t)0.68954054473706682948f,
(float16_t)0.72000250796138165477f,(float16_t)0.69397146088965389055f,
(float16_t)0.71573082528381870571f,(float16_t)0.69837624940897280457f,
(float16_t)0.71143219574521643356f,(float16_t)0.70275474445722529993f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.70275474445722529993f,(float16_t)0.71143219574521643356f,
(float16_t)0.69837624940897291559f,(float16_t)0.71573082528381859468f,
(float16_t)0.69397146088965400157f,(float16_t)0.72000250796138165477f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.68508366777270035541f,(float16_t)0.72846439044822519637f,
(float16_t)0.68060099779545302212f,(float16_t)0.73265427167241281570f,
(float16_t)0.67609270357531603413f,(float16_t)0.73681656887736979300f,
(float16_t)0.67155895484701833009f,(float16_t)0.74095112535495910588f,
(float16_t)0.66699992230363747137f,(float16_t)0.74505778544146594733f,
(float16_t)0.66241577759017178373f,(float16_t)0.74913639452345925918f,
(float16_t)0.65780669329707874837f,(float16_t)0.75318679904361252042f,
(float16_t)0.65317284295377686654f,(float16_t)0.75720884650648456748f,
(float16_t)0.64851440102211255212f,(float16_t)0.76120238548426177871f,
(float16_t)0.64383154288979149715f,(float16_t)0.76516726562245895860f,
(float16_t)0.63912444486377573138f,(float16_t)0.76910333764557958780f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.62963823891492709528f,(float16_t)0.77688846567323244230f,
(float16_t)0.62485948814238645443f,(float16_t)0.78073722857209448822f,
(float16_t)0.62005721176328920663f,(float16_t)0.78455659715557524159f,
(float16_t)0.61523159058062681925f,(float16_t)0.78834642762660622761f,
(float16_t)0.61038280627630947528f,(float16_t)0.79210657730021227785f,
(float16_t)0.60551104140432554512f,(float16_t)0.79583690460888345530f,
(float16_t)0.60061647938386897305f,(float16_t)0.79953726910790501314f,
(float16_t)0.59569930449243346793f,(float16_t)0.80320753148064483184f,
(float16_t)0.59075970185887427544f,(float16_t)0.80684755354379922299f,
(float16_t)0.58579785745643886408f,(float16_t)0.81045719825259476821f,
(float16_t)0.58081395809576452649f,(float16_t)0.81403632970594830276f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.57078074588696736669f,(float16_t)0.82110251499110464835f,
(float16_t)0.56573181078361323149f,(float16_t)0.82458930278502529099f,
(float16_t)0.56066157619733603124f,(float16_t)0.82804504525775579626f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.55045797293660481131f,(float16_t)0.83486287498638001026f,
(float16_t)0.54532498842204646383f,(float16_t)0.83822470555483796772f,
(float16_t)0.54017147272989296525f,(float16_t)0.84155497743689833268f,
(float16_t)0.53499761988709726435f,(float16_t)0.84485356524970700587f,
(float16_t)0.52980362468629482731f,(float16_t)0.84812034480329712149f,
(float16_t)0.52458968267846883826f,(float16_t)0.85135519310526519554f,
(float16_t)0.51935599016558953167f,(float16_t)0.85455798836540053376f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.50883014254310698909f,(float16_t)0.86086693863776730939f,
(float16_t)0.50353838372571757542f,(float16_t)0.86397285612158669643f,
(float16_t)0.49822766697278186854f,(float16_t)0.86704624551569264845f,
(float16_t)0.49289819222978409341f,(float16_t)0.87008699110871134952f,
(float16_t)0.48755016014843605143f,(float16_t)0.87309497841829009079f,
(float16_t)0.48218377207912282989f,(float16_t)0.87607009419540660122f,
(float16_t)0.47679923006332225466f,(float16_t)0.87901222642863341417f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.46597649576796612569f,(float16_t)0.88479709843093778954f,
(float16_t)0.46053871095824000514f,(float16_t)0.88763962040285393496f,
(float16_t)0.45508358712634383592f,(float16_t)0.89044872324475787817f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.44412214457042925586f,(float16_t)0.89596624975618510689f,
(float16_t)0.43861623853852771404f,(float16_t)0.89867446569395381673f,
(float16_t)0.43309381885315201277f,(float16_t)0.90134884704602202810f,
(float16_t)0.42755509343028219593f,(float16_t)0.90398929312344333820f,
(float16_t)0.42200027079979979261f,(float16_t)0.90659570451491533483f,
(float16_t)0.41642956009763731906f,(float16_t)0.90916798309052226923f,
(float16_t)0.41084317105790391089f,(float16_t)0.91170603200542987832f,
(float16_t)0.40524131400498986100f,(float16_t)0.91420975570353069095f,
(float16_t)0.39962419984564678810f,(float16_t)0.91667905992104270485f,
(float16_t)0.39399204006104809883f,(float16_t)0.91911385169005777040f,
(float16_t)0.38834504669882630168f,(float16_t)0.92151403934204190183f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.37700741021641831496f,(float16_t)0.92621024213831126826f,
(float16_t)0.37131719395183759858f,(float16_t)0.92850608047321558924f,
(float16_t)0.36561299780477396482f,(float16_t)0.93076696107898371224f,
(float16_t)0.35989503653498827740f,(float16_t)0.93299279883473884567f,
(float16_t)0.35416352542049051033f,(float16_t)0.93518350993894749923f,
(float16_t)0.34841868024943450921f,(float16_t)0.93733901191257495977f,
(float16_t)0.34266071731199437833f,(float16_t)0.93945922360218991898f,
(float16_t)0.33688985339222005111f,(float16_t)0.94154406518302080631f,
(float16_t)0.33110630575987642921f,(float16_t)0.94359345816196038559f,
(float16_t)0.32531029216226298173f,(float16_t)0.94560732538052127971f,
(float16_t)0.31950203081601574739f,(float16_t)0.94758559101774109124f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.30784964004153497763f,(float16_t)0.95143502096900833820f,
(float16_t)0.30200594931922819519f,(float16_t)0.95330604035419375109f,
(float16_t)0.29615088824362395536f,(float16_t)0.95514116830577067141f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.28440753721127182141f,(float16_t)0.95870347489587159906f,
(float16_t)0.27851968938505305973f,(float16_t)0.96043051941556578655f,
(float16_t)0.27262135544994897662f,(float16_t)0.96212140426904158019f,
(float16_t)0.26671275747489842090f,(float16_t)0.96377606579543984022f,
(float16_t)0.26079411791527556952f,(float16_t)0.96539444169768939830f,
(float16_t)0.25486565960451462720f,(float16_t)0.96697647104485207059f,
(float16_t)0.24892760574572025956f,(float16_t)0.96852209427441726675f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.23702360599436733679f,(float16_t)0.97150389098625178352f,
(float16_t)0.23105810828067127605f,(float16_t)0.97293995220556006576f,
(float16_t)0.22508391135979277653f,(float16_t)0.97433938278557585821f,
(float16_t)0.21910124015686976984f,(float16_t)0.97570213003852857003f,
(float16_t)0.21311031991609136194f,(float16_t)0.97702814265775439484f,
(float16_t)0.20711137619221856032f,(float16_t)0.97831737071962765473f,
(float16_t)0.20110463484209195606f,(float16_t)0.97956976568544051887f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.18906866414980627589f,(float16_t)0.98196386910955524296f,
(float16_t)0.18303988795514106180f,(float16_t)0.98310548743121628501f,
(float16_t)0.17700422041214886049f,(float16_t)0.98421009238692902521f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.16491312048997008866f,(float16_t)0.98630809724459866938f,
(float16_t)0.15885814333386139019f,(float16_t)0.98730141815785843473f,
(float16_t)0.15279718525844340760f,(float16_t)0.98825756773074946437f,
(float16_t)0.14673047445536174793f,(float16_t)0.98917650996478101444f,
(float16_t)0.14065823933284923863f,(float16_t)0.99005821026229712256f,
(float16_t)0.13458070850712622324f,(float16_t)0.99090263542778000971f,
(float16_t)0.12849811079379322432f,(float16_t)0.99170975366909952520f,
(float16_t)0.12241067519921627893f,(float16_t)0.99247953459870996706f,
(float16_t)0.11631863091190487725f,(float16_t)0.99321194923479450001f,
(float16_t)0.11022220729388318428f,(float16_t)0.99390697000235606051f,
(float16_t)0.10412163387205472520f,(float16_t)0.99456457073425541537f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.09190895649713269611f,(float16_t)0.99576741446765981713f,
(float16_t)0.08579731234443987997f,(float16_t)0.99631261218277800129f,
(float16_t)0.07968243797143012563f,(float16_t)0.99682029929116566791f,
(float16_t)0.07356456359966745406f,(float16_t)0.99729045667869020697f,
(float16_t)0.06744391956366410645f,(float16_t)0.99772306664419163624f,
(float16_t)0.06132073630220864768f,(float16_t)0.99811811290014917919f,
(float16_t)0.05519524434969003135f,(float16_t)0.99847558057329477421f,
(float16_t)0.04906767432741812596f,(float16_t)0.99879545620517240501f,
(float16_t)0.04293825693494095902f,(float16_t)0.99907772775264536147f,
(float16_t)0.03680722294135899131f,(float16_t)0.99932238458834954375f,
(float16_t)0.03067480317663658085f,(float16_t)0.99952941750109314256f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)0.01840672990580482019f,(float16_t)0.99983058179582340319f,
(float16_t)0.01227153828571994447f,(float16_t)0.99992470183914450299f,
(float16_t)0.00613588464915451517f,(float16_t)0.99998117528260110909f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99969881869620424997f,(float16_t)0.02454122852291228812f,
(float16_t)0.99879545620517240501f,(float16_t)0.04906767432741801493f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.99247953459870996706f,(float16_t)0.12241067519921619566f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98527764238894122162f,(float16_t)0.17096188876030121717f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.97003125319454397424f,(float16_t)0.24298017990326387094f,
(float16_t)0.96377606579543984022f,(float16_t)0.26671275747489836538f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.94952818059303667475f,(float16_t)0.31368174039889151761f,
(float16_t)0.94154406518302080631f,(float16_t)0.33688985339222005111f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.91420975570353069095f,(float16_t)0.40524131400498986100f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.89322430119551532446f,(float16_t)0.44961132965460653965f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.85772861000027211809f,(float16_t)0.51410274419322166128f,
(float16_t)0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.81758481315158371139f,(float16_t)0.57580819141784533866f,
(float16_t)0.80320753148064494287f,(float16_t)0.59569930449243335691f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.75720884650648456748f,(float16_t)0.65317284295377675551f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.72424708295146700276f,(float16_t)0.68954054473706682948f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.67155895484701833009f,(float16_t)0.74095112535495910588f,
(float16_t)0.65317284295377686654f,(float16_t)0.75720884650648456748f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.61523159058062681925f,(float16_t)0.78834642762660622761f,
(float16_t)0.59569930449243346793f,(float16_t)0.80320753148064483184f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.53499761988709726435f,(float16_t)0.84485356524970700587f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.49289819222978409341f,(float16_t)0.87008699110871134952f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.42755509343028219593f,(float16_t)0.90398929312344333820f,
(float16_t)0.40524131400498986100f,(float16_t)0.91420975570353069095f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.35989503653498827740f,(float16_t)0.93299279883473884567f,
(float16_t)0.33688985339222005111f,(float16_t)0.94154406518302080631f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.26671275747489842090f,(float16_t)0.96377606579543984022f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.21910124015686976984f,(float16_t)0.97570213003852857003f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.14673047445536174793f,(float16_t)0.98917650996478101444f,
(float16_t)0.12241067519921627893f,(float16_t)0.99247953459870996706f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.07356456359966745406f,(float16_t)0.99729045667869020697f,
(float16_t)0.04906767432741812596f,(float16_t)0.99879545620517240501f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,};

float16_t rearranged_twiddle_stride2_4096_f16[2728]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99999529380957619118f,(float16_t)0.00306795676296597614f,
(float16_t)0.99998117528260110909f,(float16_t)0.00613588464915447527f,
(float16_t)0.99995764455196389786f,(float16_t)0.00920375478205981944f,
(float16_t)0.99992470183914450299f,(float16_t)0.01227153828571992539f,
(float16_t)0.99988234745421256111f,(float16_t)0.01533920628498810015f,
(float16_t)0.99983058179582340319f,(float16_t)0.01840672990580482019f,
(float16_t)0.99976940535121527898f,(float16_t)0.02147408027546950787f,
(float16_t)0.99969881869620424997f,(float16_t)0.02454122852291228812f,
(float16_t)0.99961882249517863830f,(float16_t)0.02760814577896573974f,
(float16_t)0.99952941750109314256f,(float16_t)0.03067480317663662595f,
(float16_t)0.99943060455546173237f,(float16_t)0.03374117185137757990f,
(float16_t)0.99932238458834954375f,(float16_t)0.03680722294135883171f,
(float16_t)0.99920475861836388631f,(float16_t)0.03987292758773981066f,
(float16_t)0.99907772775264536147f,(float16_t)0.04293825693494082024f,
(float16_t)0.99894129318685687124f,(float16_t)0.04600318213091462299f,
(float16_t)0.99879545620517240501f,(float16_t)0.04906767432741801493f,
(float16_t)0.99864021818026527111f,(float16_t)0.05213170468028332366f,
(float16_t)0.99847558057329477421f,(float16_t)0.05519524434968993420f,
(float16_t)0.99830154493389289261f,(float16_t)0.05825826450043575244f,
(float16_t)0.99811811290014917919f,(float16_t)0.06132073630220857829f,
(float16_t)0.99792528619859599548f,(float16_t)0.06438263092985746505f,
(float16_t)0.99772306664419163624f,(float16_t)0.06744391956366405094f,
(float16_t)0.99751145614030345410f,(float16_t)0.07050457338961385600f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.99706007033948296225f,(float16_t)0.07662386139203149205f,
(float16_t)0.99682029929116566791f,(float16_t)0.07968243797143012563f,
(float16_t)0.99657114579055483539f,(float16_t)0.08274026454937569164f,
(float16_t)0.99631261218277800129f,(float16_t)0.08579731234443989385f,
(float16_t)0.99604470090125196702f,(float16_t)0.08885355258252460031f,
(float16_t)0.99576741446765981713f,(float16_t)0.09190895649713272386f,
(float16_t)0.99548075549192693856f,(float16_t)0.09496349532963899165f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.99487933079480561638f,(float16_t)0.10106986275482782167f,
(float16_t)0.99456457073425541537f,(float16_t)0.10412163387205458642f,
(float16_t)0.99424044945318790223f,(float16_t)0.10717242495680884273f,
(float16_t)0.99390697000235606051f,(float16_t)0.11022220729388305938f,
(float16_t)0.99356413552059530403f,(float16_t)0.11327095217756434631f,
(float16_t)0.99321194923479450001f,(float16_t)0.11631863091190475235f,
(float16_t)0.99285041445986510489f,(float16_t)0.11936521481099135467f,
(float16_t)0.99247953459870996706f,(float16_t)0.12241067519921619566f,
(float16_t)0.99209931314219179654f,(float16_t)0.12545498341154623367f,
(float16_t)0.99170975366909952520f,(float16_t)0.12849811079379316880f,
(float16_t)0.99131085984611544415f,(float16_t)0.13154002870288311611f,
(float16_t)0.99090263542778000971f,(float16_t)0.13458070850712616773f,
(float16_t)0.99048508425645709341f,(float16_t)0.13762012158648603832f,
(float16_t)0.99005821026229712256f,(float16_t)0.14065823933284921088f,
(float16_t)0.98962201746320088702f,(float16_t)0.14369503315029447110f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98872169196032377858f,(float16_t)0.14976453467732150915f,
(float16_t)0.98825756773074946437f,(float16_t)0.15279718525844343535f,
(float16_t)0.98778414164457217783f,(float16_t)0.15582839765426523271f,
(float16_t)0.98730141815785843473f,(float16_t)0.15885814333386144570f,
(float16_t)0.98680940181418552726f,(float16_t)0.16188639378011182579f,
(float16_t)0.98630809724459866938f,(float16_t)0.16491312048996989437f,
(float16_t)0.98579750916756747614f,(float16_t)0.16793829497473117263f,
(float16_t)0.98527764238894122162f,(float16_t)0.17096188876030121717f,
(float16_t)0.98474850180190420801f,(float16_t)0.17398387338746382214f,
(float16_t)0.98421009238692902521f,(float16_t)0.17700422041214874946f,
(float16_t)0.98366241921173025453f,(float16_t)0.18002290140569951471f,
(float16_t)0.98310548743121628501f,(float16_t)0.18303988795514095078f,
(float16_t)0.98253930228744124076f,(float16_t)0.18605515166344663291f,
(float16_t)0.98196386910955524296f,(float16_t)0.18906866414980619262f,
(float16_t)0.98137919331375456089f,(float16_t)0.19208039704989243734f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.98018213596811742949f,(float16_t)0.19809841071795356027f,
(float16_t)0.97956976568544051887f,(float16_t)0.20110463484209190055f,
(float16_t)0.97894817531906219710f,(float16_t)0.20410896609281686809f,
(float16_t)0.97831737071962765473f,(float16_t)0.20711137619221856032f,
(float16_t)0.97767735782450992943f,(float16_t)0.21011183688046961016f,
(float16_t)0.97702814265775439484f,(float16_t)0.21311031991609136194f,
(float16_t)0.97636973133002114000f,(float16_t)0.21610679707621952006f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.97502534506699412020f,(float16_t)0.22209362097320350937f,
(float16_t)0.97433938278557585821f,(float16_t)0.22508391135979283204f,
(float16_t)0.97364424965081197705f,(float16_t)0.22807208317088573102f,
(float16_t)0.97293995220556017678f,(float16_t)0.23105810828067110951f,
(float16_t)0.97222649707893626925f,(float16_t)0.23404195858354343018f,
(float16_t)0.97150389098625178352f,(float16_t)0.23702360599436719801f,
(float16_t)0.97077214072895035013f,(float16_t)0.24000302244874149871f,
(float16_t)0.97003125319454397424f,(float16_t)0.24298017990326387094f,
(float16_t)0.96928123535654853171f,(float16_t)0.24595505033579459497f,
(float16_t)0.96852209427441737777f,(float16_t)0.24892760574572014853f,
(float16_t)0.96775383709347551076f,(float16_t)0.25189781815421696809f,
(float16_t)0.96697647104485207059f,(float16_t)0.25486565960451457169f,
(float16_t)0.96619000344541250413f,(float16_t)0.25783110216215898713f,
(float16_t)0.96539444169768939830f,(float16_t)0.26079411791527551401f,
(float16_t)0.96458979328981275803f,(float16_t)0.26375467897483134694f,
(float16_t)0.96377606579543984022f,(float16_t)0.26671275747489836538f,
(float16_t)0.96295326687368387741f,(float16_t)0.26966832557291509076f,
(float16_t)0.96212140426904158019f,(float16_t)0.27262135544994897662f,
(float16_t)0.96128048581132063966f,(float16_t)0.27557181931095814376f,
(float16_t)0.96043051941556578655f,(float16_t)0.27851968938505305973f,
(float16_t)0.95957151308198451733f,(float16_t)0.28146493792575794091f,
(float16_t)0.95870347489587159906f,(float16_t)0.28440753721127187692f,
(float16_t)0.95782641302753290802f,(float16_t)0.28734745954472951102f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.95604525134999640557f,(float16_t)0.29321916269425862822f,
(float16_t)0.95514116830577078243f,(float16_t)0.29615088824362378883f,
(float16_t)0.95422809510910566733f,(float16_t)0.29907982630804047508f,
(float16_t)0.95330604035419386211f,(float16_t)0.30200594931922808417f,
(float16_t)0.95237501271976587880f,(float16_t)0.30492922973540237397f,
(float16_t)0.95143502096900833820f,(float16_t)0.30784964004153486661f,
(float16_t)0.95048607394948170235f,(float16_t)0.31076715274961147495f,
(float16_t)0.94952818059303667475f,(float16_t)0.31368174039889151761f,
(float16_t)0.94856134991573026749f,(float16_t)0.31659337555616584581f,
(float16_t)0.94758559101774109124f,(float16_t)0.31950203081601569188f,
(float16_t)0.94660091308328353499f,(float16_t)0.32240767880106985244f,
(float16_t)0.94560732538052127971f,(float16_t)0.32531029216226292622f,
(float16_t)0.94460483726148025685f,(float16_t)0.32820984357909249729f,
(float16_t)0.94359345816196038559f,(float16_t)0.33110630575987642921f,
(float16_t)0.94257319760144686605f,(float16_t)0.33399965144200938205f,
(float16_t)0.94154406518302080631f,(float16_t)0.33688985339222005111f,
(float16_t)0.94050607059326829518f,(float16_t)0.33977688440682685123f,
(float16_t)0.93945922360218991898f,(float16_t)0.34266071731199437833f,
(float16_t)0.93840353406310805795f,(float16_t)0.34554132496398909380f,
(float16_t)0.93733901191257495977f,(float16_t)0.34841868024943456472f,
(float16_t)0.93626566717027825959f,(float16_t)0.35129275608556709276f,
(float16_t)0.93518350993894761025f,(float16_t)0.35416352542049034380f,
(float16_t)0.93409255040425887007f,(float16_t)0.35703096123342997759f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.93188426558166814750f,(float16_t)0.36275572436739722537f,
(float16_t)0.93076696107898371224f,(float16_t)0.36561299780477385379f,
(float16_t)0.92964089584318121418f,(float16_t)0.36846682995337232125f,
(float16_t)0.92850608047321558924f,(float16_t)0.37131719395183754306f,
(float16_t)0.92736252565040111495f,(float16_t)0.37416406297145793358f,
(float16_t)0.92621024213831137928f,(float16_t)0.37700741021641825945f,
(float16_t)0.92504924078267758425f,(float16_t)0.37984720892405116066f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.92270112833387862850f,(float16_t)0.38551605384391884890f,
(float16_t)0.92151403934204190183f,(float16_t)0.38834504669882624617f,
(float16_t)0.92031827670911059425f,(float16_t)0.39117038430225387069f,
(float16_t)0.91911385169005777040f,(float16_t)0.39399204006104809883f,
(float16_t)0.91790077562139049672f,(float16_t)0.39680998741671030805f,
(float16_t)0.91667905992104270485f,(float16_t)0.39962419984564678810f,
(float16_t)0.91544871608826783316f,(float16_t)0.40243465085941843018f,
(float16_t)0.91420975570353069095f,(float16_t)0.40524131400498986100f,
(float16_t)0.91296219042839821256f,(float16_t)0.40804416286497868782f,
(float16_t)0.91170603200542987832f,(float16_t)0.41084317105790391089f,
(float16_t)0.91044129225806724737f,(float16_t)0.41363831223843450235f,
(float16_t)0.90916798309052238025f,(float16_t)0.41642956009763715253f,
(float16_t)0.90788611648766626150f,(float16_t)0.41921688836322390515f,
(float16_t)0.90659570451491533483f,(float16_t)0.42200027079979968159f,
(float16_t)0.90529675931811881551f,(float16_t)0.42477968120910880589f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.90267331823725882600f,(float16_t)0.43032648134008261165f,
(float16_t)0.90134884704602202810f,(float16_t)0.43309381885315195726f,
(float16_t)0.90001589201616016833f,(float16_t)0.43585707992225547480f,
(float16_t)0.89867446569395381673f,(float16_t)0.43861623853852765853f,
(float16_t)0.89732458070541831763f,(float16_t)0.44137126873171667052f,
(float16_t)0.89596624975618521791f,(float16_t)0.44412214457042920035f,
(float16_t)0.89459948563138269595f,(float16_t)0.44686884016237415906f,
(float16_t)0.89322430119551532446f,(float16_t)0.44961132965460653965f,
(float16_t)0.89184070939234272313f,(float16_t)0.45234958723377088896f,
(float16_t)0.89044872324475787817f,(float16_t)0.45508358712634383592f,
(float16_t)0.88904835585466457371f,(float16_t)0.45781330359887717485f,
(float16_t)0.88763962040285393496f,(float16_t)0.46053871095824000514f,
(float16_t)0.88622253014888063838f,(float16_t)0.46325978355186014923f,
(float16_t)0.88479709843093778954f,(float16_t)0.46597649576796618121f,
(float16_t)0.88336333866573157891f,(float16_t)0.46868882203582790114f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.88047088905216075450f,(float16_t)0.47410021465054996703f,
(float16_t)0.87901222642863352519f,(float16_t)0.47679923006332208812f,
(float16_t)0.87754529020726135258f,(float16_t)0.47949375766015295275f,
(float16_t)0.87607009419540660122f,(float16_t)0.48218377207912271887f,
(float16_t)0.87458665227817611321f,(float16_t)0.48486924800079106435f,
(float16_t)0.87309497841829009079f,(float16_t)0.48755016014843599592f,
(float16_t)0.87159508665595097909f,(float16_t)0.49022648328829115938f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.86857070597134089507f,(float16_t)0.49556526182577254058f,
(float16_t)0.86704624551569264845f,(float16_t)0.49822766697278181303f,
(float16_t)0.86551362409056908920f,(float16_t)0.50088538261124071482f,
(float16_t)0.86397285612158669643f,(float16_t)0.50353838372571757542f,
(float16_t)0.86242395611104050168f,(float16_t)0.50618664534515522835f,
(float16_t)0.86086693863776730939f,(float16_t)0.50883014254310698909f,
(float16_t)0.85930181835700847337f,(float16_t)0.51146885043797030157f,
(float16_t)0.85772861000027211809f,(float16_t)0.51410274419322166128f,
(float16_t)0.85614732837519447184f,(float16_t)0.51673179901764987321f,
(float16_t)0.85455798836540053376f,(float16_t)0.51935599016558964269f,
(float16_t)0.85296060493036363059f,(float16_t)0.52197529293715438925f,
(float16_t)0.85135519310526519554f,(float16_t)0.52458968267846894928f,
(float16_t)0.84974176800085254868f,(float16_t)0.52719913478190127964f,
(float16_t)0.84812034480329723252f,(float16_t)0.52980362468629460526f,
(float16_t)0.84649093877405212627f,(float16_t)0.53240312787719790144f,
(float16_t)0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)0.84320823964184543620f,(float16_t)0.53758707629564539410f,
(float16_t)0.84155497743689844370f,(float16_t)0.54017147272989285423f,
(float16_t)0.83989379419599952126f,(float16_t)0.54275078486451588944f,
(float16_t)0.83822470555483807875f,(float16_t)0.54532498842204646383f,
(float16_t)0.83654772722351200542f,(float16_t)0.54789405917310018967f,
(float16_t)0.83486287498638001026f,(float16_t)0.55045797293660481131f,
(float16_t)0.83317016470191318511f,(float16_t)0.55301670558002746780f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.82976123379452304540f,(float16_t)0.55811853122055610221f,
(float16_t)0.82804504525775579626f,(float16_t)0.56066157619733603124f,
(float16_t)0.82632106284566353427f,(float16_t)0.56319934401383409117f,
(float16_t)0.82458930278502529099f,(float16_t)0.56573181078361312046f,
(float16_t)0.82284978137582642788f,(float16_t)0.56825895267013148970f,
(float16_t)0.82110251499110464835f,(float16_t)0.57078074588696725566f,
(float16_t)0.81934752007679700903f,(float16_t)0.57329716669804220430f,
(float16_t)0.81758481315158371139f,(float16_t)0.57580819141784533866f,
(float16_t)0.81581441080673378075f,(float16_t)0.57831379641165558958f,
(float16_t)0.81403632970594841378f,(float16_t)0.58081395809576452649f,
(float16_t)0.81225058658520399302f,(float16_t)0.58330865293769829094f,
(float16_t)0.81045719825259476821f,(float16_t)0.58579785745643886408f,
(float16_t)0.80865618158817498262f,(float16_t)0.58828154822264522306f,
(float16_t)0.80684755354379933401f,(float16_t)0.59075970185887416442f,
(float16_t)0.80503133114296365758f,(float16_t)0.59323229503979979516f,
(float16_t)0.80320753148064494287f,(float16_t)0.59569930449243335691f,
(float16_t)0.80137617172314024039f,(float16_t)0.59816070699634238395f,
(float16_t)0.79953726910790501314f,(float16_t)0.60061647938386897305f,
(float16_t)0.79769084094339115509f,(float16_t)0.60306659854034816437f,
(float16_t)0.79583690460888356633f,(float16_t)0.60551104140432554512f,
(float16_t)0.79397547755433717231f,(float16_t)0.60794978496777363208f,
(float16_t)0.79210657730021238887f,(float16_t)0.61038280627630947528f,
(float16_t)0.79023022143731003197f,(float16_t)0.61281008242940970820f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.78645521359908576731f,(float16_t)0.61764730793780386886f,
(float16_t)0.78455659715557524159f,(float16_t)0.62005721176328909561f,
(float16_t)0.78265059616657572938f,(float16_t)0.62246127937414996723f,
(float16_t)0.78073722857209448822f,(float16_t)0.62485948814238634341f,
(float16_t)0.77881651238147597827f,(float16_t)0.62725181549514408275f,
(float16_t)0.77688846567323244230f,(float16_t)0.62963823891492698426f,
(float16_t)0.77495310659487393057f,(float16_t)0.63201873593980906207f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.77106052426181381776f,(float16_t)0.63676186123628419899f,
(float16_t)0.76910333764557969882f,(float16_t)0.63912444486377573138f,
(float16_t)0.76713891193582040007f,(float16_t)0.64148101280858305095f,
(float16_t)0.76516726562245895860f,(float16_t)0.64383154288979138613f,
(float16_t)0.76318841726338138010f,(float16_t)0.64617601298331628357f,
(float16_t)0.76120238548426177871f,(float16_t)0.64851440102211244110f,
(float16_t)0.75920918897838796102f,(float16_t)0.65084668499638087535f,
(float16_t)0.75720884650648456748f,(float16_t)0.65317284295377675551f,
(float16_t)0.75520137689653654700f,(float16_t)0.65549285299961534967f,
(float16_t)0.75318679904361252042f,(float16_t)0.65780669329707863735f,
(float16_t)0.75116513190968636771f,(float16_t)0.66011434206742047870f,
(float16_t)0.74913639452345937020f,(float16_t)0.66241577759017178373f,
(float16_t)0.74710060598018013245f,(float16_t)0.66471097820334479334f,
(float16_t)0.74505778544146594733f,(float16_t)0.66699992230363747137f,
(float16_t)0.74300795213512171866f,(float16_t)0.66928258834663600929f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.73888732446061511361f,(float16_t)0.67382900037875603783f,
(float16_t)0.73681656887736979300f,(float16_t)0.67609270357531592310f,
(float16_t)0.73473887809596349907f,(float16_t)0.67835004312986146857f,
(float16_t)0.73265427167241281570f,(float16_t)0.68060099779545302212f,
(float16_t)0.73056276922782759087f,(float16_t)0.68284554638524808112f,
(float16_t)0.72846439044822519637f,(float16_t)0.68508366777270035541f,
(float16_t)0.72635915508434600873f,(float16_t)0.68731534089175905233f,
(float16_t)0.72424708295146700276f,(float16_t)0.68954054473706682948f,
(float16_t)0.72212819392921534511f,(float16_t)0.69175925836415774750f,
(float16_t)0.72000250796138165477f,(float16_t)0.69397146088965389055f,
(float16_t)0.71787004505573170920f,(float16_t)0.69617713149146298601f,
(float16_t)0.71573082528381870571f,(float16_t)0.69837624940897280457f,
(float16_t)0.71358486878079352422f,(float16_t)0.70056879394324833576f,
(float16_t)0.71143219574521643356f,(float16_t)0.70275474445722529993f,
(float16_t)0.70927282643886568891f,(float16_t)0.70493408037590488124f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.70493408037590499227f,(float16_t)0.70927282643886568891f,
(float16_t)0.70275474445722529993f,(float16_t)0.71143219574521643356f,
(float16_t)0.70056879394324844679f,(float16_t)0.71358486878079352422f,
(float16_t)0.69837624940897291559f,(float16_t)0.71573082528381859468f,
(float16_t)0.69617713149146298601f,(float16_t)0.71787004505573170920f,
(float16_t)0.69397146088965400157f,(float16_t)0.72000250796138165477f,
(float16_t)0.69175925836415774750f,(float16_t)0.72212819392921534511f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.68731534089175905233f,(float16_t)0.72635915508434600873f,
(float16_t)0.68508366777270035541f,(float16_t)0.72846439044822519637f,
(float16_t)0.68284554638524808112f,(float16_t)0.73056276922782759087f,
(float16_t)0.68060099779545302212f,(float16_t)0.73265427167241281570f,
(float16_t)0.67835004312986146857f,(float16_t)0.73473887809596349907f,
(float16_t)0.67609270357531603413f,(float16_t)0.73681656887736979300f,
(float16_t)0.67382900037875614885f,(float16_t)0.73888732446061511361f,
(float16_t)0.67155895484701833009f,(float16_t)0.74095112535495910588f,
(float16_t)0.66928258834663600929f,(float16_t)0.74300795213512171866f,
(float16_t)0.66699992230363747137f,(float16_t)0.74505778544146594733f,
(float16_t)0.66471097820334490436f,(float16_t)0.74710060598018013245f,
(float16_t)0.66241577759017178373f,(float16_t)0.74913639452345925918f,
(float16_t)0.66011434206742047870f,(float16_t)0.75116513190968636771f,
(float16_t)0.65780669329707874837f,(float16_t)0.75318679904361252042f,
(float16_t)0.65549285299961546070f,(float16_t)0.75520137689653654700f,
(float16_t)0.65317284295377686654f,(float16_t)0.75720884650648456748f,
(float16_t)0.65084668499638098638f,(float16_t)0.75920918897838796102f,
(float16_t)0.64851440102211255212f,(float16_t)0.76120238548426177871f,
(float16_t)0.64617601298331639459f,(float16_t)0.76318841726338126907f,
(float16_t)0.64383154288979149715f,(float16_t)0.76516726562245895860f,
(float16_t)0.64148101280858316198f,(float16_t)0.76713891193582040007f,
(float16_t)0.63912444486377573138f,(float16_t)0.76910333764557958780f,
(float16_t)0.63676186123628419899f,(float16_t)0.77106052426181381776f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.63201873593980906207f,(float16_t)0.77495310659487381955f,
(float16_t)0.62963823891492709528f,(float16_t)0.77688846567323244230f,
(float16_t)0.62725181549514419377f,(float16_t)0.77881651238147586724f,
(float16_t)0.62485948814238645443f,(float16_t)0.78073722857209448822f,
(float16_t)0.62246127937415007825f,(float16_t)0.78265059616657572938f,
(float16_t)0.62005721176328920663f,(float16_t)0.78455659715557524159f,
(float16_t)0.61764730793780397988f,(float16_t)0.78645521359908576731f,
(float16_t)0.61523159058062681925f,(float16_t)0.78834642762660622761f,
(float16_t)0.61281008242940970820f,(float16_t)0.79023022143731003197f,
(float16_t)0.61038280627630947528f,(float16_t)0.79210657730021227785f,
(float16_t)0.60794978496777374311f,(float16_t)0.79397547755433717231f,
(float16_t)0.60551104140432554512f,(float16_t)0.79583690460888345530f,
(float16_t)0.60306659854034827539f,(float16_t)0.79769084094339104407f,
(float16_t)0.60061647938386897305f,(float16_t)0.79953726910790501314f,
(float16_t)0.59816070699634238395f,(float16_t)0.80137617172314012937f,
(float16_t)0.59569930449243346793f,(float16_t)0.80320753148064483184f,
(float16_t)0.59323229503979979516f,(float16_t)0.80503133114296365758f,
(float16_t)0.59075970185887427544f,(float16_t)0.80684755354379922299f,
(float16_t)0.58828154822264533408f,(float16_t)0.80865618158817498262f,
(float16_t)0.58579785745643886408f,(float16_t)0.81045719825259476821f,
(float16_t)0.58330865293769829094f,(float16_t)0.81225058658520388200f,
(float16_t)0.58081395809576452649f,(float16_t)0.81403632970594830276f,
(float16_t)0.57831379641165558958f,(float16_t)0.81581441080673378075f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.57329716669804231532f,(float16_t)0.81934752007679689800f,
(float16_t)0.57078074588696736669f,(float16_t)0.82110251499110464835f,
(float16_t)0.56825895267013148970f,(float16_t)0.82284978137582631685f,
(float16_t)0.56573181078361323149f,(float16_t)0.82458930278502529099f,
(float16_t)0.56319934401383409117f,(float16_t)0.82632106284566353427f,
(float16_t)0.56066157619733603124f,(float16_t)0.82804504525775579626f,
(float16_t)0.55811853122055610221f,(float16_t)0.82976123379452304540f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.55301670558002757883f,(float16_t)0.83317016470191318511f,
(float16_t)0.55045797293660481131f,(float16_t)0.83486287498638001026f,
(float16_t)0.54789405917310018967f,(float16_t)0.83654772722351189440f,
(float16_t)0.54532498842204646383f,(float16_t)0.83822470555483796772f,
(float16_t)0.54275078486451600046f,(float16_t)0.83989379419599941023f,
(float16_t)0.54017147272989296525f,(float16_t)0.84155497743689833268f,
(float16_t)0.53758707629564550512f,(float16_t)0.84320823964184543620f,
(float16_t)0.53499761988709726435f,(float16_t)0.84485356524970700587f,
(float16_t)0.53240312787719801246f,(float16_t)0.84649093877405212627f,
(float16_t)0.52980362468629482731f,(float16_t)0.84812034480329712149f,
(float16_t)0.52719913478190139067f,(float16_t)0.84974176800085243766f,
(float16_t)0.52458968267846883826f,(float16_t)0.85135519310526519554f,
(float16_t)0.52197529293715438925f,(float16_t)0.85296060493036363059f,
(float16_t)0.51935599016558953167f,(float16_t)0.85455798836540053376f,
(float16_t)0.51673179901764998423f,(float16_t)0.85614732837519447184f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.51146885043797052361f,(float16_t)0.85930181835700836235f,
(float16_t)0.50883014254310698909f,(float16_t)0.86086693863776730939f,
(float16_t)0.50618664534515533937f,(float16_t)0.86242395611104050168f,
(float16_t)0.50353838372571757542f,(float16_t)0.86397285612158669643f,
(float16_t)0.50088538261124093687f,(float16_t)0.86551362409056897818f,
(float16_t)0.49822766697278186854f,(float16_t)0.86704624551569264845f,
(float16_t)0.49556526182577248507f,(float16_t)0.86857070597134089507f,
(float16_t)0.49289819222978409341f,(float16_t)0.87008699110871134952f,
(float16_t)0.49022648328829110387f,(float16_t)0.87159508665595109012f,
(float16_t)0.48755016014843605143f,(float16_t)0.87309497841829009079f,
(float16_t)0.48486924800079111986f,(float16_t)0.87458665227817611321f,
(float16_t)0.48218377207912282989f,(float16_t)0.87607009419540660122f,
(float16_t)0.47949375766015300826f,(float16_t)0.87754529020726124156f,
(float16_t)0.47679923006332225466f,(float16_t)0.87901222642863341417f,
(float16_t)0.47410021465055002254f,(float16_t)0.88047088905216075450f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.46868882203582795665f,(float16_t)0.88336333866573157891f,
(float16_t)0.46597649576796612569f,(float16_t)0.88479709843093778954f,
(float16_t)0.46325978355186026025f,(float16_t)0.88622253014888063838f,
(float16_t)0.46053871095824000514f,(float16_t)0.88763962040285393496f,
(float16_t)0.45781330359887728587f,(float16_t)0.88904835585466457371f,
(float16_t)0.45508358712634383592f,(float16_t)0.89044872324475787817f,
(float16_t)0.45234958723377099998f,(float16_t)0.89184070939234272313f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.44686884016237432560f,(float16_t)0.89459948563138258493f,
(float16_t)0.44412214457042925586f,(float16_t)0.89596624975618510689f,
(float16_t)0.44137126873171661501f,(float16_t)0.89732458070541831763f,
(float16_t)0.43861623853852771404f,(float16_t)0.89867446569395381673f,
(float16_t)0.43585707992225547480f,(float16_t)0.90001589201616027935f,
(float16_t)0.43309381885315201277f,(float16_t)0.90134884704602202810f,
(float16_t)0.43032648134008261165f,(float16_t)0.90267331823725882600f,
(float16_t)0.42755509343028219593f,(float16_t)0.90398929312344333820f,
(float16_t)0.42477968120910880589f,(float16_t)0.90529675931811881551f,
(float16_t)0.42200027079979979261f,(float16_t)0.90659570451491533483f,
(float16_t)0.41921688836322396066f,(float16_t)0.90788611648766626150f,
(float16_t)0.41642956009763731906f,(float16_t)0.90916798309052226923f,
(float16_t)0.41363831223843455787f,(float16_t)0.91044129225806713634f,
(float16_t)0.41084317105790391089f,(float16_t)0.91170603200542987832f,
(float16_t)0.40804416286497874333f,(float16_t)0.91296219042839810154f,
(float16_t)0.40524131400498986100f,(float16_t)0.91420975570353069095f,
(float16_t)0.40243465085941854120f,(float16_t)0.91544871608826783316f,
(float16_t)0.39962419984564678810f,(float16_t)0.91667905992104270485f,
(float16_t)0.39680998741671041907f,(float16_t)0.91790077562139038569f,
(float16_t)0.39399204006104809883f,(float16_t)0.91911385169005777040f,
(float16_t)0.39117038430225398171f,(float16_t)0.92031827670911048322f,
(float16_t)0.38834504669882630168f,(float16_t)0.92151403934204190183f,
(float16_t)0.38551605384391901543f,(float16_t)0.92270112833387851747f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.37984720892405110515f,(float16_t)0.92504924078267758425f,
(float16_t)0.37700741021641831496f,(float16_t)0.92621024213831126826f,
(float16_t)0.37416406297145798909f,(float16_t)0.92736252565040111495f,
(float16_t)0.37131719395183759858f,(float16_t)0.92850608047321558924f,
(float16_t)0.36846682995337232125f,(float16_t)0.92964089584318121418f,
(float16_t)0.36561299780477396482f,(float16_t)0.93076696107898371224f,
(float16_t)0.36275572436739722537f,(float16_t)0.93188426558166814750f,
(float16_t)0.35989503653498827740f,(float16_t)0.93299279883473884567f,
(float16_t)0.35703096123343003310f,(float16_t)0.93409255040425887007f,
(float16_t)0.35416352542049051033f,(float16_t)0.93518350993894749923f,
(float16_t)0.35129275608556714827f,(float16_t)0.93626566717027825959f,
(float16_t)0.34841868024943450921f,(float16_t)0.93733901191257495977f,
(float16_t)0.34554132496398914931f,(float16_t)0.93840353406310805795f,
(float16_t)0.34266071731199437833f,(float16_t)0.93945922360218991898f,
(float16_t)0.33977688440682696225f,(float16_t)0.94050607059326829518f,
(float16_t)0.33688985339222005111f,(float16_t)0.94154406518302080631f,
(float16_t)0.33399965144200949307f,(float16_t)0.94257319760144686605f,
(float16_t)0.33110630575987642921f,(float16_t)0.94359345816196038559f,
(float16_t)0.32820984357909266382f,(float16_t)0.94460483726148025685f,
(float16_t)0.32531029216226298173f,(float16_t)0.94560732538052127971f,
(float16_t)0.32240767880107001897f,(float16_t)0.94660091308328353499f,
(float16_t)0.31950203081601574739f,(float16_t)0.94758559101774109124f,
(float16_t)0.31659337555616584581f,(float16_t)0.94856134991573026749f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.31076715274961147495f,(float16_t)0.95048607394948170235f,
(float16_t)0.30784964004153497763f,(float16_t)0.95143502096900833820f,
(float16_t)0.30492922973540242948f,(float16_t)0.95237501271976587880f,
(float16_t)0.30200594931922819519f,(float16_t)0.95330604035419375109f,
(float16_t)0.29907982630804047508f,(float16_t)0.95422809510910566733f,
(float16_t)0.29615088824362395536f,(float16_t)0.95514116830577067141f,
(float16_t)0.29321916269425868373f,(float16_t)0.95604525134999640557f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.28734745954472956653f,(float16_t)0.95782641302753290802f,
(float16_t)0.28440753721127182141f,(float16_t)0.95870347489587159906f,
(float16_t)0.28146493792575805193f,(float16_t)0.95957151308198451733f,
(float16_t)0.27851968938505305973f,(float16_t)0.96043051941556578655f,
(float16_t)0.27557181931095825478f,(float16_t)0.96128048581132063966f,
(float16_t)0.27262135544994897662f,(float16_t)0.96212140426904158019f,
(float16_t)0.26966832557291520178f,(float16_t)0.96295326687368387741f,
(float16_t)0.26671275747489842090f,(float16_t)0.96377606579543984022f,
(float16_t)0.26375467897483151347f,(float16_t)0.96458979328981264700f,
(float16_t)0.26079411791527556952f,(float16_t)0.96539444169768939830f,
(float16_t)0.25783110216215893162f,(float16_t)0.96619000344541261516f,
(float16_t)0.25486565960451462720f,(float16_t)0.96697647104485207059f,
(float16_t)0.25189781815421691258f,(float16_t)0.96775383709347551076f,
(float16_t)0.24892760574572025956f,(float16_t)0.96852209427441726675f,
(float16_t)0.24595505033579459497f,(float16_t)0.96928123535654853171f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.24000302244874149871f,(float16_t)0.97077214072895035013f,
(float16_t)0.23702360599436733679f,(float16_t)0.97150389098625178352f,
(float16_t)0.23404195858354345794f,(float16_t)0.97222649707893626925f,
(float16_t)0.23105810828067127605f,(float16_t)0.97293995220556006576f,
(float16_t)0.22807208317088578653f,(float16_t)0.97364424965081186603f,
(float16_t)0.22508391135979277653f,(float16_t)0.97433938278557585821f,
(float16_t)0.22209362097320359264f,(float16_t)0.97502534506699412020f,
(float16_t)0.21910124015686976984f,(float16_t)0.97570213003852857003f,
(float16_t)0.21610679707621960333f,(float16_t)0.97636973133002114000f,
(float16_t)0.21311031991609136194f,(float16_t)0.97702814265775439484f,
(float16_t)0.21011183688046972118f,(float16_t)0.97767735782450992943f,
(float16_t)0.20711137619221856032f,(float16_t)0.97831737071962765473f,
(float16_t)0.20410896609281700687f,(float16_t)0.97894817531906219710f,
(float16_t)0.20110463484209195606f,(float16_t)0.97956976568544051887f,
(float16_t)0.19809841071795372680f,(float16_t)0.98018213596811731847f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.19208039704989238183f,(float16_t)0.98137919331375456089f,
(float16_t)0.18906866414980627589f,(float16_t)0.98196386910955524296f,
(float16_t)0.18605515166344663291f,(float16_t)0.98253930228744124076f,
(float16_t)0.18303988795514106180f,(float16_t)0.98310548743121628501f,
(float16_t)0.18002290140569951471f,(float16_t)0.98366241921173025453f,
(float16_t)0.17700422041214886049f,(float16_t)0.98421009238692902521f,
(float16_t)0.17398387338746384989f,(float16_t)0.98474850180190420801f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.16793829497473122814f,(float16_t)0.98579750916756736512f,
(float16_t)0.16491312048997008866f,(float16_t)0.98630809724459866938f,
(float16_t)0.16188639378011188130f,(float16_t)0.98680940181418541624f,
(float16_t)0.15885814333386139019f,(float16_t)0.98730141815785843473f,
(float16_t)0.15582839765426531597f,(float16_t)0.98778414164457217783f,
(float16_t)0.15279718525844340760f,(float16_t)0.98825756773074946437f,
(float16_t)0.14976453467732162017f,(float16_t)0.98872169196032377858f,
(float16_t)0.14673047445536174793f,(float16_t)0.98917650996478101444f,
(float16_t)0.14369503315029458212f,(float16_t)0.98962201746320077600f,
(float16_t)0.14065823933284923863f,(float16_t)0.99005821026229712256f,
(float16_t)0.13762012158648617710f,(float16_t)0.99048508425645698239f,
(float16_t)0.13458070850712622324f,(float16_t)0.99090263542778000971f,
(float16_t)0.13154002870288328264f,(float16_t)0.99131085984611544415f,
(float16_t)0.12849811079379322432f,(float16_t)0.99170975366909952520f,
(float16_t)0.12545498341154620592f,(float16_t)0.99209931314219179654f,
(float16_t)0.12241067519921627893f,(float16_t)0.99247953459870996706f,
(float16_t)0.11936521481099135467f,(float16_t)0.99285041445986510489f,
(float16_t)0.11631863091190487725f,(float16_t)0.99321194923479450001f,
(float16_t)0.11327095217756436019f,(float16_t)0.99356413552059530403f,
(float16_t)0.11022220729388318428f,(float16_t)0.99390697000235606051f,
(float16_t)0.10717242495680887049f,(float16_t)0.99424044945318790223f,
(float16_t)0.10412163387205472520f,(float16_t)0.99456457073425541537f,
(float16_t)0.10106986275482787718f,(float16_t)0.99487933079480561638f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.09496349532963906104f,(float16_t)0.99548075549192693856f,
(float16_t)0.09190895649713269611f,(float16_t)0.99576741446765981713f,
(float16_t)0.08885355258252468358f,(float16_t)0.99604470090125196702f,
(float16_t)0.08579731234443987997f,(float16_t)0.99631261218277800129f,
(float16_t)0.08274026454937580266f,(float16_t)0.99657114579055483539f,
(float16_t)0.07968243797143012563f,(float16_t)0.99682029929116566791f,
(float16_t)0.07662386139203161695f,(float16_t)0.99706007033948296225f,
(float16_t)0.07356456359966745406f,(float16_t)0.99729045667869020697f,
(float16_t)0.07050457338961400866f,(float16_t)0.99751145614030345410f,
(float16_t)0.06744391956366410645f,(float16_t)0.99772306664419163624f,
(float16_t)0.06438263092985740954f,(float16_t)0.99792528619859599548f,
(float16_t)0.06132073630220864768f,(float16_t)0.99811811290014917919f,
(float16_t)0.05825826450043573163f,(float16_t)0.99830154493389289261f,
(float16_t)0.05519524434969003135f,(float16_t)0.99847558057329477421f,
(float16_t)0.05213170468028331672f,(float16_t)0.99864021818026527111f,
(float16_t)0.04906767432741812596f,(float16_t)0.99879545620517240501f,
(float16_t)0.04600318213091464381f,(float16_t)0.99894129318685687124f,
(float16_t)0.04293825693494095902f,(float16_t)0.99907772775264536147f,
(float16_t)0.03987292758773984536f,(float16_t)0.99920475861836388631f,
(float16_t)0.03680722294135899131f,(float16_t)0.99932238458834954375f,
(float16_t)0.03374117185137764235f,(float16_t)0.99943060455546173237f,
(float16_t)0.03067480317663658085f,(float16_t)0.99952941750109314256f,
(float16_t)0.02760814577896581953f,(float16_t)0.99961882249517863830f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)0.02147408027546960502f,(float16_t)0.99976940535121527898f,
(float16_t)0.01840672990580482019f,(float16_t)0.99983058179582340319f,
(float16_t)0.01533920628498821985f,(float16_t)0.99988234745421256111f,
(float16_t)0.01227153828571994447f,(float16_t)0.99992470183914450299f,
(float16_t)0.00920375478205995995f,(float16_t)0.99995764455196389786f,
(float16_t)0.00613588464915451517f,(float16_t)0.99998117528260110909f,
(float16_t)0.00306795676296613791f,(float16_t)0.99999529380957619118f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.00306795676296601561f,(float16_t)0.99999529380957619118f,
(float16_t)-0.00613588464915439287f,(float16_t)0.99998117528260110909f,
(float16_t)-0.00920375478205983678f,(float16_t)0.99995764455196389786f,
(float16_t)-0.01227153828571982304f,(float16_t)0.99992470183914450299f,
(float16_t)-0.01533920628498809842f,(float16_t)0.99988234745421256111f,
(float16_t)-0.01840672990580469529f,(float16_t)0.99983058179582340319f,
(float16_t)-0.02147408027546948359f,(float16_t)0.99976940535121527898f,
(float16_t)-0.02454122852291214241f,(float16_t)0.99969881869620424997f,
(float16_t)-0.02760814577896569810f,(float16_t)0.99961882249517863830f,
(float16_t)-0.03067480317663645942f,(float16_t)0.99952941750109314256f,
(float16_t)-0.03374117185137751745f,(float16_t)0.99943060455546173237f,
(float16_t)-0.03680722294135886641f,(float16_t)0.99932238458834954375f,
(float16_t)-0.03987292758773972740f,(float16_t)0.99920475861836388631f,
(float16_t)-0.04293825693494083412f,(float16_t)0.99907772775264536147f,
(float16_t)-0.04600318213091451891f,(float16_t)0.99894129318685687124f,
(float16_t)-0.04906767432741800800f,(float16_t)0.99879545620517240501f,
(float16_t)-0.05213170468028319182f,(float16_t)0.99864021818026527111f,
(float16_t)-0.05519524434968991339f,(float16_t)0.99847558057329477421f,
(float16_t)-0.05825826450043560673f,(float16_t)0.99830154493389289261f,
(float16_t)-0.06132073630220852972f,(float16_t)0.99811811290014917919f,
(float16_t)-0.06438263092985728464f,(float16_t)0.99792528619859599548f,
(float16_t)-0.06744391956366398155f,(float16_t)0.99772306664419163624f,
(float16_t)-0.07050457338961389764f,(float16_t)0.99751145614030345410f,
(float16_t)-0.07356456359966732916f,(float16_t)0.99729045667869020697f,
(float16_t)-0.07662386139203150592f,(float16_t)0.99706007033948296225f,
(float16_t)-0.07968243797143001461f,(float16_t)0.99682029929116577893f,
(float16_t)-0.08274026454937567776f,(float16_t)0.99657114579055483539f,
(float16_t)-0.08579731234443975507f,(float16_t)0.99631261218277800129f,
(float16_t)-0.08885355258252455868f,(float16_t)0.99604470090125196702f,
(float16_t)-0.09190895649713257121f,(float16_t)0.99576741446765981713f,
(float16_t)-0.09496349532963895002f,(float16_t)0.99548075549192693856f,
(float16_t)-0.09801714032956064526f,(float16_t)0.99518472667219692873f,
(float16_t)-0.10106986275482775228f,(float16_t)0.99487933079480561638f,
(float16_t)-0.10412163387205460030f,(float16_t)0.99456457073425541537f,
(float16_t)-0.10717242495680875947f,(float16_t)0.99424044945318790223f,
(float16_t)-0.11022220729388305938f,(float16_t)0.99390697000235606051f,
(float16_t)-0.11327095217756423529f,(float16_t)0.99356413552059530403f,
(float16_t)-0.11631863091190475235f,(float16_t)0.99321194923479450001f,
(float16_t)-0.11936521481099122977f,(float16_t)0.99285041445986510489f,
(float16_t)-0.12241067519921615403f,(float16_t)0.99247953459870996706f,
(float16_t)-0.12545498341154606714f,(float16_t)0.99209931314219179654f,
(float16_t)-0.12849811079379311329f,(float16_t)0.99170975366909952520f,
(float16_t)-0.13154002870288314386f,(float16_t)0.99131085984611544415f,
(float16_t)-0.13458070850712611222f,(float16_t)0.99090263542778000971f,
(float16_t)-0.13762012158648606608f,(float16_t)0.99048508425645698239f,
(float16_t)-0.14065823933284912761f,(float16_t)0.99005821026229712256f,
(float16_t)-0.14369503315029444335f,(float16_t)0.98962201746320088702f,
(float16_t)-0.14673047445536163691f,(float16_t)0.98917650996478101444f,
(float16_t)-0.14976453467732150915f,(float16_t)0.98872169196032377858f,
(float16_t)-0.15279718525844329657f,(float16_t)0.98825756773074946437f,
(float16_t)-0.15582839765426520495f,(float16_t)0.98778414164457217783f,
(float16_t)-0.15885814333386127917f,(float16_t)0.98730141815785843473f,
(float16_t)-0.16188639378011177028f,(float16_t)0.98680940181418552726f,
(float16_t)-0.16491312048996994988f,(float16_t)0.98630809724459866938f,
(float16_t)-0.16793829497473108936f,(float16_t)0.98579750916756747614f,
(float16_t)-0.17096188876030124493f,(float16_t)0.98527764238894122162f,
(float16_t)-0.17398387338746371111f,(float16_t)0.98474850180190420801f,
(float16_t)-0.17700422041214874946f,(float16_t)0.98421009238692902521f,
(float16_t)-0.18002290140569940369f,(float16_t)0.98366241921173025453f,
(float16_t)-0.18303988795514092303f,(float16_t)0.98310548743121628501f,
(float16_t)-0.18605515166344649414f,(float16_t)0.98253930228744124076f,
(float16_t)-0.18906866414980616486f,(float16_t)0.98196386910955524296f,
(float16_t)-0.19208039704989227081f,(float16_t)0.98137919331375456089f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.19809841071795361578f,(float16_t)0.98018213596811742949f,
(float16_t)-0.20110463484209181728f,(float16_t)0.97956976568544051887f,
(float16_t)-0.20410896609281689584f,(float16_t)0.97894817531906219710f,
(float16_t)-0.20711137619221844930f,(float16_t)0.97831737071962765473f,
(float16_t)-0.21011183688046961016f,(float16_t)0.97767735782450992943f,
(float16_t)-0.21311031991609125091f,(float16_t)0.97702814265775439484f,
(float16_t)-0.21610679707621949230f,(float16_t)0.97636973133002114000f,
(float16_t)-0.21910124015686965881f,(float16_t)0.97570213003852857003f,
(float16_t)-0.22209362097320348162f,(float16_t)0.97502534506699412020f,
(float16_t)-0.22508391135979266551f,(float16_t)0.97433938278557585821f,
(float16_t)-0.22807208317088567551f,(float16_t)0.97364424965081197705f,
(float16_t)-0.23105810828067113727f,(float16_t)0.97293995220556017678f,
(float16_t)-0.23404195858354331916f,(float16_t)0.97222649707893638027f,
(float16_t)-0.23702360599436722577f,(float16_t)0.97150389098625178352f,
(float16_t)-0.24000302244874138768f,(float16_t)0.97077214072895035013f,
(float16_t)-0.24298017990326387094f,(float16_t)0.97003125319454397424f,
(float16_t)-0.24595505033579448395f,(float16_t)0.96928123535654853171f,
(float16_t)-0.24892760574572012078f,(float16_t)0.96852209427441737777f,
(float16_t)-0.25189781815421680156f,(float16_t)0.96775383709347551076f,
(float16_t)-0.25486565960451451618f,(float16_t)0.96697647104485207059f,
(float16_t)-0.25783110216215882060f,(float16_t)0.96619000344541261516f,
(float16_t)-0.26079411791527545850f,(float16_t)0.96539444169768939830f,
(float16_t)-0.26375467897483140245f,(float16_t)0.96458979328981275803f,
(float16_t)-0.26671275747489830987f,(float16_t)0.96377606579543984022f,
(float16_t)-0.26966832557291509076f,(float16_t)0.96295326687368387741f,
(float16_t)-0.27262135544994886560f,(float16_t)0.96212140426904158019f,
(float16_t)-0.27557181931095814376f,(float16_t)0.96128048581132063966f,
(float16_t)-0.27851968938505294870f,(float16_t)0.96043051941556589757f,
(float16_t)-0.28146493792575794091f,(float16_t)0.95957151308198451733f,
(float16_t)-0.28440753721127171039f,(float16_t)0.95870347489587159906f,
(float16_t)-0.28734745954472945551f,(float16_t)0.95782641302753290802f,
(float16_t)-0.29028467725446216452f,(float16_t)0.95694033573220893540f,
(float16_t)-0.29321916269425857271f,(float16_t)0.95604525134999651659f,
(float16_t)-0.29615088824362384434f,(float16_t)0.95514116830577067141f,
(float16_t)-0.29907982630804036406f,(float16_t)0.95422809510910566733f,
(float16_t)-0.30200594931922808417f,(float16_t)0.95330604035419386211f,
(float16_t)-0.30492922973540226295f,(float16_t)0.95237501271976587880f,
(float16_t)-0.30784964004153486661f,(float16_t)0.95143502096900833820f,
(float16_t)-0.31076715274961136393f,(float16_t)0.95048607394948181337f,
(float16_t)-0.31368174039889140658f,(float16_t)0.94952818059303667475f,
(float16_t)-0.31659337555616573479f,(float16_t)0.94856134991573037851f,
(float16_t)-0.31950203081601563637f,(float16_t)0.94758559101774120226f,
(float16_t)-0.32240767880106985244f,(float16_t)0.94660091308328353499f,
(float16_t)-0.32531029216226287071f,(float16_t)0.94560732538052139073f,
(float16_t)-0.32820984357909255280f,(float16_t)0.94460483726148025685f,
(float16_t)-0.33110630575987631818f,(float16_t)0.94359345816196038559f,
(float16_t)-0.33399965144200938205f,(float16_t)0.94257319760144686605f,
(float16_t)-0.33688985339221994009f,(float16_t)0.94154406518302080631f,
(float16_t)-0.33977688440682685123f,(float16_t)0.94050607059326829518f,
(float16_t)-0.34266071731199426731f,(float16_t)0.93945922360218991898f,
(float16_t)-0.34554132496398903829f,(float16_t)0.93840353406310816897f,
(float16_t)-0.34841868024943439819f,(float16_t)0.93733901191257495977f,
(float16_t)-0.35129275608556703725f,(float16_t)0.93626566717027825959f,
(float16_t)-0.35416352542049039931f,(float16_t)0.93518350993894761025f,
(float16_t)-0.35703096123342992207f,(float16_t)0.93409255040425898109f,
(float16_t)-0.35989503653498816638f,(float16_t)0.93299279883473884567f,
(float16_t)-0.36275572436739711435f,(float16_t)0.93188426558166814750f,
(float16_t)-0.36561299780477385379f,(float16_t)0.93076696107898371224f,
(float16_t)-0.36846682995337221023f,(float16_t)0.92964089584318132520f,
(float16_t)-0.37131719395183748755f,(float16_t)0.92850608047321558924f,
(float16_t)-0.37416406297145787807f,(float16_t)0.92736252565040111495f,
(float16_t)-0.37700741021641820394f,(float16_t)0.92621024213831137928f,
(float16_t)-0.37984720892405099413f,(float16_t)0.92504924078267769527f,
(float16_t)-0.38268343236508972627f,(float16_t)0.92387953251128673848f,
(float16_t)-0.38551605384391890441f,(float16_t)0.92270112833387851747f,
(float16_t)-0.38834504669882619066f,(float16_t)0.92151403934204201285f,
(float16_t)-0.39117038430225387069f,(float16_t)0.92031827670911059425f,
(float16_t)-0.39399204006104798781f,(float16_t)0.91911385169005777040f,
(float16_t)-0.39680998741671030805f,(float16_t)0.91790077562139049672f,
(float16_t)-0.39962419984564667708f,(float16_t)0.91667905992104270485f,
(float16_t)-0.40243465085941843018f,(float16_t)0.91544871608826783316f,
(float16_t)-0.40524131400498974998f,(float16_t)0.91420975570353069095f,
(float16_t)-0.40804416286497863231f,(float16_t)0.91296219042839821256f,
(float16_t)-0.41084317105790379987f,(float16_t)0.91170603200542987832f,
(float16_t)-0.41363831223843450235f,(float16_t)0.91044129225806724737f,
(float16_t)-0.41642956009763698599f,(float16_t)0.90916798309052249127f,
(float16_t)-0.41921688836322407168f,(float16_t)0.90788611648766615048f,
(float16_t)-0.42200027079979968159f,(float16_t)0.90659570451491533483f,
(float16_t)-0.42477968120910869487f,(float16_t)0.90529675931811881551f,
(float16_t)-0.42755509343028186287f,(float16_t)0.90398929312344344922f,
(float16_t)-0.43032648134008272267f,(float16_t)0.90267331823725871498f,
(float16_t)-0.43309381885315190175f,(float16_t)0.90134884704602202810f,
(float16_t)-0.43585707992225536378f,(float16_t)0.90001589201616027935f,
(float16_t)-0.43861623853852738097f,(float16_t)0.89867446569395392775f,
(float16_t)-0.44137126873171672603f,(float16_t)0.89732458070541831763f,
(float16_t)-0.44412214457042914484f,(float16_t)0.89596624975618521791f,
(float16_t)-0.44686884016237399253f,(float16_t)0.89459948563138280697f,
(float16_t)-0.44961132965460670619f,(float16_t)0.89322430119551521344f,
(float16_t)-0.45234958723377088896f,(float16_t)0.89184070939234272313f,
(float16_t)-0.45508358712634372489f,(float16_t)0.89044872324475798919f,
(float16_t)-0.45781330359887700832f,(float16_t)0.88904835585466468473f,
(float16_t)-0.46053871095824006066f,(float16_t)0.88763962040285393496f,
(float16_t)-0.46325978355186014923f,(float16_t)0.88622253014888063838f,
(float16_t)-0.46597649576796601467f,(float16_t)0.88479709843093790056f,
(float16_t)-0.46868882203582767909f,(float16_t)0.88336333866573168994f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.47410021465054991152f,(float16_t)0.88047088905216086552f,
(float16_t)-0.47679923006332192159f,(float16_t)0.87901222642863352519f,
(float16_t)-0.47949375766015311928f,(float16_t)0.87754529020726124156f,
(float16_t)-0.48218377207912271887f,(float16_t)0.87607009419540660122f,
(float16_t)-0.48486924800079100883f,(float16_t)0.87458665227817622423f,
(float16_t)-0.48755016014843571837f,(float16_t)0.87309497841829020182f,
(float16_t)-0.49022648328829121489f,(float16_t)0.87159508665595097909f,
(float16_t)-0.49289819222978398239f,(float16_t)0.87008699110871146054f,
(float16_t)-0.49556526182577237405f,(float16_t)0.86857070597134100609f,
(float16_t)-0.49822766697278159098f,(float16_t)0.86704624551569275948f,
(float16_t)-0.50088538261124082585f,(float16_t)0.86551362409056908920f,
(float16_t)-0.50353838372571746440f,(float16_t)0.86397285612158680745f,
(float16_t)-0.50618664534515511733f,(float16_t)0.86242395611104061270f,
(float16_t)-0.50883014254310710012f,(float16_t)0.86086693863776719837f,
(float16_t)-0.51146885043797041259f,(float16_t)0.85930181835700847337f,
(float16_t)-0.51410274419322155026f,(float16_t)0.85772861000027211809f,
(float16_t)-0.51673179901764965116f,(float16_t)0.85614732837519458286f,
(float16_t)-0.51935599016558964269f,(float16_t)0.85455798836540053376f,
(float16_t)-0.52197529293715427823f,(float16_t)0.85296060493036374162f,
(float16_t)-0.52458968267846872724f,(float16_t)0.85135519310526519554f,
(float16_t)-0.52719913478190105760f,(float16_t)0.84974176800085265970f,
(float16_t)-0.52980362468629471628f,(float16_t)0.84812034480329723252f,
(float16_t)-0.53240312787719790144f,(float16_t)0.84649093877405212627f,
(float16_t)-0.53499761988709704230f,(float16_t)0.84485356524970722791f,
(float16_t)-0.53758707629564561614f,(float16_t)0.84320823964184532517f,
(float16_t)-0.54017147272989285423f,(float16_t)0.84155497743689844370f,
(float16_t)-0.54275078486451577842f,(float16_t)0.83989379419599952126f,
(float16_t)-0.54532498842204624179f,(float16_t)0.83822470555483818977f,
(float16_t)-0.54789405917310018967f,(float16_t)0.83654772722351200542f,
(float16_t)-0.55045797293660470029f,(float16_t)0.83486287498638012128f,
(float16_t)-0.55301670558002735678f,(float16_t)0.83317016470191329613f,
(float16_t)-0.55557023301960195560f,(float16_t)0.83146961230254534669f,
(float16_t)-0.55811853122055610221f,(float16_t)0.82976123379452304540f,
(float16_t)-0.56066157619733592021f,(float16_t)0.82804504525775579626f,
(float16_t)-0.56319934401383386913f,(float16_t)0.82632106284566364529f,
(float16_t)-0.56573181078361323149f,(float16_t)0.82458930278502517996f,
(float16_t)-0.56825895267013148970f,(float16_t)0.82284978137582631685f,
(float16_t)-0.57078074588696714464f,(float16_t)0.82110251499110475937f,
(float16_t)-0.57329716669804198226f,(float16_t)0.81934752007679712005f,
(float16_t)-0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)-0.57831379641165547856f,(float16_t)0.81581441080673378075f,
(float16_t)-0.58081395809576441547f,(float16_t)0.81403632970594852480f,
(float16_t)-0.58330865293769840196f,(float16_t)0.81225058658520388200f,
(float16_t)-0.58579785745643886408f,(float16_t)0.81045719825259476821f,
(float16_t)-0.58828154822264522306f,(float16_t)0.80865618158817509364f,
(float16_t)-0.59075970185887405339f,(float16_t)0.80684755354379944503f,
(float16_t)-0.59323229503979990618f,(float16_t)0.80503133114296354655f,
(float16_t)-0.59569930449243335691f,(float16_t)0.80320753148064494287f,
(float16_t)-0.59816070699634216190f,(float16_t)0.80137617172314024039f,
(float16_t)-0.60061647938386875101f,(float16_t)0.79953726910790523519f,
(float16_t)-0.60306659854034827539f,(float16_t)0.79769084094339104407f,
(float16_t)-0.60551104140432543410f,(float16_t)0.79583690460888356633f,
(float16_t)-0.60794978496777352106f,(float16_t)0.79397547755433728334f,
(float16_t)-0.61038280627630958630f,(float16_t)0.79210657730021227785f,
(float16_t)-0.61281008242940970820f,(float16_t)0.79023022143731003197f,
(float16_t)-0.61523159058062670823f,(float16_t)0.78834642762660633863f,
(float16_t)-0.61764730793780375784f,(float16_t)0.78645521359908587833f,
(float16_t)-0.62005721176328920663f,(float16_t)0.78455659715557513056f,
(float16_t)-0.62246127937414996723f,(float16_t)0.78265059616657572938f,
(float16_t)-0.62485948814238623239f,(float16_t)0.78073722857209459924f,
(float16_t)-0.62725181549514386070f,(float16_t)0.77881651238147608929f,
(float16_t)-0.62963823891492709528f,(float16_t)0.77688846567323244230f,
(float16_t)-0.63201873593980895105f,(float16_t)0.77495310659487393057f,
(float16_t)-0.63439328416364537677f,(float16_t)0.77301045336273710440f,
(float16_t)-0.63676186123628431002f,(float16_t)0.77106052426181370674f,
(float16_t)-0.63912444486377573138f,(float16_t)0.76910333764557958780f,
(float16_t)-0.64148101280858305095f,(float16_t)0.76713891193582040007f,
(float16_t)-0.64383154288979127511f,(float16_t)0.76516726562245906962f,
(float16_t)-0.64617601298331639459f,(float16_t)0.76318841726338115805f,
(float16_t)-0.64851440102211244110f,(float16_t)0.76120238548426188974f,
(float16_t)-0.65084668499638076433f,(float16_t)0.75920918897838807204f,
(float16_t)-0.65317284295377653347f,(float16_t)0.75720884650648467851f,
(float16_t)-0.65549285299961546070f,(float16_t)0.75520137689653643598f,
(float16_t)-0.65780669329707852633f,(float16_t)0.75318679904361252042f,
(float16_t)-0.66011434206742036768f,(float16_t)0.75116513190968658975f,
(float16_t)-0.66241577759017189475f,(float16_t)0.74913639452345925918f,
(float16_t)-0.66471097820334490436f,(float16_t)0.74710060598018013245f,
(float16_t)-0.66699992230363736034f,(float16_t)0.74505778544146605835f,
(float16_t)-0.66928258834663589827f,(float16_t)0.74300795213512182968f,
(float16_t)-0.67155895484701844111f,(float16_t)0.74095112535495899486f,
(float16_t)-0.67382900037875603783f,(float16_t)0.73888732446061522463f,
(float16_t)-0.67609270357531581208f,(float16_t)0.73681656887737001504f,
(float16_t)-0.67835004312986124653f,(float16_t)0.73473887809596372112f,
(float16_t)-0.68060099779545302212f,(float16_t)0.73265427167241281570f,
(float16_t)-0.68284554638524797010f,(float16_t)0.73056276922782759087f,
(float16_t)-0.68508366777270024439f,(float16_t)0.72846439044822530740f,
(float16_t)-0.68731534089175916336f,(float16_t)0.72635915508434589771f,
(float16_t)-0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)-0.69175925836415763648f,(float16_t)0.72212819392921545614f,
(float16_t)-0.69397146088965377952f,(float16_t)0.72000250796138176579f,
(float16_t)-0.69617713149146298601f,(float16_t)0.71787004505573170920f,
(float16_t)-0.69837624940897280457f,(float16_t)0.71573082528381870571f,
(float16_t)-0.70056879394324822474f,(float16_t)0.71358486878079363525f,
(float16_t)-0.70275474445722507788f,(float16_t)0.71143219574521665560f,
(float16_t)-0.70493408037590488124f,(float16_t)0.70927282643886557789f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.70927282643886546687f,(float16_t)0.70493408037590510329f,
(float16_t)-0.71143219574521654458f,(float16_t)0.70275474445722518890f,
(float16_t)-0.71358486878079352422f,(float16_t)0.70056879394324833576f,
(float16_t)-0.71573082528381859468f,(float16_t)0.69837624940897291559f,
(float16_t)-0.71787004505573159818f,(float16_t)0.69617713149146309703f,
(float16_t)-0.72000250796138165477f,(float16_t)0.69397146088965389055f,
(float16_t)-0.72212819392921523409f,(float16_t)0.69175925836415785852f,
(float16_t)-0.72424708295146678072f,(float16_t)0.68954054473706705153f,
(float16_t)-0.72635915508434578669f,(float16_t)0.68731534089175927438f,
(float16_t)-0.72846439044822519637f,(float16_t)0.68508366777270035541f,
(float16_t)-0.73056276922782747985f,(float16_t)0.68284554638524808112f,
(float16_t)-0.73265427167241270467f,(float16_t)0.68060099779545324417f,
(float16_t)-0.73473887809596349907f,(float16_t)0.67835004312986135755f,
(float16_t)-0.73681656887736979300f,(float16_t)0.67609270357531592310f,
(float16_t)-0.73888732446061511361f,(float16_t)0.67382900037875614885f,
(float16_t)-0.74095112535495888384f,(float16_t)0.67155895484701855214f,
(float16_t)-0.74300795213512171866f,(float16_t)0.66928258834663600929f,
(float16_t)-0.74505778544146594733f,(float16_t)0.66699992230363758239f,
(float16_t)-0.74710060598018002143f,(float16_t)0.66471097820334501538f,
(float16_t)-0.74913639452345914815f,(float16_t)0.66241577759017200577f,
(float16_t)-0.75116513190968636771f,(float16_t)0.66011434206742047870f,
(float16_t)-0.75318679904361240940f,(float16_t)0.65780669329707874837f,
(float16_t)-0.75520137689653643598f,(float16_t)0.65549285299961557172f,
(float16_t)-0.75720884650648467851f,(float16_t)0.65317284295377664449f,
(float16_t)-0.75920918897838796102f,(float16_t)0.65084668499638098638f,
(float16_t)-0.76120238548426166769f,(float16_t)0.64851440102211255212f,
(float16_t)-0.76318841726338115805f,(float16_t)0.64617601298331661663f,
(float16_t)-0.76516726562245895860f,(float16_t)0.64383154288979138613f,
(float16_t)-0.76713891193582040007f,(float16_t)0.64148101280858316198f,
(float16_t)-0.76910333764557947678f,(float16_t)0.63912444486377584241f,
(float16_t)-0.77106052426181359571f,(float16_t)0.63676186123628442104f,
(float16_t)-0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)-0.77495310659487381955f,(float16_t)0.63201873593980906207f,
(float16_t)-0.77688846567323233128f,(float16_t)0.62963823891492720630f,
(float16_t)-0.77881651238147597827f,(float16_t)0.62725181549514408275f,
(float16_t)-0.78073722857209448822f,(float16_t)0.62485948814238634341f,
(float16_t)-0.78265059616657561836f,(float16_t)0.62246127937415007825f,
(float16_t)-0.78455659715557501954f,(float16_t)0.62005721176328942867f,
(float16_t)-0.78645521359908576731f,(float16_t)0.61764730793780386886f,
(float16_t)-0.78834642762660622761f,(float16_t)0.61523159058062693028f,
(float16_t)-0.79023022143730992095f,(float16_t)0.61281008242940981923f,
(float16_t)-0.79210657730021216683f,(float16_t)0.61038280627630969732f,
(float16_t)-0.79397547755433717231f,(float16_t)0.60794978496777363208f,
(float16_t)-0.79583690460888345530f,(float16_t)0.60551104140432565615f,
(float16_t)-0.79769084094339093305f,(float16_t)0.60306659854034838641f,
(float16_t)-0.79953726910790512417f,(float16_t)0.60061647938386886203f,
(float16_t)-0.80137617172314024039f,(float16_t)0.59816070699634238395f,
(float16_t)-0.80320753148064483184f,(float16_t)0.59569930449243346793f,
(float16_t)-0.80503133114296343553f,(float16_t)0.59323229503980001720f,
(float16_t)-0.80684755354379933401f,(float16_t)0.59075970185887416442f,
(float16_t)-0.80865618158817498262f,(float16_t)0.58828154822264533408f,
(float16_t)-0.81045719825259465718f,(float16_t)0.58579785745643897510f,
(float16_t)-0.81225058658520377097f,(float16_t)0.58330865293769851299f,
(float16_t)-0.81403632970594841378f,(float16_t)0.58081395809576452649f,
(float16_t)-0.81581441080673378075f,(float16_t)0.57831379641165570060f,
(float16_t)-0.81758481315158360037f,(float16_t)0.57580819141784544968f,
(float16_t)-0.81934752007679700903f,(float16_t)0.57329716669804209328f,
(float16_t)-0.82110251499110464835f,(float16_t)0.57078074588696725566f,
(float16_t)-0.82284978137582620583f,(float16_t)0.56825895267013171175f,
(float16_t)-0.82458930278502506894f,(float16_t)0.56573181078361345353f,
(float16_t)-0.82632106284566353427f,(float16_t)0.56319934401383409117f,
(float16_t)-0.82804504525775568524f,(float16_t)0.56066157619733614226f,
(float16_t)-0.82976123379452293438f,(float16_t)0.55811853122055632426f,
(float16_t)-0.83146961230254534669f,(float16_t)0.55557023301960217765f,
(float16_t)-0.83317016470191318511f,(float16_t)0.55301670558002746780f,
(float16_t)-0.83486287498638001026f,(float16_t)0.55045797293660492233f,
(float16_t)-0.83654772722351189440f,(float16_t)0.54789405917310041172f,
(float16_t)-0.83822470555483807875f,(float16_t)0.54532498842204635281f,
(float16_t)-0.83989379419599952126f,(float16_t)0.54275078486451588944f,
(float16_t)-0.84155497743689833268f,(float16_t)0.54017147272989296525f,
(float16_t)-0.84320823964184532517f,(float16_t)0.53758707629564572716f,
(float16_t)-0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)-0.84649093877405201525f,(float16_t)0.53240312787719801246f,
(float16_t)-0.84812034480329712149f,(float16_t)0.52980362468629482731f,
(float16_t)-0.84974176800085254868f,(float16_t)0.52719913478190127964f,
(float16_t)-0.85135519310526519554f,(float16_t)0.52458968267846894928f,
(float16_t)-0.85296060493036363059f,(float16_t)0.52197529293715438925f,
(float16_t)-0.85455798836540042274f,(float16_t)0.51935599016558975372f,
(float16_t)-0.85614732837519447184f,(float16_t)0.51673179901764976218f,
(float16_t)-0.85772861000027200706f,(float16_t)0.51410274419322177231f,
(float16_t)-0.85930181835700836235f,(float16_t)0.51146885043797052361f,
(float16_t)-0.86086693863776719837f,(float16_t)0.50883014254310732216f,
(float16_t)-0.86242395611104050168f,(float16_t)0.50618664534515522835f,
(float16_t)-0.86397285612158669643f,(float16_t)0.50353838372571757542f,
(float16_t)-0.86551362409056897818f,(float16_t)0.50088538261124093687f,
(float16_t)-0.86704624551569264845f,(float16_t)0.49822766697278175752f,
(float16_t)-0.86857070597134089507f,(float16_t)0.49556526182577254058f,
(float16_t)-0.87008699110871134952f,(float16_t)0.49289819222978414892f,
(float16_t)-0.87159508665595086807f,(float16_t)0.49022648328829138142f,
(float16_t)-0.87309497841829009079f,(float16_t)0.48755016014843588490f,
(float16_t)-0.87458665227817611321f,(float16_t)0.48486924800079111986f,
(float16_t)-0.87607009419540649020f,(float16_t)0.48218377207912288540f,
(float16_t)-0.87754529020726113053f,(float16_t)0.47949375766015328582f,
(float16_t)-0.87901222642863352519f,(float16_t)0.47679923006332208812f,
(float16_t)-0.88047088905216075450f,(float16_t)0.47410021465055007805f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.88336333866573168994f,(float16_t)0.46868882203582784562f,
(float16_t)-0.88479709843093778954f,(float16_t)0.46597649576796618121f,
(float16_t)-0.88622253014888052736f,(float16_t)0.46325978355186031576f,
(float16_t)-0.88763962040285382393f,(float16_t)0.46053871095824022719f,
(float16_t)-0.88904835585466457371f,(float16_t)0.45781330359887717485f,
(float16_t)-0.89044872324475787817f,(float16_t)0.45508358712634389143f,
(float16_t)-0.89184070939234261211f,(float16_t)0.45234958723377105549f,
(float16_t)-0.89322430119551521344f,(float16_t)0.44961132965460687272f,
(float16_t)-0.89459948563138269595f,(float16_t)0.44686884016237415906f,
(float16_t)-0.89596624975618510689f,(float16_t)0.44412214457042931137f,
(float16_t)-0.89732458070541820661f,(float16_t)0.44137126873171689256f,
(float16_t)-0.89867446569395392775f,(float16_t)0.43861623853852754751f,
(float16_t)-0.90001589201616016833f,(float16_t)0.43585707992225553031f,
(float16_t)-0.90134884704602191707f,(float16_t)0.43309381885315206828f,
(float16_t)-0.90267331823725871498f,(float16_t)0.43032648134008288920f,
(float16_t)-0.90398929312344333820f,(float16_t)0.42755509343028202940f,
(float16_t)-0.90529675931811870448f,(float16_t)0.42477968120910886141f,
(float16_t)-0.90659570451491533483f,(float16_t)0.42200027079979984812f,
(float16_t)-0.90788611648766603945f,(float16_t)0.41921688836322423821f,
(float16_t)-0.90916798309052238025f,(float16_t)0.41642956009763715253f,
(float16_t)-0.91044129225806713634f,(float16_t)0.41363831223843466889f,
(float16_t)-0.91170603200542976730f,(float16_t)0.41084317105790413294f,
(float16_t)-0.91296219042839821256f,(float16_t)0.40804416286497857680f,
(float16_t)-0.91420975570353069095f,(float16_t)0.40524131400498991651f,
(float16_t)-0.91544871608826772214f,(float16_t)0.40243465085941859671f,
(float16_t)-0.91667905992104259383f,(float16_t)0.39962419984564706565f,
(float16_t)-0.91790077562139049672f,(float16_t)0.39680998741671025254f,
(float16_t)-0.91911385169005777040f,(float16_t)0.39399204006104815434f,
(float16_t)-0.92031827670911048322f,(float16_t)0.39117038430225403722f,
(float16_t)-0.92151403934204179080f,(float16_t)0.38834504669882657923f,
(float16_t)-0.92270112833387862850f,(float16_t)0.38551605384391884890f,
(float16_t)-0.92387953251128673848f,(float16_t)0.38268343236508989280f,
(float16_t)-0.92504924078267747323f,(float16_t)0.37984720892405138271f,
(float16_t)-0.92621024213831137928f,(float16_t)0.37700741021641814843f,
(float16_t)-0.92736252565040111495f,(float16_t)0.37416406297145804460f,
(float16_t)-0.92850608047321547822f,(float16_t)0.37131719395183770960f,
(float16_t)-0.92964089584318121418f,(float16_t)0.36846682995337259880f,
(float16_t)-0.93076696107898371224f,(float16_t)0.36561299780477379828f,
(float16_t)-0.93188426558166803648f,(float16_t)0.36275572436739728088f,
(float16_t)-0.93299279883473884567f,(float16_t)0.35989503653498833291f,
(float16_t)-0.93409255040425875904f,(float16_t)0.35703096123343031065f,
(float16_t)-0.93518350993894761025f,(float16_t)0.35416352542049039931f,
(float16_t)-0.93626566717027825959f,(float16_t)0.35129275608556720378f,
(float16_t)-0.93733901191257484875f,(float16_t)0.34841868024943478677f,
(float16_t)-0.93840353406310816897f,(float16_t)0.34554132496398898278f,
(float16_t)-0.93945922360218991898f,(float16_t)0.34266071731199443384f,
(float16_t)-0.94050607059326829518f,(float16_t)0.33977688440682701776f,
(float16_t)-0.94154406518302069529f,(float16_t)0.33688985339222032867f,
(float16_t)-0.94257319760144686605f,(float16_t)0.33399965144200938205f,
(float16_t)-0.94359345816196038559f,(float16_t)0.33110630575987648472f,
(float16_t)-0.94460483726148014583f,(float16_t)0.32820984357909271933f,
(float16_t)-0.94560732538052116869f,(float16_t)0.32531029216226325929f,
(float16_t)-0.94660091308328353499f,(float16_t)0.32240767880106985244f,
(float16_t)-0.94758559101774109124f,(float16_t)0.31950203081601580291f,
(float16_t)-0.94856134991573026749f,(float16_t)0.31659337555616606785f,
(float16_t)-0.94952818059303667475f,(float16_t)0.31368174039889140658f,
(float16_t)-0.95048607394948170235f,(float16_t)0.31076715274961153046f,
(float16_t)-0.95143502096900833820f,(float16_t)0.30784964004153503314f,
(float16_t)-0.95237501271976576778f,(float16_t)0.30492922973540265152f,
(float16_t)-0.95330604035419386211f,(float16_t)0.30200594931922802866f,
(float16_t)-0.95422809510910555630f,(float16_t)0.29907982630804053059f,
(float16_t)-0.95514116830577067141f,(float16_t)0.29615088824362401088f,
(float16_t)-0.95604525134999629454f,(float16_t)0.29321916269425896129f,
(float16_t)-0.95694033573220882438f,(float16_t)0.29028467725446238656f,
(float16_t)-0.95782641302753290802f,(float16_t)0.28734745954472962204f,
(float16_t)-0.95870347489587148804f,(float16_t)0.28440753721127209896f,
(float16_t)-0.95957151308198451733f,(float16_t)0.28146493792575788540f,
(float16_t)-0.96043051941556578655f,(float16_t)0.27851968938505317075f,
(float16_t)-0.96128048581132063966f,(float16_t)0.27557181931095831029f,
(float16_t)-0.96212140426904146917f,(float16_t)0.27262135544994925418f,
(float16_t)-0.96295326687368387741f,(float16_t)0.26966832557291509076f,
(float16_t)-0.96377606579543984022f,(float16_t)0.26671275747489847641f,
(float16_t)-0.96458979328981264700f,(float16_t)0.26375467897483156898f,
(float16_t)-0.96539444169768928727f,(float16_t)0.26079411791527584707f,
(float16_t)-0.96619000344541250413f,(float16_t)0.25783110216215898713f,
(float16_t)-0.96697647104485207059f,(float16_t)0.25486565960451468271f,
(float16_t)-0.96775383709347539973f,(float16_t)0.25189781815421719013f,
(float16_t)-0.96852209427441737777f,(float16_t)0.24892760574572009302f,
(float16_t)-0.96928123535654842069f,(float16_t)0.24595505033579465048f,
(float16_t)-0.97003125319454397424f,(float16_t)0.24298017990326406523f,
(float16_t)-0.97077214072895023911f,(float16_t)0.24000302244874177626f,
(float16_t)-0.97150389098625178352f,(float16_t)0.23702360599436717026f,
(float16_t)-0.97222649707893626925f,(float16_t)0.23404195858354351345f,
(float16_t)-0.97293995220556006576f,(float16_t)0.23105810828067133156f,
(float16_t)-0.97364424965081186603f,(float16_t)0.22807208317088606409f,
(float16_t)-0.97433938278557585821f,(float16_t)0.22508391135979283204f,
(float16_t)-0.97502534506699412020f,(float16_t)0.22209362097320364815f,
(float16_t)-0.97570213003852845901f,(float16_t)0.21910124015687004739f,
(float16_t)-0.97636973133002114000f,(float16_t)0.21610679707621943679f,
(float16_t)-0.97702814265775439484f,(float16_t)0.21311031991609141745f,
(float16_t)-0.97767735782450992943f,(float16_t)0.21011183688046980444f,
(float16_t)-0.97831737071962754371f,(float16_t)0.20711137619221883788f,
(float16_t)-0.97894817531906219710f,(float16_t)0.20410896609281684033f,
(float16_t)-0.97956976568544051887f,(float16_t)0.20110463484209201157f,
(float16_t)-0.98018213596811731847f,(float16_t)0.19809841071795381007f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.98137919331375456089f,(float16_t)0.19208039704989246510f,
(float16_t)-0.98196386910955524296f,(float16_t)0.18906866414980635915f,
(float16_t)-0.98253930228744124076f,(float16_t)0.18605515166344691047f,
(float16_t)-0.98310548743121628501f,(float16_t)0.18303988795514089527f,
(float16_t)-0.98366241921173025453f,(float16_t)0.18002290140569957022f,
(float16_t)-0.98421009238692902521f,(float16_t)0.17700422041214894375f,
(float16_t)-0.98474850180190420801f,(float16_t)0.17398387338746412745f,
(float16_t)-0.98527764238894122162f,(float16_t)0.17096188876030121717f,
(float16_t)-0.98579750916756736512f,(float16_t)0.16793829497473128365f,
(float16_t)-0.98630809724459855836f,(float16_t)0.16491312048997014417f,
(float16_t)-0.98680940181418552726f,(float16_t)0.16188639378011174252f,
(float16_t)-0.98730141815785843473f,(float16_t)0.15885814333386147346f,
(float16_t)-0.98778414164457217783f,(float16_t)0.15582839765426537149f,
(float16_t)-0.98825756773074946437f,(float16_t)0.15279718525844368515f,
(float16_t)-0.98872169196032377858f,(float16_t)0.14976453467732145364f,
(float16_t)-0.98917650996478101444f,(float16_t)0.14673047445536180344f,
(float16_t)-0.98962201746320077600f,(float16_t)0.14369503315029463764f,
(float16_t)-0.99005821026229701154f,(float16_t)0.14065823933284954395f,
(float16_t)-0.99048508425645709341f,(float16_t)0.13762012158648603832f,
(float16_t)-0.99090263542778000971f,(float16_t)0.13458070850712627875f,
(float16_t)-0.99131085984611544415f,(float16_t)0.13154002870288333815f,
(float16_t)-0.99170975366909952520f,(float16_t)0.12849811079379308554f,
(float16_t)-0.99209931314219179654f,(float16_t)0.12545498341154626143f,
(float16_t)-0.99247953459870996706f,(float16_t)0.12241067519921634832f,
(float16_t)-0.99285041445986510489f,(float16_t)0.11936521481099163222f,
(float16_t)-0.99321194923479450001f,(float16_t)0.11631863091190471071f,
(float16_t)-0.99356413552059530403f,(float16_t)0.11327095217756441570f,
(float16_t)-0.99390697000235606051f,(float16_t)0.11022220729388323979f,
(float16_t)-0.99424044945318790223f,(float16_t)0.10717242495680916192f,
(float16_t)-0.99456457073425541537f,(float16_t)0.10412163387205457254f,
(float16_t)-0.99487933079480561638f,(float16_t)0.10106986275482793269f,
(float16_t)-0.99518472667219681771f,(float16_t)0.09801714032956082567f,
(float16_t)-0.99548075549192693856f,(float16_t)0.09496349532963890838f,
(float16_t)-0.99576741446765981713f,(float16_t)0.09190895649713275162f,
(float16_t)-0.99604470090125196702f,(float16_t)0.08885355258252475297f,
(float16_t)-0.99631261218277800129f,(float16_t)0.08579731234444015753f,
(float16_t)-0.99657114579055483539f,(float16_t)0.08274026454937563613f,
(float16_t)-0.99682029929116566791f,(float16_t)0.07968243797143019502f,
(float16_t)-0.99706007033948296225f,(float16_t)0.07662386139203168633f,
(float16_t)-0.99729045667869020697f,(float16_t)0.07356456359966773162f,
(float16_t)-0.99751145614030345410f,(float16_t)0.07050457338961385600f,
(float16_t)-0.99772306664419163624f,(float16_t)0.06744391956366417584f,
(float16_t)-0.99792528619859599548f,(float16_t)0.06438263092985770097f,
(float16_t)-0.99811811290014917919f,(float16_t)0.06132073630220848809f,
(float16_t)-0.99830154493389289261f,(float16_t)0.05825826450043579408f,
(float16_t)-0.99847558057329477421f,(float16_t)0.05519524434969009380f,
(float16_t)-0.99864021818026516009f,(float16_t)0.05213170468028359428f,
(float16_t)-0.99879545620517240501f,(float16_t)0.04906767432741796636f,
(float16_t)-0.99894129318685687124f,(float16_t)0.04600318213091470626f,
(float16_t)-0.99907772775264536147f,(float16_t)0.04293825693494102147f,
(float16_t)-0.99920475861836388631f,(float16_t)0.03987292758774012985f,
(float16_t)-0.99932238458834954375f,(float16_t)0.03680722294135883171f,
(float16_t)-0.99943060455546173237f,(float16_t)0.03374117185137770480f,
(float16_t)-0.99952941750109314256f,(float16_t)0.03067480317663686534f,
(float16_t)-0.99961882249517863830f,(float16_t)0.02760814577896565994f,
(float16_t)-0.99969881869620424997f,(float16_t)0.02454122852291232629f,
(float16_t)-0.99976940535121527898f,(float16_t)0.02147408027546966747f,
(float16_t)-0.99983058179582340319f,(float16_t)0.01840672990580510121f,
(float16_t)-0.99988234745421256111f,(float16_t)0.01533920628498806026f,
(float16_t)-0.99992470183914450299f,(float16_t)0.01227153828572000692f,
(float16_t)-0.99995764455196389786f,(float16_t)0.00920375478206002066f,
(float16_t)-0.99998117528260110909f,(float16_t)0.00613588464915479880f,
(float16_t)-0.99999529380957619118f,(float16_t)0.00306795676296597701f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99992470183914450299f,(float16_t)0.01227153828571992539f,
(float16_t)0.99969881869620424997f,(float16_t)0.02454122852291228812f,
(float16_t)0.99932238458834954375f,(float16_t)0.03680722294135883171f,
(float16_t)0.99879545620517240501f,(float16_t)0.04906767432741801493f,
(float16_t)0.99811811290014917919f,(float16_t)0.06132073630220857829f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.99631261218277800129f,(float16_t)0.08579731234443989385f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.99390697000235606051f,(float16_t)0.11022220729388305938f,
(float16_t)0.99247953459870996706f,(float16_t)0.12241067519921619566f,
(float16_t)0.99090263542778000971f,(float16_t)0.13458070850712616773f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98730141815785843473f,(float16_t)0.15885814333386144570f,
(float16_t)0.98527764238894122162f,(float16_t)0.17096188876030121717f,
(float16_t)0.98310548743121628501f,(float16_t)0.18303988795514095078f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.97831737071962765473f,(float16_t)0.20711137619221856032f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.97293995220556017678f,(float16_t)0.23105810828067110951f,
(float16_t)0.97003125319454397424f,(float16_t)0.24298017990326387094f,
(float16_t)0.96697647104485207059f,(float16_t)0.25486565960451457169f,
(float16_t)0.96377606579543984022f,(float16_t)0.26671275747489836538f,
(float16_t)0.96043051941556578655f,(float16_t)0.27851968938505305973f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.95330604035419386211f,(float16_t)0.30200594931922808417f,
(float16_t)0.94952818059303667475f,(float16_t)0.31368174039889151761f,
(float16_t)0.94560732538052127971f,(float16_t)0.32531029216226292622f,
(float16_t)0.94154406518302080631f,(float16_t)0.33688985339222005111f,
(float16_t)0.93733901191257495977f,(float16_t)0.34841868024943456472f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.92850608047321558924f,(float16_t)0.37131719395183754306f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.91911385169005777040f,(float16_t)0.39399204006104809883f,
(float16_t)0.91420975570353069095f,(float16_t)0.40524131400498986100f,
(float16_t)0.90916798309052238025f,(float16_t)0.41642956009763715253f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.89867446569395381673f,(float16_t)0.43861623853852765853f,
(float16_t)0.89322430119551532446f,(float16_t)0.44961132965460653965f,
(float16_t)0.88763962040285393496f,(float16_t)0.46053871095824000514f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.87607009419540660122f,(float16_t)0.48218377207912271887f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.86397285612158669643f,(float16_t)0.50353838372571757542f,
(float16_t)0.85772861000027211809f,(float16_t)0.51410274419322166128f,
(float16_t)0.85135519310526519554f,(float16_t)0.52458968267846894928f,
(float16_t)0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)0.83822470555483807875f,(float16_t)0.54532498842204646383f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.82458930278502529099f,(float16_t)0.56573181078361312046f,
(float16_t)0.81758481315158371139f,(float16_t)0.57580819141784533866f,
(float16_t)0.81045719825259476821f,(float16_t)0.58579785745643886408f,
(float16_t)0.80320753148064494287f,(float16_t)0.59569930449243335691f,
(float16_t)0.79583690460888356633f,(float16_t)0.60551104140432554512f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.78073722857209448822f,(float16_t)0.62485948814238634341f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.76516726562245895860f,(float16_t)0.64383154288979138613f,
(float16_t)0.75720884650648456748f,(float16_t)0.65317284295377675551f,
(float16_t)0.74913639452345937020f,(float16_t)0.66241577759017178373f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.73265427167241281570f,(float16_t)0.68060099779545302212f,
(float16_t)0.72424708295146700276f,(float16_t)0.68954054473706682948f,
(float16_t)0.71573082528381870571f,(float16_t)0.69837624940897280457f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.69837624940897291559f,(float16_t)0.71573082528381859468f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.68060099779545302212f,(float16_t)0.73265427167241281570f,
(float16_t)0.67155895484701833009f,(float16_t)0.74095112535495910588f,
(float16_t)0.66241577759017178373f,(float16_t)0.74913639452345925918f,
(float16_t)0.65317284295377686654f,(float16_t)0.75720884650648456748f,
(float16_t)0.64383154288979149715f,(float16_t)0.76516726562245895860f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.62485948814238645443f,(float16_t)0.78073722857209448822f,
(float16_t)0.61523159058062681925f,(float16_t)0.78834642762660622761f,
(float16_t)0.60551104140432554512f,(float16_t)0.79583690460888345530f,
(float16_t)0.59569930449243346793f,(float16_t)0.80320753148064483184f,
(float16_t)0.58579785745643886408f,(float16_t)0.81045719825259476821f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.56573181078361323149f,(float16_t)0.82458930278502529099f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.54532498842204646383f,(float16_t)0.83822470555483796772f,
(float16_t)0.53499761988709726435f,(float16_t)0.84485356524970700587f,
(float16_t)0.52458968267846883826f,(float16_t)0.85135519310526519554f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.50353838372571757542f,(float16_t)0.86397285612158669643f,
(float16_t)0.49289819222978409341f,(float16_t)0.87008699110871134952f,
(float16_t)0.48218377207912282989f,(float16_t)0.87607009419540660122f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.46053871095824000514f,(float16_t)0.88763962040285393496f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.43861623853852771404f,(float16_t)0.89867446569395381673f,
(float16_t)0.42755509343028219593f,(float16_t)0.90398929312344333820f,
(float16_t)0.41642956009763731906f,(float16_t)0.90916798309052226923f,
(float16_t)0.40524131400498986100f,(float16_t)0.91420975570353069095f,
(float16_t)0.39399204006104809883f,(float16_t)0.91911385169005777040f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.37131719395183759858f,(float16_t)0.92850608047321558924f,
(float16_t)0.35989503653498827740f,(float16_t)0.93299279883473884567f,
(float16_t)0.34841868024943450921f,(float16_t)0.93733901191257495977f,
(float16_t)0.33688985339222005111f,(float16_t)0.94154406518302080631f,
(float16_t)0.32531029216226298173f,(float16_t)0.94560732538052127971f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.30200594931922819519f,(float16_t)0.95330604035419375109f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.27851968938505305973f,(float16_t)0.96043051941556578655f,
(float16_t)0.26671275747489842090f,(float16_t)0.96377606579543984022f,
(float16_t)0.25486565960451462720f,(float16_t)0.96697647104485207059f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.23105810828067127605f,(float16_t)0.97293995220556006576f,
(float16_t)0.21910124015686976984f,(float16_t)0.97570213003852857003f,
(float16_t)0.20711137619221856032f,(float16_t)0.97831737071962765473f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.18303988795514106180f,(float16_t)0.98310548743121628501f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.15885814333386139019f,(float16_t)0.98730141815785843473f,
(float16_t)0.14673047445536174793f,(float16_t)0.98917650996478101444f,
(float16_t)0.13458070850712622324f,(float16_t)0.99090263542778000971f,
(float16_t)0.12241067519921627893f,(float16_t)0.99247953459870996706f,
(float16_t)0.11022220729388318428f,(float16_t)0.99390697000235606051f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.08579731234443987997f,(float16_t)0.99631261218277800129f,
(float16_t)0.07356456359966745406f,(float16_t)0.99729045667869020697f,
(float16_t)0.06132073630220864768f,(float16_t)0.99811811290014917919f,
(float16_t)0.04906767432741812596f,(float16_t)0.99879545620517240501f,
(float16_t)0.03680722294135899131f,(float16_t)0.99932238458834954375f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)0.01227153828571994447f,(float16_t)0.99992470183914450299f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.01227153828571982304f,(float16_t)0.99992470183914450299f,
(float16_t)-0.02454122852291214241f,(float16_t)0.99969881869620424997f,
(float16_t)-0.03680722294135886641f,(float16_t)0.99932238458834954375f,
(float16_t)-0.04906767432741800800f,(float16_t)0.99879545620517240501f,
(float16_t)-0.06132073630220852972f,(float16_t)0.99811811290014917919f,
(float16_t)-0.07356456359966732916f,(float16_t)0.99729045667869020697f,
(float16_t)-0.08579731234443975507f,(float16_t)0.99631261218277800129f,
(float16_t)-0.09801714032956064526f,(float16_t)0.99518472667219692873f,
(float16_t)-0.11022220729388305938f,(float16_t)0.99390697000235606051f,
(float16_t)-0.12241067519921615403f,(float16_t)0.99247953459870996706f,
(float16_t)-0.13458070850712611222f,(float16_t)0.99090263542778000971f,
(float16_t)-0.14673047445536163691f,(float16_t)0.98917650996478101444f,
(float16_t)-0.15885814333386127917f,(float16_t)0.98730141815785843473f,
(float16_t)-0.17096188876030124493f,(float16_t)0.98527764238894122162f,
(float16_t)-0.18303988795514092303f,(float16_t)0.98310548743121628501f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.20711137619221844930f,(float16_t)0.97831737071962765473f,
(float16_t)-0.21910124015686965881f,(float16_t)0.97570213003852857003f,
(float16_t)-0.23105810828067113727f,(float16_t)0.97293995220556017678f,
(float16_t)-0.24298017990326387094f,(float16_t)0.97003125319454397424f,
(float16_t)-0.25486565960451451618f,(float16_t)0.96697647104485207059f,
(float16_t)-0.26671275747489830987f,(float16_t)0.96377606579543984022f,
(float16_t)-0.27851968938505294870f,(float16_t)0.96043051941556589757f,
(float16_t)-0.29028467725446216452f,(float16_t)0.95694033573220893540f,
(float16_t)-0.30200594931922808417f,(float16_t)0.95330604035419386211f,
(float16_t)-0.31368174039889140658f,(float16_t)0.94952818059303667475f,
(float16_t)-0.32531029216226287071f,(float16_t)0.94560732538052139073f,
(float16_t)-0.33688985339221994009f,(float16_t)0.94154406518302080631f,
(float16_t)-0.34841868024943439819f,(float16_t)0.93733901191257495977f,
(float16_t)-0.35989503653498816638f,(float16_t)0.93299279883473884567f,
(float16_t)-0.37131719395183748755f,(float16_t)0.92850608047321558924f,
(float16_t)-0.38268343236508972627f,(float16_t)0.92387953251128673848f,
(float16_t)-0.39399204006104798781f,(float16_t)0.91911385169005777040f,
(float16_t)-0.40524131400498974998f,(float16_t)0.91420975570353069095f,
(float16_t)-0.41642956009763698599f,(float16_t)0.90916798309052249127f,
(float16_t)-0.42755509343028186287f,(float16_t)0.90398929312344344922f,
(float16_t)-0.43861623853852738097f,(float16_t)0.89867446569395392775f,
(float16_t)-0.44961132965460670619f,(float16_t)0.89322430119551521344f,
(float16_t)-0.46053871095824006066f,(float16_t)0.88763962040285393496f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.48218377207912271887f,(float16_t)0.87607009419540660122f,
(float16_t)-0.49289819222978398239f,(float16_t)0.87008699110871146054f,
(float16_t)-0.50353838372571746440f,(float16_t)0.86397285612158680745f,
(float16_t)-0.51410274419322155026f,(float16_t)0.85772861000027211809f,
(float16_t)-0.52458968267846872724f,(float16_t)0.85135519310526519554f,
(float16_t)-0.53499761988709704230f,(float16_t)0.84485356524970722791f,
(float16_t)-0.54532498842204624179f,(float16_t)0.83822470555483818977f,
(float16_t)-0.55557023301960195560f,(float16_t)0.83146961230254534669f,
(float16_t)-0.56573181078361323149f,(float16_t)0.82458930278502517996f,
(float16_t)-0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)-0.58579785745643886408f,(float16_t)0.81045719825259476821f,
(float16_t)-0.59569930449243335691f,(float16_t)0.80320753148064494287f,
(float16_t)-0.60551104140432543410f,(float16_t)0.79583690460888356633f,
(float16_t)-0.61523159058062670823f,(float16_t)0.78834642762660633863f,
(float16_t)-0.62485948814238623239f,(float16_t)0.78073722857209459924f,
(float16_t)-0.63439328416364537677f,(float16_t)0.77301045336273710440f,
(float16_t)-0.64383154288979127511f,(float16_t)0.76516726562245906962f,
(float16_t)-0.65317284295377653347f,(float16_t)0.75720884650648467851f,
(float16_t)-0.66241577759017189475f,(float16_t)0.74913639452345925918f,
(float16_t)-0.67155895484701844111f,(float16_t)0.74095112535495899486f,
(float16_t)-0.68060099779545302212f,(float16_t)0.73265427167241281570f,
(float16_t)-0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)-0.69837624940897280457f,(float16_t)0.71573082528381870571f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.71573082528381859468f,(float16_t)0.69837624940897291559f,
(float16_t)-0.72424708295146678072f,(float16_t)0.68954054473706705153f,
(float16_t)-0.73265427167241270467f,(float16_t)0.68060099779545324417f,
(float16_t)-0.74095112535495888384f,(float16_t)0.67155895484701855214f,
(float16_t)-0.74913639452345914815f,(float16_t)0.66241577759017200577f,
(float16_t)-0.75720884650648467851f,(float16_t)0.65317284295377664449f,
(float16_t)-0.76516726562245895860f,(float16_t)0.64383154288979138613f,
(float16_t)-0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)-0.78073722857209448822f,(float16_t)0.62485948814238634341f,
(float16_t)-0.78834642762660622761f,(float16_t)0.61523159058062693028f,
(float16_t)-0.79583690460888345530f,(float16_t)0.60551104140432565615f,
(float16_t)-0.80320753148064483184f,(float16_t)0.59569930449243346793f,
(float16_t)-0.81045719825259465718f,(float16_t)0.58579785745643897510f,
(float16_t)-0.81758481315158360037f,(float16_t)0.57580819141784544968f,
(float16_t)-0.82458930278502506894f,(float16_t)0.56573181078361345353f,
(float16_t)-0.83146961230254534669f,(float16_t)0.55557023301960217765f,
(float16_t)-0.83822470555483807875f,(float16_t)0.54532498842204635281f,
(float16_t)-0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)-0.85135519310526519554f,(float16_t)0.52458968267846894928f,
(float16_t)-0.85772861000027200706f,(float16_t)0.51410274419322177231f,
(float16_t)-0.86397285612158669643f,(float16_t)0.50353838372571757542f,
(float16_t)-0.87008699110871134952f,(float16_t)0.49289819222978414892f,
(float16_t)-0.87607009419540649020f,(float16_t)0.48218377207912288540f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.88763962040285382393f,(float16_t)0.46053871095824022719f,
(float16_t)-0.89322430119551521344f,(float16_t)0.44961132965460687272f,
(float16_t)-0.89867446569395392775f,(float16_t)0.43861623853852754751f,
(float16_t)-0.90398929312344333820f,(float16_t)0.42755509343028202940f,
(float16_t)-0.90916798309052238025f,(float16_t)0.41642956009763715253f,
(float16_t)-0.91420975570353069095f,(float16_t)0.40524131400498991651f,
(float16_t)-0.91911385169005777040f,(float16_t)0.39399204006104815434f,
(float16_t)-0.92387953251128673848f,(float16_t)0.38268343236508989280f,
(float16_t)-0.92850608047321547822f,(float16_t)0.37131719395183770960f,
(float16_t)-0.93299279883473884567f,(float16_t)0.35989503653498833291f,
(float16_t)-0.93733901191257484875f,(float16_t)0.34841868024943478677f,
(float16_t)-0.94154406518302069529f,(float16_t)0.33688985339222032867f,
(float16_t)-0.94560732538052116869f,(float16_t)0.32531029216226325929f,
(float16_t)-0.94952818059303667475f,(float16_t)0.31368174039889140658f,
(float16_t)-0.95330604035419386211f,(float16_t)0.30200594931922802866f,
(float16_t)-0.95694033573220882438f,(float16_t)0.29028467725446238656f,
(float16_t)-0.96043051941556578655f,(float16_t)0.27851968938505317075f,
(float16_t)-0.96377606579543984022f,(float16_t)0.26671275747489847641f,
(float16_t)-0.96697647104485207059f,(float16_t)0.25486565960451468271f,
(float16_t)-0.97003125319454397424f,(float16_t)0.24298017990326406523f,
(float16_t)-0.97293995220556006576f,(float16_t)0.23105810828067133156f,
(float16_t)-0.97570213003852845901f,(float16_t)0.21910124015687004739f,
(float16_t)-0.97831737071962754371f,(float16_t)0.20711137619221883788f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.98310548743121628501f,(float16_t)0.18303988795514089527f,
(float16_t)-0.98527764238894122162f,(float16_t)0.17096188876030121717f,
(float16_t)-0.98730141815785843473f,(float16_t)0.15885814333386147346f,
(float16_t)-0.98917650996478101444f,(float16_t)0.14673047445536180344f,
(float16_t)-0.99090263542778000971f,(float16_t)0.13458070850712627875f,
(float16_t)-0.99247953459870996706f,(float16_t)0.12241067519921634832f,
(float16_t)-0.99390697000235606051f,(float16_t)0.11022220729388323979f,
(float16_t)-0.99518472667219681771f,(float16_t)0.09801714032956082567f,
(float16_t)-0.99631261218277800129f,(float16_t)0.08579731234444015753f,
(float16_t)-0.99729045667869020697f,(float16_t)0.07356456359966773162f,
(float16_t)-0.99811811290014917919f,(float16_t)0.06132073630220848809f,
(float16_t)-0.99879545620517240501f,(float16_t)0.04906767432741796636f,
(float16_t)-0.99932238458834954375f,(float16_t)0.03680722294135883171f,
(float16_t)-0.99969881869620424997f,(float16_t)0.02454122852291232629f,
(float16_t)-0.99992470183914450299f,(float16_t)0.01227153828572000692f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99879545620517240501f,(float16_t)0.04906767432741801493f,
(float16_t)0.99518472667219692873f,(float16_t)0.09801714032956060363f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.97003125319454397424f,(float16_t)0.24298017990326387094f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.94154406518302080631f,(float16_t)0.33688985339222005111f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.88192126434835504956f,(float16_t)0.47139673682599764204f,
(float16_t)0.85772861000027211809f,(float16_t)0.51410274419322166128f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.80320753148064494287f,(float16_t)0.59569930449243335691f,
(float16_t)0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.67155895484701833009f,(float16_t)0.74095112535495910588f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.59569930449243346793f,(float16_t)0.80320753148064483184f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.47139673682599780857f,(float16_t)0.88192126434835493853f,
(float16_t)0.42755509343028219593f,(float16_t)0.90398929312344333820f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.33688985339222005111f,(float16_t)0.94154406518302080631f,
(float16_t)0.29028467725446233105f,(float16_t)0.95694033573220893540f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.14673047445536174793f,(float16_t)0.98917650996478101444f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.04906767432741812596f,(float16_t)0.99879545620517240501f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.04906767432741800800f,(float16_t)0.99879545620517240501f,
(float16_t)-0.09801714032956064526f,(float16_t)0.99518472667219692873f,
(float16_t)-0.14673047445536163691f,(float16_t)0.98917650996478101444f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.24298017990326387094f,(float16_t)0.97003125319454397424f,
(float16_t)-0.29028467725446216452f,(float16_t)0.95694033573220893540f,
(float16_t)-0.33688985339221994009f,(float16_t)0.94154406518302080631f,
(float16_t)-0.38268343236508972627f,(float16_t)0.92387953251128673848f,
(float16_t)-0.42755509343028186287f,(float16_t)0.90398929312344344922f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.51410274419322155026f,(float16_t)0.85772861000027211809f,
(float16_t)-0.55557023301960195560f,(float16_t)0.83146961230254534669f,
(float16_t)-0.59569930449243335691f,(float16_t)0.80320753148064494287f,
(float16_t)-0.63439328416364537677f,(float16_t)0.77301045336273710440f,
(float16_t)-0.67155895484701844111f,(float16_t)0.74095112535495899486f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.74095112535495888384f,(float16_t)0.67155895484701855214f,
(float16_t)-0.77301045336273699338f,(float16_t)0.63439328416364548779f,
(float16_t)-0.80320753148064483184f,(float16_t)0.59569930449243346793f,
(float16_t)-0.83146961230254534669f,(float16_t)0.55557023301960217765f,
(float16_t)-0.85772861000027200706f,(float16_t)0.51410274419322177231f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.90398929312344333820f,(float16_t)0.42755509343028202940f,
(float16_t)-0.92387953251128673848f,(float16_t)0.38268343236508989280f,
(float16_t)-0.94154406518302069529f,(float16_t)0.33688985339222032867f,
(float16_t)-0.95694033573220882438f,(float16_t)0.29028467725446238656f,
(float16_t)-0.97003125319454397424f,(float16_t)0.24298017990326406523f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.98917650996478101444f,(float16_t)0.14673047445536180344f,
(float16_t)-0.99518472667219681771f,(float16_t)0.09801714032956082567f,
(float16_t)-0.99879545620517240501f,(float16_t)0.04906767432741796636f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.98078528040323043058f,(float16_t)0.19509032201612824808f,
(float16_t)0.92387953251128673848f,(float16_t)0.38268343236508978178f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.55557023301960228867f,(float16_t)0.83146961230254523567f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.19509032201612833135f,(float16_t)0.98078528040323043058f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.38268343236508972627f,(float16_t)0.92387953251128673848f,
(float16_t)-0.55557023301960195560f,(float16_t)0.83146961230254534669f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.83146961230254534669f,(float16_t)0.55557023301960217765f,
(float16_t)-0.92387953251128673848f,(float16_t)0.38268343236508989280f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.70710678118654757274f,(float16_t)0.70710678118654757274f,
(float16_t)0.00000000000000006123f,(float16_t)1.00000000000000000000f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,};

float16_t rearranged_twiddle_stride3_4096_f16[2728]={
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99998941108192840321f,(float16_t)0.00460192612044857050f,
(float16_t)0.99995764455196389786f,(float16_t)0.00920375478205981944f,
(float16_t)0.99990470108285289808f,(float16_t)0.01380538852806039059f,
(float16_t)0.99983058179582340319f,(float16_t)0.01840672990580482019f,
(float16_t)0.99973528826056168306f,(float16_t)0.02300768146883936868f,
(float16_t)0.99961882249517863830f,(float16_t)0.02760814577896573974f,
(float16_t)0.99948118696616694567f,(float16_t)0.03220802540830458582f,
(float16_t)0.99932238458834954375f,(float16_t)0.03680722294135883171f,
(float16_t)0.99914241872481690532f,(float16_t)0.04140564097707673946f,
(float16_t)0.99894129318685687124f,(float16_t)0.04600318213091462299f,
(float16_t)0.99871901223387293811f,(float16_t)0.05059974903689928166f,
(float16_t)0.99847558057329477421f,(float16_t)0.05519524434968993420f,
(float16_t)0.99821100336047818846f,(float16_t)0.05978957074663986820f,
(float16_t)0.99792528619859599548f,(float16_t)0.06438263092985746505f,
(float16_t)0.99761843513851955478f,(float16_t)0.06897432762826674613f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.99694135776498216117f,(float16_t)0.07815324163279423197f,
(float16_t)0.99657114579055483539f,(float16_t)0.08274026454937569164f,
(float16_t)0.99617982859569698117f,(float16_t)0.08732553520619205922f,
(float16_t)0.99576741446765981713f,(float16_t)0.09190895649713272386f,
(float16_t)0.99533391214048227980f,(float16_t)0.09649043135525259274f,
(float16_t)0.99487933079480561638f,(float16_t)0.10106986275482782167f,
(float16_t)0.99440368005767909576f,(float16_t)0.10564715371341061589f,
(float16_t)0.99390697000235606051f,(float16_t)0.11022220729388305938f,
(float16_t)0.99338921114808065305f,(float16_t)0.11479492660651008373f,
(float16_t)0.99285041445986510489f,(float16_t)0.11936521481099135467f,
(float16_t)0.99229059134825736699f,(float16_t)0.12393297511851215920f,
(float16_t)0.99170975366909952520f,(float16_t)0.12849811079379316880f,
(float16_t)0.99110791372327688986f,(float16_t)0.13306052515713906459f,
(float16_t)0.99048508425645709341f,(float16_t)0.13762012158648603832f,
(float16_t)0.98984127845882052821f,(float16_t)0.14217680351944803063f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98849079285269658701f,(float16_t)0.15128103795733022219f,
(float16_t)0.98778414164457217783f,(float16_t)0.15582839765426523271f,
(float16_t)0.98705657130575097380f,(float16_t)0.16037245724292828464f,
(float16_t)0.98630809724459866938f,(float16_t)0.16491312048996989437f,
(float16_t)0.98553873531217606185f,(float16_t)0.16945029123396795900f,
(float16_t)0.98474850180190420801f,(float16_t)0.17398387338746382214f,
(float16_t)0.98393741344921892278f,(float16_t)0.17851377093899750692f,
(float16_t)0.98310548743121628501f,(float16_t)0.18303988795514095078f,
(float16_t)0.98225274136628937249f,(float16_t)0.18756212858252960252f,
(float16_t)0.98137919331375456089f,(float16_t)0.19208039704989243734f,
(float16_t)0.98048486177346938497f,(float16_t)0.19659459767008022335f,
(float16_t)0.97956976568544051887f,(float16_t)0.20110463484209190055f,
(float16_t)0.97863392442942320759f,(float16_t)0.20561041305309923910f,
(float16_t)0.97767735782450992943f,(float16_t)0.21011183688046961016f,
(float16_t)0.97670008612871184184f,(float16_t)0.21460881099378675829f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.97468351068851066810f,(float16_t)0.22358902922978998729f,
(float16_t)0.97364424965081197705f,(float16_t)0.22807208317088573102f,
(float16_t)0.97258436893473221296f,(float16_t)0.23255030703877524467f,
(float16_t)0.97150389098625178352f,(float16_t)0.23702360599436719801f,
(float16_t)0.97040283868755550234f,(float16_t)0.24149188530286933019f,
(float16_t)0.96928123535654853171f,(float16_t)0.24595505033579459497f,
(float16_t)0.96813910474636244441f,(float16_t)0.25041300657296522436f,
(float16_t)0.96697647104485207059f,(float16_t)0.25486565960451457169f,
(float16_t)0.96579335887408368500f,(float16_t)0.25931291513288623474f,
(float16_t)0.96458979328981275803f,(float16_t)0.26375467897483134694f,
(float16_t)0.96336579978095404631f,(float16_t)0.26819085706340317632f,
(float16_t)0.96212140426904158019f,(float16_t)0.27262135544994897662f,
(float16_t)0.96085663310767965850f,(float16_t)0.27704608030609989555f,
(float16_t)0.95957151308198451733f,(float16_t)0.28146493792575794091f,
(float16_t)0.95826607140801767226f,(float16_t)0.28587783472708061527f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.95559433413077110586f,(float16_t)0.29468537218051432669f,
(float16_t)0.95422809510910566733f,(float16_t)0.29907982630804047508f,
(float16_t)0.95284164760119871573f,(float16_t)0.30346794657201131562f,
(float16_t)0.95143502096900833820f,(float16_t)0.30784964004153486661f,
(float16_t)0.95000824500184299914f,(float16_t)0.31222481392182488413f,
(float16_t)0.94856134991573026749f,(float16_t)0.31659337555616584581f,
(float16_t)0.94709436635277721717f,(float16_t)0.32095523242787521445f,
(float16_t)0.94560732538052127971f,(float16_t)0.32531029216226292622f,
(float16_t)0.94410025849127265918f,(float16_t)0.32965846252858749255f,
(float16_t)0.94257319760144686605f,(float16_t)0.33399965144200938205f,
(float16_t)0.94102617505088925753f,(float16_t)0.33833376696554112728f,
(float16_t)0.93945922360218991898f,(float16_t)0.34266071731199437833f,
(float16_t)0.93787237643998988545f,(float16_t)0.34698041084592368133f,
(float16_t)0.93626566717027825959f,(float16_t)0.35129275608556709276f,
(float16_t)0.93463912981968078064f,(float16_t)0.35559766170478385172f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.93132670908118042608f,(float16_t)0.36418478956707989180f,
(float16_t)0.92964089584318121418f,(float16_t)0.36846682995337232125f,
(float16_t)0.92793539482261788720f,(float16_t)0.37274106700951575855f,
(float16_t)0.92621024213831137928f,(float16_t)0.37700741021641825945f,
(float16_t)0.92446547432526260391f,(float16_t)0.38126576922216237620f,
(float16_t)0.92270112833387862850f,(float16_t)0.38551605384391884890f,
(float16_t)0.92091724152918941204f,(float16_t)0.38975817406985641123f,
(float16_t)0.91911385169005777040f,(float16_t)0.39399204006104809883f,
(float16_t)0.91729099700837790632f,(float16_t)0.39821756215337356100f,
(float16_t)0.91544871608826783316f,(float16_t)0.40243465085941843018f,
(float16_t)0.91358704794525080750f,(float16_t)0.40664321687036902864f,
(float16_t)0.91170603200542987832f,(float16_t)0.41084317105790391089f,
(float16_t)0.90980570810465222209f,(float16_t)0.41503442447608163146f,
(float16_t)0.90788611648766626150f,(float16_t)0.41921688836322390515f,
(float16_t)0.90594729780726845902f,(float16_t)0.42339047414379604728f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.90201214390249317976f,(float16_t)0.43171065802505725895f,
(float16_t)0.90001589201616016833f,(float16_t)0.43585707992225547480f,
(float16_t)0.89800057974073987932f,(float16_t)0.43999427130963325583f,
(float16_t)0.89596624975618521791f,(float16_t)0.44412214457042920035f,
(float16_t)0.89391294514520325265f,(float16_t)0.44824061228521988598f,
(float16_t)0.89184070939234272313f,(float16_t)0.45234958723377088896f,
(float16_t)0.88974958638307277692f,(float16_t)0.45644898239688391772f,
(float16_t)0.88763962040285393496f,(float16_t)0.46053871095824000514f,
(float16_t)0.88551085613619995307f,(float16_t)0.46461868630623781584f,
(float16_t)0.88336333866573157891f,(float16_t)0.46868882203582790114f,
(float16_t)0.88119711347122209322f,(float16_t)0.47274903195034279069f,
(float16_t)0.87901222642863352519f,(float16_t)0.47679923006332208812f,
(float16_t)0.87680872380914565145f,(float16_t)0.48083933060033395845f,
(float16_t)0.87458665227817611321f,(float16_t)0.48486924800079106435f,
(float16_t)0.87234605889439154058f,(float16_t)0.48888889691976317176f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.86780949676330332299f,(float16_t)0.49689704902265446895f,
(float16_t)0.86551362409056908920f,(float16_t)0.50088538261124071482f,
(float16_t)0.86319942171212415971f,(float16_t)0.50486310853126759035f,
(float16_t)0.86086693863776730939f,(float16_t)0.50883014254310698909f,
(float16_t)0.85851622426444273994f,(float16_t)0.51278640063356295542f,
(float16_t)0.85614732837519447184f,(float16_t)0.51673179901764987321f,
(float16_t)0.85376030113811141042f,(float16_t)0.52066625414036715735f,
(float16_t)0.85135519310526519554f,(float16_t)0.52458968267846894928f,
(float16_t)0.84893205521163961347f,(float16_t)0.52850200154222848337f,
(float16_t)0.84649093877405212627f,(float16_t)0.53240312787719790144f,
(float16_t)0.84403189549006640835f,(float16_t)0.53629297906596318235f,
(float16_t)0.84155497743689844370f,(float16_t)0.54017147272989285423f,
(float16_t)0.83906023707031274217f,(float16_t)0.54403852673088382019f,
(float16_t)0.83654772722351200542f,(float16_t)0.54789405917310018967f,
(float16_t)0.83401750110601813315f,(float16_t)0.55173798840470733573f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.82890411477186487499f,(float16_t)0.55939071185913613604f,
(float16_t)0.82632106284566353427f,(float16_t)0.56319934401383409117f,
(float16_t)0.82372051122739142759f,(float16_t)0.56699604882510867832f,
(float16_t)0.82110251499110464835f,(float16_t)0.57078074588696725566f,
(float16_t)0.81846712958029865792f,(float16_t)0.57455335504771576360f,
(float16_t)0.81581441080673378075f,(float16_t)0.57831379641165558958f,
(float16_t)0.81314441484925359394f,(float16_t)0.58206199034077543697f,
(float16_t)0.81045719825259476821f,(float16_t)0.58579785745643886408f,
(float16_t)0.80775281792619035848f,(float16_t)0.58952131864106394055f,
(float16_t)0.80503133114296365758f,(float16_t)0.59323229503979979516f,
(float16_t)0.80229279553811572168f,(float16_t)0.59693070806219639124f,
(float16_t)0.79953726910790501314f,(float16_t)0.60061647938386897305f,
(float16_t)0.79676481020841882774f,(float16_t)0.60428953094815596181f,
(float16_t)0.79397547755433717231f,(float16_t)0.60794978496777363208f,
(float16_t)0.79116933021769020318f,(float16_t)0.61159716392646190641f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.78550682956405393220f,(float16_t)0.61885298796097631957f,
(float16_t)0.78265059616657572938f,(float16_t)0.62246127937414996723f,
(float16_t)0.77977778792301455368f,(float16_t)0.62605638840434352232f,
(float16_t)0.77688846567323244230f,(float16_t)0.62963823891492698426f,
(float16_t)0.77398269060682289844f,(float16_t)0.63320675505005719064f,
(float16_t)0.77106052426181381776f,(float16_t)0.63676186123628419899f,
(float16_t)0.76812202852336541881f,(float16_t)0.64030348218415167327f,
(float16_t)0.76516726562245895860f,(float16_t)0.64383154288979138613f,
(float16_t)0.76219629813457900891f,(float16_t)0.64734596863651205911f,
(float16_t)0.75920918897838796102f,(float16_t)0.65084668499638087535f,
(float16_t)0.75620600141439453523f,(float16_t)0.65433361783180044036f,
(float16_t)0.75318679904361252042f,(float16_t)0.65780669329707863735f,
(float16_t)0.75015164580621507273f,(float16_t)0.66126583783999226540f,
(float16_t)0.74710060598018013245f,(float16_t)0.66471097820334479334f,
(float16_t)0.74403374417992929057f,(float16_t)0.66814204142651845153f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.73785281478846598269f,(float16_t)0.67496164610201192513f,
(float16_t)0.73473887809596349907f,(float16_t)0.67835004312986146857f,
(float16_t)0.73160938122389262972f,(float16_t)0.68172407417164970767f,
(float16_t)0.72846439044822519637f,(float16_t)0.68508366777270035541f,
(float16_t)0.72530397237306076796f,(float16_t)0.68842875278409043638f,
(float16_t)0.72212819392921534511f,(float16_t)0.69175925836415774750f,
(float16_t)0.71893712237280449351f,(float16_t)0.69507511398000088043f,
(float16_t)0.71573082528381870571f,(float16_t)0.69837624940897280457f,
(float16_t)0.71250937056469243469f,(float16_t)0.70166259474016845488f,
(float16_t)0.70927282643886568891f,(float16_t)0.70493408037590488124f,
(float16_t)0.70602126144933974317f,(float16_t)0.70819063703319540259f,
(float16_t)0.70275474445722529993f,(float16_t)0.71143219574521643356f,
(float16_t)0.69947334464028376733f,(float16_t)0.71465868786276909308f,
(float16_t)0.69617713149146298601f,(float16_t)0.71787004505573170920f,
(float16_t)0.69286617481742474034f,(float16_t)0.72106619931450810501f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.68620031168003858824f,(float16_t)0.72741262860237576593f,
(float16_t)0.68284554638524808112f,(float16_t)0.73056276922782759087f,
(float16_t)0.67947631989936496666f,(float16_t)0.73369743811466026084f,
(float16_t)0.67609270357531603413f,(float16_t)0.73681656887736979300f,
(float16_t)0.67269476907077296879f,(float16_t)0.73992009545951609173f,
(float16_t)0.66928258834663600929f,(float16_t)0.74300795213512171866f,
(float16_t)0.66585623366550972246f,(float16_t)0.74608007351006366825f,
(float16_t)0.66241577759017178373f,(float16_t)0.74913639452345925918f,
(float16_t)0.65896129298203731661f,(float16_t)0.75217685044904269986f,
(float16_t)0.65549285299961546070f,(float16_t)0.75520137689653654700f,
(float16_t)0.65201053109695950027f,(float16_t)0.75820990981301528144f,
(float16_t)0.64851440102211255212f,(float16_t)0.76120238548426177871f,
(float16_t)0.64500453681554403840f,(float16_t)0.76417874053611667406f,
(float16_t)0.64148101280858316198f,(float16_t)0.76713891193582040007f,
(float16_t)0.63794390362184416610f,(float16_t)0.77008283699334789674f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.63082922962842458148f,(float16_t)0.77592169904340757558f,
(float16_t)0.62725181549514419377f,(float16_t)0.77881651238147586724f,
(float16_t)0.62366111752569464155f,(float16_t)0.78169483207105938671f,
(float16_t)0.62005721176328920663f,(float16_t)0.78455659715557524159f,
(float16_t)0.61644017453085364622f,(float16_t)0.78740174702903131809f,
(float16_t)0.61281008242940970820f,(float16_t)0.79023022143731003197f,
(float16_t)0.60916701233645320634f,(float16_t)0.79304196047944364167f,
(float16_t)0.60551104140432554512f,(float16_t)0.79583690460888345530f,
(float16_t)0.60184224705858002658f,(float16_t)0.79861499463476082195f,
(float16_t)0.59816070699634238395f,(float16_t)0.80137617172314012937f,
(float16_t)0.59446649918466454299f,(float16_t)0.80412037739826569549f,
(float16_t)0.59075970185887427544f,(float16_t)0.80684755354379922299f,
(float16_t)0.58704039352091808013f,(float16_t)0.80955764240405125864f,
(float16_t)0.58330865293769829094f,(float16_t)0.81225058658520388200f,
(float16_t)0.57956455913940574387f,(float16_t)0.81492632905652662156f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.57203962932475704850f,(float16_t)0.82022598256943468620f,
(float16_t)0.56825895267013148970f,(float16_t)0.82284978137582631685f,
(float16_t)0.56446624152051949608f,(float16_t)0.82545615400437744036f,
(float16_t)0.56066157619733603124f,(float16_t)0.82804504525775579626f,
(float16_t)0.55684503727516010407f,(float16_t)0.83061640030884620334f,
(float16_t)0.55301670558002757883f,(float16_t)0.83317016470191318511f,
(float16_t)0.54917666218771976627f,(float16_t)0.83570628435375260423f,
(float16_t)0.54532498842204646383f,(float16_t)0.83822470555483796772f,
(float16_t)0.54146176585312355556f,(float16_t)0.84072537497045796151f,
(float16_t)0.53758707629564550512f,(float16_t)0.84320823964184543620f,
(float16_t)0.53370100180715296379f,(float16_t)0.84567324698729906540f,
(float16_t)0.52980362468629482731f,(float16_t)0.84812034480329712149f,
(float16_t)0.52589502747108474168f,(float16_t)0.85054948126560336874f,
(float16_t)0.52197529293715438925f,(float16_t)0.85296060493036363059f,
(float16_t)0.51804450409599933636f,(float16_t)0.85535366473519602870f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.51015009670676669806f,(float16_t)0.86008539042939025077f,
(float16_t)0.50618664534515533937f,(float16_t)0.86242395611104050168f,
(float16_t)0.50221247404571089934f,(float16_t)0.86474425751946237817f,
(float16_t)0.49822766697278186854f,(float16_t)0.86704624551569264845f,
(float16_t)0.49423230851595972846f,(float16_t)0.86932987134860673084f,
(float16_t)0.49022648328829110387f,(float16_t)0.87159508665595109012f,
(float16_t)0.48621027612448652899f,(float16_t)0.87384184346536675214f,
(float16_t)0.48218377207912282989f,(float16_t)0.87607009419540660122f,
(float16_t)0.47814705642484311987f,(float16_t)0.87827979165654146421f,
(float16_t)0.47410021465055002254f,(float16_t)0.88047088905216075450f,
(float16_t)0.47004333245959561971f,(float16_t)0.88264333997956279099f,
(float16_t)0.46597649576796612569f,(float16_t)0.88479709843093778954f,
(float16_t)0.46189979070246284243f,(float16_t)0.88693211879434208367f,
(float16_t)0.45781330359887728587f,(float16_t)0.88904835585466457371f,
(float16_t)0.45371712100016392544f,(float16_t)0.89114576479458318392f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.44549601651398174074f,(float16_t)0.89528392103855758410f,
(float16_t)0.44137126873171661501f,(float16_t)0.89732458070541831763f,
(float16_t)0.43723717366104419835f,(float16_t)0.89934623697934146236f,
(float16_t)0.43309381885315201277f,(float16_t)0.90134884704602202810f,
(float16_t)0.42894129205532954829f,(float16_t)0.90333236849451181705f,
(float16_t)0.42477968120910880589f,(float16_t)0.90529675931811881551f,
(float16_t)0.42060907444840250902f,(float16_t)0.90724197791529592738f,
(float16_t)0.41642956009763731906f,(float16_t)0.90916798309052226923f,
(float16_t)0.41224122666988299857f,(float16_t)0.91107473405517624965f,
(float16_t)0.40804416286497874333f,(float16_t)0.91296219042839810154f,
(float16_t)0.40383845756765412993f,(float16_t)0.91483031223794608611f,
(float16_t)0.39962419984564678810f,(float16_t)0.91667905992104270485f,
(float16_t)0.39540147894781629834f,(float16_t)0.91850839432521225181f,
(float16_t)0.39117038430225398171f,(float16_t)0.92031827670911048322f,
(float16_t)0.38693100551438869283f,(float16_t)0.92210866874334507237f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.37842775480876561511f,(float16_t)0.92563083050987271516f,
(float16_t)0.37416406297145798909f,(float16_t)0.92736252565040111495f,
(float16_t)0.36989244714893426691f,(float16_t)0.92907458125931574600f,
(float16_t)0.36561299780477396482f,(float16_t)0.93076696107898371224f,
(float16_t)0.36132580556845433906f,(float16_t)0.93243962926846235550f,
(float16_t)0.35703096123343003310f,(float16_t)0.93409255040425887007f,
(float16_t)0.35272855575521072646f,(float16_t)0.93572568948108036935f,
(float16_t)0.34841868024943450921f,(float16_t)0.93733901191257495977f,
(float16_t)0.34410142598993898044f,(float16_t)0.93893248353206448797f,
(float16_t)0.33977688440682696225f,(float16_t)0.94050607059326829518f,
(float16_t)0.33544514708453165852f,(float16_t)0.94205973977101731265f,
(float16_t)0.33110630575987642921f,(float16_t)0.94359345816196038559f,
(float16_t)0.32676045232013178898f,(float16_t)0.94510719328526060501f,
(float16_t)0.32240767880107001897f,(float16_t)0.94660091308328353499f,
(float16_t)0.31804807738501505998f,(float16_t)0.94807458592227622507f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.30930876031226878231f,(float16_t)0.95096166631157508231f,
(float16_t)0.30492922973540242948f,(float16_t)0.95237501271976587880f,
(float16_t)0.30054324141727339903f,(float16_t)0.95376818988599032512f,
(float16_t)0.29615088824362395536f,(float16_t)0.95514116830577067141f,
(float16_t)0.29175226323498937298f,(float16_t)0.95649391890239499059f,
(float16_t)0.28734745954472956653f,(float16_t)0.95782641302753290802f,
(float16_t)0.28293657045705539188f,(float16_t)0.95913862246184189431f,
(float16_t)0.27851968938505305973f,(float16_t)0.96043051941556578655f,
(float16_t)0.27409690986870632878f,(float16_t)0.96170207652912254037f,
(float16_t)0.26966832557291520178f,(float16_t)0.96295326687368387741f,
(float16_t)0.26523403028551190141f,(float16_t)0.96418406395174571788f,
(float16_t)0.26079411791527556952f,(float16_t)0.96539444169768939830f,
(float16_t)0.25634868248994291395f,(float16_t)0.96658437447833311928f,
(float16_t)0.25189781815421691258f,(float16_t)0.96775383709347551076f,
(float16_t)0.24744161916777343557f,(float16_t)0.96890280477642887202f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.23851359484431849944f,(float16_t)0.97113915844972509284f,
(float16_t)0.23404195858354345794f,(float16_t)0.97222649707893626925f,
(float16_t)0.22956536582051886852f,(float16_t)0.97329324605469824672f,
(float16_t)0.22508391135979277653f,(float16_t)0.97433938278557585821f,
(float16_t)0.22059769010887364526f,(float16_t)0.97536488511665686563f,
(float16_t)0.21610679707621960333f,(float16_t)0.97636973133002114000f,
(float16_t)0.21161132736922760866f,(float16_t)0.97735390014519996082f,
(float16_t)0.20711137619221856032f,(float16_t)0.97831737071962765473f,
(float16_t)0.20260703884442110567f,(float16_t)0.97926012264908202098f,
(float16_t)0.19809841071795372680f,(float16_t)0.98018213596811731847f,
(float16_t)0.19358558729580374602f,(float16_t)0.98108339115048659451f,
(float16_t)0.18906866414980627589f,(float16_t)0.98196386910955524296f,
(float16_t)0.18454773693861964423f,(float16_t)0.98282355119870523641f,
(float16_t)0.18002290140569951471f,(float16_t)0.98366241921173025453f,
(float16_t)0.17549425337727139751f,(float16_t)0.98448045538322093151f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.16642590354046421508f,(float16_t)0.98605396334619543897f,
(float16_t)0.16188639378011188130f,(float16_t)0.98680940181418541624f,
(float16_t)0.15734345561623827581f,(float16_t)0.98754394179435922574f,
(float16_t)0.15279718525844340760f,(float16_t)0.98825756773074946437f,
(float16_t)0.14824767898689619749f,(float16_t)0.98895026451030298986f,
(float16_t)0.14369503315029458212f,(float16_t)0.98962201746320077600f,
(float16_t)0.13913934416382628401f,(float16_t)0.99027281236316910817f,
(float16_t)0.13458070850712622324f,(float16_t)0.99090263542778000971f,
(float16_t)0.13001922272223334631f,(float16_t)0.99151147331874389668f,
(float16_t)0.12545498341154620592f,(float16_t)0.99209931314219179654f,
(float16_t)0.12088808723577722237f,(float16_t)0.99266614244894801899f,
(float16_t)0.11631863091190487725f,(float16_t)0.99321194923479450001f,
(float16_t)0.11174671121112665639f,(float16_t)0.99373672194072459884f,
(float16_t)0.10717242495680887049f,(float16_t)0.99424044945318790223f,
(float16_t)0.10259586902243628126f,(float16_t)0.99472312110432570265f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.09343633584574791151f,(float16_t)0.99562525638099430569f,
(float16_t)0.08885355258252468358f,(float16_t)0.99604470090125196702f,
(float16_t)0.08426888759332412659f,(float16_t)0.99644305135004263008f,
(float16_t)0.07968243797143012563f,(float16_t)0.99682029929116566791f,
(float16_t)0.07509430084792129145f,(float16_t)0.99717643673532618820f,
(float16_t)0.07050457338961400866f,(float16_t)0.99751145614030345410f,
(float16_t)0.06591335279700392957f,(float16_t)0.99782535041111164453f,
(float16_t)0.06132073630220864768f,(float16_t)0.99811811290014917919f,
(float16_t)0.05672682116690778292f,(float16_t)0.99838973740734016094f,
(float16_t)0.05213170468028331672f,(float16_t)0.99864021818026527111f,
(float16_t)0.04753548415695926094f,(float16_t)0.99886954991428356099f,
(float16_t)0.04293825693494095902f,(float16_t)0.99907772775264536147f,
(float16_t)0.03834012037355279123f,(float16_t)0.99926474728659442359f,
(float16_t)0.03374117185137764235f,(float16_t)0.99943060455546173237f,
(float16_t)0.02914150876419373953f,(float16_t)0.99957529604674921764f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)0.01994042855151459750f,(float16_t)0.99980116988788425569f,
(float16_t)0.01533920628498821985f,(float16_t)0.99988234745421256111f,
(float16_t)0.01073765916726457208f,(float16_t)0.99994234967602391162f,
(float16_t)0.00613588464915451517f,(float16_t)0.99998117528260110909f,
(float16_t)0.00153398018628476615f,(float16_t)0.99999882345170187925f,
(float16_t)-0.00306795676296601561f,(float16_t)0.99999529380957619118f,
(float16_t)-0.00766982873953095477f,(float16_t)0.99997058643097413988f,
(float16_t)-0.01227153828571982304f,(float16_t)0.99992470183914450299f,
(float16_t)-0.01687298794728165144f,(float16_t)0.99985764100582386060f,
(float16_t)-0.02147408027546948359f,(float16_t)0.99976940535121527898f,
(float16_t)-0.02607471782910391472f,(float16_t)0.99965999674395922270f,
(float16_t)-0.03067480317663645942f,(float16_t)0.99952941750109314256f,
(float16_t)-0.03527423889821382219f,(float16_t)0.99937767038800284780f,
(float16_t)-0.03987292758773972740f,(float16_t)0.99920475861836388631f,
(float16_t)-0.04447077185493861912f,(float16_t)0.99901068585407337697f,
(float16_t)-0.04906767432741800800f,(float16_t)0.99879545620517240501f,
(float16_t)-0.05366353765273055437f,(float16_t)0.99855907422975931365f,
(float16_t)-0.05825826450043560673f,(float16_t)0.99830154493389289261f,
(float16_t)-0.06285175756416130910f,(float16_t)0.99802287377148624081f,
(float16_t)-0.06744391956366398155f,(float16_t)0.99772306664419163624f,
(float16_t)-0.07203465324688929083f,(float16_t)0.99740212990127530279f,
(float16_t)-0.07662386139203150592f,(float16_t)0.99706007033948296225f,
(float16_t)-0.08121144680959226092f,(float16_t)0.99669689520289606044f,
(float16_t)-0.08579731234443975507f,(float16_t)0.99631261218277800129f,
(float16_t)-0.09038136087786488582f,(float16_t)0.99590722941741172125f,
(float16_t)-0.09496349532963895002f,(float16_t)0.99548075549192693856f,
(float16_t)-0.09954361866006931903f,(float16_t)0.99503319943811863180f,
(float16_t)-0.10412163387205460030f,(float16_t)0.99456457073425541537f,
(float16_t)-0.10869744401313856386f,(float16_t)0.99407487930487947736f,
(float16_t)-0.11327095217756423529f,(float16_t)0.99356413552059530403f,
(float16_t)-0.11784206150832489401f,(float16_t)0.99303235019785141002f,
(float16_t)-0.12241067519921615403f,(float16_t)0.99247953459870996706f,
(float16_t)-0.12697669649688586579f,(float16_t)0.99190570043060932726f,
(float16_t)-0.13154002870288314386f,(float16_t)0.99131085984611544415f,
(float16_t)-0.13610057517570606223f,(float16_t)0.99069502544266463406f,
(float16_t)-0.14065823933284912761f,(float16_t)0.99005821026229712256f,
(float16_t)-0.14521292465284740825f,(float16_t)0.98940042779138037687f,
(float16_t)-0.14976453467732150915f,(float16_t)0.98872169196032377858f,
(float16_t)-0.15431297301302013270f,(float16_t)0.98802201714328352633f,
(float16_t)-0.15885814333386127917f,(float16_t)0.98730141815785843473f,
(float16_t)-0.16339994938297311422f,(float16_t)0.98655991026477551920f,
(float16_t)-0.16793829497473108936f,(float16_t)0.98579750916756747614f,
(float16_t)-0.17247308399679592283f,(float16_t)0.98501423101223983814f,
(float16_t)-0.17700422041214874946f,(float16_t)0.98421009238692902521f,
(float16_t)-0.18153160826112502146f,(float16_t)0.98338511032155118130f,
(float16_t)-0.18605515166344649414f,(float16_t)0.98253930228744124076f,
(float16_t)-0.19057475482025265645f,(float16_t)0.98167268619698311305f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.19960175762113094300f,(float16_t)0.97987710369951763756f,
(float16_t)-0.20410896609281689584f,(float16_t)0.97894817531906219710f,
(float16_t)-0.20861185197826331850f,(float16_t)0.97799851493455713936f,
(float16_t)-0.21311031991609125091f,(float16_t)0.97702814265775439484f,
(float16_t)-0.21760427463848355800f,(float16_t)0.97603707903903913490f,
(float16_t)-0.22209362097320348162f,(float16_t)0.97502534506699412020f,
(float16_t)-0.22657826384560997290f,(float16_t)0.97399296216795583359f,
(float16_t)-0.23105810828067113727f,(float16_t)0.97293995220556017678f,
(float16_t)-0.23553305940497534787f,(float16_t)0.97186633748027939639f,
(float16_t)-0.24000302244874138768f,(float16_t)0.97077214072895035013f,
(float16_t)-0.24446790274782409513f,(float16_t)0.96965738512429244800f,
(float16_t)-0.24892760574572012078f,(float16_t)0.96852209427441737777f,
(float16_t)-0.25338203699557015902f,(float16_t)0.96736629222232850545f,
(float16_t)-0.25783110216215882060f,(float16_t)0.96619000344541261516f,
(float16_t)-0.26227470702391347812f,(float16_t)0.96499325285492043580f,
(float16_t)-0.26671275747489830987f,(float16_t)0.96377606579543984022f,
(float16_t)-0.27114515952680795507f,(float16_t)0.96253846804435916340f,
(float16_t)-0.27557181931095814376f,(float16_t)0.96128048581132063966f,
(float16_t)-0.27999264308027327353f,(float16_t)0.96000214573766584625f,
(float16_t)-0.28440753721127171039f,(float16_t)0.95870347489587159906f,
(float16_t)-0.28881640820604936870f,(float16_t)0.95738450078897596729f,
(float16_t)-0.29321916269425857271f,(float16_t)0.95604525134999651659f,
(float16_t)-0.29761570743508619641f,(float16_t)0.95468575494133833814f,
(float16_t)-0.30200594931922808417f,(float16_t)0.95330604035419386211f,
(float16_t)-0.30638979537086097338f,(float16_t)0.95190613680793234597f,
(float16_t)-0.31076715274961136393f,(float16_t)0.95048607394948181337f,
(float16_t)-0.31513792875252233383f,(float16_t)0.94904588185270055689f,
(float16_t)-0.31950203081601563637f,(float16_t)0.94758559101774120226f,
(float16_t)-0.32385936651785285356f,(float16_t)0.94610523237040344835f,
(float16_t)-0.32820984357909255280f,(float16_t)0.94460483726148025685f,
(float16_t)-0.33255336986604405736f,(float16_t)0.94308443746609349478f,
(float16_t)-0.33688985339221994009f,(float16_t)0.94154406518302080631f,
(float16_t)-0.34121920232028229991f,(float16_t)0.93998375303401404679f,
(float16_t)-0.34554132496398903829f,(float16_t)0.93840353406310816897f,
(float16_t)-0.34985612979013491763f,(float16_t)0.93680344173592156043f,
(float16_t)-0.35416352542049039931f,(float16_t)0.93518350993894761025f,
(float16_t)-0.35846342063373642928f,(float16_t)0.93354377297883628373f,
(float16_t)-0.36275572436739711435f,(float16_t)0.93188426558166814750f,
(float16_t)-0.36704034571976712487f,(float16_t)0.93020502289221906889f,
(float16_t)-0.37131719395183748755f,(float16_t)0.92850608047321558924f,
(float16_t)-0.37558617848921721505f,(float16_t)0.92678747430458174872f,
(float16_t)-0.37984720892405099413f,(float16_t)0.92504924078267769527f,
(float16_t)-0.38410019501693493105f,(float16_t)0.92329141671952774661f,
(float16_t)-0.38834504669882619066f,(float16_t)0.92151403934204201285f,
(float16_t)-0.39258167407295141427f,(float16_t)0.91971714629122736095f,
(float16_t)-0.39680998741671030805f,(float16_t)0.91790077562139049672f,
(float16_t)-0.40102989718357567872f,(float16_t)0.91606496579933172075f,
(float16_t)-0.40524131400498974998f,(float16_t)0.91420975570353069095f,
(float16_t)-0.40944414869225753684f,(float16_t)0.91233518462332285903f,
(float16_t)-0.41363831223843450235f,(float16_t)0.91044129225806724737f,
(float16_t)-0.41782371582021227141f,(float16_t)0.90852811871630612117f,
(float16_t)-0.42200027079979968159f,(float16_t)0.90659570451491533483f,
(float16_t)-0.42616788872679967071f,(float16_t)0.90464409057824612947f,
(float16_t)-0.43032648134008272267f,(float16_t)0.90267331823725871498f,
(float16_t)-0.43447596056965581690f,(float16_t)0.90068342922864685907f,
(float16_t)-0.43861623853852738097f,(float16_t)0.89867446569395392775f,
(float16_t)-0.44274722756456980077f,(float16_t)0.89664647017868026602f,
(float16_t)-0.44686884016237399253f,(float16_t)0.89459948563138280697f,
(float16_t)-0.45098098904510369733f,(float16_t)0.89253355540276468894f,
(float16_t)-0.45508358712634372489f,(float16_t)0.89044872324475798919f,
(float16_t)-0.45917654752194403400f,(float16_t)0.88834503330959635470f,
(float16_t)-0.46325978355186014923f,(float16_t)0.88622253014888063838f,
(float16_t)-0.46733320874198841510f,(float16_t)0.88408125871263498752f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.47545028174715592284f,(float16_t)0.87974259280004740713f,
(float16_t)-0.47949375766015311928f,(float16_t)0.87754529020726124156f,
(float16_t)-0.48352707893291846375f,(float16_t)0.87532940310411100349f,
(float16_t)-0.48755016014843571837f,(float16_t)0.87309497841829020182f,
(float16_t)-0.49156291610654972990f,(float16_t)0.87084206347007897531f,
(float16_t)-0.49556526182577237405f,(float16_t)0.86857070597134100609f,
(float16_t)-0.49955711254508178287f,(float16_t)0.86628095402451310569f,
(float16_t)-0.50353838372571746440f,(float16_t)0.86397285612158680745f,
(float16_t)-0.50750899105297075931f,(float16_t)0.86164646114308141023f,
(float16_t)-0.51146885043797041259f,(float16_t)0.85930181835700847337f,
(float16_t)-0.51541787801946303826f,(float16_t)0.85693897741782865118f,
(float16_t)-0.51935599016558964269f,(float16_t)0.85455798836540053376f,
(float16_t)-0.52328310347565654137f,(float16_t)0.85215890162391971785f,
(float16_t)-0.52719913478190105760f,(float16_t)0.84974176800085265970f,
(float16_t)-0.53110400115125477871f,(float16_t)0.84730663868585853749f,
(float16_t)-0.53499761988709704230f,(float16_t)0.84485356524970722791f,
(float16_t)-0.53887990853100831146f,(float16_t)0.84238259964318595863f,
(float16_t)-0.54275078486451577842f,(float16_t)0.83989379419599952126f,
(float16_t)-0.54661016691083474939f,(float16_t)0.83738720161566193578f,
(float16_t)-0.55045797293660470029f,(float16_t)0.83486287498638012128f,
(float16_t)-0.55429412145362011444f,(float16_t)0.83232086776792968408f,
(float16_t)-0.55811853122055610221f,(float16_t)0.82976123379452304540f,
(float16_t)-0.56193112124468946877f,(float16_t)0.82718402727366902027f,
(float16_t)-0.56573181078361323149f,(float16_t)0.82458930278502517996f,
(float16_t)-0.56952051934694725155f,(float16_t)0.82197711527924144370f,
(float16_t)-0.57329716669804198226f,(float16_t)0.81934752007679712005f,
(float16_t)-0.57706167285567933067f,(float16_t)0.81670057286682795628f,
(float16_t)-0.58081395809576441547f,(float16_t)0.81403632970594852480f,
(float16_t)-0.58455394295301521534f,(float16_t)0.81135484701706384048f,
(float16_t)-0.58828154822264522306f,(float16_t)0.80865618158817509364f,
(float16_t)-0.59199669496204088137f,(float16_t)0.80594039057117639047f,
(float16_t)-0.59569930449243335691f,(float16_t)0.80320753148064494287f,
(float16_t)-0.59938929840056454079f,(float16_t)0.80045766219262282082f,
(float16_t)-0.60306659854034827539f,(float16_t)0.79769084094339104407f,
(float16_t)-0.60673112703452458661f,(float16_t)0.79490712632823690154f,
(float16_t)-0.61038280627630958630f,(float16_t)0.79210657730021227785f,
(float16_t)-0.61402155893103815831f,(float16_t)0.78928925316888587371f,
(float16_t)-0.61764730793780375784f,(float16_t)0.78645521359908587833f,
(float16_t)-0.62125997651108744169f,(float16_t)0.78360451860963831194f,
(float16_t)-0.62485948814238623239f,(float16_t)0.78073722857209459924f,
(float16_t)-0.62844576660183260053f,(float16_t)0.77785340420945314754f,
(float16_t)-0.63201873593980895105f,(float16_t)0.77495310659487393057f,
(float16_t)-0.63557832048855611440f,(float16_t)0.77203639715038452351f,
(float16_t)-0.63912444486377573138f,(float16_t)0.76910333764557958780f,
(float16_t)-0.64265703396622686494f,(float16_t)0.76615399019631280630f,
(float16_t)-0.64617601298331639459f,(float16_t)0.76318841726338115805f,
(float16_t)-0.64968130739068330470f,(float16_t)0.76020668165120230952f,
(float16_t)-0.65317284295377653347f,(float16_t)0.75720884650648467851f,
(float16_t)-0.65665054572942882505f,(float16_t)0.75419497531688928227f,
(float16_t)-0.66011434206742036768f,(float16_t)0.75116513190968658975f,
(float16_t)-0.66356415861203965623f,(float16_t)0.74811938045040371481f,
(float16_t)-0.66699992230363736034f,(float16_t)0.74505778544146605835f,
(float16_t)-0.67042156038017308717f,(float16_t)0.74198041172083106787f,
(float16_t)-0.67382900037875603783f,(float16_t)0.73888732446061522463f,
(float16_t)-0.67722217013718044587f,(float16_t)0.73577858916571359238f,
(float16_t)-0.68060099779545302212f,(float16_t)0.73265427167241281570f,
(float16_t)-0.68396541179731551452f,(float16_t)0.72951443814699701296f,
(float16_t)-0.68731534089175916336f,(float16_t)0.72635915508434589771f,
(float16_t)-0.69065071413453438254f,(float16_t)0.72318848930652757101f,
(float16_t)-0.69397146088965377952f,(float16_t)0.72000250796138176579f,
(float16_t)-0.69727751083088640449f,(float16_t)0.71680127852109964959f,
(float16_t)-0.70056879394324822474f,(float16_t)0.71358486878079363525f,
(float16_t)-0.70384524052448482756f,(float16_t)0.71035334685706241764f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.71035334685706230662f,(float16_t)0.70384524052448504960f,
(float16_t)-0.71358486878079352422f,(float16_t)0.70056879394324833576f,
(float16_t)-0.71680127852109953857f,(float16_t)0.69727751083088651551f,
(float16_t)-0.72000250796138165477f,(float16_t)0.69397146088965389055f,
(float16_t)-0.72318848930652745999f,(float16_t)0.69065071413453460458f,
(float16_t)-0.72635915508434578669f,(float16_t)0.68731534089175927438f,
(float16_t)-0.72951443814699679091f,(float16_t)0.68396541179731562554f,
(float16_t)-0.73265427167241270467f,(float16_t)0.68060099779545324417f,
(float16_t)-0.73577858916571337033f,(float16_t)0.67722217013718055689f,
(float16_t)-0.73888732446061511361f,(float16_t)0.67382900037875614885f,
(float16_t)-0.74198041172083095685f,(float16_t)0.67042156038017319819f,
(float16_t)-0.74505778544146594733f,(float16_t)0.66699992230363758239f,
(float16_t)-0.74811938045040360379f,(float16_t)0.66356415861203976725f,
(float16_t)-0.75116513190968636771f,(float16_t)0.66011434206742047870f,
(float16_t)-0.75419497531688917125f,(float16_t)0.65665054572942904709f,
(float16_t)-0.75720884650648467851f,(float16_t)0.65317284295377664449f,
(float16_t)-0.76020668165120219850f,(float16_t)0.64968130739068341573f,
(float16_t)-0.76318841726338115805f,(float16_t)0.64617601298331661663f,
(float16_t)-0.76615399019631280630f,(float16_t)0.64265703396622708699f,
(float16_t)-0.76910333764557947678f,(float16_t)0.63912444486377584241f,
(float16_t)-0.77203639715038441249f,(float16_t)0.63557832048855622542f,
(float16_t)-0.77495310659487381955f,(float16_t)0.63201873593980906207f,
(float16_t)-0.77785340420945303652f,(float16_t)0.62844576660183271155f,
(float16_t)-0.78073722857209448822f,(float16_t)0.62485948814238634341f,
(float16_t)-0.78360451860963820092f,(float16_t)0.62125997651108755271f,
(float16_t)-0.78645521359908576731f,(float16_t)0.61764730793780386886f,
(float16_t)-0.78928925316888576269f,(float16_t)0.61402155893103838036f,
(float16_t)-0.79210657730021216683f,(float16_t)0.61038280627630969732f,
(float16_t)-0.79490712632823679051f,(float16_t)0.60673112703452469763f,
(float16_t)-0.79769084094339093305f,(float16_t)0.60306659854034838641f,
(float16_t)-0.80045766219262259877f,(float16_t)0.59938929840056465181f,
(float16_t)-0.80320753148064483184f,(float16_t)0.59569930449243346793f,
(float16_t)-0.80594039057117627944f,(float16_t)0.59199669496204099239f,
(float16_t)-0.80865618158817498262f,(float16_t)0.58828154822264533408f,
(float16_t)-0.81135484701706372945f,(float16_t)0.58455394295301532637f,
(float16_t)-0.81403632970594841378f,(float16_t)0.58081395809576452649f,
(float16_t)-0.81670057286682784525f,(float16_t)0.57706167285567944170f,
(float16_t)-0.81934752007679700903f,(float16_t)0.57329716669804209328f,
(float16_t)-0.82197711527924133268f,(float16_t)0.56952051934694747359f,
(float16_t)-0.82458930278502506894f,(float16_t)0.56573181078361345353f,
(float16_t)-0.82718402727366902027f,(float16_t)0.56193112124468957980f,
(float16_t)-0.82976123379452293438f,(float16_t)0.55811853122055632426f,
(float16_t)-0.83232086776792957306f,(float16_t)0.55429412145362022546f,
(float16_t)-0.83486287498638001026f,(float16_t)0.55045797293660492233f,
(float16_t)-0.83738720161566182476f,(float16_t)0.54661016691083497143f,
(float16_t)-0.83989379419599952126f,(float16_t)0.54275078486451588944f,
(float16_t)-0.84238259964318584760f,(float16_t)0.53887990853100842248f,
(float16_t)-0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)-0.84730663868585842646f,(float16_t)0.53110400115125488973f,
(float16_t)-0.84974176800085254868f,(float16_t)0.52719913478190127964f,
(float16_t)-0.85215890162391960683f,(float16_t)0.52328310347565665239f,
(float16_t)-0.85455798836540042274f,(float16_t)0.51935599016558975372f,
(float16_t)-0.85693897741782865118f,(float16_t)0.51541787801946314929f,
(float16_t)-0.85930181835700836235f,(float16_t)0.51146885043797052361f,
(float16_t)-0.86164646114308129921f,(float16_t)0.50750899105297098135f,
(float16_t)-0.86397285612158669643f,(float16_t)0.50353838372571757542f,
(float16_t)-0.86628095402451299467f,(float16_t)0.49955711254508189390f,
(float16_t)-0.86857070597134089507f,(float16_t)0.49556526182577254058f,
(float16_t)-0.87084206347007886428f,(float16_t)0.49156291610654989643f,
(float16_t)-0.87309497841829009079f,(float16_t)0.48755016014843588490f,
(float16_t)-0.87532940310411089246f,(float16_t)0.48352707893291863028f,
(float16_t)-0.87754529020726113053f,(float16_t)0.47949375766015328582f,
(float16_t)-0.87974259280004729611f,(float16_t)0.47545028174715608937f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.88408125871263487650f,(float16_t)0.46733320874198858164f,
(float16_t)-0.88622253014888052736f,(float16_t)0.46325978355186031576f,
(float16_t)-0.88834503330959624368f,(float16_t)0.45917654752194420054f,
(float16_t)-0.89044872324475787817f,(float16_t)0.45508358712634389143f,
(float16_t)-0.89253355540276457791f,(float16_t)0.45098098904510386387f,
(float16_t)-0.89459948563138269595f,(float16_t)0.44686884016237415906f,
(float16_t)-0.89664647017868026602f,(float16_t)0.44274722756456996731f,
(float16_t)-0.89867446569395392775f,(float16_t)0.43861623853852754751f,
(float16_t)-0.90068342922864674804f,(float16_t)0.43447596056965598343f,
(float16_t)-0.90267331823725871498f,(float16_t)0.43032648134008288920f,
(float16_t)-0.90464409057824612947f,(float16_t)0.42616788872679983724f,
(float16_t)-0.90659570451491533483f,(float16_t)0.42200027079979984812f,
(float16_t)-0.90852811871630612117f,(float16_t)0.41782371582021243794f,
(float16_t)-0.91044129225806713634f,(float16_t)0.41363831223843466889f,
(float16_t)-0.91233518462332274801f,(float16_t)0.40944414869225770337f,
(float16_t)-0.91420975570353069095f,(float16_t)0.40524131400498991651f,
(float16_t)-0.91606496579933172075f,(float16_t)0.40102989718357562321f,
(float16_t)-0.91790077562139049672f,(float16_t)0.39680998741671025254f,
(float16_t)-0.91971714629122736095f,(float16_t)0.39258167407295141427f,
(float16_t)-0.92151403934204179080f,(float16_t)0.38834504669882657923f,
(float16_t)-0.92329141671952752457f,(float16_t)0.38410019501693531963f,
(float16_t)-0.92504924078267747323f,(float16_t)0.37984720892405138271f,
(float16_t)-0.92678747430458174872f,(float16_t)0.37558617848921738158f,
(float16_t)-0.92850608047321547822f,(float16_t)0.37131719395183770960f,
(float16_t)-0.93020502289221906889f,(float16_t)0.36704034571976729140f,
(float16_t)-0.93188426558166803648f,(float16_t)0.36275572436739728088f,
(float16_t)-0.93354377297883617270f,(float16_t)0.35846342063373659581f,
(float16_t)-0.93518350993894761025f,(float16_t)0.35416352542049039931f,
(float16_t)-0.93680344173592167145f,(float16_t)0.34985612979013486212f,
(float16_t)-0.93840353406310816897f,(float16_t)0.34554132496398898278f,
(float16_t)-0.93998375303401382475f,(float16_t)0.34121920232028268849f,
(float16_t)-0.94154406518302069529f,(float16_t)0.33688985339222032867f,
(float16_t)-0.94308443746609338376f,(float16_t)0.33255336986604444593f,
(float16_t)-0.94460483726148014583f,(float16_t)0.32820984357909271933f,
(float16_t)-0.94610523237040333733f,(float16_t)0.32385936651785302010f,
(float16_t)-0.94758559101774109124f,(float16_t)0.31950203081601580291f,
(float16_t)-0.94904588185270055689f,(float16_t)0.31513792875252250036f,
(float16_t)-0.95048607394948170235f,(float16_t)0.31076715274961153046f,
(float16_t)-0.95190613680793234597f,(float16_t)0.30638979537086091787f,
(float16_t)-0.95330604035419386211f,(float16_t)0.30200594931922802866f,
(float16_t)-0.95468575494133833814f,(float16_t)0.29761570743508614090f,
(float16_t)-0.95604525134999629454f,(float16_t)0.29321916269425896129f,
(float16_t)-0.95738450078897585627f,(float16_t)0.28881640820604975728f,
(float16_t)-0.95870347489587148804f,(float16_t)0.28440753721127209896f,
(float16_t)-0.96000214573766584625f,(float16_t)0.27999264308027344006f,
(float16_t)-0.96128048581132063966f,(float16_t)0.27557181931095831029f,
(float16_t)-0.96253846804435916340f,(float16_t)0.27114515952680812161f,
(float16_t)-0.96377606579543984022f,(float16_t)0.26671275747489847641f,
(float16_t)-0.96499325285492032478f,(float16_t)0.26227470702391370017f,
(float16_t)-0.96619000344541250413f,(float16_t)0.25783110216215898713f,
(float16_t)-0.96736629222232850545f,(float16_t)0.25338203699557010351f,
(float16_t)-0.96852209427441737777f,(float16_t)0.24892760574572009302f,
(float16_t)-0.96965738512429233698f,(float16_t)0.24446790274782448371f,
(float16_t)-0.97077214072895023911f,(float16_t)0.24000302244874177626f,
(float16_t)-0.97186633748027928537f,(float16_t)0.23553305940497573645f,
(float16_t)-0.97293995220556006576f,(float16_t)0.23105810828067133156f,
(float16_t)-0.97399296216795583359f,(float16_t)0.22657826384561016719f,
(float16_t)-0.97502534506699412020f,(float16_t)0.22209362097320364815f,
(float16_t)-0.97603707903903902388f,(float16_t)0.21760427463848372454f,
(float16_t)-0.97702814265775439484f,(float16_t)0.21311031991609141745f,
(float16_t)-0.97799851493455713936f,(float16_t)0.20861185197826351279f,
(float16_t)-0.97894817531906219710f,(float16_t)0.20410896609281684033f,
(float16_t)-0.97987710369951763756f,(float16_t)0.19960175762113091524f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.98167268619698311305f,(float16_t)0.19057475482025307278f,
(float16_t)-0.98253930228744124076f,(float16_t)0.18605515166344691047f,
(float16_t)-0.98338511032155118130f,(float16_t)0.18153160826112521575f,
(float16_t)-0.98421009238692902521f,(float16_t)0.17700422041214894375f,
(float16_t)-0.98501423101223983814f,(float16_t)0.17247308399679611712f,
(float16_t)-0.98579750916756736512f,(float16_t)0.16793829497473128365f,
(float16_t)-0.98655991026477540817f,(float16_t)0.16339994938297328075f,
(float16_t)-0.98730141815785843473f,(float16_t)0.15885814333386147346f,
(float16_t)-0.98802201714328352633f,(float16_t)0.15431297301302007718f,
(float16_t)-0.98872169196032377858f,(float16_t)0.14976453467732145364f,
(float16_t)-0.98940042779138037687f,(float16_t)0.14521292465284735274f,
(float16_t)-0.99005821026229701154f,(float16_t)0.14065823933284954395f,
(float16_t)-0.99069502544266463406f,(float16_t)0.13610057517570647856f,
(float16_t)-0.99131085984611544415f,(float16_t)0.13154002870288333815f,
(float16_t)-0.99190570043060932726f,(float16_t)0.12697669649688606008f,
(float16_t)-0.99247953459870996706f,(float16_t)0.12241067519921634832f,
(float16_t)-0.99303235019785141002f,(float16_t)0.11784206150832508830f,
(float16_t)-0.99356413552059530403f,(float16_t)0.11327095217756441570f,
(float16_t)-0.99407487930487936634f,(float16_t)0.10869744401313874427f,
(float16_t)-0.99456457073425541537f,(float16_t)0.10412163387205457254f,
(float16_t)-0.99503319943811863180f,(float16_t)0.09954361866006927739f,
(float16_t)-0.99548075549192693856f,(float16_t)0.09496349532963890838f,
(float16_t)-0.99590722941741172125f,(float16_t)0.09038136087786528827f,
(float16_t)-0.99631261218277800129f,(float16_t)0.08579731234444015753f,
(float16_t)-0.99669689520289606044f,(float16_t)0.08121144680959266338f,
(float16_t)-0.99706007033948296225f,(float16_t)0.07662386139203168633f,
(float16_t)-0.99740212990127530279f,(float16_t)0.07203465324688947125f,
(float16_t)-0.99772306664419163624f,(float16_t)0.06744391956366417584f,
(float16_t)-0.99802287377148624081f,(float16_t)0.06285175756416148951f,
(float16_t)-0.99830154493389289261f,(float16_t)0.05825826450043579408f,
(float16_t)-0.99855907422975931365f,(float16_t)0.05366353765273051968f,
(float16_t)-0.99879545620517240501f,(float16_t)0.04906767432741796636f,
(float16_t)-0.99901068585407337697f,(float16_t)0.04447077185493858442f,
(float16_t)-0.99920475861836388631f,(float16_t)0.03987292758774012985f,
(float16_t)-0.99937767038800284780f,(float16_t)0.03527423889821423159f,
(float16_t)-0.99952941750109314256f,(float16_t)0.03067480317663686534f,
(float16_t)-0.99965999674395922270f,(float16_t)0.02607471782910409860f,
(float16_t)-0.99976940535121527898f,(float16_t)0.02147408027546966747f,
(float16_t)-0.99985764100582386060f,(float16_t)0.01687298794728183532f,
(float16_t)-0.99992470183914450299f,(float16_t)0.01227153828572000692f,
(float16_t)-0.99997058643097413988f,(float16_t)0.00766982873953113778f,
(float16_t)-0.99999529380957619118f,(float16_t)0.00306795676296597701f,
(float16_t)-0.99999882345170187925f,(float16_t)-0.00153398018628480431f,
(float16_t)-0.99998117528260110909f,(float16_t)-0.00613588464915455420f,
(float16_t)-0.99994234967602391162f,(float16_t)-0.01073765916726416615f,
(float16_t)-0.99988234745421256111f,(float16_t)-0.01533920628498781566f,
(float16_t)-0.99980116988788425569f,(float16_t)-0.01994042855151419158f,
(float16_t)-0.99969881869620424997f,(float16_t)-0.02454122852291207996f,
(float16_t)-0.99957529604674921764f,(float16_t)-0.02914150876419355565f,
(float16_t)-0.99943060455546173237f,(float16_t)-0.03374117185137745500f,
(float16_t)-0.99926474728659442359f,(float16_t)-0.03834012037355261082f,
(float16_t)-0.99907772775264536147f,(float16_t)-0.04293825693494077861f,
(float16_t)-0.99886954991428356099f,(float16_t)-0.04753548415695929563f,
(float16_t)-0.99864021818026527111f,(float16_t)-0.05213170468028335142f,
(float16_t)-0.99838973740734016094f,(float16_t)-0.05672682116690781762f,
(float16_t)-0.99811811290014917919f,(float16_t)-0.06132073630220824523f,
(float16_t)-0.99782535041111164453f,(float16_t)-0.06591335279700352712f,
(float16_t)-0.99751145614030345410f,(float16_t)-0.07050457338961360620f,
(float16_t)-0.99717643673532618820f,(float16_t)-0.07509430084792109716f,
(float16_t)-0.99682029929116577893f,(float16_t)-0.07968243797142994522f,
(float16_t)-0.99644305135004263008f,(float16_t)-0.08426888759332393231f,
(float16_t)-0.99604470090125196702f,(float16_t)-0.08885355258252450317f,
(float16_t)-0.99562525638099430569f,(float16_t)-0.09343633584574773110f,
(float16_t)-0.99518472667219692873f,(float16_t)-0.09801714032956058975f,
(float16_t)-0.99472312110432570265f,(float16_t)-0.10259586902243630901f,
(float16_t)-0.99424044945318790223f,(float16_t)-0.10717242495680891212f,
(float16_t)-0.99373672194072470987f,(float16_t)-0.11174671121112625394f,
(float16_t)-0.99321194923479461103f,(float16_t)-0.11631863091190447479f,
(float16_t)-0.99266614244894801899f,(float16_t)-0.12088808723577681992f,
(float16_t)-0.99209931314219179654f,(float16_t)-0.12545498341154601163f,
(float16_t)-0.99151147331874400770f,(float16_t)-0.13001922272223317978f,
(float16_t)-0.99090263542778000971f,(float16_t)-0.13458070850712605671f,
(float16_t)-0.99027281236316910817f,(float16_t)-0.13913934416382611747f,
(float16_t)-0.98962201746320088702f,(float16_t)-0.14369503315029438784f,
(float16_t)-0.98895026451030298986f,(float16_t)-0.14824767898689603096f,
(float16_t)-0.98825756773074946437f,(float16_t)-0.15279718525844343535f,
(float16_t)-0.98754394179435922574f,(float16_t)-0.15734345561623830356f,
(float16_t)-0.98680940181418552726f,(float16_t)-0.16188639378011149272f,
(float16_t)-0.98605396334619543897f,(float16_t)-0.16642590354046382650f,
(float16_t)-0.98527764238894133264f,(float16_t)-0.17096188876030096737f,
(float16_t)-0.98448045538322093151f,(float16_t)-0.17549425337727120322f,
(float16_t)-0.98366241921173025453f,(float16_t)-0.18002290140569934818f,
(float16_t)-0.98282355119870534743f,(float16_t)-0.18454773693861947770f,
(float16_t)-0.98196386910955524296f,(float16_t)-0.18906866414980610935f,
(float16_t)-0.98108339115048670553f,(float16_t)-0.19358558729580355173f,
(float16_t)-0.98018213596811742949f,(float16_t)-0.19809841071795356027f,
(float16_t)-0.97926012264908202098f,(float16_t)-0.20260703884442113343f,
(float16_t)-0.97831737071962765473f,(float16_t)-0.20711137619221858808f,
(float16_t)-0.97735390014519996082f,(float16_t)-0.21161132736922766417f,
(float16_t)-0.97636973133002125103f,(float16_t)-0.21610679707621921475f,
(float16_t)-0.97536488511665697665f,(float16_t)-0.22059769010887325669f,
(float16_t)-0.97433938278557585821f,(float16_t)-0.22508391135979261000f,
(float16_t)-0.97329324605469824672f,(float16_t)-0.22956536582051870199f,
(float16_t)-0.97222649707893638027f,(float16_t)-0.23404195858354326365f,
(float16_t)-0.97113915844972520386f,(float16_t)-0.23851359484431830515f,
(float16_t)-0.97003125319454397424f,(float16_t)-0.24298017990326381543f,
(float16_t)-0.96890280477642887202f,(float16_t)-0.24744161916777326904f,
(float16_t)-0.96775383709347551076f,(float16_t)-0.25189781815421696809f,
(float16_t)-0.96658437447833311928f,(float16_t)-0.25634868248994291395f,
(float16_t)-0.96539444169768939830f,(float16_t)-0.26079411791527562503f,
(float16_t)-0.96418406395174582890f,(float16_t)-0.26523403028551151284f,
(float16_t)-0.96295326687368398844f,(float16_t)-0.26966832557291481320f,
(float16_t)-0.96170207652912265139f,(float16_t)-0.27409690986870616225f,
(float16_t)-0.96043051941556589757f,(float16_t)-0.27851968938505289319f,
(float16_t)-0.95913862246184200533f,(float16_t)-0.28293657045705516984f,
(float16_t)-0.95782641302753290802f,(float16_t)-0.28734745954472939999f,
(float16_t)-0.95649391890239510161f,(float16_t)-0.29175226323498920644f,
(float16_t)-0.95514116830577078243f,(float16_t)-0.29615088824362378883f,
(float16_t)-0.95376818988599032512f,(float16_t)-0.30054324141727345454f,
(float16_t)-0.95237501271976587880f,(float16_t)-0.30492922973540242948f,
(float16_t)-0.95096166631157508231f,(float16_t)-0.30930876031226878231f,
(float16_t)-0.94952818059303678577f,(float16_t)-0.31368174039889118454f,
(float16_t)-0.94807458592227633609f,(float16_t)-0.31804807738501467140f,
(float16_t)-0.94660091308328364601f,(float16_t)-0.32240767880106963039f,
(float16_t)-0.94510719328526060501f,(float16_t)-0.32676045232013156694f,
(float16_t)-0.94359345816196038559f,(float16_t)-0.33110630575987626267f,
(float16_t)-0.94205973977101742367f,(float16_t)-0.33544514708453149199f,
(float16_t)-0.94050607059326840620f,(float16_t)-0.33977688440682679571f,
(float16_t)-0.93893248353206459900f,(float16_t)-0.34410142598993881391f,
(float16_t)-0.93733901191257495977f,(float16_t)-0.34841868024943456472f,
(float16_t)-0.93572568948108036935f,(float16_t)-0.35272855575521072646f,
(float16_t)-0.93409255040425887007f,(float16_t)-0.35703096123343008861f,
(float16_t)-0.93243962926846246653f,(float16_t)-0.36132580556845395048f,
(float16_t)-0.93076696107898382326f,(float16_t)-0.36561299780477357624f,
(float16_t)-0.92907458125931585702f,(float16_t)-0.36989244714893387833f,
(float16_t)-0.92736252565040111495f,(float16_t)-0.37416406297145782256f,
(float16_t)-0.92563083050987282618f,(float16_t)-0.37842775480876539307f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,
(float16_t)-0.92210866874334518339f,(float16_t)-0.38693100551438852630f,
(float16_t)-0.92031827670911059425f,(float16_t)-0.39117038430225381518f,
(float16_t)-0.91850839432521225181f,(float16_t)-0.39540147894781629834f,
(float16_t)-0.91667905992104270485f,(float16_t)-0.39962419984564684361f,
(float16_t)-0.91483031223794608611f,(float16_t)-0.40383845756765418544f,
(float16_t)-0.91296219042839832358f,(float16_t)-0.40804416286497835475f,
(float16_t)-0.91107473405517647169f,(float16_t)-0.41224122666988260999f,
(float16_t)-0.90916798309052249127f,(float16_t)-0.41642956009763693048f,
(float16_t)-0.90724197791529592738f,(float16_t)-0.42060907444840234248f,
(float16_t)-0.90529675931811881551f,(float16_t)-0.42477968120910863936f,
(float16_t)-0.90333236849451192807f,(float16_t)-0.42894129205532938176f,
(float16_t)-0.90134884704602202810f,(float16_t)-0.43309381885315184624f,
(float16_t)-0.89934623697934157338f,(float16_t)-0.43723717366104403181f,
(float16_t)-0.89732458070541831763f,(float16_t)-0.44137126873171667052f,
(float16_t)-0.89528392103855747308f,(float16_t)-0.44549601651398174074f,
(float16_t)-0.89322430119551532446f,(float16_t)-0.44961132965460665067f,
(float16_t)-0.89114576479458340597f,(float16_t)-0.45371712100016353686f,
(float16_t)-0.88904835585466468473f,(float16_t)-0.45781330359887695280f,
(float16_t)-0.88693211879434230571f,(float16_t)-0.46189979070246250936f,
(float16_t)-0.88479709843093790056f,(float16_t)-0.46597649576796595916f,
(float16_t)-0.88264333997956290201f,(float16_t)-0.47004333245959545318f,
(float16_t)-0.88047088905216086552f,(float16_t)-0.47410021465054985601f,
(float16_t)-0.87827979165654157523f,(float16_t)-0.47814705642484295334f,
(float16_t)-0.87607009419540660122f,(float16_t)-0.48218377207912266336f,
(float16_t)-0.87384184346536686316f,(float16_t)-0.48621027612448636246f,
(float16_t)-0.87159508665595109012f,(float16_t)-0.49022648328829115938f,
(float16_t)-0.86932987134860673084f,(float16_t)-0.49423230851595978397f,
(float16_t)-0.86704624551569287050f,(float16_t)-0.49822766697278153547f,
(float16_t)-0.86474425751946248919f,(float16_t)-0.50221247404571056627f,
(float16_t)-0.86242395611104072373f,(float16_t)-0.50618664534515500630f,
(float16_t)-0.86008539042939025077f,(float16_t)-0.51015009670676658704f,
(float16_t)-0.85772861000027211809f,(float16_t)-0.51410274419322155026f,
(float16_t)-0.85535366473519613972f,(float16_t)-0.51804450409599922533f,
(float16_t)-0.85296060493036374162f,(float16_t)-0.52197529293715427823f,
(float16_t)-0.85054948126560347976f,(float16_t)-0.52589502747108463065f,
(float16_t)-0.84812034480329723252f,(float16_t)-0.52980362468629460526f,
(float16_t)-0.84567324698729906540f,(float16_t)-0.53370100180715296379f,
(float16_t)-0.84320823964184543620f,(float16_t)-0.53758707629564550512f,
(float16_t)-0.84072537497045818355f,(float16_t)-0.54146176585312322249f,
(float16_t)-0.83822470555483818977f,(float16_t)-0.54532498842204613076f,
(float16_t)-0.83570628435375271525f,(float16_t)-0.54917666218771943321f,
(float16_t)-0.83317016470191329613f,(float16_t)-0.55301670558002735678f,
(float16_t)-0.83061640030884642538f,(float16_t)-0.55684503727515988203f,
(float16_t)-0.82804504525775590729f,(float16_t)-0.56066157619733592021f,
(float16_t)-0.82545615400437755138f,(float16_t)-0.56446624152051938506f,
(float16_t)-0.82284978137582642788f,(float16_t)-0.56825895267013148970f,
(float16_t)-0.82022598256943468620f,(float16_t)-0.57203962932475704850f,
(float16_t)-0.81758481315158371139f,(float16_t)-0.57580819141784533866f,
(float16_t)-0.81492632905652662156f,(float16_t)-0.57956455913940574387f,
(float16_t)-0.81225058658520388200f,(float16_t)-0.58330865293769829094f,
(float16_t)-0.80955764240405148069f,(float16_t)-0.58704039352091774706f,
(float16_t)-0.80684755354379944503f,(float16_t)-0.59075970185887394237f,
(float16_t)-0.80412037739826591753f,(float16_t)-0.59446649918466420992f,
(float16_t)-0.80137617172314035141f,(float16_t)-0.59816070699634216190f,
(float16_t)-0.79861499463476093297f,(float16_t)-0.60184224705857991555f,
(float16_t)-0.79583690460888356633f,(float16_t)-0.60551104140432543410f,
(float16_t)-0.79304196047944375270f,(float16_t)-0.60916701233645309532f,
(float16_t)-0.79023022143731003197f,(float16_t)-0.61281008242940970820f,
(float16_t)-0.78740174702903142911f,(float16_t)-0.61644017453085364622f,
(float16_t)-0.78455659715557524159f,(float16_t)-0.62005721176328920663f,
(float16_t)-0.78169483207105938671f,(float16_t)-0.62366111752569464155f,
(float16_t)-0.77881651238147620031f,(float16_t)-0.62725181549514386070f,
(float16_t)-0.77592169904340779762f,(float16_t)-0.63082922962842424841f,
(float16_t)-0.77301045336273710440f,(float16_t)-0.63439328416364526575f,
(float16_t)-0.77008283699334811878f,(float16_t)-0.63794390362184394405f,
(float16_t)-0.76713891193582051109f,(float16_t)-0.64148101280858305095f,
(float16_t)-0.76417874053611678509f,(float16_t)-0.64500453681554381635f,
(float16_t)-0.76120238548426188974f,(float16_t)-0.64851440102211233008f,
(float16_t)-0.75820990981301539247f,(float16_t)-0.65201053109695950027f,
(float16_t)-0.75520137689653654700f,(float16_t)-0.65549285299961534967f,
(float16_t)-0.75217685044904269986f,(float16_t)-0.65896129298203731661f,
(float16_t)-0.74913639452345925918f,(float16_t)-0.66241577759017178373f,
(float16_t)-0.74608007351006400132f,(float16_t)-0.66585623366550938940f,
(float16_t)-0.74300795213512194071f,(float16_t)-0.66928258834663578725f,
(float16_t)-0.73992009545951631377f,(float16_t)-0.67269476907077274674f,
(float16_t)-0.73681656887737001504f,(float16_t)-0.67609270357531581208f,
(float16_t)-0.73369743811466037187f,(float16_t)-0.67947631989936485564f,
(float16_t)-0.73056276922782770189f,(float16_t)-0.68284554638524797010f,
(float16_t)-0.72741262860237587695f,(float16_t)-0.68620031168003847721f,
(float16_t)-0.72424708295146700276f,(float16_t)-0.68954054473706682948f,
(float16_t)-0.72106619931450810501f,(float16_t)-0.69286617481742462932f,
(float16_t)-0.71787004505573170920f,(float16_t)-0.69617713149146298601f,
(float16_t)-0.71465868786276898206f,(float16_t)-0.69947334464028387835f,
(float16_t)-0.71143219574521665560f,(float16_t)-0.70275474445722507788f,
(float16_t)-0.70819063703319551362f,(float16_t)-0.70602126144933952112f,
(float16_t)-0.70493408037590510329f,(float16_t)-0.70927282643886546687f,
(float16_t)-0.70166259474016867692f,(float16_t)-0.71250937056469221265f,
(float16_t)-0.69837624940897302661f,(float16_t)-0.71573082528381848366f,
(float16_t)-0.69507511398000099145f,(float16_t)-0.71893712237280438249f,
(float16_t)-0.69175925836415785852f,(float16_t)-0.72212819392921523409f,
(float16_t)-0.68842875278409054740f,(float16_t)-0.72530397237306065694f,
(float16_t)-0.68508366777270035541f,(float16_t)-0.72846439044822519637f,
(float16_t)-0.68172407417164981869f,(float16_t)-0.73160938122389251870f,
(float16_t)-0.67835004312986146857f,(float16_t)-0.73473887809596349907f,
(float16_t)-0.67496164610201225820f,(float16_t)-0.73785281478846576064f,
(float16_t)-0.67155895484701866316f,(float16_t)-0.74095112535495888384f,
(float16_t)-0.66814204142651867357f,(float16_t)-0.74403374417992906853f,
(float16_t)-0.66471097820334501538f,(float16_t)-0.74710060598017991040f,
(float16_t)-0.66126583783999237642f,(float16_t)-0.75015164580621496171f,
(float16_t)-0.65780669329707874837f,(float16_t)-0.75318679904361240940f,
(float16_t)-0.65433361783180066240f,(float16_t)-0.75620600141439442421f,
(float16_t)-0.65084668499638098638f,(float16_t)-0.75920918897838796102f,
(float16_t)-0.64734596863651250320f,(float16_t)-0.76219629813457856482f,
(float16_t)-0.64383154288979149715f,(float16_t)-0.76516726562245895860f,
(float16_t)-0.64030348218415200634f,(float16_t)-0.76812202852336519676f,
(float16_t)-0.63676186123628419899f,(float16_t)-0.77106052426181381776f,
(float16_t)-0.63320675505005752370f,(float16_t)-0.77398269060682256537f,
(float16_t)-0.62963823891492687324f,(float16_t)-0.77688846567323255332f,
(float16_t)-0.62605638840434374437f,(float16_t)-0.77977778792301433164f,
(float16_t)-0.62246127937414974518f,(float16_t)-0.78265059616657584041f,
(float16_t)-0.61885298796097643059f,(float16_t)-0.78550682956405382118f,
(float16_t)-0.61523159058062726334f,(float16_t)-0.78834642762660589455f,
(float16_t)-0.61159716392646201744f,(float16_t)-0.79116933021769009216f,
(float16_t)-0.60794978496777407617f,(float16_t)-0.79397547755433683925f,
(float16_t)-0.60428953094815607283f,(float16_t)-0.79676481020841871672f,
(float16_t)-0.60061647938386930612f,(float16_t)-0.79953726910790479110f,
(float16_t)-0.59693070806219639124f,(float16_t)-0.80229279553811572168f,
(float16_t)-0.59323229503980012822f,(float16_t)-0.80503133114296343553f,
(float16_t)-0.58952131864106382952f,(float16_t)-0.80775281792619046950f,
(float16_t)-0.58579785745643908612f,(float16_t)-0.81045719825259465718f,
(float16_t)-0.58206199034077532595f,(float16_t)-0.81314441484925370496f,
(float16_t)-0.57831379641165570060f,(float16_t)-0.81581441080673366972f,
(float16_t)-0.57455335504771631872f,(float16_t)-0.81846712958029832485f,
(float16_t)-0.57078074588696736669f,(float16_t)-0.82110251499110464835f,
(float16_t)-0.56699604882510901138f,(float16_t)-0.82372051122739109452f,
(float16_t)-0.56319934401383409117f,(float16_t)-0.82632106284566342325f,
(float16_t)-0.55939071185913646911f,(float16_t)-0.82890411477186465294f,
(float16_t)-0.55557023301960217765f,(float16_t)-0.83146961230254523567f,
(float16_t)-0.55173798840470766880f,(float16_t)-0.83401750110601791111f,
(float16_t)-0.54789405917310007865f,(float16_t)-0.83654772722351211645f,
(float16_t)-0.54403852673088415326f,(float16_t)-0.83906023707031252012f,
(float16_t)-0.54017147272989274320f,(float16_t)-0.84155497743689855472f,
(float16_t)-0.53629297906596329337f,(float16_t)-0.84403189549006629733f,
(float16_t)-0.53240312787719845655f,(float16_t)-0.84649093877405179320f,
(float16_t)-0.52850200154222859439f,(float16_t)-0.84893205521163961347f,
(float16_t)-0.52458968267846928235f,(float16_t)-0.85135519310526486247f,
(float16_t)-0.52066625414036715735f,(float16_t)-0.85376030113811141042f,
(float16_t)-0.51673179901765020627f,(float16_t)-0.85614732837519424979f,
(float16_t)-0.51278640063356295542f,(float16_t)-0.85851622426444285097f,
(float16_t)-0.50883014254310732216f,(float16_t)-0.86086693863776708735f,
(float16_t)-0.50486310853126736831f,(float16_t)-0.86319942171212427073f,
(float16_t)-0.50088538261124104789f,(float16_t)-0.86551362409056897818f,
(float16_t)-0.49689704902265435793f,(float16_t)-0.86780949676330332299f,
(float16_t)-0.49289819222978420443f,(float16_t)-0.87008699110871134952f,
(float16_t)-0.48888889691976367136f,(float16_t)-0.87234605889439120752f,
(float16_t)-0.48486924800079117537f,(float16_t)-0.87458665227817611321f,
(float16_t)-0.48083933060033440254f,(float16_t)-0.87680872380914542941f,
(float16_t)-0.47679923006332214364f,(float16_t)-0.87901222642863341417f,
(float16_t)-0.47274903195034317926f,(float16_t)-0.88119711347122187117f,
(float16_t)-0.46868882203582790114f,(float16_t)-0.88336333866573157891f,
(float16_t)-0.46461868630623814891f,(float16_t)-0.88551085613619973103f,
(float16_t)-0.46053871095823989412f,(float16_t)-0.88763962040285404598f,
(float16_t)-0.45644898239688419528f,(float16_t)-0.88974958638307266590f,
(float16_t)-0.45234958723377066692f,(float16_t)-0.89184070939234283415f,
(float16_t)-0.44824061228522010802f,(float16_t)-0.89391294514520314163f,
(float16_t)-0.44412214457042975546f,(float16_t)-0.89596624975618488484f,
(float16_t)-0.43999427130963336685f,(float16_t)-0.89800057974073976830f,
(float16_t)-0.43585707992225597440f,(float16_t)-0.90001589201615994629f,
(float16_t)-0.43171065802505731446f,(float16_t)-0.90201214390249317976f,
(float16_t)-0.42755509343028247349f,(float16_t)-0.90398929312344311615f,
(float16_t)-0.42339047414379599177f,(float16_t)-0.90594729780726845902f,
(float16_t)-0.41921688836322429372f,(float16_t)-0.90788611648766603945f,
(float16_t)-0.41503442447608152044f,(float16_t)-0.90980570810465233311f,
(float16_t)-0.41084317105790418845f,(float16_t)-0.91170603200542976730f,
(float16_t)-0.40664321687036886210f,(float16_t)-0.91358704794525091852f,
(float16_t)-0.40243465085941865222f,(float16_t)-0.91544871608826772214f,
(float16_t)-0.39821756215337417162f,(float16_t)-0.91729099700837768427f,
(float16_t)-0.39399204006104820985f,(float16_t)-0.91911385169005765938f,
(float16_t)-0.38975817406985696634f,(float16_t)-0.92091724152918930102f,
(float16_t)-0.38551605384391890441f,(float16_t)-0.92270112833387851747f,
(float16_t)-0.38126576922216276477f,(float16_t)-0.92446547432526249288f,
(float16_t)-0.37700741021641820394f,(float16_t)-0.92621024213831137928f,
(float16_t)-0.37274106700951614712f,(float16_t)-0.92793539482261766516f,
(float16_t)-0.36846682995337221023f,(float16_t)-0.92964089584318132520f,
(float16_t)-0.36418478956708016936f,(float16_t)-0.93132670908118031505f,
(float16_t)-0.35989503653498794433f,(float16_t)-0.93299279883473895669f,
(float16_t)-0.35559766170478407377f,(float16_t)-0.93463912981968066962f,
(float16_t)-0.35129275608556687072f,(float16_t)-0.93626566717027837061f,
(float16_t)-0.34698041084592379235f,(float16_t)-0.93787237643998977443f,
(float16_t)-0.34266071731199487793f,(float16_t)-0.93945922360218969693f,
(float16_t)-0.33833376696554123830f,(float16_t)-0.94102617505088925753f,
(float16_t)-0.33399965144200982614f,(float16_t)-0.94257319760144675502f,
(float16_t)-0.32965846252858749255f,(float16_t)-0.94410025849127265918f,
(float16_t)-0.32531029216226331480f,(float16_t)-0.94560732538052116869f,
(float16_t)-0.32095523242787515894f,(float16_t)-0.94709436635277721717f,
(float16_t)-0.31659337555616617887f,(float16_t)-0.94856134991573015647f,
(float16_t)-0.31222481392182477311f,(float16_t)-0.95000824500184311017f,
(float16_t)-0.30784964004153508865f,(float16_t)-0.95143502096900833820f,
(float16_t)-0.30346794657201103806f,(float16_t)-0.95284164760119871573f,
(float16_t)-0.29907982630804058610f,(float16_t)-0.95422809510910555630f,
(float16_t)-0.29468537218051488180f,(float16_t)-0.95559433413077088382f,
(float16_t)-0.29028467725446244208f,(float16_t)-0.95694033573220882438f,
(float16_t)-0.28587783472708105936f,(float16_t)-0.95826607140801756124f,
(float16_t)-0.28146493792575794091f,(float16_t)-0.95957151308198451733f,
(float16_t)-0.27704608030610028413f,(float16_t)-0.96085663310767954748f,
(float16_t)-0.27262135544994886560f,(float16_t)-0.96212140426904158019f,
(float16_t)-0.26819085706340350939f,(float16_t)-0.96336579978095393528f,
(float16_t)-0.26375467897483123592f,(float16_t)-0.96458979328981275803f,
(float16_t)-0.25931291513288645678f,(float16_t)-0.96579335887408357397f,
(float16_t)-0.25486565960451434965f,(float16_t)-0.96697647104485218161f,
(float16_t)-0.25041300657296539089f,(float16_t)-0.96813910474636233339f,
(float16_t)-0.24595505033579515008f,(float16_t)-0.96928123535654830967f,
(float16_t)-0.24149188530286941345f,(float16_t)-0.97040283868755550234f,
(float16_t)-0.23702360599436766986f,(float16_t)-0.97150389098625167250f,
(float16_t)-0.23255030703877521692f,(float16_t)-0.97258436893473221296f,
(float16_t)-0.22807208317088611960f,(float16_t)-0.97364424965081186603f,
(float16_t)-0.22358902922978990402f,(float16_t)-0.97468351068851066810f,
(float16_t)-0.21910124015687010290f,(float16_t)-0.97570213003852845901f,
(float16_t)-0.21460881099378659176f,(float16_t)-0.97670008612871184184f,
(float16_t)-0.21011183688046985996f,(float16_t)-0.97767735782450992943f,
(float16_t)-0.20561041305309901706f,(float16_t)-0.97863392442942320759f,
(float16_t)-0.20110463484209206708f,(float16_t)-0.97956976568544051887f,
(float16_t)-0.19659459767008077846f,(float16_t)-0.98048486177346927395f,
(float16_t)-0.19208039704989252061f,(float16_t)-0.98137919331375456089f,
(float16_t)-0.18756212858253007436f,(float16_t)-0.98225274136628937249f,
(float16_t)-0.18303988795514095078f,(float16_t)-0.98310548743121628501f,
(float16_t)-0.17851377093899792325f,(float16_t)-0.98393741344921881176f,
(float16_t)-0.17398387338746373887f,(float16_t)-0.98474850180190420801f,
(float16_t)-0.16945029123396829207f,(float16_t)-0.98553873531217606185f,
(float16_t)-0.16491312048996975559f,(float16_t)-0.98630809724459866938f,
(float16_t)-0.16037245724292850668f,(float16_t)-0.98705657130575097380f,
(float16_t)-0.15582839765426498291f,(float16_t)-0.98778414164457217783f,
(float16_t)-0.15128103795733036097f,(float16_t)-0.98849079285269658701f,
(float16_t)-0.14673047445536230304f,(float16_t)-0.98917650996478090342f,
(float16_t)-0.14217680351944814165f,(float16_t)-0.98984127845882052821f,
(float16_t)-0.13762012158648653792f,(float16_t)-0.99048508425645698239f,
(float16_t)-0.13306052515713906459f,(float16_t)-0.99110791372327688986f,
(float16_t)-0.12849811079379358514f,(float16_t)-0.99170975366909952520f,
(float16_t)-0.12393297511851208981f,(float16_t)-0.99229059134825736699f,
(float16_t)-0.11936521481099168773f,(float16_t)-0.99285041445986510489f,
(float16_t)-0.11479492660650993108f,(float16_t)-0.99338921114808065305f,
(float16_t)-0.11022220729388330918f,(float16_t)-0.99390697000235606051f,
(float16_t)-0.10564715371341037997f,(float16_t)-0.99440368005767909576f,
(float16_t)-0.10106986275482798820f,(float16_t)-0.99487933079480561638f,
(float16_t)-0.09649043135525316173f,(float16_t)-0.99533391214048216877f,
(float16_t)-0.09190895649713282101f,(float16_t)-0.99576741446765981713f,
(float16_t)-0.08732553520619255882f,(float16_t)-0.99617982859569687015f,
(float16_t)-0.08274026454937570552f,(float16_t)-0.99657114579055483539f,
(float16_t)-0.07815324163279464831f,(float16_t)-0.99694135776498205015f,
(float16_t)-0.07356456359966735692f,(float16_t)-0.99729045667869020697f,
(float16_t)-0.06897432762826707919f,(float16_t)-0.99761843513851955478f,
(float16_t)-0.06438263092985731240f,(float16_t)-0.99792528619859599548f,
(float16_t)-0.05978957074664013188f,(float16_t)-0.99821100336047818846f,
(float16_t)-0.05519524434968971216f,(float16_t)-0.99847558057329477421f,
(float16_t)-0.05059974903689945513f,(float16_t)-0.99871901223387293811f,
(float16_t)-0.04600318213091520586f,(float16_t)-0.99894129318685687124f,
(float16_t)-0.04140564097707683661f,(float16_t)-0.99914241872481690532f,
(float16_t)-0.03680722294135933131f,(float16_t)-0.99932238458834943273f,
(float16_t)-0.03220802540830459970f,(float16_t)-0.99948118696616694567f,
(float16_t)-0.02760814577896616301f,(float16_t)-0.99961882249517863830f,
(float16_t)-0.02300768146883930970f,(float16_t)-0.99973528826056168306f,
(float16_t)-0.01840672990580516366f,(float16_t)-0.99983058179582340319f,
(float16_t)-0.01380538852806025008f,(float16_t)-0.99990470108285289808f,
(float16_t)-0.00920375478206008311f,(float16_t)-0.99995764455196389786f,
(float16_t)-0.00460192612044835019f,(float16_t)-0.99998941108192840321f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99983058179582340319f,(float16_t)0.01840672990580482019f,
(float16_t)0.99932238458834954375f,(float16_t)0.03680722294135883171f,
(float16_t)0.99847558057329477421f,(float16_t)0.05519524434968993420f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.99576741446765981713f,(float16_t)0.09190895649713272386f,
(float16_t)0.99390697000235606051f,(float16_t)0.11022220729388305938f,
(float16_t)0.99170975366909952520f,(float16_t)0.12849811079379316880f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.98630809724459866938f,(float16_t)0.16491312048996989437f,
(float16_t)0.98310548743121628501f,(float16_t)0.18303988795514095078f,
(float16_t)0.97956976568544051887f,(float16_t)0.20110463484209190055f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.97150389098625178352f,(float16_t)0.23702360599436719801f,
(float16_t)0.96697647104485207059f,(float16_t)0.25486565960451457169f,
(float16_t)0.96212140426904158019f,(float16_t)0.27262135544994897662f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.95143502096900833820f,(float16_t)0.30784964004153486661f,
(float16_t)0.94560732538052127971f,(float16_t)0.32531029216226292622f,
(float16_t)0.93945922360218991898f,(float16_t)0.34266071731199437833f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.92621024213831137928f,(float16_t)0.37700741021641825945f,
(float16_t)0.91911385169005777040f,(float16_t)0.39399204006104809883f,
(float16_t)0.91170603200542987832f,(float16_t)0.41084317105790391089f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.89596624975618521791f,(float16_t)0.44412214457042920035f,
(float16_t)0.88763962040285393496f,(float16_t)0.46053871095824000514f,
(float16_t)0.87901222642863352519f,(float16_t)0.47679923006332208812f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.86086693863776730939f,(float16_t)0.50883014254310698909f,
(float16_t)0.85135519310526519554f,(float16_t)0.52458968267846894928f,
(float16_t)0.84155497743689844370f,(float16_t)0.54017147272989285423f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.82110251499110464835f,(float16_t)0.57078074588696725566f,
(float16_t)0.81045719825259476821f,(float16_t)0.58579785745643886408f,
(float16_t)0.79953726910790501314f,(float16_t)0.60061647938386897305f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.77688846567323244230f,(float16_t)0.62963823891492698426f,
(float16_t)0.76516726562245895860f,(float16_t)0.64383154288979138613f,
(float16_t)0.75318679904361252042f,(float16_t)0.65780669329707863735f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.72846439044822519637f,(float16_t)0.68508366777270035541f,
(float16_t)0.71573082528381870571f,(float16_t)0.69837624940897280457f,
(float16_t)0.70275474445722529993f,(float16_t)0.71143219574521643356f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.67609270357531603413f,(float16_t)0.73681656887736979300f,
(float16_t)0.66241577759017178373f,(float16_t)0.74913639452345925918f,
(float16_t)0.64851440102211255212f,(float16_t)0.76120238548426177871f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.62005721176328920663f,(float16_t)0.78455659715557524159f,
(float16_t)0.60551104140432554512f,(float16_t)0.79583690460888345530f,
(float16_t)0.59075970185887427544f,(float16_t)0.80684755354379922299f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.56066157619733603124f,(float16_t)0.82804504525775579626f,
(float16_t)0.54532498842204646383f,(float16_t)0.83822470555483796772f,
(float16_t)0.52980362468629482731f,(float16_t)0.84812034480329712149f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.49822766697278186854f,(float16_t)0.86704624551569264845f,
(float16_t)0.48218377207912282989f,(float16_t)0.87607009419540660122f,
(float16_t)0.46597649576796612569f,(float16_t)0.88479709843093778954f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.43309381885315201277f,(float16_t)0.90134884704602202810f,
(float16_t)0.41642956009763731906f,(float16_t)0.90916798309052226923f,
(float16_t)0.39962419984564678810f,(float16_t)0.91667905992104270485f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.36561299780477396482f,(float16_t)0.93076696107898371224f,
(float16_t)0.34841868024943450921f,(float16_t)0.93733901191257495977f,
(float16_t)0.33110630575987642921f,(float16_t)0.94359345816196038559f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.29615088824362395536f,(float16_t)0.95514116830577067141f,
(float16_t)0.27851968938505305973f,(float16_t)0.96043051941556578655f,
(float16_t)0.26079411791527556952f,(float16_t)0.96539444169768939830f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.22508391135979277653f,(float16_t)0.97433938278557585821f,
(float16_t)0.20711137619221856032f,(float16_t)0.97831737071962765473f,
(float16_t)0.18906866414980627589f,(float16_t)0.98196386910955524296f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.15279718525844340760f,(float16_t)0.98825756773074946437f,
(float16_t)0.13458070850712622324f,(float16_t)0.99090263542778000971f,
(float16_t)0.11631863091190487725f,(float16_t)0.99321194923479450001f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.07968243797143012563f,(float16_t)0.99682029929116566791f,
(float16_t)0.06132073630220864768f,(float16_t)0.99811811290014917919f,
(float16_t)0.04293825693494095902f,(float16_t)0.99907772775264536147f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)0.00613588464915451517f,(float16_t)0.99998117528260110909f,
(float16_t)-0.01227153828571982304f,(float16_t)0.99992470183914450299f,
(float16_t)-0.03067480317663645942f,(float16_t)0.99952941750109314256f,
(float16_t)-0.04906767432741800800f,(float16_t)0.99879545620517240501f,
(float16_t)-0.06744391956366398155f,(float16_t)0.99772306664419163624f,
(float16_t)-0.08579731234443975507f,(float16_t)0.99631261218277800129f,
(float16_t)-0.10412163387205460030f,(float16_t)0.99456457073425541537f,
(float16_t)-0.12241067519921615403f,(float16_t)0.99247953459870996706f,
(float16_t)-0.14065823933284912761f,(float16_t)0.99005821026229712256f,
(float16_t)-0.15885814333386127917f,(float16_t)0.98730141815785843473f,
(float16_t)-0.17700422041214874946f,(float16_t)0.98421009238692902521f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.21311031991609125091f,(float16_t)0.97702814265775439484f,
(float16_t)-0.23105810828067113727f,(float16_t)0.97293995220556017678f,
(float16_t)-0.24892760574572012078f,(float16_t)0.96852209427441737777f,
(float16_t)-0.26671275747489830987f,(float16_t)0.96377606579543984022f,
(float16_t)-0.28440753721127171039f,(float16_t)0.95870347489587159906f,
(float16_t)-0.30200594931922808417f,(float16_t)0.95330604035419386211f,
(float16_t)-0.31950203081601563637f,(float16_t)0.94758559101774120226f,
(float16_t)-0.33688985339221994009f,(float16_t)0.94154406518302080631f,
(float16_t)-0.35416352542049039931f,(float16_t)0.93518350993894761025f,
(float16_t)-0.37131719395183748755f,(float16_t)0.92850608047321558924f,
(float16_t)-0.38834504669882619066f,(float16_t)0.92151403934204201285f,
(float16_t)-0.40524131400498974998f,(float16_t)0.91420975570353069095f,
(float16_t)-0.42200027079979968159f,(float16_t)0.90659570451491533483f,
(float16_t)-0.43861623853852738097f,(float16_t)0.89867446569395392775f,
(float16_t)-0.45508358712634372489f,(float16_t)0.89044872324475798919f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.48755016014843571837f,(float16_t)0.87309497841829020182f,
(float16_t)-0.50353838372571746440f,(float16_t)0.86397285612158680745f,
(float16_t)-0.51935599016558964269f,(float16_t)0.85455798836540053376f,
(float16_t)-0.53499761988709704230f,(float16_t)0.84485356524970722791f,
(float16_t)-0.55045797293660470029f,(float16_t)0.83486287498638012128f,
(float16_t)-0.56573181078361323149f,(float16_t)0.82458930278502517996f,
(float16_t)-0.58081395809576441547f,(float16_t)0.81403632970594852480f,
(float16_t)-0.59569930449243335691f,(float16_t)0.80320753148064494287f,
(float16_t)-0.61038280627630958630f,(float16_t)0.79210657730021227785f,
(float16_t)-0.62485948814238623239f,(float16_t)0.78073722857209459924f,
(float16_t)-0.63912444486377573138f,(float16_t)0.76910333764557958780f,
(float16_t)-0.65317284295377653347f,(float16_t)0.75720884650648467851f,
(float16_t)-0.66699992230363736034f,(float16_t)0.74505778544146605835f,
(float16_t)-0.68060099779545302212f,(float16_t)0.73265427167241281570f,
(float16_t)-0.69397146088965377952f,(float16_t)0.72000250796138176579f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.72000250796138165477f,(float16_t)0.69397146088965389055f,
(float16_t)-0.73265427167241270467f,(float16_t)0.68060099779545324417f,
(float16_t)-0.74505778544146594733f,(float16_t)0.66699992230363758239f,
(float16_t)-0.75720884650648467851f,(float16_t)0.65317284295377664449f,
(float16_t)-0.76910333764557947678f,(float16_t)0.63912444486377584241f,
(float16_t)-0.78073722857209448822f,(float16_t)0.62485948814238634341f,
(float16_t)-0.79210657730021216683f,(float16_t)0.61038280627630969732f,
(float16_t)-0.80320753148064483184f,(float16_t)0.59569930449243346793f,
(float16_t)-0.81403632970594841378f,(float16_t)0.58081395809576452649f,
(float16_t)-0.82458930278502506894f,(float16_t)0.56573181078361345353f,
(float16_t)-0.83486287498638001026f,(float16_t)0.55045797293660492233f,
(float16_t)-0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)-0.85455798836540042274f,(float16_t)0.51935599016558975372f,
(float16_t)-0.86397285612158669643f,(float16_t)0.50353838372571757542f,
(float16_t)-0.87309497841829009079f,(float16_t)0.48755016014843588490f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.89044872324475787817f,(float16_t)0.45508358712634389143f,
(float16_t)-0.89867446569395392775f,(float16_t)0.43861623853852754751f,
(float16_t)-0.90659570451491533483f,(float16_t)0.42200027079979984812f,
(float16_t)-0.91420975570353069095f,(float16_t)0.40524131400498991651f,
(float16_t)-0.92151403934204179080f,(float16_t)0.38834504669882657923f,
(float16_t)-0.92850608047321547822f,(float16_t)0.37131719395183770960f,
(float16_t)-0.93518350993894761025f,(float16_t)0.35416352542049039931f,
(float16_t)-0.94154406518302069529f,(float16_t)0.33688985339222032867f,
(float16_t)-0.94758559101774109124f,(float16_t)0.31950203081601580291f,
(float16_t)-0.95330604035419386211f,(float16_t)0.30200594931922802866f,
(float16_t)-0.95870347489587148804f,(float16_t)0.28440753721127209896f,
(float16_t)-0.96377606579543984022f,(float16_t)0.26671275747489847641f,
(float16_t)-0.96852209427441737777f,(float16_t)0.24892760574572009302f,
(float16_t)-0.97293995220556006576f,(float16_t)0.23105810828067133156f,
(float16_t)-0.97702814265775439484f,(float16_t)0.21311031991609141745f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.98421009238692902521f,(float16_t)0.17700422041214894375f,
(float16_t)-0.98730141815785843473f,(float16_t)0.15885814333386147346f,
(float16_t)-0.99005821026229701154f,(float16_t)0.14065823933284954395f,
(float16_t)-0.99247953459870996706f,(float16_t)0.12241067519921634832f,
(float16_t)-0.99456457073425541537f,(float16_t)0.10412163387205457254f,
(float16_t)-0.99631261218277800129f,(float16_t)0.08579731234444015753f,
(float16_t)-0.99772306664419163624f,(float16_t)0.06744391956366417584f,
(float16_t)-0.99879545620517240501f,(float16_t)0.04906767432741796636f,
(float16_t)-0.99952941750109314256f,(float16_t)0.03067480317663686534f,
(float16_t)-0.99992470183914450299f,(float16_t)0.01227153828572000692f,
(float16_t)-0.99998117528260110909f,(float16_t)-0.00613588464915455420f,
(float16_t)-0.99969881869620424997f,(float16_t)-0.02454122852291207996f,
(float16_t)-0.99907772775264536147f,(float16_t)-0.04293825693494077861f,
(float16_t)-0.99811811290014917919f,(float16_t)-0.06132073630220824523f,
(float16_t)-0.99682029929116577893f,(float16_t)-0.07968243797142994522f,
(float16_t)-0.99518472667219692873f,(float16_t)-0.09801714032956058975f,
(float16_t)-0.99321194923479461103f,(float16_t)-0.11631863091190447479f,
(float16_t)-0.99090263542778000971f,(float16_t)-0.13458070850712605671f,
(float16_t)-0.98825756773074946437f,(float16_t)-0.15279718525844343535f,
(float16_t)-0.98527764238894133264f,(float16_t)-0.17096188876030096737f,
(float16_t)-0.98196386910955524296f,(float16_t)-0.18906866414980610935f,
(float16_t)-0.97831737071962765473f,(float16_t)-0.20711137619221858808f,
(float16_t)-0.97433938278557585821f,(float16_t)-0.22508391135979261000f,
(float16_t)-0.97003125319454397424f,(float16_t)-0.24298017990326381543f,
(float16_t)-0.96539444169768939830f,(float16_t)-0.26079411791527562503f,
(float16_t)-0.96043051941556589757f,(float16_t)-0.27851968938505289319f,
(float16_t)-0.95514116830577078243f,(float16_t)-0.29615088824362378883f,
(float16_t)-0.94952818059303678577f,(float16_t)-0.31368174039889118454f,
(float16_t)-0.94359345816196038559f,(float16_t)-0.33110630575987626267f,
(float16_t)-0.93733901191257495977f,(float16_t)-0.34841868024943456472f,
(float16_t)-0.93076696107898382326f,(float16_t)-0.36561299780477357624f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,
(float16_t)-0.91667905992104270485f,(float16_t)-0.39962419984564684361f,
(float16_t)-0.90916798309052249127f,(float16_t)-0.41642956009763693048f,
(float16_t)-0.90134884704602202810f,(float16_t)-0.43309381885315184624f,
(float16_t)-0.89322430119551532446f,(float16_t)-0.44961132965460665067f,
(float16_t)-0.88479709843093790056f,(float16_t)-0.46597649576796595916f,
(float16_t)-0.87607009419540660122f,(float16_t)-0.48218377207912266336f,
(float16_t)-0.86704624551569287050f,(float16_t)-0.49822766697278153547f,
(float16_t)-0.85772861000027211809f,(float16_t)-0.51410274419322155026f,
(float16_t)-0.84812034480329723252f,(float16_t)-0.52980362468629460526f,
(float16_t)-0.83822470555483818977f,(float16_t)-0.54532498842204613076f,
(float16_t)-0.82804504525775590729f,(float16_t)-0.56066157619733592021f,
(float16_t)-0.81758481315158371139f,(float16_t)-0.57580819141784533866f,
(float16_t)-0.80684755354379944503f,(float16_t)-0.59075970185887394237f,
(float16_t)-0.79583690460888356633f,(float16_t)-0.60551104140432543410f,
(float16_t)-0.78455659715557524159f,(float16_t)-0.62005721176328920663f,
(float16_t)-0.77301045336273710440f,(float16_t)-0.63439328416364526575f,
(float16_t)-0.76120238548426188974f,(float16_t)-0.64851440102211233008f,
(float16_t)-0.74913639452345925918f,(float16_t)-0.66241577759017178373f,
(float16_t)-0.73681656887737001504f,(float16_t)-0.67609270357531581208f,
(float16_t)-0.72424708295146700276f,(float16_t)-0.68954054473706682948f,
(float16_t)-0.71143219574521665560f,(float16_t)-0.70275474445722507788f,
(float16_t)-0.69837624940897302661f,(float16_t)-0.71573082528381848366f,
(float16_t)-0.68508366777270035541f,(float16_t)-0.72846439044822519637f,
(float16_t)-0.67155895484701866316f,(float16_t)-0.74095112535495888384f,
(float16_t)-0.65780669329707874837f,(float16_t)-0.75318679904361240940f,
(float16_t)-0.64383154288979149715f,(float16_t)-0.76516726562245895860f,
(float16_t)-0.62963823891492687324f,(float16_t)-0.77688846567323255332f,
(float16_t)-0.61523159058062726334f,(float16_t)-0.78834642762660589455f,
(float16_t)-0.60061647938386930612f,(float16_t)-0.79953726910790479110f,
(float16_t)-0.58579785745643908612f,(float16_t)-0.81045719825259465718f,
(float16_t)-0.57078074588696736669f,(float16_t)-0.82110251499110464835f,
(float16_t)-0.55557023301960217765f,(float16_t)-0.83146961230254523567f,
(float16_t)-0.54017147272989274320f,(float16_t)-0.84155497743689855472f,
(float16_t)-0.52458968267846928235f,(float16_t)-0.85135519310526486247f,
(float16_t)-0.50883014254310732216f,(float16_t)-0.86086693863776708735f,
(float16_t)-0.49289819222978420443f,(float16_t)-0.87008699110871134952f,
(float16_t)-0.47679923006332214364f,(float16_t)-0.87901222642863341417f,
(float16_t)-0.46053871095823989412f,(float16_t)-0.88763962040285404598f,
(float16_t)-0.44412214457042975546f,(float16_t)-0.89596624975618488484f,
(float16_t)-0.42755509343028247349f,(float16_t)-0.90398929312344311615f,
(float16_t)-0.41084317105790418845f,(float16_t)-0.91170603200542976730f,
(float16_t)-0.39399204006104820985f,(float16_t)-0.91911385169005765938f,
(float16_t)-0.37700741021641820394f,(float16_t)-0.92621024213831137928f,
(float16_t)-0.35989503653498794433f,(float16_t)-0.93299279883473895669f,
(float16_t)-0.34266071731199487793f,(float16_t)-0.93945922360218969693f,
(float16_t)-0.32531029216226331480f,(float16_t)-0.94560732538052116869f,
(float16_t)-0.30784964004153508865f,(float16_t)-0.95143502096900833820f,
(float16_t)-0.29028467725446244208f,(float16_t)-0.95694033573220882438f,
(float16_t)-0.27262135544994886560f,(float16_t)-0.96212140426904158019f,
(float16_t)-0.25486565960451434965f,(float16_t)-0.96697647104485218161f,
(float16_t)-0.23702360599436766986f,(float16_t)-0.97150389098625167250f,
(float16_t)-0.21910124015687010290f,(float16_t)-0.97570213003852845901f,
(float16_t)-0.20110463484209206708f,(float16_t)-0.97956976568544051887f,
(float16_t)-0.18303988795514095078f,(float16_t)-0.98310548743121628501f,
(float16_t)-0.16491312048996975559f,(float16_t)-0.98630809724459866938f,
(float16_t)-0.14673047445536230304f,(float16_t)-0.98917650996478090342f,
(float16_t)-0.12849811079379358514f,(float16_t)-0.99170975366909952520f,
(float16_t)-0.11022220729388330918f,(float16_t)-0.99390697000235606051f,
(float16_t)-0.09190895649713282101f,(float16_t)-0.99576741446765981713f,
(float16_t)-0.07356456359966735692f,(float16_t)-0.99729045667869020697f,
(float16_t)-0.05519524434968971216f,(float16_t)-0.99847558057329477421f,
(float16_t)-0.03680722294135933131f,(float16_t)-0.99932238458834943273f,
(float16_t)-0.01840672990580516366f,(float16_t)-0.99983058179582340319f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.99729045667869020697f,(float16_t)0.07356456359966742631f,
(float16_t)0.98917650996478101444f,(float16_t)0.14673047445536174793f,
(float16_t)0.97570213003852857003f,(float16_t)0.21910124015686979759f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.93299279883473895669f,(float16_t)0.35989503653498811087f,
(float16_t)0.90398929312344333820f,(float16_t)0.42755509343028208491f,
(float16_t)0.87008699110871146054f,(float16_t)0.49289819222978403790f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.78834642762660622761f,(float16_t)0.61523159058062681925f,
(float16_t)0.74095112535495921691f,(float16_t)0.67155895484701833009f,
(float16_t)0.68954054473706694051f,(float16_t)0.72424708295146689174f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.57580819141784533866f,(float16_t)0.81758481315158371139f,
(float16_t)0.51410274419322166128f,(float16_t)0.85772861000027211809f,
(float16_t)0.44961132965460659516f,(float16_t)0.89322430119551532446f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.31368174039889157312f,(float16_t)0.94952818059303667475f,
(float16_t)0.24298017990326398197f,(float16_t)0.97003125319454397424f,
(float16_t)0.17096188876030135595f,(float16_t)0.98527764238894122162f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)0.02454122852291226384f,(float16_t)0.99969881869620424997f,
(float16_t)-0.04906767432741800800f,(float16_t)0.99879545620517240501f,
(float16_t)-0.12241067519921615403f,(float16_t)0.99247953459870996706f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.26671275747489830987f,(float16_t)0.96377606579543984022f,
(float16_t)-0.33688985339221994009f,(float16_t)0.94154406518302080631f,
(float16_t)-0.40524131400498974998f,(float16_t)0.91420975570353069095f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.53499761988709704230f,(float16_t)0.84485356524970722791f,
(float16_t)-0.59569930449243335691f,(float16_t)0.80320753148064494287f,
(float16_t)-0.65317284295377653347f,(float16_t)0.75720884650648467851f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.75720884650648467851f,(float16_t)0.65317284295377664449f,
(float16_t)-0.80320753148064483184f,(float16_t)0.59569930449243346793f,
(float16_t)-0.84485356524970711689f,(float16_t)0.53499761988709715332f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.91420975570353069095f,(float16_t)0.40524131400498991651f,
(float16_t)-0.94154406518302069529f,(float16_t)0.33688985339222032867f,
(float16_t)-0.96377606579543984022f,(float16_t)0.26671275747489847641f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.99247953459870996706f,(float16_t)0.12241067519921634832f,
(float16_t)-0.99879545620517240501f,(float16_t)0.04906767432741796636f,
(float16_t)-0.99969881869620424997f,(float16_t)-0.02454122852291207996f,
(float16_t)-0.99518472667219692873f,(float16_t)-0.09801714032956058975f,
(float16_t)-0.98527764238894133264f,(float16_t)-0.17096188876030096737f,
(float16_t)-0.97003125319454397424f,(float16_t)-0.24298017990326381543f,
(float16_t)-0.94952818059303678577f,(float16_t)-0.31368174039889118454f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,
(float16_t)-0.89322430119551532446f,(float16_t)-0.44961132965460665067f,
(float16_t)-0.85772861000027211809f,(float16_t)-0.51410274419322155026f,
(float16_t)-0.81758481315158371139f,(float16_t)-0.57580819141784533866f,
(float16_t)-0.77301045336273710440f,(float16_t)-0.63439328416364526575f,
(float16_t)-0.72424708295146700276f,(float16_t)-0.68954054473706682948f,
(float16_t)-0.67155895484701866316f,(float16_t)-0.74095112535495888384f,
(float16_t)-0.61523159058062726334f,(float16_t)-0.78834642762660589455f,
(float16_t)-0.55557023301960217765f,(float16_t)-0.83146961230254523567f,
(float16_t)-0.49289819222978420443f,(float16_t)-0.87008699110871134952f,
(float16_t)-0.42755509343028247349f,(float16_t)-0.90398929312344311615f,
(float16_t)-0.35989503653498794433f,(float16_t)-0.93299279883473895669f,
(float16_t)-0.29028467725446244208f,(float16_t)-0.95694033573220882438f,
(float16_t)-0.21910124015687010290f,(float16_t)-0.97570213003852845901f,
(float16_t)-0.14673047445536230304f,(float16_t)-0.98917650996478090342f,
(float16_t)-0.07356456359966735692f,(float16_t)-0.99729045667869020697f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.95694033573220882438f,(float16_t)0.29028467725446233105f,
(float16_t)0.83146961230254523567f,(float16_t)0.55557023301960217765f,
(float16_t)0.63439328416364548779f,(float16_t)0.77301045336273688235f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)0.09801714032956077016f,(float16_t)0.99518472667219681771f,
(float16_t)-0.19509032201612819257f,(float16_t)0.98078528040323043058f,
(float16_t)-0.47139673682599769755f,(float16_t)0.88192126434835504956f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.88192126434835493853f,(float16_t)0.47139673682599780857f,
(float16_t)-0.98078528040323043058f,(float16_t)0.19509032201612860891f,
(float16_t)-0.99518472667219692873f,(float16_t)-0.09801714032956058975f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,
(float16_t)-0.77301045336273710440f,(float16_t)-0.63439328416364526575f,
(float16_t)-0.55557023301960217765f,(float16_t)-0.83146961230254523567f,
(float16_t)-0.29028467725446244208f,(float16_t)-0.95694033573220882438f,
(float16_t)1.00000000000000000000f,(float16_t)0.00000000000000000000f,
(float16_t)0.38268343236508983729f,(float16_t)0.92387953251128673848f,
(float16_t)-0.70710678118654746172f,(float16_t)0.70710678118654757274f,
(float16_t)-0.92387953251128684951f,(float16_t)-0.38268343236508967076f,};

#endif



#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES) */
#endif /* defined(ARM_MATH_MVE_FLOAT16) && !defined(ARM_MATH_AUTOVECTORIZE) */

#endif /* if defined(ARM_FLOAT16_SUPPORTED) */

#endif // EIDSP_LOAD_CMSIS_DSP_SOURCES
