{\rtf1\ansi\ansicpg1252\deff0{\fonttbl{\f0\fnil\fcharset0 Courier;}}
\viewkind4\uc1\pard\lang1033\f0\fs17 '                           UV LIGHT BOX WITH LEDs - PICAXE 20M2
\par '                                      (uvbox_20m2.bas)
\par 
\par '----------------------------------------------------------------------------------
\par 'Light Box timer for making PC boards using the Riston or Kinston pre-coated board.
\par 'Drives a 3 x 4 array of UVLEDs on 25mm centers to expose the photo-sensitive board.
\par 'Program has SET and RUN modes indicated by LEDs and controlled by the push buttons.
\par 'Exposure times up to 999 seconds can be entered and are shown on a 3 digit display.
\par 'Change the exposure time by pressing the "units" or "tens" or "100s" push buttons
\par 'This time is saved and is the default exposure each time the "start" PB is pressed.
\par '----------------------------------------------------------------------------------
\par 
\par 
\par power_up:' ------------ setup the micro and load the saved exposure time ----------
\par setfreq m16
\par let dirsB = %11111111: let pinsB = %00000000
\par let dirsC = %00001111: let pinsC = %00000000
\par pullup %1111000000000000
\par read 1,b1: read 2,b2: read 3,b3
\par 'goto display_mode
\par 
\par display_mode:'--------- drive 7segment displays and monitor push buttons ----------
\par 'show units
\par if b4 = 0 and pinC.7 = 0 then: gosub set_units: endif
\par on b1 gosub zero,one,two,three,four,five,six,seven,eight,nine
\par high C.1
\par pause 16
\par low C.1
\par 
\par 'show tens
\par if b4 = 0 and pinC.6 = 0 then: gosub set_tens: endif
\par on b2 gosub zero,one,two,three,four,five,six,seven,eight,nine
\par high C.2
\par pause 16
\par low C.2
\par 
\par 'show 100s
\par if b4 = 0 and pinC.5 = 0 then: gosub set_100s: endif
\par on b3 gosub zero,one,two,three,four,five,six,seven,eight,nine
\par high C.3
\par pause 16
\par low C.3
\par goto run_check
\par 
\par 'segment data: 
\par blank: pinsB = %00000000: return
\par one:   pinsB = %00000110: return
\par two:   pinsB = %01011011: return
\par three: pinsB = %01001111: return
\par four:  pinsB = %01100110: return
\par five:  pinsB = %01101101: return
\par six:   pinsB = %01111100: return
\par seven: pinsB = %00000111: return
\par eight: pinsB = %01111111: return
\par nine:  pinsB = %01100111: return
\par zero:  pinsB = %00111111: return
\par     
\par 
\par run_check:' ---------- the run push button (S1) begins the count sequence ---------
\par if b4 = 0 and pinC.4 = 0 then gosub counter_start
\par if b4 = 1 then gosub counter_run
\par if b4 = 2 then gosub counter_stop
\par goto display_mode
\par 
\par 
\par 'exposure_set' ------ the push buttons (S2 S3 S4) enter the exposure time ---------
\par set_units:
\par if b11 = 0 then: inc b1: endif
\par if b1 => 10 then: b1 = 0: endif
\par write 1,b1
\par inc b11
\par if b11 => 12 then: b11 = 0 endif
\par return
\par 
\par set_tens:
\par if b12 = 0 then: inc b2: endif
\par if b2 => 10 then: b2 = 0: endif
\par write 2,b2
\par inc b12
\par if b12 => 12 then: b12 = 0 endif
\par return
\par 
\par set_100s:
\par if b13 = 0 then: inc b3: endif
\par if b3 => 10 then: b3 = 0: endif
\par write 3,b3
\par inc b13
\par if b13 => 12 then: b13 = 0: endif
\par return
\par 
\par 
\par counter_start:'------- prepare to count by turning on the run-led and relay -------
\par high C.0
\par if b4 = 0 then: b4 = 1: w4 = 0: time = 0: endif
\par return
\par 
\par counter_run:'-------- countdown in seconds using the selected exposure time ------- 
\par let w6 = time
\par if w6 > w4 then gosub set_count
\par 
\par 'count_units:
\par if b1 <= 9 then goto all_zeros 
\par b1 = 9
\par 
\par 'count_tens:
\par dec b2
\par if b2 <= 9 then goto all_zeros 
\par b2 = 9
\par 
\par 'count_100s:
\par dec b3 
\par if b3 <= 9 then goto all_zeros
\par b3 = 9
\par goto power_up' (re-start on overflow)
\par 
\par set_count:'--------- use picaxe "time" function to change seconds count ----------
\par let w4 = time
\par dec b1
\par return
\par 
\par all_zeros:'---------- halt counter once exposure time reaches all zeros ---------- 
\par if b1 = 0 and b2 = 0 and b3 = 0 then: b4 = 2 : endif
\par return 
\par 
\par counter_stop:'-------- turn off run-led and relay and display all zeros ----------
\par low C.0
\par inc b5
\par if b5 = 100 then: b4 = 0: b5 = 0:endif
\par if b4 = 0 then:gosub restore_count: endif
\par return 
\par 
\par restore_count:'----- play the end tune then load the saved exposure time ---------
\par tune B.7,7,($69,$67,$66,$27,$04,$42,$40,$42,$67,$44,$42,$40,$42,$6B,$E9,$67,$66,$E7)
\par read 1,b1: read 2,b2: read 3,b3
\par return
\par 
\par 
\par '                               Definition of variables
\par '----------------------------------------------------------------------------------
\par '    w4 = time old
\par '    w6 = time new
\par '    b0 = temp variable
\par '    b1 = count the units            
\par '    b2 = count the tens              
\par '    b3 = count the 100s
\par '    b4 = 0 counter off 
\par '    b4 = 1 counter on  
\par '    b4 = 2 counter zero       
\par '----------------------------------------------------------------------------------              
\par               
\par 
\par }
 