'this version uses channels 0 - 9 using
'Philips remote controls. It samples 3 complete code strings
'and compares 2nd and 3rd string for errors. Press key (0 - 9)
'until ack led flashes once briefly. If error is found ack led
'flashes quickly 10 times indicating a need to retransmit
'initially all outputs are set to momentary. These initial settings can be
'altered to toggle by pressing CHAN UP followed by 1 for toggle followed by
' 1 or 0 for INITAL STATE ie state at turn on.1 = ON;0 = OFF
'To change from toggle back to momentary CHAN UP then 0. Operation follows
'that of original article in SC june 2013
'a() is an accumulator,togglestate is toggle state of outputs
'type is type of output ie 1 = toggle or 0 = momentary(stored as 2)
'initstate is initial state of outputs at turn on(toggle only)
'setupflag = 1 when in setup mode
'flag =0 when no pulses being received; =1 when pulses are being received
'code0 is a flag to indicate momentary channel is active
'oldtoggle is toggle flag. it depends on toggle bit of RC5 code and will
'be 0 or 1. Use is made of this to determine whether a new key has been
'pressed or if old key is continued to be pressed.
'If set to 2 indicates no toggle is currently under way

  Dim a(95),togglestate(10),type(10),initstate(10)
  Sound 200000                'generate 5 us pulses for counting
  For i = 1 To 10:type(i) = 2:togglestate(i) = 1:Next i 'set all as momentary
  For i = 1 To 10:SetPin i,8:Next i 'set output pins
  SetPin  18,8:SetPin 15,2:SetPin 16,2      'set ACK & Code1 & Code2 pins
  oldtoggle = 2   'for use in toggle bit to check if key press is continuing
  Option error continue             'read in previously stored output states
  Open "a:data" For input As #1        'or create a new data file
  If MM.Errno = 6 Then         'condition that no file previously existed
    Open "a:data" For output As #1
    For i = 1 To 10
      Print #1, type(i),",",initstate(i)
    Next i
    Close #1
  Else
    Close #1
  EndIf
  Open "a:data" For input As #1 'read in output states & set initial states
  For i = 1 To 10
    Input #1, type(i),initstate(i):Pin(i) = initstate(i)
    If initstate(i) = 1 Then togglestate(i) = 0
              'need to change togglestate to correct initstate info
  Next i
  Close #1
  devicecode = 2*Pin(16) + Pin(15) + 1
  On devicecode GoSub cd,sat2,sat1,tv

idle:
  SetPin 20,7,update  'detect + & -ve edges
  SetPin 19,6,update
  count = 0:flag =  0:interval = 0
loop1: 'wait here for + & - edges
  If Timer > 12000 And setupflag = 1 Then   'Setup timeout condition is met
    code1 = 33                         'this forces exit from setup routine
    Return
  EndIf
  If flag = 1 Then                          'receiving pulses condition
    If interval > 90 Then                 'exit on receiving enough pulses
      SetPin 20,0
      SetPin 19,0
      GoTo process
    EndIf
    If Timer > 500 Then               'timeout if stuck here
      SetPin 20,0                     'turn of further interrupts
      SetPin 19,0
      GoTo idle                       'start from the beginning
    EndIf
    GoTo loop1                         'continue in loop to receive pulses
  EndIf
        'no pulses are being received here
  SetPin 14,5   'keep resetting counter because no pulses are being received
  count = count + 1 'see if key has been released. 20 found a suitable check
  If count > 20 Then
    Pin(code0) = 0      'turn off any momentary channel
   code0 = 0           'reset momentary flag
   count = 0
   oldtoggle = 2       'reset toggle flag
  EndIf
GoTo loop1

update: 'interrupt routine executed every time a transition has been detected
  a(interval) = Pin(14)   'record No of pulses
  If flag = 0 Then        'first pulse detected:-reset timer,set flag
    Timer = 0
    flag = 1
  EndIf
  interval = interval + 1       'increment counter
  If interval > 93 Then interval = 90
IReturn

process:
  Pin(18) = 1                       'set ack led
  For i = 90 To 1 Step -1             'calculate pulse intervals
    a(i) = a(i) - a(i-1)
    If  a(i) < 267 Then a(i) = 0   'check if a zero
    If a(i) > 266 And a(i) <  500 Then a(i) = 1 'check if a 1
  Next i
  For gap1 = 1 To 90    'find first gap
    If a(gap1) > 1000 Then GoTo midlimit
  Next gap1

  GoTo error1   'no gap found. Not a valid Philips code

midlimit:
  For gap2 = gap1 + 1 To 90    'find 2nd gap
    If a(gap2) > 1000 Then GoTo upperlimit
  Next gap2

  GoTo error1   'no gap found. Not a valid Philips code

upperlimit:           'find 3rd gap
  For gap3 = gap2 + 1 To 90
    If a(gap3) > 1000 Then GoTo exit1
  Next gap3

  GoTo error1     'no gap found. Not a valid Philips code

exit1:  '3rd gap has been found
  decode(gap2 + 1,gap3,code2,device2,toggle2)
  decode(gap1 + 1,gap2,code1,device1,toggle1)
  If devicecode <> device1 Then GoTo error1    'incorrect device on remote
  If code1 <> code2 Then GoTo error1          'decoding not successful
  Pin(18) = 0                       'turn off acknowledge
  If setupflag = 1 Then Return 'Setup calls main program as a subroutine
  If code1 = 33 Then GoTo setup 'channel up button was pressed
  If code1 < 11 Then On type(code1) GoTo toggle,mom

  GoTo error1    'no valid operations are set

setup:  'setup changes to type of channel & initial state (if toggle)
  Pause 500:Pin(18) = 1       'ack keypress keep ack led on
  setupflag = 1               'set setup flag
  GoSub idle                  'get channel
  Pause 500:Pin(18) = 1       'ack keypress keep ack led on
  If code1 > 10 Then GoTo exit3 'not a valid channel number
  channel = code1
  GoSub idle                 'get type of channel (mom = 0 or toggle = 1)
  Pause 500:Pin(18) = 1       'ack keypress keep ack led on
  If code1 > 2 Then GoTo exit3 'check for valid type
  If code1 = 2 Then           'condition for toggle
    type(channel) = 1
    togglestate(channel) = 1   'ensure channel will turn on when next selected
    GoSub idle                 'get initial state
    If code1 > 2 Then GoTo exit3      'check for valid entry
    If code1 = 2 Then         'condition for initial state on
      initstate(channel) = 1
    Else
      initstate(channel) = 0
    EndIf
  Else
    type(channel) = 2         'channel set as momentary
  EndIf

 Open "a:data" For output As #1       'write data to file
 For i = 1 To 10:Print #1, type(i),",",initstate(i):Next i
 Close #1
exit3:
  Pin(18) = 0                'turn off ack
  setupflag = 0              'reset setup flag
  GoTo idle

mom:    'handles momentary type channels
  If code0 = code1 Then GoTo idle  'this is a continued key press so go back
  Pin(code0) = 0  'a new channel selected, so turn off old channel
  Pin(code1) = 1      'turn on new channel
  code0 = code1   'make old channel new channel
  oldtoggle = 2   'reset toggle flag
GoTo idle

toggle:    ' handles toggle type channels
  If code0 >0 Then   'momentary channel is still active
    Pin(code0) = 0    'therefore turn it off
    code0 = 0         'and reset momentary flag
  EndIf
  If oldtoggle = toggle1 Then GoTo idle 'toggle key has not been released
  Pin(code2) = togglestate(code2)   'new channel so toggle pin
  oldtoggle = toggle1               'set toggle flag
  togglestate(code2) = Not(togglestate(code2)) 'change toggle state for next key
  GoTo idle

Sub decode (ll,ul,code,device,toggle) 'decodes Philips RC5 code
  Local phase,change,duration,jj,a$
  duration = a(ll)
  If duration = 0 Then    'set initial conditions
     phase = 0            'this is normal rc5 code
     change = 0
  EndIf
  If duration = 1 Then    'sometimes 2nd start bit is used as part of
     phase = 1            'extended code. In that case these are initial
     change = 1           'conditions
  EndIf
  a$ = ""
  For jj = ll + 1 To ul   'throw away 1st start bit
    duration = a(jj)
    If duration = 0 Then
     If change = 0 And phase = 1 Then a$ = a$ + "1"
     If change = 1 And phase = 1 Then a$ = a$ + "0"
     phase = Not(phase)
    EndIf
    If duration = 1 Then
     change = Not(change)
     If change = 0 Then a$ = a$ + "0"
     If change = 1 Then a$ = a$ + "1"
    EndIf
  Next jj
  If phase = 0 Then GoTo exit2
  If change = 1 Then
     a$ = a$ + "0"
  Else
      a$ = a$ + "1"
  EndIf

exit2:
  code = Val("&B" + Right$(a$,6)) + 1   'this makes code 1 more than key pressed
  toggle = Val("&B" + Mid$(a$,2,1))
  device = Val("&B" + Mid$(a$,3,5))
End Sub

Error1:
  i = 1
  For jj = 1 To 10
    Pin(18) = i:Pause 100:i = Not(i)
  Next jj
  Pin(18) = 0
GoTo idle

tv:
  devicecode = 0:Return
sat1:
  devicecode = 8:Return
sat2:
  devicecode = 10:Return
cd:
  devicecode = 20:Return



                                                                                                           