
; new version (2013) smaller size, analog adjustments
; and better changes 
 
; automatic input sensing
; adjustable update 

; CPU configuration
	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc


;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB3 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _HS_OSC

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF
; Define variables at memory locations


EEPROM0		equ	H'00'	; non-volatile storage for pullup/down/sensitivity  RA4,3,2


; Define variables at memory locations

; RAM

FLAG_0		equ	H'20'	; overrange flag
FLAG_I		equ	H'21'	; recount flag
AUTO_SET_FLG equ H'22'	; autoset flag
EDGE_INT	equ	H'23'	; edge interrupt flag
COUNT1		equ	H'24'	; input counter ls byte
COUNT2		equ	H'25'	; input counter ms byte
COUNT3		equ	H'26'	; latched input counter ls byte
COUNT4		equ	H'27'	; latched input counter ms byte
COUNT5		equ	H'28'	; half way ls byte High Level
COUNT6		equ	H'29'	; half way ms byte High Level
COUNT7		equ	H'2A'	; halfway counter ls byte Low Level from count5
COUNT8		equ	H'2B'	; halfway counter ms byte Low Level from count6
COUNT9		equ	H'2C'	; output counter ls byte Low Level from calc1
COUNT10		equ	H'2D'	; output counter ms byte Low Level from calc2
CALC1		equ	H'2E'	; calculated value ls byte
CALC2		equ	H'2F'	; calculated value ms byte
COUNTA		equ	H'30'	; 1/4 way ls byte High Level
COUNTB		equ	H'31'	; 1/4 way ms byte High Level
COUNT11		equ	H'32'	; 1/4 way counter ls byte Low Level from counta
COUNT12		equ	H'33'	; 1/4 way counter ms byte Low Level from countb
COUNTC		equ	H'34'	; 3/4 way ls byte High Level
COUNTD		equ	H'35'	; 3/4 way ms byte High Level
COUNT13		equ	H'36'	; 3/4 way counter ls byte Low Level from countc
COUNT14		equ	H'37'	; 3/4 way counter ms byte Low Level from countd
COUNTE		equ	H'38'	; output running counter ls
COUNTF		equ	H'39'	; output running counter ms
FAST_SLOW	equ	H'3A'	; fast/ slow correction
TEMP_C		equ	H'3B'	; calculation divisor or numerator
JUMPER		equ	H'3C'	; storage of settings
DELCNT		equ	H'3D'	; delay loop
VALUE_1		equ	H'3E'	; delay counter
VALUE_2		equ	H'3F'	; delay counter
AUTO_COUNT	equ	H'40'	; counter of input pulses for automatic setup
SET_FLG		equ	H'41'	; automatic setting flag (for completed indication)

MIN_RANGE	equ	H'43'	; duration to stop signal
CHANGES		equ	H'44'	; autoset change value
A_D_CYCLE	equ	H'45'	; counter for A to D rate
AVERAGE1	equ	H'46'	; average counter for Adjust trimpot ms byte
AVERAGE2	equ	H'47'	; average counter for Adjust trimpot ls byte
AVG_CNTR	equ	H'48'	; counter for readings
		
; math routines

TEMPB1      equ H'62'
TEMPB0      equ H'63'
TEMPD       equ H'64'    ; temporary storage
AARGB3		equ	H'65'
AARGB2      equ H'66'
AARGB1      equ H'67'
AARGB0      equ H'68'	; most significant byte of argument A
    
BARGB1      equ H'69'
BARGB0      equ H'6A'	; most significant byte of argument B
    
REMB1       equ H'6B'
REMB0       equ H'6C'   ; most significant byte of remainder
LOOPCOUNT   equ H'6D'   ; loop counter
STO1	    equ	H'6E'	; AARGB1 storage


; All Banks RAM

W_TMP		equ	H'70'	; storage of w before interrupt
STATUS_TMP	equ	H'71'	; status storage before interrupt
TEMPZ		equ	H'72'	; temporary 

; preprogram EEPROM DATA 
	
	ORG     2100
	DE	B'00000000'		; RA4 pullup if high, RA3 pulldown if high, RA2 input more sensitive if open 
	
; define reset and interrupt vector start addresses

	org	0	 		 	; start at address 0000h
	goto	MAIN		; normal service routines from Reset vector
	org     4			; interrupt vector 0004h, start interrupt routine here


; INTERRUPT
; counts time between pulses
; start interrupt by saving w and status registers before altered by interrupt routine

INTERRUPT	
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 

	bcf		STATUS,RP0	; select bank 0
	bcf		STATUS,RP1	; select bank 0

	bcf		INTCON,TMR0IF	; clear timer interrupt flag
				; freq is approx 20MHz/4/256-220/(4) ~ 34kHz
	
	movlw	D'220'		; speed up timer interrupt rate 
	movwf	TMR0

	btfsc	FLAG_0,2	; overrange flag
	bcf		PORTB,1		; output low on overrange

; count between positive edges
CNT_P
	btfss	INTCON,INTF	; Intcon INTF flag set on edge detect on RB0 (see option register)
	goto	COUNT		; not so bypass
	bsf		EDGE_INT,0
	 
; automatic setup input record
	incf	AUTO_COUNT,w; 
	btfss	STATUS,Z	; if at maximum (FF) or zero when incremented by 1 stop increasing
	incf	AUTO_COUNT,f; increase if not at maximum
	btfsc	AUTO_SET_FLG,0
	goto	RECLAIM		; bypass on autoset

XFER
	bcf		FLAG_0,3
	movf	COUNT1,w
	movwf	COUNT3		; latch value for processing
	movf	COUNT2,w
	movwf	COUNT4		; latch value for processing
; Check range

	bcf		STATUS,C
	rrf		MIN_RANGE,w
	subwf	COUNT2,w
	btfss	STATUS,C	; overrange if over
	bcf		FLAG_0,2	; clear when below overflow

CLR_CNT
	clrf	FLAG_I		; count repeat flag
	clrf	COUNT1
	incf	COUNT1,f
	clrf	COUNT2		; clear for recount
	bcf		FLAG_0,0	; clear overrange flag
	goto	CHEK_CT

COUNT_S
	bsf		FLAG_I,0	; increment to indicate next count
COUNT
	btfsc	FLAG_0,3	; if overrange stop count
	goto	RECLAIM		; 
	incfsz	COUNT1,f	; increment least significant byte
	goto	CHEK_CT 	; check count value
	incf	COUNT2,f	; if zero flag overrange

; check range
	movf	MIN_RANGE,w
	subwf	COUNT2,w
	btfss	STATUS,C	; overrange if over
;	btfss	COUNT2,6
	goto	CHEK_CT 	; check count value
	bsf		FLAG_0,0	; flag set if overrange	
	bsf		FLAG_0,1	; set valid flag
	bsf		FLAG_0,2
	bsf		FLAG_0,3
	bcf		PORTB,1		; output low
	goto	RECLAIM

; check counter
 
; one counter gives the low output and second gives high output duration
 
CHEK_CT
	btfss	FLAG_0,2	; overrange flag
;	btfss	FLAG_0,1	; valid flag
	goto	DIV_2
	bcf		PORTB,1		; output low
	goto	RECLAIM		; not valid so out

DIV_2
	incfsz	COUNTE,f	; increment least significant byte
	goto	COMP	 	; check count value
	incf	COUNTF,f	; 
COMP
	movf	COUNTE,w	; ls counter
	xorwf	COUNT9,w
	btfss	STATUS,Z	; if the same check ms byte
	goto	CHK_HL2
	movf	COUNTF,w	; ms counter
	xorwf	COUNT10,w
	btfss	STATUS,Z	; if equal reset values
	goto	CHK_HL2
	btfss	FLAG_0,2
	bsf		PORTB,1		; output high
	
; transfer calculated values

	clrf	COUNTE		; reset counter
	clrf	COUNTF
	movf	CALC2,w 	; ms counter byte full output
	movwf	COUNT10
	movf	CALC1,w
	movwf	COUNT9
	
	movf	COUNT6,w	; ms counter byte halfway count
	movwf	COUNT8
	movf	COUNT5,w
	movwf	COUNT7

	movf	COUNTB,w	; ms counter byte 1/4 way count
	movwf	COUNT12
	movf	COUNTA,w
	movwf	COUNT11

	movf	COUNTD,w	; ms counter byte 3/4 way count
	movwf	COUNT14
	movf	COUNTC,w
	movwf	COUNT13
	goto	RECLAIM

CHK_HL2	
	movf	COUNTE,w	; ls counter
	xorwf	COUNT7,w
	btfss	STATUS,Z	; if the same check ms byte
	goto	RECLAIM
	movf	COUNTF,w	; ms counter
	xorwf	COUNT8,w
	btfsc	STATUS,Z	; if equal reset values
	bcf		PORTB,1		; output low

; end of interrupt reclaim w and status 

RECLAIM	
	btfsc	EDGE_INT,0
	bcf		INTCON,INTF	; clear interrupt flag
	bcf		EDGE_INT,0
	btfsc	FLAG_0,2	; overrange flag
	bcf		PORTB,1		; output low
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register

	retfie
;********************************************************************************************** 
  	
; RESET		
; Set ports A & B

MAIN
	clrf	COUNT1
	clrf	COUNT2
	clrf	COUNT3
	clrf	COUNT4
	clrf	COUNT5
	clrf	COUNT6
	clrf   	A_D_CYCLE	; counter for A to D rate
	bsf		FLAG_0,0	; overrange flag
	bsf		FLAG_0,1	; valid flag
	clrf	FLAG_I		; extra count flag
	clrf	AUTO_SET_FLG	; auto set flag
	clrf	SET_FLG		; auto set flag cleared

	movlw	D'9'
	movwf	AVG_CNTR
	clrf	AVERAGE1
	clrf	AVERAGE2

; Setup ports, A/D, PWM etc

	movlw	B'00000000'	; RA oputputs low
	movwf	PORTA
	movwf	PORTB

	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'10110101'	; inputs/outputs
	movwf	TRISB		; port B data direction register
	movlw	B'01000001'	; 01000001 for 20MHz 
	movwf	OPTION_REG	; TMRO prescaler 4 division, PORTB pullups enabled
	movlw   B'00000111'	; RA2 input, RA0,1 input/analog
	movwf   TRISA		; A port data direction register

; analog inputs, A/D

	movlw	B'00000011'	; AN0,1 analog inputs
	movwf	ANSEL
	movlw	B'01000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'10000000'	; Fosc, channel 0 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on

; pwm set
	bsf		STATUS,RP0	; memory bank 1
	movlw	H'FE'
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	movlw	H'00'		; 0% duty 
	movwf	CCPR1L		; ms byte of PWM
	movlw	B'00000000'
	movwf	T2CON
	bsf		T2CON,2		; enable timer 2
	movlw	B'00111100'	; set PWM mode
	movwf	CCP1CON		; enable PWM operation

; allow interrupts
ALL_INTER
	bcf		INTCON,TMR0IF
	bcf		EDGE_INT,0
	bsf		INTCON,TMR0IE	; set interrupt enable for timer
	bsf		INTCON,GIE	; set global interrupt enable 

; check JP2 selections
; check if autoset
	btfss	PORTB,2		; if low autoset
	goto	AUTO_SET

; AC
	btfss	PORTB,4	
	goto	NO_PULLUP_DN; 

; pull down
	btfss	PORTB,7
	goto	PULL_DN		;

; pull up
	btfss	PORTB,5
	goto	PULL_UP		;

; if no jumpers, use EEPROM values

	movlw	EEPROM0		; read stored/preprogrammed settings
	call	EEREAD		; sets EEADR, data in w
	movwf	JUMPER		; stores jumper settings

; AC
	btfss	JUMPER,4	
	goto	AC			; stored selection for AC with or without RA2 

; pull down
	btfss	JUMPER,7
	goto	PULL_DN		;

; pull up
	btfss	JUMPER,5
	goto	PULL_UP		;


AC
	bcf		PORTA,4		; Q3 off no pullup
	nop
	bcf		PORTA,3		; Q2 off no pulldown
; check if low sensitivity
	btfss	JUMPER,7	; if set then high sensitivity
	goto	LOW_SENS
; high sensitivity, RA2 is set as an input
HI_SENS
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00000111'	; RA2 input, RA0,1 input/analog
	movwf   TRISA		; A port
	bcf		STATUS,RP0	; select memory bank 0
	goto	DO_CALC
LOW_SENS
; low sensitivity, RA2 is set as a low output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00000011'	; RA2 output, RA0,1 input/analog
	movwf   TRISA		; A port
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PORTA,2
	goto	DO_CALC

; no pullup or pulldown resistors
NO_PULLUP_DN
	bcf		PORTA,4		; Q3 off no pullup
	nop
	bcf		PORTA,3		; Q2 off no pulldown
; check if low sensitivity
	btfss	PORTB,7		; if set then high sensitivity
	goto	LOW_SENS
	goto	HI_SENS

; pull down resistor
PULL_DN
; pull down and low sensitivity, RA2 is set as a low output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00000011'	; RA2 output, RA0,1 input/analog
	movwf   TRISA		; A port
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PORTA,4	
	nop
	bcf		PORTA,2
	nop		 
	bsf		PORTA,3
	 
	goto	DO_CALC

; pullup resistor
PULL_UP
; pull up and low sensitivity, RA2 is set as a low output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00000011'	; RA2 output, RA0,1 input/analog
	movwf   TRISA		; A port
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PORTA,2		; 
	nop
	bcf		PORTA,3
	nop
	bsf		PORTA,4		; 
	goto	DO_CALC

; Automatic setup of input (clear AUTO_COUNT, delay check if auto count > 20)
AUTO_SET
	bsf		AUTO_SET_FLG,0
	movf	SET_FLG,w	; is flag set
	btfss	STATUS,Z	; if zero continue
	goto	ACK_AUTOSET	; acknowledge auto set

; start by setting MIN_RANGE to maximum timeout

	clrf	MIN_RANGE
	bsf		MIN_RANGE,7	; bit 7 sets one second timeout

; red LED on
	movlw	H'00'		; 0% duty 
	movwf	CCPR1L		; ms byte of PWM
	bsf		PORTB,6

; set no pullup/down	
CHANGE_1				; next setting
	bcf		PORTA,4		; no pullup
	nop
	bcf		PORTA,3		; no pulldown
	nop
	bcf		PORTA,2		; low sensitivity
; set RA2 as an output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00000011'	; RA2 output, RA0,1 input/analog
	movwf   TRISA		; A port
	bcf		STATUS,RP0	; select memory bank 0

	clrf	AUTO_COUNT	; clear counter
	call	DELAY		; wait and check counter
	movf	AUTO_COUNT,w; count value
	sublw	D'20'		; 
	btfsc	STATUS,C	; if c is 0 then negative and w >20
	goto	CHANGE_2	; next setting
; this setting is good. Save setting and set flag so do not keep changing
	bsf		SET_FLG,0	; set bit to stop auto set
	movlw	D'01'		; change 1
	goto	ACK_AUTOSET

; ac
CHANGE_2
	bcf		PORTA,4		; no pullup
	nop
	bcf		PORTA,3		; no pulldown
; set RA2 as input
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00000111'	; RA2 input, RA0,1 input/analog
	movwf   TRISA		; A port
	bcf		STATUS,RP0	; select memory bank 0

	clrf	AUTO_COUNT	; clear counter
	call	DELAY		; wait and check counter
	movf	AUTO_COUNT,w; count value
	sublw	D'20'		; 
	btfsc	STATUS,C	; if c is 0 then negative and w >20
	goto	CHANGE_3	; next setting
; this setting is good. Save setting and set flag so do not keep changing
	bsf		SET_FLG,0	; set bit to stop auto set
	movlw	D'02'		; change 2
	goto	ACK_AUTOSET

; set pullup
CHANGE_3				; next setting
	bcf		PORTA,3		; no pulldown
	nop
	bcf		PORTA,2		; low sensitivity
	nop
	bsf		PORTA,4		; pullup
	
; set RA2 as an output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00000011'	; RA2 output, RA0,1 input/analog
	movwf   TRISA		; A port
	bcf		STATUS,RP0	; select memory bank 0

	clrf	AUTO_COUNT	; clear counter
	call	DELAY		; wait and check counter
	movf	AUTO_COUNT,w; count value
	sublw	D'20'		; 
	btfsc	STATUS,C	; if c is 0 then negative and w >20
	goto	CHANGE_4	; next setting
; this setting is good. Save setting and set flag so do not keep changing
	bsf		SET_FLG,0	; set bit to stop auto set
	movlw	D'03'		; change 3
	goto	ACK_AUTOSET

; set pulldown
CHANGE_4				; next setting
; initially set RA2 as an input
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00000111'	; RA2 input, RA0,1 input/analog
	movwf   TRISA		; A port
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PORTA,4		; no pullup
	nop
	bsf		PORTA,3		; pulldown

	clrf	AUTO_COUNT	; clear counter
	call	DELAY		; wait and check counter
	movf	AUTO_COUNT,w; count value
	sublw	D'20'		; 
	btfsc	STATUS,C	; if c is 0 then negative and w >20
	goto	ERROR_AUTO

; this setting is good. Save setting and set flag so these do not keep changing
	bsf		SET_FLG,0	; set bit to stop auto set
; set RA2 as an output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00000011'	; RA2 output, RA0,1 input/analog
	movwf   TRISA		; A port
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PORTA,2		; low output
	movlw	D'04'		; change 4
	goto	ACK_AUTOSET

ERROR_AUTO
; show RED LED
	movlw	H'00'		; 0% duty 
	movwf	CCPR1L		; ms byte of PWM
	bsf		PORTB,6		; red LED on
	goto	ALL_INTER	; restart

ACK_AUTOSET
; acknowledge end of auto set
; show green LED
	movwf	CHANGES		; store autoset changes value
DO_ACK
	movlw	H'FF'		; 100% duty 
	movwf	CCPR1L		; ms byte of PWM
	bcf		PORTB,6		; green LED on	
	movlw	D'25'		; delay
	call	DELAY_1

; check if autoset link is in
	btfsc	PORTB,2		; if low autoset
	goto	STORE
	bsf		PORTB,6
	movlw	D'25'		; delay
	call	DELAY_1
	goto	DO_ACK	

; store in EEPROM as an equivalent JP2 connection
; pullup/pulldown/AC/+low sensitivity
STORE	
	movlw	EEPROM0		; read stored/preprogrammed settings
	call	EEREAD		; sets EEADR
	
; CHANGES
	movf	CHANGES,w
	xorlw	D'01'
	btfsc	STATUS,Z	
	goto 	CHANGES1
	movf	CHANGES,w
	xorlw	D'02'
	btfsc	STATUS,Z	
	goto 	CHANGES2
	movf	CHANGES,w
	xorlw	D'03'
	btfsc	STATUS,Z	
	goto 	CHANGES3
	
CHANGES4
	movlw	B'01111111'	; pulldown RB7
	goto	STORE_X
CHANGES3
	movlw	B'11011111'	; pullup RB5
	goto	STORE_X
CHANGES2
	movlw	B'11101111'	; AC high sensitivity
	goto	STORE_X
CHANGES1
	movlw	B'01101111'	; AC low sensitivity

STORE_X
	call	EEWRITE		; write to EEPROM
	clrf	AUTO_SET_FLG	; auto set flag

; calculations
DO_CALC
; alternate readings and set up the A/D inputs ready for the next reading	
	movf	A_D_CYCLE,w	; counter for A to D rate
	incf	A_D_CYCLE,f	; increase
	btfsc	STATUS,Z	; when zero read adjust pot
	goto	RD_ADJ
; when 127 read response pot

	movf	A_D_CYCLE,w	; counter for A to D rate
	xorlw	D'127'
	btfss	STATUS,Z
	goto	CALC

; read response pot 

;	read VR2, AN1
	movlw	B'10001000'	; Fosc, channel 1 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	call	ACQUIRE_AD
; set for AN0
	movlw	B'10000000'	; Fosc, channel 0 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on 

	bcf		STATUS,C
	rrf		ADRESH,f	; shift right
	clrf	MIN_RANGE
; 0-25
	movf	ADRESH,w
	sublw	D'25'
	btfsc	STATUS,C	; if positive set bit 7
	goto	SET_7
; 25-50
	movf	ADRESH,w
	sublw	D'50'
	btfsc	STATUS,C	; if positive set bit 6
	goto	SET_6
; 50-75
	movf	ADRESH,w
	sublw	D'75'
	btfsc	STATUS,C	; if positive set bit 4
	goto	SET_5
; 75-100
	movf	ADRESH,w
	sublw	D'100'
	btfsc	STATUS,C	; if positive set bit 4
	goto	SET_4
; 100-127

; place into bits 7,6,5,4,3 of MIN_RANGE
	bsf		MIN_RANGE,3
	goto	CALC		
SET_4
	bsf		MIN_RANGE,4
	goto	CALC
SET_5
	bsf		MIN_RANGE,5
	goto	CALC
SET_6
	bsf		MIN_RANGE,6
	goto	CALC
SET_7
	bsf		MIN_RANGE,7
	goto	CALC

; read adjustment setting
RD_ADJ
	incf	A_D_CYCLE,f	; increase
;	read VR1, AN0
	movlw	B'10000000'	; Fosc, channel 0 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	call	ACQUIRE_AD
; set for AN1
	movlw	B'10001000'	; Fosc, channel 1 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on 

	movf	ADRESH,w
	movwf	CCPR1L		; ms byte of PWM
	bsf		STATUS,RP0	; select memory bank 1
	clrf	TEMPZ
	btfsc	ADRESL,7	; if bit 7 is set, set
	bsf		TEMPZ,7
	bcf		STATUS,RP0	; bank 0
	btfss	TEMPZ,7
	goto	CLR_BIT
	bsf		CCP1CON,5	; ls bit
	goto	INV_SENSE
CLR_BIT
	bcf		CCP1CON,5	; ls bit

INV_SENSE
; invert sense
	comf	ADRESH,f
	bsf		STATUS,RP0	; select memory bank 1
	btfsc	ADRESL,7	; if bit 7 is set, clear
	goto	CLR_LOW
	bsf		ADRESL,7
	bcf		STATUS,RP0	; bank 0
	goto	OUT_LOW
CLR_LOW
	bcf		ADRESL,7
	bcf		STATUS,RP0	; bank 0

OUT_LOW	
; if 127 or 128 drive RB6 as square wave
	movf	ADRESH,w
	xorlw	D'127'
	btfsc	STATUS,Z
	goto	SQ_B6
	movf	ADRESH,w
	xorlw	D'128'
	btfss	STATUS,Z
	goto	LED_DET
SQ_B6
	btfss	PORTB,6
	goto	SET_B6
	bcf		PORTB,6

; mid setting use calculation with 254 as numerator or denominator
	movlw	D'254'
	movwf	TEMP_C		; store
	clrf	FAST_SLOW
	goto	CALC
SET_B6
	bsf		PORTB,6

; mid setting use calculation with 254 as numerator or denominator
	movlw	D'254'
	movwf	TEMP_C		; store
	clrf	FAST_SLOW
	goto	CALC

LED_DET
; if ADRESH,7 is set then set RB6
	btfsc	ADRESH,7
	goto	B6_SET
	bcf		PORTB,6
	goto	SORT_MD
B6_SET
	bsf		PORTB,6

SORT_MD  
; find multiplier/divisor 
	clrf	FAST_SLOW	
; set/clear FAST_SLOW,0 (set for faster, clear for slower)
	btfsc	ADRESH,7	; if set then set fast_slow,0
	bsf		FAST_SLOW,0
	bcf		ADRESH,7	; remove msb (used as sign bit)

	bsf		STATUS,RP0	; select memory bank 1
	bcf		STATUS,C
	btfsc	ADRESL,7	; if bit 7 is set set carry
	bsf		STATUS,C
	bcf		STATUS,RP0	; bank 0
; use 9-bits of A/D
	rlf		ADRESH,f
; if bit FAST_SLOW,0 is not set then complement the value
	btfsc	FAST_SLOW,0
	comf	ADRESH,f
	movf	ADRESH,w	; 
	movwf	TEMP_C		; store

; ** LIMIT 
; set limit for divide/multiply
	movf	TEMP_C,w	; numerator or denominator value into or by 254 
	sublw	D'42'
	btfss	STATUS,C	; if minus ok otherwise set at 42 (254/42 = 6x) (42/254 = 1/6)
	goto	CALC
	movlw	D'42'
	movwf	TEMP_C



; update value
; multiply by 254 depending on if for faster or slower output rate
; divide by 254
; 
	
CALC

	clrf	AARGB0		; clear
	btfss	FAST_SLOW,0	; if set faster rate
	goto	SLWR
	movlw	D'254'		; 
	movwf	AARGB1
	goto	STP_INT
SLWR
	movf	TEMP_C,w	; divisor
	movwf	AARGB1
	
; check if interrupt about to occur

STP_INT	
	movf	TMR0,w		; look at timer 
	sublw	D'240'		; only proceed when timer less than 240 as interrupt could occur 	
						; when transferring data
	btfss	STATUS,C	; if c = 0 then timer greater than 240
	goto	STP_INT		;
	bcf		INTCON,GIE
	movf	COUNT3,w	; latched counted value
	movwf	BARGB1
	movf	COUNT4,w
	movwf	BARGB0
	bsf		INTCON,GIE
	call	FXM1616U	; multiply 

; shift answer
	movf	AARGB2,w	; second ls byte of result
	movwf	STO1
	movf	AARGB3,w
	movwf	AARGB2
	movf	AARGB1,w
	movwf	AARGB0
	movf	STO1,w
	movwf	AARGB1
	
; load denominator

	btfsc	FAST_SLOW,0	; if set faster rate	
	goto	SLOWR
	movlw	D'254'		; 
	goto	FSTER
SLOWR
	movf	TEMP_C,w	; divisor
FSTER
	movwf	BARGB1
	clrf	BARGB0
	call	FXD2416U	; divide 

SOP_INT
	movf	TMR0,w		; look at timer 
	sublw	D'240'		; only proceed when timer less than 240 as interrupt could occur 	
						; when transferring data
	btfss	STATUS,C	; if c = 0 then timer greater than 240
	goto	SOP_INT		;
	bcf		INTCON,GIE
	movf	AARGB2,w	; move values
	movwf	CALC1
	movf	AARGB1,w
	movwf	CALC2

	bcf		STATUS,C
	rrf		CALC2,w 	; ms counter byte (find halfway count)
	movwf	COUNT6
	rrf		CALC1,w
	movwf	COUNT5

	bcf		STATUS,C
	rrf		COUNT6,w 	; ms counter byte (1/4 way count)
	movwf	COUNTB
	rrf		COUNT5,w
	movwf	COUNTA
	
	movf	COUNTA,w	; subtract 1/4 way from CALC1,2 for 3/4 way
	movwf	BARGB1
	movf	COUNTB,w
	movwf	BARGB0		
	call	D_RSUB		; subtract answer in AARGB	
	
	movf	AARGB2,w	; move values
	movwf	COUNTC
	movf	AARGB1,w
	movwf	COUNTD		; count C & D have 3/4 count
	bsf		INTCON,GIE	
; after calculation, 
; clear valid flag

	bcf		FLAG_0,1	
	goto	DO_CALC


; ********************************************************************************

; delay time 
DELAY1
	movlw	D'10'
	goto	DELAY_1

DELAY
	movlw	D'50'		; number of delay cycles
DELAY_1	
	movwf	DELCNT
	bcf		STATUS,C	; carry cleared 
	rlf		DELCNT,f	; mult by 2 for 20MHz xtal (not for 10MHz)
DELAY_M
	movlw	D'255'		; set delay period 
	movwf	VALUE_1		; VALUE_1 = w
LP_1
	movlw	D'255'		; set delay period value 2 
	movwf	VALUE_2		; VALUE_2 = w
LP_2
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_2
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_1
	decfsz	DELCNT,f
	goto	DELAY_M
	return	

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,2	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return
; subroutine to read EEPROM memory 

EEREAD
	bsf 	STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM

EWRITE
EEWRITE	
	bcf 	STATUS,RP0	; bank 0
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf 	STATUS,RP0	; select memory bank 3

	bcf		INTCON,GIE	; disable interrupts
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit

WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 	STATUS,RP0	; select memory bank 0
	bsf 	INTCON,GIE	; enable interrupts
	return				; value written 
	
	
; 24/16 Bit Unsigned Fixed Point Divide 

;       Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point divisor in BARGB0, BARGB1

;       Use:    CALL    FXD2416U

;       Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point remainder in REMB0, REMB1

;       Result: AARG, REM  <--  AARG / BARG


FXD2416U        CLRF            REMB0
                CLRF            REMB1
                CLRF            TEMPD
                RLF             AARGB0,W
                RLF             REMB1, F
                MOVF            BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                RLF             AARGB0, F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416A      RLF             AARGB0,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46LA
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46LA
UADD46LA        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46LA 		RLF             AARGB0, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416A
                RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46L8
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46L8
UADD46L8        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46L8         RLF             AARGB1, F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416B      RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46LB
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46LB
UADD46LB        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46LB         RLF             AARGB1, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416B
                RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46L16
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46L16
UADD46L16       ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46L16        RLF             AARGB2, F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416C      RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB2,0
                GOTO            UADD46LC
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46LC
UADD46LC        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46LC 		RLF             AARGB2, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416C
                BTFSC           AARGB2,0
                GOTO            UOK46L
                MOVF            BARGB1,W
	        	ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
UOK46L			RETURN
	
; multiply
;
;       Input:  fixed point arguments in AARG and BARG
;
;       Output: product AARGxBARG in AARG
;

;       16x16 Bit Unsigned Fixed Point Multiply 

;       Input:  16 bit unsigned fixed point multiplicand in AARGB0
;               16 bit unsigned fixed point multiplier in BARGB0

;       Use:    CALL    FXM1616U

;       Output: 32 bit unsigned fixed point product in AARGB0



FXM1616U        CLRF    AARGB2          ; clear partial product
                CLRF    AARGB3
                MOVF    AARGB0,W
                MOVWF   TEMPB0
                MOVF    AARGB1,W
                MOVWF   TEMPB1
                MOVLW   H'08'
                MOVWF   LOOPCOUNT
LOOPUM1616A     RRF     BARGB1, F
                BTFSC   STATUS,C
                GOTO    ALUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616A
                MOVWF   LOOPCOUNT
LOOPUM1616B     RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    BLUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616B
                CLRF    AARGB0
                CLRF    AARGB1
                RETLW   H'00'
BLUM1616NAP     BCF     STATUS,C
                GOTO    BLUM1616NA
ALUM1616NAP     BCF     STATUS,C
                GOTO    ALUM1616NA
ALOOPUM1616     RRF     BARGB1, F
                BTFSS   STATUS,C
                GOTO    ALUM1616NA
                MOVF    TEMPB1,W
                ADDWF   AARGB1, F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0, F
ALUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                DECFSZ LOOPCOUNT, F
                GOTO   ALOOPUM1616
                MOVLW  H'08'
                MOVWF  LOOPCOUNT
BLOOPUM1616     RRF    BARGB0, F
                BTFSS  STATUS,C
                GOTO   BLUM1616NA
                MOVF   TEMPB1,W
                ADDWF  AARGB1, F
                MOVF   TEMPB0,W
                BTFSC  STATUS,C
                INCFSZ TEMPB0,W
                ADDWF  AARGB0, F
BLUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                RRF    AARGB3, F
                DECFSZ LOOPCOUNT, F
                GOTO   BLOOPUM1616
                RETURN

; subroutine subtract AARGB1 AARGB2 - BARGB0 BARGB1 = AARGB
	
	
D_RSUB
	call	NEG_A		; complement of A
	movf	BARGB1,w 
	addwf	AARGB2,f 	; add lsb
	btfsc	STATUS,C	; add carry
	incf	AARGB1,f 
	movf	BARGB0,w 
	addwf	AARGB1,f 
	return

NEG_A
	comf	BARGB1,f 
	incf	BARGB1,f 
	btfsc	STATUS,Z
	decf	BARGB0,f 
	comf	BARGB0,f 
	return	

	
	
	end	
