                                          
 
; PC Birdies

; canary bird songs. Dual canaries using two processors. Identical software in each PIC. 


	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_ON & _INTRC_OSC_NOCLKOUT	

; EEPROM
EEPROM0			equ	H'00'	; non-volatile storage for canary sound alternatives

; RAM 

STORE1			equ	H'20'	; delay/ counter	
STORE2			equ	H'21'	; delay/ counter
STORE3			equ	H'22'	; delay/ counter
STORE4			equ	H'23'	; delay/ counter
TIMER1			equ	H'24'	; run timer
TIMER2			equ	H'25'	; run timer
CHECK_COUNT		equ	H'26'	; counter for LDR checking
TEMP			equ	H'27'	; temporary
TIME			equ	H'28'	; multiply burst period timer
TIME1			equ	H'29'	; store for TIME
TIME2			equ	H'2A'	; store for time ending	
VOL_END			equ	H'2B'	; volume at end
BURST_LOUD		equ	H'2C'	; loud burst length
RNDM			equ	H'2D'	; counter random
BURST_SOFT		equ	H'2E'	; soft level burst length
FREQ_SOFT_END	equ	H'2F'	; soft frequency at end
QUIET			equ	H'30'	; quiet flag
FREQ_SOFT		equ	H'31'	; frequency for soft volume
FREQ_LOUD		equ	H'32'	; frequency of main tone volume
FREQ_LOUD_END	equ	H'33'	; end frequency
FREQ_SOFT1		equ	H'34'	; frequency for soft start
FREQ_LOUD1		equ	H'35'	; frequency of main tone volume
SOFT_EXTRA		equ	H'36'	; extra run time of burst
DEL1			equ	H'37'	; delay value counter
VALUE			equ	H'38'	; internal delay value	
PWM				equ	H'39'	; pwm drive 	
WIDTH			equ	H'3A'	; working pwm duty
WIDTH2			equ	H'3B'	; working PWM duty
VOL_MAX			equ	H'3C'	; soft volume
BIRD			equ	H'3D'	; bird type
REPEAT			equ	H'3E'	; number of phrase repeats
TIMER_R			equ	H'3F'	; delay between repeats
REPEAT_STO		equ	H'40'	; repeat store
CYCLE			equ	H'41'	; canary cycles
TEMP_C			equ	H'42'	; temporary store for canary sound
PORT_STATUS		equ	H'43'	; GP4 level
STARTED			equ	H'44'	; started flag 
SYNC_BIRD		equ	H'45'	; syncronise birds counter timer
TIMER_S			equ	H'46'	; timer startup

; preprogram EEPROM DATA 
	
	ORG     H'2100'
	DE		H'00'

; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN
	    			; interrupt vector (not used)
	org		4
; ***********************************************************
		
DEL_VARY	; lookup table for birs sounds
	addwf	PCL,f
	retlw	D'117'
	retlw	D'117'
	retlw	D'115'
	retlw	D'107'
	retlw	D'118'
	retlw	D'104'
	retlw	D'117'
	retlw	D'116'
	retlw	D'116'
	retlw	D'127'
	retlw	D'117'
	retlw	D'115'
	retlw	D'127'
	retlw	D'117'
	retlw	D'115'
	retlw	D'118'
	retlw	D'117'
	retlw	D'117'
	retlw	D'116'
	retlw	D'115'
	retlw	D'117'
	retlw	D'118'
	retlw	D'104'
	retlw	D'117'
	retlw	D'116'
	retlw	D'116'
	retlw	D'117'
	retlw	D'117'
	retlw	D'120'
	retlw	D'117'
	retlw	D'118'
	retlw	D'114'
	retlw	D'117'
	retlw	D'116'
	retlw	D'116'
	retlw	D'117'
	retlw	D'117'
	retlw	D'115'
	retlw	D'117'
	retlw	D'107'
	retlw	D'115'
	retlw	D'118'
	retlw	D'117'
	retlw	D'115'
	retlw	D'127'
	retlw	D'117'
	retlw	D'115'
	retlw	D'118'
	retlw	D'117'
	retlw	D'117'
	retlw	D'115'
	retlw	D'117'
	retlw	D'118'
	retlw	D'114'
	retlw	D'127'
	retlw	D'116'
	retlw	D'116'
	retlw	D'117'
	retlw	D'117'
	retlw	D'115'
	retlw	D'117'
	retlw	D'117'
	retlw	D'115'
	retlw	D'118'

RNDM_VARY	; lookup table
RNDM_START
	addwf	PCL,f
	retlw	D'17'
	retlw	D'19'
	retlw	D'15'
	retlw	D'40'
	retlw	D'22'
	retlw	D'25'
	retlw	D'17'
	retlw	D'16'
	retlw	D'16'
	retlw	D'27'
	retlw	D'17'
	retlw	D'15'
	retlw	D'27'
	retlw	D'17'
	retlw	D'15'
	retlw	D'18'
	retlw	D'17'
	retlw	D'17'
	retlw	D'16'
	retlw	D'15'
	retlw	D'17'
	retlw	D'18'
	retlw	D'43'
	retlw	D'33'
	retlw	D'26'
	retlw	D'36'
	retlw	D'57'
	retlw	D'27'
	retlw	D'17'
	retlw	D'15'
	retlw	D'18'
	retlw	D'17'
	retlw	D'22'
	retlw	D'117'
	retlw	D'120'
	retlw	D'117'
	retlw	D'118'
	retlw	D'44'
	retlw	D'67'
	retlw	D'116'
	retlw	D'116'
	retlw	D'117'
	retlw	D'35'
	retlw	D'117'
	retlw	D'107'
	retlw	D'115'
	retlw	D'118'
	retlw	D'117'
	retlw	D'15'
	retlw	D'17'
	retlw	D'115'
	retlw	D'117'
	retlw	D'118'
	retlw	D'114'
	retlw	D'127'
	retlw	D'116'
	retlw	D'66'
	retlw	D'45'
	retlw	D'54'
	retlw	D'39'
	retlw	D'40'
	retlw	D'34'
	retlw	D'65'
	retlw	D'48'
	retlw	D'55'
RNDM_RPT	; lookup table
	addwf	PCL,f
	retlw	D'5'
	retlw	D'3'
	retlw	D'5'
	retlw	D'4'
	retlw	D'2'
	retlw	D'5'
	retlw	D'7'
	retlw	D'6'
	retlw	D'6'
	retlw	D'7'
	retlw	D'7'
	retlw	D'5'
	retlw	D'7'
	retlw	D'7'
	retlw	D'5'
	retlw	D'8'
	retlw	D'7'
	retlw	D'7'
	retlw	D'6'
	retlw	D'5'
	retlw	D'7'
	retlw	D'8'
	retlw	D'3'
	retlw	D'3'
	retlw	D'6'
	retlw	D'6'
	retlw	D'7'
	retlw	D'17'
	retlw	D'20'
	retlw	D'17'
	retlw	D'18'
	retlw	D'4'
	retlw	D'7'
	retlw	D'16'
	retlw	D'6'
	retlw	D'17'
	retlw	D'22'
	retlw	D'5'
	retlw	D'17'
	retlw	D'7'
	retlw	D'15'
	retlw	D'18'
	retlw	D'17'
	retlw	D'5'
	retlw	D'7'
	retlw	D'7'
	retlw	D'5'
	retlw	D'8'
	retlw	D'7'
	retlw	D'7'
	retlw	D'15'
	retlw	D'17'
	retlw	D'18'
	retlw	D'14'
	retlw	D'20'
	retlw	D'16'
	retlw	D'6'
	retlw	D'5'
	retlw	D'4'
	retlw	D'9'
	retlw	D'2'
	retlw	D'4'
	retlw	D'5'
	retlw	D'8'
	retlw	D'6'
MAIN
; set oscillator calibration
	bsf		STATUS,RP0	; bank 1
	call	H'3FF'		; oscillator calibration value
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0

; set inputs/outputs
	movlw	H'FF'
	movwf	GPIO		; outputs high
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	clrf	ANSEL		; digital I/O
	movlw	B'00000011'	; pullups on/off
	movwf	WPU
	movlw	B'00001101'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'00001111'	; settings (pullups enabled) wdt prescaler/128 (18ms x 128 timeout)
	movwf	OPTION_REG
	bcf		STATUS,RP0	; select memory bank 0

; initial conditions
	bcf		PIR1,EEIF
	movlw	H'FF'
	movwf	GPIO		; outputs high,LDR off,LDR level follow output
 
; let second pic run
	movwf	PORT_STATUS	; status for GPIO,4 set

	movlw	D'5'
	movwf	TEMP
STARTUP
	movlw	D'255'
	call	DELAYX
	decfsz	TEMP,f
	goto	STARTUP

BIRD_SET ; sets bird type

	call	EEPROM_READ
	movwf	BIRD
; GP0 is an input, check level
	btfsc	GPIO,0		; if low, switch is pressed
	goto	OUTPUT0_SET
	incf	BIRD,f		; 0,1 or 2
	movf	BIRD,w
	sublw	D'3'
	btfss	STATUS,C
	clrf	BIRD		; return to 0 when increased to 4
	movf	BIRD,w
	call	EEPROM_WRITE; write to EEPROM
	
WAIT_OPEN ; wait for open switch
	movlw	D'255'
	call	DELAYX
	btfss	GPIO,0
	goto	WAIT_OPEN

OUTPUT0_SET	
; set GP0 as an output and low
	bcf		GPIO,0
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00001100'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	bcf		STATUS,RP0	; select memory bank 0

LDR
	clrf	STARTED			; started flag
	bcf		GPIO,5			; switch on LDR divider
	nop
	nop
	nop	
	nop						; settling time
	btfss	GPIO,2			; LDR level
	goto	LIGHT			; when GPIO,2 is low then daylight
	bsf		GPIO,4			; LDR follow output

; when GPIO,2 is high then darkness so sleep 
; when low then light  

; SLEEP, low power mode
	bsf		GPIO,5			; LDR off

	sleep					; stop operations
	nop
; awakes with watchdog timeout

	goto	LDR				; check LDR level

LIGHT

	bsf		GPIO,5			; LDR off
	bsf		GPIO,4			; LDR follow output

	incf	REPEAT,f
	movf	REPEAT,w
	andlw	B'00111111'	; 64 max
	call	RNDM_RPT	; lookup table
	movwf	REPEAT_STO	; 2 to 20 repeats

; bird?	What type is set
	movf	BIRD,w
	btfsc	STATUS,Z
	goto	CAN_S		; BIRD=0
	movf	BIRD,w
	xorlw	D'1'	
	btfsc	STATUS,Z
	goto	CAN_FIFE	; BIRD=1
	movf	BIRD,w
	xorlw	D'2'	
	btfsc	STATUS,Z
	goto	CAN_X		; BIRD=2
	goto	MEDLEY

CAN_FIFE ;BIRD=0
	call	FIFE_CANARY
	call	RNDM_TMR
; run repeats
	decfsz	REPEAT_STO,f
	goto	CAN_FIFE
	movlw	B'11111111'
	movwf	PORT_STATUS		; GPIO,4 high
	bsf		GPIO,4
	call	RNDM_TMR_EXTRA
	goto	LDR
CAN_X
; select chirping
	movf	CYCLE,w
	andlw	B'00111111'	; 64 max
	call	RNDM_TMR	; lookup table
	movwf	TEMP_C
	btfss	TEMP_C,2
	goto	SEL_CAN_X1	
	btfss	TEMP_C,0
	goto	SEL_CAN_X2
	btfsc	TEMP_C,0
	call	CANARY_X3
	goto	REP_CAN_X
SEL_CAN_X2
	call	CANARY_X2
	goto	REP_CAN_X
SEL_CAN_X1
; run repeats
	call	CANARY_X1
REP_CAN_X	
	call	RNDM_TMR
	decfsz	REPEAT_STO,f
	goto	CAN_X
	movlw	B'11111111'
	movwf	PORT_STATUS		; GPIO,4 high
	bsf		GPIO,4
	call	RNDM_TMR_EXTRA
	incf	CYCLE,f		; change chirping
	goto	LDR
CAN_S
	call	CANARY_S
	call	RNDM_TMR
; run repeats
	decfsz	REPEAT_STO,f
	goto	CAN_S
	movlw	B'11111111'
	movwf	PORT_STATUS		; GPIO,4 high
	bsf		GPIO,4
	call	RNDM_TMR_EXTRA
	goto	LDR

MEDLEY
	incf	REPEAT,f
	movf	REPEAT,w
	andlw	B'00111111'	; 64 max
	call	RNDM_RPT	; lookup table
	movwf	REPEAT_STO	; 2 to 20 repeats
CAN_FIFE_M
	call	FIFE_CANARY
	call	RNDM_TMR
; run repeats
	decfsz	REPEAT_STO,f
	goto	CAN_FIFE_M
	movlw	B'11111111'
	movwf	PORT_STATUS		; GPIO,4 high
	bsf		GPIO,4
	call	RNDM_TMR_EXTRA
;
	incf	REPEAT,f
	movf	REPEAT,w
	andlw	B'00111111'	; 64 max
	call	RNDM_RPT	; lookup table
	movwf	REPEAT_STO	; 2 to 20 repeats
CAN_X_M1
	movf	CYCLE,w
	andlw	B'00111111'	; 64 max
	call	RNDM_TMR	; lookup table
	movwf	TEMP_C
	btfss	TEMP_C,2
	goto	SEL_CAN_X1M1	
	btfss	TEMP_C,0
	goto	SEL_CAN_X2M1
	btfsc	TEMP_C,0
	call	CANARY_X3
	goto	REP_CAN_XM1
SEL_CAN_X2M1
	call	CANARY_X2
	goto	REP_CAN_XM1
SEL_CAN_X1M1
; run repeats
	call	CANARY_X1
REP_CAN_XM1	
	call	RNDM_TMR
	decfsz	REPEAT_STO,f
	goto	CAN_X_M1
	movlw	B'11111111'
	movwf	PORT_STATUS		; GPIO,4 high
	bsf		GPIO,4
	call	RNDM_TMR_EXTRA
	incf	CYCLE,f		; change chirping

;
	incf	REPEAT,f
	movf	REPEAT,w
	andlw	B'00111111'	; 64 max
	call	RNDM_RPT	; lookup table
	movwf	REPEAT_STO	; 2 to 20 repeats
CAN_S_M
	call	CANARY_S
	call	RNDM_TMR
; run repeats
	decfsz	REPEAT_STO,f
	goto	CAN_S_M
	movlw	B'11111111'
	movwf	PORT_STATUS		; GPIO,4 high
	bsf		GPIO,4
	call	RNDM_TMR_EXTRA
;
	incf	REPEAT,f
	movf	REPEAT,w
	andlw	B'00111111'	; 64 max
	call	RNDM_RPT	; lookup table
	movwf	REPEAT_STO	; 2 to 20 repeats
CAN_X_M2
	movf	CYCLE,w
	andlw	B'00111111'	; 64 max
	call	RNDM_TMR	; lookup table
	movwf	TEMP_C
	btfss	TEMP_C,2
	goto	SEL_CAN_X1M2	
	btfss	TEMP_C,0
	goto	SEL_CAN_X2M2
	btfsc	TEMP_C,0
	call	CANARY_X3
	goto	REP_CAN_XM2
SEL_CAN_X2M2
	call	CANARY_X2
	goto	REP_CAN_XM2
SEL_CAN_X1M2
; run repeats
	call	CANARY_X1
REP_CAN_XM2	
	call	RNDM_TMR
	decfsz	REPEAT_STO,f
	goto	CAN_X_M2
	movlw	B'11111111'
	movwf	PORT_STATUS		; GPIO,4 high
	bsf		GPIO,4
	call	RNDM_TMR_EXTRA
	incf	CYCLE,f		; change chirping
	goto	LDR

; random timers 

; REPEATS	; number of phrase repeats
; TIMER_R	; time between repeats
RNDM_TMR

; run timer_R
	incf	TIMER_R,f
	movf	TIMER_R,w
	andlw	B'00111111'	; 64 max
	call	RNDM_VARY	; lookup table (17 to 127)
	movwf	STORE3
; divide by 16 for 2.4s to 17s
	bcf		STATUS,C
	rrf		STORE3,f
	bcf		STATUS,C
	rrf		STORE3,f
	bcf		STATUS,C
	rrf		STORE3,f
	bcf		STATUS,C
	rrf		STORE3,f
	incf	STORE3,f	; prevent a 0
	
	btfsc	STARTED,0	; if started is set bypass checking LDR
	goto	LOOPX_R1
LOOPX_R
	bcf		GPIO,5			; switch on LDR divider
	nop
	nop
	nop	
	nop						; settling time
	btfss	GPIO,2			; LDR level
	goto	LOOPX_R1		; when GPIO,2 is low then daylight
	bsf		GPIO,4			; LDR follow output
	bsf		PORT_STATUS,4
; when GPIO,2 is high then darkness so sleep 
; when low then light  

; SLEEP, low power mode
	bsf		GPIO,5			; LDR off
	movlw	D'1'
	movwf	STORE3			; end the timer
	sleep					; stop operations wait for watchdog
	nop
	goto	LOOPX_R
LOOPX_R1
; random start delay
	incf	TIMER_S,f
	movf	TIMER_S,w
	andlw	B'00111111'	; 64 max

	call	RNDM_START	; lookup table (17 to 127)
	movwf	SYNC_BIRD

; divide 
	bcf		STATUS,C
	rrf		SYNC_BIRD,f	; 8 to 64
	bcf		STATUS,C
	rrf		SYNC_BIRD,f; 4 to 32
	bcf		STATUS,C
	rrf		SYNC_BIRD,f; 2 to 16


LOOP_SYNC
	movlw	D'255'
	call	DELAYX		; 173ms
	decfsz	SYNC_BIRD,f
	goto	LOOP_SYNC

	bsf		STARTED,0		; sound running
	bsf		GPIO,5			; LDR off
;	bsf		GPIO,4			; LDR follow output
LOOPX_R11
	sleep					; 2.3s till watchdog timeout
	nop
	decfsz	STORE3,f
	goto	LOOPX_R11
	bsf		STARTED,0		; sound running
	return

RNDM_TMR_EXTRA

; time between repeats
; 17 to 127 or equivalent to 39s to 4.6m 
	incf	DEL1,f
	movf	DEL1,w
	andlw	B'00111111'	; 64 max
	call	RNDM_VARY	; lookup table
	movwf	STORE3
	bcf		STATUS,C
	rlf		STORE3,f

; multiply by 2 for 80s to 9minutes

LOOPX_RX1
	bcf		GPIO,5			; switch on LDR divider
	nop
	nop
	nop	
	nop						; settling time
	btfss	GPIO,2			; LDR level
	goto	LOOPX_R1C		; when GPIO,2 is low then daylight
	bsf		GPIO,4			; LDR follow output

; when GPIO,2 is high then darkness so sleep 
; when low then light  

; optional reset timer for second IC
	movlw	D'1'
	movwf	STORE3

; SLEEP, low power mode
	bsf		GPIO,5			; LDR off
	movlw	D'1'
	movwf	STORE3			; end the timer
	sleep					; stop operations wait for watchdog
	nop
	goto	LOOPX_RX1
LOOPX_R1C

	bsf		GPIO,5			; LDR off
	bsf		GPIO,4			; simulate LDR in darkness to sync the second IC
LOOPX_R1C1
	sleep
	nop
	decfsz	STORE3,f
	goto	LOOPX_R1C1
	return

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; CANARY SOUNDS
FIFE_CANARY
; WORD1. High level (LOUD)
	
;	movlw	H'FF'
;	movwf	PORT_STATUS

; let second pic run
	movlw	B'11101111'
	movwf	PORT_STATUS		; GPIO,4 low


	clrwdt
	bsf		GPIO,5			; LDR off
	
	movlw	D'3'			; burst number 
	movwf	STORE3			; 
	call	CHIRP_W1F
	goto	DEL_FIFE_1

CHIRP_W1F
	movlw	D'85'
	movwf	BURST_LOUD		; burst length	

; set frequency
	movlw	D'12'			; main frequency
	movwf	FREQ_LOUD
	movlw	D'15'			; 
	movwf	FREQ_LOUD_END	; ending frequency
	call	GENERATOR_LOUD	; kHz tone 

; CHIRP_GAP
	movlw	D'70'			; gap 30ms	
	call	DELAYX

; 2nd burst
	movlw	D'180'			; burst length 110ms
	movwf	BURST_LOUD		; individual burst length
; set frequency
	movlw	D'25'			; 2.8kHz
	movwf	FREQ_LOUD
	movlw	D'25'			; 
	movwf	FREQ_LOUD_END	
	call	GENERATOR_LOUD	; kHz tone (uses STORE1)

	movlw	D'200'			; gap 90ms	
	call	DELAYX


	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W1F
	return

DEL_FIFE_1
;	movlw	D'200'			; gap 136ms	
;	call	DELAYX
	movlw	D'100'			; total gap 136ms
	call	DELAYX

; WORD2
W2F
	movlw	D'17'			; burst number 
	movwf	STORE3			; 
	call	CHIRP_W2F
	goto	DEL_FIFE2
CHIRP_W2F

	movlw	D'70'			; burst length 30ms
	movwf	BURST_LOUD		; individual burst length
; set frequency
	movlw	D'12'			; 4.5kHz
	movwf	FREQ_LOUD
	movlw	D'15'			; 
	movwf	FREQ_LOUD_END	
	call	GENERATOR_LOUD		; kHz tone (uses STORE1)

; CHIRP_GAP
	incf	RNDM,f			; counter
	movf	RNDM,w
	andlw	B'00111111'		; 6-bits for 64 max
	movwf	RNDM
	call	DEL_VARY
	movwf	TEMP
	bcf		STATUS,C
	rrf		TEMP,w			; divide by 2 ~ D'65'	; gap 30ms	
	call	DELAYX

	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W2F
	return
DEL_FIFE2
	movlw	D'146'			; total gap 90ms	
	call	DELAYX


; WORD3

W3F
	movlw	D'3'			; burst number 
	movwf	STORE3			; 
CHIRP_W3F
	movlw	D'150'			; burst length 65ms
	movwf	BURST_LOUD		; individual burst length
; set frequency
	movlw	D'12'			; 4.5kHz
	movwf	FREQ_LOUD
	movlw	D'13'			; 
	movwf	FREQ_LOUD_END	
	call	GENERATOR_LOUD		; kHz tone (uses STORE1)

; CHIRP_GAP
	movlw	D'220'			; gap 90ms	
	call	DELAYX

	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W3F

	movlw	D'150'			; burst length 65ms
	movwf	BURST_LOUD		; individual burst length
; set frequency
	movlw	D'12'			; 4.5kHz
	movwf	FREQ_LOUD
	movlw	D'13'			; 
	movwf	FREQ_LOUD_END	
	call	GENERATOR_LOUD		; kHz tone (uses STORE1)

	movlw	D'183'			; gap 75ms	
	call	DELAYX

W4F
	movlw	D'4'			; burst number 
	movwf	STORE3			; 4 bursts 
CHIRP_W4F
	movlw	D'240'			; burst length 165ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	D'6'			; 
	movwf	FREQ_SOFT
	movlw	D'7'			; 
	movwf	FREQ_SOFT_END	
	movlw	D'5'
	movwf	VOL_MAX
	movlw	D'4'
	movwf	VOL_END
	call	GENERATOR_SOFT		; kHz tone (uses STORE1)

; CHIRP_GAP

	movlw	D'160'			; gap 65ms	
	call	DELAYX

	decfsz	STORE3,f		; run 4 bursts
	goto	CHIRP_W4F

	movlw	D'44'			; total gap 85ms	
	call	DELAYX

;	return

; word 5
W5F
	movlw	D'14'			; burst number 
	movwf	STORE3			; bursts per chirp
CHIRP_W5F
	movlw	D'8'			; burst length 32ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	D'13'			; 4.5kHz
	movwf	FREQ_SOFT
	movlw	D'15'			; 
	movwf	FREQ_SOFT_END	
	movlw	D'3'
	movwf	VOL_MAX
	movlw	D'5'
	movwf	VOL_END
	call	GENERATOR_SOFT		; kHz tone (uses STORE1)

;	return
; CHIRP_GAP

	movlw	D'75'			; gap 35ms	
	call	DELAYX

	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W5F

; second chirps with altered frequency

	movlw	D'7'			; burst number 
	movwf	STORE3			; bursts per chirp
CHIRP_W5F2
	movlw	D'7'			; burst length 32ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	D'14'			; 4.5kHz
	movwf	FREQ_SOFT
	movlw	D'15'			; 
	movwf	FREQ_SOFT_END	
	movlw	D'3'
	movwf	VOL_MAX
	movlw	D'5'
	movwf	VOL_END
	call	GENERATOR_SOFT		; kHz tone (uses STORE1)


; CHIRP_GAP

	movlw	D'75'			; gap 35ms	
	call	DELAYX

	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W5F2
; 130ms delay

	movlw	D'220'			; total gap 130ms	
	call	DELAYX


; word 6
W6F

	movlw	D'200'
	movwf	BURST_LOUD		; burst length	

; set frequency
	movlw	D'15'			; main frequency
	movwf	FREQ_LOUD
	movlw	D'16'			; 
	movwf	FREQ_LOUD_END	; ending frequency
	call	GENERATOR_LOUD	; kHz tone 

	movlw	D'200'			; gap 145ms	
	call	DELAYX
	movlw	D'140'
	call	DELAYX
	
	movlw	D'9'			; burst number 
	movwf	STORE3			; 
CHIRP_W6F
	movlw	D'200'
	movwf	BURST_LOUD		; burst length	

; set frequency
	movlw	D'15'			; main frequency
	movwf	FREQ_LOUD
	movlw	D'16'			; 
	movwf	FREQ_LOUD_END	; ending frequency
	call	GENERATOR_LOUD	; kHz tone 

	movlw	D'150'			; gap 145ms	
	call	DELAYX
	movlw	D'100'
	call	DELAYX

	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W6F

; 100ms delay

;	movlw	D'150'			; gap 100ms	
;	call	DELAYX
;	movlw	D'100'
;	call	DELAYX

W7F

	movlw	D'3'			; burst number 
	movwf	STORE3			; bursts per chirp
CHIRP_W7F
	
	movlw	D'90'			; burst length 100ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	D'9'			; 4.5kHz
	movwf	FREQ_SOFT
	movlw	D'10'			; 
	movwf	FREQ_SOFT_END	
	movlw	D'2'
	movwf	VOL_MAX
	movlw	D'3'
	movwf	VOL_END
	call	GENERATOR_SOFT		; kHz tone (uses STORE1)

; CHIRP_GAP

	movlw	D'220'			; gap 90ms	
	call	DELAYX

	decfsz	STORE3,f		; run 4 bursts
	goto	CHIRP_W7F
	return


CANARY_S
; WORD1. High level (14 x 30ms bursts of 2.8kHz 35ms gaps and 7ms end gap)
	clrwdt
; keep second pic off
;	movlw	B'11111111'
;	movwf	PORT_STATUS		; GPIO,4 high
; let second pic run
	movlw	B'11101111'
	movwf	PORT_STATUS		; GPIO,4 low
; run 14 bursts

WORD1_SOFT
	movlw	D'14'			; burst number 
WORD1_SOFT2	
	movwf	STORE3			;  2.8kHz bursts per chirp
	call	CHIRP_W12_H
	goto	CHIRP_W12X
	
CHIRP_W12_H
	movlw	D'40'
	movwf	BURST_LOUD		; burst length	

; set frequency
	movlw	D'24'			; main frequency
	movwf	FREQ_LOUD
	movlw	D'28'			; 
	movwf	FREQ_LOUD_END	; ending frequency
	call	GENERATOR_LOUD	; kHz tone 
; CHIRP_GAP
	movlw	D'95'			; gap 30ms	
	call	DELAYX
	decfsz	STORE3,f		; run 
	goto	CHIRP_W12_H
	return
CHIRP_W12X
	
; 1 short burst
	movlw	D'12'
	movwf	BURST_LOUD		; burst length	

; set frequency
	movlw	D'24'			; main frequency
	movwf	FREQ_LOUD
	movlw	D'28'			; 
	movwf	FREQ_LOUD_END	; ending frequency
	call	GENERATOR_LOUD	; kHz tone 


WORD_GAP1

WORD_GAP_1
	movlw	D'18'			; separation 7ms
 	call	DELAYX			; delay set by separation value

WORD2; low level

	clrwdt
	bsf		GPIO,5			; LDR off
	movlw	D'14'			; sets of 3 burst number 
	movwf	STORE3			; 14 x 3 x kHz bursts per chirp
CHIRP_W2
; burst 1 in set of 3
	movlw	D'5'			; burst length 4ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	D'25'			; 2.7kHz
	movwf	FREQ_SOFT
	movlw	D'26'			; 
	movwf	FREQ_SOFT_END	
	movlw	D'2'
	movwf	VOL_MAX
	movlw	D'3'
	movwf	VOL_END
	call	GENERATOR_SOFT1		; kHz tone (uses STORE1)

	movlw	D'27'			; gap 11ms	
	call	DELAYX

; burst 2 in set of 3
	movlw	D'4'			; burst length 4ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	D'45'			; 1.5kHz
	movwf	FREQ_SOFT
	movlw	D'46'			; 
	movwf	FREQ_SOFT_END	
	movlw	D'2'
	movwf	VOL_MAX
	movlw	D'3'
	movwf	VOL_END
	call	GENERATOR_SOFT1		; kHz tone (uses STORE1)

	movlw	D'27'			; gap 11ms	
	call	DELAYX

; burst 3 in set of 3
	movlw	D'9'			; burst length 8ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	D'42'			; 1.7kHz
	movwf	FREQ_SOFT
	movlw	D'28'			; 
	movwf	FREQ_SOFT_END	
	movlw	D'2'
	movwf	VOL_MAX
	movlw	D'3'
	movwf	VOL_END
	call	GENERATOR_SOFT1		; kHz tone (uses STORE1)
; CHIRP_GAP
; next 4-lines required when gap between word is < gap
	movf	STORE3,w		; burst counter
	xorlw	D'1'			; on last burst bypass gap
	btfsc	STATUS,Z
	goto	WORD_GAP2

	movlw	D'75'			; gap 30ms	
	call	DELAYX

	decfsz	STORE3,f		; run 14 bursts
	goto	CHIRP_W2

WORD_GAP2

; initial tone gap multiplier to give spacing between the bursts


WORD_GAP_2
	movlw	D'64'			; separation 25ms
 	call	DELAYX			; delay set by separation value

WORD3 ; 8 bursts 2.7kHz 160ms, 80ms gap, 100ms word separation

	clrwdt
	bsf		GPIO,5			; LDR off


CHIRP_W3
	goto	RUN_CANARY

WORD3_CANARY
	movlw	D'205'
	movwf	BURST_LOUD		; burst length	160ms

; set frequency
	movlw	D'25'			; main frequency
	movwf	FREQ_LOUD
	movlw	D'26'			; 
	movwf	FREQ_LOUD_END	; ending frequency
	call	GENERATOR_LOUD	; kHz tone 
	return	

RUN_CANARY
	call	WORD3_CANARY
	movlw	D'200'			; gap 80ms	
	call	DELAYX

;2
	call	WORD3_CANARY
 
	movlw	D'150'			; gap 60ms	
	call	DELAYX

;3
	call	WORD3_CANARY
	
	movlw	D'120'			; gap 50ms	
	call	DELAYX
; 4-7
	movlw	D'4'			; burst number 

	movwf	STORE3			; 8 x 2.7kHz bursts per chirp
CHIRP_W3_3
	call	WORD3_CANARY

	movlw	D'120'			; gap 50ms	
	call	DELAYX

	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W3_3
	movlw	D'80'			; gap 80ms	
	call	DELAYX
;8
	call	WORD3_CANARY

	movlw	D'250'			; gap 100ms	
	call	DELAYX

WORD4 ; 4 bursts 1.96kHz 190ms, 40ms gap 

	clrwdt
	bsf		GPIO,5			; LDR off

	movlw	D'4'			; burst number 
	movwf	STORE3			; 4 x 1.9kHz bursts per chirp

CHIRP_W4
	
	movlw	D'255'			; burst length 190ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	D'6'			; 
	movwf	FREQ_SOFT
	movlw	D'7'			; 
	movwf	FREQ_SOFT_END	
	movlw	D'5'
	movwf	VOL_MAX
	movlw	D'4'
	movwf	VOL_END
	call	GENERATOR_SOFT		; kHz tone (uses STORE1)

; CHIRP_GAP

	movlw	D'100'			; gap 40ms	
	call	DELAYX

	decfsz	STORE3,f		; run 4 bursts
	goto	CHIRP_W4
	return

CANARY_X1 ; characteristic electronic chirping
; let second pic run
	movlw	B'11101111'
	movwf	PORT_STATUS		; GPIO,4 low

; word 1 CANARY_S.
	incf	REPEAT,f
	movf	REPEAT,w
	andlw	B'00011111'	; 32 max
	call	RNDM_VARY	; lookup table	17-40 for first 32
	movwf	STORE3			; bursts
	call	CHIRP_W12_H
	return
CANARY_X2
; word 1 FIFE
	incf	REPEAT,f
	movf	REPEAT,w
	andlw	B'00011111'	; 32 max
	call	RNDM_VARY	; lookup table
	movwf	STORE3		; bursts
; DIVIDE BY 4
	bcf		STATUS,C
	rrf		STORE3,f
	bcf		STATUS,C
	rrf		STORE3,f
	call	CHIRP_W1F
	return
CANARY_X3
; word 2 FIFE	
	incf	REPEAT,f
	movf	REPEAT,w
	andlw	B'00011111'	; 32 max
	call	RNDM_VARY	; lookup table
	movwf	STORE3		; bursts
	call	CHIRP_W2F
	return


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Generator subroutines

GENERATOR_LOUD

	clrf	PWM
	
GENERATOR_L

	movf	PWM,w
	movwf	WIDTH
	movwf	WIDTH2

	movf	FREQ_LOUD,w		; frequency value 
	movwf	STORE1

	movf	PORT_STATUS,w
	andlw	B'11111101'		; clear GPIO1
	iorlw	B'00000001'		; set GPIO0
	movwf	GPIO

DEC1

; on for PWM cycles	
	movf	WIDTH,w
	btfsc	STATUS,Z		; when zero clear GPIO
	clrf	GPIO
	decf	WIDTH,f			; decrement width
	decfsz	STORE1,f
	goto	DEC1

	movf	FREQ_LOUD,w		;  frequency value
	movwf	STORE1

	movf	PORT_STATUS,w
	andlw	B'11111110'		; clear GPIO0
	iorlw	B'00000010'		; set GPIO1
	movwf	GPIO	

DEC2
	
; on for PWM cycles	
	movf	WIDTH2,w
	btfsc	STATUS,Z		; when zero clear GPIO
	clrf	GPIO
	decf	WIDTH2,f		; decrement width
	decfsz	STORE1,f
	goto	DEC2
	
	incf	PWM,f

	decfsz	BURST_LOUD,f	; kHz burst length
	goto	GENERATOR_L 
	clrwdt
; pwm ramp down
	
GENERATOR_LX
	movf	PWM,w
	movwf	WIDTH
	movwf	WIDTH2

	movf	FREQ_LOUD_END,w		; frequency value 
	movwf	STORE1

	movf	PORT_STATUS,w
	andlw	B'11111101'		; clear GPIO1
	iorlw	B'00000001'		; set GPIO0
	movwf	GPIO

DEC1X

; on for PWM cycles	
	movf	WIDTH,w
	btfsc	STATUS,Z		; when zero clear GPIO
	clrf	GPIO
	decf	WIDTH,f			; decrement width
	decfsz	STORE1,f
	goto	DEC1X

	movf	FREQ_LOUD_END,w		;  frequency value
	movwf	STORE1

	movf	PORT_STATUS,w
	andlw	B'11111110'		; clear GPIO0
	iorlw	B'00000010'		; set GPIO1
	movwf	GPIO	

DEC2X
	
; on for PWM cycles	
	movf	WIDTH2,w
	btfsc	STATUS,Z		; when zero clear GPIO
	clrf	GPIO
	decf	WIDTH2,f		; decrement width
	decfsz	STORE1,f
	goto	DEC2X
	
	decfsz	PWM,f			; decrease pulse width
	goto	GENERATOR_LX 
	clrwdt
	return

; softer drive
GENERATOR_SOFT1 ; shorter burst
	clrf	PWM
	movlw	D'1'
	movwf	TIME
	movwf	TIME1
	movwf	TIME2
	goto	GENERATOR_S
GENERATOR_SOFT ; longer burst
	clrf	PWM
	movlw	D'6'
	movwf	TIME
	movwf	TIME1
	movlw	D'20'
	movwf	TIME2
	
GENERATOR_S

	movf	PWM,w
	movwf	WIDTH
	movwf	WIDTH2

	movf	FREQ_SOFT,w		; frequency value 
	movwf	STORE1

	movf	PORT_STATUS,w
	andlw	B'11111101'		; clear GPIO1
	iorlw	B'00000001'		; set GPIO0
	movwf	GPIO

DEC1S

; on for PWM cycles	
	movf	WIDTH,w
	btfsc	STATUS,Z		; when zero clear GPIO
	clrf	GPIO
	decf	WIDTH,f			; decrement width
	decfsz	STORE1,f
	goto	DEC1S

	movf	FREQ_SOFT,w		;  frequency value
	movwf	STORE1

	movf	PORT_STATUS,w
	andlw	B'11111110'		; clear GPIO0
	iorlw	B'00000010'		; set GPIO1
	movwf	GPIO	

DEC2S
	
; on for PWM cycles	
	movf	WIDTH2,w
	btfsc	STATUS,Z		; when zero clear GPIO
	clrf	GPIO
	decf	WIDTH2,f		; decrement width
	decfsz	STORE1,f
	goto	DEC2S
	
	incf	PWM,w
	subwf	VOL_MAX,w
	btfsc	STATUS,C
	incf	PWM,f			; increase up to vol_max
	decfsz	TIME,f			; increase period length
	goto	GENERATOR_S
	movf	TIME1,w
	movwf	TIME
	decfsz	BURST_SOFT,f	; kHz burst length
	goto	GENERATOR_S 
	clrwdt
; pwm ramp down
	movf	VOL_END,w
	movwf	PWM
	movf	TIME2,w	
	movwf	TIME
GENERATOR_SX
	movf	PWM,w
	movwf	WIDTH
	movwf	WIDTH2

	movf	FREQ_SOFT_END,w		; frequency value 
	movwf	STORE1

	movf	PORT_STATUS,w
	andlw	B'11111101'		; clear GPIO1
	iorlw	B'00000001'		; set GPIO0
	movwf	GPIO

DEC1SX

; on for PWM cycles	
	movf	WIDTH,w
	btfsc	STATUS,Z		; when zero clear GPIO
	clrf	GPIO
	decf	WIDTH,f			; decrement width
	decfsz	STORE1,f
	goto	DEC1SX

	movf	FREQ_SOFT_END,w		;  frequency value
	movwf	STORE1

	movf	PORT_STATUS,w
	andlw	B'11111110'		; clear GPIO0
	iorlw	B'00000010'		; set GPIO1
	movwf	GPIO	

DEC2SX
	
; on for PWM cycles	
	movf	WIDTH2,w
	btfsc	STATUS,Z		; when zero clear GPIO
	clrf	GPIO
	decf	WIDTH2,f		; decrement width
	decfsz	STORE1,f
	goto	DEC2SX

	decfsz	TIME,f			; double period length
	goto	GENERATOR_SX
	movf	TIME2,w	
	movwf	TIME

	decfsz	PWM,f			; decrease pulse width
	goto	GENERATOR_SX 
	clrwdt
	return



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; delay loop 

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
	incf	DEL1,w
	movwf	DEL1
	andlw	B'00111111'	; 64 max
	call	DEL_VARY	; lookup table
	movwf	VALUE	
LOOP8	
	movf	VALUE,w		; average D'117'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	clrwdt
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

; Subroutines

; read mode
EEPROM_READ
	bsf 	STATUS,RP0 	; Bank 1
	movlw 	EEPROM0		;
	movwf 	EEADR 		; Address to read
	bsf 	EECON1,RD 	; EE Read
	movf 	EEDATA,w 	; Move data to w
	bcf		STATUS,RP0	; Bank 0
	return

; EEPROM write
EEPROM_WRITE
	clrwdt
	bsf 	STATUS,RP0 	; Bank 1
	movwf 	EEDATA		; data
	bsf 	EECON1,WREN ; Enable write
	movlw 	H'55'		; Unlock write
	movwf 	EECON2 		;
	movlw 	H'AA' 		;
	movwf 	EECON2 ;
	bsf 	EECON1,WR 	; Start the write
	bcf		STATUS,RP0	; Bank 0
	bcf		PIR1,EEIF	; clear end of write bit
	clrwdt
WRITE
	btfsc	PIR1,EEIF
	goto	READY_RETURN
	clrwdt
	goto	WRITE
READY_RETURN
	bsf 	STATUS,RP0 	; Bank 1
	bcf 	EECON1,WREN ; disable write
	bcf		STATUS,RP0	; Bank 0
	return


                

	end
