


; 10-input IR remote control with optional IR to UHF operation
; enhanced immunity to IR interference 
; UHF and IR separate inputs at RB2 and RB3 instead of SET input at RB2

; CPU configuration
	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc


;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF
; Define variables at memory locations

; EEPROM
EEPROM0		equ	H'00'	; momentary/toggle for PORTA 
EEPROM1		equ	H'01'	; momentary/toggle for PORTB
EEPROM2		equ	H'02'	; PORTA state at power up for toggle 
EEPROM3		equ	H'03'	; PORTB state at power up for toggle

; RAM
; bank 0 

REMOTE_M	equ	H'20'	; remote control input ms byte
REMOTE_L	equ	H'21'	; remote control input LS byte
REM_FLG		equ	H'22'	; flag to indicate current remote control sequencing 
REM_CNT		equ	H'23'	; interrupt count for polling remote control signal
REM_COD		equ	H'24'	; remote control bit counter mode.
TOGGLE		equ	H'25'	; remote control toggle bit
TG_BIT		equ	H'26'	; toggle bit stored flag
VALUE_1		equ	H'27'	; delay value
VALUE_2		equ	H'28'	; delay value
VALUE_3		equ	H'29'	; ACK
FLG_HL		equ	H'2A'	; high or low remote control sign
FLAG_RM		equ	H'2B'	; flag to indicate continuous remote
START_A		equ	H'2C'	; PORT A startup level for toggle
START_B		equ	H'2D'	; PORT B startup level for toggle
STORE1		equ	H'2E'	; remote storage ms byte
STORE2		equ	H'2F'	; remote storage ls byte
B_STAT		equ	H'30'	; B port toggle or momentary
A_STAT		equ	H'31'	; A port toggle or momentary
TEMP		equ	H'32'	; temporary
PARAMETERS	equ	H'33'	; flag for entering momentary/toggle and power up parameters
PARAM_CNTR	equ	H'34'	; parameters counter
PARAM_CH	equ	H'35'	; parameters channel
PARAM_TMP	equ	H'36'	; parameters temporary
PARAM_M_T	equ	H'37'	; parameters momentary or toggle
PARAM_PU	equ	H'38'	; parameters power up
TIMEOUT		equ	H'39'	; parameter timeout
PORTBSTO	equ	H'3A'	; state of portB inputs to read RB2,4 and 5
TIME_LOOP	equ	H'3B'	; timeout counter loop
PORTA_BUFF	equ	H'3C'	; portB buffer
PORTB_BUFF	equ	H'3D'	; portB buffer
QUIET		equ	H'3E'	; Quiet signal flag	for IR
DIV			equ	H'3F'	; divider counter
PERIOD		equ	H'40'	; acknowledge period
REM_CNT1	equ	H'41'	; interrupt count for polling remote control signal
DIV1		equ	H'42'	; divider counter 1
FLG_HL1		equ	H'43'	; high or low remote control sign
QUIET1		equ	H'44'	; quiet signal flag for UHF
UHF_IN		equ	H'45'	; check if UHF is in or out

; all banks ram
W_TMP		equ	H'70'	; temporary store for w in interrupt
STATUS_TMP	equ	H'71'	; temporary store of status in interrupt 
DATA_VAL	equ	H'72' 	; EEPROM data value	
EEP_CNTR	equ	H'73'	; write to EEPROM counter

	ORG     H'2100'		; preprogram EEPROM locations
	DE		H'00'		; PORTA outputs initially momentary
	DE		H'00'		; PORTB outputs initially momentary 	
	DE		H'00'		; PortA low at power up for alternate (toggle) selection
	DE		H'00'		; PortB low at power up for alternate (toggle) selection

; define reset and interrupt vector start addresses

	org		H'0'		; start at address 0000h
	goto	MAIN		; normal service routines from Reset vector
	org     H'4'		; interrupt vector 0004h, start interrupt routine here


; ************************************************************************************	
; start interrupt by saving w and status registers before altered by interrupt routine

INTERRUPT
; check interrupt source	
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bcf		STATUS,RP0	; select memory bank 0
	bcf		STATUS,RP1

; adjust interrupt rate with counter

COUNTER
	movlw	D'207'		; freq is 4MHz/4/2/50. period = 100us
	addwf	TMR0,f		; add to timer register and takes 2 cycles to start counting
	bcf		INTCON,TMR0IF	; clear TMRO interrupt flag

	btfsc	REM_FLG,2	; if set then UHF decoding
	goto	UHF_DEC1	; else UHF decoding

IR_DEC
; check for a continuous high for RB3 for ~ 50ms indicating that a transmission is in progress
; ie no noise on the signal
	btfsc	REM_FLG,0	; has remote control sequence started		
	goto	RM_SQ
	movf	QUIET,w
	btfss	STATUS,Z	; if zero check for continuous RB3 high
	goto	RM_SQ
	movf	REM_CNT,w
	btfss	STATUS,Z	; if rem counter zero, set to 50ms quiet period
 	goto	REM_SET	
	movlw	D'255'		; 25.5ms
	movwf	REM_CNT
REM_SET
	btfss	PORTB,3		; if portB is high decrease rem counter otherwise reset counter
	goto	PORT_LO
	decf	DIV,f
	btfss	DIV,0		; divide by 2 for 50ms
	decfsz	REM_CNT,f
	goto	UHF_DEC
	bsf		QUIET,0
	goto	UHF_DEC;RECLAIM
PORT_LO
	movlw	D'255'
	movwf	REM_CNT
	goto	UHF_DEC

; check if RB3 has gone low for start of remote control sequence

RM_SQ
	btfsc	REM_FLG,0	; has remote control sequence started		
	goto	REM_SEQ
	btfsc	PORTB,3		; is RB3 low 
	goto	UHF_DEC
	bsf		REM_FLG,0	; set beginning of remote control flag
	bsf		REM_FLG,3

	movlw	D'22'		; initial time period to wait till next start bit
	movwf	REM_CNT
	movlw	D'13'		; shift register counter
	movwf	REM_COD
	bsf		REMOTE_L,0	; set first bit in remote control sequence
	clrf	FLG_HL		; clear bit 1 in high low flag
	bsf		REM_FLG,7	; start bit flag set
	goto 	RECLAIM

REM_SEQ
	btfsc	REM_FLG,1	; has it finished
	goto	RECLAIM
	decfsz	REM_CNT,f	; decrease interrupt counter for timing
	goto	CKEDGE		; check if change in level
	bcf		REM_FLG,7	; clear start bit flag
	movlw	D'18'		; 18 x 100us = 1.8ms or period between valid bits
	movwf	REM_CNT
	rlf		REMOTE_L,f	; least sig byte in remote control code sequence
	rlf		REMOTE_M,f	; most sig byte 
	movf	PORTB,w		; check bit 3 portB
	andlw	B'00001000'	; mask out bits except bit 3
	movwf	FLG_HL		; place in flag
	btfsc	PORTB,3		; check if high or low
	goto	HI			; high so clear
	bsf		REMOTE_L,0	; if low set this bit
	goto	BY_HI		; bypass high
HI	
	bcf		REMOTE_L,0	; clear 0 bit
BY_HI		
	decfsz	REM_COD,f	; decrease shift register count
	goto	RECLAIM
	bsf		REM_FLG,1	; set end of remote control decoding flag
	clrf	QUIET
	bcf		REM_FLG,3	
	movlw	D'255'		; set delay period of about 120ms between codes
	movwf	VALUE_1		; VALUE_1 = w
	movlw	D'100'		; set delay period value 2 
	movwf	VALUE_2	
	goto	RECLAIM

; align change in level (edge detect) with REM_CNT counter
 
CKEDGE
	btfsc	REM_FLG,7	; start bit flag bypass edge detect as AGC level setting
	goto	RECLAIM
	movlw	B'00001000'	; select bit 3 for PORTB,3
	andwf	PORTB,w		; bit 3
	xorwf	FLG_HL,w	; compare PORTB,3 with FLAG (previous level)		
	btfsc	STATUS,Z	; Z=1 if zero then no change
	goto	RECLAIM		; no change 
	movlw	B'00001000'	; select bit 0 for PORTB,3
	andwf	PORTB,w		; bit 3 select 
	movwf	FLG_HL		; reload new level
	movlw	H'3'		; count of 3 for REM_CNT
	subwf	REM_CNT,w	; is REM_CNT larger or equal to 3
	btfss	STATUS,C
	goto	RECLAIM		; smaller than 3 
	movf	REM_CNT,w
	sublw	H'6'		; check if 6 or less
	btfss	STATUS,C
	goto	RECLAIM		; larger than 6 
	movlw	H'4'
	movwf	REM_CNT		; set REM_CNT to 4 to align with change in level
	goto	RECLAIM


UHF_DEC1
	clrf	QUIET
	bcf		REM_FLG,3
UHF_DEC

; check if UHF is in (ie if RB2 goes high sometimes)
	btfsc	PORTB,2
	bsf		UHF_IN,0	; if so set the UHF IN flag
	btfss	UHF_IN,0	; check if UHF is in or out
	goto	RECLAIM1

	btfsc	REM_FLG,3	; QUIET,0		; if set then IR decoding
	goto	RECLAIM1		; bypass UHF decoding
; check for a continuous low for RB2 for 50ms indicating that a transmission is in progress
; ie no noise on the signal
	btfsc	REM_FLG,0	; has remote control sequence started		
	goto	RM_SQ1
	movf	QUIET1,w
	btfss	STATUS,Z	; if zero check for continuous RB2 low
	goto	RM_SQ1
	movf	REM_CNT1,w
	btfss	STATUS,Z	; if rem counter zero, set to 50ms quiet period
 	goto	REM_SET1	
	movlw	D'255'		; 25.5ms
	movwf	REM_CNT1
REM_SET1
	btfsc	PORTB,2		; if portB is low decrease rem counter otherwise reset counter
	goto	PORT_HI
	decf	DIV1,f
	btfss	DIV1,0		; divide by 2 for 50ms
	decfsz	REM_CNT1,f
	goto	RECLAIM
	bsf		QUIET1,0
	goto	RECLAIM
PORT_HI
	movlw	D'255'
	movwf	REM_CNT1
	goto	RECLAIM

; check if RB2 has gone high for start of remote control sequence
RM_SQ1
	btfsc	REM_FLG,0	; has remote control sequence started		
	goto	REM_SEQ1
	btfss	PORTB,2		; is RB2 high 
	goto	RECLAIM
	bsf		REM_FLG,0	; set beginning of remote control flag
	bsf		REM_FLG,2
	movlw	D'22'		; initial time period to wait till next start bit
	movwf	REM_CNT1
	movlw	D'13'		; shift register counter
	movwf	REM_COD
	bsf		REMOTE_L,0	; set first bit in remote control sequence
	clrf	FLG_HL1		; clear bit 1 in high low flag
	bsf		REM_FLG,7	; start bit flag set	
	goto 	RECLAIM

REM_SEQ1

	btfsc	REM_FLG,1	; has it finished
	goto	RECLAIM
	decfsz	REM_CNT1,f	; decrease interrupt counter for timing
	goto	CKEDGE1		; check if change in level
	bcf		REM_FLG,7	; clear start bit flag
	movlw	D'18'		; 18 x 100us = 1.8ms or period between valid bits
	movwf	REM_CNT1
	rlf		REMOTE_L,f	; least sig byte in remote control code sequence
	rlf		REMOTE_M,f	; most sig byte 
	movf	PORTB,w		; check bit 2 portB
	andlw	B'00000100'	; mask out bits except bit 2
	movwf	FLG_HL1		; place in flag
	btfss	PORTB,2		; check if high or low
	goto	LO1			; low so clear
	bsf		REMOTE_L,0	; if high set this bit
	goto	BY_LO1		; bypass low
LO1	
	bcf		REMOTE_L,0	; clear 0 bit
BY_LO1		
	decfsz	REM_COD,f	; decrease shift register count
	goto	RECLAIM
	bsf		REM_FLG,1	; set end of remote control decoding flag
	clrf	QUIET1
	movlw	D'255'		; set delay period of about 120ms between codes
	movwf	VALUE_1		; VALUE_1 = w
	movlw	D'100'		; set delay period value 2 
	movwf	VALUE_2	
	goto	RECLAIM

CKEDGE1
	btfsc	REM_FLG,7	; start bit flag bypass edge detect as AGC level setting
	goto	RECLAIM
	movlw	B'00000100'	; select bit 2 for PORTB,2
	andwf	PORTB,w		; bit 2
	xorwf	FLG_HL1,w	; compare PORTB,2 with FLAG (previous level)		
	btfsc	STATUS,Z	; Z=1 if zero then no change
	goto	RECLAIM		; no change 
	movlw	B'00000100'	; select bit 2 for PORTB,2
	andwf	PORTB,w		; bit 2 select 
	movwf	FLG_HL1		; reload new level
	movlw	H'3'		; count of 3 for REM_CNT
	subwf	REM_CNT1,w	; is REM_CNT larger or equal to 3
	btfss	STATUS,C
	goto	RECLAIM		; smaller than 3 
	movf	REM_CNT1,w
	sublw	H'6'		; check if 6 or less
	btfss	STATUS,C
	goto	RECLAIM		; larger than 6 
	movlw	H'4'
	movwf	REM_CNT1	; set REM_CNT to 4 to align with change in level
	goto	RECLAIM

RECLAIM1
	bcf		REM_FLG,2
	clrf	QUIET1

; end of interrupt reclaim w and status 

RECLAIM
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

;********************************************************************************************** 
  
; RESET		
; Set ports A & B

MAIN
	clrf	TG_BIT		; clear toggle bit stored flag
	clrf	REM_CNT		; remote control polling counter
	clrf	REM_CNT1
	clrf	REM_FLG		; remote control flag status
	clrf	PORTA
	clrf	PORTA_BUFF	; buffer
	clrf	PORTB
	clrf	PORTB_BUFF
	clrf	STORE1		; remote storage
	clrf	STORE2
	clrf	UHF_IN		; check if UHF is in or out

; set inputs/outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'00111100'	; Inputs/outputs (RB2,4,5 initially inputs)
	movwf	TRISB		; port B data direction register
	movlw	B'01000000'	; 
	movwf	OPTION_REG	; TMRO prescaler is 2, PORTB pullups enabled, 
	movlw   B'00100000'	; inputs/ outputs 
	movwf   TRISA		; port A data direction register

; analog inputs, A/D
	movlw	B'00000000'	; no analog inputs
	movwf	ANSEL
; oscillator

	movlw	B'01100000'	; for 4MHz
	movwf	OSCCON		; osc
	bcf		STATUS,RP0	; select memory bank 0

	call	DELAY
; check portB
	movf	PORTB,w		; read portB (initially with RB2,4,5 set as inputs and pullups enabled.)
	movwf	PORTBSTO	; store

	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'10000000'	; 
	movwf	OPTION_REG	; TMRO prescaler is 2, PORTB pullups disabled, 
	movlw	B'00001100'	; Inputs/outputs (RB4,5 ouputs set low)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	movlw	D'00'
	movwf	PORTB

INITIAL	
; initial
	clrf	PARAMETERS	; parameters entering cycle off
	clrf	TIMEOUT		; timeout period for parameters
	clrf	QUIET		; signal quiet period
OUTPUT_STATUS 
; get EEPROM values
	movlw	H'00'		; for A port
	call	EEREAD
	movwf	A_STAT		; A port toggle or momentary
	movlw	H'01'		; for B port
	call	EEREAD
	movwf	B_STAT		; B port toggle or momentary

	movlw	H'02'		; for A port
	call	EEREAD

	movwf	START_A		; PORT A startup level for toggle
	movlw	H'03'		; for B port
	call	EEREAD

	movwf	START_B		; PORT B startup level for toggle

; set outputs. Note: RA,RB numbers do not correspond to outputs 0-9
; portA,0,1,2,3,4,6,7 used
	btfss	A_STAT,0	; if toggle set then set power up level
	goto	P0
	btfsc	START_A,0	; if set, set portA,0
	bsf		PORTA_BUFF,0
P0
	btfss	A_STAT,1	; if toggle set then set power up level
	goto	P1
	btfsc	START_A,1	; if set, set portA,1
	bsf		PORTA_BUFF,1
P1
	btfss	A_STAT,2	; if toggle set then set power up level
	goto	P2
	btfsc	START_A,2	; if set, set portA,2
	bsf		PORTA_BUFF,2
P2
	btfss	A_STAT,3	; if toggle set then set power up level
	goto	P3
	btfsc	START_A,3	; if set, set portA,3
	bsf		PORTA_BUFF,3
P3
	btfss	A_STAT,4	; if toggle set then set power up level
	goto	P4
	btfsc	START_A,4	; if set, set portA,4
	bsf		PORTA_BUFF,4
P4
	btfss	A_STAT,6	; if toggle set then set power up level
	goto	P6
	btfsc	START_A,6	; if set, set portA,6
	bsf		PORTA_BUFF,6
P6
	btfss	A_STAT,7	; if toggle set then set power up level
	goto	P7
	btfsc	START_A,7	; if set, set portA,7
	bsf		PORTA_BUFF,7
; PortB0,1,7 used 
P7
	btfss	B_STAT,0	; if toggle set then set power up level
	goto	P8
	btfsc	START_B,0	; if set, set portB,0
	bsf		PORTB_BUFF,0
P8
	btfss	B_STAT,1	; if toggle set then set power up level
	goto	P9
	btfsc	START_B,1	; if set, set portB,1
	bsf		PORTB_BUFF,1
P9
	btfss	B_STAT,7	; if toggle set then set power up level
	goto	PORT_EXCH
	btfsc	START_B,7	; if set, set portB,7
	bsf		PORTB_BUFF,7

 
PORT_EXCH ; buffer to port
	movf	PORTA_BUFF,w
	movwf	PORTA
	movf	PORTB_BUFF,w
	movwf	PORTB
;INTERRUPT_ENABLE
	bsf		INTCON,TMR0IE; set interrupt enable for TMR0 
	bsf		INTCON,GIE	; set global interrupt enable for above
	

; Philips RC5 code for infra red transmission (also used with Marantz, Mission, Grundig and Loewe)
; Comprises 2 start bits, 1 toggle bit (alternates high or low on successive same key press)
; 5-system address bits and 6 command bits. Data stream starts with the start bits. 
; biphase encoding with high to a low transition = a low and low to high = high
; each bit transmitted at 1.778ms rate. Whole code at 24.889ms and next code starts 113.778ms
; later. Can decode by detecting first start bit then waiting 1.778ms + 444.5us for next start
; bit. Successive bits are 1.778ms apart. Total of 14 bits. 

;Address
;0 TV1
;1 TV2
;2 Videotext
;3 Expansion for TV1 and TV2
;4 Laser vision player
;5 VCR1
;6 VCR2
;7 Reserved
;8 SAT1
;9 Expansion for VCR1 and VCR2
;10 SAT2
;11 Reserved
;12 CD Video
;13 Reserved
;14 CD Photo
;15 Reserved
;16 Audio preamplifier1
;17 Tuner
;18 Analogue cassetter recorder
;19 Audio Preamp2
;20 CD
;21 Audio rack
;22 Audio Satellite
;23 DCC Recorder
;24 Reserved
;25 Reserved
;26 Writable CD
;27-31 Reserved

;Keycode commands 
;0 0
;1 1
;2 2
;3 3
;4 4
;5 5
;6 6
;7 7
;8 8
;9 9
;16 Volume +
;17 Volume -
;18 Brightness +
;19 Brightness -
;20 Colour saturation +
;21 Colour Saturation -
;22 Bass +
;23 Bass -
;24 Treble +
;25 Treble -
;26 Balance right
;27 balance left
;63 System select
;71 Dim local display

; Special commands
;10 1/2/3 digits /10
;11 Freq/prog/ch11
;12 standby
;13 Mute
;14 Personal preference
;15 Display
;28 Contrast +
;29 Contrast -
;30 Search +
;31 Tint/hue
;32 CH/prog +
;33 CH/prog -
;34 Alternate CH

;37 stereo/mono
;39 Tint/hue +
;48 Pause
;50 rewind
;52 wind
;53 play
;54 stop
;55 record

; compare with address code out if invalid clear REM_FLG
; if valid check command bits and ls 2 address bits then clear REM_FLG
; but first check which code is selected 
	

RM_CK
	movlw	D'255'		; set delay period of about 120ms between codes
	movwf	VALUE_1		; VALUE_1 = w
LP_3
	movlw	D'100'		; set delay period value 2 
	movwf	VALUE_2		; VALUE_2 = w
LP_4
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_4

; check during delay for parameters entered flag
	
	btfsc	REM_FLG,1	; is remote control entered flag set
	goto	CODE_D1
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_3
	
;	clrf	QUIET1
;	clrf	QUIET
;	clrf	REM_FLG

RED_TMOUT; reduce timeout period during parameters entering
	movf	TIMEOUT,w
	btfsc	STATUS,Z	; if zero bypass decrement
	goto	CODE_D
	decfsz	TIMEOUT,F
	goto	CODE_D
	clrf	PARAMETERS
	bcf		PORTB,6		; ack LED off
	bcf		PORTB_BUFF,6	
	goto	CODE_D
CODE_D1		
	decfsz	TIME_LOOP,f	; reduce timeout
	goto 	CODE_D
	movlw	D'250'
	movwf	TIME_LOOP
	goto	RED_TMOUT

; remote control decoding
CODE_D	
	btfss	REM_FLG,0	; remote control sequence started
	goto	CLR_RM1	
	btfsc	REM_FLG,1	; is remote control entered flag set
	goto	CONTINUOUS
	movf	A_STAT,w	; check portA status (high is toggle so anding will keep status)
	andwf	PORTA_BUFF,f		; clear all momentary outputs keep toggles at current status
	movf	PORTA_BUFF,w
	movwf	PORTA
	movf	B_STAT,w
	iorlw	B'01000000'	; keep ACK
	andwf	PORTB_BUFF,f
	movf	PORTB_BUFF,w 
	movwf	PORTB

	goto	RM_CK

; continuous code sequence if button held for several seconds
CONTINUOUS
	bcf		STATUS,GIE	; stop interrupt
	btfss	FLAG_RM,0	; is continuous mode set
	goto	XFER
	movf	REMOTE_M,w
	andlw	B'00001000'	; toggle bit
	xorwf	TOGGLE,w	; is toggle bit the same as last time
	btfsc	STATUS,Z	; if z is 1 then the same
	goto	XFER 
	decfsz	TG_BIT,f	; toggle counter
	goto	BY_STO		; bypass storing toggle bit
	clrf	FLAG_RM		; clear continuous mode flag
XFER
	movf	REMOTE_M,w
	andlw	B'00001000'	; get toggle bit
	movwf	TOGGLE		; store toggle bit
	movlw	D'06'
	movwf	TG_BIT		; count times that toggle bit different
BY_STO
;	goto	CODE_SOURCE	; bypasses two consecutives
; two consecutive valid codes check
;sat
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit 3
	xorlw	B'00110010'	; compare with start bits and ms 3-bits of SAT1 and SAT2 address
	btfsc	STATUS,Z	; if zero then matching
	goto	CMP_LAST

; CD
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit 3
	xorlw	B'00110101'	; compare with start bits and ms 3-bits of SAT1 and SAT2 address
	btfsc	STATUS,Z	; if zero then matching
	goto	CMP_LAST

; TV	
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit 3
	xorlw	B'00110000'	; compare with start bits and ms 3-bits of TV address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF2
CMP_LAST	
; compare remote code with last received. Requires 2 matching consecutive codes before an an action occurs
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	movwf	TEMP
	movf	STORE1,w
	andlw	B'00110111' ; mask bit 6 and 7
	xorwf	TEMP,w
	btfsc	STATUS,Z
	goto	NEXT_BYTE	; the same codes so check next code byte

TRANSFER ; transfer values when not the same
	
	movf	REMOTE_M,w	; transfer codes
	movwf	STORE1	
	movf	REMOTE_L,w
	movwf	STORE2
	goto	CLR_RMF2

; compare next byte	
NEXT_BYTE
; compare remote code with last received. Requires 2 matching consecutive codes before an action occurs
	movf	REMOTE_L,w	; most significant remote code 
	xorwf	STORE2,w
	btfss	STATUS,Z
	goto	TRANSFER	; not the same values

; matching consecutive codes
; check code source
CODE_SOURCE
; LK1(RB5)
	btfss	PORTBSTO,5	
	goto	BOTH_LOW_CK	
; LK2(RB4) 
	btfss	PORTBSTO,4
	goto 	SAT2		; LK2 in only
	goto	TV_1		; both links out

BOTH_LOW_CK
; LK2(RB4)
	btfss	PORTBSTO,4
	goto 	CD			; both links in
	goto	SAT1		; LK1 in only

; code for television (TV1)
TV_1
; ms byte
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	
	xorlw	B'00110000'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF2	; clear remote flag
	goto	SAT1_TV1_CD	; ls byte check

CD
; ms byte
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit 3
	xorlw	B'00110101'	; compare with start bits and ms 3-bits of CD address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF2	; clear remote flag
	goto	SAT1_TV1_CD	; ls byte check

; satellite

SAT1
; ms byte
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF2	; clear remote flag

SAT1_TV1_CD
; ls byte
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'00000000'	; bits 0-5 keycode (0), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	ZERO
	movf	REMOTE_L,w
	xorlw	B'00000001'	; bits 0-5 keycode (1), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	ONE 
	movf	REMOTE_L,w
	xorlw	B'00000010'	; bits 0-5 keycode (2), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	TWO
	movf	REMOTE_L,w
	xorlw	B'00000011'	; bits 0-5 keycode (3), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	THREE
  	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'00000100'	; bits 0-5 keycode (4), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	FOUR
	movf	REMOTE_L,w
	xorlw	B'00000101'	; bits 0-5 keycode (5), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	FIVE 
	movf	REMOTE_L,w
	xorlw	B'00000110'	; bits 0-5 keycode (6), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	SIX
	movf	REMOTE_L,w
	xorlw	B'00000111'	; bits 0-5 keycode (7), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	SEVEN
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'00001000'	; bits 0-5 keycode (8), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	EIGHT
	movf	REMOTE_L,w
	xorlw	B'00001001'	; bits 0-5 keycode (9), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	NINE
;channel +/-
	movf	REMOTE_L,w
	xorlw	B'00100000'	; bits 0-5 keycode + (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	CH_UP
	movf	REMOTE_L,w
	xorlw	B'00100001'	; bits 0-5 keycode - (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	CH_DN
	goto	CLR_RMF2

SAT2
; ms byte
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF2	; clear remote flag
; ls byte
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'10000000'	; bits 0-5 keycode (0), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	ZERO
	movf	REMOTE_L,w
	xorlw	B'10000001'	; bits 0-5 keycode (1), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	ONE 
	movf	REMOTE_L,w
	xorlw	B'10000010'	; bits 0-5 keycode (2), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	TWO
	movf	REMOTE_L,w
	xorlw	B'10000011'	; bits 0-5 keycode (3), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	THREE
  	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'10000100'	; bits 0-5 keycode (4), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	FOUR
	movf	REMOTE_L,w
	xorlw	B'10000101'	; bits 0-5 keycode (5), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	FIVE 
	movf	REMOTE_L,w
	xorlw	B'10000110'	; bits 0-5 keycode (6), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	SIX
	movf	REMOTE_L,w
	xorlw	B'10000111'	; bits 0-5 keycode (7), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	SEVEN
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'10001000'	; bits 0-5 keycode (8), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	EIGHT
	movf	REMOTE_L,w
	xorlw	B'10001001'	; bits 0-5 keycode (9), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	NINE 
;channel +/-
	movf	REMOTE_L,w
	xorlw	B'10100000'	; bits 0-5 keycode + (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	CH_UP
	movf	REMOTE_L,w
	xorlw	B'10100001'	; bits 0-5 keycode - (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	CH_DN
	goto	CLR_RMF2
	
ZERO
	movf	PARAMETERS,w; parameters flag (setup channel parameters)
	movlw	D'0'		; value
	btfss	STATUS,Z	; if clear normal channel change
	goto	PARAM
	btfsc	FLAG_RM,0	; if set then already passed here
	goto	CLR_RMF
	btfsc	B_STAT,1	; if set then toggle
	goto	TOG_0		; toggle (alternate mode)
	bsf		PORTB_BUFF,1		; output high
	bsf		FLAG_RM,0	; set continuous mode
	goto	CLR_RMF
TOG_0
	btfsc	PORTB_BUFF,1		; if high clear
	goto	CLR_0
	bsf		PORTB_BUFF,1		; low so set
	bsf		FLAG_RM,0	; ready for next remote control input
	goto	CLR_RMF	
CLR_0
	bcf		PORTB_BUFF,1		; high so clear
	bsf		FLAG_RM,0	; ready for next remote control
	goto	CLR_RMF

ONE
	movf	PARAMETERS,w; parameters flag (setup channel parameters)
	movlw	D'1'		; value
	btfss	STATUS,Z	; if clear normal channel change
	goto	PARAM	
	btfsc	FLAG_RM,0	; if set then already passed here
	goto	CLR_RMF
	btfsc	B_STAT,0	; if set then toggle
	goto	TOG_1		; toggle (alternate mode)
	bsf		PORTB_BUFF,0		; output high
	bsf		FLAG_RM,0	; set continuous mode
	goto	CLR_RMF
TOG_1
	btfsc	PORTB_BUFF,0		; if high clear
	goto	CLR_1
	bsf		PORTB_BUFF,0		; low so set
	bsf		FLAG_RM,0	; ready for next remote control input
	goto	CLR_RMF	
CLR_1	
	bcf		PORTB_BUFF,0		; high so clear
	bsf		FLAG_RM,0	; ready for next remote control
	goto	CLR_RMF

TWO
	movf	PARAMETERS,w; parameters flag (setup channel parameters)
	movlw	D'2'		; value
	btfss	STATUS,Z	; if clear normal channel change
	goto	PARAM
	btfsc	FLAG_RM,0	; if set then already passed here
	goto	CLR_RMF
	btfsc	A_STAT,4	; if set then toggle
	goto	TOG_2		; toggle (alternate mode)
	bsf		PORTA_BUFF,4		; 2 output high
	bsf		FLAG_RM,0	; set continuous mode
	goto	CLR_RMF
TOG_2
	btfsc	PORTA_BUFF,4		; if high clear
	goto	CLR_2
	bsf		PORTA_BUFF,4		; low so set
	bsf		FLAG_RM,0	; ready for next remote control input
	goto	CLR_RMF	
CLR_2
	bcf		PORTA_BUFF,4		; high so clear
	bsf		FLAG_RM,0	; ready for next remote control
	goto	CLR_RMF

THREE
	movf	PARAMETERS,w; parameters flag (setup channel parameters)
	movlw	D'3'		; value
	btfss	STATUS,Z	; if clear normal channel change
	goto	PARAM
	btfsc	FLAG_RM,0	; if set then already passed here
	goto	CLR_RMF
	btfsc	A_STAT,3	; if set then toggle
	goto	TOG_3		; toggle (alternate mode)
	bsf		PORTA_BUFF,3		; output high
	bsf		FLAG_RM,0	; set continuous mode
	goto	CLR_RMF
TOG_3
	btfsc	PORTA_BUFF,3		; if high clear
	goto	CLR_3
	bsf		PORTA_BUFF,3		; low so set
	bsf		FLAG_RM,0	; ready for next remote control input
	goto	CLR_RMF	
CLR_3
	bcf		PORTA_BUFF,3		; high so clear
	bsf		FLAG_RM,0	; ready for next remote control
	goto	CLR_RMF

FOUR
	movf	PARAMETERS,w; parameters flag (setup channel parameters)
	movlw	D'4'		; value
	btfss	STATUS,Z	; if clear normal channel change
	goto	PARAM
	btfsc	FLAG_RM,0	; if set then already passed here
	goto	CLR_RMF
	btfsc	A_STAT,2	; if set then toggle
	goto	TOG_4		; toggle (alternate mode)
	bsf		PORTA_BUFF,2		; output high
	bsf		FLAG_RM,0	; set continuous mode
	goto	CLR_RMF
TOG_4
	btfsc	PORTA_BUFF,2		; if high clear
	goto	CLR_4
	bsf		PORTA_BUFF,2		; low so set
	bsf		FLAG_RM,0	; ready for next remote control input
	goto	CLR_RMF	
CLR_4
	bcf		PORTA_BUFF,2		; high so clear
	bsf		FLAG_RM,0	; ready for next remote control
	goto	CLR_RMF

FIVE
	movf	PARAMETERS,w; parameters flag (setup channel parameters)
	movlw	D'5'		; value
	btfss	STATUS,Z	; if clear normal channel change
	goto	PARAM
	btfsc	FLAG_RM,0	; if set then already passed here
	goto	CLR_RMF
	btfsc	A_STAT,1	; if set then toggle
	goto	TOG_5		; toggle (alternate mode)
	bsf		PORTA_BUFF,1		; output high
	bsf		FLAG_RM,0	; set continuous mode
	goto	CLR_RMF
TOG_5
	btfsc	PORTA_BUFF,1		; if high clear
	goto	CLR_5
	bsf		PORTA_BUFF,1		; low so set
	bsf		FLAG_RM,0	; ready for next remote control input
	goto	CLR_RMF	
CLR_5
	bcf		PORTA_BUFF,1		; high so clear
	bsf		FLAG_RM,0	; ready for next remote control
	goto	CLR_RMF

SIX	
	movf	PARAMETERS,w; parameters flag (setup channel parameters)
	movlw	D'6'		; value
	btfss	STATUS,Z	; if clear normal channel change
	goto	PARAM
	btfsc	FLAG_RM,0	; if set then already passed here
	goto	CLR_RMF
	btfsc	A_STAT,0	; if set then toggle
	goto	TOG_6		; toggle (alternate mode)
	bsf		PORTA_BUFF,0		; output high
	bsf		FLAG_RM,0	; set continuous mode
	goto	CLR_RMF
TOG_6
	btfsc	PORTA_BUFF,0		; if high clear
	goto	CLR_6
	bsf		PORTA_BUFF,0		; low so set
	bsf		FLAG_RM,0	; ready for next remote control input
	goto	CLR_RMF	
CLR_6
	bcf		PORTA_BUFF,0		; high so clear
	bsf		FLAG_RM,0	; ready for next remote control
	goto	CLR_RMF

SEVEN
	movf	PARAMETERS,w; parameters flag (setup channel parameters)
	movlw	D'7'		; value
	btfss	STATUS,Z	; if clear normal channel change
	goto	PARAM
	btfsc	FLAG_RM,0	; if set then already passed here
	goto	CLR_RMF
	btfsc	A_STAT,7	; if set then toggle
	goto	TOG_7		; toggle (alternate mode)
	bsf		PORTA_BUFF,7		; output high
	bsf		FLAG_RM,0	; set continuous mode
	goto	CLR_RMF
TOG_7
	btfsc	PORTA_BUFF,7		; if high clear
	goto	CLR_7
	bsf		PORTA_BUFF,7		; low so set
	bsf		FLAG_RM,0	; ready for next remote control input
	goto	CLR_RMF	
CLR_7
	bcf		PORTA_BUFF,7		; high so clear
	bsf		FLAG_RM,0	; ready for next remote control
	goto	CLR_RMF

EIGHT
	movf	PARAMETERS,w; parameters flag (setup channel parameters)
	movlw	D'8'		; value
	btfss	STATUS,Z	; if clear normal channel change
	goto	PARAM
	btfsc	FLAG_RM,0	; if set then already passed here
	goto	CLR_RMF
	btfsc	A_STAT,6	; if set then toggle
	goto	TOG_8		; toggle (alternate mode)
	bsf		PORTA_BUFF,6		; output high
	bsf		FLAG_RM,0	; set continuous mode
	goto	CLR_RMF
TOG_8
	btfsc	PORTA_BUFF,6; if high clear
	goto	CLR_8
	bsf		PORTA_BUFF,6; low so set
	bsf		FLAG_RM,0	; ready for next remote control input
	goto	CLR_RMF	
CLR_8
	bcf		PORTA_BUFF,6; high so clear
	bsf		FLAG_RM,0	; ready for next remote control
	goto	CLR_RMF

NINE
	movf	PARAMETERS,w; parameters flag (setup channel parameters)
	movlw	D'9'		; value
	btfss	STATUS,Z	; if clear normal channel change
	goto	PARAM
	btfsc	FLAG_RM,0	; if set then already passed here
	goto	CLR_RMF
	btfsc	B_STAT,7	; if set then toggle
	goto	TOG_9		; toggle (alternate mode)
	bsf		PORTB_BUFF,7		; output high
	bsf		FLAG_RM,0	; set continuous mode
	goto	CLR_RMF
TOG_9
	btfsc	PORTB_BUFF,7		; if high clear
	goto	CLR_9
	bsf		PORTB_BUFF,7		; low so set
	bsf		FLAG_RM,0	; ready for next remote control input
	goto	CLR_RMF	
CLR_9
	bcf		PORTB_BUFF,7		; high so clear
	bsf		FLAG_RM,0	; ready for next remote control
	goto	CLR_RMF

CH_UP
	bsf		PARAMETERS,0; set flag for entering
	movlw	D'150'
	movwf	TIME_LOOP
	movwf	TIMEOUT		; timeout period for parameters
	bsf		PORTB_BUFF,6
	bsf		PORTB,6		; ACK LED on
	clrf	REM_FLG		; remote flag cleared
	clrf	FLAG_RM		; continuous flag
	clrf	PARAM_CNTR
	goto	RM_CK
CH_DN
	bcf		PARAMETERS,0; clear flag for entering
	clrf	TIMEOUT		; time out period for parameters	
	bcf		PORTB,6		; ACK LED off
	bcf		PORTB_BUFF,6
	clrf	REM_FLG		; remote flag cleared
	bcf		FLAG_RM,0	; ready for next remote control
	goto	RM_CK

; ......................................
PARAM ; parameters entering options sequence
	btfsc	FLAG_RM,0	; if set then already passed here
	goto	CLR_RMFx
	movwf	PARAM_TMP	; temporary storage of w
	movf	PARAM_CNTR,w; get current parameter counter position
	btfsc	STATUS,Z	; if zero store in channel
	goto	CHANNEL
;	
	movf	PARAM_CNTR,w; get current parameter counter position
	xorlw	D'1'		; position 1
	btfsc	STATUS,Z	; if =1 store in momentary/toggle
	goto	MOM_TOG

	movf	PARAM_CNTR,w; get current parameter counter position
	xorlw	D'2'		; position 2
	btfss	STATUS,Z	; if zero store in powerup level for toggle
	goto	OUT_PARAM1	; bypass further changes
; power up setting
PU_SET ; set powerup on or off

	movf	PARAM_TMP,w
	movwf	PARAM_PU
	bcf		PARAMETERS,0; clear flag for entering
	movlw	D'25'
	call	FLASH_ACK
	bcf		PORTB,6		; ACK LED off
	bcf		PORTB_BUFF,6
	clrf	REM_FLG		; remote flag cleared
	bcf		FLAG_RM,0	; ready for next remote control
	goto	END_PARAM	; store changes


MOM_TOG ; momentary or toggle selection
	movf	PARAM_TMP,w
	movwf	PARAM_M_T	; momentary or toggle selection (0 is momentary, 1 is toggle)
; if 0 (for momentary) then bypass manually entering Power Up value
	btfsc	STATUS,Z
	goto	PU_SET		; provides 0 for PU with momentary setting
; otherwise allow for next entry for power up status in toggle mode 
	goto	OUT_PARAM

CHANNEL; position zero is channel value
	
	movf	PARAM_TMP,w
	movwf	PARAM_CH	; parameter channel

OUT_PARAM
	incf	PARAM_CNTR,f; next position
OUT_PARAM1
	bsf		FLAG_RM,0	; ready for next remote control
	movlw	D'25'
	call	FLASH_ACK	
	bsf		PORTB,6
	bsf		PORTB_BUFF,6
	clrf	REM_FLG		; remote flag cleared
	bsf		STATUS,GIE	; interrupt 
	goto	RM_CK

END_PARAM

; store in A_STAT or B_STAT (Momentary or Toggle) and START_A or START_B (power up state)
; CH0
	movf	PARAM_CH,w
	btfsc	STATUS,Z
	goto	LD0
; CH1
	movf	PARAM_CH,w
	xorlw	D'1'
	btfsc	STATUS,Z
	goto	LD1
; CH2
	movf	PARAM_CH,w
	xorlw	D'2'
	btfsc	STATUS,Z
	goto	LD2
; CH3
	movf	PARAM_CH,w
	xorlw	D'3'
	btfsc	STATUS,Z
	goto	LD3
; CH4
	movf	PARAM_CH,w
	xorlw	D'4'
	btfsc	STATUS,Z
	goto	LD4
; CH5
	movf	PARAM_CH,w
	xorlw	D'5'
	btfsc	STATUS,Z
	goto	LD5
; CH6
	movf	PARAM_CH,w
	xorlw	D'6'
	btfsc	STATUS,Z
	goto	LD6
; CH7
	movf	PARAM_CH,w
	xorlw	D'7'
	btfsc	STATUS,Z
	goto	LD7
; CH8
	movf	PARAM_CH,w
	xorlw	D'8'
	btfsc	STATUS,Z
	goto	LD8
; CH9
	movf	PARAM_CH,w
	xorlw	D'9'
	btfsc	STATUS,Z
	goto	LD9

LD0 ; RB1. PARAM_M_T and PARAM_PU bit 1
	
;B_STAT is for momentary/toggle and START_B is power up  	
	bcf		B_STAT,1	; clear status for CH0
	bcf		START_B,1	; clear power up for CH0
	btfsc	PARAM_M_T,0	; for momentary/toggle (0 or 1) then clear or set bit 1
	bsf		B_STAT,1
	btfsc	PARAM_PU,0	; for power up off or on (0 or 1) then clear or set bit 1
	bsf		START_B,1

; store in EEPROM
STO_PARAM_B 
	movlw	H'01'		; for B port
	call	EEREAD		; sets EEADR
	movf	B_STAT,w	; B port toggle or momentary
	call	EEWRITE

	movlw	H'03'		; for B port
	call	EEREAD		; sets EEADR
	movf	START_B,w
	call	EEWRITE

	goto	OUT_PARAM1	; Parameters cycle ended
LD1
; RB0. PARAM_M_T and PARAM_PU bit 1
	
;B_STAT is for momentary/toggle and START_B is power up  	
	bcf		B_STAT,0	; clear status for CH1
	bcf		START_B,0	; clear power up for CH1
	btfsc	PARAM_M_T,0	; for momentary/toggle (0 or 1) then clear or set bit 1
	bsf		B_STAT,0
	btfsc	PARAM_PU,0	; for power up off or on (0 or 1) then clear or set bit 1
	bsf		START_B,0
	goto	STO_PARAM_B	; store in EEPROM
LD2
; RA4. PARAM_M_T and PARAM_PU bit 1
	
;A_STAT is for momentary/toggle and START_A is power up  	
	bcf		A_STAT,4	; clear status for CH2
	bcf		START_A,4	; clear power up for CH2
	btfsc	PARAM_M_T,0	; for momentary/toggle (0 or 1) then clear or set bit 1
	bsf		A_STAT,4
	btfsc	PARAM_PU,0	; for power up off or on (0 or 1) then clear or set bit 1
	bsf		START_A,4
; store in EEPROM
STO_PARAM_A
	movlw	H'00'		; for A port
	call	EEREAD		; sets EEADR
	movf	A_STAT,w	; A port toggle or momentary
	call	EEWRITE
	movlw	H'02'		; for A port
	call	EEREAD		; sets EEADR
	movf	START_A,w
	call	EEWRITE
	goto	OUT_PARAM1	; Parameters cycle ended
LD3
; RA3. PARAM_M_T and PARAM_PU bit 1
	
;A_STAT is for momentary/toggle and START_A is power up  	
	bcf		A_STAT,3	; clear status for CH3
	bcf		START_A,3	; clear power up for CH3
	btfsc	PARAM_M_T,0	; for momentary/toggle (0 or 1) then clear or set bit 1
	bsf		A_STAT,3
	btfsc	PARAM_PU,0	; for power up off or on (0 or 1) then clear or set bit 1
	bsf		START_A,3
; store in EEPROM
	goto	STO_PARAM_A
LD4
; RA2. PARAM_M_T and PARAM_PU bit 1
	
;A_STAT is for momentary/toggle and START_A is power up  	
	bcf		A_STAT,2	; clear status for CH4
	bcf		START_A,2	; clear power up for CH4
	btfsc	PARAM_M_T,0	; for momentary/toggle (0 or 1) then clear or set bit 1
	bsf		A_STAT,2
	btfsc	PARAM_PU,0	; for power up off or on (0 or 1) then clear or set bit 1
	bsf		START_A,2
; store in EEPROM
	goto	STO_PARAM_A
LD5
; RA1. PARAM_M_T and PARAM_PU bit 1
	
;A_STAT is for momentary/toggle and START_A is power up  	
	bcf		A_STAT,1	; clear status for CH5
	bcf		START_A,1	; clear power up for CH5
	btfsc	PARAM_M_T,0	; for momentary/toggle (0 or 1) then clear or set bit 1
	bsf		A_STAT,1
	btfsc	PARAM_PU,0	; for power up off or on (0 or 1) then clear or set bit 1
	bsf		START_A,1
; store in EEPROM
	goto	STO_PARAM_A
LD6
; RA0. PARAM_M_T and PARAM_PU bit 1
	
;A_STAT is for momentary/toggle and START_A is power up  	
	bcf		A_STAT,0	; clear status for CH6
	bcf		START_A,0	; clear power up for CH6
	btfsc	PARAM_M_T,0	; for momentary/toggle (0 or 1) then clear or set bit 1
	bsf		A_STAT,0
	btfsc	PARAM_PU,0	; for power up off or on (0 or 1) then clear or set bit 1
	bsf		START_A,0
; store in EEPROM
	goto	STO_PARAM_A
LD7
; RA7. PARAM_M_T and PARAM_PU bit 1
	
;A_STAT is for momentary/toggle and START_A is power up  	
	bcf		A_STAT,7	; clear status for CH7
	bcf		START_A,7	; clear power up for CH7
	btfsc	PARAM_M_T,0	; for momentary/toggle (0 or 1) then clear or set bit 1
	bsf		A_STAT,7
	btfsc	PARAM_PU,0	; for power up off or on (0 or 1) then clear or set bit 1
	bsf		START_A,7
; store in EEPROM
	goto	STO_PARAM_A
LD8
; RA6. PARAM_M_T and PARAM_PU bit 1
	
;A_STAT is for momentary/toggle and START_A is power up  	
	bcf		A_STAT,6	; clear status for CH8
	bcf		START_A,6	; clear power up for CH8
	btfsc	PARAM_M_T,0	; for momentary/toggle (0 or 1) then clear or set bit 1
	bsf		A_STAT,6
	btfsc	PARAM_PU,0	; for power up off or on (0 or 1) then clear or set bit 1
	bsf		START_A,6
; store in EEPROM
	goto	STO_PARAM_A
LD9
; RB7. PARAM_M_T and PARAM_PU bit 1
	
;B_STAT is for momentary/toggle and START_B is power up  	
	bcf		B_STAT,7	; clear status for CH9
	bcf		START_B,7	; clear power up for CH9
	btfsc	PARAM_M_T,0	; for momentary/toggle (0 or 1) then clear or set bit 1
	bsf		B_STAT,7
	btfsc	PARAM_PU,0	; for power up off or on (0 or 1) then clear or set bit 1
	bsf		START_B,7
	goto	STO_PARAM_B	; store in EEPROM

; ..................................

CLR_RMFx ; parameters
	clrf	REM_FLG
	bsf		STATUS,GIE	; interrupt 
	goto	RM_CK
CLR_RMF2 ; codes not matching/valid
	clrf	REM_FLG		; remote flag cleared
; if parameters mode bypass clearing ACK LED and remote flags
	movf	PARAMETERS,w; parameters flag (setup channel parameters)
	btfss	STATUS,Z	; if zero, normal channel change
	goto	CLR_RMX	
	bcf		PORTB,6		; ACK out
	bcf		PORTB_BUFF,6
	clrf	REM_FLG
	bcf		PORTB,6
	bcf		PORTB_BUFF,6

	bsf		STATUS,GIE	; interrupt 
	goto	RM_CK

CLR_RMX
; parameters ending
	movf	A_STAT,w	; check portA status (high is toggle so anding will keep status)
	andwf	PORTA_BUFF,f		; clear all momentary outputs keep toggles at current status
	movf	PORTA_BUFF,w
	movwf	PORTA
	movf	B_STAT,w
	iorlw	B'01000000'	; keep ACK
	andwf	PORTB_BUFF,f
	movf	PORTB_BUFF,w 
	movwf	PORTB

CLR_RM1 ; remote control sequence not started yet
	clrf	FLAG_RM		; clear continuous mode flag
	call	END_CODE
	goto	RM_CK	
CLR_RMF ; continuous mode
	movf	PORTA_BUFF,w; transfer buffer to port
	movwf	PORTA
	movf	PORTB_BUFF,w
	movwf	PORTB
	call	END_CODE
	movlw	D'5'
	call	FLASH_ACK
	goto	RM_CK
END_CODE
	clrf	REM_FLG		; remote flag cleared

; if parameters mode bypass clearing ACK LED
	movf	PARAMETERS,w; parameters flag (setup channel parameters)
	btfss	STATUS,Z	; if zero, normal channel change
	goto	BY_CLR_ACK
	bcf		PORTB,6		; ACK out
	bcf		PORTB_BUFF,6
CK_RMO_1
	btfsc	FLAG_RM,0	; if set then already passed here
	return
;	movlw	D'6'
;	call	DELAYT

	movf	A_STAT,w	; check portA status (high is toggle so anding will keep status)
	andwf	PORTA_BUFF,f		; clear all momentary outputs keep toggles at current status
	movf	PORTA_BUFF,w
	movwf	PORTA
	movf	B_STAT,w
	iorlw	B'01000000'	; keep ACK
	andwf	PORTB_BUFF,f
	movf	PORTB_BUFF,w 
	movwf	PORTB
	
	bsf		STATUS,GIE	; interrupt 
	return
BY_CLR_ACK
	bsf		PORTB,6		; keep ACK LED on
	bsf		PORTB_BUFF,6
	goto	CK_RMO_1
	
	
FLASH_ACK
; flash ACK LED
	movwf	PERIOD		; set acknowledge period
	movlw	D'5'
	movwf	VALUE_3		; number of flashes
FLASH_CYCLE
	movf	PERIOD,w	; flash period
LED_PERIOD
	call	DELAYT
	btfss	PORTB_BUFF,6		; ACK LED
	goto	SET_ACK
	bcf		PORTB,6
	bcf		PORTB_BUFF,6
	goto	FLASH
SET_ACK
	bsf		PORTB,6
	bsf		PORTB_BUFF,6
FLASH
	decfsz	VALUE_3,f
	goto	FLASH_CYCLE
	return

; **********************************************************

; subroutines

; delay subroutine
DELAY	
	movlw	D'255'		; 
DELAYT
	movwf	VALUE_1		; VALUE_1 = w
LP_X
	movlw	D'255'		; set delay period value 2 
	movwf	VALUE_2		; VALUE_2 = w
LP_Y
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_Y
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_X
	return
	
; subroutine to read EEPROM memory 

EEREAD
	bsf 	STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM

; EEPROM write 

EEWRITE
	bcf		STATUS,GIE
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	movwf	DATA_VAL	; store
	bsf		STATUS,RP0	; bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
WRITE1	

	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE1		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0
	bcf		STATUS,RP1	; bank 0 

; check if written correctly

	movf	EEP_CNTR,w	; write repeats counter 
	btfss	STATUS,Z	; if zero, set
	goto	CNTR_DEC
	movlw	D'4'		; repeat writes
	movwf	EEP_CNTR
CNTR_DEC
	decfsz	EEP_CNTR,f
	goto	RD_WRITE
	goto	SAME		; out if repeat writes not successful
RD_WRITE
	bsf 	STATUS,RP1	; select memory bank 2
	movf 	EEADR,w		; indirect special function register
	bcf		STATUS,RP1	; select bank 0
	call	EEREAD		; read EEPROM result in w
	xorwf	DATA_VAL,w	; compare EEPROM with value written
	btfsc	STATUS,Z
	goto	SAME
	movf	DATA_VAL,w	; data
	goto	EEWRITE
SAME
	bsf		STATUS,GIE
	return				; value written
	
	end


	
