
 
; UHF receiver to IR LED Converter


	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_ON & _BODEN_ON  & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
	

; bank 0 RAM 


STORE1			equ	H'22'	; delay counter	
STORE2			equ	H'23'	; delay counter
PORT			equ	H'24'	; port store
FREQ			equ	H'25'	; frequency
FREQ_STORE		equ	H'26'	; storage
TIMEOUT			equ	H'27'	; indicates timer1 status; timing or timeout
INSET			equ	H'28'	; input GPIO5
RUN				equ	H'29'	; counter
 
; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN		; 
;	org     4			; interrupt vector not used

TEN	; lookup table to convert to ten frequency values
; (clear bit 7 for these) 4=45kHz 3=41kHz, 2=38kHz, 1=35kHz, 0=33kHz
; (set bit 7 for these) 4=47kHz 3=43kHz, 2=40kHz, 1=37kHz, 0=34kHz
	addwf	PCL,f
	retlw	H'00'		; 0, 33kHz trim pot dead zone
	retlw	H'00'		; 1, 33kHz trim pot dead zone
	retlw	H'00'		; 2, 33kHz trim pot dead zone
	retlw	H'00'		; 3, 33kHz

	retlw	H'80'		; 4, 34kHz
	retlw	H'01'		; 5, 35kHz
	retlw	H'81'		; 6, 37kHz
	retlw	H'02'		; 7, 38kHz 
; mid travel pot
	retlw	H'82'		; 8, 40kHz
	retlw	H'03'		; 9, 41kHz
	retlw	H'83'		; 10, 43kHz
	retlw	H'04'		; 11, 45kHz

	retlw	H'84'		; 12, 47kHz
	retlw	H'84'		; 13, 47kHz trim pot dead zone
	retlw	H'84'		; 14, 47kHz trim pot dead zone
	retlw	H'84'		; 15, 47kHz	trim pot dead zone


MAIN
	bsf		STATUS,RP0	; select memory bank 1
; calibrate internal oscillator
	call	H'3FF'	
	movwf	OSCCAL
	
	bcf		STATUS,RP0	; select memory bank 0
	call	DELAYms		; add small delay

; set inputs/outputs
	clrf	GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'	; pullups off
	movwf	WPU
	movlw	B'00111100'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'00000100'	; settings (pullups enabled) timer0/32 (8ms)
	movwf	OPTION_REG

; analog inputs, A/D
	movlw	B'01011000'	; AN3 analog input 
	movwf	ANSEL
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00001100'	; channel 3 
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on

; initial conditions
	movlw	B'00000000'	; port low
	movwf	GPIO	
	call	DELAYms		; add small delay


	clrf	TMR1H
	clrf	TMR1L
	bcf		T1CON,5		; /1 prescaler
	bcf		T1CON,4
	bsf		T1CON,0		; timer 1 on	

	call	DELAYms		; add small delay

; allow interrupts
ALL_INTERRUPTS
	bsf		STATUS,RP0	; select memory bank 1		
	bsf		PIE1,TMR1IE	; timer 1 overflow interrupt
	bcf		STATUS,RP0	; select memory bank 0
	bsf		INTCON,T0IE	; timer 0 enable
	bcf		INTCON,T0IF	; timer 0 interrupt flag
	bcf		PIR1,TMR1IF	; timer 1 interrupt flag

INPUT_SIGX

; if timer1 timeout flag set, (after 654ms of no 8.192ms quieting periods) clear timeout

	btfss	PIR1,TMR1IF	
	goto	BY_TIMEOUT
	clrf	TIMEOUT		; timeout flag cleared
	bcf		GPIO,0		; clear ACK.
BY_TIMEOUT
; locate 8ms gaps (GP5 continuously low). Then start (set timeout,0) the timeout flag to run the output

; check for 8ms periods of no signal. A gap indicates an incoming signal (not noise)
; If these do not occur, then allow timeout with timer1. Reset timer1 and timer1 flag for each gap detected

; check GP5. If low check if low for 8ms. If so reset countdown period
	call	PORT_RUN
	btfss	INSET,5
	goto	LOWIN
; GP5 whenever high reset timer0 
	clrf	TMR0		; reset timer 0 	
	bcf		INTCON,T0IF	; 
	goto	START

LOWIN
	btfss	INTCON,T0IF	; 8ms period flag, if set then input low for 8ms
	goto	INPUT_SIGX
; input low for 8ms
	bsf		TIMEOUT,0	; allow signal output with flag set
; clear timer1
	clrf	TMR1H
	clrf	TMR1L
	bcf		PIR1,TMR1IF	; timer 1 interrupt flag

; check frequency setting
	call	ACQUIRE_AD
	comf	ADRESH,f	; reverse sense
	swapf 	ADRESH,w	; get ms bits
	andlw	H'0F'		; remove the now ls bits
	call	TEN			; get 1 of 10 possible frequency values
	movwf	FREQ_STORE		; for INPUT_SIG/1 carrier frequency

; start output with timeout flag set
START
  	btfss	TIMEOUT,0	; only run when flag is set 	
	goto	INPUT_SIGX	

	call	PORT_RUN	; check input GPIO5 (INSET,5)
; select frequency and generator
	movf	FREQ_STORE,w		; frequency value
	movwf	FREQ
	bcf		GPIO,0		; clear ACK.


	btfsc	INSET,5		; set ACK LED when input is high
	bsf		GPIO,0		; acknowledge
	btfss	FREQ,7		; if bit 7 set use INPUT_SIG1
	goto	INPUT_SIG
	bcf		FREQ,7		; clear bit 7 that selects the generator (input_sig or input_sig1)
	movf	FREQ,w		; w for INPUT_SIG1
	goto	INPUT_SIG1

INPUT_SIG
	
; 4=45kHz 3=41kHz, 2=38kHz, 1=35kHz, 0=33kHz
; check for a high at GP5

	btfss	GPIO,5		; when high begin to read data
	goto	LOW2

; generate carrier
	btfss	PORT,1
	goto	LOW1
	bcf		PORT,1
	bcf		GPIO,1

; **** ensure does not cross page boundary by adding 4 to PCL
	addwf	PCL,f
	nop
	nop
	nop
	nop
	goto	INPUT_SIG
LOW1
	bsf		PORT,1
	bsf		GPIO,1
	addwf	PCL,f
	nop
	nop
	nop
	nop
	nop
	goto	INPUT_SIG

INPUT_SIG1

; 4=47kHz 3=43kHz, 2=40kHz, 1=37kHz, 0=34kHz

	btfss	GPIO,5		; when high begin to read data
	goto	LOW2

; generate carrier
	btfss	PORT,1
	goto	LOW11
	bcf		PORT,1
	bcf		GPIO,1

; **** ensure does not cross page boundary by adding 4 to PCL
	addwf	PCL,f
	nop
	nop
	nop
	nop
	goto	INPUT_SIG1
LOW11
	bsf		PORT,1
	bsf		GPIO,1
	addwf	PCL,f
	nop
	nop
	nop
	nop
	goto	INPUT_SIG1

LOW2
	bcf		GPIO,1		; clear when input low
	bcf		PORT,1
	
	goto	INPUT_SIGX	



; ***************************************************************************	

; Subroutines

; delay loop 

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B0'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,GO_DONE	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,GO_DONE	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return

; check for high at GP5
PORT_RUN
	btfss	GPIO,5
	goto	LOW_RUN
; check if remains high for 15us
	movlw	D'3'
	movwf	RUN
RUN_HI	
	decfsz	RUN,f
	goto	CK_HI
; yes high for 100us
	bsf		INSET,5
	return
CK_HI
	btfsc	GPIO,5		; check high
	goto	RUN_HI		; still high
LOW_RUN
	bcf		INSET,5		; low so set inset,5 low
	return


	end
