                                          
 
;IR to UHF Converter

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT	

; RAM 

STORE1			equ	H'20'	; 
DATA_COUNT		equ	H'21'	; data output counter
POWER_COUNT		equ	H'22'	; power counter 
DLY_LOOP		equ	H'23'	; delay loop


; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN
	    			 
	org		4			; interrupt vector not used

; ***********************************************************
		
MAIN
; set oscillator calibration
	bsf		STATUS,RP0	; bank 1
	call	H'3FF'		; oscillator calibration value
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0

; set inputs/outputs
	movlw	H'00'
	movwf	GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	clrf	ANSEL		; digital I/O
	movlw	B'00000000'	; pullups off
	movwf	WPU	
	movlw	B'00000001'
	movwf	IOC			; interrupt on change for GPIO,0
	movlw	B'00000001'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'10000111'	; settings (pullups disabled) prescaler/128 
	movwf	OPTION_REG
	bcf		STATUS,RP0	; select memory bank 0


	movlw	B'00001000'	; IOC flag enabled (for GPIO,0)
	movwf	INTCON

; initial conditions

	movlw	H'00'
	movwf	GPIO		; outputs low 
; set power timer to max
	movlw	D'250'		; power up counter
	movwf	POWER_COUNT
	movlw	D'250'
	movwf	STORE1		; power up extension period
; set Data timer to max
	movlw	D'4'
	movwf	DATA_COUNT


DECODE

; if GPIO,0 is high, set VCC and data high
	btfss	GPIO,0
	goto	IN_LOW

; check GPIO,2 for a high. If high bypass
	btfsc	GPIO,2
	goto	RST_PWR
; high so power up the UHF transmitter and data high
	movlw	B'00110010'; set GPIO,1,4,5
	movwf	GPIO
; add delay to compensate for off delay
	movlw	D'17'
	movwf	DLY_LOOP

START_DELAY
	decfsz	DLY_LOOP,f
	goto	START_DELAY
	movlw	B'00110110'; set GPIO,1,2,4,5
	movwf	GPIO
; reset power timer to max
RST_PWR
	movlw	D'250'		; power up counter
	movwf	POWER_COUNT
	movlw	D'250'
	movwf	STORE1		; power up extension period
; reset Data timer to max
	movlw	D'4'
	movwf	DATA_COUNT

	goto	DECODE
	
IN_LOW
; if low,

	
; count down power timer. When ended clear power and data & sleep
	decfsz	STORE1,f
	goto	DATA_TIMER
	movlw	D'250'
	movwf	STORE1
	decfsz	POWER_COUNT,f
	goto	DATA_TIMER
	movlw	D'250'		; power up counter
	movwf	POWER_COUNT
; clear outputs
	movlw	B'00000000'; clear GPIO,1,2,4,5
	movwf	GPIO
	goto	STOP

DATA_TIMER
; count down data level timer. When ended clear data	
	decfsz	DATA_COUNT,f
	goto	DECODE
	movlw	D'4'		; data counter
	movwf	DATA_COUNT
; clear data output
	movlw	B'00110010'; clear GPIO2 Data line to UHF transmitter
	movwf	GPIO
	goto	DECODE

STOP ; power down till signal reoccurs

; read GPIO clear flag wait for new signal
	movf	GPIO,w
	bcf		INTCON,GPIF		; clear flag
	sleep
	nop
	goto	DECODE
       

	end
