
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  WAV.h: WAV file read functions
  Written by Mauro Grassi and updated by Nicholas Vinen, 2009-2013
*/

#ifndef _WAV_H
#define _WAV_H

#define RIFF_HEADER_ID		0x46464952	/* "RIFF" Container type */
#define WAV_HEADER_ID		0x45564157	/* "WAVE" WAV file format */
#define DATA_HEADER_ID		0x61746164	/* "data" Audio Data */
#define FMT_HEADER_ID		0x20746D66	/* "fmt " Audio Format */
#define LIST_HEADER_ID		0x7473696C	/* "list" Track Info */

#define LIST_INFO_ID		0x6F666E69	/* "info" inside LIST */
#define ARTIST_INFO_ID		0x74726169	/* "iart" Artist */
#define TRACK_INFO_ID		0x6D616E69	/* "inam" Name */
#define DATE_INFO_ID		0x64726369      /* "icrd" Creation Date */
#define COMMENT_INFO_ID		0x746D6369	/* "icmt" Comment */

#define MAX_TITLE_LENGTH	64
#define MAX_ARTIST_LENGTH	32
#define MAX_DATE_LENGTH		8
#define MAX_COMMENT_LENGTH	32

typedef struct
{
	unsigned long chunkID;
	unsigned long chunkSize;
} CHUNK_HEADER;

typedef struct
{
	CHUNK_HEADER riff;
	unsigned long WAVID;
} RiffHeader;

typedef struct
{
	CHUNK_HEADER data;
	unsigned char* dataPtr;
} DataHeader;

typedef struct
{
	CHUNK_HEADER 	list;
	unsigned long   INFOID;
	unsigned char	trackTitle[MAX_TITLE_LENGTH];
	unsigned char	trackArtist[MAX_ARTIST_LENGTH];
	unsigned char	trackDate[MAX_DATE_LENGTH];
	unsigned char	trackComment[MAX_COMMENT_LENGTH];
} ListHeader;

typedef struct
{
	CHUNK_HEADER 	fmt;
	unsigned short 	audioFormat;	// 2
	unsigned short 	numChannels;	// 2
	unsigned long 	sampleRate;		// 4
	unsigned long 	byteRate;		// 4
	unsigned short 	blockAlign;		// 2
	unsigned short 	bitsPerSample;	// 2
} FmtHeader;

typedef struct
{
	RiffHeader		riffHeader;
	FmtHeader		fmtHeader;
	ListHeader		listHeader;
	DataHeader		dataHeader;
} WAVHeader;

unsigned int WAVgetInt(unsigned char* inPtr, unsigned int* x);
unsigned int WAVgetLong(unsigned char* inPtr, unsigned long* x);
unsigned char WAVconvertToUpper(unsigned char in);
unsigned int WAVgetIDu(unsigned char* inPtr, unsigned long* x);
unsigned int WAVgetIDl(unsigned char* inPtr, unsigned long* x);
unsigned int WAVreadRiffChunk(unsigned char* inPtr, RiffHeader* riffHeader, unsigned int skipIt);
unsigned int WAVreadDataChunk(unsigned char* inPtr, DataHeader* dataHeader, unsigned int skipIt);
unsigned int WAVreadFmtChunk(unsigned char* inPtr, FmtHeader* fmtHeader, unsigned int skipIt);
unsigned int WAVreadListChunk(unsigned char* inPtr, ListHeader* listHeader, unsigned int skipIt);
unsigned int WAVreadWAVChunk(unsigned char* inPtr, WAVHeader* header, unsigned int* isDataChunk, unsigned int skipIt);
unsigned int WAVreadWAVHeader(unsigned char* inPtr, WAVHeader* header, unsigned int maxBytes);
void WAVinitHeader(WAVHeader* header);
unsigned int WAVmakeWAVHeader(unsigned char* Ptr, const WAVHeader* pheader, unsigned int maxBytes);

#endif
