
typedef struct {
  int sock, block;
  enum { disconnected, connecting, connected } connection_state;
  size_t bytes_left;
  unsigned long ip;
  unsigned short port;
} TCPWAVStream;

int TCPWAVStream_Init(TCPWAVStream* pStream, const char* dest);
int TCPWAVStream_Connect(TCPWAVStream* pStream, int block, int buffer_size);
void TCPWAVStream_Disconnect(TCPWAVStream* pStream);
int TCPWAVStream_IsConnected(TCPWAVStream* pStream);

int TCPWAVStream_SendHeader(TCPWAVStream* pStream, const unsigned char* data, size_t len, int block, size_t max_data_len);
int TCPWAVStream_SendData(TCPWAVStream* pStream, const unsigned char* data, size_t len, int block);
