
#include "FIFO.h"
#include <stdlib.h>
#include <string.h>

void FIFO_Init(FIFO* pFIFO, unsigned int size) {
  pFIFO->size = size;
  pFIFO->head = 0;
  pFIFO->tail = 0;
  pFIFO->full = 0;
  pFIFO->data = (unsigned char*)malloc(size);
}

void FIFO_Deinit(FIFO* pFIFO) {
  free(pFIFO->data);
  pFIFO->data = 0;
}

void FIFO_Empty(FIFO* pFIFO) {
  pFIFO->head = 0;
  pFIFO->tail = 0;
  pFIFO->full = 0;
}

unsigned int FIFO_Read(FIFO* pFIFO, void* dest, unsigned int size) {
  unsigned int left = FIFO_BytesStored(pFIFO);
  unsigned int read;
  if( size > left )
    size = left;
  if( size > 0 )
    pFIFO->full = 0;
  read = size;
  if( read > pFIFO->size - pFIFO->head )
    read = pFIFO->size - pFIFO->head;
  memcpy(dest, pFIFO->data + pFIFO->head, read);
  pFIFO->head += read;
  dest = (unsigned char*)dest + read;
  size -= read;
  if( pFIFO->head == pFIFO->size )
    pFIFO->head = 0;
  if( size ) {
    memcpy(dest, pFIFO->data + pFIFO->head, size);
    pFIFO->head += size;
//    if( pFIFO->head == pFIFO->size )
//      pFIFO->head = 0;
  }
  return size + read;
}

unsigned int FIFO_Unread(FIFO* pFIFO, unsigned int size) {
  unsigned int free = FIFO_BytesFree(pFIFO);
  if( free < size )
    return 0;
  if( pFIFO->head < size )
    pFIFO->head -= size - pFIFO->size;
  else
    pFIFO->head -= size;
  if( free + size == pFIFO->size )
    pFIFO->full = 1;
  return size;
}

unsigned int FIFO_Write(FIFO* pFIFO, const void* source, unsigned int size) {
  unsigned int space = FIFO_BytesFree(pFIFO);
  unsigned int write;
  if( size > space )
    size = space;
  if( size == space )
    pFIFO->full = 1;
  write = size;
  if( write > pFIFO->size - pFIFO->tail )
    write = pFIFO->size - pFIFO->tail;
  memcpy(pFIFO->data + pFIFO->tail, source, write);
  pFIFO->tail += write;
  source = (const unsigned char*)source + write;
  size -= write;
  if( pFIFO->tail == pFIFO->size )
    pFIFO->tail = 0;
  if( size ) {
    memcpy(pFIFO->data + pFIFO->tail, source, size);
    pFIFO->tail += size;
//    if( pFIFO->tail == pFIFO->size )
//      pFIFO->tail = 0;
  }
  return size + write;
}

unsigned int FIFO_BytesStored(FIFO* pFIFO) {
  if( pFIFO->full )
    return pFIFO->size;
  else if( pFIFO->head <= pFIFO->tail )
    return pFIFO->tail - pFIFO->head;
  else
    return pFIFO->size - pFIFO->head + pFIFO->tail;
}

unsigned int FIFO_BytesFree(FIFO* pFIFO) {
  return pFIFO->size - FIFO_BytesStored(pFIFO);
}
