#ifndef UTIL_H //UTIL_H
#define UTIL_H //UTIL_H

#include <stdio.h>
#include <string.h>
#include "pico/stdlib.h"
#include "pico/bootrom.h"
#include "pico/cyw43_arch.h"
#include "hardware/rtc.h"
#include "hardware/watchdog.h"
#include "pico/util/datetime.h"
#include <time.h>
#include "lwip/apps/http_client.h"
#include "lwip/apps/sntp.h"
#include <hardware/flash.h>
#include <hardware/sync.h>
#include "pico/multicore.h"

#define SCAN_LEN (50)
#define BACKSPACE (8)
#define SCAN_COUNT (10)
#define SAVE_COUNT (8)
#define SSIDLEN (40)
#define SENTENCE_LEN (100)
#define PPS_PIN 1

//over 3 hours, default update is 1 hour, so we can miss two without issue
#define NTP_REFRESH (200)
#define IPAPI_REFRESH (60)
#define FAIL_LIMIT (11)
#define CORE1_FAIL_LIMIT (180)
//experimentally determined
#define WATCHDOG_REBOOT_OFFSET (50000)

//this is 1/1/2022 (timestamp in us)
#define INIT_TIMESTAMP (1640995200000000ULL)

//HTTP for IPAPI
#define HTTP_BUF_SIZE 1024
err_t headers_done_fn(httpc_state_t *connection, void *arg, struct pbuf *hdr, u16_t hdr_len, u32_t content_len);
err_t recv_fn(void *arg, struct tcp_pcb *tpcb, struct pbuf *p, err_t err);
void result_fn(void *arg, httpc_result_t httpc_result, u32_t rx_content_len, u32_t srv_res, err_t err);

//add anything that needs to be saved to this struct
struct flashdata{
	char saveSSID[SAVE_COUNT][SSIDLEN];
	char savePASS[SAVE_COUNT][SSIDLEN];
	char wifiCC[3];			//country code
	char ipAPI[SCAN_LEN];
	float lat;
	float lon;
	long baudrate;
	char talker[3];			//2 character talker code (eg GP)
	char NTPurl[SCAN_LEN];	
	unsigned long long NTPtimeout;
	int debugOn;
	int defYear;
};
	
union flashpadded{
    struct flashdata d;
    char padding[FLASH_SECTOR_SIZE];  //pad to this size so that erases do not affect other objects
};

union ipAddress{
	char oct[4];
	unsigned int ip;
};

extern union flashpadded cur;	//working version in RAM
extern const union flashpadded flashimage;	//in flash
#define FLASHIMAGESECTOR ((256 * 1024)+XIP_BASE)

extern int NTPok;
extern datetime_t dt;	    //for general usage
extern int wifiConnected;	//global for status LED display
extern int ledState;			//0-3, higher is better
extern const char hex[];            //for writing out checksum
extern uint64_t savedTime;
extern uint64_t NTPoffset;

typedef struct dms{
  int d;
  int m;
  int s;
  char lat;
  char lon;
} dms;

char* scanSerial(void);		//returns an array* when line entered
void set_system_time(uint32_t sec,uint32_t frac);		//called by NTP when it wants to update RTC
datetime_t getDateTime(uint32_t sec);	//from timestamp
void checkMenu(void);
void initAll(void);
void printMenu(void);
void doNetScan(void);
void sortScanned(void);			//in order of RSSI
void showScan(void);
void showSaved(void);
static int scan_result(void *env, const cyw43_ev_scan_result_t *result);
void saveTest(void);			//check connectivity to saved
void checkWIFI(void);			//check and maintain WiFi connections
void printStat(int wStat);		//switch case for status
void initialConnect(void);		//run once on boot to quickly connect if available
void validateCC(void);			//check and validate country code, sets to XX if invalid
void getIPAPI(void);			//initiate IPAPI request
void setLatLon(void);			//from httpbuf
dms getDMS(float c);			//convert float degrees to DMS
float getDegrees(dms c);		//convert DMS to float
void addChecksum(char *s);		//assumes that there is room to add the two characters
uint32_t stampNow(void);		//get current timestamp
void saveAndReset(void);		//store an offset in persistent RAM and reboot

#endif  //UTIL_H